import QtQuick
import QtQuick.Timeline
import QtQuick.Studio.DesignEffects
import DesignEffectsDemo

Item {
    id: root
    width: 170
    height: 71
    property alias labelText: label.text
    property color readoutLabelColor: "White"
    property color highlightColor1: "Blue"
    property int progress: 100
    property real blurFactor: 1
    property bool effectsOn: true

    Rectangle {
        id: bar1ON
        x: 10
        y: 23
        width: 10
        height: 10
        visible: true
        color: root.highlightColor1
        radius: 5
        DesignEffect {
            id: designEffectBarFront
            layerBlurRadius: 3 * root.blurFactor
            visible: root.effectsOn

            effects: [
                DesignDropShadow {
                    id: designDropShadowBarFront
                    blur: 8 * root.blurFactor
                    offsetX: 0
                    offsetY: 0
                    color: root.highlightColor1
                }
            ]
        }
    }

    Rectangle {
        id: bar2ON
        x: 26
        y: 20
        width: 10
        height: 15
        visible: true
        color: root.highlightColor1
        radius: 5
        DesignEffect {
            id: designEffectBarFront1
            layerBlurRadius: 2 * root.blurFactor
            visible: root.effectsOn

            effects: [
                DesignDropShadow {
                    id: designDropShadowBarFront1
                    blur: 8 * root.blurFactor
                    offsetX: 0
                    offsetY: 0
                    color: root.highlightColor1
                }
            ]
        }
    }

    Rectangle {
        id: bar3ON
        x: 42
        y: 16
        width: 10
        height: 20
        visible: true
        color: root.highlightColor1
        radius: 5
        DesignEffect {
            id: designEffectBarFront2
            layerBlurRadius: 2 * root.blurFactor
            visible: root.effectsOn

            effects: [
                DesignDropShadow {
                    id: designDropShadowBarFront2
                    blur: 8 * root.blurFactor
                    offsetX: 0
                    offsetY: 0
                    color: root.highlightColor1
                }
            ]
        }
    }

    Rectangle {
        id: bar4ON
        x: 58
        y: 14
        width: 10
        height: 25
        visible: true
        color: root.highlightColor1
        radius: 5
        DesignEffect {
            id: designEffectBarFront3
            layerBlurRadius: 3 * root.blurFactor
            visible: root.effectsOn

            effects: [
                DesignDropShadow {
                    id: designDropShadowBarFront3
                    blur: 8 * root.blurFactor
                    offsetX: 0
                    offsetY: 0
                    color: root.highlightColor1
                }
            ]
        }
    }

    Rectangle {
        id: bar5ON
        x: 74
        y: 9
        width: 10
        height: 35
        visible: true
        color: root.highlightColor1
        radius: 5
        DesignEffect {
            id: designEffectBarFront5
            layerBlurRadius: 2 * root.blurFactor
            visible: root.effectsOn

            effects: [
                DesignDropShadow {
                    id: designDropShadowBarFront5
                    blur: 8 * root.blurFactor
                    offsetX: 0
                    offsetY: 0
                    color: root.highlightColor1
                }
            ]
        }
    }

    Text {
        id: outputValue
        x: 99
        width: 71
        height: 33
        color: root.highlightColor1
        text: root.progress
        anchors.right: parent.right
        anchors.top: parent.top
        anchors.rightMargin: 0
        anchors.topMargin: 9
        font.pixelSize: 24
        font.family: "Victor Mono"
        DesignEffect {
            id: designEffectBarFront6
            layerBlurRadius: 2 * root.blurFactor
            visible: root.effectsOn

            effects: [
                DesignDropShadow {
                    id: designDropShadowBarFront6
                    blur: 3 * root.blurFactor
                    offsetX: 0
                    offsetY: 0
                    color: root.highlightColor1
                }
            ]
        }
    }

    Text {
        id: label
        width: 70
        color: root.readoutLabelColor
        text: qsTr("LABEL")
        anchors.left: parent.left
        anchors.top: parent.top
        anchors.bottom: parent.bottom
        anchors.leftMargin: 100
        anchors.topMargin: 40
        anchors.bottomMargin: 10
        font.pixelSize: 18
        horizontalAlignment: Text.AlignLeft
        font.styleName: "SemiBold"
        font.family: "Victor Mono"
        DesignEffect {
            id: designEffectBarFront7
            layerBlurRadius: 3 * root.blurFactor
            visible: root.effectsOn

            effects: [
                DesignDropShadow {
                    id: designDropShadowBarFront7
                    blur: 3 * root.blurFactor
                    offsetX: 0
                    offsetY: 0
                    color: root.readoutLabelColor
                }
            ]
        }
    }

    Timeline {
        id: timeline
        currentFrame: root.progress
        startFrame: 0
        endFrame: 100
        enabled: true

        KeyframeGroup {
            target: bar1ON
            property: "visible"
            Keyframe {
                value: false
                frame: 0
            }

            Keyframe {
                value: false
                frame: 16
            }

            Keyframe {
                value: true
                frame: 17
            }
        }

        KeyframeGroup {
            target: bar2ON
            property: "visible"
            Keyframe {
                value: false
                frame: 0
            }

            Keyframe {
                value: false
                frame: 32
            }

            Keyframe {
                value: true
                frame: 33
            }
        }

        KeyframeGroup {
            target: bar3ON
            property: "visible"
            Keyframe {
                value: false
                frame: 0
            }

            Keyframe {
                value: false
                frame: 52
            }

            Keyframe {
                value: true
                frame: 53
            }
        }

        KeyframeGroup {
            target: bar4ON
            property: "visible"
            Keyframe {
                value: false
                frame: 0
            }

            Keyframe {
                value: true
                frame: 74
            }

            Keyframe {
                value: false
                frame: 73
            }
        }

        KeyframeGroup {
            target: bar5ON
            property: "visible"
            Keyframe {
                value: false
                frame: 0
            }

            Keyframe {
                value: false
                frame: 99
            }

            Keyframe {
                value: true
                frame: 100
            }
        }
    }
}
