import QtQuick
import QtQuick.Controls
import QtQuick.Layouts 1.15

Rectangle {
    id: menuPanel
    width: 391
    height: 725
    color: "transparent"

    Rectangle {
        id: background
        color: "#45d9d9d9"
        radius: 30
        border.color: "#ededed"
        border.width: 1
        anchors.left: parent.left
        anchors.right: parent.right
        anchors.top: parent.top
        anchors.bottom: parent.bottom
    }

    Rectangle {
        id: menuColumn
        width: 350
        height: 613
        color: "transparent"
        anchors.verticalCenter: parent.verticalCenter
        ColumnLayout {
            id: menuColumn_layout
            anchors.left: parent.left
            anchors.right: parent.right
            anchors.top: parent.top
            anchors.bottom: parent.bottom
            spacing: 19
            MenuButton {
                id: menuItem1
                x: 0
                y: 0
                width: 350
                height: 60
                state: "state_selected"
                menuText: "Draggable Panel"
                Layout.preferredWidth: 350
                Layout.preferredHeight: 60
                Layout.alignment: Qt.AlignLeft | Qt.AlignTop
            }

            MenuButton {
                id: menuItem2
                x: 0
                y: 79
                width: 350
                height: 60
                state: "state_hover"
                Layout.preferredWidth: 350
                Layout.preferredHeight: 60
                Layout.alignment: Qt.AlignLeft | Qt.AlignTop
            }

            MenuButton {
                id: menuItem3
                x: 0
                y: 158
                width: 350
                height: 60
                state: "state_idle"
                Layout.preferredWidth: 350
                Layout.preferredHeight: 60
                Layout.alignment: Qt.AlignLeft | Qt.AlignTop
            }

            MenuButton {
                id: menuItem4
                x: 0
                y: 237
                width: 350
                height: 60
                state: "state_idle"
                Layout.preferredWidth: 350
                Layout.preferredHeight: 60
                Layout.alignment: Qt.AlignLeft | Qt.AlignTop
            }

            MenuButton {
                id: menuItem5
                x: 0
                y: 316
                width: 350
                height: 60
                state: "state_idle"
                Layout.preferredWidth: 350
                Layout.preferredHeight: 60
                Layout.alignment: Qt.AlignLeft | Qt.AlignTop
            }

            MenuButton {
                id: menuItem6
                x: 0
                y: 395
                width: 350
                height: 60
                state: "state_idle"
                Layout.preferredWidth: 350
                Layout.preferredHeight: 60
                Layout.alignment: Qt.AlignLeft | Qt.AlignTop
            }

            MenuButton {
                id: menuItem7
                x: 0
                y: 474
                width: 350
                height: 60
                state: "state_idle"
                Layout.preferredWidth: 350
                Layout.preferredHeight: 60
                Layout.alignment: Qt.AlignLeft | Qt.AlignTop
            }

            MenuButton {
                id: menuItem8
                x: 0
                y: 553
                width: 350
                height: 60
                state: "state_idle"
                Layout.preferredWidth: 350
                Layout.preferredHeight: 60
                Layout.alignment: Qt.AlignLeft | Qt.AlignTop
            }
        }
        anchors.verticalCenterOffset: 5
        anchors.horizontalCenterOffset: 3
        anchors.horizontalCenter: parent.horizontalCenter
    }
}

/*##^##
Designer {
    D{i:0;uuid:"811de6be-3a57-524a-9ad0-c36c407e18fe"}D{i:1;uuid:"69f439ce-d040-536f-bd2c-bea03927d6dc"}
D{i:2;uuid:"95cfb5fe-c880-5949-a792-aecd264f9321"}D{i:3;uuid:"95cfb5fe-c880-5949-a792-aecd264f9321_VERTICAL"}
D{i:4;uuid:"46cbc7c5-fb3f-5bec-8424-2b7db4f96236"}D{i:5;uuid:"ebbfcc3f-a344-51a2-9e1b-b424c7e374ef"}
D{i:6;uuid:"91176f11-7d9a-59a7-923b-ad8078a7cc6d"}D{i:7;uuid:"c6459e68-4109-5afc-af9c-5167281e67b6"}
D{i:8;uuid:"f3cefbbc-5ee1-5bc0-bd93-b468d58612de"}D{i:9;uuid:"86c87bfe-adc0-5ec4-913b-907e98216aa5"}
D{i:10;uuid:"624bd617-c7c1-5de3-bbdb-1434af11114a"}D{i:11;uuid:"592e9f14-5e19-5013-b45f-e82726617719"}
}
##^##*/

