// Copyright (C) 2024 The Qt Company Ltd.
// Copyright © 2004-2023 Unicode, Inc.
// SPDX-License-Identifier: Unicode-3.0

#ifndef QTIMEZONELOCALE_DATA_P_H
#define QTIMEZONELOCALE_DATA_P_H

//
//  W A R N I N G
//  -------------
//
// This file is not a normal header file.
// It defines data tables for internal use by QTimeZone's L10n code.
// It may change incompatibly between versions, or even be removed.
//
// We mean it.
//

// Only qtimezonelocale.cpp should #include this (after other things it needs),
// and even that only when feature icu is disabled.

QT_REQUIRE_CONFIG(timezone_locale);
#if QT_CONFIG(icu)
#  error "This file should only be needed (or seen) when ICU is not in use"
#endif

QT_BEGIN_NAMESPACE

#ifdef QT_CLDR_ZONE_DEBUG
#  define LOCALE_TAGS(lang, script, land) lang, script, land,
#else
#  define LOCALE_TAGS(lang, script, land)
#endif

namespace QtTimeZoneLocale {

/*
    Locale-specific data for timezone naming.
    https://www.unicode.org/reports/tr35/tr35-68/tr35-dates.html#Time_Zone_Names

    Available data, per locale, from LocaleScanner.timeZoneNames():

        formats: {
            'hour': ('+HH:mm', '-HH:mm'),
            'GMT': 'GMT%0',
            'region': ("%0 Time", std, dst),
            'fallback': "%1 (%0)" }
        zones: { ianaid: {
                'exemplarCity': name,
                'long': (gen, std, dst), 'short': (gen, std, dst) } }
        metazones: { meta: {'long': (gen, std, dst), 'short': (gen, std, dst) } }

    Mapped to C++ data-structures below (defined in QTZL_p.h) and used by
    QTZL.cpp, in conjunction with QTZP_data_p.h's locale-independent data
    conditioned on timezone_locale.
*/

// GENERATED PART STARTS HERE

/*
    This part of the file was generated on 2025-02-07 from the
    Common Locale Data Repository v46.1

    http://www.unicode.org/cldr/

    Do not edit this section: instead regenerate it using
    cldr2qlocalexml.py and qlocalexml2cpp.py on updated (or
    edited) CLDR data; see qtbase/util/locale_database/.
*/

// Sorted by locale index, then iana name
static inline constexpr LocaleZoneExemplar localeZoneExemplarTable[] = {
    // locInd, ianaInd, xcty{ind, sz}
    {    0,   14,       0,  6, }, // Africa/Asmara C/AnyScript/AnyTerritory
    {    0, 4435,       6,  8, }, // Africa/Sao_Tome
    {    0, 4252,      14,  8, }, // America/Asuncion
    {    0,  237,      22,  8, }, // America/Atikokan
    {    0, 7623,      30, 17, }, // America/Bahia_Banderas
    {    0, 3868,      47,  6, }, // America/Cancun
    {    0, 7774,      53, 13, }, // America/Ciudad_Juarez
    {    0, 5723,      66,  7, }, // America/Curacao
    {    0,  481,      73, 13, }, // America/Indiana/Knox
    {    0, 7961,      86, 16, }, // America/Indiana/Marengo
    {    0, 7985,     102, 19, }, // America/Indiana/Petersburg
    {    0, 8012,     121, 18, }, // America/Indiana/Tell_City
    {    0, 8038,     139, 14, }, // America/Indiana/Vevay
    {    0, 8060,     153, 18, }, // America/Indiana/Vincennes
    {    0, 8086,     171, 16, }, // America/Indiana/Winamac
    {    0, 8125,     187, 20, }, // America/Kentucky/Monticello
    {    0, 5932,     207, 22, }, // America/Lower_Princes
    {    0, 8220,     229,  6, }, // America/Merida
    {    0, 8301,     235, 20, }, // America/North_Dakota/Beulah
    {    0, 8329,     255, 20, }, // America/North_Dakota/Center
    {    0, 8357,     275, 23, }, // America/North_Dakota/New_Salem
    {    0,  393,     298,  4, }, // America/Nuuk
    {    0, 6899,     302, 16, }, // America/Scoresbysund
    {    0, 8508,     318, 14, }, // America/St_Barthelemy
    {    0, 2061,     332, 10, }, // America/St_Johns
    {    0, 5863,     342,  9, }, // America/St_Kitts
    {    0, 5880,     351,  9, }, // America/St_Lucia
    {    0,  855,     360, 10, }, // America/St_Thomas
    {    0, 5913,     370, 11, }, // America/St_Vincent
    {    0, 6133,     381, 16, }, // Antarctica/DumontDUrville
    {    0, 1259,     397, 16, }, // Asia/Ho_Chi_Minh
    {    0, 1185,     413,  9, }, // Asia/Kathmandu
    {    0,  992,     422,  7, }, // Asia/Kolkata
    {    0, 1211,     429,  5, }, // Asia/Macau
    {    0, 8708,     434,  8, }, // Asia/Qostanay
    {    0, 1235,     442,  6, }, // Asia/Yangon
    {    0, 1395,     448,  5, }, // Atlantic/Faroe
    {    0, 6821,     453, 10, }, // Atlantic/St_Helena
    {    0, 2527,     463,  4, }, // Europe/Kyiv
    {    0, 7211,     467,  7, }, // Indian/Reunion
    {    0, 3157,     474,  5, }, // Pacific/Chuuk
    {    0, 3096,     479,  7, }, // Pacific/Pohnpei
    {    1, 6788,     486,  6, }, // Africa/Abidjan Abkhazian/Cyrillic/Georgia
    {    1, 6760,     492,  5, }, // Africa/Accra
    {    1, 5059,     497, 11, }, // Africa/Addis_Ababa
    {    1, 7420,     508,  5, }, // Africa/Algiers
    {    1,   14,     513,  6, }, // Africa/Asmara
    {    1,   44,     519,  6, }, // Africa/Bamako
    {    1, 5257,     525,  5, }, // Africa/Bangui
    {    1, 6746,     530,  6, }, // Africa/Banjul
    {    1, 7435,     536,  5, }, // Africa/Bissau
    {    1, 4957,     541,  8, }, // Africa/Blantyre
    {    1, 5287,     549,  9, }, // Africa/Brazzaville
    {    1, 4922,     558,  9, }, // Africa/Bujumbura
    {    1, 2320,     567,  4, }, // Africa/Cairo
    {    1, 4117,     571, 10, }, // Africa/Casablanca
    {    1, 7449,     581,  5, }, // Africa/Ceuta
    {    1, 6773,     586,  7, }, // Africa/Conakry
    {    1, 6840,     593,  5, }, // Africa/Dakar
    {    1, 5130,     598, 12, }, // Africa/Dar_es_Salaam
    {    1, 5043,     610,  6, }, // Africa/Djibouti
    {    1, 5243,     616,  5, }, // Africa/Douala
    {    1, 5166,     621,  7, }, // Africa/El_Aaiun
    {    1, 6853,     628,  7, }, // Africa/Freetown
    {    1, 4906,     635,  8, }, // Africa/Gaborone
    {    1, 5015,     643,  6, }, // Africa/Harare
    {    1, 4479,     649, 12, }, // Africa/Johannesburg
    {    1, 4499,     661,  4, }, // Africa/Juba
    {    1, 5151,     665,  7, }, // Africa/Kampala
    {    1, 4524,     672,  6, }, // Africa/Khartoum
    {    1, 4973,     678,  6, }, // Africa/Kigali
    {    1, 5306,     684,  7, }, // Africa/Kinshasa
    {    1, 4744,     691,  5, }, // Africa/Lagos
    {    1, 5336,     696,  8, }, // Africa/Libreville
    {    1, 6869,     704,  4, }, // Africa/Lome
    {    1, 5211,     708,  6, }, // Africa/Luanda
    {    1, 4939,     714,  9, }, // Africa/Lubumbashi
    {    1, 5001,     723,  6, }, // Africa/Lusaka
    {    1, 5322,     729,  6, }, // Africa/Malabo
    {    1, 4987,     735,  6, }, // Africa/Maputo
    {    1, 5197,     741,  6, }, // Africa/Maseru
    {    1, 5182,     747,  7, }, // Africa/Mbabane
    {    1, 5113,     754,  8, }, // Africa/Mogadishu
    {    1, 7034,     762,  8, }, // Africa/Monrovia
    {    1, 3853,     770,  7, }, // Africa/Nairobi
    {    1, 5271,     777,  7, }, // Africa/Ndjamena
    {    1, 5354,     784,  6, }, // Africa/Niamey
    {    1, 6803,     790,  7, }, // Africa/Nouakchott
    {    1, 6727,     797,  8, }, // Africa/Ouagadougou
    {    1, 5225,     805, 10, }, // Africa/Porto-Novo
    {    1, 4435,     815,  8, }, // Africa/Sao_Tome
    {    1, 2866,     823,  7, }, // Africa/Tripoli
    {    1, 6554,     830,  5, }, // Africa/Tunis
    {    1, 4152,     835,  7, }, // Africa/Windhoek
    {    1,  132,     842,  4, }, // America/Adak
    {    1, 3346,     846,  7, }, // America/Anchorage
    {    1, 5607,     853,  7, }, // America/Anguilla
    {    1, 5624,     860,  7, }, // America/Antigua
    {    1, 4554,     867,  9, }, // America/Araguaina
    {    1,  166,     876, 12, }, // America/Argentina/Buenos_Aires
    {    1,   91,     888,  9, }, // America/Argentina/Catamarca
    {    1,  270,     897,  7, }, // America/Argentina/Cordoba
    {    1,  441,     904,  5, }, // America/Argentina/Jujuy
    {    1, 7462,     909,  8, }, // America/Argentina/La_Rioja
    {    1,  565,     917,  7, }, // America/Argentina/Mendoza
    {    1, 7489,     924, 11, }, // America/Argentina/Rio_Gallegos
    {    1, 7520,     935,  5, }, // America/Argentina/Salta
    {    1, 7544,     940,  8, }, // America/Argentina/San_Juan
    {    1, 5580,     948,  8, }, // America/Argentina/San_Luis
    {    1, 7571,     956,  7, }, // America/Argentina/Tucuman
    {    1, 7597,     963,  6, }, // America/Argentina/Ushuaia
    {    1, 5640,     969,  5, }, // America/Aruba
    {    1, 4252,     974,  7, }, // America/Asuncion
    {    1,  237,     981, 12, }, // America/Atikokan
    {    1, 3679,     993,  4, }, // America/Bahia
    {    1, 7623,     997, 16, }, // America/Bahia_Banderas
    {    1, 5654,    1013,  8, }, // America/Barbados
    {    1, 7646,    1021,  5, }, // America/Belem
    {    1, 5407,    1026,  5, }, // America/Belize
    {    1, 7660,    1031, 12, }, // America/Blanc-Sablon
    {    1, 7681,    1043,  9, }, // America/Boa_Vista
    {    1, 4361,    1052,  6, }, // America/Bogota
    {    1, 7699,    1058,  5, }, // America/Boise
    {    1, 7713,    1063, 12, }, // America/Cambridge_Bay
    {    1, 7735,    1075, 12, }, // America/Campo_Grande
    {    1, 3868,    1087,  6, }, // America/Cancun
    {    1, 4694,    1093,  7, }, // America/Caracas
    {    1, 4345,    1100,  7, }, // America/Cayenne
    {    1, 5496,    1107, 22, }, // America/Cayman
    {    1, 2260,    1129,  6, }, // America/Chicago
    {    1, 7756,    1135,  6, }, // America/Chihuahua
    {    1, 7774,      53, 13, }, // America/Ciudad_Juarez
    {    1, 5422,    1141, 10, }, // America/Costa_Rica
    {    1, 7796,    1151,  7, }, // America/Creston
    {    1, 3791,    1158,  6, }, // America/Cuiaba
    {    1, 5723,    1164,  8, }, // America/Curacao
    {    1, 7812,    1172, 12, }, // America/Danmarkshavn
    {    1, 7833,    1184,  6, }, // America/Dawson
    {    1, 7848,    1190, 11, }, // America/Dawson_Creek
    {    1,  805,    1201,  6, }, // America/Denver
    {    1, 3465,    1207,  7, }, // America/Detroit
    {    1, 5739,    1214,  8, }, // America/Dominica
    {    1,  893,    1222,  8, }, // America/Edmonton
    {    1, 7869,    1230,  8, }, // America/Eirunepe
    {    1, 5441,    1238,  8, }, // America/El_Salvador
    {    1, 7886,    1246, 11, }, // America/Fort_Nelson
    {    1, 7906,    1257,  9, }, // America/Fortaleza
    {    1, 7924,    1266,  9, }, // America/Glace_Bay
    {    1, 6881,    1275,  7, }, // America/Goose_Bay
    {    1, 4612,    1282, 10, }, // America/Grand_Turk
    {    1, 5770,    1292,  7, }, // America/Grenada
    {    1, 5786,    1299,  9, }, // America/Guadeloupe
    {    1, 3760,    1308,  9, }, // America/Guatemala
    {    1, 4841,    1317,  8, }, // America/Guayaquil
    {    1, 6932,    1325,  6, }, // America/Guyana
    {    1, 1939,    1331,  8, }, // America/Halifax
    {    1, 2281,    1339,  6, }, // America/Havana
    {    1, 7942,    1345,  8, }, // America/Hermosillo
    {    1,  348,    1353, 12, }, // America/Indiana/Indianapolis
    {    1,  481,    1365, 13, }, // America/Indiana/Knox
    {    1, 7961,    1378, 16, }, // America/Indiana/Marengo
    {    1, 7985,    1394, 19, }, // America/Indiana/Petersburg
    {    1, 8012,    1413,  9, }, // America/Indiana/Tell_City
    {    1, 8038,    1422, 14, }, // America/Indiana/Vevay
    {    1, 8060,    1436,  9, }, // America/Indiana/Vincennes
    {    1, 8086,    1445,  7, }, // America/Indiana/Winamac
    {    1, 8110,    1452,  6, }, // America/Inuvik
    {    1,  660,    1458,  7, }, // America/Iqaluit
    {    1, 2799,    1465,  7, }, // America/Jamaica
    {    1, 5380,    1472,  4, }, // America/Juneau
    {    1,  521,    1476,  8, }, // America/Kentucky/Louisville
    {    1, 8125,    1484, 20, }, // America/Kentucky/Monticello
    {    1, 5704,    1504, 10, }, // America/Kralendijk
    {    1, 4376,    1514,  6, }, // America/La_Paz
    {    1, 7169,    1520,  4, }, // America/Lima
    {    1, 3239,    1524, 11, }, // America/Los_Angeles
    {    1, 5932,    1535, 18, }, // America/Lower_Princes
    {    1, 8153,    1553,  6, }, // America/Maceio
    {    1, 8168,    1559,  7, }, // America/Managua
    {    1, 1908,    1566,  6, }, // America/Manaus
    {    1, 5897,    1572,  6, }, // America/Marigot
    {    1, 5805,    1578,  9, }, // America/Martinique
    {    1, 8184,    1587,  9, }, // America/Matamoros
    {    1, 2917,    1596,  8, }, // America/Mazatlan
    {    1, 8202,    1604,  8, }, // America/Menominee
    {    1, 8220,    1612,  6, }, // America/Merida
    {    1, 8235,    1618, 10, }, // America/Metlakatla
    {    1, 2949,    1628,  6, }, // America/Mexico_City
    {    1, 4391,    1634,  7, }, // America/Miquelon
    {    1, 8254,    1641,  7, }, // America/Moncton
    {    1, 8270,    1648,  9, }, // America/Monterrey
    {    1, 4098,    1657, 10, }, // America/Montevideo
    {    1, 5824,    1667, 10, }, // America/Montserrat
    {    1, 5481,    1677,  6, }, // America/Nassau
    {    1, 2379,    1683,  8, }, // America/New_York
    {    1, 8288,    1691,  3, }, // America/Nome
    {    1, 1850,    1694,  7, }, // America/Noronha
    {    1, 8301,    1701, 22, }, // America/North_Dakota/Beulah
    {    1, 8329,    1723, 22, }, // America/North_Dakota/Center
    {    1, 8357,    1745, 27, }, // America/North_Dakota/New_Salem
    {    1,  393,    1772,  4, }, // America/Nuuk
    {    1, 8388,    1776,  7, }, // America/Ojinaga
    {    1, 2356,    1783,  6, }, // America/Panama
    {    1, 6173,    1789, 10, }, // America/Paramaribo
    {    1, 2973,    1799,  6, }, // America/Phoenix
    {    1, 3945,    1805, 12, }, // America/Port-au-Prince
    {    1, 5954,    1817, 13, }, // America/Port_of_Spain
    {    1, 8404,    1830, 11, }, // America/Porto_Velho
    {    1, 5843,    1841, 11, }, // America/Puerto_Rico
    {    1, 4030,    1852, 12, }, // America/Punta_Arenas
    {    1, 8424,    1864, 12, }, // America/Rankin_Inlet
    {    1, 8445,    1876,  6, }, // America/Recife
    {    1, 1995,    1882,  7, }, // America/Regina
    {    1, 8460,    1889,  8, }, // America/Resolute
    {    1,  695,    1897, 10, }, // America/Rio_Branco
    {    1, 8477,    1907,  8, }, // America/Santarem
    {    1, 2201,    1915,  8, }, // America/Santiago
    {    1, 6111,    1923, 13, }, // America/Santo_Domingo
    {    1, 1878,    1936,  9, }, // America/Sao_Paulo
    {    1, 6899,    1945, 11, }, // America/Scoresbysund
    {    1, 8494,    1956,  5, }, // America/Sitka
    {    1, 8508,    1961, 13, }, // America/St_Barthelemy
    {    1, 2061,    1974,  9, }, // America/St_Johns
    {    1, 5863,    1983,  9, }, // America/St_Kitts
    {    1, 5880,    1992, 11, }, // America/St_Lucia
    {    1,  855,    2003, 10, }, // America/St_Thomas
    {    1, 5913,    2013, 12, }, // America/St_Vincent
    {    1, 8530,    2025, 13, }, // America/Swift_Current
    {    1, 5461,    2038, 11, }, // America/Tegucigalpa
    {    1, 5756,    2049,  4, }, // America/Thule
    {    1,  313,    2053,  7, }, // America/Tijuana
    {    1,  608,    2060,  7, }, // America/Toronto
    {    1, 5688,    2067,  7, }, // America/Tortola
    {    1, 2093,    2074,  8, }, // America/Vancouver
    {    1, 2144,    2082,  8, }, // America/Whitehorse
    {    1,  734,    2090,  8, }, // America/Winnipeg
    {    1, 8552,    2098,  7, }, // America/Yakutat
    {    1, 6001,    2105,  5, }, // Antarctica/Casey
    {    1, 6094,    2110,  6, }, // Antarctica/Davis
    {    1, 6133,    2116, 15, }, // Antarctica/DumontDUrville
    {    1, 8568,    2131,  8, }, // Antarctica/Macquarie
    {    1, 7066,    2139,  6, }, // Antarctica/Mawson
    {    1, 7113,    2145,  9, }, // Antarctica/McMurdo
    {    1, 8589,    2154,  6, }, // Antarctica/Palmer
    {    1, 7226,    2160,  6, }, // Antarctica/Rothera
    {    1, 7295,    2166,  5, }, // Antarctica/Syowa
    {    1, 8607,    2171,  5, }, // Antarctica/Troll
    {    1, 7374,    2176, 10, }, // Antarctica/Vostok
    {    1, 1429,    2186,  6, }, // Arctic/Longyearbyen
    {    1, 5570,    2192,  4, }, // Asia/Aden
    {    1, 5395,    2196,  6, }, // Asia/Almaty
    {    1, 3968,    2202,  5, }, // Asia/Amman
    {    1, 5511,    2207,  6, }, // Asia/Anadyr
    {    1, 5523,    2213,  5, }, // Asia/Aqtau
    {    1, 5368,    2218,  6, }, // Asia/Aqtobe
    {    1,  964,    2224,  7, }, // Asia/Ashgabat
    {    1, 8624,    2231,  6, }, // Asia/Atyrau
    {    1, 3607,    2237,  6, }, // Asia/Baghdad
    {    1, 5534,    2243,  7, }, // Asia/Bahrain
    {    1, 3653,    2250,  4, }, // Asia/Baku
    {    1, 4466,    2254,  7, }, // Asia/Bangkok
    {    1, 3571,    2261,  7, }, // Asia/Barnaul
    {    1, 4086,    2268,  6, }, // Asia/Beirut
    {    1, 3778,    2274,  6, }, // Asia/Bishkek
    {    1, 5989,    2280,  6, }, // Asia/Brunei
    {    1, 4601,    2286,  4, }, // Asia/Chita
    {    1, 4511,    2290,  7, }, // Asia/Colombo
    {    1, 4540,    2297,  6, }, // Asia/Damascus
    {    1, 1093,    2303,  5, }, // Asia/Dhaka
    {    1, 6192,    2308,  4, }, // Asia/Dili
    {    1, 3596,    2312,  5, }, // Asia/Dubai
    {    1, 6159,    2317,  7, }, // Asia/Dushanbe
    {    1, 8636,    2324,  9, }, // Asia/Famagusta
    {    1, 8651,    2333,  4, }, // Asia/Gaza
    {    1, 4795,    2337,  6, }, // Asia/Hebron
    {    1, 1259,    2343,  7, }, // Asia/Ho_Chi_Minh
    {    1, 2704,    2350,  7, }, // Asia/Hong_Kong
    {    1, 4771,    2357,  4, }, // Asia/Hovd
    {    1, 4184,    2361,  7, }, // Asia/Irkutsk
    {    1, 7006,    2368,  7, }, // Asia/Jakarta
    {    1, 6992,    2375,  8, }, // Asia/Jayapura
    {    1, 1290,    2383,  9, }, // Asia/Jerusalem
    {    1, 3560,    2392,  5, }, // Asia/Kabul
    {    1, 4316,    2397, 25, }, // Asia/Kamchatka
    {    1, 4239,    2422,  6, }, // Asia/Karachi
    {    1, 1185,    2428,  8, }, // Asia/Kathmandu
    {    1, 8661,    2436,  7, }, // Asia/Khandyga
    {    1,  992,    2443,  8, }, // Asia/Kolkata
    {    1, 4197,    2451, 11, }, // Asia/Krasnoyarsk
    {    1, 4859,    2462, 12, }, // Asia/Kuala_Lumpur
    {    1, 5976,    2474,  6, }, // Asia/Kuching
    {    1, 5547,    2480,  6, }, // Asia/Kuwait
    {    1, 1211,    2486,  5, }, // Asia/Macau
    {    1, 4017,    2491,  7, }, // Asia/Magadan
    {    1, 1349,    2498,  7, }, // Asia/Makassar
    {    1, 7182,    2505,  6, }, // Asia/Manila
    {    1, 6920,    2511,  6, }, // Asia/Muscat
    {    1, 2554,    2517,  7, }, // Asia/Nicosia
    {    1, 8675,    2524, 11, }, // Asia/Novokuznetsk
    {    1, 4135,    2535, 11, }, // Asia/Novosibirsk
    {    1, 4229,    2546,  4, }, // Asia/Omsk
    {    1, 7145,    2550,  6, }, // Asia/Oral
    {    1, 6961,    2556,  7, }, // Asia/Phnom_Penh
    {    1, 8693,    2563,  9, }, // Asia/Pontianak
    {    1, 4214,    2572,  7, }, // Asia/Pyongyang
    {    1, 5559,    2579,  5, }, // Asia/Qatar
    {    1, 8708,    2584,  8, }, // Asia/Qostanay
    {    1, 4269,    2592,  9, }, // Asia/Qyzylorda
    {    1, 3584,    2601,  7, }, // Asia/Riyadh
    {    1, 4408,    2608, 13, }, // Asia/Sakhalin
    {    1, 7245,    2621,  9, }, // Asia/Samarkand
    {    1, 3279,    2630,  4, }, // Asia/Seoul
    {    1, 1053,    2634,  6, }, // Asia/Shanghai
    {    1, 3300,    2640,  8, }, // Asia/Singapore
    {    1, 4297,    2648, 13, }, // Asia/Srednekolymsk
    {    1, 3263,    2661,  6, }, // Asia/Taipei
    {    1, 4781,    2667,  7, }, // Asia/Tashkent
    {    1, 3915,    2674,  4, }, // Asia/Tbilisi
    {    1, 2772,    2678,  7, }, // Asia/Tehran
    {    1, 1317,    2685,  7, }, // Asia/Thimphu
    {    1, 2821,    2692,  5, }, // Asia/Tokyo
    {    1, 4572,    2697,  5, }, // Asia/Tomsk
    {    1, 1021,    2702, 10, }, // Asia/Ulaanbaatar
    {    1, 1159,    2712,  6, }, // Asia/Urumqi
    {    1, 8722,    2718,  8, }, // Asia/Ust-Nera
    {    1, 6977,    2726,  7, }, // Asia/Vientiane
    {    1, 4710,    2733, 11, }, // Asia/Vladivostok
    {    1, 4828,    2744,  7, }, // Asia/Yakutsk
    {    1, 1235,    2751,  6, }, // Asia/Yangon
    {    1, 3883,    2757, 12, }, // Asia/Yekaterinburg
    {    1, 3747,    2769,  6, }, // Asia/Yerevan
    {    1, 3663,    2775, 16, }, // Atlantic/Azores
    {    1, 5671,    2791, 18, }, // Atlantic/Bermuda
    {    1, 6628,    2809, 17, }, // Atlantic/Canary
    {    1, 3727,    2826, 10, }, // Atlantic/Cape_Verde
    {    1, 1395,    2836, 17, }, // Atlantic/Faroe
    {    1, 8736,    2853,  7, }, // Atlantic/Madeira
    {    1, 2748,    2860,  9, }, // Atlantic/Reykjavik
    {    1, 7272,    2869, 16, }, // Atlantic/South_Georgia
    {    1, 6821,    2885, 26, }, // Atlantic/St_Helena
    {    1, 6644,    2911,  6, }, // Atlantic/Stanley
    {    1, 1670,    2917,  8, }, // Australia/Adelaide
    {    1, 1635,    2925,  7, }, // Australia/Brisbane
    {    1, 1799,    2932, 11, }, // Australia/Broken_Hill
    {    1, 1583,    2943,  6, }, // Australia/Darwin
    {    1, 3637,    2949,  5, }, // Australia/Eucla
    {    1, 1516,    2954,  6, }, // Australia/Hobart
    {    1, 8753,    2960,  8, }, // Australia/Lindeman
    {    1, 1547,    2968,  8, }, // Australia/Lord_Howe
    {    1, 1727,    2976,  7, }, // Australia/Melbourne
    {    1, 1762,    2983,  4, }, // Australia/Perth
    {    1, 1463,    2987,  6, }, // Australia/Sydney
    {    1, 6441,    2993,  9, }, // Europe/Amsterdam
    {    1, 6216,    3002,  7, }, // Europe/Andorra
    {    1, 3620,    3009,  8, }, // Europe/Astrakhan
    {    1, 2300,    3017,  4, }, // Europe/Athens
    {    1, 6336,    3021,  7, }, // Europe/Belgrade
    {    1, 4757,    3028,  6, }, // Europe/Berlin
    {    1, 6488,    3034, 10, }, // Europe/Bratislava
    {    1, 2167,    3044,  8, }, // Europe/Brussels
    {    1, 3928,    3052,  8, }, // Europe/Bucharest
    {    1, 3806,    3060,  8, }, // Europe/Budapest
    {    1, 8772,    3068, 23, }, // Europe/Busingen
    {    1, 2583,    3091,  7, }, // Europe/Chisinau
    {    1, 6289,    3098, 10, }, // Europe/Copenhagen
    {    1, 2338,    3108,  6, }, // Europe/Dublin
    {    1, 6307,    3114,  9, }, // Europe/Gibraltar
    {    1, 8788,    3123,  6, }, // Europe/Guernsey
    {    1, 6612,    3129,  8, }, // Europe/Helsinki
    {    1, 8804,    3137,  9, }, // Europe/Isle_of_Man
    {    1, 1130,    3146,  7, }, // Europe/Istanbul
    {    1, 8823,    3153,  5, }, // Europe/Jersey
    {    1, 3979,    3158, 11, }, // Europe/Kaliningrad
    {    1, 8929,    3169,  5, }, // Europe/Kirov
    {    1, 2527,    3174,  4, }, // Europe/Kyiv
    {    1, 3213,    3178,  8, }, // Europe/Lisbon
    {    1, 6506,    3186,  9, }, // Europe/Ljubljana
    {    1, 2501,    3195,  6, }, // Europe/London
    {    1, 6365,    3201, 11, }, // Europe/Luxembourg
    {    1, 4892,    3212,  6, }, // Europe/Madrid
    {    1, 6397,    3218,  5, }, // Europe/Malta
    {    1, 6582,    3223,  9, }, // Europe/Mariehamn
    {    1, 3693,    3232,  5, }, // Europe/Minsk
    {    1, 6410,    3237,  6, }, // Europe/Monaco
    {    1, 3537,    3243,  6, }, // Europe/Moscow
    {    1, 6458,    3249,  4, }, // Europe/Oslo
    {    1, 4284,    3253,  5, }, // Europe/Paris
    {    1, 6424,    3258,  9, }, // Europe/Podgorica
    {    1, 6275,    3267,  5, }, // Europe/Prague
    {    1, 8837,    3272,  4, }, // Europe/Riga
    {    1, 6324,    3276,  3, }, // Europe/Rome
    {    1, 4331,    3279,  6, }, // Europe/Samara
    {    1, 6470,    3285, 10, }, // Europe/San_Marino
    {    1, 6245,    3295,  7, }, // Europe/Sarajevo
    {    1, 4451,    3302,  7, }, // Europe/Saratov
    {    1, 8849,    3309, 10, }, // Europe/Simferopol
    {    1, 6383,    3319,  5, }, // Europe/Skopje
    {    1, 6599,    3324,  5, }, // Europe/Sofia
    {    1, 6523,    3329,  8, }, // Europe/Stockholm
    {    1, 8867,    3337,  6, }, // Europe/Tallinn
    {    1, 6202,    3343,  6, }, // Europe/Tirane
    {    1, 8882,    3349,  9, }, // Europe/Ulyanovsk
    {    1, 6352,    3358,  5, }, // Europe/Vaduz
    {    1, 6567,    3363,  7, }, // Europe/Vatican
    {    1, 6231,    3370,  4, }, // Europe/Vienna
    {    1, 8899,    3374,  7, }, // Europe/Vilnius
    {    1, 4727,    3381,  9, }, // Europe/Volgograd
    {    1, 3190,    3390,  7, }, // Europe/Warsaw
    {    1, 6261,    3397,  6, }, // Europe/Zagreb
    {    1, 6540,    3403,  6, }, // Europe/Zurich
    {    1, 5078,    3409, 12, }, // Indian/Antananarivo
    {    1, 6947,    3421,  5, }, // Indian/Chagos
    {    1, 6046,    3426, 12, }, // Indian/Christmas
    {    1, 6063,    3438, 17, }, // Indian/Cocos
    {    1, 5029,    3455,  5, }, // Indian/Comoro
    {    1, 6661,    3460,  8, }, // Indian/Kerguelen
    {    1, 7260,    3468,  3, }, // Indian/Mahe
    {    1, 7050,    3471,  6, }, // Indian/Maldives
    {    1, 4069,    3477,  7, }, // Indian/Mauritius
    {    1, 5098,    3484,  7, }, // Indian/Mayotte
    {    1, 7211,    3491,  7, }, // Indian/Reunion
    {    1, 4422,    3498,  4, }, // Pacific/Apia
    {    1,  932,    3502,  6, }, // Pacific/Auckland
    {    1, 3706,    3508,  8, }, // Pacific/Bougainville
    {    1, 3015,    3516,  5, }, // Pacific/Chatham
    {    1, 3157,    3521,  4, }, // Pacific/Chuuk
    {    1, 2237,    3525, 11, }, // Pacific/Easter
    {    1, 7360,    3536,  5, }, // Pacific/Efate
    {    1, 7327,    3541,  7, }, // Pacific/Fakaofo
    {    1, 3902,    3548,  4, }, // Pacific/Fiji
    {    1, 7343,    3552,  8, }, // Pacific/Funafuti
    {    1, 6678,    3560, 21, }, // Pacific/Galapagos
    {    1, 6696,    3581, 14, }, // Pacific/Gambier
    {    1, 3822,    3595, 11, }, // Pacific/Guadalcanal
    {    1, 6018,    3606,  4, }, // Pacific/Guam
    {    1, 3049,    3610,  6, }, // Pacific/Kanton
    {    1, 3998,    3616, 10, }, // Pacific/Kiritimati
    {    1, 7019,    3626,  6, }, // Pacific/Kosrae
    {    1, 2842,    3632,  9, }, // Pacific/Kwajalein
    {    1, 4877,    3641,  6, }, // Pacific/Majuro
    {    1, 4051,    3647, 18, }, // Pacific/Marquesas
    {    1, 8914,    3665, 15, }, // Pacific/Midway
    {    1, 7084,    3680,  5, }, // Pacific/Nauru
    {    1, 7132,    3685,  4, }, // Pacific/Niue
    {    1, 4168,    3689,  7, }, // Pacific/Norfolk
    {    1, 7098,    3696,  5, }, // Pacific/Noumea
    {    1, 3126,    3701,  9, }, // Pacific/Pago_Pago
    {    1, 7155,    3710,  5, }, // Pacific/Palau
    {    1, 7194,    3715,  7, }, // Pacific/Pitcairn
    {    1, 3096,    3722,  6, }, // Pacific/Pohnpei
    {    1, 4807,    3728, 11, }, // Pacific/Port_Moresby
    {    1, 6076,    3739,  9, }, // Pacific/Rarotonga
    {    1, 6031,    3748,  6, }, // Pacific/Saipan
    {    1, 7312,    3754,  5, }, // Pacific/Tahiti
    {    1, 6712,    3759,  6, }, // Pacific/Tarawa
    {    1, 4583,    3765,  9, }, // Pacific/Tongatapu
    {    1, 7392,    3774,  4, }, // Pacific/Wake
    {    1, 7405,    3778,  6, }, // Pacific/Wallis
    {    2,   14,       0,  6, }, // Africa/Asmara Afar/Latin/Ethiopia
    {    2, 4435,       6,  8, }, // Africa/Sao_Tome
    {    2, 4252,      14,  8, }, // America/Asuncion
    {    2,  237,      22,  8, }, // America/Atikokan
    {    2, 7623,      30, 17, }, // America/Bahia_Banderas
    {    2, 3868,      47,  6, }, // America/Cancun
    {    2, 7774,      53, 13, }, // America/Ciudad_Juarez
    {    2, 5723,      66,  7, }, // America/Curacao
    {    2,  481,      73, 13, }, // America/Indiana/Knox
    {    2, 7961,      86, 16, }, // America/Indiana/Marengo
    {    2, 7985,     102, 19, }, // America/Indiana/Petersburg
    {    2, 8012,     121, 18, }, // America/Indiana/Tell_City
    {    2, 8038,     139, 14, }, // America/Indiana/Vevay
    {    2, 8060,     153, 18, }, // America/Indiana/Vincennes
    {    2, 8086,     171, 16, }, // America/Indiana/Winamac
    {    2, 8125,     187, 20, }, // America/Kentucky/Monticello
    {    2, 5932,     207, 22, }, // America/Lower_Princes
    {    2, 8220,     229,  6, }, // America/Merida
    {    2, 8301,     235, 20, }, // America/North_Dakota/Beulah
    {    2, 8329,     255, 20, }, // America/North_Dakota/Center
    {    2, 8357,     275, 23, }, // America/North_Dakota/New_Salem
    {    2,  393,     298,  4, }, // America/Nuuk
    {    2, 6899,     302, 16, }, // America/Scoresbysund
    {    2, 8508,     318, 14, }, // America/St_Barthelemy
    {    2, 2061,     332, 10, }, // America/St_Johns
    {    2, 5863,     342,  9, }, // America/St_Kitts
    {    2, 5880,     351,  9, }, // America/St_Lucia
    {    2,  855,     360, 10, }, // America/St_Thomas
    {    2, 5913,     370, 11, }, // America/St_Vincent
    {    2, 6133,     381, 16, }, // Antarctica/DumontDUrville
    {    2, 1259,     397, 11, }, // Asia/Ho_Chi_Minh
    {    2, 1185,     413,  9, }, // Asia/Kathmandu
    {    2,  992,     422,  7, }, // Asia/Kolkata
    {    2, 1211,     429,  5, }, // Asia/Macau
    {    2, 1235,     442,  6, }, // Asia/Yangon
    {    2, 1395,     448,  5, }, // Atlantic/Faroe
    {    2, 6821,     453, 10, }, // Atlantic/St_Helena
    {    2, 2527,     463,  4, }, // Europe/Kyiv
    {    2, 7211,     467,  7, }, // Indian/Reunion
    {    2, 3157,     474,  5, }, // Pacific/Chuuk
    {    2, 3096,     479,  7, }, // Pacific/Pohnpei
    {    5, 5059,    3784, 11, }, // Africa/Addis_Ababa Afrikaans/Latin/South Africa
    {    5,   14,       0,  6, }, // Africa/Asmara
    {    5, 2320,    3795,  5, }, // Africa/Cairo
    {    5, 5043,    3800,  8, }, // Africa/Djibouti
    {    5, 4524,    3808,  7, }, // Africa/Khartoum
    {    5, 5113,    3815, 10, }, // Africa/Mogadishu
    {    5, 4435,       6,  8, }, // Africa/Sao_Tome
    {    5, 4252,      14,  8, }, // America/Asuncion
    {    5,  237,      22,  8, }, // America/Atikokan
    {    5, 7623,    3825, 14, }, // America/Bahia_Banderas
    {    5, 7713,    3839, 13, }, // America/Cambridge_Bay
    {    5, 3868,      47,  6, }, // America/Cancun
    {    5, 5496,    3852,  7, }, // America/Cayman
    {    5, 7774,      53, 13, }, // America/Ciudad_Juarez
    {    5, 5723,      66,  7, }, // America/Curacao
    {    5, 7924,    3859,  9, }, // America/Glace_Bay
    {    5, 6881,    3868,  9, }, // America/Goose_Bay
    {    5,  481,      73, 13, }, // America/Indiana/Knox
    {    5, 7961,      86, 16, }, // America/Indiana/Marengo
    {    5, 7985,     102, 19, }, // America/Indiana/Petersburg
    {    5, 8012,     121, 18, }, // America/Indiana/Tell_City
    {    5, 8038,     139, 14, }, // America/Indiana/Vevay
    {    5, 8060,     153, 18, }, // America/Indiana/Vincennes
    {    5, 8086,     171, 16, }, // America/Indiana/Winamac
    {    5, 2799,    3877,  7, }, // America/Jamaica
    {    5, 8125,     187, 20, }, // America/Kentucky/Monticello
    {    5, 5932,     207, 22, }, // America/Lower_Princes
    {    5, 8220,     229,  6, }, // America/Merida
    {    5, 2949,    3884, 11, }, // America/Mexico_City
    {    5, 8301,    3895, 20, }, // America/North_Dakota/Beulah
    {    5, 8329,    3915, 20, }, // America/North_Dakota/Center
    {    5, 8357,    3935, 23, }, // America/North_Dakota/New_Salem
    {    5,  393,     298,  4, }, // America/Nuuk
    {    5, 6899,     302, 16, }, // America/Scoresbysund
    {    5, 8508,    3958, 17, }, // America/St_Barthelemy
    {    5, 2061,    3975, 11, }, // America/St_Johns
    {    5, 5863,    3986, 10, }, // America/St_Kitts
    {    5, 5880,    3996, 10, }, // America/St_Lucia
    {    5,  855,    4006, 11, }, // America/St_Thomas
    {    5, 5913,    4017, 12, }, // America/St_Vincent
    {    5, 6133,     381, 16, }, // Antarctica/DumontDUrville
    {    5, 7374,    4029,  6, }, // Antarctica/Vostok
    {    5,  964,    4035,  9, }, // Asia/Ashgabat
    {    5, 3607,    4044,  6, }, // Asia/Baghdad
    {    5, 5534,    4050,  7, }, // Asia/Bahrain
    {    5, 3653,    4057,  5, }, // Asia/Baku
    {    5, 4086,    4062,  7, }, // Asia/Beirut
    {    5, 3778,    4069,  7, }, // Asia/Bishkek
    {    5, 5989,    4076,  7, }, // Asia/Brunei
    {    5, 4540,    4083,  8, }, // Asia/Damascus
    {    5, 3596,    4091,  6, }, // Asia/Dubai
    {    5, 1259,    4097, 16, }, // Asia/Ho_Chi_Minh
    {    5, 2704,    4113,  8, }, // Asia/Hong_Kong
    {    5, 4184,    4121,  8, }, // Asia/Irkutsk
    {    5, 7006,    4129,  8, }, // Asia/Jakarta
    {    5, 3560,    4137,  6, }, // Asia/Kabul
    {    5, 4316,    4143, 10, }, // Asia/Kamchatka
    {    5, 4239,    4153,  8, }, // Asia/Karachi
    {    5, 1185,    4161,  9, }, // Asia/Kathmandu
    {    5,  992,     422,  7, }, // Asia/Kolkata
    {    5, 4197,    4170, 11, }, // Asia/Krasnoyarsk
    {    5, 4859,    4181, 15, }, // Asia/Kuala_Lumpur
    {    5, 5547,    4196,  7, }, // Asia/Kuwait
    {    5, 1211,    4203,  5, }, // Asia/Macau
    {    5, 6920,    4208,  6, }, // Asia/Muscat
    {    5, 5559,    4214,  5, }, // Asia/Qatar
    {    5, 8708,     434,  8, }, // Asia/Qostanay
    {    5, 3584,    4219,  5, }, // Asia/Riyadh
    {    5, 3279,    4224,  5, }, // Asia/Seoul
    {    5, 3300,    4229,  9, }, // Asia/Singapore
    {    5, 2821,    4238,  5, }, // Asia/Tokyo
    {    5, 4710,    4243, 11, }, // Asia/Vladivostok
    {    5, 4828,    4254,  8, }, // Asia/Yakutsk
    {    5, 1235,     442,  6, }, // Asia/Yangon
    {    5, 3883,    4262, 13, }, // Asia/Yekaterinburg
    {    5, 3663,    4275,  5, }, // Atlantic/Azores
    {    5, 6628,    4280,  7, }, // Atlantic/Canary
    {    5, 3727,    4287, 10, }, // Atlantic/Cape_Verde
    {    5, 1395,     448,  5, }, // Atlantic/Faroe
    {    5, 7272,    4297, 12, }, // Atlantic/South_Georgia
    {    5, 6821,    4309, 11, }, // Atlantic/St_Helena
    {    5, 2300,    4320,  6, }, // Europe/Athens
    {    5, 4757,    4326,  6, }, // Europe/Berlin
    {    5, 2167,    4332,  7, }, // Europe/Brussels
    {    5, 3928,    4339,  9, }, // Europe/Bucharest
    {    5, 3806,    4348,  9, }, // Europe/Budapest
    {    5, 6289,    4357, 10, }, // Europe/Copenhagen
    {    5, 8804,    4367, 10, }, // Europe/Isle_of_Man
    {    5, 2527,    4377,  4, }, // Europe/Kyiv
    {    5, 3213,    4381,  8, }, // Europe/Lisbon
    {    5, 2501,    4389,  6, }, // Europe/London
    {    5, 6365,    4395,  9, }, // Europe/Luxembourg
    {    5, 3537,    4404,  6, }, // Europe/Moscow
    {    5, 4284,    4410,  5, }, // Europe/Paris
    {    5, 6275,    4415,  5, }, // Europe/Prague
    {    5, 4451,    4420,  7, }, // Europe/Saratov
    {    5, 6567,    4427, 12, }, // Europe/Vatican
    {    5, 6231,    4439,  4, }, // Europe/Vienna
    {    5, 4727,    4443,  9, }, // Europe/Volgograd
    {    5, 3190,    4452,  7, }, // Europe/Warsaw
    {    5, 6540,    4459,  6, }, // Europe/Zurich
    {    5, 6063,    4465,  5, }, // Indian/Cocos
    {    5, 5029,    4470,  6, }, // Indian/Comoro
    {    5, 7050,    4476,  8, }, // Indian/Maldives
    {    5, 7211,     467,  7, }, // Indian/Reunion
    {    5, 3157,     474,  5, }, // Pacific/Chuuk
    {    5, 2237,    4484,  4, }, // Pacific/Easter
    {    5, 3902,    4488,  5, }, // Pacific/Fiji
    {    5, 2723,    4493,  8, }, // Pacific/Honolulu
    {    5, 3049,    4501,  9, }, // Pacific/Kanton
    {    5, 7098,    4510,  6, }, // Pacific/Noumea
    {    5, 3096,     479,  7, }, // Pacific/Pohnpei
    {    5, 7405,    4516,  8, }, // Pacific/Wallis
    {    7,   14,       0,  6, }, // Africa/Asmara Aghem/Latin/Cameroon
    {    7, 4435,       6,  8, }, // Africa/Sao_Tome
    {    7, 4252,      14,  8, }, // America/Asuncion
    {    7,  237,      22,  8, }, // America/Atikokan
    {    7, 7623,      30, 17, }, // America/Bahia_Banderas
    {    7, 3868,      47,  6, }, // America/Cancun
    {    7, 7774,      53, 13, }, // America/Ciudad_Juarez
    {    7, 5723,      66,  7, }, // America/Curacao
    {    7,  481,      73, 13, }, // America/Indiana/Knox
    {    7, 7961,      86, 16, }, // America/Indiana/Marengo
    {    7, 7985,     102, 19, }, // America/Indiana/Petersburg
    {    7, 8012,     121, 18, }, // America/Indiana/Tell_City
    {    7, 8038,     139, 14, }, // America/Indiana/Vevay
    {    7, 8060,     153, 18, }, // America/Indiana/Vincennes
    {    7, 8086,     171, 16, }, // America/Indiana/Winamac
    {    7, 8125,     187, 20, }, // America/Kentucky/Monticello
    {    7, 5932,     207, 22, }, // America/Lower_Princes
    {    7, 8220,     229,  6, }, // America/Merida
    {    7, 8301,     235, 20, }, // America/North_Dakota/Beulah
    {    7, 8329,     255, 20, }, // America/North_Dakota/Center
    {    7, 8357,     275, 23, }, // America/North_Dakota/New_Salem
    {    7,  393,     298,  4, }, // America/Nuuk
    {    7, 6899,     302, 16, }, // America/Scoresbysund
    {    7, 8508,     318, 14, }, // America/St_Barthelemy
    {    7, 2061,     332, 10, }, // America/St_Johns
    {    7, 5863,     342,  9, }, // America/St_Kitts
    {    7, 5880,     351,  9, }, // America/St_Lucia
    {    7,  855,     360, 10, }, // America/St_Thomas
    {    7, 5913,     370, 11, }, // America/St_Vincent
    {    7, 6133,     381, 16, }, // Antarctica/DumontDUrville
    {    7, 1259,     397, 11, }, // Asia/Ho_Chi_Minh
    {    7, 1185,     413,  9, }, // Asia/Kathmandu
    {    7,  992,     422,  7, }, // Asia/Kolkata
    {    7, 1211,     429,  5, }, // Asia/Macau
    {    7, 1235,     442,  6, }, // Asia/Yangon
    {    7, 1395,     448,  5, }, // Atlantic/Faroe
    {    7, 6821,     453, 10, }, // Atlantic/St_Helena
    {    7, 2527,     463,  4, }, // Europe/Kyiv
    {    7, 7211,     467,  7, }, // Indian/Reunion
    {    7, 3157,     474,  5, }, // Pacific/Chuuk
    {    7, 3096,     479,  7, }, // Pacific/Pohnpei
    {    8, 6788,    4524,  7, }, // Africa/Abidjan Akan/Latin/Ghana
    {    8, 6760,    4531,  5, }, // Africa/Accra
    {    8, 7420,    4536,  7, }, // Africa/Algiers
    {    8,   14,       0,  6, }, // Africa/Asmara
    {    8, 6746,    4543,  7, }, // Africa/Banjul
    {    8, 7435,    4550,  5, }, // Africa/Bissau
    {    8, 4957,    4555,  7, }, // Africa/Blantyre
    {    8, 4922,    4562, 10, }, // Africa/Bujumbura
    {    8, 2320,    4572,  5, }, // Africa/Cairo
    {    8, 4117,    4577, 10, }, // Africa/Casablanca
    {    8, 7449,    4587,  5, }, // Africa/Ceuta
    {    8, 6773,    4592,  7, }, // Africa/Conakry
    {    8, 6840,    4599,  5, }, // Africa/Dakar
    {    8, 5043,    4604,  8, }, // Africa/Djibouti
    {    8, 4499,    4612,  5, }, // Africa/Juba
    {    8, 5306,    4617, 10, }, // Africa/Kinshasa
    {    8, 4744,    4627,  5, }, // Africa/Lagos
    {    8, 5271,    4632,  8, }, // Africa/Ndjamena
    {    8, 6727,    4640,  8, }, // Africa/Ouagadougou
    {    8, 4435,       6,  8, }, // Africa/Sao_Tome
    {    8, 3346,    4648,  9, }, // America/Anchorage
    {    8, 5607,    4657,  7, }, // America/Anguilla
    {    8,   91,    4664,  9, }, // America/Argentina/Catamarca
    {    8,  270,    4673,  7, }, // America/Argentina/Cordoba
    {    8,  441,    4680,  7, }, // America/Argentina/Jujuy
    {    8, 7462,    4687,  9, }, // America/Argentina/La_Rioja
    {    8,  565,    4696,  7, }, // America/Argentina/Mendoza
    {    8, 7489,    4703, 12, }, // America/Argentina/Rio_Gallegos
    {    8, 7544,    4715,  9, }, // America/Argentina/San_Juan
    {    8, 7571,    4724,  7, }, // America/Argentina/Tucuman
    {    8, 4252,      14,  8, }, // America/Asuncion
    {    8,  237,      22,  8, }, // America/Atikokan
    {    8, 7623,      30, 17, }, // America/Bahia_Banderas
    {    8, 5654,    4731,  8, }, // America/Barbados
    {    8, 7646,    4739,  5, }, // America/Belem
    {    8, 5407,    4744,  6, }, // America/Belize
    {    8, 7660,    4750, 12, }, // America/Blanc-Sablon
    {    8, 7699,    4762,  5, }, // America/Boise
    {    8, 7713,    4767, 13, }, // America/Cambridge_Bay
    {    8, 7735,    4780, 12, }, // America/Campo_Grande
    {    8, 3868,      47,  6, }, // America/Cancun
    {    8, 4694,    4792,  7, }, // America/Caracas
    {    8, 4345,    4799,  7, }, // America/Cayenne
    {    8, 5496,    4806,  7, }, // America/Cayman
    {    8, 2260,    4813,  7, }, // America/Chicago
    {    8, 7756,    4820,  9, }, // America/Chihuahua
    {    8, 7774,      53, 13, }, // America/Ciudad_Juarez
    {    8, 5422,    4829, 10, }, // America/Costa_Rica
    {    8, 7796,    4839,  7, }, // America/Creston
    {    8, 3791,    4846,  6, }, // America/Cuiaba
    {    8, 5723,    4852,  7, }, // America/Curacao
    {    8, 7833,    4859,  6, }, // America/Dawson
    {    8, 7848,    4865, 12, }, // America/Dawson_Creek
    {    8,  805,    4877,  5, }, // America/Denver
    {    8, 3465,    4882,  7, }, // America/Detroit
    {    8, 5739,    4889,  8, }, // America/Dominica
    {    8,  893,    4897,  8, }, // America/Edmonton
    {    8, 5441,    4905, 11, }, // America/El_Salvador
    {    8, 7886,    4916, 10, }, // America/Fort_Nelson
    {    8, 7906,    4926,  9, }, // America/Fortaleza
    {    8, 6881,    4935,  8, }, // America/Goose_Bay
    {    8, 4612,    4943,  9, }, // America/Grand_Turk
    {    8, 5786,    4952,  9, }, // America/Guadeloupe
    {    8, 3760,    4961, 10, }, // America/Guatemala
    {    8, 4841,    4971,  9, }, // America/Guayaquil
    {    8, 6932,    4980,  6, }, // America/Guyana
    {    8, 7942,    4986,  8, }, // America/Hermosillo
    {    8,  348,    4994, 12, }, // America/Indiana/Indianapolis
    {    8,  481,      73, 13, }, // America/Indiana/Knox
    {    8, 7961,      86, 16, }, // America/Indiana/Marengo
    {    8, 7985,    5006, 19, }, // America/Indiana/Petersburg
    {    8, 8012,    5025, 18, }, // America/Indiana/Tell_City
    {    8, 8038,     139, 14, }, // America/Indiana/Vevay
    {    8, 8060,     153, 18, }, // America/Indiana/Vincennes
    {    8, 8086,    5043, 16, }, // America/Indiana/Winamac
    {    8,  660,    5059,  7, }, // America/Iqaluit
    {    8, 2799,    5066,  7, }, // America/Jamaica
    {    8, 8125,    5073, 18, }, // America/Kentucky/Monticello
    {    8, 5704,    5091, 10, }, // America/Kralendijk
    {    8, 3239,    5101, 12, }, // America/Los_Angeles
    {    8, 5932,    5113, 16, }, // America/Lower_Princes
    {    8, 8153,    5129,  6, }, // America/Maceio
    {    8, 5897,    5135,  7, }, // America/Marigot
    {    8, 5805,    5142,  9, }, // America/Martinique
    {    8, 8184,    5151, 10, }, // America/Matamoros
    {    8, 2917,    5161,  8, }, // America/Mazatlan
    {    8, 8202,    5169,  9, }, // America/Menominee
    {    8, 8220,     229,  6, }, // America/Merida
    {    8, 8235,    5178, 10, }, // America/Metlakatla
    {    8, 2949,    5188, 12, }, // America/Mexico_City
    {    8, 8254,    5200,  7, }, // America/Moncton
    {    8, 8270,    5207,  8, }, // America/Monterrey
    {    8, 5824,    5215,  9, }, // America/Montserrat
    {    8, 2379,    5224,  7, }, // America/New_York
    {    8, 8301,    5231, 17, }, // America/North_Dakota/Beulah
    {    8, 8329,    5248, 17, }, // America/North_Dakota/Center
    {    8, 8357,    5265, 21, }, // America/North_Dakota/New_Salem
    {    8,  393,     298,  4, }, // America/Nuuk
    {    8, 8388,    5286,  8, }, // America/Ojinaga
    {    8, 6173,    5294, 10, }, // America/Paramaribo
    {    8, 2973,    5304,  6, }, // America/Phoenix
    {    8, 5954,    5310, 11, }, // America/Port_of_Spain
    {    8, 8404,    5321, 11, }, // America/Porto_Velho
    {    8, 5843,    5332, 10, }, // America/Puerto_Rico
    {    8, 8445,    5342,  6, }, // America/Recife
    {    8, 1995,    5348,  7, }, // America/Regina
    {    8, 8460,    5355,  7, }, // America/Resolute
    {    8,  695,    5362, 10, }, // America/Rio_Branco
    {    8, 6899,    5372, 13, }, // America/Scoresbysund
    {    8, 8508,    5385, 13, }, // America/St_Barthelemy
    {    8, 2061,     332, 10, }, // America/St_Johns
    {    8, 5863,     342,  9, }, // America/St_Kitts
    {    8, 5880,     351,  9, }, // America/St_Lucia
    {    8,  855,     360, 10, }, // America/St_Thomas
    {    8, 5913,     370, 11, }, // America/St_Vincent
    {    8, 8530,    5398, 12, }, // America/Swift_Current
    {    8, 5461,    5410, 11, }, // America/Tegucigalpa
    {    8,  313,    5421,  8, }, // America/Tijuana
    {    8, 5688,    5429,  7, }, // America/Tortola
    {    8,  734,    5436,  7, }, // America/Winnipeg
    {    8, 6001,    5443,  4, }, // Antarctica/Casey
    {    8, 6133,     381, 16, }, // Antarctica/DumontDUrville
    {    8, 8568,    5447,  7, }, // Antarctica/Macquarie
    {    8, 7066,    5454,  6, }, // Antarctica/Mawson
    {    8, 8589,    5460,  5, }, // Antarctica/Palmer
    {    8, 7226,    5465,  6, }, // Antarctica/Rothera
    {    8, 8607,    5471,  4, }, // Antarctica/Troll
    {    8, 7374,    5475,  6, }, // Antarctica/Vostok
    {    8, 5395,    5481,  6, }, // Asia/Almaty
    {    8, 3968,    5487,  4, }, // Asia/Amman
    {    8, 5523,    5491,  5, }, // Asia/Aqtau
    {    8, 5368,    5496,  6, }, // Asia/Aqtobe
    {    8, 4466,    5502,  6, }, // Asia/Bangkok
    {    8, 4086,    5508,  6, }, // Asia/Beirut
    {    8, 4601,    5514,  5, }, // Asia/Chita
    {    8, 4511,    5519,  7, }, // Asia/Colombo
    {    8, 4540,    5526,  9, }, // Asia/Damascus
    {    8, 1093,    4599,  4, }, // Asia/Dhaka
    {    8, 4795,    5535,  6, }, // Asia/Hebron
    {    8, 1259,    5541, 10, }, // Asia/Ho_Chi_Minh
    {    8, 7006,    5551,  8, }, // Asia/Jakarta
    {    8, 6992,    5559,  9, }, // Asia/Jayapura
    {    8, 1290,    5568,  9, }, // Asia/Jerusalem
    {    8, 4316,    5577,  9, }, // Asia/Kamchatka
    {    8, 4239,    5586,  7, }, // Asia/Karachi
    {    8, 1185,    5593,  8, }, // Asia/Kathmandu
    {    8,  992,    5601,  7, }, // Asia/Kolkata
    {    8, 5976,    5608,  6, }, // Asia/Kuching
    {    8, 1211,     429,  5, }, // Asia/Macau
    {    8, 1349,    5614,  6, }, // Asia/Makassar
    {    8, 6920,    4208,  6, }, // Asia/Muscat
    {    8, 2554,    5620,  7, }, // Asia/Nicosia
    {    8, 5559,    4214,  4, }, // Asia/Qatar
    {    8, 8708,     434,  8, }, // Asia/Qostanay
    {    8, 3300,    5627,  7, }, // Asia/Singapore
    {    8, 2772,    5634,  6, }, // Asia/Tehran
    {    8, 1317,    5640,  6, }, // Asia/Thimphu
    {    8, 1021,    5646,  9, }, // Asia/Ulaanbaatar
    {    8, 1159,    5655,  7, }, // Asia/Urumqi
    {    8, 6977,    5662, 10, }, // Asia/Vientiane
    {    8, 1235,     442,  6, }, // Asia/Yangon
    {    8, 3883,    5672, 12, }, // Asia/Yekaterinburg
    {    8, 5671,    5684,  6, }, // Atlantic/Bermuda
    {    8, 6628,    4280,  6, }, // Atlantic/Canary
    {    8, 3727,    5690,  7, }, // Atlantic/Cape_Verde
    {    8, 1395,     448,  5, }, // Atlantic/Faroe
    {    8, 2748,    5697, 10, }, // Atlantic/Reykjavik
    {    8, 7272,    5707, 16, }, // Atlantic/South_Georgia
    {    8, 6821,     453, 10, }, // Atlantic/St_Helena
    {    8, 6644,    5723,  6, }, // Atlantic/Stanley
    {    8, 1799,    5729, 11, }, // Australia/Broken_Hill
    {    8, 1583,    5740,  6, }, // Australia/Darwin
    {    8, 3637,    5746,  5, }, // Australia/Eucla
    {    8, 1516,    5751,  5, }, // Australia/Hobart
    {    8, 1547,    5756,  8, }, // Australia/Lord_Howe
    {    8, 1727,    5764,  6, }, // Australia/Melbourne
    {    8, 1762,    5770,  4, }, // Australia/Perth
    {    8, 1463,    5774,  5, }, // Australia/Sydney
    {    8, 6441,    5779,  8, }, // Europe/Amsterdam
    {    8, 6216,    5787,  6, }, // Europe/Andorra
    {    8, 2300,    5793,  5, }, // Europe/Athens
    {    8, 6336,    5798,  8, }, // Europe/Belgrade
    {    8, 4757,    5806,  6, }, // Europe/Berlin
    {    8, 2167,    5812,  8, }, // Europe/Brussels
    {    8, 3928,    5820,  9, }, // Europe/Bucharest
    {    8, 3806,    5829,  8, }, // Europe/Budapest
    {    8, 8772,    5837,  8, }, // Europe/Busingen
    {    8, 2583,    5845,  8, }, // Europe/Chisinau
    {    8, 6289,    5853, 11, }, // Europe/Copenhagen
    {    8, 2338,    5864,  6, }, // Europe/Dublin
    {    8, 6307,    5870,  8, }, // Europe/Gibraltar
    {    8, 6612,    5878,  8, }, // Europe/Helsinki
    {    8, 8823,    5886,  5, }, // Europe/Jersey
    {    8, 2527,     463,  4, }, // Europe/Kyiv
    {    8, 3213,    5891,  6, }, // Europe/Lisbon
    {    8, 6506,    5897, 10, }, // Europe/Ljubljana
    {    8, 2501,    5907,  6, }, // Europe/London
    {    8, 6365,    5913,  8, }, // Europe/Luxembourg
    {    8, 6397,    5921,  5, }, // Europe/Malta
    {    8, 6410,    5926,  6, }, // Europe/Monaco
    {    8, 3537,    5932,  5, }, // Europe/Moscow
    {    8, 6424,    5937,  9, }, // Europe/Podgorica
    {    8, 6324,    5946,  4, }, // Europe/Rome
    {    8, 6245,    5950,  9, }, // Europe/Sarajevo
    {    8, 6383,    5959,  7, }, // Europe/Skopje
    {    8, 6599,    5966,  5, }, // Europe/Sofia
    {    8, 6523,    5971,  7, }, // Europe/Stockholm
    {    8, 6567,    5978,  7, }, // Europe/Vatican
    {    8, 6231,    5985,  5, }, // Europe/Vienna
    {    8, 3190,    5990,  6, }, // Europe/Warsaw
    {    8, 6540,    5996,  7, }, // Europe/Zurich
    {    8, 6947,    6003,  6, }, // Indian/Chagos
    {    8, 6046,    6009,  7, }, // Indian/Christmas
    {    8, 6063,    6016,  6, }, // Indian/Cocos
    {    8, 5029,    6022,  6, }, // Indian/Comoro
    {    8, 6661,    6028,  8, }, // Indian/Kerguelen
    {    8, 4069,    6036, 10, }, // Indian/Mauritius
    {    8, 5098,    6046,  6, }, // Indian/Mayotte
    {    8, 7211,     467,  7, }, // Indian/Reunion
    {    8,  932,    6052,  7, }, // Pacific/Auckland
    {    8, 3015,    6059,  6, }, // Pacific/Chatham
    {    8, 3157,    6065,  5, }, // Pacific/Chuuk
    {    8, 2237,    6070,  5, }, // Pacific/Easter
    {    8, 3902,    6075,  5, }, // Pacific/Fiji
    {    8, 6678,    6080,  9, }, // Pacific/Galapagos
    {    8, 3822,    6089, 11, }, // Pacific/Guadalcanal
    {    8, 2842,    6100, 11, }, // Pacific/Kwajalein
    {    8, 4877,    6111,  7, }, // Pacific/Majuro
    {    8, 4051,    6118,  9, }, // Pacific/Marquesas
    {    8, 4168,    6127,  6, }, // Pacific/Norfolk
    {    8, 7194,    6133,  9, }, // Pacific/Pitcairn
    {    8, 3096,    6142,  6, }, // Pacific/Pohnpei
    {    8, 4807,    6148, 11, }, // Pacific/Port_Moresby
    {    9,   14,       0,  6, }, // Africa/Asmara Akoose/Latin/Cameroon
    {    9, 4435,       6,  8, }, // Africa/Sao_Tome
    {    9, 4252,      14,  8, }, // America/Asuncion
    {    9,  237,      22,  8, }, // America/Atikokan
    {    9, 7623,      30, 17, }, // America/Bahia_Banderas
    {    9, 3868,      47,  6, }, // America/Cancun
    {    9, 7774,      53, 13, }, // America/Ciudad_Juarez
    {    9, 5723,      66,  7, }, // America/Curacao
    {    9,  481,      73, 13, }, // America/Indiana/Knox
    {    9, 7961,      86, 16, }, // America/Indiana/Marengo
    {    9, 7985,     102, 19, }, // America/Indiana/Petersburg
    {    9, 8012,     121, 18, }, // America/Indiana/Tell_City
    {    9, 8038,     139, 14, }, // America/Indiana/Vevay
    {    9, 8060,     153, 18, }, // America/Indiana/Vincennes
    {    9, 8086,     171, 16, }, // America/Indiana/Winamac
    {    9, 8125,     187, 20, }, // America/Kentucky/Monticello
    {    9, 5932,     207, 22, }, // America/Lower_Princes
    {    9, 8220,     229,  6, }, // America/Merida
    {    9, 8301,     235, 20, }, // America/North_Dakota/Beulah
    {    9, 8329,     255, 20, }, // America/North_Dakota/Center
    {    9, 8357,     275, 23, }, // America/North_Dakota/New_Salem
    {    9,  393,     298,  4, }, // America/Nuuk
    {    9, 6899,     302, 16, }, // America/Scoresbysund
    {    9, 8508,     318, 14, }, // America/St_Barthelemy
    {    9, 2061,     332, 10, }, // America/St_Johns
    {    9, 5863,     342,  9, }, // America/St_Kitts
    {    9, 5880,     351,  9, }, // America/St_Lucia
    {    9,  855,     360, 10, }, // America/St_Thomas
    {    9, 5913,     370, 11, }, // America/St_Vincent
    {    9, 6133,     381, 16, }, // Antarctica/DumontDUrville
    {    9, 1259,     397, 11, }, // Asia/Ho_Chi_Minh
    {    9, 1185,     413,  9, }, // Asia/Kathmandu
    {    9,  992,     422,  7, }, // Asia/Kolkata
    {    9, 1211,     429,  5, }, // Asia/Macau
    {    9, 1235,     442,  6, }, // Asia/Yangon
    {    9, 1395,     448,  5, }, // Atlantic/Faroe
    {    9, 6821,     453, 10, }, // Atlantic/St_Helena
    {    9, 2527,     463,  4, }, // Europe/Kyiv
    {    9, 7211,     467,  7, }, // Indian/Reunion
    {    9, 3157,     474,  5, }, // Pacific/Chuuk
    {    9, 3096,     479,  7, }, // Pacific/Pohnpei
    {   10, 6788,    6159,  7, }, // Africa/Abidjan Albanian/Latin/Albania
    {   10, 6760,    4531,  4, }, // Africa/Accra
    {   10, 5059,    6166, 10, }, // Africa/Addis_Ababa
    {   10, 7420,    6176,  6, }, // Africa/Algiers
    {   10,   14,    6182,  6, }, // Africa/Asmara
    {   10, 6746,    6188,  7, }, // Africa/Banjul
    {   10, 7435,    6195,  5, }, // Africa/Bissau
    {   10, 4957,    6200,  8, }, // Africa/Blantyre
    {   10, 5287,    6208, 10, }, // Africa/Brazzaville
    {   10, 4922,    6218, 10, }, // Africa/Bujumbura
    {   10, 2320,    6228,  5, }, // Africa/Cairo
    {   10, 4117,    6233, 10, }, // Africa/Casablanca
    {   10, 7449,    6243,  6, }, // Africa/Ceuta
    {   10, 6773,    6249,  7, }, // Africa/Conakry
    {   10, 5130,    6256, 12, }, // Africa/Dar_es_Salaam
    {   10, 5043,    6268,  7, }, // Africa/Djibouti
    {   10, 5166,    6275,  7, }, // Africa/El_Aaiun
    {   10, 6853,    6282,  7, }, // Africa/Freetown
    {   10, 4479,    6289, 11, }, // Africa/Johannesburg
    {   10, 4499,    6300,  5, }, // Africa/Juba
    {   10, 4524,    6305,  6, }, // Africa/Khartoum
    {   10, 5336,    6311,  9, }, // Africa/Libreville
    {   10, 5354,    6320,  6, }, // Africa/Niamey
    {   10, 6803,    6326,  7, }, // Africa/Nouakchott
    {   10, 6727,    6333,  8, }, // Africa/Ouagadougou
    {   10, 4435,    6341,  8, }, // Africa/Sao_Tome
    {   10, 6554,    6349,  5, }, // Africa/Tunis
    {   10, 4152,    6354,  8, }, // Africa/Windhoek
    {   10, 3346,    6362,  9, }, // America/Anchorage
    {   10, 5607,    6371,  7, }, // America/Anguilla
    {   10, 4554,    6378, 10, }, // America/Araguaina
    {   10,  166,    6388, 12, }, // America/Argentina/Buenos_Aires
    {   10,   91,    6400,  9, }, // America/Argentina/Catamarca
    {   10,  270,    6409,  7, }, // America/Argentina/Cordoba
    {   10,  441,    6416,  5, }, // America/Argentina/Jujuy
    {   10, 7462,    6421,  8, }, // America/Argentina/La_Rioja
    {   10, 7489,    6429, 11, }, // America/Argentina/Rio_Gallegos
    {   10, 7520,    6440,  5, }, // America/Argentina/Salta
    {   10, 7544,    6445,  8, }, // America/Argentina/San_Juan
    {   10, 5580,    6453,  9, }, // America/Argentina/San_Luis
    {   10, 7571,    4724,  7, }, // America/Argentina/Tucuman
    {   10, 7597,    6462,  7, }, // America/Argentina/Ushuaia
    {   10, 5640,    6469,  5, }, // America/Aruba
    {   10, 4252,    6474,  8, }, // America/Asuncion
    {   10,  237,      22,  8, }, // America/Atikokan
    {   10, 7623,    6482, 14, }, // America/Bahia_Banderas
    {   10, 5407,    6496,  6, }, // America/Belize
    {   10, 7660,    6502, 12, }, // America/Blanc-Sablon
    {   10, 7681,    6514,  9, }, // America/Boa_Vista
    {   10, 4361,    6523,  6, }, // America/Bogota
    {   10, 7699,    6529,  5, }, // America/Boise
    {   10, 7713,    6534, 18, }, // America/Cambridge_Bay
    {   10, 7735,    6552, 12, }, // America/Campo_Grande
    {   10, 3868,    6564,  6, }, // America/Cancun
    {   10, 4694,    4792,  7, }, // America/Caracas
    {   10, 4345,    6570,  6, }, // America/Cayenne
    {   10, 5496,    6576,  6, }, // America/Cayman
    {   10, 2260,    6582,  6, }, // America/Chicago
    {   10, 7756,    6588,  7, }, // America/Chihuahua
    {   10, 7774,    6595, 13, }, // America/Ciudad_Juarez
    {   10, 5422,    6608, 10, }, // America/Costa_Rica
    {   10, 7796,    6618,  7, }, // America/Creston
    {   10, 3791,    6625,  6, }, // America/Cuiaba
    {   10, 5723,    6631,  7, }, // America/Curacao
    {   10, 7812,    6638, 13, }, // America/Danmarkshavn
    {   10, 7833,    6651,  6, }, // America/Dawson
    {   10, 7848,    6657, 16, }, // America/Dawson_Creek
    {   10, 5739,    6673,  8, }, // America/Dominica
    {   10, 7869,    6681,  7, }, // America/Eirunepe
    {   10, 5441,    6688,  8, }, // America/El_Salvador
    {   10, 7886,    6696, 11, }, // America/Fort_Nelson
    {   10, 7924,    6707, 14, }, // America/Glace_Bay
    {   10, 6881,    6721, 13, }, // America/Goose_Bay
    {   10, 4612,    6734, 12, }, // America/Grand_Turk
    {   10, 5770,    6746,  7, }, // America/Grenada
    {   10, 5786,    6753,  9, }, // America/Guadeloupe
    {   10, 3760,    6762,  9, }, // America/Guatemala
    {   10, 4841,    6771,  9, }, // America/Guayaquil
    {   10, 6932,    6780,  7, }, // America/Guyana
    {   10, 1939,    6787,  8, }, // America/Halifax
    {   10, 2281,    6795,  6, }, // America/Havana
    {   10, 7942,    6801,  9, }, // America/Hermosillo
    {   10,  481,    6810, 14, }, // America/Indiana/Knox
    {   10, 7961,      86, 16, }, // America/Indiana/Marengo
    {   10, 7985,    6824, 19, }, // America/Indiana/Petersburg
    {   10, 8012,    6843, 18, }, // America/Indiana/Tell_City
    {   10, 8038,    6861, 14, }, // America/Indiana/Vevay
    {   10, 8060,    6875, 17, }, // America/Indiana/Vincennes
    {   10, 8086,    6892, 16, }, // America/Indiana/Winamac
    {   10,  660,    5059,  7, }, // America/Iqaluit
    {   10, 2799,    6908,  8, }, // America/Jamaica
    {   10, 5380,    6916,  6, }, // America/Juneau
    {   10,  521,    6922,  8, }, // America/Kentucky/Louisville
    {   10, 8125,    6930, 18, }, // America/Kentucky/Monticello
    {   10, 7169,    6948,  4, }, // America/Lima
    {   10, 3239,    6952, 12, }, // America/Los_Angeles
    {   10, 5932,    6964, 21, }, // America/Lower_Princes
    {   10, 8153,    6985,  6, }, // America/Maceio
    {   10, 5805,    6991,  9, }, // America/Martinique
    {   10, 8202,    7000,  8, }, // America/Menominee
    {   10, 8220,    7008,  6, }, // America/Merida
    {   10, 2949,    7014, 17, }, // America/Mexico_City
    {   10, 4391,    7031,  7, }, // America/Miquelon
    {   10, 8254,    7038,  7, }, // America/Moncton
    {   10, 8270,    7045,  9, }, // America/Monterrey
    {   10, 5824,    7054,  9, }, // America/Montserrat
    {   10, 5481,    7063,  5, }, // America/Nassau
    {   10, 2379,    7068,  8, }, // America/New_York
    {   10, 1850,    7076,  7, }, // America/Noronha
    {   10, 8301,    7083, 22, }, // America/North_Dakota/Beulah
    {   10, 8329,    7105, 23, }, // America/North_Dakota/Center
    {   10, 8357,    7128, 26, }, // America/North_Dakota/New_Salem
    {   10,  393,    7154,  4, }, // America/Nuuk
    {   10, 8388,    7158,  7, }, // America/Ojinaga
    {   10, 2973,    7165,  6, }, // America/Phoenix
    {   10, 3945,    7171, 12, }, // America/Port-au-Prince
    {   10, 8404,    7183, 11, }, // America/Porto_Velho
    {   10, 5843,    7194, 10, }, // America/Puerto_Rico
    {   10, 4030,    7204, 12, }, // America/Punta_Arenas
    {   10, 8424,    7216, 11, }, // America/Rankin_Inlet
    {   10, 1995,    7227,  7, }, // America/Regina
    {   10,  695,    7234, 10, }, // America/Rio_Branco
    {   10, 6111,    7244, 13, }, // America/Santo_Domingo
    {   10, 1878,    7257,  9, }, // America/Sao_Paulo
    {   10, 6899,    7266, 12, }, // America/Scoresbysund
    {   10, 8508,    7278, 13, }, // America/St_Barthelemy
    {   10, 2061,    7291,  9, }, // America/St_Johns
    {   10, 5863,    7300,  9, }, // America/St_Kitts
    {   10, 5880,    7309, 10, }, // America/St_Lucia
    {   10,  855,    7319, 10, }, // America/St_Thomas
    {   10, 5913,    7329, 12, }, // America/St_Vincent
    {   10, 8530,    7341, 15, }, // America/Swift_Current
    {   10, 5461,    5410, 11, }, // America/Tegucigalpa
    {   10, 5756,    7356,  5, }, // America/Thule
    {   10,  313,    7361,  7, }, // America/Tijuana
    {   10, 5688,    7368,  7, }, // America/Tortola
    {   10, 2093,    7375,  8, }, // America/Vancouver
    {   10, 2144,    7383,  9, }, // America/Whitehorse
    {   10,  734,    7392,  7, }, // America/Winnipeg
    {   10, 8552,    7399,  7, }, // America/Yakutat
    {   10, 6001,    7406,  5, }, // Antarctica/Casey
    {   10, 6094,    7411,  6, }, // Antarctica/Davis
    {   10, 6133,    7417, 15, }, // Antarctica/DumontDUrville
    {   10, 8568,    7432,  7, }, // Antarctica/Macquarie
    {   10, 7066,    7439,  6, }, // Antarctica/Mawson
    {   10, 7113,    7445,  8, }, // Antarctica/McMurdo
    {   10, 7226,    7453,  7, }, // Antarctica/Rothera
    {   10, 7295,    7460,  5, }, // Antarctica/Syowa
    {   10, 1429,    7465, 11, }, // Arctic/Longyearbyen
    {   10, 5395,    7476,  6, }, // Asia/Almaty
    {   10, 3968,    5487,  4, }, // Asia/Amman
    {   10, 5511,    7482,  6, }, // Asia/Anadyr
    {   10, 5523,    5491,  5, }, // Asia/Aqtau
    {   10, 5368,    7488,  6, }, // Asia/Aqtobe
    {   10, 8624,    7494,  6, }, // Asia/Atyrau
    {   10, 3607,    4044,  6, }, // Asia/Baghdad
    {   10, 5534,    7500,  7, }, // Asia/Bahrain
    {   10, 4086,    7507,  6, }, // Asia/Beirut
    {   10, 4601,    7513,  4, }, // Asia/Chita
    {   10, 4511,    5519,  7, }, // Asia/Colombo
    {   10, 4540,    4083,  6, }, // Asia/Damascus
    {   10, 1093,    4599,  4, }, // Asia/Dhaka
    {   10, 8636,    7517,  9, }, // Asia/Famagusta
    {   10, 1259,    7526,  9, }, // Asia/Ho_Chi_Minh
    {   10, 2704,    7535,  9, }, // Asia/Hong_Kong
    {   10, 7006,    7544,  8, }, // Asia/Jakarta
    {   10, 6992,    7552,  9, }, // Asia/Jayapura
    {   10, 4316,    7561,  8, }, // Asia/Kamchatka
    {   10, 4239,    7569,  6, }, // Asia/Karachi
    {   10, 1185,    5593,  8, }, // Asia/Kathmandu
    {   10, 8661,    7575,  7, }, // Asia/Khandyga
    {   10,  992,    7582,  7, }, // Asia/Kolkata
    {   10, 4197,    4170, 11, }, // Asia/Krasnoyarsk
    {   10, 4859,    7589, 12, }, // Asia/Kuala_Lumpur
    {   10, 5976,    7601,  6, }, // Asia/Kuching
    {   10, 5547,    7607,  6, }, // Asia/Kuwait
    {   10, 1211,    7613,  5, }, // Asia/Macau
    {   10, 1349,    7618,  7, }, // Asia/Makassar
    {   10, 7182,    7625,  6, }, // Asia/Manila
    {   10, 6920,    4208,  6, }, // Asia/Muscat
    {   10, 2554,    7631,  7, }, // Asia/Nicosia
    {   10, 6961,    7638,  8, }, // Asia/Phnom_Penh
    {   10, 4214,    7646,  6, }, // Asia/Pyongyang
    {   10, 5559,    4214,  5, }, // Asia/Qatar
    {   10, 8708,    7652,  8, }, // Asia/Qostanay
    {   10, 4269,    7660,  9, }, // Asia/Qyzylorda
    {   10, 3584,    7669,  4, }, // Asia/Riyadh
    {   10, 4408,    7673,  7, }, // Asia/Sakhalin
    {   10, 3279,    7680,  4, }, // Asia/Seoul
    {   10, 1053,    7684,  7, }, // Asia/Shanghai
    {   10, 3300,    7691,  8, }, // Asia/Singapore
    {   10, 4297,    7699, 13, }, // Asia/Srednekolymsk
    {   10, 3263,    7712,  6, }, // Asia/Taipei
    {   10, 3915,    7718,  6, }, // Asia/Tbilisi
    {   10, 2772,    7724,  7, }, // Asia/Tehran
    {   10, 1317,    7731,  6, }, // Asia/Thimphu
    {   10, 2821,    4238,  5, }, // Asia/Tokyo
    {   10, 1021,    7737,  9, }, // Asia/Ulaanbaatar
    {   10, 6977,    7746,  9, }, // Asia/Vientiane
    {   10, 4828,    7755,  7, }, // Asia/Yakutsk
    {   10, 1235,    7762,  6, }, // Asia/Yangon
    {   10, 3883,    7768, 12, }, // Asia/Yekaterinburg
    {   10, 3747,    7780,  7, }, // Asia/Yerevan
    {   10, 3663,    7787,  5, }, // Atlantic/Azores
    {   10, 5671,    7792,  7, }, // Atlantic/Bermuda
    {   10, 6628,    4280,  6, }, // Atlantic/Canary
    {   10, 3727,    7799, 14, }, // Atlantic/Cape_Verde
    {   10, 1395,     448,  5, }, // Atlantic/Faroe
    {   10, 2748,    7813,  9, }, // Atlantic/Reykjavik
    {   10, 7272,    7822, 15, }, // Atlantic/South_Georgia
    {   10, 6821,    7837, 10, }, // Atlantic/St_Helena
    {   10, 6644,    7847,  6, }, // Atlantic/Stanley
    {   10, 1670,    7853,  8, }, // Australia/Adelaide
    {   10, 1635,    7861,  8, }, // Australia/Brisbane
    {   10, 1799,    7869, 11, }, // Australia/Broken_Hill
    {   10, 1583,    7880,  6, }, // Australia/Darwin
    {   10, 3637,    5746,  5, }, // Australia/Eucla
    {   10, 8753,    7886,  8, }, // Australia/Lindeman
    {   10, 1547,    7894,  9, }, // Australia/Lord_Howe
    {   10, 1727,    7903,  7, }, // Australia/Melbourne
    {   10, 1762,    7910,  5, }, // Australia/Perth
    {   10, 1463,    7915,  6, }, // Australia/Sydney
    {   10, 6216,    7921,  7, }, // Europe/Andorra
    {   10, 3620,    7928,  8, }, // Europe/Astrakhan
    {   10, 2300,    7936,  6, }, // Europe/Athens
    {   10, 6336,    7942,  7, }, // Europe/Belgrade
    {   10, 6488,    7949, 10, }, // Europe/Bratislava
    {   10, 2167,    7959,  7, }, // Europe/Brussels
    {   10, 3928,    7966,  9, }, // Europe/Bucharest
    {   10, 2583,    7975,  8, }, // Europe/Chisinau
    {   10, 6289,    4357, 10, }, // Europe/Copenhagen
    {   10, 6307,    7983, 10, }, // Europe/Gibraltar
    {   10, 8788,    7993,  7, }, // Europe/Guernsey
    {   10, 8804,    8000, 15, }, // Europe/Isle_of_Man
    {   10, 1130,    8015,  8, }, // Europe/Istanbul
    {   10, 8823,    8023,  7, }, // Europe/Jersey
    {   10, 2527,    8030,  4, }, // Europe/Kyiv
    {   10, 3213,    8034,  7, }, // Europe/Lisbon
    {   10, 6506,    8041,  7, }, // Europe/Ljubljana
    {   10, 2501,    8048,  6, }, // Europe/London
    {   10, 6365,    8054, 10, }, // Europe/Luxembourg
    {   10, 6397,    8064,  5, }, // Europe/Malta
    {   10, 6410,    5926,  6, }, // Europe/Monaco
    {   10, 3537,    8069,  5, }, // Europe/Moscow
    {   10, 6424,    8074,  9, }, // Europe/Podgorica
    {   10, 6275,    8083,  5, }, // Europe/Prague
    {   10, 8837,    8088,  4, }, // Europe/Riga
    {   10, 6324,    8092,  4, }, // Europe/Rome
    {   10, 6470,    8096, 10, }, // Europe/San_Marino
    {   10, 6245,    8106,  8, }, // Europe/Sarajevo
    {   10, 6383,    8114,  5, }, // Europe/Skopje
    {   10, 6599,    8119,  5, }, // Europe/Sofia
    {   10, 6523,    8124,  8, }, // Europe/Stockholm
    {   10, 8867,    8132,  5, }, // Europe/Tallinn
    {   10, 6202,    8137,  6, }, // Europe/Tirane
    {   10, 8882,    8143,  9, }, // Europe/Ulyanovsk
    {   10, 6567,    5978,  7, }, // Europe/Vatican
    {   10, 6231,    8152,  5, }, // Europe/Vienna
    {   10, 3190,    8157,  8, }, // Europe/Warsaw
    {   10, 6540,    8165,  5, }, // Europe/Zurich
    {   10, 6947,    8170,  5, }, // Indian/Chagos
    {   10, 6046,    8175, 12, }, // Indian/Christmas
    {   10, 6063,    4465,  5, }, // Indian/Cocos
    {   10, 5029,    8187,  6, }, // Indian/Comoro
    {   10, 7050,    8193,  7, }, // Indian/Maldives
    {   10, 5098,    8200,  6, }, // Indian/Mayotte
    {   10, 7211,     467,  7, }, // Indian/Reunion
    {   10,  932,    8206,  6, }, // Pacific/Auckland
    {   10, 3706,    8212, 10, }, // Pacific/Bougainville
    {   10, 3015,    8222,  6, }, // Pacific/Chatham
    {   10, 3157,    8228,  3, }, // Pacific/Chuuk
    {   10, 2237,    8231,  6, }, // Pacific/Easter
    {   10, 3902,    8237,  5, }, // Pacific/Fiji
    {   10, 3822,    8242, 11, }, // Pacific/Guadalcanal
    {   10, 2723,    4493,  8, }, // Pacific/Honolulu
    {   10, 3049,    4501,  8, }, // Pacific/Kanton
    {   10, 3998,    8253,  9, }, // Pacific/Kiritimati
    {   10, 7019,    8262,  5, }, // Pacific/Kosrae
    {   10, 2842,    8267, 10, }, // Pacific/Kwajalein
    {   10, 4877,    8277,  6, }, // Pacific/Majuro
    {   10, 4051,    8283,  6, }, // Pacific/Marquesas
    {   10, 8914,    8289,  6, }, // Pacific/Midway
    {   10, 3126,    8295,  9, }, // Pacific/Pago_Pago
    {   10, 7194,    8304,  7, }, // Pacific/Pitcairn
    {   10, 3096,    8311,  7, }, // Pacific/Pohnpei
    {   10, 4807,    8318, 12, }, // Pacific/Port_Moresby
    {   10, 6076,    8330,  9, }, // Pacific/Rarotonga
    {   10, 6712,    8339,  6, }, // Pacific/Tarawa
    {   10, 7392,    8345,  4, }, // Pacific/Wake
    {   10, 7405,    8349,  6, }, // Pacific/Wallis
    {   13, 6788,    8355,  4, }, // Africa/Abidjan Amharic/Ethiopic/Ethiopia
    {   13, 6760,    8359,  3, }, // Africa/Accra
    {   13, 5059,    8362,  7, }, // Africa/Addis_Ababa
    {   13, 7420,    8369,  5, }, // Africa/Algiers
    {   13,   14,    8374,  4, }, // Africa/Asmara
    {   13,   44,    8378,  3, }, // Africa/Bamako
    {   13, 5257,    8381,  4, }, // Africa/Bangui
    {   13, 6746,    8385,  4, }, // Africa/Banjul
    {   13, 7435,    8389,  3, }, // Africa/Bissau
    {   13, 4957,    8392,  6, }, // Africa/Blantyre
    {   13, 5287,    8398,  5, }, // Africa/Brazzaville
    {   13, 4922,    8403,  5, }, // Africa/Bujumbura
    {   13, 2320,    8408,  3, }, // Africa/Cairo
    {   13, 4117,    8411,  6, }, // Africa/Casablanca
    {   13, 7449,    8417,  3, }, // Africa/Ceuta
    {   13, 6773,    8420,  4, }, // Africa/Conakry
    {   13, 6840,    8424,  3, }, // Africa/Dakar
    {   13, 5130,    8427,  6, }, // Africa/Dar_es_Salaam
    {   13, 5043,    8433,  3, }, // Africa/Djibouti
    {   13, 5243,    8436,  3, }, // Africa/Douala
    {   13, 5166,    8439,  7, }, // Africa/El_Aaiun
    {   13, 6853,    8446,  5, }, // Africa/Freetown
    {   13, 4906,    8451,  4, }, // Africa/Gaborone
    {   13, 5015,    8455,  3, }, // Africa/Harare
    {   13, 4479,    8458,  7, }, // Africa/Johannesburg
    {   13, 4499,    8465,  2, }, // Africa/Juba
    {   13, 5151,    8467,  4, }, // Africa/Kampala
    {   13, 4524,    8471,  4, }, // Africa/Khartoum
    {   13, 4973,    8475,  3, }, // Africa/Kigali
    {   13, 5306,    8478,  4, }, // Africa/Kinshasa
    {   13, 4744,    8482,  3, }, // Africa/Lagos
    {   13, 5336,    8485,  5, }, // Africa/Libreville
    {   13, 6869,    8490,  2, }, // Africa/Lome
    {   13, 5211,    8492,  4, }, // Africa/Luanda
    {   13, 4939,    8496,  5, }, // Africa/Lubumbashi
    {   13, 5001,    8501,  3, }, // Africa/Lusaka
    {   13, 5322,    8504,  3, }, // Africa/Malabo
    {   13, 4987,    8507,  3, }, // Africa/Maputo
    {   13, 5197,    8510,  3, }, // Africa/Maseru
    {   13, 5182,    8513,  4, }, // Africa/Mbabane
    {   13, 5113,    8517,  4, }, // Africa/Mogadishu
    {   13, 7034,    8521,  5, }, // Africa/Monrovia
    {   13, 3853,    8526,  4, }, // Africa/Nairobi
    {   13, 5271,    8530,  4, }, // Africa/Ndjamena
    {   13, 5354,    8534,  4, }, // Africa/Niamey
    {   13, 6803,    8538,  5, }, // Africa/Nouakchott
    {   13, 6727,    8543,  4, }, // Africa/Ouagadougou
    {   13, 5225,    8547,  8, }, // Africa/Porto-Novo
    {   13, 4435,    8555,  5, }, // Africa/Sao_Tome
    {   13, 2866,    8560,  4, }, // Africa/Tripoli
    {   13, 6554,    8564,  3, }, // Africa/Tunis
    {   13, 4152,    8567,  5, }, // Africa/Windhoek
    {   13,  132,    8572,  3, }, // America/Adak
    {   13, 3346,    8575,  5, }, // America/Anchorage
    {   13, 5607,    8580,  5, }, // America/Anguilla
    {   13, 5624,    8585,  4, }, // America/Antigua
    {   13, 4554,    8589,  5, }, // America/Araguaina
    {   13,  166,    8594,  8, }, // America/Argentina/Buenos_Aires
    {   13,   91,    8602,  5, }, // America/Argentina/Catamarca
    {   13,  270,    8607,  4, }, // America/Argentina/Cordoba
    {   13,  441,    8611,  3, }, // America/Argentina/Jujuy
    {   13, 7462,    8614,  5, }, // America/Argentina/La_Rioja
    {   13,  565,    8619,  4, }, // America/Argentina/Mendoza
    {   13, 7489,    8623,  7, }, // America/Argentina/Rio_Gallegos
    {   13, 7520,    8630,  3, }, // America/Argentina/Salta
    {   13, 7544,    8633,  6, }, // America/Argentina/San_Juan
    {   13, 5580,    8639,  6, }, // America/Argentina/San_Luis
    {   13, 7571,    8645,  4, }, // America/Argentina/Tucuman
    {   13, 7597,    8649,  4, }, // America/Argentina/Ushuaia
    {   13, 5640,    8653,  3, }, // America/Aruba
    {   13, 4252,    8656,  6, }, // America/Asuncion
    {   13,  237,    8662,  5, }, // America/Atikokan
    {   13, 3679,    8667,  3, }, // America/Bahia
    {   13, 7623,    8670,  9, }, // America/Bahia_Banderas
    {   13, 5654,    8679,  5, }, // America/Barbados
    {   13, 7646,    8684,  3, }, // America/Belem
    {   13, 5407,    8687,  3, }, // America/Belize
    {   13, 7660,    8690, 10, }, // America/Blanc-Sablon
    {   13, 7681,    8700,  6, }, // America/Boa_Vista
    {   13, 4361,    8706,  3, }, // America/Bogota
    {   13, 7699,    8709,  3, }, // America/Boise
    {   13, 7713,    8712,  8, }, // America/Cambridge_Bay
    {   13, 7735,    8720,  8, }, // America/Campo_Grande
    {   13, 3868,    8728,  4, }, // America/Cancun
    {   13, 4694,    8732,  4, }, // America/Caracas
    {   13, 4345,    8736,  4, }, // America/Cayenne
    {   13, 5496,    8740,  4, }, // America/Cayman
    {   13, 2260,    8744,  3, }, // America/Chicago
    {   13, 7756,    8747,  5, }, // America/Chihuahua
    {   13, 7774,    8752,  9, }, // America/Ciudad_Juarez
    {   13, 5422,    8761,  5, }, // America/Costa_Rica
    {   13, 7796,    8766,  5, }, // America/Creston
    {   13, 3791,    8771,  4, }, // America/Cuiaba
    {   13, 5723,    8775,  4, }, // America/Curacao
    {   13, 7812,    8779,  8, }, // America/Danmarkshavn
    {   13, 7833,    8787,  4, }, // America/Dawson
    {   13, 7848,    8791,  8, }, // America/Dawson_Creek
    {   13,  805,    8799,  4, }, // America/Denver
    {   13, 3465,    8803,  5, }, // America/Detroit
    {   13, 5739,    8808,  4, }, // America/Dominica
    {   13,  893,    8812,  6, }, // America/Edmonton
    {   13, 7869,    8818,  4, }, // America/Eirunepe
    {   13, 5441,    8822,  7, }, // America/El_Salvador
    {   13, 7886,    8829,  8, }, // America/Fort_Nelson
    {   13, 7906,    8837,  5, }, // America/Fortaleza
    {   13, 7924,    8842,  6, }, // America/Glace_Bay
    {   13, 6881,    8848,  5, }, // America/Goose_Bay
    {   13, 4612,    8853,  8, }, // America/Grand_Turk
    {   13, 5770,    8861,  4, }, // America/Grenada
    {   13, 5786,    8865,  4, }, // America/Guadeloupe
    {   13, 3760,    8869,  4, }, // America/Guatemala
    {   13, 4841,    8873,  5, }, // America/Guayaquil
    {   13, 6932,    8878,  3, }, // America/Guyana
    {   13, 1939,    8881,  5, }, // America/Halifax
    {   13, 2281,    8886,  3, }, // America/Havana
    {   13, 7942,    8889,  5, }, // America/Hermosillo
    {   13,  348,    8894,  8, }, // America/Indiana/Indianapolis
    {   13,  481,    8902, 10, }, // America/Indiana/Knox
    {   13, 7961,    8912, 11, }, // America/Indiana/Marengo
    {   13, 7985,    8923, 14, }, // America/Indiana/Petersburg
    {   13, 8012,    8937, 13, }, // America/Indiana/Tell_City
    {   13, 8038,    8950, 10, }, // America/Indiana/Vevay
    {   13, 8060,    8960, 12, }, // America/Indiana/Vincennes
    {   13, 8086,    8972, 11, }, // America/Indiana/Winamac
    {   13, 8110,    8983,  4, }, // America/Inuvik
    {   13,  660,    8987,  5, }, // America/Iqaluit
    {   13, 2799,    8992,  4, }, // America/Jamaica
    {   13, 5380,    8996,  3, }, // America/Juneau
    {   13,  521,    8999,  5, }, // America/Kentucky/Louisville
    {   13, 8125,    9004, 11, }, // America/Kentucky/Monticello
    {   13, 5704,    9015,  7, }, // America/Kralendijk
    {   13, 4376,    9022,  4, }, // America/La_Paz
    {   13, 7169,    9026,  2, }, // America/Lima
    {   13, 3239,    9028,  8, }, // America/Los_Angeles
    {   13, 5932,    9036, 12, }, // America/Lower_Princes
    {   13, 8153,    9048,  3, }, // America/Maceio
    {   13, 8168,    9051,  4, }, // America/Managua
    {   13, 1908,    9055,  4, }, // America/Manaus
    {   13, 5897,    9059,  4, }, // America/Marigot
    {   13, 5805,    9063,  5, }, // America/Martinique
    {   13, 8184,    9068,  5, }, // America/Matamoros
    {   13, 2917,    9073,  5, }, // America/Mazatlan
    {   13, 8202,    9078,  4, }, // America/Menominee
    {   13, 8220,    9082,  3, }, // America/Merida
    {   13, 8235,    9085,  6, }, // America/Metlakatla
    {   13, 2949,    9091,  8, }, // America/Mexico_City
    {   13, 4391,    9099,  5, }, // America/Miquelon
    {   13, 8254,    9104,  5, }, // America/Moncton
    {   13, 8270,    9109,  6, }, // America/Monterrey
    {   13, 4098,    9115,  6, }, // America/Montevideo
    {   13, 5824,    9121,  6, }, // America/Montserrat
    {   13, 5481,    9127,  3, }, // America/Nassau
    {   13, 2379,    9130,  5, }, // America/New_York
    {   13, 8288,    9135,  2, }, // America/Nome
    {   13, 1850,    9137,  3, }, // America/Noronha
    {   13, 8301,    9140, 13, }, // America/North_Dakota/Beulah
    {   13, 8329,    9153, 14, }, // America/North_Dakota/Center
    {   13, 8357,    9167, 16, }, // America/North_Dakota/New_Salem
    {   13,  393,    9183,  4, }, // America/Nuuk
    {   13, 8388,    9187,  4, }, // America/Ojinaga
    {   13, 2356,    9191,  3, }, // America/Panama
    {   13, 6173,    9194,  5, }, // America/Paramaribo
    {   13, 2973,    9199,  4, }, // America/Phoenix
    {   13, 3945,    9203, 10, }, // America/Port-au-Prince
    {   13, 5954,    9213,  9, }, // America/Port_of_Spain
    {   13, 8404,    9222,  7, }, // America/Porto_Velho
    {   13, 5843,    9229,  5, }, // America/Puerto_Rico
    {   13, 4030,    9234,  8, }, // America/Punta_Arenas
    {   13, 8424,    9242,  9, }, // America/Rankin_Inlet
    {   13, 8445,    9251,  3, }, // America/Recife
    {   13, 1995,    9254,  3, }, // America/Regina
    {   13, 8460,    9257,  5, }, // America/Resolute
    {   13,  695,    9262,  7, }, // America/Rio_Branco
    {   13, 8477,    9269,  5, }, // America/Santarem
    {   13, 2201,    9274,  5, }, // America/Santiago
    {   13, 6111,    9279,  8, }, // America/Santo_Domingo
    {   13, 1878,    9287,  5, }, // America/Sao_Paulo
    {   13, 6899,    9292,  9, }, // America/Scoresbysund
    {   13, 8494,    9301,  3, }, // America/Sitka
    {   13, 8508,    9304, 10, }, // America/St_Barthelemy
    {   13, 2061,    9314,  8, }, // America/St_Johns
    {   13, 5863,    9322,  7, }, // America/St_Kitts
    {   13, 5880,    9329,  8, }, // America/St_Lucia
    {   13,  855,    9337,  7, }, // America/St_Thomas
    {   13, 5913,    9344,  9, }, // America/St_Vincent
    {   13, 8530,    9353,  9, }, // America/Swift_Current
    {   13, 5461,    9362,  6, }, // America/Tegucigalpa
    {   13, 5756,    9368,  2, }, // America/Thule
    {   13,  313,    9370,  4, }, // America/Tijuana
    {   13,  608,    9374,  4, }, // America/Toronto
    {   13, 5688,    9378,  4, }, // America/Tortola
    {   13, 2093,    9382,  5, }, // America/Vancouver
    {   13, 2144,    9387,  6, }, // America/Whitehorse
    {   13,  734,    9393,  4, }, // America/Winnipeg
    {   13, 8552,    9397,  4, }, // America/Yakutat
    {   13, 6001,    9401,  3, }, // Antarctica/Casey
    {   13, 6094,    9404,  3, }, // Antarctica/Davis
    {   13, 6133,    9407, 10, }, // Antarctica/DumontDUrville
    {   13, 8568,    9417,  3, }, // Antarctica/Macquarie
    {   13, 7066,    9420,  4, }, // Antarctica/Mawson
    {   13, 7113,    9424,  5, }, // Antarctica/McMurdo
    {   13, 8589,    9429,  4, }, // Antarctica/Palmer
    {   13, 7226,    9433,  3, }, // Antarctica/Rothera
    {   13, 7295,    9436,  3, }, // Antarctica/Syowa
    {   13, 8607,    9439,  3, }, // Antarctica/Troll
    {   13, 7374,    9442,  4, }, // Antarctica/Vostok
    {   13, 1429,    9446,  8, }, // Arctic/Longyearbyen
    {   13, 5570,    9454,  3, }, // Asia/Aden
    {   13, 5395,    9457,  5, }, // Asia/Almaty
    {   13, 3968,    9462,  3, }, // Asia/Amman
    {   13, 5511,    9465,  5, }, // Asia/Anadyr
    {   13, 5523,    9470,  4, }, // Asia/Aqtau
    {   13, 5368,    9474,  4, }, // Asia/Aqtobe
    {   13,  964,    9478,  5, }, // Asia/Ashgabat
    {   13, 8624,    9483,  5, }, // Asia/Atyrau
    {   13, 3607,    9488,  4, }, // Asia/Baghdad
    {   13, 5534,    9492,  4, }, // Asia/Bahrain
    {   13, 3653,    8774,  2, }, // Asia/Baku
    {   13, 4466,    9496,  4, }, // Asia/Bangkok
    {   13, 3571,    9500,  5, }, // Asia/Barnaul
    {   13, 4086,    9505,  3, }, // Asia/Beirut
    {   13, 3778,    9508,  4, }, // Asia/Bishkek
    {   13, 5989,    9512,  4, }, // Asia/Brunei
    {   13, 4601,    9516,  2, }, // Asia/Chita
    {   13, 4511,    9518,  4, }, // Asia/Colombo
    {   13, 4540,    9522,  4, }, // Asia/Damascus
    {   13, 1093,    8424,  2, }, // Asia/Dhaka
    {   13, 6192,    9526,  2, }, // Asia/Dili
    {   13, 3596,    9528,  3, }, // Asia/Dubai
    {   13, 6159,    9531,  4, }, // Asia/Dushanbe
    {   13, 8636,    9535,  5, }, // Asia/Famagusta
    {   13, 8651,    9540,  2, }, // Asia/Gaza
    {   13, 4795,    9542,  4, }, // Asia/Hebron
    {   13, 1259,    9546, 11, }, // Asia/Ho_Chi_Minh
    {   13, 2704,    9557,  7, }, // Asia/Hong_Kong
    {   13, 4771,    9564,  3, }, // Asia/Hovd
    {   13, 4184,    9567,  6, }, // Asia/Irkutsk
    {   13, 7006,    9573,  4, }, // Asia/Jakarta
    {   13, 6992,    9577,  4, }, // Asia/Jayapura
    {   13, 1290,    9581,  6, }, // Asia/Jerusalem
    {   13, 3560,    9587,  3, }, // Asia/Kabul
    {   13, 4316,    9590,  5, }, // Asia/Kamchatka
    {   13, 4239,    9595,  3, }, // Asia/Karachi
    {   13, 1185,    9598,  5, }, // Asia/Kathmandu
    {   13, 8661,    9603,  4, }, // Asia/Khandyga
    {   13,  992,    9607,  4, }, // Asia/Kolkata
    {   13, 4197,    9611,  8, }, // Asia/Krasnoyarsk
    {   13, 4859,    9619,  8, }, // Asia/Kuala_Lumpur
    {   13, 5976,    9627,  4, }, // Asia/Kuching
    {   13, 5547,    9631,  3, }, // Asia/Kuwait
    {   13, 1211,    9634,  3, }, // Asia/Macau
    {   13, 4017,    9637,  4, }, // Asia/Magadan
    {   13, 1349,    9641,  4, }, // Asia/Makassar
    {   13, 7182,    9645,  3, }, // Asia/Manila
    {   13, 6920,    9648,  4, }, // Asia/Muscat
    {   13, 2554,    9652,  4, }, // Asia/Nicosia
    {   13, 8675,    9656,  7, }, // Asia/Novokuznetsk
    {   13, 4135,    9663,  7, }, // Asia/Novosibirsk
    {   13, 4229,    9670,  4, }, // Asia/Omsk
    {   13, 7145,    9674,  3, }, // Asia/Oral
    {   13, 6961,    9677,  7, }, // Asia/Phnom_Penh
    {   13, 8693,    9684,  6, }, // Asia/Pontianak
    {   13, 4214,    9690,  7, }, // Asia/Pyongyang
    {   13, 5559,    9697,  3, }, // Asia/Qatar
    {   13, 8708,    9700,  5, }, // Asia/Qostanay
    {   13, 4269,    9705,  6, }, // Asia/Qyzylorda
    {   13, 3584,    9711,  3, }, // Asia/Riyadh
    {   13, 4408,    9714,  5, }, // Asia/Sakhalin
    {   13, 7245,    9719,  6, }, // Asia/Samarkand
    {   13, 3279,    9725,  3, }, // Asia/Seoul
    {   13, 1053,    9728,  4, }, // Asia/Shanghai
    {   13, 3300,    9732,  5, }, // Asia/Singapore
    {   13, 4297,    9737, 10, }, // Asia/Srednekolymsk
    {   13, 3263,    9747,  4, }, // Asia/Taipei
    {   13, 4781,    9751,  5, }, // Asia/Tashkent
    {   13, 3915,    9756,  4, }, // Asia/Tbilisi
    {   13, 2772,    9760,  4, }, // Asia/Tehran
    {   13, 1317,    9764,  3, }, // Asia/Thimphu
    {   13, 2821,    9767,  3, }, // Asia/Tokyo
    {   13, 4572,    9770,  4, }, // Asia/Tomsk
    {   13, 1021,    9774,  8, }, // Asia/Ulaanbaatar
    {   13, 1159,    9782,  4, }, // Asia/Urumqi
    {   13, 8722,    9786,  6, }, // Asia/Ust-Nera
    {   13, 6977,    9792,  5, }, // Asia/Vientiane
    {   13, 4710,    9797,  7, }, // Asia/Vladivostok
    {   13, 4828,    9804,  5, }, // Asia/Yakutsk
    {   13, 1235,    9809,  4, }, // Asia/Yangon
    {   13, 3883,    9813,  8, }, // Asia/Yekaterinburg
    {   13, 3747,    9821,  4, }, // Asia/Yerevan
    {   13, 3663,    9825,  4, }, // Atlantic/Azores
    {   13, 5671,    9829,  4, }, // Atlantic/Bermuda
    {   13, 6628,    9833,  3, }, // Atlantic/Canary
    {   13, 3727,    9836,  6, }, // Atlantic/Cape_Verde
    {   13, 1395,    9842,  3, }, // Atlantic/Faroe
    {   13, 8736,    9845,  3, }, // Atlantic/Madeira
    {   13, 2748,    9848,  6, }, // Atlantic/Reykjavik
    {   13, 7272,    9854,  8, }, // Atlantic/South_Georgia
    {   13, 6821,    9862,  8, }, // Atlantic/St_Helena
    {   13, 6644,    9870,  5, }, // Atlantic/Stanley
    {   13, 1670,    9875,  5, }, // Australia/Adelaide
    {   13, 1635,    9880,  5, }, // Australia/Brisbane
    {   13, 1799,    9885,  7, }, // Australia/Broken_Hill
    {   13, 1583,    9892,  4, }, // Australia/Darwin
    {   13, 3637,    9896,  3, }, // Australia/Eucla
    {   13, 1516,    9899,  4, }, // Australia/Hobart
    {   13, 8753,    9903,  5, }, // Australia/Lindeman
    {   13, 1547,    9908,  6, }, // Australia/Lord_Howe
    {   13, 1727,    9914,  5, }, // Australia/Melbourne
    {   13, 1762,    9919,  3, }, // Australia/Perth
    {   13, 1463,    9922,  3, }, // Australia/Sydney
    {   13, 6441,    9925,  7, }, // Europe/Amsterdam
    {   13, 6216,    9932,  4, }, // Europe/Andorra
    {   13, 3620,    9936,  7, }, // Europe/Astrakhan
    {   13, 2300,    9943,  4, }, // Europe/Athens
    {   13, 6336,    9947,  5, }, // Europe/Belgrade
    {   13, 4757,    9952,  4, }, // Europe/Berlin
    {   13, 6488,    9956,  6, }, // Europe/Bratislava
    {   13, 2167,    9962,  5, }, // Europe/Brussels
    {   13, 3928,    9967,  5, }, // Europe/Bucharest
    {   13, 3806,    9972,  5, }, // Europe/Budapest
    {   13, 8772,    9977,  5, }, // Europe/Busingen
    {   13, 2583,    9982,  4, }, // Europe/Chisinau
    {   13, 6289,    9986,  6, }, // Europe/Copenhagen
    {   13, 2338,    9992,  4, }, // Europe/Dublin
    {   13, 6307,    9996,  6, }, // Europe/Gibraltar
    {   13, 8788,   10002,  4, }, // Europe/Guernsey
    {   13, 6612,   10006,  5, }, // Europe/Helsinki
    {   13, 8804,   10011, 10, }, // Europe/Isle_of_Man
    {   13, 1130,   10021,  6, }, // Europe/Istanbul
    {   13, 8823,   10027,  3, }, // Europe/Jersey
    {   13, 3979,   10030,  7, }, // Europe/Kaliningrad
    {   13, 8929,   10037,  3, }, // Europe/Kirov
    {   13, 2527,   10040,  3, }, // Europe/Kyiv
    {   13, 3213,   10043,  4, }, // Europe/Lisbon
    {   13, 6506,   10047,  6, }, // Europe/Ljubljana
    {   13, 2501,   10053,  4, }, // Europe/London
    {   13, 6365,   10057,  7, }, // Europe/Luxembourg
    {   13, 4892,   10064,  4, }, // Europe/Madrid
    {   13, 6397,   10068,  3, }, // Europe/Malta
    {   13, 6582,   10071,  5, }, // Europe/Mariehamn
    {   13, 3693,   10076,  4, }, // Europe/Minsk
    {   13, 6410,   10080,  3, }, // Europe/Monaco
    {   13, 3537,   10083,  3, }, // Europe/Moscow
    {   13, 6458,   10086,  3, }, // Europe/Oslo
    {   13, 4284,   10089,  3, }, // Europe/Paris
    {   13, 6424,   10092,  5, }, // Europe/Podgorica
    {   13, 6275,   10097,  3, }, // Europe/Prague
    {   13, 8837,   10100,  2, }, // Europe/Riga
    {   13, 6324,   10102,  2, }, // Europe/Rome
    {   13, 4331,   10104,  3, }, // Europe/Samara
    {   13, 6470,   10107,  6, }, // Europe/San_Marino
    {   13, 6245,   10113,  4, }, // Europe/Sarajevo
    {   13, 4451,   10117,  4, }, // Europe/Saratov
    {   13, 8849,   10121,  6, }, // Europe/Simferopol
    {   13, 6383,   10127,  4, }, // Europe/Skopje
    {   13, 6599,   10131,  3, }, // Europe/Sofia
    {   13, 6523,   10134,  6, }, // Europe/Stockholm
    {   13, 8867,   10140,  3, }, // Europe/Tallinn
    {   13, 6202,   10143,  3, }, // Europe/Tirane
    {   13, 8882,   10146,  7, }, // Europe/Ulyanovsk
    {   13, 6352,   10153,  3, }, // Europe/Vaduz
    {   13, 6567,   10156,  4, }, // Europe/Vatican
    {   13, 6231,   10160,  3, }, // Europe/Vienna
    {   13, 8899,   10163,  4, }, // Europe/Vilnius
    {   13, 4727,   10167,  5, }, // Europe/Volgograd
    {   13, 3190,   10172,  4, }, // Europe/Warsaw
    {   13, 6261,   10176,  4, }, // Europe/Zagreb
    {   13, 6540,   10180,  3, }, // Europe/Zurich
    {   13, 5078,   10183,  7, }, // Indian/Antananarivo
    {   13, 6947,   10190,  3, }, // Indian/Chagos
    {   13, 6046,   10193,  2, }, // Indian/Christmas
    {   13, 6063,   10195,  3, }, // Indian/Cocos
    {   13, 5029,   10198,  3, }, // Indian/Comoro
    {   13, 6661,   10201,  5, }, // Indian/Kerguelen
    {   13, 7260,   10206,  2, }, // Indian/Mahe
    {   13, 7050,   10208,  4, }, // Indian/Maldives
    {   13, 4069,   10212,  5, }, // Indian/Mauritius
    {   13, 5098,   10217,  3, }, // Indian/Mayotte
    {   13, 7211,   10220,  5, }, // Indian/Reunion
    {   13, 4422,   10225,  3, }, // Pacific/Apia
    {   13,  932,   10228,  5, }, // Pacific/Auckland
    {   13, 3706,   10233,  6, }, // Pacific/Bougainville
    {   13, 3015,   10239,  3, }, // Pacific/Chatham
    {   13, 3157,   10242,  2, }, // Pacific/Chuuk
    {   13, 2237,   10244,  3, }, // Pacific/Easter
    {   13, 7360,   10247,  3, }, // Pacific/Efate
    {   13, 7327,   10250,  4, }, // Pacific/Fakaofo
    {   13, 3902,   10254,  2, }, // Pacific/Fiji
    {   13, 7343,   10256,  4, }, // Pacific/Funafuti
    {   13, 6678,   10260,  5, }, // Pacific/Galapagos
    {   13, 6696,   10265,  5, }, // Pacific/Gambier
    {   13, 3822,   10270,  7, }, // Pacific/Guadalcanal
    {   13, 6018,   10277,  3, }, // Pacific/Guam
    {   13, 2723,   10280,  4, }, // Pacific/Honolulu
    {   13, 3049,   10284,  6, }, // Pacific/Kanton
    {   13, 3998,   10290,  5, }, // Pacific/Kiritimati
    {   13, 7019,   10295,  3, }, // Pacific/Kosrae
    {   13, 2842,   10298,  5, }, // Pacific/Kwajalein
    {   13, 4877,   10303,  3, }, // Pacific/Majuro
    {   13, 4051,   10306,  6, }, // Pacific/Marquesas
    {   13, 8914,   10312,  4, }, // Pacific/Midway
    {   13, 7084,   10316,  3, }, // Pacific/Nauru
    {   13, 7132,   10319,  2, }, // Pacific/Niue
    {   13, 4168,   10321,  5, }, // Pacific/Norfolk
    {   13, 7098,   10326,  4, }, // Pacific/Noumea
    {   13, 3126,   10330,  5, }, // Pacific/Pago_Pago
    {   13, 7155,   10335,  3, }, // Pacific/Palau
    {   13, 7194,   10338,  6, }, // Pacific/Pitcairn
    {   13, 3096,   10344,  4, }, // Pacific/Pohnpei
    {   13, 4807,   10348,  9, }, // Pacific/Port_Moresby
    {   13, 6076,   10357,  5, }, // Pacific/Rarotonga
    {   13, 6031,   10362,  4, }, // Pacific/Saipan
    {   13, 7312,   10366,  3, }, // Pacific/Tahiti
    {   13, 6712,   10369,  3, }, // Pacific/Tarawa
    {   13, 4583,   10372,  5, }, // Pacific/Tongatapu
    {   13, 7392,   10377,  2, }, // Pacific/Wake
    {   13, 7405,   10379,  3, }, // Pacific/Wallis
    {   14, 6788,   10382,  7, }, // Africa/Abidjan Arabic/Arabic/Egypt
    {   14, 6760,   10389,  4, }, // Africa/Accra
    {   14, 5059,   10393, 10, }, // Africa/Addis_Ababa
    {   14, 7420,   10403,  7, }, // Africa/Algiers
    {   14,   14,   10410,  5, }, // Africa/Asmara
    {   14,   44,   10415,  6, }, // Africa/Bamako
    {   14, 5257,   10421,  6, }, // Africa/Bangui
    {   14, 6746,   10427,  6, }, // Africa/Banjul
    {   14, 7435,   10433,  5, }, // Africa/Bissau
    {   14, 4957,   10438,  8, }, // Africa/Blantyre
    {   14, 5287,   10446,  8, }, // Africa/Brazzaville
    {   14, 4922,   10454,  9, }, // Africa/Bujumbura
    {   14, 2320,   10463,  7, }, // Africa/Cairo
    {   14, 4117,   10470, 13, }, // Africa/Casablanca
    {   14, 7449,   10483,  4, }, // Africa/Ceuta
    {   14, 6773,   10487,  7, }, // Africa/Conakry
    {   14, 6840,   10494,  5, }, // Africa/Dakar
    {   14, 5130,   10499, 10, }, // Africa/Dar_es_Salaam
    {   14, 5043,   10509,  6, }, // Africa/Djibouti
    {   14, 5243,   10515,  5, }, // Africa/Douala
    {   14, 5166,   10520,  6, }, // Africa/El_Aaiun
    {   14, 6853,   10526,  8, }, // Africa/Freetown
    {   14, 4906,   10534,  7, }, // Africa/Gaborone
    {   14, 5015,   10541,  5, }, // Africa/Harare
    {   14, 4479,   10546,  9, }, // Africa/Johannesburg
    {   14, 4499,   10555,  4, }, // Africa/Juba
    {   14, 5151,   10559,  7, }, // Africa/Kampala
    {   14, 4524,   10566,  7, }, // Africa/Khartoum
    {   14, 4973,   10573,  6, }, // Africa/Kigali
    {   14, 5306,   10579,  7, }, // Africa/Kinshasa
    {   14, 4744,   10586,  5, }, // Africa/Lagos
    {   14, 5336,   10591,  7, }, // Africa/Libreville
    {   14, 6869,   10598,  4, }, // Africa/Lome
    {   14, 5211,   10602,  6, }, // Africa/Luanda
    {   14, 4939,   10608,  8, }, // Africa/Lubumbashi
    {   14, 5001,   10616,  6, }, // Africa/Lusaka
    {   14, 5322,   10622,  6, }, // Africa/Malabo
    {   14, 4987,   10628,  6, }, // Africa/Maputo
    {   14, 5197,   10634,  6, }, // Africa/Maseru
    {   14, 5182,   10640,  7, }, // Africa/Mbabane
    {   14, 5113,   10647,  7, }, // Africa/Mogadishu
    {   14, 7034,   10654,  8, }, // Africa/Monrovia
    {   14, 3853,   10662,  6, }, // Africa/Nairobi
    {   14, 5271,   10668,  7, }, // Africa/Ndjamena
    {   14, 5354,   10675,  5, }, // Africa/Niamey
    {   14, 6803,   10680,  7, }, // Africa/Nouakchott
    {   14, 6727,   10687,  8, }, // Africa/Ouagadougou
    {   14, 5225,   10695, 10, }, // Africa/Porto-Novo
    {   14, 4435,   10705,  8, }, // Africa/Sao_Tome
    {   14, 2866,   10713,  6, }, // Africa/Tripoli
    {   14, 6554,   10719,  4, }, // Africa/Tunis
    {   14, 4152,   10723,  7, }, // Africa/Windhoek
    {   14,  132,   10730,  4, }, // America/Adak
    {   14, 3346,   10734,  7, }, // America/Anchorage
    {   14, 5607,   10741,  7, }, // America/Anguilla
    {   14, 5624,   10748,  7, }, // America/Antigua
    {   14, 4554,   10755,  9, }, // America/Araguaina
    {   14,  166,   10764, 11, }, // America/Argentina/Buenos_Aires
    {   14,   91,   10775,  9, }, // America/Argentina/Catamarca
    {   14,  270,   10784,  7, }, // America/Argentina/Cordoba
    {   14,  441,   10791,  4, }, // America/Argentina/Jujuy
    {   14, 7462,   10795,  8, }, // America/Argentina/La_Rioja
    {   14,  565,   10803,  7, }, // America/Argentina/Mendoza
    {   14, 7489,   10810, 11, }, // America/Argentina/Rio_Gallegos
    {   14, 7520,   10821,  5, }, // America/Argentina/Salta
    {   14, 7544,   10826,  8, }, // America/Argentina/San_Juan
    {   14, 5580,   10834,  8, }, // America/Argentina/San_Luis
    {   14, 7571,   10842,  6, }, // America/Argentina/Tucuman
    {   14, 7597,   10848,  4, }, // America/Argentina/Ushuaia
    {   14, 5640,   10852,  5, }, // America/Aruba
    {   14, 4252,   10857,  8, }, // America/Asuncion
    {   14,  237,   10865, 11, }, // America/Atikokan
    {   14, 3679,   10876,  5, }, // America/Bahia
    {   14, 7623,   10881, 14, }, // America/Bahia_Banderas
    {   14, 5654,   10895,  7, }, // America/Barbados
    {   14, 7646,   10902,  3, }, // America/Belem
    {   14, 5407,   10905,  4, }, // America/Belize
    {   14, 7660,   10909, 12, }, // America/Blanc-Sablon
    {   14, 7681,   10921,  9, }, // America/Boa_Vista
    {   14, 4361,   10930,  6, }, // America/Bogota
    {   14, 7699,   10936,  4, }, // America/Boise
    {   14, 7713,   10940, 12, }, // America/Cambridge_Bay
    {   14, 7735,   10952, 11, }, // America/Campo_Grande
    {   14, 3868,   10963,  6, }, // America/Cancun
    {   14, 4694,   10969,  7, }, // America/Caracas
    {   14, 4345,   10976,  5, }, // America/Cayenne
    {   14, 5496,   10981,  6, }, // America/Cayman
    {   14, 2260,   10987,  6, }, // America/Chicago
    {   14, 7756,   10993,  7, }, // America/Chihuahua
    {   14, 7774,   11000, 13, }, // America/Ciudad_Juarez
    {   14, 5422,   11013,  9, }, // America/Costa_Rica
    {   14, 7796,   11022,  7, }, // America/Creston
    {   14, 3791,   11029,  5, }, // America/Cuiaba
    {   14, 5723,   11034,  7, }, // America/Curacao
    {   14, 7812,   11041, 11, }, // America/Danmarkshavn
    {   14, 7833,   11052,  6, }, // America/Dawson
    {   14, 7848,   11058, 10, }, // America/Dawson_Creek
    {   14,  805,   11068,  4, }, // America/Denver
    {   14, 3465,   11072,  7, }, // America/Detroit
    {   14, 5739,   11079,  8, }, // America/Dominica
    {   14,  893,   11087,  9, }, // America/Edmonton
    {   14, 7869,   11096,  7, }, // America/Eirunepe
    {   14, 5441,   11103,  9, }, // America/El_Salvador
    {   14, 7886,   11112, 11, }, // America/Fort_Nelson
    {   14, 7906,   11123,  9, }, // America/Fortaleza
    {   14, 7924,   11132,  8, }, // America/Glace_Bay
    {   14, 6881,   11140,  7, }, // America/Goose_Bay
    {   14, 4612,   11147,  9, }, // America/Grand_Turk
    {   14, 5770,   11156,  7, }, // America/Grenada
    {   14, 5786,   11163,  7, }, // America/Guadeloupe
    {   14, 3760,   11170,  9, }, // America/Guatemala
    {   14, 4841,   11179,  9, }, // America/Guayaquil
    {   14, 6932,   11188,  5, }, // America/Guyana
    {   14, 1939,   11193,  8, }, // America/Halifax
    {   14, 2281,   11201,  6, }, // America/Havana
    {   14, 7942,   11207,  9, }, // America/Hermosillo
    {   14,  348,   11216, 12, }, // America/Indiana/Indianapolis
    {   14,  481,   11228,  5, }, // America/Indiana/Knox
    {   14, 7961,   11233,  6, }, // America/Indiana/Marengo
    {   14, 7985,   11239,  8, }, // America/Indiana/Petersburg
    {   14, 8012,   11247, 17, }, // America/Indiana/Tell_City
    {   14, 8038,   11264,  5, }, // America/Indiana/Vevay
    {   14, 8060,   11269,  7, }, // America/Indiana/Vincennes
    {   14, 8086,   11276,  7, }, // America/Indiana/Winamac
    {   14, 8110,   11283,  7, }, // America/Inuvik
    {   14,  660,   11290,  6, }, // America/Iqaluit
    {   14, 2799,   11296,  7, }, // America/Jamaica
    {   14, 5380,   11303,  4, }, // America/Juneau
    {   14,  521,   11307,  8, }, // America/Kentucky/Louisville
    {   14, 8125,   11315,  9, }, // America/Kentucky/Monticello
    {   14, 5704,   11324,  8, }, // America/Kralendijk
    {   14, 4376,   11332,  6, }, // America/La_Paz
    {   14, 7169,   11338,  4, }, // America/Lima
    {   14, 3239,   11342, 10, }, // America/Los_Angeles
    {   14, 5932,   11352, 16, }, // America/Lower_Princes
    {   14, 8153,   11368,  5, }, // America/Maceio
    {   14, 8168,   11373,  7, }, // America/Managua
    {   14, 1908,   11380,  6, }, // America/Manaus
    {   14, 5897,   11386,  7, }, // America/Marigot
    {   14, 5805,   11393, 10, }, // America/Martinique
    {   14, 8184,   11403,  9, }, // America/Matamoros
    {   14, 2917,   11412,  8, }, // America/Mazatlan
    {   14, 8202,   11420,  8, }, // America/Menominee
    {   14, 8220,   11428,  6, }, // America/Merida
    {   14, 8235,   11434, 10, }, // America/Metlakatla
    {   14, 2949,   11444, 11, }, // America/Mexico_City
    {   14, 4391,   11455,  7, }, // America/Miquelon
    {   14, 8254,   11462,  7, }, // America/Moncton
    {   14, 8270,   11469,  7, }, // America/Monterrey
    {   14, 4098,   11476,  9, }, // America/Montevideo
    {   14, 5824,   11485,  9, }, // America/Montserrat
    {   14, 5481,   11494,  4, }, // America/Nassau
    {   14, 2379,   11498,  7, }, // America/New_York
    {   14, 8288,   11422,  3, }, // America/Nome
    {   14, 1850,   11505,  7, }, // America/Noronha
    {   14, 8301,   11512, 22, }, // America/North_Dakota/Beulah
    {   14, 8329,   11534,  4, }, // America/North_Dakota/Center
    {   14, 8357,   11538,  9, }, // America/North_Dakota/New_Salem
    {   14,  393,   11547,  6, }, // America/Nuuk
    {   14, 8388,   11553,  8, }, // America/Ojinaga
    {   14, 2356,   11561,  4, }, // America/Panama
    {   14, 6173,   11565, 10, }, // America/Paramaribo
    {   14, 2973,   11575,  5, }, // America/Phoenix
    {   14, 3945,   11580, 12, }, // America/Port-au-Prince
    {   14, 5954,   11592, 13, }, // America/Port_of_Spain
    {   14, 8404,   11605, 10, }, // America/Porto_Velho
    {   14, 5843,   11615,  9, }, // America/Puerto_Rico
    {   14, 4030,   11624, 12, }, // America/Punta_Arenas
    {   14, 8424,   11636, 10, }, // America/Rankin_Inlet
    {   14, 8445,   11646,  5, }, // America/Recife
    {   14, 1995,   11651,  6, }, // America/Regina
    {   14, 8460,   11657,  7, }, // America/Resolute
    {   14,  695,   11664,  9, }, // America/Rio_Branco
    {   14, 8477,   11673,  8, }, // America/Santarem
    {   14, 2201,   11681,  8, }, // America/Santiago
    {   14, 6111,   11689, 13, }, // America/Santo_Domingo
    {   14, 1878,   11702,  9, }, // America/Sao_Paulo
    {   14, 6899,   11711, 10, }, // America/Scoresbysund
    {   14, 8494,   11721,  5, }, // America/Sitka
    {   14, 8508,   11726, 14, }, // America/St_Barthelemy
    {   14, 2061,   11740,  9, }, // America/St_Johns
    {   14, 5863,   11749,  9, }, // America/St_Kitts
    {   14, 5880,   11758, 10, }, // America/St_Lucia
    {   14,  855,   11768, 10, }, // America/St_Thomas
    {   14, 5913,   11778, 10, }, // America/St_Vincent
    {   14, 8530,   11788, 10, }, // America/Swift_Current
    {   14, 5461,   11798, 11, }, // America/Tegucigalpa
    {   14, 5756,   11809,  3, }, // America/Thule
    {   14,  313,   11812,  7, }, // America/Tijuana
    {   14,  608,   11819,  7, }, // America/Toronto
    {   14, 5688,   11826,  7, }, // America/Tortola
    {   14, 2093,   11833,  7, }, // America/Vancouver
    {   14, 2144,   11840,  9, }, // America/Whitehorse
    {   14,  734,   11849,  7, }, // America/Winnipeg
    {   14, 8552,   11856,  7, }, // America/Yakutat
    {   14, 6001,   11863,  5, }, // Antarctica/Casey
    {   14, 6094,   11868,  5, }, // Antarctica/Davis
    {   14, 6133,   11873, 16, }, // Antarctica/DumontDUrville
    {   14, 8568,   11889,  7, }, // Antarctica/Macquarie
    {   14, 7066,   11896,  6, }, // Antarctica/Mawson
    {   14, 7113,   11902,  9, }, // Antarctica/McMurdo
    {   14, 8589,   11911,  6, }, // Antarctica/Palmer
    {   14, 7226,   11917,  6, }, // Antarctica/Rothera
    {   14, 7295,   11923,  6, }, // Antarctica/Syowa
    {   14, 8607,   11929,  4, }, // Antarctica/Troll
    {   14, 7374,   11933,  6, }, // Antarctica/Vostok
    {   14, 1429,   11939,  9, }, // Arctic/Longyearbyen
    {   14, 5570,   11948,  3, }, // Asia/Aden
    {   14, 5395,   11951,  6, }, // Asia/Almaty
    {   14, 3968,   11957,  5, }, // Asia/Amman
    {   14, 5511,   11962,  5, }, // Asia/Anadyr
    {   14, 5523,   11967,  5, }, // Asia/Aqtau
    {   14, 5368,   11972,  5, }, // Asia/Aqtobe
    {   14,  964,   11977,  8, }, // Asia/Ashgabat
    {   14, 8624,   11985,  6, }, // Asia/Atyrau
    {   14, 3607,   11991,  5, }, // Asia/Baghdad
    {   14, 5534,   11996,  7, }, // Asia/Bahrain
    {   14, 3653,   11032,  4, }, // Asia/Baku
    {   14, 4466,   12003,  6, }, // Asia/Bangkok
    {   14, 3571,   12009,  7, }, // Asia/Barnaul
    {   14, 4086,   12016,  5, }, // Asia/Beirut
    {   14, 3778,   12021,  5, }, // Asia/Bishkek
    {   14, 5989,   12026,  6, }, // Asia/Brunei
    {   14, 4601,   12032,  5, }, // Asia/Chita
    {   14, 4511,   12037,  7, }, // Asia/Colombo
    {   14, 4540,   12044,  4, }, // Asia/Damascus
    {   14, 1093,   10962,  3, }, // Asia/Dhaka
    {   14, 6192,   12048,  4, }, // Asia/Dili
    {   14, 3596,   12052,  3, }, // Asia/Dubai
    {   14, 6159,   12055,  7, }, // Asia/Dushanbe
    {   14, 8636,   12062,  9, }, // Asia/Famagusta
    {   14, 8651,   12071,  3, }, // Asia/Gaza
    {   14, 4795,   12074, 21, }, // Asia/Hebron
    {   14, 1259,   12095, 16, }, // Asia/Ho_Chi_Minh
    {   14, 2704,   12111,  9, }, // Asia/Hong_Kong
    {   14, 4771,   12120,  4, }, // Asia/Hovd
    {   14, 4184,   12124,  8, }, // Asia/Irkutsk
    {   14, 7006,   12132,  6, }, // Asia/Jakarta
    {   14, 6992,   12138,  9, }, // Asia/Jayapura
    {   14, 1290,   12147,  5, }, // Asia/Jerusalem
    {   14, 3560,   12152,  5, }, // Asia/Kabul
    {   14, 4316,   12157,  9, }, // Asia/Kamchatka
    {   14, 4239,   12166,  6, }, // Asia/Karachi
    {   14, 1185,   12172,  8, }, // Asia/Kathmandu
    {   14, 8661,   12180,  7, }, // Asia/Khandyga
    {   14,  992,   12187,  6, }, // Asia/Kolkata
    {   14, 4197,   12193, 11, }, // Asia/Krasnoyarsk
    {   14, 4859,   12204, 12, }, // Asia/Kuala_Lumpur
    {   14, 5976,   12216,  6, }, // Asia/Kuching
    {   14, 5547,   12222,  6, }, // Asia/Kuwait
    {   14, 1211,   12228,  5, }, // Asia/Macau
    {   14, 4017,   12233,  5, }, // Asia/Magadan
    {   14, 1349,   12238,  6, }, // Asia/Makassar
    {   14, 7182,   12244,  6, }, // Asia/Manila
    {   14, 6920,   12250,  4, }, // Asia/Muscat
    {   14, 2554,   12254,  7, }, // Asia/Nicosia
    {   14, 8675,   12261, 11, }, // Asia/Novokuznetsk
    {   14, 4135,   12272, 10, }, // Asia/Novosibirsk
    {   14, 4229,   12282,  5, }, // Asia/Omsk
    {   14, 7145,   12287,  5, }, // Asia/Oral
    {   14, 6961,   12292,  8, }, // Asia/Phnom_Penh
    {   14, 8693,   12300,  8, }, // Asia/Pontianak
    {   14, 4214,   12308, 10, }, // Asia/Pyongyang
    {   14, 5559,   12318,  3, }, // Asia/Qatar
    {   14, 8708,   12321,  8, }, // Asia/Qostanay
    {   14, 4269,   12329,  9, }, // Asia/Qyzylorda
    {   14, 3584,   12338,  6, }, // Asia/Riyadh
    {   14, 4408,   12344,  6, }, // Asia/Sakhalin
    {   14, 7245,   12350,  6, }, // Asia/Samarkand
    {   14, 3279,   12356,  3, }, // Asia/Seoul
    {   14, 1053,   12359,  6, }, // Asia/Shanghai
    {   14, 3300,   12365,  8, }, // Asia/Singapore
    {   14, 4297,   12373, 12, }, // Asia/Srednekolymsk
    {   14, 3263,   12385,  6, }, // Asia/Taipei
    {   14, 4781,   12391,  5, }, // Asia/Tashkent
    {   14, 3915,   12396,  6, }, // Asia/Tbilisi
    {   14, 2772,   12402,  5, }, // Asia/Tehran
    {   14, 1317,   12407,  5, }, // Asia/Thimphu
    {   14, 2821,   12412,  5, }, // Asia/Tokyo
    {   14, 4572,   12417,  5, }, // Asia/Tomsk
    {   14, 1021,   12422,  9, }, // Asia/Ulaanbaatar
    {   14, 1159,   12431,  6, }, // Asia/Urumqi
    {   14, 8722,   12437,  9, }, // Asia/Ust-Nera
    {   14, 6977,   12446,  8, }, // Asia/Vientiane
    {   14, 4710,   12454, 10, }, // Asia/Vladivostok
    {   14, 4828,   12464,  6, }, // Asia/Yakutsk
    {   14, 1235,   12470,  6, }, // Asia/Yangon
    {   14, 3883,   12476, 10, }, // Asia/Yekaterinburg
    {   14, 3747,   12486,  6, }, // Asia/Yerevan
    {   14, 3663,   12492,  5, }, // Atlantic/Azores
    {   14, 5671,   12497,  6, }, // Atlantic/Bermuda
    {   14, 6628,   12503,  5, }, // Atlantic/Canary
    {   14, 3727,   12508, 12, }, // Atlantic/Cape_Verde
    {   14, 1395,   12520,  4, }, // Atlantic/Faroe
    {   14, 8736,   12524,  6, }, // Atlantic/Madeira
    {   14, 2748,   12530,  8, }, // Atlantic/Reykjavik
    {   14, 7272,   12538, 15, }, // Atlantic/South_Georgia
    {   14, 6821,   12553, 11, }, // Atlantic/St_Helena
    {   14, 6644,   12564,  7, }, // Atlantic/Stanley
    {   14, 1670,   12571,  6, }, // Australia/Adelaide
    {   14, 1635,   12577,  7, }, // Australia/Brisbane
    {   14, 1799,   12584,  9, }, // Australia/Broken_Hill
    {   14, 1583,   12593,  5, }, // Australia/Darwin
    {   14, 3637,   12598,  5, }, // Australia/Eucla
    {   14, 1516,   12603,  6, }, // Australia/Hobart
    {   14, 8753,   12609,  7, }, // Australia/Lindeman
    {   14, 1547,   12616,  8, }, // Australia/Lord_Howe
    {   14, 1727,   12624,  7, }, // Australia/Melbourne
    {   14, 1762,   12631,  4, }, // Australia/Perth
    {   14, 1463,   12635,  5, }, // Australia/Sydney
    {   14, 6441,   12640,  8, }, // Europe/Amsterdam
    {   14, 6216,   12648,  6, }, // Europe/Andorra
    {   14, 3620,   12654,  8, }, // Europe/Astrakhan
    {   14, 2300,   12662,  5, }, // Europe/Athens
    {   14, 6336,   12667,  6, }, // Europe/Belgrade
    {   14, 4757,   12673,  5, }, // Europe/Berlin
    {   14, 6488,   12678, 10, }, // Europe/Bratislava
    {   14, 2167,   12688,  6, }, // Europe/Brussels
    {   14, 3928,   12694,  7, }, // Europe/Bucharest
    {   14, 3806,   12701,  7, }, // Europe/Budapest
    {   14, 8772,   12708,  6, }, // Europe/Busingen
    {   14, 2583,   12714,  8, }, // Europe/Chisinau
    {   14, 6289,   12722,  8, }, // Europe/Copenhagen
    {   14, 2338,   12730,  4, }, // Europe/Dublin
    {   14, 6307,   12734,  8, }, // Europe/Gibraltar
    {   14, 8788,   12742,  6, }, // Europe/Guernsey
    {   14, 6612,   12748,  6, }, // Europe/Helsinki
    {   14, 8804,   12754,  9, }, // Europe/Isle_of_Man
    {   14, 1130,   12763,  7, }, // Europe/Istanbul
    {   14, 8823,   12770,  5, }, // Europe/Jersey
    {   14, 3979,   12775,  9, }, // Europe/Kaliningrad
    {   14, 8929,   12784,  5, }, // Europe/Kirov
    {   14, 2527,   12789,  4, }, // Europe/Kyiv
    {   14, 3213,   12793,  6, }, // Europe/Lisbon
    {   14, 6506,   12799,  9, }, // Europe/Ljubljana
    {   14, 2501,   12808,  4, }, // Europe/London
    {   14, 6365,   12812,  9, }, // Europe/Luxembourg
    {   14, 4892,   12821,  5, }, // Europe/Madrid
    {   14, 6397,   12826,  5, }, // Europe/Malta
    {   14, 6582,   12831,  8, }, // Europe/Mariehamn
    {   14, 3693,   12839,  5, }, // Europe/Minsk
    {   14, 6410,   12844,  6, }, // Europe/Monaco
    {   14, 3537,   12850,  5, }, // Europe/Moscow
    {   14, 6458,   12855,  5, }, // Europe/Oslo
    {   14, 4284,   12860,  5, }, // Europe/Paris
    {   14, 6424,   12865,  9, }, // Europe/Podgorica
    {   14, 6275,   12874,  4, }, // Europe/Prague
    {   14, 8837,   12878,  4, }, // Europe/Riga
    {   14, 6324,   12522,  4, }, // Europe/Rome
    {   14, 4331,   12882,  5, }, // Europe/Samara
    {   14, 6470,   12887, 10, }, // Europe/San_Marino
    {   14, 6245,   12897,  7, }, // Europe/Sarajevo
    {   14, 4451,   12904,  7, }, // Europe/Saratov
    {   14, 8849,   12911,  9, }, // Europe/Simferopol
    {   14, 6383,   12920,  5, }, // Europe/Skopje
    {   14, 6599,   12925,  5, }, // Europe/Sofia
    {   14, 6523,   12930,  8, }, // Europe/Stockholm
    {   14, 8867,   12938,  5, }, // Europe/Tallinn
    {   14, 6202,   12943,  6, }, // Europe/Tirane
    {   14, 8882,   12949, 10, }, // Europe/Ulyanovsk
    {   14, 6352,   12959,  5, }, // Europe/Vaduz
    {   14, 6567,   12964,  9, }, // Europe/Vatican
    {   14, 6231,   12973,  5, }, // Europe/Vienna
    {   14, 8899,   12978,  7, }, // Europe/Vilnius
    {   14, 4727,   12985,  8, }, // Europe/Volgograd
    {   14, 3190,   12993,  5, }, // Europe/Warsaw
    {   14, 6261,   12998,  4, }, // Europe/Zagreb
    {   14, 6540,   13002,  5, }, // Europe/Zurich
    {   14, 5078,   13007, 12, }, // Indian/Antananarivo
    {   14, 6947,   13019,  6, }, // Indian/Chagos
    {   14, 6046,   13025,  7, }, // Indian/Christmas
    {   14, 6063,   13032,  5, }, // Indian/Cocos
    {   14, 5029,   13037,  9, }, // Indian/Comoro
    {   14, 6661,   13046,  9, }, // Indian/Kerguelen
    {   14, 7260,   13055,  4, }, // Indian/Mahe
    {   14, 7050,   13059,  8, }, // Indian/Maldives
    {   14, 4069,   13067,  8, }, // Indian/Mauritius
    {   14, 5098,   13075,  5, }, // Indian/Mayotte
    {   14, 7211,   13080,  7, }, // Indian/Reunion
    {   14, 4422,   13087,  4, }, // Pacific/Apia
    {   14,  932,   13091,  7, }, // Pacific/Auckland
    {   14, 3706,   13098,  8, }, // Pacific/Bougainville
    {   14, 3015,   13106,  6, }, // Pacific/Chatham
    {   14, 3157,   11153,  3, }, // Pacific/Chuuk
    {   14, 2237,   13112,  4, }, // Pacific/Easter
    {   14, 7360,   13116,  5, }, // Pacific/Efate
    {   14, 7327,   13121,  7, }, // Pacific/Fakaofo
    {   14, 3902,   13128,  4, }, // Pacific/Fiji
    {   14, 7343,   13132,  8, }, // Pacific/Funafuti
    {   14, 6678,   13140,  8, }, // Pacific/Galapagos
    {   14, 6696,   13148,  6, }, // Pacific/Gambier
    {   14, 3822,   13154, 11, }, // Pacific/Guadalcanal
    {   14, 6018,   11377,  4, }, // Pacific/Guam
    {   14, 2723,   13165,  8, }, // Pacific/Honolulu
    {   14, 3049,   13173,  8, }, // Pacific/Kanton
    {   14, 3998,   13181, 11, }, // Pacific/Kiritimati
    {   14, 7019,   13192,  5, }, // Pacific/Kosrae
    {   14, 2842,   13197,  8, }, // Pacific/Kwajalein
    {   14, 4877,   13205,  6, }, // Pacific/Majuro
    {   14, 4051,   13211,  8, }, // Pacific/Marquesas
    {   14, 8914,   13219,  6, }, // Pacific/Midway
    {   14, 7084,   13225,  5, }, // Pacific/Nauru
    {   14, 7132,   11498,  4, }, // Pacific/Niue
    {   14, 4168,   13230,  7, }, // Pacific/Norfolk
    {   14, 7098,   13237,  5, }, // Pacific/Noumea
    {   14, 3126,   13242,  9, }, // Pacific/Pago_Pago
    {   14, 7155,   13251,  5, }, // Pacific/Palau
    {   14, 7194,   13256,  7, }, // Pacific/Pitcairn
    {   14, 3096,   13263,  5, }, // Pacific/Pohnpei
    {   14, 4807,   13268, 10, }, // Pacific/Port_Moresby
    {   14, 6076,   13278,  9, }, // Pacific/Rarotonga
    {   14, 6031,   13287,  6, }, // Pacific/Saipan
    {   14, 7312,   13293,  6, }, // Pacific/Tahiti
    {   14, 6712,   13299,  6, }, // Pacific/Tarawa
    {   14, 4583,   13305,  9, }, // Pacific/Tongatapu
    {   14, 7392,   10681,  3, }, // Pacific/Wake
    {   14, 7405,   13314,  5, }, // Pacific/Wallis
    {   42,   14,       0,  6, }, // Africa/Asmara Aragonese/Latin/Spain
    {   42, 4435,       6,  8, }, // Africa/Sao_Tome
    {   42, 4252,      14,  8, }, // America/Asuncion
    {   42,  237,      22,  8, }, // America/Atikokan
    {   42, 7623,      30, 17, }, // America/Bahia_Banderas
    {   42, 3868,      47,  6, }, // America/Cancun
    {   42, 7774,      53, 13, }, // America/Ciudad_Juarez
    {   42, 5723,      66,  7, }, // America/Curacao
    {   42,  481,      73, 13, }, // America/Indiana/Knox
    {   42, 7961,      86, 16, }, // America/Indiana/Marengo
    {   42, 7985,     102, 19, }, // America/Indiana/Petersburg
    {   42, 8012,     121, 18, }, // America/Indiana/Tell_City
    {   42, 8038,     139, 14, }, // America/Indiana/Vevay
    {   42, 8060,     153, 18, }, // America/Indiana/Vincennes
    {   42, 8086,     171, 16, }, // America/Indiana/Winamac
    {   42, 8125,     187, 20, }, // America/Kentucky/Monticello
    {   42, 5932,     207, 22, }, // America/Lower_Princes
    {   42, 8220,     229,  6, }, // America/Merida
    {   42, 8301,     235, 20, }, // America/North_Dakota/Beulah
    {   42, 8329,     255, 20, }, // America/North_Dakota/Center
    {   42, 8357,     275, 23, }, // America/North_Dakota/New_Salem
    {   42,  393,     298,  4, }, // America/Nuuk
    {   42, 6899,     302, 16, }, // America/Scoresbysund
    {   42, 8508,     318, 14, }, // America/St_Barthelemy
    {   42, 2061,     332, 10, }, // America/St_Johns
    {   42, 5863,     342,  9, }, // America/St_Kitts
    {   42, 5880,     351,  9, }, // America/St_Lucia
    {   42,  855,     360, 10, }, // America/St_Thomas
    {   42, 5913,     370, 11, }, // America/St_Vincent
    {   42, 6133,     381, 16, }, // Antarctica/DumontDUrville
    {   42, 1259,     397, 11, }, // Asia/Ho_Chi_Minh
    {   42, 1185,     413,  9, }, // Asia/Kathmandu
    {   42,  992,     422,  7, }, // Asia/Kolkata
    {   42, 1211,    4203,  5, }, // Asia/Macau
    {   42, 1235,     442,  6, }, // Asia/Yangon
    {   42, 1395,     448,  5, }, // Atlantic/Faroe
    {   42, 6821,     453, 10, }, // Atlantic/St_Helena
    {   42, 2527,     463,  4, }, // Europe/Kyiv
    {   42, 7211,     467,  7, }, // Indian/Reunion
    {   42, 3157,     474,  5, }, // Pacific/Chuuk
    {   42, 3096,     479,  7, }, // Pacific/Pohnpei
    {   43, 6788,   13319,  6, }, // Africa/Abidjan Armenian/Armenian/Armenia
    {   43, 6760,   13325,  4, }, // Africa/Accra
    {   43, 5059,   13329, 10, }, // Africa/Addis_Ababa
    {   43, 7420,   13339,  5, }, // Africa/Algiers
    {   43,   14,   13344,  6, }, // Africa/Asmara
    {   43,   44,   13350,  6, }, // Africa/Bamako
    {   43, 5257,   13356,  5, }, // Africa/Bangui
    {   43, 6746,   13361,  7, }, // Africa/Banjul
    {   43, 7435,   13368,  6, }, // Africa/Bissau
    {   43, 4957,   13374,  8, }, // Africa/Blantyre
    {   43, 5287,   13382,  8, }, // Africa/Brazzaville
    {   43, 4922,   13390, 12, }, // Africa/Bujumbura
    {   43, 2320,   13402,  6, }, // Africa/Cairo
    {   43, 4117,   13408, 10, }, // Africa/Casablanca
    {   43, 7449,   13418,  6, }, // Africa/Ceuta
    {   43, 6773,   13424,  7, }, // Africa/Conakry
    {   43, 6840,   13431,  5, }, // Africa/Dakar
    {   43, 5130,   13436, 12, }, // Africa/Dar_es_Salaam
    {   43, 5043,   13448,  7, }, // Africa/Djibouti
    {   43, 5243,   13455,  6, }, // Africa/Douala
    {   43, 5166,   13461,  8, }, // Africa/El_Aaiun
    {   43, 6853,   13469,  8, }, // Africa/Freetown
    {   43, 4906,   13477,  8, }, // Africa/Gaborone
    {   43, 5015,   13485,  6, }, // Africa/Harare
    {   43, 4479,   13491, 12, }, // Africa/Johannesburg
    {   43, 4499,   13503,  5, }, // Africa/Juba
    {   43, 5151,   13508,  7, }, // Africa/Kampala
    {   43, 4524,   13515,  7, }, // Africa/Khartoum
    {   43, 4973,   13522,  6, }, // Africa/Kigali
    {   43, 5306,   13528,  7, }, // Africa/Kinshasa
    {   43, 4744,   13535,  5, }, // Africa/Lagos
    {   43, 5336,   13540,  7, }, // Africa/Libreville
    {   43, 6869,   13547,  4, }, // Africa/Lome
    {   43, 5211,   13551,  7, }, // Africa/Luanda
    {   43, 4939,   13558, 11, }, // Africa/Lubumbashi
    {   43, 5001,   13569,  7, }, // Africa/Lusaka
    {   43, 5322,   13576,  6, }, // Africa/Malabo
    {   43, 4987,   13582,  8, }, // Africa/Maputo
    {   43, 5197,   13590,  7, }, // Africa/Maseru
    {   43, 5182,   13597,  7, }, // Africa/Mbabane
    {   43, 5113,   13604,  8, }, // Africa/Mogadishu
    {   43, 7034,   13612,  8, }, // Africa/Monrovia
    {   43, 3853,   13620,  7, }, // Africa/Nairobi
    {   43, 5271,   13627,  7, }, // Africa/Ndjamena
    {   43, 5354,   13634,  6, }, // Africa/Niamey
    {   43, 6803,   13640,  8, }, // Africa/Nouakchott
    {   43, 6727,   13648, 11, }, // Africa/Ouagadougou
    {   43, 5225,   13659, 10, }, // Africa/Porto-Novo
    {   43, 4435,   13669,  8, }, // Africa/Sao_Tome
    {   43, 2866,   13677,  7, }, // Africa/Tripoli
    {   43, 6554,   13684,  6, }, // Africa/Tunis
    {   43, 4152,   13690,  8, }, // Africa/Windhoek
    {   43,  132,   13698,  9, }, // America/Adak
    {   43, 3346,   13707,  7, }, // America/Anchorage
    {   43, 5607,   13714,  8, }, // America/Anguilla
    {   43, 5624,   13722,  8, }, // America/Antigua
    {   43, 4554,   13730, 10, }, // America/Araguaina
    {   43,  166,   13740, 13, }, // America/Argentina/Buenos_Aires
    {   43,   91,   13753,  9, }, // America/Argentina/Catamarca
    {   43,  270,   13762,  7, }, // America/Argentina/Cordoba
    {   43,  441,   13769,  7, }, // America/Argentina/Jujuy
    {   43, 7462,   13776,  8, }, // America/Argentina/La_Rioja
    {   43,  565,   13784,  7, }, // America/Argentina/Mendoza
    {   43, 7489,   13791, 12, }, // America/Argentina/Rio_Gallegos
    {   43, 7520,   13803,  5, }, // America/Argentina/Salta
    {   43, 7544,   13808,  9, }, // America/Argentina/San_Juan
    {   43, 5580,   13817,  9, }, // America/Argentina/San_Luis
    {   43, 7571,   13826,  9, }, // America/Argentina/Tucuman
    {   43, 7597,   13835,  8, }, // America/Argentina/Ushuaia
    {   43, 5640,   13843,  6, }, // America/Aruba
    {   43, 4252,   13849,  9, }, // America/Asuncion
    {   43,  237,   13858,  8, }, // America/Atikokan
    {   43, 3679,   13866,  5, }, // America/Bahia
    {   43, 7623,   13871, 14, }, // America/Bahia_Banderas
    {   43, 5654,   13885,  8, }, // America/Barbados
    {   43, 7646,   13893,  5, }, // America/Belem
    {   43, 5407,   13898,  5, }, // America/Belize
    {   43, 7660,   13903, 12, }, // America/Blanc-Sablon
    {   43, 7681,   13915,  9, }, // America/Boa_Vista
    {   43, 4361,   13924,  6, }, // America/Bogota
    {   43, 7699,   13930,  5, }, // America/Boise
    {   43, 7713,   13935, 11, }, // America/Cambridge_Bay
    {   43, 7735,   13946, 13, }, // America/Campo_Grande
    {   43, 3868,   13959,  7, }, // America/Cancun
    {   43, 4694,   13966,  7, }, // America/Caracas
    {   43, 4345,   13973,  5, }, // America/Cayenne
    {   43, 5496,   13978, 14, }, // America/Cayman
    {   43, 2260,   13992,  6, }, // America/Chicago
    {   43, 7756,   13998,  8, }, // America/Chihuahua
    {   43, 7774,   14006, 15, }, // America/Ciudad_Juarez
    {   43, 5422,   14021, 10, }, // America/Costa_Rica
    {   43, 7796,   14031,  7, }, // America/Creston
    {   43, 3791,   14038,  7, }, // America/Cuiaba
    {   43, 5723,   14045,  9, }, // America/Curacao
    {   43, 7812,   14054, 12, }, // America/Danmarkshavn
    {   43, 7833,   14066,  7, }, // America/Dawson
    {   43, 7848,   14073, 12, }, // America/Dawson_Creek
    {   43,  805,   14085,  6, }, // America/Denver
    {   43, 3465,   14091,  7, }, // America/Detroit
    {   43, 5739,   14098,  8, }, // America/Dominica
    {   43,  893,   14106,  8, }, // America/Edmonton
    {   43, 7869,   14114,  9, }, // America/Eirunepe
    {   43, 5441,   14123,  8, }, // America/El_Salvador
    {   43, 7886,   14131, 11, }, // America/Fort_Nelson
    {   43, 7906,   14142,  9, }, // America/Fortaleza
    {   43, 7924,   14151,  9, }, // America/Glace_Bay
    {   43, 6881,   14160,  8, }, // America/Goose_Bay
    {   43, 4612,   14168, 11, }, // America/Grand_Turk
    {   43, 5770,   14179,  7, }, // America/Grenada
    {   43, 5786,   14186, 10, }, // America/Guadeloupe
    {   43, 3760,   14196,  9, }, // America/Guatemala
    {   43, 4841,   14205,  9, }, // America/Guayaquil
    {   43, 6932,   14214,  6, }, // America/Guyana
    {   43, 1939,   14220,  8, }, // America/Halifax
    {   43, 2281,   14228,  6, }, // America/Havana
    {   43, 7942,   14234,  9, }, // America/Hermosillo
    {   43,  348,   14243, 12, }, // America/Indiana/Indianapolis
    {   43,  481,   14255, 13, }, // America/Indiana/Knox
    {   43, 7961,   14268, 16, }, // America/Indiana/Marengo
    {   43, 7985,   14284, 20, }, // America/Indiana/Petersburg
    {   43, 8012,   14304, 17, }, // America/Indiana/Tell_City
    {   43, 8038,   14321, 14, }, // America/Indiana/Vevay
    {   43, 8060,   14335, 16, }, // America/Indiana/Vincennes
    {   43, 8086,   14351, 16, }, // America/Indiana/Winamac
    {   43, 8110,   14367,  7, }, // America/Inuvik
    {   43,  660,   14374,  8, }, // America/Iqaluit
    {   43, 2799,   14382,  7, }, // America/Jamaica
    {   43, 5380,   14389,  5, }, // America/Juneau
    {   43,  521,   14394,  8, }, // America/Kentucky/Louisville
    {   43, 8125,   14402, 19, }, // America/Kentucky/Monticello
    {   43, 5704,   14421, 10, }, // America/Kralendijk
    {   43, 4376,   14431,  6, }, // America/La_Paz
    {   43, 7169,   14437,  4, }, // America/Lima
    {   43, 3239,   14441, 11, }, // America/Los_Angeles
    {   43, 5932,   14452, 22, }, // America/Lower_Princes
    {   43, 8153,   14474,  6, }, // America/Maceio
    {   43, 8168,   14480,  8, }, // America/Managua
    {   43, 1908,   14488,  7, }, // America/Manaus
    {   43, 5897,   14495,  6, }, // America/Marigot
    {   43, 5805,   14501,  9, }, // America/Martinique
    {   43, 8184,   14510,  9, }, // America/Matamoros
    {   43, 2917,   14519,  8, }, // America/Mazatlan
    {   43, 8202,   14527,  8, }, // America/Menominee
    {   43, 8220,   14535,  6, }, // America/Merida
    {   43, 8235,   14541, 10, }, // America/Metlakatla
    {   43, 2949,   14551,  6, }, // America/Mexico_City
    {   43, 4391,   14557,  7, }, // America/Miquelon
    {   43, 8254,   14564,  7, }, // America/Moncton
    {   43, 8270,   14571,  8, }, // America/Monterrey
    {   43, 4098,   14579, 10, }, // America/Montevideo
    {   43, 5824,   14589,  8, }, // America/Montserrat
    {   43, 5481,   14597,  6, }, // America/Nassau
    {   43, 2379,   14603,  9, }, // America/New_York
    {   43, 8288,   14612,  3, }, // America/Nome
    {   43, 1850,   14615,  7, }, // America/Noronha
    {   43, 8301,   14622, 25, }, // America/North_Dakota/Beulah
    {   43, 8329,   14647, 28, }, // America/North_Dakota/Center
    {   43, 8357,   14675, 30, }, // America/North_Dakota/New_Salem
    {   43,  393,   14705,  6, }, // America/Nuuk
    {   43, 8388,   14711,  7, }, // America/Ojinaga
    {   43, 2356,   14718,  6, }, // America/Panama
    {   43, 6173,   14724, 10, }, // America/Paramaribo
    {   43, 2973,   14734,  6, }, // America/Phoenix
    {   43, 3945,   14740, 12, }, // America/Port-au-Prince
    {   43, 5954,   14752, 13, }, // America/Port_of_Spain
    {   43, 8404,   14765, 13, }, // America/Porto_Velho
    {   43, 5843,   14778, 12, }, // America/Puerto_Rico
    {   43, 4030,   14790, 13, }, // America/Punta_Arenas
    {   43, 8424,   14803, 12, }, // America/Rankin_Inlet
    {   43, 8445,   14815,  6, }, // America/Recife
    {   43, 1995,   14821,  7, }, // America/Regina
    {   43, 8460,   14828,  9, }, // America/Resolute
    {   43,  695,   14837, 12, }, // America/Rio_Branco
    {   43, 8477,   14849,  8, }, // America/Santarem
    {   43, 2201,   14857,  8, }, // America/Santiago
    {   43, 6111,   14865, 13, }, // America/Santo_Domingo
    {   43, 1878,   14878, 11, }, // America/Sao_Paulo
    {   43, 6899,   14889, 11, }, // America/Scoresbysund
    {   43, 8494,   14900,  5, }, // America/Sitka
    {   43, 8508,   14905, 12, }, // America/St_Barthelemy
    {   43, 2061,   14917,  9, }, // America/St_Johns
    {   43, 5863,   14926,  9, }, // America/St_Kitts
    {   43, 5880,   14935, 12, }, // America/St_Lucia
    {   43,  855,   14947, 10, }, // America/St_Thomas
    {   43, 5913,   14957, 12, }, // America/St_Vincent
    {   43, 8530,   14969, 12, }, // America/Swift_Current
    {   43, 5461,   14981, 12, }, // America/Tegucigalpa
    {   43, 5756,   14993,  5, }, // America/Thule
    {   43,  313,   14998,  8, }, // America/Tijuana
    {   43,  608,   15006,  7, }, // America/Toronto
    {   43, 5688,   15013,  7, }, // America/Tortola
    {   43, 2093,   15020,  9, }, // America/Vancouver
    {   43, 2144,   15029,  9, }, // America/Whitehorse
    {   43,  734,   15038,  7, }, // America/Winnipeg
    {   43, 8552,   15045,  8, }, // America/Yakutat
    {   43, 6001,   15053,  5, }, // Antarctica/Casey
    {   43, 6094,   15058,  6, }, // Antarctica/Davis
    {   43, 6133,   15064, 17, }, // Antarctica/DumontDUrville
    {   43, 8568,   15081, 14, }, // Antarctica/Macquarie
    {   43, 7066,   15095,  7, }, // Antarctica/Mawson
    {   43, 7113,   15102,  9, }, // Antarctica/McMurdo
    {   43, 8589,   15111,  6, }, // Antarctica/Palmer
    {   43, 7226,   15117,  6, }, // Antarctica/Rothera
    {   43, 7295,   15123,  5, }, // Antarctica/Syowa
    {   43, 8607,   15128,  5, }, // Antarctica/Troll
    {   43, 7374,   15133,  6, }, // Antarctica/Vostok
    {   43, 1429,   15139,  7, }, // Arctic/Longyearbyen
    {   43, 5570,   15146,  4, }, // Asia/Aden
    {   43, 5395,   15150,  6, }, // Asia/Almaty
    {   43, 3968,   15156,  5, }, // Asia/Amman
    {   43, 5511,   15161,  6, }, // Asia/Anadyr
    {   43, 5523,   15167,  6, }, // Asia/Aqtau
    {   43, 5368,   15173,  6, }, // Asia/Aqtobe
    {   43,  964,   15179,  7, }, // Asia/Ashgabat
    {   43, 8624,   15186,  7, }, // Asia/Atyrau
    {   43, 3607,   15193,  6, }, // Asia/Baghdad
    {   43, 5534,   15199,  7, }, // Asia/Bahrain
    {   43, 3653,   15206,  5, }, // Asia/Baku
    {   43, 4466,   15211,  7, }, // Asia/Bangkok
    {   43, 3571,   15218,  8, }, // Asia/Barnaul
    {   43, 4086,   15226,  7, }, // Asia/Beirut
    {   43, 3778,   15233,  6, }, // Asia/Bishkek
    {   43, 5989,   15239,  7, }, // Asia/Brunei
    {   43, 4601,   15246,  4, }, // Asia/Chita
    {   43, 4511,   15250,  7, }, // Asia/Colombo
    {   43, 4540,   15257,  8, }, // Asia/Damascus
    {   43, 1093,   15265,  5, }, // Asia/Dhaka
    {   43, 6192,   15270,  4, }, // Asia/Dili
    {   43, 3596,   15274,  6, }, // Asia/Dubai
    {   43, 6159,   15280,  8, }, // Asia/Dushanbe
    {   43, 8636,   15288, 10, }, // Asia/Famagusta
    {   43, 8651,   15298,  4, }, // Asia/Gaza
    {   43, 4795,   15302,  6, }, // Asia/Hebron
    {   43, 1259,   15308,  7, }, // Asia/Ho_Chi_Minh
    {   43, 2704,   15315,  7, }, // Asia/Hong_Kong
    {   43, 4771,   15322,  4, }, // Asia/Hovd
    {   43, 4184,   15326,  8, }, // Asia/Irkutsk
    {   43, 7006,   15334,  7, }, // Asia/Jakarta
    {   43, 6992,   15341,  8, }, // Asia/Jayapura
    {   43, 1290,   15349,  9, }, // Asia/Jerusalem
    {   43, 3560,   15358,  6, }, // Asia/Kabul
    {   43, 4316,   15364,  8, }, // Asia/Kamchatka
    {   43, 4239,   15372,  6, }, // Asia/Karachi
    {   43, 1185,   15378,  9, }, // Asia/Kathmandu
    {   43, 8661,   15387,  7, }, // Asia/Khandyga
    {   43,  992,   15394,  8, }, // Asia/Kolkata
    {   43, 4197,   15402, 11, }, // Asia/Krasnoyarsk
    {   43, 4859,   15413, 15, }, // Asia/Kuala_Lumpur
    {   43, 5976,   15428,  7, }, // Asia/Kuching
    {   43, 5547,   15435,  7, }, // Asia/Kuwait
    {   43, 1211,   15442,  5, }, // Asia/Macau
    {   43, 4017,   15447,  7, }, // Asia/Magadan
    {   43, 1349,   15454,  7, }, // Asia/Makassar
    {   43, 7182,   15461,  6, }, // Asia/Manila
    {   43, 6920,   15467,  6, }, // Asia/Muscat
    {   43, 2554,   15473,  7, }, // Asia/Nicosia
    {   43, 8675,   15480, 12, }, // Asia/Novokuznetsk
    {   43, 4135,   15492, 11, }, // Asia/Novosibirsk
    {   43, 4229,   15503,  4, }, // Asia/Omsk
    {   43, 7145,   15507,  7, }, // Asia/Oral
    {   43, 6961,   15514,  7, }, // Asia/Phnom_Penh
    {   43, 8693,   15521,  9, }, // Asia/Pontianak
    {   43, 4214,   15530,  7, }, // Asia/Pyongyang
    {   43, 5559,   15537,  5, }, // Asia/Qatar
    {   43, 8708,   15542,  8, }, // Asia/Qostanay
    {   43, 4269,   15550,  9, }, // Asia/Qyzylorda
    {   43, 3584,   15559,  7, }, // Asia/Riyadh
    {   43, 4408,   15566,  7, }, // Asia/Sakhalin
    {   43, 7245,   15573,  9, }, // Asia/Samarkand
    {   43, 3279,   15582,  5, }, // Asia/Seoul
    {   43, 1053,   15587,  6, }, // Asia/Shanghai
    {   43, 3300,   15593,  9, }, // Asia/Singapore
    {   43, 4297,   15602, 13, }, // Asia/Srednekolymsk
    {   43, 3263,   15615,  6, }, // Asia/Taipei
    {   43, 4781,   15621,  7, }, // Asia/Tashkent
    {   43, 3915,   15628,  7, }, // Asia/Tbilisi
    {   43, 2772,   15635,  6, }, // Asia/Tehran
    {   43, 1317,   15641,  8, }, // Asia/Thimphu
    {   43, 2821,   15649,  5, }, // Asia/Tokyo
    {   43, 4572,   15654,  5, }, // Asia/Tomsk
    {   43, 1021,   15659, 11, }, // Asia/Ulaanbaatar
    {   43, 1159,   15670,  8, }, // Asia/Urumqi
    {   43, 8722,   15678,  9, }, // Asia/Ust-Nera
    {   43, 6977,   15687,  8, }, // Asia/Vientiane
    {   43, 4710,   15695, 11, }, // Asia/Vladivostok
    {   43, 4828,   15706,  8, }, // Asia/Yakutsk
    {   43, 1235,   15714,  7, }, // Asia/Yangon
    {   43, 3883,   15721, 13, }, // Asia/Yekaterinburg
    {   43, 3747,   15734,  5, }, // Asia/Yerevan
    {   43, 3663,   15739, 15, }, // Atlantic/Azores
    {   43, 5671,   15754, 10, }, // Atlantic/Bermuda
    {   43, 6628,   15764, 16, }, // Atlantic/Canary
    {   43, 3727,   15780, 10, }, // Atlantic/Cape_Verde
    {   43, 1395,   15790, 16, }, // Atlantic/Faroe
    {   43, 8736,   15806,  7, }, // Atlantic/Madeira
    {   43, 2748,   15813,  9, }, // Atlantic/Reykjavik
    {   43, 7272,   15822, 16, }, // Atlantic/South_Georgia
    {   43, 6821,   15838, 18, }, // Atlantic/St_Helena
    {   43, 6644,   15856,  6, }, // Atlantic/Stanley
    {   43, 1670,   15862,  8, }, // Australia/Adelaide
    {   43, 1635,   15870,  7, }, // Australia/Brisbane
    {   43, 1799,   15877, 10, }, // Australia/Broken_Hill
    {   43, 1583,   15887,  6, }, // Australia/Darwin
    {   43, 3637,   15893,  6, }, // Australia/Eucla
    {   43, 1516,   15899,  6, }, // Australia/Hobart
    {   43, 8753,   15905,  8, }, // Australia/Lindeman
    {   43, 1547,   15913, 14, }, // Australia/Lord_Howe
    {   43, 1727,   15927,  8, }, // Australia/Melbourne
    {   43, 1762,   15935,  4, }, // Australia/Perth
    {   43, 1463,   15939,  6, }, // Australia/Sydney
    {   43, 6441,   15945,  9, }, // Europe/Amsterdam
    {   43, 6216,   15954,  7, }, // Europe/Andorra
    {   43, 3620,   15961,  8, }, // Europe/Astrakhan
    {   43, 2300,   15969,  5, }, // Europe/Athens
    {   43, 6336,   15974,  7, }, // Europe/Belgrade
    {   43, 4757,   15981,  6, }, // Europe/Berlin
    {   43, 6488,   15987, 10, }, // Europe/Bratislava
    {   43, 2167,   15997,  8, }, // Europe/Brussels
    {   43, 3928,   16005,  9, }, // Europe/Bucharest
    {   43, 3806,   16014,  9, }, // Europe/Budapest
    {   43, 8772,   16023, 10, }, // Europe/Busingen
    {   43, 2583,   16033,  5, }, // Europe/Chisinau
    {   43, 6289,   16038, 10, }, // Europe/Copenhagen
    {   43, 2338,   16048,  7, }, // Europe/Dublin
    {   43, 6307,   16055,  9, }, // Europe/Gibraltar
    {   43, 8788,   16064,  6, }, // Europe/Guernsey
    {   43, 6612,   16070,  8, }, // Europe/Helsinki
    {   43, 8804,   16078,  8, }, // Europe/Isle_of_Man
    {   43, 1130,   16086,  8, }, // Europe/Istanbul
    {   43, 8823,   16094,  5, }, // Europe/Jersey
    {   43, 3979,   16099, 11, }, // Europe/Kaliningrad
    {   43, 8929,   16110,  5, }, // Europe/Kirov
    {   43, 2527,   16115,  3, }, // Europe/Kyiv
    {   43, 3213,   16118,  7, }, // Europe/Lisbon
    {   43, 6506,   16125, 10, }, // Europe/Ljubljana
    {   43, 2501,   16135,  6, }, // Europe/London
    {   43, 6365,   16141, 13, }, // Europe/Luxembourg
    {   43, 4892,   16154,  6, }, // Europe/Madrid
    {   43, 6397,   16160,  5, }, // Europe/Malta
    {   43, 6582,   16165,  9, }, // Europe/Mariehamn
    {   43, 3693,   16174,  5, }, // Europe/Minsk
    {   43, 6410,   16179,  6, }, // Europe/Monaco
    {   43, 3537,   16185,  6, }, // Europe/Moscow
    {   43, 6458,   16191,  4, }, // Europe/Oslo
    {   43, 4284,   16195,  5, }, // Europe/Paris
    {   43, 6424,   16200,  9, }, // Europe/Podgorica
    {   43, 6275,   16209,  5, }, // Europe/Prague
    {   43, 8837,   16214,  4, }, // Europe/Riga
    {   43, 6324,   16218,  4, }, // Europe/Rome
    {   43, 4331,   16222,  6, }, // Europe/Samara
    {   43, 6470,   16228, 10, }, // Europe/San_Marino
    {   43, 6245,   16238,  6, }, // Europe/Sarajevo
    {   43, 4451,   16244,  7, }, // Europe/Saratov
    {   43, 8849,   16251, 10, }, // Europe/Simferopol
    {   43, 6383,   16261,  6, }, // Europe/Skopje
    {   43, 6599,   16267,  5, }, // Europe/Sofia
    {   43, 6523,   16272,  8, }, // Europe/Stockholm
    {   43, 8867,   16280,  6, }, // Europe/Tallinn
    {   43, 6202,   16286,  6, }, // Europe/Tirane
    {   43, 8882,   16292, 10, }, // Europe/Ulyanovsk
    {   43, 6352,   16302,  6, }, // Europe/Vaduz
    {   43, 6567,   16308,  7, }, // Europe/Vatican
    {   43, 6231,   16315,  6, }, // Europe/Vienna
    {   43, 8899,   16321,  8, }, // Europe/Vilnius
    {   43, 4727,   16329,  9, }, // Europe/Volgograd
    {   43, 3190,   16338,  7, }, // Europe/Warsaw
    {   43, 6261,   16345,  6, }, // Europe/Zagreb
    {   43, 6540,   16351,  7, }, // Europe/Zurich
    {   43, 5078,   16358, 13, }, // Indian/Antananarivo
    {   43, 6947,   16371,  5, }, // Indian/Chagos
    {   43, 6046,   16376, 18, }, // Indian/Christmas
    {   43, 6063,   16394, 16, }, // Indian/Cocos
    {   43, 5029,   16410, 16, }, // Indian/Comoro
    {   43, 6661,   16426,  8, }, // Indian/Kerguelen
    {   43, 7260,   16434,  3, }, // Indian/Mahe
    {   43, 7050,   16437,  9, }, // Indian/Maldives
    {   43, 4069,   16446,  9, }, // Indian/Mauritius
    {   43, 5098,   16455,  5, }, // Indian/Mayotte
    {   43, 7211,   16460,  9, }, // Indian/Reunion
    {   43, 4422,   16469,  4, }, // Pacific/Apia
    {   43,  932,   16473,  6, }, // Pacific/Auckland
    {   43, 3706,   16479,  9, }, // Pacific/Bougainville
    {   43, 3015,   16488, 10, }, // Pacific/Chatham
    {   43, 3157,   16498,  6, }, // Pacific/Chuuk
    {   43, 2237,   16504, 10, }, // Pacific/Easter
    {   43, 7360,   16514,  5, }, // Pacific/Efate
    {   43, 7327,   16519,  7, }, // Pacific/Fakaofo
    {   43, 3902,   16526,  4, }, // Pacific/Fiji
    {   43, 7343,   16530, 10, }, // Pacific/Funafuti
    {   43, 6678,   16540, 20, }, // Pacific/Galapagos
    {   43, 6696,   16560, 14, }, // Pacific/Gambier
    {   43, 3822,   16574, 12, }, // Pacific/Guadalcanal
    {   43, 6018,   16586,  5, }, // Pacific/Guam
    {   43, 2723,   16591, 10, }, // Pacific/Honolulu
    {   43, 3049,   16601, 14, }, // Pacific/Kanton
    {   43, 3998,   16615, 10, }, // Pacific/Kiritimati
    {   43, 7019,   16625,  6, }, // Pacific/Kosrae
    {   43, 2842,   16631,  9, }, // Pacific/Kwajalein
    {   43, 4877,   16640,  7, }, // Pacific/Majuro
    {   43, 4051,   16647, 17, }, // Pacific/Marquesas
    {   43, 8914,   16664, 12, }, // Pacific/Midway
    {   43, 7084,   16676,  7, }, // Pacific/Nauru
    {   43, 7132,   16683,  5, }, // Pacific/Niue
    {   43, 4168,   16688,  7, }, // Pacific/Norfolk
    {   43, 7098,   16695,  6, }, // Pacific/Noumea
    {   43, 3126,   16701,  9, }, // Pacific/Pago_Pago
    {   43, 7155,   16710,  6, }, // Pacific/Palau
    {   43, 7194,   16716,  7, }, // Pacific/Pitcairn
    {   43, 3096,   16723,  6, }, // Pacific/Pohnpei
    {   43, 4807,   16729, 11, }, // Pacific/Port_Moresby
    {   43, 6076,   16740,  9, }, // Pacific/Rarotonga
    {   43, 6031,   16749,  6, }, // Pacific/Saipan
    {   43, 7312,   16755,  5, }, // Pacific/Tahiti
    {   43, 6712,   16760,  6, }, // Pacific/Tarawa
    {   43, 4583,   16766, 10, }, // Pacific/Tongatapu
    {   43, 7392,   16776, 10, }, // Pacific/Wake
    {   43, 7405,   16786,  6, }, // Pacific/Wallis
    {   44, 6788,   16792,  7, }, // Africa/Abidjan Assamese/Bangla/India
    {   44, 6760,   16799,  5, }, // Africa/Accra
    {   44, 5059,   16804, 12, }, // Africa/Addis_Ababa
    {   44, 7420,   16816, 10, }, // Africa/Algiers
    {   44,   14,   16826,  7, }, // Africa/Asmara
    {   44,   44,   16833,  6, }, // Africa/Bamako
    {   44, 5257,   16839,  6, }, // Africa/Bangui
    {   44, 6746,   16845,  7, }, // Africa/Banjul
    {   44, 7435,   16852,  5, }, // Africa/Bissau
    {   44, 4957,   16857, 12, }, // Africa/Blantyre
    {   44, 5287,   16869, 10, }, // Africa/Brazzaville
    {   44, 4922,   16879, 10, }, // Africa/Bujumbura
    {   44, 2320,   16889,  5, }, // Africa/Cairo
    {   44, 4117,   16894, 11, }, // Africa/Casablanca
    {   44, 7449,   16905,  5, }, // Africa/Ceuta
    {   44, 6773,   16910,  8, }, // Africa/Conakry
    {   44, 6840,   16918,  5, }, // Africa/Dakar
    {   44, 5130,   16923, 12, }, // Africa/Dar_es_Salaam
    {   44, 5043,   16935,  6, }, // Africa/Djibouti
    {   44, 5243,   16941,  6, }, // Africa/Douala
    {   44, 5166,   16947,  9, }, // Africa/El_Aaiun
    {   44, 6853,   16956,  8, }, // Africa/Freetown
    {   44, 4906,   16964,  7, }, // Africa/Gaborone
    {   44, 5015,   16971,  6, }, // Africa/Harare
    {   44, 4479,   16977, 12, }, // Africa/Johannesburg
    {   44, 4499,   16989,  4, }, // Africa/Juba
    {   44, 5151,   16993,  8, }, // Africa/Kampala
    {   44, 4524,   17001,  7, }, // Africa/Khartoum
    {   44, 4973,   17008,  6, }, // Africa/Kigali
    {   44, 5306,   17014,  7, }, // Africa/Kinshasa
    {   44, 4744,   17021,  5, }, // Africa/Lagos
    {   44, 5336,   17026, 10, }, // Africa/Libreville
    {   44, 6869,   17036,  3, }, // Africa/Lome
    {   44, 5211,   17039,  8, }, // Africa/Luanda
    {   44, 4939,   17047, 10, }, // Africa/Lubumbashi
    {   44, 5001,   17057,  6, }, // Africa/Lusaka
    {   44, 5322,   17063,  6, }, // Africa/Malabo
    {   44, 4987,   17069,  6, }, // Africa/Maputo
    {   44, 5197,   17075,  6, }, // Africa/Maseru
    {   44, 5182,   17081,  8, }, // Africa/Mbabane
    {   44, 5113,   17089,  8, }, // Africa/Mogadishu
    {   44, 7034,   17097, 10, }, // Africa/Monrovia
    {   44, 3853,   17107,  7, }, // Africa/Nairobi
    {   44, 5271,   17114,  9, }, // Africa/Ndjamena
    {   44, 5354,   17123,  7, }, // Africa/Niamey
    {   44, 6803,   17130,  7, }, // Africa/Nouakchott
    {   44, 6727,   17137,  7, }, // Africa/Ouagadougou
    {   44, 5225,   17144, 11, }, // Africa/Porto-Novo
    {   44, 4435,   17155,  8, }, // Africa/Sao_Tome
    {   44, 2866,   17163,  8, }, // Africa/Tripoli
    {   44, 6554,   17171,  5, }, // Africa/Tunis
    {   44, 4152,   17176,  8, }, // Africa/Windhoek
    {   44,  132,   17184,  4, }, // America/Adak
    {   44, 3346,   17188,  7, }, // America/Anchorage
    {   44, 5607,   17195,  7, }, // America/Anguilla
    {   44, 5624,   17202,  9, }, // America/Antigua
    {   44, 4554,   17211, 10, }, // America/Araguaina
    {   44,  166,   17221, 12, }, // America/Argentina/Buenos_Aires
    {   44,   91,   17233, 10, }, // America/Argentina/Catamarca
    {   44,  270,   17243,  8, }, // America/Argentina/Cordoba
    {   44,  441,   17251,  5, }, // America/Argentina/Jujuy
    {   44, 7462,   17256,  8, }, // America/Argentina/La_Rioja
    {   44,  565,   17264,  8, }, // America/Argentina/Mendoza
    {   44, 7489,   17272, 12, }, // America/Argentina/Rio_Gallegos
    {   44, 7520,   17284,  6, }, // America/Argentina/Salta
    {   44, 7544,   17290,  9, }, // America/Argentina/San_Juan
    {   44, 5580,   17299,  8, }, // America/Argentina/San_Luis
    {   44, 7571,   17307,  6, }, // America/Argentina/Tucuman
    {   44, 7597,   17313,  8, }, // America/Argentina/Ushuaia
    {   44, 5640,   17321,  5, }, // America/Aruba
    {   44, 4252,   17326,  9, }, // America/Asuncion
    {   44,  237,   17335,  8, }, // America/Atikokan
    {   44, 3679,   17343,  7, }, // America/Bahia
    {   44, 7623,   17350, 17, }, // America/Bahia_Banderas
    {   44, 5654,   17367,  9, }, // America/Barbados
    {   44, 7646,   17376,  5, }, // America/Belem
    {   44, 5407,   17381,  5, }, // America/Belize
    {   44, 7660,   17386, 13, }, // America/Blanc-Sablon
    {   44, 7681,   17399, 11, }, // America/Boa_Vista
    {   44, 4361,   17410,  6, }, // America/Bogota
    {   44, 7699,   17416,  5, }, // America/Boise
    {   44, 7713,   17421, 15, }, // America/Cambridge_Bay
    {   44, 7735,   17436, 15, }, // America/Campo_Grande
    {   44, 3868,   17451,  6, }, // America/Cancun
    {   44, 4694,   17457,  7, }, // America/Caracas
    {   44, 4345,   17464,  6, }, // America/Cayenne
    {   44, 5496,   17470,  6, }, // America/Cayman
    {   44, 2260,   17476,  6, }, // America/Chicago
    {   44, 7756,   17482,  9, }, // America/Chihuahua
    {   44, 7774,   17491, 12, }, // America/Ciudad_Juarez
    {   44, 5422,   17503, 11, }, // America/Costa_Rica
    {   44, 7796,   17514,  8, }, // America/Creston
    {   44, 3791,   17522,  6, }, // America/Cuiaba
    {   44, 5723,   17528,  7, }, // America/Curacao
    {   44, 7812,   17535, 12, }, // America/Danmarkshavn
    {   44, 7833,   17547,  5, }, // America/Dawson
    {   44, 7848,   17552, 11, }, // America/Dawson_Creek
    {   44,  805,   17563,  6, }, // America/Denver
    {   44, 3465,   17569,  8, }, // America/Detroit
    {   44, 5739,   17577,  7, }, // America/Dominica
    {   44,  893,   17584,  7, }, // America/Edmonton
    {   44, 7869,   17591,  7, }, // America/Eirunepe
    {   44, 5441,   17598, 11, }, // America/El_Salvador
    {   44, 7886,   17609, 11, }, // America/Fort_Nelson
    {   44, 7906,   17620, 10, }, // America/Fortaleza
    {   44, 7924,   17630, 12, }, // America/Glace_Bay
    {   44, 6881,   17642, 10, }, // America/Goose_Bay
    {   44, 4612,   17652, 13, }, // America/Grand_Turk
    {   44, 5770,   17665,  8, }, // America/Grenada
    {   44, 5786,   17673,  9, }, // America/Guadeloupe
    {   44, 3760,   17682, 10, }, // America/Guatemala
    {   44, 4841,   17692,  9, }, // America/Guayaquil
    {   44, 6932,   17701,  7, }, // America/Guyana
    {   44, 1939,   17708,  9, }, // America/Halifax
    {   44, 2281,   17717,  6, }, // America/Havana
    {   44, 7942,   17723, 12, }, // America/Hermosillo
    {   44,  348,   17735, 15, }, // America/Indiana/Indianapolis
    {   44,  481,   17750, 16, }, // America/Indiana/Knox
    {   44, 7961,   17766, 19, }, // America/Indiana/Marengo
    {   44, 7985,   17785, 24, }, // America/Indiana/Petersburg
    {   44, 8012,   17809, 20, }, // America/Indiana/Tell_City
    {   44, 8038,   17829, 16, }, // America/Indiana/Vevay
    {   44, 8060,   17845, 20, }, // America/Indiana/Vincennes
    {   44, 8086,   17865, 19, }, // America/Indiana/Winamac
    {   44, 8110,   17884,  6, }, // America/Inuvik
    {   44,  660,   17890,  7, }, // America/Iqaluit
    {   44, 2799,   17897,  7, }, // America/Jamaica
    {   44, 5380,   17904,  5, }, // America/Juneau
    {   44,  521,   17909,  8, }, // America/Kentucky/Louisville
    {   44, 8125,   17917, 19, }, // America/Kentucky/Monticello
    {   44, 5704,   17936, 13, }, // America/Kralendijk
    {   44, 4376,   17949,  6, }, // America/La_Paz
    {   44, 7169,   17955,  4, }, // America/Lima
    {   44, 3239,   17959, 11, }, // America/Los_Angeles
    {   44, 5932,   17970, 25, }, // America/Lower_Princes
    {   44, 8153,   17995,  5, }, // America/Maceio
    {   44, 8168,   18000,  8, }, // America/Managua
    {   44, 1908,   18008,  5, }, // America/Manaus
    {   44, 5897,   18013,  7, }, // America/Marigot
    {   44, 5805,   18020,  9, }, // America/Martinique
    {   44, 8184,   18029,  9, }, // America/Matamoros
    {   44, 2917,   18038, 10, }, // America/Mazatlan
    {   44, 8202,   18048,  8, }, // America/Menominee
    {   44, 8220,   18056,  6, }, // America/Merida
    {   44, 8235,   18062, 12, }, // America/Metlakatla
    {   44, 2949,   18074, 13, }, // America/Mexico_City
    {   44, 4391,   18087,  9, }, // America/Miquelon
    {   44, 8254,   18096,  7, }, // America/Moncton
    {   44, 8270,   18103,  9, }, // America/Monterrey
    {   44, 4098,   18112, 11, }, // America/Montevideo
    {   44, 5824,   18123,  9, }, // America/Montserrat
    {   44, 5481,   18132,  5, }, // America/Nassau
    {   44, 2379,   18137, 10, }, // America/New_York
    {   44, 8288,   18050,  3, }, // America/Nome
    {   44, 1850,   18147,  9, }, // America/Noronha
    {   44, 8301,   18156, 20, }, // America/North_Dakota/Beulah
    {   44, 8329,   18176, 21, }, // America/North_Dakota/Center
    {   44, 8357,   18197, 23, }, // America/North_Dakota/New_Salem
    {   44,  393,   18220,  3, }, // America/Nuuk
    {   44, 8388,   18223,  8, }, // America/Ojinaga
    {   44, 2356,   18231,  6, }, // America/Panama
    {   44, 6173,   18237, 10, }, // America/Paramaribo
    {   44, 2973,   18247,  7, }, // America/Phoenix
    {   44, 3945,   18254, 15, }, // America/Port-au-Prince
    {   44, 5954,   18269, 15, }, // America/Port_of_Spain
    {   44, 8404,   18284, 14, }, // America/Porto_Velho
    {   44, 5843,   18298, 13, }, // America/Puerto_Rico
    {   44, 4030,   18311, 13, }, // America/Punta_Arenas
    {   44, 8424,   18324, 12, }, // America/Rankin_Inlet
    {   44, 8445,   18336,  6, }, // America/Recife
    {   44, 1995,   18342,  6, }, // America/Regina
    {   44, 8460,   18348,  8, }, // America/Resolute
    {   44,  695,   18356, 12, }, // America/Rio_Branco
    {   44, 8477,   18368,  9, }, // America/Santarem
    {   44, 2201,   18377, 11, }, // America/Santiago
    {   44, 6111,   18388, 14, }, // America/Santo_Domingo
    {   44, 1878,   18402,  9, }, // America/Sao_Paulo
    {   44, 6899,   18411, 13, }, // America/Scoresbysund
    {   44, 8494,   18424,  8, }, // America/Sitka
    {   44, 8508,   18432, 16, }, // America/St_Barthelemy
    {   44, 2061,   18448, 11, }, // America/St_Johns
    {   44, 5863,   18459, 11, }, // America/St_Kitts
    {   44, 5880,   18470, 14, }, // America/St_Lucia
    {   44,  855,   18484, 11, }, // America/St_Thomas
    {   44, 5913,   18495, 15, }, // America/St_Vincent
    {   44, 8530,   18510, 14, }, // America/Swift_Current
    {   44, 5461,   18524, 12, }, // America/Tegucigalpa
    {   44, 5756,   18536,  6, }, // America/Thule
    {   44,  313,   18542,  8, }, // America/Tijuana
    {   44,  608,   18550,  8, }, // America/Toronto
    {   44, 5688,   18558,  8, }, // America/Tortola
    {   44, 2093,   18566,  8, }, // America/Vancouver
    {   44, 2144,   18574, 10, }, // America/Whitehorse
    {   44,  734,   18584,  7, }, // America/Winnipeg
    {   44, 8552,   18591,  8, }, // America/Yakutat
    {   44, 6001,   18599,  4, }, // Antarctica/Casey
    {   44, 6094,   18603,  5, }, // Antarctica/Davis
    {   44, 6133,   18608, 18, }, // Antarctica/DumontDUrville
    {   44, 8568,   18626, 11, }, // Antarctica/Macquarie
    {   44, 7066,   18637,  5, }, // Antarctica/Mawson
    {   44, 7113,   18642,  9, }, // Antarctica/McMurdo
    {   44, 8589,   18651,  4, }, // Antarctica/Palmer
    {   44, 7226,   18655,  6, }, // Antarctica/Rothera
    {   44, 7295,   18661,  6, }, // Antarctica/Syowa
    {   44, 8607,   18667,  5, }, // Antarctica/Troll
    {   44, 7374,   18672,  6, }, // Antarctica/Vostok
    {   44, 1429,   18678, 12, }, // Arctic/Longyearbyen
    {   44, 5570,   18690,  4, }, // Asia/Aden
    {   44, 5395,   18694,  6, }, // Asia/Almaty
    {   44, 3968,   18700,  6, }, // Asia/Amman
    {   44, 5511,   18706,  6, }, // Asia/Anadyr
    {   44, 5523,   18712, 10, }, // Asia/Aqtau
    {   44, 5368,   18722,  7, }, // Asia/Aqtobe
    {   44,  964,   18729, 11, }, // Asia/Ashgabat
    {   44, 8624,   18740,  5, }, // Asia/Atyrau
    {   44, 3607,   18745,  6, }, // Asia/Baghdad
    {   44, 5534,   18751,  7, }, // Asia/Bahrain
    {   44, 3653,   17526,  4, }, // Asia/Baku
    {   44, 4466,   18758,  5, }, // Asia/Bangkok
    {   44, 3571,   18763,  7, }, // Asia/Barnaul
    {   44, 4086,   18770,  6, }, // Asia/Beirut
    {   44, 3778,   18776, 10, }, // Asia/Bishkek
    {   44, 5989,   18786,  7, }, // Asia/Brunei
    {   44, 4601,   18793,  4, }, // Asia/Chita
    {   44, 4511,   18797,  6, }, // Asia/Colombo
    {   44, 4540,   18803,  9, }, // Asia/Damascus
    {   44, 1093,   18812,  4, }, // Asia/Dhaka
    {   44, 6192,   18816,  4, }, // Asia/Dili
    {   44, 3596,   18820,  5, }, // Asia/Dubai
    {   44, 6159,   18825,  7, }, // Asia/Dushanbe
    {   44, 8636,   18832, 10, }, // Asia/Famagusta
    {   44, 8651,   18842,  4, }, // Asia/Gaza
    {   44, 4795,   18846,  7, }, // Asia/Hebron
    {   44, 1259,   18853, 14, }, // Asia/Ho_Chi_Minh
    {   44, 2704,   18867,  5, }, // Asia/Hong_Kong
    {   44, 4771,   18872,  6, }, // Asia/Hovd
    {   44, 4184,   18878, 10, }, // Asia/Irkutsk
    {   44, 7006,   18888,  8, }, // Asia/Jakarta
    {   44, 6992,   18896,  9, }, // Asia/Jayapura
    {   44, 1290,   18905,  9, }, // Asia/Jerusalem
    {   44, 3560,   18914,  5, }, // Asia/Kabul
    {   44, 4316,   18919,  8, }, // Asia/Kamchatka
    {   44, 4239,   18927,  5, }, // Asia/Karachi
    {   44, 1185,   18932,  9, }, // Asia/Kathmandu
    {   44, 8661,   18941,  8, }, // Asia/Khandyga
    {   44,  992,   18949,  6, }, // Asia/Kolkata
    {   44, 4197,   18955, 15, }, // Asia/Krasnoyarsk
    {   44, 4859,   18970, 12, }, // Asia/Kuala_Lumpur
    {   44, 5976,   18982,  5, }, // Asia/Kuching
    {   44, 5547,   18987,  6, }, // Asia/Kuwait
    {   44, 1211,   18993,  5, }, // Asia/Macau
    {   44, 4017,   18998,  7, }, // Asia/Magadan
    {   44, 1349,   19005,  7, }, // Asia/Makassar
    {   44, 7182,   19012,  6, }, // Asia/Manila
    {   44, 6920,   19018,  7, }, // Asia/Muscat
    {   44, 2554,   19025,  9, }, // Asia/Nicosia
    {   44, 8675,   19034, 14, }, // Asia/Novokuznetsk
    {   44, 4135,   19048, 13, }, // Asia/Novosibirsk
    {   44, 4229,   19061,  5, }, // Asia/Omsk
    {   44, 7145,   19066,  5, }, // Asia/Oral
    {   44, 6961,   19071, 10, }, // Asia/Phnom_Penh
    {   44, 8693,   19081, 11, }, // Asia/Pontianak
    {   44, 4214,   19092,  8, }, // Asia/Pyongyang
    {   44, 5559,   19100,  5, }, // Asia/Qatar
    {   44, 8708,   19105,  8, }, // Asia/Qostanay
    {   44, 4269,   19113, 10, }, // Asia/Qyzylorda
    {   44, 3584,   19123,  6, }, // Asia/Riyadh
    {   44, 4408,   19129,  7, }, // Asia/Sakhalin
    {   44, 7245,   19136, 10, }, // Asia/Samarkand
    {   44, 3279,   19146,  4, }, // Asia/Seoul
    {   44, 1053,   19150,  6, }, // Asia/Shanghai
    {   44, 3300,   19156,  8, }, // Asia/Singapore
    {   44, 4297,   19164, 15, }, // Asia/Srednekolymsk
    {   44, 3263,   19179,  6, }, // Asia/Taipei
    {   44, 4781,   19185,  8, }, // Asia/Tashkent
    {   44, 3915,   19193,  7, }, // Asia/Tbilisi
    {   44, 2772,   19200,  6, }, // Asia/Tehran
    {   44, 1317,   19206,  6, }, // Asia/Thimphu
    {   44, 2821,   19212,  5, }, // Asia/Tokyo
    {   44, 4572,   19217,  8, }, // Asia/Tomsk
    {   44, 1021,   19225,  9, }, // Asia/Ulaanbaatar
    {   44, 1159,   19234,  8, }, // Asia/Urumqi
    {   44, 8722,   19242,  9, }, // Asia/Ust-Nera
    {   44, 6977,   19251, 13, }, // Asia/Vientiane
    {   44, 4710,   19264, 12, }, // Asia/Vladivostok
    {   44, 4828,   19276, 10, }, // Asia/Yakutsk
    {   44, 1235,   19286,  6, }, // Asia/Yangon
    {   44, 3883,   19292, 15, }, // Asia/Yekaterinburg
    {   44, 3747,   19307,  8, }, // Asia/Yerevan
    {   44, 3663,   19315,  6, }, // Atlantic/Azores
    {   44, 5671,   19321,  8, }, // Atlantic/Bermuda
    {   44, 6628,   19329,  6, }, // Atlantic/Canary
    {   44, 3727,   19335, 10, }, // Atlantic/Cape_Verde
    {   44, 1395,   19345,  4, }, // Atlantic/Faroe
    {   44, 8736,   19349,  6, }, // Atlantic/Madeira
    {   44, 2748,   19355,  9, }, // Atlantic/Reykjavik
    {   44, 7272,   19364, 15, }, // Atlantic/South_Georgia
    {   44, 6821,   19379, 13, }, // Atlantic/St_Helena
    {   44, 6644,   19392,  9, }, // Atlantic/Stanley
    {   44, 1670,   19401,  7, }, // Australia/Adelaide
    {   44, 1635,   19408,  8, }, // Australia/Brisbane
    {   44, 1799,   19416, 11, }, // Australia/Broken_Hill
    {   44, 1583,   19427,  6, }, // Australia/Darwin
    {   44, 3637,   19433,  6, }, // Australia/Eucla
    {   44, 1516,   19439,  7, }, // Australia/Hobart
    {   44, 8753,   19446,  8, }, // Australia/Lindeman
    {   44, 1547,   19454,  8, }, // Australia/Lord_Howe
    {   44, 1727,   19462,  8, }, // Australia/Melbourne
    {   44, 1762,   19470,  5, }, // Australia/Perth
    {   44, 1463,   19475,  5, }, // Australia/Sydney
    {   44, 6441,   19480, 10, }, // Europe/Amsterdam
    {   44, 6216,   19490,  7, }, // Europe/Andorra
    {   44, 3620,   19497, 10, }, // Europe/Astrakhan
    {   44, 2300,   19507,  6, }, // Europe/Athens
    {   44, 6336,   19513,  8, }, // Europe/Belgrade
    {   44, 4757,   19521,  7, }, // Europe/Berlin
    {   44, 6488,   19528, 11, }, // Europe/Bratislava
    {   44, 2167,   19539,  8, }, // Europe/Brussels
    {   44, 3928,   19547,  9, }, // Europe/Bucharest
    {   44, 3806,   19556,  9, }, // Europe/Budapest
    {   44, 8772,   19565,  8, }, // Europe/Busingen
    {   44, 2583,   19573,  7, }, // Europe/Chisinau
    {   44, 6289,   19580, 10, }, // Europe/Copenhagen
    {   44, 2338,   19590,  6, }, // Europe/Dublin
    {   44, 6307,   19596, 10, }, // Europe/Gibraltar
    {   44, 8788,   19606,  7, }, // Europe/Guernsey
    {   44, 6612,   19613,  8, }, // Europe/Helsinki
    {   44, 8804,   19621, 10, }, // Europe/Isle_of_Man
    {   44, 1130,   19631,  9, }, // Europe/Istanbul
    {   44, 8823,   19640,  6, }, // Europe/Jersey
    {   44, 3979,   19646, 12, }, // Europe/Kaliningrad
    {   44, 8929,   19658,  5, }, // Europe/Kirov
    {   44, 2527,   19663,  3, }, // Europe/Kyiv
    {   44, 3213,   19666,  5, }, // Europe/Lisbon
    {   44, 6506,   19671, 11, }, // Europe/Ljubljana
    {   44, 2501,   19682,  5, }, // Europe/London
    {   44, 6365,   19687, 12, }, // Europe/Luxembourg
    {   44, 4892,   19699,  7, }, // Europe/Madrid
    {   44, 6397,   19706,  6, }, // Europe/Malta
    {   44, 6582,   19712, 10, }, // Europe/Mariehamn
    {   44, 3693,   19722,  6, }, // Europe/Minsk
    {   44, 6410,   19728,  6, }, // Europe/Monaco
    {   44, 3537,   19734,  5, }, // Europe/Moscow
    {   44, 6458,   19739,  5, }, // Europe/Oslo
    {   44, 4284,   19744,  5, }, // Europe/Paris
    {   44, 6424,   19749,  9, }, // Europe/Podgorica
    {   44, 6275,   19758,  5, }, // Europe/Prague
    {   44, 8837,   19763,  4, }, // Europe/Riga
    {   44, 6324,   19347,  3, }, // Europe/Rome
    {   44, 4331,   19767,  6, }, // Europe/Samara
    {   44, 6470,   19773, 10, }, // Europe/San_Marino
    {   44, 6245,   19783,  8, }, // Europe/Sarajevo
    {   44, 4451,   19791,  7, }, // Europe/Saratov
    {   44, 8849,   19798, 11, }, // Europe/Simferopol
    {   44, 6383,   19809,  8, }, // Europe/Skopje
    {   44, 6599,   19817,  7, }, // Europe/Sofia
    {   44, 6523,   19824,  7, }, // Europe/Stockholm
    {   44, 8867,   19831,  5, }, // Europe/Tallinn
    {   44, 6202,   19836,  6, }, // Europe/Tirane
    {   44, 8882,   19842, 13, }, // Europe/Ulyanovsk
    {   44, 6352,   19855,  5, }, // Europe/Vaduz
    {   44, 6567,   19860,  7, }, // Europe/Vatican
    {   44, 6231,   19867,  7, }, // Europe/Vienna
    {   44, 8899,   19874,  9, }, // Europe/Vilnius
    {   44, 4727,   19883, 11, }, // Europe/Volgograd
    {   44, 3190,   19894,  6, }, // Europe/Warsaw
    {   44, 6261,   19900,  7, }, // Europe/Zagreb
    {   44, 6540,   19907,  5, }, // Europe/Zurich
    {   44, 5078,   19912, 13, }, // Indian/Antananarivo
    {   44, 6947,   19925,  5, }, // Indian/Chagos
    {   44, 6046,   19930, 10, }, // Indian/Christmas
    {   44, 6063,   19940,  5, }, // Indian/Cocos
    {   44, 5029,   19945,  6, }, // Indian/Comoro
    {   44, 6661,   19951,  8, }, // Indian/Kerguelen
    {   44, 7260,   19959,  4, }, // Indian/Mahe
    {   44, 7050,   19963,  8, }, // Indian/Maldives
    {   44, 4069,   19971,  6, }, // Indian/Mauritius
    {   44, 5098,   19977,  9, }, // Indian/Mayotte
    {   44, 7211,   19986,  9, }, // Indian/Reunion
    {   44, 4422,   19995,  6, }, // Pacific/Apia
    {   44,  932,   20001,  7, }, // Pacific/Auckland
    {   44, 3706,   20008, 10, }, // Pacific/Bougainville
    {   44, 3015,   20018,  5, }, // Pacific/Chatham
    {   44, 3157,   20023,  5, }, // Pacific/Chuuk
    {   44, 2237,   20028,  6, }, // Pacific/Easter
    {   44, 7360,   20034,  4, }, // Pacific/Efate
    {   44, 7327,   20038,  7, }, // Pacific/Fakaofo
    {   44, 3902,   20045,  4, }, // Pacific/Fiji
    {   44, 7343,   20049,  8, }, // Pacific/Funafuti
    {   44, 6678,   20057,  9, }, // Pacific/Galapagos
    {   44, 6696,   20066, 10, }, // Pacific/Gambier
    {   44, 3822,   20076, 11, }, // Pacific/Guadalcanal
    {   44, 6018,   18004,  5, }, // Pacific/Guam
    {   44, 3049,   20087,  9, }, // Pacific/Kanton
    {   44, 3998,   20096, 10, }, // Pacific/Kiritimati
    {   44, 7019,   20106,  8, }, // Pacific/Kosrae
    {   44, 2842,   20114,  9, }, // Pacific/Kwajalein
    {   44, 4877,   20123,  6, }, // Pacific/Majuro
    {   44, 4051,   20129,  8, }, // Pacific/Marquesas
    {   44, 8914,   20137,  5, }, // Pacific/Midway
    {   44, 7084,   20142,  4, }, // Pacific/Nauru
    {   44, 7132,   20146,  5, }, // Pacific/Niue
    {   44, 4168,   20151,  6, }, // Pacific/Norfolk
    {   44, 7098,   20157,  7, }, // Pacific/Noumea
    {   44, 3126,   20164,  9, }, // Pacific/Pago_Pago
    {   44, 7155,   20173,  5, }, // Pacific/Palau
    {   44, 7194,   20178,  9, }, // Pacific/Pitcairn
    {   44, 3096,   20187,  6, }, // Pacific/Pohnpei
    {   44, 4807,   20193, 15, }, // Pacific/Port_Moresby
    {   44, 6076,   20208, 10, }, // Pacific/Rarotonga
    {   44, 6031,   20218,  6, }, // Pacific/Saipan
    {   44, 7312,   20224,  6, }, // Pacific/Tahiti
    {   44, 6712,   20230,  6, }, // Pacific/Tarawa
    {   44, 4583,   20236,  8, }, // Pacific/Tongatapu
    {   44, 7392,   20244,  3, }, // Pacific/Wake
    {   44, 7405,   20247,  5, }, // Pacific/Wallis
    {   45, 5059,   20252, 10, }, // Africa/Addis_Ababa Asturian/Latin/Spain
    {   45, 7420,   20262,  5, }, // Africa/Algiers
    {   45,   14,       0,  6, }, // Africa/Asmara
    {   45, 2320,   20267,  8, }, // Africa/Cairo
    {   45, 5043,   20275,  6, }, // Africa/Djibouti
    {   45, 4479,   20281, 13, }, // Africa/Johannesburg
    {   45, 4524,   20294,  6, }, // Africa/Khartoum
    {   45, 6869,   20300,  4, }, // Africa/Lome
    {   45, 5113,   20304,  8, }, // Africa/Mogadishu
    {   45, 5271,   20312,  6, }, // Africa/Ndjamena
    {   45, 5354,   20318,  6, }, // Africa/Niamey
    {   45, 6803,   20324,  7, }, // Africa/Nouakchott
    {   45, 6727,   20331,  8, }, // Africa/Ouagadougou
    {   45, 4435,   20339, 10, }, // Africa/Sao_Tome
    {   45, 2866,   20349,  7, }, // Africa/Tripoli
    {   45, 6554,   20356,  5, }, // Africa/Tunis
    {   45, 5607,    4657,  7, }, // America/Anguilla
    {   45,  270,   20361,  7, }, // America/Argentina/Cordoba
    {   45, 7571,   20368,  7, }, // America/Argentina/Tucuman
    {   45, 4252,      14,  8, }, // America/Asuncion
    {   45,  237,      22,  8, }, // America/Atikokan
    {   45, 3679,      30,  5, }, // America/Bahia
    {   45, 7623,   20375, 14, }, // America/Bahia_Banderas
    {   45, 4361,   20389,  6, }, // America/Bogota
    {   45, 3868,      47,  6, }, // America/Cancun
    {   45, 5496,   20395,  6, }, // America/Cayman
    {   45, 7774,      53, 13, }, // America/Ciudad_Juarez
    {   45, 5723,      66,  7, }, // America/Curacao
    {   45, 5770,   20401,  7, }, // America/Grenada
    {   45, 5786,   20408,  9, }, // America/Guadeloupe
    {   45, 2281,   20417,  9, }, // America/Havana
    {   45,  481,      73, 13, }, // America/Indiana/Knox
    {   45, 7961,      86, 16, }, // America/Indiana/Marengo
    {   45, 7985,     102, 19, }, // America/Indiana/Petersburg
    {   45, 8012,     121, 18, }, // America/Indiana/Tell_City
    {   45, 8038,     139, 14, }, // America/Indiana/Vevay
    {   45, 8060,     153, 18, }, // America/Indiana/Vincennes
    {   45, 8086,     171, 16, }, // America/Indiana/Winamac
    {   45, 2799,   20426,  7, }, // America/Jamaica
    {   45, 8125,     187, 20, }, // America/Kentucky/Monticello
    {   45, 5932,     207, 22, }, // America/Lower_Princes
    {   45, 5805,   20433, 12, }, // America/Martinique
    {   45, 8220,     229,  6, }, // America/Merida
    {   45, 2949,   20445, 15, }, // America/Mexico_City
    {   45, 2379,   20460, 10, }, // America/New_York
    {   45, 8301,   20470, 24, }, // America/North_Dakota/Beulah
    {   45, 8329,   20494, 24, }, // America/North_Dakota/Center
    {   45, 8357,   20518, 29, }, // America/North_Dakota/New_Salem
    {   45,  393,     298,  4, }, // America/Nuuk
    {   45, 2356,   20547,  6, }, // America/Panama
    {   45, 3945,   20553, 15, }, // America/Port-au-Prince
    {   45, 5954,   20568, 13, }, // America/Port_of_Spain
    {   45, 5843,   20581, 11, }, // America/Puerto_Rico
    {   45, 6111,   20592, 13, }, // America/Santo_Domingo
    {   45, 6899,     302, 16, }, // America/Scoresbysund
    {   45, 8508,     318, 14, }, // America/St_Barthelemy
    {   45, 2061,     332, 10, }, // America/St_Johns
    {   45, 5863,     342,  9, }, // America/St_Kitts
    {   45, 5880,     351,  9, }, // America/St_Lucia
    {   45,  855,     360, 10, }, // America/St_Thomas
    {   45, 5913,     370, 11, }, // America/St_Vincent
    {   45, 5688,   20605,  7, }, // America/Tortola
    {   45, 6133,     381, 16, }, // Antarctica/DumontDUrville
    {   45, 3968,   20612,  4, }, // Asia/Amman
    {   45, 3607,   20616,  6, }, // Asia/Baghdad
    {   45, 5534,   20622,  7, }, // Asia/Bahrain
    {   45, 3653,   20629,  4, }, // Asia/Baku
    {   45, 5989,   20633,  6, }, // Asia/Brunei
    {   45, 4540,   20639,  7, }, // Asia/Damascus
    {   45, 6159,   20646,  7, }, // Asia/Dushanbe
    {   45, 4795,   20653,  6, }, // Asia/Hebron
    {   45, 1259,   20659, 20, }, // Asia/Ho_Chi_Minh
    {   45, 2704,   20679,  9, }, // Asia/Hong_Kong
    {   45, 7006,   20688,  7, }, // Asia/Jakarta
    {   45, 6992,   20695,  8, }, // Asia/Jayapura
    {   45, 1290,   20703,  9, }, // Asia/Jerusalem
    {   45, 1185,   20712,  8, }, // Asia/Kathmandu
    {   45,  992,   20720,  7, }, // Asia/Kolkata
    {   45, 1211,   20727,  5, }, // Asia/Macau
    {   45, 4017,   20732,  7, }, // Asia/Magadan
    {   45, 6920,   20739,  7, }, // Asia/Muscat
    {   45, 4214,   20746, 10, }, // Asia/Pyongyang
    {   45, 3584,   20756,  5, }, // Asia/Riyadh
    {   45, 4408,   20761,  7, }, // Asia/Sakhalin
    {   45, 7245,   20768, 10, }, // Asia/Samarkand
    {   45, 3279,   20778,  4, }, // Asia/Seoul
    {   45, 3300,   20782,  8, }, // Asia/Singapore
    {   45, 2772,   20790,  6, }, // Asia/Tehran
    {   45, 2821,   20796,  5, }, // Asia/Tokyo
    {   45, 1021,   20801, 10, }, // Asia/Ulaanbaatar
    {   45, 6977,   20811,  8, }, // Asia/Vientiane
    {   45, 1235,   20819,  6, }, // Asia/Yangon
    {   45, 3883,   20825, 14, }, // Asia/Yekaterinburg
    {   45, 3663,   20839, 10, }, // Atlantic/Azores
    {   45, 6628,   20849,  8, }, // Atlantic/Canary
    {   45, 3727,   20857, 10, }, // Atlantic/Cape_Verde
    {   45, 1395,   20867, 12, }, // Atlantic/Faroe
    {   45, 2748,   20879,  9, }, // Atlantic/Reykjavik
    {   45, 7272,   20888, 14, }, // Atlantic/South_Georgia
    {   45, 6821,   20902, 10, }, // Atlantic/St_Helena
    {   45, 1670,   20912,  8, }, // Australia/Adelaide
    {   45, 3620,   20920,  8, }, // Europe/Astrakhan
    {   45, 2300,   20928,  6, }, // Europe/Athens
    {   45, 6336,   20934,  7, }, // Europe/Belgrade
    {   45, 4757,   20941,  6, }, // Europe/Berlin
    {   45, 2167,   20947,  8, }, // Europe/Brussels
    {   45, 3928,   20955,  8, }, // Europe/Bucharest
    {   45, 6289,   20963, 10, }, // Europe/Copenhagen
    {   45, 2338,   20973,  6, }, // Europe/Dublin
    {   45, 6307,   20979,  9, }, // Europe/Gibraltar
    {   45, 6612,   20988,  8, }, // Europe/Helsinki
    {   45, 8804,   20996, 12, }, // Europe/Isle_of_Man
    {   45, 3979,   21008, 11, }, // Europe/Kaliningrad
    {   45, 2527,    8030,  4, }, // Europe/Kyiv
    {   45, 3213,   21019,  6, }, // Europe/Lisbon
    {   45, 6506,   21025,  9, }, // Europe/Ljubljana
    {   45, 2501,   21034,  7, }, // Europe/London
    {   45, 6365,   21041, 10, }, // Europe/Luxembourg
    {   45, 6410,   21051,  6, }, // Europe/Monaco
    {   45, 3537,   21057,  5, }, // Europe/Moscow
    {   45, 4284,   21062,  5, }, // Europe/Paris
    {   45, 6275,   21067,  5, }, // Europe/Prague
    {   45, 6324,    5946,  4, }, // Europe/Rome
    {   45, 6470,   21072,  9, }, // Europe/San_Marino
    {   45, 6599,   21081,  5, }, // Europe/Sofia
    {   45, 6523,   21086,  9, }, // Europe/Stockholm
    {   45, 6202,   21095,  6, }, // Europe/Tirane
    {   45, 6567,   21101, 11, }, // Europe/Vatican
    {   45, 6231,   21112,  5, }, // Europe/Vienna
    {   45, 4727,   21117,  9, }, // Europe/Volgograd
    {   45, 3190,   21126,  8, }, // Europe/Warsaw
    {   45, 4069,   21134,  8, }, // Indian/Mauritius
    {   45, 7211,   21142,  7, }, // Indian/Reunion
    {   45, 3157,     474,  5, }, // Pacific/Chuuk
    {   45, 2237,   21149,  6, }, // Pacific/Easter
    {   45, 3902,   21155,  4, }, // Pacific/Fiji
    {   45, 6678,   21159,  9, }, // Pacific/Galapagos
    {   45, 2723,    4493,  8, }, // Pacific/Honolulu
    {   45, 3049,    4501,  9, }, // Pacific/Kanton
    {   45, 3096,     479,  7, }, // Pacific/Pohnpei
    {   46,   14,       0,  6, }, // Africa/Asmara Asu/Latin/Tanzania
    {   46, 4435,       6,  8, }, // Africa/Sao_Tome
    {   46, 4252,      14,  8, }, // America/Asuncion
    {   46,  237,      22,  8, }, // America/Atikokan
    {   46, 7623,      30, 17, }, // America/Bahia_Banderas
    {   46, 3868,      47,  6, }, // America/Cancun
    {   46, 7774,      53, 13, }, // America/Ciudad_Juarez
    {   46, 5723,      66,  7, }, // America/Curacao
    {   46,  481,      73, 13, }, // America/Indiana/Knox
    {   46, 7961,      86, 16, }, // America/Indiana/Marengo
    {   46, 7985,     102, 19, }, // America/Indiana/Petersburg
    {   46, 8012,     121, 18, }, // America/Indiana/Tell_City
    {   46, 8038,     139, 14, }, // America/Indiana/Vevay
    {   46, 8060,     153, 18, }, // America/Indiana/Vincennes
    {   46, 8086,     171, 16, }, // America/Indiana/Winamac
    {   46, 8125,     187, 20, }, // America/Kentucky/Monticello
    {   46, 5932,     207, 22, }, // America/Lower_Princes
    {   46, 8220,     229,  6, }, // America/Merida
    {   46, 8301,     235, 20, }, // America/North_Dakota/Beulah
    {   46, 8329,     255, 20, }, // America/North_Dakota/Center
    {   46, 8357,     275, 23, }, // America/North_Dakota/New_Salem
    {   46,  393,     298,  4, }, // America/Nuuk
    {   46, 6899,     302, 16, }, // America/Scoresbysund
    {   46, 8508,     318, 14, }, // America/St_Barthelemy
    {   46, 2061,     332, 10, }, // America/St_Johns
    {   46, 5863,     342,  9, }, // America/St_Kitts
    {   46, 5880,     351,  9, }, // America/St_Lucia
    {   46,  855,     360, 10, }, // America/St_Thomas
    {   46, 5913,     370, 11, }, // America/St_Vincent
    {   46, 6133,     381, 16, }, // Antarctica/DumontDUrville
    {   46, 1259,     397, 11, }, // Asia/Ho_Chi_Minh
    {   46, 1185,     413,  9, }, // Asia/Kathmandu
    {   46,  992,     422,  7, }, // Asia/Kolkata
    {   46, 1211,     429,  5, }, // Asia/Macau
    {   46, 1235,     442,  6, }, // Asia/Yangon
    {   46, 1395,     448,  5, }, // Atlantic/Faroe
    {   46, 6821,     453, 10, }, // Atlantic/St_Helena
    {   46, 2527,     463,  4, }, // Europe/Kyiv
    {   46, 7211,     467,  7, }, // Indian/Reunion
    {   46, 3157,     474,  5, }, // Pacific/Chuuk
    {   46, 3096,     479,  7, }, // Pacific/Pohnpei
    {   47,   14,       0,  6, }, // Africa/Asmara Atsam/Latin/Nigeria
    {   47, 4435,       6,  8, }, // Africa/Sao_Tome
    {   47, 4252,      14,  8, }, // America/Asuncion
    {   47,  237,      22,  8, }, // America/Atikokan
    {   47, 7623,      30, 17, }, // America/Bahia_Banderas
    {   47, 3868,      47,  6, }, // America/Cancun
    {   47, 7774,      53, 13, }, // America/Ciudad_Juarez
    {   47, 5723,      66,  7, }, // America/Curacao
    {   47,  481,      73, 13, }, // America/Indiana/Knox
    {   47, 7961,      86, 16, }, // America/Indiana/Marengo
    {   47, 7985,     102, 19, }, // America/Indiana/Petersburg
    {   47, 8012,     121, 18, }, // America/Indiana/Tell_City
    {   47, 8038,     139, 14, }, // America/Indiana/Vevay
    {   47, 8060,     153, 18, }, // America/Indiana/Vincennes
    {   47, 8086,     171, 16, }, // America/Indiana/Winamac
    {   47, 8125,     187, 20, }, // America/Kentucky/Monticello
    {   47, 5932,     207, 22, }, // America/Lower_Princes
    {   47, 8220,     229,  6, }, // America/Merida
    {   47, 8301,     235, 20, }, // America/North_Dakota/Beulah
    {   47, 8329,     255, 20, }, // America/North_Dakota/Center
    {   47, 8357,     275, 23, }, // America/North_Dakota/New_Salem
    {   47,  393,     298,  4, }, // America/Nuuk
    {   47, 6899,     302, 16, }, // America/Scoresbysund
    {   47, 8508,     318, 14, }, // America/St_Barthelemy
    {   47, 2061,     332, 10, }, // America/St_Johns
    {   47, 5863,     342,  9, }, // America/St_Kitts
    {   47, 5880,     351,  9, }, // America/St_Lucia
    {   47,  855,     360, 10, }, // America/St_Thomas
    {   47, 5913,     370, 11, }, // America/St_Vincent
    {   47, 6133,     381, 16, }, // Antarctica/DumontDUrville
    {   47, 1259,     397, 11, }, // Asia/Ho_Chi_Minh
    {   47, 1185,     413,  9, }, // Asia/Kathmandu
    {   47,  992,     422,  7, }, // Asia/Kolkata
    {   47, 1211,     429,  5, }, // Asia/Macau
    {   47, 1235,     442,  6, }, // Asia/Yangon
    {   47, 1395,     448,  5, }, // Atlantic/Faroe
    {   47, 6821,     453, 10, }, // Atlantic/St_Helena
    {   47, 2527,     463,  4, }, // Europe/Kyiv
    {   47, 7211,     467,  7, }, // Indian/Reunion
    {   47, 3157,     474,  5, }, // Pacific/Chuuk
    {   47, 3096,     479,  7, }, // Pacific/Pohnpei
    {   48, 6788,   21168,  6, }, // Africa/Abidjan Azerbaijani/Latin/Azerbaijan
    {   48, 6760,   21174,  5, }, // Africa/Accra
    {   48, 5059,   21179, 11, }, // Africa/Addis_Ababa
    {   48, 7420,   21190,  8, }, // Africa/Algiers
    {   48,   14,   21198,  6, }, // Africa/Asmara
    {   48, 5257,   21204,  6, }, // Africa/Bangui
    {   48, 6746,   21210,  6, }, // Africa/Banjul
    {   48, 4957,    6200,  7, }, // Africa/Blantyre
    {   48, 5287,   21216,  9, }, // Africa/Brazzaville
    {   48, 2320,   21225,  6, }, // Africa/Cairo
    {   48, 4117,    4577, 10, }, // Africa/Casablanca
    {   48, 7449,   21231,  5, }, // Africa/Ceuta
    {   48, 6773,    6249,  7, }, // Africa/Conakry
    {   48, 5130,   21236, 12, }, // Africa/Dar_es_Salaam
    {   48, 5043,   21248,  6, }, // Africa/Djibouti
    {   48, 5243,   21254,  5, }, // Africa/Douala
    {   48, 5166,   21259,  7, }, // Africa/El_Aaiun
    {   48, 6853,    6282,  7, }, // Africa/Freetown
    {   48, 4906,   21266,  7, }, // Africa/Gaborone
    {   48, 4479,   21273, 11, }, // Africa/Johannesburg
    {   48, 4524,   21284,  6, }, // Africa/Khartoum
    {   48, 4973,   21290,  6, }, // Africa/Kigali
    {   48, 5306,   21296,  7, }, // Africa/Kinshasa
    {   48, 4744,   21303,  5, }, // Africa/Lagos
    {   48, 5336,    6311,  8, }, // Africa/Libreville
    {   48, 4939,   21308,  9, }, // Africa/Lubumbashi
    {   48, 5113,   21317,  8, }, // Africa/Mogadishu
    {   48, 5271,   21325,  7, }, // Africa/Ndjamena
    {   48, 6803,   21332,  8, }, // Africa/Nouakchott
    {   48, 6727,   21340,  7, }, // Africa/Ouagadougou
    {   48, 4435,   21347,  7, }, // Africa/Sao_Tome
    {   48, 4152,   21354,  7, }, // Africa/Windhoek
    {   48, 3346,   21361,  7, }, // America/Anchorage
    {   48, 5607,   21368,  7, }, // America/Anguilla
    {   48, 5624,   21375,  7, }, // America/Antigua
    {   48, 4554,   21382,  9, }, // America/Araguaina
    {   48,  166,   21391, 12, }, // America/Argentina/Buenos_Aires
    {   48,   91,    6400,  9, }, // America/Argentina/Catamarca
    {   48,  270,    6409,  7, }, // America/Argentina/Cordoba
    {   48, 7462,   21403,  5, }, // America/Argentina/La_Rioja
    {   48, 7489,   21408, 12, }, // America/Argentina/Rio_Gallegos
    {   48, 7544,   21420,  8, }, // America/Argentina/San_Juan
    {   48, 7571,    4724,  7, }, // America/Argentina/Tucuman
    {   48, 7597,   21428,  6, }, // America/Argentina/Ushuaia
    {   48, 4252,    6474,  8, }, // America/Asuncion
    {   48,  237,      22,  8, }, // America/Atikokan
    {   48, 3679,   21434,  6, }, // America/Bahia
    {   48, 7623,    3825, 14, }, // America/Bahia_Banderas
    {   48, 5407,    6496,  5, }, // America/Belize
    {   48, 7660,    6502, 12, }, // America/Blanc-Sablon
    {   48, 4361,   21440,  6, }, // America/Bogota
    {   48, 7699,   21446,  5, }, // America/Boise
    {   48, 7713,   21451, 15, }, // America/Cambridge_Bay
    {   48, 7735,   21466, 12, }, // America/Campo_Grande
    {   48, 3868,    6564,  6, }, // America/Cancun
    {   48, 4694,    4792,  7, }, // America/Caracas
    {   48, 4345,   21478,  5, }, // America/Cayenne
    {   48, 5496,   21483,  6, }, // America/Cayman
    {   48, 2260,   21489,  6, }, // America/Chicago
    {   48, 7756,   21495,  8, }, // America/Chihuahua
    {   48, 7774,      53, 13, }, // America/Ciudad_Juarez
    {   48, 5422,   21503, 10, }, // America/Costa_Rica
    {   48, 7796,    6618,  7, }, // America/Creston
    {   48, 3791,   21513,  6, }, // America/Cuiaba
    {   48, 5723,    6631,  7, }, // America/Curacao
    {   48, 7812,   21519, 11, }, // America/Danmarkshavn
    {   48, 7833,    6651,  6, }, // America/Dawson
    {   48, 7848,   21530, 11, }, // America/Dawson_Creek
    {   48, 3465,   21541,  7, }, // America/Detroit
    {   48, 5739,   21548,  8, }, // America/Dominica
    {   48,  893,   21556,  9, }, // America/Edmonton
    {   48, 7869,   21565,  7, }, // America/Eirunepe
    {   48, 5441,    6688,  8, }, // America/El_Salvador
    {   48, 7924,   21572, 13, }, // America/Glace_Bay
    {   48, 6881,   21585, 11, }, // America/Goose_Bay
    {   48, 4612,   21596, 10, }, // America/Grand_Turk
    {   48, 5770,   21606,  7, }, // America/Grenada
    {   48, 5786,   21613,  9, }, // America/Guadeloupe
    {   48, 3760,   21622,  9, }, // America/Guatemala
    {   48, 4841,   21631,  8, }, // America/Guayaquil
    {   48, 6932,   21639,  6, }, // America/Guyana
    {   48, 1939,    6787,  8, }, // America/Halifax
    {   48, 7942,   21645,  9, }, // America/Hermosillo
    {   48,  348,   21654, 12, }, // America/Indiana/Indianapolis
    {   48,  481,   21666,  4, }, // America/Indiana/Knox
    {   48, 7961,   21670,  7, }, // America/Indiana/Marengo
    {   48, 7985,   21677, 10, }, // America/Indiana/Petersburg
    {   48, 8012,     121,  4, }, // America/Indiana/Tell_City
    {   48, 8038,   21687,  5, }, // America/Indiana/Vevay
    {   48, 8060,   21692,  6, }, // America/Indiana/Vincennes
    {   48, 8086,   21698,  7, }, // America/Indiana/Winamac
    {   48, 8110,   21705,  6, }, // America/Inuvik
    {   48,  660,   21711,  7, }, // America/Iqaluit
    {   48, 2799,   21718,  7, }, // America/Jamaica
    {   48, 5380,   21725,  4, }, // America/Juneau
    {   48,  521,   21729,  7, }, // America/Kentucky/Louisville
    {   48, 8125,   21736, 10, }, // America/Kentucky/Monticello
    {   48, 5704,   21746,  9, }, // America/Kralendijk
    {   48, 4376,   21755,  6, }, // America/La_Paz
    {   48, 3239,   21761, 11, }, // America/Los_Angeles
    {   48, 5932,   21772, 20, }, // America/Lower_Princes
    {   48, 8153,   21792,  6, }, // America/Maceio
    {   48, 8168,   21798,  7, }, // America/Managua
    {   48, 5897,   21805,  7, }, // America/Marigot
    {   48, 5805,    5142,  8, }, // America/Martinique
    {   48, 2917,   21812,  8, }, // America/Mazatlan
    {   48, 8202,    7000,  8, }, // America/Menominee
    {   48, 8220,    7008,  6, }, // America/Merida
    {   48, 2949,   21820,  6, }, // America/Mexico_City
    {   48, 4391,    7031,  7, }, // America/Miquelon
    {   48, 8254,    7038,  7, }, // America/Moncton
    {   48, 8270,   21826,  8, }, // America/Monterrey
    {   48, 5824,   21834,  8, }, // America/Montserrat
    {   48, 2379,   21842,  8, }, // America/New_York
    {   48, 8288,   21850,  3, }, // America/Nome
    {   48, 1850,   21853,  7, }, // America/Noronha
    {   48, 8301,   21860, 21, }, // America/North_Dakota/Beulah
    {   48, 8329,   21881, 20, }, // America/North_Dakota/Center
    {   48, 8357,   21901,  9, }, // America/North_Dakota/New_Salem
    {   48,  393,     298,  4, }, // America/Nuuk
    {   48, 8388,   21910,  7, }, // America/Ojinaga
    {   48, 2973,    7165,  6, }, // America/Phoenix
    {   48, 3945,    7171, 12, }, // America/Port-au-Prince
    {   48, 5954,   21917, 12, }, // America/Port_of_Spain
    {   48, 8404,   21929, 11, }, // America/Porto_Velho
    {   48, 5843,   21940, 11, }, // America/Puerto_Rico
    {   48, 8424,   21951, 13, }, // America/Rankin_Inlet
    {   48, 8445,   21964,  5, }, // America/Recife
    {   48, 1995,   21969,  6, }, // America/Regina
    {   48, 8460,   21975,  8, }, // America/Resolute
    {   48,  695,    5362, 10, }, // America/Rio_Branco
    {   48, 2201,   21983,  8, }, // America/Santiago
    {   48, 6111,   21991, 13, }, // America/Santo_Domingo
    {   48, 1878,   22004,  9, }, // America/Sao_Paulo
    {   48, 6899,   22013, 12, }, // America/Scoresbysund
    {   48, 8508,   22025, 14, }, // America/St_Barthelemy
    {   48, 2061,   22039,  9, }, // America/St_Johns
    {   48, 5863,   22048,  8, }, // America/St_Kitts
    {   48, 5880,   22056, 10, }, // America/St_Lucia
    {   48,  855,   22066,  9, }, // America/St_Thomas
    {   48, 5913,   22075, 11, }, // America/St_Vincent
    {   48, 8530,   22086, 12, }, // America/Swift_Current
    {   48, 5461,   22098, 11, }, // America/Tegucigalpa
    {   48, 5756,   22109,  3, }, // America/Thule
    {   48,  313,   22112,  7, }, // America/Tijuana
    {   48, 2093,    7375,  8, }, // America/Vancouver
    {   48, 2144,   22119,  8, }, // America/Whitehorse
    {   48,  734,   22127,  8, }, // America/Winnipeg
    {   48, 6001,   22135,  5, }, // Antarctica/Casey
    {   48, 6094,   22140,  6, }, // Antarctica/Davis
    {   48, 6133,     381, 14, }, // Antarctica/DumontDUrville
    {   48, 8568,   22146,  7, }, // Antarctica/Macquarie
    {   48, 7066,   22153,  6, }, // Antarctica/Mawson
    {   48, 7113,   22159,  9, }, // Antarctica/McMurdo
    {   48, 7295,   22168,  5, }, // Antarctica/Syowa
    {   48, 1429,   22173,  7, }, // Arctic/Longyearbyen
    {   48, 5395,   22180,  6, }, // Asia/Almaty
    {   48, 5511,   22186,  6, }, // Asia/Anadyr
    {   48, 5523,    5491,  5, }, // Asia/Aqtau
    {   48,  964,   22192,  7, }, // Asia/Ashgabat
    {   48, 8624,   22199,  6, }, // Asia/Atyrau
    {   48, 3607,   22205,  6, }, // Asia/Baghdad
    {   48, 5534,   22211,  7, }, // Asia/Bahrain
    {   48, 3653,   22218,  4, }, // Asia/Baku
    {   48, 4466,   22222,  7, }, // Asia/Bangkok
    {   48, 4086,   22229,  6, }, // Asia/Beirut
    {   48, 3778,   22235,  6, }, // Asia/Bishkek
    {   48, 5989,   22241,  6, }, // Asia/Brunei
    {   48, 4601,    7513,  4, }, // Asia/Chita
    {   48, 4511,    5519,  7, }, // Asia/Colombo
    {   48, 4540,   22247,  6, }, // Asia/Damascus
    {   48, 1093,   22253,  5, }, // Asia/Dhaka
    {   48, 3596,   22258,  5, }, // Asia/Dubai
    {   48, 6159,   22263,  7, }, // Asia/Dushanbe
    {   48, 8636,   22270,  9, }, // Asia/Famagusta
    {   48, 8651,   22279,  4, }, // Asia/Gaza
    {   48, 1259,   22283,  9, }, // Asia/Ho_Chi_Minh
    {   48, 2704,   22292,  9, }, // Asia/Hong_Kong
    {   48, 4184,   22301,  7, }, // Asia/Irkutsk
    {   48, 7006,   22308,  7, }, // Asia/Jakarta
    {   48, 6992,   22315,  8, }, // Asia/Jayapura
    {   48, 1290,   22323,  9, }, // Asia/Jerusalem
    {   48, 3560,   22332,  5, }, // Asia/Kabul
    {   48, 4316,   22337,  8, }, // Asia/Kamchatka
    {   48, 4239,    7569,  6, }, // Asia/Karachi
    {   48, 1185,    5593,  8, }, // Asia/Kathmandu
    {   48, 8661,   22345,  7, }, // Asia/Khandyga
    {   48,  992,   22352,  7, }, // Asia/Kolkata
    {   48, 5976,   22359,  6, }, // Asia/Kuching
    {   48, 5547,   22365,  6, }, // Asia/Kuwait
    {   48, 1211,    7613,  5, }, // Asia/Macau
    {   48, 4017,   22371,  7, }, // Asia/Magadan
    {   48, 1349,    7618,  7, }, // Asia/Makassar
    {   48, 6920,    4208,  6, }, // Asia/Muscat
    {   48, 2554,   22378,  8, }, // Asia/Nicosia
    {   48, 6961,   22386,  8, }, // Asia/Phnom_Penh
    {   48, 4214,   22394,  7, }, // Asia/Pyongyang
    {   48, 4269,   22401,  9, }, // Asia/Qyzylorda
    {   48, 3584,   20756,  5, }, // Asia/Riyadh
    {   48, 4408,   22410,  7, }, // Asia/Sakhalin
    {   48, 7245,   22417,  9, }, // Asia/Samarkand
    {   48, 3279,    7680,  4, }, // Asia/Seoul
    {   48, 1053,   22426,  6, }, // Asia/Shanghai
    {   48, 3300,   22432,  8, }, // Asia/Singapore
    {   48, 4297,   22440, 13, }, // Asia/Srednekolymsk
    {   48, 3263,   22453,  6, }, // Asia/Taipei
    {   48, 4781,   22459,  7, }, // Asia/Tashkent
    {   48, 1021,   22466,  9, }, // Asia/Ulaanbaatar
    {   48, 1159,   22475,  6, }, // Asia/Urumqi
    {   48, 6977,   22481,  8, }, // Asia/Vientiane
    {   48, 1235,   22489,  6, }, // Asia/Yangon
    {   48, 3883,   22495, 13, }, // Asia/Yekaterinburg
    {   48, 3663,    7787,  4, }, // Atlantic/Azores
    {   48, 5671,   22508, 14, }, // Atlantic/Bermuda
    {   48, 6628,    4280,  5, }, // Atlantic/Canary
    {   48, 3727,   22522, 10, }, // Atlantic/Cape_Verde
    {   48, 1395,   22532,  5, }, // Atlantic/Faroe
    {   48, 8736,   22537,  7, }, // Atlantic/Madeira
    {   48, 2748,   22544,  9, }, // Atlantic/Reykjavik
    {   48, 7272,   22553, 14, }, // Atlantic/South_Georgia
    {   48, 6821,   22567, 15, }, // Atlantic/St_Helena
    {   48, 6644,    7847,  6, }, // Atlantic/Stanley
    {   48, 1670,   20912,  8, }, // Australia/Adelaide
    {   48, 1635,   22582,  8, }, // Australia/Brisbane
    {   48, 1583,    7880,  6, }, // Australia/Darwin
    {   48, 3637,   22590,  5, }, // Australia/Eucla
    {   48, 1547,   22595,  8, }, // Australia/Lord_Howe
    {   48, 1727,    7903,  7, }, // Australia/Melbourne
    {   48, 1762,   22603,  4, }, // Australia/Perth
    {   48, 1463,   22607,  6, }, // Australia/Sydney
    {   48, 3620,   22613,  9, }, // Europe/Astrakhan
    {   48, 2300,   22622,  5, }, // Europe/Athens
    {   48, 6336,   22627,  7, }, // Europe/Belgrade
    {   48, 2167,   22634,  7, }, // Europe/Brussels
    {   48, 3928,   22641,  8, }, // Europe/Bucharest
    {   48, 3806,   22649,  8, }, // Europe/Budapest
    {   48, 2583,   22657,  8, }, // Europe/Chisinau
    {   48, 6289,    4357, 10, }, // Europe/Copenhagen
    {   48, 6307,   22665, 12, }, // Europe/Gibraltar
    {   48, 8788,   22677,  7, }, // Europe/Guernsey
    {   48, 8804,   22684,  9, }, // Europe/Isle_of_Man
    {   48, 1130,   22693,  8, }, // Europe/Istanbul
    {   48, 8823,   22701,  5, }, // Europe/Jersey
    {   48, 3979,   22706, 11, }, // Europe/Kaliningrad
    {   48, 2527,   22717,  5, }, // Europe/Kyiv
    {   48, 3213,    4381,  8, }, // Europe/Lisbon
    {   48, 6506,   22722,  9, }, // Europe/Ljubljana
    {   48, 6365,   22731, 10, }, // Europe/Luxembourg
    {   48, 6582,   22741,  7, }, // Europe/Mariehamn
    {   48, 6410,    5926,  6, }, // Europe/Monaco
    {   48, 3537,   22748,  6, }, // Europe/Moscow
    {   48, 6424,   22754, 10, }, // Europe/Podgorica
    {   48, 6275,   22764,  5, }, // Europe/Prague
    {   48, 8837,   22769,  4, }, // Europe/Riga
    {   48, 6324,    5946,  4, }, // Europe/Rome
    {   48, 6245,   22773,  8, }, // Europe/Sarajevo
    {   48, 6383,   22781,  6, }, // Europe/Skopje
    {   48, 6599,   22787,  6, }, // Europe/Sofia
    {   48, 6523,    8124,  8, }, // Europe/Stockholm
    {   48, 8867,   22793,  6, }, // Europe/Tallinn
    {   48, 6202,   21095,  6, }, // Europe/Tirane
    {   48, 6352,   22799,  6, }, // Europe/Vaduz
    {   48, 6567,    5978,  7, }, // Europe/Vatican
    {   48, 6231,   22805,  5, }, // Europe/Vienna
    {   48, 8899,   22810,  6, }, // Europe/Vilnius
    {   48, 4727,   22816,  9, }, // Europe/Volgograd
    {   48, 3190,   22825,  7, }, // Europe/Warsaw
    {   48, 6261,   22832,  6, }, // Europe/Zagreb
    {   48, 6540,   22838,  5, }, // Europe/Zurich
    {   48, 6947,   22843,  5, }, // Indian/Chagos
    {   48, 6046,   22848,  5, }, // Indian/Christmas
    {   48, 6063,    4465,  5, }, // Indian/Cocos
    {   48, 5029,   22853,  6, }, // Indian/Comoro
    {   48, 6661,   22859,  8, }, // Indian/Kerguelen
    {   48, 7050,    8193,  6, }, // Indian/Maldives
    {   48, 4069,   22867,  7, }, // Indian/Mauritius
    {   48, 5098,    6046,  5, }, // Indian/Mayotte
    {   48, 7211,     467,  7, }, // Indian/Reunion
    {   48,  932,   22874,  6, }, // Pacific/Auckland
    {   48, 3706,   22880,  8, }, // Pacific/Bougainville
    {   48, 3015,   22888,  5, }, // Pacific/Chatham
    {   48, 3157,   22893,  4, }, // Pacific/Chuuk
    {   48, 2237,   22897,  5, }, // Pacific/Easter
    {   48, 3902,   22902,  4, }, // Pacific/Fiji
    {   48, 6678,   22906,  9, }, // Pacific/Galapagos
    {   48, 6696,   22915,  8, }, // Pacific/Gambier
    {   48, 3822,   22923, 11, }, // Pacific/Guadalcanal
    {   48, 6018,   22934,  4, }, // Pacific/Guam
    {   48, 2723,    4493,  8, }, // Pacific/Honolulu
    {   48, 3049,   22938,  9, }, // Pacific/Kanton
    {   48, 3998,   22947,  8, }, // Pacific/Kiritimati
    {   48, 7019,   22955,  7, }, // Pacific/Kosrae
    {   48, 2842,   22962,  9, }, // Pacific/Kwajalein
    {   48, 4877,   22971,  6, }, // Pacific/Majuro
    {   48, 4051,   22977,  8, }, // Pacific/Marquesas
    {   48, 8914,   22985,  6, }, // Pacific/Midway
    {   48, 3126,   22991,  9, }, // Pacific/Pago_Pago
    {   48, 7194,    8304,  7, }, // Pacific/Pitcairn
    {   48, 3096,     479,  7, }, // Pacific/Pohnpei
    {   48, 4807,   23000, 12, }, // Pacific/Port_Moresby
    {   48, 6076,   23012,  9, }, // Pacific/Rarotonga
    {   48, 6031,   23021,  6, }, // Pacific/Saipan
    {   48, 6712,   23027,  6, }, // Pacific/Tarawa
    {   48, 4583,   23033,  9, }, // Pacific/Tongatapu
    {   48, 7392,   23042,  4, }, // Pacific/Wake
    {   48, 7405,    8349,  6, }, // Pacific/Wallis
    {   49,   14,       0,  6, }, // Africa/Asmara Azerbaijani/Arabic/Iran
    {   49, 4435,       6,  8, }, // Africa/Sao_Tome
    {   49, 4252,      14,  8, }, // America/Asuncion
    {   49, 7623,      30, 17, }, // America/Bahia_Banderas
    {   49, 3868,      47,  6, }, // America/Cancun
    {   49, 5723,      66,  7, }, // America/Curacao
    {   49,  481,      73, 13, }, // America/Indiana/Knox
    {   49, 7961,      86, 16, }, // America/Indiana/Marengo
    {   49, 7985,     102, 19, }, // America/Indiana/Petersburg
    {   49, 8012,     121, 18, }, // America/Indiana/Tell_City
    {   49, 8038,     139, 14, }, // America/Indiana/Vevay
    {   49, 8060,     153, 18, }, // America/Indiana/Vincennes
    {   49, 8086,     171, 16, }, // America/Indiana/Winamac
    {   49, 8125,     187, 20, }, // America/Kentucky/Monticello
    {   49, 5932,     207, 22, }, // America/Lower_Princes
    {   49, 8220,     229,  6, }, // America/Merida
    {   49, 8301,     235, 20, }, // America/North_Dakota/Beulah
    {   49, 8329,     255, 20, }, // America/North_Dakota/Center
    {   49, 8357,     275, 23, }, // America/North_Dakota/New_Salem
    {   49, 6899,     302, 16, }, // America/Scoresbysund
    {   49, 8508,     318, 14, }, // America/St_Barthelemy
    {   49, 2061,     332, 10, }, // America/St_Johns
    {   49, 5863,     342,  9, }, // America/St_Kitts
    {   49, 5880,     351,  9, }, // America/St_Lucia
    {   49,  855,     360, 10, }, // America/St_Thomas
    {   49, 5913,     370, 11, }, // America/St_Vincent
    {   49, 6133,     381, 16, }, // Antarctica/DumontDUrville
    {   49, 1259,     397, 11, }, // Asia/Ho_Chi_Minh
    {   49, 1185,     413,  9, }, // Asia/Kathmandu
    {   49,  992,     422,  7, }, // Asia/Kolkata
    {   49, 1211,     429,  5, }, // Asia/Macau
    {   49, 1235,     442,  6, }, // Asia/Yangon
    {   49, 1395,     448,  5, }, // Atlantic/Faroe
    {   49, 6821,     453, 10, }, // Atlantic/St_Helena
    {   49, 2527,     463,  4, }, // Europe/Kyiv
    {   49, 3157,     474,  5, }, // Pacific/Chuuk
    {   52,   14,       0,  6, }, // Africa/Asmara Azerbaijani/Cyrillic/Azerbaijan
    {   52, 4435,       6,  8, }, // Africa/Sao_Tome
    {   52, 4252,      14,  8, }, // America/Asuncion
    {   52, 7623,      30, 17, }, // America/Bahia_Banderas
    {   52, 3868,      47,  6, }, // America/Cancun
    {   52, 5723,      66,  7, }, // America/Curacao
    {   52,  481,      73, 13, }, // America/Indiana/Knox
    {   52, 7961,      86, 16, }, // America/Indiana/Marengo
    {   52, 7985,     102, 19, }, // America/Indiana/Petersburg
    {   52, 8012,     121, 18, }, // America/Indiana/Tell_City
    {   52, 8038,     139, 14, }, // America/Indiana/Vevay
    {   52, 8060,     153, 18, }, // America/Indiana/Vincennes
    {   52, 8086,     171, 16, }, // America/Indiana/Winamac
    {   52, 8125,     187, 20, }, // America/Kentucky/Monticello
    {   52, 5932,     207, 22, }, // America/Lower_Princes
    {   52, 8220,     229,  6, }, // America/Merida
    {   52, 8301,     235, 20, }, // America/North_Dakota/Beulah
    {   52, 8329,     255, 20, }, // America/North_Dakota/Center
    {   52, 8357,     275, 23, }, // America/North_Dakota/New_Salem
    {   52, 6899,     302, 16, }, // America/Scoresbysund
    {   52, 8508,     318, 14, }, // America/St_Barthelemy
    {   52, 2061,     332, 10, }, // America/St_Johns
    {   52, 5863,     342,  9, }, // America/St_Kitts
    {   52, 5880,     351,  9, }, // America/St_Lucia
    {   52,  855,     360, 10, }, // America/St_Thomas
    {   52, 5913,     370, 11, }, // America/St_Vincent
    {   52, 6133,     381, 16, }, // Antarctica/DumontDUrville
    {   52, 1259,     397, 11, }, // Asia/Ho_Chi_Minh
    {   52, 1185,     413,  9, }, // Asia/Kathmandu
    {   52,  992,     422,  7, }, // Asia/Kolkata
    {   52, 1211,     429,  5, }, // Asia/Macau
    {   52, 1235,     442,  6, }, // Asia/Yangon
    {   52, 1395,     448,  5, }, // Atlantic/Faroe
    {   52, 6821,     453, 10, }, // Atlantic/St_Helena
    {   52, 2527,     463,  4, }, // Europe/Kyiv
    {   52, 3157,     474,  5, }, // Pacific/Chuuk
    {   53,   14,       0,  6, }, // Africa/Asmara Bafia/Latin/Cameroon
    {   53, 4435,       6,  8, }, // Africa/Sao_Tome
    {   53, 4252,      14,  8, }, // America/Asuncion
    {   53,  237,      22,  8, }, // America/Atikokan
    {   53, 7623,      30, 17, }, // America/Bahia_Banderas
    {   53, 3868,      47,  6, }, // America/Cancun
    {   53, 7774,      53, 13, }, // America/Ciudad_Juarez
    {   53, 5723,      66,  7, }, // America/Curacao
    {   53,  481,      73, 13, }, // America/Indiana/Knox
    {   53, 7961,      86, 16, }, // America/Indiana/Marengo
    {   53, 7985,     102, 19, }, // America/Indiana/Petersburg
    {   53, 8012,     121, 18, }, // America/Indiana/Tell_City
    {   53, 8038,     139, 14, }, // America/Indiana/Vevay
    {   53, 8060,     153, 18, }, // America/Indiana/Vincennes
    {   53, 8086,     171, 16, }, // America/Indiana/Winamac
    {   53, 8125,     187, 20, }, // America/Kentucky/Monticello
    {   53, 5932,     207, 22, }, // America/Lower_Princes
    {   53, 8220,     229,  6, }, // America/Merida
    {   53, 8301,     235, 20, }, // America/North_Dakota/Beulah
    {   53, 8329,     255, 20, }, // America/North_Dakota/Center
    {   53, 8357,     275, 23, }, // America/North_Dakota/New_Salem
    {   53,  393,     298,  4, }, // America/Nuuk
    {   53, 6899,     302, 16, }, // America/Scoresbysund
    {   53, 8508,     318, 14, }, // America/St_Barthelemy
    {   53, 2061,     332, 10, }, // America/St_Johns
    {   53, 5863,     342,  9, }, // America/St_Kitts
    {   53, 5880,     351,  9, }, // America/St_Lucia
    {   53,  855,     360, 10, }, // America/St_Thomas
    {   53, 5913,     370, 11, }, // America/St_Vincent
    {   53, 6133,     381, 16, }, // Antarctica/DumontDUrville
    {   53, 1259,     397, 11, }, // Asia/Ho_Chi_Minh
    {   53, 1185,     413,  9, }, // Asia/Kathmandu
    {   53,  992,     422,  7, }, // Asia/Kolkata
    {   53, 1211,     429,  5, }, // Asia/Macau
    {   53, 1235,     442,  6, }, // Asia/Yangon
    {   53, 1395,     448,  5, }, // Atlantic/Faroe
    {   53, 6821,     453, 10, }, // Atlantic/St_Helena
    {   53, 2527,     463,  4, }, // Europe/Kyiv
    {   53, 7211,     467,  7, }, // Indian/Reunion
    {   53, 3157,     474,  5, }, // Pacific/Chuuk
    {   53, 3096,     479,  7, }, // Pacific/Pohnpei
    {   54,   14,       0,  6, }, // Africa/Asmara Bambara/Latin/Mali
    {   54, 4435,       6,  8, }, // Africa/Sao_Tome
    {   54, 4252,      14,  8, }, // America/Asuncion
    {   54,  237,      22,  8, }, // America/Atikokan
    {   54, 7623,      30, 17, }, // America/Bahia_Banderas
    {   54, 3868,      47,  6, }, // America/Cancun
    {   54, 7774,      53, 13, }, // America/Ciudad_Juarez
    {   54, 5723,      66,  7, }, // America/Curacao
    {   54,  481,      73, 13, }, // America/Indiana/Knox
    {   54, 7961,      86, 16, }, // America/Indiana/Marengo
    {   54, 7985,     102, 19, }, // America/Indiana/Petersburg
    {   54, 8012,     121, 18, }, // America/Indiana/Tell_City
    {   54, 8038,     139, 14, }, // America/Indiana/Vevay
    {   54, 8060,     153, 18, }, // America/Indiana/Vincennes
    {   54, 8086,     171, 16, }, // America/Indiana/Winamac
    {   54, 8125,     187, 20, }, // America/Kentucky/Monticello
    {   54, 5932,     207, 22, }, // America/Lower_Princes
    {   54, 8220,     229,  6, }, // America/Merida
    {   54, 8301,     235, 20, }, // America/North_Dakota/Beulah
    {   54, 8329,     255, 20, }, // America/North_Dakota/Center
    {   54, 8357,     275, 23, }, // America/North_Dakota/New_Salem
    {   54,  393,     298,  4, }, // America/Nuuk
    {   54, 6899,     302, 16, }, // America/Scoresbysund
    {   54, 8508,     318, 14, }, // America/St_Barthelemy
    {   54, 2061,     332, 10, }, // America/St_Johns
    {   54, 5863,     342,  9, }, // America/St_Kitts
    {   54, 5880,     351,  9, }, // America/St_Lucia
    {   54,  855,     360, 10, }, // America/St_Thomas
    {   54, 5913,     370, 11, }, // America/St_Vincent
    {   54, 6133,     381, 16, }, // Antarctica/DumontDUrville
    {   54, 1259,     397, 11, }, // Asia/Ho_Chi_Minh
    {   54, 1185,     413,  9, }, // Asia/Kathmandu
    {   54,  992,     422,  7, }, // Asia/Kolkata
    {   54, 1211,     429,  5, }, // Asia/Macau
    {   54, 1235,     442,  6, }, // Asia/Yangon
    {   54, 1395,     448,  5, }, // Atlantic/Faroe
    {   54, 6821,     453, 10, }, // Atlantic/St_Helena
    {   54, 2527,     463,  4, }, // Europe/Kyiv
    {   54, 7211,     467,  7, }, // Indian/Reunion
    {   54, 3157,     474,  5, }, // Pacific/Chuuk
    {   54, 3096,     479,  7, }, // Pacific/Pohnpei
    {   56, 6788,   23046,  7, }, // Africa/Abidjan Bangla/Bangla/Bangladesh
    {   56, 6760,   23053,  5, }, // Africa/Accra
    {   56, 5059,   23058, 12, }, // Africa/Addis_Ababa
    {   56, 7420,   23070, 10, }, // Africa/Algiers
    {   56,   14,   23080, 11, }, // Africa/Asmara
    {   56,   44,   23091,  8, }, // Africa/Bamako
    {   56, 5257,   23099,  7, }, // Africa/Bangui
    {   56, 6746,   23106,  7, }, // Africa/Banjul
    {   56, 7435,   23113,  5, }, // Africa/Bissau
    {   56, 4957,   23118, 13, }, // Africa/Blantyre
    {   56, 5287,   23131, 10, }, // Africa/Brazzaville
    {   56, 4922,   23141, 10, }, // Africa/Bujumbura
    {   56, 2320,   23151,  6, }, // Africa/Cairo
    {   56, 4117,   23157, 12, }, // Africa/Casablanca
    {   56, 7449,   23169,  5, }, // Africa/Ceuta
    {   56, 6773,   23174,  7, }, // Africa/Conakry
    {   56, 6840,   23181,  5, }, // Africa/Dakar
    {   56, 5130,   23186, 12, }, // Africa/Dar_es_Salaam
    {   56, 5043,   16935,  6, }, // Africa/Djibouti
    {   56, 5243,   23198,  7, }, // Africa/Douala
    {   56, 5166,   23205,  8, }, // Africa/El_Aaiun
    {   56, 6853,   23213,  8, }, // Africa/Freetown
    {   56, 4906,   23221,  9, }, // Africa/Gaborone
    {   56, 5015,   23230,  6, }, // Africa/Harare
    {   56, 4479,   23236, 12, }, // Africa/Johannesburg
    {   56, 4499,   16989,  4, }, // Africa/Juba
    {   56, 5151,   23248,  7, }, // Africa/Kampala
    {   56, 4524,   23255,  7, }, // Africa/Khartoum
    {   56, 4973,   23262,  6, }, // Africa/Kigali
    {   56, 5306,   23268,  7, }, // Africa/Kinshasa
    {   56, 4744,   23275,  5, }, // Africa/Lagos
    {   56, 5336,   23280,  9, }, // Africa/Libreville
    {   56, 6869,   23289,  4, }, // Africa/Lome
    {   56, 5211,   23293,  9, }, // Africa/Luanda
    {   56, 4939,   23302, 10, }, // Africa/Lubumbashi
    {   56, 5001,   23312,  6, }, // Africa/Lusaka
    {   56, 5322,   17063,  6, }, // Africa/Malabo
    {   56, 4987,   23318,  6, }, // Africa/Maputo
    {   56, 5197,   23324,  7, }, // Africa/Maseru
    {   56, 5182,   23331,  7, }, // Africa/Mbabane
    {   56, 5113,   23338,  9, }, // Africa/Mogadishu
    {   56, 7034,   23347,  9, }, // Africa/Monrovia
    {   56, 3853,   23356,  7, }, // Africa/Nairobi
    {   56, 5271,   23363,  7, }, // Africa/Ndjamena
    {   56, 5354,   23370,  7, }, // Africa/Niamey
    {   56, 6803,   23377,  8, }, // Africa/Nouakchott
    {   56, 6727,   23385, 11, }, // Africa/Ouagadougou
    {   56, 5225,   23396, 11, }, // Africa/Porto-Novo
    {   56, 4435,   23407,  7, }, // Africa/Sao_Tome
    {   56, 2866,   23414,  8, }, // Africa/Tripoli
    {   56, 6554,   23422,  6, }, // Africa/Tunis
    {   56, 4152,   23428,  6, }, // Africa/Windhoek
    {   56,  132,   23434,  3, }, // America/Adak
    {   56, 3346,   23437,  7, }, // America/Anchorage
    {   56, 5607,   23444, 11, }, // America/Anguilla
    {   56, 5624,   23455, 13, }, // America/Antigua
    {   56, 4554,   23468, 11, }, // America/Araguaina
    {   56,  166,   23479, 16, }, // America/Argentina/Buenos_Aires
    {   56,   91,   23495, 12, }, // America/Argentina/Catamarca
    {   56,  270,   23507,  7, }, // America/Argentina/Cordoba
    {   56,  441,   17251,  5, }, // America/Argentina/Jujuy
    {   56, 7462,   23514,  8, }, // America/Argentina/La_Rioja
    {   56,  565,   23522,  8, }, // America/Argentina/Mendoza
    {   56, 7489,   23530, 12, }, // America/Argentina/Rio_Gallegos
    {   56, 7520,   23542,  7, }, // America/Argentina/Salta
    {   56, 7544,   23549, 10, }, // America/Argentina/San_Juan
    {   56, 5580,   23559,  8, }, // America/Argentina/San_Luis
    {   56, 7571,   23567,  7, }, // America/Argentina/Tucuman
    {   56, 7597,   23574, 10, }, // America/Argentina/Ushuaia
    {   56, 5640,   23584,  5, }, // America/Aruba
    {   56, 4252,   23589,  9, }, // America/Asuncion
    {   56,  237,   17335,  8, }, // America/Atikokan
    {   56, 3679,   17343,  7, }, // America/Bahia
    {   56, 7623,   23598, 17, }, // America/Bahia_Banderas
    {   56, 5654,   23615,  9, }, // America/Barbados
    {   56, 7646,   17376,  5, }, // America/Belem
    {   56, 5407,   17381,  5, }, // America/Belize
    {   56, 7660,   23624, 15, }, // America/Blanc-Sablon
    {   56, 7681,   23639, 12, }, // America/Boa_Vista
    {   56, 4361,   17410,  6, }, // America/Bogota
    {   56, 7699,   23651,  5, }, // America/Boise
    {   56, 7713,   23656, 11, }, // America/Cambridge_Bay
    {   56, 7735,   23667, 15, }, // America/Campo_Grande
    {   56, 3868,   23682,  8, }, // America/Cancun
    {   56, 4694,   23690,  9, }, // America/Caracas
    {   56, 4345,   23699,  5, }, // America/Cayenne
    {   56, 5496,   23704,  5, }, // America/Cayman
    {   56, 2260,   23709,  6, }, // America/Chicago
    {   56, 7756,   23715, 12, }, // America/Chihuahua
    {   56, 7774,   23727, 15, }, // America/Ciudad_Juarez
    {   56, 5422,   23742, 10, }, // America/Costa_Rica
    {   56, 7796,   23752,  9, }, // America/Creston
    {   56, 3791,   23761,  8, }, // America/Cuiaba
    {   56, 5723,   23769,  7, }, // America/Curacao
    {   56, 7812,   23776, 14, }, // America/Danmarkshavn
    {   56, 7833,   23790,  4, }, // America/Dawson
    {   56, 7848,   23794, 10, }, // America/Dawson_Creek
    {   56,  805,   23804,  6, }, // America/Denver
    {   56, 3465,   23810,  8, }, // America/Detroit
    {   56, 5739,   23818,  8, }, // America/Dominica
    {   56,  893,   23826,  8, }, // America/Edmonton
    {   56, 7869,   23834,  8, }, // America/Eirunepe
    {   56, 5441,   23842, 11, }, // America/El_Salvador
    {   56, 7886,   23853, 11, }, // America/Fort_Nelson
    {   56, 7906,   23864, 10, }, // America/Fortaleza
    {   56, 7924,   23874,  8, }, // America/Glace_Bay
    {   56, 6881,   23882,  6, }, // America/Goose_Bay
    {   56, 4612,   23888, 15, }, // America/Grand_Turk
    {   56, 5770,   23903,  8, }, // America/Grenada
    {   56, 5786,   23911, 10, }, // America/Guadeloupe
    {   56, 3760,   23921, 11, }, // America/Guatemala
    {   56, 4841,   23932, 12, }, // America/Guayaquil
    {   56, 6932,   17701,  7, }, // America/Guyana
    {   56, 1939,   23944, 13, }, // America/Halifax
    {   56, 2281,   17717,  6, }, // America/Havana
    {   56, 7942,   23957, 11, }, // America/Hermosillo
    {   56,  348,   23968, 15, }, // America/Indiana/Indianapolis
    {   56,  481,   23983, 16, }, // America/Indiana/Knox
    {   56, 7961,   23999, 20, }, // America/Indiana/Marengo
    {   56, 7985,   24019, 25, }, // America/Indiana/Petersburg
    {   56, 8012,   24044, 19, }, // America/Indiana/Tell_City
    {   56, 8038,   24063, 18, }, // America/Indiana/Vevay
    {   56, 8060,   24081, 22, }, // America/Indiana/Vincennes
    {   56, 8086,   24103, 21, }, // America/Indiana/Winamac
    {   56, 8110,   24124,  8, }, // America/Inuvik
    {   56,  660,   24132, 10, }, // America/Iqaluit
    {   56, 2799,   17897,  7, }, // America/Jamaica
    {   56, 5380,   24142,  4, }, // America/Juneau
    {   56,  521,   24146,  7, }, // America/Kentucky/Louisville
    {   56, 8125,   24153, 19, }, // America/Kentucky/Monticello
    {   56, 5704,   24172, 13, }, // America/Kralendijk
    {   56, 4376,   17949,  6, }, // America/La_Paz
    {   56, 7169,   17955,  4, }, // America/Lima
    {   56, 3239,   24185, 14, }, // America/Los_Angeles
    {   56, 5932,   24199, 27, }, // America/Lower_Princes
    {   56, 8153,   24226,  7, }, // America/Maceio
    {   56, 8168,   24233,  9, }, // America/Managua
    {   56, 1908,   24242,  6, }, // America/Manaus
    {   56, 5897,   24248,  6, }, // America/Marigot
    {   56, 5805,   24254,  8, }, // America/Martinique
    {   56, 8184,   24262,  8, }, // America/Matamoros
    {   56, 2917,   24270,  8, }, // America/Mazatlan
    {   56, 8202,   24278,  8, }, // America/Menominee
    {   56, 8220,   24286,  6, }, // America/Merida
    {   56, 8235,   24292, 10, }, // America/Metlakatla
    {   56, 2949,   24302, 13, }, // America/Mexico_City
    {   56, 4391,   24315,  6, }, // America/Miquelon
    {   56, 8254,   24321,  7, }, // America/Moncton
    {   56, 8270,   24328,  7, }, // America/Monterrey
    {   56, 4098,   24335, 10, }, // America/Montevideo
    {   56, 5824,   24345,  9, }, // America/Montserrat
    {   56, 5481,   24354,  5, }, // America/Nassau
    {   56, 2379,   24359,  9, }, // America/New_York
    {   56, 8288,   18050,  3, }, // America/Nome
    {   56, 1850,   24368,  8, }, // America/Noronha
    {   56, 8301,   24376, 19, }, // America/North_Dakota/Beulah
    {   56, 8329,   24395, 18, }, // America/North_Dakota/Center
    {   56, 8357,   24413, 23, }, // America/North_Dakota/New_Salem
    {   56,  393,   18220,  3, }, // America/Nuuk
    {   56, 8388,   24436,  7, }, // America/Ojinaga
    {   56, 2356,   18231,  6, }, // America/Panama
    {   56, 6173,   24443, 12, }, // America/Paramaribo
    {   56, 2973,   18247,  7, }, // America/Phoenix
    {   56, 3945,   24455, 16, }, // America/Port-au-Prince
    {   56, 5954,   24471, 14, }, // America/Port_of_Spain
    {   56, 8404,   24485, 14, }, // America/Porto_Velho
    {   56, 5843,   24499, 14, }, // America/Puerto_Rico
    {   56, 4030,   24513, 13, }, // America/Punta_Arenas
    {   56, 8424,   24526, 16, }, // America/Rankin_Inlet
    {   56, 8445,   24542,  6, }, // America/Recife
    {   56, 1995,   24548,  6, }, // America/Regina
    {   56, 8460,   24554,  7, }, // America/Resolute
    {   56,  695,   24561, 12, }, // America/Rio_Branco
    {   56, 8477,   24573,  8, }, // America/Santarem
    {   56, 2201,   24581, 11, }, // America/Santiago
    {   56, 6111,   24592, 16, }, // America/Santo_Domingo
    {   56, 1878,   24608,  9, }, // America/Sao_Paulo
    {   56, 6899,   24617, 16, }, // America/Scoresbysund
    {   56, 8494,   24633,  5, }, // America/Sitka
    {   56, 8508,   24638, 16, }, // America/St_Barthelemy
    {   56, 2061,   24654, 10, }, // America/St_Johns
    {   56, 5863,   24664, 11, }, // America/St_Kitts
    {   56, 5880,   24675, 14, }, // America/St_Lucia
    {   56,  855,   24689, 11, }, // America/St_Thomas
    {   56, 5913,   24700, 15, }, // America/St_Vincent
    {   56, 8530,   24715, 14, }, // America/Swift_Current
    {   56, 5461,   24729, 11, }, // America/Tegucigalpa
    {   56, 5756,   24740,  4, }, // America/Thule
    {   56,  313,   24744,  9, }, // America/Tijuana
    {   56,  608,   24753,  7, }, // America/Toronto
    {   56, 5688,   24760,  6, }, // America/Tortola
    {   56, 2093,   24766, 11, }, // America/Vancouver
    {   56, 2144,   24777, 11, }, // America/Whitehorse
    {   56,  734,   24788,  7, }, // America/Winnipeg
    {   56, 8552,   24795,  9, }, // America/Yakutat
    {   56, 6001,   24804,  5, }, // Antarctica/Casey
    {   56, 6094,   24809,  5, }, // Antarctica/Davis
    {   56, 6133,   24814, 15, }, // Antarctica/DumontDUrville
    {   56, 8568,   24829, 14, }, // Antarctica/Macquarie
    {   56, 7066,   24843,  4, }, // Antarctica/Mawson
    {   56, 7113,   24847, 11, }, // Antarctica/McMurdo
    {   56, 8589,   24858,  6, }, // Antarctica/Palmer
    {   56, 7226,   24864,  5, }, // Antarctica/Rothera
    {   56, 7295,   24869,  6, }, // Antarctica/Syowa
    {   56, 8607,   24875,  4, }, // Antarctica/Troll
    {   56, 7374,   24879,  6, }, // Antarctica/Vostok
    {   56, 1429,   24885, 14, }, // Arctic/Longyearbyen
    {   56, 5570,   24899,  5, }, // Asia/Aden
    {   56, 5395,   18694,  6, }, // Asia/Almaty
    {   56, 3968,   18700,  6, }, // Asia/Amman
    {   56, 5511,   24904,  9, }, // Asia/Anadyr
    {   56, 5523,   24913,  5, }, // Asia/Aqtau
    {   56, 5368,   24918,  6, }, // Asia/Aqtobe
    {   56,  964,   24924,  7, }, // Asia/Ashgabat
    {   56, 8624,   24931,  6, }, // Asia/Atyrau
    {   56, 3607,   18745,  6, }, // Asia/Baghdad
    {   56, 5534,   24937,  7, }, // Asia/Bahrain
    {   56, 3653,   17526,  4, }, // Asia/Baku
    {   56, 4466,   24944,  7, }, // Asia/Bangkok
    {   56, 3571,   24951,  7, }, // Asia/Barnaul
    {   56, 4086,   24958,  6, }, // Asia/Beirut
    {   56, 3778,   24964,  6, }, // Asia/Bishkek
    {   56, 5989,   24970,  7, }, // Asia/Brunei
    {   56, 4601,   24977,  4, }, // Asia/Chita
    {   56, 4511,   18797,  6, }, // Asia/Colombo
    {   56, 4540,   24981,  9, }, // Asia/Damascus
    {   56, 1093,   18812,  4, }, // Asia/Dhaka
    {   56, 6192,   24990,  4, }, // Asia/Dili
    {   56, 3596,   24994,  5, }, // Asia/Dubai
    {   56, 6159,   24999,  7, }, // Asia/Dushanbe
    {   56, 8636,   25006, 10, }, // Asia/Famagusta
    {   56, 8651,   18842,  4, }, // Asia/Gaza
    {   56, 4795,   25016,  7, }, // Asia/Hebron
    {   56, 1259,   25023, 13, }, // Asia/Ho_Chi_Minh
    {   56, 2704,   18867,  5, }, // Asia/Hong_Kong
    {   56, 4771,   25036,  5, }, // Asia/Hovd
    {   56, 4184,   25041,  8, }, // Asia/Irkutsk
    {   56, 7006,   25049,  8, }, // Asia/Jakarta
    {   56, 6992,   25057,  8, }, // Asia/Jayapura
    {   56, 1290,   25065,  9, }, // Asia/Jerusalem
    {   56, 3560,   18914,  5, }, // Asia/Kabul
    {   56, 4316,   25074,  8, }, // Asia/Kamchatka
    {   56, 4239,   25082,  5, }, // Asia/Karachi
    {   56, 1185,   25087,  9, }, // Asia/Kathmandu
    {   56, 8661,   25096, 10, }, // Asia/Khandyga
    {   56,  992,   25106,  7, }, // Asia/Kolkata
    {   56, 4197,   25113, 16, }, // Asia/Krasnoyarsk
    {   56, 4859,   25129, 13, }, // Asia/Kuala_Lumpur
    {   56, 5976,   18982,  5, }, // Asia/Kuching
    {   56, 5547,   25142,  6, }, // Asia/Kuwait
    {   56, 1211,   25148,  7, }, // Asia/Macau
    {   56, 4017,   25155,  9, }, // Asia/Magadan
    {   56, 1349,   25164,  8, }, // Asia/Makassar
    {   56, 7182,   25172,  8, }, // Asia/Manila
    {   56, 6920,   25180,  5, }, // Asia/Muscat
    {   56, 2554,   25185,  9, }, // Asia/Nicosia
    {   56, 8675,   25194, 12, }, // Asia/Novokuznetsk
    {   56, 4135,   25206, 12, }, // Asia/Novosibirsk
    {   56, 4229,   25218,  6, }, // Asia/Omsk
    {   56, 7145,   25224,  4, }, // Asia/Oral
    {   56, 6961,   25228,  6, }, // Asia/Phnom_Penh
    {   56, 8693,   25234, 13, }, // Asia/Pontianak
    {   56, 4214,   25247,  9, }, // Asia/Pyongyang
    {   56, 5559,   25256,  5, }, // Asia/Qatar
    {   56, 8708,   25261,  9, }, // Asia/Qostanay
    {   56, 4269,   25270,  9, }, // Asia/Qyzylorda
    {   56, 3584,   25279,  6, }, // Asia/Riyadh
    {   56, 4408,   25285,  7, }, // Asia/Sakhalin
    {   56, 7245,   25292,  7, }, // Asia/Samarkand
    {   56, 3279,   25299,  4, }, // Asia/Seoul
    {   56, 1053,   25303,  6, }, // Asia/Shanghai
    {   56, 3300,   25309,  9, }, // Asia/Singapore
    {   56, 4297,   25318, 16, }, // Asia/Srednekolymsk
    {   56, 3263,   25334,  6, }, // Asia/Taipei
    {   56, 4781,   25340,  7, }, // Asia/Tashkent
    {   56, 3915,   25347,  8, }, // Asia/Tbilisi
    {   56, 2772,   25355,  7, }, // Asia/Tehran
    {   56, 1317,   19206,  6, }, // Asia/Thimphu
    {   56, 2821,   25362,  5, }, // Asia/Tokyo
    {   56, 4572,   25367,  6, }, // Asia/Tomsk
    {   56, 1021,   25373,  9, }, // Asia/Ulaanbaatar
    {   56, 1159,   25382,  6, }, // Asia/Urumqi
    {   56, 8722,   25388, 10, }, // Asia/Ust-Nera
    {   56, 6977,   25398, 12, }, // Asia/Vientiane
    {   56, 4710,   25410, 12, }, // Asia/Vladivostok
    {   56, 4828,   25422, 10, }, // Asia/Yakutsk
    {   56, 1235,   25432,  7, }, // Asia/Yangon
    {   56, 3883,   25439, 16, }, // Asia/Yekaterinburg
    {   56, 3747,   25455,  9, }, // Asia/Yerevan
    {   56, 3663,   25464,  6, }, // Atlantic/Azores
    {   56, 5671,   25470,  7, }, // Atlantic/Bermuda
    {   56, 6628,   25477,  6, }, // Atlantic/Canary
    {   56, 3727,   25483,  9, }, // Atlantic/Cape_Verde
    {   56, 1395,   25492,  6, }, // Atlantic/Faroe
    {   56, 8736,   25498,  7, }, // Atlantic/Madeira
    {   56, 2748,   25505,  8, }, // Atlantic/Reykjavik
    {   56, 7272,   25513, 15, }, // Atlantic/South_Georgia
    {   56, 6821,   25528, 13, }, // Atlantic/St_Helena
    {   56, 6644,   25541,  7, }, // Atlantic/Stanley
    {   56, 1670,   25548, 10, }, // Australia/Adelaide
    {   56, 1635,   25558,  8, }, // Australia/Brisbane
    {   56, 1799,   25566, 11, }, // Australia/Broken_Hill
    {   56, 1583,   25577,  6, }, // Australia/Darwin
    {   56, 3637,   19433,  6, }, // Australia/Eucla
    {   56, 1516,   25583,  7, }, // Australia/Hobart
    {   56, 8753,   25590, 10, }, // Australia/Lindeman
    {   56, 1547,   25600,  8, }, // Australia/Lord_Howe
    {   56, 1727,   25608,  8, }, // Australia/Melbourne
    {   56, 1762,   25616,  5, }, // Australia/Perth
    {   56, 1463,   25621,  5, }, // Australia/Sydney
    {   56, 6441,   25626, 10, }, // Europe/Amsterdam
    {   56, 6216,   25636, 10, }, // Europe/Andorra
    {   56, 3620,   25646,  9, }, // Europe/Astrakhan
    {   56, 2300,   19507,  6, }, // Europe/Athens
    {   56, 6336,   25655,  8, }, // Europe/Belgrade
    {   56, 4757,   25663,  7, }, // Europe/Berlin
    {   56, 6488,   25670, 12, }, // Europe/Bratislava
    {   56, 2167,   25682,  8, }, // Europe/Brussels
    {   56, 3928,   25690,  9, }, // Europe/Bucharest
    {   56, 3806,   25699,  9, }, // Europe/Budapest
    {   56, 8772,   25708,  8, }, // Europe/Busingen
    {   56, 2583,   25716,  8, }, // Europe/Chisinau
    {   56, 6289,   25724, 10, }, // Europe/Copenhagen
    {   56, 2338,   19590,  6, }, // Europe/Dublin
    {   56, 6307,   25734, 11, }, // Europe/Gibraltar
    {   56, 8788,   25745, 10, }, // Europe/Guernsey
    {   56, 6612,   25755,  9, }, // Europe/Helsinki
    {   56, 8804,   25764, 12, }, // Europe/Isle_of_Man
    {   56, 1130,   19631,  9, }, // Europe/Istanbul
    {   56, 8823,   25776,  6, }, // Europe/Jersey
    {   56, 3979,   25782, 12, }, // Europe/Kaliningrad
    {   56, 8929,   25794,  5, }, // Europe/Kirov
    {   56, 2527,   25799,  6, }, // Europe/Kyiv
    {   56, 3213,   25805,  5, }, // Europe/Lisbon
    {   56, 6506,   25810, 10, }, // Europe/Ljubljana
    {   56, 2501,   25820,  5, }, // Europe/London
    {   56, 6365,   25825, 12, }, // Europe/Luxembourg
    {   56, 4892,   25837,  7, }, // Europe/Madrid
    {   56, 6397,   19706,  6, }, // Europe/Malta
    {   56, 6582,   25844, 11, }, // Europe/Mariehamn
    {   56, 3693,   25855,  6, }, // Europe/Minsk
    {   56, 6410,   19728,  6, }, // Europe/Monaco
    {   56, 3537,   19734,  5, }, // Europe/Moscow
    {   56, 6458,   25861,  4, }, // Europe/Oslo
    {   56, 4284,   25865,  7, }, // Europe/Paris
    {   56, 6424,   25872,  9, }, // Europe/Podgorica
    {   56, 6275,   25881,  5, }, // Europe/Prague
    {   56, 8837,   25886,  4, }, // Europe/Riga
    {   56, 6324,   25496,  3, }, // Europe/Rome
    {   56, 4331,   25890,  6, }, // Europe/Samara
    {   56, 6470,   25896, 10, }, // Europe/San_Marino
    {   56, 6245,   25906,  8, }, // Europe/Sarajevo
    {   56, 4451,   25914,  7, }, // Europe/Saratov
    {   56, 8849,   25921, 10, }, // Europe/Simferopol
    {   56, 6383,   25931,  7, }, // Europe/Skopje
    {   56, 6599,   25938,  7, }, // Europe/Sofia
    {   56, 6523,   25945,  7, }, // Europe/Stockholm
    {   56, 8867,   25952,  6, }, // Europe/Tallinn
    {   56, 6202,   25958,  6, }, // Europe/Tirane
    {   56, 8882,   25964, 12, }, // Europe/Ulyanovsk
    {   56, 6352,   19855,  5, }, // Europe/Vaduz
    {   56, 6567,   25976,  7, }, // Europe/Vatican
    {   56, 6231,   19867,  7, }, // Europe/Vienna
    {   56, 8899,   25983,  7, }, // Europe/Vilnius
    {   56, 4727,   25990, 11, }, // Europe/Volgograd
    {   56, 3190,   26001,  6, }, // Europe/Warsaw
    {   56, 6261,   26007,  7, }, // Europe/Zagreb
    {   56, 6540,   26014,  5, }, // Europe/Zurich
    {   56, 5078,   26019, 13, }, // Indian/Antananarivo
    {   56, 6947,   26032,  5, }, // Indian/Chagos
    {   56, 6046,   26037,  8, }, // Indian/Christmas
    {   56, 6063,   26045,  5, }, // Indian/Cocos
    {   56, 5029,   26050,  6, }, // Indian/Comoro
    {   56, 6661,   26056,  9, }, // Indian/Kerguelen
    {   56, 7260,   19959,  4, }, // Indian/Mahe
    {   56, 7050,   19963,  8, }, // Indian/Maldives
    {   56, 4069,   26065,  6, }, // Indian/Mauritius
    {   56, 5098,   26071,  7, }, // Indian/Mayotte
    {   56, 7211,   26078,  9, }, // Indian/Reunion
    {   56, 4422,   19995,  6, }, // Pacific/Apia
    {   56,  932,   26087,  9, }, // Pacific/Auckland
    {   56, 3706,   26096,  9, }, // Pacific/Bougainville
    {   56, 3015,   26105,  7, }, // Pacific/Chatham
    {   56, 3157,   20025,  3, }, // Pacific/Chuuk
    {   56, 2237,   26112,  6, }, // Pacific/Easter
    {   56, 7360,   26118,  5, }, // Pacific/Efate
    {   56, 7327,   26123,  9, }, // Pacific/Fakaofo
    {   56, 3902,   20045,  4, }, // Pacific/Fiji
    {   56, 7343,   20049,  8, }, // Pacific/Funafuti
    {   56, 6678,   26132, 13, }, // Pacific/Galapagos
    {   56, 6696,   26145, 10, }, // Pacific/Gambier
    {   56, 3822,   26155, 13, }, // Pacific/Guadalcanal
    {   56, 6018,   24237,  6, }, // Pacific/Guam
    {   56, 2723,   26168,  7, }, // Pacific/Honolulu
    {   56, 3049,   26175, 10, }, // Pacific/Kanton
    {   56, 3998,   26185, 10, }, // Pacific/Kiritimati
    {   56, 7019,   26195,  7, }, // Pacific/Kosrae
    {   56, 2842,   26202, 11, }, // Pacific/Kwajalein
    {   56, 4877,   26213,  6, }, // Pacific/Majuro
    {   56, 4051,   26219,  9, }, // Pacific/Marquesas
    {   56, 8914,   26228,  7, }, // Pacific/Midway
    {   56, 7084,   26235,  5, }, // Pacific/Nauru
    {   56, 7132,   26240,  6, }, // Pacific/Niue
    {   56, 4168,   26246,  4, }, // Pacific/Norfolk
    {   56, 7098,   26250,  7, }, // Pacific/Noumea
    {   56, 3126,   26257, 13, }, // Pacific/Pago_Pago
    {   56, 7155,   20173,  5, }, // Pacific/Palau
    {   56, 7194,   26270, 11, }, // Pacific/Pitcairn
    {   56, 3096,   26281,  6, }, // Pacific/Pohnpei
    {   56, 4807,   26287, 12, }, // Pacific/Port_Moresby
    {   56, 6076,   26299, 11, }, // Pacific/Rarotonga
    {   56, 6031,   26310,  6, }, // Pacific/Saipan
    {   56, 7312,   20224,  6, }, // Pacific/Tahiti
    {   56, 6712,   26316,  8, }, // Pacific/Tarawa
    {   56, 4583,   26324, 10, }, // Pacific/Tongatapu
    {   56, 7392,   26334,  5, }, // Pacific/Wake
    {   56, 7405,   26339,  4, }, // Pacific/Wallis
    {   58,   14,       0,  6, }, // Africa/Asmara Basaa/Latin/Cameroon
    {   58, 4435,       6,  8, }, // Africa/Sao_Tome
    {   58, 4252,      14,  8, }, // America/Asuncion
    {   58,  237,      22,  8, }, // America/Atikokan
    {   58, 7623,      30, 17, }, // America/Bahia_Banderas
    {   58, 3868,      47,  6, }, // America/Cancun
    {   58, 7774,      53, 13, }, // America/Ciudad_Juarez
    {   58, 5723,      66,  7, }, // America/Curacao
    {   58,  481,      73, 13, }, // America/Indiana/Knox
    {   58, 7961,      86, 16, }, // America/Indiana/Marengo
    {   58, 7985,     102, 19, }, // America/Indiana/Petersburg
    {   58, 8012,     121, 18, }, // America/Indiana/Tell_City
    {   58, 8038,     139, 14, }, // America/Indiana/Vevay
    {   58, 8060,     153, 18, }, // America/Indiana/Vincennes
    {   58, 8086,     171, 16, }, // America/Indiana/Winamac
    {   58, 8125,     187, 20, }, // America/Kentucky/Monticello
    {   58, 5932,     207, 22, }, // America/Lower_Princes
    {   58, 8220,     229,  6, }, // America/Merida
    {   58, 8301,     235, 20, }, // America/North_Dakota/Beulah
    {   58, 8329,     255, 20, }, // America/North_Dakota/Center
    {   58, 8357,     275, 23, }, // America/North_Dakota/New_Salem
    {   58,  393,     298,  4, }, // America/Nuuk
    {   58, 6899,     302, 16, }, // America/Scoresbysund
    {   58, 8508,     318, 14, }, // America/St_Barthelemy
    {   58, 2061,     332, 10, }, // America/St_Johns
    {   58, 5863,     342,  9, }, // America/St_Kitts
    {   58, 5880,     351,  9, }, // America/St_Lucia
    {   58,  855,     360, 10, }, // America/St_Thomas
    {   58, 5913,     370, 11, }, // America/St_Vincent
    {   58, 6133,     381, 16, }, // Antarctica/DumontDUrville
    {   58, 1259,     397, 11, }, // Asia/Ho_Chi_Minh
    {   58, 1185,     413,  9, }, // Asia/Kathmandu
    {   58,  992,     422,  7, }, // Asia/Kolkata
    {   58, 1211,     429,  5, }, // Asia/Macau
    {   58, 1235,     442,  6, }, // Asia/Yangon
    {   58, 1395,     448,  5, }, // Atlantic/Faroe
    {   58, 6821,     453, 10, }, // Atlantic/St_Helena
    {   58, 2527,     463,  4, }, // Europe/Kyiv
    {   58, 7211,     467,  7, }, // Indian/Reunion
    {   58, 3157,     474,  5, }, // Pacific/Chuuk
    {   58, 3096,     479,  7, }, // Pacific/Pohnpei
    {   59,   14,       0,  6, }, // Africa/Asmara Bashkir/Cyrillic/Russia
    {   59, 4435,       6,  8, }, // Africa/Sao_Tome
    {   59, 4252,      14,  8, }, // America/Asuncion
    {   59,  237,      22,  8, }, // America/Atikokan
    {   59, 7623,      30, 17, }, // America/Bahia_Banderas
    {   59, 3868,      47,  6, }, // America/Cancun
    {   59, 7774,      53, 13, }, // America/Ciudad_Juarez
    {   59, 5723,      66,  7, }, // America/Curacao
    {   59,  481,      73, 13, }, // America/Indiana/Knox
    {   59, 7961,      86, 16, }, // America/Indiana/Marengo
    {   59, 7985,     102, 19, }, // America/Indiana/Petersburg
    {   59, 8012,     121, 18, }, // America/Indiana/Tell_City
    {   59, 8038,     139, 14, }, // America/Indiana/Vevay
    {   59, 8060,     153, 18, }, // America/Indiana/Vincennes
    {   59, 8086,     171, 16, }, // America/Indiana/Winamac
    {   59, 8125,     187, 20, }, // America/Kentucky/Monticello
    {   59, 5932,     207, 22, }, // America/Lower_Princes
    {   59, 8220,     229,  6, }, // America/Merida
    {   59, 8301,     235, 20, }, // America/North_Dakota/Beulah
    {   59, 8329,     255, 20, }, // America/North_Dakota/Center
    {   59, 8357,     275, 23, }, // America/North_Dakota/New_Salem
    {   59,  393,     298,  4, }, // America/Nuuk
    {   59, 6899,     302, 16, }, // America/Scoresbysund
    {   59, 8508,     318, 14, }, // America/St_Barthelemy
    {   59, 2061,     332, 10, }, // America/St_Johns
    {   59, 5863,     342,  9, }, // America/St_Kitts
    {   59, 5880,     351,  9, }, // America/St_Lucia
    {   59,  855,     360, 10, }, // America/St_Thomas
    {   59, 5913,     370, 11, }, // America/St_Vincent
    {   59, 6133,     381, 16, }, // Antarctica/DumontDUrville
    {   59, 1259,     397, 11, }, // Asia/Ho_Chi_Minh
    {   59, 1185,     413,  9, }, // Asia/Kathmandu
    {   59,  992,     422,  7, }, // Asia/Kolkata
    {   59, 1211,     429,  5, }, // Asia/Macau
    {   59, 1235,     442,  6, }, // Asia/Yangon
    {   59, 1395,     448,  5, }, // Atlantic/Faroe
    {   59, 6821,     453, 10, }, // Atlantic/St_Helena
    {   59, 2527,     463,  4, }, // Europe/Kyiv
    {   59, 7211,     467,  7, }, // Indian/Reunion
    {   59, 3157,     474,  5, }, // Pacific/Chuuk
    {   59, 3096,     479,  7, }, // Pacific/Pohnpei
    {   60, 6760,   21174,  5, }, // Africa/Accra Basque/Latin/Spain
    {   60, 5059,    3784, 11, }, // Africa/Addis_Ababa
    {   60, 7420,   26343,  5, }, // Africa/Algiers
    {   60,   14,       0,  6, }, // Africa/Asmara
    {   60, 5257,   26348,  5, }, // Africa/Bangui
    {   60, 2320,    4572,  5, }, // Africa/Cairo
    {   60, 6773,   26353,  7, }, // Africa/Conakry
    {   60, 5043,   26360,  7, }, // Africa/Djibouti
    {   60, 5243,   21254,  5, }, // Africa/Douala
    {   60, 5166,   26367,  5, }, // Africa/El_Aaiun
    {   60, 4524,   26372,  7, }, // Africa/Khartoum
    {   60, 5113,   26379,  8, }, // Africa/Mogadishu
    {   60, 5271,   26387,  9, }, // Africa/Ndjamena
    {   60, 5354,   26396,  6, }, // Africa/Niamey
    {   60, 6803,   20324,  7, }, // Africa/Nouakchott
    {   60, 6727,   26402,  8, }, // Africa/Ouagadougou
    {   60, 5225,   26410, 10, }, // Africa/Porto-Novo
    {   60, 4435,       6,  8, }, // Africa/Sao_Tome
    {   60, 5607,   26420,  7, }, // America/Anguilla
    {   60, 4554,   26427,  9, }, // America/Araguaina
    {   60,  270,   20361,  7, }, // America/Argentina/Cordoba
    {   60, 7571,   20368,  7, }, // America/Argentina/Tucuman
    {   60, 4252,      14,  8, }, // America/Asuncion
    {   60,  237,      22,  8, }, // America/Atikokan
    {   60, 7623,      30, 17, }, // America/Bahia_Banderas
    {   60, 3868,      47,  6, }, // America/Cancun
    {   60, 5496,   26436,  6, }, // America/Cayman
    {   60, 7774,      53, 13, }, // America/Ciudad_Juarez
    {   60, 3791,   26442,  6, }, // America/Cuiaba
    {   60, 5723,      66,  7, }, // America/Curacao
    {   60, 5739,   21548,  8, }, // America/Dominica
    {   60, 7869,   26448,  8, }, // America/Eirunepe
    {   60, 5786,   20408,  9, }, // America/Guadeloupe
    {   60, 2281,   20420,  6, }, // America/Havana
    {   60,  481,      73, 13, }, // America/Indiana/Knox
    {   60, 7961,      86, 16, }, // America/Indiana/Marengo
    {   60, 7985,     102, 19, }, // America/Indiana/Petersburg
    {   60, 8012,     121, 18, }, // America/Indiana/Tell_City
    {   60, 8038,     139, 14, }, // America/Indiana/Vevay
    {   60, 8060,     153, 18, }, // America/Indiana/Vincennes
    {   60, 8086,     171, 16, }, // America/Indiana/Winamac
    {   60, 2799,    3877,  7, }, // America/Jamaica
    {   60, 8125,     187, 20, }, // America/Kentucky/Monticello
    {   60, 5932,     207, 22, }, // America/Lower_Princes
    {   60, 8153,   26456,  6, }, // America/Maceio
    {   60, 5805,   26462,  9, }, // America/Martinique
    {   60, 2917,   26471,  8, }, // America/Mazatlan
    {   60, 8220,     229,  6, }, // America/Merida
    {   60, 2949,   26479, 12, }, // America/Mexico_City
    {   60, 4391,   26491,  8, }, // America/Miquelon
    {   60, 8301,   26499, 19, }, // America/North_Dakota/Beulah
    {   60, 8329,   26518, 19, }, // America/North_Dakota/Center
    {   60, 8357,   26537, 22, }, // America/North_Dakota/New_Salem
    {   60,  393,     298,  4, }, // America/Nuuk
    {   60, 5954,   26559, 13, }, // America/Port_of_Spain
    {   60, 8477,   26572,  8, }, // America/Santarem
    {   60, 1878,   26580,  9, }, // America/Sao_Paulo
    {   60, 6899,     302, 16, }, // America/Scoresbysund
    {   60, 8508,   26589, 16, }, // America/St_Barthelemy
    {   60, 2061,   26605, 12, }, // America/St_Johns
    {   60, 5863,   26617, 11, }, // America/St_Kitts
    {   60, 5880,   26628, 11, }, // America/St_Lucia
    {   60,  855,   26639, 12, }, // America/St_Thomas
    {   60, 5913,   26651, 13, }, // America/St_Vincent
    {   60, 5756,   26664,  7, }, // America/Thule
    {   60, 6133,     381, 16, }, // Antarctica/DumontDUrville
    {   60, 5523,    5491,  5, }, // Asia/Aqtau
    {   60, 5368,    7488,  6, }, // Asia/Aqtobe
    {   60,  964,   26671,  7, }, // Asia/Ashgabat
    {   60, 3607,    4044,  6, }, // Asia/Baghdad
    {   60, 3778,   26678,  6, }, // Asia/Bishkek
    {   60, 4601,   26684,  5, }, // Asia/Chita
    {   60, 4511,    5519,  7, }, // Asia/Colombo
    {   60, 4540,   26689,  7, }, // Asia/Damascus
    {   60, 6159,   26696,  7, }, // Asia/Dushanbe
    {   60, 1259,     397, 11, }, // Asia/Ho_Chi_Minh
    {   60, 4771,   26703,  5, }, // Asia/Hovd
    {   60, 4316,   26708,  9, }, // Asia/Kamchatka
    {   60, 4239,   26717,  7, }, // Asia/Karachi
    {   60, 1185,    5593,  8, }, // Asia/Kathmandu
    {   60, 8661,   26724,  8, }, // Asia/Khandyga
    {   60,  992,   26732,  7, }, // Asia/Kolkata
    {   60, 4197,   26739, 11, }, // Asia/Krasnoyarsk
    {   60, 1211,    4203,  5, }, // Asia/Macau
    {   60, 6920,   26750,  6, }, // Asia/Muscat
    {   60, 2554,    5620,  7, }, // Asia/Nicosia
    {   60, 4214,   26756,  9, }, // Asia/Pyongyang
    {   60, 8708,     434,  8, }, // Asia/Qostanay
    {   60, 4269,   26765,  9, }, // Asia/Qyzylorda
    {   60, 3584,    7669,  4, }, // Asia/Riyadh
    {   60, 7245,   26774, 10, }, // Asia/Samarkand
    {   60, 3279,    7680,  4, }, // Asia/Seoul
    {   60, 3300,   20782,  8, }, // Asia/Singapore
    {   60, 4297,    7699, 13, }, // Asia/Srednekolymsk
    {   60, 4781,   26784,  7, }, // Asia/Tashkent
    {   60, 2772,    7724,  7, }, // Asia/Tehran
    {   60, 2821,    4238,  5, }, // Asia/Tokyo
    {   60, 1021,   26791, 10, }, // Asia/Ulaanbaatar
    {   60, 1159,   26801,  6, }, // Asia/Urumqi
    {   60, 6977,   26807,  8, }, // Asia/Vientiane
    {   60, 4828,    7755,  7, }, // Asia/Yakutsk
    {   60, 1235,     442,  6, }, // Asia/Yangon
    {   60, 3883,    4262, 13, }, // Asia/Yekaterinburg
    {   60, 3747,   26815,  6, }, // Asia/Yerevan
    {   60, 3663,   26821,  7, }, // Atlantic/Azores
    {   60, 6628,   26828,  8, }, // Atlantic/Canary
    {   60, 3727,   26836, 10, }, // Atlantic/Cape_Verde
    {   60, 1395,     448,  5, }, // Atlantic/Faroe
    {   60, 7272,   26846, 19, }, // Atlantic/South_Georgia
    {   60, 6821,   26865, 12, }, // Atlantic/St_Helena
    {   60, 2300,   26877,  6, }, // Europe/Athens
    {   60, 6336,   26883,  7, }, // Europe/Belgrade
    {   60, 2167,   26890,  7, }, // Europe/Brussels
    {   60, 3928,   26897,  8, }, // Europe/Bucharest
    {   60, 8772,   26905,  8, }, // Europe/Busingen
    {   60, 6289,    4357,  9, }, // Europe/Copenhagen
    {   60, 8788,   26913,  9, }, // Europe/Guernsey
    {   60, 8804,   26922, 11, }, // Europe/Isle_of_Man
    {   60, 2527,    8030,  4, }, // Europe/Kyiv
    {   60, 3213,   21019,  6, }, // Europe/Lisbon
    {   60, 2501,   21034,  7, }, // Europe/London
    {   60, 6365,   26933, 10, }, // Europe/Luxembourg
    {   60, 4892,   26943,  6, }, // Europe/Madrid
    {   60, 6410,    5926,  6, }, // Europe/Monaco
    {   60, 3537,   26949,  5, }, // Europe/Moscow
    {   60, 6275,   21067,  5, }, // Europe/Prague
    {   60, 6324,   26954,  6, }, // Europe/Rome
    {   60, 6202,   21095,  6, }, // Europe/Tirane
    {   60, 8882,   26960,  9, }, // Europe/Ulyanovsk
    {   60, 6567,   26969, 14, }, // Europe/Vatican
    {   60, 6231,   21112,  5, }, // Europe/Vienna
    {   60, 3190,   21126,  8, }, // Europe/Warsaw
    {   60, 6540,    4459,  6, }, // Europe/Zurich
    {   60, 7260,   26983,  4, }, // Indian/Mahe
    {   60, 7050,   26987,  8, }, // Indian/Maldives
    {   60, 4069,   26995,  8, }, // Indian/Mauritius
    {   60, 7211,     467,  7, }, // Indian/Reunion
    {   60, 3157,     474,  5, }, // Pacific/Chuuk
    {   60, 2237,   27003, 13, }, // Pacific/Easter
    {   60, 7360,   27016,  5, }, // Pacific/Efate
    {   60, 6678,   27021, 10, }, // Pacific/Galapagos
    {   60, 2723,    4493,  8, }, // Pacific/Honolulu
    {   60, 3049,    4501,  9, }, // Pacific/Kanton
    {   60, 4051,   27031,  8, }, // Pacific/Marquesas
    {   60, 7098,    4510,  6, }, // Pacific/Noumea
    {   60, 3096,     479,  7, }, // Pacific/Pohnpei
    {   61, 6788,   27039,  7, }, // Africa/Abidjan Belarusian/Cyrillic/Belarus
    {   61, 6760,   27046,  4, }, // Africa/Accra
    {   61, 5059,   27050, 10, }, // Africa/Addis_Ababa
    {   61, 7420,   27060,  5, }, // Africa/Algiers
    {   61,   14,   27065,  6, }, // Africa/Asmara
    {   61,   44,     519,  6, }, // Africa/Bamako
    {   61, 5257,   27071,  5, }, // Africa/Bangui
    {   61, 6746,   27076,  7, }, // Africa/Banjul
    {   61, 7435,   27083,  5, }, // Africa/Bissau
    {   61, 4957,   27088,  8, }, // Africa/Blantyre
    {   61, 5287,   27096,  9, }, // Africa/Brazzaville
    {   61, 4922,     558,  9, }, // Africa/Bujumbura
    {   61, 2320,   27105,  4, }, // Africa/Cairo
    {   61, 4117,     571, 10, }, // Africa/Casablanca
    {   61, 7449,     581,  5, }, // Africa/Ceuta
    {   61, 6773,   27109,  7, }, // Africa/Conakry
    {   61, 6840,     593,  5, }, // Africa/Dakar
    {   61, 5130,   27116, 12, }, // Africa/Dar_es_Salaam
    {   61, 5043,   27128,  7, }, // Africa/Djibouti
    {   61, 5243,     616,  5, }, // Africa/Douala
    {   61, 5166,   27135,  7, }, // Africa/El_Aaiun
    {   61, 6853,   27142,  7, }, // Africa/Freetown
    {   61, 4906,   27149,  8, }, // Africa/Gaborone
    {   61, 5015,   27157,  6, }, // Africa/Harare
    {   61, 4479,   27163, 10, }, // Africa/Johannesburg
    {   61, 4499,   27173,  5, }, // Africa/Juba
    {   61, 5151,     665,  7, }, // Africa/Kampala
    {   61, 4524,     672,  6, }, // Africa/Khartoum
    {   61, 4973,   27178,  6, }, // Africa/Kigali
    {   61, 5306,   27184,  7, }, // Africa/Kinshasa
    {   61, 4744,   27191,  5, }, // Africa/Lagos
    {   61, 5336,   27196,  9, }, // Africa/Libreville
    {   61, 6869,   27205,  4, }, // Africa/Lome
    {   61, 5211,     708,  6, }, // Africa/Luanda
    {   61, 4939,   27209,  9, }, // Africa/Lubumbashi
    {   61, 5001,     723,  6, }, // Africa/Lusaka
    {   61, 5322,   27218,  6, }, // Africa/Malabo
    {   61, 4987,     735,  6, }, // Africa/Maputo
    {   61, 5197,     741,  6, }, // Africa/Maseru
    {   61, 5182,   27224,  7, }, // Africa/Mbabane
    {   61, 5113,   27231,  8, }, // Africa/Mogadishu
    {   61, 7034,   27239,  8, }, // Africa/Monrovia
    {   61, 3853,   27247,  7, }, // Africa/Nairobi
    {   61, 5271,   27254,  8, }, // Africa/Ndjamena
    {   61, 5354,   27262,  6, }, // Africa/Niamey
    {   61, 6803,     790,  7, }, // Africa/Nouakchott
    {   61, 6727,     797,  8, }, // Africa/Ouagadougou
    {   61, 5225,   27268, 10, }, // Africa/Porto-Novo
    {   61, 4435,   27278,  8, }, // Africa/Sao_Tome
    {   61, 2866,   27286,  7, }, // Africa/Tripoli
    {   61, 6554,   27293,  5, }, // Africa/Tunis
    {   61, 4152,   27298,  7, }, // Africa/Windhoek
    {   61,  132,     842,  4, }, // America/Adak
    {   61, 3346,   27305,  8, }, // America/Anchorage
    {   61, 5607,   27313,  7, }, // America/Anguilla
    {   61, 5624,   27320,  7, }, // America/Antigua
    {   61, 4554,   27327,  9, }, // America/Araguaina
    {   61,  166,   27336, 12, }, // America/Argentina/Buenos_Aires
    {   61,   91,     888,  9, }, // America/Argentina/Catamarca
    {   61,  270,   27348,  7, }, // America/Argentina/Cordoba
    {   61,  441,   27355,  5, }, // America/Argentina/Jujuy
    {   61, 7462,   27360,  8, }, // America/Argentina/La_Rioja
    {   61,  565,     917,  7, }, // America/Argentina/Mendoza
    {   61, 7489,   27368, 12, }, // America/Argentina/Rio_Gallegos
    {   61, 7520,   27380,  6, }, // America/Argentina/Salta
    {   61, 7544,     940,  8, }, // America/Argentina/San_Juan
    {   61, 5580,   27386,  8, }, // America/Argentina/San_Luis
    {   61, 7571,     956,  7, }, // America/Argentina/Tucuman
    {   61, 7597,   27394,  5, }, // America/Argentina/Ushuaia
    {   61, 5640,     969,  5, }, // America/Aruba
    {   61, 4252,   27399,  8, }, // America/Asuncion
    {   61,  237,   27407,  8, }, // America/Atikokan
    {   61, 3679,   27415,  4, }, // America/Bahia
    {   61, 7623,   27419, 16, }, // America/Bahia_Banderas
    {   61, 5654,   27435,  8, }, // America/Barbados
    {   61, 7646,    1021,  5, }, // America/Belem
    {   61, 5407,   27443,  5, }, // America/Belize
    {   61, 7660,    1031, 12, }, // America/Blanc-Sablon
    {   61, 7681,   27448,  9, }, // America/Boa_Vista
    {   61, 4361,   27457,  6, }, // America/Bogota
    {   61, 7699,   27463,  5, }, // America/Boise
    {   61, 7713,   27468, 12, }, // America/Cambridge_Bay
    {   61, 7735,   27480, 12, }, // America/Campo_Grande
    {   61, 3868,    1087,  6, }, // America/Cancun
    {   61, 4694,    1093,  7, }, // America/Caracas
    {   61, 4345,   27492,  5, }, // America/Cayenne
    {   61, 5496,   27497, 17, }, // America/Cayman
    {   61, 2260,   27514,  6, }, // America/Chicago
    {   61, 7756,   27520,  6, }, // America/Chihuahua
    {   61, 7774,   27526, 13, }, // America/Ciudad_Juarez
    {   61, 5422,   27539, 10, }, // America/Costa_Rica
    {   61, 7796,   27549,  7, }, // America/Creston
    {   61, 3791,   27556,  5, }, // America/Cuiaba
    {   61, 5723,   27561,  7, }, // America/Curacao
    {   61, 7812,   27568, 12, }, // America/Danmarkshavn
    {   61, 7833,   27580,  6, }, // America/Dawson
    {   61, 7848,   27586, 10, }, // America/Dawson_Creek
    {   61,  805,   27596,  6, }, // America/Denver
    {   61, 3465,   27602,  7, }, // America/Detroit
    {   61, 5739,   27609,  8, }, // America/Dominica
    {   61,  893,   27617,  8, }, // America/Edmonton
    {   61, 7869,   27625,  8, }, // America/Eirunepe
    {   61, 5441,   27633,  9, }, // America/El_Salvador
    {   61, 7886,   27642, 12, }, // America/Fort_Nelson
    {   61, 7906,   27654,  9, }, // America/Fortaleza
    {   61, 7924,   27663,  9, }, // America/Glace_Bay
    {   61, 6881,   27672,  7, }, // America/Goose_Bay
    {   61, 4612,   27679, 10, }, // America/Grand_Turk
    {   61, 5770,   27689,  7, }, // America/Grenada
    {   61, 5786,   27696,  9, }, // America/Guadeloupe
    {   61, 3760,   27705,  9, }, // America/Guatemala
    {   61, 4841,   27714,  8, }, // America/Guayaquil
    {   61, 6932,   27722,  5, }, // America/Guyana
    {   61, 1939,   27727,  8, }, // America/Halifax
    {   61, 2281,    1339,  6, }, // America/Havana
    {   61, 7942,   27735,  9, }, // America/Hermosillo
    {   61,  348,   27744, 12, }, // America/Indiana/Indianapolis
    {   61,  481,   27756, 13, }, // America/Indiana/Knox
    {   61, 7961,   27769, 16, }, // America/Indiana/Marengo
    {   61, 7985,   27785, 19, }, // America/Indiana/Petersburg
    {   61, 8012,   27804, 17, }, // America/Indiana/Tell_City
    {   61, 8038,   27821, 13, }, // America/Indiana/Vevay
    {   61, 8060,   27834, 16, }, // America/Indiana/Vincennes
    {   61, 8086,   27850, 16, }, // America/Indiana/Winamac
    {   61, 8110,   27866,  6, }, // America/Inuvik
    {   61,  660,   27872,  7, }, // America/Iqaluit
    {   61, 2799,   27879,  6, }, // America/Jamaica
    {   61, 5380,   27885,  5, }, // America/Juneau
    {   61,  521,   27890,  7, }, // America/Kentucky/Louisville
    {   61, 8125,   27897, 18, }, // America/Kentucky/Monticello
    {   61, 5704,   27915, 10, }, // America/Kralendijk
    {   61, 4376,    1514,  6, }, // America/La_Paz
    {   61, 7169,   27925,  4, }, // America/Lima
    {   61, 3239,   27929, 12, }, // America/Los_Angeles
    {   61, 5932,   27941, 20, }, // America/Lower_Princes
    {   61, 8153,   27961,  5, }, // America/Maceio
    {   61, 8168,    1559,  7, }, // America/Managua
    {   61, 1908,   27966,  6, }, // America/Manaus
    {   61, 5897,   27972,  6, }, // America/Marigot
    {   61, 5805,   27978,  9, }, // America/Martinique
    {   61, 8184,   27987,  9, }, // America/Matamoros
    {   61, 2917,    1596,  8, }, // America/Mazatlan
    {   61, 8202,   27996,  8, }, // America/Menominee
    {   61, 8220,   28004,  6, }, // America/Merida
    {   61, 8235,    1618, 10, }, // America/Metlakatla
    {   61, 2949,   28010,  6, }, // America/Mexico_City
    {   61, 4391,   28016,  7, }, // America/Miquelon
    {   61, 8254,   28023,  7, }, // America/Moncton
    {   61, 8270,   28030,  8, }, // America/Monterrey
    {   61, 4098,   28038, 10, }, // America/Montevideo
    {   61, 5824,   28048,  9, }, // America/Montserrat
    {   61, 5481,   28057,  5, }, // America/Nassau
    {   61, 2379,   28062,  7, }, // America/New_York
    {   61, 8288,    1691,  3, }, // America/Nome
    {   61, 1850,   28069,  7, }, // America/Noronha
    {   61, 8301,   28076, 23, }, // America/North_Dakota/Beulah
    {   61, 8329,   28099, 24, }, // America/North_Dakota/Center
    {   61, 8357,   28123, 28, }, // America/North_Dakota/New_Salem
    {   61,  393,   28151,  3, }, // America/Nuuk
    {   61, 8388,   28154,  7, }, // America/Ojinaga
    {   61, 2356,    1783,  6, }, // America/Panama
    {   61, 6173,   28161, 10, }, // America/Paramaribo
    {   61, 2973,   28171,  6, }, // America/Phoenix
    {   61, 3945,   28177, 12, }, // America/Port-au-Prince
    {   61, 5954,   28189, 13, }, // America/Port_of_Spain
    {   61, 8404,   28202, 11, }, // America/Porto_Velho
    {   61, 5843,   28213, 11, }, // America/Puerto_Rico
    {   61, 4030,   28224, 12, }, // America/Punta_Arenas
    {   61, 8424,   28236, 12, }, // America/Rankin_Inlet
    {   61, 8445,   28248,  6, }, // America/Recife
    {   61, 1995,   28254,  8, }, // America/Regina
    {   61, 8460,   28262,  8, }, // America/Resolute
    {   61,  695,   28270, 10, }, // America/Rio_Branco
    {   61, 8477,   28280,  8, }, // America/Santarem
    {   61, 2201,   28288,  8, }, // America/Santiago
    {   61, 6111,   28296, 13, }, // America/Santo_Domingo
    {   61, 1878,   28309,  9, }, // America/Sao_Paulo
    {   61, 6899,   28318, 13, }, // America/Scoresbysund
    {   61, 8494,   28331,  5, }, // America/Sitka
    {   61, 8508,   28336, 13, }, // America/St_Barthelemy
    {   61, 2061,   28349, 10, }, // America/St_Johns
    {   61, 5863,   28359,  9, }, // America/St_Kitts
    {   61, 5880,   28368, 10, }, // America/St_Lucia
    {   61,  855,    2003, 10, }, // America/St_Thomas
    {   61, 5913,   28378, 12, }, // America/St_Vincent
    {   61, 8530,   28390, 12, }, // America/Swift_Current
    {   61, 5461,   28402, 12, }, // America/Tegucigalpa
    {   61, 5756,    2049,  4, }, // America/Thule
    {   61,  313,   28414,  7, }, // America/Tijuana
    {   61,  608,   28421,  7, }, // America/Toronto
    {   61, 5688,   28428,  7, }, // America/Tortola
    {   61, 2093,    2074,  8, }, // America/Vancouver
    {   61, 2144,   28435,  8, }, // America/Whitehorse
    {   61,  734,   28443,  7, }, // America/Winnipeg
    {   61, 8552,   28450,  6, }, // America/Yakutat
    {   61, 6001,   28456,  5, }, // Antarctica/Casey
    {   61, 6094,   28461,  6, }, // Antarctica/Davis
    {   61, 6133,   28467, 15, }, // Antarctica/DumontDUrville
    {   61, 8568,   28482,  7, }, // Antarctica/Macquarie
    {   61, 7066,   28489,  6, }, // Antarctica/Mawson
    {   61, 7113,   28495,  9, }, // Antarctica/McMurdo
    {   61, 8589,    2154,  6, }, // Antarctica/Palmer
    {   61, 7226,   28504,  6, }, // Antarctica/Rothera
    {   61, 7295,   28510,  4, }, // Antarctica/Syowa
    {   61, 8607,    2171,  4, }, // Antarctica/Troll
    {   61, 7374,   28514,  6, }, // Antarctica/Vostok
    {   61, 1429,   28520,  7, }, // Arctic/Longyearbyen
    {   61, 5570,   28527,  4, }, // Asia/Aden
    {   61, 5395,    2196,  6, }, // Asia/Almaty
    {   61, 3968,   28531, 12, }, // Asia/Amman
    {   61, 5511,    2207,  6, }, // Asia/Anadyr
    {   61, 5523,    2213,  5, }, // Asia/Aqtau
    {   61, 5368,   28543,  6, }, // Asia/Aqtobe
    {   61,  964,   28549,  7, }, // Asia/Ashgabat
    {   61, 8624,    2231,  6, }, // Asia/Atyrau
    {   61, 3607,    2237,  6, }, // Asia/Baghdad
    {   61, 5534,   28556,  7, }, // Asia/Bahrain
    {   61, 3653,    2250,  4, }, // Asia/Baku
    {   61, 4466,    2254,  7, }, // Asia/Bangkok
    {   61, 3571,    2261,  7, }, // Asia/Barnaul
    {   61, 4086,   28563,  6, }, // Asia/Beirut
    {   61, 3778,   28569,  6, }, // Asia/Bishkek
    {   61, 5989,   28575,  6, }, // Asia/Brunei
    {   61, 4601,   28581,  4, }, // Asia/Chita
    {   61, 4511,   28585,  7, }, // Asia/Colombo
    {   61, 4540,    2297,  6, }, // Asia/Damascus
    {   61, 1093,     593,  4, }, // Asia/Dhaka
    {   61, 6192,   28592,  4, }, // Asia/Dili
    {   61, 3596,   28596,  5, }, // Asia/Dubai
    {   61, 6159,   28601,  7, }, // Asia/Dushanbe
    {   61, 8636,    2324,  9, }, // Asia/Famagusta
    {   61, 8651,    2333,  4, }, // Asia/Gaza
    {   61, 4795,   28608,  6, }, // Asia/Hebron
    {   61, 1259,   28614,  7, }, // Asia/Ho_Chi_Minh
    {   61, 2704,   28621,  7, }, // Asia/Hong_Kong
    {   61, 4771,   28628,  4, }, // Asia/Hovd
    {   61, 4184,   28632,  6, }, // Asia/Irkutsk
    {   61, 7006,   28638,  8, }, // Asia/Jakarta
    {   61, 6992,   28646,  8, }, // Asia/Jayapura
    {   61, 1290,   28654,  9, }, // Asia/Jerusalem
    {   61, 3560,    2392,  5, }, // Asia/Kabul
    {   61, 4316,    2411,  8, }, // Asia/Kamchatka
    {   61, 4239,   28663,  6, }, // Asia/Karachi
    {   61, 1185,    2428,  8, }, // Asia/Kathmandu
    {   61, 8661,    2436,  7, }, // Asia/Khandyga
    {   61,  992,   28669,  8, }, // Asia/Kolkata
    {   61, 4197,   28677, 10, }, // Asia/Krasnoyarsk
    {   61, 4859,    2462, 12, }, // Asia/Kuala_Lumpur
    {   61, 5976,   28687,  6, }, // Asia/Kuching
    {   61, 5547,   28693,  6, }, // Asia/Kuwait
    {   61, 1211,   28699,  5, }, // Asia/Macau
    {   61, 4017,    2491,  7, }, // Asia/Magadan
    {   61, 1349,    2498,  7, }, // Asia/Makassar
    {   61, 7182,   28704,  6, }, // Asia/Manila
    {   61, 6920,    2511,  6, }, // Asia/Muscat
    {   61, 2554,   28710,  7, }, // Asia/Nicosia
    {   61, 8675,   28717, 11, }, // Asia/Novokuznetsk
    {   61, 4135,   28728, 11, }, // Asia/Novosibirsk
    {   61, 4229,    2546,  4, }, // Asia/Omsk
    {   61, 7145,   28739,  7, }, // Asia/Oral
    {   61, 6961,   28746,  8, }, // Asia/Phnom_Penh
    {   61, 8693,   28754,  9, }, // Asia/Pontianak
    {   61, 4214,   28763,  7, }, // Asia/Pyongyang
    {   61, 5559,    2579,  5, }, // Asia/Qatar
    {   61, 8708,   28770,  8, }, // Asia/Qostanay
    {   61, 4269,   28778,  9, }, // Asia/Qyzylorda
    {   61, 3584,   28787,  7, }, // Asia/Riyadh
    {   61, 4408,   28794,  7, }, // Asia/Sakhalin
    {   61, 7245,    2621,  9, }, // Asia/Samarkand
    {   61, 3279,    2630,  4, }, // Asia/Seoul
    {   61, 1053,   28801,  6, }, // Asia/Shanghai
    {   61, 3300,   28807,  8, }, // Asia/Singapore
    {   61, 4297,   28815, 14, }, // Asia/Srednekolymsk
    {   61, 3263,   28829,  6, }, // Asia/Taipei
    {   61, 4781,    2667,  7, }, // Asia/Tashkent
    {   61, 3915,   28835,  7, }, // Asia/Tbilisi
    {   61, 2772,   28842,  7, }, // Asia/Tehran
    {   61, 1317,   28849,  7, }, // Asia/Thimphu
    {   61, 2821,   28856,  5, }, // Asia/Tokyo
    {   61, 4572,    2697,  5, }, // Asia/Tomsk
    {   61, 1021,   28861, 10, }, // Asia/Ulaanbaatar
    {   61, 1159,   28871,  6, }, // Asia/Urumqi
    {   61, 8722,   28877,  9, }, // Asia/Ust-Nera
    {   61, 6977,   28886,  8, }, // Asia/Vientiane
    {   61, 4710,   28894, 12, }, // Asia/Vladivostok
    {   61, 4828,   28906,  5, }, // Asia/Yakutsk
    {   61, 1235,   28911,  6, }, // Asia/Yangon
    {   61, 3883,   28917, 12, }, // Asia/Yekaterinburg
    {   61, 3747,   28929,  6, }, // Asia/Yerevan
    {   61, 3663,   28935, 16, }, // Atlantic/Azores
    {   61, 5671,   28951, 18, }, // Atlantic/Bermuda
    {   61, 6628,   28969, 17, }, // Atlantic/Canary
    {   61, 3727,   28986, 10, }, // Atlantic/Cape_Verde
    {   61, 1395,   28996, 17, }, // Atlantic/Faroe
    {   61, 8736,   29013,  7, }, // Atlantic/Madeira
    {   61, 2748,   29020,  9, }, // Atlantic/Reykjavik
    {   61, 7272,   29029, 17, }, // Atlantic/South_Georgia
    {   61, 6821,   29046, 20, }, // Atlantic/St_Helena
    {   61, 6644,   29066, 11, }, // Atlantic/Stanley
    {   61, 1670,   29077,  8, }, // Australia/Adelaide
    {   61, 1635,   29085,  7, }, // Australia/Brisbane
    {   61, 1799,   29092, 10, }, // Australia/Broken_Hill
    {   61, 1583,   29102,  6, }, // Australia/Darwin
    {   61, 3637,   29108,  4, }, // Australia/Eucla
    {   61, 1516,    2954,  6, }, // Australia/Hobart
    {   61, 8753,   29112,  8, }, // Australia/Lindeman
    {   61, 1547,    2968,  8, }, // Australia/Lord_Howe
    {   61, 1727,   29120,  8, }, // Australia/Melbourne
    {   61, 1762,    2983,  4, }, // Australia/Perth
    {   61, 1463,   29128,  6, }, // Australia/Sydney
    {   61, 6441,   29134,  9, }, // Europe/Amsterdam
    {   61, 6216,   29143,  6, }, // Europe/Andorra
    {   61, 3620,   29149,  9, }, // Europe/Astrakhan
    {   61, 2300,   29158,  5, }, // Europe/Athens
    {   61, 6336,   29163,  7, }, // Europe/Belgrade
    {   61, 4757,   29170,  6, }, // Europe/Berlin
    {   61, 6488,   29176, 10, }, // Europe/Bratislava
    {   61, 2167,   29186,  7, }, // Europe/Brussels
    {   61, 3928,   29193,  8, }, // Europe/Bucharest
    {   61, 3806,    3060,  8, }, // Europe/Budapest
    {   61, 8772,   29201,  8, }, // Europe/Busingen
    {   61, 2583,   29209,  7, }, // Europe/Chisinau
    {   61, 6289,   29216, 10, }, // Europe/Copenhagen
    {   61, 2338,   29226,  6, }, // Europe/Dublin
    {   61, 6307,   29232,  9, }, // Europe/Gibraltar
    {   61, 8788,   29241,  6, }, // Europe/Guernsey
    {   61, 6612,   29247,  9, }, // Europe/Helsinki
    {   61, 8804,   29256, 11, }, // Europe/Isle_of_Man
    {   61, 1130,    3146,  7, }, // Europe/Istanbul
    {   61, 8823,   29267,  6, }, // Europe/Jersey
    {   61, 3979,   29273, 11, }, // Europe/Kaliningrad
    {   61, 8929,   29284,  5, }, // Europe/Kirov
    {   61, 2527,   29289,  4, }, // Europe/Kyiv
    {   61, 3213,   29293,  7, }, // Europe/Lisbon
    {   61, 6506,   29300,  7, }, // Europe/Ljubljana
    {   61, 2501,   29307,  6, }, // Europe/London
    {   61, 6365,   29313, 10, }, // Europe/Luxembourg
    {   61, 4892,   29323,  6, }, // Europe/Madrid
    {   61, 6397,   29329,  6, }, // Europe/Malta
    {   61, 6582,   29335, 12, }, // Europe/Mariehamn
    {   61, 3693,   29347,  5, }, // Europe/Minsk
    {   61, 6410,   29352,  6, }, // Europe/Monaco
    {   61, 3537,   29358,  6, }, // Europe/Moscow
    {   61, 6458,   29364,  4, }, // Europe/Oslo
    {   61, 4284,   29368,  5, }, // Europe/Paris
    {   61, 6424,   29373,  9, }, // Europe/Podgorica
    {   61, 6275,    3267,  5, }, // Europe/Prague
    {   61, 8837,   29382,  4, }, // Europe/Riga
    {   61, 6324,   29386,  3, }, // Europe/Rome
    {   61, 4331,    3279,  6, }, // Europe/Samara
    {   61, 6470,   29389, 10, }, // Europe/San_Marino
    {   61, 6245,   29399,  7, }, // Europe/Sarajevo
    {   61, 4451,   29406,  7, }, // Europe/Saratov
    {   61, 8849,   29413, 11, }, // Europe/Simferopol
    {   61, 6383,   29424,  6, }, // Europe/Skopje
    {   61, 6599,   29430,  5, }, // Europe/Sofia
    {   61, 6523,   29435,  9, }, // Europe/Stockholm
    {   61, 8867,   29444,  5, }, // Europe/Tallinn
    {   61, 6202,   29449,  6, }, // Europe/Tirane
    {   61, 8882,   29455,  9, }, // Europe/Ulyanovsk
    {   61, 6352,    3358,  5, }, // Europe/Vaduz
    {   61, 6567,   29464,  7, }, // Europe/Vatican
    {   61, 6231,    3370,  4, }, // Europe/Vienna
    {   61, 8899,   29471,  7, }, // Europe/Vilnius
    {   61, 4727,   29478,  9, }, // Europe/Volgograd
    {   61, 3190,    3390,  7, }, // Europe/Warsaw
    {   61, 6261,   29487,  6, }, // Europe/Zagreb
    {   61, 6540,   29493,  5, }, // Europe/Zurich
    {   61, 5078,   29498, 12, }, // Indian/Antananarivo
    {   61, 6947,   29510,  5, }, // Indian/Chagos
    {   61, 6046,   29515, 13, }, // Indian/Christmas
    {   61, 6063,   29528, 17, }, // Indian/Cocos
    {   61, 5029,   29545, 17, }, // Indian/Comoro
    {   61, 6661,    3460,  8, }, // Indian/Kerguelen
    {   61, 7260,   29562,  3, }, // Indian/Mahe
    {   61, 7050,   29565,  8, }, // Indian/Maldives
    {   61, 4069,   29573,  8, }, // Indian/Mauritius
    {   61, 5098,   29581,  5, }, // Indian/Mayotte
    {   61, 7211,   29586,  7, }, // Indian/Reunion
    {   61, 4422,   29593,  4, }, // Pacific/Apia
    {   61,  932,    3502,  6, }, // Pacific/Auckland
    {   61, 3706,   29597,  9, }, // Pacific/Bougainville
    {   61, 3015,   29606,  5, }, // Pacific/Chatham
    {   61, 3157,    3521,  4, }, // Pacific/Chuuk
    {   61, 2237,   29611, 17, }, // Pacific/Easter
    {   61, 7360,   29628,  5, }, // Pacific/Efate
    {   61, 7327,   29633,  7, }, // Pacific/Fakaofo
    {   61, 3902,   29640,  5, }, // Pacific/Fiji
    {   61, 7343,   29645,  8, }, // Pacific/Funafuti
    {   61, 6678,   29653,  9, }, // Pacific/Galapagos
    {   61, 6696,   29662, 14, }, // Pacific/Gambier
    {   61, 3822,    3595, 11, }, // Pacific/Guadalcanal
    {   61, 6018,    3606,  4, }, // Pacific/Guam
    {   61, 2723,   29676,  8, }, // Pacific/Honolulu
    {   61, 3049,   29684,  9, }, // Pacific/Kanton
    {   61, 3998,   29693, 10, }, // Pacific/Kiritimati
    {   61, 7019,   29703,  6, }, // Pacific/Kosrae
    {   61, 2842,   29709, 10, }, // Pacific/Kwajalein
    {   61, 4877,   29719,  7, }, // Pacific/Majuro
    {   61, 4051,   29726, 18, }, // Pacific/Marquesas
    {   61, 8914,   29744,  6, }, // Pacific/Midway
    {   61, 7084,    3680,  5, }, // Pacific/Nauru
    {   61, 7132,   29750,  4, }, // Pacific/Niue
    {   61, 4168,   29754,  7, }, // Pacific/Norfolk
    {   61, 7098,    3696,  5, }, // Pacific/Noumea
    {   61, 3126,   29761,  9, }, // Pacific/Pago_Pago
    {   61, 7155,    3710,  5, }, // Pacific/Palau
    {   61, 7194,   29770,  7, }, // Pacific/Pitcairn
    {   61, 3096,   29777,  6, }, // Pacific/Pohnpei
    {   61, 4807,   29783, 11, }, // Pacific/Port_Moresby
    {   61, 6076,   29794,  9, }, // Pacific/Rarotonga
    {   61, 6031,   29803,  6, }, // Pacific/Saipan
    {   61, 7312,   29809,  5, }, // Pacific/Tahiti
    {   61, 6712,    3759,  6, }, // Pacific/Tarawa
    {   61, 4583,   29814,  9, }, // Pacific/Tongatapu
    {   61, 7392,   29823,  4, }, // Pacific/Wake
    {   61, 7405,   29827,  5, }, // Pacific/Wallis
    {   62,   14,       0,  6, }, // Africa/Asmara Bemba/Latin/Zambia
    {   62, 4435,       6,  8, }, // Africa/Sao_Tome
    {   62, 4252,      14,  8, }, // America/Asuncion
    {   62,  237,      22,  8, }, // America/Atikokan
    {   62, 7623,      30, 17, }, // America/Bahia_Banderas
    {   62, 3868,      47,  6, }, // America/Cancun
    {   62, 7774,      53, 13, }, // America/Ciudad_Juarez
    {   62, 5723,      66,  7, }, // America/Curacao
    {   62,  481,      73, 13, }, // America/Indiana/Knox
    {   62, 7961,      86, 16, }, // America/Indiana/Marengo
    {   62, 7985,     102, 19, }, // America/Indiana/Petersburg
    {   62, 8012,     121, 18, }, // America/Indiana/Tell_City
    {   62, 8038,     139, 14, }, // America/Indiana/Vevay
    {   62, 8060,     153, 18, }, // America/Indiana/Vincennes
    {   62, 8086,     171, 16, }, // America/Indiana/Winamac
    {   62, 8125,     187, 20, }, // America/Kentucky/Monticello
    {   62, 5932,     207, 22, }, // America/Lower_Princes
    {   62, 8220,     229,  6, }, // America/Merida
    {   62, 8301,     235, 20, }, // America/North_Dakota/Beulah
    {   62, 8329,     255, 20, }, // America/North_Dakota/Center
    {   62, 8357,     275, 23, }, // America/North_Dakota/New_Salem
    {   62,  393,     298,  4, }, // America/Nuuk
    {   62, 6899,     302, 16, }, // America/Scoresbysund
    {   62, 8508,     318, 14, }, // America/St_Barthelemy
    {   62, 2061,     332, 10, }, // America/St_Johns
    {   62, 5863,     342,  9, }, // America/St_Kitts
    {   62, 5880,     351,  9, }, // America/St_Lucia
    {   62,  855,     360, 10, }, // America/St_Thomas
    {   62, 5913,     370, 11, }, // America/St_Vincent
    {   62, 6133,     381, 16, }, // Antarctica/DumontDUrville
    {   62, 1259,     397, 11, }, // Asia/Ho_Chi_Minh
    {   62, 1185,     413,  9, }, // Asia/Kathmandu
    {   62,  992,     422,  7, }, // Asia/Kolkata
    {   62, 1211,     429,  5, }, // Asia/Macau
    {   62, 1235,     442,  6, }, // Asia/Yangon
    {   62, 1395,     448,  5, }, // Atlantic/Faroe
    {   62, 6821,     453, 10, }, // Atlantic/St_Helena
    {   62, 2527,     463,  4, }, // Europe/Kyiv
    {   62, 7211,     467,  7, }, // Indian/Reunion
    {   62, 3157,     474,  5, }, // Pacific/Chuuk
    {   62, 3096,     479,  7, }, // Pacific/Pohnpei
    {   63,   14,       0,  6, }, // Africa/Asmara Bena/Latin/Tanzania
    {   63, 4435,       6,  8, }, // Africa/Sao_Tome
    {   63, 4252,      14,  8, }, // America/Asuncion
    {   63,  237,      22,  8, }, // America/Atikokan
    {   63, 7623,      30, 17, }, // America/Bahia_Banderas
    {   63, 3868,      47,  6, }, // America/Cancun
    {   63, 7774,      53, 13, }, // America/Ciudad_Juarez
    {   63, 5723,      66,  7, }, // America/Curacao
    {   63,  481,      73, 13, }, // America/Indiana/Knox
    {   63, 7961,      86, 16, }, // America/Indiana/Marengo
    {   63, 7985,     102, 19, }, // America/Indiana/Petersburg
    {   63, 8012,     121, 18, }, // America/Indiana/Tell_City
    {   63, 8038,     139, 14, }, // America/Indiana/Vevay
    {   63, 8060,     153, 18, }, // America/Indiana/Vincennes
    {   63, 8086,     171, 16, }, // America/Indiana/Winamac
    {   63, 8125,     187, 20, }, // America/Kentucky/Monticello
    {   63, 5932,     207, 22, }, // America/Lower_Princes
    {   63, 8220,     229,  6, }, // America/Merida
    {   63, 8301,     235, 20, }, // America/North_Dakota/Beulah
    {   63, 8329,     255, 20, }, // America/North_Dakota/Center
    {   63, 8357,     275, 23, }, // America/North_Dakota/New_Salem
    {   63,  393,     298,  4, }, // America/Nuuk
    {   63, 6899,     302, 16, }, // America/Scoresbysund
    {   63, 8508,     318, 14, }, // America/St_Barthelemy
    {   63, 2061,     332, 10, }, // America/St_Johns
    {   63, 5863,     342,  9, }, // America/St_Kitts
    {   63, 5880,     351,  9, }, // America/St_Lucia
    {   63,  855,     360, 10, }, // America/St_Thomas
    {   63, 5913,     370, 11, }, // America/St_Vincent
    {   63, 6133,     381, 16, }, // Antarctica/DumontDUrville
    {   63, 1259,     397, 11, }, // Asia/Ho_Chi_Minh
    {   63, 1185,     413,  9, }, // Asia/Kathmandu
    {   63,  992,     422,  7, }, // Asia/Kolkata
    {   63, 1211,     429,  5, }, // Asia/Macau
    {   63, 1235,     442,  6, }, // Asia/Yangon
    {   63, 1395,     448,  5, }, // Atlantic/Faroe
    {   63, 6821,     453, 10, }, // Atlantic/St_Helena
    {   63, 2527,     463,  4, }, // Europe/Kyiv
    {   63, 7211,     467,  7, }, // Indian/Reunion
    {   63, 3157,     474,  5, }, // Pacific/Chuuk
    {   63, 3096,     479,  7, }, // Pacific/Pohnpei
    {   64,   14,       0,  6, }, // Africa/Asmara Bhojpuri/Devanagari/India
    {   64, 4435,       6,  8, }, // Africa/Sao_Tome
    {   64, 4252,      14,  8, }, // America/Asuncion
    {   64,  237,      22,  8, }, // America/Atikokan
    {   64, 7623,      30, 17, }, // America/Bahia_Banderas
    {   64, 3868,      47,  6, }, // America/Cancun
    {   64, 7774,      53, 13, }, // America/Ciudad_Juarez
    {   64, 5723,      66,  7, }, // America/Curacao
    {   64,  481,      73, 13, }, // America/Indiana/Knox
    {   64, 7961,      86, 16, }, // America/Indiana/Marengo
    {   64, 7985,     102, 19, }, // America/Indiana/Petersburg
    {   64, 8012,     121, 18, }, // America/Indiana/Tell_City
    {   64, 8038,     139, 14, }, // America/Indiana/Vevay
    {   64, 8060,     153, 18, }, // America/Indiana/Vincennes
    {   64, 8086,     171, 16, }, // America/Indiana/Winamac
    {   64, 8125,     187, 20, }, // America/Kentucky/Monticello
    {   64, 5932,     207, 22, }, // America/Lower_Princes
    {   64, 8220,     229,  6, }, // America/Merida
    {   64, 8301,     235, 20, }, // America/North_Dakota/Beulah
    {   64, 8329,     255, 20, }, // America/North_Dakota/Center
    {   64, 8357,     275, 23, }, // America/North_Dakota/New_Salem
    {   64,  393,     298,  4, }, // America/Nuuk
    {   64, 6899,     302, 16, }, // America/Scoresbysund
    {   64, 8508,     318, 14, }, // America/St_Barthelemy
    {   64, 2061,     332, 10, }, // America/St_Johns
    {   64, 5863,     342,  9, }, // America/St_Kitts
    {   64, 5880,     351,  9, }, // America/St_Lucia
    {   64,  855,     360, 10, }, // America/St_Thomas
    {   64, 5913,     370, 11, }, // America/St_Vincent
    {   64, 6133,     381, 16, }, // Antarctica/DumontDUrville
    {   64, 1259,     397, 11, }, // Asia/Ho_Chi_Minh
    {   64, 1185,     413,  9, }, // Asia/Kathmandu
    {   64,  992,     422,  7, }, // Asia/Kolkata
    {   64, 1211,     429,  5, }, // Asia/Macau
    {   64, 1235,     442,  6, }, // Asia/Yangon
    {   64, 1395,     448,  5, }, // Atlantic/Faroe
    {   64, 6821,     453, 10, }, // Atlantic/St_Helena
    {   64, 2527,     463,  4, }, // Europe/Kyiv
    {   64, 7211,     467,  7, }, // Indian/Reunion
    {   64, 3157,     474,  5, }, // Pacific/Chuuk
    {   64, 3096,     479,  7, }, // Pacific/Pohnpei
    {   65,   14,       0,  6, }, // Africa/Asmara Blin/Ethiopic/Eritrea
    {   65, 4435,       6,  8, }, // Africa/Sao_Tome
    {   65, 4252,      14,  8, }, // America/Asuncion
    {   65,  237,      22,  8, }, // America/Atikokan
    {   65, 7623,      30, 17, }, // America/Bahia_Banderas
    {   65, 3868,      47,  6, }, // America/Cancun
    {   65, 7774,      53, 13, }, // America/Ciudad_Juarez
    {   65, 5723,      66,  7, }, // America/Curacao
    {   65,  481,      73, 13, }, // America/Indiana/Knox
    {   65, 7961,      86, 16, }, // America/Indiana/Marengo
    {   65, 7985,     102, 19, }, // America/Indiana/Petersburg
    {   65, 8012,     121, 18, }, // America/Indiana/Tell_City
    {   65, 8038,     139, 14, }, // America/Indiana/Vevay
    {   65, 8060,     153, 18, }, // America/Indiana/Vincennes
    {   65, 8086,     171, 16, }, // America/Indiana/Winamac
    {   65, 8125,     187, 20, }, // America/Kentucky/Monticello
    {   65, 5932,     207, 22, }, // America/Lower_Princes
    {   65, 8220,     229,  6, }, // America/Merida
    {   65, 8301,     235, 20, }, // America/North_Dakota/Beulah
    {   65, 8329,     255, 20, }, // America/North_Dakota/Center
    {   65, 8357,     275, 23, }, // America/North_Dakota/New_Salem
    {   65,  393,     298,  4, }, // America/Nuuk
    {   65, 6899,     302, 16, }, // America/Scoresbysund
    {   65, 8508,     318, 14, }, // America/St_Barthelemy
    {   65, 2061,     332, 10, }, // America/St_Johns
    {   65, 5863,     342,  9, }, // America/St_Kitts
    {   65, 5880,     351,  9, }, // America/St_Lucia
    {   65,  855,     360, 10, }, // America/St_Thomas
    {   65, 5913,     370, 11, }, // America/St_Vincent
    {   65, 6133,     381, 16, }, // Antarctica/DumontDUrville
    {   65, 1259,     397, 11, }, // Asia/Ho_Chi_Minh
    {   65, 1185,     413,  9, }, // Asia/Kathmandu
    {   65,  992,     422,  7, }, // Asia/Kolkata
    {   65, 1211,     429,  5, }, // Asia/Macau
    {   65, 1235,     442,  6, }, // Asia/Yangon
    {   65, 1395,     448,  5, }, // Atlantic/Faroe
    {   65, 6821,     453, 10, }, // Atlantic/St_Helena
    {   65, 2527,     463,  4, }, // Europe/Kyiv
    {   65, 7211,     467,  7, }, // Indian/Reunion
    {   65, 3157,     474,  5, }, // Pacific/Chuuk
    {   65, 3096,     479,  7, }, // Pacific/Pohnpei
    {   66, 6788,   29832,  7, }, // Africa/Abidjan Bodo/Devanagari/India
    {   66, 6760,   29839,  5, }, // Africa/Accra
    {   66, 5059,   29844, 12, }, // Africa/Addis_Ababa
    {   66, 7420,   29856,  9, }, // Africa/Algiers
    {   66,   14,   29865,  7, }, // Africa/Asmara
    {   66,   44,   29872,  6, }, // Africa/Bamako
    {   66, 5257,   29878,  6, }, // Africa/Bangui
    {   66, 6746,   29884,  6, }, // Africa/Banjul
    {   66, 7435,   29890,  7, }, // Africa/Bissau
    {   66, 4957,   29897, 10, }, // Africa/Blantyre
    {   66, 5287,   29907, 11, }, // Africa/Brazzaville
    {   66, 4922,   29918, 10, }, // Africa/Bujumbura
    {   66, 2320,   29928,  5, }, // Africa/Cairo
    {   66, 4117,   29933, 11, }, // Africa/Casablanca
    {   66, 7449,   29944,  5, }, // Africa/Ceuta
    {   66, 6773,   29949,  7, }, // Africa/Conakry
    {   66, 6840,   29956,  5, }, // Africa/Dakar
    {   66, 5130,   29961, 11, }, // Africa/Dar_es_Salaam
    {   66, 5043,   29972,  6, }, // Africa/Djibouti
    {   66, 5243,   29978,  5, }, // Africa/Douala
    {   66, 5166,   29983,  7, }, // Africa/El_Aaiun
    {   66, 6853,   29990,  8, }, // Africa/Freetown
    {   66, 4906,   29998,  7, }, // Africa/Gaborone
    {   66, 5015,   30005,  6, }, // Africa/Harare
    {   66, 4479,   30011, 11, }, // Africa/Johannesburg
    {   66, 4499,   30022,  4, }, // Africa/Juba
    {   66, 5151,   30026,  8, }, // Africa/Kampala
    {   66, 4524,   30034,  7, }, // Africa/Khartoum
    {   66, 4973,   30041,  6, }, // Africa/Kigali
    {   66, 5306,   30047,  8, }, // Africa/Kinshasa
    {   66, 4744,   30055,  5, }, // Africa/Lagos
    {   66, 5336,   30060,  9, }, // Africa/Libreville
    {   66, 6869,   30069,  3, }, // Africa/Lome
    {   66, 5211,   30072,  7, }, // Africa/Luanda
    {   66, 4939,   30079, 10, }, // Africa/Lubumbashi
    {   66, 5001,   30089,  6, }, // Africa/Lusaka
    {   66, 5322,   30095,  6, }, // Africa/Malabo
    {   66, 4987,   30101,  6, }, // Africa/Maputo
    {   66, 5197,   30107,  6, }, // Africa/Maseru
    {   66, 5182,   30113,  8, }, // Africa/Mbabane
    {   66, 5113,   30121,  7, }, // Africa/Mogadishu
    {   66, 7034,   30128,  9, }, // Africa/Monrovia
    {   66, 3853,   30137,  7, }, // Africa/Nairobi
    {   66, 5271,   30144,  8, }, // Africa/Ndjamena
    {   66, 5354,   30152,  5, }, // Africa/Niamey
    {   66, 6803,   30157,  8, }, // Africa/Nouakchott
    {   66, 6727,   30165,  7, }, // Africa/Ouagadougou
    {   66, 5225,   30172,  9, }, // Africa/Porto-Novo
    {   66, 4435,   30181,  7, }, // Africa/Sao_Tome
    {   66, 2866,   30188,  8, }, // Africa/Tripoli
    {   66, 6554,   30196,  7, }, // Africa/Tunis
    {   66, 4152,   30203,  8, }, // Africa/Windhoek
    {   66,  132,   30211,  4, }, // America/Adak
    {   66, 3346,   30215,  6, }, // America/Anchorage
    {   66, 5607,   30221,  8, }, // America/Anguilla
    {   66, 5624,   30229,  9, }, // America/Antigua
    {   66, 4554,   30238,  9, }, // America/Araguaina
    {   66,  166,   30247, 11, }, // America/Argentina/Buenos_Aires
    {   66,   91,   30258, 10, }, // America/Argentina/Catamarca
    {   66,  270,   30268,  6, }, // America/Argentina/Cordoba
    {   66,  441,   30274,  5, }, // America/Argentina/Jujuy
    {   66, 7462,   30279,  8, }, // America/Argentina/La_Rioja
    {   66,  565,   30287,  8, }, // America/Argentina/Mendoza
    {   66, 7489,   30295, 10, }, // America/Argentina/Rio_Gallegos
    {   66, 7520,   30305,  6, }, // America/Argentina/Salta
    {   66, 7544,   30311,  9, }, // America/Argentina/San_Juan
    {   66, 5580,   30320,  8, }, // America/Argentina/San_Luis
    {   66, 7571,   30328,  7, }, // America/Argentina/Tucuman
    {   66, 7597,   30335,  8, }, // America/Argentina/Ushuaia
    {   66, 5640,   30343,  5, }, // America/Aruba
    {   66, 4252,   30348,  8, }, // America/Asuncion
    {   66,  237,   30356,  7, }, // America/Atikokan
    {   66, 3679,   30363,  6, }, // America/Bahia
    {   66, 7623,   30369, 16, }, // America/Bahia_Banderas
    {   66, 5654,   30385,  9, }, // America/Barbados
    {   66, 7646,   30394,  5, }, // America/Belem
    {   66, 5407,   30399,  5, }, // America/Belize
    {   66, 7660,   30404, 14, }, // America/Blanc-Sablon
    {   66, 7681,   30418,  9, }, // America/Boa_Vista
    {   66, 4361,   30427,  5, }, // America/Bogota
    {   66, 7699,   30432,  4, }, // America/Boise
    {   66, 7713,   30436, 15, }, // America/Cambridge_Bay
    {   66, 7735,   30451, 13, }, // America/Campo_Grande
    {   66, 3868,   30464,  6, }, // America/Cancun
    {   66, 4694,   30470,  7, }, // America/Caracas
    {   66, 4345,   30477,  5, }, // America/Cayenne
    {   66, 5496,   30482,  5, }, // America/Cayman
    {   66, 2260,   30487,  6, }, // America/Chicago
    {   66, 7756,   30493,  7, }, // America/Chihuahua
    {   66, 7774,      53, 13, }, // America/Ciudad_Juarez
    {   66, 5422,   30500, 10, }, // America/Costa_Rica
    {   66, 7796,   30510,  8, }, // America/Creston
    {   66, 3791,   30518,  6, }, // America/Cuiaba
    {   66, 5723,   30524,  7, }, // America/Curacao
    {   66, 7812,   30531, 13, }, // America/Danmarkshavn
    {   66, 7833,   30544,  6, }, // America/Dawson
    {   66, 7848,   30550, 12, }, // America/Dawson_Creek
    {   66,  805,   30562,  6, }, // America/Denver
    {   66, 3465,   30568,  8, }, // America/Detroit
    {   66, 5739,   30576,  7, }, // America/Dominica
    {   66,  893,   30583,  7, }, // America/Edmonton
    {   66, 7869,   30590,  8, }, // America/Eirunepe
    {   66, 5441,   30598, 11, }, // America/El_Salvador
    {   66, 7886,   30609, 10, }, // America/Fort_Nelson
    {   66, 7906,   30619,  9, }, // America/Fortaleza
    {   66, 7924,   30628,  9, }, // America/Glace_Bay
    {   66, 6881,   30637,  7, }, // America/Goose_Bay
    {   66, 4612,   30644, 13, }, // America/Grand_Turk
    {   66, 5770,   30657,  8, }, // America/Grenada
    {   66, 5786,   30665,  9, }, // America/Guadeloupe
    {   66, 3760,   30674, 10, }, // America/Guatemala
    {   66, 4841,   30684,  8, }, // America/Guayaquil
    {   66, 6932,   30692,  6, }, // America/Guyana
    {   66, 1939,   30698,  9, }, // America/Halifax
    {   66, 2281,   30707,  6, }, // America/Havana
    {   66, 7942,   30713, 12, }, // America/Hermosillo
    {   66,  348,   30725, 13, }, // America/Indiana/Indianapolis
    {   66,  481,   30738, 15, }, // America/Indiana/Knox
    {   66, 7961,   30753, 17, }, // America/Indiana/Marengo
    {   66, 7985,   30770, 23, }, // America/Indiana/Petersburg
    {   66, 8012,   30793, 20, }, // America/Indiana/Tell_City
    {   66, 8038,   30813, 15, }, // America/Indiana/Vevay
    {   66, 8060,   30828, 21, }, // America/Indiana/Vincennes
    {   66, 8086,   30849, 18, }, // America/Indiana/Winamac
    {   66, 8110,   30867,  6, }, // America/Inuvik
    {   66,  660,   30873,  7, }, // America/Iqaluit
    {   66, 2799,   30880,  7, }, // America/Jamaica
    {   66, 5380,   30887,  4, }, // America/Juneau
    {   66,  521,   30891,  6, }, // America/Kentucky/Louisville
    {   66, 8125,   30897, 19, }, // America/Kentucky/Monticello
    {   66, 5704,   30916, 10, }, // America/Kralendijk
    {   66, 4376,   30926,  6, }, // America/La_Paz
    {   66, 7169,   30932,  4, }, // America/Lima
    {   66, 3239,   30936, 11, }, // America/Los_Angeles
    {   66, 5932,   30947, 24, }, // America/Lower_Princes
    {   66, 8153,   30971,  6, }, // America/Maceio
    {   66, 8168,   30977,  6, }, // America/Managua
    {   66, 1908,   30983,  5, }, // America/Manaus
    {   66, 5897,   30988,  6, }, // America/Marigot
    {   66, 5805,   30994,  9, }, // America/Martinique
    {   66, 8184,   31003,  7, }, // America/Matamoros
    {   66, 2917,   31010,  8, }, // America/Mazatlan
    {   66, 8202,   31018,  8, }, // America/Menominee
    {   66, 8220,   31026,  6, }, // America/Merida
    {   66, 8235,   31032, 12, }, // America/Metlakatla
    {   66, 2949,   31044, 13, }, // America/Mexico_City
    {   66, 4391,   31057,  9, }, // America/Miquelon
    {   66, 8254,   31066,  6, }, // America/Moncton
    {   66, 8270,   31072,  9, }, // America/Monterrey
    {   66, 4098,   31081, 10, }, // America/Montevideo
    {   66, 5824,   31091,  9, }, // America/Montserrat
    {   66, 5481,   31100,  7, }, // America/Nassau
    {   66, 2379,   31107,  8, }, // America/New_York
    {   66, 8288,   31020,  3, }, // America/Nome
    {   66, 1850,   31115,  7, }, // America/Noronha
    {   66, 8301,   31122, 19, }, // America/North_Dakota/Beulah
    {   66, 8329,   31141, 20, }, // America/North_Dakota/Center
    {   66, 8357,   31161, 22, }, // America/North_Dakota/New_Salem
    {   66,  393,   31183,  3, }, // America/Nuuk
    {   66, 8388,   31186,  7, }, // America/Ojinaga
    {   66, 2356,   31193,  6, }, // America/Panama
    {   66, 6173,   31199, 10, }, // America/Paramaribo
    {   66, 2973,   31209,  7, }, // America/Phoenix
    {   66, 3945,   31216, 15, }, // America/Port-au-Prince
    {   66, 5954,   31231, 13, }, // America/Port_of_Spain
    {   66, 8404,   31244, 12, }, // America/Porto_Velho
    {   66, 5843,   31256, 12, }, // America/Puerto_Rico
    {   66, 4030,   31268, 13, }, // America/Punta_Arenas
    {   66, 8424,   31281, 12, }, // America/Rankin_Inlet
    {   66, 8445,   31293,  6, }, // America/Recife
    {   66, 1995,   31299,  6, }, // America/Regina
    {   66, 8460,   31305,  8, }, // America/Resolute
    {   66,  695,   31313, 12, }, // America/Rio_Branco
    {   66, 8477,   31325,  9, }, // America/Santarem
    {   66, 2201,   31334,  9, }, // America/Santiago
    {   66, 6111,   31343, 12, }, // America/Santo_Domingo
    {   66, 1878,   31355,  9, }, // America/Sao_Paulo
    {   66, 6899,   31364, 14, }, // America/Scoresbysund
    {   66, 8494,   31378,  6, }, // America/Sitka
    {   66, 8508,   31384, 16, }, // America/St_Barthelemy
    {   66, 2061,   31400, 10, }, // America/St_Johns
    {   66, 5863,   31410, 11, }, // America/St_Kitts
    {   66, 5880,   31421, 12, }, // America/St_Lucia
    {   66,  855,   31433, 10, }, // America/St_Thomas
    {   66, 5913,   31443, 15, }, // America/St_Vincent
    {   66, 8530,   31458, 15, }, // America/Swift_Current
    {   66, 5461,   31473, 12, }, // America/Tegucigalpa
    {   66, 5756,   31485,  5, }, // America/Thule
    {   66,  313,   31490,  7, }, // America/Tijuana
    {   66,  608,   31497,  6, }, // America/Toronto
    {   66, 5688,   31503,  7, }, // America/Tortola
    {   66, 2093,   31510,  7, }, // America/Vancouver
    {   66, 2144,   31517, 10, }, // America/Whitehorse
    {   66,  734,   31527,  7, }, // America/Winnipeg
    {   66, 8552,   31534,  7, }, // America/Yakutat
    {   66, 6001,   31541,  4, }, // Antarctica/Casey
    {   66, 6094,   31545,  5, }, // Antarctica/Davis
    {   66, 6133,   31550, 15, }, // Antarctica/DumontDUrville
    {   66, 8568,   31565,  8, }, // Antarctica/Macquarie
    {   66, 7066,   31573,  4, }, // Antarctica/Mawson
    {   66, 7113,   31577,  9, }, // Antarctica/McMurdo
    {   66, 8589,   31586,  6, }, // Antarctica/Palmer
    {   66, 7226,   31592,  5, }, // Antarctica/Rothera
    {   66, 7295,   31597,  5, }, // Antarctica/Syowa
    {   66, 8607,   31602,  5, }, // Antarctica/Troll
    {   66, 7374,   31607,  6, }, // Antarctica/Vostok
    {   66, 1429,   31613, 10, }, // Arctic/Longyearbyen
    {   66, 5570,   31623,  4, }, // Asia/Aden
    {   66, 5395,   31627,  7, }, // Asia/Almaty
    {   66, 3968,   31634,  6, }, // Asia/Amman
    {   66, 5511,   31640,  6, }, // Asia/Anadyr
    {   66, 5523,   31646,  6, }, // Asia/Aqtau
    {   66, 5368,   31652,  7, }, // Asia/Aqtobe
    {   66,  964,   31659,  8, }, // Asia/Ashgabat
    {   66, 8624,   31667,  6, }, // Asia/Atyrau
    {   66, 3607,   31673,  6, }, // Asia/Baghdad
    {   66, 5534,   31679,  6, }, // Asia/Bahrain
    {   66, 3653,   30522,  4, }, // Asia/Baku
    {   66, 4466,   31685,  7, }, // Asia/Bangkok
    {   66, 3571,   31692,  7, }, // Asia/Barnaul
    {   66, 4086,   31699,  5, }, // Asia/Beirut
    {   66, 3778,   31704,  7, }, // Asia/Bishkek
    {   66, 5989,   31711,  6, }, // Asia/Brunei
    {   66, 4601,   31717,  4, }, // Asia/Chita
    {   66, 4511,   31721,  6, }, // Asia/Colombo
    {   66, 4540,   31727,  9, }, // Asia/Damascus
    {   66, 1093,   31736,  4, }, // Asia/Dhaka
    {   66, 6192,   31740,  4, }, // Asia/Dili
    {   66, 3596,   31744,  5, }, // Asia/Dubai
    {   66, 6159,   31749,  8, }, // Asia/Dushanbe
    {   66, 8636,   31757, 10, }, // Asia/Famagusta
    {   66, 8651,   31767,  4, }, // Asia/Gaza
    {   66, 4795,   31771,  7, }, // Asia/Hebron
    {   66, 1259,   31778,  6, }, // Asia/Ho_Chi_Minh
    {   66, 2704,   31784,  4, }, // Asia/Hong_Kong
    {   66, 4771,   31788,  5, }, // Asia/Hovd
    {   66, 4184,   31793, 10, }, // Asia/Irkutsk
    {   66, 7006,   31803,  8, }, // Asia/Jakarta
    {   66, 6992,   31811,  7, }, // Asia/Jayapura
    {   66, 1290,   31818,  9, }, // Asia/Jerusalem
    {   66, 3560,   31827,  5, }, // Asia/Kabul
    {   66, 4316,   31832,  8, }, // Asia/Kamchatka
    {   66, 4239,   31840,  5, }, // Asia/Karachi
    {   66, 1185,   31845,  9, }, // Asia/Kathmandu
    {   66, 8661,   31854,  8, }, // Asia/Khandyga
    {   66,  992,   31862,  6, }, // Asia/Kolkata
    {   66, 4197,   31868, 15, }, // Asia/Krasnoyarsk
    {   66, 4859,   31883, 13, }, // Asia/Kuala_Lumpur
    {   66, 5976,   31896,  6, }, // Asia/Kuching
    {   66, 5547,   31902,  5, }, // Asia/Kuwait
    {   66, 1211,   31907,  5, }, // Asia/Macau
    {   66, 4017,   31912,  7, }, // Asia/Magadan
    {   66, 1349,   31919,  9, }, // Asia/Makassar
    {   66, 7182,   31928,  5, }, // Asia/Manila
    {   66, 6920,   31933,  7, }, // Asia/Muscat
    {   66, 2554,   31940,  8, }, // Asia/Nicosia
    {   66, 8675,   31948, 14, }, // Asia/Novokuznetsk
    {   66, 4135,   31962, 12, }, // Asia/Novosibirsk
    {   66, 4229,   31974,  6, }, // Asia/Omsk
    {   66, 7145,   31980,  4, }, // Asia/Oral
    {   66, 6961,   31984,  7, }, // Asia/Phnom_Penh
    {   66, 8693,   31991,  9, }, // Asia/Pontianak
    {   66, 4214,   32000,  7, }, // Asia/Pyongyang
    {   66, 5559,   32007,  5, }, // Asia/Qatar
    {   66, 8708,   32012,  7, }, // Asia/Qostanay
    {   66, 4269,   32019,  9, }, // Asia/Qyzylorda
    {   66, 3584,   32028,  5, }, // Asia/Riyadh
    {   66, 4408,   32033,  7, }, // Asia/Sakhalin
    {   66, 7245,   32040,  8, }, // Asia/Samarkand
    {   66, 3279,   32048,  4, }, // Asia/Seoul
    {   66, 1053,   32052,  6, }, // Asia/Shanghai
    {   66, 3300,   32058,  8, }, // Asia/Singapore
    {   66, 4297,   32066, 16, }, // Asia/Srednekolymsk
    {   66, 3263,   32082,  6, }, // Asia/Taipei
    {   66, 4781,   32088,  8, }, // Asia/Tashkent
    {   66, 3915,   32096,  8, }, // Asia/Tbilisi
    {   66, 2772,   32104,  6, }, // Asia/Tehran
    {   66, 1317,   32110,  6, }, // Asia/Thimphu
    {   66, 2821,   32116,  6, }, // Asia/Tokyo
    {   66, 4572,   32122,  6, }, // Asia/Tomsk
    {   66, 1021,   32128,  9, }, // Asia/Ulaanbaatar
    {   66, 1159,   32137,  6, }, // Asia/Urumqi
    {   66, 8722,   32143,  9, }, // Asia/Ust-Nera
    {   66, 6977,   32152,  9, }, // Asia/Vientiane
    {   66, 4710,   32161, 12, }, // Asia/Vladivostok
    {   66, 4828,   32173,  9, }, // Asia/Yakutsk
    {   66, 1235,   32182,  5, }, // Asia/Yangon
    {   66, 3883,   32187, 15, }, // Asia/Yekaterinburg
    {   66, 3747,   32202,  7, }, // Asia/Yerevan
    {   66, 3663,   32209,  6, }, // Atlantic/Azores
    {   66, 5671,   32215,  8, }, // Atlantic/Bermuda
    {   66, 6628,   32223,  6, }, // Atlantic/Canary
    {   66, 3727,   32229, 10, }, // Atlantic/Cape_Verde
    {   66, 1395,   32239,  4, }, // Atlantic/Faroe
    {   66, 8736,   32243,  6, }, // Atlantic/Madeira
    {   66, 2748,   32249,  8, }, // Atlantic/Reykjavik
    {   66, 7272,   32257, 12, }, // Atlantic/South_Georgia
    {   66, 6821,   32269, 12, }, // Atlantic/St_Helena
    {   66, 6644,   32281,  7, }, // Atlantic/Stanley
    {   66, 1670,   32288,  6, }, // Australia/Adelaide
    {   66, 1635,   32294,  8, }, // Australia/Brisbane
    {   66, 1799,   32302, 11, }, // Australia/Broken_Hill
    {   66, 1583,   32313,  7, }, // Australia/Darwin
    {   66, 3637,   32320,  6, }, // Australia/Eucla
    {   66, 1516,   32326,  6, }, // Australia/Hobart
    {   66, 8753,   32332,  8, }, // Australia/Lindeman
    {   66, 1547,   32340,  9, }, // Australia/Lord_Howe
    {   66, 1727,   32349,  8, }, // Australia/Melbourne
    {   66, 1762,   32357,  5, }, // Australia/Perth
    {   66, 1463,   32362,  5, }, // Australia/Sydney
    {   66, 6441,   32367, 10, }, // Europe/Amsterdam
    {   66, 6216,   32377,  7, }, // Europe/Andorra
    {   66, 3620,   32384, 10, }, // Europe/Astrakhan
    {   66, 2300,   32394,  6, }, // Europe/Athens
    {   66, 6336,   32400,  8, }, // Europe/Belgrade
    {   66, 4757,   32408,  7, }, // Europe/Berlin
    {   66, 6488,   32415, 12, }, // Europe/Bratislava
    {   66, 2167,   32427, 11, }, // Europe/Brussels
    {   66, 3928,   32438,  9, }, // Europe/Bucharest
    {   66, 3806,   32447,  9, }, // Europe/Budapest
    {   66, 8772,   32456,  8, }, // Europe/Busingen
    {   66, 2583,   32464,  6, }, // Europe/Chisinau
    {   66, 6289,   32470,  9, }, // Europe/Copenhagen
    {   66, 2338,   32479,  6, }, // Europe/Dublin
    {   66, 6307,   32485, 11, }, // Europe/Gibraltar
    {   66, 8788,   32496,  7, }, // Europe/Guernsey
    {   66, 6612,   32503,  9, }, // Europe/Helsinki
    {   66, 8804,   32512, 11, }, // Europe/Isle_of_Man
    {   66, 1130,   32523,  9, }, // Europe/Istanbul
    {   66, 8823,   32532,  6, }, // Europe/Jersey
    {   66, 3979,   32538, 12, }, // Europe/Kaliningrad
    {   66, 8929,   32550,  5, }, // Europe/Kirov
    {   66, 2527,   32555,  3, }, // Europe/Kyiv
    {   66, 3213,   32558,  6, }, // Europe/Lisbon
    {   66, 6506,   32564, 10, }, // Europe/Ljubljana
    {   66, 2501,   32574,  5, }, // Europe/London
    {   66, 6365,   32579, 13, }, // Europe/Luxembourg
    {   66, 4892,   32592,  7, }, // Europe/Madrid
    {   66, 6397,   32599,  6, }, // Europe/Malta
    {   66, 6582,   32605,  7, }, // Europe/Mariehamn
    {   66, 3693,   32612,  7, }, // Europe/Minsk
    {   66, 6410,   32619,  5, }, // Europe/Monaco
    {   66, 3537,   32624,  5, }, // Europe/Moscow
    {   66, 6458,   32629,  5, }, // Europe/Oslo
    {   66, 4284,   32634,  5, }, // Europe/Paris
    {   66, 6424,   32639,  8, }, // Europe/Podgorica
    {   66, 6275,   32647,  5, }, // Europe/Prague
    {   66, 8837,   32652,  4, }, // Europe/Riga
    {   66, 6324,   32656,  3, }, // Europe/Rome
    {   66, 4331,   32659,  6, }, // Europe/Samara
    {   66, 6470,   32665, 10, }, // Europe/San_Marino
    {   66, 6245,   32675,  8, }, // Europe/Sarajevo
    {   66, 4451,   32683,  7, }, // Europe/Saratov
    {   66, 8849,   32690, 11, }, // Europe/Simferopol
    {   66, 6383,   32701,  8, }, // Europe/Skopje
    {   66, 6599,   32709,  5, }, // Europe/Sofia
    {   66, 6523,   32714,  8, }, // Europe/Stockholm
    {   66, 8867,   32722,  5, }, // Europe/Tallinn
    {   66, 6202,   32727,  5, }, // Europe/Tirane
    {   66, 8882,   32732, 12, }, // Europe/Ulyanovsk
    {   66, 6352,   32744,  5, }, // Europe/Vaduz
    {   66, 6567,   32749,  7, }, // Europe/Vatican
    {   66, 6231,   32756,  8, }, // Europe/Vienna
    {   66, 8899,   32764,  8, }, // Europe/Vilnius
    {   66, 4727,   32772, 10, }, // Europe/Volgograd
    {   66, 3190,   32782,  5, }, // Europe/Warsaw
    {   66, 6261,   32787,  7, }, // Europe/Zagreb
    {   66, 6540,   32794,  5, }, // Europe/Zurich
    {   66, 5078,   32799, 13, }, // Indian/Antananarivo
    {   66, 6947,   32812,  5, }, // Indian/Chagos
    {   66, 6046,   32817, 16, }, // Indian/Christmas
    {   66, 6063,   32833,  4, }, // Indian/Cocos
    {   66, 5029,   32837,  5, }, // Indian/Comoro
    {   66, 6661,   32842,  9, }, // Indian/Kerguelen
    {   66, 7260,   32851,  4, }, // Indian/Mahe
    {   66, 7050,   32855,  8, }, // Indian/Maldives
    {   66, 4069,   32863,  8, }, // Indian/Mauritius
    {   66, 5098,   32871,  8, }, // Indian/Mayotte
    {   66, 7211,   32879,  9, }, // Indian/Reunion
    {   66, 4422,   32888,  5, }, // Pacific/Apia
    {   66,  932,   32893,  7, }, // Pacific/Auckland
    {   66, 3706,   32900,  8, }, // Pacific/Bougainville
    {   66, 3015,   32908,  5, }, // Pacific/Chatham
    {   66, 3157,   32913,  3, }, // Pacific/Chuuk
    {   66, 2237,   32916,  9, }, // Pacific/Easter
    {   66, 7360,   32925,  5, }, // Pacific/Efate
    {   66, 7327,   32930,  7, }, // Pacific/Fakaofo
    {   66, 3902,   32937,  4, }, // Pacific/Fiji
    {   66, 7343,   32941,  8, }, // Pacific/Funafuti
    {   66, 6678,   32949,  9, }, // Pacific/Galapagos
    {   66, 6696,   32958,  9, }, // Pacific/Gambier
    {   66, 3822,   32967, 12, }, // Pacific/Guadalcanal
    {   66, 6018,   32979,  5, }, // Pacific/Guam
    {   66, 2723,   32984,  6, }, // Pacific/Honolulu
    {   66, 3049,   32990, 10, }, // Pacific/Kanton
    {   66, 3998,   33000, 10, }, // Pacific/Kiritimati
    {   66, 7019,   33010,  5, }, // Pacific/Kosrae
    {   66, 2842,   33015,  9, }, // Pacific/Kwajalein
    {   66, 4877,   33024,  6, }, // Pacific/Majuro
    {   66, 4051,   33030,  9, }, // Pacific/Marquesas
    {   66, 8914,   33039,  5, }, // Pacific/Midway
    {   66, 7084,   33044,  5, }, // Pacific/Nauru
    {   66, 7132,   33049,  4, }, // Pacific/Niue
    {   66, 4168,   33053,  5, }, // Pacific/Norfolk
    {   66, 7098,   33058,  6, }, // Pacific/Noumea
    {   66, 3126,   33064,  9, }, // Pacific/Pago_Pago
    {   66, 7155,   33073,  5, }, // Pacific/Palau
    {   66, 7194,   33078,  8, }, // Pacific/Pitcairn
    {   66, 3096,   33086,  5, }, // Pacific/Pohnpei
    {   66, 4807,   33091, 11, }, // Pacific/Port_Moresby
    {   66, 6076,   33102,  8, }, // Pacific/Rarotonga
    {   66, 6031,   33110,  6, }, // Pacific/Saipan
    {   66, 7312,   33116,  6, }, // Pacific/Tahiti
    {   66, 6712,   33122,  6, }, // Pacific/Tarawa
    {   66, 4583,   33128,  8, }, // Pacific/Tongatapu
    {   66, 7392,   33136,  3, }, // Pacific/Wake
    {   66, 7405,   33139,  5, }, // Pacific/Wallis
    {   67,   14,       0,  6, }, // Africa/Asmara Bosnian/Latin/Bosnia and Herzegovina
    {   67, 2320,    4572,  5, }, // Africa/Cairo
    {   67, 4117,   33144, 10, }, // Africa/Casablanca
    {   67, 5043,   33154,  7, }, // Africa/Djibouti
    {   67, 4524,    6305,  6, }, // Africa/Khartoum
    {   67, 5113,   33161,  7, }, // Africa/Mogadishu
    {   67, 4435,       6,  8, }, // Africa/Sao_Tome
    {   67, 5607,   33168,  7, }, // America/Anguilla
    {   67, 5624,   33175,  7, }, // America/Antigua
    {   67, 4252,      14,  8, }, // America/Asuncion
    {   67,  237,      22,  8, }, // America/Atikokan
    {   67, 7623,    3825, 14, }, // America/Bahia_Banderas
    {   67, 3868,   33182,  6, }, // America/Cancun
    {   67, 5496,    6576,  6, }, // America/Cayman
    {   67, 7774,      53, 13, }, // America/Ciudad_Juarez
    {   67, 5422,   33188,  9, }, // America/Costa_Rica
    {   67, 5723,    6631,  7, }, // America/Curacao
    {   67, 5739,   21548,  8, }, // America/Dominica
    {   67, 5441,    6688,  8, }, // America/El_Salvador
    {   67, 5786,   33197,  9, }, // America/Guadeloupe
    {   67, 3760,   33206,  9, }, // America/Guatemala
    {   67,  481,      73, 13, }, // America/Indiana/Knox
    {   67, 7961,      86, 16, }, // America/Indiana/Marengo
    {   67, 7985,     102, 19, }, // America/Indiana/Petersburg
    {   67, 8012,     121, 18, }, // America/Indiana/Tell_City
    {   67, 8038,     139, 14, }, // America/Indiana/Vevay
    {   67, 8060,     153, 18, }, // America/Indiana/Vincennes
    {   67, 8086,     171, 16, }, // America/Indiana/Winamac
    {   67, 2799,   33215,  7, }, // America/Jamaica
    {   67, 8125,     187, 20, }, // America/Kentucky/Monticello
    {   67, 5932,     207, 22, }, // America/Lower_Princes
    {   67, 8220,    7008,  6, }, // America/Merida
    {   67, 8301,   33222, 23, }, // America/North_Dakota/Beulah
    {   67, 8329,   33245, 23, }, // America/North_Dakota/Center
    {   67, 8357,   33268, 26, }, // America/North_Dakota/New_Salem
    {   67,  393,     298,  4, }, // America/Nuuk
    {   67, 5843,   33294,  9, }, // America/Puerto_Rico
    {   67, 6899,     302, 16, }, // America/Scoresbysund
    {   67, 8508,     318, 14, }, // America/St_Barthelemy
    {   67, 2061,     332, 10, }, // America/St_Johns
    {   67, 5863,     342,  9, }, // America/St_Kitts
    {   67, 5880,     351,  9, }, // America/St_Lucia
    {   67,  855,     360, 10, }, // America/St_Thomas
    {   67, 5913,     370, 11, }, // America/St_Vincent
    {   67, 6133,     381, 16, }, // Antarctica/DumontDUrville
    {   67, 5395,    7476,  6, }, // Asia/Almaty
    {   67, 3968,    5487,  4, }, // Asia/Amman
    {   67, 5511,    7482,  6, }, // Asia/Anadyr
    {   67, 5523,    5491,  5, }, // Asia/Aqtau
    {   67, 5368,   33303,  7, }, // Asia/Aqtobe
    {   67,  964,   33310,  7, }, // Asia/Ashgabat
    {   67, 8624,   33317,  6, }, // Asia/Atyrau
    {   67, 3607,    4044,  6, }, // Asia/Baghdad
    {   67, 5534,    4050,  7, }, // Asia/Bahrain
    {   67, 4086,    7507,  6, }, // Asia/Beirut
    {   67, 3778,   33323,  6, }, // Asia/Bishkek
    {   67, 5989,   33329,  7, }, // Asia/Brunei
    {   67, 4511,    5519,  7, }, // Asia/Colombo
    {   67, 4540,    4083,  6, }, // Asia/Damascus
    {   67, 1093,    4599,  4, }, // Asia/Dhaka
    {   67, 6159,   33336,  7, }, // Asia/Dushanbe
    {   67, 1259,   33343,  9, }, // Asia/Ho_Chi_Minh
    {   67, 7006,   33352,  8, }, // Asia/Jakarta
    {   67, 6992,   33360,  9, }, // Asia/Jayapura
    {   67, 1290,   33369,  9, }, // Asia/Jerusalem
    {   67, 4316,   33378,  8, }, // Asia/Kamchatka
    {   67, 4239,   33386,  6, }, // Asia/Karachi
    {   67, 1185,    5593,  8, }, // Asia/Kathmandu
    {   67, 8661,   33392,  7, }, // Asia/Khandyga
    {   67,  992,     422,  7, }, // Asia/Kolkata
    {   67, 4197,    4170, 11, }, // Asia/Krasnoyarsk
    {   67, 5976,   33399,  6, }, // Asia/Kuching
    {   67, 5547,    7607,  6, }, // Asia/Kuwait
    {   67, 1211,   33405,  5, }, // Asia/Macau
    {   67, 1349,    7618,  7, }, // Asia/Makassar
    {   67, 6920,    4208,  6, }, // Asia/Muscat
    {   67, 2554,   33410,  8, }, // Asia/Nicosia
    {   67, 8675,   33418, 12, }, // Asia/Novokuznetsk
    {   67, 6961,   22386,  8, }, // Asia/Phnom_Penh
    {   67, 4214,   33430,  9, }, // Asia/Pyongyang
    {   67, 5559,    4214,  5, }, // Asia/Qatar
    {   67, 8708,    7652,  8, }, // Asia/Qostanay
    {   67, 4269,    7660,  9, }, // Asia/Qyzylorda
    {   67, 3584,   33439,  5, }, // Asia/Riyadh
    {   67, 4408,   33444,  7, }, // Asia/Sakhalin
    {   67, 3279,    7680,  4, }, // Asia/Seoul
    {   67, 1053,   33451,  6, }, // Asia/Shanghai
    {   67, 3300,   20782,  8, }, // Asia/Singapore
    {   67, 3263,    7712,  6, }, // Asia/Taipei
    {   67, 4781,   33457,  7, }, // Asia/Tashkent
    {   67, 2772,    7724,  7, }, // Asia/Tehran
    {   67, 2821,    4238,  5, }, // Asia/Tokyo
    {   67, 1021,   26791, 10, }, // Asia/Ulaanbaatar
    {   67, 1159,   33464,  6, }, // Asia/Urumqi
    {   67, 6977,   33470, 10, }, // Asia/Vientiane
    {   67, 4828,    7755,  7, }, // Asia/Yakutsk
    {   67, 1235,    7762,  6, }, // Asia/Yangon
    {   67, 3883,    4262, 13, }, // Asia/Yekaterinburg
    {   67, 3747,    7780,  7, }, // Asia/Yerevan
    {   67, 3663,   33480,  5, }, // Atlantic/Azores
    {   67, 6628,    4280,  6, }, // Atlantic/Canary
    {   67, 3727,   22522, 10, }, // Atlantic/Cape_Verde
    {   67, 1395,     448,  5, }, // Atlantic/Faroe
    {   67, 2748,   33485,  9, }, // Atlantic/Reykjavik
    {   67, 6821,   33494, 12, }, // Atlantic/St_Helena
    {   67, 1547,   22595,  8, }, // Australia/Lord_Howe
    {   67, 1727,    7903,  7, }, // Australia/Melbourne
    {   67, 1762,   22603,  4, }, // Australia/Perth
    {   67, 1463,    7915,  6, }, // Australia/Sydney
    {   67, 6216,   33506,  6, }, // Europe/Andorra
    {   67, 3620,   33512,  8, }, // Europe/Astrakhan
    {   67, 2300,   33520,  5, }, // Europe/Athens
    {   67, 6336,    7942,  7, }, // Europe/Belgrade
    {   67, 2167,   33525,  6, }, // Europe/Brussels
    {   67, 3928,   33531,  8, }, // Europe/Bucharest
    {   67, 3806,   33539, 10, }, // Europe/Budapest
    {   67, 2583,   33549,  8, }, // Europe/Chisinau
    {   67, 6289,    4357, 10, }, // Europe/Copenhagen
    {   67, 2338,   33557,  6, }, // Europe/Dublin
    {   67, 8788,   33563,  6, }, // Europe/Guernsey
    {   67, 8804,   33569, 10, }, // Europe/Isle_of_Man
    {   67, 3979,   33579, 12, }, // Europe/Kaliningrad
    {   67, 2527,   33591,  5, }, // Europe/Kyiv
    {   67, 3213,   33596,  7, }, // Europe/Lisbon
    {   67, 6365,    8054, 10, }, // Europe/Luxembourg
    {   67, 6410,    5926,  6, }, // Europe/Monaco
    {   67, 3537,   22748,  6, }, // Europe/Moscow
    {   67, 4284,   33603,  5, }, // Europe/Paris
    {   67, 6275,    8083,  4, }, // Europe/Prague
    {   67, 6324,   33608,  3, }, // Europe/Rome
    {   67, 8849,   33611, 11, }, // Europe/Simferopol
    {   67, 6383,   33622,  7, }, // Europe/Skopje
    {   67, 6599,   33629,  6, }, // Europe/Sofia
    {   67, 6523,   33635,  8, }, // Europe/Stockholm
    {   67, 8867,    8132,  5, }, // Europe/Tallinn
    {   67, 6202,   21095,  6, }, // Europe/Tirane
    {   67, 6567,    5978,  7, }, // Europe/Vatican
    {   67, 6231,   33643,  3, }, // Europe/Vienna
    {   67, 3190,   33646,  7, }, // Europe/Warsaw
    {   67, 6540,   33653,  5, }, // Europe/Zurich
    {   67, 6046,   33658, 14, }, // Indian/Christmas
    {   67, 6063,   33672, 15, }, // Indian/Cocos
    {   67, 7050,   33687,  7, }, // Indian/Maldives
    {   67, 4069,   33694, 10, }, // Indian/Mauritius
    {   67, 7211,     467,  7, }, // Indian/Reunion
    {   67, 3157,     474,  5, }, // Pacific/Chuuk
    {   67, 3902,   33704,  5, }, // Pacific/Fiji
    {   67, 2723,    4493,  8, }, // Pacific/Honolulu
    {   67, 3049,    4501,  9, }, // Pacific/Kanton
    {   67, 7194,    8304,  7, }, // Pacific/Pitcairn
    {   67, 3096,     479,  7, }, // Pacific/Pohnpei
    {   67, 7405,   33709,  5, }, // Pacific/Wallis
    {   68, 6788,     486,  6, }, // Africa/Abidjan Bosnian/Cyrillic/Bosnia and Herzegovina
    {   68, 6760,   27046,  4, }, // Africa/Accra
    {   68, 5059,   33714, 10, }, // Africa/Addis_Ababa
    {   68, 7420,     508,  5, }, // Africa/Algiers
    {   68,   14,     513,  6, }, // Africa/Asmara
    {   68,   44,     519,  6, }, // Africa/Bamako
    {   68, 5257,   33724,  6, }, // Africa/Bangui
    {   68, 6746,     530,  6, }, // Africa/Banjul
    {   68, 7435,   33730,  5, }, // Africa/Bissau
    {   68, 4957,   33735,  7, }, // Africa/Blantyre
    {   68, 5287,   33742,  8, }, // Africa/Brazzaville
    {   68, 4922,   33750,  9, }, // Africa/Bujumbura
    {   68, 2320,   33759,  5, }, // Africa/Cairo
    {   68, 4117,   33764, 10, }, // Africa/Casablanca
    {   68, 7449,     581,  5, }, // Africa/Ceuta
    {   68, 6773,     586,  7, }, // Africa/Conakry
    {   68, 6840,     593,  5, }, // Africa/Dakar
    {   68, 5130,     598, 12, }, // Africa/Dar_es_Salaam
    {   68, 5043,     610,  6, }, // Africa/Djibouti
    {   68, 5243,     616,  5, }, // Africa/Douala
    {   68, 5166,   33774,  7, }, // Africa/El_Aaiun
    {   68, 6853,     628,  7, }, // Africa/Freetown
    {   68, 4906,     635,  7, }, // Africa/Gaborone
    {   68, 5015,   33781,  6, }, // Africa/Harare
    {   68, 4479,   33787, 11, }, // Africa/Johannesburg
    {   68, 4499,     661,  4, }, // Africa/Juba
    {   68, 5151,     665,  7, }, // Africa/Kampala
    {   68, 4524,   33798,  6, }, // Africa/Khartoum
    {   68, 4973,     678,  6, }, // Africa/Kigali
    {   68, 5306,     684,  7, }, // Africa/Kinshasa
    {   68, 4744,     691,  5, }, // Africa/Lagos
    {   68, 5336,     696,  8, }, // Africa/Libreville
    {   68, 6869,     704,  4, }, // Africa/Lome
    {   68, 5211,     708,  6, }, // Africa/Luanda
    {   68, 4939,   33804,  9, }, // Africa/Lubumbashi
    {   68, 5001,     723,  6, }, // Africa/Lusaka
    {   68, 5322,     729,  6, }, // Africa/Malabo
    {   68, 4987,   33813,  6, }, // Africa/Maputo
    {   68, 5197,     741,  6, }, // Africa/Maseru
    {   68, 5182,     747,  7, }, // Africa/Mbabane
    {   68, 5113,     754,  7, }, // Africa/Mogadishu
    {   68, 7034,   33819,  9, }, // Africa/Monrovia
    {   68, 3853,   33828,  7, }, // Africa/Nairobi
    {   68, 5271,     777,  7, }, // Africa/Ndjamena
    {   68, 5354,   33835,  7, }, // Africa/Niamey
    {   68, 6803,     790,  7, }, // Africa/Nouakchott
    {   68, 6727,     797,  8, }, // Africa/Ouagadougou
    {   68, 5225,   33842, 10, }, // Africa/Porto-Novo
    {   68, 4435,   33852,  8, }, // Africa/Sao_Tome
    {   68, 2866,     823,  7, }, // Africa/Tripoli
    {   68, 6554,     830,  5, }, // Africa/Tunis
    {   68, 4152,     835,  7, }, // Africa/Windhoek
    {   68,  132,     842,  4, }, // America/Adak
    {   68, 3346,   33860,  7, }, // America/Anchorage
    {   68, 5607,   33867,  7, }, // America/Anguilla
    {   68, 5624,   33874,  7, }, // America/Antigua
    {   68, 4554,   33881, 10, }, // America/Araguaina
    {   68,  166,   33891, 12, }, // America/Argentina/Buenos_Aires
    {   68,   91,     888,  9, }, // America/Argentina/Catamarca
    {   68,  270,   33903,  7, }, // America/Argentina/Cordoba
    {   68,  441,   33910,  5, }, // America/Argentina/Jujuy
    {   68, 7462,   33915,  8, }, // America/Argentina/La_Rioja
    {   68,  565,   33923,  7, }, // America/Argentina/Mendoza
    {   68, 7489,   33930, 11, }, // America/Argentina/Rio_Gallegos
    {   68, 7520,     935,  5, }, // America/Argentina/Salta
    {   68, 7544,   33941,  8, }, // America/Argentina/San_Juan
    {   68, 5580,   33949,  7, }, // America/Argentina/San_Luis
    {   68, 7571,     956,  7, }, // America/Argentina/Tucuman
    {   68, 7597,   33956,  7, }, // America/Argentina/Ushuaia
    {   68, 5640,     969,  5, }, // America/Aruba
    {   68, 4252,   33963,  8, }, // America/Asuncion
    {   68,  237,   33971,  8, }, // America/Atikokan
    {   68, 3679,   33979,  5, }, // America/Bahia
    {   68, 7623,   33984, 14, }, // America/Bahia_Banderas
    {   68, 5654,    1013,  8, }, // America/Barbados
    {   68, 7646,   33998,  5, }, // America/Belem
    {   68, 5407,   34003,  6, }, // America/Belize
    {   68, 7660,   34009, 13, }, // America/Blanc-Sablon
    {   68, 7681,   34022,  9, }, // America/Boa_Vista
    {   68, 4361,    1052,  6, }, // America/Bogota
    {   68, 7699,   34031,  5, }, // America/Boise
    {   68, 7713,   34036, 11, }, // America/Cambridge_Bay
    {   68, 7735,   34047, 12, }, // America/Campo_Grande
    {   68, 3868,    1087,  6, }, // America/Cancun
    {   68, 4694,    1093,  7, }, // America/Caracas
    {   68, 4345,   34059,  5, }, // America/Cayenne
    {   68, 5496,   34064, 16, }, // America/Cayman
    {   68, 2260,    1129,  6, }, // America/Chicago
    {   68, 7756,   34080,  6, }, // America/Chihuahua
    {   68, 5422,   34086,  9, }, // America/Costa_Rica
    {   68, 7796,    1151,  7, }, // America/Creston
    {   68, 3791,    1158,  6, }, // America/Cuiaba
    {   68, 5723,   34095,  7, }, // America/Curacao
    {   68, 7812,   34102, 13, }, // America/Danmarkshavn
    {   68, 7833,   34115,  5, }, // America/Dawson
    {   68, 7848,   34120, 10, }, // America/Dawson_Creek
    {   68,  805,    1201,  6, }, // America/Denver
    {   68, 3465,    1207,  7, }, // America/Detroit
    {   68, 5739,    1214,  8, }, // America/Dominica
    {   68,  893,    1222,  8, }, // America/Edmonton
    {   68, 7869,    1230,  8, }, // America/Eirunepe
    {   68, 5441,    1238,  8, }, // America/El_Salvador
    {   68, 7886,    1246, 11, }, // America/Fort_Nelson
    {   68, 7906,    1257,  9, }, // America/Fortaleza
    {   68, 7924,   34130,  9, }, // America/Glace_Bay
    {   68, 6881,   34139,  7, }, // America/Goose_Bay
    {   68, 4612,   34146, 10, }, // America/Grand_Turk
    {   68, 5770,    1292,  7, }, // America/Grenada
    {   68, 5786,   34156,  9, }, // America/Guadeloupe
    {   68, 3760,    1308,  9, }, // America/Guatemala
    {   68, 4841,   34165,  8, }, // America/Guayaquil
    {   68, 6932,   34173,  5, }, // America/Guyana
    {   68, 1939,   34178,  8, }, // America/Halifax
    {   68, 2281,   34186,  6, }, // America/Havana
    {   68, 7942,   34192,  9, }, // America/Hermosillo
    {   68,  348,    1353, 12, }, // America/Indiana/Indianapolis
    {   68,  481,   34201, 15, }, // America/Indiana/Knox
    {   68, 7961,   34216, 17, }, // America/Indiana/Marengo
    {   68, 7985,   34233, 20, }, // America/Indiana/Petersburg
    {   68, 8012,   34253, 18, }, // America/Indiana/Tell_City
    {   68, 8038,   34271, 15, }, // America/Indiana/Vevay
    {   68, 8060,   34286, 18, }, // America/Indiana/Vincennes
    {   68, 8086,   34304, 17, }, // America/Indiana/Winamac
    {   68, 8110,    1452,  6, }, // America/Inuvik
    {   68,  660,   34321,  8, }, // America/Iqaluit
    {   68, 2799,   34329,  7, }, // America/Jamaica
    {   68, 5380,   34336,  4, }, // America/Juneau
    {   68,  521,    1476,  7, }, // America/Kentucky/Louisville
    {   68, 8125,   34340, 18, }, // America/Kentucky/Monticello
    {   68, 5704,   34358, 10, }, // America/Kralendijk
    {   68, 4376,   34368,  6, }, // America/La_Paz
    {   68, 7169,    1520,  4, }, // America/Lima
    {   68, 3239,   34374, 11, }, // America/Los_Angeles
    {   68, 5932,   34385, 19, }, // America/Lower_Princes
    {   68, 8153,   34404,  6, }, // America/Maceio
    {   68, 8168,   34410,  7, }, // America/Managua
    {   68, 1908,    1566,  6, }, // America/Manaus
    {   68, 5897,    1572,  6, }, // America/Marigot
    {   68, 5805,    1578,  8, }, // America/Martinique
    {   68, 8184,    1587,  9, }, // America/Matamoros
    {   68, 2917,   34417,  8, }, // America/Mazatlan
    {   68, 8202,    1604,  8, }, // America/Menominee
    {   68, 8220,    1612,  6, }, // America/Merida
    {   68, 8235,    1618, 10, }, // America/Metlakatla
    {   68, 2949,   34425, 12, }, // America/Mexico_City
    {   68, 4391,    1634,  7, }, // America/Miquelon
    {   68, 8254,    1641,  7, }, // America/Moncton
    {   68, 8270,   34437,  8, }, // America/Monterrey
    {   68, 4098,    1657, 10, }, // America/Montevideo
    {   68, 5824,   34445,  9, }, // America/Montserrat
    {   68, 5481,   34454,  5, }, // America/Nassau
    {   68, 2379,   34459,  6, }, // America/New_York
    {   68, 8288,    1691,  3, }, // America/Nome
    {   68, 1850,   34465,  6, }, // America/Noronha
    {   68, 8301,   34471, 22, }, // America/North_Dakota/Beulah
    {   68, 8329,   34493, 22, }, // America/North_Dakota/Center
    {   68, 8357,   34515, 26, }, // America/North_Dakota/New_Salem
    {   68,  393,   28151,  3, }, // America/Nuuk
    {   68, 8388,    1776,  7, }, // America/Ojinaga
    {   68, 2356,    1783,  6, }, // America/Panama
    {   68, 6173,    1789, 10, }, // America/Paramaribo
    {   68, 2973,   34541,  6, }, // America/Phoenix
    {   68, 3945,    1805, 12, }, // America/Port-au-Prince
    {   68, 5954,   34547, 13, }, // America/Port_of_Spain
    {   68, 8404,   34560, 10, }, // America/Porto_Velho
    {   68, 5843,   34570,  9, }, // America/Puerto_Rico
    {   68, 4030,   34579, 12, }, // America/Punta_Arenas
    {   68, 8424,   34591, 12, }, // America/Rankin_Inlet
    {   68, 8445,   34603,  6, }, // America/Recife
    {   68, 1995,   34609,  6, }, // America/Regina
    {   68, 8460,   34615,  7, }, // America/Resolute
    {   68,  695,   34622, 10, }, // America/Rio_Branco
    {   68, 8477,   34632,  8, }, // America/Santarem
    {   68, 2201,   34640,  9, }, // America/Santiago
    {   68, 6111,   34649, 13, }, // America/Santo_Domingo
    {   68, 1878,   34662,  9, }, // America/Sao_Paulo
    {   68, 6899,   34671, 12, }, // America/Scoresbysund
    {   68, 8494,    1956,  5, }, // America/Sitka
    {   68, 8508,   34683, 14, }, // America/St_Barthelemy
    {   68, 2061,   34697,  7, }, // America/St_Johns
    {   68, 5863,   34704,  9, }, // America/St_Kitts
    {   68, 5880,   34713, 10, }, // America/St_Lucia
    {   68,  855,   34723,  8, }, // America/St_Thomas
    {   68, 5913,   34731, 12, }, // America/St_Vincent
    {   68, 8530,   34743, 12, }, // America/Swift_Current
    {   68, 5461,    2038, 11, }, // America/Tegucigalpa
    {   68, 5756,    2049,  4, }, // America/Thule
    {   68,  313,    2053,  7, }, // America/Tijuana
    {   68,  608,    2060,  7, }, // America/Toronto
    {   68, 5688,    2067,  7, }, // America/Tortola
    {   68, 2093,    2074,  8, }, // America/Vancouver
    {   68, 2144,   34755,  8, }, // America/Whitehorse
    {   68,  734,   34763,  7, }, // America/Winnipeg
    {   68, 8552,   34770,  7, }, // America/Yakutat
    {   68, 6001,   34777,  5, }, // Antarctica/Casey
    {   68, 6094,   34782,  6, }, // Antarctica/Davis
    {   68, 6133,   34788, 13, }, // Antarctica/DumontDUrville
    {   68, 8568,   34801,  7, }, // Antarctica/Macquarie
    {   68, 7066,   34808,  5, }, // Antarctica/Mawson
    {   68, 7113,   34813,  8, }, // Antarctica/McMurdo
    {   68, 8589,    2154,  6, }, // Antarctica/Palmer
    {   68, 7226,    2160,  6, }, // Antarctica/Rothera
    {   68, 7295,   34821,  4, }, // Antarctica/Syowa
    {   68, 8607,    2171,  4, }, // Antarctica/Troll
    {   68, 7374,   34825,  6, }, // Antarctica/Vostok
    {   68, 1429,   34831, 11, }, // Arctic/Longyearbyen
    {   68, 5570,    2192,  4, }, // Asia/Aden
    {   68, 5395,   34842,  6, }, // Asia/Almaty
    {   68, 3968,   28531,  4, }, // Asia/Amman
    {   68, 5511,   34848,  6, }, // Asia/Anadyr
    {   68, 5523,    2213,  5, }, // Asia/Aqtau
    {   68, 5368,   34854,  7, }, // Asia/Aqtobe
    {   68,  964,    2224,  7, }, // Asia/Ashgabat
    {   68, 8624,   34861,  6, }, // Asia/Atyrau
    {   68, 3607,    2237,  6, }, // Asia/Baghdad
    {   68, 5534,    2243,  7, }, // Asia/Bahrain
    {   68, 3653,    2250,  4, }, // Asia/Baku
    {   68, 4466,   34867,  6, }, // Asia/Bangkok
    {   68, 3571,    2261,  7, }, // Asia/Barnaul
    {   68, 4086,   34873,  6, }, // Asia/Beirut
    {   68, 3778,    2274,  6, }, // Asia/Bishkek
    {   68, 5989,   34879,  7, }, // Asia/Brunei
    {   68, 4601,    2286,  4, }, // Asia/Chita
    {   68, 4511,    2290,  7, }, // Asia/Colombo
    {   68, 4540,    2297,  6, }, // Asia/Damascus
    {   68, 1093,     593,  4, }, // Asia/Dhaka
    {   68, 6192,    2308,  4, }, // Asia/Dili
    {   68, 3596,    2312,  5, }, // Asia/Dubai
    {   68, 6159,    2317,  7, }, // Asia/Dushanbe
    {   68, 8636,    2324,  9, }, // Asia/Famagusta
    {   68, 8651,    2333,  4, }, // Asia/Gaza
    {   68, 4795,   34886,  6, }, // Asia/Hebron
    {   68, 1259,   34892,  9, }, // Asia/Ho_Chi_Minh
    {   68, 2704,   34901,  9, }, // Asia/Hong_Kong
    {   68, 4771,    2357,  4, }, // Asia/Hovd
    {   68, 4184,   34910,  6, }, // Asia/Irkutsk
    {   68, 7006,    2368,  7, }, // Asia/Jakarta
    {   68, 6992,   34916,  8, }, // Asia/Jayapura
    {   68, 1290,   34924,  9, }, // Asia/Jerusalem
    {   68, 3560,    2392,  5, }, // Asia/Kabul
    {   68, 4316,    2411,  8, }, // Asia/Kamchatka
    {   68, 4239,    2422,  6, }, // Asia/Karachi
    {   68, 1185,    2428,  8, }, // Asia/Kathmandu
    {   68, 8661,   34933,  7, }, // Asia/Khandyga
    {   68,  992,   34940,  7, }, // Asia/Kolkata
    {   68, 4197,   34947, 11, }, // Asia/Krasnoyarsk
    {   68, 4859,   34958, 12, }, // Asia/Kuala_Lumpur
    {   68, 5976,    2474,  6, }, // Asia/Kuching
    {   68, 5547,   34970,  6, }, // Asia/Kuwait
    {   68, 1211,   34976,  5, }, // Asia/Macau
    {   68, 4017,    2491,  7, }, // Asia/Magadan
    {   68, 1349,    2498,  7, }, // Asia/Makassar
    {   68, 7182,    2505,  6, }, // Asia/Manila
    {   68, 6920,   34981,  6, }, // Asia/Muscat
    {   68, 2554,   34987,  8, }, // Asia/Nicosia
    {   68, 8675,   34995, 11, }, // Asia/Novokuznetsk
    {   68, 4135,    2535, 11, }, // Asia/Novosibirsk
    {   68, 4229,    2546,  4, }, // Asia/Omsk
    {   68, 7145,   35006,  4, }, // Asia/Oral
    {   68, 6961,   35010,  8, }, // Asia/Phnom_Penh
    {   68, 8693,    2563,  9, }, // Asia/Pontianak
    {   68, 4214,   35018,  9, }, // Asia/Pyongyang
    {   68, 5559,    2579,  5, }, // Asia/Qatar
    {   68, 8708,   35027,  8, }, // Asia/Qostanay
    {   68, 4269,   35035,  9, }, // Asia/Qyzylorda
    {   68, 3584,   35044,  5, }, // Asia/Riyadh
    {   68, 4408,    2614,  7, }, // Asia/Sakhalin
    {   68, 7245,    2621,  9, }, // Asia/Samarkand
    {   68, 3279,    2630,  4, }, // Asia/Seoul
    {   68, 1053,   35049,  6, }, // Asia/Shanghai
    {   68, 3300,    2640,  8, }, // Asia/Singapore
    {   68, 4297,   35055, 13, }, // Asia/Srednekolymsk
    {   68, 3263,   35068,  6, }, // Asia/Taipei
    {   68, 4781,    2667,  7, }, // Asia/Tashkent
    {   68, 3915,   35074,  7, }, // Asia/Tbilisi
    {   68, 2772,   35081,  7, }, // Asia/Tehran
    {   68, 1317,   35088,  5, }, // Asia/Thimphu
    {   68, 2821,    2692,  5, }, // Asia/Tokyo
    {   68, 4572,    2697,  5, }, // Asia/Tomsk
    {   68, 1021,   35093, 10, }, // Asia/Ulaanbaatar
    {   68, 1159,   35103,  7, }, // Asia/Urumqi
    {   68, 8722,    2718,  8, }, // Asia/Ust-Nera
    {   68, 6977,   35110, 10, }, // Asia/Vientiane
    {   68, 4710,    2733, 11, }, // Asia/Vladivostok
    {   68, 4828,   35120,  7, }, // Asia/Yakutsk
    {   68, 1235,   28911,  6, }, // Asia/Yangon
    {   68, 3883,   35127, 13, }, // Asia/Yekaterinburg
    {   68, 3747,   35140,  7, }, // Asia/Yerevan
    {   68, 3663,   35147,  5, }, // Atlantic/Azores
    {   68, 5671,   35152,  7, }, // Atlantic/Bermuda
    {   68, 6628,   35159, 15, }, // Atlantic/Canary
    {   68, 3727,   35174, 18, }, // Atlantic/Cape_Verde
    {   68, 1395,   35192, 13, }, // Atlantic/Faroe
    {   68, 8736,    2853,  7, }, // Atlantic/Madeira
    {   68, 2748,   35205,  9, }, // Atlantic/Reykjavik
    {   68, 7272,   35214, 13, }, // Atlantic/South_Georgia
    {   68, 6821,   35227, 10, }, // Atlantic/St_Helena
    {   68, 6644,    2911,  6, }, // Atlantic/Stanley
    {   68, 1670,    2917,  8, }, // Australia/Adelaide
    {   68, 1635,   35237,  8, }, // Australia/Brisbane
    {   68, 1799,   35245, 10, }, // Australia/Broken_Hill
    {   68, 1583,    2943,  6, }, // Australia/Darwin
    {   68, 3637,    2949,  5, }, // Australia/Eucla
    {   68, 1516,    2954,  6, }, // Australia/Hobart
    {   68, 8753,    2960,  8, }, // Australia/Lindeman
    {   68, 1547,   35255,  8, }, // Australia/Lord_Howe
    {   68, 1727,    2976,  7, }, // Australia/Melbourne
    {   68, 1762,    2983,  4, }, // Australia/Perth
    {   68, 1463,   35263,  6, }, // Australia/Sydney
    {   68, 6441,    2993,  9, }, // Europe/Amsterdam
    {   68, 6216,   29143,  6, }, // Europe/Andorra
    {   68, 3620,    3009,  8, }, // Europe/Astrakhan
    {   68, 2300,   35269,  5, }, // Europe/Athens
    {   68, 6336,   35274,  7, }, // Europe/Belgrade
    {   68, 4757,    3028,  6, }, // Europe/Berlin
    {   68, 6488,    3034, 10, }, // Europe/Bratislava
    {   68, 2167,   35281,  6, }, // Europe/Brussels
    {   68, 3928,   35287,  8, }, // Europe/Bucharest
    {   68, 3806,   35295, 10, }, // Europe/Budapest
    {   68, 8772,   35305,  8, }, // Europe/Busingen
    {   68, 2583,   35313,  7, }, // Europe/Chisinau
    {   68, 6289,   35320, 10, }, // Europe/Copenhagen
    {   68, 2338,   35330,  6, }, // Europe/Dublin
    {   68, 6307,    3114,  9, }, // Europe/Gibraltar
    {   68, 8788,   35336,  6, }, // Europe/Guernsey
    {   68, 6612,    3129,  8, }, // Europe/Helsinki
    {   68, 8804,   35342, 10, }, // Europe/Isle_of_Man
    {   68, 1130,   35352,  8, }, // Europe/Istanbul
    {   68, 8823,    3153,  5, }, // Europe/Jersey
    {   68, 3979,   35360, 11, }, // Europe/Kaliningrad
    {   68, 8929,    3169,  5, }, // Europe/Kirov
    {   68, 2527,   35371,  5, }, // Europe/Kyiv
    {   68, 3213,   35376,  7, }, // Europe/Lisbon
    {   68, 6506,   35383,  7, }, // Europe/Ljubljana
    {   68, 2501,    3195,  6, }, // Europe/London
    {   68, 6365,   35390, 10, }, // Europe/Luxembourg
    {   68, 4892,    3212,  6, }, // Europe/Madrid
    {   68, 6397,    3218,  5, }, // Europe/Malta
    {   68, 6582,   35400,  8, }, // Europe/Mariehamn
    {   68, 3693,    3232,  5, }, // Europe/Minsk
    {   68, 6410,    3237,  6, }, // Europe/Monaco
    {   68, 3537,    3243,  6, }, // Europe/Moscow
    {   68, 6458,    3249,  4, }, // Europe/Oslo
    {   68, 4284,   35408,  5, }, // Europe/Paris
    {   68, 6424,    3258,  9, }, // Europe/Podgorica
    {   68, 6275,    3267,  4, }, // Europe/Prague
    {   68, 8837,    3272,  4, }, // Europe/Riga
    {   68, 6324,    3276,  3, }, // Europe/Rome
    {   68, 4331,    3279,  6, }, // Europe/Samara
    {   68, 6470,   35413, 10, }, // Europe/San_Marino
    {   68, 6245,   35423,  8, }, // Europe/Sarajevo
    {   68, 4451,    3302,  7, }, // Europe/Saratov
    {   68, 8849,   35431, 10, }, // Europe/Simferopol
    {   68, 6383,   35441,  6, }, // Europe/Skopje
    {   68, 6599,   35447,  6, }, // Europe/Sofia
    {   68, 6523,   35453,  8, }, // Europe/Stockholm
    {   68, 8867,   35461,  5, }, // Europe/Tallinn
    {   68, 6202,    3343,  6, }, // Europe/Tirane
    {   68, 8882,   35466,  8, }, // Europe/Ulyanovsk
    {   68, 6352,   35474,  5, }, // Europe/Vaduz
    {   68, 6567,    3363,  7, }, // Europe/Vatican
    {   68, 6231,   35479,  3, }, // Europe/Vienna
    {   68, 8899,   35482,  6, }, // Europe/Vilnius
    {   68, 4727,    3381,  9, }, // Europe/Volgograd
    {   68, 3190,    3390,  7, }, // Europe/Warsaw
    {   68, 6261,    3397,  6, }, // Europe/Zagreb
    {   68, 6540,   35488,  5, }, // Europe/Zurich
    {   68, 5078,   35493, 12, }, // Indian/Antananarivo
    {   68, 6947,    3421,  5, }, // Indian/Chagos
    {   68, 6046,   35505,  5, }, // Indian/Christmas
    {   68, 6063,    3438,  5, }, // Indian/Cocos
    {   68, 5029,   35510,  6, }, // Indian/Comoro
    {   68, 6661,    3460,  8, }, // Indian/Kerguelen
    {   68, 7260,   35516,  4, }, // Indian/Mahe
    {   68, 7050,   35520,  7, }, // Indian/Maldives
    {   68, 4069,   35527, 10, }, // Indian/Mauritius
    {   68, 5098,   35537,  5, }, // Indian/Mayotte
    {   68, 7211,   35542,  7, }, // Indian/Reunion
    {   68, 4422,   35549,  5, }, // Pacific/Apia
    {   68,  932,   35554,  6, }, // Pacific/Auckland
    {   68, 3706,    3508,  8, }, // Pacific/Bougainville
    {   68, 3015,   35560,  6, }, // Pacific/Chatham
    {   68, 3157,    3521,  4, }, // Pacific/Chuuk
    {   68, 2237,   35566, 14, }, // Pacific/Easter
    {   68, 7360,    3536,  4, }, // Pacific/Efate
    {   68, 7327,    3541,  7, }, // Pacific/Fakaofo
    {   68, 3902,    3548,  4, }, // Pacific/Fiji
    {   68, 7343,    3552,  8, }, // Pacific/Funafuti
    {   68, 6678,    3560,  9, }, // Pacific/Galapagos
    {   68, 6696,   35580,  7, }, // Pacific/Gambier
    {   68, 3822,   35587, 11, }, // Pacific/Guadalcanal
    {   68, 6018,    3606,  4, }, // Pacific/Guam
    {   68, 2723,   35598,  8, }, // Pacific/Honolulu
    {   68, 3049,   35606,  9, }, // Pacific/Kanton
    {   68, 3998,    3616, 10, }, // Pacific/Kiritimati
    {   68, 7019,   35615,  5, }, // Pacific/Kosrae
    {   68, 2842,   35620, 10, }, // Pacific/Kwajalein
    {   68, 4877,   35630,  6, }, // Pacific/Majuro
    {   68, 4051,    3647,  6, }, // Pacific/Marquesas
    {   68, 8914,   35636,  6, }, // Pacific/Midway
    {   68, 7084,    3680,  5, }, // Pacific/Nauru
    {   68, 7132,    3685,  4, }, // Pacific/Niue
    {   68, 4168,    3689,  7, }, // Pacific/Norfolk
    {   68, 7098,    3696,  5, }, // Pacific/Noumea
    {   68, 3126,   35642,  9, }, // Pacific/Pago_Pago
    {   68, 7155,    3710,  5, }, // Pacific/Palau
    {   68, 7194,    3715,  7, }, // Pacific/Pitcairn
    {   68, 3096,   35651,  6, }, // Pacific/Pohnpei
    {   68, 4807,   35657, 11, }, // Pacific/Port_Moresby
    {   68, 6076,    3739,  9, }, // Pacific/Rarotonga
    {   68, 6031,   35668,  6, }, // Pacific/Saipan
    {   68, 7312,   35674,  6, }, // Pacific/Tahiti
    {   68, 6712,    3759,  6, }, // Pacific/Tarawa
    {   68, 4583,    3765,  9, }, // Pacific/Tongatapu
    {   68, 7392,   35680,  4, }, // Pacific/Wake
    {   68, 7405,   35684,  5, }, // Pacific/Wallis
    {   69, 5059,   35689, 10, }, // Africa/Addis_Ababa Breton/Latin/France
    {   69, 7420,   26343,  5, }, // Africa/Algiers
    {   69,   14,       0,  6, }, // Africa/Asmara
    {   69, 2320,   35699,  5, }, // Africa/Cairo
    {   69, 4117,   35704, 25, }, // Africa/Casablanca
    {   69, 5166,   35729,  7, }, // Africa/El_Aaiun
    {   69, 6869,   20300,  4, }, // Africa/Lome
    {   69, 5113,   26379,  8, }, // Africa/Mogadishu
    {   69, 5271,   35736,  9, }, // Africa/Ndjamena
    {   69, 4435,       6,  8, }, // Africa/Sao_Tome
    {   69, 2866,   35745, 19, }, // Africa/Tripoli
    {   69, 6554,    6349,  5, }, // Africa/Tunis
    {   69, 4252,      14,  8, }, // America/Asuncion
    {   69,  237,      22,  8, }, // America/Atikokan
    {   69, 7623,      30, 17, }, // America/Bahia_Banderas
    {   69, 7646,   35764,  5, }, // America/Belem
    {   69, 4361,   20389,  6, }, // America/Bogota
    {   69, 3868,      47,  6, }, // America/Cancun
    {   69, 7774,      53, 13, }, // America/Ciudad_Juarez
    {   69, 5723,      66,  7, }, // America/Curacao
    {   69, 5441,    6688,  8, }, // America/El_Salvador
    {   69, 5786,   35769,  9, }, // America/Guadeloupe
    {   69, 2281,   20417,  9, }, // America/Havana
    {   69,  481,      73, 13, }, // America/Indiana/Knox
    {   69, 7961,      86, 16, }, // America/Indiana/Marengo
    {   69, 7985,     102, 19, }, // America/Indiana/Petersburg
    {   69, 8012,     121, 18, }, // America/Indiana/Tell_City
    {   69, 8038,     139, 14, }, // America/Indiana/Vevay
    {   69, 8060,     153, 18, }, // America/Indiana/Vincennes
    {   69, 8086,     171, 16, }, // America/Indiana/Winamac
    {   69, 2799,    3877,  7, }, // America/Jamaica
    {   69, 8125,     187, 20, }, // America/Kentucky/Monticello
    {   69, 5932,     207, 22, }, // America/Lower_Princes
    {   69, 5805,    5142,  8, }, // America/Martinique
    {   69, 8220,     229,  6, }, // America/Merida
    {   69, 2949,   35778, 12, }, // America/Mexico_City
    {   69, 4391,    7031,  7, }, // America/Miquelon
    {   69, 8301,     235, 20, }, // America/North_Dakota/Beulah
    {   69, 8329,     255, 20, }, // America/North_Dakota/Center
    {   69, 8357,     275, 23, }, // America/North_Dakota/New_Salem
    {   69,  393,   35790, 14, }, // America/Nuuk
    {   69, 2356,   20547,  6, }, // America/Panama
    {   69, 1878,   26580,  9, }, // America/Sao_Paulo
    {   69, 6899,     302, 16, }, // America/Scoresbysund
    {   69, 8508,   35804, 16, }, // America/St_Barthelemy
    {   69, 2061,   35820, 12, }, // America/St_Johns
    {   69, 5863,   26617, 11, }, // America/St_Kitts
    {   69, 5880,   35832, 11, }, // America/St_Lucia
    {   69,  855,     360, 10, }, // America/St_Thomas
    {   69, 5913,   35843, 11, }, // America/St_Vincent
    {   69, 5756,   35854,  5, }, // America/Thule
    {   69, 6133,     381, 16, }, // Antarctica/DumontDUrville
    {   69, 5511,   35859,  7, }, // Asia/Anadyr
    {   69, 5534,    4050,  7, }, // Asia/Bahrain
    {   69, 3653,   35866,  5, }, // Asia/Baku
    {   69, 4086,   35871,  6, }, // Asia/Beirut
    {   69, 4601,   35877,  6, }, // Asia/Chita
    {   69, 4511,   35883,  7, }, // Asia/Colombo
    {   69, 4540,    4083,  6, }, // Asia/Damascus
    {   69, 1259,   35890, 15, }, // Asia/Ho_Chi_Minh
    {   69, 1290,   33369,  9, }, // Asia/Jerusalem
    {   69, 3560,   35905,  6, }, // Asia/Kabul
    {   69, 4316,   35911, 10, }, // Asia/Kamchatka
    {   69, 1185,     413,  9, }, // Asia/Kathmandu
    {   69,  992,   35921,  8, }, // Asia/Kolkata
    {   69, 5547,   35929,  6, }, // Asia/Kuwait
    {   69, 1211,    4203,  5, }, // Asia/Macau
    {   69, 6920,   35935,  6, }, // Asia/Muscat
    {   69, 2554,   35941,  8, }, // Asia/Nicosia
    {   69, 6961,   35949, 10, }, // Asia/Phnom_Penh
    {   69, 4214,   35959, 10, }, // Asia/Pyongyang
    {   69, 3300,   35969,  9, }, // Asia/Singapore
    {   69, 4781,   35978,  8, }, // Asia/Tashkent
    {   69, 1159,   26801,  6, }, // Asia/Urumqi
    {   69, 6977,   35986,  9, }, // Asia/Vientiane
    {   69, 1235,     442,  6, }, // Asia/Yangon
    {   69, 3883,   35995, 14, }, // Asia/Yekaterinburg
    {   69, 3663,   36009,  6, }, // Atlantic/Azores
    {   69, 5671,   36015,  8, }, // Atlantic/Bermuda
    {   69, 6628,   36023,  8, }, // Atlantic/Canary
    {   69, 3727,   36031,  8, }, // Atlantic/Cape_Verde
    {   69, 1395,   36039,  5, }, // Atlantic/Faroe
    {   69, 2748,   36044,  9, }, // Atlantic/Reykjavik
    {   69, 7272,   36053, 13, }, // Atlantic/South_Georgia
    {   69, 6821,   36066, 12, }, // Atlantic/St_Helena
    {   69, 2300,    5793,  4, }, // Europe/Athens
    {   69, 6336,    7942,  7, }, // Europe/Belgrade
    {   69, 2167,   26890,  6, }, // Europe/Brussels
    {   69, 3928,   26897,  8, }, // Europe/Bucharest
    {   69, 6289,    4357, 10, }, // Europe/Copenhagen
    {   69, 2338,   36078,  6, }, // Europe/Dublin
    {   69, 6307,   36084,  9, }, // Europe/Gibraltar
    {   69, 8788,   36093,  9, }, // Europe/Guernsey
    {   69, 8804,   36102,  5, }, // Europe/Isle_of_Man
    {   69, 8823,   36107,  8, }, // Europe/Jersey
    {   69, 2527,    8030,  4, }, // Europe/Kyiv
    {   69, 3213,   21019,  6, }, // Europe/Lisbon
    {   69, 2501,   36115,  7, }, // Europe/London
    {   69, 6365,   36122, 11, }, // Europe/Luxembourg
    {   69, 6582,   36133,  9, }, // Europe/Mariehamn
    {   69, 3693,   36142,  5, }, // Europe/Minsk
    {   69, 3537,   36147,  6, }, // Europe/Moscow
    {   69, 4284,   33603,  5, }, // Europe/Paris
    {   69, 6275,   36153,  5, }, // Europe/Prague
    {   69, 6324,    5946,  4, }, // Europe/Rome
    {   69, 6202,    8137,  6, }, // Europe/Tirane
    {   69, 6567,    5978,  7, }, // Europe/Vatican
    {   69, 3190,   21126,  8, }, // Europe/Warsaw
    {   69, 6063,   36158,  5, }, // Indian/Cocos
    {   69, 5029,   36163,  7, }, // Indian/Comoro
    {   69, 6661,   36170,  9, }, // Indian/Kerguelen
    {   69, 7050,   36179,  8, }, // Indian/Maldives
    {   69, 4069,   36187,  5, }, // Indian/Mauritius
    {   69, 7211,   36192,  7, }, // Indian/Reunion
    {   69, 3157,     474,  5, }, // Pacific/Chuuk
    {   69, 2237,   36199,  9, }, // Pacific/Easter
    {   69, 3902,    4488,  5, }, // Pacific/Fiji
    {   69, 6678,   21159,  9, }, // Pacific/Galapagos
    {   69, 2723,    4493,  8, }, // Pacific/Honolulu
    {   69, 4051,   36208,  6, }, // Pacific/Marquesas
    {   69, 3096,     479,  7, }, // Pacific/Pohnpei
    {   70, 6788,   36214,  7, }, // Africa/Abidjan Bulgarian/Cyrillic/Bulgaria
    {   70, 6760,   27046,  4, }, // Africa/Accra
    {   70, 5059,   33714, 10, }, // Africa/Addis_Ababa
    {   70, 7420,     508,  5, }, // Africa/Algiers
    {   70,   14,   27065,  6, }, // Africa/Asmara
    {   70,   44,     519,  6, }, // Africa/Bamako
    {   70, 5257,   33724,  6, }, // Africa/Bangui
    {   70, 6746,   27076,  7, }, // Africa/Banjul
    {   70, 7435,     536,  5, }, // Africa/Bissau
    {   70, 4957,   36221,  9, }, // Africa/Blantyre
    {   70, 5287,   33742,  8, }, // Africa/Brazzaville
    {   70, 4922,     558,  9, }, // Africa/Bujumbura
    {   70, 2320,   36230,  5, }, // Africa/Cairo
    {   70, 4117,   33764, 10, }, // Africa/Casablanca
    {   70, 7449,     581,  5, }, // Africa/Ceuta
    {   70, 6773,     586,  7, }, // Africa/Conakry
    {   70, 6840,     593,  5, }, // Africa/Dakar
    {   70, 5130,   36235, 12, }, // Africa/Dar_es_Salaam
    {   70, 5043,   36247,  7, }, // Africa/Djibouti
    {   70, 5243,     616,  5, }, // Africa/Douala
    {   70, 5166,   36254,  6, }, // Africa/El_Aaiun
    {   70, 6853,   36260,  8, }, // Africa/Freetown
    {   70, 4906,     635,  8, }, // Africa/Gaborone
    {   70, 5015,   33781,  6, }, // Africa/Harare
    {   70, 4479,   36268, 11, }, // Africa/Johannesburg
    {   70, 4499,   27173,  5, }, // Africa/Juba
    {   70, 5151,     665,  7, }, // Africa/Kampala
    {   70, 4524,     672,  6, }, // Africa/Khartoum
    {   70, 4973,     678,  6, }, // Africa/Kigali
    {   70, 5306,     684,  7, }, // Africa/Kinshasa
    {   70, 4744,     691,  5, }, // Africa/Lagos
    {   70, 5336,     696,  8, }, // Africa/Libreville
    {   70, 6869,     704,  4, }, // Africa/Lome
    {   70, 5211,     708,  6, }, // Africa/Luanda
    {   70, 4939,     714,  9, }, // Africa/Lubumbashi
    {   70, 5001,     723,  6, }, // Africa/Lusaka
    {   70, 5322,     729,  6, }, // Africa/Malabo
    {   70, 4987,   33813,  6, }, // Africa/Maputo
    {   70, 5197,     741,  6, }, // Africa/Maseru
    {   70, 5182,     747,  7, }, // Africa/Mbabane
    {   70, 5113,   36279,  8, }, // Africa/Mogadishu
    {   70, 7034,   36287,  8, }, // Africa/Monrovia
    {   70, 3853,   36295,  7, }, // Africa/Nairobi
    {   70, 5271,   27254,  8, }, // Africa/Ndjamena
    {   70, 5354,   36302,  6, }, // Africa/Niamey
    {   70, 6803,     790,  7, }, // Africa/Nouakchott
    {   70, 6727,     797,  8, }, // Africa/Ouagadougou
    {   70, 5225,   33842, 10, }, // Africa/Porto-Novo
    {   70, 4435,   33852,  8, }, // Africa/Sao_Tome
    {   70, 2866,     823,  7, }, // Africa/Tripoli
    {   70, 6554,     830,  5, }, // Africa/Tunis
    {   70, 4152,     835,  7, }, // Africa/Windhoek
    {   70,  132,     842,  4, }, // America/Adak
    {   70, 3346,   36308,  8, }, // America/Anchorage
    {   70, 5607,   36316,  7, }, // America/Anguilla
    {   70, 5624,     860,  7, }, // America/Antigua
    {   70, 4554,   36323,  9, }, // America/Araguaina
    {   70,  166,   36332, 12, }, // America/Argentina/Buenos_Aires
    {   70,   91,     888,  9, }, // America/Argentina/Catamarca
    {   70,  270,   33903,  7, }, // America/Argentina/Cordoba
    {   70,  441,   36344,  5, }, // America/Argentina/Jujuy
    {   70, 7462,   33915,  8, }, // America/Argentina/La_Rioja
    {   70,  565,     917,  7, }, // America/Argentina/Mendoza
    {   70, 7489,   36349, 11, }, // America/Argentina/Rio_Gallegos
    {   70, 7520,     935,  5, }, // America/Argentina/Salta
    {   70, 7544,   33941,  8, }, // America/Argentina/San_Juan
    {   70, 5580,   36360,  8, }, // America/Argentina/San_Luis
    {   70, 7571,     956,  7, }, // America/Argentina/Tucuman
    {   70, 7597,   27394,  5, }, // America/Argentina/Ushuaia
    {   70, 5640,     969,  5, }, // America/Aruba
    {   70, 4252,   33963,  8, }, // America/Asuncion
    {   70,  237,   33971,  8, }, // America/Atikokan
    {   70, 3679,   36368,  4, }, // America/Bahia
    {   70, 7623,   36372, 16, }, // America/Bahia_Banderas
    {   70, 5654,    1013,  8, }, // America/Barbados
    {   70, 7646,   33998,  5, }, // America/Belem
    {   70, 5407,    1026,  5, }, // America/Belize
    {   70, 7660,   36388, 11, }, // America/Blanc-Sablon
    {   70, 7681,   34022,  9, }, // America/Boa_Vista
    {   70, 4361,    1052,  6, }, // America/Bogota
    {   70, 7699,   36399,  5, }, // America/Boise
    {   70, 7713,   36404, 13, }, // America/Cambridge_Bay
    {   70, 7735,   34047, 12, }, // America/Campo_Grande
    {   70, 3868,    1087,  6, }, // America/Cancun
    {   70, 4694,    1093,  7, }, // America/Caracas
    {   70, 4345,   36417,  5, }, // America/Cayenne
    {   70, 5496,   36422, 17, }, // America/Cayman
    {   70, 2260,    1129,  6, }, // America/Chicago
    {   70, 7756,    1135,  6, }, // America/Chihuahua
    {   70, 7774,   36439, 13, }, // America/Ciudad_Juarez
    {   70, 5422,   36452, 10, }, // America/Costa_Rica
    {   70, 7796,   36462,  7, }, // America/Creston
    {   70, 3791,   36469,  5, }, // America/Cuiaba
    {   70, 5723,   36474,  7, }, // America/Curacao
    {   70, 7812,   36481, 12, }, // America/Danmarkshavn
    {   70, 7833,   36493,  6, }, // America/Dawson
    {   70, 7848,   36499, 12, }, // America/Dawson_Creek
    {   70,  805,   36511,  6, }, // America/Denver
    {   70, 3465,   36517,  7, }, // America/Detroit
    {   70, 5739,    1214,  8, }, // America/Dominica
    {   70,  893,   36524,  8, }, // America/Edmonton
    {   70, 7869,   36532,  8, }, // America/Eirunepe
    {   70, 5441,    1238,  8, }, // America/El_Salvador
    {   70, 7886,   36540, 11, }, // America/Fort_Nelson
    {   70, 7906,    1257,  9, }, // America/Fortaleza
    {   70, 7924,   36551,  9, }, // America/Glace_Bay
    {   70, 6881,   36560,  7, }, // America/Goose_Bay
    {   70, 4612,   36567, 10, }, // America/Grand_Turk
    {   70, 5770,    1292,  7, }, // America/Grenada
    {   70, 5786,    1299,  9, }, // America/Guadeloupe
    {   70, 3760,    1308,  9, }, // America/Guatemala
    {   70, 4841,   36577,  7, }, // America/Guayaquil
    {   70, 6932,   27722,  5, }, // America/Guyana
    {   70, 1939,   34178,  8, }, // America/Halifax
    {   70, 2281,   34186,  6, }, // America/Havana
    {   70, 7942,   36584,  9, }, // America/Hermosillo
    {   70,  348,    1353, 12, }, // America/Indiana/Indianapolis
    {   70,  481,    1365,  4, }, // America/Indiana/Knox
    {   70, 7961,    1378,  7, }, // America/Indiana/Marengo
    {   70, 7985,   36593, 10, }, // America/Indiana/Petersburg
    {   70, 8012,   34253,  8, }, // America/Indiana/Tell_City
    {   70, 8038,   36603,  4, }, // America/Indiana/Vevay
    {   70, 8060,   36607,  7, }, // America/Indiana/Vincennes
    {   70, 8086,    1445,  7, }, // America/Indiana/Winamac
    {   70, 8110,    1452,  6, }, // America/Inuvik
    {   70,  660,   34321,  8, }, // America/Iqaluit
    {   70, 2799,   27879,  6, }, // America/Jamaica
    {   70, 5380,   36614,  5, }, // America/Juneau
    {   70,  521,    1476,  7, }, // America/Kentucky/Louisville
    {   70, 8125,   34340,  9, }, // America/Kentucky/Monticello
    {   70, 5704,   36619, 10, }, // America/Kralendijk
    {   70, 4376,   36629,  6, }, // America/La_Paz
    {   70, 7169,    1520,  4, }, // America/Lima
    {   70, 3239,   36635, 12, }, // America/Los_Angeles
    {   70, 5932,   36647, 20, }, // America/Lower_Princes
    {   70, 8153,   36667,  6, }, // America/Maceio
    {   70, 8168,    1559,  7, }, // America/Managua
    {   70, 1908,    1566,  6, }, // America/Manaus
    {   70, 5897,    1572,  6, }, // America/Marigot
    {   70, 5805,    1578,  9, }, // America/Martinique
    {   70, 8184,    1587,  9, }, // America/Matamoros
    {   70, 2917,    1596,  8, }, // America/Mazatlan
    {   70, 8202,    1604,  8, }, // America/Menominee
    {   70, 8220,    1612,  6, }, // America/Merida
    {   70, 8235,    1618, 10, }, // America/Metlakatla
    {   70, 2949,   34425, 12, }, // America/Mexico_City
    {   70, 4391,    1634,  7, }, // America/Miquelon
    {   70, 8254,    1641,  7, }, // America/Moncton
    {   70, 8270,   36673,  8, }, // America/Monterrey
    {   70, 4098,    1657, 10, }, // America/Montevideo
    {   70, 5824,   34445,  9, }, // America/Montserrat
    {   70, 5481,   34454,  5, }, // America/Nassau
    {   70, 2379,   36681,  7, }, // America/New_York
    {   70, 8288,   36688,  4, }, // America/Nome
    {   70, 1850,   36692,  6, }, // America/Noronha
    {   70, 8301,   36698,  4, }, // America/North_Dakota/Beulah
    {   70, 8329,   36702,  6, }, // America/North_Dakota/Center
    {   70, 8357,   36708,  9, }, // America/North_Dakota/New_Salem
    {   70,  393,    1772,  4, }, // America/Nuuk
    {   70, 8388,    1776,  7, }, // America/Ojinaga
    {   70, 2356,    1783,  6, }, // America/Panama
    {   70, 6173,    1789, 10, }, // America/Paramaribo
    {   70, 2973,    1799,  6, }, // America/Phoenix
    {   70, 3945,    1805, 12, }, // America/Port-au-Prince
    {   70, 5954,   36717, 13, }, // America/Port_of_Spain
    {   70, 8404,   36730, 11, }, // America/Porto_Velho
    {   70, 5843,   36741, 11, }, // America/Puerto_Rico
    {   70, 4030,   34579, 12, }, // America/Punta_Arenas
    {   70, 8424,   34591, 12, }, // America/Rankin_Inlet
    {   70, 8445,   34603,  6, }, // America/Recife
    {   70, 1995,   36752,  8, }, // America/Regina
    {   70, 8460,   36760,  7, }, // America/Resolute
    {   70,  695,   34622, 10, }, // America/Rio_Branco
    {   70, 8477,   34632,  8, }, // America/Santarem
    {   70, 2201,   36767,  7, }, // America/Santiago
    {   70, 6111,   34649, 13, }, // America/Santo_Domingo
    {   70, 1878,   36774,  9, }, // America/Sao_Paulo
    {   70, 6899,   36783, 10, }, // America/Scoresbysund
    {   70, 8494,    1956,  5, }, // America/Sitka
    {   70, 8508,   36793, 13, }, // America/St_Barthelemy
    {   70, 2061,   36806, 11, }, // America/St_Johns
    {   70, 5863,   36817, 10, }, // America/St_Kitts
    {   70, 5880,   36827, 11, }, // America/St_Lucia
    {   70,  855,   36838, 11, }, // America/St_Thomas
    {   70, 5913,   36849, 13, }, // America/St_Vincent
    {   70, 8530,   36862, 12, }, // America/Swift_Current
    {   70, 5461,    2038, 11, }, // America/Tegucigalpa
    {   70, 5756,    2049,  4, }, // America/Thule
    {   70,  313,    2053,  7, }, // America/Tijuana
    {   70,  608,    2060,  7, }, // America/Toronto
    {   70, 5688,    2067,  7, }, // America/Tortola
    {   70, 2093,   36874,  8, }, // America/Vancouver
    {   70, 2144,   28435,  8, }, // America/Whitehorse
    {   70,  734,   36882,  7, }, // America/Winnipeg
    {   70, 8552,   28450,  6, }, // America/Yakutat
    {   70, 6001,   36889,  5, }, // Antarctica/Casey
    {   70, 6094,   36894,  6, }, // Antarctica/Davis
    {   70, 6133,   36900, 12, }, // Antarctica/DumontDUrville
    {   70, 8568,    2131,  8, }, // Antarctica/Macquarie
    {   70, 7066,   36912,  6, }, // Antarctica/Mawson
    {   70, 7113,   36918,  8, }, // Antarctica/McMurdo
    {   70, 8589,   36926,  6, }, // Antarctica/Palmer
    {   70, 7226,    2160,  6, }, // Antarctica/Rothera
    {   70, 7295,   34821,  4, }, // Antarctica/Syowa
    {   70, 8607,    2171,  4, }, // Antarctica/Troll
    {   70, 7374,   34825,  6, }, // Antarctica/Vostok
    {   70, 1429,   36932, 10, }, // Arctic/Longyearbyen
    {   70, 5570,    2192,  4, }, // Asia/Aden
    {   70, 5395,   34842,  6, }, // Asia/Almaty
    {   70, 3968,   28531,  4, }, // Asia/Amman
    {   70, 5511,   34848,  6, }, // Asia/Anadyr
    {   70, 5523,    2213,  5, }, // Asia/Aqtau
    {   70, 5368,    2218,  6, }, // Asia/Aqtobe
    {   70,  964,    2224,  7, }, // Asia/Ashgabat
    {   70, 8624,   36942,  6, }, // Asia/Atyrau
    {   70, 3607,    2237,  6, }, // Asia/Baghdad
    {   70, 5534,   36948,  7, }, // Asia/Bahrain
    {   70, 3653,    2250,  4, }, // Asia/Baku
    {   70, 4466,   34867,  6, }, // Asia/Bangkok
    {   70, 3571,    2261,  7, }, // Asia/Barnaul
    {   70, 4086,   28563,  6, }, // Asia/Beirut
    {   70, 3778,    2274,  6, }, // Asia/Bishkek
    {   70, 5989,   28575,  6, }, // Asia/Brunei
    {   70, 4601,    2286,  4, }, // Asia/Chita
    {   70, 4511,    2290,  7, }, // Asia/Colombo
    {   70, 4540,    2297,  6, }, // Asia/Damascus
    {   70, 1093,     593,  4, }, // Asia/Dhaka
    {   70, 6192,    2308,  4, }, // Asia/Dili
    {   70, 3596,   28596,  5, }, // Asia/Dubai
    {   70, 6159,    2317,  7, }, // Asia/Dushanbe
    {   70, 8636,    2324,  9, }, // Asia/Famagusta
    {   70, 8651,    2333,  4, }, // Asia/Gaza
    {   70, 4795,   34886,  6, }, // Asia/Hebron
    {   70, 1259,    2343,  7, }, // Asia/Ho_Chi_Minh
    {   70, 2704,   36955,  7, }, // Asia/Hong_Kong
    {   70, 4771,    2357,  4, }, // Asia/Hovd
    {   70, 4184,    2361,  7, }, // Asia/Irkutsk
    {   70, 7006,   28638,  8, }, // Asia/Jakarta
    {   70, 6992,   28646,  8, }, // Asia/Jayapura
    {   70, 1290,   36962,  9, }, // Asia/Jerusalem
    {   70, 3560,    2392,  5, }, // Asia/Kabul
    {   70, 4316,    2411,  8, }, // Asia/Kamchatka
    {   70, 4239,    2422,  6, }, // Asia/Karachi
    {   70, 1185,    2428,  8, }, // Asia/Kathmandu
    {   70, 8661,   34933,  7, }, // Asia/Khandyga
    {   70,  992,   36971,  7, }, // Asia/Kolkata
    {   70, 4197,   36978, 10, }, // Asia/Krasnoyarsk
    {   70, 4859,   34958, 12, }, // Asia/Kuala_Lumpur
    {   70, 5976,    2474,  5, }, // Asia/Kuching
    {   70, 5547,   28693,  6, }, // Asia/Kuwait
    {   70, 1211,    2486,  5, }, // Asia/Macau
    {   70, 4017,    2491,  7, }, // Asia/Magadan
    {   70, 1349,    2498,  7, }, // Asia/Makassar
    {   70, 7182,    2505,  6, }, // Asia/Manila
    {   70, 6920,   34981,  6, }, // Asia/Muscat
    {   70, 2554,   36988,  7, }, // Asia/Nicosia
    {   70, 8675,    2524, 11, }, // Asia/Novokuznetsk
    {   70, 4135,    2535, 11, }, // Asia/Novosibirsk
    {   70, 4229,    2546,  4, }, // Asia/Omsk
    {   70, 7145,   36995,  4, }, // Asia/Oral
    {   70, 6961,   35010,  8, }, // Asia/Phnom_Penh
    {   70, 8693,    2563,  9, }, // Asia/Pontianak
    {   70, 4214,   36999,  6, }, // Asia/Pyongyang
    {   70, 5559,    2579,  5, }, // Asia/Qatar
    {   70, 8708,   37005,  8, }, // Asia/Qostanay
    {   70, 4269,   37013,  9, }, // Asia/Qyzylorda
    {   70, 3584,   37022,  4, }, // Asia/Riyadh
    {   70, 4408,    2614,  7, }, // Asia/Sakhalin
    {   70, 7245,    2621,  9, }, // Asia/Samarkand
    {   70, 3279,    2630,  4, }, // Asia/Seoul
    {   70, 1053,   28801,  6, }, // Asia/Shanghai
    {   70, 3300,    2640,  8, }, // Asia/Singapore
    {   70, 4297,   37026, 13, }, // Asia/Srednekolymsk
    {   70, 3263,   37039,  5, }, // Asia/Taipei
    {   70, 4781,    2667,  7, }, // Asia/Tashkent
    {   70, 3915,   35074,  7, }, // Asia/Tbilisi
    {   70, 2772,   35081,  7, }, // Asia/Tehran
    {   70, 1317,    2685,  7, }, // Asia/Thimphu
    {   70, 2821,    2692,  5, }, // Asia/Tokyo
    {   70, 4572,    2697,  5, }, // Asia/Tomsk
    {   70, 1021,   35093, 10, }, // Asia/Ulaanbaatar
    {   70, 1159,    2712,  6, }, // Asia/Urumqi
    {   70, 8722,    2718,  8, }, // Asia/Ust-Nera
    {   70, 6977,   37044,  7, }, // Asia/Vientiane
    {   70, 4710,    2733, 11, }, // Asia/Vladivostok
    {   70, 4828,   37051,  6, }, // Asia/Yakutsk
    {   70, 1235,   28911,  6, }, // Asia/Yangon
    {   70, 3883,    2757, 12, }, // Asia/Yekaterinburg
    {   70, 3747,    2769,  6, }, // Asia/Yerevan
    {   70, 3663,   37057, 15, }, // Atlantic/Azores
    {   70, 5671,   37072, 17, }, // Atlantic/Bermuda
    {   70, 6628,   37089, 16, }, // Atlantic/Canary
    {   70, 3727,   37105, 10, }, // Atlantic/Cape_Verde
    {   70, 1395,   37115, 17, }, // Atlantic/Faroe
    {   70, 8736,   37132,  7, }, // Atlantic/Madeira
    {   70, 2748,   37139,  8, }, // Atlantic/Reykjavik
    {   70, 7272,   37147, 13, }, // Atlantic/South_Georgia
    {   70, 6821,   37160, 11, }, // Atlantic/St_Helena
    {   70, 6644,    2911,  6, }, // Atlantic/Stanley
    {   70, 1670,    2917,  8, }, // Australia/Adelaide
    {   70, 1635,   37171,  8, }, // Australia/Brisbane
    {   70, 1799,   37179, 11, }, // Australia/Broken_Hill
    {   70, 1583,    2943,  6, }, // Australia/Darwin
    {   70, 3637,   29108,  4, }, // Australia/Eucla
    {   70, 1516,    2954,  6, }, // Australia/Hobart
    {   70, 8753,    2960,  8, }, // Australia/Lindeman
    {   70, 1547,   37190,  8, }, // Australia/Lord_Howe
    {   70, 1727,   37198,  7, }, // Australia/Melbourne
    {   70, 1762,   37205,  4, }, // Australia/Perth
    {   70, 1463,   37209,  5, }, // Australia/Sydney
    {   70, 6441,    2993,  9, }, // Europe/Amsterdam
    {   70, 6216,   29143,  6, }, // Europe/Andorra
    {   70, 3620,    3009,  8, }, // Europe/Astrakhan
    {   70, 2300,   35269,  5, }, // Europe/Athens
    {   70, 6336,    3021,  7, }, // Europe/Belgrade
    {   70, 4757,    3028,  6, }, // Europe/Berlin
    {   70, 6488,    3034, 10, }, // Europe/Bratislava
    {   70, 2167,   37214,  7, }, // Europe/Brussels
    {   70, 3928,   37221,  7, }, // Europe/Bucharest
    {   70, 3806,   37228,  8, }, // Europe/Budapest
    {   70, 8772,   37236,  8, }, // Europe/Busingen
    {   70, 2583,    3091,  7, }, // Europe/Chisinau
    {   70, 6289,   35320, 10, }, // Europe/Copenhagen
    {   70, 2338,   37244,  6, }, // Europe/Dublin
    {   70, 6307,    3114,  9, }, // Europe/Gibraltar
    {   70, 8788,   37250,  6, }, // Europe/Guernsey
    {   70, 6612,   37256,  8, }, // Europe/Helsinki
    {   70, 8804,   37264, 10, }, // Europe/Isle_of_Man
    {   70, 1130,   35352,  8, }, // Europe/Istanbul
    {   70, 8823,   37274,  6, }, // Europe/Jersey
    {   70, 3979,    3158, 11, }, // Europe/Kaliningrad
    {   70, 8929,    3169,  5, }, // Europe/Kirov
    {   70, 2527,    3174,  4, }, // Europe/Kyiv
    {   70, 3213,   35376,  7, }, // Europe/Lisbon
    {   70, 6506,   29300,  7, }, // Europe/Ljubljana
    {   70, 2501,    3195,  6, }, // Europe/London
    {   70, 6365,   29313, 10, }, // Europe/Luxembourg
    {   70, 4892,    3212,  6, }, // Europe/Madrid
    {   70, 6397,    3218,  5, }, // Europe/Malta
    {   70, 6582,    3223,  9, }, // Europe/Mariehamn
    {   70, 3693,    3232,  5, }, // Europe/Minsk
    {   70, 6410,    3237,  6, }, // Europe/Monaco
    {   70, 3537,    3243,  6, }, // Europe/Moscow
    {   70, 6458,    3249,  4, }, // Europe/Oslo
    {   70, 4284,    3253,  5, }, // Europe/Paris
    {   70, 6424,    3258,  9, }, // Europe/Podgorica
    {   70, 6275,    3267,  5, }, // Europe/Prague
    {   70, 8837,    3272,  4, }, // Europe/Riga
    {   70, 6324,    3276,  3, }, // Europe/Rome
    {   70, 4331,    3279,  6, }, // Europe/Samara
    {   70, 6470,   35413, 10, }, // Europe/San_Marino
    {   70, 6245,    3295,  7, }, // Europe/Sarajevo
    {   70, 4451,    3302,  7, }, // Europe/Saratov
    {   70, 8849,    3309, 10, }, // Europe/Simferopol
    {   70, 6383,   37280,  6, }, // Europe/Skopje
    {   70, 6599,   37286,  5, }, // Europe/Sofia
    {   70, 6523,   35453,  8, }, // Europe/Stockholm
    {   70, 8867,   35461,  5, }, // Europe/Tallinn
    {   70, 6202,    3343,  6, }, // Europe/Tirane
    {   70, 8882,   37291,  8, }, // Europe/Ulyanovsk
    {   70, 6352,    3358,  5, }, // Europe/Vaduz
    {   70, 6567,    3363,  7, }, // Europe/Vatican
    {   70, 6231,   37299,  5, }, // Europe/Vienna
    {   70, 8899,   37304,  6, }, // Europe/Vilnius
    {   70, 4727,    3381,  9, }, // Europe/Volgograd
    {   70, 3190,    3390,  7, }, // Europe/Warsaw
    {   70, 6261,    3397,  6, }, // Europe/Zagreb
    {   70, 6540,   37310,  5, }, // Europe/Zurich
    {   70, 5078,   35493, 12, }, // Indian/Antananarivo
    {   70, 6947,    3421,  5, }, // Indian/Chagos
    {   70, 6046,   37315,  9, }, // Indian/Christmas
    {   70, 6063,   37324, 16, }, // Indian/Cocos
    {   70, 5029,   37340, 16, }, // Indian/Comoro
    {   70, 6661,    3460,  8, }, // Indian/Kerguelen
    {   70, 7260,    3468,  3, }, // Indian/Mahe
    {   70, 7050,   35520,  7, }, // Indian/Maldives
    {   70, 4069,   37356,  8, }, // Indian/Mauritius
    {   70, 5098,   37364,  5, }, // Indian/Mayotte
    {   70, 7211,   37369,  7, }, // Indian/Reunion
    {   70, 4422,   37376,  4, }, // Pacific/Apia
    {   70,  932,   35554,  6, }, // Pacific/Auckland
    {   70, 3706,    3508,  8, }, // Pacific/Bougainville
    {   70, 3015,   37380,  5, }, // Pacific/Chatham
    {   70, 3157,   37385,  4, }, // Pacific/Chuuk
    {   70, 2237,   37389, 18, }, // Pacific/Easter
    {   70, 7360,    3536,  5, }, // Pacific/Efate
    {   70, 7327,    3541,  7, }, // Pacific/Fakaofo
    {   70, 3902,   37407,  5, }, // Pacific/Fiji
    {   70, 7343,    3552,  8, }, // Pacific/Funafuti
    {   70, 6678,    3560,  9, }, // Pacific/Galapagos
    {   70, 6696,   37412,  6, }, // Pacific/Gambier
    {   70, 3822,    3595, 11, }, // Pacific/Guadalcanal
    {   70, 6018,    3606,  4, }, // Pacific/Guam
    {   70, 2723,   35598,  8, }, // Pacific/Honolulu
    {   70, 3049,   37418,  9, }, // Pacific/Kanton
    {   70, 3998,    3616, 10, }, // Pacific/Kiritimati
    {   70, 7019,   37427,  6, }, // Pacific/Kosrae
    {   70, 2842,   37433,  9, }, // Pacific/Kwajalein
    {   70, 4877,   37442,  7, }, // Pacific/Majuro
    {   70, 4051,   37449, 16, }, // Pacific/Marquesas
    {   70, 8914,   37465,  6, }, // Pacific/Midway
    {   70, 7084,    3680,  5, }, // Pacific/Nauru
    {   70, 7132,    3685,  4, }, // Pacific/Niue
    {   70, 4168,    3689,  7, }, // Pacific/Norfolk
    {   70, 7098,    3696,  5, }, // Pacific/Noumea
    {   70, 3126,   35642,  9, }, // Pacific/Pago_Pago
    {   70, 7155,    3710,  5, }, // Pacific/Palau
    {   70, 7194,    3715,  7, }, // Pacific/Pitcairn
    {   70, 3096,   37471,  6, }, // Pacific/Pohnpei
    {   70, 4807,   37477, 11, }, // Pacific/Port_Moresby
    {   70, 6076,    3739,  9, }, // Pacific/Rarotonga
    {   70, 6031,   29803,  6, }, // Pacific/Saipan
    {   70, 7312,    3754,  5, }, // Pacific/Tahiti
    {   70, 6712,   37488,  6, }, // Pacific/Tarawa
    {   70, 4583,    3765,  9, }, // Pacific/Tongatapu
    {   70, 7392,   37494,  4, }, // Pacific/Wake
    {   70, 7405,   37498,  5, }, // Pacific/Wallis
    {   71, 6788,   37503,  8, }, // Africa/Abidjan Burmese/Myanmar/Myanmar
    {   71, 6760,   37511,  6, }, // Africa/Accra
    {   71, 5059,   37517, 12, }, // Africa/Addis_Ababa
    {   71, 7420,   37529, 15, }, // Africa/Algiers
    {   71,   14,   37544, 10, }, // Africa/Asmara
    {   71,   44,   37554,  7, }, // Africa/Bamako
    {   71, 5257,   37561,  7, }, // Africa/Bangui
    {   71, 6746,   37568,  9, }, // Africa/Banjul
    {   71, 7435,   37577,  7, }, // Africa/Bissau
    {   71, 4957,   37584, 14, }, // Africa/Blantyre
    {   71, 5287,   37598, 11, }, // Africa/Brazzaville
    {   71, 4922,   37609, 12, }, // Africa/Bujumbura
    {   71, 2320,   37621,  8, }, // Africa/Cairo
    {   71, 4117,   37629, 10, }, // Africa/Casablanca
    {   71, 7449,   37639,  7, }, // Africa/Ceuta
    {   71, 6773,   37646,  9, }, // Africa/Conakry
    {   71, 6840,   37655,  6, }, // Africa/Dakar
    {   71, 5130,   37661, 12, }, // Africa/Dar_es_Salaam
    {   71, 5043,   37673,  7, }, // Africa/Djibouti
    {   71, 5243,   37680,  9, }, // Africa/Douala
    {   71, 5166,   37689, 12, }, // Africa/El_Aaiun
    {   71, 6853,   37701, 12, }, // Africa/Freetown
    {   71, 4906,   37713, 11, }, // Africa/Gaborone
    {   71, 5015,   37724,  9, }, // Africa/Harare
    {   71, 4479,   37733, 15, }, // Africa/Johannesburg
    {   71, 4499,   37748,  5, }, // Africa/Juba
    {   71, 5151,   37753,  7, }, // Africa/Kampala
    {   71, 4524,   37760,  8, }, // Africa/Khartoum
    {   71, 4973,   37768,  7, }, // Africa/Kigali
    {   71, 5306,   37775,  8, }, // Africa/Kinshasa
    {   71, 4744,   37783,  7, }, // Africa/Lagos
    {   71, 5336,   37790, 10, }, // Africa/Libreville
    {   71, 6869,   37800,  5, }, // Africa/Lome
    {   71, 5211,   37805,  7, }, // Africa/Luanda
    {   71, 4939,   37812, 12, }, // Africa/Lubumbashi
    {   71, 5001,   37824,  6, }, // Africa/Lusaka
    {   71, 5322,   37830,  7, }, // Africa/Malabo
    {   71, 4987,   37837,  8, }, // Africa/Maputo
    {   71, 5197,   37845,  7, }, // Africa/Maseru
    {   71, 5182,   37852,  8, }, // Africa/Mbabane
    {   71, 5113,   37860, 13, }, // Africa/Mogadishu
    {   71, 7034,   37873, 14, }, // Africa/Monrovia
    {   71, 3853,   37887, 10, }, // Africa/Nairobi
    {   71, 5271,   37897, 10, }, // Africa/Ndjamena
    {   71, 5354,   37907,  6, }, // Africa/Niamey
    {   71, 6803,   37913, 15, }, // Africa/Nouakchott
    {   71, 6727,   37928,  9, }, // Africa/Ouagadougou
    {   71, 5225,   37937, 13, }, // Africa/Porto-Novo
    {   71, 4435,   37950, 10, }, // Africa/Sao_Tome
    {   71, 2866,   37960,  8, }, // Africa/Tripoli
    {   71, 6554,   37968,  6, }, // Africa/Tunis
    {   71, 4152,   37974,  9, }, // Africa/Windhoek
    {   71,  132,   37983,  5, }, // America/Adak
    {   71, 3346,   37988, 11, }, // America/Anchorage
    {   71, 5607,   37999,  7, }, // America/Anguilla
    {   71, 5624,   38006,  8, }, // America/Antigua
    {   71, 4554,   38014, 11, }, // America/Araguaina
    {   71,  166,   38025, 13, }, // America/Argentina/Buenos_Aires
    {   71,   91,   38038,  9, }, // America/Argentina/Catamarca
    {   71,  270,   38047,  8, }, // America/Argentina/Cordoba
    {   71,  441,   38055,  6, }, // America/Argentina/Jujuy
    {   71, 7462,   38061, 10, }, // America/Argentina/La_Rioja
    {   71,  565,   38071,  8, }, // America/Argentina/Mendoza
    {   71, 7489,   38079, 15, }, // America/Argentina/Rio_Gallegos
    {   71, 7520,   38094,  6, }, // America/Argentina/Salta
    {   71, 7544,   38100,  8, }, // America/Argentina/San_Juan
    {   71, 5580,   38108, 10, }, // America/Argentina/San_Luis
    {   71, 7571,   38118,  7, }, // America/Argentina/Tucuman
    {   71, 7597,   38125,  8, }, // America/Argentina/Ushuaia
    {   71, 5640,   38133,  7, }, // America/Aruba
    {   71, 4252,   38140, 11, }, // America/Asuncion
    {   71,  237,   38151, 10, }, // America/Atikokan
    {   71, 3679,   38161,  6, }, // America/Bahia
    {   71, 7623,   38167, 16, }, // America/Bahia_Banderas
    {   71, 5654,   38183, 11, }, // America/Barbados
    {   71, 7646,   38194,  7, }, // America/Belem
    {   71, 5407,   38201,  5, }, // America/Belize
    {   71, 7660,   38206, 15, }, // America/Blanc-Sablon
    {   71, 7681,   38221, 11, }, // America/Boa_Vista
    {   71, 4361,   38232,  8, }, // America/Bogota
    {   71, 7699,   38240,  8, }, // America/Boise
    {   71, 7713,   38248, 16, }, // America/Cambridge_Bay
    {   71, 7735,   38264, 14, }, // America/Campo_Grande
    {   71, 3868,   38278,  6, }, // America/Cancun
    {   71, 4694,   38284,  8, }, // America/Caracas
    {   71, 4345,   38292,  7, }, // America/Cayenne
    {   71, 5496,   38299,  5, }, // America/Cayman
    {   71, 2260,   38304,  8, }, // America/Chicago
    {   71, 7756,   38312, 11, }, // America/Chihuahua
    {   71, 7774,   38323, 18, }, // America/Ciudad_Juarez
    {   71, 5422,   38341, 11, }, // America/Costa_Rica
    {   71, 7796,   38352,  9, }, // America/Creston
    {   71, 3791,   38361,  7, }, // America/Cuiaba
    {   71, 5723,   38368, 10, }, // America/Curacao
    {   71, 7812,   38378, 13, }, // America/Danmarkshavn
    {   71, 7833,   38391,  7, }, // America/Dawson
    {   71, 7848,   38398, 13, }, // America/Dawson_Creek
    {   71,  805,   38411,  7, }, // America/Denver
    {   71, 3465,   38418, 10, }, // America/Detroit
    {   71, 5739,   38428,  9, }, // America/Dominica
    {   71,  893,   38437, 12, }, // America/Edmonton
    {   71, 7869,   38449,  8, }, // America/Eirunepe
    {   71, 5441,   38457, 12, }, // America/El_Salvador
    {   71, 7886,   38469, 15, }, // America/Fort_Nelson
    {   71, 7906,   38484, 12, }, // America/Fortaleza
    {   71, 7924,   38496,  8, }, // America/Glace_Bay
    {   71, 6881,   38504,  8, }, // America/Goose_Bay
    {   71, 4612,   38512, 10, }, // America/Grand_Turk
    {   71, 5770,   38522,  7, }, // America/Grenada
    {   71, 5786,   38529,  9, }, // America/Guadeloupe
    {   71, 3760,   38538,  9, }, // America/Guatemala
    {   71, 4841,   38547, 11, }, // America/Guayaquil
    {   71, 6932,   38558,  9, }, // America/Guyana
    {   71, 1939,   38567,  8, }, // America/Halifax
    {   71, 2281,   38575,  6, }, // America/Havana
    {   71, 7942,   38581, 12, }, // America/Hermosillo
    {   71,  348,   38593, 19, }, // America/Indiana/Indianapolis
    {   71,  481,   38612, 22, }, // America/Indiana/Knox
    {   71, 7961,   38634, 21, }, // America/Indiana/Marengo
    {   71, 7985,   38655, 24, }, // America/Indiana/Petersburg
    {   71, 8012,   38679, 23, }, // America/Indiana/Tell_City
    {   71, 8038,   38702, 17, }, // America/Indiana/Vevay
    {   71, 8060,   38719, 22, }, // America/Indiana/Vincennes
    {   71, 8086,   38741, 22, }, // America/Indiana/Winamac
    {   71, 8110,   38763,  8, }, // America/Inuvik
    {   71,  660,   38771, 10, }, // America/Iqaluit
    {   71, 2799,   38781,  6, }, // America/Jamaica
    {   71, 5380,   38787,  9, }, // America/Juneau
    {   71,  521,   38796,  9, }, // America/Kentucky/Louisville
    {   71, 8125,   38805, 23, }, // America/Kentucky/Monticello
    {   71, 5704,   38828, 14, }, // America/Kralendijk
    {   71, 4376,   38842,  6, }, // America/La_Paz
    {   71, 7169,   38848,  4, }, // America/Lima
    {   71, 3239,   38852, 18, }, // America/Los_Angeles
    {   71, 5932,   38870, 18, }, // America/Lower_Princes
    {   71, 8153,   38888,  7, }, // America/Maceio
    {   71, 8168,   38895,  7, }, // America/Managua
    {   71, 1908,   38902,  9, }, // America/Manaus
    {   71, 5897,   38911,  8, }, // America/Marigot
    {   71, 5805,   38919,  8, }, // America/Martinique
    {   71, 8184,   38927, 12, }, // America/Matamoros
    {   71, 2917,   38939,  8, }, // America/Mazatlan
    {   71, 8202,   38947, 10, }, // America/Menominee
    {   71, 8220,   38957,  6, }, // America/Merida
    {   71, 8235,   38963, 12, }, // America/Metlakatla
    {   71, 2949,   38975, 16, }, // America/Mexico_City
    {   71, 4391,   38991,  9, }, // America/Miquelon
    {   71, 8254,   39000, 10, }, // America/Moncton
    {   71, 8270,   39010,  9, }, // America/Monterrey
    {   71, 4098,   39019, 13, }, // America/Montevideo
    {   71, 5824,   39032, 15, }, // America/Montserrat
    {   71, 5481,   39047,  7, }, // America/Nassau
    {   71, 2379,   39054,  9, }, // America/New_York
    {   71, 8288,   38949,  5, }, // America/Nome
    {   71, 1850,   39063,  8, }, // America/Noronha
    {   71, 8301,   39071, 20, }, // America/North_Dakota/Beulah
    {   71, 8329,   39091, 20, }, // America/North_Dakota/Center
    {   71, 8357,   39111, 25, }, // America/North_Dakota/New_Salem
    {   71,  393,   39136,  4, }, // America/Nuuk
    {   71, 8388,   39140,  8, }, // America/Ojinaga
    {   71, 2356,   39148,  7, }, // America/Panama
    {   71, 6173,   39155, 11, }, // America/Paramaribo
    {   71, 2973,   39166,  6, }, // America/Phoenix
    {   71, 3945,   39172, 18, }, // America/Port-au-Prince
    {   71, 5954,   39190, 19, }, // America/Port_of_Spain
    {   71, 8404,   39209, 17, }, // America/Porto_Velho
    {   71, 5843,   39226, 12, }, // America/Puerto_Rico
    {   71, 4030,   39238, 14, }, // America/Punta_Arenas
    {   71, 8424,   39252, 14, }, // America/Rankin_Inlet
    {   71, 8445,   39266,  8, }, // America/Recife
    {   71, 1995,   39274,  8, }, // America/Regina
    {   71, 8460,   39282, 13, }, // America/Resolute
    {   71,  695,   39295, 13, }, // America/Rio_Branco
    {   71, 8477,   39308,  8, }, // America/Santarem
    {   71, 2201,   39316, 10, }, // America/Santiago
    {   71, 6111,   39326, 17, }, // America/Santo_Domingo
    {   71, 1878,   39343, 10, }, // America/Sao_Paulo
    {   71, 6899,   39353, 19, }, // America/Scoresbysund
    {   71, 8494,   39372,  5, }, // America/Sitka
    {   71, 8508,   39377, 13, }, // America/St_Barthelemy
    {   71, 2061,   39390, 11, }, // America/St_Johns
    {   71, 5863,   39401,  9, }, // America/St_Kitts
    {   71, 5880,   39410, 11, }, // America/St_Lucia
    {   71,  855,   39421, 13, }, // America/St_Thomas
    {   71, 5913,   39434, 13, }, // America/St_Vincent
    {   71, 8530,   39447, 16, }, // America/Swift_Current
    {   71, 5461,   39463, 11, }, // America/Tegucigalpa
    {   71, 5756,   39474,  4, }, // America/Thule
    {   71,  313,   39478,  7, }, // America/Tijuana
    {   71,  608,   39485,  9, }, // America/Toronto
    {   71, 5688,   39494,  8, }, // America/Tortola
    {   71, 2093,   39502,  9, }, // America/Vancouver
    {   71, 2144,   39511, 14, }, // America/Whitehorse
    {   71,  734,   39525,  9, }, // America/Winnipeg
    {   71, 8552,   39534,  7, }, // America/Yakutat
    {   71, 6001,   39541,  4, }, // Antarctica/Casey
    {   71, 6094,   39545,  6, }, // Antarctica/Davis
    {   71, 6133,   39551, 19, }, // Antarctica/DumontDUrville
    {   71, 8568,   39570,  9, }, // Antarctica/Macquarie
    {   71, 7066,   39579,  8, }, // Antarctica/Mawson
    {   71, 7113,   39587,  9, }, // Antarctica/McMurdo
    {   71, 8589,   39596,  6, }, // Antarctica/Palmer
    {   71, 7226,   39602,  7, }, // Antarctica/Rothera
    {   71, 7295,   39609,  7, }, // Antarctica/Syowa
    {   71, 8607,   39616,  6, }, // Antarctica/Troll
    {   71, 7374,   39622, 10, }, // Antarctica/Vostok
    {   71, 1429,   39632, 13, }, // Arctic/Longyearbyen
    {   71, 5570,   39645,  5, }, // Asia/Aden
    {   71, 5395,   39650,  8, }, // Asia/Almaty
    {   71, 3968,   39658,  7, }, // Asia/Amman
    {   71, 5511,   39665,  9, }, // Asia/Anadyr
    {   71, 5523,   39674,  7, }, // Asia/Aqtau
    {   71, 5368,   39681,  9, }, // Asia/Aqtobe
    {   71,  964,   39690, 11, }, // Asia/Ashgabat
    {   71, 8624,   39701,  7, }, // Asia/Atyrau
    {   71, 3607,   39708,  7, }, // Asia/Baghdad
    {   71, 5534,   39715,  7, }, // Asia/Bahrain
    {   71, 3653,   39722,  4, }, // Asia/Baku
    {   71, 4466,   39726,  8, }, // Asia/Bangkok
    {   71, 3571,   39734,  7, }, // Asia/Barnaul
    {   71, 4086,   39741,  6, }, // Asia/Beirut
    {   71, 3778,   39747,  8, }, // Asia/Bishkek
    {   71, 5989,   39755,  9, }, // Asia/Brunei
    {   71, 4601,   39764,  5, }, // Asia/Chita
    {   71, 4511,   39769,  8, }, // Asia/Colombo
    {   71, 4540,   39777,  8, }, // Asia/Damascus
    {   71, 1093,   39785,  5, }, // Asia/Dhaka
    {   71, 6192,   39790,  5, }, // Asia/Dili
    {   71, 3596,   39795,  8, }, // Asia/Dubai
    {   71, 6159,   39803,  9, }, // Asia/Dushanbe
    {   71, 8636,   39812,  9, }, // Asia/Famagusta
    {   71, 8651,   39821,  4, }, // Asia/Gaza
    {   71, 4795,   39825,  7, }, // Asia/Hebron
    {   71, 1259,   39832, 16, }, // Asia/Ho_Chi_Minh
    {   71, 2704,   39848, 10, }, // Asia/Hong_Kong
    {   71, 4771,   39858,  6, }, // Asia/Hovd
    {   71, 4184,   39864,  8, }, // Asia/Irkutsk
    {   71, 7006,   39872,  6, }, // Asia/Jakarta
    {   71, 6992,   39878,  9, }, // Asia/Jayapura
    {   71, 1290,   39887,  9, }, // Asia/Jerusalem
    {   71, 3560,   39896,  7, }, // Asia/Kabul
    {   71, 4316,   39903,  9, }, // Asia/Kamchatka
    {   71, 4239,   39912,  6, }, // Asia/Karachi
    {   71, 1185,   39918,  9, }, // Asia/Kathmandu
    {   71, 8661,   39927, 10, }, // Asia/Khandyga
    {   71,  992,   39937, 11, }, // Asia/Kolkata
    {   71, 4197,   39948, 13, }, // Asia/Krasnoyarsk
    {   71, 4859,   39961, 10, }, // Asia/Kuala_Lumpur
    {   71, 5976,   39971,  6, }, // Asia/Kuching
    {   71, 5547,   39977,  6, }, // Asia/Kuwait
    {   71, 1211,   39983,  6, }, // Asia/Macau
    {   71, 4017,   39989,  8, }, // Asia/Magadan
    {   71, 1349,   39997,  8, }, // Asia/Makassar
    {   71, 7182,   40005,  5, }, // Asia/Manila
    {   71, 6920,   40010, 10, }, // Asia/Muscat
    {   71, 2554,   40020,  9, }, // Asia/Nicosia
    {   71, 8675,   40029, 15, }, // Asia/Novokuznetsk
    {   71, 4135,   40044, 16, }, // Asia/Novosibirsk
    {   71, 4229,   40060,  9, }, // Asia/Omsk
    {   71, 7145,   40069,  8, }, // Asia/Oral
    {   71, 6961,   40077,  8, }, // Asia/Phnom_Penh
    {   71, 8693,   40085, 14, }, // Asia/Pontianak
    {   71, 4214,   40099,  8, }, // Asia/Pyongyang
    {   71, 5559,   38038,  4, }, // Asia/Qatar
    {   71, 8708,   40107,  9, }, // Asia/Qostanay
    {   71, 4269,   40116,  9, }, // Asia/Qyzylorda
    {   71, 3584,   40125,  7, }, // Asia/Riyadh
    {   71, 4408,   40132,  7, }, // Asia/Sakhalin
    {   71, 7245,   40139, 12, }, // Asia/Samarkand
    {   71, 3279,   40151,  6, }, // Asia/Seoul
    {   71, 1053,   40157, 10, }, // Asia/Shanghai
    {   71, 3300,   40167,  8, }, // Asia/Singapore
    {   71, 4297,   40175, 16, }, // Asia/Srednekolymsk
    {   71, 3263,   40191,  7, }, // Asia/Taipei
    {   71, 4781,   40198, 10, }, // Asia/Tashkent
    {   71, 3915,   40208,  8, }, // Asia/Tbilisi
    {   71, 2772,   40216,  7, }, // Asia/Tehran
    {   71, 1317,   40223,  6, }, // Asia/Thimphu
    {   71, 2821,   40229,  7, }, // Asia/Tokyo
    {   71, 4572,   40236, 10, }, // Asia/Tomsk
    {   71, 1021,   40246,  9, }, // Asia/Ulaanbaatar
    {   71, 1159,   40255,  9, }, // Asia/Urumqi
    {   71, 8722,   40264, 11, }, // Asia/Ust-Nera
    {   71, 6977,   40275, 10, }, // Asia/Vientiane
    {   71, 4710,   40285, 16, }, // Asia/Vladivostok
    {   71, 4828,   40301,  9, }, // Asia/Yakutsk
    {   71, 1235,   40310,  7, }, // Asia/Yangon
    {   71, 3883,   40317, 16, }, // Asia/Yekaterinburg
    {   71, 3747,   40333, 10, }, // Asia/Yerevan
    {   71, 3663,   40343, 11, }, // Atlantic/Azores
    {   71, 5671,   40354,  7, }, // Atlantic/Bermuda
    {   71, 6628,   40361,  5, }, // Atlantic/Canary
    {   71, 3727,   40366, 11, }, // Atlantic/Cape_Verde
    {   71, 1395,   40377,  5, }, // Atlantic/Faroe
    {   71, 8736,   40382,  6, }, // Atlantic/Madeira
    {   71, 2748,   40388, 10, }, // Atlantic/Reykjavik
    {   71, 7272,   40398, 15, }, // Atlantic/South_Georgia
    {   71, 6821,   40413, 13, }, // Atlantic/St_Helena
    {   71, 6644,   40426,  6, }, // Atlantic/Stanley
    {   71, 1670,   40432, 11, }, // Australia/Adelaide
    {   71, 1635,   40443, 10, }, // Australia/Brisbane
    {   71, 1799,   40453, 12, }, // Australia/Broken_Hill
    {   71, 1583,   40465,  5, }, // Australia/Darwin
    {   71, 3637,   40470,  6, }, // Australia/Eucla
    {   71, 1516,   40476,  9, }, // Australia/Hobart
    {   71, 8753,   40485, 10, }, // Australia/Lindeman
    {   71, 1547,   40495, 12, }, // Australia/Lord_Howe
    {   71, 1727,   40507,  9, }, // Australia/Melbourne
    {   71, 1762,   40516,  5, }, // Australia/Perth
    {   71, 1463,   40521,  6, }, // Australia/Sydney
    {   71, 6441,   40527,  9, }, // Europe/Amsterdam
    {   71, 6216,   40536,  8, }, // Europe/Andorra
    {   71, 3620,   40544, 11, }, // Europe/Astrakhan
    {   71, 2300,   40555,  5, }, // Europe/Athens
    {   71, 6336,   40560,  9, }, // Europe/Belgrade
    {   71, 4757,   40569,  5, }, // Europe/Berlin
    {   71, 6488,   40574, 13, }, // Europe/Bratislava
    {   71, 2167,   40587,  8, }, // Europe/Brussels
    {   71, 3928,   40595,  9, }, // Europe/Bucharest
    {   71, 3806,   40604,  9, }, // Europe/Budapest
    {   71, 8772,   40613, 10, }, // Europe/Busingen
    {   71, 2583,   40623, 11, }, // Europe/Chisinau
    {   71, 6289,   40634, 11, }, // Europe/Copenhagen
    {   71, 2338,   40645,  7, }, // Europe/Dublin
    {   71, 6307,   40652, 12, }, // Europe/Gibraltar
    {   71, 8788,   40664,  7, }, // Europe/Guernsey
    {   71, 6612,   40671,  9, }, // Europe/Helsinki
    {   71, 8804,   40680, 10, }, // Europe/Isle_of_Man
    {   71, 1130,   40690, 11, }, // Europe/Istanbul
    {   71, 8823,   40701,  5, }, // Europe/Jersey
    {   71, 3979,   40706, 11, }, // Europe/Kaliningrad
    {   71, 8929,   40717,  7, }, // Europe/Kirov
    {   71, 2527,   40724,  8, }, // Europe/Kyiv
    {   71, 3213,   40732,  9, }, // Europe/Lisbon
    {   71, 6506,   40741, 11, }, // Europe/Ljubljana
    {   71, 2501,   40752,  6, }, // Europe/London
    {   71, 6365,   40758,  8, }, // Europe/Luxembourg
    {   71, 4892,   40766,  5, }, // Europe/Madrid
    {   71, 6397,   40771,  8, }, // Europe/Malta
    {   71, 6582,   40779, 12, }, // Europe/Mariehamn
    {   71, 3693,   40791,  7, }, // Europe/Minsk
    {   71, 6410,   40798,  8, }, // Europe/Monaco
    {   71, 3537,   40806,  8, }, // Europe/Moscow
    {   71, 6458,   40814,  8, }, // Europe/Oslo
    {   71, 4284,   40822,  5, }, // Europe/Paris
    {   71, 6424,   40827, 11, }, // Europe/Podgorica
    {   71, 6275,   40838,  6, }, // Europe/Prague
    {   71, 8837,   40844,  4, }, // Europe/Riga
    {   71, 6324,   40848,  4, }, // Europe/Rome
    {   71, 4331,   40852,  7, }, // Europe/Samara
    {   71, 6470,   40859, 10, }, // Europe/San_Marino
    {   71, 6245,   40869,  9, }, // Europe/Sarajevo
    {   71, 4451,   40878, 10, }, // Europe/Saratov
    {   71, 8849,   40888, 12, }, // Europe/Simferopol
    {   71, 6383,   40900,  9, }, // Europe/Skopje
    {   71, 6599,   40909,  7, }, // Europe/Sofia
    {   71, 6523,   40916, 10, }, // Europe/Stockholm
    {   71, 8867,   40926,  6, }, // Europe/Tallinn
    {   71, 6202,   40932,  6, }, // Europe/Tirane
    {   71, 8882,   40938, 15, }, // Europe/Ulyanovsk
    {   71, 6352,   40953,  7, }, // Europe/Vaduz
    {   71, 6567,   40960,  7, }, // Europe/Vatican
    {   71, 6231,   40967,  7, }, // Europe/Vienna
    {   71, 8899,   40974, 13, }, // Europe/Vilnius
    {   71, 4727,   40987, 12, }, // Europe/Volgograd
    {   71, 3190,   40999,  5, }, // Europe/Warsaw
    {   71, 6261,   41004, 10, }, // Europe/Zagreb
    {   71, 6540,   41014,  9, }, // Europe/Zurich
    {   71, 5078,   41023, 15, }, // Indian/Antananarivo
    {   71, 6947,   41038,  8, }, // Indian/Chagos
    {   71, 6046,   41046,  8, }, // Indian/Christmas
    {   71, 6063,   41054,  9, }, // Indian/Cocos
    {   71, 5029,   41063,  9, }, // Indian/Comoro
    {   71, 6661,   41072,  7, }, // Indian/Kerguelen
    {   71, 7260,   41079,  4, }, // Indian/Mahe
    {   71, 7050,   41083, 10, }, // Indian/Maldives
    {   71, 4069,   41093,  8, }, // Indian/Mauritius
    {   71, 5098,   41101,  7, }, // Indian/Mayotte
    {   71, 7211,   41108,  9, }, // Indian/Reunion
    {   71, 4422,   41117,  8, }, // Pacific/Apia
    {   71,  932,   41125,  8, }, // Pacific/Auckland
    {   71, 3706,   41133, 14, }, // Pacific/Bougainville
    {   71, 3015,   41147,  7, }, // Pacific/Chatham
    {   71, 3157,   41154,  5, }, // Pacific/Chuuk
    {   71, 2237,   41159,  5, }, // Pacific/Easter
    {   71, 7360,   41164,  6, }, // Pacific/Efate
    {   71, 7327,   41170, 10, }, // Pacific/Fakaofo
    {   71, 3902,   41180,  5, }, // Pacific/Fiji
    {   71, 7343,   41185,  8, }, // Pacific/Funafuti
    {   71, 6678,   41193, 11, }, // Pacific/Galapagos
    {   71, 6696,   41204,  7, }, // Pacific/Gambier
    {   71, 3822,   41211, 10, }, // Pacific/Guadalcanal
    {   71, 6018,   41221,  5, }, // Pacific/Guam
    {   71, 2723,   41226, 10, }, // Pacific/Honolulu
    {   71, 3049,   41236,  9, }, // Pacific/Kanton
    {   71, 3998,   41245,  8, }, // Pacific/Kiritimati
    {   71, 7019,   41253, 10, }, // Pacific/Kosrae
    {   71, 2842,   41263, 10, }, // Pacific/Kwajalein
    {   71, 4877,   41273,  9, }, // Pacific/Majuro
    {   71, 4051,   41282, 10, }, // Pacific/Marquesas
    {   71, 8914,   41292,  8, }, // Pacific/Midway
    {   71, 7084,   41300,  6, }, // Pacific/Nauru
    {   71, 7132,   41306,  6, }, // Pacific/Niue
    {   71, 4168,   41312, 10, }, // Pacific/Norfolk
    {   71, 7098,   41322,  7, }, // Pacific/Noumea
    {   71, 3126,   41329, 10, }, // Pacific/Pago_Pago
    {   71, 7155,   41339,  6, }, // Pacific/Palau
    {   71, 7194,   41345, 10, }, // Pacific/Pitcairn
    {   71, 3096,   41355,  9, }, // Pacific/Pohnpei
    {   71, 4807,   41364, 17, }, // Pacific/Port_Moresby
    {   71, 6076,   41381, 12, }, // Pacific/Rarotonga
    {   71, 6031,   41393,  8, }, // Pacific/Saipan
    {   71, 7312,   41401,  5, }, // Pacific/Tahiti
    {   71, 6712,   41406,  6, }, // Pacific/Tarawa
    {   71, 4583,   41412, 10, }, // Pacific/Tongatapu
    {   71, 7392,   41422,  6, }, // Pacific/Wake
    {   71, 7405,   41428,  7, }, // Pacific/Wallis
    {   72, 6788,   41435,  3, }, // Africa/Abidjan Cantonese/Traditional Han/Hong Kong
    {   72, 6760,   41438,  3, }, // Africa/Accra
    {   72, 5059,   41441,  6, }, // Africa/Addis_Ababa
    {   72, 7420,   41447,  4, }, // Africa/Algiers
    {   72,   14,   41451,  4, }, // Africa/Asmara
    {   72,   44,   41455,  3, }, // Africa/Bamako
    {   72, 5257,   41458,  2, }, // Africa/Bangui
    {   72, 6746,   41460,  2, }, // Africa/Banjul
    {   72, 7435,   41462,  2, }, // Africa/Bissau
    {   72, 4957,   41464,  4, }, // Africa/Blantyre
    {   72, 5287,   41468,  5, }, // Africa/Brazzaville
    {   72, 4922,   41473,  4, }, // Africa/Bujumbura
    {   72, 2320,   41477,  2, }, // Africa/Cairo
    {   72, 4117,   41479,  5, }, // Africa/Casablanca
    {   72, 7449,   41484,  2, }, // Africa/Ceuta
    {   72, 6773,   41486,  4, }, // Africa/Conakry
    {   72, 6840,   41490,  3, }, // Africa/Dakar
    {   72, 5130,   41493,  3, }, // Africa/Dar_es_Salaam
    {   72, 5043,   41496,  3, }, // Africa/Djibouti
    {   72, 5243,   41499,  3, }, // Africa/Douala
    {   72, 5166,   41502,  3, }, // Africa/El_Aaiun
    {   72, 6853,   41505,  3, }, // Africa/Freetown
    {   72, 4906,   41508,  4, }, // Africa/Gaborone
    {   72, 5015,   41512,  3, }, // Africa/Harare
    {   72, 4479,   41515,  5, }, // Africa/Johannesburg
    {   72, 4499,   41520,  2, }, // Africa/Juba
    {   72, 5151,   41522,  3, }, // Africa/Kampala
    {   72, 4524,   41525,  3, }, // Africa/Khartoum
    {   72, 4973,   41528,  3, }, // Africa/Kigali
    {   72, 5306,   41531,  3, }, // Africa/Kinshasa
    {   72, 4744,   41534,  3, }, // Africa/Lagos
    {   72, 5336,   41537,  3, }, // Africa/Libreville
    {   72, 6869,   41540,  2, }, // Africa/Lome
    {   72, 5211,   41542,  3, }, // Africa/Luanda
    {   72, 4939,   41545,  4, }, // Africa/Lubumbashi
    {   72, 5001,   41549,  3, }, // Africa/Lusaka
    {   72, 5322,   41552,  3, }, // Africa/Malabo
    {   72, 4987,   41555,  3, }, // Africa/Maputo
    {   72, 5197,   41558,  3, }, // Africa/Maseru
    {   72, 5182,   41561,  3, }, // Africa/Mbabane
    {   72, 5113,   41564,  4, }, // Africa/Mogadishu
    {   72, 7034,   41568,  4, }, // Africa/Monrovia
    {   72, 3853,   41572,  3, }, // Africa/Nairobi
    {   72, 5271,   41575,  4, }, // Africa/Ndjamena
    {   72, 5354,   41579,  3, }, // Africa/Niamey
    {   72, 6803,   41582,  3, }, // Africa/Nouakchott
    {   72, 6727,   41585,  4, }, // Africa/Ouagadougou
    {   72, 5225,   41589,  4, }, // Africa/Porto-Novo
    {   72, 4435,   41593,  3, }, // Africa/Sao_Tome
    {   72, 2866,   41596,  4, }, // Africa/Tripoli
    {   72, 6554,   41600,  3, }, // Africa/Tunis
    {   72, 4152,   41603,  4, }, // Africa/Windhoek
    {   72,  132,   41607,  3, }, // America/Adak
    {   72, 3346,   41610,  4, }, // America/Anchorage
    {   72, 5607,   41614,  3, }, // America/Anguilla
    {   72, 5624,   41617,  3, }, // America/Antigua
    {   72, 4554,   41620,  4, }, // America/Araguaina
    {   72,  166,   41624,  7, }, // America/Argentina/Buenos_Aires
    {   72,   91,   41631,  4, }, // America/Argentina/Catamarca
    {   72,  270,   41635,  3, }, // America/Argentina/Cordoba
    {   72,  441,   41638,  3, }, // America/Argentina/Jujuy
    {   72, 7462,   41641,  3, }, // America/Argentina/La_Rioja
    {   72,  565,   41644,  3, }, // America/Argentina/Mendoza
    {   72, 7489,   41647,  6, }, // America/Argentina/Rio_Gallegos
    {   72, 7520,   41653,  3, }, // America/Argentina/Salta
    {   72, 7544,   41656,  3, }, // America/Argentina/San_Juan
    {   72, 5580,   41659,  3, }, // America/Argentina/San_Luis
    {   72, 7571,   41662,  3, }, // America/Argentina/Tucuman
    {   72, 7597,   41665,  4, }, // America/Argentina/Ushuaia
    {   72, 5640,   41669,  3, }, // America/Aruba
    {   72, 4252,   41672,  3, }, // America/Asuncion
    {   72,  237,   41675,  4, }, // America/Atikokan
    {   72, 3679,   41679,  3, }, // America/Bahia
    {   72, 7623,   41682,  7, }, // America/Bahia_Banderas
    {   72, 5654,   41689,  3, }, // America/Barbados
    {   72, 7646,   41692,  2, }, // America/Belem
    {   72, 5407,   41694,  3, }, // America/Belize
    {   72, 7660,   41697,  5, }, // America/Blanc-Sablon
    {   72, 7681,   41702,  4, }, // America/Boa_Vista
    {   72, 4361,   41706,  3, }, // America/Bogota
    {   72, 7699,   41709,  2, }, // America/Boise
    {   72, 7713,   41711,  3, }, // America/Cambridge_Bay
    {   72, 7735,   41714,  3, }, // America/Campo_Grande
    {   72, 3868,   41717,  2, }, // America/Cancun
    {   72, 4694,   41719,  4, }, // America/Caracas
    {   72, 4345,   41723,  2, }, // America/Cayenne
    {   72, 5496,   41725,  4, }, // America/Cayman
    {   72, 2260,   41729,  3, }, // America/Chicago
    {   72, 7756,   41732,  3, }, // America/Chihuahua
    {   72, 7774,   41735,  4, }, // America/Ciudad_Juarez
    {   72, 5422,   41739,  5, }, // America/Costa_Rica
    {   72, 7796,   41744,  4, }, // America/Creston
    {   72, 3791,   41748,  3, }, // America/Cuiaba
    {   72, 5723,   41751,  3, }, // America/Curacao
    {   72, 7812,   41754,  4, }, // America/Danmarkshavn
    {   72, 7833,   41758,  2, }, // America/Dawson
    {   72, 7848,   41760,  5, }, // America/Dawson_Creek
    {   72,  805,   41765,  2, }, // America/Denver
    {   72, 3465,   41767,  3, }, // America/Detroit
    {   72, 5739,   41770,  4, }, // America/Dominica
    {   72,  893,   41774,  4, }, // America/Edmonton
    {   72, 7869,   41778,  4, }, // America/Eirunepe
    {   72, 5441,   41782,  4, }, // America/El_Salvador
    {   72, 7886,   41786,  4, }, // America/Fort_Nelson
    {   72, 7906,   41790,  4, }, // America/Fortaleza
    {   72, 7924,   41794,  4, }, // America/Glace_Bay
    {   72, 6881,   41798,  2, }, // America/Goose_Bay
    {   72, 4612,   41800,  4, }, // America/Grand_Turk
    {   72, 5770,   41804,  4, }, // America/Grenada
    {   72, 5786,   41808,  4, }, // America/Guadeloupe
    {   72, 3760,   41812,  4, }, // America/Guatemala
    {   72, 4841,   41816,  4, }, // America/Guayaquil
    {   72, 6932,   41820,  3, }, // America/Guyana
    {   72, 1939,   41823,  5, }, // America/Halifax
    {   72, 2281,   41828,  3, }, // America/Havana
    {   72, 7942,   41831,  4, }, // America/Hermosillo
    {   72,  348,   41835,  7, }, // America/Indiana/Indianapolis
    {   72,  481,   41842,  8, }, // America/Indiana/Knox
    {   72, 7961,   41850,  8, }, // America/Indiana/Marengo
    {   72, 7985,   41858,  8, }, // America/Indiana/Petersburg
    {   72, 8012,   41866,  8, }, // America/Indiana/Tell_City
    {   72, 8038,   41874,  7, }, // America/Indiana/Vevay
    {   72, 8060,   41881,  8, }, // America/Indiana/Vincennes
    {   72, 8086,   41889,  9, }, // America/Indiana/Winamac
    {   72, 8110,   41898,  4, }, // America/Inuvik
    {   72,  660,   41902,  3, }, // America/Iqaluit
    {   72, 2799,   41905,  3, }, // America/Jamaica
    {   72, 5380,   41908,  2, }, // America/Juneau
    {   72,  521,   41910,  5, }, // America/Kentucky/Louisville
    {   72, 8125,   41915,  8, }, // America/Kentucky/Monticello
    {   72, 5704,   41923,  5, }, // America/Kralendijk
    {   72, 4376,   41928,  3, }, // America/La_Paz
    {   72, 7169,   41931,  2, }, // America/Lima
    {   72, 3239,   41933,  3, }, // America/Los_Angeles
    {   72, 5932,   41936,  4, }, // America/Lower_Princes
    {   72, 8153,   41940,  3, }, // America/Maceio
    {   72, 8168,   41943,  3, }, // America/Managua
    {   72, 1908,   41946,  3, }, // America/Manaus
    {   72, 5897,   41949,  4, }, // America/Marigot
    {   72, 5805,   41953,  4, }, // America/Martinique
    {   72, 8184,   41957,  5, }, // America/Matamoros
    {   72, 2917,   41962,  4, }, // America/Mazatlan
    {   72, 8202,   41966,  4, }, // America/Menominee
    {   72, 8220,   41970,  3, }, // America/Merida
    {   72, 8235,   41973,  6, }, // America/Metlakatla
    {   72, 2949,   41979,  4, }, // America/Mexico_City
    {   72, 4391,   41983,  3, }, // America/Miquelon
    {   72, 8254,   41986,  3, }, // America/Moncton
    {   72, 8270,   41989,  3, }, // America/Monterrey
    {   72, 4098,   41992,  4, }, // America/Montevideo
    {   72, 5824,   41996,  3, }, // America/Montserrat
    {   72, 5481,   41999,  2, }, // America/Nassau
    {   72, 2379,   42001,  2, }, // America/New_York
    {   72, 8288,   42003,  2, }, // America/Nome
    {   72, 1850,   42005,  3, }, // America/Noronha
    {   72, 8301,   42008,  8, }, // America/North_Dakota/Beulah
    {   72, 8329,   42016,  7, }, // America/North_Dakota/Center
    {   72, 8357,   42023,  8, }, // America/North_Dakota/New_Salem
    {   72,  393,   42031,  2, }, // America/Nuuk
    {   72, 8388,   42033,  4, }, // America/Ojinaga
    {   72, 2356,   42037,  3, }, // America/Panama
    {   72, 6173,   42040,  5, }, // America/Paramaribo
    {   72, 2973,   42045,  3, }, // America/Phoenix
    {   72, 3945,   42048,  3, }, // America/Port-au-Prince
    {   72, 5954,   42051,  4, }, // America/Port_of_Spain
    {   72, 8404,   42055,  3, }, // America/Porto_Velho
    {   72, 5843,   42058,  4, }, // America/Puerto_Rico
    {   72, 4030,   42062,  6, }, // America/Punta_Arenas
    {   72, 8424,   42068,  3, }, // America/Rankin_Inlet
    {   72, 8445,   42071,  3, }, // America/Recife
    {   72, 1995,   42074,  3, }, // America/Regina
    {   72, 8460,   42077,  4, }, // America/Resolute
    {   72,  695,   42081,  4, }, // America/Rio_Branco
    {   72, 8477,   42085,  3, }, // America/Santarem
    {   72, 2201,   42088,  4, }, // America/Santiago
    {   72, 6111,   42092,  4, }, // America/Santo_Domingo
    {   72, 1878,   42096,  3, }, // America/Sao_Paulo
    {   72, 6899,   42099,  7, }, // America/Scoresbysund
    {   72, 8494,   42106,  3, }, // America/Sitka
    {   72, 8508,   42109,  6, }, // America/St_Barthelemy
    {   72, 2061,   42115,  3, }, // America/St_Johns
    {   72, 5863,   42118,  3, }, // America/St_Kitts
    {   72, 5880,   42121,  4, }, // America/St_Lucia
    {   72,  855,   42125,  4, }, // America/St_Thomas
    {   72, 5913,   42129,  3, }, // America/St_Vincent
    {   72, 8530,   42132,  7, }, // America/Swift_Current
    {   72, 5461,   42139,  5, }, // America/Tegucigalpa
    {   72, 5756,   42144,  2, }, // America/Thule
    {   72,  313,   42146,  3, }, // America/Tijuana
    {   72,  608,   42149,  3, }, // America/Toronto
    {   72, 5688,   42152,  4, }, // America/Tortola
    {   72, 2093,   42156,  3, }, // America/Vancouver
    {   72, 2144,   42159,  4, }, // America/Whitehorse
    {   72,  734,   42163,  3, }, // America/Winnipeg
    {   72, 8552,   42166,  3, }, // America/Yakutat
    {   72, 6001,   42169,  2, }, // Antarctica/Casey
    {   72, 6094,   42171,  3, }, // Antarctica/Davis
    {   72, 6133,   42174,  5, }, // Antarctica/DumontDUrville
    {   72, 8568,   42179,  3, }, // Antarctica/Macquarie
    {   72, 7066,   42182,  2, }, // Antarctica/Mawson
    {   72, 7113,   42184,  4, }, // Antarctica/McMurdo
    {   72, 8589,   42188,  2, }, // Antarctica/Palmer
    {   72, 7226,   42190,  3, }, // Antarctica/Rothera
    {   72, 7295,   42193,  4, }, // Antarctica/Syowa
    {   72, 8607,   42197,  2, }, // Antarctica/Troll
    {   72, 7374,   42199,  4, }, // Antarctica/Vostok
    {   72, 1429,   42203,  5, }, // Arctic/Longyearbyen
    {   72, 5570,   42208,  2, }, // Asia/Aden
    {   72, 5395,   42210,  4, }, // Asia/Almaty
    {   72, 3968,   42214,  2, }, // Asia/Amman
    {   72, 5511,   42216,  3, }, // Asia/Anadyr
    {   72, 5523,   42219,  3, }, // Asia/Aqtau
    {   72, 5368,   42222,  4, }, // Asia/Aqtobe
    {   72,  964,   42226,  5, }, // Asia/Ashgabat
    {   72, 8624,   42231,  3, }, // Asia/Atyrau
    {   72, 3607,   42234,  3, }, // Asia/Baghdad
    {   72, 5534,   42237,  2, }, // Asia/Bahrain
    {   72, 3653,   41750,  2, }, // Asia/Baku
    {   72, 4466,   42239,  2, }, // Asia/Bangkok
    {   72, 3571,   42241,  4, }, // Asia/Barnaul
    {   72, 4086,   42245,  3, }, // Asia/Beirut
    {   72, 3778,   42248,  4, }, // Asia/Bishkek
    {   72, 5989,   42252,  2, }, // Asia/Brunei
    {   72, 4601,   42254,  2, }, // Asia/Chita
    {   72, 4511,   42256,  3, }, // Asia/Colombo
    {   72, 4540,   42259,  4, }, // Asia/Damascus
    {   72, 1093,   42263,  2, }, // Asia/Dhaka
    {   72, 6192,   42265,  2, }, // Asia/Dili
    {   72, 3596,   42267,  2, }, // Asia/Dubai
    {   72, 6159,   42269,  3, }, // Asia/Dushanbe
    {   72, 8636,   42272,  5, }, // Asia/Famagusta
    {   72, 8651,   42277,  2, }, // Asia/Gaza
    {   72, 4795,   42279,  3, }, // Asia/Hebron
    {   72, 1259,   42282,  4, }, // Asia/Ho_Chi_Minh
    {   72, 2704,   42286, 14, }, // Asia/Hong_Kong
    {   72, 4771,   42300,  3, }, // Asia/Hovd
    {   72, 4184,   42303,  5, }, // Asia/Irkutsk
    {   72, 7006,   42308,  3, }, // Asia/Jakarta
    {   72, 6992,   42311,  4, }, // Asia/Jayapura
    {   72, 1290,   42315,  4, }, // Asia/Jerusalem
    {   72, 3560,   42319,  3, }, // Asia/Kabul
    {   72, 4316,   42322,  3, }, // Asia/Kamchatka
    {   72, 4239,   42325,  3, }, // Asia/Karachi
    {   72, 1185,   42328,  4, }, // Asia/Kathmandu
    {   72, 8661,   42332,  3, }, // Asia/Khandyga
    {   72,  992,   42335,  4, }, // Asia/Kolkata
    {   72, 4197,   42339,  8, }, // Asia/Krasnoyarsk
    {   72, 4859,   42347,  3, }, // Asia/Kuala_Lumpur
    {   72, 5976,   42350,  2, }, // Asia/Kuching
    {   72, 5547,   42352,  3, }, // Asia/Kuwait
    {   72, 1211,   42355, 14, }, // Asia/Macau
    {   72, 4017,   42369,  3, }, // Asia/Magadan
    {   72, 1349,   42372,  4, }, // Asia/Makassar
    {   72, 7182,   42376,  3, }, // Asia/Manila
    {   72, 6920,   42379,  4, }, // Asia/Muscat
    {   72, 2554,   42383,  4, }, // Asia/Nicosia
    {   72, 8675,   42387,  6, }, // Asia/Novokuznetsk
    {   72, 4135,   42393,  5, }, // Asia/Novosibirsk
    {   72, 4229,   42398,  4, }, // Asia/Omsk
    {   72, 7145,   42402,  3, }, // Asia/Oral
    {   72, 6961,   42405,  2, }, // Asia/Phnom_Penh
    {   72, 8693,   42407,  2, }, // Asia/Pontianak
    {   72, 4214,   42409,  2, }, // Asia/Pyongyang
    {   72, 5559,   42411,  2, }, // Asia/Qatar
    {   72, 8708,   42413,  4, }, // Asia/Qostanay
    {   72, 4269,   42417,  6, }, // Asia/Qyzylorda
    {   72, 3584,   42423,  3, }, // Asia/Riyadh
    {   72, 4408,   42426,  3, }, // Asia/Sakhalin
    {   72, 7245,   42429,  4, }, // Asia/Samarkand
    {   72, 3279,   42433,  2, }, // Asia/Seoul
    {   72, 1053,   42435,  2, }, // Asia/Shanghai
    {   72, 3300,   42437,  3, }, // Asia/Singapore
    {   72, 4297,   42440,  6, }, // Asia/Srednekolymsk
    {   72, 3263,   42446,  2, }, // Asia/Taipei
    {   72, 4781,   42448,  3, }, // Asia/Tashkent
    {   72, 3915,   42451,  4, }, // Asia/Tbilisi
    {   72, 2772,   42455,  3, }, // Asia/Tehran
    {   72, 1317,   42458,  2, }, // Asia/Thimphu
    {   72, 2821,   42460,  2, }, // Asia/Tokyo
    {   72, 4572,   42462,  4, }, // Asia/Tomsk
    {   72, 1021,   42466,  4, }, // Asia/Ulaanbaatar
    {   72, 1159,   42470,  4, }, // Asia/Urumqi
    {   72, 8722,   42474,  4, }, // Asia/Ust-Nera
    {   72, 6977,   42478,  2, }, // Asia/Vientiane
    {   72, 4710,   42480,  3, }, // Asia/Vladivostok
    {   72, 4828,   42483,  4, }, // Asia/Yakutsk
    {   72, 1235,   42487,  2, }, // Asia/Yangon
    {   72, 3883,   42489,  5, }, // Asia/Yekaterinburg
    {   72, 3747,   42494,  3, }, // Asia/Yerevan
    {   72, 3663,   42497,  5, }, // Atlantic/Azores
    {   72, 5671,   42502,  3, }, // Atlantic/Bermuda
    {   72, 6628,   42505,  3, }, // Atlantic/Canary
    {   72, 3727,   42508,  3, }, // Atlantic/Cape_Verde
    {   72, 1395,   42511,  4, }, // Atlantic/Faroe
    {   72, 8736,   42515,  5, }, // Atlantic/Madeira
    {   72, 2748,   42520,  5, }, // Atlantic/Reykjavik
    {   72, 7272,   42525,  4, }, // Atlantic/South_Georgia
    {   72, 6821,   42529,  5, }, // Atlantic/St_Helena
    {   72, 6644,   42534,  3, }, // Atlantic/Stanley
    {   72, 1670,   42537,  4, }, // Australia/Adelaide
    {   72, 1635,   42541,  4, }, // Australia/Brisbane
    {   72, 1799,   42545,  5, }, // Australia/Broken_Hill
    {   72, 1583,   42550,  3, }, // Australia/Darwin
    {   72, 3637,   42553,  3, }, // Australia/Eucla
    {   72, 1516,   42556,  3, }, // Australia/Hobart
    {   72, 8753,   42559,  3, }, // Australia/Lindeman
    {   72, 1547,   42562,  4, }, // Australia/Lord_Howe
    {   72, 1727,   42566,  3, }, // Australia/Melbourne
    {   72, 1762,   42569,  2, }, // Australia/Perth
    {   72, 1463,   42571,  2, }, // Australia/Sydney
    {   72, 6441,   42573,  5, }, // Europe/Amsterdam
    {   72, 6216,   42578,  3, }, // Europe/Andorra
    {   72, 3620,   42581,  5, }, // Europe/Astrakhan
    {   72, 2300,   42586,  2, }, // Europe/Athens
    {   72, 6336,   42588,  4, }, // Europe/Belgrade
    {   72, 4757,   42592,  2, }, // Europe/Berlin
    {   72, 6488,   42594,  6, }, // Europe/Bratislava
    {   72, 2167,   42600,  4, }, // Europe/Brussels
    {   72, 3928,   42604,  5, }, // Europe/Bucharest
    {   72, 3806,   42609,  4, }, // Europe/Budapest
    {   72, 8772,   42613,  3, }, // Europe/Busingen
    {   72, 2583,   42616,  3, }, // Europe/Chisinau
    {   72, 6289,   42619,  4, }, // Europe/Copenhagen
    {   72, 2338,   42623,  3, }, // Europe/Dublin
    {   72, 6307,   42626,  4, }, // Europe/Gibraltar
    {   72, 8788,   42630,  3, }, // Europe/Guernsey
    {   72, 6612,   42633,  4, }, // Europe/Helsinki
    {   72, 8804,   42637,  2, }, // Europe/Isle_of_Man
    {   72, 1130,   42639,  4, }, // Europe/Istanbul
    {   72, 8823,   42643,  3, }, // Europe/Jersey
    {   72, 3979,   42646,  5, }, // Europe/Kaliningrad
    {   72, 8929,   42651,  3, }, // Europe/Kirov
    {   72, 2527,   42654,  2, }, // Europe/Kyiv
    {   72, 3213,   42656,  3, }, // Europe/Lisbon
    {   72, 6506,   42659,  4, }, // Europe/Ljubljana
    {   72, 2501,   42663,  2, }, // Europe/London
    {   72, 6365,   42665,  3, }, // Europe/Luxembourg
    {   72, 4892,   42668,  3, }, // Europe/Madrid
    {   72, 6397,   42671,  3, }, // Europe/Malta
    {   72, 6582,   42674,  3, }, // Europe/Mariehamn
    {   72, 3693,   42677,  3, }, // Europe/Minsk
    {   72, 6410,   42680,  3, }, // Europe/Monaco
    {   72, 3537,   42683,  3, }, // Europe/Moscow
    {   72, 6458,   42686,  3, }, // Europe/Oslo
    {   72, 4284,   42689,  2, }, // Europe/Paris
    {   72, 6424,   42691,  4, }, // Europe/Podgorica
    {   72, 6275,   42695,  3, }, // Europe/Prague
    {   72, 8837,   42698,  2, }, // Europe/Riga
    {   72, 6324,   42700,  2, }, // Europe/Rome
    {   72, 4331,   42702,  3, }, // Europe/Samara
    {   72, 6470,   42705,  4, }, // Europe/San_Marino
    {   72, 6245,   42709,  4, }, // Europe/Sarajevo
    {   72, 4451,   42713,  4, }, // Europe/Saratov
    {   72, 8849,   42717,  4, }, // Europe/Simferopol
    {   72, 6383,   42721,  4, }, // Europe/Skopje
    {   72, 6599,   42725,  3, }, // Europe/Sofia
    {   72, 6523,   42728,  5, }, // Europe/Stockholm
    {   72, 8867,   42733,  2, }, // Europe/Tallinn
    {   72, 6202,   42735,  3, }, // Europe/Tirane
    {   72, 8882,   42738,  7, }, // Europe/Ulyanovsk
    {   72, 6352,   42745,  3, }, // Europe/Vaduz
    {   72, 6567,   42748,  3, }, // Europe/Vatican
    {   72, 6231,   42751,  3, }, // Europe/Vienna
    {   72, 8899,   42754,  4, }, // Europe/Vilnius
    {   72, 4727,   42758,  5, }, // Europe/Volgograd
    {   72, 3190,   42763,  2, }, // Europe/Warsaw
    {   72, 6261,   42765,  4, }, // Europe/Zagreb
    {   72, 6540,   42769,  3, }, // Europe/Zurich
    {   72, 5078,   42772,  6, }, // Indian/Antananarivo
    {   72, 6947,   42778,  3, }, // Indian/Chagos
    {   72, 6046,   42781,  3, }, // Indian/Christmas
    {   72, 6063,   42784,  5, }, // Indian/Cocos
    {   72, 5029,   42789,  5, }, // Indian/Comoro
    {   72, 6661,   42794,  5, }, // Indian/Kerguelen
    {   72, 7260,   42799,  3, }, // Indian/Mahe
    {   72, 7050,   42802,  4, }, // Indian/Maldives
    {   72, 4069,   42806,  4, }, // Indian/Mauritius
    {   72, 5098,   42810,  4, }, // Indian/Mayotte
    {   72, 7211,   42814,  4, }, // Indian/Reunion
    {   72, 4422,   42818,  3, }, // Pacific/Apia
    {   72,  932,   42821,  3, }, // Pacific/Auckland
    {   72, 3706,   42824,  4, }, // Pacific/Bougainville
    {   72, 3015,   42828,  2, }, // Pacific/Chatham
    {   72, 3157,   42830,  2, }, // Pacific/Chuuk
    {   72, 2237,   42832,  3, }, // Pacific/Easter
    {   72, 7360,   42835,  3, }, // Pacific/Efate
    {   72, 7327,   42838,  3, }, // Pacific/Fakaofo
    {   72, 3902,   42841,  2, }, // Pacific/Fiji
    {   72, 7343,   42843,  4, }, // Pacific/Funafuti
    {   72, 6678,   42847,  6, }, // Pacific/Galapagos
    {   72, 6696,   42853,  5, }, // Pacific/Gambier
    {   72, 3822,   42858,  6, }, // Pacific/Guadalcanal
    {   72, 6018,   42864,  2, }, // Pacific/Guam
    {   72, 2723,   42866,  3, }, // Pacific/Honolulu
    {   72, 3049,   42869,  5, }, // Pacific/Kanton
    {   72, 3998,   42874,  6, }, // Pacific/Kiritimati
    {   72, 7019,   42880,  3, }, // Pacific/Kosrae
    {   72, 2842,   42883,  4, }, // Pacific/Kwajalein
    {   72, 4877,   42887,  3, }, // Pacific/Majuro
    {   72, 4051,   42890,  5, }, // Pacific/Marquesas
    {   72, 8914,   42895,  3, }, // Pacific/Midway
    {   72, 7084,   42898,  2, }, // Pacific/Nauru
    {   72, 7132,   42900,  3, }, // Pacific/Niue
    {   72, 4168,   42903,  3, }, // Pacific/Norfolk
    {   72, 7098,   42906,  3, }, // Pacific/Noumea
    {   72, 3126,   42909,  4, }, // Pacific/Pago_Pago
    {   72, 7155,   42913,  2, }, // Pacific/Palau
    {   72, 7194,   42915,  5, }, // Pacific/Pitcairn
    {   72, 3096,   42920,  3, }, // Pacific/Pohnpei
    {   72, 4807,   42923,  4, }, // Pacific/Port_Moresby
    {   72, 6076,   42927,  4, }, // Pacific/Rarotonga
    {   72, 6031,   42931,  2, }, // Pacific/Saipan
    {   72, 7312,   42933,  3, }, // Pacific/Tahiti
    {   72, 6712,   42936,  3, }, // Pacific/Tarawa
    {   72, 4583,   42939,  5, }, // Pacific/Tongatapu
    {   72, 7392,   42944,  2, }, // Pacific/Wake
    {   72, 7405,   42946,  3, }, // Pacific/Wallis
    {   73, 6788,   42949,  3, }, // Africa/Abidjan Cantonese/Simplified Han/China
    {   73, 5059,   42952,  6, }, // Africa/Addis_Ababa
    {   73, 7420,   42958,  4, }, // Africa/Algiers
    {   73,   14,   42962,  4, }, // Africa/Asmara
    {   73,   44,   42966,  3, }, // Africa/Bamako
    {   73, 7435,   42969,  2, }, // Africa/Bissau
    {   73, 4957,   42971,  4, }, // Africa/Blantyre
    {   73, 5287,   42975,  5, }, // Africa/Brazzaville
    {   73, 2320,   42980,  2, }, // Africa/Cairo
    {   73, 4117,   42982,  5, }, // Africa/Casablanca
    {   73, 7449,   42987,  2, }, // Africa/Ceuta
    {   73, 6840,   42989,  3, }, // Africa/Dakar
    {   73, 5130,   42992,  3, }, // Africa/Dar_es_Salaam
    {   73, 4479,   42995,  5, }, // Africa/Johannesburg
    {   73, 5211,   43000,  3, }, // Africa/Luanda
    {   73, 4939,   43003,  4, }, // Africa/Lubumbashi
    {   73, 5322,   43007,  3, }, // Africa/Malabo
    {   73, 4987,   43010,  3, }, // Africa/Maputo
    {   73, 5197,   43013,  3, }, // Africa/Maseru
    {   73, 7034,   43016,  4, }, // Africa/Monrovia
    {   73, 5271,   43020,  4, }, // Africa/Ndjamena
    {   73, 5354,   43024,  3, }, // Africa/Niamey
    {   73, 6803,   43027,  3, }, // Africa/Nouakchott
    {   73, 5225,   43030,  4, }, // Africa/Porto-Novo
    {   73, 4435,   43034,  3, }, // Africa/Sao_Tome
    {   73, 4152,   43037,  4, }, // Africa/Windhoek
    {   73,  132,   43041,  3, }, // America/Adak
    {   73,  166,   43044,  7, }, // America/Argentina/Buenos_Aires
    {   73,   91,   43051,  4, }, // America/Argentina/Catamarca
    {   73,  270,   43055,  3, }, // America/Argentina/Cordoba
    {   73,  565,   43058,  3, }, // America/Argentina/Mendoza
    {   73, 7489,   43061,  6, }, // America/Argentina/Rio_Gallegos
    {   73, 7520,   43067,  3, }, // America/Argentina/Salta
    {   73, 7544,   43070,  3, }, // America/Argentina/San_Juan
    {   73, 5580,   43073,  3, }, // America/Argentina/San_Luis
    {   73, 7571,   43076,  3, }, // America/Argentina/Tucuman
    {   73, 7597,   43079,  4, }, // America/Argentina/Ushuaia
    {   73, 4252,   43083,  3, }, // America/Asuncion
    {   73, 7623,   43086,  7, }, // America/Bahia_Banderas
    {   73, 5654,   43093,  3, }, // America/Barbados
    {   73, 7646,   43096,  2, }, // America/Belem
    {   73, 5407,   43098,  3, }, // America/Belize
    {   73, 7660,   43101,  5, }, // America/Blanc-Sablon
    {   73, 7681,   43106,  4, }, // America/Boa_Vista
    {   73, 7713,   43110,  3, }, // America/Cambridge_Bay
    {   73, 7735,   43113,  3, }, // America/Campo_Grande
    {   73, 4345,   43116,  2, }, // America/Cayenne
    {   73, 5496,   43118,  4, }, // America/Cayman
    {   73, 7756,   43122,  3, }, // America/Chihuahua
    {   73, 7774,   43125,  4, }, // America/Ciudad_Juarez
    {   73, 7796,   43129,  4, }, // America/Creston
    {   73, 5723,   43133,  3, }, // America/Curacao
    {   73, 7812,   43136,  4, }, // America/Danmarkshavn
    {   73, 7869,   43140,  4, }, // America/Eirunepe
    {   73, 5441,   43144,  4, }, // America/El_Salvador
    {   73, 7886,   43148,  4, }, // America/Fort_Nelson
    {   73, 7924,   43152,  4, }, // America/Glace_Bay
    {   73, 6881,   43156,  2, }, // America/Goose_Bay
    {   73, 4612,   43158,  4, }, // America/Grand_Turk
    {   73, 5770,   43162,  4, }, // America/Grenada
    {   73, 3760,   43166,  4, }, // America/Guatemala
    {   73, 4841,   43170,  4, }, // America/Guayaquil
    {   73, 6932,   43174,  3, }, // America/Guyana
    {   73, 7942,   43177,  4, }, // America/Hermosillo
    {   73,  481,   43181,  8, }, // America/Indiana/Knox
    {   73, 7961,   43189,  8, }, // America/Indiana/Marengo
    {   73, 8012,   43197,  8, }, // America/Indiana/Tell_City
    {   73, 8038,   43205,  7, }, // America/Indiana/Vevay
    {   73, 8060,   43212,  8, }, // America/Indiana/Vincennes
    {   73, 8086,   43220,  9, }, // America/Indiana/Winamac
    {   73, 8110,   43229,  4, }, // America/Inuvik
    {   73, 2799,   43233,  3, }, // America/Jamaica
    {   73, 5380,   43236,  2, }, // America/Juneau
    {   73,  521,   43238,  5, }, // America/Kentucky/Louisville
    {   73, 8125,   43243,  8, }, // America/Kentucky/Monticello
    {   73, 5704,   43251,  5, }, // America/Kralendijk
    {   73, 7169,   43256,  2, }, // America/Lima
    {   73, 3239,   43258,  3, }, // America/Los_Angeles
    {   73, 5932,   43261,  4, }, // America/Lower_Princes
    {   73, 8153,   43265,  3, }, // America/Maceio
    {   73, 8168,   43268,  3, }, // America/Managua
    {   73, 1908,   43271,  3, }, // America/Manaus
    {   73, 5897,   43274,  4, }, // America/Marigot
    {   73, 5805,   43278,  4, }, // America/Martinique
    {   73, 8184,   43282,  5, }, // America/Matamoros
    {   73, 2917,   43287,  4, }, // America/Mazatlan
    {   73, 8202,   43291,  4, }, // America/Menominee
    {   73, 8220,   43295,  3, }, // America/Merida
    {   73, 4391,   43298,  3, }, // America/Miquelon
    {   73, 8254,   43301,  3, }, // America/Moncton
    {   73, 4098,   43304,  4, }, // America/Montevideo
    {   73, 5824,   43308,  3, }, // America/Montserrat
    {   73, 2379,   43311,  2, }, // America/New_York
    {   73, 8288,   43313,  2, }, // America/Nome
    {   73, 1850,   43315,  3, }, // America/Noronha
    {   73, 8301,   43318,  8, }, // America/North_Dakota/Beulah
    {   73, 8329,   43326,  7, }, // America/North_Dakota/Center
    {   73, 8357,   43333,  8, }, // America/North_Dakota/New_Salem
    {   73, 8388,   43341,  4, }, // America/Ojinaga
    {   73, 2356,   43345,  3, }, // America/Panama
    {   73, 6173,   43348,  5, }, // America/Paramaribo
    {   73, 2973,   43353,  3, }, // America/Phoenix
    {   73, 8404,   43356,  3, }, // America/Porto_Velho
    {   73, 4030,   43359,  6, }, // America/Punta_Arenas
    {   73, 8424,   43365,  3, }, // America/Rankin_Inlet
    {   73, 1995,   43368,  3, }, // America/Regina
    {   73, 8460,   43371,  4, }, // America/Resolute
    {   73,  695,   43375,  4, }, // America/Rio_Branco
    {   73, 8477,   43379,  3, }, // America/Santarem
    {   73, 2201,   43382,  4, }, // America/Santiago
    {   73, 6111,   43386,  4, }, // America/Santo_Domingo
    {   73, 1878,   43390,  3, }, // America/Sao_Paulo
    {   73, 6899,   43393,  7, }, // America/Scoresbysund
    {   73, 8494,   43400,  3, }, // America/Sitka
    {   73, 8508,   43403,  6, }, // America/St_Barthelemy
    {   73, 2061,   43409,  3, }, // America/St_Johns
    {   73, 5863,   43412,  3, }, // America/St_Kitts
    {   73, 5880,   43415,  4, }, // America/St_Lucia
    {   73,  855,   43419,  4, }, // America/St_Thomas
    {   73, 5913,   43423,  3, }, // America/St_Vincent
    {   73, 8530,   43426,  7, }, // America/Swift_Current
    {   73,  313,   43433,  3, }, // America/Tijuana
    {   73,  608,   43436,  3, }, // America/Toronto
    {   73, 5688,   43439,  4, }, // America/Tortola
    {   73, 2093,   43443,  3, }, // America/Vancouver
    {   73, 2144,   43446,  4, }, // America/Whitehorse
    {   73,  734,   43450,  3, }, // America/Winnipeg
    {   73, 8552,   43453,  3, }, // America/Yakutat
    {   73, 6001,   43456,  2, }, // Antarctica/Casey
    {   73, 6094,   43458,  3, }, // Antarctica/Davis
    {   73, 6133,   43461,  5, }, // Antarctica/DumontDUrville
    {   73, 8568,   43466,  3, }, // Antarctica/Macquarie
    {   73, 7113,   43469,  4, }, // Antarctica/McMurdo
    {   73, 8589,   43473,  2, }, // Antarctica/Palmer
    {   73, 7226,   43475,  3, }, // Antarctica/Rothera
    {   73, 8607,   43478,  2, }, // Antarctica/Troll
    {   73, 5570,   43480,  2, }, // Asia/Aden
    {   73, 5395,   43482,  4, }, // Asia/Almaty
    {   73, 8624,   43486,  3, }, // Asia/Atyrau
    {   73, 3607,   43489,  3, }, // Asia/Baghdad
    {   73, 3653,   43492,  2, }, // Asia/Baku
    {   73, 3571,   43494,  4, }, // Asia/Barnaul
    {   73, 4086,   43498,  3, }, // Asia/Beirut
    {   73, 3778,   43501,  4, }, // Asia/Bishkek
    {   73, 5989,   43505,  2, }, // Asia/Brunei
    {   73, 4511,   43507,  3, }, // Asia/Colombo
    {   73, 4540,   43510,  4, }, // Asia/Damascus
    {   73, 1093,   43514,  2, }, // Asia/Dhaka
    {   73, 6159,   43516,  3, }, // Asia/Dushanbe
    {   73, 8636,   43519,  5, }, // Asia/Famagusta
    {   73, 8651,   43524,  2, }, // Asia/Gaza
    {   73, 2704,   43526, 14, }, // Asia/Hong_Kong
    {   73, 4184,   43540,  5, }, // Asia/Irkutsk
    {   73, 7006,   43545,  3, }, // Asia/Jakarta
    {   73, 6992,   43548,  4, }, // Asia/Jayapura
    {   73, 3560,   43552,  3, }, // Asia/Kabul
    {   73, 1185,   43555,  4, }, // Asia/Kathmandu
    {   73,  992,   43559,  4, }, // Asia/Kolkata
    {   73, 4197,   43563,  8, }, // Asia/Krasnoyarsk
    {   73, 5976,   43571,  2, }, // Asia/Kuching
    {   73, 1211,   43573, 14, }, // Asia/Macau
    {   73, 4017,   43587,  3, }, // Asia/Magadan
    {   73, 1349,   43590,  4, }, // Asia/Makassar
    {   73, 7182,   43594,  3, }, // Asia/Manila
    {   73, 6920,   43597,  4, }, // Asia/Muscat
    {   73, 2554,   43601,  4, }, // Asia/Nicosia
    {   73, 8675,   43605,  6, }, // Asia/Novokuznetsk
    {   73, 4135,   43611,  5, }, // Asia/Novosibirsk
    {   73, 7145,   43616,  3, }, // Asia/Oral
    {   73, 6961,   43619,  2, }, // Asia/Phnom_Penh
    {   73, 5559,   43621,  2, }, // Asia/Qatar
    {   73, 4269,   43623,  6, }, // Asia/Qyzylorda
    {   73, 4408,   43629,  3, }, // Asia/Sakhalin
    {   73, 7245,   43632,  4, }, // Asia/Samarkand
    {   73, 3279,   43636,  2, }, // Asia/Seoul
    {   73, 2772,   43638,  3, }, // Asia/Tehran
    {   73, 2821,   43641,  2, }, // Asia/Tokyo
    {   73, 1021,   43643,  4, }, // Asia/Ulaanbaatar
    {   73, 1159,   43647,  4, }, // Asia/Urumqi
    {   73, 8722,   43651,  4, }, // Asia/Ust-Nera
    {   73, 4710,   43655,  3, }, // Asia/Vladivostok
    {   73, 4828,   43658,  4, }, // Asia/Yakutsk
    {   73, 3883,   43662,  5, }, // Asia/Yekaterinburg
    {   73, 3747,   43667,  3, }, // Asia/Yerevan
    {   73, 3663,   43670,  5, }, // Atlantic/Azores
    {   73, 5671,   43675,  3, }, // Atlantic/Bermuda
    {   73, 6628,   43678,  3, }, // Atlantic/Canary
    {   73, 3727,   43681,  3, }, // Atlantic/Cape_Verde
    {   73, 1395,   43684,  4, }, // Atlantic/Faroe
    {   73, 8736,   43688,  5, }, // Atlantic/Madeira
    {   73, 2748,   43693,  5, }, // Atlantic/Reykjavik
    {   73, 7272,   43698,  4, }, // Atlantic/South_Georgia
    {   73, 6821,   43702,  5, }, // Atlantic/St_Helena
    {   73, 1799,   43707,  5, }, // Australia/Broken_Hill
    {   73, 1583,   43712,  3, }, // Australia/Darwin
    {   73, 1547,   43715,  4, }, // Australia/Lord_Howe
    {   73, 1727,   43719,  3, }, // Australia/Melbourne
    {   73, 6216,   43722,  3, }, // Europe/Andorra
    {   73, 6336,   43725,  4, }, // Europe/Belgrade
    {   73, 2167,   43729,  4, }, // Europe/Brussels
    {   73, 3806,   43733,  4, }, // Europe/Budapest
    {   73, 2338,   42623,  3, }, // Europe/Dublin
    {   73, 6307,   43737,  4, }, // Europe/Gibraltar
    {   73, 8788,   43741,  3, }, // Europe/Guernsey
    {   73, 6612,   43744,  4, }, // Europe/Helsinki
    {   73, 8804,   43748,  2, }, // Europe/Isle_of_Man
    {   73, 8823,   43750,  3, }, // Europe/Jersey
    {   73, 3979,   43753,  5, }, // Europe/Kaliningrad
    {   73, 2527,   43758,  2, }, // Europe/Kyiv
    {   73, 6506,   43760,  4, }, // Europe/Ljubljana
    {   73, 2501,   43764,  2, }, // Europe/London
    {   73, 6365,   43766,  3, }, // Europe/Luxembourg
    {   73, 4892,   43769,  3, }, // Europe/Madrid
    {   73, 6397,   43772,  3, }, // Europe/Malta
    {   73, 6582,   43775,  3, }, // Europe/Mariehamn
    {   73, 6410,   43778,  3, }, // Europe/Monaco
    {   73, 6458,   43781,  3, }, // Europe/Oslo
    {   73, 6324,   43784,  2, }, // Europe/Rome
    {   73, 4331,   43786,  3, }, // Europe/Samara
    {   73, 6470,   43789,  4, }, // Europe/San_Marino
    {   73, 4451,   43793,  4, }, // Europe/Saratov
    {   73, 6599,   43797,  3, }, // Europe/Sofia
    {   73, 6523,   43800,  5, }, // Europe/Stockholm
    {   73, 8882,   43805,  7, }, // Europe/Ulyanovsk
    {   73, 6352,   43812,  3, }, // Europe/Vaduz
    {   73, 6567,   43815,  3, }, // Europe/Vatican
    {   73, 6231,   43818,  3, }, // Europe/Vienna
    {   73, 8899,   43821,  4, }, // Europe/Vilnius
    {   73, 4727,   43825,  5, }, // Europe/Volgograd
    {   73, 3190,   43830,  2, }, // Europe/Warsaw
    {   73, 6540,   43832,  3, }, // Europe/Zurich
    {   73, 6046,   43835,  3, }, // Indian/Christmas
    {   73, 6063,   43838,  5, }, // Indian/Cocos
    {   73, 5029,   43843,  5, }, // Indian/Comoro
    {   73, 6661,   43848,  5, }, // Indian/Kerguelen
    {   73, 7260,   43853,  3, }, // Indian/Mahe
    {   73, 7050,   43856,  4, }, // Indian/Maldives
    {   73, 5098,   43860,  4, }, // Indian/Mayotte
    {   73, 7211,   43864,  4, }, // Indian/Reunion
    {   73, 4422,   43868,  3, }, // Pacific/Apia
    {   73,  932,   43871,  3, }, // Pacific/Auckland
    {   73, 3706,   43874,  4, }, // Pacific/Bougainville
    {   73, 2237,   43878,  3, }, // Pacific/Easter
    {   73, 3902,   43881,  2, }, // Pacific/Fiji
    {   73, 6678,   43883,  6, }, // Pacific/Galapagos
    {   73, 6696,   43889,  5, }, // Pacific/Gambier
    {   73, 3822,   43894,  6, }, // Pacific/Guadalcanal
    {   73, 6018,   43900,  2, }, // Pacific/Guam
    {   73, 3049,   43902,  5, }, // Pacific/Kanton
    {   73, 3998,   43907,  6, }, // Pacific/Kiritimati
    {   73, 2842,   43913,  4, }, // Pacific/Kwajalein
    {   73, 4877,   43917,  3, }, // Pacific/Majuro
    {   73, 4051,   43920,  5, }, // Pacific/Marquesas
    {   73, 8914,   43925,  3, }, // Pacific/Midway
    {   73, 7084,   43928,  2, }, // Pacific/Nauru
    {   73, 7132,   43930,  3, }, // Pacific/Niue
    {   73, 4168,   43933,  3, }, // Pacific/Norfolk
    {   73, 7098,   43936,  3, }, // Pacific/Noumea
    {   73, 7194,   43939,  5, }, // Pacific/Pitcairn
    {   73, 3096,   43944,  3, }, // Pacific/Pohnpei
    {   73, 6076,   43947,  4, }, // Pacific/Rarotonga
    {   73, 4583,   43951,  5, }, // Pacific/Tongatapu
    {   75, 5059,    3784, 11, }, // Africa/Addis_Ababa Catalan/Latin/Spain
    {   75, 7420,   43956,  5, }, // Africa/Algiers
    {   75,   14,       0,  6, }, // Africa/Asmara
    {   75, 2320,   43961,  9, }, // Africa/Cairo
    {   75, 5166,   43970,  8, }, // Africa/El_Aaiun
    {   75, 4524,   26372,  7, }, // Africa/Khartoum
    {   75, 5113,   43978, 10, }, // Africa/Mogadishu
    {   75, 7034,   43988,  8, }, // Africa/Monrovia
    {   75, 5271,   43996,  9, }, // Africa/Ndjamena
    {   75, 4435,       6,  8, }, // Africa/Sao_Tome
    {   75, 2866,   20349,  7, }, // Africa/Tripoli
    {   75, 4554,   26427,  9, }, // America/Araguaina
    {   75,  270,   20361,  7, }, // America/Argentina/Cordoba
    {   75, 7489,   44005, 12, }, // America/Argentina/Rio_Gallegos
    {   75, 7571,   20368,  7, }, // America/Argentina/Tucuman
    {   75, 4252,      14,  8, }, // America/Asuncion
    {   75,  237,      22,  8, }, // America/Atikokan
    {   75, 7623,      30, 17, }, // America/Bahia_Banderas
    {   75, 7646,   35764,  5, }, // America/Belem
    {   75, 7660,   44017, 12, }, // America/Blanc-Sablon
    {   75, 4361,   44029,  6, }, // America/Bogota
    {   75, 3868,   33182,  6, }, // America/Cancun
    {   75, 4345,   44035,  6, }, // America/Cayenne
    {   75, 5496,   44041,  6, }, // America/Cayman
    {   75, 7774,      53, 13, }, // America/Ciudad_Juarez
    {   75, 3791,   26442,  6, }, // America/Cuiaba
    {   75, 5723,      66,  7, }, // America/Curacao
    {   75, 7869,   26448,  8, }, // America/Eirunepe
    {   75,  481,      73, 13, }, // America/Indiana/Knox
    {   75, 7961,      86, 16, }, // America/Indiana/Marengo
    {   75, 7985,     102, 19, }, // America/Indiana/Petersburg
    {   75, 8012,     121, 18, }, // America/Indiana/Tell_City
    {   75, 8038,     139, 14, }, // America/Indiana/Vevay
    {   75, 8060,     153, 18, }, // America/Indiana/Vincennes
    {   75, 8086,     171, 16, }, // America/Indiana/Winamac
    {   75, 8125,     187, 20, }, // America/Kentucky/Monticello
    {   75, 5932,     207, 22, }, // America/Lower_Princes
    {   75, 8153,   26456,  6, }, // America/Maceio
    {   75, 5805,   20436,  9, }, // America/Martinique
    {   75, 2917,   26471,  8, }, // America/Mazatlan
    {   75, 8220,     229,  6, }, // America/Merida
    {   75, 2949,   44047, 15, }, // America/Mexico_City
    {   75, 2379,   44062,  9, }, // America/New_York
    {   75, 8301,   44071, 23, }, // America/North_Dakota/Beulah
    {   75, 8329,   44094, 23, }, // America/North_Dakota/Center
    {   75, 8357,   44117, 26, }, // America/North_Dakota/New_Salem
    {   75,  393,     298,  4, }, // America/Nuuk
    {   75, 2356,   44143,  6, }, // America/Panama
    {   75, 8477,   26572,  8, }, // America/Santarem
    {   75, 1878,   26580,  9, }, // America/Sao_Paulo
    {   75, 6899,   44149, 12, }, // America/Scoresbysund
    {   75, 8508,   35804, 16, }, // America/St_Barthelemy
    {   75, 2061,   26605, 12, }, // America/St_Johns
    {   75, 5863,   26617, 11, }, // America/St_Kitts
    {   75, 5880,   35832, 11, }, // America/St_Lucia
    {   75,  855,   44161, 12, }, // America/St_Thomas
    {   75, 5913,   26651, 13, }, // America/St_Vincent
    {   75, 6133,     381, 16, }, // Antarctica/DumontDUrville
    {   75, 5511,   44173,  6, }, // Asia/Anadyr
    {   75, 5523,   44179,  5, }, // Asia/Aqtau
    {   75, 5368,   44184,  6, }, // Asia/Aqtobe
    {   75,  964,   44190,  7, }, // Asia/Ashgabat
    {   75, 8624,   44197,  6, }, // Asia/Atyrau
    {   75, 3607,    4044,  6, }, // Asia/Baghdad
    {   75, 3653,   20629,  4, }, // Asia/Baku
    {   75, 3571,   44203,  7, }, // Asia/Barnaul
    {   75, 4601,   44210,  5, }, // Asia/Chita
    {   75, 4540,   20639,  6, }, // Asia/Damascus
    {   75, 6159,   44215,  8, }, // Asia/Dushanbe
    {   75, 1259,   44223, 11, }, // Asia/Ho_Chi_Minh
    {   75, 4771,   26703,  5, }, // Asia/Hovd
    {   75, 6992,   44234,  6, }, // Asia/Jayapura
    {   75, 4316,   26708,  9, }, // Asia/Kamchatka
    {   75, 1185,   20712,  8, }, // Asia/Kathmandu
    {   75,  992,   20720,  7, }, // Asia/Kolkata
    {   75, 4197,   26739, 11, }, // Asia/Krasnoyarsk
    {   75, 1211,    4203,  5, }, // Asia/Macau
    {   75, 6920,   35935,  6, }, // Asia/Muscat
    {   75, 2554,   44240,  7, }, // Asia/Nicosia
    {   75, 4135,   44247, 12, }, // Asia/Novosibirsk
    {   75, 8708,   44259,  8, }, // Asia/Qostanay
    {   75, 3584,    7669,  4, }, // Asia/Riyadh
    {   75, 4408,   44267,  8, }, // Asia/Sakhalin
    {   75, 7245,   20768, 10, }, // Asia/Samarkand
    {   75, 3279,   44275,  4, }, // Asia/Seoul
    {   75, 3300,   20782,  8, }, // Asia/Singapore
    {   75, 4297,    7699, 13, }, // Asia/Srednekolymsk
    {   75, 4781,   44279,  8, }, // Asia/Tashkent
    {   75, 2772,    7724,  7, }, // Asia/Tehran
    {   75, 2821,   44287,  6, }, // Asia/Tokyo
    {   75, 1159,   44293,  7, }, // Asia/Urumqi
    {   75, 8722,   44300,  9, }, // Asia/Ust-Nera
    {   75, 4828,   44309,  7, }, // Asia/Yakutsk
    {   75, 1235,     442,  6, }, // Asia/Yangon
    {   75, 3883,   44316, 13, }, // Asia/Yekaterinburg
    {   75, 3663,   44329,  6, }, // Atlantic/Azores
    {   75, 5671,   44335,  8, }, // Atlantic/Bermuda
    {   75, 6628,   44343, 14, }, // Atlantic/Canary
    {   75, 3727,   44357,  8, }, // Atlantic/Cape_Verde
    {   75, 1395,   44365, 11, }, // Atlantic/Faroe
    {   75, 2748,   36044,  9, }, // Atlantic/Reykjavik
    {   75, 7272,   44376, 15, }, // Atlantic/South_Georgia
    {   75, 6821,   36066, 12, }, // Atlantic/St_Helena
    {   75, 3620,   44391,  8, }, // Europe/Astrakhan
    {   75, 2300,   20928,  6, }, // Europe/Athens
    {   75, 6336,   26883,  7, }, // Europe/Belgrade
    {   75, 4757,   20941,  6, }, // Europe/Berlin
    {   75, 2167,   44399, 11, }, // Europe/Brussels
    {   75, 3928,   20955,  8, }, // Europe/Bucharest
    {   75, 6289,   44410, 11, }, // Europe/Copenhagen
    {   75, 2338,   20973,  6, }, // Europe/Dublin
    {   75, 6612,   44421,  8, }, // Europe/Helsinki
    {   75, 8804,    4374,  3, }, // Europe/Isle_of_Man
    {   75, 8929,   44429,  5, }, // Europe/Kirov
    {   75, 2527,   44434,  4, }, // Europe/Kyiv
    {   75, 3213,   21019,  6, }, // Europe/Lisbon
    {   75, 2501,   21034,  7, }, // Europe/London
    {   75, 6365,    4395,  9, }, // Europe/Luxembourg
    {   75, 6410,   44438,  6, }, // Europe/Monaco
    {   75, 3537,   44444,  6, }, // Europe/Moscow
    {   75, 4284,   21062,  5, }, // Europe/Paris
    {   75, 6275,   21067,  5, }, // Europe/Prague
    {   75, 6324,    5946,  4, }, // Europe/Rome
    {   75, 4451,   44450,  7, }, // Europe/Saratov
    {   75, 8849,   44457, 10, }, // Europe/Simferopol
    {   75, 6523,   21086,  8, }, // Europe/Stockholm
    {   75, 6202,   21095,  6, }, // Europe/Tirane
    {   75, 8882,   44467,  9, }, // Europe/Ulyanovsk
    {   75, 6567,   44476,  6, }, // Europe/Vatican
    {   75, 6231,   21112,  5, }, // Europe/Vienna
    {   75, 8899,   44482,  7, }, // Europe/Vilnius
    {   75, 3190,   44489,  8, }, // Europe/Warsaw
    {   75, 6540,   44497,  5, }, // Europe/Zurich
    {   75, 4069,   21134,  7, }, // Indian/Mauritius
    {   75, 7211,   21142,  6, }, // Indian/Reunion
    {   75, 3157,     474,  5, }, // Pacific/Chuuk
    {   75, 2237,   44502, 14, }, // Pacific/Easter
    {   75, 6678,   21159,  9, }, // Pacific/Galapagos
    {   75, 2723,    4493,  8, }, // Pacific/Honolulu
    {   75, 3049,    4501,  9, }, // Pacific/Kanton
    {   75, 4051,   44516,  9, }, // Pacific/Marquesas
    {   75, 7098,    4510,  6, }, // Pacific/Noumea
    {   75, 3096,     479,  7, }, // Pacific/Pohnpei
    {   75, 7312,   44525,  6, }, // Pacific/Tahiti
    {   79,   14,       0,  6, }, // Africa/Asmara Cebuano/Latin/Philippines
    {   79, 4435,       6,  8, }, // Africa/Sao_Tome
    {   79, 4252,      14,  8, }, // America/Asuncion
    {   79,  237,      22,  8, }, // America/Atikokan
    {   79, 7623,      30, 17, }, // America/Bahia_Banderas
    {   79, 3868,      47,  6, }, // America/Cancun
    {   79, 7774,      53, 13, }, // America/Ciudad_Juarez
    {   79, 5723,      66,  7, }, // America/Curacao
    {   79,  481,      73, 13, }, // America/Indiana/Knox
    {   79, 7961,      86, 16, }, // America/Indiana/Marengo
    {   79, 7985,     102, 19, }, // America/Indiana/Petersburg
    {   79, 8012,     121, 18, }, // America/Indiana/Tell_City
    {   79, 8038,     139, 14, }, // America/Indiana/Vevay
    {   79, 8060,     153, 18, }, // America/Indiana/Vincennes
    {   79, 8086,     171, 16, }, // America/Indiana/Winamac
    {   79, 8125,     187, 20, }, // America/Kentucky/Monticello
    {   79, 5932,     207, 22, }, // America/Lower_Princes
    {   79, 8220,     229,  6, }, // America/Merida
    {   79, 8301,     235, 20, }, // America/North_Dakota/Beulah
    {   79, 8329,     255, 20, }, // America/North_Dakota/Center
    {   79, 8357,     275, 23, }, // America/North_Dakota/New_Salem
    {   79,  393,     298,  4, }, // America/Nuuk
    {   79, 6899,     302, 16, }, // America/Scoresbysund
    {   79, 8508,     318, 14, }, // America/St_Barthelemy
    {   79, 2061,     332, 10, }, // America/St_Johns
    {   79, 5863,     342,  9, }, // America/St_Kitts
    {   79, 5880,     351,  9, }, // America/St_Lucia
    {   79,  855,     360, 10, }, // America/St_Thomas
    {   79, 5913,     370, 11, }, // America/St_Vincent
    {   79, 6133,     381, 16, }, // Antarctica/DumontDUrville
    {   79, 1259,   44531, 22, }, // Asia/Ho_Chi_Minh
    {   79, 1185,     413,  9, }, // Asia/Kathmandu
    {   79,  992,     422,  7, }, // Asia/Kolkata
    {   79, 1211,     429,  5, }, // Asia/Macau
    {   79, 1235,     442,  6, }, // Asia/Yangon
    {   79, 1395,     448,  5, }, // Atlantic/Faroe
    {   79, 6821,     453, 10, }, // Atlantic/St_Helena
    {   79, 2527,     463,  4, }, // Europe/Kyiv
    {   79, 7211,     467,  7, }, // Indian/Reunion
    {   79, 3157,     474,  5, }, // Pacific/Chuuk
    {   79, 3049,    4501,  9, }, // Pacific/Kanton
    {   79, 3096,     479,  7, }, // Pacific/Pohnpei
    {   80,   14,       0,  6, }, // Africa/Asmara Central Atlas Tamazight/Latin/Morocco
    {   80, 4435,       6,  8, }, // Africa/Sao_Tome
    {   80, 4252,      14,  8, }, // America/Asuncion
    {   80,  237,      22,  8, }, // America/Atikokan
    {   80, 7623,      30, 17, }, // America/Bahia_Banderas
    {   80, 3868,      47,  6, }, // America/Cancun
    {   80, 7774,      53, 13, }, // America/Ciudad_Juarez
    {   80, 5723,      66,  7, }, // America/Curacao
    {   80,  481,      73, 13, }, // America/Indiana/Knox
    {   80, 7961,      86, 16, }, // America/Indiana/Marengo
    {   80, 7985,     102, 19, }, // America/Indiana/Petersburg
    {   80, 8012,     121, 18, }, // America/Indiana/Tell_City
    {   80, 8038,     139, 14, }, // America/Indiana/Vevay
    {   80, 8060,     153, 18, }, // America/Indiana/Vincennes
    {   80, 8086,     171, 16, }, // America/Indiana/Winamac
    {   80, 8125,     187, 20, }, // America/Kentucky/Monticello
    {   80, 5932,     207, 22, }, // America/Lower_Princes
    {   80, 8220,     229,  6, }, // America/Merida
    {   80, 8301,     235, 20, }, // America/North_Dakota/Beulah
    {   80, 8329,     255, 20, }, // America/North_Dakota/Center
    {   80, 8357,     275, 23, }, // America/North_Dakota/New_Salem
    {   80,  393,     298,  4, }, // America/Nuuk
    {   80, 6899,     302, 16, }, // America/Scoresbysund
    {   80, 8508,     318, 14, }, // America/St_Barthelemy
    {   80, 2061,     332, 10, }, // America/St_Johns
    {   80, 5863,     342,  9, }, // America/St_Kitts
    {   80, 5880,     351,  9, }, // America/St_Lucia
    {   80,  855,     360, 10, }, // America/St_Thomas
    {   80, 5913,     370, 11, }, // America/St_Vincent
    {   80, 6133,     381, 16, }, // Antarctica/DumontDUrville
    {   80, 1259,     397, 11, }, // Asia/Ho_Chi_Minh
    {   80, 1185,     413,  9, }, // Asia/Kathmandu
    {   80,  992,     422,  7, }, // Asia/Kolkata
    {   80, 1211,     429,  5, }, // Asia/Macau
    {   80, 1235,     442,  6, }, // Asia/Yangon
    {   80, 1395,     448,  5, }, // Atlantic/Faroe
    {   80, 6821,     453, 10, }, // Atlantic/St_Helena
    {   80, 2527,     463,  4, }, // Europe/Kyiv
    {   80, 7211,     467,  7, }, // Indian/Reunion
    {   80, 3157,     474,  5, }, // Pacific/Chuuk
    {   80, 3096,     479,  7, }, // Pacific/Pohnpei
    {   81,   14,       0,  6, }, // Africa/Asmara Central Kurdish/Arabic/Iraq
    {   81, 4435,       6,  8, }, // Africa/Sao_Tome
    {   81, 4252,      14,  8, }, // America/Asuncion
    {   81,  237,      22,  8, }, // America/Atikokan
    {   81, 7623,      30, 17, }, // America/Bahia_Banderas
    {   81, 3868,      47,  6, }, // America/Cancun
    {   81, 7774,      53, 13, }, // America/Ciudad_Juarez
    {   81, 5723,      66,  7, }, // America/Curacao
    {   81,  481,      73, 13, }, // America/Indiana/Knox
    {   81, 7961,      86, 16, }, // America/Indiana/Marengo
    {   81, 7985,     102, 19, }, // America/Indiana/Petersburg
    {   81, 8012,     121, 18, }, // America/Indiana/Tell_City
    {   81, 8038,     139, 14, }, // America/Indiana/Vevay
    {   81, 8060,     153, 18, }, // America/Indiana/Vincennes
    {   81, 8086,     171, 16, }, // America/Indiana/Winamac
    {   81, 8125,     187, 20, }, // America/Kentucky/Monticello
    {   81, 5932,     207, 22, }, // America/Lower_Princes
    {   81, 8220,     229,  6, }, // America/Merida
    {   81, 8301,     235, 20, }, // America/North_Dakota/Beulah
    {   81, 8329,     255, 20, }, // America/North_Dakota/Center
    {   81, 8357,     275, 23, }, // America/North_Dakota/New_Salem
    {   81,  393,     298,  4, }, // America/Nuuk
    {   81, 6899,     302, 16, }, // America/Scoresbysund
    {   81, 8508,     318, 14, }, // America/St_Barthelemy
    {   81, 2061,     332, 10, }, // America/St_Johns
    {   81, 5863,     342,  9, }, // America/St_Kitts
    {   81, 5880,     351,  9, }, // America/St_Lucia
    {   81,  855,     360, 10, }, // America/St_Thomas
    {   81, 5913,     370, 11, }, // America/St_Vincent
    {   81, 6133,     381, 16, }, // Antarctica/DumontDUrville
    {   81, 1259,     397, 11, }, // Asia/Ho_Chi_Minh
    {   81, 1185,     413,  9, }, // Asia/Kathmandu
    {   81,  992,     422,  7, }, // Asia/Kolkata
    {   81, 1211,     429,  5, }, // Asia/Macau
    {   81, 1235,     442,  6, }, // Asia/Yangon
    {   81, 1395,     448,  5, }, // Atlantic/Faroe
    {   81, 6821,     453, 10, }, // Atlantic/St_Helena
    {   81, 2527,     463,  4, }, // Europe/Kyiv
    {   81, 7211,     467,  7, }, // Indian/Reunion
    {   81, 3157,     474,  5, }, // Pacific/Chuuk
    {   81, 3096,     479,  7, }, // Pacific/Pohnpei
    {   83, 6788,   44553, 16, }, // Africa/Abidjan Chakma/Chakma/Bangladesh
    {   83, 6760,   44569,  8, }, // Africa/Accra
    {   83, 5059,   44577, 21, }, // Africa/Addis_Ababa
    {   83, 7420,   44598, 20, }, // Africa/Algiers
    {   83,   14,   44618, 16, }, // Africa/Asmara
    {   83,   44,   44634, 12, }, // Africa/Bamako
    {   83, 5257,   44646, 12, }, // Africa/Bangui
    {   83, 6746,   44658, 12, }, // Africa/Banjul
    {   83, 7435,   44670,  8, }, // Africa/Bissau
    {   83, 4957,   44678, 24, }, // Africa/Blantyre
    {   83, 5287,   44702, 18, }, // Africa/Brazzaville
    {   83, 4922,   44720, 24, }, // Africa/Bujumbura
    {   83, 2320,   44744, 10, }, // Africa/Cairo
    {   83, 4117,   44754, 14, }, // Africa/Casablanca
    {   83, 7449,   44768, 10, }, // Africa/Ceuta
    {   83, 6773,   44778, 14, }, // Africa/Conakry
    {   83, 6840,   44792,  8, }, // Africa/Dakar
    {   83, 5130,   44800, 24, }, // Africa/Dar_es_Salaam
    {   83, 5043,   44824, 12, }, // Africa/Djibouti
    {   83, 5243,   44836,  8, }, // Africa/Douala
    {   83, 5166,   44844, 27, }, // Africa/El_Aaiun
    {   83, 6853,   44871, 18, }, // Africa/Freetown
    {   83, 4906,   44889, 18, }, // Africa/Gaborone
    {   83, 5015,   44907,  8, }, // Africa/Harare
    {   83, 4479,   44915, 24, }, // Africa/Johannesburg
    {   83, 4499,   44939,  6, }, // Africa/Juba
    {   83, 5151,   44945, 10, }, // Africa/Kampala
    {   83, 4524,   44955, 14, }, // Africa/Khartoum
    {   83, 4973,   44969, 10, }, // Africa/Kigali
    {   83, 5306,   44979, 12, }, // Africa/Kinshasa
    {   83, 4744,   44991, 10, }, // Africa/Lagos
    {   83, 5336,   45001, 20, }, // Africa/Libreville
    {   83, 6869,   45021,  8, }, // Africa/Lome
    {   83, 5211,   45029, 12, }, // Africa/Luanda
    {   83, 4939,   45041, 18, }, // Africa/Lubumbashi
    {   83, 5001,   45059,  8, }, // Africa/Lusaka
    {   83, 5322,   45067,  8, }, // Africa/Malabo
    {   83, 4987,   45075, 10, }, // Africa/Maputo
    {   83, 5197,   45085, 14, }, // Africa/Maseru
    {   83, 5182,   45099, 16, }, // Africa/Mbabane
    {   83, 5113,   45115, 14, }, // Africa/Mogadishu
    {   83, 7034,   45129, 18, }, // Africa/Monrovia
    {   83, 3853,   45147, 12, }, // Africa/Nairobi
    {   83, 5271,   45159, 18, }, // Africa/Ndjamena
    {   83, 5354,   45177, 10, }, // Africa/Niamey
    {   83, 6803,   45187, 18, }, // Africa/Nouakchott
    {   83, 6727,   45205, 18, }, // Africa/Ouagadougou
    {   83, 5225,   45223, 21, }, // Africa/Porto-Novo
    {   83, 4435,   45244, 15, }, // Africa/Sao_Tome
    {   83, 2866,   45259, 16, }, // Africa/Tripoli
    {   83, 6554,   45275, 16, }, // Africa/Tunis
    {   83, 4152,   45291, 20, }, // Africa/Windhoek
    {   83,  132,   45311,  8, }, // America/Adak
    {   83, 3346,   45319, 20, }, // America/Anchorage
    {   83, 5607,   45339, 20, }, // America/Anguilla
    {   83, 5624,   45359, 22, }, // America/Antigua
    {   83, 4554,   45381, 14, }, // America/Araguaina
    {   83,  166,   45395, 31, }, // America/Argentina/Buenos_Aires
    {   83,   91,   45426, 16, }, // America/Argentina/Catamarca
    {   83,  270,   45442, 14, }, // America/Argentina/Cordoba
    {   83,  441,   45456, 12, }, // America/Argentina/Jujuy
    {   83, 7462,   45468, 13, }, // America/Argentina/La_Rioja
    {   83,  565,   45481, 14, }, // America/Argentina/Mendoza
    {   83, 7489,   45495, 23, }, // America/Argentina/Rio_Gallegos
    {   83, 7520,   45518, 12, }, // America/Argentina/Salta
    {   83, 7544,   45530, 17, }, // America/Argentina/San_Juan
    {   83, 5580,   45547, 17, }, // America/Argentina/San_Luis
    {   83, 7571,   45564, 14, }, // America/Argentina/Tucuman
    {   83, 7597,   45578, 12, }, // America/Argentina/Ushuaia
    {   83, 5640,   45590, 10, }, // America/Aruba
    {   83, 4252,   45600, 22, }, // America/Asuncion
    {   83,  237,   45622, 23, }, // America/Atikokan
    {   83, 3679,   45645,  8, }, // America/Bahia
    {   83, 7623,   45653, 25, }, // America/Bahia_Banderas
    {   83, 5654,   45678, 16, }, // America/Barbados
    {   83, 7646,   45694, 12, }, // America/Belem
    {   83, 5407,   45706, 12, }, // America/Belize
    {   83, 7660,   45718, 27, }, // America/Blanc-Sablon
    {   83, 7681,   45745, 15, }, // America/Boa_Vista
    {   83, 4361,   45760, 10, }, // America/Bogota
    {   83, 7699,   45770, 12, }, // America/Boise
    {   83, 7713,   45782, 25, }, // America/Cambridge_Bay
    {   83, 7735,   45807, 25, }, // America/Campo_Grande
    {   83, 3868,   45832, 18, }, // America/Cancun
    {   83, 4694,   45850, 14, }, // America/Caracas
    {   83, 4345,   45864, 10, }, // America/Cayenne
    {   83, 5496,   45874, 10, }, // America/Cayman
    {   83, 2260,   45884, 10, }, // America/Chicago
    {   83, 7756,   45894, 16, }, // America/Chihuahua
    {   83, 7774,      53, 13, }, // America/Ciudad_Juarez
    {   83, 5422,   45910, 16, }, // America/Costa_Rica
    {   83, 7796,   45926, 18, }, // America/Creston
    {   83, 3791,   45944, 10, }, // America/Cuiaba
    {   83, 5723,   45954, 12, }, // America/Curacao
    {   83, 7812,   45966, 30, }, // America/Danmarkshavn
    {   83, 7833,   45996, 12, }, // America/Dawson
    {   83, 7848,   46008, 25, }, // America/Dawson_Creek
    {   83,  805,   46033, 14, }, // America/Denver
    {   83, 3465,   46047, 20, }, // America/Detroit
    {   83, 5739,   46067, 14, }, // America/Dominica
    {   83,  893,   46081, 24, }, // America/Edmonton
    {   83, 7869,   46105, 16, }, // America/Eirunepe
    {   83, 5441,   46121, 25, }, // America/El_Salvador
    {   83, 7886,   46146, 29, }, // America/Fort_Nelson
    {   83, 7906,   46175, 14, }, // America/Fortaleza
    {   83, 7924,   46189, 15, }, // America/Glace_Bay
    {   83, 6881,   46204, 13, }, // America/Goose_Bay
    {   83, 4612,   46217, 31, }, // America/Grand_Turk
    {   83, 5770,   46248, 12, }, // America/Grenada
    {   83, 5786,   46260, 16, }, // America/Guadeloupe
    {   83, 3760,   46276, 12, }, // America/Guatemala
    {   83, 4841,   46288, 20, }, // America/Guayaquil
    {   83, 6932,   46308,  6, }, // America/Guyana
    {   83, 1939,   46314, 24, }, // America/Halifax
    {   83, 2281,   46338,  6, }, // America/Havana
    {   83, 7942,   46344, 22, }, // America/Hermosillo
    {   83,  348,   46366, 28, }, // America/Indiana/Indianapolis
    {   83,  481,   46394, 30, }, // America/Indiana/Knox
    {   83, 7961,   46424, 32, }, // America/Indiana/Marengo
    {   83, 7985,   46456, 42, }, // America/Indiana/Petersburg
    {   83, 8012,   46498, 34, }, // America/Indiana/Tell_City
    {   83, 8038,   46532, 30, }, // America/Indiana/Vevay
    {   83, 8060,   46562, 42, }, // America/Indiana/Vincennes
    {   83, 8086,   46604, 38, }, // America/Indiana/Winamac
    {   83, 8110,   46642, 18, }, // America/Inuvik
    {   83,  660,   46660, 20, }, // America/Iqaluit
    {   83, 2799,   46680,  8, }, // America/Jamaica
    {   83, 5380,   46688,  8, }, // America/Juneau
    {   83,  521,   46696, 18, }, // America/Kentucky/Louisville
    {   83, 8125,   46714, 36, }, // America/Kentucky/Monticello
    {   83, 5704,   46750, 26, }, // America/Kralendijk
    {   83, 4376,   46776,  9, }, // America/La_Paz
    {   83, 7169,   46785,  6, }, // America/Lima
    {   83, 3239,   46791, 31, }, // America/Los_Angeles
    {   83, 5932,   46822, 48, }, // America/Lower_Princes
    {   83, 8153,   46870, 10, }, // America/Maceio
    {   83, 8168,   46880,  8, }, // America/Managua
    {   83, 1908,   46888, 12, }, // America/Manaus
    {   83, 5897,   46900, 10, }, // America/Marigot
    {   83, 5805,   46910, 18, }, // America/Martinique
    {   83, 8184,   46928, 16, }, // America/Matamoros
    {   83, 2917,   46944, 14, }, // America/Mazatlan
    {   83, 8202,   46958, 16, }, // America/Menominee
    {   83, 8220,   46974, 10, }, // America/Merida
    {   83, 8235,   46984, 16, }, // America/Metlakatla
    {   83, 2949,   47000, 29, }, // America/Mexico_City
    {   83, 4391,   47029, 16, }, // America/Miquelon
    {   83, 8254,   47045, 16, }, // America/Moncton
    {   83, 8270,   47061, 16, }, // America/Monterrey
    {   83, 4098,   47077, 24, }, // America/Montevideo
    {   83, 5824,   47101, 22, }, // America/Montserrat
    {   83, 5481,   47123,  8, }, // America/Nassau
    {   83, 2379,   47131, 24, }, // America/New_York
    {   83, 8288,   47155,  8, }, // America/Nome
    {   83, 1850,   47163, 14, }, // America/Noronha
    {   83, 8301,   47177, 37, }, // America/North_Dakota/Beulah
    {   83, 8329,   47214, 41, }, // America/North_Dakota/Center
    {   83, 8357,   47255, 46, }, // America/North_Dakota/New_Salem
    {   83,  393,   47301,  8, }, // America/Nuuk
    {   83, 8388,   47309, 14, }, // America/Ojinaga
    {   83, 2356,   47323,  6, }, // America/Panama
    {   83, 6173,   47329, 20, }, // America/Paramaribo
    {   83, 2973,   47349, 16, }, // America/Phoenix
    {   83, 3945,   47365, 34, }, // America/Port-au-Prince
    {   83, 5954,   47399, 34, }, // America/Port_of_Spain
    {   83, 8404,   47433, 25, }, // America/Porto_Velho
    {   83, 5843,   47458, 25, }, // America/Puerto_Rico
    {   83, 8424,   47483, 35, }, // America/Rankin_Inlet
    {   83, 8445,   47518, 12, }, // America/Recife
    {   83, 1995,   47530, 10, }, // America/Regina
    {   83, 8460,   47540, 16, }, // America/Resolute
    {   83,  695,   47556, 23, }, // America/Rio_Branco
    {   83, 8477,   47579, 20, }, // America/Santarem
    {   83, 2201,   47599, 16, }, // America/Santiago
    {   83, 6111,   47615, 29, }, // America/Santo_Domingo
    {   83, 1878,   47644, 17, }, // America/Sao_Paulo
    {   83, 6899,   47661, 36, }, // America/Scoresbysund
    {   83, 8494,   47697, 10, }, // America/Sitka
    {   83, 8508,   47707, 32, }, // America/St_Barthelemy
    {   83, 2061,   47739, 25, }, // America/St_Johns
    {   83, 5863,   47764, 26, }, // America/St_Kitts
    {   83, 5880,   47790, 24, }, // America/St_Lucia
    {   83,  855,   47814, 23, }, // America/St_Thomas
    {   83, 5913,   47837, 33, }, // America/St_Vincent
    {   83, 8530,   47870, 29, }, // America/Swift_Current
    {   83, 5461,   47899, 20, }, // America/Tegucigalpa
    {   83, 5756,   47919,  8, }, // America/Thule
    {   83,  313,   47927, 12, }, // America/Tijuana
    {   83,  608,   47939, 16, }, // America/Toronto
    {   83, 5688,   47955, 14, }, // America/Tortola
    {   83, 2093,   47969, 20, }, // America/Vancouver
    {   83, 2144,   47989, 22, }, // America/Whitehorse
    {   83,  734,   48011, 20, }, // America/Winnipeg
    {   83, 8552,   48031, 16, }, // America/Yakutat
    {   83, 6001,   48047, 12, }, // Antarctica/Casey
    {   83, 6094,   48059, 12, }, // Antarctica/Davis
    {   83, 6133,   48071, 37, }, // Antarctica/DumontDUrville
    {   83, 8568,   48108, 22, }, // Antarctica/Macquarie
    {   83, 7066,   48130, 12, }, // Antarctica/Mawson
    {   83, 7113,   48142, 22, }, // Antarctica/McMurdo
    {   83, 8589,   48164, 12, }, // Antarctica/Palmer
    {   83, 7226,   48176, 10, }, // Antarctica/Rothera
    {   83, 7295,   48186,  6, }, // Antarctica/Syowa
    {   83, 8607,   48192, 12, }, // Antarctica/Troll
    {   83, 7374,   48204, 16, }, // Antarctica/Vostok
    {   83, 1429,   48220, 28, }, // Arctic/Longyearbyen
    {   83, 5570,   48248, 14, }, // Asia/Aden
    {   83, 5395,   48262, 12, }, // Asia/Almaty
    {   83, 3968,   48274, 14, }, // Asia/Amman
    {   83, 5511,   48288, 16, }, // Asia/Anadyr
    {   83, 5523,   48304, 12, }, // Asia/Aqtau
    {   83, 5368,   48316, 14, }, // Asia/Aqtobe
    {   83,  964,   48330, 16, }, // Asia/Ashgabat
    {   83, 3607,   48346, 12, }, // Asia/Baghdad
    {   83, 5534,   48358, 14, }, // Asia/Bahrain
    {   83, 3653,   45952,  6, }, // Asia/Baku
    {   83, 4466,   48372, 16, }, // Asia/Bangkok
    {   83, 3571,   48388, 14, }, // Asia/Barnaul
    {   83, 4086,   48402, 14, }, // Asia/Beirut
    {   83, 3778,   48416, 16, }, // Asia/Bishkek
    {   83, 5989,   48432, 14, }, // Asia/Brunei
    {   83, 4601,   48446,  6, }, // Asia/Chita
    {   83, 4511,   48452, 22, }, // Asia/Colombo
    {   83, 4540,   48474, 14, }, // Asia/Damascus
    {   83, 1093,   48488,  4, }, // Asia/Dhaka
    {   83, 6192,   48492,  8, }, // Asia/Dili
    {   83, 3596,   48500,  8, }, // Asia/Dubai
    {   83, 6159,   48508, 14, }, // Asia/Dushanbe
    {   83, 8651,   48522,  4, }, // Asia/Gaza
    {   83, 4795,   48526, 16, }, // Asia/Hebron
    {   83, 1259,   48542, 31, }, // Asia/Ho_Chi_Minh
    {   83, 2704,   48573, 13, }, // Asia/Hong_Kong
    {   83, 4771,   48586, 12, }, // Asia/Hovd
    {   83, 4184,   48598, 24, }, // Asia/Irkutsk
    {   83, 7006,   48622, 10, }, // Asia/Jakarta
    {   83, 6992,   48632, 12, }, // Asia/Jayapura
    {   83, 1290,   48644, 18, }, // Asia/Jerusalem
    {   83, 3560,   48662, 10, }, // Asia/Kabul
    {   83, 4316,   48672, 14, }, // Asia/Kamchatka
    {   83, 4239,   48686, 10, }, // Asia/Karachi
    {   83, 1185,   48696, 18, }, // Asia/Kathmandu
    {   83, 8661,   48714, 14, }, // Asia/Khandyga
    {   83,  992,   48728, 12, }, // Asia/Kolkata
    {   83, 4197,   48740, 28, }, // Asia/Krasnoyarsk
    {   83, 4859,   48768, 22, }, // Asia/Kuala_Lumpur
    {   83, 5976,   48790, 10, }, // Asia/Kuching
    {   83, 5547,   48800, 12, }, // Asia/Kuwait
    {   83, 1211,   48812, 12, }, // Asia/Macau
    {   83, 4017,   48824, 14, }, // Asia/Magadan
    {   83, 1349,   48838, 14, }, // Asia/Makassar
    {   83, 7182,   48852, 12, }, // Asia/Manila
    {   83, 6920,   48864, 12, }, // Asia/Muscat
    {   83, 2554,   48876, 14, }, // Asia/Nicosia
    {   83, 8675,   48890, 32, }, // Asia/Novokuznetsk
    {   83, 4135,   48922, 28, }, // Asia/Novosibirsk
    {   83, 4229,   48950, 16, }, // Asia/Omsk
    {   83, 7145,   48966, 10, }, // Asia/Oral
    {   83, 6961,   48976, 17, }, // Asia/Phnom_Penh
    {   83, 8693,   48993, 24, }, // Asia/Pontianak
    {   83, 4214,   49017, 21, }, // Asia/Pyongyang
    {   83, 5559,   49038,  8, }, // Asia/Qatar
    {   83, 4269,   49046, 18, }, // Asia/Qyzylorda
    {   83, 3584,   49064, 10, }, // Asia/Riyadh
    {   83, 4408,   49074, 12, }, // Asia/Sakhalin
    {   83, 7245,   49086, 24, }, // Asia/Samarkand
    {   83, 3279,   49110, 12, }, // Asia/Seoul
    {   83, 1053,   49122,  8, }, // Asia/Shanghai
    {   83, 3300,   49130, 18, }, // Asia/Singapore
    {   83, 4297,   49148, 40, }, // Asia/Srednekolymsk
    {   83, 3263,   49188, 12, }, // Asia/Taipei
    {   83, 4781,   49200, 18, }, // Asia/Tashkent
    {   83, 3915,   49218, 16, }, // Asia/Tbilisi
    {   83, 2772,   49234, 14, }, // Asia/Tehran
    {   83, 1317,   49248, 12, }, // Asia/Thimphu
    {   83, 2821,   49260, 12, }, // Asia/Tokyo
    {   83, 4572,   49272, 16, }, // Asia/Tomsk
    {   83, 1021,   49288, 18, }, // Asia/Ulaanbaatar
    {   83, 1159,   49306, 16, }, // Asia/Urumqi
    {   83, 8722,   49322, 19, }, // Asia/Ust-Nera
    {   83, 6977,   49341, 24, }, // Asia/Vientiane
    {   83, 4710,   49365, 26, }, // Asia/Vladivostok
    {   83, 4828,   49391, 18, }, // Asia/Yakutsk
    {   83, 1235,   49409, 16, }, // Asia/Yangon
    {   83, 3883,   49425, 32, }, // Asia/Yekaterinburg
    {   83, 3747,   49457, 16, }, // Asia/Yerevan
    {   83, 3663,   49473, 14, }, // Atlantic/Azores
    {   83, 5671,   49487, 12, }, // Atlantic/Bermuda
    {   83, 6628,   49499, 10, }, // Atlantic/Canary
    {   83, 3727,   49509, 19, }, // Atlantic/Cape_Verde
    {   83, 1395,   49528, 10, }, // Atlantic/Faroe
    {   83, 8736,   49538, 10, }, // Atlantic/Madeira
    {   83, 2748,   49548, 18, }, // Atlantic/Reykjavik
    {   83, 7272,   49566, 27, }, // Atlantic/South_Georgia
    {   83, 6821,   49593, 23, }, // Atlantic/St_Helena
    {   83, 6644,   49616, 14, }, // Atlantic/Stanley
    {   83, 1670,   49630, 20, }, // Australia/Adelaide
    {   83, 1635,   49650, 20, }, // Australia/Brisbane
    {   83, 1799,   49670, 25, }, // Australia/Broken_Hill
    {   83, 1583,   49695, 18, }, // Australia/Darwin
    {   83, 3637,   49713, 14, }, // Australia/Eucla
    {   83, 1516,   49727, 14, }, // Australia/Hobart
    {   83, 8753,   49741, 22, }, // Australia/Lindeman
    {   83, 1547,   49763, 19, }, // Australia/Lord_Howe
    {   83, 1727,   49782, 18, }, // Australia/Melbourne
    {   83, 1762,   49800, 10, }, // Australia/Perth
    {   83, 1463,   49810, 12, }, // Australia/Sydney
    {   83, 6441,   49822, 22, }, // Europe/Amsterdam
    {   83, 6216,   49844, 16, }, // Europe/Andorra
    {   83, 3620,   49860, 18, }, // Europe/Astrakhan
    {   83, 2300,   49878, 16, }, // Europe/Athens
    {   83, 6336,   49894, 20, }, // Europe/Belgrade
    {   83, 4757,   49914, 14, }, // Europe/Berlin
    {   83, 6488,   49928, 18, }, // Europe/Bratislava
    {   83, 2167,   49946, 18, }, // Europe/Brussels
    {   83, 3928,   49964, 18, }, // Europe/Bucharest
    {   83, 3806,   49982, 18, }, // Europe/Budapest
    {   83, 8772,   50000, 20, }, // Europe/Busingen
    {   83, 2583,   50020, 14, }, // Europe/Chisinau
    {   83, 6289,   50034, 24, }, // Europe/Copenhagen
    {   83, 2338,   50058, 14, }, // Europe/Dublin
    {   83, 6307,   50072, 20, }, // Europe/Gibraltar
    {   83, 8788,   50092, 16, }, // Europe/Guernsey
    {   83, 6612,   50108, 18, }, // Europe/Helsinki
    {   83, 8804,   50126, 28, }, // Europe/Isle_of_Man
    {   83, 1130,   50154, 22, }, // Europe/Istanbul
    {   83, 8823,   50176, 10, }, // Europe/Jersey
    {   83, 3979,   50186, 24, }, // Europe/Kaliningrad
    {   83, 8929,   50210, 12, }, // Europe/Kirov
    {   83, 2527,   50222, 12, }, // Europe/Kyiv
    {   83, 3213,   50234, 16, }, // Europe/Lisbon
    {   83, 6506,   50250, 16, }, // Europe/Ljubljana
    {   83, 2501,   50266, 16, }, // Europe/London
    {   83, 6365,   50282, 26, }, // Europe/Luxembourg
    {   83, 4892,   50308, 14, }, // Europe/Madrid
    {   83, 6397,   50322, 10, }, // Europe/Malta
    {   83, 6582,   50332, 22, }, // Europe/Mariehamn
    {   83, 3693,   50354, 16, }, // Europe/Minsk
    {   83, 6410,   50370, 10, }, // Europe/Monaco
    {   83, 3537,   50380, 12, }, // Europe/Moscow
    {   83, 6458,   50392, 12, }, // Europe/Oslo
    {   83, 4284,   50404, 14, }, // Europe/Paris
    {   83, 6424,   50418, 18, }, // Europe/Podgorica
    {   83, 6275,   50436, 10, }, // Europe/Prague
    {   83, 8837,   46902,  6, }, // Europe/Riga
    {   83, 6324,   50446,  8, }, // Europe/Rome
    {   83, 4331,   50454,  6, }, // Europe/Samara
    {   83, 6470,   50460, 19, }, // Europe/San_Marino
    {   83, 6245,   50479, 12, }, // Europe/Sarajevo
    {   83, 8849,   50491, 24, }, // Europe/Simferopol
    {   83, 6383,   50515, 16, }, // Europe/Skopje
    {   83, 6599,   50531, 10, }, // Europe/Sofia
    {   83, 6523,   50541, 20, }, // Europe/Stockholm
    {   83, 8867,   50561, 10, }, // Europe/Tallinn
    {   83, 6202,   50571,  8, }, // Europe/Tirane
    {   83, 8882,   50579, 26, }, // Europe/Ulyanovsk
    {   83, 6352,   50605, 10, }, // Europe/Vaduz
    {   83, 6567,   50615, 12, }, // Europe/Vatican
    {   83, 6231,   49341, 10, }, // Europe/Vienna
    {   83, 8899,   50627, 18, }, // Europe/Vilnius
    {   83, 4727,   50645, 22, }, // Europe/Volgograd
    {   83, 3190,   50667, 10, }, // Europe/Warsaw
    {   83, 6261,   50677, 14, }, // Europe/Zagreb
    {   83, 6540,   50691, 12, }, // Europe/Zurich
    {   83, 5078,   50703, 20, }, // Indian/Antananarivo
    {   83, 6947,   50723, 10, }, // Indian/Chagos
    {   83, 6046,   50733, 33, }, // Indian/Christmas
    {   83, 6063,   50766, 12, }, // Indian/Cocos
    {   83, 5029,   50778, 12, }, // Indian/Comoro
    {   83, 6661,   50790, 18, }, // Indian/Kerguelen
    {   83, 7260,   50808,  6, }, // Indian/Mahe
    {   83, 7050,   50814, 14, }, // Indian/Maldives
    {   83, 4069,   50828, 14, }, // Indian/Mauritius
    {   83, 5098,   50842, 10, }, // Indian/Mayotte
    {   83, 7211,   50852, 24, }, // Indian/Reunion
    {   83, 4422,   50876,  8, }, // Pacific/Apia
    {   83,  932,   50884, 22, }, // Pacific/Auckland
    {   83, 3706,   50906, 20, }, // Pacific/Bougainville
    {   83, 3015,   50926, 12, }, // Pacific/Chatham
    {   83, 3157,   50938, 12, }, // Pacific/Chuuk
    {   83, 2237,   50950, 14, }, // Pacific/Easter
    {   83, 7360,   50964, 10, }, // Pacific/Efate
    {   83, 7327,   50974, 16, }, // Pacific/Fakaofo
    {   83, 3902,   50990,  8, }, // Pacific/Fiji
    {   83, 7343,   50998, 14, }, // Pacific/Funafuti
    {   83, 6678,   51012, 22, }, // Pacific/Galapagos
    {   83, 6696,   51034, 18, }, // Pacific/Gambier
    {   83, 3822,   51052, 20, }, // Pacific/Guadalcanal
    {   83, 6018,   51072,  8, }, // Pacific/Guam
    {   83, 2723,   51080, 16, }, // Pacific/Honolulu
    {   83, 3049,   51096, 20, }, // Pacific/Kanton
    {   83, 3998,   51116, 18, }, // Pacific/Kiritimati
    {   83, 7019,   51134, 14, }, // Pacific/Kosrae
    {   83, 2842,   51148, 16, }, // Pacific/Kwajalein
    {   83, 4877,   51164, 10, }, // Pacific/Majuro
    {   83, 4051,   51174, 16, }, // Pacific/Marquesas
    {   83, 8914,   51190, 16, }, // Pacific/Midway
    {   83, 7084,   51206, 10, }, // Pacific/Nauru
    {   83, 7132,   51216, 12, }, // Pacific/Niue
    {   83, 4168,   51228, 16, }, // Pacific/Norfolk
    {   83, 7098,   51244, 10, }, // Pacific/Noumea
    {   83, 3126,   51254, 21, }, // Pacific/Pago_Pago
    {   83, 7155,   51275,  8, }, // Pacific/Palau
    {   83, 7194,   51283, 22, }, // Pacific/Pitcairn
    {   83, 3096,   51305, 10, }, // Pacific/Pohnpei
    {   83, 4807,   51315, 29, }, // Pacific/Port_Moresby
    {   83, 6076,   51344, 14, }, // Pacific/Rarotonga
    {   83, 6031,   51358, 10, }, // Pacific/Saipan
    {   83, 7312,   51368, 10, }, // Pacific/Tahiti
    {   83, 6712,   51378,  6, }, // Pacific/Tarawa
    {   83, 4583,   51384, 14, }, // Pacific/Tongatapu
    {   83, 7392,   51398, 12, }, // Pacific/Wake
    {   83, 7405,   51410, 12, }, // Pacific/Wallis
    {   85, 6788,   36214,  7, }, // Africa/Abidjan Chechen/Cyrillic/Russia
    {   85, 6760,     492,  5, }, // Africa/Accra
    {   85, 5059,     497, 11, }, // Africa/Addis_Ababa
    {   85, 7420,     508,  5, }, // Africa/Algiers
    {   85,   14,     513,  6, }, // Africa/Asmara
    {   85,   44,     519,  6, }, // Africa/Bamako
    {   85, 5257,     525,  5, }, // Africa/Bangui
    {   85, 6746,     530,  6, }, // Africa/Banjul
    {   85, 7435,     536,  5, }, // Africa/Bissau
    {   85, 4957,   27088,  8, }, // Africa/Blantyre
    {   85, 5287,   51422, 10, }, // Africa/Brazzaville
    {   85, 4922,     558,  9, }, // Africa/Bujumbura
    {   85, 2320,   51432,  8, }, // Africa/Cairo
    {   85, 4117,     571, 10, }, // Africa/Casablanca
    {   85, 7449,     581,  5, }, // Africa/Ceuta
    {   85, 6773,     586,  7, }, // Africa/Conakry
    {   85, 6840,     593,  5, }, // Africa/Dakar
    {   85, 5130,   27116, 12, }, // Africa/Dar_es_Salaam
    {   85, 5043,   36247,  7, }, // Africa/Djibouti
    {   85, 5243,     616,  5, }, // Africa/Douala
    {   85, 5166,   27135,  7, }, // Africa/El_Aaiun
    {   85, 6853,     628,  7, }, // Africa/Freetown
    {   85, 4906,     635,  8, }, // Africa/Gaborone
    {   85, 5015,   33781,  6, }, // Africa/Harare
    {   85, 4479,   51440, 12, }, // Africa/Johannesburg
    {   85, 4499,   27173,  5, }, // Africa/Juba
    {   85, 5151,     665,  7, }, // Africa/Kampala
    {   85, 4524,     672,  6, }, // Africa/Khartoum
    {   85, 4973,     678,  6, }, // Africa/Kigali
    {   85, 5306,     684,  7, }, // Africa/Kinshasa
    {   85, 4744,     691,  5, }, // Africa/Lagos
    {   85, 5336,   51452,  9, }, // Africa/Libreville
    {   85, 6869,     704,  4, }, // Africa/Lome
    {   85, 5211,     708,  6, }, // Africa/Luanda
    {   85, 4939,     714,  9, }, // Africa/Lubumbashi
    {   85, 5001,     723,  6, }, // Africa/Lusaka
    {   85, 5322,     729,  6, }, // Africa/Malabo
    {   85, 4987,     735,  6, }, // Africa/Maputo
    {   85, 5197,     741,  6, }, // Africa/Maseru
    {   85, 5182,     747,  7, }, // Africa/Mbabane
    {   85, 5113,     754,  8, }, // Africa/Mogadishu
    {   85, 7034,     762,  7, }, // Africa/Monrovia
    {   85, 3853,   36295,  7, }, // Africa/Nairobi
    {   85, 5271,   27254,  8, }, // Africa/Ndjamena
    {   85, 5354,   36302,  6, }, // Africa/Niamey
    {   85, 6803,     790,  7, }, // Africa/Nouakchott
    {   85, 6727,     797,  8, }, // Africa/Ouagadougou
    {   85, 5225,     805, 10, }, // Africa/Porto-Novo
    {   85, 4435,     815,  8, }, // Africa/Sao_Tome
    {   85, 2866,     823,  7, }, // Africa/Tripoli
    {   85, 6554,     830,  5, }, // Africa/Tunis
    {   85, 4152,     835,  7, }, // Africa/Windhoek
    {   85,  132,     842,  4, }, // America/Adak
    {   85, 3346,   51461,  8, }, // America/Anchorage
    {   85, 5607,   51469,  7, }, // America/Anguilla
    {   85, 5624,     860,  7, }, // America/Antigua
    {   85, 4554,     867,  9, }, // America/Araguaina
    {   85,  166,   51476, 12, }, // America/Argentina/Buenos_Aires
    {   85,   91,     888,  9, }, // America/Argentina/Catamarca
    {   85,  270,     897,  7, }, // America/Argentina/Cordoba
    {   85,  441,   27355,  5, }, // America/Argentina/Jujuy
    {   85, 7462,     909,  8, }, // America/Argentina/La_Rioja
    {   85,  565,     917,  7, }, // America/Argentina/Mendoza
    {   85, 7489,   51488, 12, }, // America/Argentina/Rio_Gallegos
    {   85, 7520,   27380,  6, }, // America/Argentina/Salta
    {   85, 7544,     940,  8, }, // America/Argentina/San_Juan
    {   85, 5580,     948,  8, }, // America/Argentina/San_Luis
    {   85, 7571,     956,  7, }, // America/Argentina/Tucuman
    {   85, 7597,   27394,  5, }, // America/Argentina/Ushuaia
    {   85, 5640,     969,  5, }, // America/Aruba
    {   85, 4252,   51500,  8, }, // America/Asuncion
    {   85,  237,     981, 12, }, // America/Atikokan
    {   85, 3679,     993,  3, }, // America/Bahia
    {   85, 7623,   51508, 16, }, // America/Bahia_Banderas
    {   85, 5654,    1013,  8, }, // America/Barbados
    {   85, 7646,    1021,  5, }, // America/Belem
    {   85, 5407,    1026,  5, }, // America/Belize
    {   85, 7660,    1031, 12, }, // America/Blanc-Sablon
    {   85, 7681,    1043,  9, }, // America/Boa_Vista
    {   85, 4361,    1052,  6, }, // America/Bogota
    {   85, 7699,   51524,  5, }, // America/Boise
    {   85, 7713,   51529, 13, }, // America/Cambridge_Bay
    {   85, 7735,    1075, 12, }, // America/Campo_Grande
    {   85, 3868,    1087,  6, }, // America/Cancun
    {   85, 4694,    1093,  7, }, // America/Caracas
    {   85, 4345,   51542,  7, }, // America/Cayenne
    {   85, 5496,   27497,  6, }, // America/Cayman
    {   85, 2260,    1129,  6, }, // America/Chicago
    {   85, 7756,    1135,  6, }, // America/Chihuahua
    {   85, 7774,      53, 13, }, // America/Ciudad_Juarez
    {   85, 5422,    1141, 10, }, // America/Costa_Rica
    {   85, 7796,    1151,  7, }, // America/Creston
    {   85, 3791,   27556,  5, }, // America/Cuiaba
    {   85, 5723,   36474,  7, }, // America/Curacao
    {   85, 7812,    1172, 12, }, // America/Danmarkshavn
    {   85, 7833,    1184,  6, }, // America/Dawson
    {   85, 7848,    1190, 11, }, // America/Dawson_Creek
    {   85,  805,    1201,  6, }, // America/Denver
    {   85, 3465,   36517,  7, }, // America/Detroit
    {   85, 5739,    1214,  8, }, // America/Dominica
    {   85,  893,   51549,  8, }, // America/Edmonton
    {   85, 7869,   51557,  8, }, // America/Eirunepe
    {   85, 5441,   27633,  9, }, // America/El_Salvador
    {   85, 7886,   51565, 12, }, // America/Fort_Nelson
    {   85, 7906,    1257,  9, }, // America/Fortaleza
    {   85, 7924,   51577,  9, }, // America/Glace_Bay
    {   85, 6881,   51586,  7, }, // America/Goose_Bay
    {   85, 4612,   34146, 10, }, // America/Grand_Turk
    {   85, 5770,    1292,  7, }, // America/Grenada
    {   85, 5786,    1299,  9, }, // America/Guadeloupe
    {   85, 3760,    1308,  9, }, // America/Guatemala
    {   85, 4841,   51593,  8, }, // America/Guayaquil
    {   85, 6932,   51601,  6, }, // America/Guyana
    {   85, 1939,   51607,  8, }, // America/Halifax
    {   85, 2281,    1339,  6, }, // America/Havana
    {   85, 7942,   51615,  9, }, // America/Hermosillo
    {   85,  348,    1353, 12, }, // America/Indiana/Indianapolis
    {   85,  481,    1365,  4, }, // America/Indiana/Knox
    {   85, 7961,    1378,  7, }, // America/Indiana/Marengo
    {   85, 7985,   34233, 10, }, // America/Indiana/Petersburg
    {   85, 8012,    1413,  9, }, // America/Indiana/Tell_City
    {   85, 8038,   51624,  5, }, // America/Indiana/Vevay
    {   85, 8060,   36607,  7, }, // America/Indiana/Vincennes
    {   85, 8086,   34304,  7, }, // America/Indiana/Winamac
    {   85, 8110,    1452,  6, }, // America/Inuvik
    {   85,  660,    1458,  7, }, // America/Iqaluit
    {   85, 2799,   27879,  6, }, // America/Jamaica
    {   85, 5380,   36614,  5, }, // America/Juneau
    {   85,  521,    1476,  8, }, // America/Kentucky/Louisville
    {   85, 8125,    1484, 10, }, // America/Kentucky/Monticello
    {   85, 5704,   36619, 10, }, // America/Kralendijk
    {   85, 4376,    1514,  6, }, // America/La_Paz
    {   85, 7169,    1520,  4, }, // America/Lima
    {   85, 3239,   51629, 12, }, // America/Los_Angeles
    {   85, 5932,   51641, 21, }, // America/Lower_Princes
    {   85, 8153,   36667,  6, }, // America/Maceio
    {   85, 8168,    1559,  7, }, // America/Managua
    {   85, 1908,    1566,  6, }, // America/Manaus
    {   85, 5897,    1572,  6, }, // America/Marigot
    {   85, 5805,    1578,  9, }, // America/Martinique
    {   85, 8184,    1587,  9, }, // America/Matamoros
    {   85, 2917,    1596,  8, }, // America/Mazatlan
    {   85, 8202,    1604,  8, }, // America/Menominee
    {   85, 8220,    1612,  6, }, // America/Merida
    {   85, 8235,    1618, 10, }, // America/Metlakatla
    {   85, 2949,    1628,  6, }, // America/Mexico_City
    {   85, 4391,    1634,  7, }, // America/Miquelon
    {   85, 8254,    1641,  7, }, // America/Moncton
    {   85, 8270,   51662,  9, }, // America/Monterrey
    {   85, 4098,    1657, 10, }, // America/Montevideo
    {   85, 5824,   51671,  9, }, // America/Montserrat
    {   85, 5481,    1677,  6, }, // America/Nassau
    {   85, 2379,   51680,  8, }, // America/New_York
    {   85, 8288,    1691,  3, }, // America/Nome
    {   85, 1850,   51688,  7, }, // America/Noronha
    {   85, 8301,   51695, 24, }, // America/North_Dakota/Beulah
    {   85, 8329,   51719, 22, }, // America/North_Dakota/Center
    {   85, 8357,   51741,  9, }, // America/North_Dakota/New_Salem
    {   85,  393,   51750,  6, }, // America/Nuuk
    {   85, 8388,    1776,  7, }, // America/Ojinaga
    {   85, 2356,    1783,  6, }, // America/Panama
    {   85, 6173,    1789, 10, }, // America/Paramaribo
    {   85, 2973,    1799,  6, }, // America/Phoenix
    {   85, 3945,    1805, 12, }, // America/Port-au-Prince
    {   85, 5954,   28189, 13, }, // America/Port_of_Spain
    {   85, 8404,   28202, 11, }, // America/Porto_Velho
    {   85, 5843,   51756, 11, }, // America/Puerto_Rico
    {   85, 4030,    1852, 12, }, // America/Punta_Arenas
    {   85, 8424,    1864, 12, }, // America/Rankin_Inlet
    {   85, 8445,    1876,  6, }, // America/Recife
    {   85, 1995,   51767,  8, }, // America/Regina
    {   85, 8460,   36760,  7, }, // America/Resolute
    {   85,  695,    1897, 10, }, // America/Rio_Branco
    {   85, 8477,    1907,  8, }, // America/Santarem
    {   85, 2201,   51775,  8, }, // America/Santiago
    {   85, 6111,    1923, 13, }, // America/Santo_Domingo
    {   85, 1878,    1936,  9, }, // America/Sao_Paulo
    {   85, 6899,    1945, 11, }, // America/Scoresbysund
    {   85, 8494,    1956,  5, }, // America/Sitka
    {   85, 8508,   51783, 13, }, // America/St_Barthelemy
    {   85, 2061,   28349, 10, }, // America/St_Johns
    {   85, 5863,    1983,  9, }, // America/St_Kitts
    {   85, 5880,   51796,  9, }, // America/St_Lucia
    {   85,  855,    2003, 10, }, // America/St_Thomas
    {   85, 5913,    2013, 12, }, // America/St_Vincent
    {   85, 8530,   51805, 12, }, // America/Swift_Current
    {   85, 5461,   51817, 12, }, // America/Tegucigalpa
    {   85, 5756,    2049,  4, }, // America/Thule
    {   85,  313,    2053,  7, }, // America/Tijuana
    {   85,  608,    2060,  7, }, // America/Toronto
    {   85, 5688,    2067,  7, }, // America/Tortola
    {   85, 2093,    2074,  8, }, // America/Vancouver
    {   85, 2144,   28435,  8, }, // America/Whitehorse
    {   85,  734,    2090,  8, }, // America/Winnipeg
    {   85, 8552,   28450,  6, }, // America/Yakutat
    {   85, 6001,   36889,  5, }, // Antarctica/Casey
    {   85, 6094,   36894,  6, }, // Antarctica/Davis
    {   85, 6133,   51829, 14, }, // Antarctica/DumontDUrville
    {   85, 8568,    2131,  8, }, // Antarctica/Macquarie
    {   85, 7066,    2139,  6, }, // Antarctica/Mawson
    {   85, 7113,    2145,  9, }, // Antarctica/McMurdo
    {   85, 8589,    2154,  6, }, // Antarctica/Palmer
    {   85, 7226,    2160,  6, }, // Antarctica/Rothera
    {   85, 7295,   28510,  4, }, // Antarctica/Syowa
    {   85, 8607,   51843,  6, }, // Antarctica/Troll
    {   85, 7374,   34825,  6, }, // Antarctica/Vostok
    {   85, 1429,   51849,  7, }, // Arctic/Longyearbyen
    {   85, 5570,    2192,  4, }, // Asia/Aden
    {   85, 5395,   51856,  8, }, // Asia/Almaty
    {   85, 3968,   51864,  6, }, // Asia/Amman
    {   85, 5511,   51870,  7, }, // Asia/Anadyr
    {   85, 5523,    2213,  5, }, // Asia/Aqtau
    {   85, 5368,    2218,  6, }, // Asia/Aqtobe
    {   85,  964,    2224,  7, }, // Asia/Ashgabat
    {   85, 8624,   51877,  6, }, // Asia/Atyrau
    {   85, 3607,   51883,  7, }, // Asia/Baghdad
    {   85, 5534,   36948,  7, }, // Asia/Bahrain
    {   85, 3653,   51890,  5, }, // Asia/Baku
    {   85, 4466,    2254,  7, }, // Asia/Bangkok
    {   85, 3571,    2261,  7, }, // Asia/Barnaul
    {   85, 4086,   28563,  6, }, // Asia/Beirut
    {   85, 3778,    2274,  6, }, // Asia/Bishkek
    {   85, 5989,   28575,  6, }, // Asia/Brunei
    {   85, 4601,    2286,  4, }, // Asia/Chita
    {   85, 4511,    2290,  7, }, // Asia/Colombo
    {   85, 4540,   51895,  7, }, // Asia/Damascus
    {   85, 1093,    2303,  5, }, // Asia/Dhaka
    {   85, 6192,    2308,  4, }, // Asia/Dili
    {   85, 3596,   28596,  5, }, // Asia/Dubai
    {   85, 6159,    2317,  7, }, // Asia/Dushanbe
    {   85, 8636,    2324,  9, }, // Asia/Famagusta
    {   85, 8651,    2333,  4, }, // Asia/Gaza
    {   85, 4795,    2337,  6, }, // Asia/Hebron
    {   85, 1259,    2343,  7, }, // Asia/Ho_Chi_Minh
    {   85, 2704,   51902,  7, }, // Asia/Hong_Kong
    {   85, 4771,    2357,  4, }, // Asia/Hovd
    {   85, 4184,    2361,  7, }, // Asia/Irkutsk
    {   85, 7006,   28638,  8, }, // Asia/Jakarta
    {   85, 6992,   51909,  7, }, // Asia/Jayapura
    {   85, 1290,   51916, 11, }, // Asia/Jerusalem
    {   85, 3560,    2392,  5, }, // Asia/Kabul
    {   85, 4316,   51927, 23, }, // Asia/Kamchatka
    {   85, 4239,    2422,  6, }, // Asia/Karachi
    {   85, 1185,    2428,  8, }, // Asia/Kathmandu
    {   85, 8661,    2436,  7, }, // Asia/Khandyga
    {   85,  992,   51950,  9, }, // Asia/Kolkata
    {   85, 4197,   36978, 10, }, // Asia/Krasnoyarsk
    {   85, 4859,    2462, 12, }, // Asia/Kuala_Lumpur
    {   85, 5976,    2474,  6, }, // Asia/Kuching
    {   85, 5547,   28693,  6, }, // Asia/Kuwait
    {   85, 1211,    2486,  5, }, // Asia/Macau
    {   85, 4017,    2491,  7, }, // Asia/Magadan
    {   85, 1349,    2498,  7, }, // Asia/Makassar
    {   85, 7182,    2505,  6, }, // Asia/Manila
    {   85, 6920,    2511,  6, }, // Asia/Muscat
    {   85, 2554,    2517,  6, }, // Asia/Nicosia
    {   85, 8675,    2524, 11, }, // Asia/Novokuznetsk
    {   85, 4135,    2535, 11, }, // Asia/Novosibirsk
    {   85, 4229,    2546,  4, }, // Asia/Omsk
    {   85, 7145,   35006,  4, }, // Asia/Oral
    {   85, 6961,   51959,  8, }, // Asia/Phnom_Penh
    {   85, 8693,    2563,  9, }, // Asia/Pontianak
    {   85, 4214,   28763,  7, }, // Asia/Pyongyang
    {   85, 5559,    2579,  5, }, // Asia/Qatar
    {   85, 4269,    2592,  9, }, // Asia/Qyzylorda
    {   85, 3584,   51967,  7, }, // Asia/Riyadh
    {   85, 4408,   51974, 12, }, // Asia/Sakhalin
    {   85, 7245,    2621,  9, }, // Asia/Samarkand
    {   85, 3279,    2630,  4, }, // Asia/Seoul
    {   85, 1053,   28801,  6, }, // Asia/Shanghai
    {   85, 3300,    2640,  8, }, // Asia/Singapore
    {   85, 4297,    2648, 13, }, // Asia/Srednekolymsk
    {   85, 3263,   28829,  6, }, // Asia/Taipei
    {   85, 4781,    2667,  7, }, // Asia/Tashkent
    {   85, 3915,   35074,  7, }, // Asia/Tbilisi
    {   85, 2772,   51986,  7, }, // Asia/Tehran
    {   85, 1317,   35088,  5, }, // Asia/Thimphu
    {   85, 2821,    2692,  5, }, // Asia/Tokyo
    {   85, 4572,    2697,  5, }, // Asia/Tomsk
    {   85, 1021,    2702, 10, }, // Asia/Ulaanbaatar
    {   85, 1159,    2712,  6, }, // Asia/Urumqi
    {   85, 8722,   51993,  9, }, // Asia/Ust-Nera
    {   85, 6977,   52002,  8, }, // Asia/Vientiane
    {   85, 4710,    2733, 11, }, // Asia/Vladivostok
    {   85, 4828,   37051,  6, }, // Asia/Yakutsk
    {   85, 1235,   28911,  6, }, // Asia/Yangon
    {   85, 3883,    2757, 12, }, // Asia/Yekaterinburg
    {   85, 3747,    2769,  6, }, // Asia/Yerevan
    {   85, 3663,   52010, 16, }, // Atlantic/Azores
    {   85, 5671,   52026,  8, }, // Atlantic/Bermuda
    {   85, 6628,   52034, 17, }, // Atlantic/Canary
    {   85, 3727,    2826, 10, }, // Atlantic/Cape_Verde
    {   85, 1395,   52051, 18, }, // Atlantic/Faroe
    {   85, 8736,   52069, 13, }, // Atlantic/Madeira
    {   85, 2748,   52082,  9, }, // Atlantic/Reykjavik
    {   85, 7272,   52091, 14, }, // Atlantic/South_Georgia
    {   85, 6821,   52105, 19, }, // Atlantic/St_Helena
    {   85, 6644,   52124,  6, }, // Atlantic/Stanley
    {   85, 1670,    2917,  8, }, // Australia/Adelaide
    {   85, 1635,    2925,  7, }, // Australia/Brisbane
    {   85, 1799,    2932, 11, }, // Australia/Broken_Hill
    {   85, 1583,    2943,  6, }, // Australia/Darwin
    {   85, 3637,   29108,  4, }, // Australia/Eucla
    {   85, 1516,    2954,  6, }, // Australia/Hobart
    {   85, 8753,    2960,  8, }, // Australia/Lindeman
    {   85, 1547,   52130, 14, }, // Australia/Lord_Howe
    {   85, 1727,   29120,  8, }, // Australia/Melbourne
    {   85, 1762,    2983,  4, }, // Australia/Perth
    {   85, 1463,   52144,  6, }, // Australia/Sydney
    {   85, 6441,    2993,  9, }, // Europe/Amsterdam
    {   85, 6216,    3002,  7, }, // Europe/Andorra
    {   85, 3620,   52150,  9, }, // Europe/Astrakhan
    {   85, 2300,   52159,  5, }, // Europe/Athens
    {   85, 6336,    3021,  7, }, // Europe/Belgrade
    {   85, 4757,    3028,  6, }, // Europe/Berlin
    {   85, 6488,    3034, 10, }, // Europe/Bratislava
    {   85, 2167,   52164,  8, }, // Europe/Brussels
    {   85, 3928,    3052,  8, }, // Europe/Bucharest
    {   85, 3806,    3060,  8, }, // Europe/Budapest
    {   85, 8772,   52172, 19, }, // Europe/Busingen
    {   85, 2583,    3091,  7, }, // Europe/Chisinau
    {   85, 6289,   52191, 10, }, // Europe/Copenhagen
    {   85, 2338,    3108,  6, }, // Europe/Dublin
    {   85, 6307,    3114,  9, }, // Europe/Gibraltar
    {   85, 8788,    3123,  6, }, // Europe/Guernsey
    {   85, 6612,   52201,  9, }, // Europe/Helsinki
    {   85, 8804,   52210,  9, }, // Europe/Isle_of_Man
    {   85, 1130,    3146,  7, }, // Europe/Istanbul
    {   85, 8823,   52219,  6, }, // Europe/Jersey
    {   85, 3979,    3158, 11, }, // Europe/Kaliningrad
    {   85, 8929,    3169,  5, }, // Europe/Kirov
    {   85, 2527,    3174,  4, }, // Europe/Kyiv
    {   85, 3213,    3178,  8, }, // Europe/Lisbon
    {   85, 6506,   29300,  7, }, // Europe/Ljubljana
    {   85, 2501,    3195,  6, }, // Europe/London
    {   85, 6365,   29313, 10, }, // Europe/Luxembourg
    {   85, 4892,    3212,  6, }, // Europe/Madrid
    {   85, 6397,   29329,  6, }, // Europe/Malta
    {   85, 6582,    3223,  9, }, // Europe/Mariehamn
    {   85, 3693,    3232,  5, }, // Europe/Minsk
    {   85, 6410,    3237,  6, }, // Europe/Monaco
    {   85, 3537,    3243,  6, }, // Europe/Moscow
    {   85, 6458,    3249,  4, }, // Europe/Oslo
    {   85, 4284,    3253,  5, }, // Europe/Paris
    {   85, 6424,    3258,  9, }, // Europe/Podgorica
    {   85, 6275,    3267,  5, }, // Europe/Prague
    {   85, 8837,    3272,  4, }, // Europe/Riga
    {   85, 6324,    3276,  3, }, // Europe/Rome
    {   85, 4331,    3279,  6, }, // Europe/Samara
    {   85, 6470,    3285, 10, }, // Europe/San_Marino
    {   85, 6245,    3295,  7, }, // Europe/Sarajevo
    {   85, 4451,    3302,  7, }, // Europe/Saratov
    {   85, 8849,   52225, 11, }, // Europe/Simferopol
    {   85, 6383,   52236,  6, }, // Europe/Skopje
    {   85, 6599,    3324,  4, }, // Europe/Sofia
    {   85, 6523,   52242,  9, }, // Europe/Stockholm
    {   85, 8867,    3337,  6, }, // Europe/Tallinn
    {   85, 6202,    3343,  6, }, // Europe/Tirane
    {   85, 8882,   52251,  9, }, // Europe/Ulyanovsk
    {   85, 6352,    3358,  5, }, // Europe/Vaduz
    {   85, 6567,    3363,  7, }, // Europe/Vatican
    {   85, 6231,    3370,  4, }, // Europe/Vienna
    {   85, 8899,   52260,  7, }, // Europe/Vilnius
    {   85, 4727,    3381,  9, }, // Europe/Volgograd
    {   85, 3190,    3390,  7, }, // Europe/Warsaw
    {   85, 6261,    3397,  6, }, // Europe/Zagreb
    {   85, 6540,   37310,  5, }, // Europe/Zurich
    {   85, 5078,    3409, 12, }, // Indian/Antananarivo
    {   85, 6947,    3421,  5, }, // Indian/Chagos
    {   85, 6046,   52267, 31, }, // Indian/Christmas
    {   85, 6063,   52298, 16, }, // Indian/Cocos
    {   85, 5029,   52314, 18, }, // Indian/Comoro
    {   85, 6661,    3460,  8, }, // Indian/Kerguelen
    {   85, 7260,   29562,  3, }, // Indian/Mahe
    {   85, 7050,   52332,  9, }, // Indian/Maldives
    {   85, 4069,    3477,  7, }, // Indian/Mauritius
    {   85, 5098,   52341,  7, }, // Indian/Mayotte
    {   85, 7211,   52348,  7, }, // Indian/Reunion
    {   85, 4422,    3498,  3, }, // Pacific/Apia
    {   85,  932,    3502,  6, }, // Pacific/Auckland
    {   85, 3706,   52355, 15, }, // Pacific/Bougainville
    {   85, 3015,   52370, 11, }, // Pacific/Chatham
    {   85, 3157,   52381, 12, }, // Pacific/Chuuk
    {   85, 2237,   52393, 16, }, // Pacific/Easter
    {   85, 7360,   52409,  5, }, // Pacific/Efate
    {   85, 7327,    3541,  7, }, // Pacific/Fakaofo
    {   85, 3902,   37407,  5, }, // Pacific/Fiji
    {   85, 7343,    3552,  8, }, // Pacific/Funafuti
    {   85, 6678,   52414, 21, }, // Pacific/Galapagos
    {   85, 6696,   52435, 15, }, // Pacific/Gambier
    {   85, 3822,   35587, 11, }, // Pacific/Guadalcanal
    {   85, 6018,    3606,  4, }, // Pacific/Guam
    {   85, 2723,   52450,  8, }, // Pacific/Honolulu
    {   85, 3049,   52458, 16, }, // Pacific/Kanton
    {   85, 3998,    3616, 10, }, // Pacific/Kiritimati
    {   85, 7019,    3626,  6, }, // Pacific/Kosrae
    {   85, 2842,   29709, 10, }, // Pacific/Kwajalein
    {   85, 4877,   37442,  7, }, // Pacific/Majuro
    {   85, 4051,   52474, 16, }, // Pacific/Marquesas
    {   85, 8914,   52490, 14, }, // Pacific/Midway
    {   85, 7084,    3680,  5, }, // Pacific/Nauru
    {   85, 7132,   52504,  4, }, // Pacific/Niue
    {   85, 4168,    3689,  7, }, // Pacific/Norfolk
    {   85, 7098,    3696,  5, }, // Pacific/Noumea
    {   85, 3126,    3701,  9, }, // Pacific/Pago_Pago
    {   85, 7155,    3710,  5, }, // Pacific/Palau
    {   85, 7194,    3715,  7, }, // Pacific/Pitcairn
    {   85, 3096,   52508, 14, }, // Pacific/Pohnpei
    {   85, 4807,    3728, 11, }, // Pacific/Port_Moresby
    {   85, 6076,    3739,  9, }, // Pacific/Rarotonga
    {   85, 6031,   29803,  6, }, // Pacific/Saipan
    {   85, 7312,   52522, 13, }, // Pacific/Tahiti
    {   85, 6712,    3759,  6, }, // Pacific/Tarawa
    {   85, 4583,    3765,  9, }, // Pacific/Tongatapu
    {   85, 7392,   52535, 10, }, // Pacific/Wake
    {   85, 7405,    3778,  6, }, // Pacific/Wallis
    {   86, 6788,   52545,  4, }, // Africa/Abidjan Cherokee/Cherokee/United States
    {   86, 6760,   52549,  2, }, // Africa/Accra
    {   86, 5059,   52551,  7, }, // Africa/Addis_Ababa
    {   86, 7420,   52558,  4, }, // Africa/Algiers
    {   86,   14,   52562,  4, }, // Africa/Asmara
    {   86,   44,   52566,  3, }, // Africa/Bamako
    {   86, 5257,   52569,  4, }, // Africa/Bangui
    {   86, 6746,   52573,  4, }, // Africa/Banjul
    {   86, 7435,   52577,  3, }, // Africa/Bissau
    {   86, 4957,   52580,  3, }, // Africa/Blantyre
    {   86, 5287,   52583,  4, }, // Africa/Brazzaville
    {   86, 4922,   52587,  5, }, // Africa/Bujumbura
    {   86, 2320,   52592,  3, }, // Africa/Cairo
    {   86, 4117,   52595,  8, }, // Africa/Casablanca
    {   86, 7449,   52603,  2, }, // Africa/Ceuta
    {   86, 6773,   52605,  3, }, // Africa/Conakry
    {   86, 6840,   52608,  3, }, // Africa/Dakar
    {   86, 5130,   52611,  8, }, // Africa/Dar_es_Salaam
    {   86, 5043,   52619,  3, }, // Africa/Djibouti
    {   86, 5243,   52622,  4, }, // Africa/Douala
    {   86, 5166,   52626,  7, }, // Africa/El_Aaiun
    {   86, 6853,   52633,  7, }, // Africa/Freetown
    {   86, 4906,   52640,  4, }, // Africa/Gaborone
    {   86, 5015,   52644,  3, }, // Africa/Harare
    {   86, 4479,   52647,  6, }, // Africa/Johannesburg
    {   86, 4499,   52653,  2, }, // Africa/Juba
    {   86, 5151,   52655,  4, }, // Africa/Kampala
    {   86, 4524,   52659,  3, }, // Africa/Khartoum
    {   86, 4973,   52662,  3, }, // Africa/Kigali
    {   86, 5306,   52665,  4, }, // Africa/Kinshasa
    {   86, 4744,   52669,  3, }, // Africa/Lagos
    {   86, 5336,   52672,  4, }, // Africa/Libreville
    {   86, 6869,   52676,  2, }, // Africa/Lome
    {   86, 5211,   52678,  4, }, // Africa/Luanda
    {   86, 4939,   52682,  4, }, // Africa/Lubumbashi
    {   86, 5001,   52686,  3, }, // Africa/Lusaka
    {   86, 5322,   52689,  3, }, // Africa/Malabo
    {   86, 4987,   52692,  3, }, // Africa/Maputo
    {   86, 5197,   52695,  3, }, // Africa/Maseru
    {   86, 5182,   52698,  3, }, // Africa/Mbabane
    {   86, 5113,   52701,  4, }, // Africa/Mogadishu
    {   86, 7034,   52705,  5, }, // Africa/Monrovia
    {   86, 3853,   52710,  4, }, // Africa/Nairobi
    {   86, 5271,   52714,  4, }, // Africa/Ndjamena
    {   86, 5354,   52718,  3, }, // Africa/Niamey
    {   86, 6803,   52721,  4, }, // Africa/Nouakchott
    {   86, 6727,   52725,  5, }, // Africa/Ouagadougou
    {   86, 5225,   52730, 11, }, // Africa/Porto-Novo
    {   86, 4435,   52741,  4, }, // Africa/Sao_Tome
    {   86, 2866,   52745,  3, }, // Africa/Tripoli
    {   86, 6554,   52748,  3, }, // Africa/Tunis
    {   86, 4152,   52751,  5, }, // Africa/Windhoek
    {   86,  132,   52756,  3, }, // America/Adak
    {   86, 3346,   52759,  5, }, // America/Anchorage
    {   86, 5607,   52764,  4, }, // America/Anguilla
    {   86, 5624,   52768,  3, }, // America/Antigua
    {   86, 4554,   52771,  6, }, // America/Araguaina
    {   86,  166,   52777,  7, }, // America/Argentina/Buenos_Aires
    {   86,   91,   52784,  4, }, // America/Argentina/Catamarca
    {   86,  270,   52788,  3, }, // America/Argentina/Cordoba
    {   86,  441,   52791,  3, }, // America/Argentina/Jujuy
    {   86, 7462,   52794,  5, }, // America/Argentina/La_Rioja
    {   86,  565,   52799,  4, }, // America/Argentina/Mendoza
    {   86, 7489,   52803,  8, }, // America/Argentina/Rio_Gallegos
    {   86, 7520,   52811,  3, }, // America/Argentina/Salta
    {   86, 7544,   52814,  5, }, // America/Argentina/San_Juan
    {   86, 5580,   52819,  8, }, // America/Argentina/San_Luis
    {   86, 7571,   52827,  4, }, // America/Argentina/Tucuman
    {   86, 7597,   52831,  4, }, // America/Argentina/Ushuaia
    {   86, 5640,   52835,  3, }, // America/Aruba
    {   86, 4252,   52838,  5, }, // America/Asuncion
    {   86,  237,   52843,  5, }, // America/Atikokan
    {   86, 3679,   52848,  3, }, // America/Bahia
    {   86, 7623,   52851,  9, }, // America/Bahia_Banderas
    {   86, 5654,   52860,  4, }, // America/Barbados
    {   86, 7646,   52864,  3, }, // America/Belem
    {   86, 5407,   52867,  3, }, // America/Belize
    {   86, 7660,   52870,  6, }, // America/Blanc-Sablon
    {   86, 7681,   52876,  9, }, // America/Boa_Vista
    {   86, 4361,   52885,  3, }, // America/Bogota
    {   86, 7699,   52888,  3, }, // America/Boise
    {   86, 7713,   52891, 10, }, // America/Cambridge_Bay
    {   86, 7735,   52901,  7, }, // America/Campo_Grande
    {   86, 3868,   52908,  4, }, // America/Cancun
    {   86, 4694,   52912,  4, }, // America/Caracas
    {   86, 4345,   52916,  3, }, // America/Cayenne
    {   86, 5496,   52919,  4, }, // America/Cayman
    {   86, 2260,   52923,  3, }, // America/Chicago
    {   86, 7756,   52926,  3, }, // America/Chihuahua
    {   86, 7774,   52929,  7, }, // America/Ciudad_Juarez
    {   86, 5422,   52936,  5, }, // America/Costa_Rica
    {   86, 7796,   52941,  4, }, // America/Creston
    {   86, 3791,   52945,  3, }, // America/Cuiaba
    {   86, 5723,   52948,  4, }, // America/Curacao
    {   86, 7812,   52952,  7, }, // America/Danmarkshavn
    {   86, 7833,   52959,  3, }, // America/Dawson
    {   86, 7848,   52962,  7, }, // America/Dawson_Creek
    {   86,  805,   52969,  8, }, // America/Denver
    {   86, 3465,   52977,  3, }, // America/Detroit
    {   86, 5739,   52980,  4, }, // America/Dominica
    {   86,  893,   52984,  6, }, // America/Edmonton
    {   86, 7869,   52990,  4, }, // America/Eirunepe
    {   86, 5441,   52994,  8, }, // America/El_Salvador
    {   86, 7886,   53002,  8, }, // America/Fort_Nelson
    {   86, 7906,   53010,  4, }, // America/Fortaleza
    {   86, 7924,   53014,  8, }, // America/Glace_Bay
    {   86, 6881,   53022,  8, }, // America/Goose_Bay
    {   86, 4612,   53030,  8, }, // America/Grand_Turk
    {   86, 5770,   53038,  3, }, // America/Grenada
    {   86, 5786,   53041,  4, }, // America/Guadeloupe
    {   86, 3760,   53045,  4, }, // America/Guatemala
    {   86, 4841,   53049,  4, }, // America/Guayaquil
    {   86, 6932,   53053,  3, }, // America/Guyana
    {   86, 1939,   53056,  5, }, // America/Halifax
    {   86, 2281,   53061,  3, }, // America/Havana
    {   86, 7942,   53064,  4, }, // America/Hermosillo
    {   86,  348,   53068,  9, }, // America/Indiana/Indianapolis
    {   86,  481,   53077, 10, }, // America/Indiana/Knox
    {   86, 7961,   53087, 11, }, // America/Indiana/Marengo
    {   86, 7985,   53098, 11, }, // America/Indiana/Petersburg
    {   86, 8012,   53109, 13, }, // America/Indiana/Tell_City
    {   86, 8038,   53122,  9, }, // America/Indiana/Vevay
    {   86, 8060,   53131, 12, }, // America/Indiana/Vincennes
    {   86, 8086,   53143, 11, }, // America/Indiana/Winamac
    {   86, 8110,   53154,  4, }, // America/Inuvik
    {   86,  660,   53158,  5, }, // America/Iqaluit
    {   86, 2799,   53163,  4, }, // America/Jamaica
    {   86, 5380,   53167,  2, }, // America/Juneau
    {   86,  521,   53169,  4, }, // America/Kentucky/Louisville
    {   86, 8125,   53173, 11, }, // America/Kentucky/Monticello
    {   86, 5704,   53184,  4, }, // America/Kralendijk
    {   86, 4376,   53188,  2, }, // America/La_Paz
    {   86, 7169,   53172,  2, }, // America/Lima
    {   86, 3239,   53190, 12, }, // America/Los_Angeles
    {   86, 5932,   53202, 17, }, // America/Lower_Princes
    {   86, 8153,   53219,  3, }, // America/Maceio
    {   86, 8168,   53222,  3, }, // America/Managua
    {   86, 1908,   53225,  4, }, // America/Manaus
    {   86, 5897,   53229,  4, }, // America/Marigot
    {   86, 5805,   53233,  4, }, // America/Martinique
    {   86, 8184,   53237,  5, }, // America/Matamoros
    {   86, 2917,   53242,  4, }, // America/Mazatlan
    {   86, 8202,   53246,  4, }, // America/Menominee
    {   86, 8220,   53250,  3, }, // America/Merida
    {   86, 8235,   53253,  4, }, // America/Metlakatla
    {   86, 2949,   53257,  9, }, // America/Mexico_City
    {   86, 4391,   53266,  4, }, // America/Miquelon
    {   86, 8254,   53270,  4, }, // America/Moncton
    {   86, 8270,   53274,  3, }, // America/Monterrey
    {   86, 4098,   53277,  6, }, // America/Montevideo
    {   86, 5824,   53283,  6, }, // America/Montserrat
    {   86, 5481,   53289,  3, }, // America/Nassau
    {   86, 2379,   53292,  3, }, // America/New_York
    {   86, 8288,   53295,  2, }, // America/Nome
    {   86, 1850,   53297,  4, }, // America/Noronha
    {   86, 8301,   53301, 12, }, // America/North_Dakota/Beulah
    {   86, 8329,   53313, 12, }, // America/North_Dakota/Center
    {   86, 8357,   53325, 15, }, // America/North_Dakota/New_Salem
    {   86,  393,   53340,  2, }, // America/Nuuk
    {   86, 8388,   53342,  4, }, // America/Ojinaga
    {   86, 2356,   53346,  3, }, // America/Panama
    {   86, 6173,   53349,  5, }, // America/Paramaribo
    {   86, 2973,   53354,  6, }, // America/Phoenix
    {   86, 3945,   53360, 17, }, // America/Port-au-Prince
    {   86, 5954,   53377, 15, }, // America/Port_of_Spain
    {   86, 8404,   53392, 12, }, // America/Porto_Velho
    {   86, 5843,   53404,  7, }, // America/Puerto_Rico
    {   86, 4030,   53411,  7, }, // America/Punta_Arenas
    {   86, 8424,   53418,  9, }, // America/Rankin_Inlet
    {   86, 8445,   53427,  3, }, // America/Recife
    {   86, 1995,   53430,  3, }, // America/Regina
    {   86, 8460,   53433,  4, }, // America/Resolute
    {   86,  695,   53437,  7, }, // America/Rio_Branco
    {   86, 8477,   53444,  5, }, // America/Santarem
    {   86, 2201,   53449,  5, }, // America/Santiago
    {   86, 6111,   53454,  7, }, // America/Santo_Domingo
    {   86, 1878,   53461,  5, }, // America/Sao_Paulo
    {   86, 6899,   53466,  6, }, // America/Scoresbysund
    {   86, 8494,   53472,  3, }, // America/Sitka
    {   86, 8508,   53475, 10, }, // America/St_Barthelemy
    {   86, 2061,   53485, 11, }, // America/St_Johns
    {   86, 5863,   53496,  8, }, // America/St_Kitts
    {   86, 5880,   53504,  8, }, // America/St_Lucia
    {   86,  855,   53512,  8, }, // America/St_Thomas
    {   86, 5913,   53520,  9, }, // America/St_Vincent
    {   86, 8530,   53529,  8, }, // America/Swift_Current
    {   86, 5461,   53537,  6, }, // America/Tegucigalpa
    {   86, 5756,   53543,  2, }, // America/Thule
    {   86,  313,   53545,  4, }, // America/Tijuana
    {   86,  608,   53549,  4, }, // America/Toronto
    {   86, 5688,   53553,  3, }, // America/Tortola
    {   86, 2093,   53556,  5, }, // America/Vancouver
    {   86, 2144,   53561,  7, }, // America/Whitehorse
    {   86,  734,   53568,  4, }, // America/Winnipeg
    {   86, 8552,   53572,  4, }, // America/Yakutat
    {   86, 6001,   52906,  2, }, // Antarctica/Casey
    {   86, 6094,   53576,  3, }, // Antarctica/Davis
    {   86, 6133,   53579, 11, }, // Antarctica/DumontDUrville
    {   86, 8568,   53590,  3, }, // Antarctica/Macquarie
    {   86, 7066,   53593,  3, }, // Antarctica/Mawson
    {   86, 7113,   53596,  4, }, // Antarctica/McMurdo
    {   86, 8589,   53600,  4, }, // Antarctica/Palmer
    {   86, 7226,   53604,  3, }, // Antarctica/Rothera
    {   86, 7295,   53607,  3, }, // Antarctica/Syowa
    {   86, 8607,   53610,  2, }, // Antarctica/Troll
    {   86, 7374,   53612,  4, }, // Antarctica/Vostok
    {   86, 1429,   53616, 17, }, // Arctic/Longyearbyen
    {   86, 5570,   53633,  3, }, // Asia/Aden
    {   86, 5395,   53636,  4, }, // Asia/Almaty
    {   86, 3968,   53640,  3, }, // Asia/Amman
    {   86, 5511,   53643,  4, }, // Asia/Anadyr
    {   86, 5523,   53647,  4, }, // Asia/Aqtau
    {   86, 5368,   53651,  4, }, // Asia/Aqtobe
    {   86,  964,   53655,  5, }, // Asia/Ashgabat
    {   86, 8624,   53660,  4, }, // Asia/Atyrau
    {   86, 3607,   53664,  4, }, // Asia/Baghdad
    {   86, 5534,   53668,  5, }, // Asia/Bahrain
    {   86, 3653,   52947,  2, }, // Asia/Baku
    {   86, 4466,   53673,  5, }, // Asia/Bangkok
    {   86, 3571,   53678,  4, }, // Asia/Barnaul
    {   86, 4086,   53682,  3, }, // Asia/Beirut
    {   86, 3778,   53685,  4, }, // Asia/Bishkek
    {   86, 5989,   53689,  3, }, // Asia/Brunei
    {   86, 4601,   53692,  2, }, // Asia/Chita
    {   86, 4511,   53694,  4, }, // Asia/Colombo
    {   86, 4540,   53698,  5, }, // Asia/Damascus
    {   86, 1093,   52608,  2, }, // Asia/Dhaka
    {   86, 6192,   53645,  2, }, // Asia/Dili
    {   86, 3596,   53703,  3, }, // Asia/Dubai
    {   86, 6159,   53706,  4, }, // Asia/Dushanbe
    {   86, 8636,   53710,  5, }, // Asia/Famagusta
    {   86, 8651,   53715,  2, }, // Asia/Gaza
    {   86, 4795,   53717,  3, }, // Asia/Hebron
    {   86, 1259,   53720, 10, }, // Asia/Ho_Chi_Minh
    {   86, 2704,   53730,  7, }, // Asia/Hong_Kong
    {   86, 4771,   53737,  3, }, // Asia/Hovd
    {   86, 4184,   53740,  4, }, // Asia/Irkutsk
    {   86, 7006,   53744,  3, }, // Asia/Jakarta
    {   86, 6992,   53747,  4, }, // Asia/Jayapura
    {   86, 1290,   53751,  5, }, // Asia/Jerusalem
    {   86, 3560,   53756,  3, }, // Asia/Kabul
    {   86, 4316,   53759,  4, }, // Asia/Kamchatka
    {   86, 4239,   53763,  3, }, // Asia/Karachi
    {   86, 1185,   53766,  5, }, // Asia/Kathmandu
    {   86, 8661,   53771,  4, }, // Asia/Khandyga
    {   86,  992,   53775,  4, }, // Asia/Kolkata
    {   86, 4197,   53779,  6, }, // Asia/Krasnoyarsk
    {   86, 4859,   53785,  7, }, // Asia/Kuala_Lumpur
    {   86, 5976,   53792,  4, }, // Asia/Kuching
    {   86, 5547,   53796,  3, }, // Asia/Kuwait
    {   86, 1211,   53799,  3, }, // Asia/Macau
    {   86, 4017,   53802,  4, }, // Asia/Magadan
    {   86, 1349,   53806,  4, }, // Asia/Makassar
    {   86, 7182,   53810,  3, }, // Asia/Manila
    {   86, 6920,   53813,  4, }, // Asia/Muscat
    {   86, 2554,   53817,  4, }, // Asia/Nicosia
    {   86, 8675,   53821,  7, }, // Asia/Novokuznetsk
    {   86, 4135,   53828,  6, }, // Asia/Novosibirsk
    {   86, 4229,   53834,  4, }, // Asia/Omsk
    {   86, 7145,   53838,  3, }, // Asia/Oral
    {   86, 6961,   53841,  5, }, // Asia/Phnom_Penh
    {   86, 8693,   53846,  6, }, // Asia/Pontianak
    {   86, 4214,   53852,  7, }, // Asia/Pyongyang
    {   86, 5559,   53859,  3, }, // Asia/Qatar
    {   86, 8708,   53862,  4, }, // Asia/Qostanay
    {   86, 4269,   53866,  5, }, // Asia/Qyzylorda
    {   86, 3584,   53871,  3, }, // Asia/Riyadh
    {   86, 4408,   53874,  4, }, // Asia/Sakhalin
    {   86, 7245,   53878,  5, }, // Asia/Samarkand
    {   86, 3279,   53883,  2, }, // Asia/Seoul
    {   86, 1053,   53885,  5, }, // Asia/Shanghai
    {   86, 3300,   53890,  5, }, // Asia/Singapore
    {   86, 4297,   53895,  9, }, // Asia/Srednekolymsk
    {   86, 3263,   53904,  3, }, // Asia/Taipei
    {   86, 4781,   53907,  5, }, // Asia/Tashkent
    {   86, 3915,   53912,  4, }, // Asia/Tbilisi
    {   86, 2772,   53916,  3, }, // Asia/Tehran
    {   86, 1317,   53919,  3, }, // Asia/Thimphu
    {   86, 2821,   53922,  3, }, // Asia/Tokyo
    {   86, 4572,   53925,  4, }, // Asia/Tomsk
    {   86, 1021,   53929,  5, }, // Asia/Ulaanbaatar
    {   86, 1159,   53934,  4, }, // Asia/Urumqi
    {   86, 8722,   53938,  6, }, // Asia/Ust-Nera
    {   86, 6977,   53944,  6, }, // Asia/Vientiane
    {   86, 4710,   53950,  7, }, // Asia/Vladivostok
    {   86, 4828,   53957,  4, }, // Asia/Yakutsk
    {   86, 1235,   53961,  4, }, // Asia/Yangon
    {   86, 3883,   53965,  7, }, // Asia/Yekaterinburg
    {   86, 3747,   53972,  4, }, // Asia/Yerevan
    {   86, 3663,   53976,  4, }, // Atlantic/Azores
    {   86, 5671,   53980,  3, }, // Atlantic/Bermuda
    {   86, 6628,   53983,  3, }, // Atlantic/Canary
    {   86, 3727,   53986, 11, }, // Atlantic/Cape_Verde
    {   86, 1395,   53997,  2, }, // Atlantic/Faroe
    {   86, 8736,   53999,  3, }, // Atlantic/Madeira
    {   86, 2748,   54002,  4, }, // Atlantic/Reykjavik
    {   86, 7272,   54006,  9, }, // Atlantic/South_Georgia
    {   86, 6821,   54015,  8, }, // Atlantic/St_Helena
    {   86, 6644,   54023,  4, }, // Atlantic/Stanley
    {   86, 1670,   54027,  4, }, // Australia/Adelaide
    {   86, 1635,   54031,  4, }, // Australia/Brisbane
    {   86, 1799,   54035,  8, }, // Australia/Broken_Hill
    {   86, 1583,   54043,  3, }, // Australia/Darwin
    {   86, 3637,   54046,  2, }, // Australia/Eucla
    {   86, 1516,   54048,  3, }, // Australia/Hobart
    {   86, 8753,   54051,  5, }, // Australia/Lindeman
    {   86, 1547,   54056,  8, }, // Australia/Lord_Howe
    {   86, 1727,   54064,  4, }, // Australia/Melbourne
    {   86, 1762,   54068,  3, }, // Australia/Perth
    {   86, 1463,   54071,  3, }, // Australia/Sydney
    {   86, 6441,   54074,  6, }, // Europe/Amsterdam
    {   86, 6216,   54080,  4, }, // Europe/Andorra
    {   86, 3620,   54084,  4, }, // Europe/Astrakhan
    {   86, 2300,   54088,  4, }, // Europe/Athens
    {   86, 6336,   54092,  4, }, // Europe/Belgrade
    {   86, 4757,   54096,  3, }, // Europe/Berlin
    {   86, 6488,   54099,  5, }, // Europe/Bratislava
    {   86, 2167,   54104,  4, }, // Europe/Brussels
    {   86, 3928,   54108,  5, }, // Europe/Bucharest
    {   86, 3806,   54113,  5, }, // Europe/Budapest
    {   86, 8772,   54118,  5, }, // Europe/Busingen
    {   86, 2583,   54123,  4, }, // Europe/Chisinau
    {   86, 6289,   54127,  6, }, // Europe/Copenhagen
    {   86, 2338,   54133,  3, }, // Europe/Dublin
    {   86, 6307,   54136,  4, }, // Europe/Gibraltar
    {   86, 8788,   54140,  3, }, // Europe/Guernsey
    {   86, 6612,   54143,  5, }, // Europe/Helsinki
    {   86, 8804,   54148, 15, }, // Europe/Isle_of_Man
    {   86, 1130,   54163,  6, }, // Europe/Istanbul
    {   86, 8823,   54169,  3, }, // Europe/Jersey
    {   86, 3979,   54172,  5, }, // Europe/Kaliningrad
    {   86, 8929,   54177,  3, }, // Europe/Kirov
    {   86, 2527,   54180,  2, }, // Europe/Kyiv
    {   86, 3213,   54182,  4, }, // Europe/Lisbon
    {   86, 6506,   54186,  3, }, // Europe/Ljubljana
    {   86, 2501,   54189,  4, }, // Europe/London
    {   86, 6365,   54193,  5, }, // Europe/Luxembourg
    {   86, 4892,   54198,  3, }, // Europe/Madrid
    {   86, 6397,   54201,  3, }, // Europe/Malta
    {   86, 6582,   54204,  4, }, // Europe/Mariehamn
    {   86, 3693,   54208,  4, }, // Europe/Minsk
    {   86, 6410,   54212,  3, }, // Europe/Monaco
    {   86, 3537,   54215,  4, }, // Europe/Moscow
    {   86, 6458,   54219,  3, }, // Europe/Oslo
    {   86, 4284,   54222,  3, }, // Europe/Paris
    {   86, 6424,   54225,  4, }, // Europe/Podgorica
    {   86, 6275,   52698,  2, }, // Europe/Prague
    {   86, 8837,   53052,  2, }, // Europe/Riga
    {   86, 6324,   53695,  2, }, // Europe/Rome
    {   86, 4331,   54229,  3, }, // Europe/Samara
    {   86, 6470,   54232,  3, }, // Europe/San_Marino
    {   86, 6245,   54235,  4, }, // Europe/Sarajevo
    {   86, 4451,   54239,  4, }, // Europe/Saratov
    {   86, 8849,   54243,  6, }, // Europe/Simferopol
    {   86, 6383,   54249,  3, }, // Europe/Skopje
    {   86, 6599,   54252,  3, }, // Europe/Sofia
    {   86, 6523,   54255,  5, }, // Europe/Stockholm
    {   86, 8867,   54260,  3, }, // Europe/Tallinn
    {   86, 6202,   54263,  3, }, // Europe/Tirane
    {   86, 8882,   54266,  7, }, // Europe/Ulyanovsk
    {   86, 6352,   54273,  3, }, // Europe/Vaduz
    {   86, 6567,   54276,  5, }, // Europe/Vatican
    {   86, 6231,   54281,  3, }, // Europe/Vienna
    {   86, 8899,   54284,  5, }, // Europe/Vilnius
    {   86, 4727,   54289,  5, }, // Europe/Volgograd
    {   86, 3190,   54294,  8, }, // Europe/Warsaw
    {   86, 6261,   54302,  3, }, // Europe/Zagreb
    {   86, 6540,   54305,  3, }, // Europe/Zurich
    {   86, 5078,   54308,  7, }, // Indian/Antananarivo
    {   86, 6947,   54315,  3, }, // Indian/Chagos
    {   86, 6046,   54318,  7, }, // Indian/Christmas
    {   86, 6063,   54325,  3, }, // Indian/Cocos
    {   86, 5029,   54328,  3, }, // Indian/Comoro
    {   86, 6661,   54331,  6, }, // Indian/Kerguelen
    {   86, 7260,   54337,  2, }, // Indian/Mahe
    {   86, 7050,   54339,  5, }, // Indian/Maldives
    {   86, 4069,   54344,  5, }, // Indian/Mauritius
    {   86, 5098,   54349,  3, }, // Indian/Mayotte
    {   86, 7211,   54352,  5, }, // Indian/Reunion
    {   86, 4422,   54357,  3, }, // Pacific/Apia
    {   86,  932,   54360,  5, }, // Pacific/Auckland
    {   86, 3706,   54365,  5, }, // Pacific/Bougainville
    {   86, 3015,   54370,  3, }, // Pacific/Chatham
    {   86, 3157,   54373,  2, }, // Pacific/Chuuk
    {   86, 2237,   54375,  7, }, // Pacific/Easter
    {   86, 7360,   54382,  3, }, // Pacific/Efate
    {   86, 7327,   54385,  4, }, // Pacific/Fakaofo
    {   86, 3902,   54389,  2, }, // Pacific/Fiji
    {   86, 7343,   54391,  4, }, // Pacific/Funafuti
    {   86, 6678,   54395, 12, }, // Pacific/Galapagos
    {   86, 6696,   54407,  4, }, // Pacific/Gambier
    {   86, 3822,   54411,  6, }, // Pacific/Guadalcanal
    {   86, 6018,   54417,  2, }, // Pacific/Guam
    {   86, 2723,   54419,  4, }, // Pacific/Honolulu
    {   86, 3049,   54423,  4, }, // Pacific/Kanton
    {   86, 3998,   54427,  5, }, // Pacific/Kiritimati
    {   86, 7019,   54432,  3, }, // Pacific/Kosrae
    {   86, 2842,   54435,  5, }, // Pacific/Kwajalein
    {   86, 4877,   54440,  3, }, // Pacific/Majuro
    {   86, 4051,   54443,  5, }, // Pacific/Marquesas
    {   86, 8914,   54448,  5, }, // Pacific/Midway
    {   86, 7084,   54453,  3, }, // Pacific/Nauru
    {   86, 7132,   54045,  2, }, // Pacific/Niue
    {   86, 4168,   54456,  5, }, // Pacific/Norfolk
    {   86, 7098,   54461,  4, }, // Pacific/Noumea
    {   86, 3126,   54465,  5, }, // Pacific/Pago_Pago
    {   86, 7155,   54470,  4, }, // Pacific/Palau
    {   86, 7194,   54474,  5, }, // Pacific/Pitcairn
    {   86, 3096,   54479,  3, }, // Pacific/Pohnpei
    {   86, 4807,   54482, 13, }, // Pacific/Port_Moresby
    {   86, 6076,   54495,  5, }, // Pacific/Rarotonga
    {   86, 6031,   54500,  4, }, // Pacific/Saipan
    {   86, 7312,   54504,  3, }, // Pacific/Tahiti
    {   86, 6712,   54507,  3, }, // Pacific/Tarawa
    {   86, 4583,   54510,  5, }, // Pacific/Tongatapu
    {   86, 7392,   54515,  3, }, // Pacific/Wake
    {   86, 7405,   54518,  3, }, // Pacific/Wallis
    {   87,   14,       0,  6, }, // Africa/Asmara Chickasaw/Latin/United States
    {   87, 4435,       6,  8, }, // Africa/Sao_Tome
    {   87, 4252,      14,  8, }, // America/Asuncion
    {   87,  237,      22,  8, }, // America/Atikokan
    {   87, 7623,      30, 17, }, // America/Bahia_Banderas
    {   87, 3868,      47,  6, }, // America/Cancun
    {   87, 7774,      53, 13, }, // America/Ciudad_Juarez
    {   87, 5723,      66,  7, }, // America/Curacao
    {   87,  481,      73, 13, }, // America/Indiana/Knox
    {   87, 7961,      86, 16, }, // America/Indiana/Marengo
    {   87, 7985,     102, 19, }, // America/Indiana/Petersburg
    {   87, 8012,     121, 18, }, // America/Indiana/Tell_City
    {   87, 8038,     139, 14, }, // America/Indiana/Vevay
    {   87, 8060,     153, 18, }, // America/Indiana/Vincennes
    {   87, 8086,     171, 16, }, // America/Indiana/Winamac
    {   87, 8125,     187, 20, }, // America/Kentucky/Monticello
    {   87, 5932,     207, 22, }, // America/Lower_Princes
    {   87, 8220,     229,  6, }, // America/Merida
    {   87, 8301,     235, 20, }, // America/North_Dakota/Beulah
    {   87, 8329,     255, 20, }, // America/North_Dakota/Center
    {   87, 8357,     275, 23, }, // America/North_Dakota/New_Salem
    {   87,  393,     298,  4, }, // America/Nuuk
    {   87, 6899,     302, 16, }, // America/Scoresbysund
    {   87, 8508,     318, 14, }, // America/St_Barthelemy
    {   87, 2061,     332, 10, }, // America/St_Johns
    {   87, 5863,     342,  9, }, // America/St_Kitts
    {   87, 5880,     351,  9, }, // America/St_Lucia
    {   87,  855,     360, 10, }, // America/St_Thomas
    {   87, 5913,     370, 11, }, // America/St_Vincent
    {   87, 6133,     381, 16, }, // Antarctica/DumontDUrville
    {   87, 1259,     397, 11, }, // Asia/Ho_Chi_Minh
    {   87, 1185,     413,  9, }, // Asia/Kathmandu
    {   87,  992,     422,  7, }, // Asia/Kolkata
    {   87, 1211,     429,  5, }, // Asia/Macau
    {   87, 1235,     442,  6, }, // Asia/Yangon
    {   87, 1395,     448,  5, }, // Atlantic/Faroe
    {   87, 6821,     453, 10, }, // Atlantic/St_Helena
    {   87, 2527,     463,  4, }, // Europe/Kyiv
    {   87, 7211,     467,  7, }, // Indian/Reunion
    {   87, 3157,     474,  5, }, // Pacific/Chuuk
    {   87, 3096,     479,  7, }, // Pacific/Pohnpei
    {   88,   14,       0,  6, }, // Africa/Asmara Chiga/Latin/Uganda
    {   88, 4435,       6,  8, }, // Africa/Sao_Tome
    {   88, 4252,      14,  8, }, // America/Asuncion
    {   88,  237,      22,  8, }, // America/Atikokan
    {   88, 7623,      30, 17, }, // America/Bahia_Banderas
    {   88, 3868,      47,  6, }, // America/Cancun
    {   88, 7774,      53, 13, }, // America/Ciudad_Juarez
    {   88, 5723,      66,  7, }, // America/Curacao
    {   88,  481,      73, 13, }, // America/Indiana/Knox
    {   88, 7961,      86, 16, }, // America/Indiana/Marengo
    {   88, 7985,     102, 19, }, // America/Indiana/Petersburg
    {   88, 8012,     121, 18, }, // America/Indiana/Tell_City
    {   88, 8038,     139, 14, }, // America/Indiana/Vevay
    {   88, 8060,     153, 18, }, // America/Indiana/Vincennes
    {   88, 8086,     171, 16, }, // America/Indiana/Winamac
    {   88, 8125,     187, 20, }, // America/Kentucky/Monticello
    {   88, 5932,     207, 22, }, // America/Lower_Princes
    {   88, 8220,     229,  6, }, // America/Merida
    {   88, 8301,     235, 20, }, // America/North_Dakota/Beulah
    {   88, 8329,     255, 20, }, // America/North_Dakota/Center
    {   88, 8357,     275, 23, }, // America/North_Dakota/New_Salem
    {   88,  393,     298,  4, }, // America/Nuuk
    {   88, 6899,     302, 16, }, // America/Scoresbysund
    {   88, 8508,     318, 14, }, // America/St_Barthelemy
    {   88, 2061,     332, 10, }, // America/St_Johns
    {   88, 5863,     342,  9, }, // America/St_Kitts
    {   88, 5880,     351,  9, }, // America/St_Lucia
    {   88,  855,     360, 10, }, // America/St_Thomas
    {   88, 5913,     370, 11, }, // America/St_Vincent
    {   88, 6133,     381, 16, }, // Antarctica/DumontDUrville
    {   88, 1259,     397, 11, }, // Asia/Ho_Chi_Minh
    {   88, 1185,     413,  9, }, // Asia/Kathmandu
    {   88,  992,     422,  7, }, // Asia/Kolkata
    {   88, 1211,     429,  5, }, // Asia/Macau
    {   88, 1235,     442,  6, }, // Asia/Yangon
    {   88, 1395,     448,  5, }, // Atlantic/Faroe
    {   88, 6821,     453, 10, }, // Atlantic/St_Helena
    {   88, 2527,     463,  4, }, // Europe/Kyiv
    {   88, 7211,     467,  7, }, // Indian/Reunion
    {   88, 3157,     474,  5, }, // Pacific/Chuuk
    {   88, 3096,     479,  7, }, // Pacific/Pohnpei
    {   89, 6788,   42949,  3, }, // Africa/Abidjan Chinese/Simplified Han/China
    {   89, 6760,   41438,  3, }, // Africa/Accra
    {   89, 5059,   54521,  6, }, // Africa/Addis_Ababa
    {   89, 7420,   42958,  4, }, // Africa/Algiers
    {   89,   14,   54527,  4, }, // Africa/Asmara
    {   89,   44,   42966,  3, }, // Africa/Bamako
    {   89, 5257,   41458,  2, }, // Africa/Bangui
    {   89, 6746,   54531,  3, }, // Africa/Banjul
    {   89, 7435,   42969,  2, }, // Africa/Bissau
    {   89, 4957,   42971,  4, }, // Africa/Blantyre
    {   89, 5287,   42975,  5, }, // Africa/Brazzaville
    {   89, 4922,   54534,  4, }, // Africa/Bujumbura
    {   89, 2320,   42980,  2, }, // Africa/Cairo
    {   89, 4117,   42982,  5, }, // Africa/Casablanca
    {   89, 7449,   42987,  2, }, // Africa/Ceuta
    {   89, 6773,   54538,  4, }, // Africa/Conakry
    {   89, 6840,   42989,  3, }, // Africa/Dakar
    {   89, 5130,   54542,  6, }, // Africa/Dar_es_Salaam
    {   89, 5043,   54548,  3, }, // Africa/Djibouti
    {   89, 5243,   41499,  3, }, // Africa/Douala
    {   89, 5166,   41502,  3, }, // Africa/El_Aaiun
    {   89, 6853,   54551,  3, }, // Africa/Freetown
    {   89, 4906,   54554,  4, }, // Africa/Gaborone
    {   89, 5015,   41512,  3, }, // Africa/Harare
    {   89, 4479,   54558,  5, }, // Africa/Johannesburg
    {   89, 4499,   41520,  2, }, // Africa/Juba
    {   89, 5151,   41522,  3, }, // Africa/Kampala
    {   89, 4524,   41525,  3, }, // Africa/Khartoum
    {   89, 4973,   41528,  3, }, // Africa/Kigali
    {   89, 5306,   54563,  3, }, // Africa/Kinshasa
    {   89, 4744,   54566,  3, }, // Africa/Lagos
    {   89, 5336,   54569,  4, }, // Africa/Libreville
    {   89, 6869,   41540,  2, }, // Africa/Lome
    {   89, 5211,   43000,  3, }, // Africa/Luanda
    {   89, 4939,   43003,  4, }, // Africa/Lubumbashi
    {   89, 5001,   54573,  3, }, // Africa/Lusaka
    {   89, 5322,   43007,  3, }, // Africa/Malabo
    {   89, 4987,   43010,  3, }, // Africa/Maputo
    {   89, 5197,   54576,  3, }, // Africa/Maseru
    {   89, 5182,   54579,  4, }, // Africa/Mbabane
    {   89, 5113,   54583,  4, }, // Africa/Mogadishu
    {   89, 7034,   43016,  4, }, // Africa/Monrovia
    {   89, 3853,   54587,  3, }, // Africa/Nairobi
    {   89, 5271,   43020,  4, }, // Africa/Ndjamena
    {   89, 5354,   43024,  3, }, // Africa/Niamey
    {   89, 6803,   54590,  5, }, // Africa/Nouakchott
    {   89, 6727,   41585,  4, }, // Africa/Ouagadougou
    {   89, 5225,   54595,  4, }, // Africa/Porto-Novo
    {   89, 4435,   43034,  3, }, // Africa/Sao_Tome
    {   89, 2866,   41596,  4, }, // Africa/Tripoli
    {   89, 6554,   41600,  3, }, // Africa/Tunis
    {   89, 4152,   43037,  4, }, // Africa/Windhoek
    {   89,  132,   54599,  3, }, // America/Adak
    {   89, 3346,   54602,  4, }, // America/Anchorage
    {   89, 5607,   54606,  3, }, // America/Anguilla
    {   89, 5624,   54609,  3, }, // America/Antigua
    {   89, 4554,   54612,  5, }, // America/Araguaina
    {   89,  166,   43044,  7, }, // America/Argentina/Buenos_Aires
    {   89,   91,   43051,  4, }, // America/Argentina/Catamarca
    {   89,  270,   54617,  4, }, // America/Argentina/Cordoba
    {   89,  441,   41638,  3, }, // America/Argentina/Jujuy
    {   89, 7462,   54621,  4, }, // America/Argentina/La_Rioja
    {   89,  565,   43058,  3, }, // America/Argentina/Mendoza
    {   89, 7489,   43061,  6, }, // America/Argentina/Rio_Gallegos
    {   89, 7520,   43067,  3, }, // America/Argentina/Salta
    {   89, 7544,   43070,  3, }, // America/Argentina/San_Juan
    {   89, 5580,   54625,  4, }, // America/Argentina/San_Luis
    {   89, 7571,   54629,  3, }, // America/Argentina/Tucuman
    {   89, 7597,   43079,  4, }, // America/Argentina/Ushuaia
    {   89, 5640,   54632,  3, }, // America/Aruba
    {   89, 4252,   43083,  3, }, // America/Asuncion
    {   89,  237,   41675,  4, }, // America/Atikokan
    {   89, 3679,   43086,  3, }, // America/Bahia
    {   89, 7623,   43086,  7, }, // America/Bahia_Banderas
    {   89, 5654,   54635,  4, }, // America/Barbados
    {   89, 7646,   43096,  2, }, // America/Belem
    {   89, 5407,   54639,  3, }, // America/Belize
    {   89, 7660,   54642,  6, }, // America/Blanc-Sablon
    {   89, 7681,   54648,  5, }, // America/Boa_Vista
    {   89, 4361,   41706,  3, }, // America/Bogota
    {   89, 7699,   54653,  3, }, // America/Boise
    {   89, 7713,   43110,  3, }, // America/Cambridge_Bay
    {   89, 7735,   54656,  3, }, // America/Campo_Grande
    {   89, 3868,   41717,  2, }, // America/Cancun
    {   89, 4694,   54659,  4, }, // America/Caracas
    {   89, 4345,   54663,  2, }, // America/Cayenne
    {   89, 5496,   43118,  2, }, // America/Cayman
    {   89, 2260,   41729,  3, }, // America/Chicago
    {   89, 7756,   54665,  3, }, // America/Chihuahua
    {   89, 7774,   43125,  4, }, // America/Ciudad_Juarez
    {   89, 5422,   54668,  5, }, // America/Costa_Rica
    {   89, 7796,   43129,  4, }, // America/Creston
    {   89, 3791,   54673,  3, }, // America/Cuiaba
    {   89, 5723,   43133,  3, }, // America/Curacao
    {   89, 7812,   43136,  4, }, // America/Danmarkshavn
    {   89, 7833,   41758,  2, }, // America/Dawson
    {   89, 7848,   41760,  5, }, // America/Dawson_Creek
    {   89,  805,   41765,  2, }, // America/Denver
    {   89, 3465,   41767,  3, }, // America/Detroit
    {   89, 5739,   54676,  4, }, // America/Dominica
    {   89,  893,   54680,  4, }, // America/Edmonton
    {   89, 7869,   54684,  4, }, // America/Eirunepe
    {   89, 5441,   43144,  4, }, // America/El_Salvador
    {   89, 7886,   43148,  4, }, // America/Fort_Nelson
    {   89, 7906,   54688,  4, }, // America/Fortaleza
    {   89, 7924,   54692,  4, }, // America/Glace_Bay
    {   89, 6881,   54696,  3, }, // America/Goose_Bay
    {   89, 4612,   41800,  3, }, // America/Grand_Turk
    {   89, 5770,   54699,  4, }, // America/Grenada
    {   89, 5786,   54703,  4, }, // America/Guadeloupe
    {   89, 3760,   54707,  4, }, // America/Guatemala
    {   89, 4841,   43170,  4, }, // America/Guayaquil
    {   89, 6932,   54711,  3, }, // America/Guyana
    {   89, 1939,   54714,  5, }, // America/Halifax
    {   89, 2281,   41828,  3, }, // America/Havana
    {   89, 7942,   43177,  4, }, // America/Hermosillo
    {   89,  348,   54719,  7, }, // America/Indiana/Indianapolis
    {   89,  481,   54726,  8, }, // America/Indiana/Knox
    {   89, 7961,   54734,  8, }, // America/Indiana/Marengo
    {   89, 7985,   54742,  9, }, // America/Indiana/Petersburg
    {   89, 8012,   54751,  8, }, // America/Indiana/Tell_City
    {   89, 8038,   54759,  8, }, // America/Indiana/Vevay
    {   89, 8060,   54767,  8, }, // America/Indiana/Vincennes
    {   89, 8086,   54775,  9, }, // America/Indiana/Winamac
    {   89, 8110,   54784,  4, }, // America/Inuvik
    {   89,  660,   41902,  3, }, // America/Iqaluit
    {   89, 2799,   43233,  3, }, // America/Jamaica
    {   89, 5380,   43236,  2, }, // America/Juneau
    {   89,  521,   43238,  5, }, // America/Kentucky/Louisville
    {   89, 8125,   54788,  8, }, // America/Kentucky/Monticello
    {   89, 5704,   43251,  5, }, // America/Kralendijk
    {   89, 4376,   41928,  3, }, // America/La_Paz
    {   89, 7169,   43256,  2, }, // America/Lima
    {   89, 3239,   43258,  3, }, // America/Los_Angeles
    {   89, 5932,   43261,  4, }, // America/Lower_Princes
    {   89, 8153,   54796,  3, }, // America/Maceio
    {   89, 8168,   54799,  3, }, // America/Managua
    {   89, 1908,   54802,  3, }, // America/Manaus
    {   89, 5897,   43274,  4, }, // America/Marigot
    {   89, 5805,   54805,  4, }, // America/Martinique
    {   89, 8184,   43282,  5, }, // America/Matamoros
    {   89, 2917,   43287,  4, }, // America/Mazatlan
    {   89, 8202,   54809,  4, }, // America/Menominee
    {   89, 8220,   43295,  3, }, // America/Merida
    {   89, 8235,   41973,  6, }, // America/Metlakatla
    {   89, 2949,   54813,  4, }, // America/Mexico_City
    {   89, 4391,   54817,  3, }, // America/Miquelon
    {   89, 8254,   43301,  3, }, // America/Moncton
    {   89, 8270,   54820,  3, }, // America/Monterrey
    {   89, 4098,   54823,  5, }, // America/Montevideo
    {   89, 5824,   54828,  5, }, // America/Montserrat
    {   89, 5481,   54833,  2, }, // America/Nassau
    {   89, 2379,   43311,  2, }, // America/New_York
    {   89, 8288,   43313,  2, }, // America/Nome
    {   89, 1850,   54835,  4, }, // America/Noronha
    {   89, 8301,   54839,  8, }, // America/North_Dakota/Beulah
    {   89, 8329,   54847,  7, }, // America/North_Dakota/Center
    {   89, 8357,   54854,  9, }, // America/North_Dakota/New_Salem
    {   89,  393,   42031,  2, }, // America/Nuuk
    {   89, 8388,   43341,  4, }, // America/Ojinaga
    {   89, 2356,   43345,  3, }, // America/Panama
    {   89, 6173,   54863,  5, }, // America/Paramaribo
    {   89, 2973,   43353,  3, }, // America/Phoenix
    {   89, 3945,   42048,  3, }, // America/Port-au-Prince
    {   89, 5954,   42051,  4, }, // America/Port_of_Spain
    {   89, 8404,   54868,  4, }, // America/Porto_Velho
    {   89, 5843,   42058,  4, }, // America/Puerto_Rico
    {   89, 4030,   43359,  6, }, // America/Punta_Arenas
    {   89, 8424,   43365,  3, }, // America/Rankin_Inlet
    {   89, 8445,   54872,  3, }, // America/Recife
    {   89, 1995,   43368,  3, }, // America/Regina
    {   89, 8460,   54875,  4, }, // America/Resolute
    {   89,  695,   54879,  5, }, // America/Rio_Branco
    {   89, 8477,   43379,  3, }, // America/Santarem
    {   89, 2201,   54884,  4, }, // America/Santiago
    {   89, 6111,   54888,  4, }, // America/Santo_Domingo
    {   89, 1878,   43390,  3, }, // America/Sao_Paulo
    {   89, 6899,   54892,  7, }, // America/Scoresbysund
    {   89, 8494,   43400,  3, }, // America/Sitka
    {   89, 8508,   54899,  6, }, // America/St_Barthelemy
    {   89, 2061,   54905,  4, }, // America/St_Johns
    {   89, 5863,   43412,  3, }, // America/St_Kitts
    {   89, 5880,   54909,  4, }, // America/St_Lucia
    {   89,  855,   43419,  4, }, // America/St_Thomas
    {   89, 5913,   54913,  4, }, // America/St_Vincent
    {   89, 8530,   43426,  7, }, // America/Swift_Current
    {   89, 5461,   54917,  6, }, // America/Tegucigalpa
    {   89, 5756,   54923,  2, }, // America/Thule
    {   89,  313,   54925,  3, }, // America/Tijuana
    {   89,  608,   43436,  3, }, // America/Toronto
    {   89, 5688,   43439,  4, }, // America/Tortola
    {   89, 2093,   43443,  3, }, // America/Vancouver
    {   89, 2144,   43446,  4, }, // America/Whitehorse
    {   89,  734,   43450,  3, }, // America/Winnipeg
    {   89, 8552,   54928,  4, }, // America/Yakutat
    {   89, 6001,   54932,  2, }, // Antarctica/Casey
    {   89, 6094,   43458,  3, }, // Antarctica/Davis
    {   89, 6133,   54934,  6, }, // Antarctica/DumontDUrville
    {   89, 8568,   54940,  3, }, // Antarctica/Macquarie
    {   89, 7066,   42182,  2, }, // Antarctica/Mawson
    {   89, 7113,   43469,  4, }, // Antarctica/McMurdo
    {   89, 8589,   54943,  3, }, // Antarctica/Palmer
    {   89, 7226,   43475,  3, }, // Antarctica/Rothera
    {   89, 7295,   42193,  2, }, // Antarctica/Syowa
    {   89, 8607,   54946,  3, }, // Antarctica/Troll
    {   89, 7374,   42199,  4, }, // Antarctica/Vostok
    {   89, 1429,   54949,  4, }, // Arctic/Longyearbyen
    {   89, 5570,   43480,  2, }, // Asia/Aden
    {   89, 5395,   43482,  4, }, // Asia/Almaty
    {   89, 3968,   42214,  2, }, // Asia/Amman
    {   89, 5511,   54953,  4, }, // Asia/Anadyr
    {   89, 5523,   42219,  3, }, // Asia/Aqtau
    {   89, 5368,   54957,  4, }, // Asia/Aqtobe
    {   89,  964,   54961,  5, }, // Asia/Ashgabat
    {   89, 8624,   43486,  3, }, // Asia/Atyrau
    {   89, 3607,   43489,  3, }, // Asia/Baghdad
    {   89, 5534,   42237,  2, }, // Asia/Bahrain
    {   89, 3653,   43492,  2, }, // Asia/Baku
    {   89, 4466,   42239,  2, }, // Asia/Bangkok
    {   89, 3571,   43494,  4, }, // Asia/Barnaul
    {   89, 4086,   43498,  3, }, // Asia/Beirut
    {   89, 3778,   43501,  4, }, // Asia/Bishkek
    {   89, 5989,   54966,  2, }, // Asia/Brunei
    {   89, 4601,   42254,  2, }, // Asia/Chita
    {   89, 4511,   54968,  3, }, // Asia/Colombo
    {   89, 4540,   43510,  4, }, // Asia/Damascus
    {   89, 1093,   43514,  2, }, // Asia/Dhaka
    {   89, 6192,   42265,  2, }, // Asia/Dili
    {   89, 3596,   54971,  2, }, // Asia/Dubai
    {   89, 6159,   54973,  3, }, // Asia/Dushanbe
    {   89, 8636,   43519,  5, }, // Asia/Famagusta
    {   89, 8651,   54976,  2, }, // Asia/Gaza
    {   89, 4795,   54978,  3, }, // Asia/Hebron
    {   89, 1259,   42282,  4, }, // Asia/Ho_Chi_Minh
    {   89, 2704,   42293,  2, }, // Asia/Hong_Kong
    {   89, 4771,   42300,  3, }, // Asia/Hovd
    {   89, 4184,   54981,  5, }, // Asia/Irkutsk
    {   89, 7006,   43545,  3, }, // Asia/Jakarta
    {   89, 6992,   54986,  4, }, // Asia/Jayapura
    {   89, 1290,   42315,  4, }, // Asia/Jerusalem
    {   89, 3560,   43552,  3, }, // Asia/Kabul
    {   89, 4316,   42322,  3, }, // Asia/Kamchatka
    {   89, 4239,   54990,  3, }, // Asia/Karachi
    {   89, 1185,   43555,  4, }, // Asia/Kathmandu
    {   89, 8661,   54993,  3, }, // Asia/Khandyga
    {   89,  992,   43559,  4, }, // Asia/Kolkata
    {   89, 4197,   43563,  8, }, // Asia/Krasnoyarsk
    {   89, 4859,   42347,  3, }, // Asia/Kuala_Lumpur
    {   89, 5976,   43571,  2, }, // Asia/Kuching
    {   89, 5547,   42352,  3, }, // Asia/Kuwait
    {   89, 1211,   43580,  2, }, // Asia/Macau
    {   89, 4017,   43587,  3, }, // Asia/Magadan
    {   89, 1349,   54996,  3, }, // Asia/Makassar
    {   89, 7182,   43594,  3, }, // Asia/Manila
    {   89, 6920,   54999,  4, }, // Asia/Muscat
    {   89, 2554,   55003,  4, }, // Asia/Nicosia
    {   89, 8675,   43605,  6, }, // Asia/Novokuznetsk
    {   89, 4135,   43611,  5, }, // Asia/Novosibirsk
    {   89, 4229,   42398,  4, }, // Asia/Omsk
    {   89, 7145,   43616,  3, }, // Asia/Oral
    {   89, 6961,   43619,  2, }, // Asia/Phnom_Penh
    {   89, 8693,   42407,  2, }, // Asia/Pontianak
    {   89, 4214,   42409,  2, }, // Asia/Pyongyang
    {   89, 5559,   55007,  3, }, // Asia/Qatar
    {   89, 8708,   55010,  4, }, // Asia/Qostanay
    {   89, 4269,   55014,  5, }, // Asia/Qyzylorda
    {   89, 3584,   55019,  3, }, // Asia/Riyadh
    {   89, 4408,   55022,  3, }, // Asia/Sakhalin
    {   89, 7245,   43632,  4, }, // Asia/Samarkand
    {   89, 3279,   43636,  2, }, // Asia/Seoul
    {   89, 1053,   42435,  2, }, // Asia/Shanghai
    {   89, 3300,   42437,  3, }, // Asia/Singapore
    {   89, 4297,   42440,  6, }, // Asia/Srednekolymsk
    {   89, 3263,   42446,  2, }, // Asia/Taipei
    {   89, 4781,   42448,  3, }, // Asia/Tashkent
    {   89, 3915,   42451,  4, }, // Asia/Tbilisi
    {   89, 2772,   43638,  3, }, // Asia/Tehran
    {   89, 1317,   42458,  2, }, // Asia/Thimphu
    {   89, 2821,   43641,  2, }, // Asia/Tokyo
    {   89, 4572,   42462,  4, }, // Asia/Tomsk
    {   89, 1021,   43643,  4, }, // Asia/Ulaanbaatar
    {   89, 1159,   43647,  4, }, // Asia/Urumqi
    {   89, 8722,   43651,  4, }, // Asia/Ust-Nera
    {   89, 6977,   55025,  2, }, // Asia/Vientiane
    {   89, 4710,   55027,  7, }, // Asia/Vladivostok
    {   89, 4828,   55034,  4, }, // Asia/Yakutsk
    {   89, 1235,   42487,  2, }, // Asia/Yangon
    {   89, 3883,   55038,  5, }, // Asia/Yekaterinburg
    {   89, 3747,   55043,  3, }, // Asia/Yerevan
    {   89, 3663,   43670,  5, }, // Atlantic/Azores
    {   89, 5671,   55046,  3, }, // Atlantic/Bermuda
    {   89, 6628,   55049,  3, }, // Atlantic/Canary
    {   89, 3727,   55052,  3, }, // Atlantic/Cape_Verde
    {   89, 1395,   43684,  2, }, // Atlantic/Faroe
    {   89, 8736,   55055,  3, }, // Atlantic/Madeira
    {   89, 2748,   55058,  5, }, // Atlantic/Reykjavik
    {   89, 7272,   43698,  4, }, // Atlantic/South_Georgia
    {   89, 6821,   43702,  4, }, // Atlantic/St_Helena
    {   89, 6644,   55063,  3, }, // Atlantic/Stanley
    {   89, 1670,   55066,  4, }, // Australia/Adelaide
    {   89, 1635,   55070,  4, }, // Australia/Brisbane
    {   89, 1799,   43707,  5, }, // Australia/Broken_Hill
    {   89, 1583,   43712,  3, }, // Australia/Darwin
    {   89, 3637,   42553,  3, }, // Australia/Eucla
    {   89, 1516,   55074,  3, }, // Australia/Hobart
    {   89, 8753,   42559,  3, }, // Australia/Lindeman
    {   89, 1547,   43715,  4, }, // Australia/Lord_Howe
    {   89, 1727,   43719,  3, }, // Australia/Melbourne
    {   89, 1762,   55077,  2, }, // Australia/Perth
    {   89, 1463,   55079,  2, }, // Australia/Sydney
    {   89, 6441,   42573,  5, }, // Europe/Amsterdam
    {   89, 6216,   43722,  3, }, // Europe/Andorra
    {   89, 3620,   42581,  5, }, // Europe/Astrakhan
    {   89, 2300,   42586,  2, }, // Europe/Athens
    {   89, 6336,   55081,  5, }, // Europe/Belgrade
    {   89, 4757,   42592,  2, }, // Europe/Berlin
    {   89, 6488,   55086,  6, }, // Europe/Bratislava
    {   89, 2167,   43729,  4, }, // Europe/Brussels
    {   89, 3928,   42604,  5, }, // Europe/Bucharest
    {   89, 3806,   43733,  4, }, // Europe/Budapest
    {   89, 8772,   42613,  3, }, // Europe/Busingen
    {   89, 2583,   55092,  4, }, // Europe/Chisinau
    {   89, 6289,   42619,  4, }, // Europe/Copenhagen
    {   89, 2338,   42623,  3, }, // Europe/Dublin
    {   89, 6307,   43737,  4, }, // Europe/Gibraltar
    {   89, 8788,   55096,  3, }, // Europe/Guernsey
    {   89, 6612,   43744,  4, }, // Europe/Helsinki
    {   89, 8804,   55099,  3, }, // Europe/Isle_of_Man
    {   89, 1130,   55102,  5, }, // Europe/Istanbul
    {   89, 8823,   43750,  3, }, // Europe/Jersey
    {   89, 3979,   43753,  5, }, // Europe/Kaliningrad
    {   89, 8929,   42651,  3, }, // Europe/Kirov
    {   89, 2527,   43758,  2, }, // Europe/Kyiv
    {   89, 3213,   42656,  3, }, // Europe/Lisbon
    {   89, 6506,   55107,  5, }, // Europe/Ljubljana
    {   89, 2501,   43764,  2, }, // Europe/London
    {   89, 6365,   43766,  3, }, // Europe/Luxembourg
    {   89, 4892,   43769,  3, }, // Europe/Madrid
    {   89, 6397,   55112,  3, }, // Europe/Malta
    {   89, 6582,   43775,  3, }, // Europe/Mariehamn
    {   89, 3693,   42677,  3, }, // Europe/Minsk
    {   89, 6410,   43778,  3, }, // Europe/Monaco
    {   89, 3537,   42683,  3, }, // Europe/Moscow
    {   89, 6458,   43781,  3, }, // Europe/Oslo
    {   89, 4284,   42689,  2, }, // Europe/Paris
    {   89, 6424,   55115,  5, }, // Europe/Podgorica
    {   89, 6275,   42695,  3, }, // Europe/Prague
    {   89, 8837,   42698,  2, }, // Europe/Riga
    {   89, 6324,   43784,  2, }, // Europe/Rome
    {   89, 4331,   55120,  3, }, // Europe/Samara
    {   89, 6470,   55123,  4, }, // Europe/San_Marino
    {   89, 6245,   55127,  4, }, // Europe/Sarajevo
    {   89, 4451,   43793,  4, }, // Europe/Saratov
    {   89, 8849,   55131,  5, }, // Europe/Simferopol
    {   89, 6383,   55136,  4, }, // Europe/Skopje
    {   89, 6599,   55140,  3, }, // Europe/Sofia
    {   89, 6523,   43800,  5, }, // Europe/Stockholm
    {   89, 8867,   42733,  2, }, // Europe/Tallinn
    {   89, 6202,   42735,  3, }, // Europe/Tirane
    {   89, 8882,   43805,  7, }, // Europe/Ulyanovsk
    {   89, 6352,   55143,  3, }, // Europe/Vaduz
    {   89, 6567,   43815,  3, }, // Europe/Vatican
    {   89, 6231,   43818,  3, }, // Europe/Vienna
    {   89, 8899,   43821,  4, }, // Europe/Vilnius
    {   89, 4727,   43825,  5, }, // Europe/Volgograd
    {   89, 3190,   43830,  2, }, // Europe/Warsaw
    {   89, 6261,   55146,  4, }, // Europe/Zagreb
    {   89, 6540,   43832,  3, }, // Europe/Zurich
    {   89, 5078,   42772,  6, }, // Indian/Antananarivo
    {   89, 6947,   42778,  3, }, // Indian/Chagos
    {   89, 6046,   43835,  3, }, // Indian/Christmas
    {   89, 6063,   55150,  3, }, // Indian/Cocos
    {   89, 5029,   43843,  3, }, // Indian/Comoro
    {   89, 6661,   43848,  4, }, // Indian/Kerguelen
    {   89, 7260,   43853,  3, }, // Indian/Mahe
    {   89, 7050,   55153,  4, }, // Indian/Maldives
    {   89, 4069,   55157,  4, }, // Indian/Mauritius
    {   89, 5098,   43860,  3, }, // Indian/Mayotte
    {   89, 7211,   55161,  3, }, // Indian/Reunion
    {   89, 4422,   43868,  3, }, // Pacific/Apia
    {   89,  932,   43871,  3, }, // Pacific/Auckland
    {   89, 3706,   43874,  4, }, // Pacific/Bougainville
    {   89, 3015,   55164,  3, }, // Pacific/Chatham
    {   89, 3157,   55167,  5, }, // Pacific/Chuuk
    {   89, 2237,   55172,  4, }, // Pacific/Easter
    {   89, 7360,   42835,  3, }, // Pacific/Efate
    {   89, 7327,   42838,  3, }, // Pacific/Fakaofo
    {   89, 3902,   43881,  2, }, // Pacific/Fiji
    {   89, 7343,   55176,  4, }, // Pacific/Funafuti
    {   89, 6678,   55180,  4, }, // Pacific/Galapagos
    {   89, 6696,   43889,  3, }, // Pacific/Gambier
    {   89, 3822,   55184,  6, }, // Pacific/Guadalcanal
    {   89, 6018,   43900,  2, }, // Pacific/Guam
    {   89, 2723,   42866,  3, }, // Pacific/Honolulu
    {   89, 3049,   55190,  4, }, // Pacific/Kanton
    {   89, 3998,   43907,  6, }, // Pacific/Kiritimati
    {   89, 7019,   55194,  3, }, // Pacific/Kosrae
    {   89, 2842,   55197,  3, }, // Pacific/Kwajalein
    {   89, 4877,   55200,  3, }, // Pacific/Majuro
    {   89, 4051,   55203,  4, }, // Pacific/Marquesas
    {   89, 8914,   43925,  3, }, // Pacific/Midway
    {   89, 7084,   55207,  2, }, // Pacific/Nauru
    {   89, 7132,   43930,  2, }, // Pacific/Niue
    {   89, 4168,   43933,  3, }, // Pacific/Norfolk
    {   89, 7098,   55209,  3, }, // Pacific/Noumea
    {   89, 3126,   55212,  4, }, // Pacific/Pago_Pago
    {   89, 7155,   55216,  2, }, // Pacific/Palau
    {   89, 7194,   55218,  4, }, // Pacific/Pitcairn
    {   89, 3096,   55222,  4, }, // Pacific/Pohnpei
    {   89, 4807,   55226,  5, }, // Pacific/Port_Moresby
    {   89, 6076,   43947,  4, }, // Pacific/Rarotonga
    {   89, 6031,   42931,  2, }, // Pacific/Saipan
    {   89, 7312,   55231,  3, }, // Pacific/Tahiti
    {   89, 6712,   42936,  3, }, // Pacific/Tarawa
    {   89, 4583,   43951,  4, }, // Pacific/Tongatapu
    {   89, 7392,   42944,  2, }, // Pacific/Wake
    {   89, 7405,   42946,  3, }, // Pacific/Wallis
    {   94, 6899,   55234,  6, }, // America/Scoresbysund Chinese/Simplified Han/Singapore
    {   95, 6788,   55240,  3, }, // Africa/Abidjan Chinese/Traditional Han/Hong Kong
    {   95,   14,   55243,  4, }, // Africa/Asmara
    {   95, 5257,   55247,  2, }, // Africa/Bangui
    {   95, 6773,   55249,  4, }, // Africa/Conakry
    {   95, 5130,   55253,  6, }, // Africa/Dar_es_Salaam
    {   95, 4479,   55259,  5, }, // Africa/Johannesburg
    {   95, 5306,   55264,  3, }, // Africa/Kinshasa
    {   95, 5336,   55267,  3, }, // Africa/Libreville
    {   95, 5211,   55270,  3, }, // Africa/Luanda
    {   95, 5001,   55273,  3, }, // Africa/Lusaka
    {   95, 5197,   55276,  3, }, // Africa/Maseru
    {   95, 3853,   55279,  3, }, // Africa/Nairobi
    {   95, 4152,   55282,  4, }, // Africa/Windhoek
    {   95,  132,   55286,  3, }, // America/Adak
    {   95, 4554,   55289,  5, }, // America/Araguaina
    {   95,  270,   55294,  4, }, // America/Argentina/Cordoba
    {   95, 7462,   55298,  4, }, // America/Argentina/La_Rioja
    {   95, 5640,   55302,  3, }, // America/Aruba
    {   95, 4252,   55305,  3, }, // America/Asuncion
    {   95, 3679,   55308,  3, }, // America/Bahia
    {   95, 7623,   55311,  8, }, // America/Bahia_Banderas
    {   95, 5407,   55319,  3, }, // America/Belize
    {   95, 7681,   55322,  5, }, // America/Boa_Vista
    {   95, 7756,   55327,  3, }, // America/Chihuahua
    {   95, 7774,   41735,  4, }, // America/Ciudad_Juarez
    {   95, 5422,   55330,  5, }, // America/Costa_Rica
    {   95, 3791,   55335,  3, }, // America/Cuiaba
    {   95, 7848,   55338,  3, }, // America/Dawson_Creek
    {   95,  893,   55341,  3, }, // America/Edmonton
    {   95, 7906,   55344,  4, }, // America/Fortaleza
    {   95, 7924,   55348,  4, }, // America/Glace_Bay
    {   95, 5770,   55352,  4, }, // America/Grenada
    {   95, 5786,   55356,  4, }, // America/Guadeloupe
    {   95, 3760,   55360,  4, }, // America/Guatemala
    {   95, 6932,   55364,  3, }, // America/Guyana
    {   95, 2281,   55367,  3, }, // America/Havana
    {   95,  348,   55370,  7, }, // America/Indiana/Indianapolis
    {   95,  481,   55377,  8, }, // America/Indiana/Knox
    {   95, 7961,   55385,  8, }, // America/Indiana/Marengo
    {   95, 7985,   55393,  8, }, // America/Indiana/Petersburg
    {   95, 8012,   55401,  8, }, // America/Indiana/Tell_City
    {   95, 8038,   55409,  7, }, // America/Indiana/Vevay
    {   95, 8060,   55416,  8, }, // America/Indiana/Vincennes
    {   95, 8086,   55424,  9, }, // America/Indiana/Winamac
    {   95, 8110,   55433,  4, }, // America/Inuvik
    {   95,  521,   55437,  4, }, // America/Kentucky/Louisville
    {   95, 8153,   55441,  3, }, // America/Maceio
    {   95, 8168,   55444,  3, }, // America/Managua
    {   95, 5805,   55447,  4, }, // America/Martinique
    {   95, 8202,   55451,  4, }, // America/Menominee
    {   95, 4098,   55455,  5, }, // America/Montevideo
    {   95, 5824,   55460,  5, }, // America/Montserrat
    {   95, 5481,   55465,  2, }, // America/Nassau
    {   95, 1850,   55467,  4, }, // America/Noronha
    {   95, 8301,   55471,  8, }, // America/North_Dakota/Beulah
    {   95, 8329,   55479,  8, }, // America/North_Dakota/Center
    {   95, 8357,   55487,  9, }, // America/North_Dakota/New_Salem
    {   95, 8404,   55496,  3, }, // America/Porto_Velho
    {   95,  695,   55499,  5, }, // America/Rio_Branco
    {   95, 2201,   55504,  4, }, // America/Santiago
    {   95, 6111,   55508,  4, }, // America/Santo_Domingo
    {   95, 8508,   55512,  5, }, // America/St_Barthelemy
    {   95, 2061,   55517,  4, }, // America/St_Johns
    {   95, 5880,   55521,  4, }, // America/St_Lucia
    {   95, 5913,   55525,  4, }, // America/St_Vincent
    {   95, 5461,   55529,  6, }, // America/Tegucigalpa
    {   95, 5756,   55535,  2, }, // America/Thule
    {   95,  313,   55537,  3, }, // America/Tijuana
    {   95, 2144,   55540,  3, }, // America/Whitehorse
    {   95, 8552,   55543,  4, }, // America/Yakutat
    {   95, 6001,   55547,  3, }, // Antarctica/Casey
    {   95, 6094,   55550,  4, }, // Antarctica/Davis
    {   95, 6133,   55554,  6, }, // Antarctica/DumontDUrville
    {   95, 8568,   55560,  3, }, // Antarctica/Macquarie
    {   95, 7066,   55563,  3, }, // Antarctica/Mawson
    {   95, 7113,   55566,  5, }, // Antarctica/McMurdo
    {   95, 8589,   55571,  3, }, // Antarctica/Palmer
    {   95, 7226,   55574,  4, }, // Antarctica/Rothera
    {   95, 7295,   55578,  3, }, // Antarctica/Syowa
    {   95, 8607,   55581,  4, }, // Antarctica/Troll
    {   95, 1429,   55585,  4, }, // Arctic/Longyearbyen
    {   95, 5511,   55589,  4, }, // Asia/Anadyr
    {   95, 3778,   55593,  4, }, // Asia/Bishkek
    {   95, 4511,   55597,  3, }, // Asia/Colombo
    {   95, 6159,   55600,  3, }, // Asia/Dushanbe
    {   95, 4795,   55603,  3, }, // Asia/Hebron
    {   95, 4184,   55606,  5, }, // Asia/Irkutsk
    {   95, 6992,   55611,  4, }, // Asia/Jayapura
    {   95, 1349,   55615,  2, }, // Asia/Makassar
    {   95, 6920,   55617,  4, }, // Asia/Muscat
    {   95, 2554,   55621,  4, }, // Asia/Nicosia
    {   95, 5559,   55625,  3, }, // Asia/Qatar
    {   95, 4828,   55628,  4, }, // Asia/Yakutsk
    {   95, 3883,   55632,  5, }, // Asia/Yekaterinburg
    {   95, 8736,   55637,  4, }, // Atlantic/Madeira
    {   95, 6644,   55641,  3, }, // Atlantic/Stanley
    {   95, 1670,   55644,  4, }, // Australia/Adelaide
    {   95, 1635,   55648,  4, }, // Australia/Brisbane
    {   95, 1516,   55652,  3, }, // Australia/Hobart
    {   95, 6336,   55655,  5, }, // Europe/Belgrade
    {   95, 6488,   55660,  6, }, // Europe/Bratislava
    {   95, 2583,   55666,  4, }, // Europe/Chisinau
    {   95, 8788,   55670,  3, }, // Europe/Guernsey
    {   95, 8804,   55673,  3, }, // Europe/Isle_of_Man
    {   95, 6506,   55676,  5, }, // Europe/Ljubljana
    {   95, 6397,   55681,  3, }, // Europe/Malta
    {   95, 6245,   55684,  4, }, // Europe/Sarajevo
    {   95, 6352,   55688,  3, }, // Europe/Vaduz
    {   95, 6261,   55691,  4, }, // Europe/Zagreb
    {   95, 6947,   55695,  5, }, // Indian/Chagos
    {   95, 6063,   55700,  5, }, // Indian/Cocos
    {   95, 5029,   42789,  3, }, // Indian/Comoro
    {   95, 6661,   55705,  6, }, // Indian/Kerguelen
    {   95, 7050,   55711,  4, }, // Indian/Maldives
    {   95, 4069,   55715,  4, }, // Indian/Mauritius
    {   95, 5098,   42810,  3, }, // Indian/Mayotte
    {   95, 7211,   42814,  3, }, // Indian/Reunion
    {   95, 3706,   55719,  5, }, // Pacific/Bougainville
    {   95, 7327,   55724,  5, }, // Pacific/Fakaofo
    {   95, 6696,   42853,  3, }, // Pacific/Gambier
    {   95, 3822,   55729,  7, }, // Pacific/Guadalcanal
    {   95, 3049,   55736,  5, }, // Pacific/Kanton
    {   95, 7019,   55741,  3, }, // Pacific/Kosrae
    {   95, 2842,   55744,  5, }, // Pacific/Kwajalein
    {   95, 4877,   55749,  3, }, // Pacific/Majuro
    {   95, 4051,   55752,  6, }, // Pacific/Marquesas
    {   95, 7084,   55758,  2, }, // Pacific/Nauru
    {   95, 7194,   55760,  5, }, // Pacific/Pitcairn
    {   95, 4583,   55765,  5, }, // Pacific/Tongatapu
    {   95, 7392,   55770,  3, }, // Pacific/Wake
    {   96, 6788,   55240,  3, }, // Africa/Abidjan Chinese/Traditional Han/Macao
    {   96,   14,   55243,  4, }, // Africa/Asmara
    {   96, 5257,   55247,  2, }, // Africa/Bangui
    {   96, 6773,   55249,  4, }, // Africa/Conakry
    {   96, 5130,   55253,  6, }, // Africa/Dar_es_Salaam
    {   96, 4479,   55259,  5, }, // Africa/Johannesburg
    {   96, 5306,   55264,  3, }, // Africa/Kinshasa
    {   96, 5336,   55267,  3, }, // Africa/Libreville
    {   96, 5211,   55270,  3, }, // Africa/Luanda
    {   96, 5001,   55273,  3, }, // Africa/Lusaka
    {   96, 5197,   55276,  3, }, // Africa/Maseru
    {   96, 3853,   55279,  3, }, // Africa/Nairobi
    {   96, 4152,   55282,  4, }, // Africa/Windhoek
    {   96,  132,   55286,  3, }, // America/Adak
    {   96, 4554,   55289,  5, }, // America/Araguaina
    {   96,  270,   55294,  4, }, // America/Argentina/Cordoba
    {   96, 7462,   55298,  4, }, // America/Argentina/La_Rioja
    {   96, 5640,   55302,  3, }, // America/Aruba
    {   96, 4252,   55305,  3, }, // America/Asuncion
    {   96, 3679,   55308,  3, }, // America/Bahia
    {   96, 7623,   55311,  8, }, // America/Bahia_Banderas
    {   96, 5407,   55319,  3, }, // America/Belize
    {   96, 7681,   55322,  5, }, // America/Boa_Vista
    {   96, 7756,   55327,  3, }, // America/Chihuahua
    {   96, 7774,   41735,  4, }, // America/Ciudad_Juarez
    {   96, 5422,   55330,  5, }, // America/Costa_Rica
    {   96, 3791,   55335,  3, }, // America/Cuiaba
    {   96, 7848,   55338,  3, }, // America/Dawson_Creek
    {   96,  893,   55341,  3, }, // America/Edmonton
    {   96, 7906,   55344,  4, }, // America/Fortaleza
    {   96, 7924,   55348,  4, }, // America/Glace_Bay
    {   96, 5770,   55352,  4, }, // America/Grenada
    {   96, 5786,   55356,  4, }, // America/Guadeloupe
    {   96, 3760,   55360,  4, }, // America/Guatemala
    {   96, 6932,   55364,  3, }, // America/Guyana
    {   96, 2281,   55367,  3, }, // America/Havana
    {   96,  348,   55370,  7, }, // America/Indiana/Indianapolis
    {   96,  481,   55377,  8, }, // America/Indiana/Knox
    {   96, 7961,   55385,  8, }, // America/Indiana/Marengo
    {   96, 7985,   55393,  8, }, // America/Indiana/Petersburg
    {   96, 8012,   55401,  8, }, // America/Indiana/Tell_City
    {   96, 8038,   55409,  7, }, // America/Indiana/Vevay
    {   96, 8060,   55416,  8, }, // America/Indiana/Vincennes
    {   96, 8086,   55424,  9, }, // America/Indiana/Winamac
    {   96, 8110,   55433,  4, }, // America/Inuvik
    {   96,  521,   55437,  4, }, // America/Kentucky/Louisville
    {   96, 8153,   55441,  3, }, // America/Maceio
    {   96, 8168,   55444,  3, }, // America/Managua
    {   96, 5805,   55447,  4, }, // America/Martinique
    {   96, 8202,   55451,  4, }, // America/Menominee
    {   96, 4098,   55455,  5, }, // America/Montevideo
    {   96, 5824,   55460,  5, }, // America/Montserrat
    {   96, 5481,   55465,  2, }, // America/Nassau
    {   96, 1850,   55467,  4, }, // America/Noronha
    {   96, 8301,   55471,  8, }, // America/North_Dakota/Beulah
    {   96, 8329,   55479,  8, }, // America/North_Dakota/Center
    {   96, 8357,   55487,  9, }, // America/North_Dakota/New_Salem
    {   96, 8404,   55496,  3, }, // America/Porto_Velho
    {   96,  695,   55499,  5, }, // America/Rio_Branco
    {   96, 2201,   55504,  4, }, // America/Santiago
    {   96, 6111,   55508,  4, }, // America/Santo_Domingo
    {   96, 8508,   55512,  5, }, // America/St_Barthelemy
    {   96, 2061,   55517,  4, }, // America/St_Johns
    {   96, 5880,   55521,  4, }, // America/St_Lucia
    {   96, 5913,   55525,  4, }, // America/St_Vincent
    {   96, 5461,   55529,  6, }, // America/Tegucigalpa
    {   96, 5756,   55535,  2, }, // America/Thule
    {   96,  313,   55537,  3, }, // America/Tijuana
    {   96, 2144,   55540,  3, }, // America/Whitehorse
    {   96, 8552,   55543,  4, }, // America/Yakutat
    {   96, 6001,   55547,  3, }, // Antarctica/Casey
    {   96, 6094,   55550,  4, }, // Antarctica/Davis
    {   96, 6133,   55554,  6, }, // Antarctica/DumontDUrville
    {   96, 8568,   55560,  3, }, // Antarctica/Macquarie
    {   96, 7066,   55563,  3, }, // Antarctica/Mawson
    {   96, 7113,   55566,  5, }, // Antarctica/McMurdo
    {   96, 8589,   55571,  3, }, // Antarctica/Palmer
    {   96, 7226,   55574,  4, }, // Antarctica/Rothera
    {   96, 7295,   55578,  3, }, // Antarctica/Syowa
    {   96, 8607,   55581,  4, }, // Antarctica/Troll
    {   96, 1429,   55585,  4, }, // Arctic/Longyearbyen
    {   96, 5511,   55589,  4, }, // Asia/Anadyr
    {   96, 3778,   55593,  4, }, // Asia/Bishkek
    {   96, 4511,   55597,  3, }, // Asia/Colombo
    {   96, 6159,   55600,  3, }, // Asia/Dushanbe
    {   96, 4795,   55603,  3, }, // Asia/Hebron
    {   96, 4184,   55606,  5, }, // Asia/Irkutsk
    {   96, 6992,   55611,  4, }, // Asia/Jayapura
    {   96, 1349,   55615,  2, }, // Asia/Makassar
    {   96, 6920,   55617,  4, }, // Asia/Muscat
    {   96, 2554,   55621,  4, }, // Asia/Nicosia
    {   96, 5559,   55625,  3, }, // Asia/Qatar
    {   96, 4828,   55628,  4, }, // Asia/Yakutsk
    {   96, 3883,   55632,  5, }, // Asia/Yekaterinburg
    {   96, 8736,   55637,  4, }, // Atlantic/Madeira
    {   96, 6644,   55641,  3, }, // Atlantic/Stanley
    {   96, 1670,   55644,  4, }, // Australia/Adelaide
    {   96, 1635,   55648,  4, }, // Australia/Brisbane
    {   96, 1516,   55652,  3, }, // Australia/Hobart
    {   96, 6336,   55655,  5, }, // Europe/Belgrade
    {   96, 6488,   55660,  6, }, // Europe/Bratislava
    {   96, 2583,   55666,  4, }, // Europe/Chisinau
    {   96, 8788,   55670,  3, }, // Europe/Guernsey
    {   96, 8804,   55673,  3, }, // Europe/Isle_of_Man
    {   96, 6506,   55676,  5, }, // Europe/Ljubljana
    {   96, 6397,   55681,  3, }, // Europe/Malta
    {   96, 6245,   55684,  4, }, // Europe/Sarajevo
    {   96, 6352,   55688,  3, }, // Europe/Vaduz
    {   96, 6261,   55691,  4, }, // Europe/Zagreb
    {   96, 6947,   55695,  5, }, // Indian/Chagos
    {   96, 6063,   55700,  5, }, // Indian/Cocos
    {   96, 5029,   42789,  3, }, // Indian/Comoro
    {   96, 6661,   55705,  6, }, // Indian/Kerguelen
    {   96, 7050,   55711,  4, }, // Indian/Maldives
    {   96, 4069,   55715,  4, }, // Indian/Mauritius
    {   96, 5098,   42810,  3, }, // Indian/Mayotte
    {   96, 7211,   42814,  3, }, // Indian/Reunion
    {   96, 3706,   55719,  5, }, // Pacific/Bougainville
    {   96, 7327,   55724,  5, }, // Pacific/Fakaofo
    {   96, 6696,   42853,  3, }, // Pacific/Gambier
    {   96, 3822,   55729,  7, }, // Pacific/Guadalcanal
    {   96, 3049,   55736,  5, }, // Pacific/Kanton
    {   96, 7019,   55741,  3, }, // Pacific/Kosrae
    {   96, 2842,   55744,  5, }, // Pacific/Kwajalein
    {   96, 4877,   55749,  3, }, // Pacific/Majuro
    {   96, 4051,   55752,  6, }, // Pacific/Marquesas
    {   96, 7084,   55758,  2, }, // Pacific/Nauru
    {   96, 7194,   55760,  5, }, // Pacific/Pitcairn
    {   96, 4583,   55765,  5, }, // Pacific/Tongatapu
    {   96, 7392,   55770,  3, }, // Pacific/Wake
    {   98, 6788,   41435,  3, }, // Africa/Abidjan Chinese/Traditional Han/Taiwan
    {   98, 5059,   41441,  6, }, // Africa/Addis_Ababa
    {   98, 7420,   41447,  4, }, // Africa/Algiers
    {   98,   14,   41451,  4, }, // Africa/Asmara
    {   98,   44,   41455,  3, }, // Africa/Bamako
    {   98, 6746,   41460,  2, }, // Africa/Banjul
    {   98, 7435,   41462,  2, }, // Africa/Bissau
    {   98, 4957,   41464,  4, }, // Africa/Blantyre
    {   98, 5287,   41468,  5, }, // Africa/Brazzaville
    {   98, 4922,   41473,  4, }, // Africa/Bujumbura
    {   98, 2320,   41477,  2, }, // Africa/Cairo
    {   98, 4117,   41479,  5, }, // Africa/Casablanca
    {   98, 7449,   41484,  2, }, // Africa/Ceuta
    {   98, 6773,   41486,  4, }, // Africa/Conakry
    {   98, 6840,   41490,  3, }, // Africa/Dakar
    {   98, 5130,   41493,  3, }, // Africa/Dar_es_Salaam
    {   98, 5043,   41496,  3, }, // Africa/Djibouti
    {   98, 6853,   41505,  3, }, // Africa/Freetown
    {   98, 4906,   41508,  4, }, // Africa/Gaborone
    {   98, 4479,   41515,  5, }, // Africa/Johannesburg
    {   98, 5306,   41531,  3, }, // Africa/Kinshasa
    {   98, 4744,   41534,  3, }, // Africa/Lagos
    {   98, 5336,   41537,  3, }, // Africa/Libreville
    {   98, 5211,   41542,  3, }, // Africa/Luanda
    {   98, 4939,   41545,  4, }, // Africa/Lubumbashi
    {   98, 5001,   41549,  3, }, // Africa/Lusaka
    {   98, 5322,   41552,  3, }, // Africa/Malabo
    {   98, 4987,   41555,  3, }, // Africa/Maputo
    {   98, 5197,   41558,  3, }, // Africa/Maseru
    {   98, 5182,   41561,  3, }, // Africa/Mbabane
    {   98, 5113,   41564,  4, }, // Africa/Mogadishu
    {   98, 7034,   41568,  4, }, // Africa/Monrovia
    {   98, 3853,   41572,  3, }, // Africa/Nairobi
    {   98, 5271,   41575,  4, }, // Africa/Ndjamena
    {   98, 5354,   41579,  3, }, // Africa/Niamey
    {   98, 6803,   41582,  3, }, // Africa/Nouakchott
    {   98, 5225,   41589,  4, }, // Africa/Porto-Novo
    {   98, 4435,   41593,  3, }, // Africa/Sao_Tome
    {   98, 4152,   41603,  4, }, // Africa/Windhoek
    {   98,  132,   41607,  3, }, // America/Adak
    {   98, 3346,   41610,  4, }, // America/Anchorage
    {   98, 5607,   55773,  3, }, // America/Anguilla
    {   98, 5624,   41617,  3, }, // America/Antigua
    {   98, 4554,   41620,  4, }, // America/Araguaina
    {   98,  166,   41624,  7, }, // America/Argentina/Buenos_Aires
    {   98,   91,   41631,  4, }, // America/Argentina/Catamarca
    {   98,  270,   41635,  3, }, // America/Argentina/Cordoba
    {   98, 7462,   41641,  3, }, // America/Argentina/La_Rioja
    {   98,  565,   41644,  3, }, // America/Argentina/Mendoza
    {   98, 7489,   41647,  6, }, // America/Argentina/Rio_Gallegos
    {   98, 7520,   41653,  3, }, // America/Argentina/Salta
    {   98, 7544,   41656,  3, }, // America/Argentina/San_Juan
    {   98, 5580,   41659,  3, }, // America/Argentina/San_Luis
    {   98, 7571,   41662,  3, }, // America/Argentina/Tucuman
    {   98, 7597,   41665,  4, }, // America/Argentina/Ushuaia
    {   98, 5640,   55776,  5, }, // America/Aruba
    {   98, 4252,   41672,  3, }, // America/Asuncion
    {   98, 3679,   41679,  3, }, // America/Bahia
    {   98, 7623,   41682,  7, }, // America/Bahia_Banderas
    {   98, 5654,   41689,  3, }, // America/Barbados
    {   98, 7646,   41692,  2, }, // America/Belem
    {   98, 5407,   41694,  3, }, // America/Belize
    {   98, 7660,   41697,  5, }, // America/Blanc-Sablon
    {   98, 7681,   41702,  4, }, // America/Boa_Vista
    {   98, 7699,   41709,  2, }, // America/Boise
    {   98, 7713,   41711,  3, }, // America/Cambridge_Bay
    {   98, 7735,   41714,  3, }, // America/Campo_Grande
    {   98, 4694,   41719,  4, }, // America/Caracas
    {   98, 4345,   41723,  2, }, // America/Cayenne
    {   98, 5496,   41725,  4, }, // America/Cayman
    {   98, 7756,   41732,  3, }, // America/Chihuahua
    {   98, 7774,   41735,  3, }, // America/Ciudad_Juarez
    {   98, 5422,   41739,  5, }, // America/Costa_Rica
    {   98, 7796,   41744,  4, }, // America/Creston
    {   98, 3791,   41748,  3, }, // America/Cuiaba
    {   98, 5723,   41751,  3, }, // America/Curacao
    {   98, 7812,   41754,  4, }, // America/Danmarkshavn
    {   98, 5739,   55781,  4, }, // America/Dominica
    {   98,  893,   41774,  4, }, // America/Edmonton
    {   98, 7869,   41778,  4, }, // America/Eirunepe
    {   98, 5441,   41782,  4, }, // America/El_Salvador
    {   98, 7886,   41786,  4, }, // America/Fort_Nelson
    {   98, 7906,   41790,  4, }, // America/Fortaleza
    {   98, 7924,   41794,  4, }, // America/Glace_Bay
    {   98, 6881,   41798,  2, }, // America/Goose_Bay
    {   98, 4612,   41800,  4, }, // America/Grand_Turk
    {   98, 5770,   41804,  4, }, // America/Grenada
    {   98, 5786,   41808,  4, }, // America/Guadeloupe
    {   98, 3760,   41812,  4, }, // America/Guatemala
    {   98, 4841,   41816,  4, }, // America/Guayaquil
    {   98, 6932,   41820,  3, }, // America/Guyana
    {   98, 1939,   41823,  5, }, // America/Halifax
    {   98, 7942,   41831,  4, }, // America/Hermosillo
    {   98,  348,   41835,  7, }, // America/Indiana/Indianapolis
    {   98,  481,   41842,  8, }, // America/Indiana/Knox
    {   98, 7961,   41850,  8, }, // America/Indiana/Marengo
    {   98, 7985,   41858,  8, }, // America/Indiana/Petersburg
    {   98, 8012,   41866,  8, }, // America/Indiana/Tell_City
    {   98, 8038,   41874,  7, }, // America/Indiana/Vevay
    {   98, 8060,   41881,  8, }, // America/Indiana/Vincennes
    {   98, 8086,   41889,  9, }, // America/Indiana/Winamac
    {   98, 8110,   41898,  4, }, // America/Inuvik
    {   98, 2799,   41905,  3, }, // America/Jamaica
    {   98, 5380,   41908,  2, }, // America/Juneau
    {   98,  521,   41910,  5, }, // America/Kentucky/Louisville
    {   98, 8125,   41915,  8, }, // America/Kentucky/Monticello
    {   98, 5704,   41923,  5, }, // America/Kralendijk
    {   98, 7169,   41931,  2, }, // America/Lima
    {   98, 3239,   41933,  3, }, // America/Los_Angeles
    {   98, 5932,   41936,  4, }, // America/Lower_Princes
    {   98, 8153,   41940,  3, }, // America/Maceio
    {   98, 8168,   41943,  3, }, // America/Managua
    {   98, 1908,   41946,  3, }, // America/Manaus
    {   98, 5897,   41949,  4, }, // America/Marigot
    {   98, 5805,   41953,  4, }, // America/Martinique
    {   98, 8184,   41957,  5, }, // America/Matamoros
    {   98, 2917,   41962,  4, }, // America/Mazatlan
    {   98, 8202,   41966,  4, }, // America/Menominee
    {   98, 8220,   41970,  3, }, // America/Merida
    {   98, 2949,   41979,  4, }, // America/Mexico_City
    {   98, 4391,   41983,  3, }, // America/Miquelon
    {   98, 8254,   41986,  3, }, // America/Moncton
    {   98, 8270,   41989,  3, }, // America/Monterrey
    {   98, 4098,   41992,  4, }, // America/Montevideo
    {   98, 5824,   41996,  3, }, // America/Montserrat
    {   98, 5481,   41999,  2, }, // America/Nassau
    {   98, 2379,   42001,  2, }, // America/New_York
    {   98, 8288,   42003,  2, }, // America/Nome
    {   98, 1850,   42005,  3, }, // America/Noronha
    {   98, 8301,   42008,  8, }, // America/North_Dakota/Beulah
    {   98, 8329,   42016,  7, }, // America/North_Dakota/Center
    {   98, 8357,   42023,  8, }, // America/North_Dakota/New_Salem
    {   98, 8388,   42033,  4, }, // America/Ojinaga
    {   98, 2356,   42037,  3, }, // America/Panama
    {   98, 6173,   42040,  5, }, // America/Paramaribo
    {   98, 2973,   42045,  3, }, // America/Phoenix
    {   98, 8404,   42055,  3, }, // America/Porto_Velho
    {   98, 4030,   42062,  6, }, // America/Punta_Arenas
    {   98, 8424,   42068,  3, }, // America/Rankin_Inlet
    {   98, 8445,   42071,  3, }, // America/Recife
    {   98, 1995,   42074,  3, }, // America/Regina
    {   98, 8460,   42077,  4, }, // America/Resolute
    {   98,  695,   42081,  4, }, // America/Rio_Branco
    {   98, 8477,   42085,  3, }, // America/Santarem
    {   98, 2201,   42088,  4, }, // America/Santiago
    {   98, 6111,   42092,  4, }, // America/Santo_Domingo
    {   98, 1878,   42096,  3, }, // America/Sao_Paulo
    {   98, 6899,   42099,  7, }, // America/Scoresbysund
    {   98, 8494,   42106,  3, }, // America/Sitka
    {   98, 8508,   42109,  6, }, // America/St_Barthelemy
    {   98, 2061,   42115,  3, }, // America/St_Johns
    {   98, 5863,   42118,  3, }, // America/St_Kitts
    {   98, 5880,   42121,  4, }, // America/St_Lucia
    {   98,  855,   42125,  4, }, // America/St_Thomas
    {   98, 5913,   42129,  3, }, // America/St_Vincent
    {   98, 8530,   42132,  7, }, // America/Swift_Current
    {   98, 5461,   42139,  5, }, // America/Tegucigalpa
    {   98, 5756,   42144,  2, }, // America/Thule
    {   98,  313,   42146,  3, }, // America/Tijuana
    {   98,  608,   42149,  3, }, // America/Toronto
    {   98, 5688,   42152,  4, }, // America/Tortola
    {   98, 2093,   42156,  3, }, // America/Vancouver
    {   98, 2144,   42159,  4, }, // America/Whitehorse
    {   98,  734,   42163,  3, }, // America/Winnipeg
    {   98, 8552,   42166,  3, }, // America/Yakutat
    {   98, 6001,   42169,  2, }, // Antarctica/Casey
    {   98, 6094,   42171,  3, }, // Antarctica/Davis
    {   98, 6133,   42174,  5, }, // Antarctica/DumontDUrville
    {   98, 8568,   42179,  3, }, // Antarctica/Macquarie
    {   98, 7113,   42184,  4, }, // Antarctica/McMurdo
    {   98, 8589,   42188,  2, }, // Antarctica/Palmer
    {   98, 7226,   42190,  3, }, // Antarctica/Rothera
    {   98, 7295,   42193,  4, }, // Antarctica/Syowa
    {   98, 8607,   42197,  2, }, // Antarctica/Troll
    {   98, 1429,   42203,  5, }, // Arctic/Longyearbyen
    {   98, 5570,   42208,  2, }, // Asia/Aden
    {   98, 5395,   42210,  4, }, // Asia/Almaty
    {   98, 5511,   42216,  3, }, // Asia/Anadyr
    {   98, 5368,   42222,  4, }, // Asia/Aqtobe
    {   98,  964,   42226,  5, }, // Asia/Ashgabat
    {   98, 8624,   42231,  3, }, // Asia/Atyrau
    {   98, 3607,   42234,  3, }, // Asia/Baghdad
    {   98, 3653,   41750,  2, }, // Asia/Baku
    {   98, 3571,   42241,  4, }, // Asia/Barnaul
    {   98, 4086,   42245,  3, }, // Asia/Beirut
    {   98, 3778,   42248,  4, }, // Asia/Bishkek
    {   98, 5989,   42252,  2, }, // Asia/Brunei
    {   98, 4511,   42256,  3, }, // Asia/Colombo
    {   98, 4540,   42259,  4, }, // Asia/Damascus
    {   98, 1093,   42263,  2, }, // Asia/Dhaka
    {   98, 3596,   42267,  2, }, // Asia/Dubai
    {   98, 6159,   42269,  3, }, // Asia/Dushanbe
    {   98, 8636,   42272,  5, }, // Asia/Famagusta
    {   98, 8651,   42277,  2, }, // Asia/Gaza
    {   98, 4795,   42279,  3, }, // Asia/Hebron
    {   98, 4184,   42303,  5, }, // Asia/Irkutsk
    {   98, 7006,   42308,  3, }, // Asia/Jakarta
    {   98, 6992,   42311,  4, }, // Asia/Jayapura
    {   98, 3560,   42319,  3, }, // Asia/Kabul
    {   98, 4239,   42325,  3, }, // Asia/Karachi
    {   98, 1185,   42328,  4, }, // Asia/Kathmandu
    {   98, 8661,   42332,  3, }, // Asia/Khandyga
    {   98,  992,   42335,  4, }, // Asia/Kolkata
    {   98, 4197,   42339,  8, }, // Asia/Krasnoyarsk
    {   98, 5976,   42350,  2, }, // Asia/Kuching
    {   98, 1211,   42362,  2, }, // Asia/Macau
    {   98, 4017,   42369,  3, }, // Asia/Magadan
    {   98, 1349,   42372,  4, }, // Asia/Makassar
    {   98, 7182,   42376,  3, }, // Asia/Manila
    {   98, 6920,   42379,  4, }, // Asia/Muscat
    {   98, 2554,   42383,  4, }, // Asia/Nicosia
    {   98, 8675,   42387,  6, }, // Asia/Novokuznetsk
    {   98, 4135,   42393,  5, }, // Asia/Novosibirsk
    {   98, 7145,   42402,  3, }, // Asia/Oral
    {   98, 6961,   42405,  2, }, // Asia/Phnom_Penh
    {   98, 5559,   42411,  2, }, // Asia/Qatar
    {   98, 8708,   55785,  4, }, // Asia/Qostanay
    {   98, 4269,   42417,  6, }, // Asia/Qyzylorda
    {   98, 3584,   42423,  3, }, // Asia/Riyadh
    {   98, 4408,   42426,  3, }, // Asia/Sakhalin
    {   98, 7245,   42429,  4, }, // Asia/Samarkand
    {   98, 3279,   42433,  2, }, // Asia/Seoul
    {   98, 2772,   42455,  3, }, // Asia/Tehran
    {   98, 2821,   42460,  2, }, // Asia/Tokyo
    {   98, 1021,   42466,  4, }, // Asia/Ulaanbaatar
    {   98, 1159,   42470,  4, }, // Asia/Urumqi
    {   98, 8722,   42474,  4, }, // Asia/Ust-Nera
    {   98, 6977,   42478,  2, }, // Asia/Vientiane
    {   98, 4710,   42480,  3, }, // Asia/Vladivostok
    {   98, 4828,   42483,  4, }, // Asia/Yakutsk
    {   98, 3883,   42489,  5, }, // Asia/Yekaterinburg
    {   98, 3747,   42494,  3, }, // Asia/Yerevan
    {   98, 3663,   42497,  5, }, // Atlantic/Azores
    {   98, 5671,   42502,  3, }, // Atlantic/Bermuda
    {   98, 6628,   42505,  3, }, // Atlantic/Canary
    {   98, 3727,   42508,  3, }, // Atlantic/Cape_Verde
    {   98, 1395,   42511,  4, }, // Atlantic/Faroe
    {   98, 8736,   42515,  5, }, // Atlantic/Madeira
    {   98, 2748,   42520,  5, }, // Atlantic/Reykjavik
    {   98, 7272,   42525,  4, }, // Atlantic/South_Georgia
    {   98, 6821,   42529,  5, }, // Atlantic/St_Helena
    {   98, 6644,   42534,  3, }, // Atlantic/Stanley
    {   98, 1670,   42537,  4, }, // Australia/Adelaide
    {   98, 1635,   42541,  4, }, // Australia/Brisbane
    {   98, 1799,   42545,  5, }, // Australia/Broken_Hill
    {   98, 1583,   42550,  3, }, // Australia/Darwin
    {   98, 1516,   42556,  3, }, // Australia/Hobart
    {   98, 1547,   42562,  4, }, // Australia/Lord_Howe
    {   98, 1727,   42566,  3, }, // Australia/Melbourne
    {   98, 1762,   42569,  2, }, // Australia/Perth
    {   98, 1463,   42571,  2, }, // Australia/Sydney
    {   98, 6216,   42578,  3, }, // Europe/Andorra
    {   98, 6336,   42588,  4, }, // Europe/Belgrade
    {   98, 6488,   42594,  6, }, // Europe/Bratislava
    {   98, 2167,   42600,  4, }, // Europe/Brussels
    {   98, 3806,   42609,  4, }, // Europe/Budapest
    {   98, 2583,   55789,  3, }, // Europe/Chisinau
    {   98, 2338,   42623,  3, }, // Europe/Dublin
    {   98, 6307,   42626,  4, }, // Europe/Gibraltar
    {   98, 8788,   42630,  3, }, // Europe/Guernsey
    {   98, 6612,   42633,  4, }, // Europe/Helsinki
    {   98, 8804,   42637,  2, }, // Europe/Isle_of_Man
    {   98, 1130,   42639,  4, }, // Europe/Istanbul
    {   98, 8823,   42643,  3, }, // Europe/Jersey
    {   98, 3979,   42646,  5, }, // Europe/Kaliningrad
    {   98, 2527,   42654,  2, }, // Europe/Kyiv
    {   98, 6506,   42659,  4, }, // Europe/Ljubljana
    {   98, 2501,   42663,  2, }, // Europe/London
    {   98, 6365,   42665,  3, }, // Europe/Luxembourg
    {   98, 4892,   42668,  3, }, // Europe/Madrid
    {   98, 6397,   42671,  3, }, // Europe/Malta
    {   98, 6582,   42674,  3, }, // Europe/Mariehamn
    {   98, 6410,   42680,  3, }, // Europe/Monaco
    {   98, 6458,   42686,  3, }, // Europe/Oslo
    {   98, 6424,   42691,  4, }, // Europe/Podgorica
    {   98, 6324,   42700,  2, }, // Europe/Rome
    {   98, 4331,   42702,  3, }, // Europe/Samara
    {   98, 6470,   42705,  4, }, // Europe/San_Marino
    {   98, 6245,   42709,  4, }, // Europe/Sarajevo
    {   98, 4451,   42713,  4, }, // Europe/Saratov
    {   98, 8849,   42717,  4, }, // Europe/Simferopol
    {   98, 6383,   42721,  4, }, // Europe/Skopje
    {   98, 6599,   42725,  3, }, // Europe/Sofia
    {   98, 6523,   42728,  5, }, // Europe/Stockholm
    {   98, 8882,   42738,  7, }, // Europe/Ulyanovsk
    {   98, 6352,   42745,  3, }, // Europe/Vaduz
    {   98, 6567,   42748,  3, }, // Europe/Vatican
    {   98, 6231,   42751,  3, }, // Europe/Vienna
    {   98, 8899,   42754,  4, }, // Europe/Vilnius
    {   98, 4727,   42758,  5, }, // Europe/Volgograd
    {   98, 3190,   42763,  2, }, // Europe/Warsaw
    {   98, 6261,   42765,  4, }, // Europe/Zagreb
    {   98, 6540,   42769,  3, }, // Europe/Zurich
    {   98, 5078,   55792,  6, }, // Indian/Antananarivo
    {   98, 6046,   42781,  3, }, // Indian/Christmas
    {   98, 6063,   42784,  5, }, // Indian/Cocos
    {   98, 5029,   42789,  5, }, // Indian/Comoro
    {   98, 6661,   42794,  5, }, // Indian/Kerguelen
    {   98, 7260,   42799,  3, }, // Indian/Mahe
    {   98, 7050,   42802,  4, }, // Indian/Maldives
    {   98, 4069,   42806,  4, }, // Indian/Mauritius
    {   98, 5098,   42810,  4, }, // Indian/Mayotte
    {   98, 7211,   42814,  4, }, // Indian/Reunion
    {   98, 4422,   42818,  3, }, // Pacific/Apia
    {   98,  932,   42821,  3, }, // Pacific/Auckland
    {   98, 3706,   42824,  4, }, // Pacific/Bougainville
    {   98, 3015,   42828,  2, }, // Pacific/Chatham
    {   98, 3157,   42830,  2, }, // Pacific/Chuuk
    {   98, 2237,   42832,  3, }, // Pacific/Easter
    {   98, 3902,   42841,  2, }, // Pacific/Fiji
    {   98, 7343,   42843,  4, }, // Pacific/Funafuti
    {   98, 6678,   42847,  6, }, // Pacific/Galapagos
    {   98, 6696,   42853,  5, }, // Pacific/Gambier
    {   98, 3822,   42858,  6, }, // Pacific/Guadalcanal
    {   98, 6018,   42864,  2, }, // Pacific/Guam
    {   98, 3049,   42869,  5, }, // Pacific/Kanton
    {   98, 3998,   42874,  6, }, // Pacific/Kiritimati
    {   98, 7019,   42880,  3, }, // Pacific/Kosrae
    {   98, 2842,   42883,  4, }, // Pacific/Kwajalein
    {   98, 4877,   42887,  3, }, // Pacific/Majuro
    {   98, 4051,   42890,  5, }, // Pacific/Marquesas
    {   98, 8914,   42895,  3, }, // Pacific/Midway
    {   98, 7084,   42898,  2, }, // Pacific/Nauru
    {   98, 7132,   42900,  3, }, // Pacific/Niue
    {   98, 4168,   42903,  3, }, // Pacific/Norfolk
    {   98, 7098,   42906,  3, }, // Pacific/Noumea
    {   98, 3126,   42909,  4, }, // Pacific/Pago_Pago
    {   98, 7155,   42913,  2, }, // Pacific/Palau
    {   98, 7194,   42915,  5, }, // Pacific/Pitcairn
    {   98, 3096,   42920,  3, }, // Pacific/Pohnpei
    {   98, 4807,   42923,  4, }, // Pacific/Port_Moresby
    {   98, 6076,   42927,  4, }, // Pacific/Rarotonga
    {   98, 7312,   42933,  3, }, // Pacific/Tahiti
    {   98, 4583,   42939,  5, }, // Pacific/Tongatapu
    {   99,   14,       0,  6, }, // Africa/Asmara Church/Cyrillic/Russia
    {   99, 4435,       6,  8, }, // Africa/Sao_Tome
    {   99, 4252,      14,  8, }, // America/Asuncion
    {   99,  237,      22,  8, }, // America/Atikokan
    {   99, 7623,      30, 17, }, // America/Bahia_Banderas
    {   99, 3868,      47,  6, }, // America/Cancun
    {   99, 7774,      53, 13, }, // America/Ciudad_Juarez
    {   99, 5723,      66,  7, }, // America/Curacao
    {   99,  481,      73, 13, }, // America/Indiana/Knox
    {   99, 7961,      86, 16, }, // America/Indiana/Marengo
    {   99, 7985,     102, 19, }, // America/Indiana/Petersburg
    {   99, 8012,     121, 18, }, // America/Indiana/Tell_City
    {   99, 8038,     139, 14, }, // America/Indiana/Vevay
    {   99, 8060,     153, 18, }, // America/Indiana/Vincennes
    {   99, 8086,     171, 16, }, // America/Indiana/Winamac
    {   99, 8125,     187, 20, }, // America/Kentucky/Monticello
    {   99, 5932,     207, 22, }, // America/Lower_Princes
    {   99, 8220,     229,  6, }, // America/Merida
    {   99, 8301,     235, 20, }, // America/North_Dakota/Beulah
    {   99, 8329,     255, 20, }, // America/North_Dakota/Center
    {   99, 8357,     275, 23, }, // America/North_Dakota/New_Salem
    {   99,  393,     298,  4, }, // America/Nuuk
    {   99, 6899,     302, 16, }, // America/Scoresbysund
    {   99, 8508,     318, 14, }, // America/St_Barthelemy
    {   99, 2061,     332, 10, }, // America/St_Johns
    {   99, 5863,     342,  9, }, // America/St_Kitts
    {   99, 5880,     351,  9, }, // America/St_Lucia
    {   99,  855,     360, 10, }, // America/St_Thomas
    {   99, 5913,     370, 11, }, // America/St_Vincent
    {   99, 6133,     381, 16, }, // Antarctica/DumontDUrville
    {   99, 5395,   55798,  8, }, // Asia/Almaty
    {   99, 5511,   55806,  9, }, // Asia/Anadyr
    {   99, 5523,   55815,  7, }, // Asia/Aqtau
    {   99, 5368,   55822, 12, }, // Asia/Aqtobe
    {   99, 3778,   55834,  8, }, // Asia/Bishkek
    {   99, 4601,   55842,  5, }, // Asia/Chita
    {   99, 1259,     397, 11, }, // Asia/Ho_Chi_Minh
    {   99, 4184,   55847, 10, }, // Asia/Irkutsk
    {   99, 4316,   55857, 27, }, // Asia/Kamchatka
    {   99, 1185,     413,  9, }, // Asia/Kathmandu
    {   99, 8661,   55884,  8, }, // Asia/Khandyga
    {   99,  992,     422,  7, }, // Asia/Kolkata
    {   99, 4197,   55892, 12, }, // Asia/Krasnoyarsk
    {   99, 1211,     429,  5, }, // Asia/Macau
    {   99, 4017,   55904,  9, }, // Asia/Magadan
    {   99, 8675,   55913, 13, }, // Asia/Novokuznetsk
    {   99, 4135,   55926, 13, }, // Asia/Novosibirsk
    {   99, 4229,   55939,  7, }, // Asia/Omsk
    {   99, 7145,   55946, 11, }, // Asia/Oral
    {   99, 4269,   55957, 10, }, // Asia/Qyzylorda
    {   99, 4408,   55967,  9, }, // Asia/Sakhalin
    {   99, 4297,   55976, 15, }, // Asia/Srednekolymsk
    {   99, 8722,   55991, 13, }, // Asia/Ust-Nera
    {   99, 4710,   56004, 13, }, // Asia/Vladivostok
    {   99, 4828,   56017,  9, }, // Asia/Yakutsk
    {   99, 1235,     442,  6, }, // Asia/Yangon
    {   99, 3883,   56026, 15, }, // Asia/Yekaterinburg
    {   99, 1395,     448,  5, }, // Atlantic/Faroe
    {   99, 6821,     453, 10, }, // Atlantic/St_Helena
    {   99, 3979,   56041, 13, }, // Europe/Kaliningrad
    {   99, 2527,   56054,  6, }, // Europe/Kyiv
    {   99, 3693,   56060,  7, }, // Europe/Minsk
    {   99, 3537,   56067,  7, }, // Europe/Moscow
    {   99, 4331,   56074,  7, }, // Europe/Samara
    {   99, 8849,   56081, 12, }, // Europe/Simferopol
    {   99, 4727,   56093, 11, }, // Europe/Volgograd
    {   99, 7211,     467,  7, }, // Indian/Reunion
    {   99, 3157,     474,  5, }, // Pacific/Chuuk
    {   99, 3096,     479,  7, }, // Pacific/Pohnpei
    {  100, 6788,   36214,  7, }, // Africa/Abidjan Chuvash/Cyrillic/Russia
    {  100, 6760,     492,  5, }, // Africa/Accra
    {  100, 5059,     497, 11, }, // Africa/Addis_Ababa
    {  100, 7420,     508,  5, }, // Africa/Algiers
    {  100,   14,   56104,  6, }, // Africa/Asmara
    {  100,   44,     519,  6, }, // Africa/Bamako
    {  100, 5257,     525,  5, }, // Africa/Bangui
    {  100, 6746,     530,  6, }, // Africa/Banjul
    {  100, 7435,     536,  5, }, // Africa/Bissau
    {  100, 4957,   27088,  8, }, // Africa/Blantyre
    {  100, 5287,   51422, 10, }, // Africa/Brazzaville
    {  100, 4922,     558,  9, }, // Africa/Bujumbura
    {  100, 2320,     567,  4, }, // Africa/Cairo
    {  100, 4117,     571, 10, }, // Africa/Casablanca
    {  100, 7449,     581,  5, }, // Africa/Ceuta
    {  100, 6773,     586,  7, }, // Africa/Conakry
    {  100, 6840,     593,  5, }, // Africa/Dakar
    {  100, 5130,   27116, 12, }, // Africa/Dar_es_Salaam
    {  100, 5043,   36247,  7, }, // Africa/Djibouti
    {  100, 5243,     616,  5, }, // Africa/Douala
    {  100, 5166,   27135,  7, }, // Africa/El_Aaiun
    {  100, 6853,     628,  7, }, // Africa/Freetown
    {  100, 4906,     635,  8, }, // Africa/Gaborone
    {  100, 5015,   33781,  6, }, // Africa/Harare
    {  100, 4479,   51440, 12, }, // Africa/Johannesburg
    {  100, 4499,   27173,  5, }, // Africa/Juba
    {  100, 5151,     665,  7, }, // Africa/Kampala
    {  100, 4524,     672,  6, }, // Africa/Khartoum
    {  100, 4973,     678,  6, }, // Africa/Kigali
    {  100, 5306,     684,  7, }, // Africa/Kinshasa
    {  100, 4744,     691,  5, }, // Africa/Lagos
    {  100, 5336,   51452,  9, }, // Africa/Libreville
    {  100, 6869,     704,  4, }, // Africa/Lome
    {  100, 5211,     708,  6, }, // Africa/Luanda
    {  100, 4939,     714,  9, }, // Africa/Lubumbashi
    {  100, 5001,     723,  6, }, // Africa/Lusaka
    {  100, 5322,     729,  6, }, // Africa/Malabo
    {  100, 4987,     735,  6, }, // Africa/Maputo
    {  100, 5197,     741,  6, }, // Africa/Maseru
    {  100, 5182,     747,  7, }, // Africa/Mbabane
    {  100, 5113,     754,  8, }, // Africa/Mogadishu
    {  100, 7034,     762,  7, }, // Africa/Monrovia
    {  100, 3853,   36295,  7, }, // Africa/Nairobi
    {  100, 5271,   27254,  8, }, // Africa/Ndjamena
    {  100, 5354,   36302,  6, }, // Africa/Niamey
    {  100, 6803,     790,  7, }, // Africa/Nouakchott
    {  100, 6727,     797,  8, }, // Africa/Ouagadougou
    {  100, 5225,     805, 10, }, // Africa/Porto-Novo
    {  100, 4435,   56110, 17, }, // Africa/Sao_Tome
    {  100, 2866,     823,  7, }, // Africa/Tripoli
    {  100, 6554,     830,  5, }, // Africa/Tunis
    {  100, 4152,     835,  7, }, // Africa/Windhoek
    {  100,  132,     842,  4, }, // America/Adak
    {  100, 3346,   51461,  8, }, // America/Anchorage
    {  100, 5607,   51469,  7, }, // America/Anguilla
    {  100, 5624,     860,  7, }, // America/Antigua
    {  100, 4554,     867,  9, }, // America/Araguaina
    {  100,  166,   51476, 12, }, // America/Argentina/Buenos_Aires
    {  100,   91,     888,  9, }, // America/Argentina/Catamarca
    {  100,  270,     897,  7, }, // America/Argentina/Cordoba
    {  100,  441,   27355,  5, }, // America/Argentina/Jujuy
    {  100, 7462,     909,  8, }, // America/Argentina/La_Rioja
    {  100,  565,     917,  7, }, // America/Argentina/Mendoza
    {  100, 7489,   51488, 12, }, // America/Argentina/Rio_Gallegos
    {  100, 7520,   27380,  6, }, // America/Argentina/Salta
    {  100, 7544,     940,  8, }, // America/Argentina/San_Juan
    {  100, 5580,   56127, 17, }, // America/Argentina/San_Luis
    {  100, 7571,     956,  7, }, // America/Argentina/Tucuman
    {  100, 7597,   27394,  5, }, // America/Argentina/Ushuaia
    {  100, 5640,     969,  5, }, // America/Aruba
    {  100, 4252,   51500,  8, }, // America/Asuncion
    {  100,  237,     981, 12, }, // America/Atikokan
    {  100, 3679,   36368,  4, }, // America/Bahia
    {  100, 7623,   51508, 16, }, // America/Bahia_Banderas
    {  100, 5654,    1013,  8, }, // America/Barbados
    {  100, 7646,    1021,  5, }, // America/Belem
    {  100, 5407,    1026,  5, }, // America/Belize
    {  100, 7660,    1031, 12, }, // America/Blanc-Sablon
    {  100, 7681,    1043,  9, }, // America/Boa_Vista
    {  100, 4361,    1052,  6, }, // America/Bogota
    {  100, 7699,   51524,  5, }, // America/Boise
    {  100, 7713,   51529, 13, }, // America/Cambridge_Bay
    {  100, 7735,    1075, 12, }, // America/Campo_Grande
    {  100, 3868,    1087,  6, }, // America/Cancun
    {  100, 4694,    1093,  7, }, // America/Caracas
    {  100, 4345,   51542,  7, }, // America/Cayenne
    {  100, 5496,   56144, 16, }, // America/Cayman
    {  100, 2260,    1129,  6, }, // America/Chicago
    {  100, 7756,    1135,  6, }, // America/Chihuahua
    {  100, 7774,   56160, 13, }, // America/Ciudad_Juarez
    {  100, 5422,    1141, 10, }, // America/Costa_Rica
    {  100, 7796,    1151,  7, }, // America/Creston
    {  100, 3791,   27556,  5, }, // America/Cuiaba
    {  100, 5723,   36474,  7, }, // America/Curacao
    {  100, 7812,    1172, 12, }, // America/Danmarkshavn
    {  100, 7833,    1184,  6, }, // America/Dawson
    {  100, 7848,    1190, 11, }, // America/Dawson_Creek
    {  100,  805,    1201,  6, }, // America/Denver
    {  100, 3465,   36517,  7, }, // America/Detroit
    {  100, 5739,    1214,  8, }, // America/Dominica
    {  100,  893,   51549,  8, }, // America/Edmonton
    {  100, 7869,   51557,  8, }, // America/Eirunepe
    {  100, 5441,   27633,  9, }, // America/El_Salvador
    {  100, 7886,   51565, 12, }, // America/Fort_Nelson
    {  100, 7906,    1257,  9, }, // America/Fortaleza
    {  100, 7924,   51577,  9, }, // America/Glace_Bay
    {  100, 6881,   51586,  7, }, // America/Goose_Bay
    {  100, 4612,    1282, 10, }, // America/Grand_Turk
    {  100, 5770,    1292,  7, }, // America/Grenada
    {  100, 5786,    1299,  9, }, // America/Guadeloupe
    {  100, 3760,    1308,  9, }, // America/Guatemala
    {  100, 4841,   51593,  8, }, // America/Guayaquil
    {  100, 6932,   51601,  6, }, // America/Guyana
    {  100, 1939,   51607,  8, }, // America/Halifax
    {  100, 2281,    1339,  6, }, // America/Havana
    {  100, 7942,   51615,  9, }, // America/Hermosillo
    {  100,  348,    1353, 12, }, // America/Indiana/Indianapolis
    {  100,  481,    1365, 13, }, // America/Indiana/Knox
    {  100, 7961,    1378, 16, }, // America/Indiana/Marengo
    {  100, 7985,    1394, 19, }, // America/Indiana/Petersburg
    {  100, 8012,   56173, 18, }, // America/Indiana/Tell_City
    {  100, 8038,   56191, 14, }, // America/Indiana/Vevay
    {  100, 8060,   56205, 18, }, // America/Indiana/Vincennes
    {  100, 8086,   56223, 16, }, // America/Indiana/Winamac
    {  100, 8110,    1452,  6, }, // America/Inuvik
    {  100,  660,    1458,  7, }, // America/Iqaluit
    {  100, 2799,   27879,  6, }, // America/Jamaica
    {  100, 5380,   36614,  5, }, // America/Juneau
    {  100,  521,    1476,  8, }, // America/Kentucky/Louisville
    {  100, 8125,    1484, 20, }, // America/Kentucky/Monticello
    {  100, 5704,   36619, 10, }, // America/Kralendijk
    {  100, 4376,    1514,  6, }, // America/La_Paz
    {  100, 7169,    1520,  4, }, // America/Lima
    {  100, 3239,   51629, 12, }, // America/Los_Angeles
    {  100, 5932,   56239, 18, }, // America/Lower_Princes
    {  100, 8153,   36667,  6, }, // America/Maceio
    {  100, 8168,    1559,  7, }, // America/Managua
    {  100, 1908,    1566,  6, }, // America/Manaus
    {  100, 5897,    1572,  6, }, // America/Marigot
    {  100, 5805,    1578,  9, }, // America/Martinique
    {  100, 8184,    1587,  9, }, // America/Matamoros
    {  100, 2917,    1596,  8, }, // America/Mazatlan
    {  100, 8202,    1604,  8, }, // America/Menominee
    {  100, 8220,    1612,  6, }, // America/Merida
    {  100, 8235,    1618, 10, }, // America/Metlakatla
    {  100, 2949,    1628,  6, }, // America/Mexico_City
    {  100, 4391,    1634,  7, }, // America/Miquelon
    {  100, 8254,    1641,  7, }, // America/Moncton
    {  100, 8270,   51662,  9, }, // America/Monterrey
    {  100, 4098,    1657, 10, }, // America/Montevideo
    {  100, 5824,    1667, 10, }, // America/Montserrat
    {  100, 5481,    1677,  6, }, // America/Nassau
    {  100, 2379,   51680,  8, }, // America/New_York
    {  100, 8288,    1691,  3, }, // America/Nome
    {  100, 1850,   56257,  7, }, // America/Noronha
    {  100, 8301,   56264, 20, }, // America/North_Dakota/Beulah
    {  100, 8329,   56284, 20, }, // America/North_Dakota/Center
    {  100, 8357,   56304, 25, }, // America/North_Dakota/New_Salem
    {  100,  393,    1772,  4, }, // America/Nuuk
    {  100, 8388,    1776,  7, }, // America/Ojinaga
    {  100, 2356,    1783,  6, }, // America/Panama
    {  100, 6173,    1789, 10, }, // America/Paramaribo
    {  100, 2973,    1799,  6, }, // America/Phoenix
    {  100, 3945,    1805, 12, }, // America/Port-au-Prince
    {  100, 5954,   28189, 13, }, // America/Port_of_Spain
    {  100, 8404,   28202, 11, }, // America/Porto_Velho
    {  100, 5843,   51756, 11, }, // America/Puerto_Rico
    {  100, 4030,    1852, 12, }, // America/Punta_Arenas
    {  100, 8424,    1864, 12, }, // America/Rankin_Inlet
    {  100, 8445,    1876,  6, }, // America/Recife
    {  100, 1995,   51767,  8, }, // America/Regina
    {  100, 8460,   56329,  8, }, // America/Resolute
    {  100,  695,    1897, 10, }, // America/Rio_Branco
    {  100, 8477,    1907,  8, }, // America/Santarem
    {  100, 2201,   51775,  8, }, // America/Santiago
    {  100, 6111,    1923, 13, }, // America/Santo_Domingo
    {  100, 1878,   56337, 19, }, // America/Sao_Paulo
    {  100, 6899,    1945, 11, }, // America/Scoresbysund
    {  100, 8494,    1956,  5, }, // America/Sitka
    {  100, 8508,    1961, 13, }, // America/St_Barthelemy
    {  100, 2061,   28349, 10, }, // America/St_Johns
    {  100, 5863,    1983,  9, }, // America/St_Kitts
    {  100, 5880,   56356, 10, }, // America/St_Lucia
    {  100,  855,    2003, 10, }, // America/St_Thomas
    {  100, 5913,    2013, 12, }, // America/St_Vincent
    {  100, 8530,    2025, 13, }, // America/Swift_Current
    {  100, 5461,   51817, 12, }, // America/Tegucigalpa
    {  100, 5756,    2049,  4, }, // America/Thule
    {  100,  313,    2053,  7, }, // America/Tijuana
    {  100,  608,    2060,  7, }, // America/Toronto
    {  100, 5688,    2067,  7, }, // America/Tortola
    {  100, 2093,    2074,  8, }, // America/Vancouver
    {  100, 2144,   28435,  8, }, // America/Whitehorse
    {  100,  734,    2090,  8, }, // America/Winnipeg
    {  100, 8552,   28450,  6, }, // America/Yakutat
    {  100, 6001,   36889,  5, }, // Antarctica/Casey
    {  100, 6094,   36894,  6, }, // Antarctica/Davis
    {  100, 6133,   56366, 29, }, // Antarctica/DumontDUrville
    {  100, 8568,    2131,  8, }, // Antarctica/Macquarie
    {  100, 7066,    2139,  6, }, // Antarctica/Mawson
    {  100, 7113,    2145,  9, }, // Antarctica/McMurdo
    {  100, 8589,    2154,  6, }, // Antarctica/Palmer
    {  100, 7226,    2160,  6, }, // Antarctica/Rothera
    {  100, 7295,   28510,  4, }, // Antarctica/Syowa
    {  100, 8607,   51843,  6, }, // Antarctica/Troll
    {  100, 7374,   34825,  6, }, // Antarctica/Vostok
    {  100, 1429,   51849,  7, }, // Arctic/Longyearbyen
    {  100, 5570,    2192,  4, }, // Asia/Aden
    {  100, 5395,    2196,  6, }, // Asia/Almaty
    {  100, 3968,    2202,  5, }, // Asia/Amman
    {  100, 5511,   51870,  7, }, // Asia/Anadyr
    {  100, 5523,    2213,  5, }, // Asia/Aqtau
    {  100, 5368,    2218,  6, }, // Asia/Aqtobe
    {  100,  964,    2224,  7, }, // Asia/Ashgabat
    {  100, 8624,    2231,  6, }, // Asia/Atyrau
    {  100, 3607,    2237,  6, }, // Asia/Baghdad
    {  100, 5534,   36948,  7, }, // Asia/Bahrain
    {  100, 3653,    2250,  4, }, // Asia/Baku
    {  100, 4466,    2254,  7, }, // Asia/Bangkok
    {  100, 3571,    2261,  7, }, // Asia/Barnaul
    {  100, 4086,   28563,  6, }, // Asia/Beirut
    {  100, 3778,    2274,  6, }, // Asia/Bishkek
    {  100, 5989,   28575,  6, }, // Asia/Brunei
    {  100, 4601,    2286,  4, }, // Asia/Chita
    {  100, 4511,    2290,  7, }, // Asia/Colombo
    {  100, 4540,    2297,  6, }, // Asia/Damascus
    {  100, 1093,    2303,  5, }, // Asia/Dhaka
    {  100, 6192,    2308,  4, }, // Asia/Dili
    {  100, 3596,   28596,  5, }, // Asia/Dubai
    {  100, 6159,    2317,  7, }, // Asia/Dushanbe
    {  100, 8636,    2324,  9, }, // Asia/Famagusta
    {  100, 8651,    2333,  4, }, // Asia/Gaza
    {  100, 4795,    2337,  6, }, // Asia/Hebron
    {  100, 1259,    2343,  7, }, // Asia/Ho_Chi_Minh
    {  100, 2704,   51902,  7, }, // Asia/Hong_Kong
    {  100, 4771,    2357,  4, }, // Asia/Hovd
    {  100, 4184,    2361,  7, }, // Asia/Irkutsk
    {  100, 7006,   28638,  8, }, // Asia/Jakarta
    {  100, 6992,   28646,  8, }, // Asia/Jayapura
    {  100, 1290,    2383,  9, }, // Asia/Jerusalem
    {  100, 3560,    2392,  5, }, // Asia/Kabul
    {  100, 4316,   51927, 23, }, // Asia/Kamchatka
    {  100, 4239,    2422,  6, }, // Asia/Karachi
    {  100, 1185,    2428,  8, }, // Asia/Kathmandu
    {  100, 8661,    2436,  7, }, // Asia/Khandyga
    {  100,  992,   51950,  9, }, // Asia/Kolkata
    {  100, 4197,   36978, 10, }, // Asia/Krasnoyarsk
    {  100, 4859,    2462, 12, }, // Asia/Kuala_Lumpur
    {  100, 5976,    2474,  6, }, // Asia/Kuching
    {  100, 5547,   28693,  6, }, // Asia/Kuwait
    {  100, 1211,    2486,  5, }, // Asia/Macau
    {  100, 4017,    2491,  7, }, // Asia/Magadan
    {  100, 1349,    2498,  7, }, // Asia/Makassar
    {  100, 7182,    2505,  6, }, // Asia/Manila
    {  100, 6920,    2511,  6, }, // Asia/Muscat
    {  100, 2554,    2517,  6, }, // Asia/Nicosia
    {  100, 8675,    2524, 11, }, // Asia/Novokuznetsk
    {  100, 4135,    2535, 11, }, // Asia/Novosibirsk
    {  100, 4229,    2546,  4, }, // Asia/Omsk
    {  100, 7145,   28739,  7, }, // Asia/Oral
    {  100, 6961,   51959,  8, }, // Asia/Phnom_Penh
    {  100, 8693,    2563,  9, }, // Asia/Pontianak
    {  100, 4214,   28763,  7, }, // Asia/Pyongyang
    {  100, 5559,    2579,  5, }, // Asia/Qatar
    {  100, 8708,   37005,  8, }, // Asia/Qostanay
    {  100, 4269,    2592,  9, }, // Asia/Qyzylorda
    {  100, 3584,   51967,  7, }, // Asia/Riyadh
    {  100, 4408,   56395, 14, }, // Asia/Sakhalin
    {  100, 7245,    2621,  9, }, // Asia/Samarkand
    {  100, 3279,    2630,  4, }, // Asia/Seoul
    {  100, 1053,   28801,  6, }, // Asia/Shanghai
    {  100, 3300,    2640,  8, }, // Asia/Singapore
    {  100, 4297,    2648, 13, }, // Asia/Srednekolymsk
    {  100, 3263,   28829,  6, }, // Asia/Taipei
    {  100, 4781,    2667,  7, }, // Asia/Tashkent
    {  100, 3915,   35074,  7, }, // Asia/Tbilisi
    {  100, 2772,    2678,  7, }, // Asia/Tehran
    {  100, 1317,    2685,  7, }, // Asia/Thimphu
    {  100, 2821,    2692,  5, }, // Asia/Tokyo
    {  100, 4572,    2697,  5, }, // Asia/Tomsk
    {  100, 1021,    2702, 10, }, // Asia/Ulaanbaatar
    {  100, 1159,    2712,  6, }, // Asia/Urumqi
    {  100, 8722,   51993,  9, }, // Asia/Ust-Nera
    {  100, 6977,   52002,  8, }, // Asia/Vientiane
    {  100, 4710,    2733, 11, }, // Asia/Vladivostok
    {  100, 4828,   37051,  6, }, // Asia/Yakutsk
    {  100, 1235,   56409,  5, }, // Asia/Yangon
    {  100, 3883,    2757, 12, }, // Asia/Yekaterinburg
    {  100, 3747,    2769,  6, }, // Asia/Yerevan
    {  100, 3663,   56414, 14, }, // Atlantic/Azores
    {  100, 5671,   56428, 16, }, // Atlantic/Bermuda
    {  100, 6628,   56444, 15, }, // Atlantic/Canary
    {  100, 3727,    2826, 10, }, // Atlantic/Cape_Verde
    {  100, 1395,   56459, 15, }, // Atlantic/Faroe
    {  100, 8736,   37132,  7, }, // Atlantic/Madeira
    {  100, 2748,   52082,  9, }, // Atlantic/Reykjavik
    {  100, 7272,   56474, 13, }, // Atlantic/South_Georgia
    {  100, 6821,   56487, 20, }, // Atlantic/St_Helena
    {  100, 6644,   52124,  6, }, // Atlantic/Stanley
    {  100, 1670,    2917,  8, }, // Australia/Adelaide
    {  100, 1635,    2925,  7, }, // Australia/Brisbane
    {  100, 1799,    2932, 11, }, // Australia/Broken_Hill
    {  100, 1583,    2943,  6, }, // Australia/Darwin
    {  100, 3637,   29108,  4, }, // Australia/Eucla
    {  100, 1516,    2954,  6, }, // Australia/Hobart
    {  100, 8753,    2960,  8, }, // Australia/Lindeman
    {  100, 1547,    2968,  8, }, // Australia/Lord_Howe
    {  100, 1727,   29120,  8, }, // Australia/Melbourne
    {  100, 1762,    2983,  4, }, // Australia/Perth
    {  100, 1463,   52144,  6, }, // Australia/Sydney
    {  100, 6441,    2993,  9, }, // Europe/Amsterdam
    {  100, 6216,    3002,  7, }, // Europe/Andorra
    {  100, 3620,   29149,  9, }, // Europe/Astrakhan
    {  100, 2300,   56507,  7, }, // Europe/Athens
    {  100, 6336,    3021,  7, }, // Europe/Belgrade
    {  100, 4757,    3028,  6, }, // Europe/Berlin
    {  100, 6488,    3034, 10, }, // Europe/Bratislava
    {  100, 2167,   52164,  8, }, // Europe/Brussels
    {  100, 3928,    3052,  8, }, // Europe/Bucharest
    {  100, 3806,    3060,  8, }, // Europe/Budapest
    {  100, 8772,   37236,  8, }, // Europe/Busingen
    {  100, 2583,    3091,  7, }, // Europe/Chisinau
    {  100, 6289,   52191, 10, }, // Europe/Copenhagen
    {  100, 2338,    3108,  6, }, // Europe/Dublin
    {  100, 6307,    3114,  9, }, // Europe/Gibraltar
    {  100, 8788,    3123,  6, }, // Europe/Guernsey
    {  100, 6612,   52201,  9, }, // Europe/Helsinki
    {  100, 8804,   56514, 10, }, // Europe/Isle_of_Man
    {  100, 1130,    3146,  7, }, // Europe/Istanbul
    {  100, 8823,   52219,  6, }, // Europe/Jersey
    {  100, 3979,    3158, 11, }, // Europe/Kaliningrad
    {  100, 8929,    3169,  5, }, // Europe/Kirov
    {  100, 2527,    3174,  4, }, // Europe/Kyiv
    {  100, 3213,    3178,  8, }, // Europe/Lisbon
    {  100, 6506,   29300,  7, }, // Europe/Ljubljana
    {  100, 2501,    3195,  6, }, // Europe/London
    {  100, 6365,   29313, 10, }, // Europe/Luxembourg
    {  100, 4892,    3212,  6, }, // Europe/Madrid
    {  100, 6397,   29329,  6, }, // Europe/Malta
    {  100, 6582,    3223,  9, }, // Europe/Mariehamn
    {  100, 3693,    3232,  5, }, // Europe/Minsk
    {  100, 6410,    3237,  6, }, // Europe/Monaco
    {  100, 3537,   56524,  6, }, // Europe/Moscow
    {  100, 6458,    3249,  4, }, // Europe/Oslo
    {  100, 4284,    3253,  5, }, // Europe/Paris
    {  100, 6424,    3258,  9, }, // Europe/Podgorica
    {  100, 6275,    3267,  5, }, // Europe/Prague
    {  100, 8837,    3272,  4, }, // Europe/Riga
    {  100, 6324,    3276,  3, }, // Europe/Rome
    {  100, 4331,    3279,  6, }, // Europe/Samara
    {  100, 6470,    3285, 10, }, // Europe/San_Marino
    {  100, 6245,    3295,  7, }, // Europe/Sarajevo
    {  100, 4451,    3302,  7, }, // Europe/Saratov
    {  100, 8849,   52225, 11, }, // Europe/Simferopol
    {  100, 6383,   52236,  6, }, // Europe/Skopje
    {  100, 6599,    3324,  4, }, // Europe/Sofia
    {  100, 6523,   52242,  9, }, // Europe/Stockholm
    {  100, 8867,    3337,  6, }, // Europe/Tallinn
    {  100, 6202,    3343,  6, }, // Europe/Tirane
    {  100, 8882,   52251,  9, }, // Europe/Ulyanovsk
    {  100, 6352,    3358,  5, }, // Europe/Vaduz
    {  100, 6567,    3363,  7, }, // Europe/Vatican
    {  100, 6231,    3370,  4, }, // Europe/Vienna
    {  100, 8899,   52260,  7, }, // Europe/Vilnius
    {  100, 4727,    3381,  9, }, // Europe/Volgograd
    {  100, 3190,    3390,  7, }, // Europe/Warsaw
    {  100, 6261,    3397,  6, }, // Europe/Zagreb
    {  100, 6540,   37310,  5, }, // Europe/Zurich
    {  100, 5078,    3409, 12, }, // Indian/Antananarivo
    {  100, 6947,    3421,  5, }, // Indian/Chagos
    {  100, 6046,   56530, 13, }, // Indian/Christmas
    {  100, 6063,   56543, 15, }, // Indian/Cocos
    {  100, 5029,   56558,  8, }, // Indian/Comoro
    {  100, 6661,    3460,  8, }, // Indian/Kerguelen
    {  100, 7260,   29562,  3, }, // Indian/Mahe
    {  100, 7050,   56566, 10, }, // Indian/Maldives
    {  100, 4069,   56576,  8, }, // Indian/Mauritius
    {  100, 5098,   56584,  7, }, // Indian/Mayotte
    {  100, 7211,   52348,  7, }, // Indian/Reunion
    {  100, 4422,    3498,  4, }, // Pacific/Apia
    {  100,  932,    3502,  6, }, // Pacific/Auckland
    {  100, 3706,   52355,  9, }, // Pacific/Bougainville
    {  100, 3015,    3516,  5, }, // Pacific/Chatham
    {  100, 3157,    3521,  4, }, // Pacific/Chuuk
    {  100, 2237,   56591, 13, }, // Pacific/Easter
    {  100, 7360,   52409,  5, }, // Pacific/Efate
    {  100, 7327,    3541,  7, }, // Pacific/Fakaofo
    {  100, 3902,   37407,  5, }, // Pacific/Fiji
    {  100, 7343,    3552,  8, }, // Pacific/Funafuti
    {  100, 6678,   56604, 19, }, // Pacific/Galapagos
    {  100, 6696,   56623, 16, }, // Pacific/Gambier
    {  100, 3822,    3595, 11, }, // Pacific/Guadalcanal
    {  100, 6018,    3606,  4, }, // Pacific/Guam
    {  100, 3049,    3610,  6, }, // Pacific/Kanton
    {  100, 3998,    3616, 10, }, // Pacific/Kiritimati
    {  100, 7019,    3626,  6, }, // Pacific/Kosrae
    {  100, 2842,   29709, 10, }, // Pacific/Kwajalein
    {  100, 4877,   37442,  7, }, // Pacific/Majuro
    {  100, 4051,   56639, 18, }, // Pacific/Marquesas
    {  100, 8914,   52490,  6, }, // Pacific/Midway
    {  100, 7084,    3680,  5, }, // Pacific/Nauru
    {  100, 7132,   52504,  4, }, // Pacific/Niue
    {  100, 4168,    3689,  7, }, // Pacific/Norfolk
    {  100, 7098,    3696,  5, }, // Pacific/Noumea
    {  100, 3126,    3701,  9, }, // Pacific/Pago_Pago
    {  100, 7155,    3710,  5, }, // Pacific/Palau
    {  100, 7194,   56657,  7, }, // Pacific/Pitcairn
    {  100, 3096,    3722,  6, }, // Pacific/Pohnpei
    {  100, 4807,    3728, 11, }, // Pacific/Port_Moresby
    {  100, 6076,    3739,  9, }, // Pacific/Rarotonga
    {  100, 6031,   29803,  6, }, // Pacific/Saipan
    {  100, 7312,    3754,  5, }, // Pacific/Tahiti
    {  100, 6712,    3759,  6, }, // Pacific/Tarawa
    {  100, 4583,    3765,  9, }, // Pacific/Tongatapu
    {  100, 7392,   29823,  4, }, // Pacific/Wake
    {  100, 7405,    3778,  6, }, // Pacific/Wallis
    {  101,   14,       0,  6, }, // Africa/Asmara Colognian/Latin/Germany
    {  101, 2320,   56664,  6, }, // Africa/Cairo
    {  101, 4744,   56670,  6, }, // Africa/Lagos
    {  101, 4435,       6,  8, }, // Africa/Sao_Tome
    {  101, 4152,   56676,  7, }, // Africa/Windhoek
    {  101, 4252,      14,  8, }, // America/Asuncion
    {  101,  237,      22,  8, }, // America/Atikokan
    {  101, 7623,      30, 17, }, // America/Bahia_Banderas
    {  101, 3868,      47,  6, }, // America/Cancun
    {  101, 7774,      53, 13, }, // America/Ciudad_Juarez
    {  101, 5422,   56683, 10, }, // America/Costa_Rica
    {  101, 5723,      66,  7, }, // America/Curacao
    {  101, 4841,   56693,  9, }, // America/Guayaquil
    {  101,  481,   56702, 15, }, // America/Indiana/Knox
    {  101, 7961,   56717, 18, }, // America/Indiana/Marengo
    {  101, 7985,   56735, 21, }, // America/Indiana/Petersburg
    {  101, 8012,   56756, 20, }, // America/Indiana/Tell_City
    {  101, 8038,   56776, 16, }, // America/Indiana/Vevay
    {  101, 8060,   56792, 20, }, // America/Indiana/Vincennes
    {  101, 8086,   56812, 18, }, // America/Indiana/Winamac
    {  101, 8125,   56830, 22, }, // America/Kentucky/Monticello
    {  101, 5932,     207, 22, }, // America/Lower_Princes
    {  101, 8220,     229,  6, }, // America/Merida
    {  101, 2949,   56852, 14, }, // America/Mexico_City
    {  101, 8301,   56866, 21, }, // America/North_Dakota/Beulah
    {  101, 8329,   56887, 21, }, // America/North_Dakota/Center
    {  101, 8357,   56908, 24, }, // America/North_Dakota/New_Salem
    {  101,  393,     298,  4, }, // America/Nuuk
    {  101, 6899,     302, 16, }, // America/Scoresbysund
    {  101, 8508,   56932, 15, }, // America/St_Barthelemy
    {  101, 2061,   56947, 11, }, // America/St_Johns
    {  101, 5863,   56958, 10, }, // America/St_Kitts
    {  101, 5880,   56968, 16, }, // America/St_Lucia
    {  101,  855,   56984, 11, }, // America/St_Thomas
    {  101, 5913,   56995, 15, }, // America/St_Vincent
    {  101, 8552,    7399,  7, }, // America/Yakutat
    {  101, 6133,   57010, 27, }, // Antarctica/DumontDUrville
    {  101, 7295,   57037, 36, }, // Antarctica/Syowa
    {  101, 7374,    4029,  6, }, // Antarctica/Vostok
    {  101, 5368,   57073,  6, }, // Asia/Aqtobe
    {  101,  964,   57079,  9, }, // Asia/Ashgabat
    {  101, 3607,    4044,  6, }, // Asia/Baghdad
    {  101, 3778,   57088,  8, }, // Asia/Bishkek
    {  101, 4540,    4083,  8, }, // Asia/Damascus
    {  101, 6159,   57096,  9, }, // Asia/Dushanbe
    {  101, 8651,   57105,  5, }, // Asia/Gaza
    {  101, 1259,   57110, 30, }, // Asia/Ho_Chi_Minh
    {  101, 2704,    4113,  8, }, // Asia/Hong_Kong
    {  101, 4316,   57140, 11, }, // Asia/Kamchatka
    {  101, 1185,     413,  9, }, // Asia/Kathmandu
    {  101,  992,     422,  7, }, // Asia/Kolkata
    {  101, 4197,    4170, 11, }, // Asia/Krasnoyarsk
    {  101, 1211,     429,  5, }, // Asia/Macau
    {  101, 2554,   57151,  8, }, // Asia/Nicosia
    {  101, 6961,   57159,  9, }, // Asia/Phnom_Penh
    {  101, 4269,   57168,  9, }, // Asia/Qyzylorda
    {  101, 3584,   33439,  5, }, // Asia/Riyadh
    {  101, 1053,   57177,  9, }, // Asia/Shanghai
    {  101, 3300,   57186, 10, }, // Asia/Singapore
    {  101, 4781,   57196,  9, }, // Asia/Tashkent
    {  101, 3915,   57205,  6, }, // Asia/Tbilisi
    {  101, 1021,   26791, 10, }, // Asia/Ulaanbaatar
    {  101, 1159,   57211, 11, }, // Asia/Urumqi
    {  101, 4710,    4243, 11, }, // Asia/Vladivostok
    {  101, 4828,    7755,  7, }, // Asia/Yakutsk
    {  101, 1235,   57222,  6, }, // Asia/Yangon
    {  101, 3883,    4262, 13, }, // Asia/Yekaterinburg
    {  101, 3747,   57228,  6, }, // Asia/Yerevan
    {  101, 3663,   57234,  6, }, // Atlantic/Azores
    {  101, 6628,   57240,  8, }, // Atlantic/Canary
    {  101, 3727,   57248,  9, }, // Atlantic/Cape_Verde
    {  101, 1395,   57257,  5, }, // Atlantic/Faroe
    {  101, 6821,   57262, 11, }, // Atlantic/St_Helena
    {  101, 2300,    4320,  5, }, // Europe/Athens
    {  101, 6336,   57273,  7, }, // Europe/Belgrade
    {  101, 2167,   22634,  7, }, // Europe/Brussels
    {  101, 3928,   26897,  8, }, // Europe/Bucharest
    {  101, 6289,   57280, 10, }, // Europe/Copenhagen
    {  101, 6307,   57290,  9, }, // Europe/Gibraltar
    {  101, 8788,   57299,  7, }, // Europe/Guernsey
    {  101, 8804,   57306,  9, }, // Europe/Isle_of_Man
    {  101, 1130,   57315,  8, }, // Europe/Istanbul
    {  101, 8823,   57323,  6, }, // Europe/Jersey
    {  101, 3979,   57329, 13, }, // Europe/Kaliningrad
    {  101, 2527,     463,  4, }, // Europe/Kyiv
    {  101, 3213,    4381,  8, }, // Europe/Lisbon
    {  101, 6365,   57342, 11, }, // Europe/Luxembourg
    {  101, 3537,   57353,  6, }, // Europe/Moscow
    {  101, 6275,    8083,  4, }, // Europe/Prague
    {  101, 8837,   57359,  5, }, // Europe/Riga
    {  101, 6324,    5946,  3, }, // Europe/Rome
    {  101, 6202,   57364,  7, }, // Europe/Tirane
    {  101, 6567,   57371, 12, }, // Europe/Vatican
    {  101, 6231,   57383,  4, }, // Europe/Vienna
    {  101, 4727,   57387,  9, }, // Europe/Volgograd
    {  101, 3190,   57396,  8, }, // Europe/Warsaw
    {  101, 6261,   57404,  6, }, // Europe/Zagreb
    {  101, 6540,   57410,  7, }, // Europe/Zurich
    {  101, 7050,   57417,  8, }, // Indian/Maldives
    {  101, 7211,     467,  7, }, // Indian/Reunion
    {  101, 3157,     474,  5, }, // Pacific/Chuuk
    {  101, 6678,   57425, 10, }, // Pacific/Galapagos
    {  101, 6018,   57435,  4, }, // Pacific/Guam
    {  101, 2723,   57439,  8, }, // Pacific/Honolulu
    {  101, 7194,    8304,  7, }, // Pacific/Pitcairn
    {  101, 3096,     479,  7, }, // Pacific/Pohnpei
    {  102,   14,       0,  6, }, // Africa/Asmara Cornish/Latin/United Kingdom
    {  102, 4435,       6,  8, }, // Africa/Sao_Tome
    {  102, 4252,      14,  8, }, // America/Asuncion
    {  102,  237,      22,  8, }, // America/Atikokan
    {  102, 7623,      30, 17, }, // America/Bahia_Banderas
    {  102, 3868,      47,  6, }, // America/Cancun
    {  102, 7774,      53, 13, }, // America/Ciudad_Juarez
    {  102, 5723,      66,  7, }, // America/Curacao
    {  102,  481,      73, 13, }, // America/Indiana/Knox
    {  102, 7961,      86, 16, }, // America/Indiana/Marengo
    {  102, 7985,     102, 19, }, // America/Indiana/Petersburg
    {  102, 8012,     121, 18, }, // America/Indiana/Tell_City
    {  102, 8038,     139, 14, }, // America/Indiana/Vevay
    {  102, 8060,     153, 18, }, // America/Indiana/Vincennes
    {  102, 8086,     171, 16, }, // America/Indiana/Winamac
    {  102, 8125,     187, 20, }, // America/Kentucky/Monticello
    {  102, 5932,     207, 22, }, // America/Lower_Princes
    {  102, 8220,     229,  6, }, // America/Merida
    {  102, 8301,     235, 20, }, // America/North_Dakota/Beulah
    {  102, 8329,     255, 20, }, // America/North_Dakota/Center
    {  102, 8357,     275, 23, }, // America/North_Dakota/New_Salem
    {  102,  393,     298,  4, }, // America/Nuuk
    {  102, 6899,     302, 16, }, // America/Scoresbysund
    {  102, 8508,     318, 14, }, // America/St_Barthelemy
    {  102, 2061,     332, 10, }, // America/St_Johns
    {  102, 5863,     342,  9, }, // America/St_Kitts
    {  102, 5880,     351,  9, }, // America/St_Lucia
    {  102,  855,     360, 10, }, // America/St_Thomas
    {  102, 5913,     370, 11, }, // America/St_Vincent
    {  102, 6133,     381, 16, }, // Antarctica/DumontDUrville
    {  102, 1259,     397, 11, }, // Asia/Ho_Chi_Minh
    {  102, 1185,     413,  9, }, // Asia/Kathmandu
    {  102,  992,     422,  7, }, // Asia/Kolkata
    {  102, 1211,     429,  5, }, // Asia/Macau
    {  102, 1235,     442,  6, }, // Asia/Yangon
    {  102, 1395,     448,  5, }, // Atlantic/Faroe
    {  102, 6821,     453, 10, }, // Atlantic/St_Helena
    {  102, 2527,     463,  4, }, // Europe/Kyiv
    {  102, 7211,     467,  7, }, // Indian/Reunion
    {  102, 3157,     474,  5, }, // Pacific/Chuuk
    {  102, 3096,     479,  7, }, // Pacific/Pohnpei
    {  103,   14,       0,  6, }, // Africa/Asmara Corsican/Latin/France
    {  103, 4435,       6,  8, }, // Africa/Sao_Tome
    {  103, 4252,      14,  8, }, // America/Asuncion
    {  103,  237,      22,  8, }, // America/Atikokan
    {  103, 7623,      30, 17, }, // America/Bahia_Banderas
    {  103, 3868,      47,  6, }, // America/Cancun
    {  103, 7774,      53, 13, }, // America/Ciudad_Juarez
    {  103, 5723,      66,  7, }, // America/Curacao
    {  103,  481,      73, 13, }, // America/Indiana/Knox
    {  103, 7961,      86, 16, }, // America/Indiana/Marengo
    {  103, 7985,     102, 19, }, // America/Indiana/Petersburg
    {  103, 8012,     121, 18, }, // America/Indiana/Tell_City
    {  103, 8038,     139, 14, }, // America/Indiana/Vevay
    {  103, 8060,     153, 18, }, // America/Indiana/Vincennes
    {  103, 8086,     171, 16, }, // America/Indiana/Winamac
    {  103, 8125,     187, 20, }, // America/Kentucky/Monticello
    {  103, 5932,     207, 22, }, // America/Lower_Princes
    {  103, 8220,     229,  6, }, // America/Merida
    {  103, 8301,     235, 20, }, // America/North_Dakota/Beulah
    {  103, 8329,     255, 20, }, // America/North_Dakota/Center
    {  103, 8357,     275, 23, }, // America/North_Dakota/New_Salem
    {  103,  393,     298,  4, }, // America/Nuuk
    {  103, 6899,     302, 16, }, // America/Scoresbysund
    {  103, 8508,     318, 14, }, // America/St_Barthelemy
    {  103, 2061,     332, 10, }, // America/St_Johns
    {  103, 5863,     342,  9, }, // America/St_Kitts
    {  103, 5880,     351,  9, }, // America/St_Lucia
    {  103,  855,     360, 10, }, // America/St_Thomas
    {  103, 5913,     370, 11, }, // America/St_Vincent
    {  103, 6133,     381, 16, }, // Antarctica/DumontDUrville
    {  103, 1259,     397, 11, }, // Asia/Ho_Chi_Minh
    {  103, 1185,     413,  9, }, // Asia/Kathmandu
    {  103,  992,     422,  7, }, // Asia/Kolkata
    {  103, 1211,     429,  5, }, // Asia/Macau
    {  103, 1235,     442,  6, }, // Asia/Yangon
    {  103, 1395,     448,  5, }, // Atlantic/Faroe
    {  103, 6821,     453, 10, }, // Atlantic/St_Helena
    {  103, 2527,     463,  4, }, // Europe/Kyiv
    {  103, 7211,     467,  7, }, // Indian/Reunion
    {  103, 3157,     474,  5, }, // Pacific/Chuuk
    {  103, 3096,     479,  7, }, // Pacific/Pohnpei
    {  104, 5059,    3784, 11, }, // Africa/Addis_Ababa Croatian/Latin/Croatia
    {  104, 7420,   57447,  5, }, // Africa/Algiers
    {  104,   14,       0,  6, }, // Africa/Asmara
    {  104, 2320,    4572,  5, }, // Africa/Cairo
    {  104, 5043,   33154,  7, }, // Africa/Djibouti
    {  104, 6869,   20300,  4, }, // Africa/Lome
    {  104, 4435,       6,  8, }, // Africa/Sao_Tome
    {  104, 5607,   33168,  7, }, // America/Anguilla
    {  104, 4252,      14,  8, }, // America/Asuncion
    {  104,  237,      22,  8, }, // America/Atikokan
    {  104, 7623,    3825, 14, }, // America/Bahia_Banderas
    {  104, 3868,   33182,  6, }, // America/Cancun
    {  104, 7774,      53, 13, }, // America/Ciudad_Juarez
    {  104, 5422,   33188,  9, }, // America/Costa_Rica
    {  104, 5723,      66,  7, }, // America/Curacao
    {  104, 5739,   21548,  8, }, // America/Dominica
    {  104, 5441,    6688,  8, }, // America/El_Salvador
    {  104, 5786,   20408,  9, }, // America/Guadeloupe
    {  104, 3760,   33206,  9, }, // America/Guatemala
    {  104, 6932,   57452,  7, }, // America/Guyana
    {  104,  481,      73, 13, }, // America/Indiana/Knox
    {  104, 7961,      86, 16, }, // America/Indiana/Marengo
    {  104, 7985,     102, 19, }, // America/Indiana/Petersburg
    {  104, 8012,     121, 18, }, // America/Indiana/Tell_City
    {  104, 8038,     139, 14, }, // America/Indiana/Vevay
    {  104, 8060,     153, 18, }, // America/Indiana/Vincennes
    {  104, 8086,     171, 16, }, // America/Indiana/Winamac
    {  104, 2799,   33215,  7, }, // America/Jamaica
    {  104, 8125,     187, 20, }, // America/Kentucky/Monticello
    {  104, 5932,     207, 22, }, // America/Lower_Princes
    {  104, 8220,    7008,  6, }, // America/Merida
    {  104, 2949,   57459, 16, }, // America/Mexico_City
    {  104, 8301,   33222, 23, }, // America/North_Dakota/Beulah
    {  104, 8329,   33245, 23, }, // America/North_Dakota/Center
    {  104, 8357,   33268, 26, }, // America/North_Dakota/New_Salem
    {  104,  393,     298,  4, }, // America/Nuuk
    {  104, 5843,   33294,  9, }, // America/Puerto_Rico
    {  104, 6899,     302, 16, }, // America/Scoresbysund
    {  104, 8508,   35804, 16, }, // America/St_Barthelemy
    {  104, 2061,     332, 10, }, // America/St_Johns
    {  104, 5863,     342,  9, }, // America/St_Kitts
    {  104, 5880,     351,  9, }, // America/St_Lucia
    {  104,  855,     360, 10, }, // America/St_Thomas
    {  104, 5913,     370, 11, }, // America/St_Vincent
    {  104, 6133,     381, 16, }, // Antarctica/DumontDUrville
    {  104, 5395,   57475,  8, }, // Asia/Almaty
    {  104, 5511,    7482,  6, }, // Asia/Anadyr
    {  104, 5523,    5491,  5, }, // Asia/Aqtau
    {  104, 5368,    7488,  6, }, // Asia/Aqtobe
    {  104,  964,   57483,  7, }, // Asia/Ashgabat
    {  104, 3607,    4044,  6, }, // Asia/Baghdad
    {  104, 5534,    4050,  7, }, // Asia/Bahrain
    {  104, 3778,   33323,  6, }, // Asia/Bishkek
    {  104, 5989,   33329,  6, }, // Asia/Brunei
    {  104, 4601,   57490,  4, }, // Asia/Chita
    {  104, 4540,    4083,  6, }, // Asia/Damascus
    {  104, 6159,   33336,  7, }, // Asia/Dushanbe
    {  104, 1259,   33343,  9, }, // Asia/Ho_Chi_Minh
    {  104, 7006,   33352,  8, }, // Asia/Jakarta
    {  104, 1290,   33369,  9, }, // Asia/Jerusalem
    {  104, 4316,   33378,  8, }, // Asia/Kamchatka
    {  104, 4239,   33386,  6, }, // Asia/Karachi
    {  104, 1185,    5593,  8, }, // Asia/Kathmandu
    {  104, 8661,   33392,  7, }, // Asia/Khandyga
    {  104,  992,     422,  7, }, // Asia/Kolkata
    {  104, 4197,    4170, 11, }, // Asia/Krasnoyarsk
    {  104, 5547,    7607,  6, }, // Asia/Kuwait
    {  104, 1211,    7613,  5, }, // Asia/Macau
    {  104, 2554,   33410,  8, }, // Asia/Nicosia
    {  104, 8675,   33418, 12, }, // Asia/Novokuznetsk
    {  104, 4214,   33430,  9, }, // Asia/Pyongyang
    {  104, 5559,    4214,  5, }, // Asia/Qatar
    {  104, 8708,     434,  8, }, // Asia/Qostanay
    {  104, 4269,    7660,  9, }, // Asia/Qyzylorda
    {  104, 3584,   33439,  5, }, // Asia/Riyadh
    {  104, 4408,   33444,  7, }, // Asia/Sakhalin
    {  104, 3279,    7680,  4, }, // Asia/Seoul
    {  104, 1053,   33451,  6, }, // Asia/Shanghai
    {  104, 3300,   20782,  8, }, // Asia/Singapore
    {  104, 4297,    7699, 13, }, // Asia/Srednekolymsk
    {  104, 4781,   33457,  7, }, // Asia/Tashkent
    {  104, 2772,    7724,  7, }, // Asia/Tehran
    {  104, 2821,    4238,  5, }, // Asia/Tokyo
    {  104, 1021,   26791, 10, }, // Asia/Ulaanbaatar
    {  104, 1159,   33464,  6, }, // Asia/Urumqi
    {  104, 4828,    7755,  7, }, // Asia/Yakutsk
    {  104, 1235,    7762,  6, }, // Asia/Yangon
    {  104, 3883,    4262, 13, }, // Asia/Yekaterinburg
    {  104, 3747,   26815,  6, }, // Asia/Yerevan
    {  104, 3663,   33480,  5, }, // Atlantic/Azores
    {  104, 5671,   57494,  7, }, // Atlantic/Bermuda
    {  104, 6628,    4280,  6, }, // Atlantic/Canary
    {  104, 1395,   57501, 14, }, // Atlantic/Faroe
    {  104, 7272,   57515, 14, }, // Atlantic/South_Georgia
    {  104, 6821,   33494, 12, }, // Atlantic/St_Helena
    {  104, 6216,   33506,  6, }, // Europe/Andorra
    {  104, 3620,   33512,  8, }, // Europe/Astrakhan
    {  104, 2300,   26877,  5, }, // Europe/Athens
    {  104, 6336,    7942,  7, }, // Europe/Belgrade
    {  104, 2167,   57529,  9, }, // Europe/Brussels
    {  104, 3928,   33531,  8, }, // Europe/Bucharest
    {  104, 3806,   33539, 10, }, // Europe/Budapest
    {  104, 2583,   33549,  8, }, // Europe/Chisinau
    {  104, 6289,    4357, 10, }, // Europe/Copenhagen
    {  104, 8804,   57538,  8, }, // Europe/Isle_of_Man
    {  104, 3979,   33579, 12, }, // Europe/Kaliningrad
    {  104, 2527,   33591,  5, }, // Europe/Kyiv
    {  104, 3213,   33596,  7, }, // Europe/Lisbon
    {  104, 6365,    8054, 10, }, // Europe/Luxembourg
    {  104, 6410,    5926,  6, }, // Europe/Monaco
    {  104, 3537,   22748,  6, }, // Europe/Moscow
    {  104, 4284,   33603,  5, }, // Europe/Paris
    {  104, 6275,    8083,  4, }, // Europe/Prague
    {  104, 6324,   33608,  3, }, // Europe/Rome
    {  104, 8849,   33611, 11, }, // Europe/Simferopol
    {  104, 6383,   33622,  7, }, // Europe/Skopje
    {  104, 6599,   33629,  6, }, // Europe/Sofia
    {  104, 6202,   21095,  6, }, // Europe/Tirane
    {  104, 8882,    8143,  9, }, // Europe/Ulyanovsk
    {  104, 6567,    5978,  7, }, // Europe/Vatican
    {  104, 6231,   33643,  3, }, // Europe/Vienna
    {  104, 3190,   33646,  7, }, // Europe/Warsaw
    {  104, 6540,    4459,  6, }, // Europe/Zurich
    {  104, 7050,   33687,  7, }, // Indian/Maldives
    {  104, 4069,   33694, 10, }, // Indian/Mauritius
    {  104, 7211,     467,  7, }, // Indian/Reunion
    {  104, 3157,     474,  5, }, // Pacific/Chuuk
    {  104, 3902,   33704,  5, }, // Pacific/Fiji
    {  104, 2723,    4493,  8, }, // Pacific/Honolulu
    {  104, 3049,    4501,  9, }, // Pacific/Kanton
    {  104, 4051,   57546, 18, }, // Pacific/Marquesas
    {  104, 3096,     479,  7, }, // Pacific/Pohnpei
    {  106, 6788,   57564,  7, }, // Africa/Abidjan Czech/Latin/Czechia
    {  106, 5059,    3784, 11, }, // Africa/Addis_Ababa
    {  106, 7420,   57571,  5, }, // Africa/Algiers
    {  106,   14,       0,  6, }, // Africa/Asmara
    {  106, 2320,   57576,  6, }, // Africa/Cairo
    {  106, 5043,   33154,  7, }, // Africa/Djibouti
    {  106, 4524,   57582,  7, }, // Africa/Khartoum
    {  106, 6869,   20300,  4, }, // Africa/Lome
    {  106, 5113,   57589,  8, }, // Africa/Mogadishu
    {  106, 5271,   57597,  8, }, // Africa/Ndjamena
    {  106, 6803,   57605,  8, }, // Africa/Nouakchott
    {  106, 4435,   57613, 11, }, // Africa/Sao_Tome
    {  106, 2866,   57624,  8, }, // Africa/Tripoli
    {  106,  270,   20361,  7, }, // America/Argentina/Cordoba
    {  106, 4252,      14,  8, }, // America/Asuncion
    {  106,  237,      22,  8, }, // America/Atikokan
    {  106, 3679,      30,  5, }, // America/Bahia
    {  106, 7623,    3825, 14, }, // America/Bahia_Banderas
    {  106, 7646,   35764,  5, }, // America/Belem
    {  106, 4361,   20389,  6, }, // America/Bogota
    {  106, 3868,      47,  6, }, // America/Cancun
    {  106, 5496,   57632, 17, }, // America/Cayman
    {  106, 7774,      53, 13, }, // America/Ciudad_Juarez
    {  106, 5422,   33188,  9, }, // America/Costa_Rica
    {  106, 5723,      66,  7, }, // America/Curacao
    {  106, 5739,   21548,  8, }, // America/Dominica
    {  106, 5441,    6688,  8, }, // America/El_Salvador
    {  106,  481,      73, 13, }, // America/Indiana/Knox
    {  106, 7961,      86, 16, }, // America/Indiana/Marengo
    {  106, 7985,     102, 19, }, // America/Indiana/Petersburg
    {  106, 8012,     121, 18, }, // America/Indiana/Tell_City
    {  106, 8038,     139, 14, }, // America/Indiana/Vevay
    {  106, 8060,     153, 18, }, // America/Indiana/Vincennes
    {  106, 8086,     171, 16, }, // America/Indiana/Winamac
    {  106, 2799,   33215,  7, }, // America/Jamaica
    {  106, 8125,     187, 20, }, // America/Kentucky/Monticello
    {  106, 5932,     207, 22, }, // America/Lower_Princes
    {  106, 5805,    5142,  8, }, // America/Martinique
    {  106, 2917,   26471,  8, }, // America/Mazatlan
    {  106, 8220,    7008,  6, }, // America/Merida
    {  106, 2949,   57459, 16, }, // America/Mexico_City
    {  106, 8301,   57649, 22, }, // America/North_Dakota/Beulah
    {  106, 8329,   57671, 22, }, // America/North_Dakota/Center
    {  106, 8357,   57693, 25, }, // America/North_Dakota/New_Salem
    {  106,  393,     298,  4, }, // America/Nuuk
    {  106, 5843,   33294,  9, }, // America/Puerto_Rico
    {  106, 8477,   26572,  8, }, // America/Santarem
    {  106, 1878,   26580,  9, }, // America/Sao_Paulo
    {  106, 6899,     302, 16, }, // America/Scoresbysund
    {  106, 8508,   57718, 16, }, // America/St_Barthelemy
    {  106, 2061,     332, 10, }, // America/St_Johns
    {  106, 5863,   57734, 13, }, // America/St_Kitts
    {  106, 5880,   57747, 11, }, // America/St_Lucia
    {  106,  855,   57758, 21, }, // America/St_Thomas
    {  106, 5913,   57779, 13, }, // America/St_Vincent
    {  106, 6133,     381, 16, }, // Antarctica/DumontDUrville
    {  106, 3968,   57792,  5, }, // Asia/Amman
    {  106, 5523,    5491,  5, }, // Asia/Aqtau
    {  106, 5368,    7488,  6, }, // Asia/Aqtobe
    {  106,  964,   57797,  8, }, // Asia/Ashgabat
    {  106, 3607,   57805,  6, }, // Asia/Baghdad
    {  106, 5534,   57811,  7, }, // Asia/Bahrain
    {  106, 4086,   57818,  6, }, // Asia/Beirut
    {  106, 3778,   33323,  6, }, // Asia/Bishkek
    {  106, 5989,   33329,  6, }, // Asia/Brunei
    {  106, 4601,   57490,  4, }, // Asia/Chita
    {  106, 4511,    5519,  7, }, // Asia/Colombo
    {  106, 4540,   57824,  7, }, // Asia/Damascus
    {  106, 1093,   57831,  5, }, // Asia/Dhaka
    {  106, 3596,   57836,  5, }, // Asia/Dubai
    {  106, 6159,   33336,  7, }, // Asia/Dushanbe
    {  106, 1259,   57841, 18, }, // Asia/Ho_Chi_Minh
    {  106, 2704,    4113,  8, }, // Asia/Hong_Kong
    {  106, 1290,   57859,  9, }, // Asia/Jerusalem
    {  106, 3560,   57868,  5, }, // Asia/Kabul
    {  106, 4316,   33378,  8, }, // Asia/Kamchatka
    {  106, 4239,   57873,  6, }, // Asia/Karachi
    {  106, 1185,   57879,  9, }, // Asia/Kathmandu
    {  106, 8661,   57888,  8, }, // Asia/Khandyga
    {  106,  992,   57896,  7, }, // Asia/Kolkata
    {  106, 4197,    4170, 11, }, // Asia/Krasnoyarsk
    {  106, 5976,   33399,  6, }, // Asia/Kuching
    {  106, 5547,    7607,  6, }, // Asia/Kuwait
    {  106, 1211,     429,  5, }, // Asia/Macau
    {  106, 6920,   26750,  6, }, // Asia/Muscat
    {  106, 2554,   57903,  7, }, // Asia/Nicosia
    {  106, 8675,   57910, 11, }, // Asia/Novokuznetsk
    {  106, 7145,   57921,  6, }, // Asia/Oral
    {  106, 6961,   57927,  9, }, // Asia/Phnom_Penh
    {  106, 4214,   57936, 11, }, // Asia/Pyongyang
    {  106, 5559,    4214,  5, }, // Asia/Qatar
    {  106, 8708,    7652,  8, }, // Asia/Qostanay
    {  106, 4269,   26765,  9, }, // Asia/Qyzylorda
    {  106, 3584,   57947,  5, }, // Asia/Riyadh
    {  106, 4408,   57952,  8, }, // Asia/Sakhalin
    {  106, 3279,   57960,  4, }, // Asia/Seoul
    {  106, 1053,   57964,  7, }, // Asia/Shanghai
    {  106, 3300,   20782,  8, }, // Asia/Singapore
    {  106, 4297,   57971, 13, }, // Asia/Srednekolymsk
    {  106, 3263,   57984,  9, }, // Asia/Taipei
    {  106, 4781,   33457,  7, }, // Asia/Tashkent
    {  106, 2772,   57993,  7, }, // Asia/Tehran
    {  106, 1317,   58000,  6, }, // Asia/Thimphu
    {  106, 2821,    4238,  5, }, // Asia/Tokyo
    {  106, 1021,   58006,  9, }, // Asia/Ulaanbaatar
    {  106, 1159,   33464,  6, }, // Asia/Urumqi
    {  106, 4828,    7755,  7, }, // Asia/Yakutsk
    {  106, 1235,   20819,  6, }, // Asia/Yangon
    {  106, 3883,   58015, 13, }, // Asia/Yekaterinburg
    {  106, 3747,    7780,  7, }, // Asia/Yerevan
    {  106, 3663,   58028, 15, }, // Atlantic/Azores
    {  106, 5671,   58043,  7, }, // Atlantic/Bermuda
    {  106, 6628,   58050, 16, }, // Atlantic/Canary
    {  106, 3727,   58066,  8, }, // Atlantic/Cape_Verde
    {  106, 1395,   58074, 15, }, // Atlantic/Faroe
    {  106, 2748,   36044,  9, }, // Atlantic/Reykjavik
    {  106, 7272,   58089, 13, }, // Atlantic/South_Georgia
    {  106, 6821,   58102, 12, }, // Atlantic/St_Helena
    {  106, 3620,   58114,  9, }, // Europe/Astrakhan
    {  106, 2300,   58123,  6, }, // Europe/Athens
    {  106, 6336,   58129,  8, }, // Europe/Belgrade
    {  106, 4757,   20941,  6, }, // Europe/Berlin
    {  106, 2167,   26890,  6, }, // Europe/Brussels
    {  106, 3928,   58137,  8, }, // Europe/Bucharest
    {  106, 3806,   58145,  8, }, // Europe/Budapest
    {  106, 2583,   58153,  7, }, // Europe/Chisinau
    {  106, 6289,   58160,  5, }, // Europe/Copenhagen
    {  106, 6612,   58165,  8, }, // Europe/Helsinki
    {  106, 8804,   58173, 10, }, // Europe/Isle_of_Man
    {  106, 2527,   58183,  5, }, // Europe/Kyiv
    {  106, 3213,   33596,  7, }, // Europe/Lisbon
    {  106, 6506,   58188,  6, }, // Europe/Ljubljana
    {  106, 2501,   58194,  6, }, // Europe/London
    {  106, 6365,   58200,  9, }, // Europe/Luxembourg
    {  106, 6410,    5926,  6, }, // Europe/Monaco
    {  106, 3537,   22748,  6, }, // Europe/Moscow
    {  106, 4284,   58209,  5, }, // Europe/Paris
    {  106, 6275,   36153,  5, }, // Europe/Prague
    {  106, 6324,   58214,  3, }, // Europe/Rome
    {  106, 6599,   58217,  5, }, // Europe/Sofia
    {  106, 6202,   21095,  6, }, // Europe/Tirane
    {  106, 8882,    8143,  9, }, // Europe/Ulyanovsk
    {  106, 6567,   58222,  7, }, // Europe/Vatican
    {  106, 6231,   58229,  5, }, // Europe/Vienna
    {  106, 3190,   33646,  7, }, // Europe/Warsaw
    {  106, 6261,   58234,  6, }, // Europe/Zagreb
    {  106, 6540,   58240,  6, }, // Europe/Zurich
    {  106, 6046,   58246, 14, }, // Indian/Christmas
    {  106, 6063,   58260, 16, }, // Indian/Cocos
    {  106, 5029,   58276,  6, }, // Indian/Comoro
    {  106, 6661,   58282, 20, }, // Indian/Kerguelen
    {  106, 7260,   26983,  4, }, // Indian/Mahe
    {  106, 7050,   58302,  8, }, // Indian/Maldives
    {  106, 4069,   58310,  9, }, // Indian/Mauritius
    {  106, 7211,     467,  7, }, // Indian/Reunion
    {  106, 3015,   58319, 18, }, // Pacific/Chatham
    {  106, 3157,   58337, 16, }, // Pacific/Chuuk
    {  106, 2237,   58353, 18, }, // Pacific/Easter
    {  106, 7360,   27016,  5, }, // Pacific/Efate
    {  106, 3902,   33704,  5, }, // Pacific/Fiji
    {  106, 6678,   58371,  8, }, // Pacific/Galapagos
    {  106, 6696,   58379, 18, }, // Pacific/Gambier
    {  106, 2723,    4493,  8, }, // Pacific/Honolulu
    {  106, 3049,    4501,  9, }, // Pacific/Kanton
    {  106, 4051,   58397,  7, }, // Pacific/Marquesas
    {  106, 7098,    4510,  6, }, // Pacific/Noumea
    {  106, 7194,   58404, 19, }, // Pacific/Pitcairn
    {  106, 3096,     479,  7, }, // Pacific/Pohnpei
    {  107, 5059,    3784, 11, }, // Africa/Addis_Ababa Danish/Latin/Denmark
    {  107, 7420,   58423,  6, }, // Africa/Algiers
    {  107,   14,       0,  6, }, // Africa/Asmara
    {  107, 4435,       6,  8, }, // Africa/Sao_Tome
    {  107, 4252,      14,  8, }, // America/Asuncion
    {  107,  237,      22,  8, }, // America/Atikokan
    {  107, 7623,    3825, 14, }, // America/Bahia_Banderas
    {  107, 3868,   33182,  6, }, // America/Cancun
    {  107, 5496,   58429, 11, }, // America/Cayman
    {  107, 7774,      53, 13, }, // America/Ciudad_Juarez
    {  107, 5723,      66,  7, }, // America/Curacao
    {  107,  481,      73, 13, }, // America/Indiana/Knox
    {  107, 7961,      86, 16, }, // America/Indiana/Marengo
    {  107, 7985,     102, 19, }, // America/Indiana/Petersburg
    {  107, 8012,     121, 18, }, // America/Indiana/Tell_City
    {  107, 8038,     139, 14, }, // America/Indiana/Vevay
    {  107, 8060,     153, 18, }, // America/Indiana/Vincennes
    {  107, 8086,     171, 16, }, // America/Indiana/Winamac
    {  107, 8125,     187, 20, }, // America/Kentucky/Monticello
    {  107, 5932,     207, 22, }, // America/Lower_Princes
    {  107, 8220,    7008,  6, }, // America/Merida
    {  107, 8301,     235, 20, }, // America/North_Dakota/Beulah
    {  107, 8329,     255, 20, }, // America/North_Dakota/Center
    {  107, 8357,     275, 23, }, // America/North_Dakota/New_Salem
    {  107,  393,     298,  4, }, // America/Nuuk
    {  107, 1878,   26580,  9, }, // America/Sao_Paulo
    {  107, 6899,     302, 16, }, // America/Scoresbysund
    {  107, 8508,   26589, 16, }, // America/St_Barthelemy
    {  107, 2061,     332, 10, }, // America/St_Johns
    {  107, 5863,     342,  9, }, // America/St_Kitts
    {  107, 5880,     351,  9, }, // America/St_Lucia
    {  107,  855,     360, 10, }, // America/St_Thomas
    {  107, 5913,     370, 11, }, // America/St_Vincent
    {  107, 6133,     381, 16, }, // Antarctica/DumontDUrville
    {  107, 5523,    5491,  5, }, // Asia/Aqtau
    {  107, 5368,    7488,  6, }, // Asia/Aqtobe
    {  107,  964,   58440,  9, }, // Asia/Ashgabat
    {  107, 3607,    4044,  6, }, // Asia/Baghdad
    {  107, 3778,    4069,  7, }, // Asia/Bishkek
    {  107, 4540,    4083,  8, }, // Asia/Damascus
    {  107, 6159,   58449,  8, }, // Asia/Dushanbe
    {  107, 1259,     397, 16, }, // Asia/Ho_Chi_Minh
    {  107, 2704,    4113,  8, }, // Asia/Hong_Kong
    {  107, 4316,   58457,  9, }, // Asia/Kamchatka
    {  107, 1185,    5593,  8, }, // Asia/Kathmandu
    {  107,  992,     422,  7, }, // Asia/Kolkata
    {  107, 4197,    4170, 11, }, // Asia/Krasnoyarsk
    {  107, 1211,     429,  5, }, // Asia/Macau
    {  107, 8675,   58466, 12, }, // Asia/Novokuznetsk
    {  107, 8708,     434,  8, }, // Asia/Qostanay
    {  107, 4269,   26765,  9, }, // Asia/Qyzylorda
    {  107, 4781,   58478,  8, }, // Asia/Tashkent
    {  107, 2772,    7724,  7, }, // Asia/Tehran
    {  107, 1021,   26791, 10, }, // Asia/Ulaanbaatar
    {  107, 1159,   26801,  6, }, // Asia/Urumqi
    {  107, 4828,    7755,  7, }, // Asia/Yakutsk
    {  107, 1235,   58486,  7, }, // Asia/Yangon
    {  107, 3883,    4262, 13, }, // Asia/Yekaterinburg
    {  107, 3747,    7780,  7, }, // Asia/Yerevan
    {  107, 3663,   58493,  8, }, // Atlantic/Azores
    {  107, 6628,   58501, 16, }, // Atlantic/Canary
    {  107, 3727,   57248,  9, }, // Atlantic/Cape_Verde
    {  107, 1395,   58517,  8, }, // Atlantic/Faroe
    {  107, 6821,     453, 10, }, // Atlantic/St_Helena
    {  107, 2300,    4320,  5, }, // Europe/Athens
    {  107, 6336,    7942,  7, }, // Europe/Belgrade
    {  107, 2167,   57529,  9, }, // Europe/Brussels
    {  107, 3928,   26897,  8, }, // Europe/Bucharest
    {  107, 6289,   58525,  9, }, // Europe/Copenhagen
    {  107, 2527,    8030,  4, }, // Europe/Kyiv
    {  107, 3213,    4381,  8, }, // Europe/Lisbon
    {  107, 3537,   22748,  6, }, // Europe/Moscow
    {  107, 6275,    8083,  4, }, // Europe/Prague
    {  107, 6324,    5946,  3, }, // Europe/Rome
    {  107, 6202,   21095,  6, }, // Europe/Tirane
    {  107, 8882,    8143,  9, }, // Europe/Ulyanovsk
    {  107, 6567,   58534,  9, }, // Europe/Vatican
    {  107, 6231,   57383,  4, }, // Europe/Vienna
    {  107, 3190,   58543,  8, }, // Europe/Warsaw
    {  107, 6540,    4459,  6, }, // Europe/Zurich
    {  107, 6046,   58551,  7, }, // Indian/Christmas
    {  107, 5029,   58558,  9, }, // Indian/Comoro
    {  107, 7050,   58567, 10, }, // Indian/Maldives
    {  107, 7211,     467,  7, }, // Indian/Reunion
    {  107, 3157,     474,  5, }, // Pacific/Chuuk
    {  107, 2237,   58577,  8, }, // Pacific/Easter
    {  107, 2723,    4493,  8, }, // Pacific/Honolulu
    {  107, 3049,    4501,  9, }, // Pacific/Kanton
    {  107, 3096,     479,  7, }, // Pacific/Pohnpei
    {  109,   14,       0,  6, }, // Africa/Asmara Divehi/Thaana/Maldives
    {  109, 4435,       6,  8, }, // Africa/Sao_Tome
    {  109, 4252,      14,  8, }, // America/Asuncion
    {  109,  237,      22,  8, }, // America/Atikokan
    {  109, 7623,      30, 17, }, // America/Bahia_Banderas
    {  109, 3868,      47,  6, }, // America/Cancun
    {  109, 7774,      53, 13, }, // America/Ciudad_Juarez
    {  109, 5723,      66,  7, }, // America/Curacao
    {  109,  481,      73, 13, }, // America/Indiana/Knox
    {  109, 7961,      86, 16, }, // America/Indiana/Marengo
    {  109, 7985,     102, 19, }, // America/Indiana/Petersburg
    {  109, 8012,     121, 18, }, // America/Indiana/Tell_City
    {  109, 8038,     139, 14, }, // America/Indiana/Vevay
    {  109, 8060,     153, 18, }, // America/Indiana/Vincennes
    {  109, 8086,     171, 16, }, // America/Indiana/Winamac
    {  109, 8125,     187, 20, }, // America/Kentucky/Monticello
    {  109, 5932,     207, 22, }, // America/Lower_Princes
    {  109, 8220,     229,  6, }, // America/Merida
    {  109, 8301,     235, 20, }, // America/North_Dakota/Beulah
    {  109, 8329,     255, 20, }, // America/North_Dakota/Center
    {  109, 8357,     275, 23, }, // America/North_Dakota/New_Salem
    {  109,  393,     298,  4, }, // America/Nuuk
    {  109, 6899,     302, 16, }, // America/Scoresbysund
    {  109, 8508,     318, 14, }, // America/St_Barthelemy
    {  109, 2061,     332, 10, }, // America/St_Johns
    {  109, 5863,     342,  9, }, // America/St_Kitts
    {  109, 5880,     351,  9, }, // America/St_Lucia
    {  109,  855,     360, 10, }, // America/St_Thomas
    {  109, 5913,     370, 11, }, // America/St_Vincent
    {  109, 6133,     381, 16, }, // Antarctica/DumontDUrville
    {  109, 1259,     397, 11, }, // Asia/Ho_Chi_Minh
    {  109, 1185,     413,  9, }, // Asia/Kathmandu
    {  109,  992,     422,  7, }, // Asia/Kolkata
    {  109, 1211,     429,  5, }, // Asia/Macau
    {  109, 1235,     442,  6, }, // Asia/Yangon
    {  109, 1395,     448,  5, }, // Atlantic/Faroe
    {  109, 6821,     453, 10, }, // Atlantic/St_Helena
    {  109, 2527,     463,  4, }, // Europe/Kyiv
    {  109, 7211,     467,  7, }, // Indian/Reunion
    {  109, 3157,     474,  5, }, // Pacific/Chuuk
    {  109, 3096,     479,  7, }, // Pacific/Pohnpei
    {  110,   14,       0,  6, }, // Africa/Asmara Dogri/Devanagari/India
    {  110, 4435,       6,  8, }, // Africa/Sao_Tome
    {  110, 4252,      14,  8, }, // America/Asuncion
    {  110,  237,      22,  8, }, // America/Atikokan
    {  110, 7623,      30, 17, }, // America/Bahia_Banderas
    {  110, 3868,      47,  6, }, // America/Cancun
    {  110, 7774,      53, 13, }, // America/Ciudad_Juarez
    {  110, 5723,      66,  7, }, // America/Curacao
    {  110,  481,      73, 13, }, // America/Indiana/Knox
    {  110, 7961,      86, 16, }, // America/Indiana/Marengo
    {  110, 7985,     102, 19, }, // America/Indiana/Petersburg
    {  110, 8012,     121, 18, }, // America/Indiana/Tell_City
    {  110, 8038,     139, 14, }, // America/Indiana/Vevay
    {  110, 8060,     153, 18, }, // America/Indiana/Vincennes
    {  110, 8086,     171, 16, }, // America/Indiana/Winamac
    {  110, 8125,     187, 20, }, // America/Kentucky/Monticello
    {  110, 5932,     207, 22, }, // America/Lower_Princes
    {  110, 8220,     229,  6, }, // America/Merida
    {  110, 8301,     235, 20, }, // America/North_Dakota/Beulah
    {  110, 8329,     255, 20, }, // America/North_Dakota/Center
    {  110, 8357,     275, 23, }, // America/North_Dakota/New_Salem
    {  110,  393,     298,  4, }, // America/Nuuk
    {  110, 6899,     302, 16, }, // America/Scoresbysund
    {  110, 8508,     318, 14, }, // America/St_Barthelemy
    {  110, 2061,     332, 10, }, // America/St_Johns
    {  110, 5863,     342,  9, }, // America/St_Kitts
    {  110, 5880,     351,  9, }, // America/St_Lucia
    {  110,  855,     360, 10, }, // America/St_Thomas
    {  110, 5913,     370, 11, }, // America/St_Vincent
    {  110, 6133,     381, 16, }, // Antarctica/DumontDUrville
    {  110, 1259,     397, 11, }, // Asia/Ho_Chi_Minh
    {  110, 1185,     413,  9, }, // Asia/Kathmandu
    {  110,  992,     422,  7, }, // Asia/Kolkata
    {  110, 1211,     429,  5, }, // Asia/Macau
    {  110, 1235,     442,  6, }, // Asia/Yangon
    {  110, 1395,     448,  5, }, // Atlantic/Faroe
    {  110, 6821,     453, 10, }, // Atlantic/St_Helena
    {  110, 2527,     463,  4, }, // Europe/Kyiv
    {  110, 7211,     467,  7, }, // Indian/Reunion
    {  110, 3157,     474,  5, }, // Pacific/Chuuk
    {  110, 3096,     479,  7, }, // Pacific/Pohnpei
    {  111,   14,       0,  6, }, // Africa/Asmara Duala/Latin/Cameroon
    {  111, 4435,       6,  8, }, // Africa/Sao_Tome
    {  111, 4252,      14,  8, }, // America/Asuncion
    {  111,  237,      22,  8, }, // America/Atikokan
    {  111, 7623,      30, 17, }, // America/Bahia_Banderas
    {  111, 3868,      47,  6, }, // America/Cancun
    {  111, 7774,      53, 13, }, // America/Ciudad_Juarez
    {  111, 5723,      66,  7, }, // America/Curacao
    {  111,  481,      73, 13, }, // America/Indiana/Knox
    {  111, 7961,      86, 16, }, // America/Indiana/Marengo
    {  111, 7985,     102, 19, }, // America/Indiana/Petersburg
    {  111, 8012,     121, 18, }, // America/Indiana/Tell_City
    {  111, 8038,     139, 14, }, // America/Indiana/Vevay
    {  111, 8060,     153, 18, }, // America/Indiana/Vincennes
    {  111, 8086,     171, 16, }, // America/Indiana/Winamac
    {  111, 8125,     187, 20, }, // America/Kentucky/Monticello
    {  111, 5932,     207, 22, }, // America/Lower_Princes
    {  111, 8220,     229,  6, }, // America/Merida
    {  111, 8301,     235, 20, }, // America/North_Dakota/Beulah
    {  111, 8329,     255, 20, }, // America/North_Dakota/Center
    {  111, 8357,     275, 23, }, // America/North_Dakota/New_Salem
    {  111,  393,     298,  4, }, // America/Nuuk
    {  111, 6899,     302, 16, }, // America/Scoresbysund
    {  111, 8508,     318, 14, }, // America/St_Barthelemy
    {  111, 2061,     332, 10, }, // America/St_Johns
    {  111, 5863,     342,  9, }, // America/St_Kitts
    {  111, 5880,     351,  9, }, // America/St_Lucia
    {  111,  855,     360, 10, }, // America/St_Thomas
    {  111, 5913,     370, 11, }, // America/St_Vincent
    {  111, 6133,     381, 16, }, // Antarctica/DumontDUrville
    {  111, 1259,     397, 11, }, // Asia/Ho_Chi_Minh
    {  111, 1185,     413,  9, }, // Asia/Kathmandu
    {  111,  992,     422,  7, }, // Asia/Kolkata
    {  111, 1211,     429,  5, }, // Asia/Macau
    {  111, 1235,     442,  6, }, // Asia/Yangon
    {  111, 1395,     448,  5, }, // Atlantic/Faroe
    {  111, 6821,     453, 10, }, // Atlantic/St_Helena
    {  111, 2527,     463,  4, }, // Europe/Kyiv
    {  111, 7211,     467,  7, }, // Indian/Reunion
    {  111, 3157,     474,  5, }, // Pacific/Chuuk
    {  111, 3096,     479,  7, }, // Pacific/Pohnpei
    {  112, 5059,    3784, 11, }, // Africa/Addis_Ababa Dutch/Latin/Netherlands
    {  112,   14,       0,  6, }, // Africa/Asmara
    {  112, 2320,   58585,  5, }, // Africa/Cairo
    {  112, 4524,   58590,  8, }, // Africa/Khartoum
    {  112, 6869,   20300,  4, }, // Africa/Lome
    {  112, 4435,   58598,  8, }, // Africa/Sao_Tome
    {  112,  270,   20361,  7, }, // America/Argentina/Cordoba
    {  112, 7489,   44005, 12, }, // America/Argentina/Rio_Gallegos
    {  112, 7571,   20368,  7, }, // America/Argentina/Tucuman
    {  112, 4252,      14,  8, }, // America/Asuncion
    {  112,  237,      22,  8, }, // America/Atikokan
    {  112, 7623,      30, 17, }, // America/Bahia_Banderas
    {  112, 7646,   35764,  5, }, // America/Belem
    {  112, 3868,   33182,  6, }, // America/Cancun
    {  112, 7774,      53, 13, }, // America/Ciudad_Juarez
    {  112, 3791,   26442,  6, }, // America/Cuiaba
    {  112, 5723,      66,  7, }, // America/Curacao
    {  112,  481,      73, 13, }, // America/Indiana/Knox
    {  112, 7961,      86, 16, }, // America/Indiana/Marengo
    {  112, 7985,     102, 19, }, // America/Indiana/Petersburg
    {  112, 8012,     121, 18, }, // America/Indiana/Tell_City
    {  112, 8038,     139, 14, }, // America/Indiana/Vevay
    {  112, 8060,     153, 18, }, // America/Indiana/Vincennes
    {  112, 8086,     171, 16, }, // America/Indiana/Winamac
    {  112, 8125,     187, 20, }, // America/Kentucky/Monticello
    {  112, 5932,   58606, 24, }, // America/Lower_Princes
    {  112, 8153,   26456,  6, }, // America/Maceio
    {  112, 2917,   26471,  8, }, // America/Mazatlan
    {  112, 8220,     229,  6, }, // America/Merida
    {  112, 2949,   58630, 11, }, // America/Mexico_City
    {  112, 8301,    3895, 20, }, // America/North_Dakota/Beulah
    {  112, 8329,    3915, 20, }, // America/North_Dakota/Center
    {  112, 8357,    3935, 23, }, // America/North_Dakota/New_Salem
    {  112,  393,     298,  4, }, // America/Nuuk
    {  112, 1878,   26580,  9, }, // America/Sao_Paulo
    {  112, 6899,     302, 16, }, // America/Scoresbysund
    {  112, 8508,   26589, 16, }, // America/St_Barthelemy
    {  112, 2061,   26605, 12, }, // America/St_Johns
    {  112, 5863,   26617, 11, }, // America/St_Kitts
    {  112, 5880,   35832, 11, }, // America/St_Lucia
    {  112,  855,   44161, 12, }, // America/St_Thomas
    {  112, 5913,   26651, 13, }, // America/St_Vincent
    {  112, 6133,     381, 16, }, // Antarctica/DumontDUrville
    {  112, 5395,   58641,  8, }, // Asia/Almaty
    {  112, 5368,   57073,  6, }, // Asia/Aqtobe
    {  112,  964,    4035,  9, }, // Asia/Ashgabat
    {  112, 8624,   58649,  6, }, // Asia/Atyrau
    {  112, 3607,    4044,  6, }, // Asia/Baghdad
    {  112, 5534,    4050,  7, }, // Asia/Bahrain
    {  112, 3653,    4057,  5, }, // Asia/Baku
    {  112, 4086,    4062,  7, }, // Asia/Beirut
    {  112, 3778,    4069,  7, }, // Asia/Bishkek
    {  112, 6159,   58655,  9, }, // Asia/Dushanbe
    {  112, 1259,   58664, 15, }, // Asia/Ho_Chi_Minh
    {  112, 2704,    4113,  8, }, // Asia/Hong_Kong
    {  112, 4184,    4121,  8, }, // Asia/Irkutsk
    {  112, 1290,   33369,  9, }, // Asia/Jerusalem
    {  112, 4316,    4143, 10, }, // Asia/Kamchatka
    {  112, 1185,     413,  9, }, // Asia/Kathmandu
    {  112,  992,   35921,  8, }, // Asia/Kolkata
    {  112, 4197,    4170, 11, }, // Asia/Krasnoyarsk
    {  112, 5547,    4196,  7, }, // Asia/Kuwait
    {  112, 1211,    4203,  5, }, // Asia/Macau
    {  112, 7182,   58679,  7, }, // Asia/Manila
    {  112, 3584,   20756,  5, }, // Asia/Riyadh
    {  112, 4408,   57952,  8, }, // Asia/Sakhalin
    {  112, 1053,   58686,  8, }, // Asia/Shanghai
    {  112, 4781,   58478,  8, }, // Asia/Tashkent
    {  112, 2772,    7724,  7, }, // Asia/Tehran
    {  112, 2821,    4238,  5, }, // Asia/Tokyo
    {  112, 4828,    4254,  8, }, // Asia/Yakutsk
    {  112, 1235,   58486,  7, }, // Asia/Yangon
    {  112, 3883,   58694, 15, }, // Asia/Yekaterinburg
    {  112, 3747,    7780,  7, }, // Asia/Yerevan
    {  112, 3663,   58709,  6, }, // Atlantic/Azores
    {  112, 6628,   58715, 19, }, // Atlantic/Canary
    {  112, 3727,   58734, 10, }, // Atlantic/Cape_Verde
    {  112, 1395,   58744,  7, }, // Atlantic/Faroe
    {  112, 7272,   58751, 12, }, // Atlantic/South_Georgia
    {  112, 6821,   58763, 11, }, // Atlantic/St_Helena
    {  112, 2300,    4320,  6, }, // Europe/Athens
    {  112, 6336,   58774,  8, }, // Europe/Belgrade
    {  112, 4757,   58782,  7, }, // Europe/Berlin
    {  112, 2167,    4332,  7, }, // Europe/Brussels
    {  112, 3928,    4339,  9, }, // Europe/Bucharest
    {  112, 3806,    4348,  9, }, // Europe/Budapest
    {  112, 6289,    4357, 10, }, // Europe/Copenhagen
    {  112, 1130,   58789,  9, }, // Europe/Istanbul
    {  112, 2527,    8030,  4, }, // Europe/Kyiv
    {  112, 3213,    4381,  8, }, // Europe/Lisbon
    {  112, 2501,    4389,  6, }, // Europe/London
    {  112, 6365,    4395,  9, }, // Europe/Luxembourg
    {  112, 3537,    4404,  6, }, // Europe/Moscow
    {  112, 4284,   58798,  6, }, // Europe/Paris
    {  112, 6275,    4415,  5, }, // Europe/Prague
    {  112, 6202,   21095,  6, }, // Europe/Tirane
    {  112, 6567,   58804, 12, }, // Europe/Vatican
    {  112, 6231,   58816,  5, }, // Europe/Vienna
    {  112, 4727,    4443,  9, }, // Europe/Volgograd
    {  112, 3190,   57396,  8, }, // Europe/Warsaw
    {  112, 6540,    4459,  6, }, // Europe/Zurich
    {  112, 6947,   58821, 14, }, // Indian/Chagos
    {  112, 6046,   58835, 15, }, // Indian/Christmas
    {  112, 6063,   58850, 13, }, // Indian/Cocos
    {  112, 7260,   26983,  4, }, // Indian/Mahe
    {  112, 7050,   58863,  8, }, // Indian/Maldives
    {  112, 7211,     467,  7, }, // Indian/Reunion
    {  112, 3157,     474,  5, }, // Pacific/Chuuk
    {  112, 2237,   58871, 10, }, // Pacific/Easter
    {  112, 6696,   58881, 12, }, // Pacific/Gambier
    {  112, 2723,    4493,  8, }, // Pacific/Honolulu
    {  112, 3049,    4501,  9, }, // Pacific/Kanton
    {  112, 4051,   58893, 17, }, // Pacific/Marquesas
    {  112, 7098,    4510,  6, }, // Pacific/Noumea
    {  112, 3096,     479,  7, }, // Pacific/Pohnpei
    {  119, 6760,   58910,  6, }, // Africa/Accra Dzongkha/Tibetan/Bhutan
    {  119, 5059,   58916, 14, }, // Africa/Addis_Ababa
    {  119, 7420,   58930,  8, }, // Africa/Algiers
    {  119,   14,   58938,  7, }, // Africa/Asmara
    {  119,   44,   58945,  7, }, // Africa/Bamako
    {  119, 5257,   58952,  6, }, // Africa/Bangui
    {  119, 6746,   58958,  8, }, // Africa/Banjul
    {  119, 7435,   58966,  8, }, // Africa/Bissau
    {  119, 5287,   58974,  9, }, // Africa/Brazzaville
    {  119, 4922,   58983, 13, }, // Africa/Bujumbura
    {  119, 2320,   58996,  7, }, // Africa/Cairo
    {  119, 6773,   59003,  8, }, // Africa/Conakry
    {  119, 6840,   59011,  5, }, // Africa/Dakar
    {  119, 5043,   59016,  9, }, // Africa/Djibouti
    {  119, 4906,   59025, 12, }, // Africa/Gaborone
    {  119, 5015,   59037,  7, }, // Africa/Harare
    {  119, 5151,   59044,  7, }, // Africa/Kampala
    {  119, 4524,   59051,  7, }, // Africa/Khartoum
    {  119, 4973,   59058,  8, }, // Africa/Kigali
    {  119, 5306,   59066,  7, }, // Africa/Kinshasa
    {  119, 5336,   59073, 10, }, // Africa/Libreville
    {  119, 6869,   59083,  5, }, // Africa/Lome
    {  119, 5211,   59088,  8, }, // Africa/Luanda
    {  119, 5001,   59096,  7, }, // Africa/Lusaka
    {  119, 5322,   59103,  7, }, // Africa/Malabo
    {  119, 4987,   59110,  7, }, // Africa/Maputo
    {  119, 5197,   59117,  6, }, // Africa/Maseru
    {  119, 5182,   59123, 12, }, // Africa/Mbabane
    {  119, 5113,   59135, 11, }, // Africa/Mogadishu
    {  119, 7034,   59146, 11, }, // Africa/Monrovia
    {  119, 3853,   59157, 10, }, // Africa/Nairobi
    {  119, 5354,   59167,  7, }, // Africa/Niamey
    {  119, 6803,   59174, 10, }, // Africa/Nouakchott
    {  119, 6727,   59184, 10, }, // Africa/Ouagadougou
    {  119, 4435,   59194,  9, }, // Africa/Sao_Tome
    {  119, 2866,   59203,  9, }, // Africa/Tripoli
    {  119, 6554,   59212,  7, }, // Africa/Tunis
    {  119, 4152,   59219,  8, }, // Africa/Windhoek
    {  119, 5624,   59227, 11, }, // America/Antigua
    {  119,  166,   59238, 18, }, // America/Argentina/Buenos_Aires
    {  119, 4252,   59256, 12, }, // America/Asuncion
    {  119,  237,   59268, 11, }, // America/Atikokan
    {  119, 7623,      30, 17, }, // America/Bahia_Banderas
    {  119, 5654,   59279, 10, }, // America/Barbados
    {  119, 5407,   59289,  7, }, // America/Belize
    {  119, 4361,   59296,  7, }, // America/Bogota
    {  119, 7713,   59303, 15, }, // America/Cambridge_Bay
    {  119, 3868,      47,  6, }, // America/Cancun
    {  119, 4694,   59318,  7, }, // America/Caracas
    {  119, 2260,   59325,  8, }, // America/Chicago
    {  119, 7774,      53, 13, }, // America/Ciudad_Juarez
    {  119, 5422,   59333, 10, }, // America/Costa_Rica
    {  119, 5723,      66,  7, }, // America/Curacao
    {  119, 7833,   59343,  8, }, // America/Dawson
    {  119, 7848,   59351, 15, }, // America/Dawson_Creek
    {  119, 5739,   59366, 10, }, // America/Dominica
    {  119,  893,   59376, 12, }, // America/Edmonton
    {  119, 5441,   59388, 13, }, // America/El_Salvador
    {  119, 6881,   59401, 10, }, // America/Goose_Bay
    {  119, 3760,   59411,  9, }, // America/Guatemala
    {  119, 6932,   59420,  6, }, // America/Guyana
    {  119, 1939,   59426, 10, }, // America/Halifax
    {  119,  481,      73, 13, }, // America/Indiana/Knox
    {  119, 7961,      86, 16, }, // America/Indiana/Marengo
    {  119, 7985,     102, 19, }, // America/Indiana/Petersburg
    {  119, 8012,     121, 18, }, // America/Indiana/Tell_City
    {  119, 8038,     139, 14, }, // America/Indiana/Vevay
    {  119, 8060,     153, 18, }, // America/Indiana/Vincennes
    {  119, 8086,     171, 16, }, // America/Indiana/Winamac
    {  119, 8110,   59436,  9, }, // America/Inuvik
    {  119, 2799,   59445,  8, }, // America/Jamaica
    {  119, 8125,     187, 20, }, // America/Kentucky/Monticello
    {  119, 4376,   59453,  6, }, // America/La_Paz
    {  119, 7169,   59459,  4, }, // America/Lima
    {  119, 5932,     207, 22, }, // America/Lower_Princes
    {  119, 8220,     229,  6, }, // America/Merida
    {  119, 2949,   59463, 16, }, // America/Mexico_City
    {  119, 8254,   59479,  9, }, // America/Moncton
    {  119, 4098,   59488, 15, }, // America/Montevideo
    {  119, 5481,   59503,  5, }, // America/Nassau
    {  119, 8301,     235, 20, }, // America/North_Dakota/Beulah
    {  119, 8329,     255, 20, }, // America/North_Dakota/Center
    {  119, 8357,     275, 23, }, // America/North_Dakota/New_Salem
    {  119,  393,     298,  4, }, // America/Nuuk
    {  119, 2356,   59508,  5, }, // America/Panama
    {  119, 6173,   59513, 12, }, // America/Paramaribo
    {  119, 8424,   59525, 16, }, // America/Rankin_Inlet
    {  119, 1995,   59541,  7, }, // America/Regina
    {  119, 8460,   59548, 11, }, // America/Resolute
    {  119, 2201,   59559, 12, }, // America/Santiago
    {  119, 6111,   59571, 18, }, // America/Santo_Domingo
    {  119, 6899,     302, 16, }, // America/Scoresbysund
    {  119, 8508,     318, 14, }, // America/St_Barthelemy
    {  119, 2061,   59589, 17, }, // America/St_Johns
    {  119, 5863,     342,  9, }, // America/St_Kitts
    {  119, 5880,     351,  9, }, // America/St_Lucia
    {  119,  855,     360, 10, }, // America/St_Thomas
    {  119, 5913,     370, 11, }, // America/St_Vincent
    {  119, 8530,   59606, 14, }, // America/Swift_Current
    {  119, 5461,   59620, 14, }, // America/Tegucigalpa
    {  119,  313,   59634,  8, }, // America/Tijuana
    {  119,  608,   59642,  9, }, // America/Toronto
    {  119, 8552,   59651,  7, }, // America/Yakutat
    {  119, 6094,   59658,  7, }, // Antarctica/Davis
    {  119, 6133,     381, 16, }, // Antarctica/DumontDUrville
    {  119, 7066,   59665,  8, }, // Antarctica/Mawson
    {  119, 8589,   59673,  6, }, // Antarctica/Palmer
    {  119, 7226,   59679,  8, }, // Antarctica/Rothera
    {  119, 7374,   59687,  8, }, // Antarctica/Vostok
    {  119, 5534,   59695,  7, }, // Asia/Bahrain
    {  119, 5989,   59702,  8, }, // Asia/Brunei
    {  119, 4511,   59710, 10, }, // Asia/Colombo
    {  119, 1093,   59011,  4, }, // Asia/Dhaka
    {  119, 1259,     397, 11, }, // Asia/Ho_Chi_Minh
    {  119, 7006,   59720,  7, }, // Asia/Jakarta
    {  119, 6992,   59727,  8, }, // Asia/Jayapura
    {  119, 3560,   59735,  6, }, // Asia/Kabul
    {  119, 4239,   59741,  6, }, // Asia/Karachi
    {  119, 1185,   59747, 10, }, // Asia/Kathmandu
    {  119,  992,   59757,  8, }, // Asia/Kolkata
    {  119, 4859,   59765, 12, }, // Asia/Kuala_Lumpur
    {  119, 1211,     429,  5, }, // Asia/Macau
    {  119, 8693,   59777, 11, }, // Asia/Pontianak
    {  119, 2772,   59788,  6, }, // Asia/Tehran
    {  119, 1317,   59794,  7, }, // Asia/Thimphu
    {  119, 6977,   59801, 13, }, // Asia/Vientiane
    {  119, 1235,   59814,  7, }, // Asia/Yangon
    {  119, 5671,   59821,  7, }, // Atlantic/Bermuda
    {  119, 3727,   59828,  7, }, // Atlantic/Cape_Verde
    {  119, 1395,   59835,  8, }, // Atlantic/Faroe
    {  119, 2748,   59843, 11, }, // Atlantic/Reykjavik
    {  119, 7272,   59854, 11, }, // Atlantic/South_Georgia
    {  119, 6821,     453, 10, }, // Atlantic/St_Helena
    {  119, 6441,   59865,  9, }, // Europe/Amsterdam
    {  119, 6216,   59874,  8, }, // Europe/Andorra
    {  119, 2300,   59882,  8, }, // Europe/Athens
    {  119, 4757,   59890,  7, }, // Europe/Berlin
    {  119, 2167,   59897,  7, }, // Europe/Brussels
    {  119, 3928,   59904, 10, }, // Europe/Bucharest
    {  119, 3806,   59914, 10, }, // Europe/Budapest
    {  119, 2583,   59924,  9, }, // Europe/Chisinau
    {  119, 6289,   59933, 13, }, // Europe/Copenhagen
    {  119, 2338,   59946,  6, }, // Europe/Dublin
    {  119, 6612,   59952, 10, }, // Europe/Helsinki
    {  119, 2527,     463,  4, }, // Europe/Kyiv
    {  119, 2501,   59962,  7, }, // Europe/London
    {  119, 6365,   59969,  9, }, // Europe/Luxembourg
    {  119, 4892,   59978,  8, }, // Europe/Madrid
    {  119, 3693,   59986,  5, }, // Europe/Minsk
    {  119, 6410,   59991,  7, }, // Europe/Monaco
    {  119, 3537,   59998,  7, }, // Europe/Moscow
    {  119, 6458,   60005,  6, }, // Europe/Oslo
    {  119, 4284,   60011,  6, }, // Europe/Paris
    {  119, 6275,   60017,  3, }, // Europe/Prague
    {  119, 8837,   60020,  5, }, // Europe/Riga
    {  119, 6245,   60025,  9, }, // Europe/Sarajevo
    {  119, 6599,   60034,  7, }, // Europe/Sofia
    {  119, 6523,   60041, 12, }, // Europe/Stockholm
    {  119, 8867,   60053,  7, }, // Europe/Tallinn
    {  119, 6202,   60060,  6, }, // Europe/Tirane
    {  119, 6352,   60066,  6, }, // Europe/Vaduz
    {  119, 6231,   60072,  7, }, // Europe/Vienna
    {  119, 8899,   60079, 10, }, // Europe/Vilnius
    {  119, 3190,   60089,  5, }, // Europe/Warsaw
    {  119, 6540,   60094,  6, }, // Europe/Zurich
    {  119, 5078,   60100, 15, }, // Indian/Antananarivo
    {  119, 6046,   60115, 10, }, // Indian/Christmas
    {  119, 6063,   60125,  7, }, // Indian/Cocos
    {  119, 5029,   60132,  8, }, // Indian/Comoro
    {  119, 6661,   60140, 10, }, // Indian/Kerguelen
    {  119, 7050,   60150,  8, }, // Indian/Maldives
    {  119, 4069,   60158,  9, }, // Indian/Mauritius
    {  119, 7211,     467,  7, }, // Indian/Reunion
    {  119, 4422,   60167,  6, }, // Pacific/Apia
    {  119, 3157,     474,  5, }, // Pacific/Chuuk
    {  119, 7327,   60173,  8, }, // Pacific/Fakaofo
    {  119, 7343,   60181, 10, }, // Pacific/Funafuti
    {  119, 6696,   60191,  8, }, // Pacific/Gambier
    {  119, 4877,   60199,  8, }, // Pacific/Majuro
    {  119, 8914,   60207,  6, }, // Pacific/Midway
    {  119, 7084,   60213,  6, }, // Pacific/Nauru
    {  119, 3126,   60219, 10, }, // Pacific/Pago_Pago
    {  119, 7155,   60229,  5, }, // Pacific/Palau
    {  119, 3096,     479,  7, }, // Pacific/Pohnpei
    {  119, 6076,   60234, 12, }, // Pacific/Rarotonga
    {  119, 6031,   60246,  8, }, // Pacific/Saipan
    {  119, 4583,   60254, 10, }, // Pacific/Tongatapu
    {  119, 7392,   60264,  3, }, // Pacific/Wake
    {  120,   14,       0,  6, }, // Africa/Asmara Embu/Latin/Kenya
    {  120, 4435,       6,  8, }, // Africa/Sao_Tome
    {  120, 4252,      14,  8, }, // America/Asuncion
    {  120,  237,      22,  8, }, // America/Atikokan
    {  120, 7623,      30, 17, }, // America/Bahia_Banderas
    {  120, 3868,      47,  6, }, // America/Cancun
    {  120, 7774,      53, 13, }, // America/Ciudad_Juarez
    {  120, 5723,      66,  7, }, // America/Curacao
    {  120,  481,      73, 13, }, // America/Indiana/Knox
    {  120, 7961,      86, 16, }, // America/Indiana/Marengo
    {  120, 7985,     102, 19, }, // America/Indiana/Petersburg
    {  120, 8012,     121, 18, }, // America/Indiana/Tell_City
    {  120, 8038,     139, 14, }, // America/Indiana/Vevay
    {  120, 8060,     153, 18, }, // America/Indiana/Vincennes
    {  120, 8086,     171, 16, }, // America/Indiana/Winamac
    {  120, 8125,     187, 20, }, // America/Kentucky/Monticello
    {  120, 5932,     207, 22, }, // America/Lower_Princes
    {  120, 8220,     229,  6, }, // America/Merida
    {  120, 8301,     235, 20, }, // America/North_Dakota/Beulah
    {  120, 8329,     255, 20, }, // America/North_Dakota/Center
    {  120, 8357,     275, 23, }, // America/North_Dakota/New_Salem
    {  120,  393,     298,  4, }, // America/Nuuk
    {  120, 6899,     302, 16, }, // America/Scoresbysund
    {  120, 8508,     318, 14, }, // America/St_Barthelemy
    {  120, 2061,     332, 10, }, // America/St_Johns
    {  120, 5863,     342,  9, }, // America/St_Kitts
    {  120, 5880,     351,  9, }, // America/St_Lucia
    {  120,  855,     360, 10, }, // America/St_Thomas
    {  120, 5913,     370, 11, }, // America/St_Vincent
    {  120, 6133,     381, 16, }, // Antarctica/DumontDUrville
    {  120, 1259,     397, 11, }, // Asia/Ho_Chi_Minh
    {  120, 1185,     413,  9, }, // Asia/Kathmandu
    {  120,  992,     422,  7, }, // Asia/Kolkata
    {  120, 1211,     429,  5, }, // Asia/Macau
    {  120, 1235,     442,  6, }, // Asia/Yangon
    {  120, 1395,     448,  5, }, // Atlantic/Faroe
    {  120, 6821,     453, 10, }, // Atlantic/St_Helena
    {  120, 2527,     463,  4, }, // Europe/Kyiv
    {  120, 7211,     467,  7, }, // Indian/Reunion
    {  120, 3157,     474,  5, }, // Pacific/Chuuk
    {  120, 3096,     479,  7, }, // Pacific/Pohnpei
    {  121,   14,       0,  6, }, // Africa/Asmara English/Latin/United States
    {  121, 4435,       6,  8, }, // Africa/Sao_Tome
    {  121, 4252,      14,  8, }, // America/Asuncion
    {  121,  237,      22,  8, }, // America/Atikokan
    {  121, 7623,      30, 17, }, // America/Bahia_Banderas
    {  121, 3868,      47,  6, }, // America/Cancun
    {  121, 7774,      53, 13, }, // America/Ciudad_Juarez
    {  121, 5723,      66,  7, }, // America/Curacao
    {  121,  481,      73, 13, }, // America/Indiana/Knox
    {  121, 7961,      86, 16, }, // America/Indiana/Marengo
    {  121, 7985,     102, 19, }, // America/Indiana/Petersburg
    {  121, 8012,     121, 18, }, // America/Indiana/Tell_City
    {  121, 8038,     139, 14, }, // America/Indiana/Vevay
    {  121, 8060,     153, 18, }, // America/Indiana/Vincennes
    {  121, 8086,     171, 16, }, // America/Indiana/Winamac
    {  121, 8125,     187, 20, }, // America/Kentucky/Monticello
    {  121, 5932,     207, 22, }, // America/Lower_Princes
    {  121, 8220,     229,  6, }, // America/Merida
    {  121, 8301,     235, 20, }, // America/North_Dakota/Beulah
    {  121, 8329,     255, 20, }, // America/North_Dakota/Center
    {  121, 8357,     275, 23, }, // America/North_Dakota/New_Salem
    {  121,  393,     298,  4, }, // America/Nuuk
    {  121, 6899,     302, 16, }, // America/Scoresbysund
    {  121, 8508,     318, 14, }, // America/St_Barthelemy
    {  121, 2061,     332, 10, }, // America/St_Johns
    {  121, 5863,     342,  9, }, // America/St_Kitts
    {  121, 5880,     351,  9, }, // America/St_Lucia
    {  121,  855,     360, 10, }, // America/St_Thomas
    {  121, 5913,     370, 11, }, // America/St_Vincent
    {  121, 6133,     381, 16, }, // Antarctica/DumontDUrville
    {  121, 1259,     397, 16, }, // Asia/Ho_Chi_Minh
    {  121, 1185,     413,  9, }, // Asia/Kathmandu
    {  121,  992,     422,  7, }, // Asia/Kolkata
    {  121, 1211,     429,  5, }, // Asia/Macau
    {  121, 8708,     434,  8, }, // Asia/Qostanay
    {  121, 1235,     442,  6, }, // Asia/Yangon
    {  121, 1395,     448,  5, }, // Atlantic/Faroe
    {  121, 6821,     453, 10, }, // Atlantic/St_Helena
    {  121, 2527,     463,  4, }, // Europe/Kyiv
    {  121, 7211,     467,  7, }, // Indian/Reunion
    {  121, 3157,     474,  5, }, // Pacific/Chuuk
    {  121, 3096,     479,  7, }, // Pacific/Pohnpei
    {  122,  132,   60267,  8, }, // America/Adak English/Deseret/United States
    {  122, 3346,   60275, 14, }, // America/Anchorage
    {  122, 7699,   60289, 10, }, // America/Boise
    {  122, 2260,   60299, 12, }, // America/Chicago
    {  122,  805,   60311, 12, }, // America/Denver
    {  122, 3465,   60323, 14, }, // America/Detroit
    {  122,  348,   60337, 24, }, // America/Indiana/Indianapolis
    {  122,  481,   60361, 24, }, // America/Indiana/Knox
    {  122, 7961,   60385, 30, }, // America/Indiana/Marengo
    {  122, 7985,   60415, 36, }, // America/Indiana/Petersburg
    {  122, 8012,   60451, 31, }, // America/Indiana/Tell_City
    {  122, 8038,   60482, 24, }, // America/Indiana/Vevay
    {  122, 8060,   60506, 30, }, // America/Indiana/Vincennes
    {  122, 8086,   60536, 30, }, // America/Indiana/Winamac
    {  122, 5380,   60566,  8, }, // America/Juneau
    {  122,  521,   60574, 14, }, // America/Kentucky/Louisville
    {  122, 8125,   60588, 34, }, // America/Kentucky/Monticello
    {  122, 3239,   60622, 19, }, // America/Los_Angeles
    {  122, 8202,   60641, 16, }, // America/Menominee
    {  122, 2379,   60657, 13, }, // America/New_York
    {  122, 8288,   60670,  6, }, // America/Nome
    {  122, 8329,   60676, 35, }, // America/North_Dakota/Center
    {  122, 8357,   60711, 38, }, // America/North_Dakota/New_Salem
    {  122, 2973,   60749, 12, }, // America/Phoenix
    {  122, 8552,   60761, 14, }, // America/Yakutat
    {  122, 1259,     397, 11, }, // Asia/Ho_Chi_Minh
    {  122, 2723,   60775, 16, }, // Pacific/Honolulu
    {  122, 8914,   60791, 10, }, // Pacific/Midway
    {  122, 7392,   60801,  6, }, // Pacific/Wake
    {  124, 8508,   60807, 13, }, // America/St_Barthelemy English/Latin/Anguilla
    {  124, 2061,   60820,  9, }, // America/St_Johns
    {  124, 5863,   60829,  8, }, // America/St_Kitts
    {  124, 5880,   60837,  8, }, // America/St_Lucia
    {  124,  855,   60845,  9, }, // America/St_Thomas
    {  124, 5913,   60854, 10, }, // America/St_Vincent
    {  124, 5523,    5491,  5, }, // Asia/Aqtau
    {  124, 6821,   60864,  9, }, // Atlantic/St_Helena
    {  124, 3049,    4501,  9, }, // Pacific/Kanton
    {  125, 8508,   60807, 13, }, // America/St_Barthelemy English/Latin/Antigua and Barbuda
    {  125, 2061,   60820,  9, }, // America/St_Johns
    {  125, 5863,   60829,  8, }, // America/St_Kitts
    {  125, 5880,   60837,  8, }, // America/St_Lucia
    {  125,  855,   60845,  9, }, // America/St_Thomas
    {  125, 5913,   60854, 10, }, // America/St_Vincent
    {  125, 5523,    5491,  5, }, // Asia/Aqtau
    {  125, 6821,   60864,  9, }, // Atlantic/St_Helena
    {  125, 3049,    4501,  9, }, // Pacific/Kanton
    {  126, 8508,   60807, 13, }, // America/St_Barthelemy English/Latin/Australia
    {  126, 2061,   60820,  9, }, // America/St_Johns
    {  126, 5863,   60829,  8, }, // America/St_Kitts
    {  126, 5880,   60837,  8, }, // America/St_Lucia
    {  126,  855,   60845,  9, }, // America/St_Thomas
    {  126, 5913,   60854, 10, }, // America/St_Vincent
    {  126, 5523,    5491,  5, }, // Asia/Aqtau
    {  126, 6821,   60864,  9, }, // Atlantic/St_Helena
    {  126, 3049,    4501,  9, }, // Pacific/Kanton
    {  127, 8508,   60807, 13, }, // America/St_Barthelemy English/Latin/Austria
    {  127, 2061,   60820,  9, }, // America/St_Johns
    {  127, 5863,   60829,  8, }, // America/St_Kitts
    {  127, 5880,   60837,  8, }, // America/St_Lucia
    {  127,  855,   60845,  9, }, // America/St_Thomas
    {  127, 5913,   60854, 10, }, // America/St_Vincent
    {  127, 5523,    5491,  5, }, // Asia/Aqtau
    {  127, 6821,   60864,  9, }, // Atlantic/St_Helena
    {  127, 3049,    4501,  9, }, // Pacific/Kanton
    {  128, 8508,   60807, 13, }, // America/St_Barthelemy English/Latin/Bahamas
    {  128, 2061,   60820,  9, }, // America/St_Johns
    {  128, 5863,   60829,  8, }, // America/St_Kitts
    {  128, 5880,   60837,  8, }, // America/St_Lucia
    {  128,  855,   60845,  9, }, // America/St_Thomas
    {  128, 5913,   60854, 10, }, // America/St_Vincent
    {  128, 5523,    5491,  5, }, // Asia/Aqtau
    {  128, 6821,   60864,  9, }, // Atlantic/St_Helena
    {  128, 3049,    4501,  9, }, // Pacific/Kanton
    {  129, 8508,   60807, 13, }, // America/St_Barthelemy English/Latin/Barbados
    {  129, 2061,   60820,  9, }, // America/St_Johns
    {  129, 5863,   60829,  8, }, // America/St_Kitts
    {  129, 5880,   60837,  8, }, // America/St_Lucia
    {  129,  855,   60845,  9, }, // America/St_Thomas
    {  129, 5913,   60854, 10, }, // America/St_Vincent
    {  129, 5523,    5491,  5, }, // Asia/Aqtau
    {  129, 6821,   60864,  9, }, // Atlantic/St_Helena
    {  129, 3049,    4501,  9, }, // Pacific/Kanton
    {  130, 8508,   60807, 13, }, // America/St_Barthelemy English/Latin/Belgium
    {  130, 2061,   60820,  9, }, // America/St_Johns
    {  130, 5863,   60829,  8, }, // America/St_Kitts
    {  130, 5880,   60837,  8, }, // America/St_Lucia
    {  130,  855,   60845,  9, }, // America/St_Thomas
    {  130, 5913,   60854, 10, }, // America/St_Vincent
    {  130, 5523,    5491,  5, }, // Asia/Aqtau
    {  130, 6821,   60864,  9, }, // Atlantic/St_Helena
    {  130, 3049,    4501,  9, }, // Pacific/Kanton
    {  131, 8508,   60807, 13, }, // America/St_Barthelemy English/Latin/Belize
    {  131, 2061,   60820,  9, }, // America/St_Johns
    {  131, 5863,   60829,  8, }, // America/St_Kitts
    {  131, 5880,   60837,  8, }, // America/St_Lucia
    {  131,  855,   60845,  9, }, // America/St_Thomas
    {  131, 5913,   60854, 10, }, // America/St_Vincent
    {  131, 5523,    5491,  5, }, // Asia/Aqtau
    {  131, 6821,   60864,  9, }, // Atlantic/St_Helena
    {  131, 3049,    4501,  9, }, // Pacific/Kanton
    {  132, 8508,   60807, 13, }, // America/St_Barthelemy English/Latin/Bermuda
    {  132, 2061,   60820,  9, }, // America/St_Johns
    {  132, 5863,   60829,  8, }, // America/St_Kitts
    {  132, 5880,   60837,  8, }, // America/St_Lucia
    {  132,  855,   60845,  9, }, // America/St_Thomas
    {  132, 5913,   60854, 10, }, // America/St_Vincent
    {  132, 5523,    5491,  5, }, // Asia/Aqtau
    {  132, 6821,   60864,  9, }, // Atlantic/St_Helena
    {  132, 3049,    4501,  9, }, // Pacific/Kanton
    {  133, 8508,   60807, 13, }, // America/St_Barthelemy English/Latin/Botswana
    {  133, 2061,   60820,  9, }, // America/St_Johns
    {  133, 5863,   60829,  8, }, // America/St_Kitts
    {  133, 5880,   60837,  8, }, // America/St_Lucia
    {  133,  855,   60845,  9, }, // America/St_Thomas
    {  133, 5913,   60854, 10, }, // America/St_Vincent
    {  133, 5523,    5491,  5, }, // Asia/Aqtau
    {  133, 6821,   60864,  9, }, // Atlantic/St_Helena
    {  133, 3049,    4501,  9, }, // Pacific/Kanton
    {  134, 8508,   60807, 13, }, // America/St_Barthelemy English/Latin/British Indian Ocean Territory
    {  134, 2061,   60820,  9, }, // America/St_Johns
    {  134, 5863,   60829,  8, }, // America/St_Kitts
    {  134, 5880,   60837,  8, }, // America/St_Lucia
    {  134,  855,   60845,  9, }, // America/St_Thomas
    {  134, 5913,   60854, 10, }, // America/St_Vincent
    {  134, 5523,    5491,  5, }, // Asia/Aqtau
    {  134, 6821,   60864,  9, }, // Atlantic/St_Helena
    {  134, 3049,    4501,  9, }, // Pacific/Kanton
    {  135, 8508,   60807, 13, }, // America/St_Barthelemy English/Latin/British Virgin Islands
    {  135, 2061,   60820,  9, }, // America/St_Johns
    {  135, 5863,   60829,  8, }, // America/St_Kitts
    {  135, 5880,   60837,  8, }, // America/St_Lucia
    {  135,  855,   60845,  9, }, // America/St_Thomas
    {  135, 5913,   60854, 10, }, // America/St_Vincent
    {  135, 5523,    5491,  5, }, // Asia/Aqtau
    {  135, 6821,   60864,  9, }, // Atlantic/St_Helena
    {  135, 3049,    4501,  9, }, // Pacific/Kanton
    {  137, 8508,   60807, 13, }, // America/St_Barthelemy English/Latin/Cameroon
    {  137, 2061,   60820,  9, }, // America/St_Johns
    {  137, 5863,   60829,  8, }, // America/St_Kitts
    {  137, 5880,   60837,  8, }, // America/St_Lucia
    {  137,  855,   60845,  9, }, // America/St_Thomas
    {  137, 5913,   60854, 10, }, // America/St_Vincent
    {  137, 5523,    5491,  5, }, // Asia/Aqtau
    {  137, 6821,   60864,  9, }, // Atlantic/St_Helena
    {  137, 3049,    4501,  9, }, // Pacific/Kanton
    {  138, 8508,   26589, 16, }, // America/St_Barthelemy English/Latin/Canada
    {  138, 2061,   26605, 12, }, // America/St_Johns
    {  138, 5863,   26617, 11, }, // America/St_Kitts
    {  138, 5880,   35832, 11, }, // America/St_Lucia
    {  138,  855,   44161, 12, }, // America/St_Thomas
    {  138, 5913,   26651, 13, }, // America/St_Vincent
    {  138, 1235,   58486,  7, }, // Asia/Yangon
    {  138, 6821,   36066, 12, }, // Atlantic/St_Helena
    {  139, 8508,   60807, 13, }, // America/St_Barthelemy English/Latin/Cayman Islands
    {  139, 2061,   60820,  9, }, // America/St_Johns
    {  139, 5863,   60829,  8, }, // America/St_Kitts
    {  139, 5880,   60837,  8, }, // America/St_Lucia
    {  139,  855,   60845,  9, }, // America/St_Thomas
    {  139, 5913,   60854, 10, }, // America/St_Vincent
    {  139, 5523,    5491,  5, }, // Asia/Aqtau
    {  139, 6821,   60864,  9, }, // Atlantic/St_Helena
    {  139, 3049,    4501,  9, }, // Pacific/Kanton
    {  140, 8508,   60807, 13, }, // America/St_Barthelemy English/Latin/Christmas Island
    {  140, 2061,   60820,  9, }, // America/St_Johns
    {  140, 5863,   60829,  8, }, // America/St_Kitts
    {  140, 5880,   60837,  8, }, // America/St_Lucia
    {  140,  855,   60845,  9, }, // America/St_Thomas
    {  140, 5913,   60854, 10, }, // America/St_Vincent
    {  140, 5523,    5491,  5, }, // Asia/Aqtau
    {  140, 6821,   60864,  9, }, // Atlantic/St_Helena
    {  140, 3049,    4501,  9, }, // Pacific/Kanton
    {  141, 8508,   60807, 13, }, // America/St_Barthelemy English/Latin/Cocos Islands
    {  141, 2061,   60820,  9, }, // America/St_Johns
    {  141, 5863,   60829,  8, }, // America/St_Kitts
    {  141, 5880,   60837,  8, }, // America/St_Lucia
    {  141,  855,   60845,  9, }, // America/St_Thomas
    {  141, 5913,   60854, 10, }, // America/St_Vincent
    {  141, 5523,    5491,  5, }, // Asia/Aqtau
    {  141, 6821,   60864,  9, }, // Atlantic/St_Helena
    {  141, 3049,    4501,  9, }, // Pacific/Kanton
    {  142, 8508,   60807, 13, }, // America/St_Barthelemy English/Latin/Cook Islands
    {  142, 2061,   60820,  9, }, // America/St_Johns
    {  142, 5863,   60829,  8, }, // America/St_Kitts
    {  142, 5880,   60837,  8, }, // America/St_Lucia
    {  142,  855,   60845,  9, }, // America/St_Thomas
    {  142, 5913,   60854, 10, }, // America/St_Vincent
    {  142, 5523,    5491,  5, }, // Asia/Aqtau
    {  142, 6821,   60864,  9, }, // Atlantic/St_Helena
    {  142, 3049,    4501,  9, }, // Pacific/Kanton
    {  143, 8508,   60807, 13, }, // America/St_Barthelemy English/Latin/Cyprus
    {  143, 2061,   60820,  9, }, // America/St_Johns
    {  143, 5863,   60829,  8, }, // America/St_Kitts
    {  143, 5880,   60837,  8, }, // America/St_Lucia
    {  143,  855,   60845,  9, }, // America/St_Thomas
    {  143, 5913,   60854, 10, }, // America/St_Vincent
    {  143, 5523,    5491,  5, }, // Asia/Aqtau
    {  143, 6821,   60864,  9, }, // Atlantic/St_Helena
    {  143, 3049,    4501,  9, }, // Pacific/Kanton
    {  144, 8508,   60807, 13, }, // America/St_Barthelemy English/Latin/Denmark
    {  144, 2061,   60820,  9, }, // America/St_Johns
    {  144, 5863,   60829,  8, }, // America/St_Kitts
    {  144, 5880,   60837,  8, }, // America/St_Lucia
    {  144,  855,   60845,  9, }, // America/St_Thomas
    {  144, 5913,   60854, 10, }, // America/St_Vincent
    {  144, 5523,    5491,  5, }, // Asia/Aqtau
    {  144, 6821,   60864,  9, }, // Atlantic/St_Helena
    {  144, 3049,    4501,  9, }, // Pacific/Kanton
    {  145, 8508,   60807, 13, }, // America/St_Barthelemy English/Latin/Diego Garcia
    {  145, 2061,   60820,  9, }, // America/St_Johns
    {  145, 5863,   60829,  8, }, // America/St_Kitts
    {  145, 5880,   60837,  8, }, // America/St_Lucia
    {  145,  855,   60845,  9, }, // America/St_Thomas
    {  145, 5913,   60854, 10, }, // America/St_Vincent
    {  145, 5523,    5491,  5, }, // Asia/Aqtau
    {  145, 6821,   60864,  9, }, // Atlantic/St_Helena
    {  145, 3049,    4501,  9, }, // Pacific/Kanton
    {  146, 8508,   60807, 13, }, // America/St_Barthelemy English/Latin/Dominica
    {  146, 2061,   60820,  9, }, // America/St_Johns
    {  146, 5863,   60829,  8, }, // America/St_Kitts
    {  146, 5880,   60837,  8, }, // America/St_Lucia
    {  146,  855,   60845,  9, }, // America/St_Thomas
    {  146, 5913,   60854, 10, }, // America/St_Vincent
    {  146, 5523,    5491,  5, }, // Asia/Aqtau
    {  146, 6821,   60864,  9, }, // Atlantic/St_Helena
    {  146, 3049,    4501,  9, }, // Pacific/Kanton
    {  147, 8508,   60807, 13, }, // America/St_Barthelemy English/Latin/Eritrea
    {  147, 2061,   60820,  9, }, // America/St_Johns
    {  147, 5863,   60829,  8, }, // America/St_Kitts
    {  147, 5880,   60837,  8, }, // America/St_Lucia
    {  147,  855,   60845,  9, }, // America/St_Thomas
    {  147, 5913,   60854, 10, }, // America/St_Vincent
    {  147, 5523,    5491,  5, }, // Asia/Aqtau
    {  147, 6821,   60864,  9, }, // Atlantic/St_Helena
    {  147, 3049,    4501,  9, }, // Pacific/Kanton
    {  148, 8508,   60807, 13, }, // America/St_Barthelemy English/Latin/Eswatini
    {  148, 2061,   60820,  9, }, // America/St_Johns
    {  148, 5863,   60829,  8, }, // America/St_Kitts
    {  148, 5880,   60837,  8, }, // America/St_Lucia
    {  148,  855,   60845,  9, }, // America/St_Thomas
    {  148, 5913,   60854, 10, }, // America/St_Vincent
    {  148, 5523,    5491,  5, }, // Asia/Aqtau
    {  148, 6821,   60864,  9, }, // Atlantic/St_Helena
    {  148, 3049,    4501,  9, }, // Pacific/Kanton
    {  149, 8508,   60807, 13, }, // America/St_Barthelemy English/Latin/Europe
    {  149, 2061,   60820,  9, }, // America/St_Johns
    {  149, 5863,   60829,  8, }, // America/St_Kitts
    {  149, 5880,   60837,  8, }, // America/St_Lucia
    {  149,  855,   60845,  9, }, // America/St_Thomas
    {  149, 5913,   60854, 10, }, // America/St_Vincent
    {  149, 5523,    5491,  5, }, // Asia/Aqtau
    {  149, 6821,   60864,  9, }, // Atlantic/St_Helena
    {  149, 3049,    4501,  9, }, // Pacific/Kanton
    {  150, 8508,   60807, 13, }, // America/St_Barthelemy English/Latin/Falkland Islands
    {  150, 2061,   60820,  9, }, // America/St_Johns
    {  150, 5863,   60829,  8, }, // America/St_Kitts
    {  150, 5880,   60837,  8, }, // America/St_Lucia
    {  150,  855,   60845,  9, }, // America/St_Thomas
    {  150, 5913,   60854, 10, }, // America/St_Vincent
    {  150, 5523,    5491,  5, }, // Asia/Aqtau
    {  150, 6821,   60864,  9, }, // Atlantic/St_Helena
    {  150, 3049,    4501,  9, }, // Pacific/Kanton
    {  151, 8508,   60807, 13, }, // America/St_Barthelemy English/Latin/Fiji
    {  151, 2061,   60820,  9, }, // America/St_Johns
    {  151, 5863,   60829,  8, }, // America/St_Kitts
    {  151, 5880,   60837,  8, }, // America/St_Lucia
    {  151,  855,   60845,  9, }, // America/St_Thomas
    {  151, 5913,   60854, 10, }, // America/St_Vincent
    {  151, 5523,    5491,  5, }, // Asia/Aqtau
    {  151, 6821,   60864,  9, }, // Atlantic/St_Helena
    {  151, 3049,    4501,  9, }, // Pacific/Kanton
    {  152, 8508,   60807, 13, }, // America/St_Barthelemy English/Latin/Finland
    {  152, 2061,   60820,  9, }, // America/St_Johns
    {  152, 5863,   60829,  8, }, // America/St_Kitts
    {  152, 5880,   60837,  8, }, // America/St_Lucia
    {  152,  855,   60845,  9, }, // America/St_Thomas
    {  152, 5913,   60854, 10, }, // America/St_Vincent
    {  152, 5523,    5491,  5, }, // Asia/Aqtau
    {  152, 6821,   60864,  9, }, // Atlantic/St_Helena
    {  152, 3049,    4501,  9, }, // Pacific/Kanton
    {  153, 8508,   60807, 13, }, // America/St_Barthelemy English/Latin/Gambia
    {  153, 2061,   60820,  9, }, // America/St_Johns
    {  153, 5863,   60829,  8, }, // America/St_Kitts
    {  153, 5880,   60837,  8, }, // America/St_Lucia
    {  153,  855,   60845,  9, }, // America/St_Thomas
    {  153, 5913,   60854, 10, }, // America/St_Vincent
    {  153, 5523,    5491,  5, }, // Asia/Aqtau
    {  153, 6821,   60864,  9, }, // Atlantic/St_Helena
    {  153, 3049,    4501,  9, }, // Pacific/Kanton
    {  154, 8508,   60807, 13, }, // America/St_Barthelemy English/Latin/Germany
    {  154, 2061,   60820,  9, }, // America/St_Johns
    {  154, 5863,   60829,  8, }, // America/St_Kitts
    {  154, 5880,   60837,  8, }, // America/St_Lucia
    {  154,  855,   60845,  9, }, // America/St_Thomas
    {  154, 5913,   60854, 10, }, // America/St_Vincent
    {  154, 5523,    5491,  5, }, // Asia/Aqtau
    {  154, 6821,   60864,  9, }, // Atlantic/St_Helena
    {  154, 3049,    4501,  9, }, // Pacific/Kanton
    {  155, 8508,   60807, 13, }, // America/St_Barthelemy English/Latin/Ghana
    {  155, 2061,   60820,  9, }, // America/St_Johns
    {  155, 5863,   60829,  8, }, // America/St_Kitts
    {  155, 5880,   60837,  8, }, // America/St_Lucia
    {  155,  855,   60845,  9, }, // America/St_Thomas
    {  155, 5913,   60854, 10, }, // America/St_Vincent
    {  155, 5523,    5491,  5, }, // Asia/Aqtau
    {  155, 6821,   60864,  9, }, // Atlantic/St_Helena
    {  155, 3049,    4501,  9, }, // Pacific/Kanton
    {  156, 8508,   60807, 13, }, // America/St_Barthelemy English/Latin/Gibraltar
    {  156, 2061,   60820,  9, }, // America/St_Johns
    {  156, 5863,   60829,  8, }, // America/St_Kitts
    {  156, 5880,   60837,  8, }, // America/St_Lucia
    {  156,  855,   60845,  9, }, // America/St_Thomas
    {  156, 5913,   60854, 10, }, // America/St_Vincent
    {  156, 5523,    5491,  5, }, // Asia/Aqtau
    {  156, 6821,   60864,  9, }, // Atlantic/St_Helena
    {  156, 3049,    4501,  9, }, // Pacific/Kanton
    {  157, 8508,   60807, 13, }, // America/St_Barthelemy English/Latin/Grenada
    {  157, 2061,   60820,  9, }, // America/St_Johns
    {  157, 5863,   60829,  8, }, // America/St_Kitts
    {  157, 5880,   60837,  8, }, // America/St_Lucia
    {  157,  855,   60845,  9, }, // America/St_Thomas
    {  157, 5913,   60854, 10, }, // America/St_Vincent
    {  157, 5523,    5491,  5, }, // Asia/Aqtau
    {  157, 6821,   60864,  9, }, // Atlantic/St_Helena
    {  157, 3049,    4501,  9, }, // Pacific/Kanton
    {  159, 8508,   60807, 13, }, // America/St_Barthelemy English/Latin/Guernsey
    {  159, 2061,   60820,  9, }, // America/St_Johns
    {  159, 5863,   60829,  8, }, // America/St_Kitts
    {  159, 5880,   60837,  8, }, // America/St_Lucia
    {  159,  855,   60845,  9, }, // America/St_Thomas
    {  159, 5913,   60854, 10, }, // America/St_Vincent
    {  159, 5523,    5491,  5, }, // Asia/Aqtau
    {  159, 6821,   60864,  9, }, // Atlantic/St_Helena
    {  159, 3049,    4501,  9, }, // Pacific/Kanton
    {  160, 8508,   60807, 13, }, // America/St_Barthelemy English/Latin/Guyana
    {  160, 2061,   60820,  9, }, // America/St_Johns
    {  160, 5863,   60829,  8, }, // America/St_Kitts
    {  160, 5880,   60837,  8, }, // America/St_Lucia
    {  160,  855,   60845,  9, }, // America/St_Thomas
    {  160, 5913,   60854, 10, }, // America/St_Vincent
    {  160, 5523,    5491,  5, }, // Asia/Aqtau
    {  160, 6821,   60864,  9, }, // Atlantic/St_Helena
    {  160, 3049,    4501,  9, }, // Pacific/Kanton
    {  161, 8508,   60807, 13, }, // America/St_Barthelemy English/Latin/Hong Kong
    {  161, 2061,   60820,  9, }, // America/St_Johns
    {  161, 5863,   60829,  8, }, // America/St_Kitts
    {  161, 5880,   60837,  8, }, // America/St_Lucia
    {  161,  855,   60845,  9, }, // America/St_Thomas
    {  161, 5913,   60854, 10, }, // America/St_Vincent
    {  161, 5523,    5491,  5, }, // Asia/Aqtau
    {  161, 6821,   60864,  9, }, // Atlantic/St_Helena
    {  161, 3049,    4501,  9, }, // Pacific/Kanton
    {  162, 8508,   60807, 13, }, // America/St_Barthelemy English/Latin/India
    {  162, 2061,   60820,  9, }, // America/St_Johns
    {  162, 5863,   60829,  8, }, // America/St_Kitts
    {  162, 5880,   60837,  8, }, // America/St_Lucia
    {  162,  855,   60845,  9, }, // America/St_Thomas
    {  162, 5913,   60854, 10, }, // America/St_Vincent
    {  162, 5523,    5491,  5, }, // Asia/Aqtau
    {  162, 4771,   26703,  5, }, // Asia/Hovd
    {  162, 4269,   26765,  9, }, // Asia/Qyzylorda
    {  162, 6821,   60864,  9, }, // Atlantic/St_Helena
    {  162, 3049,    4501,  9, }, // Pacific/Kanton
    {  163, 8508,   60807, 13, }, // America/St_Barthelemy English/Latin/Indonesia
    {  163, 2061,   60820,  9, }, // America/St_Johns
    {  163, 5863,   60829,  8, }, // America/St_Kitts
    {  163, 5880,   60837,  8, }, // America/St_Lucia
    {  163,  855,   60845,  9, }, // America/St_Thomas
    {  163, 5913,   60854, 10, }, // America/St_Vincent
    {  163, 5523,    5491,  5, }, // Asia/Aqtau
    {  163, 6821,   60864,  9, }, // Atlantic/St_Helena
    {  163, 3049,    4501,  9, }, // Pacific/Kanton
    {  164, 8508,   60807, 13, }, // America/St_Barthelemy English/Latin/Ireland
    {  164, 2061,   60820,  9, }, // America/St_Johns
    {  164, 5863,   60829,  8, }, // America/St_Kitts
    {  164, 5880,   60837,  8, }, // America/St_Lucia
    {  164,  855,   60845,  9, }, // America/St_Thomas
    {  164, 5913,   60854, 10, }, // America/St_Vincent
    {  164, 5523,    5491,  5, }, // Asia/Aqtau
    {  164, 6821,   60864,  9, }, // Atlantic/St_Helena
    {  164, 3049,    4501,  9, }, // Pacific/Kanton
    {  165, 8508,   60807, 13, }, // America/St_Barthelemy English/Latin/Isle of Man
    {  165, 2061,   60820,  9, }, // America/St_Johns
    {  165, 5863,   60829,  8, }, // America/St_Kitts
    {  165, 5880,   60837,  8, }, // America/St_Lucia
    {  165,  855,   60845,  9, }, // America/St_Thomas
    {  165, 5913,   60854, 10, }, // America/St_Vincent
    {  165, 5523,    5491,  5, }, // Asia/Aqtau
    {  165, 6821,   60864,  9, }, // Atlantic/St_Helena
    {  165, 3049,    4501,  9, }, // Pacific/Kanton
    {  166, 8508,   60807, 13, }, // America/St_Barthelemy English/Latin/Israel
    {  166, 2061,   60820,  9, }, // America/St_Johns
    {  166, 5863,   60829,  8, }, // America/St_Kitts
    {  166, 5880,   60837,  8, }, // America/St_Lucia
    {  166,  855,   60845,  9, }, // America/St_Thomas
    {  166, 5913,   60854, 10, }, // America/St_Vincent
    {  166, 5523,    5491,  5, }, // Asia/Aqtau
    {  166, 6821,   60864,  9, }, // Atlantic/St_Helena
    {  166, 3049,    4501,  9, }, // Pacific/Kanton
    {  167, 8508,   60807, 13, }, // America/St_Barthelemy English/Latin/Jamaica
    {  167, 2061,   60820,  9, }, // America/St_Johns
    {  167, 5863,   60829,  8, }, // America/St_Kitts
    {  167, 5880,   60837,  8, }, // America/St_Lucia
    {  167,  855,   60845,  9, }, // America/St_Thomas
    {  167, 5913,   60854, 10, }, // America/St_Vincent
    {  167, 5523,    5491,  5, }, // Asia/Aqtau
    {  167, 6821,   60864,  9, }, // Atlantic/St_Helena
    {  167, 3049,    4501,  9, }, // Pacific/Kanton
    {  168, 8508,   60807, 13, }, // America/St_Barthelemy English/Latin/Jersey
    {  168, 2061,   60820,  9, }, // America/St_Johns
    {  168, 5863,   60829,  8, }, // America/St_Kitts
    {  168, 5880,   60837,  8, }, // America/St_Lucia
    {  168,  855,   60845,  9, }, // America/St_Thomas
    {  168, 5913,   60854, 10, }, // America/St_Vincent
    {  168, 5523,    5491,  5, }, // Asia/Aqtau
    {  168, 6821,   60864,  9, }, // Atlantic/St_Helena
    {  168, 3049,    4501,  9, }, // Pacific/Kanton
    {  169, 8508,   60807, 13, }, // America/St_Barthelemy English/Latin/Kenya
    {  169, 2061,   60820,  9, }, // America/St_Johns
    {  169, 5863,   60829,  8, }, // America/St_Kitts
    {  169, 5880,   60837,  8, }, // America/St_Lucia
    {  169,  855,   60845,  9, }, // America/St_Thomas
    {  169, 5913,   60854, 10, }, // America/St_Vincent
    {  169, 5523,    5491,  5, }, // Asia/Aqtau
    {  169, 6821,   60864,  9, }, // Atlantic/St_Helena
    {  169, 3049,    4501,  9, }, // Pacific/Kanton
    {  170, 8508,   60807, 13, }, // America/St_Barthelemy English/Latin/Kiribati
    {  170, 2061,   60820,  9, }, // America/St_Johns
    {  170, 5863,   60829,  8, }, // America/St_Kitts
    {  170, 5880,   60837,  8, }, // America/St_Lucia
    {  170,  855,   60845,  9, }, // America/St_Thomas
    {  170, 5913,   60854, 10, }, // America/St_Vincent
    {  170, 5523,    5491,  5, }, // Asia/Aqtau
    {  170, 6821,   60864,  9, }, // Atlantic/St_Helena
    {  170, 3049,    4501,  9, }, // Pacific/Kanton
    {  171, 8508,   60807, 13, }, // America/St_Barthelemy English/Latin/Lesotho
    {  171, 2061,   60820,  9, }, // America/St_Johns
    {  171, 5863,   60829,  8, }, // America/St_Kitts
    {  171, 5880,   60837,  8, }, // America/St_Lucia
    {  171,  855,   60845,  9, }, // America/St_Thomas
    {  171, 5913,   60854, 10, }, // America/St_Vincent
    {  171, 5523,    5491,  5, }, // Asia/Aqtau
    {  171, 6821,   60864,  9, }, // Atlantic/St_Helena
    {  171, 3049,    4501,  9, }, // Pacific/Kanton
    {  172, 8508,   60807, 13, }, // America/St_Barthelemy English/Latin/Liberia
    {  172, 2061,   60820,  9, }, // America/St_Johns
    {  172, 5863,   60829,  8, }, // America/St_Kitts
    {  172, 5880,   60837,  8, }, // America/St_Lucia
    {  172,  855,   60845,  9, }, // America/St_Thomas
    {  172, 5913,   60854, 10, }, // America/St_Vincent
    {  172, 5523,    5491,  5, }, // Asia/Aqtau
    {  172, 6821,   60864,  9, }, // Atlantic/St_Helena
    {  172, 3049,    4501,  9, }, // Pacific/Kanton
    {  173, 8508,   60807, 13, }, // America/St_Barthelemy English/Latin/Macao
    {  173, 2061,   60820,  9, }, // America/St_Johns
    {  173, 5863,   60829,  8, }, // America/St_Kitts
    {  173, 5880,   60837,  8, }, // America/St_Lucia
    {  173,  855,   60845,  9, }, // America/St_Thomas
    {  173, 5913,   60854, 10, }, // America/St_Vincent
    {  173, 5523,    5491,  5, }, // Asia/Aqtau
    {  173, 6821,   60864,  9, }, // Atlantic/St_Helena
    {  173, 3049,    4501,  9, }, // Pacific/Kanton
    {  174, 8508,   60807, 13, }, // America/St_Barthelemy English/Latin/Madagascar
    {  174, 2061,   60820,  9, }, // America/St_Johns
    {  174, 5863,   60829,  8, }, // America/St_Kitts
    {  174, 5880,   60837,  8, }, // America/St_Lucia
    {  174,  855,   60845,  9, }, // America/St_Thomas
    {  174, 5913,   60854, 10, }, // America/St_Vincent
    {  174, 5523,    5491,  5, }, // Asia/Aqtau
    {  174, 6821,   60864,  9, }, // Atlantic/St_Helena
    {  174, 3049,    4501,  9, }, // Pacific/Kanton
    {  175, 8508,   60807, 13, }, // America/St_Barthelemy English/Latin/Malawi
    {  175, 2061,   60820,  9, }, // America/St_Johns
    {  175, 5863,   60829,  8, }, // America/St_Kitts
    {  175, 5880,   60837,  8, }, // America/St_Lucia
    {  175,  855,   60845,  9, }, // America/St_Thomas
    {  175, 5913,   60854, 10, }, // America/St_Vincent
    {  175, 5523,    5491,  5, }, // Asia/Aqtau
    {  175, 6821,   60864,  9, }, // Atlantic/St_Helena
    {  175, 3049,    4501,  9, }, // Pacific/Kanton
    {  176, 8508,   60807, 13, }, // America/St_Barthelemy English/Latin/Malaysia
    {  176, 2061,   60820,  9, }, // America/St_Johns
    {  176, 5863,   60829,  8, }, // America/St_Kitts
    {  176, 5880,   60837,  8, }, // America/St_Lucia
    {  176,  855,   60845,  9, }, // America/St_Thomas
    {  176, 5913,   60854, 10, }, // America/St_Vincent
    {  176, 5523,    5491,  5, }, // Asia/Aqtau
    {  176, 6821,   60864,  9, }, // Atlantic/St_Helena
    {  176, 3049,    4501,  9, }, // Pacific/Kanton
    {  177, 8508,   60807, 13, }, // America/St_Barthelemy English/Latin/Maldives
    {  177, 2061,   60820,  9, }, // America/St_Johns
    {  177, 5863,   60829,  8, }, // America/St_Kitts
    {  177, 5880,   60837,  8, }, // America/St_Lucia
    {  177,  855,   60845,  9, }, // America/St_Thomas
    {  177, 5913,   60854, 10, }, // America/St_Vincent
    {  177, 5523,    5491,  5, }, // Asia/Aqtau
    {  177, 6821,   60864,  9, }, // Atlantic/St_Helena
    {  177, 3049,    4501,  9, }, // Pacific/Kanton
    {  178, 8508,   60807, 13, }, // America/St_Barthelemy English/Latin/Malta
    {  178, 2061,   60820,  9, }, // America/St_Johns
    {  178, 5863,   60829,  8, }, // America/St_Kitts
    {  178, 5880,   60837,  8, }, // America/St_Lucia
    {  178,  855,   60845,  9, }, // America/St_Thomas
    {  178, 5913,   60854, 10, }, // America/St_Vincent
    {  178, 5523,    5491,  5, }, // Asia/Aqtau
    {  178, 6821,   60864,  9, }, // Atlantic/St_Helena
    {  178, 3049,    4501,  9, }, // Pacific/Kanton
    {  180, 8508,   60807, 13, }, // America/St_Barthelemy English/Latin/Mauritius
    {  180, 2061,   60820,  9, }, // America/St_Johns
    {  180, 5863,   60829,  8, }, // America/St_Kitts
    {  180, 5880,   60837,  8, }, // America/St_Lucia
    {  180,  855,   60845,  9, }, // America/St_Thomas
    {  180, 5913,   60854, 10, }, // America/St_Vincent
    {  180, 5523,    5491,  5, }, // Asia/Aqtau
    {  180, 6821,   60864,  9, }, // Atlantic/St_Helena
    {  180, 3049,    4501,  9, }, // Pacific/Kanton
    {  181, 8508,   60807, 13, }, // America/St_Barthelemy English/Latin/Micronesia
    {  181, 2061,   60820,  9, }, // America/St_Johns
    {  181, 5863,   60829,  8, }, // America/St_Kitts
    {  181, 5880,   60837,  8, }, // America/St_Lucia
    {  181,  855,   60845,  9, }, // America/St_Thomas
    {  181, 5913,   60854, 10, }, // America/St_Vincent
    {  181, 5523,    5491,  5, }, // Asia/Aqtau
    {  181, 6821,   60864,  9, }, // Atlantic/St_Helena
    {  181, 3049,    4501,  9, }, // Pacific/Kanton
    {  182, 8508,   60807, 13, }, // America/St_Barthelemy English/Latin/Montserrat
    {  182, 2061,   60820,  9, }, // America/St_Johns
    {  182, 5863,   60829,  8, }, // America/St_Kitts
    {  182, 5880,   60837,  8, }, // America/St_Lucia
    {  182,  855,   60845,  9, }, // America/St_Thomas
    {  182, 5913,   60854, 10, }, // America/St_Vincent
    {  182, 5523,    5491,  5, }, // Asia/Aqtau
    {  182, 6821,   60864,  9, }, // Atlantic/St_Helena
    {  182, 3049,    4501,  9, }, // Pacific/Kanton
    {  183, 8508,   60807, 13, }, // America/St_Barthelemy English/Latin/Namibia
    {  183, 2061,   60820,  9, }, // America/St_Johns
    {  183, 5863,   60829,  8, }, // America/St_Kitts
    {  183, 5880,   60837,  8, }, // America/St_Lucia
    {  183,  855,   60845,  9, }, // America/St_Thomas
    {  183, 5913,   60854, 10, }, // America/St_Vincent
    {  183, 5523,    5491,  5, }, // Asia/Aqtau
    {  183, 6821,   60864,  9, }, // Atlantic/St_Helena
    {  183, 3049,    4501,  9, }, // Pacific/Kanton
    {  184, 8508,   60807, 13, }, // America/St_Barthelemy English/Latin/Nauru
    {  184, 2061,   60820,  9, }, // America/St_Johns
    {  184, 5863,   60829,  8, }, // America/St_Kitts
    {  184, 5880,   60837,  8, }, // America/St_Lucia
    {  184,  855,   60845,  9, }, // America/St_Thomas
    {  184, 5913,   60854, 10, }, // America/St_Vincent
    {  184, 5523,    5491,  5, }, // Asia/Aqtau
    {  184, 6821,   60864,  9, }, // Atlantic/St_Helena
    {  184, 3049,    4501,  9, }, // Pacific/Kanton
    {  185, 8508,   60807, 13, }, // America/St_Barthelemy English/Latin/Netherlands
    {  185, 2061,   60820,  9, }, // America/St_Johns
    {  185, 5863,   60829,  8, }, // America/St_Kitts
    {  185, 5880,   60837,  8, }, // America/St_Lucia
    {  185,  855,   60845,  9, }, // America/St_Thomas
    {  185, 5913,   60854, 10, }, // America/St_Vincent
    {  185, 5523,    5491,  5, }, // Asia/Aqtau
    {  185, 6821,   60864,  9, }, // Atlantic/St_Helena
    {  185, 3049,    4501,  9, }, // Pacific/Kanton
    {  186, 8508,   60807, 13, }, // America/St_Barthelemy English/Latin/New Zealand
    {  186, 2061,   60820,  9, }, // America/St_Johns
    {  186, 5863,   60829,  8, }, // America/St_Kitts
    {  186, 5880,   60837,  8, }, // America/St_Lucia
    {  186,  855,   60845,  9, }, // America/St_Thomas
    {  186, 5913,   60854, 10, }, // America/St_Vincent
    {  186, 5523,    5491,  5, }, // Asia/Aqtau
    {  186, 6821,   60864,  9, }, // Atlantic/St_Helena
    {  186, 3049,    4501,  9, }, // Pacific/Kanton
    {  187, 8508,   60807, 13, }, // America/St_Barthelemy English/Latin/Nigeria
    {  187, 2061,   60820,  9, }, // America/St_Johns
    {  187, 5863,   60829,  8, }, // America/St_Kitts
    {  187, 5880,   60837,  8, }, // America/St_Lucia
    {  187,  855,   60845,  9, }, // America/St_Thomas
    {  187, 5913,   60854, 10, }, // America/St_Vincent
    {  187, 5523,    5491,  5, }, // Asia/Aqtau
    {  187, 6821,   60864,  9, }, // Atlantic/St_Helena
    {  187, 3049,    4501,  9, }, // Pacific/Kanton
    {  188, 8508,   60807, 13, }, // America/St_Barthelemy English/Latin/Niue
    {  188, 2061,   60820,  9, }, // America/St_Johns
    {  188, 5863,   60829,  8, }, // America/St_Kitts
    {  188, 5880,   60837,  8, }, // America/St_Lucia
    {  188,  855,   60845,  9, }, // America/St_Thomas
    {  188, 5913,   60854, 10, }, // America/St_Vincent
    {  188, 5523,    5491,  5, }, // Asia/Aqtau
    {  188, 6821,   60864,  9, }, // Atlantic/St_Helena
    {  188, 3049,    4501,  9, }, // Pacific/Kanton
    {  189, 8508,   60807, 13, }, // America/St_Barthelemy English/Latin/Norfolk Island
    {  189, 2061,   60820,  9, }, // America/St_Johns
    {  189, 5863,   60829,  8, }, // America/St_Kitts
    {  189, 5880,   60837,  8, }, // America/St_Lucia
    {  189,  855,   60845,  9, }, // America/St_Thomas
    {  189, 5913,   60854, 10, }, // America/St_Vincent
    {  189, 5523,    5491,  5, }, // Asia/Aqtau
    {  189, 6821,   60864,  9, }, // Atlantic/St_Helena
    {  189, 3049,    4501,  9, }, // Pacific/Kanton
    {  191, 8508,   60807, 13, }, // America/St_Barthelemy English/Latin/Pakistan
    {  191, 2061,   60820,  9, }, // America/St_Johns
    {  191, 5863,   60829,  8, }, // America/St_Kitts
    {  191, 5880,   60837,  8, }, // America/St_Lucia
    {  191,  855,   60845,  9, }, // America/St_Thomas
    {  191, 5913,   60854, 10, }, // America/St_Vincent
    {  191, 5523,    5491,  5, }, // Asia/Aqtau
    {  191, 6821,   60864,  9, }, // Atlantic/St_Helena
    {  191, 3049,    4501,  9, }, // Pacific/Kanton
    {  192, 8508,   60807, 13, }, // America/St_Barthelemy English/Latin/Palau
    {  192, 2061,   60820,  9, }, // America/St_Johns
    {  192, 5863,   60829,  8, }, // America/St_Kitts
    {  192, 5880,   60837,  8, }, // America/St_Lucia
    {  192,  855,   60845,  9, }, // America/St_Thomas
    {  192, 5913,   60854, 10, }, // America/St_Vincent
    {  192, 5523,    5491,  5, }, // Asia/Aqtau
    {  192, 6821,   60864,  9, }, // Atlantic/St_Helena
    {  192, 3049,    4501,  9, }, // Pacific/Kanton
    {  193, 8508,   60807, 13, }, // America/St_Barthelemy English/Latin/Papua New Guinea
    {  193, 2061,   60820,  9, }, // America/St_Johns
    {  193, 5863,   60829,  8, }, // America/St_Kitts
    {  193, 5880,   60837,  8, }, // America/St_Lucia
    {  193,  855,   60845,  9, }, // America/St_Thomas
    {  193, 5913,   60854, 10, }, // America/St_Vincent
    {  193, 5523,    5491,  5, }, // Asia/Aqtau
    {  193, 6821,   60864,  9, }, // Atlantic/St_Helena
    {  193, 3049,    4501,  9, }, // Pacific/Kanton
    {  195, 8508,   60807, 13, }, // America/St_Barthelemy English/Latin/Pitcairn
    {  195, 2061,   60820,  9, }, // America/St_Johns
    {  195, 5863,   60829,  8, }, // America/St_Kitts
    {  195, 5880,   60837,  8, }, // America/St_Lucia
    {  195,  855,   60845,  9, }, // America/St_Thomas
    {  195, 5913,   60854, 10, }, // America/St_Vincent
    {  195, 5523,    5491,  5, }, // Asia/Aqtau
    {  195, 6821,   60864,  9, }, // Atlantic/St_Helena
    {  195, 3049,    4501,  9, }, // Pacific/Kanton
    {  197, 8508,   60807, 13, }, // America/St_Barthelemy English/Latin/Rwanda
    {  197, 2061,   60820,  9, }, // America/St_Johns
    {  197, 5863,   60829,  8, }, // America/St_Kitts
    {  197, 5880,   60837,  8, }, // America/St_Lucia
    {  197,  855,   60845,  9, }, // America/St_Thomas
    {  197, 5913,   60854, 10, }, // America/St_Vincent
    {  197, 5523,    5491,  5, }, // Asia/Aqtau
    {  197, 6821,   60864,  9, }, // Atlantic/St_Helena
    {  197, 3049,    4501,  9, }, // Pacific/Kanton
    {  198, 8508,   60807, 13, }, // America/St_Barthelemy English/Latin/Saint Helena
    {  198, 2061,   60820,  9, }, // America/St_Johns
    {  198, 5863,   60829,  8, }, // America/St_Kitts
    {  198, 5880,   60837,  8, }, // America/St_Lucia
    {  198,  855,   60845,  9, }, // America/St_Thomas
    {  198, 5913,   60854, 10, }, // America/St_Vincent
    {  198, 5523,    5491,  5, }, // Asia/Aqtau
    {  198, 6821,   60864,  9, }, // Atlantic/St_Helena
    {  198, 3049,    4501,  9, }, // Pacific/Kanton
    {  199, 8508,   60807, 13, }, // America/St_Barthelemy English/Latin/Saint Kitts and Nevis
    {  199, 2061,   60820,  9, }, // America/St_Johns
    {  199, 5863,   60829,  8, }, // America/St_Kitts
    {  199, 5880,   60837,  8, }, // America/St_Lucia
    {  199,  855,   60845,  9, }, // America/St_Thomas
    {  199, 5913,   60854, 10, }, // America/St_Vincent
    {  199, 5523,    5491,  5, }, // Asia/Aqtau
    {  199, 6821,   60864,  9, }, // Atlantic/St_Helena
    {  199, 3049,    4501,  9, }, // Pacific/Kanton
    {  200, 8508,   60807, 13, }, // America/St_Barthelemy English/Latin/Saint Lucia
    {  200, 2061,   60820,  9, }, // America/St_Johns
    {  200, 5863,   60829,  8, }, // America/St_Kitts
    {  200, 5880,   60837,  8, }, // America/St_Lucia
    {  200,  855,   60845,  9, }, // America/St_Thomas
    {  200, 5913,   60854, 10, }, // America/St_Vincent
    {  200, 5523,    5491,  5, }, // Asia/Aqtau
    {  200, 6821,   60864,  9, }, // Atlantic/St_Helena
    {  200, 3049,    4501,  9, }, // Pacific/Kanton
    {  201, 8508,   60807, 13, }, // America/St_Barthelemy English/Latin/Saint Vincent and Grenadines
    {  201, 2061,   60820,  9, }, // America/St_Johns
    {  201, 5863,   60829,  8, }, // America/St_Kitts
    {  201, 5880,   60837,  8, }, // America/St_Lucia
    {  201,  855,   60845,  9, }, // America/St_Thomas
    {  201, 5913,   60854, 10, }, // America/St_Vincent
    {  201, 5523,    5491,  5, }, // Asia/Aqtau
    {  201, 6821,   60864,  9, }, // Atlantic/St_Helena
    {  201, 3049,    4501,  9, }, // Pacific/Kanton
    {  202, 8508,   60807, 13, }, // America/St_Barthelemy English/Latin/Samoa
    {  202, 2061,   60820,  9, }, // America/St_Johns
    {  202, 5863,   60829,  8, }, // America/St_Kitts
    {  202, 5880,   60837,  8, }, // America/St_Lucia
    {  202,  855,   60845,  9, }, // America/St_Thomas
    {  202, 5913,   60854, 10, }, // America/St_Vincent
    {  202, 5523,    5491,  5, }, // Asia/Aqtau
    {  202, 6821,   60864,  9, }, // Atlantic/St_Helena
    {  202, 3049,    4501,  9, }, // Pacific/Kanton
    {  203, 8508,   60807, 13, }, // America/St_Barthelemy English/Latin/Seychelles
    {  203, 2061,   60820,  9, }, // America/St_Johns
    {  203, 5863,   60829,  8, }, // America/St_Kitts
    {  203, 5880,   60837,  8, }, // America/St_Lucia
    {  203,  855,   60845,  9, }, // America/St_Thomas
    {  203, 5913,   60854, 10, }, // America/St_Vincent
    {  203, 5523,    5491,  5, }, // Asia/Aqtau
    {  203, 6821,   60864,  9, }, // Atlantic/St_Helena
    {  203, 3049,    4501,  9, }, // Pacific/Kanton
    {  204, 8508,   60807, 13, }, // America/St_Barthelemy English/Latin/Sierra Leone
    {  204, 2061,   60820,  9, }, // America/St_Johns
    {  204, 5863,   60829,  8, }, // America/St_Kitts
    {  204, 5880,   60837,  8, }, // America/St_Lucia
    {  204,  855,   60845,  9, }, // America/St_Thomas
    {  204, 5913,   60854, 10, }, // America/St_Vincent
    {  204, 5523,    5491,  5, }, // Asia/Aqtau
    {  204, 6821,   60864,  9, }, // Atlantic/St_Helena
    {  204, 3049,    4501,  9, }, // Pacific/Kanton
    {  205, 8508,   60807, 13, }, // America/St_Barthelemy English/Latin/Singapore
    {  205, 2061,   60820,  9, }, // America/St_Johns
    {  205, 5863,   60829,  8, }, // America/St_Kitts
    {  205, 5880,   60837,  8, }, // America/St_Lucia
    {  205,  855,   60845,  9, }, // America/St_Thomas
    {  205, 5913,   60854, 10, }, // America/St_Vincent
    {  205, 5523,    5491,  5, }, // Asia/Aqtau
    {  205, 6821,   60864,  9, }, // Atlantic/St_Helena
    {  205, 3049,    4501,  9, }, // Pacific/Kanton
    {  206, 8508,   60807, 13, }, // America/St_Barthelemy English/Latin/Sint Maarten
    {  206, 2061,   60820,  9, }, // America/St_Johns
    {  206, 5863,   60829,  8, }, // America/St_Kitts
    {  206, 5880,   60837,  8, }, // America/St_Lucia
    {  206,  855,   60845,  9, }, // America/St_Thomas
    {  206, 5913,   60854, 10, }, // America/St_Vincent
    {  206, 5523,    5491,  5, }, // Asia/Aqtau
    {  206, 6821,   60864,  9, }, // Atlantic/St_Helena
    {  206, 3049,    4501,  9, }, // Pacific/Kanton
    {  207, 8508,   60807, 13, }, // America/St_Barthelemy English/Latin/Slovenia
    {  207, 2061,   60820,  9, }, // America/St_Johns
    {  207, 5863,   60829,  8, }, // America/St_Kitts
    {  207, 5880,   60837,  8, }, // America/St_Lucia
    {  207,  855,   60845,  9, }, // America/St_Thomas
    {  207, 5913,   60854, 10, }, // America/St_Vincent
    {  207, 5523,    5491,  5, }, // Asia/Aqtau
    {  207, 6821,   60864,  9, }, // Atlantic/St_Helena
    {  207, 3049,    4501,  9, }, // Pacific/Kanton
    {  208, 8508,   60807, 13, }, // America/St_Barthelemy English/Latin/Solomon Islands
    {  208, 2061,   60820,  9, }, // America/St_Johns
    {  208, 5863,   60829,  8, }, // America/St_Kitts
    {  208, 5880,   60837,  8, }, // America/St_Lucia
    {  208,  855,   60845,  9, }, // America/St_Thomas
    {  208, 5913,   60854, 10, }, // America/St_Vincent
    {  208, 5523,    5491,  5, }, // Asia/Aqtau
    {  208, 6821,   60864,  9, }, // Atlantic/St_Helena
    {  208, 3049,    4501,  9, }, // Pacific/Kanton
    {  209, 8508,   60807, 13, }, // America/St_Barthelemy English/Latin/South Africa
    {  209, 2061,   60820,  9, }, // America/St_Johns
    {  209, 5863,   60829,  8, }, // America/St_Kitts
    {  209, 5880,   60837,  8, }, // America/St_Lucia
    {  209,  855,   60845,  9, }, // America/St_Thomas
    {  209, 5913,   60854, 10, }, // America/St_Vincent
    {  209, 5523,    5491,  5, }, // Asia/Aqtau
    {  209, 6821,   60864,  9, }, // Atlantic/St_Helena
    {  209, 3049,    4501,  9, }, // Pacific/Kanton
    {  210, 8508,   60807, 13, }, // America/St_Barthelemy English/Latin/South Sudan
    {  210, 2061,   60820,  9, }, // America/St_Johns
    {  210, 5863,   60829,  8, }, // America/St_Kitts
    {  210, 5880,   60837,  8, }, // America/St_Lucia
    {  210,  855,   60845,  9, }, // America/St_Thomas
    {  210, 5913,   60854, 10, }, // America/St_Vincent
    {  210, 5523,    5491,  5, }, // Asia/Aqtau
    {  210, 6821,   60864,  9, }, // Atlantic/St_Helena
    {  210, 3049,    4501,  9, }, // Pacific/Kanton
    {  211, 8508,   60807, 13, }, // America/St_Barthelemy English/Latin/Sudan
    {  211, 2061,   60820,  9, }, // America/St_Johns
    {  211, 5863,   60829,  8, }, // America/St_Kitts
    {  211, 5880,   60837,  8, }, // America/St_Lucia
    {  211,  855,   60845,  9, }, // America/St_Thomas
    {  211, 5913,   60854, 10, }, // America/St_Vincent
    {  211, 5523,    5491,  5, }, // Asia/Aqtau
    {  211, 6821,   60864,  9, }, // Atlantic/St_Helena
    {  211, 3049,    4501,  9, }, // Pacific/Kanton
    {  212, 8508,   60807, 13, }, // America/St_Barthelemy English/Latin/Sweden
    {  212, 2061,   60820,  9, }, // America/St_Johns
    {  212, 5863,   60829,  8, }, // America/St_Kitts
    {  212, 5880,   60837,  8, }, // America/St_Lucia
    {  212,  855,   60845,  9, }, // America/St_Thomas
    {  212, 5913,   60854, 10, }, // America/St_Vincent
    {  212, 5523,    5491,  5, }, // Asia/Aqtau
    {  212, 6821,   60864,  9, }, // Atlantic/St_Helena
    {  212, 3049,    4501,  9, }, // Pacific/Kanton
    {  213, 8508,   60807, 13, }, // America/St_Barthelemy English/Latin/Switzerland
    {  213, 2061,   60820,  9, }, // America/St_Johns
    {  213, 5863,   60829,  8, }, // America/St_Kitts
    {  213, 5880,   60837,  8, }, // America/St_Lucia
    {  213,  855,   60845,  9, }, // America/St_Thomas
    {  213, 5913,   60854, 10, }, // America/St_Vincent
    {  213, 5523,    5491,  5, }, // Asia/Aqtau
    {  213, 6821,   60864,  9, }, // Atlantic/St_Helena
    {  213, 3049,    4501,  9, }, // Pacific/Kanton
    {  214, 8508,   60807, 13, }, // America/St_Barthelemy English/Latin/Tanzania
    {  214, 2061,   60820,  9, }, // America/St_Johns
    {  214, 5863,   60829,  8, }, // America/St_Kitts
    {  214, 5880,   60837,  8, }, // America/St_Lucia
    {  214,  855,   60845,  9, }, // America/St_Thomas
    {  214, 5913,   60854, 10, }, // America/St_Vincent
    {  214, 5523,    5491,  5, }, // Asia/Aqtau
    {  214, 6821,   60864,  9, }, // Atlantic/St_Helena
    {  214, 3049,    4501,  9, }, // Pacific/Kanton
    {  215, 8508,   60807, 13, }, // America/St_Barthelemy English/Latin/Tokelau
    {  215, 2061,   60820,  9, }, // America/St_Johns
    {  215, 5863,   60829,  8, }, // America/St_Kitts
    {  215, 5880,   60837,  8, }, // America/St_Lucia
    {  215,  855,   60845,  9, }, // America/St_Thomas
    {  215, 5913,   60854, 10, }, // America/St_Vincent
    {  215, 5523,    5491,  5, }, // Asia/Aqtau
    {  215, 6821,   60864,  9, }, // Atlantic/St_Helena
    {  215, 3049,    4501,  9, }, // Pacific/Kanton
    {  216, 8508,   60807, 13, }, // America/St_Barthelemy English/Latin/Tonga
    {  216, 2061,   60820,  9, }, // America/St_Johns
    {  216, 5863,   60829,  8, }, // America/St_Kitts
    {  216, 5880,   60837,  8, }, // America/St_Lucia
    {  216,  855,   60845,  9, }, // America/St_Thomas
    {  216, 5913,   60854, 10, }, // America/St_Vincent
    {  216, 5523,    5491,  5, }, // Asia/Aqtau
    {  216, 6821,   60864,  9, }, // Atlantic/St_Helena
    {  216, 3049,    4501,  9, }, // Pacific/Kanton
    {  217, 8508,   60807, 13, }, // America/St_Barthelemy English/Latin/Trinidad and Tobago
    {  217, 2061,   60820,  9, }, // America/St_Johns
    {  217, 5863,   60829,  8, }, // America/St_Kitts
    {  217, 5880,   60837,  8, }, // America/St_Lucia
    {  217,  855,   60845,  9, }, // America/St_Thomas
    {  217, 5913,   60854, 10, }, // America/St_Vincent
    {  217, 5523,    5491,  5, }, // Asia/Aqtau
    {  217, 6821,   60864,  9, }, // Atlantic/St_Helena
    {  217, 3049,    4501,  9, }, // Pacific/Kanton
    {  218, 8508,   60807, 13, }, // America/St_Barthelemy English/Latin/Turks and Caicos Islands
    {  218, 2061,   60820,  9, }, // America/St_Johns
    {  218, 5863,   60829,  8, }, // America/St_Kitts
    {  218, 5880,   60837,  8, }, // America/St_Lucia
    {  218,  855,   60845,  9, }, // America/St_Thomas
    {  218, 5913,   60854, 10, }, // America/St_Vincent
    {  218, 5523,    5491,  5, }, // Asia/Aqtau
    {  218, 6821,   60864,  9, }, // Atlantic/St_Helena
    {  218, 3049,    4501,  9, }, // Pacific/Kanton
    {  219, 8508,   60807, 13, }, // America/St_Barthelemy English/Latin/Tuvalu
    {  219, 2061,   60820,  9, }, // America/St_Johns
    {  219, 5863,   60829,  8, }, // America/St_Kitts
    {  219, 5880,   60837,  8, }, // America/St_Lucia
    {  219,  855,   60845,  9, }, // America/St_Thomas
    {  219, 5913,   60854, 10, }, // America/St_Vincent
    {  219, 5523,    5491,  5, }, // Asia/Aqtau
    {  219, 6821,   60864,  9, }, // Atlantic/St_Helena
    {  219, 3049,    4501,  9, }, // Pacific/Kanton
    {  220, 8508,   60807, 13, }, // America/St_Barthelemy English/Latin/Uganda
    {  220, 2061,   60820,  9, }, // America/St_Johns
    {  220, 5863,   60829,  8, }, // America/St_Kitts
    {  220, 5880,   60837,  8, }, // America/St_Lucia
    {  220,  855,   60845,  9, }, // America/St_Thomas
    {  220, 5913,   60854, 10, }, // America/St_Vincent
    {  220, 5523,    5491,  5, }, // Asia/Aqtau
    {  220, 6821,   60864,  9, }, // Atlantic/St_Helena
    {  220, 3049,    4501,  9, }, // Pacific/Kanton
    {  222, 7623,    3825, 14, }, // America/Bahia_Banderas English/Latin/United Kingdom
    {  222, 3868,   33182,  6, }, // America/Cancun
    {  222, 8220,    7008,  6, }, // America/Merida
    {  222, 8508,   60807, 13, }, // America/St_Barthelemy
    {  222, 2061,   60820,  9, }, // America/St_Johns
    {  222, 5863,   60829,  8, }, // America/St_Kitts
    {  222, 5880,   60837,  8, }, // America/St_Lucia
    {  222,  855,   60845,  9, }, // America/St_Thomas
    {  222, 5913,   60854, 10, }, // America/St_Vincent
    {  222, 5523,    5491,  5, }, // Asia/Aqtau
    {  222, 6821,   60864,  9, }, // Atlantic/St_Helena
    {  222, 3049,    4501,  9, }, // Pacific/Kanton
    {  225, 8508,   60807, 13, }, // America/St_Barthelemy English/Latin/Vanuatu
    {  225, 2061,   60820,  9, }, // America/St_Johns
    {  225, 5863,   60829,  8, }, // America/St_Kitts
    {  225, 5880,   60837,  8, }, // America/St_Lucia
    {  225,  855,   60845,  9, }, // America/St_Thomas
    {  225, 5913,   60854, 10, }, // America/St_Vincent
    {  225, 5523,    5491,  5, }, // Asia/Aqtau
    {  225, 6821,   60864,  9, }, // Atlantic/St_Helena
    {  225, 3049,    4501,  9, }, // Pacific/Kanton
    {  226, 8508,   60807, 13, }, // America/St_Barthelemy English/Latin/world
    {  226, 2061,   60820,  9, }, // America/St_Johns
    {  226, 5863,   60829,  8, }, // America/St_Kitts
    {  226, 5880,   60837,  8, }, // America/St_Lucia
    {  226,  855,   60845,  9, }, // America/St_Thomas
    {  226, 5913,   60854, 10, }, // America/St_Vincent
    {  226, 5523,    5491,  5, }, // Asia/Aqtau
    {  226, 6821,   60864,  9, }, // Atlantic/St_Helena
    {  226, 3049,    4501,  9, }, // Pacific/Kanton
    {  227, 8508,   60807, 13, }, // America/St_Barthelemy English/Latin/Zambia
    {  227, 2061,   60820,  9, }, // America/St_Johns
    {  227, 5863,   60829,  8, }, // America/St_Kitts
    {  227, 5880,   60837,  8, }, // America/St_Lucia
    {  227,  855,   60845,  9, }, // America/St_Thomas
    {  227, 5913,   60854, 10, }, // America/St_Vincent
    {  227, 5523,    5491,  5, }, // Asia/Aqtau
    {  227, 6821,   60864,  9, }, // Atlantic/St_Helena
    {  227, 3049,    4501,  9, }, // Pacific/Kanton
    {  228, 8508,   60807, 13, }, // America/St_Barthelemy English/Latin/Zimbabwe
    {  228, 2061,   60820,  9, }, // America/St_Johns
    {  228, 5863,   60829,  8, }, // America/St_Kitts
    {  228, 5880,   60837,  8, }, // America/St_Lucia
    {  228,  855,   60845,  9, }, // America/St_Thomas
    {  228, 5913,   60854, 10, }, // America/St_Vincent
    {  228, 5523,    5491,  5, }, // Asia/Aqtau
    {  228, 6821,   60864,  9, }, // Atlantic/St_Helena
    {  228, 3049,    4501,  9, }, // Pacific/Kanton
    {  229, 1259,     397, 11, }, // Asia/Ho_Chi_Minh English/Shavian/United Kingdom
    {  230,   14,       0,  6, }, // Africa/Asmara Erzya/Cyrillic/Russia
    {  230, 4435,       6,  8, }, // Africa/Sao_Tome
    {  230, 4252,      14,  8, }, // America/Asuncion
    {  230,  237,      22,  8, }, // America/Atikokan
    {  230, 7623,      30, 17, }, // America/Bahia_Banderas
    {  230, 7699,   36399,  5, }, // America/Boise
    {  230, 3868,      47,  6, }, // America/Cancun
    {  230, 2260,   60873,  6, }, // America/Chicago
    {  230, 7774,      53, 13, }, // America/Ciudad_Juarez
    {  230, 5723,      66,  7, }, // America/Curacao
    {  230,  805,    1201,  6, }, // America/Denver
    {  230, 5770,    1292,  7, }, // America/Grenada
    {  230,  481,      73, 13, }, // America/Indiana/Knox
    {  230, 7961,      86, 16, }, // America/Indiana/Marengo
    {  230, 7985,     102, 19, }, // America/Indiana/Petersburg
    {  230, 8012,     121, 18, }, // America/Indiana/Tell_City
    {  230, 8038,     139, 14, }, // America/Indiana/Vevay
    {  230, 8060,     153, 18, }, // America/Indiana/Vincennes
    {  230, 8086,     171, 16, }, // America/Indiana/Winamac
    {  230, 8125,     187, 20, }, // America/Kentucky/Monticello
    {  230, 5932,     207, 22, }, // America/Lower_Princes
    {  230, 8220,     229,  6, }, // America/Merida
    {  230, 8301,     235, 20, }, // America/North_Dakota/Beulah
    {  230, 8329,     255, 20, }, // America/North_Dakota/Center
    {  230, 8357,     275, 23, }, // America/North_Dakota/New_Salem
    {  230,  393,     298,  4, }, // America/Nuuk
    {  230, 2356,    1783,  6, }, // America/Panama
    {  230, 6899,     302, 16, }, // America/Scoresbysund
    {  230, 8508,     318, 14, }, // America/St_Barthelemy
    {  230, 2061,     332, 10, }, // America/St_Johns
    {  230, 5863,     342,  9, }, // America/St_Kitts
    {  230, 5880,     351,  9, }, // America/St_Lucia
    {  230,  855,     360, 10, }, // America/St_Thomas
    {  230, 5913,     370, 11, }, // America/St_Vincent
    {  230, 6133,     381, 16, }, // Antarctica/DumontDUrville
    {  230, 1429,   60879, 11, }, // Arctic/Longyearbyen
    {  230, 3607,    2237,  6, }, // Asia/Baghdad
    {  230, 3653,    2250,  4, }, // Asia/Baku
    {  230, 1259,     397, 11, }, // Asia/Ho_Chi_Minh
    {  230, 2704,   51902,  7, }, // Asia/Hong_Kong
    {  230, 1185,     413,  9, }, // Asia/Kathmandu
    {  230,  992,     422,  7, }, // Asia/Kolkata
    {  230, 1211,     429,  5, }, // Asia/Macau
    {  230, 4229,   60890,  6, }, // Asia/Omsk
    {  230, 4408,    2614,  7, }, // Asia/Sakhalin
    {  230, 7245,    2621,  9, }, // Asia/Samarkand
    {  230, 3279,    2630,  4, }, // Asia/Seoul
    {  230, 1053,   28801,  6, }, // Asia/Shanghai
    {  230, 3263,   60896,  6, }, // Asia/Taipei
    {  230, 4781,    2667,  7, }, // Asia/Tashkent
    {  230, 2821,    2692,  5, }, // Asia/Tokyo
    {  230, 4572,   60902,  7, }, // Asia/Tomsk
    {  230, 1021,   60909, 10, }, // Asia/Ulaanbaatar
    {  230, 1235,     442,  6, }, // Asia/Yangon
    {  230, 5671,   35152,  7, }, // Atlantic/Bermuda
    {  230, 1395,     448,  5, }, // Atlantic/Faroe
    {  230, 8736,   37132,  7, }, // Atlantic/Madeira
    {  230, 2748,   52082,  9, }, // Atlantic/Reykjavik
    {  230, 6821,     453, 10, }, // Atlantic/St_Helena
    {  230, 6441,    2993,  9, }, // Europe/Amsterdam
    {  230, 6216,    3002,  7, }, // Europe/Andorra
    {  230, 2300,   60919,  5, }, // Europe/Athens
    {  230, 6336,    3021,  7, }, // Europe/Belgrade
    {  230, 4757,    3028,  6, }, // Europe/Berlin
    {  230, 6488,    3034, 10, }, // Europe/Bratislava
    {  230, 2167,   52164,  8, }, // Europe/Brussels
    {  230, 3928,    3052,  8, }, // Europe/Bucharest
    {  230, 3806,    3060,  8, }, // Europe/Budapest
    {  230, 6289,   52191, 10, }, // Europe/Copenhagen
    {  230, 2338,    3108,  6, }, // Europe/Dublin
    {  230, 6612,   52201,  9, }, // Europe/Helsinki
    {  230, 8929,    3169,  5, }, // Europe/Kirov
    {  230, 2527,    3174,  4, }, // Europe/Kyiv
    {  230, 3213,    3178,  8, }, // Europe/Lisbon
    {  230, 6506,   29300,  7, }, // Europe/Ljubljana
    {  230, 2501,    3195,  6, }, // Europe/London
    {  230, 6365,   29313, 10, }, // Europe/Luxembourg
    {  230, 4892,    3212,  6, }, // Europe/Madrid
    {  230, 6397,   29329,  6, }, // Europe/Malta
    {  230, 3693,   60924,  7, }, // Europe/Minsk
    {  230, 6410,    3237,  6, }, // Europe/Monaco
    {  230, 3537,   60931,  6, }, // Europe/Moscow
    {  230, 6458,    3249,  4, }, // Europe/Oslo
    {  230, 4284,    3253,  5, }, // Europe/Paris
    {  230, 6424,    3258,  9, }, // Europe/Podgorica
    {  230, 6275,    3267,  5, }, // Europe/Prague
    {  230, 8837,    3272,  4, }, // Europe/Riga
    {  230, 6324,    3276,  3, }, // Europe/Rome
    {  230, 4331,    3279,  6, }, // Europe/Samara
    {  230, 6470,    3285, 10, }, // Europe/San_Marino
    {  230, 6245,    3295,  7, }, // Europe/Sarajevo
    {  230, 4451,    3302,  7, }, // Europe/Saratov
    {  230, 8849,   52225, 11, }, // Europe/Simferopol
    {  230, 6383,   52236,  6, }, // Europe/Skopje
    {  230, 6599,   37286,  5, }, // Europe/Sofia
    {  230, 6523,   52242,  9, }, // Europe/Stockholm
    {  230, 8867,    3337,  6, }, // Europe/Tallinn
    {  230, 6202,    3343,  6, }, // Europe/Tirane
    {  230, 6352,    3358,  5, }, // Europe/Vaduz
    {  230, 6567,    3363,  7, }, // Europe/Vatican
    {  230, 6231,    3370,  4, }, // Europe/Vienna
    {  230, 8899,   52260,  7, }, // Europe/Vilnius
    {  230, 3190,    3390,  7, }, // Europe/Warsaw
    {  230, 6261,    3397,  6, }, // Europe/Zagreb
    {  230, 6540,   37310,  5, }, // Europe/Zurich
    {  230, 7211,     467,  7, }, // Indian/Reunion
    {  230, 3157,     474,  5, }, // Pacific/Chuuk
    {  230, 3096,     479,  7, }, // Pacific/Pohnpei
    {  231, 6788,   60937,  7, }, // Africa/Abidjan Esperanto/Latin/world
    {  231, 6760,   60944,  5, }, // Africa/Accra
    {  231, 5059,   60949,  9, }, // Africa/Addis_Ababa
    {  231, 7420,   60958,  6, }, // Africa/Algiers
    {  231,   14,   60964,  6, }, // Africa/Asmara
    {  231, 5257,   60970,  5, }, // Africa/Bangui
    {  231, 6746,   60975,  7, }, // Africa/Banjul
    {  231, 7435,   60982,  6, }, // Africa/Bissau
    {  231, 5287,   60988,  9, }, // Africa/Brazzaville
    {  231, 4922,   60997,  9, }, // Africa/Bujumbura
    {  231, 2320,    4572,  5, }, // Africa/Cairo
    {  231, 4117,   61006, 10, }, // Africa/Casablanca
    {  231, 7449,   61016,  5, }, // Africa/Ceuta
    {  231, 6773,   61021,  8, }, // Africa/Conakry
    {  231, 6840,   61029,  6, }, // Africa/Dakar
    {  231, 5130,   61035, 10, }, // Africa/Dar_es_Salaam
    {  231, 5043,   61045,  7, }, // Africa/Djibouti
    {  231, 5243,   61052,  6, }, // Africa/Douala
    {  231, 5166,   61058,  5, }, // Africa/El_Aaiun
    {  231, 6853,   61063,  8, }, // Africa/Freetown
    {  231, 4906,   61071,  8, }, // Africa/Gaborone
    {  231, 5015,   61079,  7, }, // Africa/Harare
    {  231, 4479,   61086, 12, }, // Africa/Johannesburg
    {  231, 4499,   61098,  5, }, // Africa/Juba
    {  231, 5151,   61103,  7, }, // Africa/Kampala
    {  231, 4524,   61110,  7, }, // Africa/Khartoum
    {  231, 4973,   61117,  6, }, // Africa/Kigali
    {  231, 5306,   61123,  7, }, // Africa/Kinshasa
    {  231, 4744,   61130,  6, }, // Africa/Lagos
    {  231, 5336,   61136,  9, }, // Africa/Libreville
    {  231, 6869,   61145,  5, }, // Africa/Lome
    {  231, 5211,   61150,  6, }, // Africa/Luanda
    {  231, 4939,   61156,  9, }, // Africa/Lubumbashi
    {  231, 5001,   61165,  6, }, // Africa/Lusaka
    {  231, 5197,   61171,  7, }, // Africa/Maseru
    {  231, 5182,   61178,  7, }, // Africa/Mbabane
    {  231, 5113,   61185,  8, }, // Africa/Mogadishu
    {  231, 7034,   61193,  8, }, // Africa/Monrovia
    {  231, 3853,   61201,  8, }, // Africa/Nairobi
    {  231, 5271,   61209,  8, }, // Africa/Ndjamena
    {  231, 5354,   61217,  7, }, // Africa/Niamey
    {  231, 6803,   61224,  8, }, // Africa/Nouakchott
    {  231, 6727,   61232,  9, }, // Africa/Ouagadougou
    {  231, 5225,   61241,  9, }, // Africa/Porto-Novo
    {  231, 4435,   61250,  8, }, // Africa/Sao_Tome
    {  231, 2866,   61258,  7, }, // Africa/Tripoli
    {  231, 6554,   61265,  6, }, // Africa/Tunis
    {  231, 4152,   61271,  8, }, // Africa/Windhoek
    {  231, 5607,   61279,  7, }, // America/Anguilla
    {  231, 5624,   61286,  7, }, // America/Antigua
    {  231, 4554,   26427,  9, }, // America/Araguaina
    {  231,  166,   61293,  7, }, // America/Argentina/Buenos_Aires
    {  231,  270,   61300,  7, }, // America/Argentina/Cordoba
    {  231, 7489,   44005, 12, }, // America/Argentina/Rio_Gallegos
    {  231, 7520,   61307,  9, }, // America/Argentina/Salta
    {  231, 7571,   20368,  7, }, // America/Argentina/Tucuman
    {  231, 5640,   61316,  5, }, // America/Aruba
    {  231, 4252,   61321,  9, }, // America/Asuncion
    {  231,  237,      22,  8, }, // America/Atikokan
    {  231, 3679,   61330,  5, }, // America/Bahia
    {  231, 7623,      30, 17, }, // America/Bahia_Banderas
    {  231, 5654,   61335,  7, }, // America/Barbados
    {  231, 7646,   61342,  6, }, // America/Belem
    {  231, 5407,   61348,  6, }, // America/Belize
    {  231, 4361,   61354,  6, }, // America/Bogota
    {  231, 7713,   61360, 14, }, // America/Cambridge_Bay
    {  231, 3868,   61374,  7, }, // America/Cancun
    {  231, 4694,   61381,  8, }, // America/Caracas
    {  231, 4345,   61389,  6, }, // America/Cayenne
    {  231, 5496,   61395,  8, }, // America/Cayman
    {  231, 2260,   61403,  6, }, // America/Chicago
    {  231, 7774,      53, 13, }, // America/Ciudad_Juarez
    {  231, 5422,   61409,  9, }, // America/Costa_Rica
    {  231, 3791,   26442,  6, }, // America/Cuiaba
    {  231, 5723,   61418,  7, }, // America/Curacao
    {  231,  805,   61425,  7, }, // America/Denver
    {  231, 3465,   61432,  8, }, // America/Detroit
    {  231, 5739,   61440,  8, }, // America/Dominica
    {  231,  893,   61448,  9, }, // America/Edmonton
    {  231, 7869,   26448,  8, }, // America/Eirunepe
    {  231, 5441,   61457,  9, }, // America/El_Salvador
    {  231, 7906,   61466,  9, }, // America/Fortaleza
    {  231, 4612,   61475, 12, }, // America/Grand_Turk
    {  231, 5770,   61487,  7, }, // America/Grenada
    {  231, 5786,   61494,  9, }, // America/Guadeloupe
    {  231, 3760,   61503,  9, }, // America/Guatemala
    {  231, 6932,   61512,  6, }, // America/Guyana
    {  231, 1939,   61518,  9, }, // America/Halifax
    {  231, 2281,   61527,  6, }, // America/Havana
    {  231,  348,   61533, 21, }, // America/Indiana/Indianapolis
    {  231,  481,   61554, 14, }, // America/Indiana/Knox
    {  231, 7961,   61568, 17, }, // America/Indiana/Marengo
    {  231, 7985,   61585, 20, }, // America/Indiana/Petersburg
    {  231, 8012,   61605, 19, }, // America/Indiana/Tell_City
    {  231, 8038,   61624, 15, }, // America/Indiana/Vevay
    {  231, 8060,   61639, 19, }, // America/Indiana/Vincennes
    {  231, 8086,   61658, 17, }, // America/Indiana/Winamac
    {  231,  660,   61675,  8, }, // America/Iqaluit
    {  231, 2799,   61683,  7, }, // America/Jamaica
    {  231, 8125,   61690, 20, }, // America/Kentucky/Monticello
    {  231, 7169,   61710,  4, }, // America/Lima
    {  231, 3239,   61714, 11, }, // America/Los_Angeles
    {  231, 5932,     207, 22, }, // America/Lower_Princes
    {  231, 8153,   26456,  6, }, // America/Maceio
    {  231, 8168,   61725,  7, }, // America/Managua
    {  231, 1908,   61732,  7, }, // America/Manaus
    {  231, 5897,   61739,  8, }, // America/Marigot
    {  231, 5805,   61747,  9, }, // America/Martinique
    {  231, 2917,   26471,  8, }, // America/Mazatlan
    {  231, 8220,   61756,  6, }, // America/Merida
    {  231, 2949,   61762, 10, }, // America/Mexico_City
    {  231, 4391,   61772,  8, }, // America/Miquelon
    {  231, 8254,   61780,  8, }, // America/Moncton
    {  231, 8270,   61788,  9, }, // America/Monterrey
    {  231, 5824,   61797,  9, }, // America/Montserrat
    {  231, 5481,   61806,  6, }, // America/Nassau
    {  231, 2379,   61812,  8, }, // America/New_York
    {  231, 1850,   61820, 19, }, // America/Noronha
    {  231, 8301,   61839, 20, }, // America/North_Dakota/Beulah
    {  231, 8329,   61859, 20, }, // America/North_Dakota/Center
    {  231, 8357,   61879, 23, }, // America/North_Dakota/New_Salem
    {  231,  393,   61902,  4, }, // America/Nuuk
    {  231, 2356,   61906,  6, }, // America/Panama
    {  231, 2973,   61912,  7, }, // America/Phoenix
    {  231, 3945,   61919, 11, }, // America/Port-au-Prince
    {  231, 5954,   61930, 10, }, // America/Port_of_Spain
    {  231, 5843,   61940, 10, }, // America/Puerto_Rico
    {  231, 8477,   26572,  8, }, // America/Santarem
    {  231, 6111,   61950, 14, }, // America/Santo_Domingo
    {  231, 1878,   61964,  8, }, // America/Sao_Paulo
    {  231, 6899,     302, 16, }, // America/Scoresbysund
    {  231, 8508,   61972, 17, }, // America/St_Barthelemy
    {  231, 2061,     332, 10, }, // America/St_Johns
    {  231, 5863,   61989, 17, }, // America/St_Kitts
    {  231, 5880,   62006, 12, }, // America/St_Lucia
    {  231,  855,   62018, 13, }, // America/St_Thomas
    {  231, 5913,   62031, 15, }, // America/St_Vincent
    {  231, 5461,   62046, 11, }, // America/Tegucigalpa
    {  231, 5756,   26664,  7, }, // America/Thule
    {  231, 2093,   62057,  9, }, // America/Vancouver
    {  231,  734,   62066,  8, }, // America/Winnipeg
    {  231, 6133,     381, 16, }, // Antarctica/DumontDUrville
    {  231, 8568,   62074, 14, }, // Antarctica/Macquarie
    {  231, 7295,   62088,  5, }, // Antarctica/Syowa
    {  231, 1429,   62093, 11, }, // Arctic/Longyearbyen
    {  231, 5570,   62104,  5, }, // Asia/Aden
    {  231, 5395,   62109,  6, }, // Asia/Almaty
    {  231, 3968,   62115,  5, }, // Asia/Amman
    {  231, 5511,    7482,  6, }, // Asia/Anadyr
    {  231, 5523,    5491,  5, }, // Asia/Aqtau
    {  231, 5368,    7488,  6, }, // Asia/Aqtobe
    {  231,  964,   62120,  8, }, // Asia/Ashgabat
    {  231, 8624,    7494,  6, }, // Asia/Atyrau
    {  231, 3607,   62128,  7, }, // Asia/Baghdad
    {  231, 5534,   62135,  7, }, // Asia/Bahrain
    {  231, 3653,   62142,  5, }, // Asia/Baku
    {  231, 4466,   62147,  7, }, // Asia/Bangkok
    {  231, 4086,   62154,  7, }, // Asia/Beirut
    {  231, 3778,   62161,  7, }, // Asia/Bishkek
    {  231, 5989,   62168,  7, }, // Asia/Brunei
    {  231, 4601,   62175,  4, }, // Asia/Chita
    {  231, 4511,    5519,  7, }, // Asia/Colombo
    {  231, 4540,   26689,  7, }, // Asia/Damascus
    {  231, 1093,     249,  4, }, // Asia/Dhaka
    {  231, 6192,   62179,  4, }, // Asia/Dili
    {  231, 3596,   62183,  9, }, // Asia/Dubai
    {  231, 6159,   62192,  8, }, // Asia/Dushanbe
    {  231, 8651,   62200,  5, }, // Asia/Gaza
    {  231, 4795,   62205,  7, }, // Asia/Hebron
    {  231, 1259,   62212,  8, }, // Asia/Ho_Chi_Minh
    {  231, 2704,   62220,  8, }, // Asia/Hong_Kong
    {  231, 4771,   62228,  4, }, // Asia/Hovd
    {  231, 4184,   62232,  8, }, // Asia/Irkutsk
    {  231, 7006,   62240,  7, }, // Asia/Jakarta
    {  231, 1290,   62247, 10, }, // Asia/Jerusalem
    {  231, 3560,   62257,  6, }, // Asia/Kabul
    {  231, 4316,   62263,  8, }, // Asia/Kamchatka
    {  231, 4239,   62271,  7, }, // Asia/Karachi
    {  231, 1185,   62278,  9, }, // Asia/Kathmandu
    {  231, 8661,   62287,  7, }, // Asia/Khandyga
    {  231,  992,   62294,  7, }, // Asia/Kolkata
    {  231, 4197,   62301, 12, }, // Asia/Krasnoyarsk
    {  231, 4859,   62313, 12, }, // Asia/Kuala_Lumpur
    {  231, 5547,   62325,  7, }, // Asia/Kuwait
    {  231, 1211,    7613,  5, }, // Asia/Macau
    {  231, 7182,   62332,  6, }, // Asia/Manila
    {  231, 6920,   62338,  7, }, // Asia/Muscat
    {  231, 2554,   62345,  7, }, // Asia/Nicosia
    {  231, 8675,   62352, 12, }, // Asia/Novokuznetsk
    {  231, 4135,   62364, 12, }, // Asia/Novosibirsk
    {  231, 4229,   62376,  5, }, // Asia/Omsk
    {  231, 7145,   62381,  5, }, // Asia/Oral
    {  231, 6961,   62386,  8, }, // Asia/Phnom_Penh
    {  231, 4214,   62394, 10, }, // Asia/Pyongyang
    {  231, 5559,   62404,  6, }, // Asia/Qatar
    {  231, 8708,    7652,  8, }, // Asia/Qostanay
    {  231, 4269,   62410,  9, }, // Asia/Qyzylorda
    {  231, 3584,   62419,  5, }, // Asia/Riyadh
    {  231, 4408,   62424,  8, }, // Asia/Sakhalin
    {  231, 7245,   62432, 10, }, // Asia/Samarkand
    {  231, 3279,   62442,  5, }, // Asia/Seoul
    {  231, 1053,   62447,  7, }, // Asia/Shanghai
    {  231, 3300,   62454,  9, }, // Asia/Singapore
    {  231, 4297,    7699, 13, }, // Asia/Srednekolymsk
    {  231, 3263,   62463,  6, }, // Asia/Taipei
    {  231, 4781,   62469,  8, }, // Asia/Tashkent
    {  231, 3915,   62477,  7, }, // Asia/Tbilisi
    {  231, 2772,   62484,  8, }, // Asia/Tehran
    {  231, 1317,   62492,  6, }, // Asia/Thimphu
    {  231, 2821,    4238,  5, }, // Asia/Tokyo
    {  231, 1021,   62498, 10, }, // Asia/Ulaanbaatar
    {  231, 1159,   62508,  7, }, // Asia/Urumqi
    {  231, 8722,   62515,  7, }, // Asia/Ust-Nera
    {  231, 6977,   62522,  9, }, // Asia/Vientiane
    {  231, 4710,   62531, 12, }, // Asia/Vladivostok
    {  231, 4828,   62543,  8, }, // Asia/Yakutsk
    {  231, 1235,   62551,  7, }, // Asia/Yangon
    {  231, 3883,   62558, 14, }, // Asia/Yekaterinburg
    {  231, 3747,   62572,  7, }, // Asia/Yerevan
    {  231, 3663,   62579,  6, }, // Atlantic/Azores
    {  231, 5671,   62585,  8, }, // Atlantic/Bermuda
    {  231, 6628,   62593,  8, }, // Atlantic/Canary
    {  231, 3727,   62601,  9, }, // Atlantic/Cape_Verde
    {  231, 1395,   62610,  6, }, // Atlantic/Faroe
    {  231, 8736,   62616,  7, }, // Atlantic/Madeira
    {  231, 2748,   62623, 10, }, // Atlantic/Reykjavik
    {  231, 7272,   62633, 11, }, // Atlantic/South_Georgia
    {  231, 6821,   62644, 13, }, // Atlantic/St_Helena
    {  231, 6644,   62657,  8, }, // Atlantic/Stanley
    {  231, 1670,   62665,  8, }, // Australia/Adelaide
    {  231, 1635,   62673,  8, }, // Australia/Brisbane
    {  231, 1583,   62681,  7, }, // Australia/Darwin
    {  231, 1516,   62688,  7, }, // Australia/Hobart
    {  231, 1727,   62695,  8, }, // Australia/Melbourne
    {  231, 1762,   62703,  5, }, // Australia/Perth
    {  231, 1463,   62708,  7, }, // Australia/Sydney
    {  231, 6441,   62715, 10, }, // Europe/Amsterdam
    {  231, 6216,   62725,  6, }, // Europe/Andorra
    {  231, 3620,   62731,  9, }, // Europe/Astrakhan
    {  231, 2300,   62740,  5, }, // Europe/Athens
    {  231, 6336,   62745,  8, }, // Europe/Belgrade
    {  231, 4757,   62753,  7, }, // Europe/Berlin
    {  231, 6488,   62760, 10, }, // Europe/Bratislava
    {  231, 2167,   62770,  7, }, // Europe/Brussels
    {  231, 3928,   62777,  9, }, // Europe/Bucharest
    {  231, 3806,   62786,  9, }, // Europe/Budapest
    {  231, 8772,   62795, 21, }, // Europe/Busingen
    {  231, 2583,   62816,  8, }, // Europe/Chisinau
    {  231, 6289,   62824,  9, }, // Europe/Copenhagen
    {  231, 2338,   62833,  7, }, // Europe/Dublin
    {  231, 6307,   62840, 10, }, // Europe/Gibraltar
    {  231, 8788,   62850,  9, }, // Europe/Guernsey
    {  231, 6612,   62859,  8, }, // Europe/Helsinki
    {  231, 8804,   62867, 10, }, // Europe/Isle_of_Man
    {  231, 1130,   62877,  9, }, // Europe/Istanbul
    {  231, 8823,   62886,  7, }, // Europe/Jersey
    {  231, 3979,   62893, 12, }, // Europe/Kaliningrad
    {  231, 2527,   62905,  5, }, // Europe/Kyiv
    {  231, 3213,   62910,  7, }, // Europe/Lisbon
    {  231, 6506,   62917,  9, }, // Europe/Ljubljana
    {  231, 2501,   62926,  7, }, // Europe/London
    {  231, 6365,   62933, 11, }, // Europe/Luxembourg
    {  231, 4892,   62944,  7, }, // Europe/Madrid
    {  231, 6397,   62951,  5, }, // Europe/Malta
    {  231, 3693,   62956,  6, }, // Europe/Minsk
    {  231, 6410,    5926,  6, }, // Europe/Monaco
    {  231, 3537,   62962,  6, }, // Europe/Moscow
    {  231, 4284,   62968,  6, }, // Europe/Paris
    {  231, 6424,   62974,  9, }, // Europe/Podgorica
    {  231, 6275,   62983,  5, }, // Europe/Prague
    {  231, 8837,   62988,  4, }, // Europe/Riga
    {  231, 6324,   62992,  4, }, // Europe/Rome
    {  231, 6470,   62996,  9, }, // Europe/San_Marino
    {  231, 8849,   63005, 11, }, // Europe/Simferopol
    {  231, 6383,   63016,  6, }, // Europe/Skopje
    {  231, 6599,   63022,  5, }, // Europe/Sofia
    {  231, 6523,   63027,  9, }, // Europe/Stockholm
    {  231, 8867,   63036,  6, }, // Europe/Tallinn
    {  231, 6202,   63042,  6, }, // Europe/Tirane
    {  231, 8882,   63048, 10, }, // Europe/Ulyanovsk
    {  231, 6352,   63058,  6, }, // Europe/Vaduz
    {  231, 6567,   26969,  8, }, // Europe/Vatican
    {  231, 6231,   63064,  5, }, // Europe/Vienna
    {  231, 8899,   63069,  5, }, // Europe/Vilnius
    {  231, 4727,   63074, 10, }, // Europe/Volgograd
    {  231, 3190,   63084,  8, }, // Europe/Warsaw
    {  231, 6261,   63092,  7, }, // Europe/Zagreb
    {  231, 6540,   63099,  6, }, // Europe/Zurich
    {  231, 6947,   63105,  7, }, // Indian/Chagos
    {  231, 6046,   63112, 15, }, // Indian/Christmas
    {  231, 6063,   63127, 12, }, // Indian/Cocos
    {  231, 5029,   63139,  7, }, // Indian/Comoro
    {  231, 6661,   63146, 10, }, // Indian/Kerguelen
    {  231, 7260,   26983,  4, }, // Indian/Mahe
    {  231, 7050,   63156,  8, }, // Indian/Maldives
    {  231, 4069,   63164,  8, }, // Indian/Mauritius
    {  231, 5098,   63172,  6, }, // Indian/Mayotte
    {  231, 7211,   63178,  6, }, // Indian/Reunion
    {  231, 4422,   63184,  4, }, // Pacific/Apia
    {  231,  932,   63188,  8, }, // Pacific/Auckland
    {  231, 3015,   63196,  7, }, // Pacific/Chatham
    {  231, 3157,   63203,  4, }, // Pacific/Chuuk
    {  231, 2237,   63207, 10, }, // Pacific/Easter
    {  231, 3902,   63217,  5, }, // Pacific/Fiji
    {  231, 7343,   63222,  9, }, // Pacific/Funafuti
    {  231, 6678,   63231,  9, }, // Pacific/Galapagos
    {  231, 6018,   63240,  5, }, // Pacific/Guam
    {  231, 4051,   63245, 13, }, // Pacific/Marquesas
    {  231, 8914,   63258, 13, }, // Pacific/Midway
    {  231, 7084,   63271,  5, }, // Pacific/Nauru
    {  231, 7132,   63276,  4, }, // Pacific/Niue
    {  231, 4168,   63280, 13, }, // Pacific/Norfolk
    {  231, 7098,   63293,  5, }, // Pacific/Noumea
    {  231, 3126,   63298,  8, }, // Pacific/Pago_Pago
    {  231, 7155,   63306,  6, }, // Pacific/Palau
    {  231, 7194,   63312, 15, }, // Pacific/Pitcairn
    {  231, 3096,    8311,  6, }, // Pacific/Pohnpei
    {  231, 6076,   63327,  9, }, // Pacific/Rarotonga
    {  231, 6031,   63336,  7, }, // Pacific/Saipan
    {  231, 7312,   63343,  7, }, // Pacific/Tahiti
    {  231, 6712,   63350,  6, }, // Pacific/Tarawa
    {  231, 7392,   63356, 10, }, // Pacific/Wake
    {  231, 7405,   63366,  6, }, // Pacific/Wallis
    {  232, 5059,    3784, 11, }, // Africa/Addis_Ababa Estonian/Latin/Estonia
    {  232, 7420,   63372,  6, }, // Africa/Algiers
    {  232,   14,       0,  6, }, // Africa/Asmara
    {  232, 2320,    4572,  5, }, // Africa/Cairo
    {  232, 5166,   63378,  8, }, // Africa/El_Aaiun
    {  232, 4524,   63386,  6, }, // Africa/Khartoum
    {  232, 6869,   20300,  4, }, // Africa/Lome
    {  232, 5113,   26379,  8, }, // Africa/Mogadishu
    {  232, 5271,   43996,  9, }, // Africa/Ndjamena
    {  232, 4435,       6,  8, }, // Africa/Sao_Tome
    {  232, 4554,   26427,  9, }, // America/Araguaina
    {  232,  270,   20361,  7, }, // America/Argentina/Cordoba
    {  232, 7489,   44005, 12, }, // America/Argentina/Rio_Gallegos
    {  232, 7571,   20368,  7, }, // America/Argentina/Tucuman
    {  232, 4252,      14,  8, }, // America/Asuncion
    {  232,  237,      22,  8, }, // America/Atikokan
    {  232, 7623,    3825, 14, }, // America/Bahia_Banderas
    {  232, 7646,   35764,  5, }, // America/Belem
    {  232, 4361,   20389,  6, }, // America/Bogota
    {  232, 3868,      47,  6, }, // America/Cancun
    {  232, 7774,      53, 13, }, // America/Ciudad_Juarez
    {  232, 3791,   26442,  6, }, // America/Cuiaba
    {  232, 5723,      66,  7, }, // America/Curacao
    {  232, 7869,   26448,  8, }, // America/Eirunepe
    {  232, 2281,   63392,  7, }, // America/Havana
    {  232,  481,      73, 13, }, // America/Indiana/Knox
    {  232, 7961,      86, 16, }, // America/Indiana/Marengo
    {  232, 7985,     102, 19, }, // America/Indiana/Petersburg
    {  232, 8012,     121, 18, }, // America/Indiana/Tell_City
    {  232, 8038,     139, 14, }, // America/Indiana/Vevay
    {  232, 8060,     153, 18, }, // America/Indiana/Vincennes
    {  232, 8086,     171, 16, }, // America/Indiana/Winamac
    {  232, 8125,     187, 20, }, // America/Kentucky/Monticello
    {  232, 5932,     207, 22, }, // America/Lower_Princes
    {  232, 8153,   26456,  6, }, // America/Maceio
    {  232, 2917,   26471,  8, }, // America/Mazatlan
    {  232, 8220,     229,  6, }, // America/Merida
    {  232, 2949,   57469,  6, }, // America/Mexico_City
    {  232, 8301,   63399, 20, }, // America/North_Dakota/Beulah
    {  232, 8329,   63419, 20, }, // America/North_Dakota/Center
    {  232, 8357,   63439, 23, }, // America/North_Dakota/New_Salem
    {  232,  393,     298,  4, }, // America/Nuuk
    {  232, 8477,   26572,  8, }, // America/Santarem
    {  232, 1878,   26580,  9, }, // America/Sao_Paulo
    {  232, 6899,     302, 16, }, // America/Scoresbysund
    {  232, 8508,   26589, 16, }, // America/St_Barthelemy
    {  232, 2061,   26605, 12, }, // America/St_Johns
    {  232, 5863,   26617, 11, }, // America/St_Kitts
    {  232, 5880,   35832, 11, }, // America/St_Lucia
    {  232,  855,   44161, 12, }, // America/St_Thomas
    {  232, 5913,   26651, 13, }, // America/St_Vincent
    {  232, 6133,     381, 16, }, // Antarctica/DumontDUrville
    {  232, 5395,   63462,  6, }, // Asia/Almaty
    {  232, 5511,   63468,  6, }, // Asia/Anadyr
    {  232, 5523,    5491,  5, }, // Asia/Aqtau
    {  232, 5368,   63474,  6, }, // Asia/Aqtobe
    {  232,  964,   44190,  7, }, // Asia/Ashgabat
    {  232, 8624,   63480,  6, }, // Asia/Atyrau
    {  232, 3607,    4044,  6, }, // Asia/Baghdad
    {  232, 5534,    4050,  7, }, // Asia/Bahrain
    {  232, 3653,   63486,  5, }, // Asia/Baku
    {  232, 3778,   33323,  6, }, // Asia/Bishkek
    {  232, 4601,   63491,  5, }, // Asia/Chita
    {  232, 4540,    4083,  8, }, // Asia/Damascus
    {  232, 6159,   33336,  7, }, // Asia/Dushanbe
    {  232, 1259,   63496, 11, }, // Asia/Ho_Chi_Minh
    {  232, 2704,    4113,  8, }, // Asia/Hong_Kong
    {  232, 1290,   63507, 11, }, // Asia/Jerusalem
    {  232, 4316,   63518,  9, }, // Asia/Kamchatka
    {  232, 1185,    5593,  8, }, // Asia/Kathmandu
    {  232, 8661,   63527,  7, }, // Asia/Khandyga
    {  232,  992,     422,  7, }, // Asia/Kolkata
    {  232, 4197,    4170, 11, }, // Asia/Krasnoyarsk
    {  232, 5547,   63534,  6, }, // Asia/Kuwait
    {  232, 1211,    4203,  5, }, // Asia/Macau
    {  232, 6920,   63540,  6, }, // Asia/Muscat
    {  232, 2554,    5620,  7, }, // Asia/Nicosia
    {  232, 5559,    4214,  5, }, // Asia/Qatar
    {  232, 8708,    7652,  8, }, // Asia/Qostanay
    {  232, 4269,   63546,  9, }, // Asia/Qyzylorda
    {  232, 3584,   63555,  8, }, // Asia/Riyadh
    {  232, 4408,   63563,  8, }, // Asia/Sakhalin
    {  232, 3279,   57960,  4, }, // Asia/Seoul
    {  232, 3300,   20782,  8, }, // Asia/Singapore
    {  232, 4297,   63571, 13, }, // Asia/Srednekolymsk
    {  232, 4781,   33457,  7, }, // Asia/Tashkent
    {  232, 3915,   63584,  8, }, // Asia/Tbilisi
    {  232, 2772,    7724,  7, }, // Asia/Tehran
    {  232, 2821,   63592,  5, }, // Asia/Tokyo
    {  232, 1159,   26801,  6, }, // Asia/Urumqi
    {  232, 4828,    7755,  7, }, // Asia/Yakutsk
    {  232, 1235,     442,  6, }, // Asia/Yangon
    {  232, 3883,    4262, 13, }, // Asia/Yekaterinburg
    {  232, 3747,    7780,  7, }, // Asia/Yerevan
    {  232, 3663,   63597,  8, }, // Atlantic/Azores
    {  232, 6628,   63605, 14, }, // Atlantic/Canary
    {  232, 3727,   63619, 15, }, // Atlantic/Cape_Verde
    {  232, 1395,   63634, 12, }, // Atlantic/Faroe
    {  232, 2748,   36044,  9, }, // Atlantic/Reykjavik
    {  232, 7272,   63646, 13, }, // Atlantic/South_Georgia
    {  232, 6821,   36066, 12, }, // Atlantic/St_Helena
    {  232, 3620,   33512,  8, }, // Europe/Astrakhan
    {  232, 2300,   63659,  6, }, // Europe/Athens
    {  232, 6336,   26883,  7, }, // Europe/Belgrade
    {  232, 4757,   63665,  7, }, // Europe/Berlin
    {  232, 2167,   22634,  7, }, // Europe/Brussels
    {  232, 3928,   26897,  8, }, // Europe/Bucharest
    {  232, 8772,   26905,  8, }, // Europe/Busingen
    {  232, 2583,   63672,  8, }, // Europe/Chisinau
    {  232, 6289,   63680, 11, }, // Europe/Copenhagen
    {  232, 6612,   63691,  8, }, // Europe/Helsinki
    {  232, 8804,   63699,  9, }, // Europe/Isle_of_Man
    {  232, 1130,   22693,  8, }, // Europe/Istanbul
    {  232, 2527,   63708,  5, }, // Europe/Kyiv
    {  232, 3213,    4381,  8, }, // Europe/Lisbon
    {  232, 6582,   63713, 13, }, // Europe/Mariehamn
    {  232, 3537,   22748,  6, }, // Europe/Moscow
    {  232, 4284,   63726,  6, }, // Europe/Paris
    {  232, 6275,   36153,  5, }, // Europe/Prague
    {  232, 8837,   63732,  4, }, // Europe/Riga
    {  232, 6324,   63736,  5, }, // Europe/Rome
    {  232, 6202,   21095,  6, }, // Europe/Tirane
    {  232, 8882,    8143,  9, }, // Europe/Ulyanovsk
    {  232, 6567,    5978,  7, }, // Europe/Vatican
    {  232, 6231,   63741,  4, }, // Europe/Vienna
    {  232, 3190,   63745,  8, }, // Europe/Warsaw
    {  232, 6540,    4459,  6, }, // Europe/Zurich
    {  232, 6046,   63753,  9, }, // Indian/Christmas
    {  232, 6063,   63762, 12, }, // Indian/Cocos
    {  232, 7260,   26983,  4, }, // Indian/Mahe
    {  232, 7050,   63774,  9, }, // Indian/Maldives
    {  232, 7211,     467,  7, }, // Indian/Reunion
    {  232, 3157,     474,  5, }, // Pacific/Chuuk
    {  232, 2237,   63783, 13, }, // Pacific/Easter
    {  232, 3902,   33704,  5, }, // Pacific/Fiji
    {  232, 6678,   21159,  9, }, // Pacific/Galapagos
    {  232, 2723,    4493,  8, }, // Pacific/Honolulu
    {  232, 3049,    4501,  9, }, // Pacific/Kanton
    {  232, 4051,   63796, 12, }, // Pacific/Marquesas
    {  232, 7098,    4510,  6, }, // Pacific/Noumea
    {  232, 7155,   63808,  5, }, // Pacific/Palau
    {  232, 3096,     479,  7, }, // Pacific/Pohnpei
    {  233,   14,       0,  6, }, // Africa/Asmara Ewe/Latin/Ghana
    {  233, 4435,       6,  8, }, // Africa/Sao_Tome
    {  233, 4252,      14,  8, }, // America/Asuncion
    {  233,  237,      22,  8, }, // America/Atikokan
    {  233, 7623,    3825, 14, }, // America/Bahia_Banderas
    {  233, 3868,   33182,  6, }, // America/Cancun
    {  233, 7774,      53, 13, }, // America/Ciudad_Juarez
    {  233, 5723,      66,  7, }, // America/Curacao
    {  233,  481,      73, 13, }, // America/Indiana/Knox
    {  233, 7961,      86, 16, }, // America/Indiana/Marengo
    {  233, 7985,     102, 19, }, // America/Indiana/Petersburg
    {  233, 8012,     121, 18, }, // America/Indiana/Tell_City
    {  233, 8038,     139, 14, }, // America/Indiana/Vevay
    {  233, 8060,     153, 18, }, // America/Indiana/Vincennes
    {  233, 8086,     171, 16, }, // America/Indiana/Winamac
    {  233, 8125,     187, 20, }, // America/Kentucky/Monticello
    {  233, 5932,     207, 22, }, // America/Lower_Princes
    {  233, 8220,    7008,  6, }, // America/Merida
    {  233, 8301,     235, 20, }, // America/North_Dakota/Beulah
    {  233, 8329,     255, 20, }, // America/North_Dakota/Center
    {  233, 8357,     275, 23, }, // America/North_Dakota/New_Salem
    {  233,  393,     298,  4, }, // America/Nuuk
    {  233, 6899,     302, 16, }, // America/Scoresbysund
    {  233, 8508,     318, 14, }, // America/St_Barthelemy
    {  233, 2061,     332, 10, }, // America/St_Johns
    {  233, 5863,     342,  9, }, // America/St_Kitts
    {  233, 5880,     351,  9, }, // America/St_Lucia
    {  233,  855,     360, 10, }, // America/St_Thomas
    {  233, 5913,     370, 11, }, // America/St_Vincent
    {  233, 6133,     381, 16, }, // Antarctica/DumontDUrville
    {  233, 1259,     397, 11, }, // Asia/Ho_Chi_Minh
    {  233, 1185,   63813, 24, }, // Asia/Kathmandu
    {  233,  992,     422,  7, }, // Asia/Kolkata
    {  233, 1211,    4203,  5, }, // Asia/Macau
    {  233, 1235,     442,  6, }, // Asia/Yangon
    {  233, 1395,     448,  5, }, // Atlantic/Faroe
    {  233, 6821,     453, 10, }, // Atlantic/St_Helena
    {  233, 2527,    8030,  4, }, // Europe/Kyiv
    {  233, 7211,     467,  7, }, // Indian/Reunion
    {  233, 3157,     474,  5, }, // Pacific/Chuuk
    {  233, 2723,    4493,  8, }, // Pacific/Honolulu
    {  233, 3049,    4501,  9, }, // Pacific/Kanton
    {  233, 3096,     479,  7, }, // Pacific/Pohnpei
    {  235,   14,       0,  6, }, // Africa/Asmara Ewondo/Latin/Cameroon
    {  235, 4435,       6,  8, }, // Africa/Sao_Tome
    {  235, 4252,      14,  8, }, // America/Asuncion
    {  235,  237,      22,  8, }, // America/Atikokan
    {  235, 7623,      30, 17, }, // America/Bahia_Banderas
    {  235, 3868,      47,  6, }, // America/Cancun
    {  235, 7774,      53, 13, }, // America/Ciudad_Juarez
    {  235, 5723,      66,  7, }, // America/Curacao
    {  235,  481,      73, 13, }, // America/Indiana/Knox
    {  235, 7961,      86, 16, }, // America/Indiana/Marengo
    {  235, 7985,     102, 19, }, // America/Indiana/Petersburg
    {  235, 8012,     121, 18, }, // America/Indiana/Tell_City
    {  235, 8038,     139, 14, }, // America/Indiana/Vevay
    {  235, 8060,     153, 18, }, // America/Indiana/Vincennes
    {  235, 8086,     171, 16, }, // America/Indiana/Winamac
    {  235, 8125,     187, 20, }, // America/Kentucky/Monticello
    {  235, 5932,     207, 22, }, // America/Lower_Princes
    {  235, 8220,     229,  6, }, // America/Merida
    {  235, 8301,     235, 20, }, // America/North_Dakota/Beulah
    {  235, 8329,     255, 20, }, // America/North_Dakota/Center
    {  235, 8357,     275, 23, }, // America/North_Dakota/New_Salem
    {  235,  393,     298,  4, }, // America/Nuuk
    {  235, 6899,     302, 16, }, // America/Scoresbysund
    {  235, 8508,     318, 14, }, // America/St_Barthelemy
    {  235, 2061,     332, 10, }, // America/St_Johns
    {  235, 5863,     342,  9, }, // America/St_Kitts
    {  235, 5880,     351,  9, }, // America/St_Lucia
    {  235,  855,     360, 10, }, // America/St_Thomas
    {  235, 5913,     370, 11, }, // America/St_Vincent
    {  235, 6133,     381, 16, }, // Antarctica/DumontDUrville
    {  235, 1259,     397, 11, }, // Asia/Ho_Chi_Minh
    {  235, 1185,     413,  9, }, // Asia/Kathmandu
    {  235,  992,     422,  7, }, // Asia/Kolkata
    {  235, 1211,     429,  5, }, // Asia/Macau
    {  235, 1235,     442,  6, }, // Asia/Yangon
    {  235, 1395,     448,  5, }, // Atlantic/Faroe
    {  235, 6821,     453, 10, }, // Atlantic/St_Helena
    {  235, 2527,     463,  4, }, // Europe/Kyiv
    {  235, 7211,     467,  7, }, // Indian/Reunion
    {  235, 3157,     474,  5, }, // Pacific/Chuuk
    {  235, 3096,     479,  7, }, // Pacific/Pohnpei
    {  236,   14,       0,  6, }, // Africa/Asmara Faroese/Latin/Faroe Islands
    {  236, 5043,   26360,  7, }, // Africa/Djibouti
    {  236, 4435,       6,  8, }, // Africa/Sao_Tome
    {  236, 4252,      14,  8, }, // America/Asuncion
    {  236,  237,      22,  8, }, // America/Atikokan
    {  236, 7623,    3825, 14, }, // America/Bahia_Banderas
    {  236, 5407,   63837,  5, }, // America/Belize
    {  236, 3868,   33182,  6, }, // America/Cancun
    {  236, 7774,      53, 13, }, // America/Ciudad_Juarez
    {  236, 5422,   21503, 10, }, // America/Costa_Rica
    {  236, 5723,      66,  7, }, // America/Curacao
    {  236,  481,      73, 13, }, // America/Indiana/Knox
    {  236, 7961,      86, 16, }, // America/Indiana/Marengo
    {  236, 7985,     102, 19, }, // America/Indiana/Petersburg
    {  236, 8012,     121, 18, }, // America/Indiana/Tell_City
    {  236, 8038,     139, 14, }, // America/Indiana/Vevay
    {  236, 8060,     153, 18, }, // America/Indiana/Vincennes
    {  236, 8086,     171, 16, }, // America/Indiana/Winamac
    {  236, 2799,    3877,  7, }, // America/Jamaica
    {  236, 8125,     187, 20, }, // America/Kentucky/Monticello
    {  236, 5932,     207, 22, }, // America/Lower_Princes
    {  236, 8220,    7008,  6, }, // America/Merida
    {  236, 8301,     235, 20, }, // America/North_Dakota/Beulah
    {  236, 8329,     255, 20, }, // America/North_Dakota/Center
    {  236, 8357,     275, 23, }, // America/North_Dakota/New_Salem
    {  236,  393,     298,  4, }, // America/Nuuk
    {  236, 5843,   21940, 11, }, // America/Puerto_Rico
    {  236, 6899,     302, 16, }, // America/Scoresbysund
    {  236, 8508,     318, 14, }, // America/St_Barthelemy
    {  236, 2061,     332, 10, }, // America/St_Johns
    {  236, 5863,     342,  9, }, // America/St_Kitts
    {  236, 5880,     351,  9, }, // America/St_Lucia
    {  236,  855,     360, 10, }, // America/St_Thomas
    {  236, 5913,     370, 11, }, // America/St_Vincent
    {  236, 6133,     381, 16, }, // Antarctica/DumontDUrville
    {  236, 5534,   63842,  6, }, // Asia/Bahrain
    {  236, 8651,   63848,  4, }, // Asia/Gaza
    {  236, 1259,     397, 11, }, // Asia/Ho_Chi_Minh
    {  236, 1185,     413,  9, }, // Asia/Kathmandu
    {  236,  992,     422,  7, }, // Asia/Kolkata
    {  236, 5547,   63852,  6, }, // Asia/Kuwait
    {  236, 1211,    7613,  5, }, // Asia/Macau
    {  236, 8708,     434,  8, }, // Asia/Qostanay
    {  236, 3300,    7691,  8, }, // Asia/Singapore
    {  236, 2772,    7724,  7, }, // Asia/Tehran
    {  236, 1235,   58486,  7, }, // Asia/Yangon
    {  236, 3663,   63858,  9, }, // Atlantic/Azores
    {  236, 3727,   63867, 16, }, // Atlantic/Cape_Verde
    {  236, 1395,   63883,  7, }, // Atlantic/Faroe
    {  236, 2748,   36044,  9, }, // Atlantic/Reykjavik
    {  236, 7272,   63890, 19, }, // Atlantic/South_Georgia
    {  236, 6821,     453, 10, }, // Atlantic/St_Helena
    {  236, 2300,    5793,  4, }, // Europe/Athens
    {  236, 6336,    7942,  7, }, // Europe/Belgrade
    {  236, 2167,   57529,  9, }, // Europe/Brussels
    {  236, 3928,   26897,  8, }, // Europe/Bucharest
    {  236, 6289,   63909, 13, }, // Europe/Copenhagen
    {  236, 2527,    8030,  4, }, // Europe/Kyiv
    {  236, 3213,    4381,  8, }, // Europe/Lisbon
    {  236, 6365,   63922, 10, }, // Europe/Luxembourg
    {  236, 6410,    5926,  6, }, // Europe/Monaco
    {  236, 3537,   22748,  6, }, // Europe/Moscow
    {  236, 6275,    8083,  4, }, // Europe/Prague
    {  236, 6324,    5946,  3, }, // Europe/Rome
    {  236, 6523,   63932,  9, }, // Europe/Stockholm
    {  236, 6567,   63941,  9, }, // Europe/Vatican
    {  236, 6231,   57383,  4, }, // Europe/Vienna
    {  236, 3190,   63950,  8, }, // Europe/Warsaw
    {  236, 6540,    4459,  6, }, // Europe/Zurich
    {  236, 7050,   63958, 13, }, // Indian/Maldives
    {  236, 4069,   63971,  8, }, // Indian/Mauritius
    {  236, 7211,     467,  7, }, // Indian/Reunion
    {  236, 3157,     474,  5, }, // Pacific/Chuuk
    {  236, 2723,    4493,  8, }, // Pacific/Honolulu
    {  236, 3049,    4501,  9, }, // Pacific/Kanton
    {  236, 3096,     479,  7, }, // Pacific/Pohnpei
    {  238,   14,       0,  6, }, // Africa/Asmara Filipino/Latin/Philippines
    {  238, 4435,       6,  8, }, // Africa/Sao_Tome
    {  238, 4252,      14,  8, }, // America/Asuncion
    {  238,  237,      22,  8, }, // America/Atikokan
    {  238, 7623,    3825, 14, }, // America/Bahia_Banderas
    {  238, 3868,   33182,  6, }, // America/Cancun
    {  238, 7774,   63979, 17, }, // America/Ciudad_Juarez
    {  238, 5723,      66,  7, }, // America/Curacao
    {  238,  481,      73, 13, }, // America/Indiana/Knox
    {  238, 7961,      86, 16, }, // America/Indiana/Marengo
    {  238, 7985,     102, 19, }, // America/Indiana/Petersburg
    {  238, 8012,     121, 18, }, // America/Indiana/Tell_City
    {  238, 8038,     139, 14, }, // America/Indiana/Vevay
    {  238, 8060,     153, 18, }, // America/Indiana/Vincennes
    {  238, 8086,     171, 16, }, // America/Indiana/Winamac
    {  238, 8125,     187, 20, }, // America/Kentucky/Monticello
    {  238, 5932,     207, 22, }, // America/Lower_Princes
    {  238, 8220,    7008,  6, }, // America/Merida
    {  238, 2949,   63996, 17, }, // America/Mexico_City
    {  238, 8301,     235, 20, }, // America/North_Dakota/Beulah
    {  238, 8329,     255, 20, }, // America/North_Dakota/Center
    {  238, 8357,     275, 23, }, // America/North_Dakota/New_Salem
    {  238,  393,     298,  4, }, // America/Nuuk
    {  238, 5954,   64013, 18, }, // America/Port_of_Spain
    {  238, 8424,   64031, 25, }, // America/Rankin_Inlet
    {  238, 6899,     302, 16, }, // America/Scoresbysund
    {  238, 8508,     318, 14, }, // America/St_Barthelemy
    {  238, 2061,     332, 10, }, // America/St_Johns
    {  238, 5863,     342,  9, }, // America/St_Kitts
    {  238, 5880,     351,  9, }, // America/St_Lucia
    {  238,  855,     360, 10, }, // America/St_Thomas
    {  238, 5913,     370, 11, }, // America/St_Vincent
    {  238, 6133,     381, 16, }, // Antarctica/DumontDUrville
    {  238, 1259,   64056, 22, }, // Asia/Ho_Chi_Minh
    {  238, 1185,     413,  9, }, // Asia/Kathmandu
    {  238,  992,     422,  7, }, // Asia/Kolkata
    {  238, 1211,    4203,  5, }, // Asia/Macau
    {  238, 8708,     434,  8, }, // Asia/Qostanay
    {  238, 1235,     442,  6, }, // Asia/Yangon
    {  238, 1395,     448,  5, }, // Atlantic/Faroe
    {  238, 6821,     453, 10, }, // Atlantic/St_Helena
    {  238, 2527,    8030,  4, }, // Europe/Kyiv
    {  238, 7211,     467,  7, }, // Indian/Reunion
    {  238, 3157,     474,  5, }, // Pacific/Chuuk
    {  238, 2723,    4493,  8, }, // Pacific/Honolulu
    {  238, 3049,    4501,  9, }, // Pacific/Kanton
    {  238, 3096,     479,  7, }, // Pacific/Pohnpei
    {  239, 5059,    3784, 11, }, // Africa/Addis_Ababa Finnish/Latin/Finland
    {  239, 7420,   43956,  5, }, // Africa/Algiers
    {  239,   14,       0,  6, }, // Africa/Asmara
    {  239, 2320,    4572,  5, }, // Africa/Cairo
    {  239, 5166,   63378,  8, }, // Africa/El_Aaiun
    {  239, 4524,   26372,  7, }, // Africa/Khartoum
    {  239, 6869,   20300,  4, }, // Africa/Lome
    {  239, 5271,   43996,  9, }, // Africa/Ndjamena
    {  239, 4435,       6,  8, }, // Africa/Sao_Tome
    {  239, 4554,   26427,  9, }, // America/Araguaina
    {  239,  270,   20361,  7, }, // America/Argentina/Cordoba
    {  239, 7571,   20368,  7, }, // America/Argentina/Tucuman
    {  239, 4252,      14,  8, }, // America/Asuncion
    {  239,  237,      22,  8, }, // America/Atikokan
    {  239, 7623,      30, 17, }, // America/Bahia_Banderas
    {  239, 4361,   20389,  6, }, // America/Bogota
    {  239, 3868,      47,  6, }, // America/Cancun
    {  239, 7774,      53, 13, }, // America/Ciudad_Juarez
    {  239, 3791,   26442,  6, }, // America/Cuiaba
    {  239, 5723,      66,  7, }, // America/Curacao
    {  239, 7869,   26448,  8, }, // America/Eirunepe
    {  239, 2281,   63392,  7, }, // America/Havana
    {  239,  481,      73, 13, }, // America/Indiana/Knox
    {  239, 7961,      86, 16, }, // America/Indiana/Marengo
    {  239, 7985,     102, 19, }, // America/Indiana/Petersburg
    {  239, 8012,     121, 18, }, // America/Indiana/Tell_City
    {  239, 8038,     139, 14, }, // America/Indiana/Vevay
    {  239, 8060,     153, 18, }, // America/Indiana/Vincennes
    {  239, 8086,     171, 16, }, // America/Indiana/Winamac
    {  239, 2799,    3877,  7, }, // America/Jamaica
    {  239, 8125,     187, 20, }, // America/Kentucky/Monticello
    {  239, 5932,     207, 22, }, // America/Lower_Princes
    {  239, 8153,   26456,  6, }, // America/Maceio
    {  239, 2917,   26471,  8, }, // America/Mazatlan
    {  239, 8220,     229,  6, }, // America/Merida
    {  239, 2949,   57459, 16, }, // America/Mexico_City
    {  239, 8301,   64078, 22, }, // America/North_Dakota/Beulah
    {  239, 8329,   64100, 22, }, // America/North_Dakota/Center
    {  239, 8357,   64122, 25, }, // America/North_Dakota/New_Salem
    {  239,  393,   35796,  7, }, // America/Nuuk
    {  239, 8477,   26572,  8, }, // America/Santarem
    {  239, 2201,   64147, 17, }, // America/Santiago
    {  239, 1878,   26580,  9, }, // America/Sao_Paulo
    {  239, 6899,   44149, 12, }, // America/Scoresbysund
    {  239, 8508,   26589, 16, }, // America/St_Barthelemy
    {  239, 2061,     332, 10, }, // America/St_Johns
    {  239, 5863,   26617, 11, }, // America/St_Kitts
    {  239, 5880,   35832, 11, }, // America/St_Lucia
    {  239,  855,   44161, 12, }, // America/St_Thomas
    {  239, 5913,   26651, 13, }, // America/St_Vincent
    {  239, 5756,   26664,  7, }, // America/Thule
    {  239, 6133,     381, 16, }, // Antarctica/DumontDUrville
    {  239, 8568,   64164, 15, }, // Antarctica/Macquarie
    {  239, 5523,   64179,  5, }, // Asia/Aqtau
    {  239, 5368,   57073,  6, }, // Asia/Aqtobe
    {  239,  964,   57483,  7, }, // Asia/Ashgabat
    {  239, 8624,   58649,  6, }, // Asia/Atyrau
    {  239, 3607,    4044,  6, }, // Asia/Baghdad
    {  239, 3778,   33323,  6, }, // Asia/Bishkek
    {  239, 4601,   63491,  5, }, // Asia/Chita
    {  239, 4540,   64184,  8, }, // Asia/Damascus
    {  239, 6159,   33336,  7, }, // Asia/Dushanbe
    {  239, 1259,   64192, 22, }, // Asia/Ho_Chi_Minh
    {  239, 2704,    4113,  8, }, // Asia/Hong_Kong
    {  239, 4316,   63518,  9, }, // Asia/Kamchatka
    {  239, 1185,     413,  9, }, // Asia/Kathmandu
    {  239, 8661,   64214,  7, }, // Asia/Khandyga
    {  239,  992,   64221,  8, }, // Asia/Kolkata
    {  239, 4197,    4170, 11, }, // Asia/Krasnoyarsk
    {  239, 1211,     429,  5, }, // Asia/Macau
    {  239, 6920,   35935,  6, }, // Asia/Muscat
    {  239, 2554,    5620,  7, }, // Asia/Nicosia
    {  239, 7145,   57921,  6, }, // Asia/Oral
    {  239, 4214,   33430,  9, }, // Asia/Pyongyang
    {  239, 8708,   64229,  8, }, // Asia/Qostanay
    {  239, 4269,   22401,  9, }, // Asia/Qyzylorda
    {  239, 3584,    7669,  4, }, // Asia/Riyadh
    {  239, 4408,   33444,  7, }, // Asia/Sakhalin
    {  239, 3279,   57960,  4, }, // Asia/Seoul
    {  239, 4781,   33457,  7, }, // Asia/Tashkent
    {  239, 2772,    7724,  7, }, // Asia/Tehran
    {  239, 2821,    4238,  5, }, // Asia/Tokyo
    {  239, 1021,   26791, 10, }, // Asia/Ulaanbaatar
    {  239, 1159,   26801,  6, }, // Asia/Urumqi
    {  239, 4828,    7755,  7, }, // Asia/Yakutsk
    {  239, 1235,     442,  6, }, // Asia/Yangon
    {  239, 3883,    4262, 13, }, // Asia/Yekaterinburg
    {  239, 3747,    7780,  7, }, // Asia/Yerevan
    {  239, 3663,   64237,  6, }, // Atlantic/Azores
    {  239, 6628,   64243, 14, }, // Atlantic/Canary
    {  239, 3727,   57248,  9, }, // Atlantic/Cape_Verde
    {  239, 1395,   64257,  9, }, // Atlantic/Faroe
    {  239, 2748,   36044,  9, }, // Atlantic/Reykjavik
    {  239, 7272,   64266, 13, }, // Atlantic/South_Georgia
    {  239, 6821,   36066, 12, }, // Atlantic/St_Helena
    {  239, 3620,   33512,  8, }, // Europe/Astrakhan
    {  239, 2300,   63659,  6, }, // Europe/Athens
    {  239, 6336,   26883,  7, }, // Europe/Belgrade
    {  239, 4757,   64279,  8, }, // Europe/Berlin
    {  239, 2167,   64287,  7, }, // Europe/Brussels
    {  239, 3928,   26897,  8, }, // Europe/Bucharest
    {  239, 8772,   26905,  8, }, // Europe/Busingen
    {  239, 2583,   64294,  8, }, // Europe/Chisinau
    {  239, 6289,   64302, 12, }, // Europe/Copenhagen
    {  239, 8804,   64314,  8, }, // Europe/Isle_of_Man
    {  239, 2527,   64322,  5, }, // Europe/Kyiv
    {  239, 3213,    4381,  8, }, // Europe/Lisbon
    {  239, 2501,   64327,  6, }, // Europe/London
    {  239, 6365,    4395,  9, }, // Europe/Luxembourg
    {  239, 6582,   63713, 13, }, // Europe/Mariehamn
    {  239, 3537,   64333,  7, }, // Europe/Moscow
    {  239, 4284,   64340,  7, }, // Europe/Paris
    {  239, 6275,   36153,  5, }, // Europe/Prague
    {  239, 8837,   64347,  5, }, // Europe/Riga
    {  239, 6324,   63736,  5, }, // Europe/Rome
    {  239, 6523,   64352,  8, }, // Europe/Stockholm
    {  239, 8867,   64360,  8, }, // Europe/Tallinn
    {  239, 6202,   21095,  6, }, // Europe/Tirane
    {  239, 8882,    8143,  9, }, // Europe/Ulyanovsk
    {  239, 6567,   64368,  9, }, // Europe/Vatican
    {  239, 6231,   57383,  4, }, // Europe/Vienna
    {  239, 8899,   64377,  5, }, // Europe/Vilnius
    {  239, 3190,   64382,  7, }, // Europe/Warsaw
    {  239, 6540,    4459,  6, }, // Europe/Zurich
    {  239, 6046,   64389, 10, }, // Indian/Christmas
    {  239, 6063,   64399, 12, }, // Indian/Cocos
    {  239, 5029,   64411,  7, }, // Indian/Comoro
    {  239, 6661,   64418, 15, }, // Indian/Kerguelen
    {  239, 7260,   26983,  4, }, // Indian/Mahe
    {  239, 7050,   64433, 10, }, // Indian/Maldives
    {  239, 7211,     467,  7, }, // Indian/Reunion
    {  239, 3015,   64443, 13, }, // Pacific/Chatham
    {  239, 3157,     474,  5, }, // Pacific/Chuuk
    {  239, 2237,   64456, 13, }, // Pacific/Easter
    {  239, 3902,   33704,  5, }, // Pacific/Fiji
    {  239, 6696,   64469, 13, }, // Pacific/Gambier
    {  239, 2723,    4493,  8, }, // Pacific/Honolulu
    {  239, 3049,    4501,  9, }, // Pacific/Kanton
    {  239, 4051,   64482, 15, }, // Pacific/Marquesas
    {  239, 8914,   64497, 12, }, // Pacific/Midway
    {  239, 7098,    4510,  6, }, // Pacific/Noumea
    {  239, 3096,     479,  7, }, // Pacific/Pohnpei
    {  240, 5059,   64509, 11, }, // Africa/Addis_Ababa French/Latin/France
    {  240, 7420,   43956,  5, }, // Africa/Algiers
    {  240,   14,       0,  6, }, // Africa/Asmara
    {  240, 2320,   64520,  8, }, // Africa/Cairo
    {  240, 5166,   64528,  8, }, // Africa/El_Aaiun
    {  240, 6869,   20300,  4, }, // Africa/Lome
    {  240, 5113,   43978, 10, }, // Africa/Mogadishu
    {  240, 5271,   43996,  9, }, // Africa/Ndjamena
    {  240, 4435,       6,  8, }, // Africa/Sao_Tome
    {  240, 2866,   64536, 15, }, // Africa/Tripoli
    {  240, 4554,   26427,  9, }, // America/Araguaina
    {  240,  270,   20361,  7, }, // America/Argentina/Cordoba
    {  240, 7489,   44005, 12, }, // America/Argentina/Rio_Gallegos
    {  240, 7571,   20368,  7, }, // America/Argentina/Tucuman
    {  240, 7597,   64551,  7, }, // America/Argentina/Ushuaia
    {  240, 4252,      14,  8, }, // America/Asuncion
    {  240,  237,      22,  8, }, // America/Atikokan
    {  240, 7623,   64558, 17, }, // America/Bahia_Banderas
    {  240, 5654,   64575, 10, }, // America/Barbados
    {  240, 7646,   35764,  5, }, // America/Belem
    {  240, 3868,      47,  6, }, // America/Cancun
    {  240, 5496,   64585,  7, }, // America/Cayman
    {  240, 7774,      53, 13, }, // America/Ciudad_Juarez
    {  240, 3791,   26442,  6, }, // America/Cuiaba
    {  240, 5723,      66,  7, }, // America/Curacao
    {  240, 3465,   64592,  7, }, // America/Detroit
    {  240, 5739,   64599,  9, }, // America/Dominica
    {  240, 7869,   26448,  8, }, // America/Eirunepe
    {  240, 5770,   64608,  7, }, // America/Grenada
    {  240, 2281,   64615,  9, }, // America/Havana
    {  240,  481,   64624, 14, }, // America/Indiana/Knox
    {  240, 7961,   64638, 17, }, // America/Indiana/Marengo
    {  240, 7985,   64655, 20, }, // America/Indiana/Petersburg
    {  240, 8012,   64675, 19, }, // America/Indiana/Tell_City
    {  240, 8038,   64694, 15, }, // America/Indiana/Vevay
    {  240, 8060,   64709, 19, }, // America/Indiana/Vincennes
    {  240, 8086,   64728, 17, }, // America/Indiana/Winamac
    {  240, 2799,   64745,  8, }, // America/Jamaica
    {  240, 8125,   64753, 21, }, // America/Kentucky/Monticello
    {  240, 5932,     207, 22, }, // America/Lower_Princes
    {  240, 8153,   26456,  6, }, // America/Maceio
    {  240, 1908,   64774,  6, }, // America/Manaus
    {  240, 2917,   26471,  8, }, // America/Mazatlan
    {  240, 8220,     229,  6, }, // America/Merida
    {  240, 2949,   58630,  6, }, // America/Mexico_City
    {  240, 8301,   64780, 23, }, // America/North_Dakota/Beulah
    {  240, 8329,   64803, 23, }, // America/North_Dakota/Center
    {  240, 8357,   64826, 26, }, // America/North_Dakota/New_Salem
    {  240,  393,     298,  4, }, // America/Nuuk
    {  240, 5954,   64852, 14, }, // America/Port_of_Spain
    {  240, 5843,   64866, 10, }, // America/Puerto_Rico
    {  240, 8477,   26572,  8, }, // America/Santarem
    {  240, 6111,   64876, 14, }, // America/Santo_Domingo
    {  240, 1878,   26580,  9, }, // America/Sao_Paulo
    {  240, 6899,     302, 16, }, // America/Scoresbysund
    {  240, 8508,   26589, 16, }, // America/St_Barthelemy
    {  240, 2061,   64890, 25, }, // America/St_Johns
    {  240, 5863,   64915, 16, }, // America/St_Kitts
    {  240, 5880,   64931, 12, }, // America/St_Lucia
    {  240,  855,   26639, 12, }, // America/St_Thomas
    {  240, 5913,   64943, 13, }, // America/St_Vincent
    {  240, 5756,   64956,  5, }, // America/Thule
    {  240, 6133,   57010, 16, }, // Antarctica/DumontDUrville
    {  240, 7295,   62088,  5, }, // Antarctica/Syowa
    {  240, 5395,   57475,  8, }, // Asia/Almaty
    {  240, 5523,   64961,  6, }, // Asia/Aqtau
    {  240, 5368,   64967, 11, }, // Asia/Aqtobe
    {  240,  964,   64978,  8, }, // Asia/Ashgabat
    {  240, 8624,   64986,  7, }, // Asia/Atyrau
    {  240, 3607,    4044,  6, }, // Asia/Baghdad
    {  240, 5534,   64993,  7, }, // Asia/Bahrain
    {  240, 3653,   35866,  5, }, // Asia/Baku
    {  240, 4086,   65000,  8, }, // Asia/Beirut
    {  240, 3778,   65008,  7, }, // Asia/Bishkek
    {  240, 4601,   35877,  6, }, // Asia/Chita
    {  240, 4540,    4083,  5, }, // Asia/Damascus
    {  240, 3596,   65015,  5, }, // Asia/Dubai
    {  240, 6159,   65020,  9, }, // Asia/Dushanbe
    {  240, 8636,   65029, 10, }, // Asia/Famagusta
    {  240, 4795,   65039,  6, }, // Asia/Hebron
    {  240, 1259,   65045, 17, }, // Asia/Ho_Chi_Minh
    {  240, 4184,   65062,  8, }, // Asia/Irkutsk
    {  240, 1290,   65070,  9, }, // Asia/Jerusalem
    {  240, 3560,   35905,  6, }, // Asia/Kabul
    {  240, 4316,   35911, 10, }, // Asia/Kamchatka
    {  240, 1185,   65079,  9, }, // Asia/Kathmandu
    {  240,  992,   35921,  8, }, // Asia/Kolkata
    {  240, 4197,   65088, 11, }, // Asia/Krasnoyarsk
    {  240, 5547,   65099,  6, }, // Asia/Kuwait
    {  240, 1211,     429,  5, }, // Asia/Macau
    {  240, 1349,   65105,  8, }, // Asia/Makassar
    {  240, 7182,   65113,  7, }, // Asia/Manila
    {  240, 6920,   20739,  7, }, // Asia/Muscat
    {  240, 2554,   65120,  7, }, // Asia/Nicosia
    {  240, 4135,   44247, 12, }, // Asia/Novosibirsk
    {  240, 7145,   65127,  7, }, // Asia/Oral
    {  240, 8708,   65134,  8, }, // Asia/Qostanay
    {  240, 4269,   65142,  9, }, // Asia/Qyzylorda
    {  240, 3584,   20756,  5, }, // Asia/Riyadh
    {  240, 4408,   65151,  9, }, // Asia/Sakhalin
    {  240, 7245,   65160, 10, }, // Asia/Samarkand
    {  240, 3279,   65170,  5, }, // Asia/Seoul
    {  240, 3300,   35969,  9, }, // Asia/Singapore
    {  240, 4781,   65175,  8, }, // Asia/Tashkent
    {  240, 3915,   65183,  8, }, // Asia/Tbilisi
    {  240, 2772,   65191,  7, }, // Asia/Tehran
    {  240, 1021,   65198, 11, }, // Asia/Ulaanbaatar
    {  240, 1159,   26801,  6, }, // Asia/Urumqi
    {  240, 4828,   65209,  8, }, // Asia/Yakutsk
    {  240, 1235,   65217,  7, }, // Asia/Yangon
    {  240, 3883,   65224, 13, }, // Asia/Yekaterinburg
    {  240, 3747,   26815,  6, }, // Asia/Yerevan
    {  240, 3663,   44329,  6, }, // Atlantic/Azores
    {  240, 5671,   44335,  8, }, // Atlantic/Bermuda
    {  240, 6628,   65237, 13, }, // Atlantic/Canary
    {  240, 3727,   65250,  8, }, // Atlantic/Cape_Verde
    {  240, 1395,   65258, 10, }, // Atlantic/Faroe
    {  240, 8736,   65268,  6, }, // Atlantic/Madeira
    {  240, 7272,   65274, 14, }, // Atlantic/South_Georgia
    {  240, 6821,   65288, 13, }, // Atlantic/St_Helena
    {  240, 1670,   65301,  8, }, // Australia/Adelaide
    {  240, 6216,   65309,  7, }, // Europe/Andorra
    {  240, 2300,   65316,  7, }, // Europe/Athens
    {  240, 2167,   57529,  9, }, // Europe/Brussels
    {  240, 3928,   20955,  8, }, // Europe/Bucharest
    {  240, 8772,   26905,  8, }, // Europe/Busingen
    {  240, 6289,   20963, 10, }, // Europe/Copenhagen
    {  240, 8788,   26913,  9, }, // Europe/Guernsey
    {  240, 8804,   65323, 10, }, // Europe/Isle_of_Man
    {  240, 2527,    8030,  4, }, // Europe/Kyiv
    {  240, 3213,   65333,  8, }, // Europe/Lisbon
    {  240, 2501,   21034,  7, }, // Europe/London
    {  240, 6397,   65341,  5, }, // Europe/Malta
    {  240, 3537,   44444,  6, }, // Europe/Moscow
    {  240, 6470,   65346, 11, }, // Europe/San_Marino
    {  240, 6202,   21095,  6, }, // Europe/Tirane
    {  240, 8882,   65357, 10, }, // Europe/Ulyanovsk
    {  240, 6567,   65367, 10, }, // Europe/Vatican
    {  240, 6231,   65377,  6, }, // Europe/Vienna
    {  240, 3190,   65383,  8, }, // Europe/Warsaw
    {  240, 5029,   65391,  7, }, // Indian/Comoro
    {  240, 7260,   26983,  4, }, // Indian/Mahe
    {  240, 4069,   65398,  7, }, // Indian/Mauritius
    {  240, 7211,   65405, 10, }, // Indian/Reunion
    {  240, 3157,     474,  5, }, // Pacific/Chuuk
    {  240, 2237,   65415, 13, }, // Pacific/Easter
    {  240, 7360,   27016,  5, }, // Pacific/Efate
    {  240, 3902,    4488,  5, }, // Pacific/Fiji
    {  240, 6678,   21159,  9, }, // Pacific/Galapagos
    {  240, 2723,    4493,  8, }, // Pacific/Honolulu
    {  240, 3049,    4501,  9, }, // Pacific/Kanton
    {  240, 4051,   65428,  9, }, // Pacific/Marquesas
    {  240, 7098,    4510,  6, }, // Pacific/Noumea
    {  240, 7155,   65437,  6, }, // Pacific/Palau
    {  240, 3096,     479,  7, }, // Pacific/Pohnpei
    {  247, 5271,   65443,  8, }, // Africa/Ndjamena French/Latin/Canada
    {  247, 2866,   65451, 15, }, // Africa/Tripoli
    {  247, 5654,   65466, 12, }, // America/Barbados
    {  247, 5496,   65478, 12, }, // America/Cayman
    {  247, 8301,   65490, 23, }, // America/North_Dakota/Beulah
    {  247, 8329,   65513, 23, }, // America/North_Dakota/Center
    {  247, 8357,   65536, 26, }, // America/North_Dakota/New_Salem
    {  247, 2061,     332, 10, }, // America/St_Johns
    {  247, 5863,   65562, 26, }, // America/St_Kitts
    {  247,  855,   44161, 12, }, // America/St_Thomas
    {  247, 6133,     381, 16, }, // Antarctica/DumontDUrville
    {  247, 1093,   65588,  5, }, // Asia/Dhaka
    {  247, 1317,   65593,  8, }, // Asia/Thimphu
    {  247, 6628,   65601, 13, }, // Atlantic/Canary
    {  247, 1395,   65614, 10, }, // Atlantic/Faroe
    {  247, 8804,   65624, 10, }, // Europe/Isle_of_Man
    {  247, 2501,   21034,  7, }, // Europe/London
    {  247, 6567,   21104,  7, }, // Europe/Vatican
    {  247, 2237,   65634, 13, }, // Pacific/Easter
    {  247, 7155,   65647,  5, }, // Pacific/Palau
    {  286,   14,       0,  6, }, // Africa/Asmara Friulian/Latin/Italy
    {  286, 4435,       6,  8, }, // Africa/Sao_Tome
    {  286, 4252,      14,  8, }, // America/Asuncion
    {  286,  237,      22,  8, }, // America/Atikokan
    {  286, 7623,      30, 17, }, // America/Bahia_Banderas
    {  286, 3868,      47,  6, }, // America/Cancun
    {  286, 7774,      53, 13, }, // America/Ciudad_Juarez
    {  286, 5723,      66,  7, }, // America/Curacao
    {  286,  481,      73, 13, }, // America/Indiana/Knox
    {  286, 7961,      86, 16, }, // America/Indiana/Marengo
    {  286, 7985,     102, 19, }, // America/Indiana/Petersburg
    {  286, 8012,     121, 18, }, // America/Indiana/Tell_City
    {  286, 8038,     139, 14, }, // America/Indiana/Vevay
    {  286, 8060,     153, 18, }, // America/Indiana/Vincennes
    {  286, 8086,     171, 16, }, // America/Indiana/Winamac
    {  286, 8125,     187, 20, }, // America/Kentucky/Monticello
    {  286, 5932,     207, 22, }, // America/Lower_Princes
    {  286, 8220,     229,  6, }, // America/Merida
    {  286, 2379,   65652, 10, }, // America/New_York
    {  286, 8301,     235, 20, }, // America/North_Dakota/Beulah
    {  286, 8329,     255, 20, }, // America/North_Dakota/Center
    {  286, 8357,     275, 23, }, // America/North_Dakota/New_Salem
    {  286,  393,     298,  4, }, // America/Nuuk
    {  286, 1878,   65662, 20, }, // America/Sao_Paulo
    {  286, 6899,     302, 16, }, // America/Scoresbysund
    {  286, 8508,     318, 14, }, // America/St_Barthelemy
    {  286, 2061,     332, 10, }, // America/St_Johns
    {  286, 5863,     342,  9, }, // America/St_Kitts
    {  286, 5880,     351,  9, }, // America/St_Lucia
    {  286,  855,     360, 10, }, // America/St_Thomas
    {  286, 5913,     370, 11, }, // America/St_Vincent
    {  286, 6133,     381, 16, }, // Antarctica/DumontDUrville
    {  286, 1259,     397, 11, }, // Asia/Ho_Chi_Minh
    {  286, 1185,     413,  9, }, // Asia/Kathmandu
    {  286,  992,     422,  7, }, // Asia/Kolkata
    {  286, 1211,     429,  5, }, // Asia/Macau
    {  286, 1235,     442,  6, }, // Asia/Yangon
    {  286, 3663,   65682,  6, }, // Atlantic/Azores
    {  286, 6628,   65688,  8, }, // Atlantic/Canary
    {  286, 1395,     448,  5, }, // Atlantic/Faroe
    {  286, 6821,     453, 10, }, // Atlantic/St_Helena
    {  286, 6336,   65696,  7, }, // Europe/Belgrade
    {  286, 2527,     463,  4, }, // Europe/Kyiv
    {  286, 3213,   65703,  7, }, // Europe/Lisbon
    {  286, 6506,   65710,  7, }, // Europe/Ljubljana
    {  286, 6365,   65717, 10, }, // Europe/Luxembourg
    {  286, 6397,   65341,  5, }, // Europe/Malta
    {  286, 3537,   65727,  6, }, // Europe/Moscow
    {  286, 6275,   65733,  6, }, // Europe/Prague
    {  286, 6470,   65739,  9, }, // Europe/San_Marino
    {  286, 6231,   65748,  5, }, // Europe/Vienna
    {  286, 7211,     467,  7, }, // Indian/Reunion
    {  286, 3157,     474,  5, }, // Pacific/Chuuk
    {  286, 3096,     479,  7, }, // Pacific/Pohnpei
    {  287,   14,       0,  6, }, // Africa/Asmara Fulah/Latin/Senegal
    {  287, 4435,       6,  8, }, // Africa/Sao_Tome
    {  287, 4252,      14,  8, }, // America/Asuncion
    {  287,  237,      22,  8, }, // America/Atikokan
    {  287, 7623,      30, 17, }, // America/Bahia_Banderas
    {  287, 3868,      47,  6, }, // America/Cancun
    {  287, 7774,      53, 13, }, // America/Ciudad_Juarez
    {  287, 5723,      66,  7, }, // America/Curacao
    {  287,  481,      73, 13, }, // America/Indiana/Knox
    {  287, 7961,      86, 16, }, // America/Indiana/Marengo
    {  287, 7985,     102, 19, }, // America/Indiana/Petersburg
    {  287, 8012,     121, 18, }, // America/Indiana/Tell_City
    {  287, 8038,     139, 14, }, // America/Indiana/Vevay
    {  287, 8060,     153, 18, }, // America/Indiana/Vincennes
    {  287, 8086,     171, 16, }, // America/Indiana/Winamac
    {  287, 8125,     187, 20, }, // America/Kentucky/Monticello
    {  287, 5932,     207, 22, }, // America/Lower_Princes
    {  287, 8220,     229,  6, }, // America/Merida
    {  287, 8301,     235, 20, }, // America/North_Dakota/Beulah
    {  287, 8329,     255, 20, }, // America/North_Dakota/Center
    {  287, 8357,     275, 23, }, // America/North_Dakota/New_Salem
    {  287,  393,     298,  4, }, // America/Nuuk
    {  287, 6899,     302, 16, }, // America/Scoresbysund
    {  287, 8508,     318, 14, }, // America/St_Barthelemy
    {  287, 2061,     332, 10, }, // America/St_Johns
    {  287, 5863,     342,  9, }, // America/St_Kitts
    {  287, 5880,     351,  9, }, // America/St_Lucia
    {  287,  855,     360, 10, }, // America/St_Thomas
    {  287, 5913,     370, 11, }, // America/St_Vincent
    {  287, 6133,     381, 16, }, // Antarctica/DumontDUrville
    {  287, 1259,     397, 11, }, // Asia/Ho_Chi_Minh
    {  287, 1185,     413,  9, }, // Asia/Kathmandu
    {  287,  992,     422,  7, }, // Asia/Kolkata
    {  287, 1211,     429,  5, }, // Asia/Macau
    {  287, 1235,     442,  6, }, // Asia/Yangon
    {  287, 1395,     448,  5, }, // Atlantic/Faroe
    {  287, 6821,     453, 10, }, // Atlantic/St_Helena
    {  287, 2527,     463,  4, }, // Europe/Kyiv
    {  287, 7211,     467,  7, }, // Indian/Reunion
    {  287, 3157,     474,  5, }, // Pacific/Chuuk
    {  287, 3096,     479,  7, }, // Pacific/Pohnpei
    {  293, 6788,   65753, 12, }, // Africa/Abidjan Fulah/Adlam/Guinea
    {  293, 6760,   65765, 10, }, // Africa/Accra
    {  293, 5059,   65775, 18, }, // Africa/Addis_Ababa
    {  293, 7420,   65793, 14, }, // Africa/Algiers
    {  293,   14,   65807, 12, }, // Africa/Asmara
    {  293,   44,   65819, 14, }, // Africa/Bamako
    {  293, 5257,   65833, 10, }, // Africa/Bangui
    {  293, 6746,   65843, 12, }, // Africa/Banjul
    {  293, 7435,   65855, 12, }, // Africa/Bissau
    {  293, 4957,   65867, 18, }, // Africa/Blantyre
    {  293, 5287,   65885, 16, }, // Africa/Brazzaville
    {  293, 4922,   65901, 18, }, // Africa/Bujumbura
    {  293, 2320,   65919, 10, }, // Africa/Cairo
    {  293, 4117,   65929, 26, }, // Africa/Casablanca
    {  293, 7449,   65955, 10, }, // Africa/Ceuta
    {  293, 6773,   65965, 18, }, // Africa/Conakry
    {  293, 6840,   65983, 12, }, // Africa/Dakar
    {  293, 5130,   65995, 25, }, // Africa/Dar_es_Salaam
    {  293, 5043,   66020, 14, }, // Africa/Djibouti
    {  293, 5243,   66034, 12, }, // Africa/Douala
    {  293, 5166,   66046, 14, }, // Africa/El_Aaiun
    {  293, 6853,   66060, 12, }, // Africa/Freetown
    {  293, 4906,   66072, 16, }, // Africa/Gaborone
    {  293, 5015,   66088, 12, }, // Africa/Harare
    {  293, 4479,   66100, 22, }, // Africa/Johannesburg
    {  293, 4499,   66122,  8, }, // Africa/Juba
    {  293, 5151,   66130, 14, }, // Africa/Kampala
    {  293, 4524,   66144, 14, }, // Africa/Khartoum
    {  293, 4973,   66158, 12, }, // Africa/Kigali
    {  293, 5306,   66170, 14, }, // Africa/Kinshasa
    {  293, 4744,   66184, 12, }, // Africa/Lagos
    {  293, 5336,   66196, 20, }, // Africa/Libreville
    {  293, 6869,   66216,  8, }, // Africa/Lome
    {  293, 5211,   66224, 16, }, // Africa/Luanda
    {  293, 4939,   66240, 18, }, // Africa/Lubumbashi
    {  293, 5001,   66258, 12, }, // Africa/Lusaka
    {  293, 5322,   66270, 14, }, // Africa/Malabo
    {  293, 4987,   66284, 12, }, // Africa/Maputo
    {  293, 5197,   66296, 12, }, // Africa/Maseru
    {  293, 5182,   66308, 18, }, // Africa/Mbabane
    {  293, 5113,   66326, 16, }, // Africa/Mogadishu
    {  293, 7034,   66342, 16, }, // Africa/Monrovia
    {  293, 3853,   66358, 14, }, // Africa/Nairobi
    {  293, 5271,   66372, 16, }, // Africa/Ndjamena
    {  293, 5354,   66388, 12, }, // Africa/Niamey
    {  293, 6803,   66400, 20, }, // Africa/Nouakchott
    {  293, 6727,   66420, 16, }, // Africa/Ouagadougou
    {  293, 5225,   66436, 21, }, // Africa/Porto-Novo
    {  293, 4435,   66457, 19, }, // Africa/Sao_Tome
    {  293, 2866,   66476, 14, }, // Africa/Tripoli
    {  293, 6554,   66490, 12, }, // Africa/Tunis
    {  293, 4152,   66502, 14, }, // Africa/Windhoek
    {  293,  132,   66516,  8, }, // America/Adak
    {  293, 3346,   66524, 18, }, // America/Anchorage
    {  293, 5607,   66542, 14, }, // America/Anguilla
    {  293, 5624,   66556, 12, }, // America/Antigua
    {  293, 4554,   66568, 18, }, // America/Araguaina
    {  293,  166,   66586, 29, }, // America/Argentina/Buenos_Aires
    {  293,   91,   66615, 20, }, // America/Argentina/Catamarca
    {  293,  270,   66635, 16, }, // America/Argentina/Cordoba
    {  293,  441,   66651, 10, }, // America/Argentina/Jujuy
    {  293, 7462,   66661, 17, }, // America/Argentina/La_Rioja
    {  293,  565,   66678, 16, }, // America/Argentina/Mendoza
    {  293, 7489,   66694, 21, }, // America/Argentina/Rio_Gallegos
    {  293, 7520,   66715, 10, }, // America/Argentina/Salta
    {  293, 7544,   66725, 19, }, // America/Argentina/San_Juan
    {  293, 5580,   66744, 19, }, // America/Argentina/San_Luis
    {  293, 7571,   66763, 16, }, // America/Argentina/Tucuman
    {  293, 7597,   66779, 14, }, // America/Argentina/Ushuaia
    {  293, 5640,   66793, 12, }, // America/Aruba
    {  293, 4252,   66805, 18, }, // America/Asuncion
    {  293,  237,   66823, 18, }, // America/Atikokan
    {  293, 3679,   66841, 12, }, // America/Bahia
    {  293, 7623,   66853, 33, }, // America/Bahia_Banderas
    {  293, 5654,   66886, 18, }, // America/Barbados
    {  293, 7646,   66904, 10, }, // America/Belem
    {  293, 5407,   66914, 12, }, // America/Belize
    {  293, 7660,   66926, 25, }, // America/Blanc-Sablon
    {  293, 7681,   66951, 19, }, // America/Boa_Vista
    {  293, 4361,   66970, 12, }, // America/Bogota
    {  293, 7699,   66982, 12, }, // America/Boise
    {  293, 7713,   66994, 25, }, // America/Cambridge_Bay
    {  293, 7735,   67019, 23, }, // America/Campo_Grande
    {  293, 3868,   67042, 14, }, // America/Cancun
    {  293, 4694,   67056, 14, }, // America/Caracas
    {  293, 4345,   67070, 12, }, // America/Cayenne
    {  293, 5496,   67082, 14, }, // America/Cayman
    {  293, 2260,   67096, 16, }, // America/Chicago
    {  293, 7756,   67112, 16, }, // America/Chihuahua
    {  293, 5422,   67128, 21, }, // America/Costa_Rica
    {  293, 7796,   67149, 14, }, // America/Creston
    {  293, 3791,   67163, 14, }, // America/Cuiaba
    {  293, 5723,   67177, 18, }, // America/Curacao
    {  293, 7812,   67195, 26, }, // America/Danmarkshavn
    {  293, 7833,   67221, 12, }, // America/Dawson
    {  293, 7848,   67233, 21, }, // America/Dawson_Creek
    {  293,  805,   67254, 12, }, // America/Denver
    {  293, 3465,   67266, 14, }, // America/Detroit
    {  293, 5739,   67280, 18, }, // America/Dominica
    {  293,  893,   67298, 16, }, // America/Edmonton
    {  293, 7869,   67314, 14, }, // America/Eirunepe
    {  293, 5441,   67328, 23, }, // America/El_Salvador
    {  293, 7886,   67351, 22, }, // America/Fort_Nelson
    {  293, 7906,   67373, 20, }, // America/Fortaleza
    {  293, 7924,   67393, 15, }, // America/Glace_Bay
    {  293, 6881,   67408, 15, }, // America/Goose_Bay
    {  293, 4612,   67423, 19, }, // America/Grand_Turk
    {  293, 5770,   67442, 16, }, // America/Grenada
    {  293, 5786,   67458, 24, }, // America/Guadeloupe
    {  293, 3760,   67482, 20, }, // America/Guatemala
    {  293, 4841,   67502, 14, }, // America/Guayaquil
    {  293, 6932,   67516, 14, }, // America/Guyana
    {  293, 1939,   67530, 18, }, // America/Halifax
    {  293, 2281,   67548, 14, }, // America/Havana
    {  293, 7942,   67562, 24, }, // America/Hermosillo
    {  293,  348,   67586, 28, }, // America/Indiana/Indianapolis
    {  293,  481,   67614, 28, }, // America/Indiana/Knox
    {  293, 7961,   67642, 34, }, // America/Indiana/Marengo
    {  293, 7985,   67676, 40, }, // America/Indiana/Petersburg
    {  293, 8012,   67716, 37, }, // America/Indiana/Tell_City
    {  293, 8038,   67753, 32, }, // America/Indiana/Vevay
    {  293, 8060,   67785, 34, }, // America/Indiana/Vincennes
    {  293, 8086,   67819, 34, }, // America/Indiana/Winamac
    {  293, 8110,   67853, 12, }, // America/Inuvik
    {  293,  660,   67865, 16, }, // America/Iqaluit
    {  293, 2799,   67881, 16, }, // America/Jamaica
    {  293, 5380,   67897, 12, }, // America/Juneau
    {  293,  521,   67909, 12, }, // America/Kentucky/Louisville
    {  293, 8125,   67921, 40, }, // America/Kentucky/Monticello
    {  293, 5704,   67961, 20, }, // America/Kralendijk
    {  293, 4376,   67981, 13, }, // America/La_Paz
    {  293, 7169,   67994, 10, }, // America/Lima
    {  293, 3239,   68004, 21, }, // America/Los_Angeles
    {  293, 5932,   68025, 36, }, // America/Lower_Princes
    {  293, 8153,   68061, 12, }, // America/Maceio
    {  293, 8168,   68073, 14, }, // America/Managua
    {  293, 1908,   68087, 12, }, // America/Manaus
    {  293, 5897,   68099, 14, }, // America/Marigot
    {  293, 5805,   68113, 16, }, // America/Martinique
    {  293, 8184,   68129, 20, }, // America/Matamoros
    {  293, 2917,   68149, 16, }, // America/Mazatlan
    {  293, 8202,   68165, 16, }, // America/Menominee
    {  293, 8220,   68181, 12, }, // America/Merida
    {  293, 8235,   68193, 20, }, // America/Metlakatla
    {  293, 2949,   68213, 27, }, // America/Mexico_City
    {  293, 4391,   68240, 14, }, // America/Miquelon
    {  293, 8254,   68254, 16, }, // America/Moncton
    {  293, 8270,   68270, 18, }, // America/Monterrey
    {  293, 4098,   68288, 24, }, // America/Montevideo
    {  293, 5824,   68312, 20, }, // America/Montserrat
    {  293, 5481,   68332, 10, }, // America/Nassau
    {  293, 2379,   68342, 15, }, // America/New_York
    {  293, 8288,   68357, 10, }, // America/Nome
    {  293, 1850,   68367, 14, }, // America/Noronha
    {  293, 8301,   68381, 33, }, // America/North_Dakota/Beulah
    {  293, 8329,   68414, 37, }, // America/North_Dakota/Center
    {  293, 8357,   68451, 42, }, // America/North_Dakota/New_Salem
    {  293,  393,   68493,  8, }, // America/Nuuk
    {  293, 8388,   68501, 14, }, // America/Ojinaga
    {  293, 2356,   68515, 16, }, // America/Panama
    {  293, 6173,   68531, 20, }, // America/Paramaribo
    {  293, 2973,   68551, 12, }, // America/Phoenix
    {  293, 3945,   68563, 22, }, // America/Port-au-Prince
    {  293, 5954,   68585, 26, }, // America/Port_of_Spain
    {  293, 8404,   68611, 23, }, // America/Porto_Velho
    {  293, 5843,   68634, 19, }, // America/Puerto_Rico
    {  293, 4030,   68653, 23, }, // America/Punta_Arenas
    {  293, 8424,   68676, 23, }, // America/Rankin_Inlet
    {  293, 8445,   68699, 12, }, // America/Recife
    {  293, 1995,   68711, 14, }, // America/Regina
    {  293, 8460,   68725, 16, }, // America/Resolute
    {  293,  695,   68741, 21, }, // America/Rio_Branco
    {  293, 8477,   68762, 18, }, // America/Santarem
    {  293, 2201,   68780, 20, }, // America/Santiago
    {  293, 6111,   68800, 27, }, // America/Santo_Domingo
    {  293, 1878,   68827, 19, }, // America/Sao_Paulo
    {  293, 6899,   68846, 30, }, // America/Scoresbysund
    {  293, 8494,   68876, 10, }, // America/Sitka
    {  293, 8508,   68886, 27, }, // America/St_Barthelemy
    {  293, 2061,   68913, 19, }, // America/St_Johns
    {  293, 5863,   68932, 21, }, // America/St_Kitts
    {  293, 5880,   68953, 19, }, // America/St_Lucia
    {  293,  855,   68972, 21, }, // America/St_Thomas
    {  293, 5913,   68993, 23, }, // America/St_Vincent
    {  293, 8530,   69016, 23, }, // America/Swift_Current
    {  293, 5461,   69039, 22, }, // America/Tegucigalpa
    {  293, 5756,   69061,  8, }, // America/Thule
    {  293,  313,   69069, 18, }, // America/Tijuana
    {  293,  608,   69087, 16, }, // America/Toronto
    {  293, 5688,   69103, 16, }, // America/Tortola
    {  293, 2093,   69119, 16, }, // America/Vancouver
    {  293, 2144,   69135, 18, }, // America/Whitehorse
    {  293,  734,   69153, 16, }, // America/Winnipeg
    {  293, 8552,   69169, 14, }, // America/Yakutat
    {  293, 6001,   69183, 10, }, // Antarctica/Casey
    {  293, 6094,   69193, 12, }, // Antarctica/Davis
    {  293, 6133,   69205, 27, }, // Antarctica/DumontDUrville
    {  293, 8568,   69232, 14, }, // Antarctica/Macquarie
    {  293, 7066,   69246, 12, }, // Antarctica/Mawson
    {  293, 7113,   69258, 18, }, // Antarctica/McMurdo
    {  293, 8589,   69276, 14, }, // Antarctica/Palmer
    {  293, 7226,   69290, 12, }, // Antarctica/Rothera
    {  293, 7295,   69302, 14, }, // Antarctica/Syowa
    {  293, 8607,   69316, 12, }, // Antarctica/Troll
    {  293, 7374,   69328, 12, }, // Antarctica/Vostok
    {  293, 1429,   69340, 24, }, // Arctic/Longyearbyen
    {  293, 5570,   69364,  8, }, // Asia/Aden
    {  293, 5395,   69372, 14, }, // Asia/Almaty
    {  293, 3968,   69386, 12, }, // Asia/Amman
    {  293, 5511,   69398, 14, }, // Asia/Anadyr
    {  293, 5523,   69412, 14, }, // Asia/Aqtau
    {  293, 5368,   69426, 14, }, // Asia/Aqtobe
    {  293,  964,   69440, 16, }, // Asia/Ashgabat
    {  293, 8624,   69456, 14, }, // Asia/Atyrau
    {  293, 3607,   69470, 16, }, // Asia/Baghdad
    {  293, 5534,   69486, 16, }, // Asia/Bahrain
    {  293, 3653,   69502, 10, }, // Asia/Baku
    {  293, 4466,   69512, 16, }, // Asia/Bangkok
    {  293, 3571,   69528, 16, }, // Asia/Barnaul
    {  293, 4086,   69544, 16, }, // Asia/Beirut
    {  293, 3778,   69560, 16, }, // Asia/Bishkek
    {  293, 5989,   69576, 12, }, // Asia/Brunei
    {  293, 4601,   69588, 10, }, // Asia/Chita
    {  293, 4511,   69598, 14, }, // Asia/Colombo
    {  293, 4540,   69612, 14, }, // Asia/Damascus
    {  293, 1093,   65983, 10, }, // Asia/Dhaka
    {  293, 6192,   69626, 10, }, // Asia/Dili
    {  293, 3596,   69636, 10, }, // Asia/Dubai
    {  293, 6159,   69646, 14, }, // Asia/Dushanbe
    {  293, 8636,   69660, 18, }, // Asia/Famagusta
    {  293, 8651,   69678, 10, }, // Asia/Gaza
    {  293, 4795,   69688, 14, }, // Asia/Hebron
    {  293, 1259,   69702, 31, }, // Asia/Ho_Chi_Minh
    {  293, 2704,   69733, 17, }, // Asia/Hong_Kong
    {  293, 4771,   69750, 10, }, // Asia/Hovd
    {  293, 4184,   69760, 18, }, // Asia/Irkutsk
    {  293, 7006,   69778, 16, }, // Asia/Jakarta
    {  293, 6992,   69794, 16, }, // Asia/Jayapura
    {  293, 1290,   69810, 12, }, // Asia/Jerusalem
    {  293, 3560,   69822, 10, }, // Asia/Kabul
    {  293, 4316,   69832, 18, }, // Asia/Kamchatka
    {  293, 4239,   69850, 14, }, // Asia/Karachi
    {  293, 1185,   69864, 18, }, // Asia/Kathmandu
    {  293, 8661,   69882, 14, }, // Asia/Khandyga
    {  293,  992,   69896, 14, }, // Asia/Kolkata
    {  293, 4197,   69910, 28, }, // Asia/Krasnoyarsk
    {  293, 4859,   69938, 27, }, // Asia/Kuala_Lumpur
    {  293, 5976,   69965, 10, }, // Asia/Kuching
    {  293, 5547,   69975, 14, }, // Asia/Kuwait
    {  293, 1211,   69989, 12, }, // Asia/Macau
    {  293, 4017,   70001, 14, }, // Asia/Magadan
    {  293, 1349,   70015, 16, }, // Asia/Makassar
    {  293, 7182,   70031, 12, }, // Asia/Manila
    {  293, 6920,   70043, 14, }, // Asia/Muscat
    {  293, 2554,   70057, 16, }, // Asia/Nicosia
    {  293, 8675,   70073, 28, }, // Asia/Novokuznetsk
    {  293, 4135,   70101, 24, }, // Asia/Novosibirsk
    {  293, 4229,   70125, 12, }, // Asia/Omsk
    {  293, 7145,   70137,  8, }, // Asia/Oral
    {  293, 6961,   70145, 17, }, // Asia/Phnom_Penh
    {  293, 8693,   70162, 20, }, // Asia/Pontianak
    {  293, 4214,   70182, 16, }, // Asia/Pyongyang
    {  293, 5559,   70198, 10, }, // Asia/Qatar
    {  293, 8708,   70208, 16, }, // Asia/Qostanay
    {  293, 4269,   70224, 18, }, // Asia/Qyzylorda
    {  293, 3584,   70242, 12, }, // Asia/Riyadh
    {  293, 4408,   70254, 16, }, // Asia/Sakhalin
    {  293, 7245,   70270, 20, }, // Asia/Samarkand
    {  293, 3279,   70290, 10, }, // Asia/Seoul
    {  293, 1053,   70300, 12, }, // Asia/Shanghai
    {  293, 3300,   70312, 18, }, // Asia/Singapore
    {  293, 4297,   70330, 24, }, // Asia/Srednekolymsk
    {  293, 3263,   70354, 12, }, // Asia/Taipei
    {  293, 4781,   70366, 16, }, // Asia/Tashkent
    {  293, 3915,   70382, 18, }, // Asia/Tbilisi
    {  293, 2772,   70400, 16, }, // Asia/Tehran
    {  293, 1317,   70416, 10, }, // Asia/Thimphu
    {  293, 2821,   70426, 12, }, // Asia/Tokyo
    {  293, 4572,   70438, 14, }, // Asia/Tomsk
    {  293, 1021,   70452, 18, }, // Asia/Ulaanbaatar
    {  293, 1159,   70470, 12, }, // Asia/Urumqi
    {  293, 8722,   70482, 17, }, // Asia/Ust-Nera
    {  293, 6977,   70499, 18, }, // Asia/Vientiane
    {  293, 4710,   70517, 28, }, // Asia/Vladivostok
    {  293, 4828,   70545, 18, }, // Asia/Yakutsk
    {  293, 1235,   70563, 14, }, // Asia/Yangon
    {  293, 3883,   70577, 28, }, // Asia/Yekaterinburg
    {  293, 3747,   70605, 16, }, // Asia/Yerevan
    {  293, 3663,   70621, 14, }, // Atlantic/Azores
    {  293, 5671,   70635, 16, }, // Atlantic/Bermuda
    {  293, 6628,   70651, 12, }, // Atlantic/Canary
    {  293, 3727,   70663, 21, }, // Atlantic/Cape_Verde
    {  293, 1395,   70684, 10, }, // Atlantic/Faroe
    {  293, 8736,   70694, 14, }, // Atlantic/Madeira
    {  293, 2748,   70708, 18, }, // Atlantic/Reykjavik
    {  293, 7272,   70726, 25, }, // Atlantic/South_Georgia
    {  293, 6821,   70751, 23, }, // Atlantic/St_Helena
    {  293, 6644,   70774, 16, }, // Atlantic/Stanley
    {  293, 1670,   70790, 16, }, // Australia/Adelaide
    {  293, 1635,   70806, 20, }, // Australia/Brisbane
    {  293, 1799,   70826, 21, }, // Australia/Broken_Hill
    {  293, 1583,   70847, 14, }, // Australia/Darwin
    {  293, 3637,   70861, 12, }, // Australia/Eucla
    {  293, 1516,   70873, 16, }, // Australia/Hobart
    {  293, 8753,   70889, 20, }, // Australia/Lindeman
    {  293, 1547,   70909, 19, }, // Australia/Lord_Howe
    {  293, 1727,   70928, 18, }, // Australia/Melbourne
    {  293, 1762,   70946, 10, }, // Australia/Perth
    {  293, 1463,   70956, 12, }, // Australia/Sydney
    {  293, 6441,   70968, 22, }, // Europe/Amsterdam
    {  293, 6216,   70990, 14, }, // Europe/Andorra
    {  293, 3620,   71004, 18, }, // Europe/Astrakhan
    {  293, 2300,   71022, 12, }, // Europe/Athens
    {  293, 6336,   71034, 18, }, // Europe/Belgrade
    {  293, 4757,   71052, 12, }, // Europe/Berlin
    {  293, 6488,   71064, 22, }, // Europe/Bratislava
    {  293, 2167,   71086, 16, }, // Europe/Brussels
    {  293, 3928,   71102, 18, }, // Europe/Bucharest
    {  293, 3806,   71120, 16, }, // Europe/Budapest
    {  293, 8772,   71136, 16, }, // Europe/Busingen
    {  293, 2583,   71152, 18, }, // Europe/Chisinau
    {  293, 6289,   71170, 18, }, // Europe/Copenhagen
    {  293, 2338,   71188, 14, }, // Europe/Dublin
    {  293, 6307,   71202, 20, }, // Europe/Gibraltar
    {  293, 8788,   71222, 16, }, // Europe/Guernsey
    {  293, 6612,   71238, 16, }, // Europe/Helsinki
    {  293, 8804,   71254, 23, }, // Europe/Isle_of_Man
    {  293, 1130,   71277, 16, }, // Europe/Istanbul
    {  293, 8823,   71293, 12, }, // Europe/Jersey
    {  293, 3979,   71305, 18, }, // Europe/Kaliningrad
    {  293, 8929,   71323, 14, }, // Europe/Kirov
    {  293, 2527,   71337, 12, }, // Europe/Kyiv
    {  293, 3213,   71349, 14, }, // Europe/Lisbon
    {  293, 6506,   71363, 20, }, // Europe/Ljubljana
    {  293, 2501,   71383, 12, }, // Europe/London
    {  293, 6365,   71395, 22, }, // Europe/Luxembourg
    {  293, 4892,   71417, 14, }, // Europe/Madrid
    {  293, 6397,   71431, 10, }, // Europe/Malta
    {  293, 6582,   71441, 26, }, // Europe/Mariehamn
    {  293, 3693,   71467, 14, }, // Europe/Minsk
    {  293, 6410,   71481, 14, }, // Europe/Monaco
    {  293, 3537,   71495, 10, }, // Europe/Moscow
    {  293, 6458,   71505, 10, }, // Europe/Oslo
    {  293, 4284,   71515,  8, }, // Europe/Paris
    {  293, 6424,   71523, 20, }, // Europe/Podgorica
    {  293, 6275,   71543, 14, }, // Europe/Prague
    {  293, 8837,   71557,  8, }, // Europe/Riga
    {  293, 6324,   71565, 10, }, // Europe/Rome
    {  293, 4331,   71575, 12, }, // Europe/Samara
    {  293, 6470,   71587, 19, }, // Europe/San_Marino
    {  293, 6245,   71606, 18, }, // Europe/Sarajevo
    {  293, 4451,   71624, 16, }, // Europe/Saratov
    {  293, 8849,   71640, 20, }, // Europe/Simferopol
    {  293, 6383,   71660, 18, }, // Europe/Skopje
    {  293, 6599,   71678, 12, }, // Europe/Sofia
    {  293, 6523,   71690, 18, }, // Europe/Stockholm
    {  293, 8867,   71708, 14, }, // Europe/Tallinn
    {  293, 6202,   71722, 12, }, // Europe/Tirane
    {  293, 8882,   71734, 22, }, // Europe/Ulyanovsk
    {  293, 6352,   71756, 14, }, // Europe/Vaduz
    {  293, 6567,   71770, 14, }, // Europe/Vatican
    {  293, 6231,   71784, 14, }, // Europe/Vienna
    {  293, 8899,   71798, 14, }, // Europe/Vilnius
    {  293, 4727,   71812, 20, }, // Europe/Volgograd
    {  293, 3190,   71832, 10, }, // Europe/Warsaw
    {  293, 6261,   71842, 14, }, // Europe/Zagreb
    {  293, 6540,   71856, 10, }, // Europe/Zurich
    {  293, 5078,   71866, 28, }, // Indian/Antananarivo
    {  293, 6947,   71894, 10, }, // Indian/Chagos
    {  293, 6046,   71904, 18, }, // Indian/Christmas
    {  293, 6063,   71922, 12, }, // Indian/Cocos
    {  293, 5029,   71934, 14, }, // Indian/Comoro
    {  293, 6661,   71948, 16, }, // Indian/Kerguelen
    {  293, 7260,   71964, 10, }, // Indian/Mahe
    {  293, 7050,   71974, 18, }, // Indian/Maldives
    {  293, 4069,   71992, 14, }, // Indian/Mauritius
    {  293, 5098,   72006, 14, }, // Indian/Mayotte
    {  293, 7211,   72020, 16, }, // Indian/Reunion
    {  293, 4422,   72036, 12, }, // Pacific/Apia
    {  293,  932,   72048, 14, }, // Pacific/Auckland
    {  293, 3706,   72062, 18, }, // Pacific/Bougainville
    {  293, 3015,   72080, 12, }, // Pacific/Chatham
    {  293, 3157,   72092, 10, }, // Pacific/Chuuk
    {  293, 2237,   72102, 10, }, // Pacific/Easter
    {  293, 7360,   72112, 10, }, // Pacific/Efate
    {  293, 7327,   72122, 14, }, // Pacific/Fakaofo
    {  293, 3902,   72136, 10, }, // Pacific/Fiji
    {  293, 7343,   72146, 18, }, // Pacific/Funafuti
    {  293, 6678,   72164, 18, }, // Pacific/Galapagos
    {  293, 6696,   72182, 16, }, // Pacific/Gambier
    {  293, 3822,   72198, 24, }, // Pacific/Guadalcanal
    {  293, 6018,   72222, 12, }, // Pacific/Guam
    {  293, 3049,   72234, 20, }, // Pacific/Kanton
    {  293, 3998,   72254, 20, }, // Pacific/Kiritimati
    {  293, 7019,   72274, 12, }, // Pacific/Kosrae
    {  293, 2842,   72286, 20, }, // Pacific/Kwajalein
    {  293, 4877,   72306, 14, }, // Pacific/Majuro
    {  293, 4051,   72320, 18, }, // Pacific/Marquesas
    {  293, 8914,   72338, 12, }, // Pacific/Midway
    {  293, 7084,   72350, 10, }, // Pacific/Nauru
    {  293, 7132,   72360, 10, }, // Pacific/Niue
    {  293, 4168,   72370, 16, }, // Pacific/Norfolk
    {  293, 7098,   72386, 12, }, // Pacific/Noumea
    {  293, 3126,   72398, 17, }, // Pacific/Pago_Pago
    {  293, 7155,   72415, 10, }, // Pacific/Palau
    {  293, 7194,   72425, 18, }, // Pacific/Pitcairn
    {  293, 3096,   72443, 12, }, // Pacific/Pohnpei
    {  293, 4807,   72455, 25, }, // Pacific/Port_Moresby
    {  293, 6076,   72480, 18, }, // Pacific/Rarotonga
    {  293, 6031,   72498, 14, }, // Pacific/Saipan
    {  293, 7312,   72512, 14, }, // Pacific/Tahiti
    {  293, 6712,   72526, 14, }, // Pacific/Tarawa
    {  293, 4583,   72540, 20, }, // Pacific/Tongatapu
    {  293, 7392,   72560, 10, }, // Pacific/Wake
    {  293, 7405,   72570, 14, }, // Pacific/Wallis
    {  311, 5059,   72584, 11, }, // Africa/Addis_Ababa Gaelic/Latin/United Kingdom
    {  311,   14,   72595,  6, }, // Africa/Asmara
    {  311, 5130,   72601, 12, }, // Africa/Dar_es_Salaam
    {  311, 5043,   72613, 10, }, // Africa/Djibouti
    {  311, 5166,   63378,  8, }, // Africa/El_Aaiun
    {  311, 4479,   72623, 11, }, // Africa/Johannesburg
    {  311, 6869,   20300,  4, }, // Africa/Lome
    {  311, 5271,   72634,  9, }, // Africa/Ndjamena
    {  311, 4435,       6,  8, }, // Africa/Sao_Tome
    {  311, 5607,   72643,  9, }, // America/Anguilla
    {  311, 5624,   72652,  8, }, // America/Antigua
    {  311, 4554,   26427,  9, }, // America/Araguaina
    {  311,  270,   20361,  7, }, // America/Argentina/Cordoba
    {  311, 7489,   44005, 12, }, // America/Argentina/Rio_Gallegos
    {  311, 7571,   20368,  7, }, // America/Argentina/Tucuman
    {  311, 5640,   72660,  5, }, // America/Aruba
    {  311, 4252,      14,  8, }, // America/Asuncion
    {  311,  237,      22,  8, }, // America/Atikokan
    {  311, 7623,      30, 17, }, // America/Bahia_Banderas
    {  311, 7646,   35764,  5, }, // America/Belem
    {  311, 5407,   72665, 10, }, // America/Belize
    {  311, 4361,   20389,  6, }, // America/Bogota
    {  311, 3868,      47,  6, }, // America/Cancun
    {  311, 5496,   72675,  7, }, // America/Cayman
    {  311, 7774,      53, 13, }, // America/Ciudad_Juarez
    {  311, 5422,   72682, 11, }, // America/Costa_Rica
    {  311, 3791,   26442,  6, }, // America/Cuiaba
    {  311, 5723,      66,  7, }, // America/Curacao
    {  311, 5739,   72693, 10, }, // America/Dominica
    {  311, 7869,   26448,  8, }, // America/Eirunepe
    {  311, 5441,   72703, 12, }, // America/El_Salvador
    {  311, 7924,   72715,  9, }, // America/Glace_Bay
    {  311, 4612,   72724, 12, }, // America/Grand_Turk
    {  311, 5770,   72736,  8, }, // America/Grenada
    {  311, 5786,   20408,  8, }, // America/Guadeloupe
    {  311, 3760,   72744,  9, }, // America/Guatemala
    {  311, 6932,   72753,  9, }, // America/Guyana
    {  311,  481,      73, 13, }, // America/Indiana/Knox
    {  311, 7961,      86, 16, }, // America/Indiana/Marengo
    {  311, 7985,     102, 19, }, // America/Indiana/Petersburg
    {  311, 8012,     121, 18, }, // America/Indiana/Tell_City
    {  311, 8038,     139, 14, }, // America/Indiana/Vevay
    {  311, 8060,     153, 18, }, // America/Indiana/Vincennes
    {  311, 8086,     171, 16, }, // America/Indiana/Winamac
    {  311, 8110,   72762,  7, }, // America/Inuvik
    {  311, 2799,   72769,  8, }, // America/Jamaica
    {  311, 8125,     187, 20, }, // America/Kentucky/Monticello
    {  311, 5932,     207, 22, }, // America/Lower_Princes
    {  311, 8153,   26456,  6, }, // America/Maceio
    {  311, 5805,   72777,  9, }, // America/Martinique
    {  311, 2917,   26471,  8, }, // America/Mazatlan
    {  311, 8220,     229,  6, }, // America/Merida
    {  311, 2949,   72786, 17, }, // America/Mexico_City
    {  311, 5824,   72803,  9, }, // America/Montserrat
    {  311, 2379,   72812, 13, }, // America/New_York
    {  311, 8301,     235, 20, }, // America/North_Dakota/Beulah
    {  311, 8329,     255, 20, }, // America/North_Dakota/Center
    {  311, 8357,     275, 23, }, // America/North_Dakota/New_Salem
    {  311,  393,     298,  4, }, // America/Nuuk
    {  311, 5954,   72825, 15, }, // America/Port_of_Spain
    {  311, 5843,   72840, 11, }, // America/Puerto_Rico
    {  311, 8424,   72851, 11, }, // America/Rankin_Inlet
    {  311, 8460,   72862, 10, }, // America/Resolute
    {  311, 8477,   26572,  8, }, // America/Santarem
    {  311, 1878,   26580,  9, }, // America/Sao_Paulo
    {  311, 6899,     302, 16, }, // America/Scoresbysund
    {  311, 8508,   35804, 16, }, // America/St_Barthelemy
    {  311, 2061,     332, 10, }, // America/St_Johns
    {  311, 5863,   72872, 14, }, // America/St_Kitts
    {  311, 5880,   72886, 12, }, // America/St_Lucia
    {  311,  855,     360, 10, }, // America/St_Thomas
    {  311, 5913,   72898, 15, }, // America/St_Vincent
    {  311, 5756,   26664,  7, }, // America/Thule
    {  311, 6133,     381, 16, }, // Antarctica/DumontDUrville
    {  311, 8568,   72913, 17, }, // Antarctica/Macquarie
    {  311, 3968,   72930,  5, }, // Asia/Amman
    {  311, 5368,   57073,  6, }, // Asia/Aqtobe
    {  311,  964,   44190,  7, }, // Asia/Ashgabat
    {  311, 3607,   72935,  7, }, // Asia/Baghdad
    {  311, 5534,   72942,  8, }, // Asia/Bahrain
    {  311, 3778,   33323,  6, }, // Asia/Bishkek
    {  311, 5989,   72950,  8, }, // Asia/Brunei
    {  311, 6159,   33336,  7, }, // Asia/Dushanbe
    {  311, 8651,   72958,  4, }, // Asia/Gaza
    {  311, 1259,   72962, 19, }, // Asia/Ho_Chi_Minh
    {  311, 4771,   26703,  5, }, // Asia/Hovd
    {  311, 1290,   72981,  9, }, // Asia/Jerusalem
    {  311, 4239,   72990,  6, }, // Asia/Karachi
    {  311, 1185,     413,  9, }, // Asia/Kathmandu
    {  311,  992,     422,  7, }, // Asia/Kolkata
    {  311, 5547,   72996,  8, }, // Asia/Kuwait
    {  311, 1211,   73004,  7, }, // Asia/Macau
    {  311, 4214,   73011, 10, }, // Asia/Pyongyang
    {  311, 5559,   73021,  5, }, // Asia/Qatar
    {  311, 8708,   73026,  8, }, // Asia/Qostanay
    {  311, 4269,   22401,  9, }, // Asia/Qyzylorda
    {  311, 3300,   73034,  9, }, // Asia/Singapore
    {  311, 4781,   73043,  7, }, // Asia/Tashkent
    {  311, 3915,   73050,  8, }, // Asia/Tbilisi
    {  311, 2772,   73058,  6, }, // Asia/Tehran
    {  311, 2821,   63592,  5, }, // Asia/Tokyo
    {  311, 1159,   26801,  6, }, // Asia/Urumqi
    {  311, 6977,   73064, 10, }, // Asia/Vientiane
    {  311, 1235,    7762,  6, }, // Asia/Yangon
    {  311, 3663,   73074, 13, }, // Atlantic/Azores
    {  311, 5671,   73087,  8, }, // Atlantic/Bermuda
    {  311, 6628,   73095, 22, }, // Atlantic/Canary
    {  311, 3727,   73117, 13, }, // Atlantic/Cape_Verde
    {  311, 1395,   73130,  4, }, // Atlantic/Faroe
    {  311, 2748,   36044,  9, }, // Atlantic/Reykjavik
    {  311, 7272,   73134, 14, }, // Atlantic/South_Georgia
    {  311, 6821,   73148, 19, }, // Atlantic/St_Helena
    {  311, 1463,    5774,  5, }, // Australia/Sydney
    {  311, 2300,   73167,  9, }, // Europe/Athens
    {  311, 2167,   73176, 12, }, // Europe/Brussels
    {  311, 2583,   63672,  8, }, // Europe/Chisinau
    {  311, 6289,   73188,  6, }, // Europe/Copenhagen
    {  311, 2338,   73194, 17, }, // Europe/Dublin
    {  311, 6307,   73211, 10, }, // Europe/Gibraltar
    {  311, 8788,   73221, 10, }, // Europe/Guernsey
    {  311, 8804,   73231, 15, }, // Europe/Isle_of_Man
    {  311, 8823,   73246,  9, }, // Europe/Jersey
    {  311, 2527,    8030,  4, }, // Europe/Kyiv
    {  311, 2501,   73255, 20, }, // Europe/London
    {  311, 6365,   73275, 10, }, // Europe/Luxembourg
    {  311, 3537,   73285,  5, }, // Europe/Moscow
    {  311, 4284,   73290,  5, }, // Europe/Paris
    {  311, 6275,   73295,  4, }, // Europe/Prague
    {  311, 8837,   73299,  4, }, // Europe/Riga
    {  311, 6324,   73303,  8, }, // Europe/Rome
    {  311, 6599,   22787,  6, }, // Europe/Sofia
    {  311, 6202,    8137,  6, }, // Europe/Tirane
    {  311, 6567,   73311, 11, }, // Europe/Vatican
    {  311, 6540,    4459,  6, }, // Europe/Zurich
    {  311, 6046,   73322,  7, }, // Indian/Christmas
    {  311, 6661,   36170,  9, }, // Indian/Kerguelen
    {  311, 7260,   26983,  4, }, // Indian/Mahe
    {  311, 7050,   73329, 24, }, // Indian/Maldives
    {  311, 4069,   73353, 24, }, // Indian/Mauritius
    {  311, 7211,     467,  7, }, // Indian/Reunion
    {  311, 3157,     474,  5, }, // Pacific/Chuuk
    {  311, 2237,   73377,  8, }, // Pacific/Easter
    {  311, 3902,   73385,  4, }, // Pacific/Fiji
    {  311, 6678,   21159,  9, }, // Pacific/Galapagos
    {  311, 6696,   73389,  9, }, // Pacific/Gambier
    {  311, 2723,    4493,  8, }, // Pacific/Honolulu
    {  311, 3049,    4501,  9, }, // Pacific/Kanton
    {  311, 4051,   73398, 20, }, // Pacific/Marquesas
    {  311, 7084,   73418,  6, }, // Pacific/Nauru
    {  311, 7155,   73424,  6, }, // Pacific/Palau
    {  311, 7194,   73430, 14, }, // Pacific/Pitcairn
    {  311, 3096,     479,  7, }, // Pacific/Pohnpei
    {  311, 7405,   73444,  6, }, // Pacific/Wallis
    {  312, 6760,    4707,  2, }, // Africa/Accra Ga/Latin/Ghana
    {  312,   14,       0,  6, }, // Africa/Asmara
    {  312, 2320,    4572,  5, }, // Africa/Cairo
    {  312, 4117,    4577, 10, }, // Africa/Casablanca
    {  312, 6773,   26353,  7, }, // Africa/Conakry
    {  312, 6803,   73450, 10, }, // Africa/Nouakchott
    {  312, 4435,       6,  8, }, // Africa/Sao_Tome
    {  312, 3346,   73460,  8, }, // America/Anchorage
    {  312, 4252,      14,  8, }, // America/Asuncion
    {  312,  237,      22,  8, }, // America/Atikokan
    {  312, 7623,      30, 17, }, // America/Bahia_Banderas
    {  312, 7660,    6502, 12, }, // America/Blanc-Sablon
    {  312, 7713,   73468, 25, }, // America/Cambridge_Bay
    {  312, 3868,    6564,  6, }, // America/Cancun
    {  312, 5496,   21483,  6, }, // America/Cayman
    {  312, 2260,   73493,  7, }, // America/Chicago
    {  312, 7756,   73500,  9, }, // America/Chihuahua
    {  312, 7774,      53, 13, }, // America/Ciudad_Juarez
    {  312, 5422,   21503, 10, }, // America/Costa_Rica
    {  312, 7796,    6618,  7, }, // America/Creston
    {  312, 5723,    6631,  7, }, // America/Curacao
    {  312, 7848,   73509, 21, }, // America/Dawson_Creek
    {  312, 5739,   21548,  8, }, // America/Dominica
    {  312, 7886,   73530, 10, }, // America/Fort_Nelson
    {  312, 7924,   73540, 21, }, // America/Glace_Bay
    {  312, 6881,   73561, 21, }, // America/Goose_Bay
    {  312, 4612,   73582, 10, }, // America/Grand_Turk
    {  312, 1939,   73592,  7, }, // America/Halifax
    {  312,  481,   73599, 13, }, // America/Indiana/Knox
    {  312, 7961,      86, 16, }, // America/Indiana/Marengo
    {  312, 7985,     102, 19, }, // America/Indiana/Petersburg
    {  312, 8012,   73612, 19, }, // America/Indiana/Tell_City
    {  312, 8038,     139, 14, }, // America/Indiana/Vevay
    {  312, 8060,   73631, 18, }, // America/Indiana/Vincennes
    {  312, 8086,    5043, 16, }, // America/Indiana/Winamac
    {  312,  660,    5059,  7, }, // America/Iqaluit
    {  312, 2799,    3877,  7, }, // America/Jamaica
    {  312, 8125,   73649, 19, }, // America/Kentucky/Monticello
    {  312, 5932,   73668, 26, }, // America/Lower_Princes
    {  312, 5805,    5142,  8, }, // America/Martinique
    {  312, 8220,     229,  6, }, // America/Merida
    {  312, 2949,   73694, 10, }, // America/Mexico_City
    {  312, 4391,    7031,  7, }, // America/Miquelon
    {  312, 8254,    7038,  7, }, // America/Moncton
    {  312, 8301,     235, 20, }, // America/North_Dakota/Beulah
    {  312, 8329,   73704, 23, }, // America/North_Dakota/Center
    {  312, 8357,   73727, 26, }, // America/North_Dakota/New_Salem
    {  312,  393,     298,  4, }, // America/Nuuk
    {  312, 3945,   73753, 21, }, // America/Port-au-Prince
    {  312, 5954,   73774, 18, }, // America/Port_of_Spain
    {  312, 5843,   21940, 11, }, // America/Puerto_Rico
    {  312, 8424,   73792, 15, }, // America/Rankin_Inlet
    {  312, 6899,   73807, 15, }, // America/Scoresbysund
    {  312, 8508,     318, 14, }, // America/St_Barthelemy
    {  312, 2061,     332, 10, }, // America/St_Johns
    {  312, 5863,     342,  9, }, // America/St_Kitts
    {  312, 5880,   73822,  9, }, // America/St_Lucia
    {  312,  855,     360, 10, }, // America/St_Thomas
    {  312, 5913,   73831, 11, }, // America/St_Vincent
    {  312, 8530,   73842, 12, }, // America/Swift_Current
    {  312, 5461,    5410, 11, }, // America/Tegucigalpa
    {  312, 2093,   73854,  9, }, // America/Vancouver
    {  312, 2144,   73863, 10, }, // America/Whitehorse
    {  312, 6001,   73873,  5, }, // Antarctica/Casey
    {  312, 6133,     381, 16, }, // Antarctica/DumontDUrville
    {  312, 8568,   73878,  8, }, // Antarctica/Macquarie
    {  312, 7113,   73886,  8, }, // Antarctica/McMurdo
    {  312, 5523,    5491,  5, }, // Asia/Aqtau
    {  312, 5368,    7488,  6, }, // Asia/Aqtobe
    {  312, 4511,    5519,  7, }, // Asia/Colombo
    {  312, 4540,   26689,  7, }, // Asia/Damascus
    {  312, 1259,   73894, 20, }, // Asia/Ho_Chi_Minh
    {  312, 1290,    5568,  9, }, // Asia/Jerusalem
    {  312, 4239,   73914,  7, }, // Asia/Karachi
    {  312, 1185,     413,  9, }, // Asia/Kathmandu
    {  312,  992,     422,  7, }, // Asia/Kolkata
    {  312, 5976,   73921,  7, }, // Asia/Kuching
    {  312, 1211,    7613,  5, }, // Asia/Macau
    {  312, 6920,    4208,  6, }, // Asia/Muscat
    {  312, 2554,    5620,  7, }, // Asia/Nicosia
    {  312, 5559,    4214,  4, }, // Asia/Qatar
    {  312, 8708,     434,  8, }, // Asia/Qostanay
    {  312, 4269,   26765,  9, }, // Asia/Qyzylorda
    {  312, 1159,   73928,  6, }, // Asia/Urumqi
    {  312, 1235,     442,  6, }, // Asia/Yangon
    {  312, 3727,   22522, 10, }, // Atlantic/Cape_Verde
    {  312, 1395,     448,  5, }, // Atlantic/Faroe
    {  312, 6821,     453, 10, }, // Atlantic/St_Helena
    {  312, 1799,   73934, 15, }, // Australia/Broken_Hill
    {  312, 3637,   22590,  5, }, // Australia/Eucla
    {  312, 1547,   73949, 11, }, // Australia/Lord_Howe
    {  312, 2527,     463,  4, }, // Europe/Kyiv
    {  312, 6947,   73960,  6, }, // Indian/Chagos
    {  312, 6046,   73966,  7, }, // Indian/Christmas
    {  312, 6063,    4465,  5, }, // Indian/Cocos
    {  312, 5029,   22853,  6, }, // Indian/Comoro
    {  312, 7211,     467,  7, }, // Indian/Reunion
    {  312,  932,   73973,  6, }, // Pacific/Auckland
    {  312, 3015,   73979,  7, }, // Pacific/Chatham
    {  312, 3157,   73986,  5, }, // Pacific/Chuuk
    {  312, 3822,    8242, 11, }, // Pacific/Guadalcanal
    {  312, 4051,   73991,  9, }, // Pacific/Marquesas
    {  312, 7194,    6133,  8, }, // Pacific/Pitcairn
    {  312, 3096,     479,  7, }, // Pacific/Pohnpei
    {  313, 6760,   74000,  4, }, // Africa/Accra Galician/Latin/Spain
    {  313, 5059,   20252, 10, }, // Africa/Addis_Ababa
    {  313, 7420,   74004,  5, }, // Africa/Algiers
    {  313,   14,       0,  6, }, // Africa/Asmara
    {  313,   44,   74009,  6, }, // Africa/Bamako
    {  313, 2320,   74015,  7, }, // Africa/Cairo
    {  313, 5043,   26360,  7, }, // Africa/Djibouti
    {  313, 5166,   74022,  6, }, // Africa/El_Aaiun
    {  313, 4479,   74028, 12, }, // Africa/Johannesburg
    {  313, 4524,   74040,  7, }, // Africa/Khartoum
    {  313, 6869,   20300,  4, }, // Africa/Lome
    {  313, 5001,   74047,  6, }, // Africa/Lusaka
    {  313, 5113,   74053,  8, }, // Africa/Mogadishu
    {  313, 5271,   43996,  9, }, // Africa/Ndjamena
    {  313, 6727,   26402,  8, }, // Africa/Ouagadougou
    {  313, 4435,   74061,  8, }, // Africa/Sao_Tome
    {  313, 2866,   20349,  7, }, // Africa/Tripoli
    {  313, 6554,   74069,  5, }, // Africa/Tunis
    {  313, 5607,    4657,  7, }, // America/Anguilla
    {  313, 4554,   26427,  9, }, // America/Araguaina
    {  313,  270,   20361,  7, }, // America/Argentina/Cordoba
    {  313, 7489,   44005, 12, }, // America/Argentina/Rio_Gallegos
    {  313, 7571,   20368,  7, }, // America/Argentina/Tucuman
    {  313, 4252,      14,  8, }, // America/Asuncion
    {  313,  237,      22,  8, }, // America/Atikokan
    {  313, 3679,   74074,  4, }, // America/Bahia
    {  313, 7623,      30, 17, }, // America/Bahia_Banderas
    {  313, 7646,   35764,  5, }, // America/Belem
    {  313, 4361,   20389,  6, }, // America/Bogota
    {  313, 3868,      47,  6, }, // America/Cancun
    {  313, 4345,   44035,  6, }, // America/Cayenne
    {  313, 5496,   74078, 12, }, // America/Cayman
    {  313, 7774,      53, 13, }, // America/Ciudad_Juarez
    {  313, 3791,   26442,  6, }, // America/Cuiaba
    {  313, 5723,      66,  7, }, // America/Curacao
    {  313, 7869,   26448,  8, }, // America/Eirunepe
    {  313, 5441,   74090, 10, }, // America/El_Salvador
    {  313, 5770,   20401,  7, }, // America/Grenada
    {  313, 5786,   20408,  9, }, // America/Guadeloupe
    {  313, 6932,   74100,  6, }, // America/Guyana
    {  313, 2281,   74106,  8, }, // America/Havana
    {  313,  348,   74114, 12, }, // America/Indiana/Indianapolis
    {  313,  481,      73, 13, }, // America/Indiana/Knox
    {  313, 7961,      86, 16, }, // America/Indiana/Marengo
    {  313, 7985,     102, 19, }, // America/Indiana/Petersburg
    {  313, 8012,     121, 18, }, // America/Indiana/Tell_City
    {  313, 8038,     139, 14, }, // America/Indiana/Vevay
    {  313, 8060,     153, 18, }, // America/Indiana/Vincennes
    {  313, 8086,     171, 16, }, // America/Indiana/Winamac
    {  313, 2799,   20426,  7, }, // America/Jamaica
    {  313, 8125,     187, 20, }, // America/Kentucky/Monticello
    {  313, 4376,   74126,  5, }, // America/La_Paz
    {  313, 3239,   74131, 10, }, // America/Los_Angeles
    {  313, 5932,     207, 22, }, // America/Lower_Princes
    {  313, 8153,   26456,  6, }, // America/Maceio
    {  313, 5805,   20436,  9, }, // America/Martinique
    {  313, 2917,   26471,  8, }, // America/Mazatlan
    {  313, 8220,     229,  6, }, // America/Merida
    {  313, 2949,   74141, 16, }, // America/Mexico_City
    {  313, 2379,   44062,  9, }, // America/New_York
    {  313, 8301,   74157, 23, }, // America/North_Dakota/Beulah
    {  313, 8329,   74180, 23, }, // America/North_Dakota/Center
    {  313, 8357,   74203, 26, }, // America/North_Dakota/New_Salem
    {  313,  393,     298,  4, }, // America/Nuuk
    {  313, 2356,   20547,  6, }, // America/Panama
    {  313, 3945,   74229, 14, }, // America/Port-au-Prince
    {  313, 5954,   74243, 12, }, // America/Port_of_Spain
    {  313, 5843,   64866, 10, }, // America/Puerto_Rico
    {  313,  695,   74255, 10, }, // America/Rio_Branco
    {  313, 8477,   26572,  8, }, // America/Santarem
    {  313, 1878,   26580,  9, }, // America/Sao_Paulo
    {  313, 6899,     302, 16, }, // America/Scoresbysund
    {  313, 8508,   35804, 16, }, // America/St_Barthelemy
    {  313, 2061,   26605, 12, }, // America/St_Johns
    {  313, 5863,   26617, 11, }, // America/St_Kitts
    {  313, 5880,   74265, 11, }, // America/St_Lucia
    {  313,  855,   44161, 12, }, // America/St_Thomas
    {  313, 5913,   74276, 11, }, // America/St_Vincent
    {  313, 5688,   20605,  7, }, // America/Tortola
    {  313, 6133,   57010, 16, }, // Antarctica/DumontDUrville
    {  313, 7295,   62088,  5, }, // Antarctica/Syowa
    {  313, 5570,   74287,  4, }, // Asia/Aden
    {  313, 5395,    7476,  6, }, // Asia/Almaty
    {  313, 3968,   20612,  4, }, // Asia/Amman
    {  313, 5523,    5491,  5, }, // Asia/Aqtau
    {  313, 5368,    7488,  6, }, // Asia/Aqtobe
    {  313,  964,   74291,  9, }, // Asia/Ashgabat
    {  313, 3607,    4044,  6, }, // Asia/Baghdad
    {  313, 3653,   74300,  4, }, // Asia/Baku
    {  313, 4601,   74304,  5, }, // Asia/Chita
    {  313, 4540,   74309,  7, }, // Asia/Damascus
    {  313, 4795,   20653,  6, }, // Asia/Hebron
    {  313, 1259,     397, 11, }, // Asia/Ho_Chi_Minh
    {  313, 7006,   74316,  7, }, // Asia/Jakarta
    {  313, 1290,   20703,  9, }, // Asia/Jerusalem
    {  313, 3560,   74323,  5, }, // Asia/Kabul
    {  313, 1185,   20712,  8, }, // Asia/Kathmandu
    {  313, 8661,   57888,  8, }, // Asia/Khandyga
    {  313,  992,   20720,  7, }, // Asia/Kolkata
    {  313, 1211,    4203,  5, }, // Asia/Macau
    {  313, 6920,   20739,  7, }, // Asia/Muscat
    {  313, 8708,   44259,  8, }, // Asia/Qostanay
    {  313, 4269,   26765,  9, }, // Asia/Qyzylorda
    {  313, 3584,    7669,  4, }, // Asia/Riyadh
    {  313, 4408,   44267,  8, }, // Asia/Sakhalin
    {  313, 7245,   20768, 10, }, // Asia/Samarkand
    {  313, 3279,   20778,  4, }, // Asia/Seoul
    {  313, 3300,   20782,  8, }, // Asia/Singapore
    {  313, 4297,    7699, 13, }, // Asia/Srednekolymsk
    {  313, 2772,   57993,  7, }, // Asia/Tehran
    {  313, 1159,   26801,  6, }, // Asia/Urumqi
    {  313, 4828,   44309,  7, }, // Asia/Yakutsk
    {  313, 1235,     442,  6, }, // Asia/Yangon
    {  313, 3883,   74328, 13, }, // Asia/Yekaterinburg
    {  313, 3747,   74341,  7, }, // Asia/Yerevan
    {  313, 5671,   74348, 14, }, // Atlantic/Bermuda
    {  313, 6628,   74362, 14, }, // Atlantic/Canary
    {  313, 3727,   26836, 10, }, // Atlantic/Cape_Verde
    {  313, 1395,   20874,  5, }, // Atlantic/Faroe
    {  313, 2748,   74376, 10, }, // Atlantic/Reykjavik
    {  313, 7272,   74386, 14, }, // Atlantic/South_Georgia
    {  313, 6821,   26865, 12, }, // Atlantic/St_Helena
    {  313, 1670,   20912,  8, }, // Australia/Adelaide
    {  313, 1463,   22607,  6, }, // Australia/Sydney
    {  313, 6441,   74400,  9, }, // Europe/Amsterdam
    {  313, 3620,   74409,  8, }, // Europe/Astrakhan
    {  313, 2300,   26877,  6, }, // Europe/Athens
    {  313, 6336,   58774,  8, }, // Europe/Belgrade
    {  313, 4757,   20941,  6, }, // Europe/Berlin
    {  313, 2167,   74417,  8, }, // Europe/Brussels
    {  313, 3928,   20955,  8, }, // Europe/Bucharest
    {  313, 6289,   20963, 10, }, // Europe/Copenhagen
    {  313, 2338,   20973,  6, }, // Europe/Dublin
    {  313, 6307,   20979,  9, }, // Europe/Gibraltar
    {  313, 6612,   74425,  9, }, // Europe/Helsinki
    {  313, 8804,   74434, 11, }, // Europe/Isle_of_Man
    {  313, 3979,   62893, 12, }, // Europe/Kaliningrad
    {  313, 2527,   44434,  4, }, // Europe/Kyiv
    {  313, 3213,   21019,  6, }, // Europe/Lisbon
    {  313, 6506,   21025,  9, }, // Europe/Ljubljana
    {  313, 2501,   21034,  7, }, // Europe/London
    {  313, 6365,   74445, 10, }, // Europe/Luxembourg
    {  313, 6410,   74455,  6, }, // Europe/Monaco
    {  313, 3537,   74461,  7, }, // Europe/Moscow
    {  313, 4284,   21062,  5, }, // Europe/Paris
    {  313, 6275,   21067,  5, }, // Europe/Prague
    {  313, 6324,    5946,  4, }, // Europe/Rome
    {  313, 6245,   74468,  8, }, // Europe/Sarajevo
    {  313, 8849,   74476, 10, }, // Europe/Simferopol
    {  313, 6599,   21081,  5, }, // Europe/Sofia
    {  313, 6523,   74486,  9, }, // Europe/Stockholm
    {  313, 6202,   21095,  6, }, // Europe/Tirane
    {  313, 8882,   26960,  9, }, // Europe/Ulyanovsk
    {  313, 6567,   74495,  8, }, // Europe/Vatican
    {  313, 6231,   21112,  5, }, // Europe/Vienna
    {  313, 4727,   63074, 10, }, // Europe/Volgograd
    {  313, 3190,   21126,  8, }, // Europe/Warsaw
    {  313, 6540,    4459,  6, }, // Europe/Zurich
    {  313, 6046,   74503, 14, }, // Indian/Christmas
    {  313, 5029,   65391,  7, }, // Indian/Comoro
    {  313, 7260,   26983,  4, }, // Indian/Mahe
    {  313, 7050,   74517,  8, }, // Indian/Maldives
    {  313, 4069,   74525,  8, }, // Indian/Mauritius
    {  313, 7211,   21142,  7, }, // Indian/Reunion
    {  313, 3157,     474,  5, }, // Pacific/Chuuk
    {  313, 2237,   74533, 14, }, // Pacific/Easter
    {  313, 3902,   21155,  4, }, // Pacific/Fiji
    {  313, 6678,   74547, 15, }, // Pacific/Galapagos
    {  313, 2723,   74562,  8, }, // Pacific/Honolulu
    {  313, 3049,    4501,  9, }, // Pacific/Kanton
    {  313, 3096,     479,  7, }, // Pacific/Pohnpei
    {  313, 7312,   44525,  6, }, // Pacific/Tahiti
    {  314,   14,       0,  6, }, // Africa/Asmara Ganda/Latin/Uganda
    {  314, 4435,       6,  8, }, // Africa/Sao_Tome
    {  314, 4252,      14,  8, }, // America/Asuncion
    {  314,  237,      22,  8, }, // America/Atikokan
    {  314, 7623,      30, 17, }, // America/Bahia_Banderas
    {  314, 3868,      47,  6, }, // America/Cancun
    {  314, 7774,      53, 13, }, // America/Ciudad_Juarez
    {  314, 5723,      66,  7, }, // America/Curacao
    {  314,  481,      73, 13, }, // America/Indiana/Knox
    {  314, 7961,      86, 16, }, // America/Indiana/Marengo
    {  314, 7985,     102, 19, }, // America/Indiana/Petersburg
    {  314, 8012,     121, 18, }, // America/Indiana/Tell_City
    {  314, 8038,     139, 14, }, // America/Indiana/Vevay
    {  314, 8060,     153, 18, }, // America/Indiana/Vincennes
    {  314, 8086,     171, 16, }, // America/Indiana/Winamac
    {  314, 8125,     187, 20, }, // America/Kentucky/Monticello
    {  314, 5932,     207, 22, }, // America/Lower_Princes
    {  314, 8220,     229,  6, }, // America/Merida
    {  314, 8301,     235, 20, }, // America/North_Dakota/Beulah
    {  314, 8329,     255, 20, }, // America/North_Dakota/Center
    {  314, 8357,     275, 23, }, // America/North_Dakota/New_Salem
    {  314,  393,     298,  4, }, // America/Nuuk
    {  314, 6899,     302, 16, }, // America/Scoresbysund
    {  314, 8508,     318, 14, }, // America/St_Barthelemy
    {  314, 2061,     332, 10, }, // America/St_Johns
    {  314, 5863,     342,  9, }, // America/St_Kitts
    {  314, 5880,     351,  9, }, // America/St_Lucia
    {  314,  855,     360, 10, }, // America/St_Thomas
    {  314, 5913,     370, 11, }, // America/St_Vincent
    {  314, 6133,     381, 16, }, // Antarctica/DumontDUrville
    {  314, 1259,     397, 11, }, // Asia/Ho_Chi_Minh
    {  314, 1185,     413,  9, }, // Asia/Kathmandu
    {  314,  992,     422,  7, }, // Asia/Kolkata
    {  314, 1211,     429,  5, }, // Asia/Macau
    {  314, 1235,     442,  6, }, // Asia/Yangon
    {  314, 1395,     448,  5, }, // Atlantic/Faroe
    {  314, 6821,     453, 10, }, // Atlantic/St_Helena
    {  314, 2527,     463,  4, }, // Europe/Kyiv
    {  314, 7211,     467,  7, }, // Indian/Reunion
    {  314, 3157,     474,  5, }, // Pacific/Chuuk
    {  314, 3096,     479,  7, }, // Pacific/Pohnpei
    {  315,   14,       0,  6, }, // Africa/Asmara Geez/Ethiopic/Ethiopia
    {  315, 4435,       6,  8, }, // Africa/Sao_Tome
    {  315, 4252,      14,  8, }, // America/Asuncion
    {  315,  237,      22,  8, }, // America/Atikokan
    {  315, 7623,      30, 17, }, // America/Bahia_Banderas
    {  315, 3868,      47,  6, }, // America/Cancun
    {  315, 7774,      53, 13, }, // America/Ciudad_Juarez
    {  315, 5723,      66,  7, }, // America/Curacao
    {  315,  481,      73, 13, }, // America/Indiana/Knox
    {  315, 7961,      86, 16, }, // America/Indiana/Marengo
    {  315, 7985,     102, 19, }, // America/Indiana/Petersburg
    {  315, 8012,     121, 18, }, // America/Indiana/Tell_City
    {  315, 8038,     139, 14, }, // America/Indiana/Vevay
    {  315, 8060,     153, 18, }, // America/Indiana/Vincennes
    {  315, 8086,     171, 16, }, // America/Indiana/Winamac
    {  315, 8125,     187, 20, }, // America/Kentucky/Monticello
    {  315, 5932,     207, 22, }, // America/Lower_Princes
    {  315, 8220,     229,  6, }, // America/Merida
    {  315, 8301,     235, 20, }, // America/North_Dakota/Beulah
    {  315, 8329,     255, 20, }, // America/North_Dakota/Center
    {  315, 8357,     275, 23, }, // America/North_Dakota/New_Salem
    {  315,  393,     298,  4, }, // America/Nuuk
    {  315, 6899,     302, 16, }, // America/Scoresbysund
    {  315, 8508,     318, 14, }, // America/St_Barthelemy
    {  315, 2061,     332, 10, }, // America/St_Johns
    {  315, 5863,     342,  9, }, // America/St_Kitts
    {  315, 5880,     351,  9, }, // America/St_Lucia
    {  315,  855,     360, 10, }, // America/St_Thomas
    {  315, 5913,     370, 11, }, // America/St_Vincent
    {  315, 6133,     381, 16, }, // Antarctica/DumontDUrville
    {  315, 1259,     397, 11, }, // Asia/Ho_Chi_Minh
    {  315, 1185,     413,  9, }, // Asia/Kathmandu
    {  315,  992,     422,  7, }, // Asia/Kolkata
    {  315, 1211,     429,  5, }, // Asia/Macau
    {  315, 1235,     442,  6, }, // Asia/Yangon
    {  315, 1395,     448,  5, }, // Atlantic/Faroe
    {  315, 6821,     453, 10, }, // Atlantic/St_Helena
    {  315, 2527,     463,  4, }, // Europe/Kyiv
    {  315, 7211,     467,  7, }, // Indian/Reunion
    {  315, 3157,     474,  5, }, // Pacific/Chuuk
    {  315, 3096,     479,  7, }, // Pacific/Pohnpei
    {  317, 6788,   74570,  7, }, // Africa/Abidjan Georgian/Georgian/Georgia
    {  317, 6760,   74577,  4, }, // Africa/Accra
    {  317, 5059,   74581, 10, }, // Africa/Addis_Ababa
    {  317, 7420,   74591,  6, }, // Africa/Algiers
    {  317,   14,   74597,  6, }, // Africa/Asmara
    {  317,   44,   74603,  6, }, // Africa/Bamako
    {  317, 5257,   74609,  5, }, // Africa/Bangui
    {  317, 6746,   74614,  7, }, // Africa/Banjul
    {  317, 7435,   74621,  5, }, // Africa/Bissau
    {  317, 4957,   74626,  8, }, // Africa/Blantyre
    {  317, 5287,   74634,  9, }, // Africa/Brazzaville
    {  317, 4922,   74643,  9, }, // Africa/Bujumbura
    {  317, 2320,   74652,  5, }, // Africa/Cairo
    {  317, 4117,   74657, 10, }, // Africa/Casablanca
    {  317, 7449,   74667,  5, }, // Africa/Ceuta
    {  317, 6773,   74672,  7, }, // Africa/Conakry
    {  317, 6840,   74679,  6, }, // Africa/Dakar
    {  317, 5130,   74685, 13, }, // Africa/Dar_es_Salaam
    {  317, 5043,   74698,  6, }, // Africa/Djibouti
    {  317, 5243,   74704,  5, }, // Africa/Douala
    {  317, 5166,   74709,  9, }, // Africa/El_Aaiun
    {  317, 6853,   74718,  8, }, // Africa/Freetown
    {  317, 4906,   74726,  8, }, // Africa/Gaborone
    {  317, 5015,   74734,  6, }, // Africa/Harare
    {  317, 4479,   74740, 12, }, // Africa/Johannesburg
    {  317, 4499,   74752,  4, }, // Africa/Juba
    {  317, 5151,   74756,  7, }, // Africa/Kampala
    {  317, 4524,   74763,  7, }, // Africa/Khartoum
    {  317, 4973,   74770,  6, }, // Africa/Kigali
    {  317, 5306,   74776,  7, }, // Africa/Kinshasa
    {  317, 4744,   74783,  6, }, // Africa/Lagos
    {  317, 5336,   74789,  9, }, // Africa/Libreville
    {  317, 6869,   74798,  4, }, // Africa/Lome
    {  317, 5211,   74802,  6, }, // Africa/Luanda
    {  317, 4939,   74808,  9, }, // Africa/Lubumbashi
    {  317, 5001,   74817,  6, }, // Africa/Lusaka
    {  317, 5322,   74823,  6, }, // Africa/Malabo
    {  317, 4987,   74829,  6, }, // Africa/Maputo
    {  317, 5197,   74835,  6, }, // Africa/Maseru
    {  317, 5182,   74841,  7, }, // Africa/Mbabane
    {  317, 5113,   74848,  8, }, // Africa/Mogadishu
    {  317, 7034,   74856,  8, }, // Africa/Monrovia
    {  317, 3853,   74864,  7, }, // Africa/Nairobi
    {  317, 5271,   74871,  7, }, // Africa/Ndjamena
    {  317, 5354,   74878,  6, }, // Africa/Niamey
    {  317, 6803,   74884,  8, }, // Africa/Nouakchott
    {  317, 6727,   74892,  8, }, // Africa/Ouagadougou
    {  317, 5225,   74900, 10, }, // Africa/Porto-Novo
    {  317, 4435,   74910,  8, }, // Africa/Sao_Tome
    {  317, 2866,   74918,  7, }, // Africa/Tripoli
    {  317, 6554,   74925,  6, }, // Africa/Tunis
    {  317, 4152,   74931,  8, }, // Africa/Windhoek
    {  317,  132,   74939,  5, }, // America/Adak
    {  317, 3346,   74944,  8, }, // America/Anchorage
    {  317, 5607,   74952,  7, }, // America/Anguilla
    {  317, 5624,   74959,  7, }, // America/Antigua
    {  317, 4554,   74966,  9, }, // America/Araguaina
    {  317,  166,   74975, 13, }, // America/Argentina/Buenos_Aires
    {  317,   91,   74988,  9, }, // America/Argentina/Catamarca
    {  317,  270,   74997,  7, }, // America/Argentina/Cordoba
    {  317,  441,   75004,  5, }, // America/Argentina/Jujuy
    {  317, 7462,   75009,  8, }, // America/Argentina/La_Rioja
    {  317,  565,   75017,  7, }, // America/Argentina/Mendoza
    {  317, 7489,   75024, 12, }, // America/Argentina/Rio_Gallegos
    {  317, 7520,   75036,  5, }, // America/Argentina/Salta
    {  317, 7544,   75041,  9, }, // America/Argentina/San_Juan
    {  317, 5580,   75050,  9, }, // America/Argentina/San_Luis
    {  317, 7571,   75059,  8, }, // America/Argentina/Tucuman
    {  317, 7597,   75067,  6, }, // America/Argentina/Ushuaia
    {  317, 5640,   75073,  5, }, // America/Aruba
    {  317, 4252,   75078,  9, }, // America/Asuncion
    {  317,  237,   75087,  9, }, // America/Atikokan
    {  317, 3679,   75096,  4, }, // America/Bahia
    {  317, 7623,   75100, 15, }, // America/Bahia_Banderas
    {  317, 5654,   75115,  9, }, // America/Barbados
    {  317, 7646,   75124,  6, }, // America/Belem
    {  317, 5407,   75130,  6, }, // America/Belize
    {  317, 7660,   75136, 12, }, // America/Blanc-Sablon
    {  317, 7681,   75148,  9, }, // America/Boa_Vista
    {  317, 4361,   75157,  6, }, // America/Bogota
    {  317, 7699,   75163,  5, }, // America/Boise
    {  317, 7713,   75168, 11, }, // America/Cambridge_Bay
    {  317, 7735,   75179, 12, }, // America/Campo_Grande
    {  317, 3868,   75191,  7, }, // America/Cancun
    {  317, 4694,   75198,  8, }, // America/Caracas
    {  317, 4345,   75206,  6, }, // America/Cayenne
    {  317, 5496,   75212,  7, }, // America/Cayman
    {  317, 2260,   75219,  6, }, // America/Chicago
    {  317, 7756,   75225,  8, }, // America/Chihuahua
    {  317, 7774,   75233, 14, }, // America/Ciudad_Juarez
    {  317, 5422,   75247, 10, }, // America/Costa_Rica
    {  317, 7796,   75257,  8, }, // America/Creston
    {  317, 3791,   75265,  6, }, // America/Cuiaba
    {  317, 5723,   75271,  8, }, // America/Curacao
    {  317, 7812,   75279, 12, }, // America/Danmarkshavn
    {  317, 7833,   75291,  7, }, // America/Dawson
    {  317, 7848,   75298, 12, }, // America/Dawson_Creek
    {  317,  805,   75310,  7, }, // America/Denver
    {  317, 3465,   75317,  8, }, // America/Detroit
    {  317, 5739,   75325,  8, }, // America/Dominica
    {  317,  893,   75333,  9, }, // America/Edmonton
    {  317, 7869,   75342,  8, }, // America/Eirunepe
    {  317, 5441,   75350,  9, }, // America/El_Salvador
    {  317, 7886,   75359, 12, }, // America/Fort_Nelson
    {  317, 7906,   75371,  9, }, // America/Fortaleza
    {  317, 7924,   75380,  9, }, // America/Glace_Bay
    {  317, 6881,   75389,  7, }, // America/Goose_Bay
    {  317, 4612,   75396, 11, }, // America/Grand_Turk
    {  317, 5770,   75407,  7, }, // America/Grenada
    {  317, 5786,   75414,  9, }, // America/Guadeloupe
    {  317, 3760,   75423,  9, }, // America/Guatemala
    {  317, 4841,   75432,  9, }, // America/Guayaquil
    {  317, 6932,   75441,  6, }, // America/Guyana
    {  317, 1939,   75447,  9, }, // America/Halifax
    {  317, 2281,   75456,  6, }, // America/Havana
    {  317, 7942,   75462,  9, }, // America/Hermosillo
    {  317,  348,   75471, 13, }, // America/Indiana/Indianapolis
    {  317,  481,   75484, 14, }, // America/Indiana/Knox
    {  317, 7961,   75498, 16, }, // America/Indiana/Marengo
    {  317, 7985,   75514, 20, }, // America/Indiana/Petersburg
    {  317, 8012,   75534, 17, }, // America/Indiana/Tell_City
    {  317, 8038,   75551, 14, }, // America/Indiana/Vevay
    {  317, 8060,   75565, 16, }, // America/Indiana/Vincennes
    {  317, 8086,   75581, 17, }, // America/Indiana/Winamac
    {  317, 8110,   75598,  7, }, // America/Inuvik
    {  317,  660,   75605,  8, }, // America/Iqaluit
    {  317, 2799,   75613,  7, }, // America/Jamaica
    {  317, 5380,   75620,  4, }, // America/Juneau
    {  317,  521,   75624,  8, }, // America/Kentucky/Louisville
    {  317, 8125,   75632, 18, }, // America/Kentucky/Monticello
    {  317, 5704,   75650, 11, }, // America/Kralendijk
    {  317, 4376,   75661,  7, }, // America/La_Paz
    {  317, 7169,   75668,  4, }, // America/Lima
    {  317, 3239,   75672, 12, }, // America/Los_Angeles
    {  317, 5932,   75684, 19, }, // America/Lower_Princes
    {  317, 8153,   75703,  6, }, // America/Maceio
    {  317, 8168,   75709,  7, }, // America/Managua
    {  317, 1908,   75716,  7, }, // America/Manaus
    {  317, 5897,   75723,  6, }, // America/Marigot
    {  317, 5805,   75729,  9, }, // America/Martinique
    {  317, 8184,   75738, 10, }, // America/Matamoros
    {  317, 2917,   75748,  9, }, // America/Mazatlan
    {  317, 8202,   75757,  8, }, // America/Menominee
    {  317, 8220,   75765,  6, }, // America/Merida
    {  317, 8235,   75771, 10, }, // America/Metlakatla
    {  317, 2949,   75781,  6, }, // America/Mexico_City
    {  317, 4391,   75787,  8, }, // America/Miquelon
    {  317, 8254,   75795,  8, }, // America/Moncton
    {  317, 8270,   75803,  8, }, // America/Monterrey
    {  317, 4098,   75811, 10, }, // America/Montevideo
    {  317, 5824,   75821,  9, }, // America/Montserrat
    {  317, 5481,   75830,  5, }, // America/Nassau
    {  317, 2379,   75835,  9, }, // America/New_York
    {  317, 8288,   75759,  4, }, // America/Nome
    {  317, 1850,   75844,  7, }, // America/Noronha
    {  317, 8301,   75851, 23, }, // America/North_Dakota/Beulah
    {  317, 8329,   75874, 24, }, // America/North_Dakota/Center
    {  317, 8357,   75898, 28, }, // America/North_Dakota/New_Salem
    {  317,  393,   75926,  7, }, // America/Nuuk
    {  317, 8388,   75933,  7, }, // America/Ojinaga
    {  317, 2356,   75940,  6, }, // America/Panama
    {  317, 6173,   75946, 10, }, // America/Paramaribo
    {  317, 2973,   75956,  7, }, // America/Phoenix
    {  317, 3945,   75963, 13, }, // America/Port-au-Prince
    {  317, 5954,   75976, 14, }, // America/Port_of_Spain
    {  317, 8404,   75990, 11, }, // America/Porto_Velho
    {  317, 5843,   76001, 11, }, // America/Puerto_Rico
    {  317, 4030,   76012, 13, }, // America/Punta_Arenas
    {  317, 8424,   76025, 13, }, // America/Rankin_Inlet
    {  317, 8445,   76038,  6, }, // America/Recife
    {  317, 1995,   76044,  6, }, // America/Regina
    {  317, 8460,   76050,  8, }, // America/Resolute
    {  317,  695,   76058, 10, }, // America/Rio_Branco
    {  317, 8477,   76068,  9, }, // America/Santarem
    {  317, 2201,   76077,  8, }, // America/Santiago
    {  317, 6111,   76085, 13, }, // America/Santo_Domingo
    {  317, 1878,   76098,  9, }, // America/Sao_Paulo
    {  317, 6899,   76107, 12, }, // America/Scoresbysund
    {  317, 8494,   76119,  5, }, // America/Sitka
    {  317, 8508,   76124, 13, }, // America/St_Barthelemy
    {  317, 2061,   76137, 10, }, // America/St_Johns
    {  317, 5863,   76147, 10, }, // America/St_Kitts
    {  317, 5880,   76157, 10, }, // America/St_Lucia
    {  317,  855,   76167, 10, }, // America/St_Thomas
    {  317, 5913,   76177, 12, }, // America/St_Vincent
    {  317, 8530,   76189, 13, }, // America/Swift_Current
    {  317, 5461,   76202, 11, }, // America/Tegucigalpa
    {  317, 5756,   76213,  4, }, // America/Thule
    {  317,  313,   76217,  7, }, // America/Tijuana
    {  317,  608,   76224,  7, }, // America/Toronto
    {  317, 5688,   76231,  7, }, // America/Tortola
    {  317, 2093,   76238,  9, }, // America/Vancouver
    {  317, 2144,   76247,  9, }, // America/Whitehorse
    {  317,  734,   76256,  8, }, // America/Winnipeg
    {  317, 8552,   76264,  8, }, // America/Yakutat
    {  317, 6001,   76272,  5, }, // Antarctica/Casey
    {  317, 6094,   76277,  6, }, // Antarctica/Davis
    {  317, 6133,   76283, 15, }, // Antarctica/DumontDUrville
    {  317, 8568,   76298,  7, }, // Antarctica/Macquarie
    {  317, 7066,   76305,  7, }, // Antarctica/Mawson
    {  317, 7113,   76312,  8, }, // Antarctica/McMurdo
    {  317, 8589,   76320,  7, }, // Antarctica/Palmer
    {  317, 7226,   76327,  6, }, // Antarctica/Rothera
    {  317, 7295,   76333,  5, }, // Antarctica/Syowa
    {  317, 8607,   76338,  5, }, // Antarctica/Troll
    {  317, 7374,   76343,  7, }, // Antarctica/Vostok
    {  317, 1429,   76350, 11, }, // Arctic/Longyearbyen
    {  317, 5570,   76361,  5, }, // Asia/Aden
    {  317, 5395,   76366,  6, }, // Asia/Almaty
    {  317, 3968,   76372,  5, }, // Asia/Amman
    {  317, 5511,   76377,  7, }, // Asia/Anadyr
    {  317, 5523,   76384,  5, }, // Asia/Aqtau
    {  317, 5368,   76389,  6, }, // Asia/Aqtobe
    {  317,  964,   76395,  8, }, // Asia/Ashgabat
    {  317, 8624,   76403,  6, }, // Asia/Atyrau
    {  317, 3607,   76409,  7, }, // Asia/Baghdad
    {  317, 5534,   76416,  8, }, // Asia/Bahrain
    {  317, 3653,   76424,  4, }, // Asia/Baku
    {  317, 4466,   76428,  8, }, // Asia/Bangkok
    {  317, 3571,   76436,  8, }, // Asia/Barnaul
    {  317, 4086,   76444,  7, }, // Asia/Beirut
    {  317, 3778,   76451,  7, }, // Asia/Bishkek
    {  317, 5989,   76458,  6, }, // Asia/Brunei
    {  317, 4601,   76464,  4, }, // Asia/Chita
    {  317, 4511,   76468,  7, }, // Asia/Colombo
    {  317, 4540,   76475,  7, }, // Asia/Damascus
    {  317, 1093,   74679,  4, }, // Asia/Dhaka
    {  317, 6192,   76482,  4, }, // Asia/Dili
    {  317, 3596,   76486,  5, }, // Asia/Dubai
    {  317, 6159,   76491,  7, }, // Asia/Dushanbe
    {  317, 8636,   76498,  9, }, // Asia/Famagusta
    {  317, 8651,   76507,  4, }, // Asia/Gaza
    {  317, 4795,   76511,  7, }, // Asia/Hebron
    {  317, 1259,   76518,  8, }, // Asia/Ho_Chi_Minh
    {  317, 2704,   76526,  8, }, // Asia/Hong_Kong
    {  317, 4771,   76534,  5, }, // Asia/Hovd
    {  317, 4184,   76539,  8, }, // Asia/Irkutsk
    {  317, 7006,   76547,  7, }, // Asia/Jakarta
    {  317, 6992,   76554,  8, }, // Asia/Jayapura
    {  317, 1290,   76562, 10, }, // Asia/Jerusalem
    {  317, 3560,   76572,  6, }, // Asia/Kabul
    {  317, 4316,   76578,  8, }, // Asia/Kamchatka
    {  317, 4239,   76586,  6, }, // Asia/Karachi
    {  317, 1185,   76592,  8, }, // Asia/Kathmandu
    {  317, 8661,   76600,  7, }, // Asia/Khandyga
    {  317,  992,   76607,  7, }, // Asia/Kolkata
    {  317, 4197,   76614, 12, }, // Asia/Krasnoyarsk
    {  317, 4859,   76626, 13, }, // Asia/Kuala_Lumpur
    {  317, 5976,   76639,  7, }, // Asia/Kuching
    {  317, 5547,   76646,  7, }, // Asia/Kuwait
    {  317, 1211,   76653,  5, }, // Asia/Macau
    {  317, 4017,   76658,  8, }, // Asia/Magadan
    {  317, 1349,   76666,  8, }, // Asia/Makassar
    {  317, 7182,   76674,  6, }, // Asia/Manila
    {  317, 6920,   76680,  7, }, // Asia/Muscat
    {  317, 2554,   76687,  7, }, // Asia/Nicosia
    {  317, 8675,   76694, 12, }, // Asia/Novokuznetsk
    {  317, 4135,   76706, 12, }, // Asia/Novosibirsk
    {  317, 4229,   76718,  5, }, // Asia/Omsk
    {  317, 7145,   76723,  5, }, // Asia/Oral
    {  317, 6961,   76728,  8, }, // Asia/Phnom_Penh
    {  317, 8693,   76736, 10, }, // Asia/Pontianak
    {  317, 4214,   76746,  8, }, // Asia/Pyongyang
    {  317, 5559,   76754,  6, }, // Asia/Qatar
    {  317, 8708,   76760,  8, }, // Asia/Qostanay
    {  317, 4269,   76768,  9, }, // Asia/Qyzylorda
    {  317, 3584,   76777,  8, }, // Asia/Riyadh
    {  317, 4408,   76785,  8, }, // Asia/Sakhalin
    {  317, 7245,   76793, 10, }, // Asia/Samarkand
    {  317, 3279,   76803,  5, }, // Asia/Seoul
    {  317, 1053,   76808,  6, }, // Asia/Shanghai
    {  317, 3300,   76814,  9, }, // Asia/Singapore
    {  317, 4297,   76823, 14, }, // Asia/Srednekolymsk
    {  317, 3263,   76837,  6, }, // Asia/Taipei
    {  317, 4781,   76843,  8, }, // Asia/Tashkent
    {  317, 3915,   76851,  7, }, // Asia/Tbilisi
    {  317, 2772,   76858,  7, }, // Asia/Tehran
    {  317, 1317,   76865,  7, }, // Asia/Thimphu
    {  317, 2821,   76872,  5, }, // Asia/Tokyo
    {  317, 4572,   76877,  6, }, // Asia/Tomsk
    {  317, 1021,   76883, 10, }, // Asia/Ulaanbaatar
    {  317, 1159,   76893,  6, }, // Asia/Urumqi
    {  317, 8722,   76899,  8, }, // Asia/Ust-Nera
    {  317, 6977,   76907,  9, }, // Asia/Vientiane
    {  317, 4710,   76916, 12, }, // Asia/Vladivostok
    {  317, 4828,   76928,  8, }, // Asia/Yakutsk
    {  317, 1235,   76936,  7, }, // Asia/Yangon
    {  317, 3883,   76943, 13, }, // Asia/Yekaterinburg
    {  317, 3747,   76956,  7, }, // Asia/Yerevan
    {  317, 3663,   76963, 16, }, // Atlantic/Azores
    {  317, 5671,   76979,  7, }, // Atlantic/Bermuda
    {  317, 6628,   76986,  6, }, // Atlantic/Canary
    {  317, 3727,   76992, 10, }, // Atlantic/Cape_Verde
    {  317, 1395,   77002, 17, }, // Atlantic/Faroe
    {  317, 8736,   77019,  7, }, // Atlantic/Madeira
    {  317, 2748,   77026, 10, }, // Atlantic/Reykjavik
    {  317, 7272,   77036, 14, }, // Atlantic/South_Georgia
    {  317, 6821,   77050, 18, }, // Atlantic/St_Helena
    {  317, 6644,   77068,  6, }, // Atlantic/Stanley
    {  317, 1670,   77074,  8, }, // Australia/Adelaide
    {  317, 1635,   77082,  9, }, // Australia/Brisbane
    {  317, 1799,   77091, 12, }, // Australia/Broken_Hill
    {  317, 1583,   77103,  7, }, // Australia/Darwin
    {  317, 3637,   77110,  5, }, // Australia/Eucla
    {  317, 1516,   77115,  7, }, // Australia/Hobart
    {  317, 8753,   77122,  8, }, // Australia/Lindeman
    {  317, 1547,   77130,  9, }, // Australia/Lord_Howe
    {  317, 1727,   77139,  8, }, // Australia/Melbourne
    {  317, 1762,   77147,  5, }, // Australia/Perth
    {  317, 1463,   77152,  6, }, // Australia/Sydney
    {  317, 6441,   77158, 10, }, // Europe/Amsterdam
    {  317, 6216,   77168,  6, }, // Europe/Andorra
    {  317, 3620,   77174,  9, }, // Europe/Astrakhan
    {  317, 2300,   77183,  5, }, // Europe/Athens
    {  317, 6336,   77188,  8, }, // Europe/Belgrade
    {  317, 4757,   77196,  7, }, // Europe/Berlin
    {  317, 6488,   77203, 10, }, // Europe/Bratislava
    {  317, 2167,   77213,  8, }, // Europe/Brussels
    {  317, 3928,   77221,  9, }, // Europe/Bucharest
    {  317, 3806,   77230,  9, }, // Europe/Budapest
    {  317, 8772,   77239,  9, }, // Europe/Busingen
    {  317, 2583,   77248,  9, }, // Europe/Chisinau
    {  317, 6289,   77257, 11, }, // Europe/Copenhagen
    {  317, 2338,   77268,  7, }, // Europe/Dublin
    {  317, 6307,   77275, 10, }, // Europe/Gibraltar
    {  317, 8788,   77285,  6, }, // Europe/Guernsey
    {  317, 6612,   77291,  8, }, // Europe/Helsinki
    {  317, 8804,   77299, 13, }, // Europe/Isle_of_Man
    {  317, 1130,   77312,  8, }, // Europe/Istanbul
    {  317, 8823,   77320,  5, }, // Europe/Jersey
    {  317, 3979,   77325, 12, }, // Europe/Kaliningrad
    {  317, 8929,   77337,  6, }, // Europe/Kirov
    {  317, 2527,   77343,  5, }, // Europe/Kyiv
    {  317, 3213,   77348,  8, }, // Europe/Lisbon
    {  317, 6506,   77356,  9, }, // Europe/Ljubljana
    {  317, 2501,   77365,  7, }, // Europe/London
    {  317, 6365,   77372, 11, }, // Europe/Luxembourg
    {  317, 4892,   77383,  7, }, // Europe/Madrid
    {  317, 6397,   77390,  5, }, // Europe/Malta
    {  317, 6582,   77395,  9, }, // Europe/Mariehamn
    {  317, 3693,   77404,  6, }, // Europe/Minsk
    {  317, 6410,   77410,  6, }, // Europe/Monaco
    {  317, 3537,   77416,  7, }, // Europe/Moscow
    {  317, 6458,   77423,  4, }, // Europe/Oslo
    {  317, 4284,   77427,  6, }, // Europe/Paris
    {  317, 6424,   77433,  9, }, // Europe/Podgorica
    {  317, 6275,   77442,  5, }, // Europe/Prague
    {  317, 8837,   77447,  4, }, // Europe/Riga
    {  317, 6324,   77451,  4, }, // Europe/Rome
    {  317, 4331,   77455,  6, }, // Europe/Samara
    {  317, 6470,   77461, 10, }, // Europe/San_Marino
    {  317, 6245,   77471,  7, }, // Europe/Sarajevo
    {  317, 4451,   77478,  8, }, // Europe/Saratov
    {  317, 8849,   77486, 11, }, // Europe/Simferopol
    {  317, 6383,   77497,  6, }, // Europe/Skopje
    {  317, 6599,   77503,  5, }, // Europe/Sofia
    {  317, 6523,   77508,  9, }, // Europe/Stockholm
    {  317, 8867,   77517,  6, }, // Europe/Tallinn
    {  317, 6202,   77523,  6, }, // Europe/Tirane
    {  317, 8882,   77529, 10, }, // Europe/Ulyanovsk
    {  317, 6352,   77539,  6, }, // Europe/Vaduz
    {  317, 6567,   77545,  8, }, // Europe/Vatican
    {  317, 6231,   77553,  4, }, // Europe/Vienna
    {  317, 8899,   77557,  8, }, // Europe/Vilnius
    {  317, 4727,   77565, 10, }, // Europe/Volgograd
    {  317, 3190,   77575,  7, }, // Europe/Warsaw
    {  317, 6261,   77582,  7, }, // Europe/Zagreb
    {  317, 6540,   77589,  7, }, // Europe/Zurich
    {  317, 5078,   77596, 12, }, // Indian/Antananarivo
    {  317, 6947,   77608,  6, }, // Indian/Chagos
    {  317, 6046,   77614, 13, }, // Indian/Christmas
    {  317, 6063,   77627,  6, }, // Indian/Cocos
    {  317, 5029,   77633,  6, }, // Indian/Comoro
    {  317, 6661,   77639,  9, }, // Indian/Kerguelen
    {  317, 7260,   77648,  4, }, // Indian/Mahe
    {  317, 7050,   77652,  9, }, // Indian/Maldives
    {  317, 4069,   77661,  7, }, // Indian/Mauritius
    {  317, 5098,   77668,  6, }, // Indian/Mayotte
    {  317, 7211,   77674,  9, }, // Indian/Reunion
    {  317, 4422,   77683,  4, }, // Pacific/Apia
    {  317,  932,   77687,  7, }, // Pacific/Auckland
    {  317, 3706,   77694,  9, }, // Pacific/Bougainville
    {  317, 3015,   77703,  6, }, // Pacific/Chatham
    {  317, 3157,   77709,  5, }, // Pacific/Chuuk
    {  317, 2237,   77714,  6, }, // Pacific/Easter
    {  317, 7360,   77720,  5, }, // Pacific/Efate
    {  317, 7327,   77725,  7, }, // Pacific/Fakaofo
    {  317, 3902,   77732,  4, }, // Pacific/Fiji
    {  317, 7343,   77736,  8, }, // Pacific/Funafuti
    {  317, 6678,   77744, 10, }, // Pacific/Galapagos
    {  317, 6696,   77754,  8, }, // Pacific/Gambier
    {  317, 3822,   77762, 12, }, // Pacific/Guadalcanal
    {  317, 6018,   77774,  5, }, // Pacific/Guam
    {  317, 2723,   77779,  8, }, // Pacific/Honolulu
    {  317, 3049,   77787,  9, }, // Pacific/Kanton
    {  317, 3998,   77796, 10, }, // Pacific/Kiritimati
    {  317, 7019,   77806,  6, }, // Pacific/Kosrae
    {  317, 2842,   77812, 10, }, // Pacific/Kwajalein
    {  317, 4877,   77822,  6, }, // Pacific/Majuro
    {  317, 4051,   77828,  9, }, // Pacific/Marquesas
    {  317, 8914,   77837,  6, }, // Pacific/Midway
    {  317, 7084,   77843,  5, }, // Pacific/Nauru
    {  317, 7132,   77848,  4, }, // Pacific/Niue
    {  317, 4168,   77852,  8, }, // Pacific/Norfolk
    {  317, 7098,   77860,  5, }, // Pacific/Noumea
    {  317, 3126,   77865,  9, }, // Pacific/Pago_Pago
    {  317, 7155,   77874,  5, }, // Pacific/Palau
    {  317, 7194,   77879,  8, }, // Pacific/Pitcairn
    {  317, 3096,   77887,  6, }, // Pacific/Pohnpei
    {  317, 4807,   77893, 11, }, // Pacific/Port_Moresby
    {  317, 6076,   77904,  9, }, // Pacific/Rarotonga
    {  317, 6031,   77913,  7, }, // Pacific/Saipan
    {  317, 7312,   77920,  5, }, // Pacific/Tahiti
    {  317, 6712,   77925,  6, }, // Pacific/Tarawa
    {  317, 4583,   77931,  9, }, // Pacific/Tongatapu
    {  317, 7392,   77940,  5, }, // Pacific/Wake
    {  317, 7405,   77945,  6, }, // Pacific/Wallis
    {  318, 5059,    3784, 11, }, // Africa/Addis_Ababa German/Latin/Germany
    {  318, 7420,   58423,  6, }, // Africa/Algiers
    {  318,   14,       0,  6, }, // Africa/Asmara
    {  318, 2320,    4572,  5, }, // Africa/Cairo
    {  318, 5130,   77951, 10, }, // Africa/Dar_es_Salaam
    {  318, 5043,   77961,  9, }, // Africa/Djibouti
    {  318, 5166,   63378,  8, }, // Africa/El_Aaiun
    {  318, 4524,   26372,  7, }, // Africa/Khartoum
    {  318, 6869,   20300,  4, }, // Africa/Lome
    {  318, 5113,   77970, 10, }, // Africa/Mogadishu
    {  318, 5271,   43996,  9, }, // Africa/Ndjamena
    {  318, 5225,   26410, 10, }, // Africa/Porto-Novo
    {  318, 4435,       6,  8, }, // Africa/Sao_Tome
    {  318, 2866,   57624,  8, }, // Africa/Tripoli
    {  318,  270,   20361,  7, }, // America/Argentina/Cordoba
    {  318, 4252,      14,  8, }, // America/Asuncion
    {  318,  237,      22,  8, }, // America/Atikokan
    {  318, 7623,    3825, 14, }, // America/Bahia_Banderas
    {  318, 4361,   20389,  6, }, // America/Bogota
    {  318, 3868,      47,  6, }, // America/Cancun
    {  318, 5496,   77980, 12, }, // America/Cayman
    {  318, 7774,      53, 13, }, // America/Ciudad_Juarez
    {  318, 5723,      66,  7, }, // America/Curacao
    {  318, 2281,   63392,  7, }, // America/Havana
    {  318,  481,      73, 13, }, // America/Indiana/Knox
    {  318, 7961,      86, 16, }, // America/Indiana/Marengo
    {  318, 7985,     102, 19, }, // America/Indiana/Petersburg
    {  318, 8012,     121, 18, }, // America/Indiana/Tell_City
    {  318, 8038,     139, 14, }, // America/Indiana/Vevay
    {  318, 8060,     153, 18, }, // America/Indiana/Vincennes
    {  318, 8086,     171, 16, }, // America/Indiana/Winamac
    {  318, 2799,    3877,  7, }, // America/Jamaica
    {  318, 8125,     187, 20, }, // America/Kentucky/Monticello
    {  318, 5932,     207, 22, }, // America/Lower_Princes
    {  318, 8220,    7008,  6, }, // America/Merida
    {  318, 2949,   77992, 12, }, // America/Mexico_City
    {  318, 8301,     235, 20, }, // America/North_Dakota/Beulah
    {  318, 8329,     255, 20, }, // America/North_Dakota/Center
    {  318, 8357,     275, 23, }, // America/North_Dakota/New_Salem
    {  318,  393,     298,  4, }, // America/Nuuk
    {  318, 1878,   26580,  9, }, // America/Sao_Paulo
    {  318, 6899,     302, 16, }, // America/Scoresbysund
    {  318, 8508,   26589, 16, }, // America/St_Barthelemy
    {  318, 2061,     332, 10, }, // America/St_Johns
    {  318, 5863,     342,  9, }, // America/St_Kitts
    {  318, 5880,     351,  9, }, // America/St_Lucia
    {  318,  855,     360, 10, }, // America/St_Thomas
    {  318, 5913,     370, 11, }, // America/St_Vincent
    {  318, 6133,     381, 16, }, // Antarctica/DumontDUrville
    {  318, 7374,    4029,  6, }, // Antarctica/Vostok
    {  318, 5368,    7488,  6, }, // Asia/Aqtobe
    {  318,  964,   44190,  7, }, // Asia/Ashgabat
    {  318, 3607,    4044,  6, }, // Asia/Baghdad
    {  318, 3778,   57088,  8, }, // Asia/Bishkek
    {  318, 5989,   78004, 17, }, // Asia/Brunei
    {  318, 4601,   78021,  7, }, // Asia/Chita
    {  318, 4540,    4083,  8, }, // Asia/Damascus
    {  318, 6159,   57096,  9, }, // Asia/Dushanbe
    {  318, 1259,   78028, 17, }, // Asia/Ho_Chi_Minh
    {  318, 2704,    4113,  8, }, // Asia/Hong_Kong
    {  318, 4771,   78045,  5, }, // Asia/Hovd
    {  318, 4316,   78050, 11, }, // Asia/Kamchatka
    {  318, 4239,   78061,  9, }, // Asia/Karachi
    {  318, 1185,     413,  9, }, // Asia/Kathmandu
    {  318, 8661,   57888,  8, }, // Asia/Khandyga
    {  318,  992,   64221,  8, }, // Asia/Kolkata
    {  318, 4197,    4170, 11, }, // Asia/Krasnoyarsk
    {  318, 1211,    4203,  5, }, // Asia/Macau
    {  318, 6920,   26750,  6, }, // Asia/Muscat
    {  318, 2554,    5620,  7, }, // Asia/Nicosia
    {  318, 8675,   78070, 12, }, // Asia/Novokuznetsk
    {  318, 4135,   78082, 11, }, // Asia/Novosibirsk
    {  318, 4214,   78093,  9, }, // Asia/Pyongyang
    {  318, 5559,    4214,  5, }, // Asia/Qatar
    {  318, 8708,   44259,  8, }, // Asia/Qostanay
    {  318, 4269,   57168,  9, }, // Asia/Qyzylorda
    {  318, 3584,    7669,  4, }, // Asia/Riyadh
    {  318, 4408,   57952,  8, }, // Asia/Sakhalin
    {  318, 3300,   20782,  8, }, // Asia/Singapore
    {  318, 3263,   78102,  6, }, // Asia/Taipei
    {  318, 4781,   57196,  9, }, // Asia/Tashkent
    {  318, 3915,   78108,  6, }, // Asia/Tbilisi
    {  318, 2772,    7724,  7, }, // Asia/Tehran
    {  318, 2821,    4238,  5, }, // Asia/Tokyo
    {  318, 1159,   26801,  6, }, // Asia/Urumqi
    {  318, 4710,    4243, 11, }, // Asia/Vladivostok
    {  318, 4828,    7755,  7, }, // Asia/Yakutsk
    {  318, 1235,    7762,  6, }, // Asia/Yangon
    {  318, 3883,    4262, 13, }, // Asia/Yekaterinburg
    {  318, 3747,   57228,  6, }, // Asia/Yerevan
    {  318, 3663,   58709,  6, }, // Atlantic/Azores
    {  318, 6628,   78114,  7, }, // Atlantic/Canary
    {  318, 3727,   26836, 10, }, // Atlantic/Cape_Verde
    {  318, 1395,   78121,  6, }, // Atlantic/Faroe
    {  318, 2748,   78127, 11, }, // Atlantic/Reykjavik
    {  318, 7272,   78138, 11, }, // Atlantic/South_Georgia
    {  318, 6821,     453, 10, }, // Atlantic/St_Helena
    {  318, 3620,   78149,  9, }, // Europe/Astrakhan
    {  318, 2300,    4320,  5, }, // Europe/Athens
    {  318, 6336,   26883,  7, }, // Europe/Belgrade
    {  318, 2167,   22634,  7, }, // Europe/Brussels
    {  318, 3928,   26897,  8, }, // Europe/Bucharest
    {  318, 8772,   26905,  8, }, // Europe/Busingen
    {  318, 6289,    4357, 10, }, // Europe/Copenhagen
    {  318, 8929,   78158,  5, }, // Europe/Kirov
    {  318, 2527,   78163,  4, }, // Europe/Kyiv
    {  318, 3213,    4381,  8, }, // Europe/Lisbon
    {  318, 6365,    4395,  9, }, // Europe/Luxembourg
    {  318, 3537,   57353,  6, }, // Europe/Moscow
    {  318, 6275,    8083,  4, }, // Europe/Prague
    {  318, 6324,    5946,  3, }, // Europe/Rome
    {  318, 4451,   78167,  7, }, // Europe/Saratov
    {  318, 6202,   21095,  6, }, // Europe/Tirane
    {  318, 8882,   78174,  9, }, // Europe/Ulyanovsk
    {  318, 6567,    5978,  7, }, // Europe/Vatican
    {  318, 6231,   57383,  4, }, // Europe/Vienna
    {  318, 4727,    4443,  9, }, // Europe/Volgograd
    {  318, 3190,   57396,  8, }, // Europe/Warsaw
    {  318, 6540,    4459,  6, }, // Europe/Zurich
    {  318, 6046,   78183, 15, }, // Indian/Christmas
    {  318, 5029,   78198,  7, }, // Indian/Comoro
    {  318, 7050,   78205,  9, }, // Indian/Maldives
    {  318, 7211,     467,  7, }, // Indian/Reunion
    {  318, 3157,     474,  5, }, // Pacific/Chuuk
    {  318, 2237,   78214, 10, }, // Pacific/Easter
    {  318, 3902,   78224,  7, }, // Pacific/Fiji
    {  318, 2723,    4493,  8, }, // Pacific/Honolulu
    {  318, 3049,    4501,  9, }, // Pacific/Kanton
    {  318, 3096,     479,  7, }, // Pacific/Pohnpei
    {  324, 5989,   78004,  6, }, // Asia/Brunei German/Latin/Switzerland
    {  324, 1211,     429,  5, }, // Asia/Macau
    {  324, 4451,   78231,  7, }, // Europe/Saratov
    {  325, 6788,   78238,  8, }, // Africa/Abidjan Greek/Greek/Greece
    {  325, 6760,   78246,  4, }, // Africa/Accra
    {  325, 5059,   78250, 13, }, // Africa/Addis_Ababa
    {  325, 7420,   78263,  6, }, // Africa/Algiers
    {  325,   14,   78269,  6, }, // Africa/Asmara
    {  325,   44,   78275,  7, }, // Africa/Bamako
    {  325, 5257,   78282,  7, }, // Africa/Bangui
    {  325, 6746,   78289,  8, }, // Africa/Banjul
    {  325, 7435,   78297,  7, }, // Africa/Bissau
    {  325, 4957,   78304,  9, }, // Africa/Blantyre
    {  325, 5287,   78313,  9, }, // Africa/Brazzaville
    {  325, 4922,   78322, 13, }, // Africa/Bujumbura
    {  325, 2320,   78335,  5, }, // Africa/Cairo
    {  325, 4117,   78340, 11, }, // Africa/Casablanca
    {  325, 7449,   78351,  6, }, // Africa/Ceuta
    {  325, 6773,   78357,  7, }, // Africa/Conakry
    {  325, 6840,   78364,  6, }, // Africa/Dakar
    {  325, 5130,   78370, 13, }, // Africa/Dar_es_Salaam
    {  325, 5043,   78383,  9, }, // Africa/Djibouti
    {  325, 5243,   78392,  7, }, // Africa/Douala
    {  325, 5166,   78399,  9, }, // Africa/El_Aaiun
    {  325, 6853,   78408,  8, }, // Africa/Freetown
    {  325, 4906,   78416, 10, }, // Africa/Gaborone
    {  325, 5015,   78426,  6, }, // Africa/Harare
    {  325, 4479,   78432, 15, }, // Africa/Johannesburg
    {  325, 4499,   78447,  7, }, // Africa/Juba
    {  325, 5151,   78454,  7, }, // Africa/Kampala
    {  325, 4524,   78461,  7, }, // Africa/Khartoum
    {  325, 4973,   78468,  7, }, // Africa/Kigali
    {  325, 5306,   78475,  7, }, // Africa/Kinshasa
    {  325, 4744,   78482,  6, }, // Africa/Lagos
    {  325, 5336,   78488,  9, }, // Africa/Libreville
    {  325, 6869,   78497,  4, }, // Africa/Lome
    {  325, 5211,   78501,  7, }, // Africa/Luanda
    {  325, 4939,   78508, 12, }, // Africa/Lubumbashi
    {  325, 5001,   78520,  7, }, // Africa/Lusaka
    {  325, 5322,   78527,  7, }, // Africa/Malabo
    {  325, 4987,   78534,  7, }, // Africa/Maputo
    {  325, 5197,   78541,  7, }, // Africa/Maseru
    {  325, 5182,   78548,  8, }, // Africa/Mbabane
    {  325, 5113,   78556, 11, }, // Africa/Mogadishu
    {  325, 7034,   78567,  8, }, // Africa/Monrovia
    {  325, 3853,   78575,  8, }, // Africa/Nairobi
    {  325, 5271,   78583,  8, }, // Africa/Ndjamena
    {  325, 5354,   78591,  6, }, // Africa/Niamey
    {  325, 6803,   78597,  8, }, // Africa/Nouakchott
    {  325, 6727,   78605, 14, }, // Africa/Ouagadougou
    {  325, 5225,   78619, 10, }, // Africa/Porto-Novo
    {  325, 4435,   78629,  8, }, // Africa/Sao_Tome
    {  325, 2866,   78637,  7, }, // Africa/Tripoli
    {  325, 6554,   78644,  6, }, // Africa/Tunis
    {  325, 4152,   78650,  8, }, // Africa/Windhoek
    {  325,  132,   78658,  5, }, // America/Adak
    {  325, 3346,   78663,  8, }, // America/Anchorage
    {  325, 5607,   78671,  9, }, // America/Anguilla
    {  325, 5624,   78680,  9, }, // America/Antigua
    {  325, 4554,   78689, 11, }, // America/Araguaina
    {  325,  166,   78700, 14, }, // America/Argentina/Buenos_Aires
    {  325,   91,   78714,  9, }, // America/Argentina/Catamarca
    {  325,  270,   78723,  7, }, // America/Argentina/Cordoba
    {  325,  441,   78730,  7, }, // America/Argentina/Jujuy
    {  325, 7462,   78737,  8, }, // America/Argentina/La_Rioja
    {  325,  565,   78745,  7, }, // America/Argentina/Mendoza
    {  325, 7489,   78752, 14, }, // America/Argentina/Rio_Gallegos
    {  325, 7520,   78766,  5, }, // America/Argentina/Salta
    {  325, 7544,   78771,  9, }, // America/Argentina/San_Juan
    {  325, 5580,   78780,  9, }, // America/Argentina/San_Luis
    {  325, 7571,   78789,  9, }, // America/Argentina/Tucuman
    {  325, 7597,   78798,  8, }, // America/Argentina/Ushuaia
    {  325, 5640,   78806,  7, }, // America/Aruba
    {  325, 4252,   78813,  9, }, // America/Asuncion
    {  325,  237,   78822,  8, }, // America/Atikokan
    {  325, 3679,   78830,  5, }, // America/Bahia
    {  325, 7623,   78835, 19, }, // America/Bahia_Banderas
    {  325, 5654,   78854, 12, }, // America/Barbados
    {  325, 7646,   78866,  6, }, // America/Belem
    {  325, 5407,   78872,  6, }, // America/Belize
    {  325, 7660,   78878, 13, }, // America/Blanc-Sablon
    {  325, 7681,   78891, 10, }, // America/Boa_Vista
    {  325, 4361,   78901,  8, }, // America/Bogota
    {  325, 7699,   78909,  6, }, // America/Boise
    {  325, 7713,   78915, 13, }, // America/Cambridge_Bay
    {  325, 7735,   78928, 13, }, // America/Campo_Grande
    {  325, 3868,   78941,  7, }, // America/Cancun
    {  325, 4694,   78948,  7, }, // America/Caracas
    {  325, 4345,   78955,  6, }, // America/Cayenne
    {  325, 5496,   78961,  6, }, // America/Cayman
    {  325, 2260,   78967,  6, }, // America/Chicago
    {  325, 7756,   78973,  9, }, // America/Chihuahua
    {  325, 7774,   78982, 15, }, // America/Ciudad_Juarez
    {  325, 5422,   78997, 10, }, // America/Costa_Rica
    {  325, 7796,   79007,  7, }, // America/Creston
    {  325, 3791,   79014,  8, }, // America/Cuiaba
    {  325, 5723,   79022,  8, }, // America/Curacao
    {  325, 7812,   79030, 12, }, // America/Danmarkshavn
    {  325, 7833,   79042,  6, }, // America/Dawson
    {  325, 7848,   79048, 11, }, // America/Dawson_Creek
    {  325,  805,   79059,  7, }, // America/Denver
    {  325, 3465,   79066,  8, }, // America/Detroit
    {  325, 5739,   79074,  9, }, // America/Dominica
    {  325,  893,   79083,  9, }, // America/Edmonton
    {  325, 7869,   79092,  9, }, // America/Eirunepe
    {  325, 5441,   79101, 11, }, // America/El_Salvador
    {  325, 7886,   79112, 11, }, // America/Fort_Nelson
    {  325, 7906,   79123,  9, }, // America/Fortaleza
    {  325, 7924,   79132, 11, }, // America/Glace_Bay
    {  325, 6881,   79143, 10, }, // America/Goose_Bay
    {  325, 4612,   79153, 12, }, // America/Grand_Turk
    {  325, 5770,   79165,  7, }, // America/Grenada
    {  325, 5786,   79172, 11, }, // America/Guadeloupe
    {  325, 3760,   79183, 10, }, // America/Guatemala
    {  325, 4841,   79193, 11, }, // America/Guayaquil
    {  325, 6932,   79204,  7, }, // America/Guyana
    {  325, 1939,   79211,  7, }, // America/Halifax
    {  325, 2281,   79218,  5, }, // America/Havana
    {  325, 7942,   79223,  9, }, // America/Hermosillo
    {  325,  348,   79232, 12, }, // America/Indiana/Indianapolis
    {  325,  481,   79244, 12, }, // America/Indiana/Knox
    {  325, 7961,   79256, 17, }, // America/Indiana/Marengo
    {  325, 7985,   79273, 21, }, // America/Indiana/Petersburg
    {  325, 8012,   79294, 17, }, // America/Indiana/Tell_City
    {  325, 8038,   79311, 14, }, // America/Indiana/Vevay
    {  325, 8060,   79325, 15, }, // America/Indiana/Vincennes
    {  325, 8086,   79340, 18, }, // America/Indiana/Winamac
    {  325, 8110,   79358,  7, }, // America/Inuvik
    {  325,  660,   79365,  8, }, // America/Iqaluit
    {  325, 2799,   79373,  8, }, // America/Jamaica
    {  325, 5380,   79381,  6, }, // America/Juneau
    {  325,  521,   79387,  7, }, // America/Kentucky/Louisville
    {  325, 8125,   79394, 19, }, // America/Kentucky/Monticello
    {  325, 5704,   79413,  9, }, // America/Kralendijk
    {  325, 4376,   79422,  6, }, // America/La_Paz
    {  325, 7169,   79428,  4, }, // America/Lima
    {  325, 3239,   79432, 12, }, // America/Los_Angeles
    {  325, 5932,     207, 22, }, // America/Lower_Princes
    {  325, 8153,   79444,  6, }, // America/Maceio
    {  325, 8168,   79450,  9, }, // America/Managua
    {  325, 1908,   79459,  7, }, // America/Manaus
    {  325, 5897,   79466,  7, }, // America/Marigot
    {  325, 5805,   79473,  9, }, // America/Martinique
    {  325, 8184,   79482,  9, }, // America/Matamoros
    {  325, 2917,   79491,  8, }, // America/Mazatlan
    {  325, 8202,   79499,  8, }, // America/Menominee
    {  325, 8220,   79507,  6, }, // America/Merida
    {  325, 8235,   79513, 10, }, // America/Metlakatla
    {  325, 2949,   79523, 16, }, // America/Mexico_City
    {  325, 4391,   79539,  7, }, // America/Miquelon
    {  325, 8254,   79546,  7, }, // America/Moncton
    {  325, 8270,   79553,  8, }, // America/Monterrey
    {  325, 4098,   79561, 10, }, // America/Montevideo
    {  325, 5824,   79571,  8, }, // America/Montserrat
    {  325, 5481,   79579,  6, }, // America/Nassau
    {  325, 2379,   79585,  9, }, // America/New_York
    {  325, 8288,   79594,  4, }, // America/Nome
    {  325, 1850,   79598,  7, }, // America/Noronha
    {  325, 8301,   79605, 23, }, // America/North_Dakota/Beulah
    {  325, 8329,   79628, 22, }, // America/North_Dakota/Center
    {  325, 8357,   79650, 27, }, // America/North_Dakota/New_Salem
    {  325,  393,   79677,  6, }, // America/Nuuk
    {  325, 8388,   79683,  8, }, // America/Ojinaga
    {  325, 2356,   79691,  7, }, // America/Panama
    {  325, 6173,   79698, 11, }, // America/Paramaribo
    {  325, 2973,   79709,  6, }, // America/Phoenix
    {  325, 3945,   79715, 12, }, // America/Port-au-Prince
    {  325, 5954,   79727, 13, }, // America/Port_of_Spain
    {  325, 8404,   79740, 11, }, // America/Porto_Velho
    {  325, 5843,   79751, 12, }, // America/Puerto_Rico
    {  325, 4030,   79763, 13, }, // America/Punta_Arenas
    {  325, 8424,   79776, 12, }, // America/Rankin_Inlet
    {  325, 8445,   79788,  6, }, // America/Recife
    {  325, 1995,   79794,  8, }, // America/Regina
    {  325, 8460,   79802,  8, }, // America/Resolute
    {  325,  695,   79810, 11, }, // America/Rio_Branco
    {  325, 8477,   79821,  8, }, // America/Santarem
    {  325, 2201,   79829,  9, }, // America/Santiago
    {  325, 6111,   79838, 15, }, // America/Santo_Domingo
    {  325, 1878,   79853,  9, }, // America/Sao_Paulo
    {  325, 6899,   79862, 14, }, // America/Scoresbysund
    {  325, 8494,   79876,  5, }, // America/Sitka
    {  325, 8508,   79881, 18, }, // America/St_Barthelemy
    {  325, 2061,   79899,  9, }, // America/St_Johns
    {  325, 5863,   79908,  8, }, // America/St_Kitts
    {  325, 5880,   79916, 11, }, // America/St_Lucia
    {  325,  855,   79927, 11, }, // America/St_Thomas
    {  325, 5913,   79938, 15, }, // America/St_Vincent
    {  325, 8530,   79953, 13, }, // America/Swift_Current
    {  325, 5461,   79966, 14, }, // America/Tegucigalpa
    {  325, 5756,   79980,  5, }, // America/Thule
    {  325,  313,   79985,  8, }, // America/Tijuana
    {  325,  608,   79993,  7, }, // America/Toronto
    {  325, 5688,   80000,  7, }, // America/Tortola
    {  325, 2093,   80007,  9, }, // America/Vancouver
    {  325, 2144,   80016, 10, }, // America/Whitehorse
    {  325,  734,   80026, 10, }, // America/Winnipeg
    {  325, 8552,   80036,  9, }, // America/Yakutat
    {  325, 6001,   80045,  5, }, // Antarctica/Casey
    {  325, 6094,   80050,  7, }, // Antarctica/Davis
    {  325, 6133,   80057, 17, }, // Antarctica/DumontDUrville
    {  325, 8568,   80074,  8, }, // Antarctica/Macquarie
    {  325, 7066,   80082,  5, }, // Antarctica/Mawson
    {  325, 7113,   80087,  9, }, // Antarctica/McMurdo
    {  325, 8589,   80096,  6, }, // Antarctica/Palmer
    {  325, 7226,   80102,  6, }, // Antarctica/Rothera
    {  325, 7295,   80108,  5, }, // Antarctica/Syowa
    {  325, 8607,   80113,  4, }, // Antarctica/Troll
    {  325, 7374,   80117,  6, }, // Antarctica/Vostok
    {  325, 1429,   80123, 14, }, // Arctic/Longyearbyen
    {  325, 5570,   80137,  5, }, // Asia/Aden
    {  325, 5395,   80142,  6, }, // Asia/Almaty
    {  325, 3968,   80148,  5, }, // Asia/Amman
    {  325, 5511,   80153,  7, }, // Asia/Anadyr
    {  325, 5523,   80160,  6, }, // Asia/Aqtau
    {  325, 5368,   80166,  7, }, // Asia/Aqtobe
    {  325,  964,   80173,  8, }, // Asia/Ashgabat
    {  325, 8624,   80181,  7, }, // Asia/Atyrau
    {  325, 3607,   80188,  7, }, // Asia/Baghdad
    {  325, 5534,   80195,  8, }, // Asia/Bahrain
    {  325, 3653,   80203,  6, }, // Asia/Baku
    {  325, 4466,   80209,  8, }, // Asia/Bangkok
    {  325, 3571,   80217,  9, }, // Asia/Barnaul
    {  325, 4086,   80226,  7, }, // Asia/Beirut
    {  325, 3778,   80233,  7, }, // Asia/Bishkek
    {  325, 5989,   80240,  8, }, // Asia/Brunei
    {  325, 4601,   80248,  5, }, // Asia/Chita
    {  325, 4511,   80253,  7, }, // Asia/Colombo
    {  325, 4540,   80260,  8, }, // Asia/Damascus
    {  325, 1093,   80268,  5, }, // Asia/Dhaka
    {  325, 6192,   80273,  5, }, // Asia/Dili
    {  325, 3596,   80278,  8, }, // Asia/Dubai
    {  325, 6159,   80286, 10, }, // Asia/Dushanbe
    {  325, 8636,   80296, 10, }, // Asia/Famagusta
    {  325, 8651,   80306,  4, }, // Asia/Gaza
    {  325, 4795,   80310,  7, }, // Asia/Hebron
    {  325, 1259,   80317, 16, }, // Asia/Ho_Chi_Minh
    {  325, 2704,   80333, 11, }, // Asia/Hong_Kong
    {  325, 4771,   80344,  5, }, // Asia/Hovd
    {  325, 4184,   80349,  8, }, // Asia/Irkutsk
    {  325, 7006,   80357,  8, }, // Asia/Jakarta
    {  325, 6992,   80365, 11, }, // Asia/Jayapura
    {  325, 1290,   80376, 10, }, // Asia/Jerusalem
    {  325, 3560,   80386,  7, }, // Asia/Kabul
    {  325, 4316,   80393,  9, }, // Asia/Kamchatka
    {  325, 4239,   80402,  7, }, // Asia/Karachi
    {  325, 1185,   80409,  9, }, // Asia/Kathmandu
    {  325, 8661,   80418,  8, }, // Asia/Khandyga
    {  325,  992,   80426,  8, }, // Asia/Kolkata
    {  325, 4197,   80434, 12, }, // Asia/Krasnoyarsk
    {  325, 4859,   80446, 15, }, // Asia/Kuala_Lumpur
    {  325, 5976,   80461,  9, }, // Asia/Kuching
    {  325, 5547,   80470,  7, }, // Asia/Kuwait
    {  325, 1211,   80477,  5, }, // Asia/Macau
    {  325, 4017,   80482,  9, }, // Asia/Magadan
    {  325, 1349,   80491,  7, }, // Asia/Makassar
    {  325, 7182,   80498,  6, }, // Asia/Manila
    {  325, 6920,   80504,  6, }, // Asia/Muscat
    {  325, 2554,   80510,  8, }, // Asia/Nicosia
    {  325, 8675,   80518, 13, }, // Asia/Novokuznetsk
    {  325, 4135,   80531, 12, }, // Asia/Novosibirsk
    {  325, 4229,   80543,  4, }, // Asia/Omsk
    {  325, 7145,   80547,  4, }, // Asia/Oral
    {  325, 6961,   80551,  9, }, // Asia/Phnom_Penh
    {  325, 8693,   80560,  9, }, // Asia/Pontianak
    {  325, 4214,   80569, 12, }, // Asia/Pyongyang
    {  325, 5559,   80581,  5, }, // Asia/Qatar
    {  325, 8708,   80586,  8, }, // Asia/Qostanay
    {  325, 4269,   80594, 10, }, // Asia/Qyzylorda
    {  325, 3584,   80604,  5, }, // Asia/Riyadh
    {  325, 4408,   80609,  8, }, // Asia/Sakhalin
    {  325, 7245,   80617, 10, }, // Asia/Samarkand
    {  325, 3279,   80627,  5, }, // Asia/Seoul
    {  325, 1053,   80632,  7, }, // Asia/Shanghai
    {  325, 3300,   80639, 10, }, // Asia/Singapore
    {  325, 4297,   80649, 14, }, // Asia/Srednekolymsk
    {  325, 3263,   80663,  6, }, // Asia/Taipei
    {  325, 4781,   80669,  8, }, // Asia/Tashkent
    {  325, 3915,   80677,  7, }, // Asia/Tbilisi
    {  325, 2772,   80684,  8, }, // Asia/Tehran
    {  325, 1317,   80692,  6, }, // Asia/Thimphu
    {  325, 2821,   80698,  5, }, // Asia/Tokyo
    {  325, 4572,   80703,  5, }, // Asia/Tomsk
    {  325, 1021,   80708, 12, }, // Asia/Ulaanbaatar
    {  325, 1159,   80720,  9, }, // Asia/Urumqi
    {  325, 8722,   80729,  9, }, // Asia/Ust-Nera
    {  325, 6977,   80738,  8, }, // Asia/Vientiane
    {  325, 4710,   80746, 11, }, // Asia/Vladivostok
    {  325, 4828,   80757,  9, }, // Asia/Yakutsk
    {  325, 1235,   80766,  8, }, // Asia/Yangon
    {  325, 3883,   80774, 15, }, // Asia/Yekaterinburg
    {  325, 3747,   80789,  6, }, // Asia/Yerevan
    {  325, 3663,   80795,  6, }, // Atlantic/Azores
    {  325, 5671,   80801,  9, }, // Atlantic/Bermuda
    {  325, 6628,   80810,  7, }, // Atlantic/Canary
    {  325, 3727,   80817, 17, }, // Atlantic/Cape_Verde
    {  325, 1395,   80834,  6, }, // Atlantic/Faroe
    {  325, 8736,   80840,  6, }, // Atlantic/Madeira
    {  325, 2748,   80846,  9, }, // Atlantic/Reykjavik
    {  325, 7272,   80855, 13, }, // Atlantic/South_Georgia
    {  325, 6821,   80868,  9, }, // Atlantic/St_Helena
    {  325, 6644,   80877,  7, }, // Atlantic/Stanley
    {  325, 1670,   80884,  8, }, // Australia/Adelaide
    {  325, 1635,   80892, 10, }, // Australia/Brisbane
    {  325, 1799,   80902, 11, }, // Australia/Broken_Hill
    {  325, 1583,   80913,  9, }, // Australia/Darwin
    {  325, 3637,   80922,  7, }, // Australia/Eucla
    {  325, 1516,   80929,  7, }, // Australia/Hobart
    {  325, 8753,   80936,  8, }, // Australia/Lindeman
    {  325, 1547,   80944, 10, }, // Australia/Lord_Howe
    {  325, 1727,   80954,  9, }, // Australia/Melbourne
    {  325, 1762,   80963,  4, }, // Australia/Perth
    {  325, 1463,   80967,  6, }, // Australia/Sydney
    {  325, 6441,   80973, 10, }, // Europe/Amsterdam
    {  325, 6216,   80983,  6, }, // Europe/Andorra
    {  325, 3620,   80989,  8, }, // Europe/Astrakhan
    {  325, 2300,   80997,  5, }, // Europe/Athens
    {  325, 6336,   81002,  9, }, // Europe/Belgrade
    {  325, 4757,   81011,  8, }, // Europe/Berlin
    {  325, 6488,   81019, 11, }, // Europe/Bratislava
    {  325, 2167,   81030,  9, }, // Europe/Brussels
    {  325, 3928,   81039, 11, }, // Europe/Bucharest
    {  325, 3806,   81050, 10, }, // Europe/Budapest
    {  325, 8772,   81060, 10, }, // Europe/Busingen
    {  325, 2583,   81070,  8, }, // Europe/Chisinau
    {  325, 6289,   81078,  9, }, // Europe/Copenhagen
    {  325, 2338,   81087,  8, }, // Europe/Dublin
    {  325, 6307,   81095,  9, }, // Europe/Gibraltar
    {  325, 8788,   81104,  7, }, // Europe/Guernsey
    {  325, 6612,   81111,  7, }, // Europe/Helsinki
    {  325, 8804,   81118, 13, }, // Europe/Isle_of_Man
    {  325, 1130,   81131, 16, }, // Europe/Istanbul
    {  325, 8823,   81147,  7, }, // Europe/Jersey
    {  325, 3979,   81154, 13, }, // Europe/Kaliningrad
    {  325, 8929,   81167,  5, }, // Europe/Kirov
    {  325, 2527,   81172,  5, }, // Europe/Kyiv
    {  325, 3213,   81177,  8, }, // Europe/Lisbon
    {  325, 6506,   81185, 11, }, // Europe/Ljubljana
    {  325, 2501,   81196,  7, }, // Europe/London
    {  325, 6365,   81203, 12, }, // Europe/Luxembourg
    {  325, 4892,   81215,  7, }, // Europe/Madrid
    {  325, 6397,   81222,  5, }, // Europe/Malta
    {  325, 6582,   81227,  9, }, // Europe/Mariehamn
    {  325, 3693,   81236,  5, }, // Europe/Minsk
    {  325, 6410,   81241,  6, }, // Europe/Monaco
    {  325, 3537,   81247,  5, }, // Europe/Moscow
    {  325, 6458,   81252,  4, }, // Europe/Oslo
    {  325, 4284,   81256,  6, }, // Europe/Paris
    {  325, 6424,   81262, 12, }, // Europe/Podgorica
    {  325, 6275,   81274,  5, }, // Europe/Prague
    {  325, 8837,   81279,  4, }, // Europe/Riga
    {  325, 6324,   81283,  4, }, // Europe/Rome
    {  325, 4331,   81287,  6, }, // Europe/Samara
    {  325, 6470,   81293, 13, }, // Europe/San_Marino
    {  325, 6245,   81306,  8, }, // Europe/Sarajevo
    {  325, 4451,   81314,  7, }, // Europe/Saratov
    {  325, 8849,   81321, 11, }, // Europe/Simferopol
    {  325, 6383,   81332,  6, }, // Europe/Skopje
    {  325, 6599,   81338,  5, }, // Europe/Sofia
    {  325, 6523,   81343,  9, }, // Europe/Stockholm
    {  325, 8867,   81352,  5, }, // Europe/Tallinn
    {  325, 6202,   81357,  6, }, // Europe/Tirane
    {  325, 8882,   81363, 10, }, // Europe/Ulyanovsk
    {  325, 6352,   81373,  7, }, // Europe/Vaduz
    {  325, 6567,   81380,  8, }, // Europe/Vatican
    {  325, 6231,   81388,  6, }, // Europe/Vienna
    {  325, 8899,   81394,  8, }, // Europe/Vilnius
    {  325, 4727,   81402, 11, }, // Europe/Volgograd
    {  325, 3190,   81413,  8, }, // Europe/Warsaw
    {  325, 6261,   81421,  8, }, // Europe/Zagreb
    {  325, 6540,   81429,  6, }, // Europe/Zurich
    {  325, 5078,   81435, 12, }, // Indian/Antananarivo
    {  325, 6947,   81447,  7, }, // Indian/Chagos
    {  325, 6046,   81454, 19, }, // Indian/Christmas
    {  325, 6063,   81473,  5, }, // Indian/Cocos
    {  325, 5029,   81478,  6, }, // Indian/Comoro
    {  325, 6661,   81484,  9, }, // Indian/Kerguelen
    {  325, 7260,   81493,  4, }, // Indian/Mahe
    {  325, 7050,   81497,  8, }, // Indian/Maldives
    {  325, 4069,   81505,  9, }, // Indian/Mauritius
    {  325, 5098,   81514,  6, }, // Indian/Mayotte
    {  325, 7211,   81520,  7, }, // Indian/Reunion
    {  325, 4422,   81527,  4, }, // Pacific/Apia
    {  325,  932,   81531,  6, }, // Pacific/Auckland
    {  325, 3706,   81537, 11, }, // Pacific/Bougainville
    {  325, 3015,   81548,  6, }, // Pacific/Chatham
    {  325, 3157,   81554,  5, }, // Pacific/Chuuk
    {  325, 2237,   81559, 11, }, // Pacific/Easter
    {  325, 7360,   81570,  5, }, // Pacific/Efate
    {  325, 7327,   81575,  7, }, // Pacific/Fakaofo
    {  325, 3902,   81582,  5, }, // Pacific/Fiji
    {  325, 7343,   81587, 10, }, // Pacific/Funafuti
    {  325, 6678,   81597, 11, }, // Pacific/Galapagos
    {  325, 6696,   81608,  8, }, // Pacific/Gambier
    {  325, 3822,   81616, 14, }, // Pacific/Guadalcanal
    {  325, 6018,   81630,  6, }, // Pacific/Guam
    {  325, 2723,   81636, 10, }, // Pacific/Honolulu
    {  325, 3049,   81646, 10, }, // Pacific/Kanton
    {  325, 3998,   81656, 10, }, // Pacific/Kiritimati
    {  325, 7019,   81666,  6, }, // Pacific/Kosrae
    {  325, 2842,   81672, 11, }, // Pacific/Kwajalein
    {  325, 4877,   81683,  8, }, // Pacific/Majuro
    {  325, 4051,   81691,  8, }, // Pacific/Marquesas
    {  325, 8914,   81699,  9, }, // Pacific/Midway
    {  325, 7084,   81708,  7, }, // Pacific/Nauru
    {  325, 7132,   81715,  5, }, // Pacific/Niue
    {  325, 4168,   81720,  7, }, // Pacific/Norfolk
    {  325, 7098,   81727,  6, }, // Pacific/Noumea
    {  325, 3126,   81733, 11, }, // Pacific/Pago_Pago
    {  325, 7155,   81744,  6, }, // Pacific/Palau
    {  325, 7194,   81750,  7, }, // Pacific/Pitcairn
    {  325, 3096,   81757,  6, }, // Pacific/Pohnpei
    {  325, 4807,   81763, 13, }, // Pacific/Port_Moresby
    {  325, 6076,   81776, 10, }, // Pacific/Rarotonga
    {  325, 6031,   81786,  6, }, // Pacific/Saipan
    {  325, 7312,   81792,  5, }, // Pacific/Tahiti
    {  325, 6712,   81797,  7, }, // Pacific/Tarawa
    {  325, 4583,   81804, 11, }, // Pacific/Tongatapu
    {  325, 7392,   81815,  6, }, // Pacific/Wake
    {  325, 7405,   81821,  7, }, // Pacific/Wallis
    {  327,   14,       0,  6, }, // Africa/Asmara Guarani/Latin/Paraguay
    {  327, 4435,       6,  8, }, // Africa/Sao_Tome
    {  327, 4252,      14,  8, }, // America/Asuncion
    {  327,  237,      22,  8, }, // America/Atikokan
    {  327, 7623,      30, 17, }, // America/Bahia_Banderas
    {  327, 3868,      47,  6, }, // America/Cancun
    {  327, 7774,      53, 13, }, // America/Ciudad_Juarez
    {  327, 5723,      66,  7, }, // America/Curacao
    {  327,  481,      73, 13, }, // America/Indiana/Knox
    {  327, 7961,      86, 16, }, // America/Indiana/Marengo
    {  327, 7985,     102, 19, }, // America/Indiana/Petersburg
    {  327, 8012,     121, 18, }, // America/Indiana/Tell_City
    {  327, 8038,     139, 14, }, // America/Indiana/Vevay
    {  327, 8060,     153, 18, }, // America/Indiana/Vincennes
    {  327, 8086,     171, 16, }, // America/Indiana/Winamac
    {  327, 8125,     187, 20, }, // America/Kentucky/Monticello
    {  327, 5932,     207, 22, }, // America/Lower_Princes
    {  327, 8220,     229,  6, }, // America/Merida
    {  327, 8301,     235, 20, }, // America/North_Dakota/Beulah
    {  327, 8329,     255, 20, }, // America/North_Dakota/Center
    {  327, 8357,     275, 23, }, // America/North_Dakota/New_Salem
    {  327,  393,     298,  4, }, // America/Nuuk
    {  327, 6899,     302, 16, }, // America/Scoresbysund
    {  327, 8508,     318, 14, }, // America/St_Barthelemy
    {  327, 2061,     332, 10, }, // America/St_Johns
    {  327, 5863,     342,  9, }, // America/St_Kitts
    {  327, 5880,     351,  9, }, // America/St_Lucia
    {  327,  855,     360, 10, }, // America/St_Thomas
    {  327, 5913,     370, 11, }, // America/St_Vincent
    {  327, 6133,     381, 16, }, // Antarctica/DumontDUrville
    {  327, 1259,     397, 11, }, // Asia/Ho_Chi_Minh
    {  327, 1185,     413,  9, }, // Asia/Kathmandu
    {  327,  992,     422,  7, }, // Asia/Kolkata
    {  327, 1211,     429,  5, }, // Asia/Macau
    {  327, 1235,     442,  6, }, // Asia/Yangon
    {  327, 1395,     448,  5, }, // Atlantic/Faroe
    {  327, 6821,     453, 10, }, // Atlantic/St_Helena
    {  327, 2527,     463,  4, }, // Europe/Kyiv
    {  327, 7211,     467,  7, }, // Indian/Reunion
    {  327, 3157,     474,  5, }, // Pacific/Chuuk
    {  327, 3096,     479,  7, }, // Pacific/Pohnpei
    {  328, 6788,   81828,  8, }, // Africa/Abidjan Gujarati/Gujarati/India
    {  328, 6760,   81836,  4, }, // Africa/Accra
    {  328, 5059,   81840, 10, }, // Africa/Addis_Ababa
    {  328, 7420,   81850,  9, }, // Africa/Algiers
    {  328,   14,   81859,  7, }, // Africa/Asmara
    {  328,   44,   81866,  5, }, // Africa/Bamako
    {  328, 5257,   81871,  6, }, // Africa/Bangui
    {  328, 6746,   81877,  6, }, // Africa/Banjul
    {  328, 7435,   81883,  5, }, // Africa/Bissau
    {  328, 4957,   81888,  8, }, // Africa/Blantyre
    {  328, 5287,   81896, 10, }, // Africa/Brazzaville
    {  328, 4922,   81906,  9, }, // Africa/Bujumbura
    {  328, 2320,   81915,  4, }, // Africa/Cairo
    {  328, 4117,   81919, 11, }, // Africa/Casablanca
    {  328, 7449,   81930,  6, }, // Africa/Ceuta
    {  328, 6773,   81936,  8, }, // Africa/Conakry
    {  328, 6840,   81944,  4, }, // Africa/Dakar
    {  328, 5130,   81948, 11, }, // Africa/Dar_es_Salaam
    {  328, 5043,   81959,  6, }, // Africa/Djibouti
    {  328, 5243,   81965,  5, }, // Africa/Douala
    {  328, 5166,   81970,  6, }, // Africa/El_Aaiun
    {  328, 6853,   81976,  8, }, // Africa/Freetown
    {  328, 4906,   81984,  7, }, // Africa/Gaborone
    {  328, 5015,   81991,  5, }, // Africa/Harare
    {  328, 4479,   81996, 11, }, // Africa/Johannesburg
    {  328, 4499,   82007,  4, }, // Africa/Juba
    {  328, 5151,   82011,  7, }, // Africa/Kampala
    {  328, 4524,   82018,  7, }, // Africa/Khartoum
    {  328, 4973,   82025,  6, }, // Africa/Kigali
    {  328, 5306,   82031,  7, }, // Africa/Kinshasa
    {  328, 4744,   82038,  5, }, // Africa/Lagos
    {  328, 5336,   82043, 10, }, // Africa/Libreville
    {  328, 6869,   82053,  3, }, // Africa/Lome
    {  328, 5211,   82056,  9, }, // Africa/Luanda
    {  328, 4939,   82065, 10, }, // Africa/Lubumbashi
    {  328, 5001,   82075,  6, }, // Africa/Lusaka
    {  328, 5322,   82081,  5, }, // Africa/Malabo
    {  328, 4987,   82086,  6, }, // Africa/Maputo
    {  328, 5197,   82092,  5, }, // Africa/Maseru
    {  328, 5182,   82097,  7, }, // Africa/Mbabane
    {  328, 5113,   82104,  8, }, // Africa/Mogadishu
    {  328, 7034,   82112,  9, }, // Africa/Monrovia
    {  328, 3853,   82121,  6, }, // Africa/Nairobi
    {  328, 5271,   82127,  7, }, // Africa/Ndjamena
    {  328, 5354,   82134,  6, }, // Africa/Niamey
    {  328, 6803,   82140,  6, }, // Africa/Nouakchott
    {  328, 6727,   82146,  8, }, // Africa/Ouagadougou
    {  328, 5225,   82154, 11, }, // Africa/Porto-Novo
    {  328, 4435,   82165,  7, }, // Africa/Sao_Tome
    {  328, 2866,   82172,  8, }, // Africa/Tripoli
    {  328, 6554,   82180,  7, }, // Africa/Tunis
    {  328, 4152,   82187,  7, }, // Africa/Windhoek
    {  328,  132,   82194,  3, }, // America/Adak
    {  328, 3346,   82197,  8, }, // America/Anchorage
    {  328, 5607,   82205,  8, }, // America/Anguilla
    {  328, 5624,   82213,  8, }, // America/Antigua
    {  328, 4554,   82221,  8, }, // America/Araguaina
    {  328,  166,   82229, 12, }, // America/Argentina/Buenos_Aires
    {  328,   91,   82241, 10, }, // America/Argentina/Catamarca
    {  328,  270,   82251,  8, }, // America/Argentina/Cordoba
    {  328,  441,   82259,  5, }, // America/Argentina/Jujuy
    {  328, 7462,   82264,  8, }, // America/Argentina/La_Rioja
    {  328,  565,   82272,  8, }, // America/Argentina/Mendoza
    {  328, 7489,   82280, 11, }, // America/Argentina/Rio_Gallegos
    {  328, 7520,   82291,  6, }, // America/Argentina/Salta
    {  328, 7544,   82297,  8, }, // America/Argentina/San_Juan
    {  328, 5580,   82305,  8, }, // America/Argentina/San_Luis
    {  328, 7571,   82313,  7, }, // America/Argentina/Tucuman
    {  328, 7597,   82320,  5, }, // America/Argentina/Ushuaia
    {  328, 5640,   82325,  5, }, // America/Aruba
    {  328, 4252,   82330,  8, }, // America/Asuncion
    {  328,  237,   82338,  8, }, // America/Atikokan
    {  328, 3679,   82346,  6, }, // America/Bahia
    {  328, 7623,   82352, 14, }, // America/Bahia_Banderas
    {  328, 5654,   82366,  8, }, // America/Barbados
    {  328, 7646,   82374,  5, }, // America/Belem
    {  328, 5407,   82379,  5, }, // America/Belize
    {  328, 7660,   82384, 13, }, // America/Blanc-Sablon
    {  328, 7681,   82397, 10, }, // America/Boa_Vista
    {  328, 4361,   82407,  6, }, // America/Bogota
    {  328, 7699,   82413,  4, }, // America/Boise
    {  328, 7713,   82417, 12, }, // America/Cambridge_Bay
    {  328, 7735,   82429, 13, }, // America/Campo_Grande
    {  328, 3868,   82442,  7, }, // America/Cancun
    {  328, 4694,   82449,  6, }, // America/Caracas
    {  328, 4345,   82455,  6, }, // America/Cayenne
    {  328, 5496,   82461,  5, }, // America/Cayman
    {  328, 2260,   82466,  6, }, // America/Chicago
    {  328, 7756,   82472,  8, }, // America/Chihuahua
    {  328, 7774,   82480, 14, }, // America/Ciudad_Juarez
    {  328, 5422,   82494, 11, }, // America/Costa_Rica
    {  328, 7796,   82505,  8, }, // America/Creston
    {  328, 3791,   82513,  7, }, // America/Cuiaba
    {  328, 5723,   82520,  7, }, // America/Curacao
    {  328, 7812,   82527, 11, }, // America/Danmarkshavn
    {  328, 7833,   82538,  4, }, // America/Dawson
    {  328, 7848,   82542, 10, }, // America/Dawson_Creek
    {  328,  805,   82552,  6, }, // America/Denver
    {  328, 3465,   82558,  8, }, // America/Detroit
    {  328, 5739,   82566,  8, }, // America/Dominica
    {  328,  893,   82574,  8, }, // America/Edmonton
    {  328, 7869,   82582,  6, }, // America/Eirunepe
    {  328, 5441,   82588, 12, }, // America/El_Salvador
    {  328, 7886,   82600, 12, }, // America/Fort_Nelson
    {  328, 7906,   82612, 10, }, // America/Fortaleza
    {  328, 7924,   82622,  8, }, // America/Glace_Bay
    {  328, 6881,   82630,  6, }, // America/Goose_Bay
    {  328, 4612,   82636, 12, }, // America/Grand_Turk
    {  328, 5770,   82648,  8, }, // America/Grenada
    {  328, 5786,   82656,  9, }, // America/Guadeloupe
    {  328, 3760,   82665, 10, }, // America/Guatemala
    {  328, 4841,   82675,  9, }, // America/Guayaquil
    {  328, 6932,   82684,  5, }, // America/Guyana
    {  328, 1939,   82689,  9, }, // America/Halifax
    {  328, 2281,   82698,  5, }, // America/Havana
    {  328, 7942,   82703,  8, }, // America/Hermosillo
    {  328,  348,   82711, 14, }, // America/Indiana/Indianapolis
    {  328,  481,   82725, 16, }, // America/Indiana/Knox
    {  328, 7961,   82741, 18, }, // America/Indiana/Marengo
    {  328, 7985,   82759, 21, }, // America/Indiana/Petersburg
    {  328, 8012,   82780, 19, }, // America/Indiana/Tell_City
    {  328, 8038,   82799, 15, }, // America/Indiana/Vevay
    {  328, 8060,   82814, 20, }, // America/Indiana/Vincennes
    {  328, 8086,   82834, 18, }, // America/Indiana/Winamac
    {  328, 8110,   82852,  6, }, // America/Inuvik
    {  328,  660,   82858,  7, }, // America/Iqaluit
    {  328, 2799,   82865,  5, }, // America/Jamaica
    {  328, 5380,   82870,  5, }, // America/Juneau
    {  328,  521,   82875,  6, }, // America/Kentucky/Louisville
    {  328, 8125,   82881, 20, }, // America/Kentucky/Monticello
    {  328, 5704,   82901, 11, }, // America/Kralendijk
    {  328, 4376,   82912,  6, }, // America/La_Paz
    {  328, 7169,   82918,  4, }, // America/Lima
    {  328, 3239,   82922, 11, }, // America/Los_Angeles
    {  328, 5932,   82933, 24, }, // America/Lower_Princes
    {  328, 8153,   82957,  5, }, // America/Maceio
    {  328, 8168,   82962,  7, }, // America/Managua
    {  328, 1908,   82969,  4, }, // America/Manaus
    {  328, 5897,   82973,  7, }, // America/Marigot
    {  328, 5805,   82980,  9, }, // America/Martinique
    {  328, 8184,   82989,  9, }, // America/Matamoros
    {  328, 2917,   82998,  7, }, // America/Mazatlan
    {  328, 8202,   83005,  8, }, // America/Menominee
    {  328, 8220,   83013,  6, }, // America/Merida
    {  328, 8235,   83019, 12, }, // America/Metlakatla
    {  328, 2949,   83031, 13, }, // America/Mexico_City
    {  328, 4391,   83044,  9, }, // America/Miquelon
    {  328, 8254,   83053,  7, }, // America/Moncton
    {  328, 8270,   83060,  8, }, // America/Monterrey
    {  328, 4098,   83068, 10, }, // America/Montevideo
    {  328, 5824,   83078,  9, }, // America/Montserrat
    {  328, 5481,   83087,  5, }, // America/Nassau
    {  328, 2379,   83092,  9, }, // America/New_York
    {  328, 8288,   83007,  3, }, // America/Nome
    {  328, 1850,   83101,  8, }, // America/Noronha
    {  328, 8301,   83109, 21, }, // America/North_Dakota/Beulah
    {  328, 8329,   83130, 20, }, // America/North_Dakota/Center
    {  328, 8357,   83150, 23, }, // America/North_Dakota/New_Salem
    {  328,  393,   83173,  3, }, // America/Nuuk
    {  328, 8388,   83176,  7, }, // America/Ojinaga
    {  328, 2356,   83183,  5, }, // America/Panama
    {  328, 6173,   83188, 10, }, // America/Paramaribo
    {  328, 2973,   83198,  7, }, // America/Phoenix
    {  328, 3945,   83205, 15, }, // America/Port-au-Prince
    {  328, 5954,   83220, 14, }, // America/Port_of_Spain
    {  328, 8404,   83234, 13, }, // America/Porto_Velho
    {  328, 5843,   83247, 14, }, // America/Puerto_Rico
    {  328, 4030,   83261, 13, }, // America/Punta_Arenas
    {  328, 8424,   83274, 13, }, // America/Rankin_Inlet
    {  328, 8445,   83287,  5, }, // America/Recife
    {  328, 1995,   83292,  6, }, // America/Regina
    {  328, 8460,   83298,  7, }, // America/Resolute
    {  328,  695,   83305, 12, }, // America/Rio_Branco
    {  328, 8477,   83317,  9, }, // America/Santarem
    {  328, 2201,   83326,  9, }, // America/Santiago
    {  328, 6111,   83335, 13, }, // America/Santo_Domingo
    {  328, 1878,   83348,  9, }, // America/Sao_Paulo
    {  328, 6899,   83357, 14, }, // America/Scoresbysund
    {  328, 8494,   83371,  6, }, // America/Sitka
    {  328, 8508,   83377, 15, }, // America/St_Barthelemy
    {  328, 2061,   83392, 12, }, // America/St_Johns
    {  328, 5863,   83404, 10, }, // America/St_Kitts
    {  328, 5880,   83414, 11, }, // America/St_Lucia
    {  328,  855,   83425,  9, }, // America/St_Thomas
    {  328, 5913,   83434, 14, }, // America/St_Vincent
    {  328, 8530,   83448, 12, }, // America/Swift_Current
    {  328, 5461,   83460, 11, }, // America/Tegucigalpa
    {  328, 5756,   83471,  4, }, // America/Thule
    {  328,  313,   83475,  7, }, // America/Tijuana
    {  328,  608,   83482,  7, }, // America/Toronto
    {  328, 5688,   83489,  8, }, // America/Tortola
    {  328, 2093,   83497,  8, }, // America/Vancouver
    {  328, 2144,   83505, 11, }, // America/Whitehorse
    {  328,  734,   83516,  9, }, // America/Winnipeg
    {  328, 8552,   83525,  5, }, // America/Yakutat
    {  328, 6001,   83530,  4, }, // Antarctica/Casey
    {  328, 6094,   83534,  5, }, // Antarctica/Davis
    {  328, 6133,   83539, 17, }, // Antarctica/DumontDUrville
    {  328, 8568,   83556,  8, }, // Antarctica/Macquarie
    {  328, 7066,   83564,  4, }, // Antarctica/Mawson
    {  328, 7113,   83568,  8, }, // Antarctica/McMurdo
    {  328, 8589,   83576,  6, }, // Antarctica/Palmer
    {  328, 7226,   83582,  6, }, // Antarctica/Rothera
    {  328, 7295,   83588,  6, }, // Antarctica/Syowa
    {  328, 8607,   83594,  5, }, // Antarctica/Troll
    {  328, 7374,   83599,  7, }, // Antarctica/Vostok
    {  328, 1429,   83606, 12, }, // Arctic/Longyearbyen
    {  328, 5570,   83618,  4, }, // Asia/Aden
    {  328, 5395,   83622,  7, }, // Asia/Almaty
    {  328, 3968,   83629,  6, }, // Asia/Amman
    {  328, 5511,   83635,  5, }, // Asia/Anadyr
    {  328, 5523,   83640,  5, }, // Asia/Aqtau
    {  328, 5368,   83645,  6, }, // Asia/Aqtobe
    {  328,  964,   83651,  6, }, // Asia/Ashgabat
    {  328, 8624,   83657,  7, }, // Asia/Atyrau
    {  328, 3607,   83664,  5, }, // Asia/Baghdad
    {  328, 5534,   83669,  6, }, // Asia/Bahrain
    {  328, 3653,   82518,  4, }, // Asia/Baku
    {  328, 4466,   83675,  7, }, // Asia/Bangkok
    {  328, 3571,   83682,  6, }, // Asia/Barnaul
    {  328, 4086,   83688,  5, }, // Asia/Beirut
    {  328, 3778,   83693,  6, }, // Asia/Bishkek
    {  328, 5989,   83699,  7, }, // Asia/Brunei
    {  328, 4601,   83706,  4, }, // Asia/Chita
    {  328, 4511,   83710,  6, }, // Asia/Colombo
    {  328, 4540,   83716,  7, }, // Asia/Damascus
    {  328, 1093,   83723,  4, }, // Asia/Dhaka
    {  328, 6192,   83727,  4, }, // Asia/Dili
    {  328, 3596,   83731,  4, }, // Asia/Dubai
    {  328, 6159,   83735,  8, }, // Asia/Dushanbe
    {  328, 8636,   83743, 10, }, // Asia/Famagusta
    {  328, 8651,   83753,  4, }, // Asia/Gaza
    {  328, 4795,   83757,  7, }, // Asia/Hebron
    {  328, 1259,   83764, 14, }, // Asia/Ho_Chi_Minh
    {  328, 2704,   83778,  8, }, // Asia/Hong_Kong
    {  328, 4771,   83786,  5, }, // Asia/Hovd
    {  328, 4184,   83791, 10, }, // Asia/Irkutsk
    {  328, 7006,   83801,  7, }, // Asia/Jakarta
    {  328, 6992,   83808,  7, }, // Asia/Jayapura
    {  328, 1290,   83815,  8, }, // Asia/Jerusalem
    {  328, 3560,   83823,  5, }, // Asia/Kabul
    {  328, 4316,   83828,  8, }, // Asia/Kamchatka
    {  328, 4239,   83836,  5, }, // Asia/Karachi
    {  328, 1185,   83841,  7, }, // Asia/Kathmandu
    {  328, 8661,   83848,  6, }, // Asia/Khandyga
    {  328,  992,   83854,  7, }, // Asia/Kolkata
    {  328, 4197,   83861, 15, }, // Asia/Krasnoyarsk
    {  328, 4859,   83876, 13, }, // Asia/Kuala_Lumpur
    {  328, 5976,   83889,  6, }, // Asia/Kuching
    {  328, 5547,   83895,  5, }, // Asia/Kuwait
    {  328, 1211,   83900,  4, }, // Asia/Macau
    {  328, 4017,   83904,  6, }, // Asia/Magadan
    {  328, 1349,   83910,  7, }, // Asia/Makassar
    {  328, 7182,   83917,  5, }, // Asia/Manila
    {  328, 6920,   83922,  5, }, // Asia/Muscat
    {  328, 2554,   83927,  8, }, // Asia/Nicosia
    {  328, 8675,   83935, 15, }, // Asia/Novokuznetsk
    {  328, 4135,   83950, 15, }, // Asia/Novosibirsk
    {  328, 4229,   83965,  6, }, // Asia/Omsk
    {  328, 7145,   83971,  3, }, // Asia/Oral
    {  328, 6961,   83974, 11, }, // Asia/Phnom_Penh
    {  328, 8693,   83985, 10, }, // Asia/Pontianak
    {  328, 4214,   83995, 10, }, // Asia/Pyongyang
    {  328, 5559,   84005,  4, }, // Asia/Qatar
    {  328, 8708,   84009,  8, }, // Asia/Qostanay
    {  328, 4269,   84017, 10, }, // Asia/Qyzylorda
    {  328, 3584,   84027,  5, }, // Asia/Riyadh
    {  328, 4408,   84032,  6, }, // Asia/Sakhalin
    {  328, 7245,   84038,  7, }, // Asia/Samarkand
    {  328, 3279,   84045,  4, }, // Asia/Seoul
    {  328, 1053,   84049,  6, }, // Asia/Shanghai
    {  328, 3300,   84055,  8, }, // Asia/Singapore
    {  328, 4297,   84063, 17, }, // Asia/Srednekolymsk
    {  328, 3263,   84080,  6, }, // Asia/Taipei
    {  328, 4781,   84086,  8, }, // Asia/Tashkent
    {  328, 3915,   84094,  6, }, // Asia/Tbilisi
    {  328, 2772,   84100,  6, }, // Asia/Tehran
    {  328, 1317,   84106,  6, }, // Asia/Thimphu
    {  328, 2821,   84112,  6, }, // Asia/Tokyo
    {  328, 4572,   84118,  6, }, // Asia/Tomsk
    {  328, 1021,   84124,  8, }, // Asia/Ulaanbaatar
    {  328, 1159,   84132,  7, }, // Asia/Urumqi
    {  328, 8722,   84139,  9, }, // Asia/Ust-Nera
    {  328, 6977,   84148, 10, }, // Asia/Vientiane
    {  328, 4710,   84158, 13, }, // Asia/Vladivostok
    {  328, 4828,   84171,  7, }, // Asia/Yakutsk
    {  328, 1235,   84178,  5, }, // Asia/Yangon
    {  328, 3883,   84183, 13, }, // Asia/Yekaterinburg
    {  328, 3747,   84196,  7, }, // Asia/Yerevan
    {  328, 3663,   84203,  6, }, // Atlantic/Azores
    {  328, 5671,   84209,  7, }, // Atlantic/Bermuda
    {  328, 6628,   84216,  6, }, // Atlantic/Canary
    {  328, 3727,   84222,  9, }, // Atlantic/Cape_Verde
    {  328, 1395,   84231,  4, }, // Atlantic/Faroe
    {  328, 8736,   84235,  5, }, // Atlantic/Madeira
    {  328, 2748,   84240,  8, }, // Atlantic/Reykjavik
    {  328, 7272,   84248, 17, }, // Atlantic/South_Georgia
    {  328, 6821,   84265, 11, }, // Atlantic/St_Helena
    {  328, 6644,   84276,  7, }, // Atlantic/Stanley
    {  328, 1670,   84283,  7, }, // Australia/Adelaide
    {  328, 1635,   84290,  8, }, // Australia/Brisbane
    {  328, 1799,   84298, 10, }, // Australia/Broken_Hill
    {  328, 1583,   84308,  7, }, // Australia/Darwin
    {  328, 3637,   84315,  5, }, // Australia/Eucla
    {  328, 1516,   84320,  7, }, // Australia/Hobart
    {  328, 8753,   84327,  9, }, // Australia/Lindeman
    {  328, 1547,   84336,  9, }, // Australia/Lord_Howe
    {  328, 1727,   84345,  8, }, // Australia/Melbourne
    {  328, 1762,   84353,  4, }, // Australia/Perth
    {  328, 1463,   84357,  5, }, // Australia/Sydney
    {  328, 6441,   84362, 10, }, // Europe/Amsterdam
    {  328, 6216,   84372,  6, }, // Europe/Andorra
    {  328, 3620,   84378,  8, }, // Europe/Astrakhan
    {  328, 2300,   84386,  5, }, // Europe/Athens
    {  328, 6336,   84391,  8, }, // Europe/Belgrade
    {  328, 4757,   84399,  6, }, // Europe/Berlin
    {  328, 6488,   84405, 11, }, // Europe/Bratislava
    {  328, 2167,   84416,  8, }, // Europe/Brussels
    {  328, 3928,   84424,  8, }, // Europe/Bucharest
    {  328, 3806,   84432,  9, }, // Europe/Budapest
    {  328, 8772,   84441,  8, }, // Europe/Busingen
    {  328, 2583,   84449,  7, }, // Europe/Chisinau
    {  328, 6289,   84456,  8, }, // Europe/Copenhagen
    {  328, 2338,   84464,  5, }, // Europe/Dublin
    {  328, 6307,   84469, 10, }, // Europe/Gibraltar
    {  328, 8788,   84479,  6, }, // Europe/Guernsey
    {  328, 6612,   84485,  8, }, // Europe/Helsinki
    {  328, 8804,   84493, 10, }, // Europe/Isle_of_Man
    {  328, 1130,   84503,  9, }, // Europe/Istanbul
    {  328, 8823,   84512,  5, }, // Europe/Jersey
    {  328, 3979,   84517, 12, }, // Europe/Kaliningrad
    {  328, 8929,   84529,  5, }, // Europe/Kirov
    {  328, 2527,   84534,  3, }, // Europe/Kyiv
    {  328, 3213,   84537,  6, }, // Europe/Lisbon
    {  328, 6506,   84543, 10, }, // Europe/Ljubljana
    {  328, 2501,   84553,  4, }, // Europe/London
    {  328, 6365,   84557,  9, }, // Europe/Luxembourg
    {  328, 4892,   84566,  7, }, // Europe/Madrid
    {  328, 6397,   84573,  6, }, // Europe/Malta
    {  328, 6582,   84579,  7, }, // Europe/Mariehamn
    {  328, 3693,   84586,  6, }, // Europe/Minsk
    {  328, 6410,   84592,  6, }, // Europe/Monaco
    {  328, 3537,   84598,  6, }, // Europe/Moscow
    {  328, 6458,   84604,  5, }, // Europe/Oslo
    {  328, 4284,   84609,  5, }, // Europe/Paris
    {  328, 6424,   84614,  9, }, // Europe/Podgorica
    {  328, 6275,   84623,  5, }, // Europe/Prague
    {  328, 8837,   84628,  4, }, // Europe/Riga
    {  328, 6324,   83366,  3, }, // Europe/Rome
    {  328, 4331,   84632,  5, }, // Europe/Samara
    {  328, 6470,   84637, 10, }, // Europe/San_Marino
    {  328, 6245,   84647,  8, }, // Europe/Sarajevo
    {  328, 4451,   84655,  7, }, // Europe/Saratov
    {  328, 8849,   84662, 11, }, // Europe/Simferopol
    {  328, 6383,   84673,  7, }, // Europe/Skopje
    {  328, 6599,   84680,  6, }, // Europe/Sofia
    {  328, 6523,   84686,  8, }, // Europe/Stockholm
    {  328, 8867,   84694,  6, }, // Europe/Tallinn
    {  328, 6202,   84700,  6, }, // Europe/Tirane
    {  328, 8882,   84706, 10, }, // Europe/Ulyanovsk
    {  328, 6352,   84716,  5, }, // Europe/Vaduz
    {  328, 6567,   84721,  6, }, // Europe/Vatican
    {  328, 6231,   84727,  6, }, // Europe/Vienna
    {  328, 8899,   84733,  8, }, // Europe/Vilnius
    {  328, 4727,   84741, 11, }, // Europe/Volgograd
    {  328, 3190,   84752,  5, }, // Europe/Warsaw
    {  328, 6261,   84757,  6, }, // Europe/Zagreb
    {  328, 6540,   84763,  5, }, // Europe/Zurich
    {  328, 5078,   84768, 12, }, // Indian/Antananarivo
    {  328, 6947,   84780,  5, }, // Indian/Chagos
    {  328, 6046,   84785,  7, }, // Indian/Christmas
    {  328, 6063,   84792,  5, }, // Indian/Cocos
    {  328, 5029,   84797,  6, }, // Indian/Comoro
    {  328, 6661,   84803, 10, }, // Indian/Kerguelen
    {  328, 7260,   84813,  4, }, // Indian/Mahe
    {  328, 7050,   84817,  8, }, // Indian/Maldives
    {  328, 4069,   84825,  8, }, // Indian/Mauritius
    {  328, 5098,   84833,  5, }, // Indian/Mayotte
    {  328, 7211,   84838,  8, }, // Indian/Reunion
    {  328, 4422,   84846,  5, }, // Pacific/Apia
    {  328,  932,   84851,  7, }, // Pacific/Auckland
    {  328, 3706,   84858, 10, }, // Pacific/Bougainville
    {  328, 3015,   84868,  3, }, // Pacific/Chatham
    {  328, 3157,   84871,  3, }, // Pacific/Chuuk
    {  328, 2237,   84874,  5, }, // Pacific/Easter
    {  328, 7360,   84879,  4, }, // Pacific/Efate
    {  328, 7327,   84883,  7, }, // Pacific/Fakaofo
    {  328, 3902,   84890,  4, }, // Pacific/Fiji
    {  328, 7343,   84894,  8, }, // Pacific/Funafuti
    {  328, 6678,   84902,  9, }, // Pacific/Galapagos
    {  328, 6696,   84911,  8, }, // Pacific/Gambier
    {  328, 3822,   84919,  8, }, // Pacific/Guadalcanal
    {  328, 6018,   84927,  5, }, // Pacific/Guam
    {  328, 2723,   84932,  8, }, // Pacific/Honolulu
    {  328, 3049,   84940,  8, }, // Pacific/Kanton
    {  328, 3998,   84948, 10, }, // Pacific/Kiritimati
    {  328, 7019,   84958,  5, }, // Pacific/Kosrae
    {  328, 2842,   84963,  9, }, // Pacific/Kwajalein
    {  328, 4877,   84972,  6, }, // Pacific/Majuro
    {  328, 4051,   84978,  9, }, // Pacific/Marquesas
    {  328, 8914,   84987,  5, }, // Pacific/Midway
    {  328, 7084,   84992,  4, }, // Pacific/Nauru
    {  328, 7132,   84996,  4, }, // Pacific/Niue
    {  328, 4168,   85000,  6, }, // Pacific/Norfolk
    {  328, 7098,   85006,  5, }, // Pacific/Noumea
    {  328, 3126,   85011,  9, }, // Pacific/Pago_Pago
    {  328, 7155,   85020,  4, }, // Pacific/Palau
    {  328, 7194,   85024,  8, }, // Pacific/Pitcairn
    {  328, 3096,   85032,  6, }, // Pacific/Pohnpei
    {  328, 4807,   85038, 14, }, // Pacific/Port_Moresby
    {  328, 6076,   85052,  9, }, // Pacific/Rarotonga
    {  328, 6031,   85061,  5, }, // Pacific/Saipan
    {  328, 7312,   85066,  6, }, // Pacific/Tahiti
    {  328, 6712,   85072,  6, }, // Pacific/Tarawa
    {  328, 4583,   85078,  9, }, // Pacific/Tongatapu
    {  328, 7392,   85087,  3, }, // Pacific/Wake
    {  328, 7405,   85090,  5, }, // Pacific/Wallis
    {  329,   14,       0,  6, }, // Africa/Asmara Gusii/Latin/Kenya
    {  329, 4435,       6,  8, }, // Africa/Sao_Tome
    {  329, 4252,      14,  8, }, // America/Asuncion
    {  329,  237,      22,  8, }, // America/Atikokan
    {  329, 7623,      30, 17, }, // America/Bahia_Banderas
    {  329, 3868,      47,  6, }, // America/Cancun
    {  329, 7774,      53, 13, }, // America/Ciudad_Juarez
    {  329, 5723,      66,  7, }, // America/Curacao
    {  329,  481,      73, 13, }, // America/Indiana/Knox
    {  329, 7961,      86, 16, }, // America/Indiana/Marengo
    {  329, 7985,     102, 19, }, // America/Indiana/Petersburg
    {  329, 8012,     121, 18, }, // America/Indiana/Tell_City
    {  329, 8038,     139, 14, }, // America/Indiana/Vevay
    {  329, 8060,     153, 18, }, // America/Indiana/Vincennes
    {  329, 8086,     171, 16, }, // America/Indiana/Winamac
    {  329, 8125,     187, 20, }, // America/Kentucky/Monticello
    {  329, 5932,     207, 22, }, // America/Lower_Princes
    {  329, 8220,     229,  6, }, // America/Merida
    {  329, 8301,     235, 20, }, // America/North_Dakota/Beulah
    {  329, 8329,     255, 20, }, // America/North_Dakota/Center
    {  329, 8357,     275, 23, }, // America/North_Dakota/New_Salem
    {  329,  393,     298,  4, }, // America/Nuuk
    {  329, 6899,     302, 16, }, // America/Scoresbysund
    {  329, 8508,     318, 14, }, // America/St_Barthelemy
    {  329, 2061,     332, 10, }, // America/St_Johns
    {  329, 5863,     342,  9, }, // America/St_Kitts
    {  329, 5880,     351,  9, }, // America/St_Lucia
    {  329,  855,     360, 10, }, // America/St_Thomas
    {  329, 5913,     370, 11, }, // America/St_Vincent
    {  329, 6133,     381, 16, }, // Antarctica/DumontDUrville
    {  329, 1259,     397, 11, }, // Asia/Ho_Chi_Minh
    {  329, 1185,     413,  9, }, // Asia/Kathmandu
    {  329,  992,     422,  7, }, // Asia/Kolkata
    {  329, 1211,     429,  5, }, // Asia/Macau
    {  329, 1235,     442,  6, }, // Asia/Yangon
    {  329, 1395,     448,  5, }, // Atlantic/Faroe
    {  329, 6821,     453, 10, }, // Atlantic/St_Helena
    {  329, 2527,     463,  4, }, // Europe/Kyiv
    {  329, 7211,     467,  7, }, // Indian/Reunion
    {  329, 3157,     474,  5, }, // Pacific/Chuuk
    {  329, 3096,     479,  7, }, // Pacific/Pohnpei
    {  330,   14,       0,  6, }, // Africa/Asmara Hausa/Latin/Nigeria
    {  330, 4435,       6,  8, }, // Africa/Sao_Tome
    {  330, 4252,      14,  8, }, // America/Asuncion
    {  330,  237,      22,  8, }, // America/Atikokan
    {  330, 7623,      30, 17, }, // America/Bahia_Banderas
    {  330, 3868,      47,  6, }, // America/Cancun
    {  330, 7774,      53, 13, }, // America/Ciudad_Juarez
    {  330, 5723,      66,  7, }, // America/Curacao
    {  330,  481,      73, 13, }, // America/Indiana/Knox
    {  330, 7961,      86, 16, }, // America/Indiana/Marengo
    {  330, 7985,     102, 19, }, // America/Indiana/Petersburg
    {  330, 8012,     121, 18, }, // America/Indiana/Tell_City
    {  330, 8038,     139, 14, }, // America/Indiana/Vevay
    {  330, 8060,     153, 18, }, // America/Indiana/Vincennes
    {  330, 8086,     171, 16, }, // America/Indiana/Winamac
    {  330, 8125,     187, 20, }, // America/Kentucky/Monticello
    {  330, 5932,     207, 22, }, // America/Lower_Princes
    {  330, 8220,     229,  6, }, // America/Merida
    {  330, 8301,   85095, 23, }, // America/North_Dakota/Beulah
    {  330, 8329,   85118, 23, }, // America/North_Dakota/Center
    {  330, 8357,   85141, 26, }, // America/North_Dakota/New_Salem
    {  330,  393,     298,  4, }, // America/Nuuk
    {  330, 6899,     302, 16, }, // America/Scoresbysund
    {  330, 8508,     318, 14, }, // America/St_Barthelemy
    {  330, 2061,     332, 10, }, // America/St_Johns
    {  330, 5863,     342,  9, }, // America/St_Kitts
    {  330, 5880,     351,  9, }, // America/St_Lucia
    {  330,  855,     360, 10, }, // America/St_Thomas
    {  330, 5913,     370, 11, }, // America/St_Vincent
    {  330, 6133,     381, 16, }, // Antarctica/DumontDUrville
    {  330, 1259,     397, 11, }, // Asia/Ho_Chi_Minh
    {  330, 1185,     413,  9, }, // Asia/Kathmandu
    {  330,  992,     422,  7, }, // Asia/Kolkata
    {  330, 1211,     429,  5, }, // Asia/Macau
    {  330, 1235,     442,  6, }, // Asia/Yangon
    {  330, 1395,     448,  5, }, // Atlantic/Faroe
    {  330, 6821,     453, 10, }, // Atlantic/St_Helena
    {  330, 2527,     463,  4, }, // Europe/Kyiv
    {  330, 7211,     467,  7, }, // Indian/Reunion
    {  330, 3157,     474,  5, }, // Pacific/Chuuk
    {  330, 3096,     479,  7, }, // Pacific/Pohnpei
    {  331, 8301,     235, 20, }, // America/North_Dakota/Beulah Hausa/Arabic/Nigeria
    {  331, 8329,     255, 20, }, // America/North_Dakota/Center
    {  331, 8357,     275, 23, }, // America/North_Dakota/New_Salem
    {  332, 8301,     235, 20, }, // America/North_Dakota/Beulah Hausa/Arabic/Sudan
    {  332, 8329,     255, 20, }, // America/North_Dakota/Center
    {  332, 8357,     275, 23, }, // America/North_Dakota/New_Salem
    {  335,   14,       0,  6, }, // Africa/Asmara Hawaiian/Latin/United States
    {  335, 4435,       6,  8, }, // Africa/Sao_Tome
    {  335, 4252,      14,  8, }, // America/Asuncion
    {  335,  237,      22,  8, }, // America/Atikokan
    {  335, 7623,      30, 17, }, // America/Bahia_Banderas
    {  335, 3868,      47,  6, }, // America/Cancun
    {  335, 7774,      53, 13, }, // America/Ciudad_Juarez
    {  335, 5723,      66,  7, }, // America/Curacao
    {  335,  481,      73, 13, }, // America/Indiana/Knox
    {  335, 7961,      86, 16, }, // America/Indiana/Marengo
    {  335, 7985,     102, 19, }, // America/Indiana/Petersburg
    {  335, 8012,     121, 18, }, // America/Indiana/Tell_City
    {  335, 8038,     139, 14, }, // America/Indiana/Vevay
    {  335, 8060,     153, 18, }, // America/Indiana/Vincennes
    {  335, 8086,     171, 16, }, // America/Indiana/Winamac
    {  335, 8125,     187, 20, }, // America/Kentucky/Monticello
    {  335, 5932,     207, 22, }, // America/Lower_Princes
    {  335, 8220,     229,  6, }, // America/Merida
    {  335, 8301,     235, 20, }, // America/North_Dakota/Beulah
    {  335, 8329,     255, 20, }, // America/North_Dakota/Center
    {  335, 8357,     275, 23, }, // America/North_Dakota/New_Salem
    {  335,  393,     298,  4, }, // America/Nuuk
    {  335, 6899,     302, 16, }, // America/Scoresbysund
    {  335, 8508,     318, 14, }, // America/St_Barthelemy
    {  335, 2061,     332, 10, }, // America/St_Johns
    {  335, 5863,     342,  9, }, // America/St_Kitts
    {  335, 5880,     351,  9, }, // America/St_Lucia
    {  335,  855,     360, 10, }, // America/St_Thomas
    {  335, 5913,     370, 11, }, // America/St_Vincent
    {  335, 6133,     381, 16, }, // Antarctica/DumontDUrville
    {  335, 1259,     397, 11, }, // Asia/Ho_Chi_Minh
    {  335, 1185,     413,  9, }, // Asia/Kathmandu
    {  335,  992,     422,  7, }, // Asia/Kolkata
    {  335, 1211,     429,  5, }, // Asia/Macau
    {  335, 1235,     442,  6, }, // Asia/Yangon
    {  335, 1395,     448,  5, }, // Atlantic/Faroe
    {  335, 6821,     453, 10, }, // Atlantic/St_Helena
    {  335, 2527,     463,  4, }, // Europe/Kyiv
    {  335, 7211,     467,  7, }, // Indian/Reunion
    {  335, 3157,     474,  5, }, // Pacific/Chuuk
    {  335, 3096,     479,  7, }, // Pacific/Pohnpei
    {  336, 6788,   85167,  7, }, // Africa/Abidjan Hebrew/Hebrew/Israel
    {  336, 6760,   85174,  4, }, // Africa/Accra
    {  336, 5059,   85178,  9, }, // Africa/Addis_Ababa
    {  336, 7420,   85187,  6, }, // Africa/Algiers
    {  336,   14,   85193,  5, }, // Africa/Asmara
    {  336,   44,   85198,  5, }, // Africa/Bamako
    {  336, 5257,   85203,  6, }, // Africa/Bangui
    {  336, 6746,   85209,  6, }, // Africa/Banjul
    {  336, 7435,   85215,  5, }, // Africa/Bissau
    {  336, 4957,   85220,  6, }, // Africa/Blantyre
    {  336, 5287,   85226,  7, }, // Africa/Brazzaville
    {  336, 4922,   85233, 10, }, // Africa/Bujumbura
    {  336, 2320,   85243,  4, }, // Africa/Cairo
    {  336, 4117,   85247,  7, }, // Africa/Casablanca
    {  336, 7449,   85254,  5, }, // Africa/Ceuta
    {  336, 6773,   85259,  7, }, // Africa/Conakry
    {  336, 6840,   85266,  4, }, // Africa/Dakar
    {  336, 5130,   85270, 10, }, // Africa/Dar_es_Salaam
    {  336, 5043,   85280,  7, }, // Africa/Djibouti
    {  336, 5243,   85287,  5, }, // Africa/Douala
    {  336, 5166,   85292,  7, }, // Africa/El_Aaiun
    {  336, 6853,   85299,  7, }, // Africa/Freetown
    {  336, 4906,   85306,  7, }, // Africa/Gaborone
    {  336, 5015,   85313,  5, }, // Africa/Harare
    {  336, 4479,   85318,  9, }, // Africa/Johannesburg
    {  336, 4499,   85327,  5, }, // Africa/Juba
    {  336, 5151,   85332,  6, }, // Africa/Kampala
    {  336, 4524,   85338,  5, }, // Africa/Khartoum
    {  336, 4973,   85343,  5, }, // Africa/Kigali
    {  336, 5306,   85348,  6, }, // Africa/Kinshasa
    {  336, 4744,   85354,  5, }, // Africa/Lagos
    {  336, 5336,   85359,  8, }, // Africa/Libreville
    {  336, 6869,   85367,  4, }, // Africa/Lome
    {  336, 5211,   85371,  6, }, // Africa/Luanda
    {  336, 4939,   85377,  9, }, // Africa/Lubumbashi
    {  336, 5001,   85386,  5, }, // Africa/Lusaka
    {  336, 5322,   85391,  4, }, // Africa/Malabo
    {  336, 4987,   85395,  6, }, // Africa/Maputo
    {  336, 5197,   85401,  4, }, // Africa/Maseru
    {  336, 5182,   85405,  5, }, // Africa/Mbabane
    {  336, 5113,   85410,  7, }, // Africa/Mogadishu
    {  336, 7034,   85417,  8, }, // Africa/Monrovia
    {  336, 3853,   85425,  7, }, // Africa/Nairobi
    {  336, 5271,   85432,  6, }, // Africa/Ndjamena
    {  336, 5354,   85438,  6, }, // Africa/Niamey
    {  336, 6803,   85444,  8, }, // Africa/Nouakchott
    {  336, 6727,   85452,  9, }, // Africa/Ouagadougou
    {  336, 5225,   85461, 10, }, // Africa/Porto-Novo
    {  336, 4435,   85471,  8, }, // Africa/Sao_Tome
    {  336, 2866,   85479,  7, }, // Africa/Tripoli
    {  336, 6554,   85486,  5, }, // Africa/Tunis
    {  336, 4152,   85491,  7, }, // Africa/Windhoek
    {  336,  132,   85498,  4, }, // America/Adak
    {  336, 3346,   85502,  7, }, // America/Anchorage
    {  336, 5607,   85509,  8, }, // America/Anguilla
    {  336, 5624,   85517,  8, }, // America/Antigua
    {  336, 4554,   85525,  9, }, // America/Araguaina
    {  336,  166,   85534, 12, }, // America/Argentina/Buenos_Aires
    {  336,   91,   85546,  6, }, // America/Argentina/Catamarca
    {  336,  270,   85552,  7, }, // America/Argentina/Cordoba
    {  336,  441,   85559,  5, }, // America/Argentina/Jujuy
    {  336, 7462,   85564,  8, }, // America/Argentina/La_Rioja
    {  336,  565,   85572,  6, }, // America/Argentina/Mendoza
    {  336, 7489,   85578, 11, }, // America/Argentina/Rio_Gallegos
    {  336, 7520,   85589,  4, }, // America/Argentina/Salta
    {  336, 7544,   85593,  7, }, // America/Argentina/San_Juan
    {  336, 5580,   85600,  8, }, // America/Argentina/San_Luis
    {  336, 7571,   85608,  6, }, // America/Argentina/Tucuman
    {  336, 7597,   85614,  8, }, // America/Argentina/Ushuaia
    {  336, 5640,   85622,  5, }, // America/Aruba
    {  336, 4252,   85627,  8, }, // America/Asuncion
    {  336,  237,   85635,  7, }, // America/Atikokan
    {  336, 3679,   85642,  5, }, // America/Bahia
    {  336, 7623,   85647, 11, }, // America/Bahia_Banderas
    {  336, 5654,   85658,  6, }, // America/Barbados
    {  336, 7646,   85664,  3, }, // America/Belem
    {  336, 5407,   85667,  4, }, // America/Belize
    {  336, 7660,   85671, 10, }, // America/Blanc-Sablon
    {  336, 7681,   85681, 10, }, // America/Boa_Vista
    {  336, 4361,   85691,  6, }, // America/Bogota
    {  336, 7699,   85697,  5, }, // America/Boise
    {  336, 7713,   85702, 14, }, // America/Cambridge_Bay
    {  336, 7735,   85716, 10, }, // America/Campo_Grande
    {  336, 3868,   85726,  5, }, // America/Cancun
    {  336, 4694,   85731,  5, }, // America/Caracas
    {  336, 4345,   85736,  5, }, // America/Cayenne
    {  336, 5496,   85741,  5, }, // America/Cayman
    {  336, 2260,   85746,  5, }, // America/Chicago
    {  336, 7756,   85751,  9, }, // America/Chihuahua
    {  336, 7774,   85760, 11, }, // America/Ciudad_Juarez
    {  336, 5422,   85771, 10, }, // America/Costa_Rica
    {  336, 7796,   85781,  6, }, // America/Creston
    {  336, 3791,   85787,  6, }, // America/Cuiaba
    {  336, 5723,   85793,  7, }, // America/Curacao
    {  336, 7812,   85800, 10, }, // America/Danmarkshavn
    {  336, 7833,   85810,  5, }, // America/Dawson
    {  336, 7848,   85815, 10, }, // America/Dawson_Creek
    {  336,  805,   85825,  5, }, // America/Denver
    {  336, 3465,   85830,  6, }, // America/Detroit
    {  336, 5739,   85836,  8, }, // America/Dominica
    {  336,  893,   85844,  8, }, // America/Edmonton
    {  336, 7869,   85852,  7, }, // America/Eirunepe
    {  336, 5441,   85859,  9, }, // America/El_Salvador
    {  336, 7886,   85868, 10, }, // America/Fort_Nelson
    {  336, 7906,   85878,  8, }, // America/Fortaleza
    {  336, 7924,   85886,  9, }, // America/Glace_Bay
    {  336, 6881,   85895,  7, }, // America/Goose_Bay
    {  336, 4612,   85902,  9, }, // America/Grand_Turk
    {  336, 5770,   85721,  5, }, // America/Grenada
    {  336, 5786,   85911,  7, }, // America/Guadeloupe
    {  336, 3760,   85918,  7, }, // America/Guatemala
    {  336, 4841,   85925,  8, }, // America/Guayaquil
    {  336, 6932,   85933,  5, }, // America/Guyana
    {  336, 1939,   85938,  6, }, // America/Halifax
    {  336, 2281,   85944,  6, }, // America/Havana
    {  336, 7942,   85950,  7, }, // America/Hermosillo
    {  336,  348,   85957, 12, }, // America/Indiana/Indianapolis
    {  336,  481,   85969, 14, }, // America/Indiana/Knox
    {  336, 7961,   85983, 15, }, // America/Indiana/Marengo
    {  336, 7985,   85998, 19, }, // America/Indiana/Petersburg
    {  336, 8012,   86017, 17, }, // America/Indiana/Tell_City
    {  336, 8038,   86034, 17, }, // America/Indiana/Vevay
    {  336, 8060,   86051, 16, }, // America/Indiana/Vincennes
    {  336, 8086,   86067, 16, }, // America/Indiana/Winamac
    {  336, 8110,   86083,  7, }, // America/Inuvik
    {  336,  660,   86090,  8, }, // America/Iqaluit
    {  336, 2799,   86098,  7, }, // America/Jamaica
    {  336, 5380,   86105,  5, }, // America/Juneau
    {  336,  521,   86110,  8, }, // America/Kentucky/Louisville
    {  336, 8125,   86118, 17, }, // America/Kentucky/Monticello
    {  336, 5704,   86135,  8, }, // America/Kralendijk
    {  336, 4376,   86143,  6, }, // America/La_Paz
    {  336, 7169,   86149,  4, }, // America/Lima
    {  336, 3239,   86153, 10, }, // America/Los_Angeles
    {  336, 5932,   86163, 20, }, // America/Lower_Princes
    {  336, 8153,   86183,  6, }, // America/Maceio
    {  336, 8168,   86189,  6, }, // America/Managua
    {  336, 1908,   86195,  5, }, // America/Manaus
    {  336, 5897,   86200,  5, }, // America/Marigot
    {  336, 5805,   86205,  7, }, // America/Martinique
    {  336, 8184,   86212,  7, }, // America/Matamoros
    {  336, 2917,   86219,  5, }, // America/Mazatlan
    {  336, 8202,   86224,  7, }, // America/Menominee
    {  336, 8220,   86231,  5, }, // America/Merida
    {  336, 8235,   86236,  7, }, // America/Metlakatla
    {  336, 2949,   86243, 11, }, // America/Mexico_City
    {  336, 4391,   86254,  6, }, // America/Miquelon
    {  336, 8254,   86260,  7, }, // America/Moncton
    {  336, 8270,   86267,  7, }, // America/Monterrey
    {  336, 4098,   86274, 10, }, // America/Montevideo
    {  336, 5824,   86284,  7, }, // America/Montserrat
    {  336, 5481,   86291,  4, }, // America/Nassau
    {  336, 2379,   86295,  8, }, // America/New_York
    {  336, 8288,   86303,  3, }, // America/Nome
    {  336, 1850,   86306,  7, }, // America/Noronha
    {  336, 8301,   86313, 20, }, // America/North_Dakota/Beulah
    {  336, 8329,   86333, 19, }, // America/North_Dakota/Center
    {  336, 8357,   86352, 24, }, // America/North_Dakota/New_Salem
    {  336,  393,   86376,  5, }, // America/Nuuk
    {  336, 8388,   86381,  9, }, // America/Ojinaga
    {  336, 2356,   86390,  4, }, // America/Panama
    {  336, 6173,   86394,  7, }, // America/Paramaribo
    {  336, 2973,   86401,  6, }, // America/Phoenix
    {  336, 3945,   86407, 13, }, // America/Port-au-Prince
    {  336, 5954,   86420, 14, }, // America/Port_of_Spain
    {  336, 8404,   86434, 10, }, // America/Porto_Velho
    {  336, 5843,   86444, 11, }, // America/Puerto_Rico
    {  336, 4030,   86455, 10, }, // America/Punta_Arenas
    {  336, 8424,   86465, 11, }, // America/Rankin_Inlet
    {  336, 8445,   86476,  5, }, // America/Recife
    {  336, 1995,   86481,  6, }, // America/Regina
    {  336, 8460,   86487,  6, }, // America/Resolute
    {  336,  695,   86493,  9, }, // America/Rio_Branco
    {  336, 8477,   86502,  5, }, // America/Santarem
    {  336, 2201,   86507,  7, }, // America/Santiago
    {  336, 6111,   86514, 12, }, // America/Santo_Domingo
    {  336, 1878,   86526,  9, }, // America/Sao_Paulo
    {  336, 6899,   86535, 11, }, // America/Scoresbysund
    {  336, 8494,   86546,  5, }, // America/Sitka
    {  336, 8508,   86551, 10, }, // America/St_Barthelemy
    {  336, 2061,   86561,  9, }, // America/St_Johns
    {  336, 5863,   86570,  8, }, // America/St_Kitts
    {  336, 5880,   86578,  9, }, // America/St_Lucia
    {  336,  855,   86587,  9, }, // America/St_Thomas
    {  336, 5913,   86596, 10, }, // America/St_Vincent
    {  336, 8530,   86606, 11, }, // America/Swift_Current
    {  336, 5461,   86617,  9, }, // America/Tegucigalpa
    {  336, 5756,   86626,  4, }, // America/Thule
    {  336,  313,   86630,  7, }, // America/Tijuana
    {  336,  608,   86637,  7, }, // America/Toronto
    {  336, 5688,   86644,  7, }, // America/Tortola
    {  336, 2093,   86651,  6, }, // America/Vancouver
    {  336, 2144,   86657,  9, }, // America/Whitehorse
    {  336,  734,   86666,  7, }, // America/Winnipeg
    {  336, 8552,   86673,  6, }, // America/Yakutat
    {  336, 6001,   86679,  5, }, // Antarctica/Casey
    {  336, 6094,   86684,  6, }, // Antarctica/Davis
    {  336, 6133,   86690, 15, }, // Antarctica/DumontDUrville
    {  336, 8568,   86705,  7, }, // Antarctica/Macquarie
    {  336, 7066,   86712,  5, }, // Antarctica/Mawson
    {  336, 7113,   86717,  7, }, // Antarctica/McMurdo
    {  336, 8589,   86724,  5, }, // Antarctica/Palmer
    {  336, 7226,   86729,  6, }, // Antarctica/Rothera
    {  336, 7295,   86735,  6, }, // Antarctica/Syowa
    {  336, 8607,   86741,  4, }, // Antarctica/Troll
    {  336, 7374,   86745,  6, }, // Antarctica/Vostok
    {  336, 1429,   86751, 10, }, // Arctic/Longyearbyen
    {  336, 5570,   86761,  3, }, // Asia/Aden
    {  336, 5395,   86764,  6, }, // Asia/Almaty
    {  336, 3968,   86770,  4, }, // Asia/Amman
    {  336, 5511,   86774,  5, }, // Asia/Anadyr
    {  336, 5523,   86779,  5, }, // Asia/Aqtau
    {  336, 5368,   86784,  6, }, // Asia/Aqtobe
    {  336,  964,   86790,  5, }, // Asia/Ashgabat
    {  336, 8624,   86795,  6, }, // Asia/Atyrau
    {  336, 3607,   86801,  4, }, // Asia/Baghdad
    {  336, 5534,   86805,  6, }, // Asia/Bahrain
    {  336, 3653,   86811,  4, }, // Asia/Baku
    {  336, 4466,   86815,  6, }, // Asia/Bangkok
    {  336, 3571,   86821,  6, }, // Asia/Barnaul
    {  336, 4086,   86827,  6, }, // Asia/Beirut
    {  336, 3778,   86833,  5, }, // Asia/Bishkek
    {  336, 5989,   86838,  6, }, // Asia/Brunei
    {  336, 4601,   86844,  5, }, // Asia/Chita
    {  336, 4511,   86849,  7, }, // Asia/Colombo
    {  336, 4540,   86856,  4, }, // Asia/Damascus
    {  336, 1093,   86860,  4, }, // Asia/Dhaka
    {  336, 6192,   86864,  4, }, // Asia/Dili
    {  336, 3596,   86868,  5, }, // Asia/Dubai
    {  336, 6159,   86873,  6, }, // Asia/Dushanbe
    {  336, 8636,   86879,  7, }, // Asia/Famagusta
    {  336, 8651,   86886,  3, }, // Asia/Gaza
    {  336, 4795,   86889,  5, }, // Asia/Hebron
    {  336, 1259,   86894, 15, }, // Asia/Ho_Chi_Minh
    {  336, 2704,   86909,  9, }, // Asia/Hong_Kong
    {  336, 4771,   86918,  4, }, // Asia/Hovd
    {  336, 4184,   86922,  8, }, // Asia/Irkutsk
    {  336, 7006,   86930,  6, }, // Asia/Jakarta
    {  336, 6992,   86936,  9, }, // Asia/Jayapura
    {  336, 1290,   86945,  7, }, // Asia/Jerusalem
    {  336, 3560,   86952,  5, }, // Asia/Kabul
    {  336, 4316,   86957,  7, }, // Asia/Kamchatka
    {  336, 4239,   86964,  6, }, // Asia/Karachi
    {  336, 1185,   86970,  6, }, // Asia/Kathmandu
    {  336, 8661,   86976,  6, }, // Asia/Khandyga
    {  336,  992,   86982,  6, }, // Asia/Kolkata
    {  336, 4197,   86988, 10, }, // Asia/Krasnoyarsk
    {  336, 4859,   86998, 12, }, // Asia/Kuala_Lumpur
    {  336, 5976,   87010,  7, }, // Asia/Kuching
    {  336, 5547,   87017,  5, }, // Asia/Kuwait
    {  336, 1211,   87022,  4, }, // Asia/Macau
    {  336, 4017,   87026,  4, }, // Asia/Magadan
    {  336, 1349,   87030,  7, }, // Asia/Makassar
    {  336, 7182,   87037,  5, }, // Asia/Manila
    {  336, 6920,   87042,  5, }, // Asia/Muscat
    {  336, 2554,   87047,  7, }, // Asia/Nicosia
    {  336, 8675,   87054, 11, }, // Asia/Novokuznetsk
    {  336, 4135,   87065, 11, }, // Asia/Novosibirsk
    {  336, 4229,   87076,  5, }, // Asia/Omsk
    {  336, 7145,   87081,  4, }, // Asia/Oral
    {  336, 6961,   87085,  7, }, // Asia/Phnom_Penh
    {  336, 8693,   87092,  8, }, // Asia/Pontianak
    {  336, 4214,   87100,  9, }, // Asia/Pyongyang
    {  336, 5559,   87109,  4, }, // Asia/Qatar
    {  336, 8708,   87113,  7, }, // Asia/Qostanay
    {  336, 4269,   87120,  9, }, // Asia/Qyzylorda
    {  336, 3584,   87129,  4, }, // Asia/Riyadh
    {  336, 4408,   87133,  5, }, // Asia/Sakhalin
    {  336, 7245,   87138,  6, }, // Asia/Samarkand
    {  336, 3279,   87144,  5, }, // Asia/Seoul
    {  336, 1053,   87149,  5, }, // Asia/Shanghai
    {  336, 3300,   87154,  7, }, // Asia/Singapore
    {  336, 4297,   87161, 13, }, // Asia/Srednekolymsk
    {  336, 3263,   87174,  6, }, // Asia/Taipei
    {  336, 4781,   87180,  5, }, // Asia/Tashkent
    {  336, 3915,   87185,  7, }, // Asia/Tbilisi
    {  336, 2772,   87192,  4, }, // Asia/Tehran
    {  336, 1317,   87196,  7, }, // Asia/Thimphu
    {  336, 2821,   87203,  5, }, // Asia/Tokyo
    {  336, 4572,   87208,  5, }, // Asia/Tomsk
    {  336, 1021,   87213, 11, }, // Asia/Ulaanbaatar
    {  336, 1159,   87224,  7, }, // Asia/Urumqi
    {  336, 8722,   87231,  8, }, // Asia/Ust-Nera
    {  336, 6977,   87239,  8, }, // Asia/Vientiane
    {  336, 4710,   87247, 10, }, // Asia/Vladivostok
    {  336, 4828,   87257,  6, }, // Asia/Yakutsk
    {  336, 1235,   87263,  5, }, // Asia/Yangon
    {  336, 3883,   87268, 10, }, // Asia/Yekaterinburg
    {  336, 3747,   87278,  6, }, // Asia/Yerevan
    {  336, 3663,   87284, 14, }, // Atlantic/Azores
    {  336, 5671,   87298,  6, }, // Atlantic/Bermuda
    {  336, 6628,   87304, 13, }, // Atlantic/Canary
    {  336, 3727,   87317,  7, }, // Atlantic/Cape_Verde
    {  336, 1395,   87324,  4, }, // Atlantic/Faroe
    {  336, 8736,   87328,  6, }, // Atlantic/Madeira
    {  336, 2748,   87334, 10, }, // Atlantic/Reykjavik
    {  336, 7272,   87344, 13, }, // Atlantic/South_Georgia
    {  336, 6821,   87357,  8, }, // Atlantic/St_Helena
    {  336, 6644,   87365,  5, }, // Atlantic/Stanley
    {  336, 1670,   87370,  6, }, // Australia/Adelaide
    {  336, 1635,   87376,  8, }, // Australia/Brisbane
    {  336, 1799,   87384,  9, }, // Australia/Broken_Hill
    {  336, 1583,   87393,  6, }, // Australia/Darwin
    {  336, 3637,   87399,  5, }, // Australia/Eucla
    {  336, 1516,   87404,  5, }, // Australia/Hobart
    {  336, 8753,   87409,  6, }, // Australia/Lindeman
    {  336, 1547,   87415, 12, }, // Australia/Lord_Howe
    {  336, 1727,   87427,  6, }, // Australia/Melbourne
    {  336, 1762,   87433,  4, }, // Australia/Perth
    {  336, 1463,   87437,  5, }, // Australia/Sydney
    {  336, 6441,   87442,  7, }, // Europe/Amsterdam
    {  336, 6216,   87449,  6, }, // Europe/Andorra
    {  336, 3620,   87455,  6, }, // Europe/Astrakhan
    {  336, 2300,   87461,  5, }, // Europe/Athens
    {  336, 6336,   87466,  5, }, // Europe/Belgrade
    {  336, 4757,   87471,  5, }, // Europe/Berlin
    {  336, 6488,   87476,  8, }, // Europe/Bratislava
    {  336, 2167,   87484,  5, }, // Europe/Brussels
    {  336, 3928,   87489,  6, }, // Europe/Bucharest
    {  336, 3806,   87495,  6, }, // Europe/Budapest
    {  336, 8772,   87501,  7, }, // Europe/Busingen
    {  336, 2583,   87508,  6, }, // Europe/Chisinau
    {  336, 6289,   87514,  7, }, // Europe/Copenhagen
    {  336, 2338,   87521,  5, }, // Europe/Dublin
    {  336, 6307,   87526,  7, }, // Europe/Gibraltar
    {  336, 8788,   87533,  5, }, // Europe/Guernsey
    {  336, 6612,   87538,  7, }, // Europe/Helsinki
    {  336, 8804,   87545,  7, }, // Europe/Isle_of_Man
    {  336, 1130,   87552,  8, }, // Europe/Istanbul
    {  336, 8823,   87560,  5, }, // Europe/Jersey
    {  336, 3979,   87565,  9, }, // Europe/Kaliningrad
    {  336, 8929,   87574,  5, }, // Europe/Kirov
    {  336, 2527,   87579,  4, }, // Europe/Kyiv
    {  336, 3213,   87583,  6, }, // Europe/Lisbon
    {  336, 6506,   87589,  8, }, // Europe/Ljubljana
    {  336, 2501,   87597,  6, }, // Europe/London
    {  336, 6365,   87603,  9, }, // Europe/Luxembourg
    {  336, 4892,   87612,  5, }, // Europe/Madrid
    {  336, 6397,   87617,  4, }, // Europe/Malta
    {  336, 6582,   87621,  8, }, // Europe/Mariehamn
    {  336, 3693,   87629,  5, }, // Europe/Minsk
    {  336, 6410,   87634,  5, }, // Europe/Monaco
    {  336, 3537,   87639,  6, }, // Europe/Moscow
    {  336, 6458,   87645,  5, }, // Europe/Oslo
    {  336, 4284,   87650,  4, }, // Europe/Paris
    {  336, 6424,   87654,  9, }, // Europe/Podgorica
    {  336, 6275,   87663,  4, }, // Europe/Prague
    {  336, 8837,   87667,  4, }, // Europe/Riga
    {  336, 6324,   87671,  4, }, // Europe/Rome
    {  336, 4331,   85194,  4, }, // Europe/Samara
    {  336, 6470,   87675,  8, }, // Europe/San_Marino
    {  336, 6245,   87683,  6, }, // Europe/Sarajevo
    {  336, 4451,   87689,  6, }, // Europe/Saratov
    {  336, 8849,   87695,  9, }, // Europe/Simferopol
    {  336, 6383,   87704,  6, }, // Europe/Skopje
    {  336, 6599,   87710,  5, }, // Europe/Sofia
    {  336, 6523,   87715,  8, }, // Europe/Stockholm
    {  336, 8867,   87723,  5, }, // Europe/Tallinn
    {  336, 6202,   87728,  5, }, // Europe/Tirane
    {  336, 8882,   87733, 10, }, // Europe/Ulyanovsk
    {  336, 6352,   87743,  5, }, // Europe/Vaduz
    {  336, 6567,   87748,  7, }, // Europe/Vatican
    {  336, 6231,   87755,  4, }, // Europe/Vienna
    {  336, 8899,   87759,  5, }, // Europe/Vilnius
    {  336, 4727,   87764,  8, }, // Europe/Volgograd
    {  336, 3190,   87772,  4, }, // Europe/Warsaw
    {  336, 6261,   87776,  5, }, // Europe/Zagreb
    {  336, 6540,   87781,  5, }, // Europe/Zurich
    {  336, 5078,   87786,  9, }, // Indian/Antananarivo
    {  336, 6947,   87795,  6, }, // Indian/Chagos
    {  336, 6046,   87801, 11, }, // Indian/Christmas
    {  336, 6063,   87812,  5, }, // Indian/Cocos
    {  336, 5029,   87817,  6, }, // Indian/Comoro
    {  336, 6661,   87823,  7, }, // Indian/Kerguelen
    {  336, 7260,   87830,  3, }, // Indian/Mahe
    {  336, 7050,   87833, 15, }, // Indian/Maldives
    {  336, 4069,   87848,  9, }, // Indian/Mauritius
    {  336, 5098,   87857,  5, }, // Indian/Mayotte
    {  336, 7211,   87862,  7, }, // Indian/Reunion
    {  336, 4422,   87869,  4, }, // Pacific/Apia
    {  336,  932,   87873,  6, }, // Pacific/Auckland
    {  336, 3706,   87879,  8, }, // Pacific/Bougainville
    {  336, 3015,   87887,  7, }, // Pacific/Chatham
    {  336, 3157,   87894,  4, }, // Pacific/Chuuk
    {  336, 2237,   87898,  8, }, // Pacific/Easter
    {  336, 7360,   87906,  4, }, // Pacific/Efate
    {  336, 7327,   87910,  6, }, // Pacific/Fakaofo
    {  336, 3902,   87916,  5, }, // Pacific/Fiji
    {  336, 7343,   87921,  7, }, // Pacific/Funafuti
    {  336, 6678,   87928,  7, }, // Pacific/Galapagos
    {  336, 6696,   87935, 10, }, // Pacific/Gambier
    {  336, 3822,   87945,  9, }, // Pacific/Guadalcanal
    {  336, 6018,   87954,  4, }, // Pacific/Guam
    {  336, 2723,   87958,  8, }, // Pacific/Honolulu
    {  336, 3049,   87966,  8, }, // Pacific/Kanton
    {  336, 3998,   87974, 10, }, // Pacific/Kiritimati
    {  336, 7019,   87984,  5, }, // Pacific/Kosrae
    {  336, 2842,   87989, 10, }, // Pacific/Kwajalein
    {  336, 4877,   87999,  7, }, // Pacific/Majuro
    {  336, 4051,   88006,  9, }, // Pacific/Marquesas
    {  336, 8914,   88015,  7, }, // Pacific/Midway
    {  336, 7084,   88022,  5, }, // Pacific/Nauru
    {  336, 7132,   88027,  5, }, // Pacific/Niue
    {  336, 4168,   88032,  6, }, // Pacific/Norfolk
    {  336, 7098,   88038,  5, }, // Pacific/Noumea
    {  336, 3126,   88043,  9, }, // Pacific/Pago_Pago
    {  336, 7155,   88052,  4, }, // Pacific/Palau
    {  336, 7194,   88056,  6, }, // Pacific/Pitcairn
    {  336, 3096,   88062,  6, }, // Pacific/Pohnpei
    {  336, 4807,   88068, 11, }, // Pacific/Port_Moresby
    {  336, 6076,   88079,  9, }, // Pacific/Rarotonga
    {  336, 6031,   88088,  6, }, // Pacific/Saipan
    {  336, 7312,   88094,  5, }, // Pacific/Tahiti
    {  336, 6712,   88099,  7, }, // Pacific/Tarawa
    {  336, 4583,   88106,  8, }, // Pacific/Tongatapu
    {  336, 7392,   88114,  4, }, // Pacific/Wake
    {  336, 7405,   88118,  5, }, // Pacific/Wallis
    {  337, 6788,   29832,  7, }, // Africa/Abidjan Hindi/Devanagari/India
    {  337, 6760,   88123,  5, }, // Africa/Accra
    {  337, 5059,   88128, 10, }, // Africa/Addis_Ababa
    {  337, 7420,   88138,  9, }, // Africa/Algiers
    {  337,   14,   88147,  7, }, // Africa/Asmara
    {  337,   44,   88154,  6, }, // Africa/Bamako
    {  337, 5257,   88160,  6, }, // Africa/Bangui
    {  337, 6746,   88166,  6, }, // Africa/Banjul
    {  337, 7435,   88172,  5, }, // Africa/Bissau
    {  337, 4957,   88177,  9, }, // Africa/Blantyre
    {  337, 5287,   88186, 11, }, // Africa/Brazzaville
    {  337, 4922,   88197,  9, }, // Africa/Bujumbura
    {  337, 2320,   88206,  5, }, // Africa/Cairo
    {  337, 4117,   29933, 11, }, // Africa/Casablanca
    {  337, 7449,   88211,  5, }, // Africa/Ceuta
    {  337, 6773,   88216,  8, }, // Africa/Conakry
    {  337, 6840,   88224,  4, }, // Africa/Dakar
    {  337, 5130,   88228, 11, }, // Africa/Dar_es_Salaam
    {  337, 5043,   88239,  6, }, // Africa/Djibouti
    {  337, 5243,   88245,  5, }, // Africa/Douala
    {  337, 5166,   88250,  8, }, // Africa/El_Aaiun
    {  337, 6853,   88258,  9, }, // Africa/Freetown
    {  337, 4906,   88267,  7, }, // Africa/Gaborone
    {  337, 5015,   88274,  5, }, // Africa/Harare
    {  337, 4479,   88279, 10, }, // Africa/Johannesburg
    {  337, 4499,   30022,  4, }, // Africa/Juba
    {  337, 5151,   88289,  6, }, // Africa/Kampala
    {  337, 4524,   30034,  7, }, // Africa/Khartoum
    {  337, 4973,   88295,  6, }, // Africa/Kigali
    {  337, 5306,   88301,  7, }, // Africa/Kinshasa
    {  337, 4744,   88308,  5, }, // Africa/Lagos
    {  337, 5336,   88313, 10, }, // Africa/Libreville
    {  337, 6869,   88323,  3, }, // Africa/Lome
    {  337, 5211,   88326,  6, }, // Africa/Luanda
    {  337, 4939,   88332,  9, }, // Africa/Lubumbashi
    {  337, 5001,   30089,  6, }, // Africa/Lusaka
    {  337, 5322,   88341,  5, }, // Africa/Malabo
    {  337, 4987,   88346,  6, }, // Africa/Maputo
    {  337, 5197,   30107,  6, }, // Africa/Maseru
    {  337, 5182,   88352,  7, }, // Africa/Mbabane
    {  337, 5113,   88359,  8, }, // Africa/Mogadishu
    {  337, 7034,   88367,  9, }, // Africa/Monrovia
    {  337, 3853,   88376,  6, }, // Africa/Nairobi
    {  337, 5271,   88382, 10, }, // Africa/Ndjamena
    {  337, 5354,   88392,  6, }, // Africa/Niamey
    {  337, 6803,   88398,  7, }, // Africa/Nouakchott
    {  337, 6727,   88405,  7, }, // Africa/Ouagadougou
    {  337, 5225,   88412, 11, }, // Africa/Porto-Novo
    {  337, 4435,   88423,  7, }, // Africa/Sao_Tome
    {  337, 2866,   88430,  8, }, // Africa/Tripoli
    {  337, 6554,   30196,  7, }, // Africa/Tunis
    {  337, 4152,   88438,  7, }, // Africa/Windhoek
    {  337,  132,   88445,  3, }, // America/Adak
    {  337, 3346,   30215,  6, }, // America/Anchorage
    {  337, 5607,   88448,  8, }, // America/Anguilla
    {  337, 5624,   88456,  7, }, // America/Antigua
    {  337, 4554,   88463,  9, }, // America/Araguaina
    {  337,  166,   88472, 11, }, // America/Argentina/Buenos_Aires
    {  337,   91,   30258, 10, }, // America/Argentina/Catamarca
    {  337,  270,   88483,  8, }, // America/Argentina/Cordoba
    {  337,  441,   88491,  5, }, // America/Argentina/Jujuy
    {  337, 7462,   88496,  8, }, // America/Argentina/La_Rioja
    {  337,  565,   88504,  8, }, // America/Argentina/Mendoza
    {  337, 7489,   88512, 12, }, // America/Argentina/Rio_Gallegos
    {  337, 7520,   30305,  6, }, // America/Argentina/Salta
    {  337, 7544,   88524,  9, }, // America/Argentina/San_Juan
    {  337, 5580,   88533,  7, }, // America/Argentina/San_Luis
    {  337, 7571,   88540,  6, }, // America/Argentina/Tucuman
    {  337, 7597,   88546,  7, }, // America/Argentina/Ushuaia
    {  337, 5640,   88553,  5, }, // America/Aruba
    {  337, 4252,   88558,  8, }, // America/Asuncion
    {  337,  237,   88566,  8, }, // America/Atikokan
    {  337, 3679,   88574,  5, }, // America/Bahia
    {  337, 7623,   88579, 15, }, // America/Bahia_Banderas
    {  337, 5654,   88594,  8, }, // America/Barbados
    {  337, 7646,   30394,  5, }, // America/Belem
    {  337, 5407,   88602,  6, }, // America/Belize
    {  337, 7660,   88608, 13, }, // America/Blanc-Sablon
    {  337, 7681,   88621, 10, }, // America/Boa_Vista
    {  337, 4361,   88631,  6, }, // America/Bogota
    {  337, 7699,   88637,  5, }, // America/Boise
    {  337, 7713,   88642, 15, }, // America/Cambridge_Bay
    {  337, 7735,   88657, 13, }, // America/Campo_Grande
    {  337, 3868,   88670,  6, }, // America/Cancun
    {  337, 4694,   88676,  6, }, // America/Caracas
    {  337, 4345,   30477,  5, }, // America/Cayenne
    {  337, 5496,   30482,  5, }, // America/Cayman
    {  337, 2260,   88682,  6, }, // America/Chicago
    {  337, 7756,   88688,  8, }, // America/Chihuahua
    {  337, 7774,   88696, 16, }, // America/Ciudad_Juarez
    {  337, 5422,   88712, 11, }, // America/Costa_Rica
    {  337, 7796,   30510,  8, }, // America/Creston
    {  337, 3791,   88723,  7, }, // America/Cuiaba
    {  337, 5723,   88730,  7, }, // America/Curacao
    {  337, 7812,   88737, 11, }, // America/Danmarkshavn
    {  337, 7833,   88748,  4, }, // America/Dawson
    {  337, 7848,   88752, 10, }, // America/Dawson_Creek
    {  337,  805,   88762,  5, }, // America/Denver
    {  337, 3465,   88767,  8, }, // America/Detroit
    {  337, 5739,   88775,  8, }, // America/Dominica
    {  337,  893,   88783,  6, }, // America/Edmonton
    {  337, 7869,   30591,  7, }, // America/Eirunepe
    {  337, 5441,   88789, 11, }, // America/El_Salvador
    {  337, 7886,   88800, 13, }, // America/Fort_Nelson
    {  337, 7906,   88813, 12, }, // America/Fortaleza
    {  337, 7924,   88825, 11, }, // America/Glace_Bay
    {  337, 6881,   88836,  9, }, // America/Goose_Bay
    {  337, 4612,   88845, 11, }, // America/Grand_Turk
    {  337, 5770,   30657,  8, }, // America/Grenada
    {  337, 5786,   88856,  9, }, // America/Guadeloupe
    {  337, 3760,   30674, 10, }, // America/Guatemala
    {  337, 4841,   88865,  9, }, // America/Guayaquil
    {  337, 6932,   88874,  5, }, // America/Guyana
    {  337, 1939,   88879, 10, }, // America/Halifax
    {  337, 2281,   88889,  5, }, // America/Havana
    {  337, 7942,   88894, 11, }, // America/Hermosillo
    {  337,  348,   88905, 13, }, // America/Indiana/Indianapolis
    {  337,  481,   88918, 15, }, // America/Indiana/Knox
    {  337, 7961,   88933, 17, }, // America/Indiana/Marengo
    {  337, 7985,   88950, 20, }, // America/Indiana/Petersburg
    {  337, 8012,   88970, 18, }, // America/Indiana/Tell_City
    {  337, 8038,   88988, 14, }, // America/Indiana/Vevay
    {  337, 8060,   89002, 18, }, // America/Indiana/Vincennes
    {  337, 8086,   89020, 17, }, // America/Indiana/Winamac
    {  337, 8110,   30867,  6, }, // America/Inuvik
    {  337,  660,   89037,  7, }, // America/Iqaluit
    {  337, 2799,   89044,  5, }, // America/Jamaica
    {  337, 5380,   89049,  7, }, // America/Juneau
    {  337,  521,   89056,  8, }, // America/Kentucky/Louisville
    {  337, 8125,   89064, 17, }, // America/Kentucky/Monticello
    {  337, 5704,   89081, 12, }, // America/Kralendijk
    {  337, 4376,   89093,  7, }, // America/La_Paz
    {  337, 7169,   30932,  4, }, // America/Lima
    {  337, 3239,   89100, 11, }, // America/Los_Angeles
    {  337, 5932,   89111, 22, }, // America/Lower_Princes
    {  337, 8153,   89133,  5, }, // America/Maceio
    {  337, 8168,   89138,  7, }, // America/Managua
    {  337, 1908,   89145,  4, }, // America/Manaus
    {  337, 5897,   89149,  7, }, // America/Marigot
    {  337, 5805,   89156,  9, }, // America/Martinique
    {  337, 8184,   89165,  9, }, // America/Matamoros
    {  337, 2917,   89174,  9, }, // America/Mazatlan
    {  337, 8202,   89183,  8, }, // America/Menominee
    {  337, 8220,   31026,  6, }, // America/Merida
    {  337, 8235,   89191, 12, }, // America/Metlakatla
    {  337, 2949,   89203, 13, }, // America/Mexico_City
    {  337, 4391,   89216,  7, }, // America/Miquelon
    {  337, 8254,   89223,  6, }, // America/Moncton
    {  337, 8270,   89229,  9, }, // America/Monterrey
    {  337, 4098,   89238, 11, }, // America/Montevideo
    {  337, 5824,   89249,  9, }, // America/Montserrat
    {  337, 5481,   89258,  5, }, // America/Nassau
    {  337, 2379,   89263,  9, }, // America/New_York
    {  337, 8288,   89185,  3, }, // America/Nome
    {  337, 1850,   89272,  8, }, // America/Noronha
    {  337, 8301,   89280, 20, }, // America/North_Dakota/Beulah
    {  337, 8329,   89300, 19, }, // America/North_Dakota/Center
    {  337, 8357,   89319, 24, }, // America/North_Dakota/New_Salem
    {  337,  393,   89343,  3, }, // America/Nuuk
    {  337, 8388,   89346,  9, }, // America/Ojinaga
    {  337, 2356,   89355,  5, }, // America/Panama
    {  337, 6173,   89360, 10, }, // America/Paramaribo
    {  337, 2973,   89370,  8, }, // America/Phoenix
    {  337, 3945,   89378, 14, }, // America/Port-au-Prince
    {  337, 5954,   89392, 15, }, // America/Port_of_Spain
    {  337, 8404,   89407, 13, }, // America/Porto_Velho
    {  337, 5843,   89420, 11, }, // America/Puerto_Rico
    {  337, 4030,   89431, 12, }, // America/Punta_Arenas
    {  337, 8424,   89443, 12, }, // America/Rankin_Inlet
    {  337, 8445,   89455,  7, }, // America/Recife
    {  337, 1995,   31299,  6, }, // America/Regina
    {  337, 8460,   89462,  9, }, // America/Resolute
    {  337,  695,   89471, 12, }, // America/Rio_Branco
    {  337, 8477,   89483,  8, }, // America/Santarem
    {  337, 2201,   89491,  9, }, // America/Santiago
    {  337, 6111,   89500, 13, }, // America/Santo_Domingo
    {  337, 1878,   89513,  9, }, // America/Sao_Paulo
    {  337, 6899,   89522, 13, }, // America/Scoresbysund
    {  337, 8494,   89535,  6, }, // America/Sitka
    {  337, 8508,   89541, 15, }, // America/St_Barthelemy
    {  337, 2061,   89556,  9, }, // America/St_Johns
    {  337, 5863,   89565, 10, }, // America/St_Kitts
    {  337, 5880,   89575, 11, }, // America/St_Lucia
    {  337,  855,   89586,  9, }, // America/St_Thomas
    {  337, 5913,   89595, 12, }, // America/St_Vincent
    {  337, 8530,   89607, 13, }, // America/Swift_Current
    {  337, 5461,   89620, 11, }, // America/Tegucigalpa
    {  337, 5756,   89631,  6, }, // America/Thule
    {  337,  313,   89637,  7, }, // America/Tijuana
    {  337,  608,   89644,  6, }, // America/Toronto
    {  337, 5688,   89650,  8, }, // America/Tortola
    {  337, 2093,   89658,  7, }, // America/Vancouver
    {  337, 2144,   89665, 11, }, // America/Whitehorse
    {  337,  734,   89676,  7, }, // America/Winnipeg
    {  337, 8552,   89683,  7, }, // America/Yakutat
    {  337, 6001,   31541,  4, }, // Antarctica/Casey
    {  337, 6094,   89690,  5, }, // Antarctica/Davis
    {  337, 6133,   89695, 19, }, // Antarctica/DumontDUrville
    {  337, 8568,   89714,  7, }, // Antarctica/Macquarie
    {  337, 7066,   89721,  4, }, // Antarctica/Mawson
    {  337, 7113,   89725,  9, }, // Antarctica/McMurdo
    {  337, 8589,   89734,  4, }, // Antarctica/Palmer
    {  337, 7226,   89738,  6, }, // Antarctica/Rothera
    {  337, 7295,   89744,  6, }, // Antarctica/Syowa
    {  337, 8607,   89750,  5, }, // Antarctica/Troll
    {  337, 7374,   89755,  7, }, // Antarctica/Vostok
    {  337, 1429,   89762, 13, }, // Arctic/Longyearbyen
    {  337, 5570,   89775,  4, }, // Asia/Aden
    {  337, 5395,   89779,  7, }, // Asia/Almaty
    {  337, 3968,   89786,  6, }, // Asia/Amman
    {  337, 5511,   89792,  6, }, // Asia/Anadyr
    {  337, 5523,   31646,  6, }, // Asia/Aqtau
    {  337, 5368,   89798,  6, }, // Asia/Aqtobe
    {  337,  964,   31659,  8, }, // Asia/Ashgabat
    {  337, 8624,   89804,  5, }, // Asia/Atyrau
    {  337, 3607,   89809,  5, }, // Asia/Baghdad
    {  337, 5534,   89814,  5, }, // Asia/Bahrain
    {  337, 3653,   88728,  4, }, // Asia/Baku
    {  337, 4466,   89819,  6, }, // Asia/Bangkok
    {  337, 3571,   89825,  6, }, // Asia/Barnaul
    {  337, 4086,   89831,  5, }, // Asia/Beirut
    {  337, 3778,   31704,  7, }, // Asia/Bishkek
    {  337, 5989,   89836,  7, }, // Asia/Brunei
    {  337, 4601,   89843,  6, }, // Asia/Chita
    {  337, 4511,   89849,  6, }, // Asia/Colombo
    {  337, 4540,   89855,  7, }, // Asia/Damascus
    {  337, 1093,   89862,  4, }, // Asia/Dhaka
    {  337, 6192,   89866,  4, }, // Asia/Dili
    {  337, 3596,   89870,  4, }, // Asia/Dubai
    {  337, 6159,   89874,  7, }, // Asia/Dushanbe
    {  337, 8636,   89881, 11, }, // Asia/Famagusta
    {  337, 8651,   89892,  5, }, // Asia/Gaza
    {  337, 4795,   89897,  7, }, // Asia/Hebron
    {  337, 1259,   89904, 16, }, // Asia/Ho_Chi_Minh
    {  337, 2704,   89920,  9, }, // Asia/Hong_Kong
    {  337, 4771,   89929,  5, }, // Asia/Hovd
    {  337, 4184,   89934, 10, }, // Asia/Irkutsk
    {  337, 7006,   89944,  7, }, // Asia/Jakarta
    {  337, 6992,   31811,  7, }, // Asia/Jayapura
    {  337, 1290,   89951,  6, }, // Asia/Jerusalem
    {  337, 3560,   89957,  5, }, // Asia/Kabul
    {  337, 4316,   89962,  7, }, // Asia/Kamchatka
    {  337, 4239,   31840,  5, }, // Asia/Karachi
    {  337, 1185,   89969,  8, }, // Asia/Kathmandu
    {  337, 8661,   89977,  7, }, // Asia/Khandyga
    {  337,  992,   89984,  7, }, // Asia/Kolkata
    {  337, 4197,   89991, 15, }, // Asia/Krasnoyarsk
    {  337, 4859,   90006, 10, }, // Asia/Kuala_Lumpur
    {  337, 5976,   31896,  6, }, // Asia/Kuching
    {  337, 5547,   31902,  5, }, // Asia/Kuwait
    {  337, 1211,   90016,  4, }, // Asia/Macau
    {  337, 4017,   31912,  7, }, // Asia/Magadan
    {  337, 1349,   90020,  6, }, // Asia/Makassar
    {  337, 7182,   31928,  5, }, // Asia/Manila
    {  337, 6920,   90026,  5, }, // Asia/Muscat
    {  337, 2554,   90031,  8, }, // Asia/Nicosia
    {  337, 8675,   90039, 16, }, // Asia/Novokuznetsk
    {  337, 4135,   90055, 13, }, // Asia/Novosibirsk
    {  337, 4229,   90068,  6, }, // Asia/Omsk
    {  337, 7145,   90074,  3, }, // Asia/Oral
    {  337, 6961,   90077,  9, }, // Asia/Phnom_Penh
    {  337, 8693,   90086,  9, }, // Asia/Pontianak
    {  337, 4214,   90095, 10, }, // Asia/Pyongyang
    {  337, 5559,   90105,  3, }, // Asia/Qatar
    {  337, 8708,   90108,  8, }, // Asia/Qostanay
    {  337, 4269,   90116, 11, }, // Asia/Qyzylorda
    {  337, 3584,   90127,  5, }, // Asia/Riyadh
    {  337, 4408,   90132,  6, }, // Asia/Sakhalin
    {  337, 7245,   90138,  6, }, // Asia/Samarkand
    {  337, 3279,   90144,  4, }, // Asia/Seoul
    {  337, 1053,   90148,  5, }, // Asia/Shanghai
    {  337, 3300,   32058,  8, }, // Asia/Singapore
    {  337, 4297,   90153, 16, }, // Asia/Srednekolymsk
    {  337, 3263,   90169,  6, }, // Asia/Taipei
    {  337, 4781,   90175,  6, }, // Asia/Tashkent
    {  337, 3915,   90181,  7, }, // Asia/Tbilisi
    {  337, 2772,   32104,  6, }, // Asia/Tehran
    {  337, 1317,   90188,  5, }, // Asia/Thimphu
    {  337, 2821,   90193,  6, }, // Asia/Tokyo
    {  337, 4572,   90199,  7, }, // Asia/Tomsk
    {  337, 1021,   90206,  8, }, // Asia/Ulaanbaatar
    {  337, 1159,   90214,  7, }, // Asia/Urumqi
    {  337, 8722,   90221, 10, }, // Asia/Ust-Nera
    {  337, 6977,   90231,  9, }, // Asia/Vientiane
    {  337, 4710,   90240, 13, }, // Asia/Vladivostok
    {  337, 4828,   32173,  9, }, // Asia/Yakutsk
    {  337, 1235,   32182,  5, }, // Asia/Yangon
    {  337, 3883,   90253, 13, }, // Asia/Yekaterinburg
    {  337, 3747,   90266,  7, }, // Asia/Yerevan
    {  337, 3663,   90273,  7, }, // Atlantic/Azores
    {  337, 5671,   90280,  6, }, // Atlantic/Bermuda
    {  337, 6628,   90286,  6, }, // Atlantic/Canary
    {  337, 3727,   90292,  8, }, // Atlantic/Cape_Verde
    {  337, 1395,   90300,  5, }, // Atlantic/Faroe
    {  337, 8736,   90305,  5, }, // Atlantic/Madeira
    {  337, 2748,   90310,  9, }, // Atlantic/Reykjavik
    {  337, 7272,   90319, 15, }, // Atlantic/South_Georgia
    {  337, 6821,   90334, 11, }, // Atlantic/St_Helena
    {  337, 6644,   90345,  7, }, // Atlantic/Stanley
    {  337, 1670,   90352,  6, }, // Australia/Adelaide
    {  337, 1635,   90358,  8, }, // Australia/Brisbane
    {  337, 1799,   90366, 10, }, // Australia/Broken_Hill
    {  337, 1583,   90376,  7, }, // Australia/Darwin
    {  337, 3637,   32320,  6, }, // Australia/Eucla
    {  337, 1516,   90383,  7, }, // Australia/Hobart
    {  337, 8753,   90390,  8, }, // Australia/Lindeman
    {  337, 1547,   90398, 10, }, // Australia/Lord_Howe
    {  337, 1727,   90408,  8, }, // Australia/Melbourne
    {  337, 1762,   90416,  4, }, // Australia/Perth
    {  337, 1463,   32362,  5, }, // Australia/Sydney
    {  337, 6441,   90420, 10, }, // Europe/Amsterdam
    {  337, 6216,   90430,  6, }, // Europe/Andorra
    {  337, 3620,   90436, 10, }, // Europe/Astrakhan
    {  337, 2300,   90446,  5, }, // Europe/Athens
    {  337, 6336,   32400,  8, }, // Europe/Belgrade
    {  337, 4757,   90451,  6, }, // Europe/Berlin
    {  337, 6488,   90457, 12, }, // Europe/Bratislava
    {  337, 2167,   90469,  9, }, // Europe/Brussels
    {  337, 3928,   90478, 10, }, // Europe/Bucharest
    {  337, 3806,   90488,  9, }, // Europe/Budapest
    {  337, 8772,   90497, 10, }, // Europe/Busingen
    {  337, 2583,   90507,  7, }, // Europe/Chisinau
    {  337, 6289,   90514,  9, }, // Europe/Copenhagen
    {  337, 2338,   90523,  5, }, // Europe/Dublin
    {  337, 6307,   90528, 10, }, // Europe/Gibraltar
    {  337, 8788,   90538,  6, }, // Europe/Guernsey
    {  337, 6612,   90544,  8, }, // Europe/Helsinki
    {  337, 8804,   90552, 11, }, // Europe/Isle_of_Man
    {  337, 1130,   90563,  9, }, // Europe/Istanbul
    {  337, 8823,   90572,  5, }, // Europe/Jersey
    {  337, 3979,   90577, 12, }, // Europe/Kaliningrad
    {  337, 8929,   90589,  5, }, // Europe/Kirov
    {  337, 2527,   90594,  3, }, // Europe/Kyiv
    {  337, 3213,   32558,  6, }, // Europe/Lisbon
    {  337, 6506,   90597, 11, }, // Europe/Ljubljana
    {  337, 2501,   90608,  4, }, // Europe/London
    {  337, 6365,   90612, 10, }, // Europe/Luxembourg
    {  337, 4892,   90622,  7, }, // Europe/Madrid
    {  337, 6397,   32599,  6, }, // Europe/Malta
    {  337, 6582,   90629,  9, }, // Europe/Mariehamn
    {  337, 3693,   90638,  6, }, // Europe/Minsk
    {  337, 6410,   90644,  6, }, // Europe/Monaco
    {  337, 3537,   90650,  6, }, // Europe/Moscow
    {  337, 6458,   90656,  5, }, // Europe/Oslo
    {  337, 4284,   32634,  5, }, // Europe/Paris
    {  337, 6424,   90661, 10, }, // Europe/Podgorica
    {  337, 6275,   90671,  5, }, // Europe/Prague
    {  337, 8837,   90676,  4, }, // Europe/Riga
    {  337, 6324,   90303,  3, }, // Europe/Rome
    {  337, 4331,   90680,  5, }, // Europe/Samara
    {  337, 6470,   90685, 10, }, // Europe/San_Marino
    {  337, 6245,   90695,  8, }, // Europe/Sarajevo
    {  337, 4451,   90703,  7, }, // Europe/Saratov
    {  337, 8849,   90710, 12, }, // Europe/Simferopol
    {  337, 6383,   90722,  8, }, // Europe/Skopje
    {  337, 6599,   90730,  7, }, // Europe/Sofia
    {  337, 6523,   90737,  8, }, // Europe/Stockholm
    {  337, 8867,   90745,  5, }, // Europe/Tallinn
    {  337, 6202,   90750,  6, }, // Europe/Tirane
    {  337, 8882,   90756, 12, }, // Europe/Ulyanovsk
    {  337, 6352,   90768,  6, }, // Europe/Vaduz
    {  337, 6567,   90774,  6, }, // Europe/Vatican
    {  337, 6231,   90780,  5, }, // Europe/Vienna
    {  337, 8899,   90785,  8, }, // Europe/Vilnius
    {  337, 4727,   90793, 11, }, // Europe/Volgograd
    {  337, 3190,   90804,  5, }, // Europe/Warsaw
    {  337, 6261,   90809,  8, }, // Europe/Zagreb
    {  337, 6540,   90817,  9, }, // Europe/Zurich
    {  337, 5078,   90826, 11, }, // Indian/Antananarivo
    {  337, 6947,   90837,  5, }, // Indian/Chagos
    {  337, 6046,   90842,  7, }, // Indian/Christmas
    {  337, 6063,   90849,  5, }, // Indian/Cocos
    {  337, 5029,   90854,  6, }, // Indian/Comoro
    {  337, 6661,   90860,  7, }, // Indian/Kerguelen
    {  337, 7260,   32851,  4, }, // Indian/Mahe
    {  337, 7050,   90867,  6, }, // Indian/Maldives
    {  337, 4069,   90873,  6, }, // Indian/Mauritius
    {  337, 5098,   90879,  8, }, // Indian/Mayotte
    {  337, 7211,   90887,  8, }, // Indian/Reunion
    {  337, 4422,   90895,  5, }, // Pacific/Apia
    {  337,  932,   90900,  6, }, // Pacific/Auckland
    {  337, 3706,   90906,  8, }, // Pacific/Bougainville
    {  337, 3015,   90914,  4, }, // Pacific/Chatham
    {  337, 3157,   90918,  2, }, // Pacific/Chuuk
    {  337, 2237,   90920,  5, }, // Pacific/Easter
    {  337, 7360,   90925,  5, }, // Pacific/Efate
    {  337, 7327,   90930,  9, }, // Pacific/Fakaofo
    {  337, 3902,   90939,  5, }, // Pacific/Fiji
    {  337, 7343,   90944, 12, }, // Pacific/Funafuti
    {  337, 6678,   90956,  9, }, // Pacific/Galapagos
    {  337, 6696,   90965,  7, }, // Pacific/Gambier
    {  337, 3822,   90972, 10, }, // Pacific/Guadalcanal
    {  337, 6018,   30980,  4, }, // Pacific/Guam
    {  337, 2723,   90982,  8, }, // Pacific/Honolulu
    {  337, 3049,   90990,  7, }, // Pacific/Kanton
    {  337, 3998,   33000, 10, }, // Pacific/Kiritimati
    {  337, 7019,   90997,  6, }, // Pacific/Kosrae
    {  337, 2842,   91003, 10, }, // Pacific/Kwajalein
    {  337, 4877,   91013,  6, }, // Pacific/Majuro
    {  337, 4051,   91019,  8, }, // Pacific/Marquesas
    {  337, 8914,   91027,  5, }, // Pacific/Midway
    {  337, 7084,   91032,  4, }, // Pacific/Nauru
    {  337, 7132,   91036,  4, }, // Pacific/Niue
    {  337, 4168,   91040,  7, }, // Pacific/Norfolk
    {  337, 7098,   91047,  6, }, // Pacific/Noumea
    {  337, 3126,   91053,  9, }, // Pacific/Pago_Pago
    {  337, 7155,   91062,  4, }, // Pacific/Palau
    {  337, 7194,   33078,  8, }, // Pacific/Pitcairn
    {  337, 3096,   91066,  6, }, // Pacific/Pohnpei
    {  337, 4807,   91072, 14, }, // Pacific/Port_Moresby
    {  337, 6076,   91086,  9, }, // Pacific/Rarotonga
    {  337, 6031,   91095,  6, }, // Pacific/Saipan
    {  337, 7312,   91101,  6, }, // Pacific/Tahiti
    {  337, 6712,   91107,  6, }, // Pacific/Tarawa
    {  337, 4583,   91113,  9, }, // Pacific/Tongatapu
    {  337, 7392,   33136,  3, }, // Pacific/Wake
    {  337, 7405,   33139,  5, }, // Pacific/Wallis
    {  338,   14,   91122,  6, }, // Africa/Asmara Hindi/Latin/India
    {  338, 5225,   26410, 10, }, // Africa/Porto-Novo
    {  338, 4435,   91128,  8, }, // Africa/Sao_Tome
    {  338, 4252,   61321,  8, }, // America/Asuncion
    {  338,  237,   91136, 13, }, // America/Atikokan
    {  338, 7623,    3825, 14, }, // America/Bahia_Banderas
    {  338, 7660,   44017, 12, }, // America/Blanc-Sablon
    {  338, 3868,   33182,  6, }, // America/Cancun
    {  338, 7774,   91149, 13, }, // America/Ciudad_Juarez
    {  338, 5723,   91162,  7, }, // America/Curacao
    {  338,  481,      73, 13, }, // America/Indiana/Knox
    {  338, 7961,      86, 16, }, // America/Indiana/Marengo
    {  338, 7985,     102, 19, }, // America/Indiana/Petersburg
    {  338, 8012,     121, 18, }, // America/Indiana/Tell_City
    {  338, 8038,     139, 14, }, // America/Indiana/Vevay
    {  338, 8060,     153, 18, }, // America/Indiana/Vincennes
    {  338, 8086,     171, 16, }, // America/Indiana/Winamac
    {  338, 8125,     187, 20, }, // America/Kentucky/Monticello
    {  338, 5932,     207, 22, }, // America/Lower_Princes
    {  338, 8220,    7008,  6, }, // America/Merida
    {  338, 8301,     235, 20, }, // America/North_Dakota/Beulah
    {  338, 8329,     255, 20, }, // America/North_Dakota/Center
    {  338, 8357,     275, 23, }, // America/North_Dakota/New_Salem
    {  338,  393,     298,  4, }, // America/Nuuk
    {  338, 6899,     302, 16, }, // America/Scoresbysund
    {  338, 8508,   91169, 13, }, // America/St_Barthelemy
    {  338, 2061,   60820,  9, }, // America/St_Johns
    {  338, 5863,   60829,  8, }, // America/St_Kitts
    {  338, 5880,   60837,  8, }, // America/St_Lucia
    {  338,  855,   60845,  9, }, // America/St_Thomas
    {  338, 5913,   60854, 10, }, // America/St_Vincent
    {  338, 6133,   91182, 14, }, // Antarctica/DumontDUrville
    {  338, 5523,   91196,  5, }, // Asia/Aqtau
    {  338, 1259,   91201,  6, }, // Asia/Ho_Chi_Minh
    {  338, 4771,   26703,  5, }, // Asia/Hovd
    {  338, 1185,     413,  9, }, // Asia/Kathmandu
    {  338,  992,     422,  7, }, // Asia/Kolkata
    {  338, 1211,    4203,  5, }, // Asia/Macau
    {  338, 8708,   91207,  8, }, // Asia/Qostanay
    {  338, 4269,   26765,  9, }, // Asia/Qyzylorda
    {  338, 1235,     442,  6, }, // Asia/Yangon
    {  338, 1395,   91215,  6, }, // Atlantic/Faroe
    {  338, 6821,   60864,  9, }, // Atlantic/St_Helena
    {  338, 2527,     463,  4, }, // Europe/Kyiv
    {  338, 7211,   91221,  7, }, // Indian/Reunion
    {  338, 3157,   91228,  4, }, // Pacific/Chuuk
    {  338, 2723,    4493,  8, }, // Pacific/Honolulu
    {  338, 3049,    4501,  9, }, // Pacific/Kanton
    {  338, 3096,    8311,  6, }, // Pacific/Pohnpei
    {  339, 5059,   91232, 12, }, // Africa/Addis_Ababa Hungarian/Latin/Hungary
    {  339, 7420,   91244,  5, }, // Africa/Algiers
    {  339,   14,   91249,  7, }, // Africa/Asmara
    {  339, 2320,   91256,  5, }, // Africa/Cairo
    {  339, 5130,   91261, 13, }, // Africa/Dar_es_Salaam
    {  339, 5043,   91274,  8, }, // Africa/Djibouti
    {  339, 5166,   91282,  7, }, // Africa/El_Aaiun
    {  339, 4524,   91289,  6, }, // Africa/Khartoum
    {  339, 5322,   91295,  6, }, // Africa/Malabo
    {  339, 4435,       6,  8, }, // Africa/Sao_Tome
    {  339, 6554,   91301,  6, }, // Africa/Tunis
    {  339, 4554,   26427,  9, }, // America/Araguaina
    {  339,  270,   20361,  7, }, // America/Argentina/Cordoba
    {  339, 7489,   44005, 12, }, // America/Argentina/Rio_Gallegos
    {  339, 7571,   20368,  7, }, // America/Argentina/Tucuman
    {  339, 4252,      14,  8, }, // America/Asuncion
    {  339,  237,      22,  8, }, // America/Atikokan
    {  339, 7623,    3825, 14, }, // America/Bahia_Banderas
    {  339, 7646,   35764,  5, }, // America/Belem
    {  339, 4361,   20389,  6, }, // America/Bogota
    {  339, 3868,      47,  6, }, // America/Cancun
    {  339, 5496,   91307, 15, }, // America/Cayman
    {  339, 7774,      53, 13, }, // America/Ciudad_Juarez
    {  339, 3791,   26442,  6, }, // America/Cuiaba
    {  339, 5723,      66,  7, }, // America/Curacao
    {  339, 5739,   21548,  8, }, // America/Dominica
    {  339, 7869,   26448,  8, }, // America/Eirunepe
    {  339, 5441,    6688,  8, }, // America/El_Salvador
    {  339, 2281,   63392,  7, }, // America/Havana
    {  339,  481,      73, 13, }, // America/Indiana/Knox
    {  339, 7961,      86, 16, }, // America/Indiana/Marengo
    {  339, 7985,     102, 19, }, // America/Indiana/Petersburg
    {  339, 8012,     121, 18, }, // America/Indiana/Tell_City
    {  339, 8038,     139, 14, }, // America/Indiana/Vevay
    {  339, 8060,     153, 18, }, // America/Indiana/Vincennes
    {  339, 8086,     171, 16, }, // America/Indiana/Winamac
    {  339, 8125,     187, 20, }, // America/Kentucky/Monticello
    {  339, 5932,     207, 22, }, // America/Lower_Princes
    {  339, 8153,   26456,  6, }, // America/Maceio
    {  339, 2917,   26471,  8, }, // America/Mazatlan
    {  339, 8220,     229,  6, }, // America/Merida
    {  339, 2949,   91322, 11, }, // America/Mexico_City
    {  339, 8301,   91333, 20, }, // America/North_Dakota/Beulah
    {  339, 8329,   91353, 20, }, // America/North_Dakota/Center
    {  339, 8357,   91373, 23, }, // America/North_Dakota/New_Salem
    {  339,  393,     298,  4, }, // America/Nuuk
    {  339,  695,   74255, 10, }, // America/Rio_Branco
    {  339, 1878,   26580,  9, }, // America/Sao_Paulo
    {  339, 6899,     302, 16, }, // America/Scoresbysund
    {  339, 8508,   26589, 16, }, // America/St_Barthelemy
    {  339, 2061,     332, 10, }, // America/St_Johns
    {  339, 5863,     342,  9, }, // America/St_Kitts
    {  339, 5880,     351,  9, }, // America/St_Lucia
    {  339,  855,     360, 10, }, // America/St_Thomas
    {  339, 5913,     370, 11, }, // America/St_Vincent
    {  339, 6133,     381, 16, }, // Antarctica/DumontDUrville
    {  339, 7374,   91396,  7, }, // Antarctica/Vostok
    {  339, 5570,   91403,  4, }, // Asia/Aden
    {  339, 5395,   58641,  8, }, // Asia/Almaty
    {  339, 3968,   57792,  5, }, // Asia/Amman
    {  339, 5511,    7482,  6, }, // Asia/Anadyr
    {  339, 5523,    5491,  5, }, // Asia/Aqtau
    {  339, 5368,   63474,  6, }, // Asia/Aqtobe
    {  339,  964,   26671,  7, }, // Asia/Ashgabat
    {  339, 8624,    7494,  6, }, // Asia/Atyrau
    {  339, 3607,    4044,  6, }, // Asia/Baghdad
    {  339, 5534,    4050,  7, }, // Asia/Bahrain
    {  339, 4086,   57818,  6, }, // Asia/Beirut
    {  339, 3778,   91407,  6, }, // Asia/Bishkek
    {  339, 4601,   91413,  5, }, // Asia/Chita
    {  339, 4540,   91418, 10, }, // Asia/Damascus
    {  339, 1093,   91428,  5, }, // Asia/Dhaka
    {  339, 3596,   57836,  5, }, // Asia/Dubai
    {  339, 6159,   91433,  7, }, // Asia/Dushanbe
    {  339, 8651,   91440,  4, }, // Asia/Gaza
    {  339, 1259,   91444, 16, }, // Asia/Ho_Chi_Minh
    {  339, 2704,    4113,  8, }, // Asia/Hong_Kong
    {  339, 4184,   91460,  8, }, // Asia/Irkutsk
    {  339, 1290,   91468, 10, }, // Asia/Jerusalem
    {  339, 4316,   91478,  9, }, // Asia/Kamchatka
    {  339, 4239,   91487,  7, }, // Asia/Karachi
    {  339, 1185,    5593,  8, }, // Asia/Kathmandu
    {  339, 8661,   33392,  7, }, // Asia/Khandyga
    {  339,  992,   64221,  8, }, // Asia/Kolkata
    {  339, 4197,   91494, 13, }, // Asia/Krasnoyarsk
    {  339, 5976,   91507,  7, }, // Asia/Kuching
    {  339, 5547,   63852,  6, }, // Asia/Kuwait
    {  339, 1211,   91514,  5, }, // Asia/Macau
    {  339, 4017,   20732,  7, }, // Asia/Magadan
    {  339, 1349,    7618,  7, }, // Asia/Makassar
    {  339, 6920,   91519,  7, }, // Asia/Muscat
    {  339, 8675,   91526, 12, }, // Asia/Novokuznetsk
    {  339, 4135,   91538, 13, }, // Asia/Novosibirsk
    {  339, 4229,   91551,  5, }, // Asia/Omsk
    {  339, 4214,   91556,  7, }, // Asia/Pyongyang
    {  339, 5559,    4214,  5, }, // Asia/Qatar
    {  339, 8708,   91563,  9, }, // Asia/Qostanay
    {  339, 4269,    7660,  9, }, // Asia/Qyzylorda
    {  339, 3584,   57947,  5, }, // Asia/Riyadh
    {  339, 4408,   91572,  8, }, // Asia/Sakhalin
    {  339, 7245,   91580, 10, }, // Asia/Samarkand
    {  339, 3279,   91590,  5, }, // Asia/Seoul
    {  339, 1053,   91595,  7, }, // Asia/Shanghai
    {  339, 3300,   91602,  9, }, // Asia/Singapore
    {  339, 4297,   91611, 15, }, // Asia/Srednekolymsk
    {  339, 3263,    7712,  6, }, // Asia/Taipei
    {  339, 4781,   91626,  7, }, // Asia/Tashkent
    {  339, 3915,   91633,  8, }, // Asia/Tbilisi
    {  339, 2772,   57993,  7, }, // Asia/Tehran
    {  339, 1317,   91641,  5, }, // Asia/Thimphu
    {  339, 2821,   91646,  5, }, // Asia/Tokyo
    {  339, 4572,   91651,  6, }, // Asia/Tomsk
    {  339, 1021,   91657,  9, }, // Asia/Ulaanbaatar
    {  339, 1159,   91666,  7, }, // Asia/Urumqi
    {  339, 8722,   91673, 11, }, // Asia/Ust-Nera
    {  339, 6977,   20811,  8, }, // Asia/Vientiane
    {  339, 4710,   91684, 13, }, // Asia/Vladivostok
    {  339, 4828,   91697,  8, }, // Asia/Yakutsk
    {  339, 1235,     442,  6, }, // Asia/Yangon
    {  339, 3883,   91705, 14, }, // Asia/Yekaterinburg
    {  339, 3747,   91719,  7, }, // Asia/Yerevan
    {  339, 3663,   91726, 14, }, // Atlantic/Azores
    {  339, 6628,   91740, 15, }, // Atlantic/Canary
    {  339, 3727,   91755, 18, }, // Atlantic/Cape_Verde
    {  339, 1395,   91773,  6, }, // Atlantic/Faroe
    {  339, 2748,   36044,  9, }, // Atlantic/Reykjavik
    {  339, 7272,   91779, 12, }, // Atlantic/South_Georgia
    {  339, 6821,   91791, 11, }, // Atlantic/St_Helena
    {  339, 6441,   91802, 10, }, // Europe/Amsterdam
    {  339, 3620,   91812,  9, }, // Europe/Astrakhan
    {  339, 2300,   58123,  5, }, // Europe/Athens
    {  339, 6336,   91821,  7, }, // Europe/Belgrade
    {  339, 6488,   91828,  7, }, // Europe/Bratislava
    {  339, 2167,   91835,  8, }, // Europe/Brussels
    {  339, 3928,   26897,  8, }, // Europe/Bucharest
    {  339, 8772,   26905,  8, }, // Europe/Busingen
    {  339, 6289,   91843, 10, }, // Europe/Copenhagen
    {  339, 6307,   91853,  9, }, // Europe/Gibraltar
    {  339, 8804,   91862, 10, }, // Europe/Isle_of_Man
    {  339, 1130,   91872,  9, }, // Europe/Istanbul
    {  339, 3979,   91881, 12, }, // Europe/Kaliningrad
    {  339, 2527,   33591,  5, }, // Europe/Kyiv
    {  339, 3213,   91893,  9, }, // Europe/Lisbon
    {  339, 6365,    4395,  9, }, // Europe/Luxembourg
    {  339, 6397,   91902,  5, }, // Europe/Malta
    {  339, 3693,   91907,  6, }, // Europe/Minsk
    {  339, 3537,   91913,  7, }, // Europe/Moscow
    {  339, 4284,   91920,  6, }, // Europe/Paris
    {  339, 6275,   91926,  5, }, // Europe/Prague
    {  339, 6324,   91931,  4, }, // Europe/Rome
    {  339, 4331,   91935,  7, }, // Europe/Samara
    {  339, 6245,   91942,  9, }, // Europe/Sarajevo
    {  339, 4451,   91951,  8, }, // Europe/Saratov
    {  339, 8849,   91959, 11, }, // Europe/Simferopol
    {  339, 6383,   91970,  7, }, // Europe/Skopje
    {  339, 6599,   91977,  6, }, // Europe/Sofia
    {  339, 8867,   22793,  6, }, // Europe/Tallinn
    {  339, 6202,   21095,  6, }, // Europe/Tirane
    {  339, 8882,   91983, 10, }, // Europe/Ulyanovsk
    {  339, 6567,   58222,  7, }, // Europe/Vatican
    {  339, 6231,   91993,  4, }, // Europe/Vienna
    {  339, 4727,   91997,  9, }, // Europe/Volgograd
    {  339, 3190,   92006,  5, }, // Europe/Warsaw
    {  339, 6261,   92011,  6, }, // Europe/Zagreb
    {  339, 6540,    4459,  6, }, // Europe/Zurich
    {  339, 6046,   92017, 16, }, // Indian/Christmas
    {  339, 6063,   92033, 13, }, // Indian/Cocos
    {  339, 5029,   92046,  6, }, // Indian/Comoro
    {  339, 7050,   92052, 15, }, // Indian/Maldives
    {  339, 7211,     467,  7, }, // Indian/Reunion
    {  339, 3015,   92067, 16, }, // Pacific/Chatham
    {  339, 3157,   91228,  4, }, // Pacific/Chuuk
    {  339, 2237,   92083, 15, }, // Pacific/Easter
    {  339, 3902,   92098,  6, }, // Pacific/Fiji
    {  339, 6678,   92104, 18, }, // Pacific/Galapagos
    {  339, 6696,   92122, 16, }, // Pacific/Gambier
    {  339, 2723,    4493,  8, }, // Pacific/Honolulu
    {  339, 3049,    4501,  9, }, // Pacific/Kanton
    {  339, 3998,   92138, 17, }, // Pacific/Kiritimati
    {  339, 7019,   92155, 15, }, // Pacific/Kosrae
    {  339, 2842,   92170, 16, }, // Pacific/Kwajalein
    {  339, 4877,   92186, 13, }, // Pacific/Majuro
    {  339, 4051,   92199, 18, }, // Pacific/Marquesas
    {  339, 8914,   92217, 15, }, // Pacific/Midway
    {  339, 7194,   92232, 17, }, // Pacific/Pitcairn
    {  339, 3096,   92249, 15, }, // Pacific/Pohnpei
    {  339, 7392,   92264, 11, }, // Pacific/Wake
    {  340, 7420,   92275, 11, }, // Africa/Algiers Icelandic/Latin/Iceland
    {  340,   14,       0,  6, }, // Africa/Asmara
    {  340, 7435,   92286,  5, }, // Africa/Bissau
    {  340, 2320,   92291,  5, }, // Africa/Cairo
    {  340, 5043,   92296,  7, }, // Africa/Djibouti
    {  340, 4479,   92303, 14, }, // Africa/Johannesburg
    {  340, 4435,   92317,  8, }, // Africa/Sao_Tome
    {  340, 2866,   92325,  7, }, // Africa/Tripoli
    {  340, 6554,   92332,  9, }, // Africa/Tunis
    {  340, 5607,   92341,  8, }, // America/Anguilla
    {  340, 5624,   92349,  7, }, // America/Antigua
    {  340, 5640,   92356,  5, }, // America/Aruba
    {  340, 4252,      14,  8, }, // America/Asuncion
    {  340,  237,      22,  8, }, // America/Atikokan
    {  340, 7623,    3825, 14, }, // America/Bahia_Banderas
    {  340, 5407,   92361,  5, }, // America/Belize
    {  340, 3868,   92366,  6, }, // America/Cancun
    {  340, 5496,   92372, 12, }, // America/Cayman
    {  340, 7774,      53, 13, }, // America/Ciudad_Juarez
    {  340, 5422,   92384,  9, }, // America/Costa_Rica
    {  340, 5723,      66,  7, }, // America/Curacao
    {  340, 5739,   92393,  8, }, // America/Dominica
    {  340, 5786,   92401,  8, }, // America/Guadeloupe
    {  340, 3760,   33206,  9, }, // America/Guatemala
    {  340, 6932,   92409,  7, }, // America/Guyana
    {  340,  481,      73, 13, }, // America/Indiana/Knox
    {  340, 7961,      86, 16, }, // America/Indiana/Marengo
    {  340, 7985,     102, 19, }, // America/Indiana/Petersburg
    {  340, 8012,     121, 18, }, // America/Indiana/Tell_City
    {  340, 8038,     139, 14, }, // America/Indiana/Vevay
    {  340, 8060,     153, 18, }, // America/Indiana/Vincennes
    {  340, 8086,     171, 16, }, // America/Indiana/Winamac
    {  340, 2799,   92416,  7, }, // America/Jamaica
    {  340, 8125,     187, 20, }, // America/Kentucky/Monticello
    {  340, 5932,     207, 22, }, // America/Lower_Princes
    {  340, 5805,   92423,  8, }, // America/Martinique
    {  340, 8220,    7008,  6, }, // America/Merida
    {  340, 2949,   92431, 10, }, // America/Mexico_City
    {  340, 8301,     235, 20, }, // America/North_Dakota/Beulah
    {  340, 8329,     255, 20, }, // America/North_Dakota/Center
    {  340, 8357,     275, 23, }, // America/North_Dakota/New_Salem
    {  340,  393,     298,  4, }, // America/Nuuk
    {  340, 5843,   92441, 11, }, // America/Puerto_Rico
    {  340, 6899,     302, 16, }, // America/Scoresbysund
    {  340, 8508,   92452, 25, }, // America/St_Barthelemy
    {  340, 2061,     332, 10, }, // America/St_Johns
    {  340, 5863,   92477, 12, }, // America/St_Kitts
    {  340, 5880,   92489, 12, }, // America/St_Lucia
    {  340,  855,   92501, 13, }, // America/St_Thomas
    {  340, 5913,   92514, 14, }, // America/St_Vincent
    {  340, 5688,   92528,  7, }, // America/Tortola
    {  340, 6133,     381, 16, }, // Antarctica/DumontDUrville
    {  340, 3607,    4044,  6, }, // Asia/Baghdad
    {  340, 5534,   63842,  6, }, // Asia/Bahrain
    {  340, 3653,   20629,  4, }, // Asia/Baku
    {  340, 4086,   92535,  6, }, // Asia/Beirut
    {  340, 5989,   92541,  6, }, // Asia/Brunei
    {  340, 4511,   92547,  7, }, // Asia/Colombo
    {  340, 4540,    4083,  8, }, // Asia/Damascus
    {  340, 1093,   91428,  5, }, // Asia/Dhaka
    {  340, 1259,   92554, 16, }, // Asia/Ho_Chi_Minh
    {  340, 7006,    4129,  8, }, // Asia/Jakarta
    {  340, 1290,   92570,  9, }, // Asia/Jerusalem
    {  340, 3560,   92579,  5, }, // Asia/Kabul
    {  340, 4316,    4143, 10, }, // Asia/Kamchatka
    {  340, 1185,   20712,  8, }, // Asia/Kathmandu
    {  340,  992,   92584,  8, }, // Asia/Kolkata
    {  340, 4859,   92592, 12, }, // Asia/Kuala_Lumpur
    {  340, 5547,   92604,  6, }, // Asia/Kuwait
    {  340, 1211,   91514,  5, }, // Asia/Macau
    {  340, 2554,   92610,  7, }, // Asia/Nicosia
    {  340, 4214,   33430,  9, }, // Asia/Pyongyang
    {  340, 5559,    4214,  5, }, // Asia/Qatar
    {  340, 8708,     434,  8, }, // Asia/Qostanay
    {  340, 3584,   92617,  5, }, // Asia/Riyadh
    {  340, 3279,   20778,  4, }, // Asia/Seoul
    {  340, 1053,   92622,  7, }, // Asia/Shanghai
    {  340, 3300,   92629,  8, }, // Asia/Singapore
    {  340, 2772,    7724,  7, }, // Asia/Tehran
    {  340, 2821,   92637,  5, }, // Asia/Tokyo
    {  340, 1021,   92642, 10, }, // Asia/Ulaanbaatar
    {  340, 1235,   20819,  6, }, // Asia/Yangon
    {  340, 3747,    7780,  7, }, // Asia/Yerevan
    {  340, 3663,   92652,  9, }, // Atlantic/Azores
    {  340, 5671,   92661,  7, }, // Atlantic/Bermuda
    {  340, 6628,   92668, 11, }, // Atlantic/Canary
    {  340, 3727,   92679, 14, }, // Atlantic/Cape_Verde
    {  340, 1395,   92693,  8, }, // Atlantic/Faroe
    {  340, 2748,   36044,  9, }, // Atlantic/Reykjavik
    {  340, 7272,   92701, 13, }, // Atlantic/South_Georgia
    {  340, 6821,   92714, 13, }, // Atlantic/St_Helena
    {  340, 2300,   92727,  5, }, // Europe/Athens
    {  340, 6336,   26883,  7, }, // Europe/Belgrade
    {  340, 4757,   20941,  6, }, // Europe/Berlin
    {  340, 2167,    4332,  7, }, // Europe/Brussels
    {  340, 3928,   92732,  8, }, // Europe/Bucharest
    {  340, 3806,   92740,  8, }, // Europe/Budapest
    {  340, 6289,   92748, 13, }, // Europe/Copenhagen
    {  340, 6307,   92761,  9, }, // Europe/Gibraltar
    {  340, 8804,   92770,  3, }, // Europe/Isle_of_Man
    {  340, 1130,   92773,  8, }, // Europe/Istanbul
    {  340, 2527,   92781, 10, }, // Europe/Kyiv
    {  340, 3213,    4381,  8, }, // Europe/Lisbon
    {  340, 2501,   92791,  8, }, // Europe/London
    {  340, 6365,   92799,  9, }, // Europe/Luxembourg
    {  340, 4892,   92808,  6, }, // Europe/Madrid
    {  340, 6582,   92814,  9, }, // Europe/Mariehamn
    {  340, 6410,   92823,  6, }, // Europe/Monaco
    {  340, 3537,   22748,  6, }, // Europe/Moscow
    {  340, 6458,   92829,  4, }, // Europe/Oslo
    {  340, 4284,   21062,  5, }, // Europe/Paris
    {  340, 6275,    8083,  4, }, // Europe/Prague
    {  340, 6324,   91931,  3, }, // Europe/Rome
    {  340, 6470,   92833, 10, }, // Europe/San_Marino
    {  340, 6245,   92843,  8, }, // Europe/Sarajevo
    {  340, 6599,   92851,  5, }, // Europe/Sofia
    {  340, 6523,   92856, 11, }, // Europe/Stockholm
    {  340, 6202,   92867,  6, }, // Europe/Tirane
    {  340, 6567,   92873,  9, }, // Europe/Vatican
    {  340, 6231,   92882,  3, }, // Europe/Vienna
    {  340, 8899,   92885,  7, }, // Europe/Vilnius
    {  340, 3190,   92892,  6, }, // Europe/Warsaw
    {  340, 6046,   92898,  6, }, // Indian/Christmas
    {  340, 6063,   92904, 10, }, // Indian/Cocos
    {  340, 7050,   92914, 11, }, // Indian/Maldives
    {  340, 4069,   92925,  8, }, // Indian/Mauritius
    {  340, 7211,     467,  7, }, // Indian/Reunion
    {  340, 3157,     474,  5, }, // Pacific/Chuuk
    {  340, 2237,   92933,  9, }, // Pacific/Easter
    {  340, 3902,   92942,  5, }, // Pacific/Fiji
    {  340, 6018,   63240,  4, }, // Pacific/Guam
    {  340, 2723,    4493,  8, }, // Pacific/Honolulu
    {  340, 3049,    4501,  9, }, // Pacific/Kanton
    {  340, 4051,   92947, 15, }, // Pacific/Marquesas
    {  340, 7084,   92962,  4, }, // Pacific/Nauru
    {  340, 7155,   92966,  4, }, // Pacific/Palau
    {  340, 3096,     479,  7, }, // Pacific/Pohnpei
    {  340, 7312,   92970,  6, }, // Pacific/Tahiti
    {  341,   14,       0,  6, }, // Africa/Asmara Ido/Latin/world
    {  341, 4435,       6,  8, }, // Africa/Sao_Tome
    {  341, 4252,      14,  8, }, // America/Asuncion
    {  341,  237,      22,  8, }, // America/Atikokan
    {  341, 7623,      30, 17, }, // America/Bahia_Banderas
    {  341, 3868,      47,  6, }, // America/Cancun
    {  341, 7774,      53, 13, }, // America/Ciudad_Juarez
    {  341, 5723,      66,  7, }, // America/Curacao
    {  341,  481,      73, 13, }, // America/Indiana/Knox
    {  341, 7961,      86, 16, }, // America/Indiana/Marengo
    {  341, 7985,     102, 19, }, // America/Indiana/Petersburg
    {  341, 8012,     121, 18, }, // America/Indiana/Tell_City
    {  341, 8038,     139, 14, }, // America/Indiana/Vevay
    {  341, 8060,     153, 18, }, // America/Indiana/Vincennes
    {  341, 8086,     171, 16, }, // America/Indiana/Winamac
    {  341, 8125,     187, 20, }, // America/Kentucky/Monticello
    {  341, 5932,     207, 22, }, // America/Lower_Princes
    {  341, 8220,     229,  6, }, // America/Merida
    {  341, 8301,     235, 20, }, // America/North_Dakota/Beulah
    {  341, 8329,     255, 20, }, // America/North_Dakota/Center
    {  341, 8357,     275, 23, }, // America/North_Dakota/New_Salem
    {  341,  393,     298,  4, }, // America/Nuuk
    {  341, 6899,     302, 16, }, // America/Scoresbysund
    {  341, 8508,     318, 14, }, // America/St_Barthelemy
    {  341, 2061,     332, 10, }, // America/St_Johns
    {  341, 5863,     342,  9, }, // America/St_Kitts
    {  341, 5880,     351,  9, }, // America/St_Lucia
    {  341,  855,     360, 10, }, // America/St_Thomas
    {  341, 5913,     370, 11, }, // America/St_Vincent
    {  341, 6133,     381, 16, }, // Antarctica/DumontDUrville
    {  341, 1259,     397, 11, }, // Asia/Ho_Chi_Minh
    {  341, 1185,     413,  9, }, // Asia/Kathmandu
    {  341,  992,     422,  7, }, // Asia/Kolkata
    {  341, 1211,     429,  5, }, // Asia/Macau
    {  341, 1235,     442,  6, }, // Asia/Yangon
    {  341, 1395,     448,  5, }, // Atlantic/Faroe
    {  341, 6821,     453, 10, }, // Atlantic/St_Helena
    {  341, 2527,     463,  4, }, // Europe/Kyiv
    {  341, 7211,     467,  7, }, // Indian/Reunion
    {  341, 3157,     474,  5, }, // Pacific/Chuuk
    {  341, 3096,     479,  7, }, // Pacific/Pohnpei
    {  342,   14,       0,  6, }, // Africa/Asmara Igbo/Latin/Nigeria
    {  342, 4435,       6,  8, }, // Africa/Sao_Tome
    {  342, 4252,      14,  8, }, // America/Asuncion
    {  342,  237,      22,  8, }, // America/Atikokan
    {  342, 7623,      30, 17, }, // America/Bahia_Banderas
    {  342, 3868,      47,  6, }, // America/Cancun
    {  342, 7774,      53, 13, }, // America/Ciudad_Juarez
    {  342, 5723,      66,  7, }, // America/Curacao
    {  342,  481,      73, 13, }, // America/Indiana/Knox
    {  342, 7961,      86, 16, }, // America/Indiana/Marengo
    {  342, 7985,     102, 19, }, // America/Indiana/Petersburg
    {  342, 8012,     121, 18, }, // America/Indiana/Tell_City
    {  342, 8038,     139, 14, }, // America/Indiana/Vevay
    {  342, 8060,     153, 18, }, // America/Indiana/Vincennes
    {  342, 8086,     171, 16, }, // America/Indiana/Winamac
    {  342, 8125,     187, 20, }, // America/Kentucky/Monticello
    {  342, 5932,     207, 22, }, // America/Lower_Princes
    {  342, 8220,     229,  6, }, // America/Merida
    {  342, 8301,     235, 20, }, // America/North_Dakota/Beulah
    {  342, 8329,     255, 20, }, // America/North_Dakota/Center
    {  342, 8357,     275, 23, }, // America/North_Dakota/New_Salem
    {  342,  393,     298,  4, }, // America/Nuuk
    {  342, 6899,     302, 16, }, // America/Scoresbysund
    {  342, 8508,     318, 14, }, // America/St_Barthelemy
    {  342, 2061,     332, 10, }, // America/St_Johns
    {  342, 5863,     342,  9, }, // America/St_Kitts
    {  342, 5880,     351,  9, }, // America/St_Lucia
    {  342,  855,     360, 10, }, // America/St_Thomas
    {  342, 5913,     370, 11, }, // America/St_Vincent
    {  342, 6133,     381, 16, }, // Antarctica/DumontDUrville
    {  342, 1259,     397, 11, }, // Asia/Ho_Chi_Minh
    {  342, 1185,     413,  9, }, // Asia/Kathmandu
    {  342,  992,     422,  7, }, // Asia/Kolkata
    {  342, 1211,     429,  5, }, // Asia/Macau
    {  342, 1235,     442,  6, }, // Asia/Yangon
    {  342, 1395,     448,  5, }, // Atlantic/Faroe
    {  342, 6821,     453, 10, }, // Atlantic/St_Helena
    {  342, 2527,     463,  4, }, // Europe/Kyiv
    {  342, 7211,     467,  7, }, // Indian/Reunion
    {  342, 3157,     474,  5, }, // Pacific/Chuuk
    {  342, 3049,    4501,  9, }, // Pacific/Kanton
    {  342, 3096,     479,  7, }, // Pacific/Pohnpei
    {  343,   14,       0,  6, }, // Africa/Asmara Inari Sami/Latin/Finland
    {  343, 4435,       6,  8, }, // Africa/Sao_Tome
    {  343, 4252,      14,  8, }, // America/Asuncion
    {  343,  237,      22,  8, }, // America/Atikokan
    {  343, 7623,      30, 17, }, // America/Bahia_Banderas
    {  343, 3868,      47,  6, }, // America/Cancun
    {  343, 7774,      53, 13, }, // America/Ciudad_Juarez
    {  343, 5723,      66,  7, }, // America/Curacao
    {  343,  481,      73, 13, }, // America/Indiana/Knox
    {  343, 7961,      86, 16, }, // America/Indiana/Marengo
    {  343, 7985,     102, 19, }, // America/Indiana/Petersburg
    {  343, 8012,     121, 18, }, // America/Indiana/Tell_City
    {  343, 8038,     139, 14, }, // America/Indiana/Vevay
    {  343, 8060,     153, 18, }, // America/Indiana/Vincennes
    {  343, 8086,     171, 16, }, // America/Indiana/Winamac
    {  343, 8125,     187, 20, }, // America/Kentucky/Monticello
    {  343, 5932,     207, 22, }, // America/Lower_Princes
    {  343, 8220,     229,  6, }, // America/Merida
    {  343, 8301,     235, 20, }, // America/North_Dakota/Beulah
    {  343, 8329,     255, 20, }, // America/North_Dakota/Center
    {  343, 8357,     275, 23, }, // America/North_Dakota/New_Salem
    {  343,  393,     298,  4, }, // America/Nuuk
    {  343, 6899,     302, 16, }, // America/Scoresbysund
    {  343, 8508,     318, 14, }, // America/St_Barthelemy
    {  343, 2061,     332, 10, }, // America/St_Johns
    {  343, 5863,     342,  9, }, // America/St_Kitts
    {  343, 5880,     351,  9, }, // America/St_Lucia
    {  343,  855,     360, 10, }, // America/St_Thomas
    {  343, 5913,     370, 11, }, // America/St_Vincent
    {  343, 6133,     381, 16, }, // Antarctica/DumontDUrville
    {  343, 1259,     397, 11, }, // Asia/Ho_Chi_Minh
    {  343, 1185,     413,  9, }, // Asia/Kathmandu
    {  343,  992,     422,  7, }, // Asia/Kolkata
    {  343, 1211,     429,  5, }, // Asia/Macau
    {  343, 1235,     442,  6, }, // Asia/Yangon
    {  343, 1395,     448,  5, }, // Atlantic/Faroe
    {  343, 6821,     453, 10, }, // Atlantic/St_Helena
    {  343, 2527,     463,  4, }, // Europe/Kyiv
    {  343, 7211,     467,  7, }, // Indian/Reunion
    {  343, 3157,     474,  5, }, // Pacific/Chuuk
    {  343, 3096,     479,  7, }, // Pacific/Pohnpei
    {  344, 7420,   92976,  5, }, // Africa/Algiers Indonesian/Latin/Indonesia
    {  344,   14,       0,  6, }, // Africa/Asmara
    {  344, 2320,    4572,  5, }, // Africa/Cairo
    {  344, 4435,       6,  8, }, // Africa/Sao_Tome
    {  344, 5607,    4657,  7, }, // America/Anguilla
    {  344, 4252,      14,  8, }, // America/Asuncion
    {  344,  237,      22,  8, }, // America/Atikokan
    {  344, 7623,    3825, 14, }, // America/Bahia_Banderas
    {  344, 3868,   33182,  6, }, // America/Cancun
    {  344, 7774,   91149, 13, }, // America/Ciudad_Juarez
    {  344, 5422,   21503, 10, }, // America/Costa_Rica
    {  344, 5723,      66,  7, }, // America/Curacao
    {  344, 5739,   21548,  8, }, // America/Dominica
    {  344,  481,      73, 13, }, // America/Indiana/Knox
    {  344, 7961,      86, 16, }, // America/Indiana/Marengo
    {  344, 7985,     102, 19, }, // America/Indiana/Petersburg
    {  344, 8012,     121, 18, }, // America/Indiana/Tell_City
    {  344, 8038,     139, 14, }, // America/Indiana/Vevay
    {  344, 8060,     153, 18, }, // America/Indiana/Vincennes
    {  344, 8086,     171, 16, }, // America/Indiana/Winamac
    {  344, 8125,     187, 20, }, // America/Kentucky/Monticello
    {  344, 5932,     207, 22, }, // America/Lower_Princes
    {  344, 5805,    5142,  8, }, // America/Martinique
    {  344, 8220,    7008,  6, }, // America/Merida
    {  344, 8301,   92981, 20, }, // America/North_Dakota/Beulah
    {  344, 8329,   93001, 20, }, // America/North_Dakota/Center
    {  344, 8357,   93021, 23, }, // America/North_Dakota/New_Salem
    {  344,  393,     298,  4, }, // America/Nuuk
    {  344, 6899,     302, 16, }, // America/Scoresbysund
    {  344, 8508,     318, 14, }, // America/St_Barthelemy
    {  344, 2061,     332, 10, }, // America/St_Johns
    {  344, 5863,     342,  9, }, // America/St_Kitts
    {  344, 5880,     351,  9, }, // America/St_Lucia
    {  344,  855,     360, 10, }, // America/St_Thomas
    {  344, 5913,     370, 11, }, // America/St_Vincent
    {  344, 6133,     381, 16, }, // Antarctica/DumontDUrville
    {  344, 5523,    5491,  5, }, // Asia/Aqtau
    {  344, 5368,    7488,  6, }, // Asia/Aqtobe
    {  344, 4511,    5519,  7, }, // Asia/Colombo
    {  344, 4540,    4083,  8, }, // Asia/Damascus
    {  344, 1259,     397, 11, }, // Asia/Ho_Chi_Minh
    {  344, 1290,    5568,  9, }, // Asia/Jerusalem
    {  344, 1185,     413,  9, }, // Asia/Kathmandu
    {  344,  992,     422,  7, }, // Asia/Kolkata
    {  344, 1211,   33405,  5, }, // Asia/Macau
    {  344, 6920,    4208,  6, }, // Asia/Muscat
    {  344, 2554,    5620,  7, }, // Asia/Nicosia
    {  344, 8708,     434,  8, }, // Asia/Qostanay
    {  344, 3300,   93044,  9, }, // Asia/Singapore
    {  344, 2772,    7724,  7, }, // Asia/Tehran
    {  344, 1235,   58486,  7, }, // Asia/Yangon
    {  344, 3727,   93053, 13, }, // Atlantic/Cape_Verde
    {  344, 1395,     448,  5, }, // Atlantic/Faroe
    {  344, 7272,   93066, 15, }, // Atlantic/South_Georgia
    {  344, 6821,     453, 10, }, // Atlantic/St_Helena
    {  344, 2300,   93081,  6, }, // Europe/Athens
    {  344, 6336,    7942,  7, }, // Europe/Belgrade
    {  344, 2583,   93087,  8, }, // Europe/Chisinau
    {  344, 6289,    4357, 10, }, // Europe/Copenhagen
    {  344, 8804,   93095,  9, }, // Europe/Isle_of_Man
    {  344, 2527,    8030,  4, }, // Europe/Kyiv
    {  344, 6365,    8054, 10, }, // Europe/Luxembourg
    {  344, 6410,    5926,  6, }, // Europe/Monaco
    {  344, 3537,   93104,  6, }, // Europe/Moscow
    {  344, 6275,   36153,  5, }, // Europe/Prague
    {  344, 6324,    5946,  4, }, // Europe/Rome
    {  344, 6567,    5978,  7, }, // Europe/Vatican
    {  344, 6231,     171,  4, }, // Europe/Vienna
    {  344, 3190,   93110,  7, }, // Europe/Warsaw
    {  344, 5029,   22853,  6, }, // Indian/Comoro
    {  344, 7050,   93117,  8, }, // Indian/Maldives
    {  344, 7211,     467,  7, }, // Indian/Reunion
    {  344, 3157,     474,  5, }, // Pacific/Chuuk
    {  344, 3822,    8242, 11, }, // Pacific/Guadalcanal
    {  344, 2723,    4493,  8, }, // Pacific/Honolulu
    {  344, 3049,    4501,  9, }, // Pacific/Kanton
    {  344, 3096,     479,  7, }, // Pacific/Pohnpei
    {  345,   14,       0,  6, }, // Africa/Asmara Interlingua/Latin/world
    {  345, 5043,   26360,  7, }, // Africa/Djibouti
    {  345, 4435,       6,  8, }, // Africa/Sao_Tome
    {  345, 4252,      14,  8, }, // America/Asuncion
    {  345,  237,      22,  8, }, // America/Atikokan
    {  345, 7623,   64558, 17, }, // America/Bahia_Banderas
    {  345, 3868,   33182,  6, }, // America/Cancun
    {  345, 5496,   44041,  6, }, // America/Cayman
    {  345, 7774,      53, 13, }, // America/Ciudad_Juarez
    {  345, 5723,      66,  7, }, // America/Curacao
    {  345,  481,      73, 13, }, // America/Indiana/Knox
    {  345, 7961,      86, 16, }, // America/Indiana/Marengo
    {  345, 7985,     102, 19, }, // America/Indiana/Petersburg
    {  345, 8012,     121, 18, }, // America/Indiana/Tell_City
    {  345, 8038,     139, 14, }, // America/Indiana/Vevay
    {  345, 8060,     153, 18, }, // America/Indiana/Vincennes
    {  345, 8086,     171, 16, }, // America/Indiana/Winamac
    {  345, 8125,     187, 20, }, // America/Kentucky/Monticello
    {  345, 5932,     207, 22, }, // America/Lower_Princes
    {  345, 5805,   20436,  9, }, // America/Martinique
    {  345, 8220,    7008,  6, }, // America/Merida
    {  345, 2949,   93125, 16, }, // America/Mexico_City
    {  345, 2379,   93141,  9, }, // America/New_York
    {  345, 8301,   44071, 23, }, // America/North_Dakota/Beulah
    {  345, 8329,   44094, 23, }, // America/North_Dakota/Center
    {  345, 8357,   44117, 26, }, // America/North_Dakota/New_Salem
    {  345,  393,     298,  4, }, // America/Nuuk
    {  345, 5843,   64866, 10, }, // America/Puerto_Rico
    {  345, 6899,     302, 16, }, // America/Scoresbysund
    {  345, 8508,   93150, 18, }, // America/St_Barthelemy
    {  345, 2061,   93168, 28, }, // America/St_Johns
    {  345, 5863,   93196, 19, }, // America/St_Kitts
    {  345, 5880,   93215, 12, }, // America/St_Lucia
    {  345,  855,   93227, 13, }, // America/St_Thomas
    {  345, 5913,   93240, 15, }, // America/St_Vincent
    {  345, 6133,     381, 16, }, // Antarctica/DumontDUrville
    {  345, 5534,    4050,  7, }, // Asia/Bahrain
    {  345, 4540,   74309,  7, }, // Asia/Damascus
    {  345, 1259,     397, 11, }, // Asia/Ho_Chi_Minh
    {  345, 2704,    4113,  8, }, // Asia/Hong_Kong
    {  345, 1185,     413,  9, }, // Asia/Kathmandu
    {  345, 8661,   57888,  8, }, // Asia/Khandyga
    {  345,  992,   35921,  8, }, // Asia/Kolkata
    {  345, 1211,     429,  5, }, // Asia/Macau
    {  345, 4408,   57952,  8, }, // Asia/Sakhalin
    {  345, 1021,   26791, 10, }, // Asia/Ulaanbaatar
    {  345, 1235,     442,  6, }, // Asia/Yangon
    {  345, 3883,    7768, 12, }, // Asia/Yekaterinburg
    {  345, 6628,   74368,  8, }, // Atlantic/Canary
    {  345, 3727,   93255, 10, }, // Atlantic/Cape_Verde
    {  345, 1395,   20874,  5, }, // Atlantic/Faroe
    {  345, 6821,     453, 10, }, // Atlantic/St_Helena
    {  345, 2300,   93265,  7, }, // Europe/Athens
    {  345, 6336,   58774,  8, }, // Europe/Belgrade
    {  345, 2167,   57529,  9, }, // Europe/Brussels
    {  345, 3928,   20955,  8, }, // Europe/Bucharest
    {  345, 8772,   26905,  8, }, // Europe/Busingen
    {  345, 8804,   93272, 13, }, // Europe/Isle_of_Man
    {  345, 2527,    8030,  4, }, // Europe/Kyiv
    {  345, 3213,   93285,  7, }, // Europe/Lisbon
    {  345, 6365,    4395,  9, }, // Europe/Luxembourg
    {  345, 3537,   74461,  7, }, // Europe/Moscow
    {  345, 6275,   21067,  5, }, // Europe/Prague
    {  345, 6324,    5946,  4, }, // Europe/Rome
    {  345, 6202,   21095,  6, }, // Europe/Tirane
    {  345, 6567,   74495,  8, }, // Europe/Vatican
    {  345, 3190,   21126,  8, }, // Europe/Warsaw
    {  345, 6046,   93292,  5, }, // Indian/Christmas
    {  345, 7050,   74517,  8, }, // Indian/Maldives
    {  345, 4069,   93297,  8, }, // Indian/Mauritius
    {  345, 5098,   93305,  7, }, // Indian/Mayotte
    {  345, 7211,     467,  7, }, // Indian/Reunion
    {  345, 3157,     474,  5, }, // Pacific/Chuuk
    {  345, 2237,   93312,  6, }, // Pacific/Easter
    {  345, 6678,   21159,  9, }, // Pacific/Galapagos
    {  345, 3096,     479,  7, }, // Pacific/Pohnpei
    {  346, 5059,   64509, 11, }, // Africa/Addis_Ababa Interlingue/Latin/Estonia
    {  346, 7420,   43956,  5, }, // Africa/Algiers
    {  346,   14,       0,  6, }, // Africa/Asmara
    {  346, 5130,   93318, 13, }, // Africa/Dar_es_Salaam
    {  346, 5043,   26360,  7, }, // Africa/Djibouti
    {  346, 5166,   93331,  8, }, // Africa/El_Aaiun
    {  346, 4524,   26372,  7, }, // Africa/Khartoum
    {  346, 6727,   26402,  8, }, // Africa/Ouagadougou
    {  346, 4435,   93339,  8, }, // Africa/Sao_Tome
    {  346,  166,   93347, 12, }, // America/Argentina/Buenos_Aires
    {  346, 7462,   93359,  8, }, // America/Argentina/La_Rioja
    {  346, 7489,   93367, 12, }, // America/Argentina/Rio_Gallegos
    {  346, 7544,   93379,  9, }, // America/Argentina/San_Juan
    {  346, 5580,   93388,  9, }, // America/Argentina/San_Luis
    {  346, 4252,      14,  8, }, // America/Asuncion
    {  346,  237,      22,  8, }, // America/Atikokan
    {  346, 7623,   93397, 15, }, // America/Bahia_Banderas
    {  346, 7681,    6514,  9, }, // America/Boa_Vista
    {  346, 7713,   93412, 13, }, // America/Cambridge_Bay
    {  346, 7735,   93425, 12, }, // America/Campo_Grande
    {  346, 3868,      47,  6, }, // America/Cancun
    {  346, 7774,   93437, 13, }, // America/Ciudad_Juarez
    {  346, 5422,   93450, 10, }, // America/Costa_Rica
    {  346, 5723,      66,  7, }, // America/Curacao
    {  346, 7848,   93460, 12, }, // America/Dawson_Creek
    {  346, 5441,   93472, 11, }, // America/El_Salvador
    {  346, 7886,    6696, 11, }, // America/Fort_Nelson
    {  346, 7924,   93483,  9, }, // America/Glace_Bay
    {  346, 6881,   93492,  9, }, // America/Goose_Bay
    {  346, 4612,   93501, 10, }, // America/Grand_Turk
    {  346, 5786,   93511,  9, }, // America/Guadeloupe
    {  346,  481,      73, 13, }, // America/Indiana/Knox
    {  346, 7961,      86, 16, }, // America/Indiana/Marengo
    {  346, 7985,     102, 19, }, // America/Indiana/Petersburg
    {  346, 8012,   93520, 18, }, // America/Indiana/Tell_City
    {  346, 8038,     139, 14, }, // America/Indiana/Vevay
    {  346, 8060,     153, 18, }, // America/Indiana/Vincennes
    {  346, 8086,     171, 16, }, // America/Indiana/Winamac
    {  346, 8125,     187, 20, }, // America/Kentucky/Monticello
    {  346, 4376,   93538,  6, }, // America/La_Paz
    {  346, 3239,   93544, 11, }, // America/Los_Angeles
    {  346, 5932,   93555, 22, }, // America/Lower_Princes
    {  346, 5805,   20436,  9, }, // America/Martinique
    {  346, 8220,     229,  6, }, // America/Merida
    {  346, 2949,   93577, 12, }, // America/Mexico_City
    {  346, 8301,   93589, 19, }, // America/North_Dakota/Beulah
    {  346, 8329,   93608, 19, }, // America/North_Dakota/Center
    {  346, 8357,   93627, 22, }, // America/North_Dakota/New_Salem
    {  346,  393,     298,  4, }, // America/Nuuk
    {  346, 5954,   26559, 13, }, // America/Port_of_Spain
    {  346, 8404,    7183, 11, }, // America/Porto_Velho
    {  346, 5843,   93649, 10, }, // America/Puerto_Rico
    {  346, 4030,    7204, 12, }, // America/Punta_Arenas
    {  346, 8424,   93659, 12, }, // America/Rankin_Inlet
    {  346,  695,   93671, 10, }, // America/Rio_Branco
    {  346, 6111,   93681, 11, }, // America/Santo_Domingo
    {  346, 1878,   93692,  9, }, // America/Sao_Paulo
    {  346, 6899,     302, 16, }, // America/Scoresbysund
    {  346, 8508,   93701, 15, }, // America/St_Barthelemy
    {  346, 2061,   93716, 10, }, // America/St_Johns
    {  346, 5863,   93726,  9, }, // America/St_Kitts
    {  346, 5880,   93735,  9, }, // America/St_Lucia
    {  346,  855,   93744, 10, }, // America/St_Thomas
    {  346, 5913,   93754, 11, }, // America/St_Vincent
    {  346, 8530,   93765, 13, }, // America/Swift_Current
    {  346, 6133,   57010, 16, }, // Antarctica/DumontDUrville
    {  346, 7295,   62088,  5, }, // Antarctica/Syowa
    {  346, 5395,    7476,  6, }, // Asia/Almaty
    {  346, 5523,    5491,  5, }, // Asia/Aqtau
    {  346, 5368,    7488,  6, }, // Asia/Aqtobe
    {  346, 8624,    7494,  6, }, // Asia/Atyrau
    {  346, 4540,   74309,  7, }, // Asia/Damascus
    {  346, 1259,   78028, 11, }, // Asia/Ho_Chi_Minh
    {  346, 2704,    7535,  9, }, // Asia/Hong_Kong
    {  346, 1185,     413,  9, }, // Asia/Kathmandu
    {  346,  992,     422,  7, }, // Asia/Kolkata
    {  346, 4859,    7589, 12, }, // Asia/Kuala_Lumpur
    {  346, 1211,     429,  5, }, // Asia/Macau
    {  346, 6961,   93778, 10, }, // Asia/Phnom_Penh
    {  346, 8708,     434,  8, }, // Asia/Qostanay
    {  346, 4269,    7660,  9, }, // Asia/Qyzylorda
    {  346, 3300,   20782,  8, }, // Asia/Singapore
    {  346, 2772,    7724,  7, }, // Asia/Tehran
    {  346, 2821,    4238,  5, }, // Asia/Tokyo
    {  346, 1235,     442,  6, }, // Asia/Yangon
    {  346, 6628,   74368,  7, }, // Atlantic/Canary
    {  346, 3727,   93788,  9, }, // Atlantic/Cape_Verde
    {  346, 1395,   20874,  5, }, // Atlantic/Faroe
    {  346, 7272,   93797, 11, }, // Atlantic/South_Georgia
    {  346, 6821,   93808, 11, }, // Atlantic/St_Helena
    {  346, 1799,   93819, 11, }, // Australia/Broken_Hill
    {  346, 1547,   93830, 15, }, // Australia/Lord_Howe
    {  346, 1762,   22603,  4, }, // Australia/Perth
    {  346, 2300,    5793,  4, }, // Europe/Athens
    {  346, 6336,   26883,  7, }, // Europe/Belgrade
    {  346, 2167,   57529,  9, }, // Europe/Brussels
    {  346, 3928,   93845,  9, }, // Europe/Bucharest
    {  346, 6289,   58525,  9, }, // Europe/Copenhagen
    {  346, 8804,   93854, 12, }, // Europe/Isle_of_Man
    {  346, 2527,    8030,  4, }, // Europe/Kyiv
    {  346, 3213,   21019,  6, }, // Europe/Lisbon
    {  346, 6365,    4395,  9, }, // Europe/Luxembourg
    {  346, 6410,   74455,  6, }, // Europe/Monaco
    {  346, 3537,   93866,  6, }, // Europe/Moscow
    {  346, 6275,   36153,  5, }, // Europe/Prague
    {  346, 6324,    5946,  4, }, // Europe/Rome
    {  346, 6470,    8096, 10, }, // Europe/San_Marino
    {  346, 6202,   21095,  6, }, // Europe/Tirane
    {  346, 3190,   58543,  8, }, // Europe/Warsaw
    {  346, 6540,    4459,  6, }, // Europe/Zurich
    {  346, 4069,   74525,  8, }, // Indian/Mauritius
    {  346, 7211,     467,  7, }, // Indian/Reunion
    {  346, 3157,     474,  5, }, // Pacific/Chuuk
    {  346, 2237,   93872,  5, }, // Pacific/Easter
    {  346, 3902,    4488,  5, }, // Pacific/Fiji
    {  346, 3126,    8295,  9, }, // Pacific/Pago_Pago
    {  346, 3096,     479,  7, }, // Pacific/Pohnpei
    {  346, 4807,   93877, 12, }, // Pacific/Port_Moresby
    {  347,   14,       0,  6, }, // Africa/Asmara Inuktitut/Canadian Aboriginal/Canada
    {  347, 4435,       6,  8, }, // Africa/Sao_Tome
    {  347, 4252,      14,  8, }, // America/Asuncion
    {  347,  237,      22,  8, }, // America/Atikokan
    {  347, 7623,      30, 17, }, // America/Bahia_Banderas
    {  347, 3868,      47,  6, }, // America/Cancun
    {  347, 7774,      53, 13, }, // America/Ciudad_Juarez
    {  347, 5723,      66,  7, }, // America/Curacao
    {  347,  481,      73, 13, }, // America/Indiana/Knox
    {  347, 7961,      86, 16, }, // America/Indiana/Marengo
    {  347, 7985,     102, 19, }, // America/Indiana/Petersburg
    {  347, 8012,     121, 18, }, // America/Indiana/Tell_City
    {  347, 8038,     139, 14, }, // America/Indiana/Vevay
    {  347, 8060,     153, 18, }, // America/Indiana/Vincennes
    {  347, 8086,     171, 16, }, // America/Indiana/Winamac
    {  347, 8125,     187, 20, }, // America/Kentucky/Monticello
    {  347, 5932,     207, 22, }, // America/Lower_Princes
    {  347, 8220,     229,  6, }, // America/Merida
    {  347, 8301,     235, 20, }, // America/North_Dakota/Beulah
    {  347, 8329,     255, 20, }, // America/North_Dakota/Center
    {  347, 8357,     275, 23, }, // America/North_Dakota/New_Salem
    {  347,  393,     298,  4, }, // America/Nuuk
    {  347, 6899,     302, 16, }, // America/Scoresbysund
    {  347, 8508,     318, 14, }, // America/St_Barthelemy
    {  347, 2061,     332, 10, }, // America/St_Johns
    {  347, 5863,     342,  9, }, // America/St_Kitts
    {  347, 5880,     351,  9, }, // America/St_Lucia
    {  347,  855,     360, 10, }, // America/St_Thomas
    {  347, 5913,     370, 11, }, // America/St_Vincent
    {  347, 6133,     381, 16, }, // Antarctica/DumontDUrville
    {  347, 1259,     397, 11, }, // Asia/Ho_Chi_Minh
    {  347, 1185,     413,  9, }, // Asia/Kathmandu
    {  347,  992,     422,  7, }, // Asia/Kolkata
    {  347, 1211,     429,  5, }, // Asia/Macau
    {  347, 1235,     442,  6, }, // Asia/Yangon
    {  347, 1395,     448,  5, }, // Atlantic/Faroe
    {  347, 6821,     453, 10, }, // Atlantic/St_Helena
    {  347, 2527,     463,  4, }, // Europe/Kyiv
    {  347, 7211,     467,  7, }, // Indian/Reunion
    {  347, 3157,     474,  5, }, // Pacific/Chuuk
    {  347, 3096,     479,  7, }, // Pacific/Pohnpei
    {  349, 7420,   93889, 20, }, // Africa/Algiers Irish/Latin/Ireland
    {  349,   14,       0,  6, }, // Africa/Asmara
    {  349, 2320,   93909,  6, }, // Africa/Cairo
    {  349, 6773,   93915,  8, }, // Africa/Conakry
    {  349, 6840,   93923,  5, }, // Africa/Dakar
    {  349, 5130,   93928,  9, }, // Africa/Dar_es_Salaam
    {  349, 5166,   93937,  6, }, // Africa/El_Aaiun
    {  349, 4524,   93943,  6, }, // Africa/Khartoum
    {  349, 6869,   20300,  4, }, // Africa/Lome
    {  349, 4987,   93949,  6, }, // Africa/Maputo
    {  349, 5113,   93955, 10, }, // Africa/Mogadishu
    {  349, 6803,   93965,  7, }, // Africa/Nouakchott
    {  349, 4435,       6,  8, }, // Africa/Sao_Tome
    {  349, 2866,   93972,  7, }, // Africa/Tripoli
    {  349, 6554,   93979,  6, }, // Africa/Tunis
    {  349, 5607,   93985,  7, }, // America/Anguilla
    {  349,  270,   20361,  7, }, // America/Argentina/Cordoba
    {  349, 5640,   92356,  5, }, // America/Aruba
    {  349, 4252,      14,  8, }, // America/Asuncion
    {  349,  237,      22,  8, }, // America/Atikokan
    {  349, 7623,    3825, 14, }, // America/Bahia_Banderas
    {  349, 5654,   93992,  8, }, // America/Barbados
    {  349, 7646,   35764,  5, }, // America/Belem
    {  349, 5407,   94000, 10, }, // America/Belize
    {  349, 4361,   94010,  6, }, // America/Bogota
    {  349, 3868,      47,  6, }, // America/Cancun
    {  349, 7774,      53, 13, }, // America/Ciudad_Juarez
    {  349, 5422,   94016, 10, }, // America/Costa_Rica
    {  349, 5723,   94026,  6, }, // America/Curacao
    {  349, 5739,   72693,  9, }, // America/Dominica
    {  349, 5441,   94032, 13, }, // America/El_Salvador
    {  349, 5770,   94045,  8, }, // America/Grenada
    {  349, 5786,   94053,  9, }, // America/Guadeloupe
    {  349, 3760,   72744,  9, }, // America/Guatemala
    {  349, 6932,   94062,  9, }, // America/Guyana
    {  349,  481,      73, 13, }, // America/Indiana/Knox
    {  349, 7961,      86, 16, }, // America/Indiana/Marengo
    {  349, 7985,     102, 19, }, // America/Indiana/Petersburg
    {  349, 8012,     121, 18, }, // America/Indiana/Tell_City
    {  349, 8038,     139, 14, }, // America/Indiana/Vevay
    {  349, 8060,     153, 18, }, // America/Indiana/Vincennes
    {  349, 8086,     171, 16, }, // America/Indiana/Winamac
    {  349, 2799,   94071,  7, }, // America/Jamaica
    {  349, 8125,     187, 20, }, // America/Kentucky/Monticello
    {  349, 7169,   94078,  5, }, // America/Lima
    {  349, 5932,     207, 22, }, // America/Lower_Princes
    {  349, 8220,    7008,  6, }, // America/Merida
    {  349, 2949,   94083, 18, }, // America/Mexico_City
    {  349, 5824,   72803,  9, }, // America/Montserrat
    {  349, 2379,   94101, 11, }, // America/New_York
    {  349, 8301,     235, 20, }, // America/North_Dakota/Beulah
    {  349, 8329,     255, 20, }, // America/North_Dakota/Center
    {  349, 8357,     275, 23, }, // America/North_Dakota/New_Salem
    {  349,  393,     298,  4, }, // America/Nuuk
    {  349, 5843,   94112, 10, }, // America/Puerto_Rico
    {  349, 1878,   26580,  9, }, // America/Sao_Paulo
    {  349, 6899,     302, 16, }, // America/Scoresbysund
    {  349, 8508,   35804, 16, }, // America/St_Barthelemy
    {  349, 2061,     332, 10, }, // America/St_Johns
    {  349, 5863,   94122, 13, }, // America/St_Kitts
    {  349, 5880,   35832, 11, }, // America/St_Lucia
    {  349,  855,     360, 10, }, // America/St_Thomas
    {  349, 5913,   94135, 12, }, // America/St_Vincent
    {  349, 5756,   94147, 10, }, // America/Thule
    {  349, 6133,     381, 16, }, // Antarctica/DumontDUrville
    {  349, 8568,   94157, 10, }, // Antarctica/Macquarie
    {  349, 5570,   94167,  5, }, // Asia/Aden
    {  349, 3607,    4044,  6, }, // Asia/Baghdad
    {  349, 5534,   94172,  7, }, // Asia/Bahrain
    {  349, 3653,   94179,  4, }, // Asia/Baku
    {  349, 4086,   94183,  7, }, // Asia/Beirut
    {  349, 5989,   94190,  6, }, // Asia/Brunei
    {  349, 4540,   94196, 10, }, // Asia/Damascus
    {  349, 4795,   94206,  7, }, // Asia/Hebron
    {  349, 1259,   72962, 19, }, // Asia/Ho_Chi_Minh
    {  349, 2704,   94213,  9, }, // Asia/Hong_Kong
    {  349, 7006,   94222,  7, }, // Asia/Jakarta
    {  349, 1290,   94229, 11, }, // Asia/Jerusalem
    {  349, 3560,   94240,  5, }, // Asia/Kabul
    {  349, 1185,     413,  9, }, // Asia/Kathmandu
    {  349,  992,   94245,  7, }, // Asia/Kolkata
    {  349, 5547,   94252,  5, }, // Asia/Kuwait
    {  349, 1211,     429,  5, }, // Asia/Macau
    {  349, 1349,   94257,  7, }, // Asia/Makassar
    {  349, 7182,   94264,  7, }, // Asia/Manila
    {  349, 2554,   94271, 10, }, // Asia/Nicosia
    {  349, 5559,   73021,  5, }, // Asia/Qatar
    {  349, 8708,     434,  8, }, // Asia/Qostanay
    {  349, 3279,   94281,  3, }, // Asia/Seoul
    {  349, 1053,   94284,  9, }, // Asia/Shanghai
    {  349, 3300,   94293,  9, }, // Asia/Singapore
    {  349, 2821,   94302,  6, }, // Asia/Tokyo
    {  349, 4828,   94308,  7, }, // Asia/Yakutsk
    {  349, 1235,   20819,  6, }, // Asia/Yangon
    {  349, 3747,   94315,  8, }, // Asia/Yerevan
    {  349, 3663,   94323,  9, }, // Atlantic/Azores
    {  349, 5671,   94332,  9, }, // Atlantic/Bermuda
    {  349, 6628,   94341, 22, }, // Atlantic/Canary
    {  349, 3727,   94363, 10, }, // Atlantic/Cape_Verde
    {  349, 1395,   94373, 13, }, // Atlantic/Faroe
    {  349, 8736,   94386,  8, }, // Atlantic/Madeira
    {  349, 2748,   94394,  8, }, // Atlantic/Reykjavik
    {  349, 7272,   94402, 18, }, // Atlantic/South_Georgia
    {  349, 6821,   94420, 10, }, // Atlantic/St_Helena
    {  349, 6441,   94430,  9, }, // Europe/Amsterdam
    {  349, 6216,   94439,  6, }, // Europe/Andorra
    {  349, 3620,   94445, 12, }, // Europe/Astrakhan
    {  349, 2300,   94457,  9, }, // Europe/Athens
    {  349, 6336,   94466,  8, }, // Europe/Belgrade
    {  349, 4757,   94474,  7, }, // Europe/Berlin
    {  349, 6488,   94481, 14, }, // Europe/Bratislava
    {  349, 2167,   94495, 12, }, // Europe/Brussels
    {  349, 3928,   94507,  9, }, // Europe/Bucharest
    {  349, 3806,   94516, 10, }, // Europe/Budapest
    {  349, 2583,   94526,  7, }, // Europe/Chisinau
    {  349, 6289,   94533, 10, }, // Europe/Copenhagen
    {  349, 2338,   94543, 17, }, // Europe/Dublin
    {  349, 6307,   94560, 10, }, // Europe/Gibraltar
    {  349, 8788,   94570,  7, }, // Europe/Guernsey
    {  349, 6612,   94577,  9, }, // Europe/Helsinki
    {  349, 8804,   94586, 14, }, // Europe/Isle_of_Man
    {  349, 1130,   94600,  9, }, // Europe/Istanbul
    {  349, 8823,   94609,  6, }, // Europe/Jersey
    {  349, 2527,   94615,  3, }, // Europe/Kyiv
    {  349, 3213,   94618,  8, }, // Europe/Lisbon
    {  349, 6506,   94626, 10, }, // Europe/Ljubljana
    {  349, 2501,   94636,  7, }, // Europe/London
    {  349, 6365,   94643, 10, }, // Europe/Luxembourg
    {  349, 4892,   94653,  7, }, // Europe/Madrid
    {  349, 6397,   91902,  5, }, // Europe/Malta
    {  349, 3693,   94660,  6, }, // Europe/Minsk
    {  349, 6410,   94666,  6, }, // Europe/Monaco
    {  349, 3537,   94672,  5, }, // Europe/Moscow
    {  349, 6458,   92829,  4, }, // Europe/Oslo
    {  349, 4284,   94677,  5, }, // Europe/Paris
    {  349, 6424,   94682, 11, }, // Europe/Podgorica
    {  349, 6275,   91926,  4, }, // Europe/Prague
    {  349, 8837,   94693,  4, }, // Europe/Riga
    {  349, 6324,   94697,  8, }, // Europe/Rome
    {  349, 6470,   94705, 11, }, // Europe/San_Marino
    {  349, 6245,   94716,  8, }, // Europe/Sarajevo
    {  349, 6383,   94724,  6, }, // Europe/Skopje
    {  349, 6599,   94730,  6, }, // Europe/Sofia
    {  349, 6523,   94736,  7, }, // Europe/Stockholm
    {  349, 8867,   94743,  8, }, // Europe/Tallinn
    {  349, 6202,   94751,  7, }, // Europe/Tirane
    {  349, 6352,   94758,  5, }, // Europe/Vaduz
    {  349, 6567,   94763, 11, }, // Europe/Vatican
    {  349, 6231,   92882,  3, }, // Europe/Vienna
    {  349, 8899,   94774,  7, }, // Europe/Vilnius
    {  349, 3190,   94781,  5, }, // Europe/Warsaw
    {  349, 6261,   94786,  6, }, // Europe/Zagreb
    {  349, 6540,    4459,  6, }, // Europe/Zurich
    {  349, 5078,   94792, 14, }, // Indian/Antananarivo
    {  349, 6046,   94806, 16, }, // Indian/Christmas
    {  349, 6063,   94822, 12, }, // Indian/Cocos
    {  349, 5029,   94834, 15, }, // Indian/Comoro
    {  349, 7050,   94849, 17, }, // Indian/Maldives
    {  349, 4069,   94866, 14, }, // Indian/Mauritius
    {  349, 7211,   65405, 10, }, // Indian/Reunion
    {  349, 3157,     474,  5, }, // Pacific/Chuuk
    {  349, 3902,   94880,  5, }, // Pacific/Fiji
    {  349, 2723,    4493,  8, }, // Pacific/Honolulu
    {  349, 3049,    4501,  9, }, // Pacific/Kanton
    {  349, 4051,   94885, 23, }, // Pacific/Marquesas
    {  349, 8914,   94908, 14, }, // Pacific/Midway
    {  349, 7084,   92962,  4, }, // Pacific/Nauru
    {  349, 3096,     479,  7, }, // Pacific/Pohnpei
    {  349, 7312,   94922,  7, }, // Pacific/Tahiti
    {  349, 7405,   94929,  6, }, // Pacific/Wallis
    {  351, 5059,    3784, 11, }, // Africa/Addis_Ababa Italian/Latin/Italy
    {  351, 7420,   94935,  6, }, // Africa/Algiers
    {  351,   14,       0,  6, }, // Africa/Asmara
    {  351, 2320,   94941,  8, }, // Africa/Cairo
    {  351, 5043,   94949,  6, }, // Africa/Djibouti
    {  351, 5166,   94955,  7, }, // Africa/El_Aaiun
    {  351, 4499,   94962,  5, }, // Africa/Juba
    {  351, 4524,   26372,  7, }, // Africa/Khartoum
    {  351, 6869,   20300,  4, }, // Africa/Lome
    {  351, 5113,   43978, 10, }, // Africa/Mogadishu
    {  351, 5271,   43996,  9, }, // Africa/Ndjamena
    {  351, 4435,       6,  8, }, // Africa/Sao_Tome
    {  351, 6554,   94967,  6, }, // Africa/Tunis
    {  351, 7571,   20368,  7, }, // America/Argentina/Tucuman
    {  351, 4252,      14,  8, }, // America/Asuncion
    {  351,  237,      22,  8, }, // America/Atikokan
    {  351, 7623,      30, 17, }, // America/Bahia_Banderas
    {  351, 4361,   20389,  6, }, // America/Bogota
    {  351, 3868,      47,  6, }, // America/Cancun
    {  351, 4345,   94973,  7, }, // America/Cayenne
    {  351, 7774,      53, 13, }, // America/Ciudad_Juarez
    {  351, 5723,      66,  7, }, // America/Curacao
    {  351, 5786,   94980,  9, }, // America/Guadeloupe
    {  351, 2281,   94989,  7, }, // America/Havana
    {  351,  481,      73, 13, }, // America/Indiana/Knox
    {  351, 7961,      86, 16, }, // America/Indiana/Marengo
    {  351, 7985,     102, 19, }, // America/Indiana/Petersburg
    {  351, 8012,     121, 18, }, // America/Indiana/Tell_City
    {  351, 8038,     139, 14, }, // America/Indiana/Vevay
    {  351, 8060,     153, 18, }, // America/Indiana/Vincennes
    {  351, 8086,     171, 16, }, // America/Indiana/Winamac
    {  351, 2799,   94996,  8, }, // America/Jamaica
    {  351, 8125,     187, 20, }, // America/Kentucky/Monticello
    {  351, 5932,     207, 22, }, // America/Lower_Princes
    {  351, 5805,   20436,  9, }, // America/Martinique
    {  351, 8220,     229,  6, }, // America/Merida
    {  351, 2949,   95004, 17, }, // America/Mexico_City
    {  351, 8301,   95021, 23, }, // America/North_Dakota/Beulah
    {  351, 8329,   95044, 23, }, // America/North_Dakota/Center
    {  351, 8357,   95067, 26, }, // America/North_Dakota/New_Salem
    {  351,  393,     298,  4, }, // America/Nuuk
    {  351, 5843,   95093,  9, }, // America/Puerto_Rico
    {  351, 8477,   26572,  8, }, // America/Santarem
    {  351, 1878,   95102,  9, }, // America/Sao_Paulo
    {  351, 6899,     302, 16, }, // America/Scoresbysund
    {  351, 8508,   26589, 16, }, // America/St_Barthelemy
    {  351, 2061,     332, 10, }, // America/St_Johns
    {  351, 5863,     342,  9, }, // America/St_Kitts
    {  351, 5880,   95111, 11, }, // America/St_Lucia
    {  351,  855,   44161, 12, }, // America/St_Thomas
    {  351, 5913,   26651, 13, }, // America/St_Vincent
    {  351, 6133,     381, 16, }, // Antarctica/DumontDUrville
    {  351, 5511,   95122,  7, }, // Asia/Anadyr
    {  351, 5368,   57073,  6, }, // Asia/Aqtobe
    {  351, 5534,    4050,  7, }, // Asia/Bahrain
    {  351, 4601,   57490,  4, }, // Asia/Chita
    {  351, 4540,   74309,  7, }, // Asia/Damascus
    {  351, 1093,   65588,  5, }, // Asia/Dhaka
    {  351, 8636,   95129,  9, }, // Asia/Famagusta
    {  351, 1259,     397, 11, }, // Asia/Ho_Chi_Minh
    {  351, 7006,   95138,  8, }, // Asia/Jakarta
    {  351, 1290,   95146, 11, }, // Asia/Jerusalem
    {  351, 1185,     413,  9, }, // Asia/Kathmandu
    {  351, 8661,   57888,  8, }, // Asia/Khandyga
    {  351,  992,   35921,  8, }, // Asia/Kolkata
    {  351, 4197,    4170, 11, }, // Asia/Krasnoyarsk
    {  351, 1211,     429,  5, }, // Asia/Macau
    {  351, 6920,   20739,  7, }, // Asia/Muscat
    {  351, 8675,   62352, 11, }, // Asia/Novokuznetsk
    {  351, 3584,   20756,  5, }, // Asia/Riyadh
    {  351, 4408,   57952,  8, }, // Asia/Sakhalin
    {  351, 7245,   20768, 10, }, // Asia/Samarkand
    {  351, 3279,    7680,  4, }, // Asia/Seoul
    {  351, 2772,    7724,  7, }, // Asia/Tehran
    {  351, 1021,   26791, 10, }, // Asia/Ulaanbaatar
    {  351, 8722,   44300,  9, }, // Asia/Ust-Nera
    {  351, 4828,    7755,  7, }, // Asia/Yakutsk
    {  351, 1235,   58486,  7, }, // Asia/Yangon
    {  351, 3883,    7768, 12, }, // Asia/Yekaterinburg
    {  351, 3663,   95157,  7, }, // Atlantic/Azores
    {  351, 6628,   20849,  7, }, // Atlantic/Canary
    {  351, 3727,   93255, 10, }, // Atlantic/Cape_Verde
    {  351, 1395,   95164, 13, }, // Atlantic/Faroe
    {  351, 2748,   36044,  9, }, // Atlantic/Reykjavik
    {  351, 7272,   95177, 15, }, // Atlantic/South_Georgia
    {  351, 6821,   95192, 10, }, // Atlantic/St_Helena
    {  351, 2300,    5793,  5, }, // Europe/Athens
    {  351, 6336,   58774,  8, }, // Europe/Belgrade
    {  351, 4757,   62753,  7, }, // Europe/Berlin
    {  351, 2167,   57529,  9, }, // Europe/Brussels
    {  351, 3928,   20955,  8, }, // Europe/Bucharest
    {  351, 8772,   26905,  8, }, // Europe/Busingen
    {  351, 6289,   95202, 10, }, // Europe/Copenhagen
    {  351, 2338,   62833,  7, }, // Europe/Dublin
    {  351, 6307,   95212, 10, }, // Europe/Gibraltar
    {  351, 8804,   95222, 12, }, // Europe/Isle_of_Man
    {  351, 2527,    8030,  4, }, // Europe/Kyiv
    {  351, 3213,   93285,  7, }, // Europe/Lisbon
    {  351, 6506,   95234,  7, }, // Europe/Ljubljana
    {  351, 2501,   95241,  6, }, // Europe/London
    {  351, 6365,   95247, 11, }, // Europe/Luxembourg
    {  351, 3537,   95258,  5, }, // Europe/Moscow
    {  351, 4284,   95263,  6, }, // Europe/Paris
    {  351, 6275,   21067,  5, }, // Europe/Prague
    {  351, 6324,    5946,  4, }, // Europe/Rome
    {  351, 8849,   95269, 11, }, // Europe/Simferopol
    {  351, 6523,   95280,  9, }, // Europe/Stockholm
    {  351, 6202,   21095,  6, }, // Europe/Tirane
    {  351, 6567,   95289, 18, }, // Europe/Vatican
    {  351, 3190,   95307,  8, }, // Europe/Warsaw
    {  351, 6261,   95315,  8, }, // Europe/Zagreb
    {  351, 6540,   95323,  6, }, // Europe/Zurich
    {  351, 5029,    4470,  6, }, // Indian/Comoro
    {  351, 7050,    8193,  7, }, // Indian/Maldives
    {  351, 7211,   95329, 11, }, // Indian/Reunion
    {  351, 3157,     474,  5, }, // Pacific/Chuuk
    {  351, 2237,   44510,  6, }, // Pacific/Easter
    {  351, 3902,   95340,  4, }, // Pacific/Fiji
    {  351, 2723,    4493,  8, }, // Pacific/Honolulu
    {  351, 3049,    4501,  9, }, // Pacific/Kanton
    {  351, 4051,   95344,  8, }, // Pacific/Marquesas
    {  351, 3096,     479,  7, }, // Pacific/Pohnpei
    {  355, 6788,   95352,  5, }, // Africa/Abidjan Japanese/Japanese/Japan
    {  355, 6760,   95357,  3, }, // Africa/Accra
    {  355, 5059,   95360,  6, }, // Africa/Addis_Ababa
    {  355, 7420,   95366,  4, }, // Africa/Algiers
    {  355,   14,   95370,  4, }, // Africa/Asmara
    {  355,   44,   95374,  3, }, // Africa/Bamako
    {  355, 5257,   95377,  3, }, // Africa/Bangui
    {  355, 6746,   95380,  6, }, // Africa/Banjul
    {  355, 7435,   95386,  3, }, // Africa/Bissau
    {  355, 4957,   95389,  6, }, // Africa/Blantyre
    {  355, 5287,   95395,  5, }, // Africa/Brazzaville
    {  355, 4922,   95400,  6, }, // Africa/Bujumbura
    {  355, 2320,   95406,  3, }, // Africa/Cairo
    {  355, 4117,   95409,  6, }, // Africa/Casablanca
    {  355, 7449,   95415,  3, }, // Africa/Ceuta
    {  355, 6773,   95418,  4, }, // Africa/Conakry
    {  355, 6840,   95422,  4, }, // Africa/Dakar
    {  355, 5130,   95426,  8, }, // Africa/Dar_es_Salaam
    {  355, 5043,   95434,  3, }, // Africa/Djibouti
    {  355, 5243,   95437,  4, }, // Africa/Douala
    {  355, 5166,   95441,  4, }, // Africa/El_Aaiun
    {  355, 6853,   95445,  6, }, // Africa/Freetown
    {  355, 4906,   95451,  5, }, // Africa/Gaborone
    {  355, 5015,   95456,  3, }, // Africa/Harare
    {  355, 4479,   95459,  7, }, // Africa/Johannesburg
    {  355, 4499,   95466,  3, }, // Africa/Juba
    {  355, 5151,   95469,  4, }, // Africa/Kampala
    {  355, 4524,   95473,  5, }, // Africa/Khartoum
    {  355, 4973,   95478,  3, }, // Africa/Kigali
    {  355, 5306,   95481,  5, }, // Africa/Kinshasa
    {  355, 4744,   95486,  3, }, // Africa/Lagos
    {  355, 5336,   95489,  7, }, // Africa/Libreville
    {  355, 6869,   95496,  2, }, // Africa/Lome
    {  355, 5211,   95498,  4, }, // Africa/Luanda
    {  355, 4939,   95502,  5, }, // Africa/Lubumbashi
    {  355, 5001,   95507,  3, }, // Africa/Lusaka
    {  355, 5322,   95510,  3, }, // Africa/Malabo
    {  355, 4987,   95513,  3, }, // Africa/Maputo
    {  355, 5197,   95516,  3, }, // Africa/Maseru
    {  355, 5182,   95519,  5, }, // Africa/Mbabane
    {  355, 5113,   95524,  6, }, // Africa/Mogadishu
    {  355, 7034,   95530,  5, }, // Africa/Monrovia
    {  355, 3853,   95535,  4, }, // Africa/Nairobi
    {  355, 5271,   95539,  5, }, // Africa/Ndjamena
    {  355, 5354,   95544,  3, }, // Africa/Niamey
    {  355, 6803,   95547,  7, }, // Africa/Nouakchott
    {  355, 6727,   95554,  6, }, // Africa/Ouagadougou
    {  355, 5225,   95560,  5, }, // Africa/Porto-Novo
    {  355, 4435,   95565,  4, }, // Africa/Sao_Tome
    {  355, 2866,   95569,  4, }, // Africa/Tripoli
    {  355, 6554,   95573,  4, }, // Africa/Tunis
    {  355, 4152,   95577,  7, }, // Africa/Windhoek
    {  355,  132,   95584,  4, }, // America/Adak
    {  355, 3346,   95588,  6, }, // America/Anchorage
    {  355, 5607,   95594,  4, }, // America/Anguilla
    {  355, 5624,   95598,  6, }, // America/Antigua
    {  355, 4554,   95604,  6, }, // America/Araguaina
    {  355,  166,   95610,  8, }, // America/Argentina/Buenos_Aires
    {  355,   91,   95618,  5, }, // America/Argentina/Catamarca
    {  355,  270,   95623,  4, }, // America/Argentina/Cordoba
    {  355,  441,   95627,  3, }, // America/Argentina/Jujuy
    {  355, 7462,   95630,  4, }, // America/Argentina/La_Rioja
    {  355,  565,   95634,  5, }, // America/Argentina/Mendoza
    {  355, 7489,   95639,  7, }, // America/Argentina/Rio_Gallegos
    {  355, 7520,   95646,  3, }, // America/Argentina/Salta
    {  355, 7544,   95649,  5, }, // America/Argentina/San_Juan
    {  355, 5580,   95654,  5, }, // America/Argentina/San_Luis
    {  355, 7571,   95659,  5, }, // America/Argentina/Tucuman
    {  355, 7597,   95664,  6, }, // America/Argentina/Ushuaia
    {  355, 5640,   95670,  3, }, // America/Aruba
    {  355, 4252,   95673,  6, }, // America/Asuncion
    {  355,  237,   95679,  6, }, // America/Atikokan
    {  355, 3679,   95685,  4, }, // America/Bahia
    {  355, 7623,   95689,  7, }, // America/Bahia_Banderas
    {  355, 5654,   95696,  5, }, // America/Barbados
    {  355, 7646,   95701,  3, }, // America/Belem
    {  355, 5407,   95704,  4, }, // America/Belize
    {  355, 7660,   95708,  8, }, // America/Blanc-Sablon
    {  355, 7681,   95716,  5, }, // America/Boa_Vista
    {  355, 4361,   95721,  3, }, // America/Bogota
    {  355, 7699,   95724,  3, }, // America/Boise
    {  355, 7713,   95727,  8, }, // America/Cambridge_Bay
    {  355, 7735,   95735,  7, }, // America/Campo_Grande
    {  355, 3868,   95742,  4, }, // America/Cancun
    {  355, 4694,   95746,  4, }, // America/Caracas
    {  355, 4345,   95750,  5, }, // America/Cayenne
    {  355, 5496,   95755,  4, }, // America/Cayman
    {  355, 2260,   95759,  3, }, // America/Chicago
    {  355, 7756,   95762,  3, }, // America/Chihuahua
    {  355, 7774,   95765,  9, }, // America/Ciudad_Juarez
    {  355, 5422,   95774,  5, }, // America/Costa_Rica
    {  355, 7796,   95779,  5, }, // America/Creston
    {  355, 3791,   95784,  4, }, // America/Cuiaba
    {  355, 5723,   95788,  5, }, // America/Curacao
    {  355, 7812,   95793,  9, }, // America/Danmarkshavn
    {  355, 7833,   95802,  4, }, // America/Dawson
    {  355, 7848,   95806,  8, }, // America/Dawson_Creek
    {  355,  805,   95814,  4, }, // America/Denver
    {  355, 3465,   95818,  5, }, // America/Detroit
    {  355, 5739,   95823,  4, }, // America/Dominica
    {  355,  893,   95827,  6, }, // America/Edmonton
    {  355, 7869,   95833,  5, }, // America/Eirunepe
    {  355, 5441,   95838,  7, }, // America/El_Salvador
    {  355, 7886,   95845,  8, }, // America/Fort_Nelson
    {  355, 7906,   95853,  6, }, // America/Fortaleza
    {  355, 7924,   95859,  6, }, // America/Glace_Bay
    {  355, 6881,   95865,  5, }, // America/Goose_Bay
    {  355, 4612,   95870,  7, }, // America/Grand_Turk
    {  355, 5770,   95877,  4, }, // America/Grenada
    {  355, 5786,   95881,  6, }, // America/Guadeloupe
    {  355, 3760,   95887,  5, }, // America/Guatemala
    {  355, 4841,   95892,  5, }, // America/Guayaquil
    {  355, 6932,   95897,  4, }, // America/Guyana
    {  355, 1939,   95901,  6, }, // America/Halifax
    {  355, 2281,   95907,  3, }, // America/Havana
    {  355, 7942,   95910,  5, }, // America/Hermosillo
    {  355,  348,   95915,  9, }, // America/Indiana/Indianapolis
    {  355,  481,   95924, 11, }, // America/Indiana/Knox
    {  355, 7961,   95935, 11, }, // America/Indiana/Marengo
    {  355, 7985,   95946, 15, }, // America/Indiana/Petersburg
    {  355, 8012,   95961, 12, }, // America/Indiana/Tell_City
    {  355, 8038,   95973, 10, }, // America/Indiana/Vevay
    {  355, 8060,   95983, 12, }, // America/Indiana/Vincennes
    {  355, 8086,   95995, 13, }, // America/Indiana/Winamac
    {  355, 8110,   96008,  5, }, // America/Inuvik
    {  355,  660,   96013,  6, }, // America/Iqaluit
    {  355, 2799,   96019,  5, }, // America/Jamaica
    {  355, 5380,   96024,  4, }, // America/Juneau
    {  355,  521,   96028,  4, }, // America/Kentucky/Louisville
    {  355, 8125,   96032, 14, }, // America/Kentucky/Monticello
    {  355, 5704,   96046,  7, }, // America/Kralendijk
    {  355, 4376,   96053,  3, }, // America/La_Paz
    {  355, 7169,   96056,  2, }, // America/Lima
    {  355, 3239,   96058,  6, }, // America/Los_Angeles
    {  355, 5932,   96064, 17, }, // America/Lower_Princes
    {  355, 8153,   96081,  4, }, // America/Maceio
    {  355, 8168,   96085,  4, }, // America/Managua
    {  355, 1908,   96089,  4, }, // America/Manaus
    {  355, 5897,   96093,  3, }, // America/Marigot
    {  355, 5805,   96096,  7, }, // America/Martinique
    {  355, 8184,   96103,  5, }, // America/Matamoros
    {  355, 2917,   96108,  5, }, // America/Mazatlan
    {  355, 8202,   96113,  5, }, // America/Menominee
    {  355, 8220,   96118,  3, }, // America/Merida
    {  355, 8235,   96121,  6, }, // America/Metlakatla
    {  355, 2949,   96127,  8, }, // America/Mexico_City
    {  355, 4391,   96135,  5, }, // America/Miquelon
    {  355, 8254,   96140,  5, }, // America/Moncton
    {  355, 8270,   96145,  5, }, // America/Monterrey
    {  355, 4098,   96150,  6, }, // America/Montevideo
    {  355, 5824,   96156,  6, }, // America/Montserrat
    {  355, 5481,   96162,  4, }, // America/Nassau
    {  355, 2379,   96166,  6, }, // America/New_York
    {  355, 8288,   96172,  3, }, // America/Nome
    {  355, 1850,   96175,  5, }, // America/Noronha
    {  355, 8301,   96180, 12, }, // America/North_Dakota/Beulah
    {  355, 8329,   96192, 11, }, // America/North_Dakota/Center
    {  355, 8357,   96203, 14, }, // America/North_Dakota/New_Salem
    {  355,  393,   96217,  3, }, // America/Nuuk
    {  355, 8388,   96220,  4, }, // America/Ojinaga
    {  355, 2356,   96224,  3, }, // America/Panama
    {  355, 6173,   96227,  5, }, // America/Paramaribo
    {  355, 2973,   96232,  6, }, // America/Phoenix
    {  355, 3945,   96238,  8, }, // America/Port-au-Prince
    {  355, 5954,   96246,  9, }, // America/Port_of_Spain
    {  355, 8404,   96255,  7, }, // America/Porto_Velho
    {  355, 5843,   96262,  6, }, // America/Puerto_Rico
    {  355, 4030,   96268,  7, }, // America/Punta_Arenas
    {  355, 8424,   96275,  9, }, // America/Rankin_Inlet
    {  355, 8445,   96284,  4, }, // America/Recife
    {  355, 1995,   96288,  5, }, // America/Regina
    {  355, 8460,   96293,  6, }, // America/Resolute
    {  355,  695,   96299,  6, }, // America/Rio_Branco
    {  355, 8477,   96305,  5, }, // America/Santarem
    {  355, 2201,   96310,  5, }, // America/Santiago
    {  355, 6111,   96315,  7, }, // America/Santo_Domingo
    {  355, 1878,   96322,  5, }, // America/Sao_Paulo
    {  355, 6899,   96327,  9, }, // America/Scoresbysund
    {  355, 8494,   96336,  3, }, // America/Sitka
    {  355, 8508,   96339,  9, }, // America/St_Barthelemy
    {  355, 2061,   96348,  7, }, // America/St_Johns
    {  355, 5863,   96355, 10, }, // America/St_Kitts
    {  355, 5880,   96365,  6, }, // America/St_Lucia
    {  355,  855,   96371,  7, }, // America/St_Thomas
    {  355, 5913,   96378,  8, }, // America/St_Vincent
    {  355, 8530,   96386,  9, }, // America/Swift_Current
    {  355, 5461,   96395,  6, }, // America/Tegucigalpa
    {  355, 5756,   96401,  4, }, // America/Thule
    {  355,  313,   96405,  5, }, // America/Tijuana
    {  355,  608,   96410,  4, }, // America/Toronto
    {  355, 5688,   96414,  5, }, // America/Tortola
    {  355, 2093,   96419,  6, }, // America/Vancouver
    {  355, 2144,   96425,  7, }, // America/Whitehorse
    {  355,  734,   96432,  5, }, // America/Winnipeg
    {  355, 8552,   96437,  5, }, // America/Yakutat
    {  355, 6001,   96442,  6, }, // Antarctica/Casey
    {  355, 6094,   96448,  6, }, // Antarctica/Davis
    {  355, 6133,   96454, 13, }, // Antarctica/DumontDUrville
    {  355, 8568,   96467,  5, }, // Antarctica/Macquarie
    {  355, 7066,   96472,  6, }, // Antarctica/Mawson
    {  355, 7113,   96478,  7, }, // Antarctica/McMurdo
    {  355, 8589,   96485,  6, }, // Antarctica/Palmer
    {  355, 7226,   96491,  5, }, // Antarctica/Rothera
    {  355, 7295,   42193,  4, }, // Antarctica/Syowa
    {  355, 8607,   96496,  5, }, // Antarctica/Troll
    {  355, 7374,   96501,  7, }, // Antarctica/Vostok
    {  355, 1429,   96508, 10, }, // Arctic/Longyearbyen
    {  355, 5570,   96518,  3, }, // Asia/Aden
    {  355, 5395,   96521,  5, }, // Asia/Almaty
    {  355, 3968,   96526,  4, }, // Asia/Amman
    {  355, 5511,   96530,  5, }, // Asia/Anadyr
    {  355, 5523,   96535,  4, }, // Asia/Aqtau
    {  355, 5368,   96539,  4, }, // Asia/Aqtobe
    {  355,  964,   96543,  6, }, // Asia/Ashgabat
    {  355, 8624,   96549,  5, }, // Asia/Atyrau
    {  355, 3607,   96554,  5, }, // Asia/Baghdad
    {  355, 5534,   96559,  5, }, // Asia/Bahrain
    {  355, 3653,   96564,  3, }, // Asia/Baku
    {  355, 4466,   96567,  4, }, // Asia/Bangkok
    {  355, 3571,   96571,  5, }, // Asia/Barnaul
    {  355, 4086,   96576,  5, }, // Asia/Beirut
    {  355, 3778,   96581,  5, }, // Asia/Bishkek
    {  355, 5989,   96586,  4, }, // Asia/Brunei
    {  355, 4601,   96590,  2, }, // Asia/Chita
    {  355, 4511,   96592,  4, }, // Asia/Colombo
    {  355, 4540,   96596,  5, }, // Asia/Damascus
    {  355, 1093,   96601,  3, }, // Asia/Dhaka
    {  355, 6192,   96532,  3, }, // Asia/Dili
    {  355, 3596,   96604,  3, }, // Asia/Dubai
    {  355, 6159,   96607,  6, }, // Asia/Dushanbe
    {  355, 8636,   96613,  6, }, // Asia/Famagusta
    {  355, 8651,   96619,  2, }, // Asia/Gaza
    {  355, 4795,   96621,  4, }, // Asia/Hebron
    {  355, 1259,   96625,  5, }, // Asia/Ho_Chi_Minh
    {  355, 2704,   42293,  2, }, // Asia/Hong_Kong
    {  355, 4771,   96630,  3, }, // Asia/Hovd
    {  355, 4184,   96633,  6, }, // Asia/Irkutsk
    {  355, 7006,   96639,  5, }, // Asia/Jakarta
    {  355, 6992,   96644,  5, }, // Asia/Jayapura
    {  355, 1290,   96649,  5, }, // Asia/Jerusalem
    {  355, 3560,   96654,  4, }, // Asia/Kabul
    {  355, 4316,   96658,  6, }, // Asia/Kamchatka
    {  355, 4239,   96664,  3, }, // Asia/Karachi
    {  355, 1185,   96667,  5, }, // Asia/Kathmandu
    {  355, 8661,   96672,  6, }, // Asia/Khandyga
    {  355,  992,   96678,  4, }, // Asia/Kolkata
    {  355, 4197,   96682,  8, }, // Asia/Krasnoyarsk
    {  355, 4859,   96690,  8, }, // Asia/Kuala_Lumpur
    {  355, 5976,   96698,  3, }, // Asia/Kuching
    {  355, 5547,   96701,  5, }, // Asia/Kuwait
    {  355, 1211,   96706,  3, }, // Asia/Macau
    {  355, 4017,   96709,  4, }, // Asia/Magadan
    {  355, 1349,   96713,  5, }, // Asia/Makassar
    {  355, 7182,   96718,  3, }, // Asia/Manila
    {  355, 6920,   96721,  5, }, // Asia/Muscat
    {  355, 2554,   96726,  4, }, // Asia/Nicosia
    {  355, 8675,   96730,  8, }, // Asia/Novokuznetsk
    {  355, 4135,   96738,  8, }, // Asia/Novosibirsk
    {  355, 4229,   96746,  4, }, // Asia/Omsk
    {  355, 7145,   96750,  3, }, // Asia/Oral
    {  355, 6961,   96753,  5, }, // Asia/Phnom_Penh
    {  355, 8693,   96758,  8, }, // Asia/Pontianak
    {  355, 4214,   96766,  2, }, // Asia/Pyongyang
    {  355, 5559,   96768,  4, }, // Asia/Qatar
    {  355, 8708,   96772,  5, }, // Asia/Qostanay
    {  355, 4269,   96777,  5, }, // Asia/Qyzylorda
    {  355, 3584,   96782,  3, }, // Asia/Riyadh
    {  355, 4408,   96785,  4, }, // Asia/Sakhalin
    {  355, 7245,   96789,  6, }, // Asia/Samarkand
    {  355, 3279,   96795,  3, }, // Asia/Seoul
    {  355, 1053,   42435,  2, }, // Asia/Shanghai
    {  355, 3300,   96798,  6, }, // Asia/Singapore
    {  355, 4297,   96804,  9, }, // Asia/Srednekolymsk
    {  355, 3263,   42446,  2, }, // Asia/Taipei
    {  355, 4781,   96813,  5, }, // Asia/Tashkent
    {  355, 3915,   96818,  4, }, // Asia/Tbilisi
    {  355, 2772,   96822,  4, }, // Asia/Tehran
    {  355, 1317,   96826,  5, }, // Asia/Thimphu
    {  355, 2821,   42460,  2, }, // Asia/Tokyo
    {  355, 4572,   96831,  4, }, // Asia/Tomsk
    {  355, 1021,   96835,  7, }, // Asia/Ulaanbaatar
    {  355, 1159,   96842,  4, }, // Asia/Urumqi
    {  355, 8722,   96846,  5, }, // Asia/Ust-Nera
    {  355, 6977,   96851,  6, }, // Asia/Vientiane
    {  355, 4710,   96857,  7, }, // Asia/Vladivo