import{ObjectWrapper,UIString,Settings,ResourceType,ParsedURL,Revealer}from'../common/common.js';import{InspectorFrontendHost}from'../host/host.js';import{Toolbar,Utils,UIUtils,ARIAUtils,SettingsUI,ContextMenu,RemoteDebuggingTerminatedScreen,Dialog,GlassPane,TargetCrashedScreen}from'../ui/ui.js';import{StringUtilities}from'../platform/platform.js';import{LiveLocation,DebuggerWorkspaceBinding,CSSWorkspaceBinding,ResourceUtils,BlackboxManager}from'../bindings/bindings.js';import{SDKModel,DebuggerModel,NetworkRequest}from'../sdk/sdk.js';import{TextUtils}from'../text_utils/text_utils.js';import{Workspace}from'../workspace/workspace.js';class DockController extends ObjectWrapper.ObjectWrapper{constructor(canDock){super();this._canDock=canDock;this._closeButton=new Toolbar.ToolbarButton(UIString.UIString('Close'),'largeicon-delete');this._closeButton.addEventListener(Toolbar.ToolbarButton.Events.Click,InspectorFrontendHost.InspectorFrontendHostInstance.closeWindow.bind(InspectorFrontendHost.InspectorFrontendHostInstance));if(!canDock){this._dockSide=State.Undocked;this._closeButton.setVisible(false);return;}
this._states=[State.DockedToRight,State.DockedToBottom,State.DockedToLeft,State.Undocked];this._currentDockStateSetting=Settings.Settings.instance().moduleSetting('currentDockState');this._currentDockStateSetting.addChangeListener(this._dockSideChanged,this);this._lastDockStateSetting=Settings.Settings.instance().createSetting('lastDockState','bottom');if(this._states.indexOf(this._currentDockStateSetting.get())===-1){this._currentDockStateSetting.set('right');}
if(this._states.indexOf(this._lastDockStateSetting.get())===-1){this._currentDockStateSetting.set('bottom');}}
initialize(){if(!this._canDock){return;}
this._titles=[UIString.UIString('Dock to right'),UIString.UIString('Dock to bottom'),UIString.UIString('Dock to left'),UIString.UIString('Undock into separate window')];this._dockSideChanged();}
_dockSideChanged(){this.setDockSide(this._currentDockStateSetting.get());}
dockSide(){return this._dockSide;}
canDock(){return this._canDock;}
isVertical(){return this._dockSide===State.DockedToRight||this._dockSide===State.DockedToLeft;}
setDockSide(dockSide){if(this._states.indexOf(dockSide)===-1){dockSide=this._states[0];}
if(this._dockSide===dockSide){return;}
if(this._dockSide){this._lastDockStateSetting.set(this._dockSide);}
this._savedFocus=document.deepActiveElement();const eventData={from:this._dockSide,to:dockSide};this.dispatchEventToListeners(Events.BeforeDockSideChanged,eventData);console.timeStamp('DockController.setIsDocked');this._dockSide=dockSide;this._currentDockStateSetting.set(dockSide);InspectorFrontendHost.InspectorFrontendHostInstance.setIsDocked(dockSide!==State.Undocked,this._setIsDockedResponse.bind(this,eventData));this._closeButton.setVisible(this._dockSide!==State.Undocked);this.dispatchEventToListeners(Events.DockSideChanged,eventData);}
_setIsDockedResponse(eventData){this.dispatchEventToListeners(Events.AfterDockSideChanged,eventData);if(this._savedFocus){this._savedFocus.focus();this._savedFocus=null;}}
_toggleDockSide(){if(this._lastDockStateSetting.get()===this._currentDockStateSetting.get()){const index=this._states.indexOf(this._currentDockStateSetting.get())||0;this._lastDockStateSetting.set(this._states[(index+1)%this._states.length]);}
this.setDockSide(this._lastDockStateSetting.get());}}
const State={DockedToBottom:'bottom',DockedToRight:'right',DockedToLeft:'left',Undocked:'undocked'};const Events={BeforeDockSideChanged:Symbol('BeforeDockSideChanged'),DockSideChanged:Symbol('DockSideChanged'),AfterDockSideChanged:Symbol('AfterDockSideChanged')};class ToggleDockActionDelegate{handleAction(context,actionId){self.Components.dockController._toggleDockSide();return true;}}
class CloseButtonProvider{item(){return self.Components.dockController._closeButton;}}
var DockController$1=Object.freeze({__proto__:null,DockController:DockController,State:State,Events:Events,ToggleDockActionDelegate:ToggleDockActionDelegate,CloseButtonProvider:CloseButtonProvider});class ImagePreview{static build(target,originalImageURL,showDimensions,options={}){const{precomputedFeatures,imageAltText}=options;const resourceTreeModel=target.model(SDK.ResourceTreeModel);if(!resourceTreeModel){return Promise.resolve((null));}
let resource=resourceTreeModel.resourceForURL(originalImageURL);let imageURL=originalImageURL;if(!isImageResource(resource)&&precomputedFeatures&&precomputedFeatures.currentSrc){imageURL=precomputedFeatures.currentSrc;resource=resourceTreeModel.resourceForURL(imageURL);}
if(!isImageResource(resource)){return Promise.resolve((null));}
let fulfill;const promise=new Promise(x=>fulfill=x);const imageElement=createElement('img');imageElement.addEventListener('load',buildContent,false);imageElement.addEventListener('error',()=>fulfill(null),false);if(imageAltText){imageElement.alt=imageAltText;}
resource.populateImageSource(imageElement);return promise;function isImageResource(resource){return!!resource&&resource.resourceType()===ResourceType.resourceTypes.Image;}
function buildContent(){const container=createElement('table');Utils.appendStyle(container,'components/imagePreview.css');container.className='image-preview-container';const intrinsicWidth=imageElement.naturalWidth;const intrinsicHeight=imageElement.naturalHeight;const renderedWidth=precomputedFeatures?precomputedFeatures.renderedWidth:intrinsicWidth;const renderedHeight=precomputedFeatures?precomputedFeatures.renderedHeight:intrinsicHeight;let description;if(showDimensions){if(renderedHeight!==intrinsicHeight||renderedWidth!==intrinsicWidth){description=ls`${renderedWidth} × ${renderedHeight} pixels (intrinsic: ${intrinsicWidth} × ${
              intrinsicHeight} pixels)`;}else{description=ls`${renderedWidth} × ${renderedHeight} pixels`;}}
container.createChild('tr').createChild('td','image-container').appendChild(imageElement);if(description){container.createChild('tr').createChild('td').createChild('span','description').textContent=description;}
if(imageURL!==originalImageURL){container.createChild('tr').createChild('td').createChild('span','description').textContent=StringUtilities.sprintf('currentSrc: %s',imageURL.trimMiddle(100));}
fulfill(container);}}
static async loadDimensionsForNode(node){if(!node.nodeName()||node.nodeName().toLowerCase()!=='img'){return;}
const object=await node.resolveToObject('');if(!object){return;}
const featuresObject=object.callFunctionJSON(features,undefined);object.release();return featuresObject;function features(){return{renderedWidth:this.width,renderedHeight:this.height,currentSrc:this.currentSrc};}}
static defaultAltTextForImageURL(url){const parsedImageURL=new ParsedURL.ParsedURL(url);const imageSourceText=parsedImageURL.isValid?parsedImageURL.displayName:ls`unknown source`;return ls`Image from ${imageSourceText}`;}}
var ImagePreview$1=Object.freeze({__proto__:null,ImagePreview:ImagePreview});class Linkifier{constructor(maxLengthForDisplayedURLs,useLinkDecorator,onLiveLocationUpdate=()=>{}){this._maxLength=maxLengthForDisplayedURLs||UIUtils.MaxLengthForDisplayedURLs;this._anchorsByTarget=new Map();this._locationPoolByTarget=new Map();this._onLiveLocationUpdate=onLiveLocationUpdate;this._useLinkDecorator=!!useLinkDecorator;_instances.add(this);SDKModel.TargetManager.instance().observeTargets(this);}
static setLinkDecorator(decorator){console.assert(!_decorator,'Cannot re-register link decorator.');_decorator=decorator;decorator.addEventListener(LinkDecorator.Events.LinkIconChanged,onLinkIconChanged);for(const linkifier of _instances){linkifier._updateAllAnchorDecorations();}
function onLinkIconChanged(event){const uiSourceCode=(event.data);const links=uiSourceCode[_sourceCodeAnchors]||[];for(const link of links){Linkifier._updateLinkDecorations(link);}}}
_updateAllAnchorDecorations(){for(const anchors of this._anchorsByTarget.values()){for(const anchor of anchors){Linkifier._updateLinkDecorations(anchor);}}}
static _bindUILocation(anchor,uiLocation){Linkifier._linkInfo(anchor).uiLocation=uiLocation;if(!uiLocation){return;}
const uiSourceCode=uiLocation.uiSourceCode;let sourceCodeAnchors=uiSourceCode[_sourceCodeAnchors];if(!sourceCodeAnchors){sourceCodeAnchors=new Set();uiSourceCode[_sourceCodeAnchors]=sourceCodeAnchors;}
sourceCodeAnchors.add(anchor);}
static _unbindUILocation(anchor){const info=Linkifier._linkInfo(anchor);if(!info.uiLocation){return;}
const uiSourceCode=info.uiLocation.uiSourceCode;info.uiLocation=null;const sourceCodeAnchors=uiSourceCode[_sourceCodeAnchors];if(sourceCodeAnchors){sourceCodeAnchors.delete(anchor);}}
targetAdded(target){this._anchorsByTarget.set(target,[]);this._locationPoolByTarget.set(target,new LiveLocation.LiveLocationPool());}
targetRemoved(target){const locationPool=this._locationPoolByTarget.get(target);this._locationPoolByTarget.delete(target);locationPool.disposeAll();const anchors=this._anchorsByTarget.get(target);this._anchorsByTarget.delete(target);for(const anchor of anchors){const info=Linkifier._linkInfo(anchor);info.liveLocation=null;Linkifier._unbindUILocation(anchor);if(info.fallback){anchor.href=info.fallback.href;anchor.title=info.fallback.title;anchor.className=info.fallback.className;anchor.textContent=info.fallback.textContent;anchor[_infoSymbol]=info.fallback[_infoSymbol];}}}
maybeLinkifyScriptLocation(target,scriptId,sourceURL,lineNumber,options){const parsedOptions={className:'',columnNumber:0,...options};const{columnNumber,className}=parsedOptions;let fallbackAnchor=null;if(sourceURL){fallbackAnchor=Linkifier.linkifyURL(sourceURL,{lineNumber,maxLength:this._maxLength,...options});}
if(!target||target.isDisposed()){return fallbackAnchor;}
const debuggerModel=target.model(DebuggerModel.DebuggerModel);if(!debuggerModel){return fallbackAnchor;}
let rawLocation;if(scriptId){rawLocation=debuggerModel.createRawLocationByScriptId(scriptId,lineNumber,columnNumber);}
if(!rawLocation){rawLocation=debuggerModel.createRawLocationByURL(sourceURL,lineNumber,columnNumber);}
if(!rawLocation){return fallbackAnchor;}
const anchor=Linkifier._createLink('\u200b',className,options);const info=Linkifier._linkInfo(anchor);info.enableDecorator=this._useLinkDecorator;info.fallback=fallbackAnchor;const pool=this._locationPoolByTarget.get(rawLocation.debuggerModel.target());DebuggerWorkspaceBinding.DebuggerWorkspaceBinding.instance().createLiveLocation(rawLocation,this._updateAnchor.bind(this,anchor),pool).then(liveLocation=>{info.liveLocation=liveLocation;this._onLiveLocationUpdate();});const anchors=(this._anchorsByTarget.get(rawLocation.debuggerModel.target()));anchors.push(anchor);return anchor;}
linkifyScriptLocation(target,scriptId,sourceURL,lineNumber,options){const scriptLink=this.maybeLinkifyScriptLocation(target,scriptId,sourceURL,lineNumber,options);return scriptLink||Linkifier.linkifyURL(sourceURL,{lineNumber,maxLength:this._maxLength,...options});}
linkifyRawLocation(rawLocation,fallbackUrl,className){return this.linkifyScriptLocation(rawLocation.debuggerModel.target(),rawLocation.scriptId,fallbackUrl,rawLocation.lineNumber,{columnNumber:rawLocation.columnNumber,className});}
maybeLinkifyConsoleCallFrame(target,callFrame,options){return this.maybeLinkifyScriptLocation(target,callFrame.scriptId,callFrame.url,callFrame.lineNumber,{columnNumber:callFrame.columnNumber,...options});}
linkifyStackTraceTopFrame(target,stackTrace,classes){console.assert(stackTrace.callFrames&&stackTrace.callFrames.length);const topFrame=stackTrace.callFrames[0];const fallbackAnchor=Linkifier.linkifyURL(topFrame.url,{className:classes,lineNumber:topFrame.lineNumber,columnNumber:topFrame.columnNumber,maxLength:this._maxLength});if(target.isDisposed()){return fallbackAnchor;}
const debuggerModel=target.model(DebuggerModel.DebuggerModel);const rawLocations=debuggerModel.createRawLocationsByStackTrace(stackTrace);if(rawLocations.length===0){return fallbackAnchor;}
const anchor=Linkifier._createLink('\u200b',classes||'');const info=Linkifier._linkInfo(anchor);info.enableDecorator=this._useLinkDecorator;info.fallback=fallbackAnchor;const pool=this._locationPoolByTarget.get(target);DebuggerWorkspaceBinding.DebuggerWorkspaceBinding.instance().createStackTraceTopFrameLiveLocation(rawLocations,this._updateAnchor.bind(this,anchor),pool).then(liveLocation=>{info.liveLocation=liveLocation;this._onLiveLocationUpdate();});const anchors=(this._anchorsByTarget.get(target));anchors.push(anchor);return anchor;}
linkifyCSSLocation(rawLocation,classes){const anchor=Linkifier._createLink('\u200b',classes||'');const info=Linkifier._linkInfo(anchor);info.enableDecorator=this._useLinkDecorator;const pool=this._locationPoolByTarget.get(rawLocation.cssModel().target());CSSWorkspaceBinding.CSSWorkspaceBinding.instance().createLiveLocation(rawLocation,this._updateAnchor.bind(this,anchor),pool).then(liveLocation=>{info.liveLocation=liveLocation;this._onLiveLocationUpdate();});const anchors=(this._anchorsByTarget.get(rawLocation.cssModel().target()));anchors.push(anchor);return anchor;}
reset(){for(const target of[...this._anchorsByTarget.keys()]){this.targetRemoved(target);this.targetAdded(target);}}
dispose(){for(const target of[...this._anchorsByTarget.keys()]){this.targetRemoved(target);}
SDKModel.TargetManager.instance().unobserveTargets(this);_instances.delete(this);}
async _updateAnchor(anchor,liveLocation){Linkifier._unbindUILocation(anchor);const uiLocation=await liveLocation.uiLocation();if(!uiLocation){return;}
Linkifier._bindUILocation(anchor,uiLocation);const text=uiLocation.linkText(true);Linkifier._setTrimmedText(anchor,text,this._maxLength);let titleText=uiLocation.uiSourceCode.url();if(typeof uiLocation.lineNumber==='number'){titleText+=':'+(uiLocation.lineNumber+1);}
anchor.title=titleText;anchor.classList.toggle('webkit-html-blackbox-link',await liveLocation.isBlackboxed());Linkifier._updateLinkDecorations(anchor);}
static _updateLinkDecorations(anchor){const info=Linkifier._linkInfo(anchor);if(!info||!info.enableDecorator){return;}
if(!_decorator||!info.uiLocation){return;}
if(info.icon&&info.icon.parentElement){anchor.removeChild(info.icon);}
const icon=_decorator.linkIcon(info.uiLocation.uiSourceCode);if(icon){icon.style.setProperty('margin-right','2px');anchor.insertBefore(icon,anchor.firstChild);}
info.icon=icon;}
static linkifyURL(url,options){options=options||{};const text=options.text;const className=options.className||'';const lineNumber=options.lineNumber;const columnNumber=options.columnNumber;const preventClick=options.preventClick;const maxLength=options.maxLength||UIUtils.MaxLengthForDisplayedURLs;const bypassURLTrimming=options.bypassURLTrimming;if(!url||url.trim().toLowerCase().startsWith('javascript:')){const element=document.createElement('span');if(className){element.className=className;}
element.textContent=text||url||UIString.UIString('(unknown)');return element;}
let linkText=text||ResourceUtils.displayNameForURL(url);if(typeof lineNumber==='number'&&!text){linkText+=':'+(lineNumber+1);}
const title=linkText!==url?url:'';const linkOptions={maxLength,title,href:url,preventClick,tabStop:options.tabStop,bypassURLTrimming};const link=Linkifier._createLink(linkText,className,linkOptions);const info=Linkifier._linkInfo(link);if(typeof lineNumber==='number'){info.lineNumber=lineNumber;}
if(typeof columnNumber==='number'){info.columnNumber=columnNumber;}
return link;}
static linkifyRevealable(revealable,text,fallbackHref){const link=Linkifier._createLink(text,'',{maxLength:UIUtils.MaxLengthForDisplayedURLs,href:fallbackHref});Linkifier._linkInfo(link).revealable=revealable;return link;}
static _createLink(text,className,options){options=options||{};const{maxLength,title,href,preventClick,tabStop,bypassURLTrimming}=options;const link=document.createElement('span');if(className){link.className=className;}
link.classList.add('devtools-link');if(title){link.title=title;}
if(href){link.href=href;}
if(bypassURLTrimming){link.classList.add('devtools-link-styled-trim');Linkifier._appendTextWithoutHashes(link,text);}else{Linkifier._setTrimmedText(link,text,maxLength);}
link[_infoSymbol]={icon:null,enableDecorator:false,uiLocation:null,liveLocation:null,url:href||null,lineNumber:null,columnNumber:null,revealable:null,fallback:null};if(!preventClick){link.addEventListener('click',event=>{if(Linkifier._handleClick(event)){event.consume(true);}},false);link.addEventListener('keydown',event=>{if(isEnterKey(event)&&Linkifier._handleClick(event)){event.consume(true);}},false);}else{link.classList.add('devtools-link-prevent-click');}
ARIAUtils.markAsLink(link);link.tabIndex=tabStop?0:-1;return link;}
static _setTrimmedText(link,text,maxLength){link.removeChildren();if(maxLength&&text.length>maxLength){const middleSplit=splitMiddle(text,maxLength);Linkifier._appendTextWithoutHashes(link,middleSplit[0]);Linkifier._appendHiddenText(link,middleSplit[1]);Linkifier._appendTextWithoutHashes(link,middleSplit[2]);}else{Linkifier._appendTextWithoutHashes(link,text);}
function splitMiddle(string,maxLength){let leftIndex=Math.floor(maxLength/2);let rightIndex=string.length-Math.ceil(maxLength/2)+1;if(string.codePointAt(rightIndex-1)>=0x10000){rightIndex++;leftIndex++;}
if(leftIndex>0&&string.codePointAt(leftIndex-1)>=0x10000){leftIndex--;}
return[string.substring(0,leftIndex),string.substring(leftIndex,rightIndex),string.substring(rightIndex)];}}
static _appendTextWithoutHashes(link,string){const hashSplit=TextUtils.Utils.splitStringByRegexes(string,[/[a-f0-9]{20,}/g]);for(const match of hashSplit){if(match.regexIndex===-1){link.createTextChild(match.value);}else{link.createTextChild(match.value.substring(0,7));Linkifier._appendHiddenText(link,match.value.substring(7));}}}
static _appendHiddenText(link,string){const ellipsisNode=link.createChild('span','devtools-link-ellipsis').createTextChild('…');ellipsisNode[_untruncatedNodeTextSymbol]=string;}
static untruncatedNodeText(node){return node[_untruncatedNodeTextSymbol]||node.textContent;}
static _linkInfo(link){return(link?link[_infoSymbol]||null:null);}
static _handleClick(event){const link=(event.currentTarget);if(UIUtils.isBeingEdited((event.target))||link.hasSelection()){return false;}
return Linkifier.invokeFirstAction(link);}
static invokeFirstAction(link){const actions=Linkifier._linkActions(link);if(actions.length){actions[0].handler.call(null);return true;}
return false;}
static _linkHandlerSetting(){if(!Linkifier._linkHandlerSettingInstance){Linkifier._linkHandlerSettingInstance=Settings.Settings.instance().createSetting('openLinkHandler',ls`auto`);}
return Linkifier._linkHandlerSettingInstance;}
static registerLinkHandler(title,handler){_linkHandlers.set(title,handler);self.runtime.sharedInstance(LinkHandlerSettingUI)._update();}
static unregisterLinkHandler(title){_linkHandlers.delete(title);self.runtime.sharedInstance(LinkHandlerSettingUI)._update();}
static uiLocation(link){const info=Linkifier._linkInfo(link);return info?info.uiLocation:null;}
static _linkActions(link){const info=Linkifier._linkInfo(link);const result=[];if(!info){return result;}
let url='';let uiLocation=null;if(info.uiLocation){uiLocation=info.uiLocation;url=uiLocation.uiSourceCode.contentURL();}else if(info.url){url=info.url;const uiSourceCode=Workspace.WorkspaceImpl.instance().uiSourceCodeForURL(url)||Workspace.WorkspaceImpl.instance().uiSourceCodeForURL(ParsedURL.ParsedURL.urlWithoutHash(url));uiLocation=uiSourceCode?uiSourceCode.uiLocation(info.lineNumber||0,info.columnNumber||0):null;}
const resource=url?ResourceUtils.resourceForURL(url):null;const contentProvider=uiLocation?uiLocation.uiSourceCode:resource;const revealable=info.revealable||uiLocation||resource;if(revealable){const destination=Revealer.revealDestination(revealable);result.push({section:'reveal',title:destination?ls`Reveal in ${destination}`:ls`Reveal`,handler:()=>Revealer.reveal(revealable)});}
if(contentProvider){const lineNumber=uiLocation?uiLocation.lineNumber:info.lineNumber||0;for(const title of _linkHandlers.keys()){const handler=_linkHandlers.get(title);const action={section:'reveal',title:UIString.UIString('Open using %s',title),handler:handler.bind(null,contentProvider,lineNumber)};if(title===Linkifier._linkHandlerSetting().get()){result.unshift(action);}else{result.push(action);}}}
if(resource||info.url){result.push({section:'reveal',title:UIUtils.openLinkExternallyLabel(),handler:()=>InspectorFrontendHost.InspectorFrontendHostInstance.openInNewTab(url)});result.push({section:'clipboard',title:UIUtils.copyLinkAddressLabel(),handler:()=>InspectorFrontendHost.InspectorFrontendHostInstance.copyText(url)});}
return result;}}
const _instances=new Set();let _decorator=null;const _sourceCodeAnchors=Symbol('Linkifier.anchors');const _infoSymbol=Symbol('Linkifier.info');const _untruncatedNodeTextSymbol=Symbol('Linkifier.untruncatedNodeText');const _linkHandlers=new Map();class LinkDecorator{linkIcon(uiSourceCode){}}
LinkDecorator.Events={LinkIconChanged:Symbol('LinkIconChanged')};class LinkContextMenuProvider{appendApplicableItems(event,contextMenu,target){let targetNode=(target);while(targetNode&&!targetNode[_infoSymbol]){targetNode=targetNode.parentNodeOrShadowHost();}
const link=(targetNode);const actions=Linkifier._linkActions(link);for(const action of actions){contextMenu.section(action.section).appendItem(action.title,action.handler);}}}
class LinkHandlerSettingUI{constructor(){this._element=document.createElement('select');this._element.classList.add('chrome-select');this._element.addEventListener('change',this._onChange.bind(this),false);this._update();}
_update(){this._element.removeChildren();const names=[..._linkHandlers.keys()];names.unshift(UIString.UIString('auto'));for(const name of names){const option=createElement('option');option.textContent=name;option.selected=name===Linkifier._linkHandlerSetting().get();this._element.appendChild(option);}
this._element.disabled=names.length<=1;}
_onChange(event){const value=event.target.value;Linkifier._linkHandlerSetting().set(value);}
settingElement(){return SettingsUI.createCustomSetting(UIString.UIString('Link handling:'),this._element);}}
class ContentProviderContextMenuProvider{appendApplicableItems(event,contextMenu,target){const contentProvider=(target);if(!contentProvider.contentURL()){return;}
contextMenu.revealSection().appendItem(UIUtils.openLinkExternallyLabel(),()=>InspectorFrontendHost.InspectorFrontendHostInstance.openInNewTab(contentProvider.contentURL()));for(const title of _linkHandlers.keys()){const handler=_linkHandlers.get(title);contextMenu.revealSection().appendItem(UIString.UIString('Open using %s',title),handler.bind(null,contentProvider,0));}
if(contentProvider instanceof NetworkRequest.NetworkRequest){return;}
contextMenu.clipboardSection().appendItem(UIUtils.copyLinkAddressLabel(),()=>InspectorFrontendHost.InspectorFrontendHostInstance.copyText(contentProvider.contentURL()));}}
let _LinkInfo;let LinkifyURLOptions;let LinkifyOptions;let _CreateLinkOptions;let LinkHandler;var Linkifier$1=Object.freeze({__proto__:null,Linkifier:Linkifier,LinkDecorator:LinkDecorator,LinkContextMenuProvider:LinkContextMenuProvider,LinkHandlerSettingUI:LinkHandlerSettingUI,ContentProviderContextMenuProvider:ContentProviderContextMenuProvider,_LinkInfo:_LinkInfo,LinkifyURLOptions:LinkifyURLOptions,LinkifyOptions:LinkifyOptions,_CreateLinkOptions:_CreateLinkOptions,LinkHandler:LinkHandler});function buildStackTracePreviewContents(target,linkifier,options={}){const{stackTrace,contentUpdated,tabStops}=options;const element=document.createElement('span');element.classList.add('monospace');element.style.display='inline-block';const shadowRoot=Utils.createShadowRootWithCoreStyles(element,'components/jsUtils.css');const contentElement=shadowRoot.createChild('table','stack-preview-container');let totalHiddenCallFramesCount=0;let totalCallFramesCount=0;const links=[];function appendStackTrace(stackTrace){let hiddenCallFrames=0;for(const stackFrame of stackTrace.callFrames){totalCallFramesCount++;let shouldHide=totalCallFramesCount>30&&stackTrace.callFrames.length>31;const row=createElement('tr');row.createChild('td').textContent='\n';row.createChild('td','function-name').textContent=UIUtils.beautifyFunctionName(stackFrame.functionName);const link=linkifier.maybeLinkifyConsoleCallFrame(target,stackFrame,{tabStop:!!tabStops});if(link){link.addEventListener('contextmenu',populateContextMenu.bind(null,link));const uiLocation=Linkifier.uiLocation(link);if(uiLocation&&BlackboxManager.BlackboxManager.instance().isBlackboxedUISourceCode(uiLocation.uiSourceCode)){shouldHide=true;}
row.createChild('td').textContent=' @ ';row.createChild('td').appendChild(link);links.push(link);}
if(shouldHide){row.classList.add('blackboxed');++hiddenCallFrames;}
contentElement.appendChild(row);}
totalHiddenCallFramesCount+=hiddenCallFrames;return stackTrace.callFrames.length===hiddenCallFrames;}
function populateContextMenu(link,event){const contextMenu=new ContextMenu.ContextMenu(event);event.consume(true);const uiLocation=Linkifier.uiLocation(link);if(uiLocation&&BlackboxManager.BlackboxManager.instance().canBlackboxUISourceCode(uiLocation.uiSourceCode)){if(BlackboxManager.BlackboxManager.instance().isBlackboxedUISourceCode(uiLocation.uiSourceCode)){contextMenu.debugSection().appendItem(ls`Stop blackboxing`,()=>BlackboxManager.BlackboxManager.instance().unblackboxUISourceCode(uiLocation.uiSourceCode));}else{contextMenu.debugSection().appendItem(ls`Blackbox script`,()=>BlackboxManager.BlackboxManager.instance().blackboxUISourceCode(uiLocation.uiSourceCode));}}
contextMenu.appendApplicableItems(event);contextMenu.show();}
if(!stackTrace){return{element,links};}
appendStackTrace(stackTrace);let asyncStackTrace=stackTrace.parent;while(asyncStackTrace){if(!asyncStackTrace.callFrames.length){asyncStackTrace=asyncStackTrace.parent;continue;}
const row=contentElement.createChild('tr');row.createChild('td').textContent='\n';row.createChild('td','stack-preview-async-description').textContent=UIUtils.asyncStackTraceLabel(asyncStackTrace.description);row.createChild('td');row.createChild('td');if(appendStackTrace(asyncStackTrace)){row.classList.add('blackboxed');}
asyncStackTrace=asyncStackTrace.parent;}
if(totalHiddenCallFramesCount){const row=contentElement.createChild('tr','show-blackboxed-link');row.createChild('td').textContent='\n';const cell=row.createChild('td');cell.colSpan=4;const showAllLink=cell.createChild('span','link');if(totalHiddenCallFramesCount===1){showAllLink.textContent=ls`Show 1 more frame`;}else{showAllLink.textContent=ls`Show ${totalHiddenCallFramesCount} more frames`;}
showAllLink.addEventListener('click',()=>{contentElement.classList.add('show-blackboxed');if(contentUpdated){contentUpdated();}},false);}
return{element,links};}
let Options;var JSPresentationUtils=Object.freeze({__proto__:null,buildStackTracePreviewContents:buildStackTracePreviewContents,Options:Options});function reload(){if(self.Components.dockController.canDock()&&self.Components.dockController.dockSide()===State.Undocked){InspectorFrontendHost.InspectorFrontendHostInstance.setIsDocked(true,function(){});}
InspectorFrontendHost.InspectorFrontendHostInstance.reattach(()=>window.location.reload());}
var Reload=Object.freeze({__proto__:null,reload:reload});class TargetDetachedDialog extends SDKModel.SDKModel{constructor(target){super(target);target.registerInspectorDispatcher(this);target.inspectorAgent().enable();this._hideCrashedDialog=null;TargetDetachedDialog._disconnectedScreenWithReasonWasShown=false;}
detached(reason){TargetDetachedDialog._disconnectedScreenWithReasonWasShown=true;RemoteDebuggingTerminatedScreen.RemoteDebuggingTerminatedScreen.show(reason);}
static webSocketConnectionLost(){RemoteDebuggingTerminatedScreen.RemoteDebuggingTerminatedScreen.show(ls`WebSocket disconnected`);}
targetCrashed(){if(this.target().parentTarget()){return;}
const dialog=new Dialog.Dialog();dialog.setSizeBehavior(GlassPane.SizeBehavior.MeasureContent);dialog.addCloseButton();dialog.setDimmed(true);this._hideCrashedDialog=dialog.hide.bind(dialog);new TargetCrashedScreen.TargetCrashedScreen(()=>this._hideCrashedDialog=null).show(dialog.contentElement);dialog.show();}
targetReloadedAfterCrash(){this.target().runtimeAgent().runIfWaitingForDebugger();if(this._hideCrashedDialog){this._hideCrashedDialog.call(null);this._hideCrashedDialog=null;}}}
SDKModel.SDKModel.register(TargetDetachedDialog,SDKModel.Capability.Inspector,true);var TargetDetachedDialog$1=Object.freeze({__proto__:null,TargetDetachedDialog:TargetDetachedDialog});export{DockController$1 as DockController,ImagePreview$1 as ImagePreview,JSPresentationUtils,Linkifier$1 as Linkifier,Reload,TargetDetachedDialog$1 as TargetDetachedDialog};