import{UIString,Color,ObjectWrapper}from'../common/common.js';import{NumberUtilities}from'../platform/platform.js';import{Geometry,Widget,UIUtils,Utils,Icon,KeyboardShortcut,GlassPane}from'../ui/ui.js';import{TextUtils}from'../text_utils/text_utils.js';class BezierUI{constructor(width,height,marginTop,controlPointRadius,linearLine){this.width=width;this.height=height;this.marginTop=marginTop;this.radius=controlPointRadius;this.linearLine=linearLine;}
static drawVelocityChart(bezier,path,width){const height=Height;let pathBuilder=['M',0,height];const sampleSize=1/40;let prev=bezier.evaluateAt(0);for(let t=sampleSize;t<1+sampleSize;t+=sampleSize){const current=bezier.evaluateAt(t);let slope=(current.y-prev.y)/(current.x-prev.x);const weightedX=prev.x*(1-t)+current.x*t;slope=Math.tanh(slope/1.5);pathBuilder=pathBuilder.concat(['L',(weightedX*width).toFixed(2),(height-slope*height).toFixed(2)]);prev=current;}
pathBuilder=pathBuilder.concat(['L',width.toFixed(2),height,'Z']);path.setAttribute('d',pathBuilder.join(' '));}
curveWidth(){return this.width-this.radius*2;}
curveHeight(){return this.height-this.radius*2-this.marginTop*2;}
_drawLine(parentElement,className,x1,y1,x2,y2){const line=parentElement.createSVGChild('line',className);line.setAttribute('x1',x1+this.radius);line.setAttribute('y1',y1+this.radius+this.marginTop);line.setAttribute('x2',x2+this.radius);line.setAttribute('y2',y2+this.radius+this.marginTop);}
_drawControlPoints(parentElement,startX,startY,controlX,controlY){this._drawLine(parentElement,'bezier-control-line',startX,startY,controlX,controlY);const circle=parentElement.createSVGChild('circle','bezier-control-circle');circle.setAttribute('cx',controlX+this.radius);circle.setAttribute('cy',controlY+this.radius+this.marginTop);circle.setAttribute('r',this.radius);}
drawCurve(bezier,svg){if(!bezier){return;}
const width=this.curveWidth();const height=this.curveHeight();svg.setAttribute('width',this.width);svg.setAttribute('height',this.height);svg.removeChildren();const group=svg.createSVGChild('g');if(this.linearLine){this._drawLine(group,'linear-line',0,height,width,0);}
const curve=group.createSVGChild('path','bezier-path');const curvePoints=[new Geometry.Point(bezier.controlPoints[0].x*width+this.radius,(1-bezier.controlPoints[0].y)*height+this.radius+this.marginTop),new Geometry.Point(bezier.controlPoints[1].x*width+this.radius,(1-bezier.controlPoints[1].y)*height+this.radius+this.marginTop),new Geometry.Point(width+this.radius,this.marginTop+this.radius)];curve.setAttribute('d','M'+this.radius+','+(height+this.radius+this.marginTop)+' C'+curvePoints.join(' '));this._drawControlPoints(group,0,height,bezier.controlPoints[0].x*width,(1-bezier.controlPoints[0].y)*height);this._drawControlPoints(group,width,0,bezier.controlPoints[1].x*width,(1-bezier.controlPoints[1].y)*height);}}
const Height=26;var BezierUI$1=Object.freeze({__proto__:null,BezierUI:BezierUI,Height:Height});class BezierEditor extends Widget.VBox{constructor(){super(true);this.registerRequiredCSS('inline_editor/bezierEditor.css');this.contentElement.tabIndex=0;this.setDefaultFocusedElement(this.contentElement);this._previewElement=this.contentElement.createChild('div','bezier-preview-container');this._previewElement.createChild('div','bezier-preview-animation');this._previewElement.addEventListener('click',this._startPreviewAnimation.bind(this));this._previewOnion=this.contentElement.createChild('div','bezier-preview-onion');this._previewOnion.addEventListener('click',this._startPreviewAnimation.bind(this));this._outerContainer=this.contentElement.createChild('div','bezier-container');this._presetsContainer=this._outerContainer.createChild('div','bezier-presets');this._presetUI=new BezierUI(40,40,0,2,false);this._presetCategories=[];for(let i=0;i<Presets.length;i++){this._presetCategories[i]=this._createCategory(Presets[i]);this._presetsContainer.appendChild(this._presetCategories[i].icon);}
this._curveUI=new BezierUI(150,250,50,7,true);this._curve=this._outerContainer.createSVGChild('svg','bezier-curve');UIUtils.installDragHandle(this._curve,this._dragStart.bind(this),this._dragMove.bind(this),this._dragEnd.bind(this),'default');this._header=this.contentElement.createChild('div','bezier-header');const minus=this._createPresetModifyIcon(this._header,'bezier-preset-minus','M 12 6 L 8 10 L 12 14');const plus=this._createPresetModifyIcon(this._header,'bezier-preset-plus','M 8 6 L 12 10 L 8 14');minus.addEventListener('click',this._presetModifyClicked.bind(this,false));plus.addEventListener('click',this._presetModifyClicked.bind(this,true));this._label=this._header.createChild('span','source-code bezier-display-value');}
setBezier(bezier){if(!bezier){return;}
this._bezier=bezier;this._updateUI();}
bezier(){return this._bezier;}
wasShown(){this._unselectPresets();for(const category of this._presetCategories){for(let i=0;i<category.presets.length;i++){if(this._bezier.asCSSText()===category.presets[i].value){category.presetIndex=i;this._presetCategorySelected(category);}}}
this._updateUI();this._startPreviewAnimation();}
_onchange(){this._updateUI();this.dispatchEventToListeners(Events.BezierChanged,this._bezier.asCSSText());}
_updateUI(){const labelText=this._selectedCategory?this._selectedCategory.presets[this._selectedCategory.presetIndex].name:this._bezier.asCSSText().replace(/\s(-\d\.\d)/g,'$1');this._label.textContent=UIString.UIString(labelText);this._curveUI.drawCurve(this._bezier,this._curve);this._previewOnion.removeChildren();}
_dragStart(event){this._mouseDownPosition=new Geometry.Point(event.x,event.y);const ui=this._curveUI;this._controlPosition=new Geometry.Point(NumberUtilities.clamp((event.offsetX-ui.radius)/ui.curveWidth(),0,1),(ui.curveHeight()+ui.marginTop+ui.radius-event.offsetY)/ui.curveHeight());const firstControlPointIsCloser=this._controlPosition.distanceTo(this._bezier.controlPoints[0])<this._controlPosition.distanceTo(this._bezier.controlPoints[1]);this._selectedPoint=firstControlPointIsCloser?0:1;this._bezier.controlPoints[this._selectedPoint]=this._controlPosition;this._unselectPresets();this._onchange();event.consume(true);return true;}
_updateControlPosition(mouseX,mouseY){const deltaX=(mouseX-this._mouseDownPosition.x)/this._curveUI.curveWidth();const deltaY=(mouseY-this._mouseDownPosition.y)/this._curveUI.curveHeight();const newPosition=new Geometry.Point(NumberUtilities.clamp(this._controlPosition.x+deltaX,0,1),this._controlPosition.y-deltaY);this._bezier.controlPoints[this._selectedPoint]=newPosition;}
_dragMove(event){this._updateControlPosition(event.x,event.y);this._onchange();}
_dragEnd(event){this._updateControlPosition(event.x,event.y);this._onchange();this._startPreviewAnimation();}
_createCategory(presetGroup){const presetElement=createElementWithClass('div','bezier-preset-category');const iconElement=presetElement.createSVGChild('svg','bezier-preset monospace');const category={presets:presetGroup,presetIndex:0,icon:presetElement};this._presetUI.drawCurve(Geometry.CubicBezier.parse(category.presets[0].value),iconElement);iconElement.addEventListener('click',this._presetCategorySelected.bind(this,category));return category;}
_createPresetModifyIcon(parentElement,className,drawPath){const icon=parentElement.createSVGChild('svg','bezier-preset-modify '+className);icon.setAttribute('width',20);icon.setAttribute('height',20);const path=icon.createSVGChild('path');path.setAttribute('d',drawPath);return icon;}
_unselectPresets(){for(const category of this._presetCategories){category.icon.classList.remove('bezier-preset-selected');}
delete this._selectedCategory;this._header.classList.remove('bezier-header-active');}
_presetCategorySelected(category,event){if(this._selectedCategory===category){return;}
this._unselectPresets();this._header.classList.add('bezier-header-active');this._selectedCategory=category;this._selectedCategory.icon.classList.add('bezier-preset-selected');this.setBezier(Geometry.CubicBezier.parse(category.presets[category.presetIndex].value));this._onchange();this._startPreviewAnimation();if(event){event.consume(true);}}
_presetModifyClicked(intensify,event){if(!this._selectedCategory){return;}
const length=this._selectedCategory.presets.length;this._selectedCategory.presetIndex=(this._selectedCategory.presetIndex+(intensify?1:-1)+length)%length;this.setBezier(Geometry.CubicBezier.parse(this._selectedCategory.presets[this._selectedCategory.presetIndex].value));this._onchange();this._startPreviewAnimation();}
_startPreviewAnimation(){if(this._previewAnimation){this._previewAnimation.cancel();}
const animationDuration=1600;const numberOnionSlices=20;const keyframes=[{offset:0,transform:'translateX(0px)',easing:this._bezier.asCSSText(),opacity:1},{offset:0.9,transform:'translateX(218px)',opacity:1},{offset:1,transform:'translateX(218px)',opacity:0}];this._previewAnimation=this._previewElement.animate(keyframes,animationDuration);this._previewOnion.removeChildren();for(let i=0;i<=numberOnionSlices;i++){const slice=this._previewOnion.createChild('div','bezier-preview-animation');const player=slice.animate([{transform:'translateX(0px)',easing:this._bezier.asCSSText()},{transform:'translateX(218px)'}],{duration:animationDuration,fill:'forwards'});player.pause();player.currentTime=animationDuration*i/numberOnionSlices;}}}
const Events={BezierChanged:Symbol('BezierChanged')};const Presets=[[{name:'ease-in-out',value:'ease-in-out'},{name:'In Out · Sine',value:'cubic-bezier(0.45, 0.05, 0.55, 0.95)'},{name:'In Out · Quadratic',value:'cubic-bezier(0.46, 0.03, 0.52, 0.96)'},{name:'In Out · Cubic',value:'cubic-bezier(0.65, 0.05, 0.36, 1)'},{name:'Fast Out, Slow In',value:'cubic-bezier(0.4, 0, 0.2, 1)'},{name:'In Out · Back',value:'cubic-bezier(0.68, -0.55, 0.27, 1.55)'}],[{name:'Fast Out, Linear In',value:'cubic-bezier(0.4, 0, 1, 1)'},{name:'ease-in',value:'ease-in'},{name:'In · Sine',value:'cubic-bezier(0.47, 0, 0.75, 0.72)'},{name:'In · Quadratic',value:'cubic-bezier(0.55, 0.09, 0.68, 0.53)'},{name:'In · Cubic',value:'cubic-bezier(0.55, 0.06, 0.68, 0.19)'},{name:'In · Back',value:'cubic-bezier(0.6, -0.28, 0.74, 0.05)'}],[{name:'ease-out',value:'ease-out'},{name:'Out · Sine',value:'cubic-bezier(0.39, 0.58, 0.57, 1)'},{name:'Out · Quadratic',value:'cubic-bezier(0.25, 0.46, 0.45, 0.94)'},{name:'Out · Cubic',value:'cubic-bezier(0.22, 0.61, 0.36, 1)'},{name:'Linear Out, Slow In',value:'cubic-bezier(0, 0, 0.2, 1)'},{name:'Out · Back',value:'cubic-bezier(0.18, 0.89, 0.32, 1.28)'}]];let PresetCategory;var BezierEditor$1=Object.freeze({__proto__:null,BezierEditor:BezierEditor,Events:Events,Presets:Presets,PresetCategory:PresetCategory});class CSSShadowModel{constructor(isBoxShadow){this._isBoxShadow=isBoxShadow;this._inset=false;this._offsetX=CSSLength.zero();this._offsetY=CSSLength.zero();this._blurRadius=CSSLength.zero();this._spreadRadius=CSSLength.zero();this._color=(Color.Color.parse('black'));this._format=[_Part.OffsetX,_Part.OffsetY];}
static parseTextShadow(text){return CSSShadowModel._parseShadow(text,false);}
static parseBoxShadow(text){return CSSShadowModel._parseShadow(text,true);}
static _parseShadow(text,isBoxShadow){const shadowTexts=[];const splits=TextUtils.Utils.splitStringByRegexes(text,[Color.Regex,/,/g]);let currentIndex=0;for(let i=0;i<splits.length;i++){if(splits[i].regexIndex===1){const comma=splits[i];shadowTexts.push(text.substring(currentIndex,comma.position));currentIndex=comma.position+1;}}
shadowTexts.push(text.substring(currentIndex,text.length));const shadows=[];for(let i=0;i<shadowTexts.length;i++){const shadow=new CSSShadowModel(isBoxShadow);shadow._format=[];let nextPartAllowed=true;const regexes=[/inset/gi,Color.Regex,CSSLength.Regex];const results=TextUtils.Utils.splitStringByRegexes(shadowTexts[i],regexes);for(let j=0;j<results.length;j++){const result=results[j];if(result.regexIndex===-1){if(/\S/.test(result.value)){return[];}
nextPartAllowed=true;}else{if(!nextPartAllowed){return[];}
nextPartAllowed=false;if(result.regexIndex===0){shadow._inset=true;shadow._format.push(_Part.Inset);}else if(result.regexIndex===1){const color=Color.Color.parse(result.value);if(!color){return[];}
shadow._color=color;shadow._format.push(_Part.Color);}else if(result.regexIndex===2){const length=CSSLength.parse(result.value);if(!length){return[];}
const previousPart=shadow._format.length>0?shadow._format[shadow._format.length-1]:'';if(previousPart===_Part.OffsetX){shadow._offsetY=length;shadow._format.push(_Part.OffsetY);}else if(previousPart===_Part.OffsetY){shadow._blurRadius=length;shadow._format.push(_Part.BlurRadius);}else if(previousPart===_Part.BlurRadius){shadow._spreadRadius=length;shadow._format.push(_Part.SpreadRadius);}else{shadow._offsetX=length;shadow._format.push(_Part.OffsetX);}}}}
if(invalidCount(shadow,_Part.OffsetX,1,1)||invalidCount(shadow,_Part.OffsetY,1,1)||invalidCount(shadow,_Part.Color,0,1)||invalidCount(shadow,_Part.BlurRadius,0,1)||invalidCount(shadow,_Part.Inset,0,isBoxShadow?1:0)||invalidCount(shadow,_Part.SpreadRadius,0,isBoxShadow?1:0)){return[];}
shadows.push(shadow);}
return shadows;function invalidCount(shadow,part,min,max){let count=0;for(let i=0;i<shadow._format.length;i++){if(shadow._format[i]===part){count++;}}
return count<min||count>max;}}
setInset(inset){this._inset=inset;if(this._format.indexOf(_Part.Inset)===-1){this._format.unshift(_Part.Inset);}}
setOffsetX(offsetX){this._offsetX=offsetX;}
setOffsetY(offsetY){this._offsetY=offsetY;}
setBlurRadius(blurRadius){this._blurRadius=blurRadius;if(this._format.indexOf(_Part.BlurRadius)===-1){const yIndex=this._format.indexOf(_Part.OffsetY);this._format.splice(yIndex+1,0,_Part.BlurRadius);}}
setSpreadRadius(spreadRadius){this._spreadRadius=spreadRadius;if(this._format.indexOf(_Part.SpreadRadius)===-1){this.setBlurRadius(this._blurRadius);const blurIndex=this._format.indexOf(_Part.BlurRadius);this._format.splice(blurIndex+1,0,_Part.SpreadRadius);}}
setColor(color){this._color=color;if(this._format.indexOf(_Part.Color)===-1){this._format.push(_Part.Color);}}
isBoxShadow(){return this._isBoxShadow;}
inset(){return this._inset;}
offsetX(){return this._offsetX;}
offsetY(){return this._offsetY;}
blurRadius(){return this._blurRadius;}
spreadRadius(){return this._spreadRadius;}
color(){return this._color;}
asCSSText(){const parts=[];for(let i=0;i<this._format.length;i++){const part=this._format[i];if(part===_Part.Inset&&this._inset){parts.push('inset');}else if(part===_Part.OffsetX){parts.push(this._offsetX.asCSSText());}else if(part===_Part.OffsetY){parts.push(this._offsetY.asCSSText());}else if(part===_Part.BlurRadius){parts.push(this._blurRadius.asCSSText());}else if(part===_Part.SpreadRadius){parts.push(this._spreadRadius.asCSSText());}else if(part===_Part.Color){parts.push(this._color.asString(this._color.format()));}}
return parts.join(' ');}}
const _Part={Inset:'I',OffsetX:'X',OffsetY:'Y',BlurRadius:'B',SpreadRadius:'S',Color:'C'};class CSSLength{constructor(amount,unit){this.amount=amount;this.unit=unit;}
static parse(text){const lengthRegex=new RegExp('^(?:'+CSSLength.Regex.source+')$','i');const match=text.match(lengthRegex);if(!match){return null;}
if(match.length>2&&match[2]){return new CSSLength(parseFloat(match[1]),match[2]);}
return CSSLength.zero();}
static zero(){return new CSSLength(0,'');}
asCSSText(){return this.amount+this.unit;}}
CSSLength.Regex=(function(){const number='([+-]?(?:[0-9]*[.])?[0-9]+(?:[eE][+-]?[0-9]+)?)';const unit='(ch|cm|em|ex|in|mm|pc|pt|px|rem|vh|vmax|vmin|vw)';const zero='[+-]?(?:0*[.])?0+(?:[eE][+-]?[0-9]+)?';return new RegExp(number+unit+'|'+zero,'gi');})();var CSSShadowModel$1=Object.freeze({__proto__:null,CSSShadowModel:CSSShadowModel,_Part:_Part,CSSLength:CSSLength});class ColorSwatch extends HTMLSpanElement{constructor(){super();const root=Utils.createShadowRootWithCoreStyles(this,'inline_editor/colorSwatch.css');this._iconElement=root.createChild('span','color-swatch');this._iconElement.title=UIString.UIString('Shift-click to change color format');this._swatchInner=this._iconElement.createChild('span','color-swatch-inner');this._swatchInner.addEventListener('dblclick',e=>e.consume(),false);this._swatchInner.addEventListener('mousedown',e=>e.consume(),false);this._swatchInner.addEventListener('click',this._handleClick.bind(this),true);root.createChild('slot');this._colorValueElement=this.createChild('span');}
static create(){if(!ColorSwatch._constructor){ColorSwatch._constructor=Utils.registerCustomElement('span','color-swatch',ColorSwatch);}
return(ColorSwatch._constructor());}
static _nextColorFormat(color,curFormat){const cf=Color.Format;switch(curFormat){case cf.Original:return!color.hasAlpha()?cf.RGB:cf.RGBA;case cf.RGB:case cf.RGBA:return!color.hasAlpha()?cf.HSL:cf.HSLA;case cf.HSL:case cf.HSLA:if(color.nickname()){return cf.Nickname;}
return color.detectHEXFormat();case cf.ShortHEX:return cf.HEX;case cf.ShortHEXA:return cf.HEXA;case cf.HEXA:case cf.HEX:return cf.Original;case cf.Nickname:return color.detectHEXFormat();default:return cf.RGBA;}}
color(){return this._color;}
setColor(color){this._color=color;this._format=this._color.format();const colorString=(this._color.asString(this._format));this.setText(colorString);this._swatchInner.style.backgroundColor=colorString;}
hideText(hide){this._colorValueElement.hidden=hide;}
setText(text,tooltip){this._colorValueElement.textContent=text;this._colorValueElement.title=tooltip;}
format(){return this._format;}
setFormat(format){this._format=format;this.setText(this._color.asString(this._format));}
toggleNextFormat(){let currentValue;do{this._format=ColorSwatch._nextColorFormat(this._color,this._format);currentValue=this._color.asString(this._format);}while(currentValue===this._colorValueElement.textContent);this.setText(currentValue);}
iconElement(){return this._iconElement;}
_handleClick(event){if(!event.shiftKey){return;}
event.target.parentNode.parentNode.host.toggleNextFormat();event.consume(true);}}
class BezierSwatch extends HTMLSpanElement{constructor(){super();const root=Utils.createShadowRootWithCoreStyles(this,'inline_editor/bezierSwatch.css');this._iconElement=Icon.Icon.create('smallicon-bezier','bezier-swatch-icon');root.appendChild(this._iconElement);this._textElement=this.createChild('span');root.createChild('slot');}
static create(){if(!BezierSwatch._constructor){BezierSwatch._constructor=Utils.registerCustomElement('span','bezier-swatch',BezierSwatch);}
return(BezierSwatch._constructor());}
bezierText(){return this._textElement.textContent;}
setBezierText(text){this._textElement.textContent=text;}
hideText(hide){this._textElement.hidden=hide;}
iconElement(){return this._iconElement;}}
class CSSShadowSwatch extends HTMLSpanElement{constructor(){super();const root=Utils.createShadowRootWithCoreStyles(this,'inline_editor/cssShadowSwatch.css');this._iconElement=Icon.Icon.create('smallicon-shadow','shadow-swatch-icon');root.appendChild(this._iconElement);root.createChild('slot');this._contentElement=this.createChild('span');}
static create(){if(!CSSShadowSwatch._constructor){CSSShadowSwatch._constructor=Utils.registerCustomElement('span','css-shadow-swatch',CSSShadowSwatch);}
return(CSSShadowSwatch._constructor());}
model(){return this._model;}
setCSSShadow(model){this._model=model;this._contentElement.removeChildren();const results=TextUtils.Utils.splitStringByRegexes(model.asCSSText(),[/inset/g,Color.Regex]);for(let i=0;i<results.length;i++){const result=results[i];if(result.regexIndex===1){if(!this._colorSwatch){this._colorSwatch=ColorSwatch.create();}
this._colorSwatch.setColor(model.color());this._contentElement.appendChild(this._colorSwatch);}else{this._contentElement.appendChild(createTextNode(result.value));}}}
hideText(hide){this._contentElement.hidden=hide;}
iconElement(){return this._iconElement;}
colorSwatch(){return this._colorSwatch;}}
var ColorSwatch$1=Object.freeze({__proto__:null,ColorSwatch:ColorSwatch,BezierSwatch:BezierSwatch,CSSShadowSwatch:CSSShadowSwatch});const maxRange=20;const defaultUnit='px';const sliderThumbRadius=6;const canvasSize=88;class CSSShadowEditor extends Widget.VBox{constructor(){super(true);this.registerRequiredCSS('inline_editor/cssShadowEditor.css');this.contentElement.tabIndex=0;this.setDefaultFocusedElement(this.contentElement);this._typeField=this.contentElement.createChild('div','shadow-editor-field shadow-editor-flex-field');this._typeField.createChild('label','shadow-editor-label').textContent=UIString.UIString('Type');this._outsetButton=this._typeField.createChild('button','shadow-editor-button-left');this._outsetButton.textContent=UIString.UIString('Outset');this._outsetButton.addEventListener('click',this._onButtonClick.bind(this),false);this._insetButton=this._typeField.createChild('button','shadow-editor-button-right');this._insetButton.textContent=UIString.UIString('Inset');this._insetButton.addEventListener('click',this._onButtonClick.bind(this),false);const xField=this.contentElement.createChild('div','shadow-editor-field');this._xInput=this._createTextInput(xField,UIString.UIString('X offset'));const yField=this.contentElement.createChild('div','shadow-editor-field');this._yInput=this._createTextInput(yField,UIString.UIString('Y offset'));this._xySlider=xField.createChild('canvas','shadow-editor-2D-slider');this._xySlider.width=canvasSize;this._xySlider.height=canvasSize;this._xySlider.tabIndex=-1;this._halfCanvasSize=canvasSize/2;this._innerCanvasSize=this._halfCanvasSize-sliderThumbRadius;UIUtils.installDragHandle(this._xySlider,this._dragStart.bind(this),this._dragMove.bind(this),null,'default');this._xySlider.addEventListener('keydown',this._onCanvasArrowKey.bind(this),false);this._xySlider.addEventListener('blur',this._onCanvasBlur.bind(this),false);const blurField=this.contentElement.createChild('div','shadow-editor-field shadow-editor-flex-field shadow-editor-blur-field');this._blurInput=this._createTextInput(blurField,UIString.UIString('Blur'));this._blurSlider=this._createSlider(blurField);this._spreadField=this.contentElement.createChild('div','shadow-editor-field shadow-editor-flex-field');this._spreadInput=this._createTextInput(this._spreadField,UIString.UIString('Spread'));this._spreadSlider=this._createSlider(this._spreadField);}
_createTextInput(field,propertyName){const label=field.createChild('label','shadow-editor-label');label.textContent=propertyName;label.setAttribute('for',propertyName);const textInput=UIUtils.createInput('shadow-editor-text-input','text');field.appendChild(textInput);textInput.id=propertyName;textInput.addEventListener('keydown',this._handleValueModification.bind(this),false);textInput.addEventListener('mousewheel',this._handleValueModification.bind(this),false);textInput.addEventListener('input',this._onTextInput.bind(this),false);textInput.addEventListener('blur',this._onTextBlur.bind(this),false);return textInput;}
_createSlider(field){const slider=UIUtils.createSlider(0,maxRange,-1);slider.addEventListener('input',this._onSliderInput.bind(this),false);field.appendChild(slider);return slider;}
wasShown(){this._updateUI();}
setModel(model){this._model=model;this._typeField.classList.toggle('hidden',!model.isBoxShadow());this._spreadField.classList.toggle('hidden',!model.isBoxShadow());this._updateUI();}
_updateUI(){this._updateButtons();this._xInput.value=this._model.offsetX().asCSSText();this._yInput.value=this._model.offsetY().asCSSText();this._blurInput.value=this._model.blurRadius().asCSSText();this._spreadInput.value=this._model.spreadRadius().asCSSText();this._blurSlider.value=this._model.blurRadius().amount;this._spreadSlider.value=this._model.spreadRadius().amount;this._updateCanvas(false);}
_updateButtons(){this._insetButton.classList.toggle('enabled',this._model.inset());this._outsetButton.classList.toggle('enabled',!this._model.inset());}
_updateCanvas(drawFocus){const context=this._xySlider.getContext('2d');context.clearRect(0,0,this._xySlider.width,this._xySlider.height);context.save();context.setLineDash([1,1]);context.strokeStyle='rgba(210, 210, 210, 0.8)';context.beginPath();context.moveTo(this._halfCanvasSize,0);context.lineTo(this._halfCanvasSize,canvasSize);context.moveTo(0,this._halfCanvasSize);context.lineTo(canvasSize,this._halfCanvasSize);context.stroke();context.restore();const thumbPoint=this._sliderThumbPosition();context.save();context.translate(this._halfCanvasSize,this._halfCanvasSize);context.lineWidth=2;context.strokeStyle='rgba(130, 130, 130, 0.75)';context.beginPath();context.moveTo(0,0);context.lineTo(thumbPoint.x,thumbPoint.y);context.stroke();if(drawFocus){context.beginPath();context.fillStyle='rgba(66, 133, 244, 0.4)';context.arc(thumbPoint.x,thumbPoint.y,sliderThumbRadius+2,0,2*Math.PI);context.fill();}
context.beginPath();context.fillStyle='#4285F4';context.arc(thumbPoint.x,thumbPoint.y,sliderThumbRadius,0,2*Math.PI);context.fill();context.restore();}
_onButtonClick(event){const insetClicked=(event.currentTarget===this._insetButton);if(insetClicked&&this._model.inset()||!insetClicked&&!this._model.inset()){return;}
this._model.setInset(insetClicked);this._updateButtons();this.dispatchEventToListeners(Events$1.ShadowChanged,this._model);}
_handleValueModification(event){const modifiedValue=UIUtils.createReplacementString(event.currentTarget.value,event,customNumberHandler);if(!modifiedValue){return;}
const length=CSSLength.parse(modifiedValue);if(!length){return;}
if(event.currentTarget===this._blurInput&&length.amount<0){length.amount=0;}
event.currentTarget.value=length.asCSSText();event.currentTarget.selectionStart=0;event.currentTarget.selectionEnd=event.currentTarget.value.length;this._onTextInput(event);event.consume(true);function customNumberHandler(prefix,number,suffix){if(!suffix.length){suffix=defaultUnit;}
return prefix+number+suffix;}}
_onTextInput(event){this._changedElement=event.currentTarget;this._changedElement.classList.remove('invalid');const length=CSSLength.parse(event.currentTarget.value);if(!length||event.currentTarget===this._blurInput&&length.amount<0){return;}
if(event.currentTarget===this._xInput){this._model.setOffsetX(length);this._updateCanvas(false);}else if(event.currentTarget===this._yInput){this._model.setOffsetY(length);this._updateCanvas(false);}else if(event.currentTarget===this._blurInput){this._model.setBlurRadius(length);this._blurSlider.value=length.amount;}else if(event.currentTarget===this._spreadInput){this._model.setSpreadRadius(length);this._spreadSlider.value=length.amount;}
this.dispatchEventToListeners(Events$1.ShadowChanged,this._model);}
_onTextBlur(){if(!this._changedElement){return;}
let length=!this._changedElement.value.trim()?CSSLength.zero():CSSLength.parse(this._changedElement.value);if(!length){length=CSSLength.parse(this._changedElement.value+defaultUnit);}
if(!length){this._changedElement.classList.add('invalid');this._changedElement=null;return;}
if(this._changedElement===this._xInput){this._model.setOffsetX(length);this._xInput.value=length.asCSSText();this._updateCanvas(false);}else if(this._changedElement===this._yInput){this._model.setOffsetY(length);this._yInput.value=length.asCSSText();this._updateCanvas(false);}else if(this._changedElement===this._blurInput){if(length.amount<0){length=CSSLength.zero();}
this._model.setBlurRadius(length);this._blurInput.value=length.asCSSText();this._blurSlider.value=length.amount;}else if(this._changedElement===this._spreadInput){this._model.setSpreadRadius(length);this._spreadInput.value=length.asCSSText();this._spreadSlider.value=length.amount;}
this._changedElement=null;this.dispatchEventToListeners(Events$1.ShadowChanged,this._model);}
_onSliderInput(event){if(event.currentTarget===this._blurSlider){this._model.setBlurRadius(new CSSLength(this._blurSlider.value,this._model.blurRadius().unit||defaultUnit));this._blurInput.value=this._model.blurRadius().asCSSText();this._blurInput.classList.remove('invalid');}else if(event.currentTarget===this._spreadSlider){this._model.setSpreadRadius(new CSSLength(this._spreadSlider.value,this._model.spreadRadius().unit||defaultUnit));this._spreadInput.value=this._model.spreadRadius().asCSSText();this._spreadInput.classList.remove('invalid');}
this.dispatchEventToListeners(Events$1.ShadowChanged,this._model);}
_dragStart(event){this._xySlider.focus();this._updateCanvas(true);this._canvasOrigin=new Geometry.Point(this._xySlider.totalOffsetLeft()+this._halfCanvasSize,this._xySlider.totalOffsetTop()+this._halfCanvasSize);const clickedPoint=new Geometry.Point(event.x-this._canvasOrigin.x,event.y-this._canvasOrigin.y);const thumbPoint=this._sliderThumbPosition();if(clickedPoint.distanceTo(thumbPoint)>=sliderThumbRadius){this._dragMove(event);}
return true;}
_dragMove(event){let point=new Geometry.Point(event.x-this._canvasOrigin.x,event.y-this._canvasOrigin.y);if(event.shiftKey){point=this._snapToClosestDirection(point);}
const constrainedPoint=this._constrainPoint(point,this._innerCanvasSize);const newX=Math.round((constrainedPoint.x/this._innerCanvasSize)*maxRange);const newY=Math.round((constrainedPoint.y/this._innerCanvasSize)*maxRange);if(event.shiftKey){this._model.setOffsetX(new CSSLength(newX,this._model.offsetX().unit||defaultUnit));this._model.setOffsetY(new CSSLength(newY,this._model.offsetY().unit||defaultUnit));}else{if(!event.altKey){this._model.setOffsetX(new CSSLength(newX,this._model.offsetX().unit||defaultUnit));}
if(!KeyboardShortcut.KeyboardShortcut.eventHasCtrlOrMeta(event)){this._model.setOffsetY(new CSSLength(newY,this._model.offsetY().unit||defaultUnit));}}
this._xInput.value=this._model.offsetX().asCSSText();this._yInput.value=this._model.offsetY().asCSSText();this._xInput.classList.remove('invalid');this._yInput.classList.remove('invalid');this._updateCanvas(true);this.dispatchEventToListeners(Events$1.ShadowChanged,this._model);}
_onCanvasBlur(){this._updateCanvas(false);}
_onCanvasArrowKey(event){let shiftX=0;let shiftY=0;if(event.key==='ArrowRight'){shiftX=1;}else if(event.key==='ArrowLeft'){shiftX=-1;}else if(event.key==='ArrowUp'){shiftY=-1;}else if(event.key==='ArrowDown'){shiftY=1;}
if(!shiftX&&!shiftY){return;}
event.consume(true);if(shiftX){const offsetX=this._model.offsetX();const newAmount=NumberUtilities.clamp(offsetX.amount+shiftX,-maxRange,maxRange);if(newAmount===offsetX.amount){return;}
this._model.setOffsetX(new CSSLength(newAmount,offsetX.unit||defaultUnit));this._xInput.value=this._model.offsetX().asCSSText();this._xInput.classList.remove('invalid');}
if(shiftY){const offsetY=this._model.offsetY();const newAmount=NumberUtilities.clamp(offsetY.amount+shiftY,-maxRange,maxRange);if(newAmount===offsetY.amount){return;}
this._model.setOffsetY(new CSSLength(newAmount,offsetY.unit||defaultUnit));this._yInput.value=this._model.offsetY().asCSSText();this._yInput.classList.remove('invalid');}
this._updateCanvas(true);this.dispatchEventToListeners(Events$1.ShadowChanged,this._model);}
_constrainPoint(point,max){if(Math.abs(point.x)<=max&&Math.abs(point.y)<=max){return new Geometry.Point(point.x,point.y);}
return point.scale(max/Math.max(Math.abs(point.x),Math.abs(point.y)));}
_snapToClosestDirection(point){let minDistance=Number.MAX_VALUE;let closestPoint=point;const directions=[new Geometry.Point(0,-1),new Geometry.Point(1,-1),new Geometry.Point(1,0),new Geometry.Point(1,1)];for(const direction of directions){const projection=point.projectOn(direction);const distance=point.distanceTo(projection);if(distance<minDistance){minDistance=distance;closestPoint=projection;}}
return closestPoint;}
_sliderThumbPosition(){const x=(this._model.offsetX().amount/maxRange)*this._innerCanvasSize;const y=(this._model.offsetY().amount/maxRange)*this._innerCanvasSize;return this._constrainPoint(new Geometry.Point(x,y),this._innerCanvasSize);}}
const Events$1={ShadowChanged:Symbol('ShadowChanged')};var CSSShadowEditor$1=Object.freeze({__proto__:null,CSSShadowEditor:CSSShadowEditor,Events:Events$1});class SwatchPopoverHelper extends ObjectWrapper.ObjectWrapper{constructor(){super();this._popover=new GlassPane.GlassPane();this._popover.registerRequiredCSS('inline_editor/swatchPopover.css');this._popover.setSizeBehavior(GlassPane.SizeBehavior.MeasureContent);this._popover.setMarginBehavior(GlassPane.MarginBehavior.Arrow);this._popover.element.addEventListener('mousedown',e=>e.consume(),false);this._hideProxy=this.hide.bind(this,true);this._boundOnKeyDown=this._onKeyDown.bind(this);this._boundFocusOut=this._onFocusOut.bind(this);this._isHidden=true;}
_onFocusOut(event){if(!event.relatedTarget||event.relatedTarget.isSelfOrDescendant(this._view.contentElement)){return;}
this._hideProxy();}
isShowing(){return this._popover.isShowing();}
show(view,anchorElement,hiddenCallback){if(this._popover.isShowing()){if(this._anchorElement===anchorElement){return;}
this.hide(true);}
delete this._isHidden;this._anchorElement=anchorElement;this._view=view;this._hiddenCallback=hiddenCallback;this.reposition();view.focus();const document=this._popover.element.ownerDocument;document.addEventListener('mousedown',this._hideProxy,false);document.defaultView.addEventListener('resize',this._hideProxy,false);this._view.contentElement.addEventListener('keydown',this._boundOnKeyDown,false);}
reposition(){this._view.contentElement.removeEventListener('focusout',this._boundFocusOut,false);this._view.show(this._popover.contentElement);this._popover.setContentAnchorBox(this._anchorElement.boxInWindow());this._popover.show(this._anchorElement.ownerDocument);this._view.contentElement.addEventListener('focusout',this._boundFocusOut,false);if(!this._focusRestorer){this._focusRestorer=new Widget.WidgetFocusRestorer(this._view);}}
hide(commitEdit){if(this._isHidden){return;}
const document=this._popover.element.ownerDocument;this._isHidden=true;this._popover.hide();document.removeEventListener('mousedown',this._hideProxy,false);document.defaultView.removeEventListener('resize',this._hideProxy,false);if(this._hiddenCallback){this._hiddenCallback.call(null,!!commitEdit);}
this._focusRestorer.restore();delete this._anchorElement;if(this._view){this._view.detach();this._view.contentElement.removeEventListener('keydown',this._boundOnKeyDown,false);this._view.contentElement.removeEventListener('focusout',this._boundFocusOut,false);delete this._view;}}
_onKeyDown(event){if(event.key==='Enter'){this.hide(true);event.consume(true);return;}
if(event.key==='Escape'){this.hide(false);event.consume(true);}}}
var SwatchPopoverHelper$1=Object.freeze({__proto__:null,SwatchPopoverHelper:SwatchPopoverHelper});export{BezierEditor$1 as BezierEditor,BezierUI$1 as BezierUI,CSSShadowEditor$1 as CSSShadowEditor,CSSShadowModel$1 as CSSShadowModel,ColorSwatch$1 as ColorSwatch,SwatchPopoverHelper$1 as SwatchPopoverHelper};