/*
 * Copyright (c) 2007, 2015, 2022 -2022 Apple Inc. All rights reserved.
 * Copyright (c) 2013 Google Inc. All rights reserved.
 * Copyright (c) 2014, 2015, 2016, 2019, 2022, 2024 Apple Inc. All rights reserved.
 * Copyright (c) 2014, 2017 -2017 Apple Inc. All rights reserved.
 * Copyright (c) 2015 Andy VanWagoner <andy@vanwagoner.family>.
 * Copyright (c) 2015 Jordan Harband. All rights reserved.
 * Copyright (c) 2015, 2016 -2016 Apple Inc. All rights reserved.
 * Copyright (c) 2015, 2016 -2016 Yusuke Suzuki <utatane.tea@gmail.com>.
 * Copyright (c) 2015, 2016, 2017 Yusuke Suzuki <utatane.tea@gmail.com>.
 * Copyright (c) 2016 Caitlin Potter <caitp@igalia.com>.
 * Copyright (c) 2016 Yusuke Suzuki <utatane.tea@gmail.com>
 * Copyright (c) 2016, 2017 -2017 Yusuke Suzuki <utatane.tea@gmail.com>.
 * Copyright (c) 2016, 2017, 2018 Oleksandr Skachkov <gskachkov@gmail.com>.
 * Copyright (c) 2016, 2018 -2018 Apple Inc. All rights reserved.
 * Copyright (c) 2016, 2019 -2019 Apple Inc. All rights reserved.
 * Copyright (c) 2016, 2024 -2024 Apple Inc. All rights reserved.
 * Copyright (c) 2017 Caio Lima <ticaiolima@gmail.com>.
 * Copyright (c) 2018 Yusuke Suzuki <yusukesuzuki@slowstart.org>.
 * Copyright (c) 2019 Alexey Shvayka <shvaikalesh@gmail.com>.
 * Copyright (c) 2021 Igalia S.L.
 * Copyright (c) 2022 Jarred Sumner. All rights reserved.
 * Copyright (c) 2023 Devin Rousso <webkit@devinrousso.com>.
 * Copyright (c) 2024 Sosuke Suzuki <aosukeke@gmail.com>.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY APPLE INC. AND ITS CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL APPLE INC. OR ITS CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 * 
 */

// DO NOT EDIT THIS FILE. It is automatically generated from JavaScript files for
// builtins by the script: Source/JavaScriptCore/Scripts/generate-js-builtins.py

#pragma once

namespace JSC {
class FunctionExecutable;
class VM;

enum class ConstructAbility : uint8_t;
enum class ConstructorKind : uint8_t;
enum class ImplementationVisibility : uint8_t;
enum class InlineAttribute : uint8_t;
}

namespace JSC {

extern const char s_JSCCombinedCode[];

extern const unsigned s_JSCCombinedCodeLength;

/* ArrayConstructor */
extern const char* const s_arrayConstructorOfCode;
extern const int s_arrayConstructorOfCodeLength;
extern const JSC::ConstructAbility s_arrayConstructorOfCodeConstructAbility;
extern const JSC::ConstructorKind s_arrayConstructorOfCodeConstructorKind;
extern const JSC::ImplementationVisibility s_arrayConstructorOfCodeImplementationVisibility;
extern const JSC::InlineAttribute s_arrayConstructorOfCodeInlineAttribute;
extern const char* const s_arrayConstructorFromCode;
extern const int s_arrayConstructorFromCodeLength;
extern const JSC::ConstructAbility s_arrayConstructorFromCodeConstructAbility;
extern const JSC::ConstructorKind s_arrayConstructorFromCodeConstructorKind;
extern const JSC::ImplementationVisibility s_arrayConstructorFromCodeImplementationVisibility;
extern const JSC::InlineAttribute s_arrayConstructorFromCodeInlineAttribute;
extern const char* const s_arrayConstructorIsArrayCode;
extern const int s_arrayConstructorIsArrayCodeLength;
extern const JSC::ConstructAbility s_arrayConstructorIsArrayCodeConstructAbility;
extern const JSC::ConstructorKind s_arrayConstructorIsArrayCodeConstructorKind;
extern const JSC::ImplementationVisibility s_arrayConstructorIsArrayCodeImplementationVisibility;
extern const JSC::InlineAttribute s_arrayConstructorIsArrayCodeInlineAttribute;
extern const char* const s_arrayConstructorDefaultAsyncFromAsyncIteratorCode;
extern const int s_arrayConstructorDefaultAsyncFromAsyncIteratorCodeLength;
extern const JSC::ConstructAbility s_arrayConstructorDefaultAsyncFromAsyncIteratorCodeConstructAbility;
extern const JSC::ConstructorKind s_arrayConstructorDefaultAsyncFromAsyncIteratorCodeConstructorKind;
extern const JSC::ImplementationVisibility s_arrayConstructorDefaultAsyncFromAsyncIteratorCodeImplementationVisibility;
extern const JSC::InlineAttribute s_arrayConstructorDefaultAsyncFromAsyncIteratorCodeInlineAttribute;
extern const char* const s_arrayConstructorDefaultAsyncFromAsyncArrayLikeCode;
extern const int s_arrayConstructorDefaultAsyncFromAsyncArrayLikeCodeLength;
extern const JSC::ConstructAbility s_arrayConstructorDefaultAsyncFromAsyncArrayLikeCodeConstructAbility;
extern const JSC::ConstructorKind s_arrayConstructorDefaultAsyncFromAsyncArrayLikeCodeConstructorKind;
extern const JSC::ImplementationVisibility s_arrayConstructorDefaultAsyncFromAsyncArrayLikeCodeImplementationVisibility;
extern const JSC::InlineAttribute s_arrayConstructorDefaultAsyncFromAsyncArrayLikeCodeInlineAttribute;
extern const char* const s_arrayConstructorFromAsyncCode;
extern const int s_arrayConstructorFromAsyncCodeLength;
extern const JSC::ConstructAbility s_arrayConstructorFromAsyncCodeConstructAbility;
extern const JSC::ConstructorKind s_arrayConstructorFromAsyncCodeConstructorKind;
extern const JSC::ImplementationVisibility s_arrayConstructorFromAsyncCodeImplementationVisibility;
extern const JSC::InlineAttribute s_arrayConstructorFromAsyncCodeInlineAttribute;

#define JSC_FOREACH_ARRAYCONSTRUCTOR_BUILTIN_DATA(macro) \
    macro(of, arrayConstructorOf, 0) \
    macro(from, arrayConstructorFrom, 1) \
    macro(isArray, arrayConstructorIsArray, 1) \
    macro(defaultAsyncFromAsyncIterator, arrayConstructorDefaultAsyncFromAsyncIterator, 3) \
    macro(defaultAsyncFromAsyncArrayLike, arrayConstructorDefaultAsyncFromAsyncArrayLike, 3) \
    macro(fromAsync, arrayConstructorFromAsync, 1) \

/* ArrayIteratorPrototype */
extern const char* const s_arrayIteratorPrototypeNextCode;
extern const int s_arrayIteratorPrototypeNextCodeLength;
extern const JSC::ConstructAbility s_arrayIteratorPrototypeNextCodeConstructAbility;
extern const JSC::ConstructorKind s_arrayIteratorPrototypeNextCodeConstructorKind;
extern const JSC::ImplementationVisibility s_arrayIteratorPrototypeNextCodeImplementationVisibility;
extern const JSC::InlineAttribute s_arrayIteratorPrototypeNextCodeInlineAttribute;
extern const char* const s_arrayIteratorPrototypeArrayIteratorNextHelperCode;
extern const int s_arrayIteratorPrototypeArrayIteratorNextHelperCodeLength;
extern const JSC::ConstructAbility s_arrayIteratorPrototypeArrayIteratorNextHelperCodeConstructAbility;
extern const JSC::ConstructorKind s_arrayIteratorPrototypeArrayIteratorNextHelperCodeConstructorKind;
extern const JSC::ImplementationVisibility s_arrayIteratorPrototypeArrayIteratorNextHelperCodeImplementationVisibility;
extern const JSC::InlineAttribute s_arrayIteratorPrototypeArrayIteratorNextHelperCodeInlineAttribute;

#define JSC_FOREACH_ARRAYITERATORPROTOTYPE_BUILTIN_DATA(macro) \
    macro(next, arrayIteratorPrototypeNext, 0) \
    macro(arrayIteratorNextHelper, arrayIteratorPrototypeArrayIteratorNextHelper, 2) \

/* ArrayPrototype */
extern const char* const s_arrayPrototypeReduceCode;
extern const int s_arrayPrototypeReduceCodeLength;
extern const JSC::ConstructAbility s_arrayPrototypeReduceCodeConstructAbility;
extern const JSC::ConstructorKind s_arrayPrototypeReduceCodeConstructorKind;
extern const JSC::ImplementationVisibility s_arrayPrototypeReduceCodeImplementationVisibility;
extern const JSC::InlineAttribute s_arrayPrototypeReduceCodeInlineAttribute;
extern const char* const s_arrayPrototypeReduceRightCode;
extern const int s_arrayPrototypeReduceRightCodeLength;
extern const JSC::ConstructAbility s_arrayPrototypeReduceRightCodeConstructAbility;
extern const JSC::ConstructorKind s_arrayPrototypeReduceRightCodeConstructorKind;
extern const JSC::ImplementationVisibility s_arrayPrototypeReduceRightCodeImplementationVisibility;
extern const JSC::InlineAttribute s_arrayPrototypeReduceRightCodeInlineAttribute;
extern const char* const s_arrayPrototypeEveryCode;
extern const int s_arrayPrototypeEveryCodeLength;
extern const JSC::ConstructAbility s_arrayPrototypeEveryCodeConstructAbility;
extern const JSC::ConstructorKind s_arrayPrototypeEveryCodeConstructorKind;
extern const JSC::ImplementationVisibility s_arrayPrototypeEveryCodeImplementationVisibility;
extern const JSC::InlineAttribute s_arrayPrototypeEveryCodeInlineAttribute;
extern const char* const s_arrayPrototypeForEachCode;
extern const int s_arrayPrototypeForEachCodeLength;
extern const JSC::ConstructAbility s_arrayPrototypeForEachCodeConstructAbility;
extern const JSC::ConstructorKind s_arrayPrototypeForEachCodeConstructorKind;
extern const JSC::ImplementationVisibility s_arrayPrototypeForEachCodeImplementationVisibility;
extern const JSC::InlineAttribute s_arrayPrototypeForEachCodeInlineAttribute;
extern const char* const s_arrayPrototypeFilterCode;
extern const int s_arrayPrototypeFilterCodeLength;
extern const JSC::ConstructAbility s_arrayPrototypeFilterCodeConstructAbility;
extern const JSC::ConstructorKind s_arrayPrototypeFilterCodeConstructorKind;
extern const JSC::ImplementationVisibility s_arrayPrototypeFilterCodeImplementationVisibility;
extern const JSC::InlineAttribute s_arrayPrototypeFilterCodeInlineAttribute;
extern const char* const s_arrayPrototypeMapCode;
extern const int s_arrayPrototypeMapCodeLength;
extern const JSC::ConstructAbility s_arrayPrototypeMapCodeConstructAbility;
extern const JSC::ConstructorKind s_arrayPrototypeMapCodeConstructorKind;
extern const JSC::ImplementationVisibility s_arrayPrototypeMapCodeImplementationVisibility;
extern const JSC::InlineAttribute s_arrayPrototypeMapCodeInlineAttribute;
extern const char* const s_arrayPrototypeSomeCode;
extern const int s_arrayPrototypeSomeCodeLength;
extern const JSC::ConstructAbility s_arrayPrototypeSomeCodeConstructAbility;
extern const JSC::ConstructorKind s_arrayPrototypeSomeCodeConstructorKind;
extern const JSC::ImplementationVisibility s_arrayPrototypeSomeCodeImplementationVisibility;
extern const JSC::InlineAttribute s_arrayPrototypeSomeCodeInlineAttribute;
extern const char* const s_arrayPrototypeFindCode;
extern const int s_arrayPrototypeFindCodeLength;
extern const JSC::ConstructAbility s_arrayPrototypeFindCodeConstructAbility;
extern const JSC::ConstructorKind s_arrayPrototypeFindCodeConstructorKind;
extern const JSC::ImplementationVisibility s_arrayPrototypeFindCodeImplementationVisibility;
extern const JSC::InlineAttribute s_arrayPrototypeFindCodeInlineAttribute;
extern const char* const s_arrayPrototypeFindLastCode;
extern const int s_arrayPrototypeFindLastCodeLength;
extern const JSC::ConstructAbility s_arrayPrototypeFindLastCodeConstructAbility;
extern const JSC::ConstructorKind s_arrayPrototypeFindLastCodeConstructorKind;
extern const JSC::ImplementationVisibility s_arrayPrototypeFindLastCodeImplementationVisibility;
extern const JSC::InlineAttribute s_arrayPrototypeFindLastCodeInlineAttribute;
extern const char* const s_arrayPrototypeFindIndexCode;
extern const int s_arrayPrototypeFindIndexCodeLength;
extern const JSC::ConstructAbility s_arrayPrototypeFindIndexCodeConstructAbility;
extern const JSC::ConstructorKind s_arrayPrototypeFindIndexCodeConstructorKind;
extern const JSC::ImplementationVisibility s_arrayPrototypeFindIndexCodeImplementationVisibility;
extern const JSC::InlineAttribute s_arrayPrototypeFindIndexCodeInlineAttribute;
extern const char* const s_arrayPrototypeFindLastIndexCode;
extern const int s_arrayPrototypeFindLastIndexCodeLength;
extern const JSC::ConstructAbility s_arrayPrototypeFindLastIndexCodeConstructAbility;
extern const JSC::ConstructorKind s_arrayPrototypeFindLastIndexCodeConstructorKind;
extern const JSC::ImplementationVisibility s_arrayPrototypeFindLastIndexCodeImplementationVisibility;
extern const JSC::InlineAttribute s_arrayPrototypeFindLastIndexCodeInlineAttribute;
extern const char* const s_arrayPrototypeIncludesCode;
extern const int s_arrayPrototypeIncludesCodeLength;
extern const JSC::ConstructAbility s_arrayPrototypeIncludesCodeConstructAbility;
extern const JSC::ConstructorKind s_arrayPrototypeIncludesCodeConstructorKind;
extern const JSC::ImplementationVisibility s_arrayPrototypeIncludesCodeImplementationVisibility;
extern const JSC::InlineAttribute s_arrayPrototypeIncludesCodeInlineAttribute;
extern const char* const s_arrayPrototypeMaxWithPositivesCode;
extern const int s_arrayPrototypeMaxWithPositivesCodeLength;
extern const JSC::ConstructAbility s_arrayPrototypeMaxWithPositivesCodeConstructAbility;
extern const JSC::ConstructorKind s_arrayPrototypeMaxWithPositivesCodeConstructorKind;
extern const JSC::ImplementationVisibility s_arrayPrototypeMaxWithPositivesCodeImplementationVisibility;
extern const JSC::InlineAttribute s_arrayPrototypeMaxWithPositivesCodeInlineAttribute;
extern const char* const s_arrayPrototypeMinWithMaybeNegativeZeroAndPositiveCode;
extern const int s_arrayPrototypeMinWithMaybeNegativeZeroAndPositiveCodeLength;
extern const JSC::ConstructAbility s_arrayPrototypeMinWithMaybeNegativeZeroAndPositiveCodeConstructAbility;
extern const JSC::ConstructorKind s_arrayPrototypeMinWithMaybeNegativeZeroAndPositiveCodeConstructorKind;
extern const JSC::ImplementationVisibility s_arrayPrototypeMinWithMaybeNegativeZeroAndPositiveCodeImplementationVisibility;
extern const JSC::InlineAttribute s_arrayPrototypeMinWithMaybeNegativeZeroAndPositiveCodeInlineAttribute;
extern const char* const s_arrayPrototypeCopyWithinCode;
extern const int s_arrayPrototypeCopyWithinCodeLength;
extern const JSC::ConstructAbility s_arrayPrototypeCopyWithinCodeConstructAbility;
extern const JSC::ConstructorKind s_arrayPrototypeCopyWithinCodeConstructorKind;
extern const JSC::ImplementationVisibility s_arrayPrototypeCopyWithinCodeImplementationVisibility;
extern const JSC::InlineAttribute s_arrayPrototypeCopyWithinCodeInlineAttribute;
extern const char* const s_arrayPrototypeFlatIntoArrayCode;
extern const int s_arrayPrototypeFlatIntoArrayCodeLength;
extern const JSC::ConstructAbility s_arrayPrototypeFlatIntoArrayCodeConstructAbility;
extern const JSC::ConstructorKind s_arrayPrototypeFlatIntoArrayCodeConstructorKind;
extern const JSC::ImplementationVisibility s_arrayPrototypeFlatIntoArrayCodeImplementationVisibility;
extern const JSC::InlineAttribute s_arrayPrototypeFlatIntoArrayCodeInlineAttribute;
extern const char* const s_arrayPrototypeFlatCode;
extern const int s_arrayPrototypeFlatCodeLength;
extern const JSC::ConstructAbility s_arrayPrototypeFlatCodeConstructAbility;
extern const JSC::ConstructorKind s_arrayPrototypeFlatCodeConstructorKind;
extern const JSC::ImplementationVisibility s_arrayPrototypeFlatCodeImplementationVisibility;
extern const JSC::InlineAttribute s_arrayPrototypeFlatCodeInlineAttribute;
extern const char* const s_arrayPrototypeFlatIntoArrayWithCallbackCode;
extern const int s_arrayPrototypeFlatIntoArrayWithCallbackCodeLength;
extern const JSC::ConstructAbility s_arrayPrototypeFlatIntoArrayWithCallbackCodeConstructAbility;
extern const JSC::ConstructorKind s_arrayPrototypeFlatIntoArrayWithCallbackCodeConstructorKind;
extern const JSC::ImplementationVisibility s_arrayPrototypeFlatIntoArrayWithCallbackCodeImplementationVisibility;
extern const JSC::InlineAttribute s_arrayPrototypeFlatIntoArrayWithCallbackCodeInlineAttribute;
extern const char* const s_arrayPrototypeFlatMapCode;
extern const int s_arrayPrototypeFlatMapCodeLength;
extern const JSC::ConstructAbility s_arrayPrototypeFlatMapCodeConstructAbility;
extern const JSC::ConstructorKind s_arrayPrototypeFlatMapCodeConstructorKind;
extern const JSC::ImplementationVisibility s_arrayPrototypeFlatMapCodeImplementationVisibility;
extern const JSC::InlineAttribute s_arrayPrototypeFlatMapCodeInlineAttribute;
extern const char* const s_arrayPrototypeAtCode;
extern const int s_arrayPrototypeAtCodeLength;
extern const JSC::ConstructAbility s_arrayPrototypeAtCodeConstructAbility;
extern const JSC::ConstructorKind s_arrayPrototypeAtCodeConstructorKind;
extern const JSC::ImplementationVisibility s_arrayPrototypeAtCodeImplementationVisibility;
extern const JSC::InlineAttribute s_arrayPrototypeAtCodeInlineAttribute;
extern const char* const s_arrayPrototypeToSortedCode;
extern const int s_arrayPrototypeToSortedCodeLength;
extern const JSC::ConstructAbility s_arrayPrototypeToSortedCodeConstructAbility;
extern const JSC::ConstructorKind s_arrayPrototypeToSortedCodeConstructorKind;
extern const JSC::ImplementationVisibility s_arrayPrototypeToSortedCodeImplementationVisibility;
extern const JSC::InlineAttribute s_arrayPrototypeToSortedCodeInlineAttribute;
extern const char* const s_arrayPrototypeToSplicedCode;
extern const int s_arrayPrototypeToSplicedCodeLength;
extern const JSC::ConstructAbility s_arrayPrototypeToSplicedCodeConstructAbility;
extern const JSC::ConstructorKind s_arrayPrototypeToSplicedCodeConstructorKind;
extern const JSC::ImplementationVisibility s_arrayPrototypeToSplicedCodeImplementationVisibility;
extern const JSC::InlineAttribute s_arrayPrototypeToSplicedCodeInlineAttribute;
extern const char* const s_arrayPrototypeWithCode;
extern const int s_arrayPrototypeWithCodeLength;
extern const JSC::ConstructAbility s_arrayPrototypeWithCodeConstructAbility;
extern const JSC::ConstructorKind s_arrayPrototypeWithCodeConstructorKind;
extern const JSC::ImplementationVisibility s_arrayPrototypeWithCodeImplementationVisibility;
extern const JSC::InlineAttribute s_arrayPrototypeWithCodeInlineAttribute;

#define JSC_FOREACH_ARRAYPROTOTYPE_BUILTIN_DATA(macro) \
    macro(reduce, arrayPrototypeReduce, 1) \
    macro(reduceRight, arrayPrototypeReduceRight, 1) \
    macro(every, arrayPrototypeEvery, 1) \
    macro(forEach, arrayPrototypeForEach, 1) \
    macro(filter, arrayPrototypeFilter, 1) \
    macro(map, arrayPrototypeMap, 1) \
    macro(some, arrayPrototypeSome, 1) \
    macro(find, arrayPrototypeFind, 1) \
    macro(findLast, arrayPrototypeFindLast, 1) \
    macro(findIndex, arrayPrototypeFindIndex, 1) \
    macro(findLastIndex, arrayPrototypeFindLastIndex, 1) \
    macro(includes, arrayPrototypeIncludes, 1) \
    macro(maxWithPositives, arrayPrototypeMaxWithPositives, 2) \
    macro(minWithMaybeNegativeZeroAndPositive, arrayPrototypeMinWithMaybeNegativeZeroAndPositive, 2) \
    macro(copyWithin, arrayPrototypeCopyWithin, 2) \
    macro(flatIntoArray, arrayPrototypeFlatIntoArray, 5) \
    macro(flat, arrayPrototypeFlat, 0) \
    macro(flatIntoArrayWithCallback, arrayPrototypeFlatIntoArrayWithCallback, 6) \
    macro(flatMap, arrayPrototypeFlatMap, 1) \
    macro(at, arrayPrototypeAt, 1) \
    macro(toSorted, arrayPrototypeToSorted, 1) \
    macro(toSpliced, arrayPrototypeToSpliced, 2) \
    macro(with, arrayPrototypeWith, 2) \

/* AsyncFromSyncIteratorPrototype */
extern const char* const s_asyncFromSyncIteratorPrototypeAsyncFromSyncIteratorOnRejectedCode;
extern const int s_asyncFromSyncIteratorPrototypeAsyncFromSyncIteratorOnRejectedCodeLength;
extern const JSC::ConstructAbility s_asyncFromSyncIteratorPrototypeAsyncFromSyncIteratorOnRejectedCodeConstructAbility;
extern const JSC::ConstructorKind s_asyncFromSyncIteratorPrototypeAsyncFromSyncIteratorOnRejectedCodeConstructorKind;
extern const JSC::ImplementationVisibility s_asyncFromSyncIteratorPrototypeAsyncFromSyncIteratorOnRejectedCodeImplementationVisibility;
extern const JSC::InlineAttribute s_asyncFromSyncIteratorPrototypeAsyncFromSyncIteratorOnRejectedCodeInlineAttribute;
extern const char* const s_asyncFromSyncIteratorPrototypeAsyncFromSyncIteratorOnFulfilledContinueCode;
extern const int s_asyncFromSyncIteratorPrototypeAsyncFromSyncIteratorOnFulfilledContinueCodeLength;
extern const JSC::ConstructAbility s_asyncFromSyncIteratorPrototypeAsyncFromSyncIteratorOnFulfilledContinueCodeConstructAbility;
extern const JSC::ConstructorKind s_asyncFromSyncIteratorPrototypeAsyncFromSyncIteratorOnFulfilledContinueCodeConstructorKind;
extern const JSC::ImplementationVisibility s_asyncFromSyncIteratorPrototypeAsyncFromSyncIteratorOnFulfilledContinueCodeImplementationVisibility;
extern const JSC::InlineAttribute s_asyncFromSyncIteratorPrototypeAsyncFromSyncIteratorOnFulfilledContinueCodeInlineAttribute;
extern const char* const s_asyncFromSyncIteratorPrototypeAsyncFromSyncIteratorOnFulfilledDoneCode;
extern const int s_asyncFromSyncIteratorPrototypeAsyncFromSyncIteratorOnFulfilledDoneCodeLength;
extern const JSC::ConstructAbility s_asyncFromSyncIteratorPrototypeAsyncFromSyncIteratorOnFulfilledDoneCodeConstructAbility;
extern const JSC::ConstructorKind s_asyncFromSyncIteratorPrototypeAsyncFromSyncIteratorOnFulfilledDoneCodeConstructorKind;
extern const JSC::ImplementationVisibility s_asyncFromSyncIteratorPrototypeAsyncFromSyncIteratorOnFulfilledDoneCodeImplementationVisibility;
extern const JSC::InlineAttribute s_asyncFromSyncIteratorPrototypeAsyncFromSyncIteratorOnFulfilledDoneCodeInlineAttribute;
extern const char* const s_asyncFromSyncIteratorPrototypeNextCode;
extern const int s_asyncFromSyncIteratorPrototypeNextCodeLength;
extern const JSC::ConstructAbility s_asyncFromSyncIteratorPrototypeNextCodeConstructAbility;
extern const JSC::ConstructorKind s_asyncFromSyncIteratorPrototypeNextCodeConstructorKind;
extern const JSC::ImplementationVisibility s_asyncFromSyncIteratorPrototypeNextCodeImplementationVisibility;
extern const JSC::InlineAttribute s_asyncFromSyncIteratorPrototypeNextCodeInlineAttribute;
extern const char* const s_asyncFromSyncIteratorPrototypeReturnCode;
extern const int s_asyncFromSyncIteratorPrototypeReturnCodeLength;
extern const JSC::ConstructAbility s_asyncFromSyncIteratorPrototypeReturnCodeConstructAbility;
extern const JSC::ConstructorKind s_asyncFromSyncIteratorPrototypeReturnCodeConstructorKind;
extern const JSC::ImplementationVisibility s_asyncFromSyncIteratorPrototypeReturnCodeImplementationVisibility;
extern const JSC::InlineAttribute s_asyncFromSyncIteratorPrototypeReturnCodeInlineAttribute;
extern const char* const s_asyncFromSyncIteratorPrototypeThrowCode;
extern const int s_asyncFromSyncIteratorPrototypeThrowCodeLength;
extern const JSC::ConstructAbility s_asyncFromSyncIteratorPrototypeThrowCodeConstructAbility;
extern const JSC::ConstructorKind s_asyncFromSyncIteratorPrototypeThrowCodeConstructorKind;
extern const JSC::ImplementationVisibility s_asyncFromSyncIteratorPrototypeThrowCodeImplementationVisibility;
extern const JSC::InlineAttribute s_asyncFromSyncIteratorPrototypeThrowCodeInlineAttribute;
extern const char* const s_asyncFromSyncIteratorPrototypeCreateAsyncFromSyncIteratorCode;
extern const int s_asyncFromSyncIteratorPrototypeCreateAsyncFromSyncIteratorCodeLength;
extern const JSC::ConstructAbility s_asyncFromSyncIteratorPrototypeCreateAsyncFromSyncIteratorCodeConstructAbility;
extern const JSC::ConstructorKind s_asyncFromSyncIteratorPrototypeCreateAsyncFromSyncIteratorCodeConstructorKind;
extern const JSC::ImplementationVisibility s_asyncFromSyncIteratorPrototypeCreateAsyncFromSyncIteratorCodeImplementationVisibility;
extern const JSC::InlineAttribute s_asyncFromSyncIteratorPrototypeCreateAsyncFromSyncIteratorCodeInlineAttribute;

#define JSC_FOREACH_ASYNCFROMSYNCITERATORPROTOTYPE_BUILTIN_DATA(macro) \
    macro(asyncFromSyncIteratorOnRejected, asyncFromSyncIteratorPrototypeAsyncFromSyncIteratorOnRejected, 2) \
    macro(asyncFromSyncIteratorOnFulfilledContinue, asyncFromSyncIteratorPrototypeAsyncFromSyncIteratorOnFulfilledContinue, 2) \
    macro(asyncFromSyncIteratorOnFulfilledDone, asyncFromSyncIteratorPrototypeAsyncFromSyncIteratorOnFulfilledDone, 2) \
    macro(next, asyncFromSyncIteratorPrototypeNext, 1) \
    macro(return, asyncFromSyncIteratorPrototypeReturn, 1) \
    macro(throw, asyncFromSyncIteratorPrototypeThrow, 1) \
    macro(createAsyncFromSyncIterator, asyncFromSyncIteratorPrototypeCreateAsyncFromSyncIterator, 2) \

/* AsyncFunctionPrototype */
extern const char* const s_asyncFunctionPrototypeAsyncFunctionResumeOnFulfilledCode;
extern const int s_asyncFunctionPrototypeAsyncFunctionResumeOnFulfilledCodeLength;
extern const JSC::ConstructAbility s_asyncFunctionPrototypeAsyncFunctionResumeOnFulfilledCodeConstructAbility;
extern const JSC::ConstructorKind s_asyncFunctionPrototypeAsyncFunctionResumeOnFulfilledCodeConstructorKind;
extern const JSC::ImplementationVisibility s_asyncFunctionPrototypeAsyncFunctionResumeOnFulfilledCodeImplementationVisibility;
extern const JSC::InlineAttribute s_asyncFunctionPrototypeAsyncFunctionResumeOnFulfilledCodeInlineAttribute;
extern const char* const s_asyncFunctionPrototypeAsyncFunctionResumeOnRejectedCode;
extern const int s_asyncFunctionPrototypeAsyncFunctionResumeOnRejectedCodeLength;
extern const JSC::ConstructAbility s_asyncFunctionPrototypeAsyncFunctionResumeOnRejectedCodeConstructAbility;
extern const JSC::ConstructorKind s_asyncFunctionPrototypeAsyncFunctionResumeOnRejectedCodeConstructorKind;
extern const JSC::ImplementationVisibility s_asyncFunctionPrototypeAsyncFunctionResumeOnRejectedCodeImplementationVisibility;
extern const JSC::InlineAttribute s_asyncFunctionPrototypeAsyncFunctionResumeOnRejectedCodeInlineAttribute;
extern const char* const s_asyncFunctionPrototypeAsyncFunctionResumeCode;
extern const int s_asyncFunctionPrototypeAsyncFunctionResumeCodeLength;
extern const JSC::ConstructAbility s_asyncFunctionPrototypeAsyncFunctionResumeCodeConstructAbility;
extern const JSC::ConstructorKind s_asyncFunctionPrototypeAsyncFunctionResumeCodeConstructorKind;
extern const JSC::ImplementationVisibility s_asyncFunctionPrototypeAsyncFunctionResumeCodeImplementationVisibility;
extern const JSC::InlineAttribute s_asyncFunctionPrototypeAsyncFunctionResumeCodeInlineAttribute;

#define JSC_FOREACH_ASYNCFUNCTIONPROTOTYPE_BUILTIN_DATA(macro) \
    macro(asyncFunctionResumeOnFulfilled, asyncFunctionPrototypeAsyncFunctionResumeOnFulfilled, 2) \
    macro(asyncFunctionResumeOnRejected, asyncFunctionPrototypeAsyncFunctionResumeOnRejected, 2) \
    macro(asyncFunctionResume, asyncFunctionPrototypeAsyncFunctionResume, 3) \

/* AsyncGeneratorPrototype */
extern const char* const s_asyncGeneratorPrototypeAsyncGeneratorQueueIsEmptyCode;
extern const int s_asyncGeneratorPrototypeAsyncGeneratorQueueIsEmptyCodeLength;
extern const JSC::ConstructAbility s_asyncGeneratorPrototypeAsyncGeneratorQueueIsEmptyCodeConstructAbility;
extern const JSC::ConstructorKind s_asyncGeneratorPrototypeAsyncGeneratorQueueIsEmptyCodeConstructorKind;
extern const JSC::ImplementationVisibility s_asyncGeneratorPrototypeAsyncGeneratorQueueIsEmptyCodeImplementationVisibility;
extern const JSC::InlineAttribute s_asyncGeneratorPrototypeAsyncGeneratorQueueIsEmptyCodeInlineAttribute;
extern const char* const s_asyncGeneratorPrototypeAsyncGeneratorQueueEnqueueCode;
extern const int s_asyncGeneratorPrototypeAsyncGeneratorQueueEnqueueCodeLength;
extern const JSC::ConstructAbility s_asyncGeneratorPrototypeAsyncGeneratorQueueEnqueueCodeConstructAbility;
extern const JSC::ConstructorKind s_asyncGeneratorPrototypeAsyncGeneratorQueueEnqueueCodeConstructorKind;
extern const JSC::ImplementationVisibility s_asyncGeneratorPrototypeAsyncGeneratorQueueEnqueueCodeImplementationVisibility;
extern const JSC::InlineAttribute s_asyncGeneratorPrototypeAsyncGeneratorQueueEnqueueCodeInlineAttribute;
extern const char* const s_asyncGeneratorPrototypeAsyncGeneratorQueueDequeueCode;
extern const int s_asyncGeneratorPrototypeAsyncGeneratorQueueDequeueCodeLength;
extern const JSC::ConstructAbility s_asyncGeneratorPrototypeAsyncGeneratorQueueDequeueCodeConstructAbility;
extern const JSC::ConstructorKind s_asyncGeneratorPrototypeAsyncGeneratorQueueDequeueCodeConstructorKind;
extern const JSC::ImplementationVisibility s_asyncGeneratorPrototypeAsyncGeneratorQueueDequeueCodeImplementationVisibility;
extern const JSC::InlineAttribute s_asyncGeneratorPrototypeAsyncGeneratorQueueDequeueCodeInlineAttribute;
extern const char* const s_asyncGeneratorPrototypeIsExecutionStateCode;
extern const int s_asyncGeneratorPrototypeIsExecutionStateCodeLength;
extern const JSC::ConstructAbility s_asyncGeneratorPrototypeIsExecutionStateCodeConstructAbility;
extern const JSC::ConstructorKind s_asyncGeneratorPrototypeIsExecutionStateCodeConstructorKind;
extern const JSC::ImplementationVisibility s_asyncGeneratorPrototypeIsExecutionStateCodeImplementationVisibility;
extern const JSC::InlineAttribute s_asyncGeneratorPrototypeIsExecutionStateCodeInlineAttribute;
extern const char* const s_asyncGeneratorPrototypeIsSuspendYieldStateCode;
extern const int s_asyncGeneratorPrototypeIsSuspendYieldStateCodeLength;
extern const JSC::ConstructAbility s_asyncGeneratorPrototypeIsSuspendYieldStateCodeConstructAbility;
extern const JSC::ConstructorKind s_asyncGeneratorPrototypeIsSuspendYieldStateCodeConstructorKind;
extern const JSC::ImplementationVisibility s_asyncGeneratorPrototypeIsSuspendYieldStateCodeImplementationVisibility;
extern const JSC::InlineAttribute s_asyncGeneratorPrototypeIsSuspendYieldStateCodeInlineAttribute;
extern const char* const s_asyncGeneratorPrototypeAsyncGeneratorRejectCode;
extern const int s_asyncGeneratorPrototypeAsyncGeneratorRejectCodeLength;
extern const JSC::ConstructAbility s_asyncGeneratorPrototypeAsyncGeneratorRejectCodeConstructAbility;
extern const JSC::ConstructorKind s_asyncGeneratorPrototypeAsyncGeneratorRejectCodeConstructorKind;
extern const JSC::ImplementationVisibility s_asyncGeneratorPrototypeAsyncGeneratorRejectCodeImplementationVisibility;
extern const JSC::InlineAttribute s_asyncGeneratorPrototypeAsyncGeneratorRejectCodeInlineAttribute;
extern const char* const s_asyncGeneratorPrototypeAsyncGeneratorResolveCode;
extern const int s_asyncGeneratorPrototypeAsyncGeneratorResolveCodeLength;
extern const JSC::ConstructAbility s_asyncGeneratorPrototypeAsyncGeneratorResolveCodeConstructAbility;
extern const JSC::ConstructorKind s_asyncGeneratorPrototypeAsyncGeneratorResolveCodeConstructorKind;
extern const JSC::ImplementationVisibility s_asyncGeneratorPrototypeAsyncGeneratorResolveCodeImplementationVisibility;
extern const JSC::InlineAttribute s_asyncGeneratorPrototypeAsyncGeneratorResolveCodeInlineAttribute;
extern const char* const s_asyncGeneratorPrototypeAsyncGeneratorYieldAwaitedCode;
extern const int s_asyncGeneratorPrototypeAsyncGeneratorYieldAwaitedCodeLength;
extern const JSC::ConstructAbility s_asyncGeneratorPrototypeAsyncGeneratorYieldAwaitedCodeConstructAbility;
extern const JSC::ConstructorKind s_asyncGeneratorPrototypeAsyncGeneratorYieldAwaitedCodeConstructorKind;
extern const JSC::ImplementationVisibility s_asyncGeneratorPrototypeAsyncGeneratorYieldAwaitedCodeImplementationVisibility;
extern const JSC::InlineAttribute s_asyncGeneratorPrototypeAsyncGeneratorYieldAwaitedCodeInlineAttribute;
extern const char* const s_asyncGeneratorPrototypeAsyncGeneratorYieldOnRejectedCode;
extern const int s_asyncGeneratorPrototypeAsyncGeneratorYieldOnRejectedCodeLength;
extern const JSC::ConstructAbility s_asyncGeneratorPrototypeAsyncGeneratorYieldOnRejectedCodeConstructAbility;
extern const JSC::ConstructorKind s_asyncGeneratorPrototypeAsyncGeneratorYieldOnRejectedCodeConstructorKind;
extern const JSC::ImplementationVisibility s_asyncGeneratorPrototypeAsyncGeneratorYieldOnRejectedCodeImplementationVisibility;
extern const JSC::InlineAttribute s_asyncGeneratorPrototypeAsyncGeneratorYieldOnRejectedCodeInlineAttribute;
extern const char* const s_asyncGeneratorPrototypeAsyncGeneratorYieldCode;
extern const int s_asyncGeneratorPrototypeAsyncGeneratorYieldCodeLength;
extern const JSC::ConstructAbility s_asyncGeneratorPrototypeAsyncGeneratorYieldCodeConstructAbility;
extern const JSC::ConstructorKind s_asyncGeneratorPrototypeAsyncGeneratorYieldCodeConstructorKind;
extern const JSC::ImplementationVisibility s_asyncGeneratorPrototypeAsyncGeneratorYieldCodeImplementationVisibility;
extern const JSC::InlineAttribute s_asyncGeneratorPrototypeAsyncGeneratorYieldCodeInlineAttribute;
extern const char* const s_asyncGeneratorPrototypeAwaitValueCode;
extern const int s_asyncGeneratorPrototypeAwaitValueCodeLength;
extern const JSC::ConstructAbility s_asyncGeneratorPrototypeAwaitValueCodeConstructAbility;
extern const JSC::ConstructorKind s_asyncGeneratorPrototypeAwaitValueCodeConstructorKind;
extern const JSC::ImplementationVisibility s_asyncGeneratorPrototypeAwaitValueCodeImplementationVisibility;
extern const JSC::InlineAttribute s_asyncGeneratorPrototypeAwaitValueCodeInlineAttribute;
extern const char* const s_asyncGeneratorPrototypeDoAsyncGeneratorBodyCallOnFulfilledNormalCode;
extern const int s_asyncGeneratorPrototypeDoAsyncGeneratorBodyCallOnFulfilledNormalCodeLength;
extern const JSC::ConstructAbility s_asyncGeneratorPrototypeDoAsyncGeneratorBodyCallOnFulfilledNormalCodeConstructAbility;
extern const JSC::ConstructorKind s_asyncGeneratorPrototypeDoAsyncGeneratorBodyCallOnFulfilledNormalCodeConstructorKind;
extern const JSC::ImplementationVisibility s_asyncGeneratorPrototypeDoAsyncGeneratorBodyCallOnFulfilledNormalCodeImplementationVisibility;
extern const JSC::InlineAttribute s_asyncGeneratorPrototypeDoAsyncGeneratorBodyCallOnFulfilledNormalCodeInlineAttribute;
extern const char* const s_asyncGeneratorPrototypeDoAsyncGeneratorBodyCallOnFulfilledReturnCode;
extern const int s_asyncGeneratorPrototypeDoAsyncGeneratorBodyCallOnFulfilledReturnCodeLength;
extern const JSC::ConstructAbility s_asyncGeneratorPrototypeDoAsyncGeneratorBodyCallOnFulfilledReturnCodeConstructAbility;
extern const JSC::ConstructorKind s_asyncGeneratorPrototypeDoAsyncGeneratorBodyCallOnFulfilledReturnCodeConstructorKind;
extern const JSC::ImplementationVisibility s_asyncGeneratorPrototypeDoAsyncGeneratorBodyCallOnFulfilledReturnCodeImplementationVisibility;
extern const JSC::InlineAttribute s_asyncGeneratorPrototypeDoAsyncGeneratorBodyCallOnFulfilledReturnCodeInlineAttribute;
extern const char* const s_asyncGeneratorPrototypeDoAsyncGeneratorBodyCallCode;
extern const int s_asyncGeneratorPrototypeDoAsyncGeneratorBodyCallCodeLength;
extern const JSC::ConstructAbility s_asyncGeneratorPrototypeDoAsyncGeneratorBodyCallCodeConstructAbility;
extern const JSC::ConstructorKind s_asyncGeneratorPrototypeDoAsyncGeneratorBodyCallCodeConstructorKind;
extern const JSC::ImplementationVisibility s_asyncGeneratorPrototypeDoAsyncGeneratorBodyCallCodeImplementationVisibility;
extern const JSC::InlineAttribute s_asyncGeneratorPrototypeDoAsyncGeneratorBodyCallCodeInlineAttribute;
extern const char* const s_asyncGeneratorPrototypeAsyncGeneratorResumeNextOnFulfilledCode;
extern const int s_asyncGeneratorPrototypeAsyncGeneratorResumeNextOnFulfilledCodeLength;
extern const JSC::ConstructAbility s_asyncGeneratorPrototypeAsyncGeneratorResumeNextOnFulfilledCodeConstructAbility;
extern const JSC::ConstructorKind s_asyncGeneratorPrototypeAsyncGeneratorResumeNextOnFulfilledCodeConstructorKind;
extern const JSC::ImplementationVisibility s_asyncGeneratorPrototypeAsyncGeneratorResumeNextOnFulfilledCodeImplementationVisibility;
extern const JSC::InlineAttribute s_asyncGeneratorPrototypeAsyncGeneratorResumeNextOnFulfilledCodeInlineAttribute;
extern const char* const s_asyncGeneratorPrototypeAsyncGeneratorResumeNextOnRejectedCode;
extern const int s_asyncGeneratorPrototypeAsyncGeneratorResumeNextOnRejectedCodeLength;
extern const JSC::ConstructAbility s_asyncGeneratorPrototypeAsyncGeneratorResumeNextOnRejectedCodeConstructAbility;
extern const JSC::ConstructorKind s_asyncGeneratorPrototypeAsyncGeneratorResumeNextOnRejectedCodeConstructorKind;
extern const JSC::ImplementationVisibility s_asyncGeneratorPrototypeAsyncGeneratorResumeNextOnRejectedCodeImplementationVisibility;
extern const JSC::InlineAttribute s_asyncGeneratorPrototypeAsyncGeneratorResumeNextOnRejectedCodeInlineAttribute;
extern const char* const s_asyncGeneratorPrototypeAsyncGeneratorResumeNextCode;
extern const int s_asyncGeneratorPrototypeAsyncGeneratorResumeNextCodeLength;
extern const JSC::ConstructAbility s_asyncGeneratorPrototypeAsyncGeneratorResumeNextCodeConstructAbility;
extern const JSC::ConstructorKind s_asyncGeneratorPrototypeAsyncGeneratorResumeNextCodeConstructorKind;
extern const JSC::ImplementationVisibility s_asyncGeneratorPrototypeAsyncGeneratorResumeNextCodeImplementationVisibility;
extern const JSC::InlineAttribute s_asyncGeneratorPrototypeAsyncGeneratorResumeNextCodeInlineAttribute;
extern const char* const s_asyncGeneratorPrototypeAsyncGeneratorEnqueueCode;
extern const int s_asyncGeneratorPrototypeAsyncGeneratorEnqueueCodeLength;
extern const JSC::ConstructAbility s_asyncGeneratorPrototypeAsyncGeneratorEnqueueCodeConstructAbility;
extern const JSC::ConstructorKind s_asyncGeneratorPrototypeAsyncGeneratorEnqueueCodeConstructorKind;
extern const JSC::ImplementationVisibility s_asyncGeneratorPrototypeAsyncGeneratorEnqueueCodeImplementationVisibility;
extern const JSC::InlineAttribute s_asyncGeneratorPrototypeAsyncGeneratorEnqueueCodeInlineAttribute;
extern const char* const s_asyncGeneratorPrototypeNextCode;
extern const int s_asyncGeneratorPrototypeNextCodeLength;
extern const JSC::ConstructAbility s_asyncGeneratorPrototypeNextCodeConstructAbility;
extern const JSC::ConstructorKind s_asyncGeneratorPrototypeNextCodeConstructorKind;
extern const JSC::ImplementationVisibility s_asyncGeneratorPrototypeNextCodeImplementationVisibility;
extern const JSC::InlineAttribute s_asyncGeneratorPrototypeNextCodeInlineAttribute;
extern const char* const s_asyncGeneratorPrototypeReturnCode;
extern const int s_asyncGeneratorPrototypeReturnCodeLength;
extern const JSC::ConstructAbility s_asyncGeneratorPrototypeReturnCodeConstructAbility;
extern const JSC::ConstructorKind s_asyncGeneratorPrototypeReturnCodeConstructorKind;
extern const JSC::ImplementationVisibility s_asyncGeneratorPrototypeReturnCodeImplementationVisibility;
extern const JSC::InlineAttribute s_asyncGeneratorPrototypeReturnCodeInlineAttribute;
extern const char* const s_asyncGeneratorPrototypeThrowCode;
extern const int s_asyncGeneratorPrototypeThrowCodeLength;
extern const JSC::ConstructAbility s_asyncGeneratorPrototypeThrowCodeConstructAbility;
extern const JSC::ConstructorKind s_asyncGeneratorPrototypeThrowCodeConstructorKind;
extern const JSC::ImplementationVisibility s_asyncGeneratorPrototypeThrowCodeImplementationVisibility;
extern const JSC::InlineAttribute s_asyncGeneratorPrototypeThrowCodeInlineAttribute;

#define JSC_FOREACH_ASYNCGENERATORPROTOTYPE_BUILTIN_DATA(macro) \
    macro(asyncGeneratorQueueIsEmpty, asyncGeneratorPrototypeAsyncGeneratorQueueIsEmpty, 1) \
    macro(asyncGeneratorQueueEnqueue, asyncGeneratorPrototypeAsyncGeneratorQueueEnqueue, 2) \
    macro(asyncGeneratorQueueDequeue, asyncGeneratorPrototypeAsyncGeneratorQueueDequeue, 1) \
    macro(isExecutionState, asyncGeneratorPrototypeIsExecutionState, 1) \
    macro(isSuspendYieldState, asyncGeneratorPrototypeIsSuspendYieldState, 1) \
    macro(asyncGeneratorReject, asyncGeneratorPrototypeAsyncGeneratorReject, 2) \
    macro(asyncGeneratorResolve, asyncGeneratorPrototypeAsyncGeneratorResolve, 3) \
    macro(asyncGeneratorYieldAwaited, asyncGeneratorPrototypeAsyncGeneratorYieldAwaited, 2) \
    macro(asyncGeneratorYieldOnRejected, asyncGeneratorPrototypeAsyncGeneratorYieldOnRejected, 2) \
    macro(asyncGeneratorYield, asyncGeneratorPrototypeAsyncGeneratorYield, 3) \
    macro(awaitValue, asyncGeneratorPrototypeAwaitValue, 3) \
    macro(doAsyncGeneratorBodyCallOnFulfilledNormal, asyncGeneratorPrototypeDoAsyncGeneratorBodyCallOnFulfilledNormal, 2) \
    macro(doAsyncGeneratorBodyCallOnFulfilledReturn, asyncGeneratorPrototypeDoAsyncGeneratorBodyCallOnFulfilledReturn, 2) \
    macro(doAsyncGeneratorBodyCall, asyncGeneratorPrototypeDoAsyncGeneratorBodyCall, 3) \
    macro(asyncGeneratorResumeNextOnFulfilled, asyncGeneratorPrototypeAsyncGeneratorResumeNextOnFulfilled, 2) \
    macro(asyncGeneratorResumeNextOnRejected, asyncGeneratorPrototypeAsyncGeneratorResumeNextOnRejected, 2) \
    macro(asyncGeneratorResumeNext, asyncGeneratorPrototypeAsyncGeneratorResumeNext, 1) \
    macro(asyncGeneratorEnqueue, asyncGeneratorPrototypeAsyncGeneratorEnqueue, 3) \
    macro(next, asyncGeneratorPrototypeNext, 1) \
    macro(return, asyncGeneratorPrototypeReturn, 1) \
    macro(throw, asyncGeneratorPrototypeThrow, 1) \

/* FunctionPrototype */
extern const char* const s_functionPrototypeCallCode;
extern const int s_functionPrototypeCallCodeLength;
extern const JSC::ConstructAbility s_functionPrototypeCallCodeConstructAbility;
extern const JSC::ConstructorKind s_functionPrototypeCallCodeConstructorKind;
extern const JSC::ImplementationVisibility s_functionPrototypeCallCodeImplementationVisibility;
extern const JSC::InlineAttribute s_functionPrototypeCallCodeInlineAttribute;
extern const char* const s_functionPrototypeApplyCode;
extern const int s_functionPrototypeApplyCodeLength;
extern const JSC::ConstructAbility s_functionPrototypeApplyCodeConstructAbility;
extern const JSC::ConstructorKind s_functionPrototypeApplyCodeConstructorKind;
extern const JSC::ImplementationVisibility s_functionPrototypeApplyCodeImplementationVisibility;
extern const JSC::InlineAttribute s_functionPrototypeApplyCodeInlineAttribute;
extern const char* const s_functionPrototypeSymbolHasInstanceCode;
extern const int s_functionPrototypeSymbolHasInstanceCodeLength;
extern const JSC::ConstructAbility s_functionPrototypeSymbolHasInstanceCodeConstructAbility;
extern const JSC::ConstructorKind s_functionPrototypeSymbolHasInstanceCodeConstructorKind;
extern const JSC::ImplementationVisibility s_functionPrototypeSymbolHasInstanceCodeImplementationVisibility;
extern const JSC::InlineAttribute s_functionPrototypeSymbolHasInstanceCodeInlineAttribute;

#define JSC_FOREACH_FUNCTIONPROTOTYPE_BUILTIN_DATA(macro) \
    macro(call, functionPrototypeCall, 1) \
    macro(apply, functionPrototypeApply, 2) \
    macro(symbolHasInstance, functionPrototypeSymbolHasInstance, 1) \

/* GeneratorPrototype */
extern const char* const s_generatorPrototypeGeneratorResumeCode;
extern const int s_generatorPrototypeGeneratorResumeCodeLength;
extern const JSC::ConstructAbility s_generatorPrototypeGeneratorResumeCodeConstructAbility;
extern const JSC::ConstructorKind s_generatorPrototypeGeneratorResumeCodeConstructorKind;
extern const JSC::ImplementationVisibility s_generatorPrototypeGeneratorResumeCodeImplementationVisibility;
extern const JSC::InlineAttribute s_generatorPrototypeGeneratorResumeCodeInlineAttribute;
extern const char* const s_generatorPrototypeNextCode;
extern const int s_generatorPrototypeNextCodeLength;
extern const JSC::ConstructAbility s_generatorPrototypeNextCodeConstructAbility;
extern const JSC::ConstructorKind s_generatorPrototypeNextCodeConstructorKind;
extern const JSC::ImplementationVisibility s_generatorPrototypeNextCodeImplementationVisibility;
extern const JSC::InlineAttribute s_generatorPrototypeNextCodeInlineAttribute;
extern const char* const s_generatorPrototypeReturnCode;
extern const int s_generatorPrototypeReturnCodeLength;
extern const JSC::ConstructAbility s_generatorPrototypeReturnCodeConstructAbility;
extern const JSC::ConstructorKind s_generatorPrototypeReturnCodeConstructorKind;
extern const JSC::ImplementationVisibility s_generatorPrototypeReturnCodeImplementationVisibility;
extern const JSC::InlineAttribute s_generatorPrototypeReturnCodeInlineAttribute;
extern const char* const s_generatorPrototypeThrowCode;
extern const int s_generatorPrototypeThrowCodeLength;
extern const JSC::ConstructAbility s_generatorPrototypeThrowCodeConstructAbility;
extern const JSC::ConstructorKind s_generatorPrototypeThrowCodeConstructorKind;
extern const JSC::ImplementationVisibility s_generatorPrototypeThrowCodeImplementationVisibility;
extern const JSC::InlineAttribute s_generatorPrototypeThrowCodeInlineAttribute;

#define JSC_FOREACH_GENERATORPROTOTYPE_BUILTIN_DATA(macro) \
    macro(generatorResume, generatorPrototypeGeneratorResume, 4) \
    macro(next, generatorPrototypeNext, 1) \
    macro(return, generatorPrototypeReturn, 1) \
    macro(throw, generatorPrototypeThrow, 1) \

/* GlobalObject */
extern const char* const s_globalObjectIsFiniteCode;
extern const int s_globalObjectIsFiniteCodeLength;
extern const JSC::ConstructAbility s_globalObjectIsFiniteCodeConstructAbility;
extern const JSC::ConstructorKind s_globalObjectIsFiniteCodeConstructorKind;
extern const JSC::ImplementationVisibility s_globalObjectIsFiniteCodeImplementationVisibility;
extern const JSC::InlineAttribute s_globalObjectIsFiniteCodeInlineAttribute;

#define JSC_FOREACH_GLOBALOBJECT_BUILTIN_DATA(macro) \
    macro(isFinite, globalObjectIsFinite, 1) \

/* GlobalOperations */
extern const char* const s_globalOperationsSpeciesConstructorCode;
extern const int s_globalOperationsSpeciesConstructorCodeLength;
extern const JSC::ConstructAbility s_globalOperationsSpeciesConstructorCodeConstructAbility;
extern const JSC::ConstructorKind s_globalOperationsSpeciesConstructorCodeConstructorKind;
extern const JSC::ImplementationVisibility s_globalOperationsSpeciesConstructorCodeImplementationVisibility;
extern const JSC::InlineAttribute s_globalOperationsSpeciesConstructorCodeInlineAttribute;

#define JSC_FOREACH_GLOBALOPERATIONS_BUILTIN_DATA(macro) \
    macro(speciesConstructor, globalOperationsSpeciesConstructor, 2) \

/* InternalPromiseConstructor */
extern const char* const s_internalPromiseConstructorInternalAllCode;
extern const int s_internalPromiseConstructorInternalAllCodeLength;
extern const JSC::ConstructAbility s_internalPromiseConstructorInternalAllCodeConstructAbility;
extern const JSC::ConstructorKind s_internalPromiseConstructorInternalAllCodeConstructorKind;
extern const JSC::ImplementationVisibility s_internalPromiseConstructorInternalAllCodeImplementationVisibility;
extern const JSC::InlineAttribute s_internalPromiseConstructorInternalAllCodeInlineAttribute;

#define JSC_FOREACH_INTERNALPROMISECONSTRUCTOR_BUILTIN_DATA(macro) \
    macro(internalAll, internalPromiseConstructorInternalAll, 1) \

/* IteratorHelpers */
extern const char* const s_iteratorHelpersPerformIterationCode;
extern const int s_iteratorHelpersPerformIterationCodeLength;
extern const JSC::ConstructAbility s_iteratorHelpersPerformIterationCodeConstructAbility;
extern const JSC::ConstructorKind s_iteratorHelpersPerformIterationCodeConstructorKind;
extern const JSC::ImplementationVisibility s_iteratorHelpersPerformIterationCodeImplementationVisibility;
extern const JSC::InlineAttribute s_iteratorHelpersPerformIterationCodeInlineAttribute;
extern const char* const s_iteratorHelpersWrappedIteratorCode;
extern const int s_iteratorHelpersWrappedIteratorCodeLength;
extern const JSC::ConstructAbility s_iteratorHelpersWrappedIteratorCodeConstructAbility;
extern const JSC::ConstructorKind s_iteratorHelpersWrappedIteratorCodeConstructorKind;
extern const JSC::ImplementationVisibility s_iteratorHelpersWrappedIteratorCodeImplementationVisibility;
extern const JSC::InlineAttribute s_iteratorHelpersWrappedIteratorCodeInlineAttribute;
extern const char* const s_iteratorHelpersBuiltinSetIterableCode;
extern const int s_iteratorHelpersBuiltinSetIterableCodeLength;
extern const JSC::ConstructAbility s_iteratorHelpersBuiltinSetIterableCodeConstructAbility;
extern const JSC::ConstructorKind s_iteratorHelpersBuiltinSetIterableCodeConstructorKind;
extern const JSC::ImplementationVisibility s_iteratorHelpersBuiltinSetIterableCodeImplementationVisibility;
extern const JSC::InlineAttribute s_iteratorHelpersBuiltinSetIterableCodeInlineAttribute;
extern const char* const s_iteratorHelpersBuiltinMapIterableCode;
extern const int s_iteratorHelpersBuiltinMapIterableCodeLength;
extern const JSC::ConstructAbility s_iteratorHelpersBuiltinMapIterableCodeConstructAbility;
extern const JSC::ConstructorKind s_iteratorHelpersBuiltinMapIterableCodeConstructorKind;
extern const JSC::ImplementationVisibility s_iteratorHelpersBuiltinMapIterableCodeImplementationVisibility;
extern const JSC::InlineAttribute s_iteratorHelpersBuiltinMapIterableCodeInlineAttribute;

#define JSC_FOREACH_ITERATORHELPERS_BUILTIN_DATA(macro) \
    macro(performIteration, iteratorHelpersPerformIteration, 1) \
    macro(wrappedIterator, iteratorHelpersWrappedIterator, 1) \
    macro(builtinSetIterable, iteratorHelpersBuiltinSetIterable, 1) \
    macro(builtinMapIterable, iteratorHelpersBuiltinMapIterable, 1) \

/* JSIteratorConstructor */
extern const char* const s_jsIteratorConstructorGetIteratorFlattenableCode;
extern const int s_jsIteratorConstructorGetIteratorFlattenableCodeLength;
extern const JSC::ConstructAbility s_jsIteratorConstructorGetIteratorFlattenableCodeConstructAbility;
extern const JSC::ConstructorKind s_jsIteratorConstructorGetIteratorFlattenableCodeConstructorKind;
extern const JSC::ImplementationVisibility s_jsIteratorConstructorGetIteratorFlattenableCodeImplementationVisibility;
extern const JSC::InlineAttribute s_jsIteratorConstructorGetIteratorFlattenableCodeInlineAttribute;
extern const char* const s_jsIteratorConstructorFromCode;
extern const int s_jsIteratorConstructorFromCodeLength;
extern const JSC::ConstructAbility s_jsIteratorConstructorFromCodeConstructAbility;
extern const JSC::ConstructorKind s_jsIteratorConstructorFromCodeConstructorKind;
extern const JSC::ImplementationVisibility s_jsIteratorConstructorFromCodeImplementationVisibility;
extern const JSC::InlineAttribute s_jsIteratorConstructorFromCodeInlineAttribute;
extern const char* const s_jsIteratorConstructorConcatCode;
extern const int s_jsIteratorConstructorConcatCodeLength;
extern const JSC::ConstructAbility s_jsIteratorConstructorConcatCodeConstructAbility;
extern const JSC::ConstructorKind s_jsIteratorConstructorConcatCodeConstructorKind;
extern const JSC::ImplementationVisibility s_jsIteratorConstructorConcatCodeImplementationVisibility;
extern const JSC::InlineAttribute s_jsIteratorConstructorConcatCodeInlineAttribute;

#define JSC_FOREACH_JSITERATORCONSTRUCTOR_BUILTIN_DATA(macro) \
    macro(getIteratorFlattenable, jsIteratorConstructorGetIteratorFlattenable, 2) \
    macro(from, jsIteratorConstructorFrom, 1) \
    macro(concat, jsIteratorConstructorConcat, 0) \

/* JSIteratorHelperPrototype */
extern const char* const s_jsIteratorHelperPrototypeNextCode;
extern const int s_jsIteratorHelperPrototypeNextCodeLength;
extern const JSC::ConstructAbility s_jsIteratorHelperPrototypeNextCodeConstructAbility;
extern const JSC::ConstructorKind s_jsIteratorHelperPrototypeNextCodeConstructorKind;
extern const JSC::ImplementationVisibility s_jsIteratorHelperPrototypeNextCodeImplementationVisibility;
extern const JSC::InlineAttribute s_jsIteratorHelperPrototypeNextCodeInlineAttribute;
extern const char* const s_jsIteratorHelperPrototypeReturnCode;
extern const int s_jsIteratorHelperPrototypeReturnCodeLength;
extern const JSC::ConstructAbility s_jsIteratorHelperPrototypeReturnCodeConstructAbility;
extern const JSC::ConstructorKind s_jsIteratorHelperPrototypeReturnCodeConstructorKind;
extern const JSC::ImplementationVisibility s_jsIteratorHelperPrototypeReturnCodeImplementationVisibility;
extern const JSC::InlineAttribute s_jsIteratorHelperPrototypeReturnCodeInlineAttribute;

#define JSC_FOREACH_JSITERATORHELPERPROTOTYPE_BUILTIN_DATA(macro) \
    macro(next, jsIteratorHelperPrototypeNext, 0) \
    macro(return, jsIteratorHelperPrototypeReturn, 0) \

/* JSIteratorPrototype */
extern const char* const s_jsIteratorPrototypeMapCode;
extern const int s_jsIteratorPrototypeMapCodeLength;
extern const JSC::ConstructAbility s_jsIteratorPrototypeMapCodeConstructAbility;
extern const JSC::ConstructorKind s_jsIteratorPrototypeMapCodeConstructorKind;
extern const JSC::ImplementationVisibility s_jsIteratorPrototypeMapCodeImplementationVisibility;
extern const JSC::InlineAttribute s_jsIteratorPrototypeMapCodeInlineAttribute;
extern const char* const s_jsIteratorPrototypeFilterCode;
extern const int s_jsIteratorPrototypeFilterCodeLength;
extern const JSC::ConstructAbility s_jsIteratorPrototypeFilterCodeConstructAbility;
extern const JSC::ConstructorKind s_jsIteratorPrototypeFilterCodeConstructorKind;
extern const JSC::ImplementationVisibility s_jsIteratorPrototypeFilterCodeImplementationVisibility;
extern const JSC::InlineAttribute s_jsIteratorPrototypeFilterCodeInlineAttribute;
extern const char* const s_jsIteratorPrototypeTakeCode;
extern const int s_jsIteratorPrototypeTakeCodeLength;
extern const JSC::ConstructAbility s_jsIteratorPrototypeTakeCodeConstructAbility;
extern const JSC::ConstructorKind s_jsIteratorPrototypeTakeCodeConstructorKind;
extern const JSC::ImplementationVisibility s_jsIteratorPrototypeTakeCodeImplementationVisibility;
extern const JSC::InlineAttribute s_jsIteratorPrototypeTakeCodeInlineAttribute;
extern const char* const s_jsIteratorPrototypeDropCode;
extern const int s_jsIteratorPrototypeDropCodeLength;
extern const JSC::ConstructAbility s_jsIteratorPrototypeDropCodeConstructAbility;
extern const JSC::ConstructorKind s_jsIteratorPrototypeDropCodeConstructorKind;
extern const JSC::ImplementationVisibility s_jsIteratorPrototypeDropCodeImplementationVisibility;
extern const JSC::InlineAttribute s_jsIteratorPrototypeDropCodeInlineAttribute;
extern const char* const s_jsIteratorPrototypeFlatMapCode;
extern const int s_jsIteratorPrototypeFlatMapCodeLength;
extern const JSC::ConstructAbility s_jsIteratorPrototypeFlatMapCodeConstructAbility;
extern const JSC::ConstructorKind s_jsIteratorPrototypeFlatMapCodeConstructorKind;
extern const JSC::ImplementationVisibility s_jsIteratorPrototypeFlatMapCodeImplementationVisibility;
extern const JSC::InlineAttribute s_jsIteratorPrototypeFlatMapCodeInlineAttribute;
extern const char* const s_jsIteratorPrototypeSomeCode;
extern const int s_jsIteratorPrototypeSomeCodeLength;
extern const JSC::ConstructAbility s_jsIteratorPrototypeSomeCodeConstructAbility;
extern const JSC::ConstructorKind s_jsIteratorPrototypeSomeCodeConstructorKind;
extern const JSC::ImplementationVisibility s_jsIteratorPrototypeSomeCodeImplementationVisibility;
extern const JSC::InlineAttribute s_jsIteratorPrototypeSomeCodeInlineAttribute;
extern const char* const s_jsIteratorPrototypeEveryCode;
extern const int s_jsIteratorPrototypeEveryCodeLength;
extern const JSC::ConstructAbility s_jsIteratorPrototypeEveryCodeConstructAbility;
extern const JSC::ConstructorKind s_jsIteratorPrototypeEveryCodeConstructorKind;
extern const JSC::ImplementationVisibility s_jsIteratorPrototypeEveryCodeImplementationVisibility;
extern const JSC::InlineAttribute s_jsIteratorPrototypeEveryCodeInlineAttribute;
extern const char* const s_jsIteratorPrototypeFindCode;
extern const int s_jsIteratorPrototypeFindCodeLength;
extern const JSC::ConstructAbility s_jsIteratorPrototypeFindCodeConstructAbility;
extern const JSC::ConstructorKind s_jsIteratorPrototypeFindCodeConstructorKind;
extern const JSC::ImplementationVisibility s_jsIteratorPrototypeFindCodeImplementationVisibility;
extern const JSC::InlineAttribute s_jsIteratorPrototypeFindCodeInlineAttribute;
extern const char* const s_jsIteratorPrototypeReduceCode;
extern const int s_jsIteratorPrototypeReduceCodeLength;
extern const JSC::ConstructAbility s_jsIteratorPrototypeReduceCodeConstructAbility;
extern const JSC::ConstructorKind s_jsIteratorPrototypeReduceCodeConstructorKind;
extern const JSC::ImplementationVisibility s_jsIteratorPrototypeReduceCodeImplementationVisibility;
extern const JSC::InlineAttribute s_jsIteratorPrototypeReduceCodeInlineAttribute;
extern const char* const s_jsIteratorPrototypeChunksCode;
extern const int s_jsIteratorPrototypeChunksCodeLength;
extern const JSC::ConstructAbility s_jsIteratorPrototypeChunksCodeConstructAbility;
extern const JSC::ConstructorKind s_jsIteratorPrototypeChunksCodeConstructorKind;
extern const JSC::ImplementationVisibility s_jsIteratorPrototypeChunksCodeImplementationVisibility;
extern const JSC::InlineAttribute s_jsIteratorPrototypeChunksCodeInlineAttribute;
extern const char* const s_jsIteratorPrototypeWindowsCode;
extern const int s_jsIteratorPrototypeWindowsCodeLength;
extern const JSC::ConstructAbility s_jsIteratorPrototypeWindowsCodeConstructAbility;
extern const JSC::ConstructorKind s_jsIteratorPrototypeWindowsCodeConstructorKind;
extern const JSC::ImplementationVisibility s_jsIteratorPrototypeWindowsCodeImplementationVisibility;
extern const JSC::InlineAttribute s_jsIteratorPrototypeWindowsCodeInlineAttribute;

#define JSC_FOREACH_JSITERATORPROTOTYPE_BUILTIN_DATA(macro) \
    macro(map, jsIteratorPrototypeMap, 1) \
    macro(filter, jsIteratorPrototypeFilter, 1) \
    macro(take, jsIteratorPrototypeTake, 1) \
    macro(drop, jsIteratorPrototypeDrop, 1) \
    macro(flatMap, jsIteratorPrototypeFlatMap, 1) \
    macro(some, jsIteratorPrototypeSome, 1) \
    macro(every, jsIteratorPrototypeEvery, 1) \
    macro(find, jsIteratorPrototypeFind, 1) \
    macro(reduce, jsIteratorPrototypeReduce, 1) \
    macro(chunks, jsIteratorPrototypeChunks, 1) \
    macro(windows, jsIteratorPrototypeWindows, 1) \

/* MapConstructor */
extern const char* const s_mapConstructorGroupByCode;
extern const int s_mapConstructorGroupByCodeLength;
extern const JSC::ConstructAbility s_mapConstructorGroupByCodeConstructAbility;
extern const JSC::ConstructorKind s_mapConstructorGroupByCodeConstructorKind;
extern const JSC::ImplementationVisibility s_mapConstructorGroupByCodeImplementationVisibility;
extern const JSC::InlineAttribute s_mapConstructorGroupByCodeInlineAttribute;

#define JSC_FOREACH_MAPCONSTRUCTOR_BUILTIN_DATA(macro) \
    macro(groupBy, mapConstructorGroupBy, 2) \

/* MapIteratorPrototype */
extern const char* const s_mapIteratorPrototypeNextCode;
extern const int s_mapIteratorPrototypeNextCodeLength;
extern const JSC::ConstructAbility s_mapIteratorPrototypeNextCodeConstructAbility;
extern const JSC::ConstructorKind s_mapIteratorPrototypeNextCodeConstructorKind;
extern const JSC::ImplementationVisibility s_mapIteratorPrototypeNextCodeImplementationVisibility;
extern const JSC::InlineAttribute s_mapIteratorPrototypeNextCodeInlineAttribute;

#define JSC_FOREACH_MAPITERATORPROTOTYPE_BUILTIN_DATA(macro) \
    macro(next, mapIteratorPrototypeNext, 0) \

/* MapPrototype */
extern const char* const s_mapPrototypeForEachCode;
extern const int s_mapPrototypeForEachCodeLength;
extern const JSC::ConstructAbility s_mapPrototypeForEachCodeConstructAbility;
extern const JSC::ConstructorKind s_mapPrototypeForEachCodeConstructorKind;
extern const JSC::ImplementationVisibility s_mapPrototypeForEachCodeImplementationVisibility;
extern const JSC::InlineAttribute s_mapPrototypeForEachCodeInlineAttribute;

#define JSC_FOREACH_MAPPROTOTYPE_BUILTIN_DATA(macro) \
    macro(forEach, mapPrototypeForEach, 1) \

/* ModuleLoader */
extern const char* const s_moduleLoaderSetStateToMaxCode;
extern const int s_moduleLoaderSetStateToMaxCodeLength;
extern const JSC::ConstructAbility s_moduleLoaderSetStateToMaxCodeConstructAbility;
extern const JSC::ConstructorKind s_moduleLoaderSetStateToMaxCodeConstructorKind;
extern const JSC::ImplementationVisibility s_moduleLoaderSetStateToMaxCodeImplementationVisibility;
extern const JSC::InlineAttribute s_moduleLoaderSetStateToMaxCodeInlineAttribute;
extern const char* const s_moduleLoaderNewRegistryEntryCode;
extern const int s_moduleLoaderNewRegistryEntryCodeLength;
extern const JSC::ConstructAbility s_moduleLoaderNewRegistryEntryCodeConstructAbility;
extern const JSC::ConstructorKind s_moduleLoaderNewRegistryEntryCodeConstructorKind;
extern const JSC::ImplementationVisibility s_moduleLoaderNewRegistryEntryCodeImplementationVisibility;
extern const JSC::InlineAttribute s_moduleLoaderNewRegistryEntryCodeInlineAttribute;
extern const char* const s_moduleLoaderEnsureRegisteredCode;
extern const int s_moduleLoaderEnsureRegisteredCodeLength;
extern const JSC::ConstructAbility s_moduleLoaderEnsureRegisteredCodeConstructAbility;
extern const JSC::ConstructorKind s_moduleLoaderEnsureRegisteredCodeConstructorKind;
extern const JSC::ImplementationVisibility s_moduleLoaderEnsureRegisteredCodeImplementationVisibility;
extern const JSC::InlineAttribute s_moduleLoaderEnsureRegisteredCodeInlineAttribute;
extern const char* const s_moduleLoaderForceFulfillPromiseCode;
extern const int s_moduleLoaderForceFulfillPromiseCodeLength;
extern const JSC::ConstructAbility s_moduleLoaderForceFulfillPromiseCodeConstructAbility;
extern const JSC::ConstructorKind s_moduleLoaderForceFulfillPromiseCodeConstructorKind;
extern const JSC::ImplementationVisibility s_moduleLoaderForceFulfillPromiseCodeImplementationVisibility;
extern const JSC::InlineAttribute s_moduleLoaderForceFulfillPromiseCodeInlineAttribute;
extern const char* const s_moduleLoaderFulfillFetchCode;
extern const int s_moduleLoaderFulfillFetchCodeLength;
extern const JSC::ConstructAbility s_moduleLoaderFulfillFetchCodeConstructAbility;
extern const JSC::ConstructorKind s_moduleLoaderFulfillFetchCodeConstructorKind;
extern const JSC::ImplementationVisibility s_moduleLoaderFulfillFetchCodeImplementationVisibility;
extern const JSC::InlineAttribute s_moduleLoaderFulfillFetchCodeInlineAttribute;
extern const char* const s_moduleLoaderRequestFetchCode;
extern const int s_moduleLoaderRequestFetchCodeLength;
extern const JSC::ConstructAbility s_moduleLoaderRequestFetchCodeConstructAbility;
extern const JSC::ConstructorKind s_moduleLoaderRequestFetchCodeConstructorKind;
extern const JSC::ImplementationVisibility s_moduleLoaderRequestFetchCodeImplementationVisibility;
extern const JSC::InlineAttribute s_moduleLoaderRequestFetchCodeInlineAttribute;
extern const char* const s_moduleLoaderRequestInstantiateCode;
extern const int s_moduleLoaderRequestInstantiateCodeLength;
extern const JSC::ConstructAbility s_moduleLoaderRequestInstantiateCodeConstructAbility;
extern const JSC::ConstructorKind s_moduleLoaderRequestInstantiateCodeConstructorKind;
extern const JSC::ImplementationVisibility s_moduleLoaderRequestInstantiateCodeImplementationVisibility;
extern const JSC::InlineAttribute s_moduleLoaderRequestInstantiateCodeInlineAttribute;
extern const char* const s_moduleLoaderCacheSatisfyCode;
extern const int s_moduleLoaderCacheSatisfyCodeLength;
extern const JSC::ConstructAbility s_moduleLoaderCacheSatisfyCodeConstructAbility;
extern const JSC::ConstructorKind s_moduleLoaderCacheSatisfyCodeConstructorKind;
extern const JSC::ImplementationVisibility s_moduleLoaderCacheSatisfyCodeImplementationVisibility;
extern const JSC::InlineAttribute s_moduleLoaderCacheSatisfyCodeInlineAttribute;
extern const char* const s_moduleLoaderCacheSatisfyAndReturnCode;
extern const int s_moduleLoaderCacheSatisfyAndReturnCodeLength;
extern const JSC::ConstructAbility s_moduleLoaderCacheSatisfyAndReturnCodeConstructAbility;
extern const JSC::ConstructorKind s_moduleLoaderCacheSatisfyAndReturnCodeConstructorKind;
extern const JSC::ImplementationVisibility s_moduleLoaderCacheSatisfyAndReturnCodeImplementationVisibility;
extern const JSC::InlineAttribute s_moduleLoaderCacheSatisfyAndReturnCodeInlineAttribute;
extern const char* const s_moduleLoaderRequestSatisfyCode;
extern const int s_moduleLoaderRequestSatisfyCodeLength;
extern const JSC::ConstructAbility s_moduleLoaderRequestSatisfyCodeConstructAbility;
extern const JSC::ConstructorKind s_moduleLoaderRequestSatisfyCodeConstructorKind;
extern const JSC::ImplementationVisibility s_moduleLoaderRequestSatisfyCodeImplementationVisibility;
extern const JSC::InlineAttribute s_moduleLoaderRequestSatisfyCodeInlineAttribute;
extern const char* const s_moduleLoaderRequestSatisfyUtilCode;
extern const int s_moduleLoaderRequestSatisfyUtilCodeLength;
extern const JSC::ConstructAbility s_moduleLoaderRequestSatisfyUtilCodeConstructAbility;
extern const JSC::ConstructorKind s_moduleLoaderRequestSatisfyUtilCodeConstructorKind;
extern const JSC::ImplementationVisibility s_moduleLoaderRequestSatisfyUtilCodeImplementationVisibility;
extern const JSC::InlineAttribute s_moduleLoaderRequestSatisfyUtilCodeInlineAttribute;
extern const char* const s_moduleLoaderLinkCode;
extern const int s_moduleLoaderLinkCodeLength;
extern const JSC::ConstructAbility s_moduleLoaderLinkCodeConstructAbility;
extern const JSC::ConstructorKind s_moduleLoaderLinkCodeConstructorKind;
extern const JSC::ImplementationVisibility s_moduleLoaderLinkCodeImplementationVisibility;
extern const JSC::InlineAttribute s_moduleLoaderLinkCodeInlineAttribute;
extern const char* const s_moduleLoaderModuleEvaluationCode;
extern const int s_moduleLoaderModuleEvaluationCodeLength;
extern const JSC::ConstructAbility s_moduleLoaderModuleEvaluationCodeConstructAbility;
extern const JSC::ConstructorKind s_moduleLoaderModuleEvaluationCodeConstructorKind;
extern const JSC::ImplementationVisibility s_moduleLoaderModuleEvaluationCodeImplementationVisibility;
extern const JSC::InlineAttribute s_moduleLoaderModuleEvaluationCodeInlineAttribute;
extern const char* const s_moduleLoaderAsyncModuleEvaluationCode;
extern const int s_moduleLoaderAsyncModuleEvaluationCodeLength;
extern const JSC::ConstructAbility s_moduleLoaderAsyncModuleEvaluationCodeConstructAbility;
extern const JSC::ConstructorKind s_moduleLoaderAsyncModuleEvaluationCodeConstructorKind;
extern const JSC::ImplementationVisibility s_moduleLoaderAsyncModuleEvaluationCodeImplementationVisibility;
extern const JSC::InlineAttribute s_moduleLoaderAsyncModuleEvaluationCodeInlineAttribute;
extern const char* const s_moduleLoaderProvideFetchCode;
extern const int s_moduleLoaderProvideFetchCodeLength;
extern const JSC::ConstructAbility s_moduleLoaderProvideFetchCodeConstructAbility;
extern const JSC::ConstructorKind s_moduleLoaderProvideFetchCodeConstructorKind;
extern const JSC::ImplementationVisibility s_moduleLoaderProvideFetchCodeImplementationVisibility;
extern const JSC::InlineAttribute s_moduleLoaderProvideFetchCodeInlineAttribute;
extern const char* const s_moduleLoaderLoadModuleCode;
extern const int s_moduleLoaderLoadModuleCodeLength;
extern const JSC::ConstructAbility s_moduleLoaderLoadModuleCodeConstructAbility;
extern const JSC::ConstructorKind s_moduleLoaderLoadModuleCodeConstructorKind;
extern const JSC::ImplementationVisibility s_moduleLoaderLoadModuleCodeImplementationVisibility;
extern const JSC::InlineAttribute s_moduleLoaderLoadModuleCodeInlineAttribute;
extern const char* const s_moduleLoaderLinkAndEvaluateModuleCode;
extern const int s_moduleLoaderLinkAndEvaluateModuleCodeLength;
extern const JSC::ConstructAbility s_moduleLoaderLinkAndEvaluateModuleCodeConstructAbility;
extern const JSC::ConstructorKind s_moduleLoaderLinkAndEvaluateModuleCodeConstructorKind;
extern const JSC::ImplementationVisibility s_moduleLoaderLinkAndEvaluateModuleCodeImplementationVisibility;
extern const JSC::InlineAttribute s_moduleLoaderLinkAndEvaluateModuleCodeInlineAttribute;
extern const char* const s_moduleLoaderLoadAndEvaluateModuleCode;
extern const int s_moduleLoaderLoadAndEvaluateModuleCodeLength;
extern const JSC::ConstructAbility s_moduleLoaderLoadAndEvaluateModuleCodeConstructAbility;
extern const JSC::ConstructorKind s_moduleLoaderLoadAndEvaluateModuleCodeConstructorKind;
extern const JSC::ImplementationVisibility s_moduleLoaderLoadAndEvaluateModuleCodeImplementationVisibility;
extern const JSC::InlineAttribute s_moduleLoaderLoadAndEvaluateModuleCodeInlineAttribute;
extern const char* const s_moduleLoaderRequestImportModuleCode;
extern const int s_moduleLoaderRequestImportModuleCodeLength;
extern const JSC::ConstructAbility s_moduleLoaderRequestImportModuleCodeConstructAbility;
extern const JSC::ConstructorKind s_moduleLoaderRequestImportModuleCodeConstructorKind;
extern const JSC::ImplementationVisibility s_moduleLoaderRequestImportModuleCodeImplementationVisibility;
extern const JSC::InlineAttribute s_moduleLoaderRequestImportModuleCodeInlineAttribute;
extern const char* const s_moduleLoaderDependencyKeysIfEvaluatedCode;
extern const int s_moduleLoaderDependencyKeysIfEvaluatedCodeLength;
extern const JSC::ConstructAbility s_moduleLoaderDependencyKeysIfEvaluatedCodeConstructAbility;
extern const JSC::ConstructorKind s_moduleLoaderDependencyKeysIfEvaluatedCodeConstructorKind;
extern const JSC::ImplementationVisibility s_moduleLoaderDependencyKeysIfEvaluatedCodeImplementationVisibility;
extern const JSC::InlineAttribute s_moduleLoaderDependencyKeysIfEvaluatedCodeInlineAttribute;

#define JSC_FOREACH_MODULELOADER_BUILTIN_DATA(macro) \
    macro(setStateToMax, moduleLoaderSetStateToMax, 2) \
    macro(newRegistryEntry, moduleLoaderNewRegistryEntry, 1) \
    macro(ensureRegistered, moduleLoaderEnsureRegistered, 1) \
    macro(forceFulfillPromise, moduleLoaderForceFulfillPromise, 2) \
    macro(fulfillFetch, moduleLoaderFulfillFetch, 2) \
    macro(requestFetch, moduleLoaderRequestFetch, 3) \
    macro(requestInstantiate, moduleLoaderRequestInstantiate, 3) \
    macro(cacheSatisfy, moduleLoaderCacheSatisfy, 1) \
    macro(cacheSatisfyAndReturn, moduleLoaderCacheSatisfyAndReturn, 3) \
    macro(requestSatisfy, moduleLoaderRequestSatisfy, 4) \
    macro(requestSatisfyUtil, moduleLoaderRequestSatisfyUtil, 5) \
    macro(link, moduleLoaderLink, 2) \
    macro(moduleEvaluation, moduleLoaderModuleEvaluation, 2) \
    macro(asyncModuleEvaluation, moduleLoaderAsyncModuleEvaluation, 3) \
    macro(provideFetch, moduleLoaderProvideFetch, 2) \
    macro(loadModule, moduleLoaderLoadModule, 3) \
    macro(linkAndEvaluateModule, moduleLoaderLinkAndEvaluateModule, 2) \
    macro(loadAndEvaluateModule, moduleLoaderLoadAndEvaluateModule, 3) \
    macro(requestImportModule, moduleLoaderRequestImportModule, 4) \
    macro(dependencyKeysIfEvaluated, moduleLoaderDependencyKeysIfEvaluated, 1) \

/* NumberConstructor */
extern const char* const s_numberConstructorIsFiniteCode;
extern const int s_numberConstructorIsFiniteCodeLength;
extern const JSC::ConstructAbility s_numberConstructorIsFiniteCodeConstructAbility;
extern const JSC::ConstructorKind s_numberConstructorIsFiniteCodeConstructorKind;
extern const JSC::ImplementationVisibility s_numberConstructorIsFiniteCodeImplementationVisibility;
extern const JSC::InlineAttribute s_numberConstructorIsFiniteCodeInlineAttribute;

#define JSC_FOREACH_NUMBERCONSTRUCTOR_BUILTIN_DATA(macro) \
    macro(isFinite, numberConstructorIsFinite, 1) \

/* ObjectConstructor */
extern const char* const s_objectConstructorFromEntriesCode;
extern const int s_objectConstructorFromEntriesCodeLength;
extern const JSC::ConstructAbility s_objectConstructorFromEntriesCodeConstructAbility;
extern const JSC::ConstructorKind s_objectConstructorFromEntriesCodeConstructorKind;
extern const JSC::ImplementationVisibility s_objectConstructorFromEntriesCodeImplementationVisibility;
extern const JSC::InlineAttribute s_objectConstructorFromEntriesCodeInlineAttribute;
extern const char* const s_objectConstructorGroupByCode;
extern const int s_objectConstructorGroupByCodeLength;
extern const JSC::ConstructAbility s_objectConstructorGroupByCodeConstructAbility;
extern const JSC::ConstructorKind s_objectConstructorGroupByCodeConstructorKind;
extern const JSC::ImplementationVisibility s_objectConstructorGroupByCodeImplementationVisibility;
extern const JSC::InlineAttribute s_objectConstructorGroupByCodeInlineAttribute;

#define JSC_FOREACH_OBJECTCONSTRUCTOR_BUILTIN_DATA(macro) \
    macro(fromEntries, objectConstructorFromEntries, 1) \
    macro(groupBy, objectConstructorGroupBy, 2) \

/* PromiseConstructor */
extern const char* const s_promiseConstructorPromiseAllSlowCode;
extern const int s_promiseConstructorPromiseAllSlowCodeLength;
extern const JSC::ConstructAbility s_promiseConstructorPromiseAllSlowCodeConstructAbility;
extern const JSC::ConstructorKind s_promiseConstructorPromiseAllSlowCodeConstructorKind;
extern const JSC::ImplementationVisibility s_promiseConstructorPromiseAllSlowCodeImplementationVisibility;
extern const JSC::InlineAttribute s_promiseConstructorPromiseAllSlowCodeInlineAttribute;
extern const char* const s_promiseConstructorPromiseOnRejectedWithContextCode;
extern const int s_promiseConstructorPromiseOnRejectedWithContextCodeLength;
extern const JSC::ConstructAbility s_promiseConstructorPromiseOnRejectedWithContextCodeConstructAbility;
extern const JSC::ConstructorKind s_promiseConstructorPromiseOnRejectedWithContextCodeConstructorKind;
extern const JSC::ImplementationVisibility s_promiseConstructorPromiseOnRejectedWithContextCodeImplementationVisibility;
extern const JSC::InlineAttribute s_promiseConstructorPromiseOnRejectedWithContextCodeInlineAttribute;
extern const char* const s_promiseConstructorPromiseAllOnFulfilledCode;
extern const int s_promiseConstructorPromiseAllOnFulfilledCodeLength;
extern const JSC::ConstructAbility s_promiseConstructorPromiseAllOnFulfilledCodeConstructAbility;
extern const JSC::ConstructorKind s_promiseConstructorPromiseAllOnFulfilledCodeConstructorKind;
extern const JSC::ImplementationVisibility s_promiseConstructorPromiseAllOnFulfilledCodeImplementationVisibility;
extern const JSC::InlineAttribute s_promiseConstructorPromiseAllOnFulfilledCodeInlineAttribute;
extern const char* const s_promiseConstructorPromiseNewOnRejectedCode;
extern const int s_promiseConstructorPromiseNewOnRejectedCodeLength;
extern const JSC::ConstructAbility s_promiseConstructorPromiseNewOnRejectedCodeConstructAbility;
extern const JSC::ConstructorKind s_promiseConstructorPromiseNewOnRejectedCodeConstructorKind;
extern const JSC::ImplementationVisibility s_promiseConstructorPromiseNewOnRejectedCodeImplementationVisibility;
extern const JSC::InlineAttribute s_promiseConstructorPromiseNewOnRejectedCodeInlineAttribute;
extern const char* const s_promiseConstructorPromiseAllNewResolveElementCode;
extern const int s_promiseConstructorPromiseAllNewResolveElementCodeLength;
extern const JSC::ConstructAbility s_promiseConstructorPromiseAllNewResolveElementCodeConstructAbility;
extern const JSC::ConstructorKind s_promiseConstructorPromiseAllNewResolveElementCodeConstructorKind;
extern const JSC::ImplementationVisibility s_promiseConstructorPromiseAllNewResolveElementCodeImplementationVisibility;
extern const JSC::InlineAttribute s_promiseConstructorPromiseAllNewResolveElementCodeInlineAttribute;
extern const char* const s_promiseConstructorAllCode;
extern const int s_promiseConstructorAllCodeLength;
extern const JSC::ConstructAbility s_promiseConstructorAllCodeConstructAbility;
extern const JSC::ConstructorKind s_promiseConstructorAllCodeConstructorKind;
extern const JSC::ImplementationVisibility s_promiseConstructorAllCodeImplementationVisibility;
extern const JSC::InlineAttribute s_promiseConstructorAllCodeInlineAttribute;
extern const char* const s_promiseConstructorAllSettledCode;
extern const int s_promiseConstructorAllSettledCodeLength;
extern const JSC::ConstructAbility s_promiseConstructorAllSettledCodeConstructAbility;
extern const JSC::ConstructorKind s_promiseConstructorAllSettledCodeConstructorKind;
extern const JSC::ImplementationVisibility s_promiseConstructorAllSettledCodeImplementationVisibility;
extern const JSC::InlineAttribute s_promiseConstructorAllSettledCodeInlineAttribute;
extern const char* const s_promiseConstructorAnyCode;
extern const int s_promiseConstructorAnyCodeLength;
extern const JSC::ConstructAbility s_promiseConstructorAnyCodeConstructAbility;
extern const JSC::ConstructorKind s_promiseConstructorAnyCodeConstructorKind;
extern const JSC::ImplementationVisibility s_promiseConstructorAnyCodeImplementationVisibility;
extern const JSC::InlineAttribute s_promiseConstructorAnyCodeInlineAttribute;
extern const char* const s_promiseConstructorRaceCode;
extern const int s_promiseConstructorRaceCodeLength;
extern const JSC::ConstructAbility s_promiseConstructorRaceCodeConstructAbility;
extern const JSC::ConstructorKind s_promiseConstructorRaceCodeConstructorKind;
extern const JSC::ImplementationVisibility s_promiseConstructorRaceCodeImplementationVisibility;
extern const JSC::InlineAttribute s_promiseConstructorRaceCodeInlineAttribute;
extern const char* const s_promiseConstructorRejectCode;
extern const int s_promiseConstructorRejectCodeLength;
extern const JSC::ConstructAbility s_promiseConstructorRejectCodeConstructAbility;
extern const JSC::ConstructorKind s_promiseConstructorRejectCodeConstructorKind;
extern const JSC::ImplementationVisibility s_promiseConstructorRejectCodeImplementationVisibility;
extern const JSC::InlineAttribute s_promiseConstructorRejectCodeInlineAttribute;
extern const char* const s_promiseConstructorResolveCode;
extern const int s_promiseConstructorResolveCodeLength;
extern const JSC::ConstructAbility s_promiseConstructorResolveCodeConstructAbility;
extern const JSC::ConstructorKind s_promiseConstructorResolveCodeConstructorKind;
extern const JSC::ImplementationVisibility s_promiseConstructorResolveCodeImplementationVisibility;
extern const JSC::InlineAttribute s_promiseConstructorResolveCodeInlineAttribute;
extern const char* const s_promiseConstructorTryCode;
extern const int s_promiseConstructorTryCodeLength;
extern const JSC::ConstructAbility s_promiseConstructorTryCodeConstructAbility;
extern const JSC::ConstructorKind s_promiseConstructorTryCodeConstructorKind;
extern const JSC::ImplementationVisibility s_promiseConstructorTryCodeImplementationVisibility;
extern const JSC::InlineAttribute s_promiseConstructorTryCodeInlineAttribute;
extern const char* const s_promiseConstructorWithResolversCode;
extern const int s_promiseConstructorWithResolversCodeLength;
extern const JSC::ConstructAbility s_promiseConstructorWithResolversCodeConstructAbility;
extern const JSC::ConstructorKind s_promiseConstructorWithResolversCodeConstructorKind;
extern const JSC::ImplementationVisibility s_promiseConstructorWithResolversCodeImplementationVisibility;
extern const JSC::InlineAttribute s_promiseConstructorWithResolversCodeInlineAttribute;
extern const char* const s_promiseConstructorPromiseConstructorCode;
extern const int s_promiseConstructorPromiseConstructorCodeLength;
extern const JSC::ConstructAbility s_promiseConstructorPromiseConstructorCodeConstructAbility;
extern const JSC::ConstructorKind s_promiseConstructorPromiseConstructorCodeConstructorKind;
extern const JSC::ImplementationVisibility s_promiseConstructorPromiseConstructorCodeImplementationVisibility;
extern const JSC::InlineAttribute s_promiseConstructorPromiseConstructorCodeInlineAttribute;
extern const char* const s_promiseConstructorInternalPromiseConstructorCode;
extern const int s_promiseConstructorInternalPromiseConstructorCodeLength;
extern const JSC::ConstructAbility s_promiseConstructorInternalPromiseConstructorCodeConstructAbility;
extern const JSC::ConstructorKind s_promiseConstructorInternalPromiseConstructorCodeConstructorKind;
extern const JSC::ImplementationVisibility s_promiseConstructorInternalPromiseConstructorCodeImplementationVisibility;
extern const JSC::InlineAttribute s_promiseConstructorInternalPromiseConstructorCodeInlineAttribute;

#define JSC_FOREACH_PROMISECONSTRUCTOR_BUILTIN_DATA(macro) \
    macro(promiseAllSlow, promiseConstructorPromiseAllSlow, 1) \
    macro(promiseOnRejectedWithContext, promiseConstructorPromiseOnRejectedWithContext, 2) \
    macro(promiseAllOnFulfilled, promiseConstructorPromiseAllOnFulfilled, 2) \
    macro(promiseNewOnRejected, promiseConstructorPromiseNewOnRejected, 1) \
    macro(promiseAllNewResolveElement, promiseConstructorPromiseAllNewResolveElement, 2) \
    macro(all, promiseConstructorAll, 1) \
    macro(allSettled, promiseConstructorAllSettled, 1) \
    macro(any, promiseConstructorAny, 1) \
    macro(race, promiseConstructorRace, 1) \
    macro(reject, promiseConstructorReject, 1) \
    macro(resolve, promiseConstructorResolve, 1) \
    macro(try, promiseConstructorTry, 1) \
    macro(withResolvers, promiseConstructorWithResolvers, 0) \
    macro(Promise, promiseConstructorPromiseConstructor, 1) \
    macro(InternalPromise, promiseConstructorInternalPromiseConstructor, 1) \

/* PromiseOperations */
extern const char* const s_promiseOperationsPushNewPromiseReactionCode;
extern const int s_promiseOperationsPushNewPromiseReactionCodeLength;
extern const JSC::ConstructAbility s_promiseOperationsPushNewPromiseReactionCodeConstructAbility;
extern const JSC::ConstructorKind s_promiseOperationsPushNewPromiseReactionCodeConstructorKind;
extern const JSC::ImplementationVisibility s_promiseOperationsPushNewPromiseReactionCodeImplementationVisibility;
extern const JSC::InlineAttribute s_promiseOperationsPushNewPromiseReactionCodeInlineAttribute;
extern const char* const s_promiseOperationsNewPromiseCapabilitySlowCode;
extern const int s_promiseOperationsNewPromiseCapabilitySlowCodeLength;
extern const JSC::ConstructAbility s_promiseOperationsNewPromiseCapabilitySlowCodeConstructAbility;
extern const JSC::ConstructorKind s_promiseOperationsNewPromiseCapabilitySlowCodeConstructorKind;
extern const JSC::ImplementationVisibility s_promiseOperationsNewPromiseCapabilitySlowCodeImplementationVisibility;
extern const JSC::InlineAttribute s_promiseOperationsNewPromiseCapabilitySlowCodeInlineAttribute;
extern const char* const s_promiseOperationsNewPromiseCapabilityCode;
extern const int s_promiseOperationsNewPromiseCapabilityCodeLength;
extern const JSC::ConstructAbility s_promiseOperationsNewPromiseCapabilityCodeConstructAbility;
extern const JSC::ConstructorKind s_promiseOperationsNewPromiseCapabilityCodeConstructorKind;
extern const JSC::ImplementationVisibility s_promiseOperationsNewPromiseCapabilityCodeImplementationVisibility;
extern const JSC::InlineAttribute s_promiseOperationsNewPromiseCapabilityCodeInlineAttribute;
extern const char* const s_promiseOperationsPromiseResolveCode;
extern const int s_promiseOperationsPromiseResolveCodeLength;
extern const JSC::ConstructAbility s_promiseOperationsPromiseResolveCodeConstructAbility;
extern const JSC::ConstructorKind s_promiseOperationsPromiseResolveCodeConstructorKind;
extern const JSC::ImplementationVisibility s_promiseOperationsPromiseResolveCodeImplementationVisibility;
extern const JSC::InlineAttribute s_promiseOperationsPromiseResolveCodeInlineAttribute;
extern const char* const s_promiseOperationsPromiseResolveSlowCode;
extern const int s_promiseOperationsPromiseResolveSlowCodeLength;
extern const JSC::ConstructAbility s_promiseOperationsPromiseResolveSlowCodeConstructAbility;
extern const JSC::ConstructorKind s_promiseOperationsPromiseResolveSlowCodeConstructorKind;
extern const JSC::ImplementationVisibility s_promiseOperationsPromiseResolveSlowCodeImplementationVisibility;
extern const JSC::InlineAttribute s_promiseOperationsPromiseResolveSlowCodeInlineAttribute;
extern const char* const s_promiseOperationsPromiseRejectSlowCode;
extern const int s_promiseOperationsPromiseRejectSlowCodeLength;
extern const JSC::ConstructAbility s_promiseOperationsPromiseRejectSlowCodeConstructAbility;
extern const JSC::ConstructorKind s_promiseOperationsPromiseRejectSlowCodeConstructorKind;
extern const JSC::ImplementationVisibility s_promiseOperationsPromiseRejectSlowCodeImplementationVisibility;
extern const JSC::InlineAttribute s_promiseOperationsPromiseRejectSlowCodeInlineAttribute;
extern const char* const s_promiseOperationsNewHandledRejectedPromiseCode;
extern const int s_promiseOperationsNewHandledRejectedPromiseCodeLength;
extern const JSC::ConstructAbility s_promiseOperationsNewHandledRejectedPromiseCodeConstructAbility;
extern const JSC::ConstructorKind s_promiseOperationsNewHandledRejectedPromiseCodeConstructorKind;
extern const JSC::ImplementationVisibility s_promiseOperationsNewHandledRejectedPromiseCodeImplementationVisibility;
extern const JSC::InlineAttribute s_promiseOperationsNewHandledRejectedPromiseCodeInlineAttribute;
extern const char* const s_promiseOperationsTriggerPromiseReactionsCode;
extern const int s_promiseOperationsTriggerPromiseReactionsCodeLength;
extern const JSC::ConstructAbility s_promiseOperationsTriggerPromiseReactionsCodeConstructAbility;
extern const JSC::ConstructorKind s_promiseOperationsTriggerPromiseReactionsCodeConstructorKind;
extern const JSC::ImplementationVisibility s_promiseOperationsTriggerPromiseReactionsCodeImplementationVisibility;
extern const JSC::InlineAttribute s_promiseOperationsTriggerPromiseReactionsCodeInlineAttribute;
extern const char* const s_promiseOperationsResolvePromiseCode;
extern const int s_promiseOperationsResolvePromiseCodeLength;
extern const JSC::ConstructAbility s_promiseOperationsResolvePromiseCodeConstructAbility;
extern const JSC::ConstructorKind s_promiseOperationsResolvePromiseCodeConstructorKind;
extern const JSC::ImplementationVisibility s_promiseOperationsResolvePromiseCodeImplementationVisibility;
extern const JSC::InlineAttribute s_promiseOperationsResolvePromiseCodeInlineAttribute;
extern const char* const s_promiseOperationsRejectPromiseCode;
extern const int s_promiseOperationsRejectPromiseCodeLength;
extern const JSC::ConstructAbility s_promiseOperationsRejectPromiseCodeConstructAbility;
extern const JSC::ConstructorKind s_promiseOperationsRejectPromiseCodeConstructorKind;
extern const JSC::ImplementationVisibility s_promiseOperationsRejectPromiseCodeImplementationVisibility;
extern const JSC::InlineAttribute s_promiseOperationsRejectPromiseCodeInlineAttribute;
extern const char* const s_promiseOperationsFulfillPromiseCode;
extern const int s_promiseOperationsFulfillPromiseCodeLength;
extern const JSC::ConstructAbility s_promiseOperationsFulfillPromiseCodeConstructAbility;
extern const JSC::ConstructorKind s_promiseOperationsFulfillPromiseCodeConstructorKind;
extern const JSC::ImplementationVisibility s_promiseOperationsFulfillPromiseCodeImplementationVisibility;
extern const JSC::InlineAttribute s_promiseOperationsFulfillPromiseCodeInlineAttribute;
extern const char* const s_promiseOperationsResolvePromiseWithFirstResolvingFunctionCallCheckCode;
extern const int s_promiseOperationsResolvePromiseWithFirstResolvingFunctionCallCheckCodeLength;
extern const JSC::ConstructAbility s_promiseOperationsResolvePromiseWithFirstResolvingFunctionCallCheckCodeConstructAbility;
extern const JSC::ConstructorKind s_promiseOperationsResolvePromiseWithFirstResolvingFunctionCallCheckCodeConstructorKind;
extern const JSC::ImplementationVisibility s_promiseOperationsResolvePromiseWithFirstResolvingFunctionCallCheckCodeImplementationVisibility;
extern const JSC::InlineAttribute s_promiseOperationsResolvePromiseWithFirstResolvingFunctionCallCheckCodeInlineAttribute;
extern const char* const s_promiseOperationsFulfillPromiseWithFirstResolvingFunctionCallCheckCode;
extern const int s_promiseOperationsFulfillPromiseWithFirstResolvingFunctionCallCheckCodeLength;
extern const JSC::ConstructAbility s_promiseOperationsFulfillPromiseWithFirstResolvingFunctionCallCheckCodeConstructAbility;
extern const JSC::ConstructorKind s_promiseOperationsFulfillPromiseWithFirstResolvingFunctionCallCheckCodeConstructorKind;
extern const JSC::ImplementationVisibility s_promiseOperationsFulfillPromiseWithFirstResolvingFunctionCallCheckCodeImplementationVisibility;
extern const JSC::InlineAttribute s_promiseOperationsFulfillPromiseWithFirstResolvingFunctionCallCheckCodeInlineAttribute;
extern const char* const s_promiseOperationsRejectPromiseWithFirstResolvingFunctionCallCheckCode;
extern const int s_promiseOperationsRejectPromiseWithFirstResolvingFunctionCallCheckCodeLength;
extern const JSC::ConstructAbility s_promiseOperationsRejectPromiseWithFirstResolvingFunctionCallCheckCodeConstructAbility;
extern const JSC::ConstructorKind s_promiseOperationsRejectPromiseWithFirstResolvingFunctionCallCheckCodeConstructorKind;
extern const JSC::ImplementationVisibility s_promiseOperationsRejectPromiseWithFirstResolvingFunctionCallCheckCodeImplementationVisibility;
extern const JSC::InlineAttribute s_promiseOperationsRejectPromiseWithFirstResolvingFunctionCallCheckCodeInlineAttribute;
extern const char* const s_promiseOperationsCreateResolvingFunctionsCode;
extern const int s_promiseOperationsCreateResolvingFunctionsCodeLength;
extern const JSC::ConstructAbility s_promiseOperationsCreateResolvingFunctionsCodeConstructAbility;
extern const JSC::ConstructorKind s_promiseOperationsCreateResolvingFunctionsCodeConstructorKind;
extern const JSC::ImplementationVisibility s_promiseOperationsCreateResolvingFunctionsCodeImplementationVisibility;
extern const JSC::InlineAttribute s_promiseOperationsCreateResolvingFunctionsCodeInlineAttribute;
extern const char* const s_promiseOperationsPromiseReactionJobWithoutPromiseCode;
extern const int s_promiseOperationsPromiseReactionJobWithoutPromiseCodeLength;
extern const JSC::ConstructAbility s_promiseOperationsPromiseReactionJobWithoutPromiseCodeConstructAbility;
extern const JSC::ConstructorKind s_promiseOperationsPromiseReactionJobWithoutPromiseCodeConstructorKind;
extern const JSC::ImplementationVisibility s_promiseOperationsPromiseReactionJobWithoutPromiseCodeImplementationVisibility;
extern const JSC::InlineAttribute s_promiseOperationsPromiseReactionJobWithoutPromiseCodeInlineAttribute;
extern const char* const s_promiseOperationsResolveWithoutPromiseCode;
extern const int s_promiseOperationsResolveWithoutPromiseCodeLength;
extern const JSC::ConstructAbility s_promiseOperationsResolveWithoutPromiseCodeConstructAbility;
extern const JSC::ConstructorKind s_promiseOperationsResolveWithoutPromiseCodeConstructorKind;
extern const JSC::ImplementationVisibility s_promiseOperationsResolveWithoutPromiseCodeImplementationVisibility;
extern const JSC::InlineAttribute s_promiseOperationsResolveWithoutPromiseCodeInlineAttribute;
extern const char* const s_promiseOperationsRejectWithoutPromiseCode;
extern const int s_promiseOperationsRejectWithoutPromiseCodeLength;
extern const JSC::ConstructAbility s_promiseOperationsRejectWithoutPromiseCodeConstructAbility;
extern const JSC::ConstructorKind s_promiseOperationsRejectWithoutPromiseCodeConstructorKind;
extern const JSC::ImplementationVisibility s_promiseOperationsRejectWithoutPromiseCodeImplementationVisibility;
extern const JSC::InlineAttribute s_promiseOperationsRejectWithoutPromiseCodeInlineAttribute;
extern const char* const s_promiseOperationsFulfillWithoutPromiseCode;
extern const int s_promiseOperationsFulfillWithoutPromiseCodeLength;
extern const JSC::ConstructAbility s_promiseOperationsFulfillWithoutPromiseCodeConstructAbility;
extern const JSC::ConstructorKind s_promiseOperationsFulfillWithoutPromiseCodeConstructorKind;
extern const JSC::ImplementationVisibility s_promiseOperationsFulfillWithoutPromiseCodeImplementationVisibility;
extern const JSC::InlineAttribute s_promiseOperationsFulfillWithoutPromiseCodeInlineAttribute;
extern const char* const s_promiseOperationsResolveWithoutPromiseForAsyncAwaitCode;
extern const int s_promiseOperationsResolveWithoutPromiseForAsyncAwaitCodeLength;
extern const JSC::ConstructAbility s_promiseOperationsResolveWithoutPromiseForAsyncAwaitCodeConstructAbility;
extern const JSC::ConstructorKind s_promiseOperationsResolveWithoutPromiseForAsyncAwaitCodeConstructorKind;
extern const JSC::ImplementationVisibility s_promiseOperationsResolveWithoutPromiseForAsyncAwaitCodeImplementationVisibility;
extern const JSC::InlineAttribute s_promiseOperationsResolveWithoutPromiseForAsyncAwaitCodeInlineAttribute;
extern const char* const s_promiseOperationsCreateResolvingFunctionsWithoutPromiseCode;
extern const int s_promiseOperationsCreateResolvingFunctionsWithoutPromiseCodeLength;
extern const JSC::ConstructAbility s_promiseOperationsCreateResolvingFunctionsWithoutPromiseCodeConstructAbility;
extern const JSC::ConstructorKind s_promiseOperationsCreateResolvingFunctionsWithoutPromiseCodeConstructorKind;
extern const JSC::ImplementationVisibility s_promiseOperationsCreateResolvingFunctionsWithoutPromiseCodeImplementationVisibility;
extern const JSC::InlineAttribute s_promiseOperationsCreateResolvingFunctionsWithoutPromiseCodeInlineAttribute;
extern const char* const s_promiseOperationsPromiseReactionJobCode;
extern const int s_promiseOperationsPromiseReactionJobCodeLength;
extern const JSC::ConstructAbility s_promiseOperationsPromiseReactionJobCodeConstructAbility;
extern const JSC::ConstructorKind s_promiseOperationsPromiseReactionJobCodeConstructorKind;
extern const JSC::ImplementationVisibility s_promiseOperationsPromiseReactionJobCodeImplementationVisibility;
extern const JSC::InlineAttribute s_promiseOperationsPromiseReactionJobCodeInlineAttribute;
extern const char* const s_promiseOperationsPromiseResolveThenableJobFastCode;
extern const int s_promiseOperationsPromiseResolveThenableJobFastCodeLength;
extern const JSC::ConstructAbility s_promiseOperationsPromiseResolveThenableJobFastCodeConstructAbility;
extern const JSC::ConstructorKind s_promiseOperationsPromiseResolveThenableJobFastCodeConstructorKind;
extern const JSC::ImplementationVisibility s_promiseOperationsPromiseResolveThenableJobFastCodeImplementationVisibility;
extern const JSC::InlineAttribute s_promiseOperationsPromiseResolveThenableJobFastCodeInlineAttribute;
extern const char* const s_promiseOperationsPromiseResolveThenableJobWithoutPromiseFastCode;
extern const int s_promiseOperationsPromiseResolveThenableJobWithoutPromiseFastCodeLength;
extern const JSC::ConstructAbility s_promiseOperationsPromiseResolveThenableJobWithoutPromiseFastCodeConstructAbility;
extern const JSC::ConstructorKind s_promiseOperationsPromiseResolveThenableJobWithoutPromiseFastCodeConstructorKind;
extern const JSC::ImplementationVisibility s_promiseOperationsPromiseResolveThenableJobWithoutPromiseFastCodeImplementationVisibility;
extern const JSC::InlineAttribute s_promiseOperationsPromiseResolveThenableJobWithoutPromiseFastCodeInlineAttribute;
extern const char* const s_promiseOperationsPromiseResolveThenableJobCode;
extern const int s_promiseOperationsPromiseResolveThenableJobCodeLength;
extern const JSC::ConstructAbility s_promiseOperationsPromiseResolveThenableJobCodeConstructAbility;
extern const JSC::ConstructorKind s_promiseOperationsPromiseResolveThenableJobCodeConstructorKind;
extern const JSC::ImplementationVisibility s_promiseOperationsPromiseResolveThenableJobCodeImplementationVisibility;
extern const JSC::InlineAttribute s_promiseOperationsPromiseResolveThenableJobCodeInlineAttribute;
extern const char* const s_promiseOperationsPromiseResolveThenableJobWithDerivedPromiseCode;
extern const int s_promiseOperationsPromiseResolveThenableJobWithDerivedPromiseCodeLength;
extern const JSC::ConstructAbility s_promiseOperationsPromiseResolveThenableJobWithDerivedPromiseCodeConstructAbility;
extern const JSC::ConstructorKind s_promiseOperationsPromiseResolveThenableJobWithDerivedPromiseCodeConstructorKind;
extern const JSC::ImplementationVisibility s_promiseOperationsPromiseResolveThenableJobWithDerivedPromiseCodeImplementationVisibility;
extern const JSC::InlineAttribute s_promiseOperationsPromiseResolveThenableJobWithDerivedPromiseCodeInlineAttribute;
extern const char* const s_promiseOperationsPromiseEmptyOnFulfilledCode;
extern const int s_promiseOperationsPromiseEmptyOnFulfilledCodeLength;
extern const JSC::ConstructAbility s_promiseOperationsPromiseEmptyOnFulfilledCodeConstructAbility;
extern const JSC::ConstructorKind s_promiseOperationsPromiseEmptyOnFulfilledCodeConstructorKind;
extern const JSC::ImplementationVisibility s_promiseOperationsPromiseEmptyOnFulfilledCodeImplementationVisibility;
extern const JSC::InlineAttribute s_promiseOperationsPromiseEmptyOnFulfilledCodeInlineAttribute;
extern const char* const s_promiseOperationsPromiseEmptyOnRejectedCode;
extern const int s_promiseOperationsPromiseEmptyOnRejectedCodeLength;
extern const JSC::ConstructAbility s_promiseOperationsPromiseEmptyOnRejectedCodeConstructAbility;
extern const JSC::ConstructorKind s_promiseOperationsPromiseEmptyOnRejectedCodeConstructorKind;
extern const JSC::ImplementationVisibility s_promiseOperationsPromiseEmptyOnRejectedCodeImplementationVisibility;
extern const JSC::InlineAttribute s_promiseOperationsPromiseEmptyOnRejectedCodeInlineAttribute;
extern const char* const s_promiseOperationsPerformPromiseThenCode;
extern const int s_promiseOperationsPerformPromiseThenCodeLength;
extern const JSC::ConstructAbility s_promiseOperationsPerformPromiseThenCodeConstructAbility;
extern const JSC::ConstructorKind s_promiseOperationsPerformPromiseThenCodeConstructorKind;
extern const JSC::ImplementationVisibility s_promiseOperationsPerformPromiseThenCodeImplementationVisibility;
extern const JSC::InlineAttribute s_promiseOperationsPerformPromiseThenCodeInlineAttribute;

#define JSC_FOREACH_PROMISEOPERATIONS_BUILTIN_DATA(macro) \
    macro(pushNewPromiseReaction, promiseOperationsPushNewPromiseReaction, 6) \
    macro(newPromiseCapabilitySlow, promiseOperationsNewPromiseCapabilitySlow, 1) \
    macro(newPromiseCapability, promiseOperationsNewPromiseCapability, 1) \
    macro(promiseResolve, promiseOperationsPromiseResolve, 2) \
    macro(promiseResolveSlow, promiseOperationsPromiseResolveSlow, 2) \
    macro(promiseRejectSlow, promiseOperationsPromiseRejectSlow, 2) \
    macro(newHandledRejectedPromise, promiseOperationsNewHandledRejectedPromise, 1) \
    macro(triggerPromiseReactions, promiseOperationsTriggerPromiseReactions, 3) \
    macro(resolvePromise, promiseOperationsResolvePromise, 2) \
    macro(rejectPromise, promiseOperationsRejectPromise, 2) \
    macro(fulfillPromise, promiseOperationsFulfillPromise, 2) \
    macro(resolvePromiseWithFirstResolvingFunctionCallCheck, promiseOperationsResolvePromiseWithFirstResolvingFunctionCallCheck, 2) \
    macro(fulfillPromiseWithFirstResolvingFunctionCallCheck, promiseOperationsFulfillPromiseWithFirstResolvingFunctionCallCheck, 2) \
    macro(rejectPromiseWithFirstResolvingFunctionCallCheck, promiseOperationsRejectPromiseWithFirstResolvingFunctionCallCheck, 2) \
    macro(createResolvingFunctions, promiseOperationsCreateResolvingFunctions, 1) \
    macro(promiseReactionJobWithoutPromise, promiseOperationsPromiseReactionJobWithoutPromise, 3) \
    macro(resolveWithoutPromise, promiseOperationsResolveWithoutPromise, 4) \
    macro(rejectWithoutPromise, promiseOperationsRejectWithoutPromise, 4) \
    macro(fulfillWithoutPromise, promiseOperationsFulfillWithoutPromise, 4) \
    macro(resolveWithoutPromiseForAsyncAwait, promiseOperationsResolveWithoutPromiseForAsyncAwait, 4) \
    macro(createResolvingFunctionsWithoutPromise, promiseOperationsCreateResolvingFunctionsWithoutPromise, 3) \
    macro(promiseReactionJob, promiseOperationsPromiseReactionJob, 4) \
    macro(promiseResolveThenableJobFast, promiseOperationsPromiseResolveThenableJobFast, 2) \
    macro(promiseResolveThenableJobWithoutPromiseFast, promiseOperationsPromiseResolveThenableJobWithoutPromiseFast, 4) \
    macro(promiseResolveThenableJob, promiseOperationsPromiseResolveThenableJob, 3) \
    macro(promiseResolveThenableJobWithDerivedPromise, promiseOperationsPromiseResolveThenableJobWithDerivedPromise, 3) \
    macro(promiseEmptyOnFulfilled, promiseOperationsPromiseEmptyOnFulfilled, 1) \
    macro(promiseEmptyOnRejected, promiseOperationsPromiseEmptyOnRejected, 1) \
    macro(performPromiseThen, promiseOperationsPerformPromiseThen, 5) \

/* PromisePrototype */
extern const char* const s_promisePrototypeCatchCode;
extern const int s_promisePrototypeCatchCodeLength;
extern const JSC::ConstructAbility s_promisePrototypeCatchCodeConstructAbility;
extern const JSC::ConstructorKind s_promisePrototypeCatchCodeConstructorKind;
extern const JSC::ImplementationVisibility s_promisePrototypeCatchCodeImplementationVisibility;
extern const JSC::InlineAttribute s_promisePrototypeCatchCodeInlineAttribute;
extern const char* const s_promisePrototypeThenCode;
extern const int s_promisePrototypeThenCodeLength;
extern const JSC::ConstructAbility s_promisePrototypeThenCodeConstructAbility;
extern const JSC::ConstructorKind s_promisePrototypeThenCodeConstructorKind;
extern const JSC::ImplementationVisibility s_promisePrototypeThenCodeImplementationVisibility;
extern const JSC::InlineAttribute s_promisePrototypeThenCodeInlineAttribute;
extern const char* const s_promisePrototypeFinallyCode;
extern const int s_promisePrototypeFinallyCodeLength;
extern const JSC::ConstructAbility s_promisePrototypeFinallyCodeConstructAbility;
extern const JSC::ConstructorKind s_promisePrototypeFinallyCodeConstructorKind;
extern const JSC::ImplementationVisibility s_promisePrototypeFinallyCodeImplementationVisibility;
extern const JSC::InlineAttribute s_promisePrototypeFinallyCodeInlineAttribute;

#define JSC_FOREACH_PROMISEPROTOTYPE_BUILTIN_DATA(macro) \
    macro(catch, promisePrototypeCatch, 1) \
    macro(then, promisePrototypeThen, 2) \
    macro(finally, promisePrototypeFinally, 1) \

/* ProxyHelpers */
extern const char* const s_proxyHelpersPerformProxyObjectHasCode;
extern const int s_proxyHelpersPerformProxyObjectHasCodeLength;
extern const JSC::ConstructAbility s_proxyHelpersPerformProxyObjectHasCodeConstructAbility;
extern const JSC::ConstructorKind s_proxyHelpersPerformProxyObjectHasCodeConstructorKind;
extern const JSC::ImplementationVisibility s_proxyHelpersPerformProxyObjectHasCodeImplementationVisibility;
extern const JSC::InlineAttribute s_proxyHelpersPerformProxyObjectHasCodeInlineAttribute;
extern const char* const s_proxyHelpersPerformProxyObjectHasByValCode;
extern const int s_proxyHelpersPerformProxyObjectHasByValCodeLength;
extern const JSC::ConstructAbility s_proxyHelpersPerformProxyObjectHasByValCodeConstructAbility;
extern const JSC::ConstructorKind s_proxyHelpersPerformProxyObjectHasByValCodeConstructorKind;
extern const JSC::ImplementationVisibility s_proxyHelpersPerformProxyObjectHasByValCodeImplementationVisibility;
extern const JSC::InlineAttribute s_proxyHelpersPerformProxyObjectHasByValCodeInlineAttribute;
extern const char* const s_proxyHelpersPerformProxyObjectGetCode;
extern const int s_proxyHelpersPerformProxyObjectGetCodeLength;
extern const JSC::ConstructAbility s_proxyHelpersPerformProxyObjectGetCodeConstructAbility;
extern const JSC::ConstructorKind s_proxyHelpersPerformProxyObjectGetCodeConstructorKind;
extern const JSC::ImplementationVisibility s_proxyHelpersPerformProxyObjectGetCodeImplementationVisibility;
extern const JSC::InlineAttribute s_proxyHelpersPerformProxyObjectGetCodeInlineAttribute;
extern const char* const s_proxyHelpersPerformProxyObjectGetByValCode;
extern const int s_proxyHelpersPerformProxyObjectGetByValCodeLength;
extern const JSC::ConstructAbility s_proxyHelpersPerformProxyObjectGetByValCodeConstructAbility;
extern const JSC::ConstructorKind s_proxyHelpersPerformProxyObjectGetByValCodeConstructorKind;
extern const JSC::ImplementationVisibility s_proxyHelpersPerformProxyObjectGetByValCodeImplementationVisibility;
extern const JSC::InlineAttribute s_proxyHelpersPerformProxyObjectGetByValCodeInlineAttribute;
extern const char* const s_proxyHelpersPerformProxyObjectSetSloppyCode;
extern const int s_proxyHelpersPerformProxyObjectSetSloppyCodeLength;
extern const JSC::ConstructAbility s_proxyHelpersPerformProxyObjectSetSloppyCodeConstructAbility;
extern const JSC::ConstructorKind s_proxyHelpersPerformProxyObjectSetSloppyCodeConstructorKind;
extern const JSC::ImplementationVisibility s_proxyHelpersPerformProxyObjectSetSloppyCodeImplementationVisibility;
extern const JSC::InlineAttribute s_proxyHelpersPerformProxyObjectSetSloppyCodeInlineAttribute;
extern const char* const s_proxyHelpersPerformProxyObjectSetStrictCode;
extern const int s_proxyHelpersPerformProxyObjectSetStrictCodeLength;
extern const JSC::ConstructAbility s_proxyHelpersPerformProxyObjectSetStrictCodeConstructAbility;
extern const JSC::ConstructorKind s_proxyHelpersPerformProxyObjectSetStrictCodeConstructorKind;
extern const JSC::ImplementationVisibility s_proxyHelpersPerformProxyObjectSetStrictCodeImplementationVisibility;
extern const JSC::InlineAttribute s_proxyHelpersPerformProxyObjectSetStrictCodeInlineAttribute;
extern const char* const s_proxyHelpersPerformProxyObjectSetByValSloppyCode;
extern const int s_proxyHelpersPerformProxyObjectSetByValSloppyCodeLength;
extern const JSC::ConstructAbility s_proxyHelpersPerformProxyObjectSetByValSloppyCodeConstructAbility;
extern const JSC::ConstructorKind s_proxyHelpersPerformProxyObjectSetByValSloppyCodeConstructorKind;
extern const JSC::ImplementationVisibility s_proxyHelpersPerformProxyObjectSetByValSloppyCodeImplementationVisibility;
extern const JSC::InlineAttribute s_proxyHelpersPerformProxyObjectSetByValSloppyCodeInlineAttribute;
extern const char* const s_proxyHelpersPerformProxyObjectSetByValStrictCode;
extern const int s_proxyHelpersPerformProxyObjectSetByValStrictCodeLength;
extern const JSC::ConstructAbility s_proxyHelpersPerformProxyObjectSetByValStrictCodeConstructAbility;
extern const JSC::ConstructorKind s_proxyHelpersPerformProxyObjectSetByValStrictCodeConstructorKind;
extern const JSC::ImplementationVisibility s_proxyHelpersPerformProxyObjectSetByValStrictCodeImplementationVisibility;
extern const JSC::InlineAttribute s_proxyHelpersPerformProxyObjectSetByValStrictCodeInlineAttribute;

#define JSC_FOREACH_PROXYHELPERS_BUILTIN_DATA(macro) \
    macro(performProxyObjectHas, proxyHelpersPerformProxyObjectHas, 1) \
    macro(performProxyObjectHasByVal, proxyHelpersPerformProxyObjectHasByVal, 1) \
    macro(performProxyObjectGet, proxyHelpersPerformProxyObjectGet, 2) \
    macro(performProxyObjectGetByVal, proxyHelpersPerformProxyObjectGetByVal, 2) \
    macro(performProxyObjectSetSloppy, proxyHelpersPerformProxyObjectSetSloppy, 3) \
    macro(performProxyObjectSetStrict, proxyHelpersPerformProxyObjectSetStrict, 3) \
    macro(performProxyObjectSetByValSloppy, proxyHelpersPerformProxyObjectSetByValSloppy, 3) \
    macro(performProxyObjectSetByValStrict, proxyHelpersPerformProxyObjectSetByValStrict, 3) \

/* ReflectObject */
extern const char* const s_reflectObjectApplyCode;
extern const int s_reflectObjectApplyCodeLength;
extern const JSC::ConstructAbility s_reflectObjectApplyCodeConstructAbility;
extern const JSC::ConstructorKind s_reflectObjectApplyCodeConstructorKind;
extern const JSC::ImplementationVisibility s_reflectObjectApplyCodeImplementationVisibility;
extern const JSC::InlineAttribute s_reflectObjectApplyCodeInlineAttribute;
extern const char* const s_reflectObjectDeletePropertyCode;
extern const int s_reflectObjectDeletePropertyCodeLength;
extern const JSC::ConstructAbility s_reflectObjectDeletePropertyCodeConstructAbility;
extern const JSC::ConstructorKind s_reflectObjectDeletePropertyCodeConstructorKind;
extern const JSC::ImplementationVisibility s_reflectObjectDeletePropertyCodeImplementationVisibility;
extern const JSC::InlineAttribute s_reflectObjectDeletePropertyCodeInlineAttribute;
extern const char* const s_reflectObjectGetCode;
extern const int s_reflectObjectGetCodeLength;
extern const JSC::ConstructAbility s_reflectObjectGetCodeConstructAbility;
extern const JSC::ConstructorKind s_reflectObjectGetCodeConstructorKind;
extern const JSC::ImplementationVisibility s_reflectObjectGetCodeImplementationVisibility;
extern const JSC::InlineAttribute s_reflectObjectGetCodeInlineAttribute;
extern const char* const s_reflectObjectHasCode;
extern const int s_reflectObjectHasCodeLength;
extern const JSC::ConstructAbility s_reflectObjectHasCodeConstructAbility;
extern const JSC::ConstructorKind s_reflectObjectHasCodeConstructorKind;
extern const JSC::ImplementationVisibility s_reflectObjectHasCodeImplementationVisibility;
extern const JSC::InlineAttribute s_reflectObjectHasCodeInlineAttribute;

#define JSC_FOREACH_REFLECTOBJECT_BUILTIN_DATA(macro) \
    macro(apply, reflectObjectApply, 3) \
    macro(deleteProperty, reflectObjectDeleteProperty, 2) \
    macro(get, reflectObjectGet, 2) \
    macro(has, reflectObjectHas, 2) \

/* RegExpPrototype */
extern const char* const s_regExpPrototypeAdvanceStringIndexCode;
extern const int s_regExpPrototypeAdvanceStringIndexCodeLength;
extern const JSC::ConstructAbility s_regExpPrototypeAdvanceStringIndexCodeConstructAbility;
extern const JSC::ConstructorKind s_regExpPrototypeAdvanceStringIndexCodeConstructorKind;
extern const JSC::ImplementationVisibility s_regExpPrototypeAdvanceStringIndexCodeImplementationVisibility;
extern const JSC::InlineAttribute s_regExpPrototypeAdvanceStringIndexCodeInlineAttribute;
extern const char* const s_regExpPrototypeRegExpExecCode;
extern const int s_regExpPrototypeRegExpExecCodeLength;
extern const JSC::ConstructAbility s_regExpPrototypeRegExpExecCodeConstructAbility;
extern const JSC::ConstructorKind s_regExpPrototypeRegExpExecCodeConstructorKind;
extern const JSC::ImplementationVisibility s_regExpPrototypeRegExpExecCodeImplementationVisibility;
extern const JSC::InlineAttribute s_regExpPrototypeRegExpExecCodeInlineAttribute;
extern const char* const s_regExpPrototypeHasObservableSideEffectsForRegExpMatchCode;
extern const int s_regExpPrototypeHasObservableSideEffectsForRegExpMatchCodeLength;
extern const JSC::ConstructAbility s_regExpPrototypeHasObservableSideEffectsForRegExpMatchCodeConstructAbility;
extern const JSC::ConstructorKind s_regExpPrototypeHasObservableSideEffectsForRegExpMatchCodeConstructorKind;
extern const JSC::ImplementationVisibility s_regExpPrototypeHasObservableSideEffectsForRegExpMatchCodeImplementationVisibility;
extern const JSC::InlineAttribute s_regExpPrototypeHasObservableSideEffectsForRegExpMatchCodeInlineAttribute;
extern const char* const s_regExpPrototypeMatchSlowCode;
extern const int s_regExpPrototypeMatchSlowCodeLength;
extern const JSC::ConstructAbility s_regExpPrototypeMatchSlowCodeConstructAbility;
extern const JSC::ConstructorKind s_regExpPrototypeMatchSlowCodeConstructorKind;
extern const JSC::ImplementationVisibility s_regExpPrototypeMatchSlowCodeImplementationVisibility;
extern const JSC::InlineAttribute s_regExpPrototypeMatchSlowCodeInlineAttribute;
extern const char* const s_regExpPrototypeMatchCode;
extern const int s_regExpPrototypeMatchCodeLength;
extern const JSC::ConstructAbility s_regExpPrototypeMatchCodeConstructAbility;
extern const JSC::ConstructorKind s_regExpPrototypeMatchCodeConstructorKind;
extern const JSC::ImplementationVisibility s_regExpPrototypeMatchCodeImplementationVisibility;
extern const JSC::InlineAttribute s_regExpPrototypeMatchCodeInlineAttribute;
extern const char* const s_regExpPrototypeMatchAllCode;
extern const int s_regExpPrototypeMatchAllCodeLength;
extern const JSC::ConstructAbility s_regExpPrototypeMatchAllCodeConstructAbility;
extern const JSC::ConstructorKind s_regExpPrototypeMatchAllCodeConstructorKind;
extern const JSC::ImplementationVisibility s_regExpPrototypeMatchAllCodeImplementationVisibility;
extern const JSC::InlineAttribute s_regExpPrototypeMatchAllCodeInlineAttribute;
extern const char* const s_regExpPrototypeGetSubstitutionCode;
extern const int s_regExpPrototypeGetSubstitutionCodeLength;
extern const JSC::ConstructAbility s_regExpPrototypeGetSubstitutionCodeConstructAbility;
extern const JSC::ConstructorKind s_regExpPrototypeGetSubstitutionCodeConstructorKind;
extern const JSC::ImplementationVisibility s_regExpPrototypeGetSubstitutionCodeImplementationVisibility;
extern const JSC::InlineAttribute s_regExpPrototypeGetSubstitutionCodeInlineAttribute;
extern const char* const s_regExpPrototypeReplaceCode;
extern const int s_regExpPrototypeReplaceCodeLength;
extern const JSC::ConstructAbility s_regExpPrototypeReplaceCodeConstructAbility;
extern const JSC::ConstructorKind s_regExpPrototypeReplaceCodeConstructorKind;
extern const JSC::ImplementationVisibility s_regExpPrototypeReplaceCodeImplementationVisibility;
extern const JSC::InlineAttribute s_regExpPrototypeReplaceCodeInlineAttribute;
extern const char* const s_regExpPrototypeSearchCode;
extern const int s_regExpPrototypeSearchCodeLength;
extern const JSC::ConstructAbility s_regExpPrototypeSearchCodeConstructAbility;
extern const JSC::ConstructorKind s_regExpPrototypeSearchCodeConstructorKind;
extern const JSC::ImplementationVisibility s_regExpPrototypeSearchCodeImplementationVisibility;
extern const JSC::InlineAttribute s_regExpPrototypeSearchCodeInlineAttribute;
extern const char* const s_regExpPrototypeHasObservableSideEffectsForRegExpSplitCode;
extern const int s_regExpPrototypeHasObservableSideEffectsForRegExpSplitCodeLength;
extern const JSC::ConstructAbility s_regExpPrototypeHasObservableSideEffectsForRegExpSplitCodeConstructAbility;
extern const JSC::ConstructorKind s_regExpPrototypeHasObservableSideEffectsForRegExpSplitCodeConstructorKind;
extern const JSC::ImplementationVisibility s_regExpPrototypeHasObservableSideEffectsForRegExpSplitCodeImplementationVisibility;
extern const JSC::InlineAttribute s_regExpPrototypeHasObservableSideEffectsForRegExpSplitCodeInlineAttribute;
extern const char* const s_regExpPrototypeSplitCode;
extern const int s_regExpPrototypeSplitCodeLength;
extern const JSC::ConstructAbility s_regExpPrototypeSplitCodeConstructAbility;
extern const JSC::ConstructorKind s_regExpPrototypeSplitCodeConstructorKind;
extern const JSC::ImplementationVisibility s_regExpPrototypeSplitCodeImplementationVisibility;
extern const JSC::InlineAttribute s_regExpPrototypeSplitCodeInlineAttribute;
extern const char* const s_regExpPrototypeTestCode;
extern const int s_regExpPrototypeTestCodeLength;
extern const JSC::ConstructAbility s_regExpPrototypeTestCodeConstructAbility;
extern const JSC::ConstructorKind s_regExpPrototypeTestCodeConstructorKind;
extern const JSC::ImplementationVisibility s_regExpPrototypeTestCodeImplementationVisibility;
extern const JSC::InlineAttribute s_regExpPrototypeTestCodeInlineAttribute;

#define JSC_FOREACH_REGEXPPROTOTYPE_BUILTIN_DATA(macro) \
    macro(advanceStringIndex, regExpPrototypeAdvanceStringIndex, 3) \
    macro(regExpExec, regExpPrototypeRegExpExec, 2) \
    macro(hasObservableSideEffectsForRegExpMatch, regExpPrototypeHasObservableSideEffectsForRegExpMatch, 1) \
    macro(matchSlow, regExpPrototypeMatchSlow, 2) \
    macro(match, regExpPrototypeMatch, 1) \
    macro(matchAll, regExpPrototypeMatchAll, 1) \
    macro(getSubstitution, regExpPrototypeGetSubstitution, 6) \
    macro(replace, regExpPrototypeReplace, 2) \
    macro(search, regExpPrototypeSearch, 1) \
    macro(hasObservableSideEffectsForRegExpSplit, regExpPrototypeHasObservableSideEffectsForRegExpSplit, 1) \
    macro(split, regExpPrototypeSplit, 2) \
    macro(test, regExpPrototypeTest, 1) \

/* RegExpStringIteratorPrototype */
extern const char* const s_regExpStringIteratorPrototypeNextCode;
extern const int s_regExpStringIteratorPrototypeNextCodeLength;
extern const JSC::ConstructAbility s_regExpStringIteratorPrototypeNextCodeConstructAbility;
extern const JSC::ConstructorKind s_regExpStringIteratorPrototypeNextCodeConstructorKind;
extern const JSC::ImplementationVisibility s_regExpStringIteratorPrototypeNextCodeImplementationVisibility;
extern const JSC::InlineAttribute s_regExpStringIteratorPrototypeNextCodeInlineAttribute;

#define JSC_FOREACH_REGEXPSTRINGITERATORPROTOTYPE_BUILTIN_DATA(macro) \
    macro(next, regExpStringIteratorPrototypeNext, 0) \

/* SetIteratorPrototype */
extern const char* const s_setIteratorPrototypeNextCode;
extern const int s_setIteratorPrototypeNextCodeLength;
extern const JSC::ConstructAbility s_setIteratorPrototypeNextCodeConstructAbility;
extern const JSC::ConstructorKind s_setIteratorPrototypeNextCodeConstructorKind;
extern const JSC::ImplementationVisibility s_setIteratorPrototypeNextCodeImplementationVisibility;
extern const JSC::InlineAttribute s_setIteratorPrototypeNextCodeInlineAttribute;

#define JSC_FOREACH_SETITERATORPROTOTYPE_BUILTIN_DATA(macro) \
    macro(next, setIteratorPrototypeNext, 0) \

/* SetPrototype */
extern const char* const s_setPrototypeForEachCode;
extern const int s_setPrototypeForEachCodeLength;
extern const JSC::ConstructAbility s_setPrototypeForEachCodeConstructAbility;
extern const JSC::ConstructorKind s_setPrototypeForEachCodeConstructorKind;
extern const JSC::ImplementationVisibility s_setPrototypeForEachCodeImplementationVisibility;
extern const JSC::InlineAttribute s_setPrototypeForEachCodeInlineAttribute;
extern const char* const s_setPrototypeGetSetSizeAsIntCode;
extern const int s_setPrototypeGetSetSizeAsIntCodeLength;
extern const JSC::ConstructAbility s_setPrototypeGetSetSizeAsIntCodeConstructAbility;
extern const JSC::ConstructorKind s_setPrototypeGetSetSizeAsIntCodeConstructorKind;
extern const JSC::ImplementationVisibility s_setPrototypeGetSetSizeAsIntCodeImplementationVisibility;
extern const JSC::InlineAttribute s_setPrototypeGetSetSizeAsIntCodeInlineAttribute;
extern const char* const s_setPrototypeUnionCode;
extern const int s_setPrototypeUnionCodeLength;
extern const JSC::ConstructAbility s_setPrototypeUnionCodeConstructAbility;
extern const JSC::ConstructorKind s_setPrototypeUnionCodeConstructorKind;
extern const JSC::ImplementationVisibility s_setPrototypeUnionCodeImplementationVisibility;
extern const JSC::InlineAttribute s_setPrototypeUnionCodeInlineAttribute;
extern const char* const s_setPrototypeIntersectionCode;
extern const int s_setPrototypeIntersectionCodeLength;
extern const JSC::ConstructAbility s_setPrototypeIntersectionCodeConstructAbility;
extern const JSC::ConstructorKind s_setPrototypeIntersectionCodeConstructorKind;
extern const JSC::ImplementationVisibility s_setPrototypeIntersectionCodeImplementationVisibility;
extern const JSC::InlineAttribute s_setPrototypeIntersectionCodeInlineAttribute;
extern const char* const s_setPrototypeDifferenceCode;
extern const int s_setPrototypeDifferenceCodeLength;
extern const JSC::ConstructAbility s_setPrototypeDifferenceCodeConstructAbility;
extern const JSC::ConstructorKind s_setPrototypeDifferenceCodeConstructorKind;
extern const JSC::ImplementationVisibility s_setPrototypeDifferenceCodeImplementationVisibility;
extern const JSC::InlineAttribute s_setPrototypeDifferenceCodeInlineAttribute;
extern const char* const s_setPrototypeSymmetricDifferenceCode;
extern const int s_setPrototypeSymmetricDifferenceCodeLength;
extern const JSC::ConstructAbility s_setPrototypeSymmetricDifferenceCodeConstructAbility;
extern const JSC::ConstructorKind s_setPrototypeSymmetricDifferenceCodeConstructorKind;
extern const JSC::ImplementationVisibility s_setPrototypeSymmetricDifferenceCodeImplementationVisibility;
extern const JSC::InlineAttribute s_setPrototypeSymmetricDifferenceCodeInlineAttribute;
extern const char* const s_setPrototypeIsSubsetOfCode;
extern const int s_setPrototypeIsSubsetOfCodeLength;
extern const JSC::ConstructAbility s_setPrototypeIsSubsetOfCodeConstructAbility;
extern const JSC::ConstructorKind s_setPrototypeIsSubsetOfCodeConstructorKind;
extern const JSC::ImplementationVisibility s_setPrototypeIsSubsetOfCodeImplementationVisibility;
extern const JSC::InlineAttribute s_setPrototypeIsSubsetOfCodeInlineAttribute;
extern const char* const s_setPrototypeIsSupersetOfCode;
extern const int s_setPrototypeIsSupersetOfCodeLength;
extern const JSC::ConstructAbility s_setPrototypeIsSupersetOfCodeConstructAbility;
extern const JSC::ConstructorKind s_setPrototypeIsSupersetOfCodeConstructorKind;
extern const JSC::ImplementationVisibility s_setPrototypeIsSupersetOfCodeImplementationVisibility;
extern const JSC::InlineAttribute s_setPrototypeIsSupersetOfCodeInlineAttribute;
extern const char* const s_setPrototypeIsDisjointFromCode;
extern const int s_setPrototypeIsDisjointFromCodeLength;
extern const JSC::ConstructAbility s_setPrototypeIsDisjointFromCodeConstructAbility;
extern const JSC::ConstructorKind s_setPrototypeIsDisjointFromCodeConstructorKind;
extern const JSC::ImplementationVisibility s_setPrototypeIsDisjointFromCodeImplementationVisibility;
extern const JSC::InlineAttribute s_setPrototypeIsDisjointFromCodeInlineAttribute;

#define JSC_FOREACH_SETPROTOTYPE_BUILTIN_DATA(macro) \
    macro(forEach, setPrototypeForEach, 1) \
    macro(getSetSizeAsInt, setPrototypeGetSetSizeAsInt, 1) \
    macro(union, setPrototypeUnion, 1) \
    macro(intersection, setPrototypeIntersection, 1) \
    macro(difference, setPrototypeDifference, 1) \
    macro(symmetricDifference, setPrototypeSymmetricDifference, 1) \
    macro(isSubsetOf, setPrototypeIsSubsetOf, 1) \
    macro(isSupersetOf, setPrototypeIsSupersetOf, 1) \
    macro(isDisjointFrom, setPrototypeIsDisjointFrom, 1) \

/* ShadowRealmPrototype */
extern const char* const s_shadowRealmPrototypeWrapRemoteValueCode;
extern const int s_shadowRealmPrototypeWrapRemoteValueCodeLength;
extern const JSC::ConstructAbility s_shadowRealmPrototypeWrapRemoteValueCodeConstructAbility;
extern const JSC::ConstructorKind s_shadowRealmPrototypeWrapRemoteValueCodeConstructorKind;
extern const JSC::ImplementationVisibility s_shadowRealmPrototypeWrapRemoteValueCodeImplementationVisibility;
extern const JSC::InlineAttribute s_shadowRealmPrototypeWrapRemoteValueCodeInlineAttribute;
extern const char* const s_shadowRealmPrototypeEvaluateCode;
extern const int s_shadowRealmPrototypeEvaluateCodeLength;
extern const JSC::ConstructAbility s_shadowRealmPrototypeEvaluateCodeConstructAbility;
extern const JSC::ConstructorKind s_shadowRealmPrototypeEvaluateCodeConstructorKind;
extern const JSC::ImplementationVisibility s_shadowRealmPrototypeEvaluateCodeImplementationVisibility;
extern const JSC::InlineAttribute s_shadowRealmPrototypeEvaluateCodeInlineAttribute;
extern const char* const s_shadowRealmPrototypeCrossRealmThrowCode;
extern const int s_shadowRealmPrototypeCrossRealmThrowCodeLength;
extern const JSC::ConstructAbility s_shadowRealmPrototypeCrossRealmThrowCodeConstructAbility;
extern const JSC::ConstructorKind s_shadowRealmPrototypeCrossRealmThrowCodeConstructorKind;
extern const JSC::ImplementationVisibility s_shadowRealmPrototypeCrossRealmThrowCodeImplementationVisibility;
extern const JSC::InlineAttribute s_shadowRealmPrototypeCrossRealmThrowCodeInlineAttribute;
extern const char* const s_shadowRealmPrototypeImportValueCode;
extern const int s_shadowRealmPrototypeImportValueCodeLength;
extern const JSC::ConstructAbility s_shadowRealmPrototypeImportValueCodeConstructAbility;
extern const JSC::ConstructorKind s_shadowRealmPrototypeImportValueCodeConstructorKind;
extern const JSC::ImplementationVisibility s_shadowRealmPrototypeImportValueCodeImplementationVisibility;
extern const JSC::InlineAttribute s_shadowRealmPrototypeImportValueCodeInlineAttribute;

#define JSC_FOREACH_SHADOWREALMPROTOTYPE_BUILTIN_DATA(macro) \
    macro(wrapRemoteValue, shadowRealmPrototypeWrapRemoteValue, 3) \
    macro(evaluate, shadowRealmPrototypeEvaluate, 1) \
    macro(crossRealmThrow, shadowRealmPrototypeCrossRealmThrow, 1) \
    macro(importValue, shadowRealmPrototypeImportValue, 2) \

/* StringConstructor */
extern const char* const s_stringConstructorRawCode;
extern const int s_stringConstructorRawCodeLength;
extern const JSC::ConstructAbility s_stringConstructorRawCodeConstructAbility;
extern const JSC::ConstructorKind s_stringConstructorRawCodeConstructorKind;
extern const JSC::ImplementationVisibility s_stringConstructorRawCodeImplementationVisibility;
extern const JSC::InlineAttribute s_stringConstructorRawCodeInlineAttribute;

#define JSC_FOREACH_STRINGCONSTRUCTOR_BUILTIN_DATA(macro) \
    macro(raw, stringConstructorRaw, 1) \

/* StringIteratorPrototype */
extern const char* const s_stringIteratorPrototypeNextCode;
extern const int s_stringIteratorPrototypeNextCodeLength;
extern const JSC::ConstructAbility s_stringIteratorPrototypeNextCodeConstructAbility;
extern const JSC::ConstructorKind s_stringIteratorPrototypeNextCodeConstructorKind;
extern const JSC::ImplementationVisibility s_stringIteratorPrototypeNextCodeImplementationVisibility;
extern const JSC::InlineAttribute s_stringIteratorPrototypeNextCodeInlineAttribute;

#define JSC_FOREACH_STRINGITERATORPROTOTYPE_BUILTIN_DATA(macro) \
    macro(next, stringIteratorPrototypeNext, 0) \

/* StringPrototype */
extern const char* const s_stringPrototypeMatchCode;
extern const int s_stringPrototypeMatchCodeLength;
extern const JSC::ConstructAbility s_stringPrototypeMatchCodeConstructAbility;
extern const JSC::ConstructorKind s_stringPrototypeMatchCodeConstructorKind;
extern const JSC::ImplementationVisibility s_stringPrototypeMatchCodeImplementationVisibility;
extern const JSC::InlineAttribute s_stringPrototypeMatchCodeInlineAttribute;
extern const char* const s_stringPrototypeMatchAllCode;
extern const int s_stringPrototypeMatchAllCodeLength;
extern const JSC::ConstructAbility s_stringPrototypeMatchAllCodeConstructAbility;
extern const JSC::ConstructorKind s_stringPrototypeMatchAllCodeConstructorKind;
extern const JSC::ImplementationVisibility s_stringPrototypeMatchAllCodeImplementationVisibility;
extern const JSC::InlineAttribute s_stringPrototypeMatchAllCodeInlineAttribute;
extern const char* const s_stringPrototypeRepeatSlowPathCode;
extern const int s_stringPrototypeRepeatSlowPathCodeLength;
extern const JSC::ConstructAbility s_stringPrototypeRepeatSlowPathCodeConstructAbility;
extern const JSC::ConstructorKind s_stringPrototypeRepeatSlowPathCodeConstructorKind;
extern const JSC::ImplementationVisibility s_stringPrototypeRepeatSlowPathCodeImplementationVisibility;
extern const JSC::InlineAttribute s_stringPrototypeRepeatSlowPathCodeInlineAttribute;
extern const char* const s_stringPrototypeRepeatCharactersSlowPathCode;
extern const int s_stringPrototypeRepeatCharactersSlowPathCodeLength;
extern const JSC::ConstructAbility s_stringPrototypeRepeatCharactersSlowPathCodeConstructAbility;
extern const JSC::ConstructorKind s_stringPrototypeRepeatCharactersSlowPathCodeConstructorKind;
extern const JSC::ImplementationVisibility s_stringPrototypeRepeatCharactersSlowPathCodeImplementationVisibility;
extern const JSC::InlineAttribute s_stringPrototypeRepeatCharactersSlowPathCodeInlineAttribute;
extern const char* const s_stringPrototypeRepeatCode;
extern const int s_stringPrototypeRepeatCodeLength;
extern const JSC::ConstructAbility s_stringPrototypeRepeatCodeConstructAbility;
extern const JSC::ConstructorKind s_stringPrototypeRepeatCodeConstructorKind;
extern const JSC::ImplementationVisibility s_stringPrototypeRepeatCodeImplementationVisibility;
extern const JSC::InlineAttribute s_stringPrototypeRepeatCodeInlineAttribute;
extern const char* const s_stringPrototypePadStartCode;
extern const int s_stringPrototypePadStartCodeLength;
extern const JSC::ConstructAbility s_stringPrototypePadStartCodeConstructAbility;
extern const JSC::ConstructorKind s_stringPrototypePadStartCodeConstructorKind;
extern const JSC::ImplementationVisibility s_stringPrototypePadStartCodeImplementationVisibility;
extern const JSC::InlineAttribute s_stringPrototypePadStartCodeInlineAttribute;
extern const char* const s_stringPrototypePadEndCode;
extern const int s_stringPrototypePadEndCodeLength;
extern const JSC::ConstructAbility s_stringPrototypePadEndCodeConstructAbility;
extern const JSC::ConstructorKind s_stringPrototypePadEndCodeConstructorKind;
extern const JSC::ImplementationVisibility s_stringPrototypePadEndCodeImplementationVisibility;
extern const JSC::InlineAttribute s_stringPrototypePadEndCodeInlineAttribute;
extern const char* const s_stringPrototypeHasObservableSideEffectsForStringReplaceCode;
extern const int s_stringPrototypeHasObservableSideEffectsForStringReplaceCodeLength;
extern const JSC::ConstructAbility s_stringPrototypeHasObservableSideEffectsForStringReplaceCodeConstructAbility;
extern const JSC::ConstructorKind s_stringPrototypeHasObservableSideEffectsForStringReplaceCodeConstructorKind;
extern const JSC::ImplementationVisibility s_stringPrototypeHasObservableSideEffectsForStringReplaceCodeImplementationVisibility;
extern const JSC::InlineAttribute s_stringPrototypeHasObservableSideEffectsForStringReplaceCodeInlineAttribute;
extern const char* const s_stringPrototypeReplaceCode;
extern const int s_stringPrototypeReplaceCodeLength;
extern const JSC::ConstructAbility s_stringPrototypeReplaceCodeConstructAbility;
extern const JSC::ConstructorKind s_stringPrototypeReplaceCodeConstructorKind;
extern const JSC::ImplementationVisibility s_stringPrototypeReplaceCodeImplementationVisibility;
extern const JSC::InlineAttribute s_stringPrototypeReplaceCodeInlineAttribute;
extern const char* const s_stringPrototypeReplaceAllCode;
extern const int s_stringPrototypeReplaceAllCodeLength;
extern const JSC::ConstructAbility s_stringPrototypeReplaceAllCodeConstructAbility;
extern const JSC::ConstructorKind s_stringPrototypeReplaceAllCodeConstructorKind;
extern const JSC::ImplementationVisibility s_stringPrototypeReplaceAllCodeImplementationVisibility;
extern const JSC::InlineAttribute s_stringPrototypeReplaceAllCodeInlineAttribute;
extern const char* const s_stringPrototypeSearchCode;
extern const int s_stringPrototypeSearchCodeLength;
extern const JSC::ConstructAbility s_stringPrototypeSearchCodeConstructAbility;
extern const JSC::ConstructorKind s_stringPrototypeSearchCodeConstructorKind;
extern const JSC::ImplementationVisibility s_stringPrototypeSearchCodeImplementationVisibility;
extern const JSC::InlineAttribute s_stringPrototypeSearchCodeInlineAttribute;
extern const char* const s_stringPrototypeSplitCode;
extern const int s_stringPrototypeSplitCodeLength;
extern const JSC::ConstructAbility s_stringPrototypeSplitCodeConstructAbility;
extern const JSC::ConstructorKind s_stringPrototypeSplitCodeConstructorKind;
extern const JSC::ImplementationVisibility s_stringPrototypeSplitCodeImplementationVisibility;
extern const JSC::InlineAttribute s_stringPrototypeSplitCodeInlineAttribute;
extern const char* const s_stringPrototypeStringConcatSlowPathCode;
extern const int s_stringPrototypeStringConcatSlowPathCodeLength;
extern const JSC::ConstructAbility s_stringPrototypeStringConcatSlowPathCodeConstructAbility;
extern const JSC::ConstructorKind s_stringPrototypeStringConcatSlowPathCodeConstructorKind;
extern const JSC::ImplementationVisibility s_stringPrototypeStringConcatSlowPathCodeImplementationVisibility;
extern const JSC::InlineAttribute s_stringPrototypeStringConcatSlowPathCodeInlineAttribute;
extern const char* const s_stringPrototypeConcatCode;
extern const int s_stringPrototypeConcatCodeLength;
extern const JSC::ConstructAbility s_stringPrototypeConcatCodeConstructAbility;
extern const JSC::ConstructorKind s_stringPrototypeConcatCodeConstructorKind;
extern const JSC::ImplementationVisibility s_stringPrototypeConcatCodeImplementationVisibility;
extern const JSC::InlineAttribute s_stringPrototypeConcatCodeInlineAttribute;
extern const char* const s_stringPrototypeCreateHTMLCode;
extern const int s_stringPrototypeCreateHTMLCodeLength;
extern const JSC::ConstructAbility s_stringPrototypeCreateHTMLCodeConstructAbility;
extern const JSC::ConstructorKind s_stringPrototypeCreateHTMLCodeConstructorKind;
extern const JSC::ImplementationVisibility s_stringPrototypeCreateHTMLCodeImplementationVisibility;
extern const JSC::InlineAttribute s_stringPrototypeCreateHTMLCodeInlineAttribute;
extern const char* const s_stringPrototypeAnchorCode;
extern const int s_stringPrototypeAnchorCodeLength;
extern const JSC::ConstructAbility s_stringPrototypeAnchorCodeConstructAbility;
extern const JSC::ConstructorKind s_stringPrototypeAnchorCodeConstructorKind;
extern const JSC::ImplementationVisibility s_stringPrototypeAnchorCodeImplementationVisibility;
extern const JSC::InlineAttribute s_stringPrototypeAnchorCodeInlineAttribute;
extern const char* const s_stringPrototypeBigCode;
extern const int s_stringPrototypeBigCodeLength;
extern const JSC::ConstructAbility s_stringPrototypeBigCodeConstructAbility;
extern const JSC::ConstructorKind s_stringPrototypeBigCodeConstructorKind;
extern const JSC::ImplementationVisibility s_stringPrototypeBigCodeImplementationVisibility;
extern const JSC::InlineAttribute s_stringPrototypeBigCodeInlineAttribute;
extern const char* const s_stringPrototypeBlinkCode;
extern const int s_stringPrototypeBlinkCodeLength;
extern const JSC::ConstructAbility s_stringPrototypeBlinkCodeConstructAbility;
extern const JSC::ConstructorKind s_stringPrototypeBlinkCodeConstructorKind;
extern const JSC::ImplementationVisibility s_stringPrototypeBlinkCodeImplementationVisibility;
extern const JSC::InlineAttribute s_stringPrototypeBlinkCodeInlineAttribute;
extern const char* const s_stringPrototypeBoldCode;
extern const int s_stringPrototypeBoldCodeLength;
extern const JSC::ConstructAbility s_stringPrototypeBoldCodeConstructAbility;
extern const JSC::ConstructorKind s_stringPrototypeBoldCodeConstructorKind;
extern const JSC::ImplementationVisibility s_stringPrototypeBoldCodeImplementationVisibility;
extern const JSC::InlineAttribute s_stringPrototypeBoldCodeInlineAttribute;
extern const char* const s_stringPrototypeFixedCode;
extern const int s_stringPrototypeFixedCodeLength;
extern const JSC::ConstructAbility s_stringPrototypeFixedCodeConstructAbility;
extern const JSC::ConstructorKind s_stringPrototypeFixedCodeConstructorKind;
extern const JSC::ImplementationVisibility s_stringPrototypeFixedCodeImplementationVisibility;
extern const JSC::InlineAttribute s_stringPrototypeFixedCodeInlineAttribute;
extern const char* const s_stringPrototypeFontcolorCode;
extern const int s_stringPrototypeFontcolorCodeLength;
extern const JSC::ConstructAbility s_stringPrototypeFontcolorCodeConstructAbility;
extern const JSC::ConstructorKind s_stringPrototypeFontcolorCodeConstructorKind;
extern const JSC::ImplementationVisibility s_stringPrototypeFontcolorCodeImplementationVisibility;
extern const JSC::InlineAttribute s_stringPrototypeFontcolorCodeInlineAttribute;
extern const char* const s_stringPrototypeFontsizeCode;
extern const int s_stringPrototypeFontsizeCodeLength;
extern const JSC::ConstructAbility s_stringPrototypeFontsizeCodeConstructAbility;
extern const JSC::ConstructorKind s_stringPrototypeFontsizeCodeConstructorKind;
extern const JSC::ImplementationVisibility s_stringPrototypeFontsizeCodeImplementationVisibility;
extern const JSC::InlineAttribute s_stringPrototypeFontsizeCodeInlineAttribute;
extern const char* const s_stringPrototypeItalicsCode;
extern const int s_stringPrototypeItalicsCodeLength;
extern const JSC::ConstructAbility s_stringPrototypeItalicsCodeConstructAbility;
extern const JSC::ConstructorKind s_stringPrototypeItalicsCodeConstructorKind;
extern const JSC::ImplementationVisibility s_stringPrototypeItalicsCodeImplementationVisibility;
extern const JSC::InlineAttribute s_stringPrototypeItalicsCodeInlineAttribute;
extern const char* const s_stringPrototypeLinkCode;
extern const int s_stringPrototypeLinkCodeLength;
extern const JSC::ConstructAbility s_stringPrototypeLinkCodeConstructAbility;
extern const JSC::ConstructorKind s_stringPrototypeLinkCodeConstructorKind;
extern const JSC::ImplementationVisibility s_stringPrototypeLinkCodeImplementationVisibility;
extern const JSC::InlineAttribute s_stringPrototypeLinkCodeInlineAttribute;
extern const char* const s_stringPrototypeSmallCode;
extern const int s_stringPrototypeSmallCodeLength;
extern const JSC::ConstructAbility s_stringPrototypeSmallCodeConstructAbility;
extern const JSC::ConstructorKind s_stringPrototypeSmallCodeConstructorKind;
extern const JSC::ImplementationVisibility s_stringPrototypeSmallCodeImplementationVisibility;
extern const JSC::InlineAttribute s_stringPrototypeSmallCodeInlineAttribute;
extern const char* const s_stringPrototypeStrikeCode;
extern const int s_stringPrototypeStrikeCodeLength;
extern const JSC::ConstructAbility s_stringPrototypeStrikeCodeConstructAbility;
extern const JSC::ConstructorKind s_stringPrototypeStrikeCodeConstructorKind;
extern const JSC::ImplementationVisibility s_stringPrototypeStrikeCodeImplementationVisibility;
extern const JSC::InlineAttribute s_stringPrototypeStrikeCodeInlineAttribute;
extern const char* const s_stringPrototypeSubCode;
extern const int s_stringPrototypeSubCodeLength;
extern const JSC::ConstructAbility s_stringPrototypeSubCodeConstructAbility;
extern const JSC::ConstructorKind s_stringPrototypeSubCodeConstructorKind;
extern const JSC::ImplementationVisibility s_stringPrototypeSubCodeImplementationVisibility;
extern const JSC::InlineAttribute s_stringPrototypeSubCodeInlineAttribute;
extern const char* const s_stringPrototypeSupCode;
extern const int s_stringPrototypeSupCodeLength;
extern const JSC::ConstructAbility s_stringPrototypeSupCodeConstructAbility;
extern const JSC::ConstructorKind s_stringPrototypeSupCodeConstructorKind;
extern const JSC::ImplementationVisibility s_stringPrototypeSupCodeImplementationVisibility;
extern const JSC::InlineAttribute s_stringPrototypeSupCodeInlineAttribute;

#define JSC_FOREACH_STRINGPROTOTYPE_BUILTIN_DATA(macro) \
    macro(match, stringPrototypeMatch, 1) \
    macro(matchAll, stringPrototypeMatchAll, 1) \
    macro(repeatSlowPath, stringPrototypeRepeatSlowPath, 2) \
    macro(repeatCharactersSlowPath, stringPrototypeRepeatCharactersSlowPath, 2) \
    macro(repeat, stringPrototypeRepeat, 1) \
    macro(padStart, stringPrototypePadStart, 1) \
    macro(padEnd, stringPrototypePadEnd, 1) \
    macro(hasObservableSideEffectsForStringReplace, stringPrototypeHasObservableSideEffectsForStringReplace, 2) \
    macro(replace, stringPrototypeReplace, 2) \
    macro(replaceAll, stringPrototypeReplaceAll, 2) \
    macro(search, stringPrototypeSearch, 1) \
    macro(split, stringPrototypeSplit, 2) \
    macro(stringConcatSlowPath, stringPrototypeStringConcatSlowPath, 0) \
    macro(concat, stringPrototypeConcat, 1) \
    macro(createHTML, stringPrototypeCreateHTML, 5) \
    macro(anchor, stringPrototypeAnchor, 1) \
    macro(big, stringPrototypeBig, 0) \
    macro(blink, stringPrototypeBlink, 0) \
    macro(bold, stringPrototypeBold, 0) \
    macro(fixed, stringPrototypeFixed, 0) \
    macro(fontcolor, stringPrototypeFontcolor, 1) \
    macro(fontsize, stringPrototypeFontsize, 1) \
    macro(italics, stringPrototypeItalics, 0) \
    macro(link, stringPrototypeLink, 1) \
    macro(small, stringPrototypeSmall, 0) \
    macro(strike, stringPrototypeStrike, 0) \
    macro(sub, stringPrototypeSub, 0) \
    macro(sup, stringPrototypeSup, 0) \

/* TypedArrayConstructor */
extern const char* const s_typedArrayConstructorOfCode;
extern const int s_typedArrayConstructorOfCodeLength;
extern const JSC::ConstructAbility s_typedArrayConstructorOfCodeConstructAbility;
extern const JSC::ConstructorKind s_typedArrayConstructorOfCodeConstructorKind;
extern const JSC::ImplementationVisibility s_typedArrayConstructorOfCodeImplementationVisibility;
extern const JSC::InlineAttribute s_typedArrayConstructorOfCodeInlineAttribute;
extern const char* const s_typedArrayConstructorFromCode;
extern const int s_typedArrayConstructorFromCodeLength;
extern const JSC::ConstructAbility s_typedArrayConstructorFromCodeConstructAbility;
extern const JSC::ConstructorKind s_typedArrayConstructorFromCodeConstructorKind;
extern const JSC::ImplementationVisibility s_typedArrayConstructorFromCodeImplementationVisibility;
extern const JSC::InlineAttribute s_typedArrayConstructorFromCodeInlineAttribute;

#define JSC_FOREACH_TYPEDARRAYCONSTRUCTOR_BUILTIN_DATA(macro) \
    macro(of, typedArrayConstructorOf, 0) \
    macro(from, typedArrayConstructorFrom, 1) \

/* TypedArrayPrototype */
extern const char* const s_typedArrayPrototypeTypedArraySpeciesConstructorCode;
extern const int s_typedArrayPrototypeTypedArraySpeciesConstructorCodeLength;
extern const JSC::ConstructAbility s_typedArrayPrototypeTypedArraySpeciesConstructorCodeConstructAbility;
extern const JSC::ConstructorKind s_typedArrayPrototypeTypedArraySpeciesConstructorCodeConstructorKind;
extern const JSC::ImplementationVisibility s_typedArrayPrototypeTypedArraySpeciesConstructorCodeImplementationVisibility;
extern const JSC::InlineAttribute s_typedArrayPrototypeTypedArraySpeciesConstructorCodeInlineAttribute;
extern const char* const s_typedArrayPrototypeEveryCode;
extern const int s_typedArrayPrototypeEveryCodeLength;
extern const JSC::ConstructAbility s_typedArrayPrototypeEveryCodeConstructAbility;
extern const JSC::ConstructorKind s_typedArrayPrototypeEveryCodeConstructorKind;
extern const JSC::ImplementationVisibility s_typedArrayPrototypeEveryCodeImplementationVisibility;
extern const JSC::InlineAttribute s_typedArrayPrototypeEveryCodeInlineAttribute;
extern const char* const s_typedArrayPrototypeFindCode;
extern const int s_typedArrayPrototypeFindCodeLength;
extern const JSC::ConstructAbility s_typedArrayPrototypeFindCodeConstructAbility;
extern const JSC::ConstructorKind s_typedArrayPrototypeFindCodeConstructorKind;
extern const JSC::ImplementationVisibility s_typedArrayPrototypeFindCodeImplementationVisibility;
extern const JSC::InlineAttribute s_typedArrayPrototypeFindCodeInlineAttribute;
extern const char* const s_typedArrayPrototypeFindLastCode;
extern const int s_typedArrayPrototypeFindLastCodeLength;
extern const JSC::ConstructAbility s_typedArrayPrototypeFindLastCodeConstructAbility;
extern const JSC::ConstructorKind s_typedArrayPrototypeFindLastCodeConstructorKind;
extern const JSC::ImplementationVisibility s_typedArrayPrototypeFindLastCodeImplementationVisibility;
extern const JSC::InlineAttribute s_typedArrayPrototypeFindLastCodeInlineAttribute;
extern const char* const s_typedArrayPrototypeFindIndexCode;
extern const int s_typedArrayPrototypeFindIndexCodeLength;
extern const JSC::ConstructAbility s_typedArrayPrototypeFindIndexCodeConstructAbility;
extern const JSC::ConstructorKind s_typedArrayPrototypeFindIndexCodeConstructorKind;
extern const JSC::ImplementationVisibility s_typedArrayPrototypeFindIndexCodeImplementationVisibility;
extern const JSC::InlineAttribute s_typedArrayPrototypeFindIndexCodeInlineAttribute;
extern const char* const s_typedArrayPrototypeFindLastIndexCode;
extern const int s_typedArrayPrototypeFindLastIndexCodeLength;
extern const JSC::ConstructAbility s_typedArrayPrototypeFindLastIndexCodeConstructAbility;
extern const JSC::ConstructorKind s_typedArrayPrototypeFindLastIndexCodeConstructorKind;
extern const JSC::ImplementationVisibility s_typedArrayPrototypeFindLastIndexCodeImplementationVisibility;
extern const JSC::InlineAttribute s_typedArrayPrototypeFindLastIndexCodeInlineAttribute;
extern const char* const s_typedArrayPrototypeForEachCode;
extern const int s_typedArrayPrototypeForEachCodeLength;
extern const JSC::ConstructAbility s_typedArrayPrototypeForEachCodeConstructAbility;
extern const JSC::ConstructorKind s_typedArrayPrototypeForEachCodeConstructorKind;
extern const JSC::ImplementationVisibility s_typedArrayPrototypeForEachCodeImplementationVisibility;
extern const JSC::InlineAttribute s_typedArrayPrototypeForEachCodeInlineAttribute;
extern const char* const s_typedArrayPrototypeSomeCode;
extern const int s_typedArrayPrototypeSomeCodeLength;
extern const JSC::ConstructAbility s_typedArrayPrototypeSomeCodeConstructAbility;
extern const JSC::ConstructorKind s_typedArrayPrototypeSomeCodeConstructorKind;
extern const JSC::ImplementationVisibility s_typedArrayPrototypeSomeCodeImplementationVisibility;
extern const JSC::InlineAttribute s_typedArrayPrototypeSomeCodeInlineAttribute;
extern const char* const s_typedArrayPrototypeReduceCode;
extern const int s_typedArrayPrototypeReduceCodeLength;
extern const JSC::ConstructAbility s_typedArrayPrototypeReduceCodeConstructAbility;
extern const JSC::ConstructorKind s_typedArrayPrototypeReduceCodeConstructorKind;
extern const JSC::ImplementationVisibility s_typedArrayPrototypeReduceCodeImplementationVisibility;
extern const JSC::InlineAttribute s_typedArrayPrototypeReduceCodeInlineAttribute;
extern const char* const s_typedArrayPrototypeReduceRightCode;
extern const int s_typedArrayPrototypeReduceRightCodeLength;
extern const JSC::ConstructAbility s_typedArrayPrototypeReduceRightCodeConstructAbility;
extern const JSC::ConstructorKind s_typedArrayPrototypeReduceRightCodeConstructorKind;
extern const JSC::ImplementationVisibility s_typedArrayPrototypeReduceRightCodeImplementationVisibility;
extern const JSC::InlineAttribute s_typedArrayPrototypeReduceRightCodeInlineAttribute;
extern const char* const s_typedArrayPrototypeMapCode;
extern const int s_typedArrayPrototypeMapCodeLength;
extern const JSC::ConstructAbility s_typedArrayPrototypeMapCodeConstructAbility;
extern const JSC::ConstructorKind s_typedArrayPrototypeMapCodeConstructorKind;
extern const JSC::ImplementationVisibility s_typedArrayPrototypeMapCodeImplementationVisibility;
extern const JSC::InlineAttribute s_typedArrayPrototypeMapCodeInlineAttribute;
extern const char* const s_typedArrayPrototypeFilterCode;
extern const int s_typedArrayPrototypeFilterCodeLength;
extern const JSC::ConstructAbility s_typedArrayPrototypeFilterCodeConstructAbility;
extern const JSC::ConstructorKind s_typedArrayPrototypeFilterCodeConstructorKind;
extern const JSC::ImplementationVisibility s_typedArrayPrototypeFilterCodeImplementationVisibility;
extern const JSC::InlineAttribute s_typedArrayPrototypeFilterCodeInlineAttribute;
extern const char* const s_typedArrayPrototypeToLocaleStringCode;
extern const int s_typedArrayPrototypeToLocaleStringCodeLength;
extern const JSC::ConstructAbility s_typedArrayPrototypeToLocaleStringCodeConstructAbility;
extern const JSC::ConstructorKind s_typedArrayPrototypeToLocaleStringCodeConstructorKind;
extern const JSC::ImplementationVisibility s_typedArrayPrototypeToLocaleStringCodeImplementationVisibility;
extern const JSC::InlineAttribute s_typedArrayPrototypeToLocaleStringCodeInlineAttribute;
extern const char* const s_typedArrayPrototypeAtCode;
extern const int s_typedArrayPrototypeAtCodeLength;
extern const JSC::ConstructAbility s_typedArrayPrototypeAtCodeConstructAbility;
extern const JSC::ConstructorKind s_typedArrayPrototypeAtCodeConstructorKind;
extern const JSC::ImplementationVisibility s_typedArrayPrototypeAtCodeImplementationVisibility;
extern const JSC::InlineAttribute s_typedArrayPrototypeAtCodeInlineAttribute;

#define JSC_FOREACH_TYPEDARRAYPROTOTYPE_BUILTIN_DATA(macro) \
    macro(typedArraySpeciesConstructor, typedArrayPrototypeTypedArraySpeciesConstructor, 1) \
    macro(every, typedArrayPrototypeEvery, 1) \
    macro(find, typedArrayPrototypeFind, 1) \
    macro(findLast, typedArrayPrototypeFindLast, 1) \
    macro(findIndex, typedArrayPrototypeFindIndex, 1) \
    macro(findLastIndex, typedArrayPrototypeFindLastIndex, 1) \
    macro(forEach, typedArrayPrototypeForEach, 1) \
    macro(some, typedArrayPrototypeSome, 1) \
    macro(reduce, typedArrayPrototypeReduce, 1) \
    macro(reduceRight, typedArrayPrototypeReduceRight, 1) \
    macro(map, typedArrayPrototypeMap, 1) \
    macro(filter, typedArrayPrototypeFilter, 1) \
    macro(toLocaleString, typedArrayPrototypeToLocaleString, 0) \
    macro(at, typedArrayPrototypeAt, 1) \

/* WebAssembly */
extern const char* const s_webAssemblyCompileStreamingCode;
extern const int s_webAssemblyCompileStreamingCodeLength;
extern const JSC::ConstructAbility s_webAssemblyCompileStreamingCodeConstructAbility;
extern const JSC::ConstructorKind s_webAssemblyCompileStreamingCodeConstructorKind;
extern const JSC::ImplementationVisibility s_webAssemblyCompileStreamingCodeImplementationVisibility;
extern const JSC::InlineAttribute s_webAssemblyCompileStreamingCodeInlineAttribute;
extern const char* const s_webAssemblyInstantiateStreamingCode;
extern const int s_webAssemblyInstantiateStreamingCodeLength;
extern const JSC::ConstructAbility s_webAssemblyInstantiateStreamingCodeConstructAbility;
extern const JSC::ConstructorKind s_webAssemblyInstantiateStreamingCodeConstructorKind;
extern const JSC::ImplementationVisibility s_webAssemblyInstantiateStreamingCodeImplementationVisibility;
extern const JSC::InlineAttribute s_webAssemblyInstantiateStreamingCodeInlineAttribute;

#define JSC_FOREACH_WEBASSEMBLY_BUILTIN_DATA(macro) \
    macro(compileStreaming, webAssemblyCompileStreaming, 1) \
    macro(instantiateStreaming, webAssemblyInstantiateStreaming, 1) \

/* WrapForValidIteratorPrototype */
extern const char* const s_wrapForValidIteratorPrototypeNextCode;
extern const int s_wrapForValidIteratorPrototypeNextCodeLength;
extern const JSC::ConstructAbility s_wrapForValidIteratorPrototypeNextCodeConstructAbility;
extern const JSC::ConstructorKind s_wrapForValidIteratorPrototypeNextCodeConstructorKind;
extern const JSC::ImplementationVisibility s_wrapForValidIteratorPrototypeNextCodeImplementationVisibility;
extern const JSC::InlineAttribute s_wrapForValidIteratorPrototypeNextCodeInlineAttribute;
extern const char* const s_wrapForValidIteratorPrototypeReturnCode;
extern const int s_wrapForValidIteratorPrototypeReturnCodeLength;
extern const JSC::ConstructAbility s_wrapForValidIteratorPrototypeReturnCodeConstructAbility;
extern const JSC::ConstructorKind s_wrapForValidIteratorPrototypeReturnCodeConstructorKind;
extern const JSC::ImplementationVisibility s_wrapForValidIteratorPrototypeReturnCodeImplementationVisibility;
extern const JSC::InlineAttribute s_wrapForValidIteratorPrototypeReturnCodeInlineAttribute;

#define JSC_FOREACH_WRAPFORVALIDITERATORPROTOTYPE_BUILTIN_DATA(macro) \
    macro(next, wrapForValidIteratorPrototypeNext, 0) \
    macro(return, wrapForValidIteratorPrototypeReturn, 0) \

/* InjectedScriptSource */
extern const char* const s_injectedScriptSourceCreateObjectWithoutPrototypeCode;
extern const int s_injectedScriptSourceCreateObjectWithoutPrototypeCodeLength;
extern const JSC::ConstructAbility s_injectedScriptSourceCreateObjectWithoutPrototypeCodeConstructAbility;
extern const JSC::ConstructorKind s_injectedScriptSourceCreateObjectWithoutPrototypeCodeConstructorKind;
extern const JSC::ImplementationVisibility s_injectedScriptSourceCreateObjectWithoutPrototypeCodeImplementationVisibility;
extern const JSC::InlineAttribute s_injectedScriptSourceCreateObjectWithoutPrototypeCodeInlineAttribute;
extern const char* const s_injectedScriptSourceCreateArrayWithoutPrototypeCode;
extern const int s_injectedScriptSourceCreateArrayWithoutPrototypeCodeLength;
extern const JSC::ConstructAbility s_injectedScriptSourceCreateArrayWithoutPrototypeCodeConstructAbility;
extern const JSC::ConstructorKind s_injectedScriptSourceCreateArrayWithoutPrototypeCodeConstructorKind;
extern const JSC::ImplementationVisibility s_injectedScriptSourceCreateArrayWithoutPrototypeCodeImplementationVisibility;
extern const JSC::InlineAttribute s_injectedScriptSourceCreateArrayWithoutPrototypeCodeInlineAttribute;
extern const char* const s_injectedScriptSourceCreateInspectorInjectedScriptCode;
extern const int s_injectedScriptSourceCreateInspectorInjectedScriptCodeLength;
extern const JSC::ConstructAbility s_injectedScriptSourceCreateInspectorInjectedScriptCodeConstructAbility;
extern const JSC::ConstructorKind s_injectedScriptSourceCreateInspectorInjectedScriptCodeConstructorKind;
extern const JSC::ImplementationVisibility s_injectedScriptSourceCreateInspectorInjectedScriptCodeImplementationVisibility;
extern const JSC::InlineAttribute s_injectedScriptSourceCreateInspectorInjectedScriptCodeInlineAttribute;

#define JSC_FOREACH_INJECTEDSCRIPTSOURCE_BUILTIN_DATA(macro) \
    macro(createObjectWithoutPrototype, injectedScriptSourceCreateObjectWithoutPrototype, 0) \
    macro(createArrayWithoutPrototype, injectedScriptSourceCreateArrayWithoutPrototype, 0) \
    macro(createInspectorInjectedScript, injectedScriptSourceCreateInspectorInjectedScript, 3) \

#define JSC_FOREACH_BUILTIN_CODE(macro) \
    macro(promiseConstructorInternalPromiseConstructorCode, InternalPromise, ASCIILiteral(), s_promiseConstructorInternalPromiseConstructorCodeLength) \
    macro(promiseConstructorPromiseConstructorCode, Promise, ASCIILiteral(), s_promiseConstructorPromiseConstructorCodeLength) \
    macro(regExpPrototypeAdvanceStringIndexCode, advanceStringIndex, ASCIILiteral(), s_regExpPrototypeAdvanceStringIndexCodeLength) \
    macro(promiseConstructorAllCode, all, ASCIILiteral(), s_promiseConstructorAllCodeLength) \
    macro(promiseConstructorAllSettledCode, allSettled, ASCIILiteral(), s_promiseConstructorAllSettledCodeLength) \
    macro(stringPrototypeAnchorCode, anchor, ASCIILiteral(), s_stringPrototypeAnchorCodeLength) \
    macro(promiseConstructorAnyCode, any, ASCIILiteral(), s_promiseConstructorAnyCodeLength) \
    macro(functionPrototypeApplyCode, apply, ASCIILiteral(), s_functionPrototypeApplyCodeLength) \
    macro(reflectObjectApplyCode, apply, ASCIILiteral(), s_reflectObjectApplyCodeLength) \
    macro(arrayIteratorPrototypeArrayIteratorNextHelperCode, arrayIteratorNextHelper, ASCIILiteral(), s_arrayIteratorPrototypeArrayIteratorNextHelperCodeLength) \
    macro(asyncFromSyncIteratorPrototypeAsyncFromSyncIteratorOnFulfilledContinueCode, asyncFromSyncIteratorOnFulfilledContinue, ASCIILiteral(), s_asyncFromSyncIteratorPrototypeAsyncFromSyncIteratorOnFulfilledContinueCodeLength) \
    macro(asyncFromSyncIteratorPrototypeAsyncFromSyncIteratorOnFulfilledDoneCode, asyncFromSyncIteratorOnFulfilledDone, ASCIILiteral(), s_asyncFromSyncIteratorPrototypeAsyncFromSyncIteratorOnFulfilledDoneCodeLength) \
    macro(asyncFromSyncIteratorPrototypeAsyncFromSyncIteratorOnRejectedCode, asyncFromSyncIteratorOnRejected, ASCIILiteral(), s_asyncFromSyncIteratorPrototypeAsyncFromSyncIteratorOnRejectedCodeLength) \
    macro(asyncFunctionPrototypeAsyncFunctionResumeCode, asyncFunctionResume, ASCIILiteral(), s_asyncFunctionPrototypeAsyncFunctionResumeCodeLength) \
    macro(asyncFunctionPrototypeAsyncFunctionResumeOnFulfilledCode, asyncFunctionResumeOnFulfilled, ASCIILiteral(), s_asyncFunctionPrototypeAsyncFunctionResumeOnFulfilledCodeLength) \
    macro(asyncFunctionPrototypeAsyncFunctionResumeOnRejectedCode, asyncFunctionResumeOnRejected, ASCIILiteral(), s_asyncFunctionPrototypeAsyncFunctionResumeOnRejectedCodeLength) \
    macro(asyncGeneratorPrototypeAsyncGeneratorEnqueueCode, asyncGeneratorEnqueue, ASCIILiteral(), s_asyncGeneratorPrototypeAsyncGeneratorEnqueueCodeLength) \
    macro(asyncGeneratorPrototypeAsyncGeneratorQueueDequeueCode, asyncGeneratorQueueDequeue, ASCIILiteral(), s_asyncGeneratorPrototypeAsyncGeneratorQueueDequeueCodeLength) \
    macro(asyncGeneratorPrototypeAsyncGeneratorQueueEnqueueCode, asyncGeneratorQueueEnqueue, ASCIILiteral(), s_asyncGeneratorPrototypeAsyncGeneratorQueueEnqueueCodeLength) \
    macro(asyncGeneratorPrototypeAsyncGeneratorQueueIsEmptyCode, asyncGeneratorQueueIsEmpty, ASCIILiteral(), s_asyncGeneratorPrototypeAsyncGeneratorQueueIsEmptyCodeLength) \
    macro(asyncGeneratorPrototypeAsyncGeneratorRejectCode, asyncGeneratorReject, ASCIILiteral(), s_asyncGeneratorPrototypeAsyncGeneratorRejectCodeLength) \
    macro(asyncGeneratorPrototypeAsyncGeneratorResolveCode, asyncGeneratorResolve, ASCIILiteral(), s_asyncGeneratorPrototypeAsyncGeneratorResolveCodeLength) \
    macro(asyncGeneratorPrototypeAsyncGeneratorResumeNextCode, asyncGeneratorResumeNext, ASCIILiteral(), s_asyncGeneratorPrototypeAsyncGeneratorResumeNextCodeLength) \
    macro(asyncGeneratorPrototypeAsyncGeneratorResumeNextOnFulfilledCode, asyncGeneratorResumeNextOnFulfilled, ASCIILiteral(), s_asyncGeneratorPrototypeAsyncGeneratorResumeNextOnFulfilledCodeLength) \
    macro(asyncGeneratorPrototypeAsyncGeneratorResumeNextOnRejectedCode, asyncGeneratorResumeNextOnRejected, ASCIILiteral(), s_asyncGeneratorPrototypeAsyncGeneratorResumeNextOnRejectedCodeLength) \
    macro(asyncGeneratorPrototypeAsyncGeneratorYieldCode, asyncGeneratorYield, ASCIILiteral(), s_asyncGeneratorPrototypeAsyncGeneratorYieldCodeLength) \
    macro(asyncGeneratorPrototypeAsyncGeneratorYieldAwaitedCode, asyncGeneratorYieldAwaited, ASCIILiteral(), s_asyncGeneratorPrototypeAsyncGeneratorYieldAwaitedCodeLength) \
    macro(asyncGeneratorPrototypeAsyncGeneratorYieldOnRejectedCode, asyncGeneratorYieldOnRejected, ASCIILiteral(), s_asyncGeneratorPrototypeAsyncGeneratorYieldOnRejectedCodeLength) \
    macro(moduleLoaderAsyncModuleEvaluationCode, asyncModuleEvaluation, ASCIILiteral(), s_moduleLoaderAsyncModuleEvaluationCodeLength) \
    macro(arrayPrototypeAtCode, at, ASCIILiteral(), s_arrayPrototypeAtCodeLength) \
    macro(typedArrayPrototypeAtCode, at, ASCIILiteral(), s_typedArrayPrototypeAtCodeLength) \
    macro(asyncGeneratorPrototypeAwaitValueCode, awaitValue, ASCIILiteral(), s_asyncGeneratorPrototypeAwaitValueCodeLength) \
    macro(stringPrototypeBigCode, big, ASCIILiteral(), s_stringPrototypeBigCodeLength) \
    macro(stringPrototypeBlinkCode, blink, ASCIILiteral(), s_stringPrototypeBlinkCodeLength) \
    macro(stringPrototypeBoldCode, bold, ASCIILiteral(), s_stringPrototypeBoldCodeLength) \
    macro(iteratorHelpersBuiltinMapIterableCode, builtinMapIterable, ASCIILiteral(), s_iteratorHelpersBuiltinMapIterableCodeLength) \
    macro(iteratorHelpersBuiltinSetIterableCode, builtinSetIterable, ASCIILiteral(), s_iteratorHelpersBuiltinSetIterableCodeLength) \
    macro(moduleLoaderCacheSatisfyCode, cacheSatisfy, ASCIILiteral(), s_moduleLoaderCacheSatisfyCodeLength) \
    macro(moduleLoaderCacheSatisfyAndReturnCode, cacheSatisfyAndReturn, ASCIILiteral(), s_moduleLoaderCacheSatisfyAndReturnCodeLength) \
    macro(functionPrototypeCallCode, call, ASCIILiteral(), s_functionPrototypeCallCodeLength) \
    macro(promisePrototypeCatchCode, catch, ASCIILiteral(), s_promisePrototypeCatchCodeLength) \
    macro(jsIteratorPrototypeChunksCode, chunks, ASCIILiteral(), s_jsIteratorPrototypeChunksCodeLength) \
    macro(webAssemblyCompileStreamingCode, compileStreaming, ASCIILiteral(), s_webAssemblyCompileStreamingCodeLength) \
    macro(jsIteratorConstructorConcatCode, concat, ASCIILiteral(), s_jsIteratorConstructorConcatCodeLength) \
    macro(stringPrototypeConcatCode, concat, ASCIILiteral(), s_stringPrototypeConcatCodeLength) \
    macro(arrayPrototypeCopyWithinCode, copyWithin, ASCIILiteral(), s_arrayPrototypeCopyWithinCodeLength) \
    macro(injectedScriptSourceCreateArrayWithoutPrototypeCode, createArrayWithoutPrototype, ASCIILiteral(), s_injectedScriptSourceCreateArrayWithoutPrototypeCodeLength) \
    macro(asyncFromSyncIteratorPrototypeCreateAsyncFromSyncIteratorCode, createAsyncFromSyncIterator, ASCIILiteral(), s_asyncFromSyncIteratorPrototypeCreateAsyncFromSyncIteratorCodeLength) \
    macro(stringPrototypeCreateHTMLCode, createHTML, ASCIILiteral(), s_stringPrototypeCreateHTMLCodeLength) \
    macro(injectedScriptSourceCreateInspectorInjectedScriptCode, createInspectorInjectedScript, ASCIILiteral(), s_injectedScriptSourceCreateInspectorInjectedScriptCodeLength) \
    macro(injectedScriptSourceCreateObjectWithoutPrototypeCode, createObjectWithoutPrototype, ASCIILiteral(), s_injectedScriptSourceCreateObjectWithoutPrototypeCodeLength) \
    macro(promiseOperationsCreateResolvingFunctionsCode, createResolvingFunctions, ASCIILiteral(), s_promiseOperationsCreateResolvingFunctionsCodeLength) \
    macro(promiseOperationsCreateResolvingFunctionsWithoutPromiseCode, createResolvingFunctionsWithoutPromise, ASCIILiteral(), s_promiseOperationsCreateResolvingFunctionsWithoutPromiseCodeLength) \
    macro(shadowRealmPrototypeCrossRealmThrowCode, crossRealmThrow, ASCIILiteral(), s_shadowRealmPrototypeCrossRealmThrowCodeLength) \
    macro(arrayConstructorDefaultAsyncFromAsyncArrayLikeCode, defaultAsyncFromAsyncArrayLike, ASCIILiteral(), s_arrayConstructorDefaultAsyncFromAsyncArrayLikeCodeLength) \
    macro(arrayConstructorDefaultAsyncFromAsyncIteratorCode, defaultAsyncFromAsyncIterator, ASCIILiteral(), s_arrayConstructorDefaultAsyncFromAsyncIteratorCodeLength) \
    macro(reflectObjectDeletePropertyCode, deleteProperty, ASCIILiteral(), s_reflectObjectDeletePropertyCodeLength) \
    macro(moduleLoaderDependencyKeysIfEvaluatedCode, dependencyKeysIfEvaluated, ASCIILiteral(), s_moduleLoaderDependencyKeysIfEvaluatedCodeLength) \
    macro(setPrototypeDifferenceCode, difference, ASCIILiteral(), s_setPrototypeDifferenceCodeLength) \
    macro(asyncGeneratorPrototypeDoAsyncGeneratorBodyCallCode, doAsyncGeneratorBodyCall, ASCIILiteral(), s_asyncGeneratorPrototypeDoAsyncGeneratorBodyCallCodeLength) \
    macro(asyncGeneratorPrototypeDoAsyncGeneratorBodyCallOnFulfilledNormalCode, doAsyncGeneratorBodyCallOnFulfilledNormal, ASCIILiteral(), s_asyncGeneratorPrototypeDoAsyncGeneratorBodyCallOnFulfilledNormalCodeLength) \
    macro(asyncGeneratorPrototypeDoAsyncGeneratorBodyCallOnFulfilledReturnCode, doAsyncGeneratorBodyCallOnFulfilledReturn, ASCIILiteral(), s_asyncGeneratorPrototypeDoAsyncGeneratorBodyCallOnFulfilledReturnCodeLength) \
    macro(jsIteratorPrototypeDropCode, drop, ASCIILiteral(), s_jsIteratorPrototypeDropCodeLength) \
    macro(moduleLoaderEnsureRegisteredCode, ensureRegistered, ASCIILiteral(), s_moduleLoaderEnsureRegisteredCodeLength) \
    macro(shadowRealmPrototypeEvaluateCode, evaluate, ASCIILiteral(), s_shadowRealmPrototypeEvaluateCodeLength) \
    macro(arrayPrototypeEveryCode, every, ASCIILiteral(), s_arrayPrototypeEveryCodeLength) \
    macro(jsIteratorPrototypeEveryCode, every, ASCIILiteral(), s_jsIteratorPrototypeEveryCodeLength) \
    macro(typedArrayPrototypeEveryCode, every, ASCIILiteral(), s_typedArrayPrototypeEveryCodeLength) \
    macro(arrayPrototypeFilterCode, filter, ASCIILiteral(), s_arrayPrototypeFilterCodeLength) \
    macro(jsIteratorPrototypeFilterCode, filter, ASCIILiteral(), s_jsIteratorPrototypeFilterCodeLength) \
    macro(typedArrayPrototypeFilterCode, filter, ASCIILiteral(), s_typedArrayPrototypeFilterCodeLength) \
    macro(promisePrototypeFinallyCode, finally, ASCIILiteral(), s_promisePrototypeFinallyCodeLength) \
    macro(arrayPrototypeFindCode, find, ASCIILiteral(), s_arrayPrototypeFindCodeLength) \
    macro(jsIteratorPrototypeFindCode, find, ASCIILiteral(), s_jsIteratorPrototypeFindCodeLength) \
    macro(typedArrayPrototypeFindCode, find, ASCIILiteral(), s_typedArrayPrototypeFindCodeLength) \
    macro(arrayPrototypeFindIndexCode, findIndex, ASCIILiteral(), s_arrayPrototypeFindIndexCodeLength) \
    macro(typedArrayPrototypeFindIndexCode, findIndex, ASCIILiteral(), s_typedArrayPrototypeFindIndexCodeLength) \
    macro(arrayPrototypeFindLastCode, findLast, ASCIILiteral(), s_arrayPrototypeFindLastCodeLength) \
    macro(typedArrayPrototypeFindLastCode, findLast, ASCIILiteral(), s_typedArrayPrototypeFindLastCodeLength) \
    macro(arrayPrototypeFindLastIndexCode, findLastIndex, ASCIILiteral(), s_arrayPrototypeFindLastIndexCodeLength) \
    macro(typedArrayPrototypeFindLastIndexCode, findLastIndex, ASCIILiteral(), s_typedArrayPrototypeFindLastIndexCodeLength) \
    macro(stringPrototypeFixedCode, fixed, ASCIILiteral(), s_stringPrototypeFixedCodeLength) \
    macro(arrayPrototypeFlatCode, flat, ASCIILiteral(), s_arrayPrototypeFlatCodeLength) \
    macro(arrayPrototypeFlatIntoArrayCode, flatIntoArray, ASCIILiteral(), s_arrayPrototypeFlatIntoArrayCodeLength) \
    macro(arrayPrototypeFlatIntoArrayWithCallbackCode, flatIntoArrayWithCallback, ASCIILiteral(), s_arrayPrototypeFlatIntoArrayWithCallbackCodeLength) \
    macro(arrayPrototypeFlatMapCode, flatMap, ASCIILiteral(), s_arrayPrototypeFlatMapCodeLength) \
    macro(jsIteratorPrototypeFlatMapCode, flatMap, ASCIILiteral(), s_jsIteratorPrototypeFlatMapCodeLength) \
    macro(stringPrototypeFontcolorCode, fontcolor, ASCIILiteral(), s_stringPrototypeFontcolorCodeLength) \
    macro(stringPrototypeFontsizeCode, fontsize, ASCIILiteral(), s_stringPrototypeFontsizeCodeLength) \
    macro(arrayPrototypeForEachCode, forEach, ASCIILiteral(), s_arrayPrototypeForEachCodeLength) \
    macro(mapPrototypeForEachCode, forEach, ASCIILiteral(), s_mapPrototypeForEachCodeLength) \
    macro(setPrototypeForEachCode, forEach, ASCIILiteral(), s_setPrototypeForEachCodeLength) \
    macro(typedArrayPrototypeForEachCode, forEach, ASCIILiteral(), s_typedArrayPrototypeForEachCodeLength) \
    macro(moduleLoaderForceFulfillPromiseCode, forceFulfillPromise, ASCIILiteral(), s_moduleLoaderForceFulfillPromiseCodeLength) \
    macro(arrayConstructorFromCode, from, ASCIILiteral(), s_arrayConstructorFromCodeLength) \
    macro(jsIteratorConstructorFromCode, from, ASCIILiteral(), s_jsIteratorConstructorFromCodeLength) \
    macro(typedArrayConstructorFromCode, from, ASCIILiteral(), s_typedArrayConstructorFromCodeLength) \
    macro(arrayConstructorFromAsyncCode, fromAsync, ASCIILiteral(), s_arrayConstructorFromAsyncCodeLength) \
    macro(objectConstructorFromEntriesCode, fromEntries, ASCIILiteral(), s_objectConstructorFromEntriesCodeLength) \
    macro(moduleLoaderFulfillFetchCode, fulfillFetch, ASCIILiteral(), s_moduleLoaderFulfillFetchCodeLength) \
    macro(promiseOperationsFulfillPromiseCode, fulfillPromise, ASCIILiteral(), s_promiseOperationsFulfillPromiseCodeLength) \
    macro(promiseOperationsFulfillPromiseWithFirstResolvingFunctionCallCheckCode, fulfillPromiseWithFirstResolvingFunctionCallCheck, ASCIILiteral(), s_promiseOperationsFulfillPromiseWithFirstResolvingFunctionCallCheckCodeLength) \
    macro(promiseOperationsFulfillWithoutPromiseCode, fulfillWithoutPromise, ASCIILiteral(), s_promiseOperationsFulfillWithoutPromiseCodeLength) \
    macro(generatorPrototypeGeneratorResumeCode, generatorResume, ASCIILiteral(), s_generatorPrototypeGeneratorResumeCodeLength) \
    macro(reflectObjectGetCode, get, ASCIILiteral(), s_reflectObjectGetCodeLength) \
    macro(jsIteratorConstructorGetIteratorFlattenableCode, getIteratorFlattenable, ASCIILiteral(), s_jsIteratorConstructorGetIteratorFlattenableCodeLength) \
    macro(setPrototypeGetSetSizeAsIntCode, getSetSizeAsInt, ASCIILiteral(), s_setPrototypeGetSetSizeAsIntCodeLength) \
    macro(regExpPrototypeGetSubstitutionCode, getSubstitution, ASCIILiteral(), s_regExpPrototypeGetSubstitutionCodeLength) \
    macro(mapConstructorGroupByCode, groupBy, ASCIILiteral(), s_mapConstructorGroupByCodeLength) \
    macro(objectConstructorGroupByCode, groupBy, ASCIILiteral(), s_objectConstructorGroupByCodeLength) \
    macro(reflectObjectHasCode, has, ASCIILiteral(), s_reflectObjectHasCodeLength) \
    macro(regExpPrototypeHasObservableSideEffectsForRegExpMatchCode, hasObservableSideEffectsForRegExpMatch, ASCIILiteral(), s_regExpPrototypeHasObservableSideEffectsForRegExpMatchCodeLength) \
    macro(regExpPrototypeHasObservableSideEffectsForRegExpSplitCode, hasObservableSideEffectsForRegExpSplit, ASCIILiteral(), s_regExpPrototypeHasObservableSideEffectsForRegExpSplitCodeLength) \
    macro(stringPrototypeHasObservableSideEffectsForStringReplaceCode, hasObservableSideEffectsForStringReplace, ASCIILiteral(), s_stringPrototypeHasObservableSideEffectsForStringReplaceCodeLength) \
    macro(shadowRealmPrototypeImportValueCode, importValue, ASCIILiteral(), s_shadowRealmPrototypeImportValueCodeLength) \
    macro(arrayPrototypeIncludesCode, includes, ASCIILiteral(), s_arrayPrototypeIncludesCodeLength) \
    macro(webAssemblyInstantiateStreamingCode, instantiateStreaming, ASCIILiteral(), s_webAssemblyInstantiateStreamingCodeLength) \
    macro(internalPromiseConstructorInternalAllCode, internalAll, ASCIILiteral(), s_internalPromiseConstructorInternalAllCodeLength) \
    macro(setPrototypeIntersectionCode, intersection, ASCIILiteral(), s_setPrototypeIntersectionCodeLength) \
    macro(arrayConstructorIsArrayCode, isArray, ASCIILiteral(), s_arrayConstructorIsArrayCodeLength) \
    macro(setPrototypeIsDisjointFromCode, isDisjointFrom, ASCIILiteral(), s_setPrototypeIsDisjointFromCodeLength) \
    macro(asyncGeneratorPrototypeIsExecutionStateCode, isExecutionState, ASCIILiteral(), s_asyncGeneratorPrototypeIsExecutionStateCodeLength) \
    macro(globalObjectIsFiniteCode, isFinite, ASCIILiteral(), s_globalObjectIsFiniteCodeLength) \
    macro(numberConstructorIsFiniteCode, isFinite, ASCIILiteral(), s_numberConstructorIsFiniteCodeLength) \
    macro(setPrototypeIsSubsetOfCode, isSubsetOf, ASCIILiteral(), s_setPrototypeIsSubsetOfCodeLength) \
    macro(setPrototypeIsSupersetOfCode, isSupersetOf, ASCIILiteral(), s_setPrototypeIsSupersetOfCodeLength) \
    macro(asyncGeneratorPrototypeIsSuspendYieldStateCode, isSuspendYieldState, ASCIILiteral(), s_asyncGeneratorPrototypeIsSuspendYieldStateCodeLength) \
    macro(stringPrototypeItalicsCode, italics, ASCIILiteral(), s_stringPrototypeItalicsCodeLength) \
    macro(moduleLoaderLinkCode, link, ASCIILiteral(), s_moduleLoaderLinkCodeLength) \
    macro(stringPrototypeLinkCode, link, ASCIILiteral(), s_stringPrototypeLinkCodeLength) \
    macro(moduleLoaderLinkAndEvaluateModuleCode, linkAndEvaluateModule, ASCIILiteral(), s_moduleLoaderLinkAndEvaluateModuleCodeLength) \
    macro(moduleLoaderLoadAndEvaluateModuleCode, loadAndEvaluateModule, ASCIILiteral(), s_moduleLoaderLoadAndEvaluateModuleCodeLength) \
    macro(moduleLoaderLoadModuleCode, loadModule, ASCIILiteral(), s_moduleLoaderLoadModuleCodeLength) \
    macro(arrayPrototypeMapCode, map, ASCIILiteral(), s_arrayPrototypeMapCodeLength) \
    macro(jsIteratorPrototypeMapCode, map, ASCIILiteral(), s_jsIteratorPrototypeMapCodeLength) \
    macro(typedArrayPrototypeMapCode, map, ASCIILiteral(), s_typedArrayPrototypeMapCodeLength) \
    macro(regExpPrototypeMatchCode, match, "[Symbol.match]"_s, s_regExpPrototypeMatchCodeLength) \
    macro(stringPrototypeMatchCode, match, ASCIILiteral(), s_stringPrototypeMatchCodeLength) \
    macro(regExpPrototypeMatchAllCode, matchAll, "[Symbol.matchAll]"_s, s_regExpPrototypeMatchAllCodeLength) \
    macro(stringPrototypeMatchAllCode, matchAll, ASCIILiteral(), s_stringPrototypeMatchAllCodeLength) \
    macro(regExpPrototypeMatchSlowCode, matchSlow, ASCIILiteral(), s_regExpPrototypeMatchSlowCodeLength) \
    macro(arrayPrototypeMaxWithPositivesCode, maxWithPositives, ASCIILiteral(), s_arrayPrototypeMaxWithPositivesCodeLength) \
    macro(arrayPrototypeMinWithMaybeNegativeZeroAndPositiveCode, minWithMaybeNegativeZeroAndPositive, ASCIILiteral(), s_arrayPrototypeMinWithMaybeNegativeZeroAndPositiveCodeLength) \
    macro(moduleLoaderModuleEvaluationCode, moduleEvaluation, ASCIILiteral(), s_moduleLoaderModuleEvaluationCodeLength) \
    macro(promiseOperationsNewHandledRejectedPromiseCode, newHandledRejectedPromise, ASCIILiteral(), s_promiseOperationsNewHandledRejectedPromiseCodeLength) \
    macro(promiseOperationsNewPromiseCapabilityCode, newPromiseCapability, ASCIILiteral(), s_promiseOperationsNewPromiseCapabilityCodeLength) \
    macro(promiseOperationsNewPromiseCapabilitySlowCode, newPromiseCapabilitySlow, ASCIILiteral(), s_promiseOperationsNewPromiseCapabilitySlowCodeLength) \
    macro(moduleLoaderNewRegistryEntryCode, newRegistryEntry, ASCIILiteral(), s_moduleLoaderNewRegistryEntryCodeLength) \
    macro(arrayIteratorPrototypeNextCode, next, ASCIILiteral(), s_arrayIteratorPrototypeNextCodeLength) \
    macro(asyncFromSyncIteratorPrototypeNextCode, next, ASCIILiteral(), s_asyncFromSyncIteratorPrototypeNextCodeLength) \
    macro(asyncGeneratorPrototypeNextCode, next, ASCIILiteral(), s_asyncGeneratorPrototypeNextCodeLength) \
    macro(generatorPrototypeNextCode, next, ASCIILiteral(), s_generatorPrototypeNextCodeLength) \
    macro(jsIteratorHelperPrototypeNextCode, next, ASCIILiteral(), s_jsIteratorHelperPrototypeNextCodeLength) \
    macro(mapIteratorPrototypeNextCode, next, ASCIILiteral(), s_mapIteratorPrototypeNextCodeLength) \
    macro(regExpStringIteratorPrototypeNextCode, next, ASCIILiteral(), s_regExpStringIteratorPrototypeNextCodeLength) \
    macro(setIteratorPrototypeNextCode, next, ASCIILiteral(), s_setIteratorPrototypeNextCodeLength) \
    macro(stringIteratorPrototypeNextCode, next, ASCIILiteral(), s_stringIteratorPrototypeNextCodeLength) \
    macro(wrapForValidIteratorPrototypeNextCode, next, ASCIILiteral(), s_wrapForValidIteratorPrototypeNextCodeLength) \
    macro(arrayConstructorOfCode, of, ASCIILiteral(), s_arrayConstructorOfCodeLength) \
    macro(typedArrayConstructorOfCode, of, ASCIILiteral(), s_typedArrayConstructorOfCodeLength) \
    macro(stringPrototypePadEndCode, padEnd, ASCIILiteral(), s_stringPrototypePadEndCodeLength) \
    macro(stringPrototypePadStartCode, padStart, ASCIILiteral(), s_stringPrototypePadStartCodeLength) \
    macro(iteratorHelpersPerformIterationCode, performIteration, ASCIILiteral(), s_iteratorHelpersPerformIterationCodeLength) \
    macro(promiseOperationsPerformPromiseThenCode, performPromiseThen, ASCIILiteral(), s_promiseOperationsPerformPromiseThenCodeLength) \
    macro(proxyHelpersPerformProxyObjectGetCode, performProxyObjectGet, ASCIILiteral(), s_proxyHelpersPerformProxyObjectGetCodeLength) \
    macro(proxyHelpersPerformProxyObjectGetByValCode, performProxyObjectGetByVal, ASCIILiteral(), s_proxyHelpersPerformProxyObjectGetByValCodeLength) \
    macro(proxyHelpersPerformProxyObjectHasCode, performProxyObjectHas, ASCIILiteral(), s_proxyHelpersPerformProxyObjectHasCodeLength) \
    macro(proxyHelpersPerformProxyObjectHasByValCode, performProxyObjectHasByVal, ASCIILiteral(), s_proxyHelpersPerformProxyObjectHasByValCodeLength) \
    macro(proxyHelpersPerformProxyObjectSetByValSloppyCode, performProxyObjectSetByValSloppy, ASCIILiteral(), s_proxyHelpersPerformProxyObjectSetByValSloppyCodeLength) \
    macro(proxyHelpersPerformProxyObjectSetByValStrictCode, performProxyObjectSetByValStrict, ASCIILiteral(), s_proxyHelpersPerformProxyObjectSetByValStrictCodeLength) \
    macro(proxyHelpersPerformProxyObjectSetSloppyCode, performProxyObjectSetSloppy, ASCIILiteral(), s_proxyHelpersPerformProxyObjectSetSloppyCodeLength) \
    macro(proxyHelpersPerformProxyObjectSetStrictCode, performProxyObjectSetStrict, ASCIILiteral(), s_proxyHelpersPerformProxyObjectSetStrictCodeLength) \
    macro(promiseConstructorPromiseAllNewResolveElementCode, promiseAllNewResolveElement, ASCIILiteral(), s_promiseConstructorPromiseAllNewResolveElementCodeLength) \
    macro(promiseConstructorPromiseAllOnFulfilledCode, promiseAllOnFulfilled, ASCIILiteral(), s_promiseConstructorPromiseAllOnFulfilledCodeLength) \
    macro(promiseConstructorPromiseAllSlowCode, promiseAllSlow, ASCIILiteral(), s_promiseConstructorPromiseAllSlowCodeLength) \
    macro(promiseOperationsPromiseEmptyOnFulfilledCode, promiseEmptyOnFulfilled, ASCIILiteral(), s_promiseOperationsPromiseEmptyOnFulfilledCodeLength) \
    macro(promiseOperationsPromiseEmptyOnRejectedCode, promiseEmptyOnRejected, ASCIILiteral(), s_promiseOperationsPromiseEmptyOnRejectedCodeLength) \
    macro(promiseConstructorPromiseNewOnRejectedCode, promiseNewOnRejected, ASCIILiteral(), s_promiseConstructorPromiseNewOnRejectedCodeLength) \
    macro(promiseConstructorPromiseOnRejectedWithContextCode, promiseOnRejectedWithContext, ASCIILiteral(), s_promiseConstructorPromiseOnRejectedWithContextCodeLength) \
    macro(promiseOperationsPromiseReactionJobCode, promiseReactionJob, ASCIILiteral(), s_promiseOperationsPromiseReactionJobCodeLength) \
    macro(promiseOperationsPromiseReactionJobWithoutPromiseCode, promiseReactionJobWithoutPromise, ASCIILiteral(), s_promiseOperationsPromiseReactionJobWithoutPromiseCodeLength) \
    macro(promiseOperationsPromiseRejectSlowCode, promiseRejectSlow, ASCIILiteral(), s_promiseOperationsPromiseRejectSlowCodeLength) \
    macro(promiseOperationsPromiseResolveCode, promiseResolve, ASCIILiteral(), s_promiseOperationsPromiseResolveCodeLength) \
    macro(promiseOperationsPromiseResolveSlowCode, promiseResolveSlow, ASCIILiteral(), s_promiseOperationsPromiseResolveSlowCodeLength) \
    macro(promiseOperationsPromiseResolveThenableJobCode, promiseResolveThenableJob, ASCIILiteral(), s_promiseOperationsPromiseResolveThenableJobCodeLength) \
    macro(promiseOperationsPromiseResolveThenableJobFastCode, promiseResolveThenableJobFast, ASCIILiteral(), s_promiseOperationsPromiseResolveThenableJobFastCodeLength) \
    macro(promiseOperationsPromiseResolveThenableJobWithDerivedPromiseCode, promiseResolveThenableJobWithDerivedPromise, ASCIILiteral(), s_promiseOperationsPromiseResolveThenableJobWithDerivedPromiseCodeLength) \
    macro(promiseOperationsPromiseResolveThenableJobWithoutPromiseFastCode, promiseResolveThenableJobWithoutPromiseFast, ASCIILiteral(), s_promiseOperationsPromiseResolveThenableJobWithoutPromiseFastCodeLength) \
    macro(moduleLoaderProvideFetchCode, provideFetch, ASCIILiteral(), s_moduleLoaderProvideFetchCodeLength) \
    macro(promiseOperationsPushNewPromiseReactionCode, pushNewPromiseReaction, ASCIILiteral(), s_promiseOperationsPushNewPromiseReactionCodeLength) \
    macro(promiseConstructorRaceCode, race, ASCIILiteral(), s_promiseConstructorRaceCodeLength) \
    macro(stringConstructorRawCode, raw, ASCIILiteral(), s_stringConstructorRawCodeLength) \
    macro(arrayPrototypeReduceCode, reduce, ASCIILiteral(), s_arrayPrototypeReduceCodeLength) \
    macro(jsIteratorPrototypeReduceCode, reduce, ASCIILiteral(), s_jsIteratorPrototypeReduceCodeLength) \
    macro(typedArrayPrototypeReduceCode, reduce, ASCIILiteral(), s_typedArrayPrototypeReduceCodeLength) \
    macro(arrayPrototypeReduceRightCode, reduceRight, ASCIILiteral(), s_arrayPrototypeReduceRightCodeLength) \
    macro(typedArrayPrototypeReduceRightCode, reduceRight, ASCIILiteral(), s_typedArrayPrototypeReduceRightCodeLength) \
    macro(regExpPrototypeRegExpExecCode, regExpExec, ASCIILiteral(), s_regExpPrototypeRegExpExecCodeLength) \
    macro(promiseConstructorRejectCode, reject, ASCIILiteral(), s_promiseConstructorRejectCodeLength) \
    macro(promiseOperationsRejectPromiseCode, rejectPromise, ASCIILiteral(), s_promiseOperationsRejectPromiseCodeLength) \
    macro(promiseOperationsRejectPromiseWithFirstResolvingFunctionCallCheckCode, rejectPromiseWithFirstResolvingFunctionCallCheck, ASCIILiteral(), s_promiseOperationsRejectPromiseWithFirstResolvingFunctionCallCheckCodeLength) \
    macro(promiseOperationsRejectWithoutPromiseCode, rejectWithoutPromise, ASCIILiteral(), s_promiseOperationsRejectWithoutPromiseCodeLength) \
    macro(stringPrototypeRepeatCode, repeat, ASCIILiteral(), s_stringPrototypeRepeatCodeLength) \
    macro(stringPrototypeRepeatCharactersSlowPathCode, repeatCharactersSlowPath, ASCIILiteral(), s_stringPrototypeRepeatCharactersSlowPathCodeLength) \
    macro(stringPrototypeRepeatSlowPathCode, repeatSlowPath, ASCIILiteral(), s_stringPrototypeRepeatSlowPathCodeLength) \
    macro(regExpPrototypeReplaceCode, replace, "[Symbol.replace]"_s, s_regExpPrototypeReplaceCodeLength) \
    macro(stringPrototypeReplaceCode, replace, ASCIILiteral(), s_stringPrototypeReplaceCodeLength) \
    macro(stringPrototypeReplaceAllCode, replaceAll, ASCIILiteral(), s_stringPrototypeReplaceAllCodeLength) \
    macro(moduleLoaderRequestFetchCode, requestFetch, ASCIILiteral(), s_moduleLoaderRequestFetchCodeLength) \
    macro(moduleLoaderRequestImportModuleCode, requestImportModule, ASCIILiteral(), s_moduleLoaderRequestImportModuleCodeLength) \
    macro(moduleLoaderRequestInstantiateCode, requestInstantiate, ASCIILiteral(), s_moduleLoaderRequestInstantiateCodeLength) \
    macro(moduleLoaderRequestSatisfyCode, requestSatisfy, ASCIILiteral(), s_moduleLoaderRequestSatisfyCodeLength) \
    macro(moduleLoaderRequestSatisfyUtilCode, requestSatisfyUtil, ASCIILiteral(), s_moduleLoaderRequestSatisfyUtilCodeLength) \
    macro(promiseConstructorResolveCode, resolve, ASCIILiteral(), s_promiseConstructorResolveCodeLength) \
    macro(promiseOperationsResolvePromiseCode, resolvePromise, ASCIILiteral(), s_promiseOperationsResolvePromiseCodeLength) \
    macro(promiseOperationsResolvePromiseWithFirstResolvingFunctionCallCheckCode, resolvePromiseWithFirstResolvingFunctionCallCheck, ASCIILiteral(), s_promiseOperationsResolvePromiseWithFirstResolvingFunctionCallCheckCodeLength) \
    macro(promiseOperationsResolveWithoutPromiseCode, resolveWithoutPromise, ASCIILiteral(), s_promiseOperationsResolveWithoutPromiseCodeLength) \
    macro(promiseOperationsResolveWithoutPromiseForAsyncAwaitCode, resolveWithoutPromiseForAsyncAwait, ASCIILiteral(), s_promiseOperationsResolveWithoutPromiseForAsyncAwaitCodeLength) \
    macro(asyncFromSyncIteratorPrototypeReturnCode, return, ASCIILiteral(), s_asyncFromSyncIteratorPrototypeReturnCodeLength) \
    macro(asyncGeneratorPrototypeReturnCode, return, ASCIILiteral(), s_asyncGeneratorPrototypeReturnCodeLength) \
    macro(generatorPrototypeReturnCode, return, ASCIILiteral(), s_generatorPrototypeReturnCodeLength) \
    macro(jsIteratorHelperPrototypeReturnCode, return, ASCIILiteral(), s_jsIteratorHelperPrototypeReturnCodeLength) \
    macro(wrapForValidIteratorPrototypeReturnCode, return, ASCIILiteral(), s_wrapForValidIteratorPrototypeReturnCodeLength) \
    macro(regExpPrototypeSearchCode, search, "[Symbol.search]"_s, s_regExpPrototypeSearchCodeLength) \
    macro(stringPrototypeSearchCode, search, ASCIILiteral(), s_stringPrototypeSearchCodeLength) \
    macro(moduleLoaderSetStateToMaxCode, setStateToMax, ASCIILiteral(), s_moduleLoaderSetStateToMaxCodeLength) \
    macro(stringPrototypeSmallCode, small, ASCIILiteral(), s_stringPrototypeSmallCodeLength) \
    macro(arrayPrototypeSomeCode, some, ASCIILiteral(), s_arrayPrototypeSomeCodeLength) \
    macro(jsIteratorPrototypeSomeCode, some, ASCIILiteral(), s_jsIteratorPrototypeSomeCodeLength) \
    macro(typedArrayPrototypeSomeCode, some, ASCIILiteral(), s_typedArrayPrototypeSomeCodeLength) \
    macro(globalOperationsSpeciesConstructorCode, speciesConstructor, ASCIILiteral(), s_globalOperationsSpeciesConstructorCodeLength) \
    macro(regExpPrototypeSplitCode, split, "[Symbol.split]"_s, s_regExpPrototypeSplitCodeLength) \
    macro(stringPrototypeSplitCode, split, ASCIILiteral(), s_stringPrototypeSplitCodeLength) \
    macro(stringPrototypeStrikeCode, strike, ASCIILiteral(), s_stringPrototypeStrikeCodeLength) \
    macro(stringPrototypeStringConcatSlowPathCode, stringConcatSlowPath, ASCIILiteral(), s_stringPrototypeStringConcatSlowPathCodeLength) \
    macro(stringPrototypeSubCode, sub, ASCIILiteral(), s_stringPrototypeSubCodeLength) \
    macro(stringPrototypeSupCode, sup, ASCIILiteral(), s_stringPrototypeSupCodeLength) \
    macro(functionPrototypeSymbolHasInstanceCode, symbolHasInstance, "[Symbol.hasInstance]"_s, s_functionPrototypeSymbolHasInstanceCodeLength) \
    macro(setPrototypeSymmetricDifferenceCode, symmetricDifference, ASCIILiteral(), s_setPrototypeSymmetricDifferenceCodeLength) \
    macro(jsIteratorPrototypeTakeCode, take, ASCIILiteral(), s_jsIteratorPrototypeTakeCodeLength) \
    macro(regExpPrototypeTestCode, test, ASCIILiteral(), s_regExpPrototypeTestCodeLength) \
    macro(promisePrototypeThenCode, then, ASCIILiteral(), s_promisePrototypeThenCodeLength) \
    macro(asyncFromSyncIteratorPrototypeThrowCode, throw, ASCIILiteral(), s_asyncFromSyncIteratorPrototypeThrowCodeLength) \
    macro(asyncGeneratorPrototypeThrowCode, throw, ASCIILiteral(), s_asyncGeneratorPrototypeThrowCodeLength) \
    macro(generatorPrototypeThrowCode, throw, ASCIILiteral(), s_generatorPrototypeThrowCodeLength) \
    macro(typedArrayPrototypeToLocaleStringCode, toLocaleString, ASCIILiteral(), s_typedArrayPrototypeToLocaleStringCodeLength) \
    macro(arrayPrototypeToSortedCode, toSorted, ASCIILiteral(), s_arrayPrototypeToSortedCodeLength) \
    macro(arrayPrototypeToSplicedCode, toSpliced, ASCIILiteral(), s_arrayPrototypeToSplicedCodeLength) \
    macro(promiseOperationsTriggerPromiseReactionsCode, triggerPromiseReactions, ASCIILiteral(), s_promiseOperationsTriggerPromiseReactionsCodeLength) \
    macro(promiseConstructorTryCode, try, ASCIILiteral(), s_promiseConstructorTryCodeLength) \
    macro(typedArrayPrototypeTypedArraySpeciesConstructorCode, typedArraySpeciesConstructor, ASCIILiteral(), s_typedArrayPrototypeTypedArraySpeciesConstructorCodeLength) \
    macro(setPrototypeUnionCode, union, ASCIILiteral(), s_setPrototypeUnionCodeLength) \
    macro(jsIteratorPrototypeWindowsCode, windows, ASCIILiteral(), s_jsIteratorPrototypeWindowsCodeLength) \
    macro(arrayPrototypeWithCode, with, ASCIILiteral(), s_arrayPrototypeWithCodeLength) \
    macro(promiseConstructorWithResolversCode, withResolvers, ASCIILiteral(), s_promiseConstructorWithResolversCodeLength) \
    macro(shadowRealmPrototypeWrapRemoteValueCode, wrapRemoteValue, ASCIILiteral(), s_shadowRealmPrototypeWrapRemoteValueCodeLength) \
    macro(iteratorHelpersWrappedIteratorCode, wrappedIterator, ASCIILiteral(), s_iteratorHelpersWrappedIteratorCodeLength) \

#define JSC_FOREACH_BUILTIN_FUNCTION_NAME(macro) \
    macro(InternalPromise) \
    macro(Promise) \
    macro(advanceStringIndex) \
    macro(all) \
    macro(allSettled) \
    macro(anchor) \
    macro(any) \
    macro(apply) \
    macro(arrayIteratorNextHelper) \
    macro(asyncFromSyncIteratorOnFulfilledContinue) \
    macro(asyncFromSyncIteratorOnFulfilledDone) \
    macro(asyncFromSyncIteratorOnRejected) \
    macro(asyncFunctionResume) \
    macro(asyncFunctionResumeOnFulfilled) \
    macro(asyncFunctionResumeOnRejected) \
    macro(asyncGeneratorEnqueue) \
    macro(asyncGeneratorQueueDequeue) \
    macro(asyncGeneratorQueueEnqueue) \
    macro(asyncGeneratorQueueIsEmpty) \
    macro(asyncGeneratorReject) \
    macro(asyncGeneratorResolve) \
    macro(asyncGeneratorResumeNext) \
    macro(asyncGeneratorResumeNextOnFulfilled) \
    macro(asyncGeneratorResumeNextOnRejected) \
    macro(asyncGeneratorYield) \
    macro(asyncGeneratorYieldAwaited) \
    macro(asyncGeneratorYieldOnRejected) \
    macro(asyncModuleEvaluation) \
    macro(at) \
    macro(awaitValue) \
    macro(big) \
    macro(blink) \
    macro(bold) \
    macro(builtinMapIterable) \
    macro(builtinSetIterable) \
    macro(cacheSatisfy) \
    macro(cacheSatisfyAndReturn) \
    macro(call) \
    macro(catch) \
    macro(chunks) \
    macro(compileStreaming) \
    macro(concat) \
    macro(copyWithin) \
    macro(createArrayWithoutPrototype) \
    macro(createAsyncFromSyncIterator) \
    macro(createHTML) \
    macro(createInspectorInjectedScript) \
    macro(createObjectWithoutPrototype) \
    macro(createResolvingFunctions) \
    macro(createResolvingFunctionsWithoutPromise) \
    macro(crossRealmThrow) \
    macro(defaultAsyncFromAsyncArrayLike) \
    macro(defaultAsyncFromAsyncIterator) \
    macro(deleteProperty) \
    macro(dependencyKeysIfEvaluated) \
    macro(difference) \
    macro(doAsyncGeneratorBodyCall) \
    macro(doAsyncGeneratorBodyCallOnFulfilledNormal) \
    macro(doAsyncGeneratorBodyCallOnFulfilledReturn) \
    macro(drop) \
    macro(ensureRegistered) \
    macro(evaluate) \
    macro(every) \
    macro(filter) \
    macro(finally) \
    macro(find) \
    macro(findIndex) \
    macro(findLast) \
    macro(findLastIndex) \
    macro(fixed) \
    macro(flat) \
    macro(flatIntoArray) \
    macro(flatIntoArrayWithCallback) \
    macro(flatMap) \
    macro(fontcolor) \
    macro(fontsize) \
    macro(forEach) \
    macro(forceFulfillPromise) \
    macro(from) \
    macro(fromAsync) \
    macro(fromEntries) \
    macro(fulfillFetch) \
    macro(fulfillPromise) \
    macro(fulfillPromiseWithFirstResolvingFunctionCallCheck) \
    macro(fulfillWithoutPromise) \
    macro(generatorResume) \
    macro(get) \
    macro(getIteratorFlattenable) \
    macro(getSetSizeAsInt) \
    macro(getSubstitution) \
    macro(groupBy) \
    macro(has) \
    macro(hasObservableSideEffectsForRegExpMatch) \
    macro(hasObservableSideEffectsForRegExpSplit) \
    macro(hasObservableSideEffectsForStringReplace) \
    macro(importValue) \
    macro(includes) \
    macro(instantiateStreaming) \
    macro(internalAll) \
    macro(intersection) \
    macro(isArray) \
    macro(isDisjointFrom) \
    macro(isExecutionState) \
    macro(isFinite) \
    macro(isSubsetOf) \
    macro(isSupersetOf) \
    macro(isSuspendYieldState) \
    macro(italics) \
    macro(link) \
    macro(linkAndEvaluateModule) \
    macro(loadAndEvaluateModule) \
    macro(loadModule) \
    macro(map) \
    macro(match) \
    macro(matchAll) \
    macro(matchSlow) \
    macro(maxWithPositives) \
    macro(minWithMaybeNegativeZeroAndPositive) \
    macro(moduleEvaluation) \
    macro(newHandledRejectedPromise) \
    macro(newPromiseCapability) \
    macro(newPromiseCapabilitySlow) \
    macro(newRegistryEntry) \
    macro(next) \
    macro(of) \
    macro(padEnd) \
    macro(padStart) \
    macro(performIteration) \
    macro(performPromiseThen) \
    macro(performProxyObjectGet) \
    macro(performProxyObjectGetByVal) \
    macro(performProxyObjectHas) \
    macro(performProxyObjectHasByVal) \
    macro(performProxyObjectSetByValSloppy) \
    macro(performProxyObjectSetByValStrict) \
    macro(performProxyObjectSetSloppy) \
    macro(performProxyObjectSetStrict) \
    macro(promiseAllNewResolveElement) \
    macro(promiseAllOnFulfilled) \
    macro(promiseAllSlow) \
    macro(promiseEmptyOnFulfilled) \
    macro(promiseEmptyOnRejected) \
    macro(promiseNewOnRejected) \
    macro(promiseOnRejectedWithContext) \
    macro(promiseReactionJob) \
    macro(promiseReactionJobWithoutPromise) \
    macro(promiseRejectSlow) \
    macro(promiseResolve) \
    macro(promiseResolveSlow) \
    macro(promiseResolveThenableJob) \
    macro(promiseResolveThenableJobFast) \
    macro(promiseResolveThenableJobWithDerivedPromise) \
    macro(promiseResolveThenableJobWithoutPromiseFast) \
    macro(provideFetch) \
    macro(pushNewPromiseReaction) \
    macro(race) \
    macro(raw) \
    macro(reduce) \
    macro(reduceRight) \
    macro(regExpExec) \
    macro(reject) \
    macro(rejectPromise) \
    macro(rejectPromiseWithFirstResolvingFunctionCallCheck) \
    macro(rejectWithoutPromise) \
    macro(repeat) \
    macro(repeatCharactersSlowPath) \
    macro(repeatSlowPath) \
    macro(replace) \
    macro(replaceAll) \
    macro(requestFetch) \
    macro(requestImportModule) \
    macro(requestInstantiate) \
    macro(requestSatisfy) \
    macro(requestSatisfyUtil) \
    macro(resolve) \
    macro(resolvePromise) \
    macro(resolvePromiseWithFirstResolvingFunctionCallCheck) \
    macro(resolveWithoutPromise) \
    macro(resolveWithoutPromiseForAsyncAwait) \
    macro(return) \
    macro(search) \
    macro(setStateToMax) \
    macro(small) \
    macro(some) \
    macro(speciesConstructor) \
    macro(split) \
    macro(strike) \
    macro(stringConcatSlowPath) \
    macro(sub) \
    macro(sup) \
    macro(symbolHasInstance) \
    macro(symmetricDifference) \
    macro(take) \
    macro(test) \
    macro(then) \
    macro(throw) \
    macro(toLocaleString) \
    macro(toSorted) \
    macro(toSpliced) \
    macro(triggerPromiseReactions) \
    macro(try) \
    macro(typedArraySpeciesConstructor) \
    macro(union) \
    macro(windows) \
    macro(with) \
    macro(withResolvers) \
    macro(wrapRemoteValue) \
    macro(wrappedIterator) \

#define JSC_FOREACH_BUILTIN_LINK_TIME_CONSTANT(macro) \
    macro(advanceStringIndex, regExpPrototypeAdvanceStringIndex) \
    macro(arrayIteratorNextHelper, arrayIteratorPrototypeArrayIteratorNextHelper) \
    macro(asyncFromSyncIteratorOnFulfilledContinue, asyncFromSyncIteratorPrototypeAsyncFromSyncIteratorOnFulfilledContinue) \
    macro(asyncFromSyncIteratorOnFulfilledDone, asyncFromSyncIteratorPrototypeAsyncFromSyncIteratorOnFulfilledDone) \
    macro(asyncFromSyncIteratorOnRejected, asyncFromSyncIteratorPrototypeAsyncFromSyncIteratorOnRejected) \
    macro(asyncFunctionResume, asyncFunctionPrototypeAsyncFunctionResume) \
    macro(asyncFunctionResumeOnFulfilled, asyncFunctionPrototypeAsyncFunctionResumeOnFulfilled) \
    macro(asyncFunctionResumeOnRejected, asyncFunctionPrototypeAsyncFunctionResumeOnRejected) \
    macro(asyncGeneratorEnqueue, asyncGeneratorPrototypeAsyncGeneratorEnqueue) \
    macro(asyncGeneratorQueueDequeue, asyncGeneratorPrototypeAsyncGeneratorQueueDequeue) \
    macro(asyncGeneratorQueueEnqueue, asyncGeneratorPrototypeAsyncGeneratorQueueEnqueue) \
    macro(asyncGeneratorQueueIsEmpty, asyncGeneratorPrototypeAsyncGeneratorQueueIsEmpty) \
    macro(asyncGeneratorReject, asyncGeneratorPrototypeAsyncGeneratorReject) \
    macro(asyncGeneratorResolve, asyncGeneratorPrototypeAsyncGeneratorResolve) \
    macro(asyncGeneratorResumeNext, asyncGeneratorPrototypeAsyncGeneratorResumeNext) \
    macro(asyncGeneratorResumeNextOnFulfilled, asyncGeneratorPrototypeAsyncGeneratorResumeNextOnFulfilled) \
    macro(asyncGeneratorResumeNextOnRejected, asyncGeneratorPrototypeAsyncGeneratorResumeNextOnRejected) \
    macro(asyncGeneratorYield, asyncGeneratorPrototypeAsyncGeneratorYield) \
    macro(asyncGeneratorYieldAwaited, asyncGeneratorPrototypeAsyncGeneratorYieldAwaited) \
    macro(asyncGeneratorYieldOnRejected, asyncGeneratorPrototypeAsyncGeneratorYieldOnRejected) \
    macro(awaitValue, asyncGeneratorPrototypeAwaitValue) \
    macro(builtinMapIterable, iteratorHelpersBuiltinMapIterable) \
    macro(builtinSetIterable, iteratorHelpersBuiltinSetIterable) \
    macro(cacheSatisfy, moduleLoaderCacheSatisfy) \
    macro(cacheSatisfyAndReturn, moduleLoaderCacheSatisfyAndReturn) \
    macro(createArrayWithoutPrototype, injectedScriptSourceCreateArrayWithoutPrototype) \
    macro(createAsyncFromSyncIterator, asyncFromSyncIteratorPrototypeCreateAsyncFromSyncIterator) \
    macro(createHTML, stringPrototypeCreateHTML) \
    macro(createInspectorInjectedScript, injectedScriptSourceCreateInspectorInjectedScript) \
    macro(createObjectWithoutPrototype, injectedScriptSourceCreateObjectWithoutPrototype) \
    macro(createResolvingFunctions, promiseOperationsCreateResolvingFunctions) \
    macro(createResolvingFunctionsWithoutPromise, promiseOperationsCreateResolvingFunctionsWithoutPromise) \
    macro(crossRealmThrow, shadowRealmPrototypeCrossRealmThrow) \
    macro(defaultAsyncFromAsyncArrayLike, arrayConstructorDefaultAsyncFromAsyncArrayLike) \
    macro(defaultAsyncFromAsyncIterator, arrayConstructorDefaultAsyncFromAsyncIterator) \
    macro(doAsyncGeneratorBodyCall, asyncGeneratorPrototypeDoAsyncGeneratorBodyCall) \
    macro(doAsyncGeneratorBodyCallOnFulfilledNormal, asyncGeneratorPrototypeDoAsyncGeneratorBodyCallOnFulfilledNormal) \
    macro(doAsyncGeneratorBodyCallOnFulfilledReturn, asyncGeneratorPrototypeDoAsyncGeneratorBodyCallOnFulfilledReturn) \
    macro(flatIntoArray, arrayPrototypeFlatIntoArray) \
    macro(flatIntoArrayWithCallback, arrayPrototypeFlatIntoArrayWithCallback) \
    macro(forceFulfillPromise, moduleLoaderForceFulfillPromise) \
    macro(fulfillFetch, moduleLoaderFulfillFetch) \
    macro(fulfillPromise, promiseOperationsFulfillPromise) \
    macro(fulfillPromiseWithFirstResolvingFunctionCallCheck, promiseOperationsFulfillPromiseWithFirstResolvingFunctionCallCheck) \
    macro(fulfillWithoutPromise, promiseOperationsFulfillWithoutPromise) \
    macro(generatorResume, generatorPrototypeGeneratorResume) \
    macro(getIteratorFlattenable, jsIteratorConstructorGetIteratorFlattenable) \
    macro(getSetSizeAsInt, setPrototypeGetSetSizeAsInt) \
    macro(getSubstitution, regExpPrototypeGetSubstitution) \
    macro(hasObservableSideEffectsForRegExpMatch, regExpPrototypeHasObservableSideEffectsForRegExpMatch) \
    macro(hasObservableSideEffectsForRegExpSplit, regExpPrototypeHasObservableSideEffectsForRegExpSplit) \
    macro(hasObservableSideEffectsForStringReplace, stringPrototypeHasObservableSideEffectsForStringReplace) \
    macro(isExecutionState, asyncGeneratorPrototypeIsExecutionState) \
    macro(isFinite, globalObjectIsFinite) \
    macro(isSuspendYieldState, asyncGeneratorPrototypeIsSuspendYieldState) \
    macro(matchSlow, regExpPrototypeMatchSlow) \
    macro(maxWithPositives, arrayPrototypeMaxWithPositives) \
    macro(minWithMaybeNegativeZeroAndPositive, arrayPrototypeMinWithMaybeNegativeZeroAndPositive) \
    macro(newHandledRejectedPromise, promiseOperationsNewHandledRejectedPromise) \
    macro(newPromiseCapability, promiseOperationsNewPromiseCapability) \
    macro(newPromiseCapabilitySlow, promiseOperationsNewPromiseCapabilitySlow) \
    macro(newRegistryEntry, moduleLoaderNewRegistryEntry) \
    macro(performIteration, iteratorHelpersPerformIteration) \
    macro(performPromiseThen, promiseOperationsPerformPromiseThen) \
    macro(performProxyObjectGet, proxyHelpersPerformProxyObjectGet) \
    macro(performProxyObjectGetByVal, proxyHelpersPerformProxyObjectGetByVal) \
    macro(performProxyObjectHas, proxyHelpersPerformProxyObjectHas) \
    macro(performProxyObjectHasByVal, proxyHelpersPerformProxyObjectHasByVal) \
    macro(performProxyObjectSetByValSloppy, proxyHelpersPerformProxyObjectSetByValSloppy) \
    macro(performProxyObjectSetByValStrict, proxyHelpersPerformProxyObjectSetByValStrict) \
    macro(performProxyObjectSetSloppy, proxyHelpersPerformProxyObjectSetSloppy) \
    macro(performProxyObjectSetStrict, proxyHelpersPerformProxyObjectSetStrict) \
    macro(promiseAllNewResolveElement, promiseConstructorPromiseAllNewResolveElement) \
    macro(promiseAllOnFulfilled, promiseConstructorPromiseAllOnFulfilled) \
    macro(promiseAllSlow, promiseConstructorPromiseAllSlow) \
    macro(promiseEmptyOnFulfilled, promiseOperationsPromiseEmptyOnFulfilled) \
    macro(promiseEmptyOnRejected, promiseOperationsPromiseEmptyOnRejected) \
    macro(promiseNewOnRejected, promiseConstructorPromiseNewOnRejected) \
    macro(promiseOnRejectedWithContext, promiseConstructorPromiseOnRejectedWithContext) \
    macro(promiseReactionJob, promiseOperationsPromiseReactionJob) \
    macro(promiseReactionJobWithoutPromise, promiseOperationsPromiseReactionJobWithoutPromise) \
    macro(promiseRejectSlow, promiseOperationsPromiseRejectSlow) \
    macro(promiseResolve, promiseOperationsPromiseResolve) \
    macro(promiseResolveSlow, promiseOperationsPromiseResolveSlow) \
    macro(promiseResolveThenableJob, promiseOperationsPromiseResolveThenableJob) \
    macro(promiseResolveThenableJobFast, promiseOperationsPromiseResolveThenableJobFast) \
    macro(promiseResolveThenableJobWithDerivedPromise, promiseOperationsPromiseResolveThenableJobWithDerivedPromise) \
    macro(promiseResolveThenableJobWithoutPromiseFast, promiseOperationsPromiseResolveThenableJobWithoutPromiseFast) \
    macro(pushNewPromiseReaction, promiseOperationsPushNewPromiseReaction) \
    macro(regExpExec, regExpPrototypeRegExpExec) \
    macro(rejectPromise, promiseOperationsRejectPromise) \
    macro(rejectPromiseWithFirstResolvingFunctionCallCheck, promiseOperationsRejectPromiseWithFirstResolvingFunctionCallCheck) \
    macro(rejectWithoutPromise, promiseOperationsRejectWithoutPromise) \
    macro(repeatCharactersSlowPath, stringPrototypeRepeatCharactersSlowPath) \
    macro(repeatSlowPath, stringPrototypeRepeatSlowPath) \
    macro(resolvePromise, promiseOperationsResolvePromise) \
    macro(resolvePromiseWithFirstResolvingFunctionCallCheck, promiseOperationsResolvePromiseWithFirstResolvingFunctionCallCheck) \
    macro(resolveWithoutPromise, promiseOperationsResolveWithoutPromise) \
    macro(resolveWithoutPromiseForAsyncAwait, promiseOperationsResolveWithoutPromiseForAsyncAwait) \
    macro(setStateToMax, moduleLoaderSetStateToMax) \
    macro(speciesConstructor, globalOperationsSpeciesConstructor) \
    macro(stringConcatSlowPath, stringPrototypeStringConcatSlowPath) \
    macro(triggerPromiseReactions, promiseOperationsTriggerPromiseReactions) \
    macro(typedArraySpeciesConstructor, typedArrayPrototypeTypedArraySpeciesConstructor) \
    macro(wrapRemoteValue, shadowRealmPrototypeWrapRemoteValue) \
    macro(wrappedIterator, iteratorHelpersWrappedIterator) \

#define DECLARE_BUILTIN_GENERATOR(codeName, functionName, overriddenName, argumentCount) \
    JSC::FunctionExecutable* codeName##Generator(JSC::VM&);

JSC_FOREACH_BUILTIN_CODE(DECLARE_BUILTIN_GENERATOR)
#undef DECLARE_BUILTIN_GENERATOR

} // namespace JSC
