/*
 * Copyright (C) 2013, 2015 Apple Inc. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY APPLE INC. AND ITS CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL APPLE INC. OR ITS CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

WI.FrameDOMTreeContentView = class FrameDOMTreeContentView extends WI.DOMTreeContentView
{
    constructor(domTree)
    {
        console.assert(domTree instanceof WI.DOMTree, domTree);

        super(domTree);

        this._domTree = domTree;
        this._domTree.addEventListener(WI.DOMTree.Event.RootDOMNodeInvalidated, this._rootDOMNodeInvalidated, this);

        this._requestRootDOMNode();
    }

    // Public

    get domTree()
    {
        return this._domTree;
    }

    closed()
    {
        this._domTree.removeEventListener(null, null, this);

        super.closed();
    }

    getSearchContextNodes(callback)
    {
        this._domTree.requestRootDOMNode(function(rootDOMNode) {
            callback([rootDOMNode.id]);
        });
    }

    // Private

    _rootDOMNodeAvailable(rootDOMNode)
    {
        this.domTreeOutline.rootDOMNode = rootDOMNode;

        if (!rootDOMNode) {
            this.domTreeOutline.selectDOMNode(null, false);
            return;
        }

        this._restoreBreakpointsAfterUpdate();
        this._restoreSelectedNodeAfterUpdate(this._domTree.frame.url, rootDOMNode.body || rootDOMNode.documentElement || rootDOMNode.firstChild);
    }

    _rootDOMNodeInvalidated(event)
    {
        this._requestRootDOMNode();
    }

    _requestRootDOMNode()
    {
        this._domTree.requestRootDOMNode(this._rootDOMNodeAvailable.bind(this));
    }
};
