/*
 * Decompiled with CFR 0.152.
 */
package org.jline.builtins;

import java.io.File;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;

public interface Source {
    public String getName();

    public InputStream read() throws IOException;

    public static class StdInSource
    implements Source {
        @Override
        public String getName() {
            return null;
        }

        @Override
        public InputStream read() throws IOException {
            return new FilterInputStream(System.in){

                @Override
                public void close() throws IOException {
                }
            };
        }
    }

    public static class PathSource
    implements Source {
        final Path path;
        final String name;

        public PathSource(File file, String name) {
            this.path = file.toPath();
            this.name = name;
        }

        public PathSource(Path path, String name) {
            this.path = path;
            this.name = name;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public InputStream read() throws IOException {
            return Files.newInputStream(this.path, new OpenOption[0]);
        }
    }

    public static class URLSource
    implements Source {
        final URL url;
        final String name;

        public URLSource(URL url, String name) {
            this.url = url;
            this.name = name;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public InputStream read() throws IOException {
            return this.url.openStream();
        }
    }
}

