/*
 * Decompiled with CFR 0.152.
 */
package gnu.math;

import gnu.math.CComplex;
import gnu.math.DComplex;
import gnu.math.DFloNum;
import gnu.math.IntNum;
import gnu.math.Numeric;
import gnu.math.Quantity;
import gnu.math.RealNum;

public abstract class Complex
extends Quantity {
    private static CComplex imOne;
    private static CComplex imMinusOne;

    public Complex number() {
        return this;
    }

    public boolean isExact() {
        return this.re().isExact() && this.im().isExact();
    }

    public static CComplex imOne() {
        if (imOne == null) {
            imOne = new CComplex(IntNum.zero(), IntNum.one());
        }
        return imOne;
    }

    public static CComplex imMinusOne() {
        if (imMinusOne == null) {
            imMinusOne = new CComplex(IntNum.zero(), IntNum.minusOne());
        }
        return imMinusOne;
    }

    public double doubleValue() {
        return this.re().doubleValue();
    }

    public double doubleImagValue() {
        return this.im().doubleValue();
    }

    public final double doubleRealValue() {
        return this.doubleValue();
    }

    public long longValue() {
        return this.re().longValue();
    }

    public static Complex make(RealNum realNum, RealNum realNum2) {
        if (realNum2.isZero()) {
            return realNum;
        }
        if (!realNum.isExact() || !realNum2.isExact()) {
            return new DComplex(realNum.doubleValue(), realNum2.doubleValue());
        }
        return new CComplex(realNum, realNum2);
    }

    public static Complex make(double d, double d2) {
        if (d2 == 0.0) {
            return new DFloNum(d);
        }
        return new DComplex(d, d2);
    }

    public static DComplex polar(double d, double d2) {
        return new DComplex(d * Math.cos(d2), d * Math.sin(d2));
    }

    public static DComplex polar(RealNum realNum, RealNum realNum2) {
        return Complex.polar(realNum.doubleValue(), realNum2.doubleValue());
    }

    public static Complex power(Complex complex, Complex complex2) {
        if (complex2 instanceof IntNum) {
            return (Complex)complex.power((IntNum)complex2);
        }
        double d = complex.doubleRealValue();
        double d2 = complex.doubleImagValue();
        double d3 = complex2.doubleRealValue();
        double d4 = complex2.doubleImagValue();
        if (d2 == 0.0 && d4 == 0.0 && (d >= 0.0 || Double.isInfinite(d) || Double.isNaN(d))) {
            return new DFloNum(Math.pow(d, d3));
        }
        return DComplex.power(d, d2, d3, d4);
    }

    public Numeric abs() {
        return new DFloNum(Math.hypot(this.doubleRealValue(), this.doubleImagValue()));
    }

    public RealNum angle() {
        return new DFloNum(Math.atan2(this.doubleImagValue(), this.doubleRealValue()));
    }

    public static boolean equals(Complex complex, Complex complex2) {
        return complex.re().equals(complex2.re()) && complex.im().equals(complex.im());
    }

    public boolean equals(Object object2) {
        if (object2 == null || !(object2 instanceof Complex)) {
            return false;
        }
        return Complex.equals(this, (Complex)object2);
    }

    public static int compare(Complex complex, Complex complex2) {
        int n = complex.im().compare(complex2.im());
        if (n != 0) {
            return n;
        }
        return complex.re().compare(complex2.re());
    }

    public int compare(Object object2) {
        if (!(object2 instanceof Complex)) {
            return ((Numeric)object2).compareReversed(this);
        }
        return Complex.compare(this, (Complex)object2);
    }

    public boolean isZero() {
        return this.re().isZero() && this.im().isZero();
    }

    public String toString(int n) {
        if (this.im().isZero()) {
            return this.re().toString(n);
        }
        String string = this.im().toString(n) + "i";
        if (string.charAt(0) != '-') {
            string = "+" + string;
        }
        if (this.re().isZero()) {
            return string;
        }
        return this.re().toString(n) + string;
    }

    public static Complex neg(Complex complex) {
        return Complex.make(complex.re().rneg(), complex.im().rneg());
    }

    public Numeric neg() {
        return Complex.neg(this);
    }

    public static Complex add(Complex complex, Complex complex2, int n) {
        return Complex.make(RealNum.add(complex.re(), complex2.re(), n), RealNum.add(complex.im(), complex2.im(), n));
    }

    public Numeric add(Object object2, int n) {
        if (object2 instanceof Complex) {
            return Complex.add(this, (Complex)object2, n);
        }
        return ((Numeric)object2).addReversed(this, n);
    }

    public Numeric addReversed(Numeric numeric, int n) {
        if (numeric instanceof Complex) {
            return Complex.add((Complex)numeric, this, n);
        }
        throw new IllegalArgumentException();
    }

    public static Complex times(Complex complex, Complex complex2) {
        RealNum realNum = complex.re();
        RealNum realNum2 = complex.im();
        RealNum realNum3 = complex2.re();
        RealNum realNum4 = complex2.im();
        return Complex.make(RealNum.add(RealNum.times(realNum, realNum3), RealNum.times(realNum2, realNum4), -1), RealNum.add(RealNum.times(realNum, realNum4), RealNum.times(realNum2, realNum3), 1));
    }

    public Numeric mul(Object object2) {
        if (object2 instanceof Complex) {
            return Complex.times(this, (Complex)object2);
        }
        return ((Numeric)object2).mulReversed(this);
    }

    public Numeric mulReversed(Numeric numeric) {
        if (numeric instanceof Complex) {
            return Complex.times((Complex)numeric, this);
        }
        throw new IllegalArgumentException();
    }

    public static Complex divide(Complex complex, Complex complex2) {
        if (!complex.isExact() || !complex2.isExact()) {
            return DComplex.div(complex.doubleRealValue(), complex.doubleImagValue(), complex2.doubleRealValue(), complex2.doubleImagValue());
        }
        RealNum realNum = complex.re();
        RealNum realNum2 = complex.im();
        RealNum realNum3 = complex2.re();
        RealNum realNum4 = complex2.im();
        RealNum realNum5 = RealNum.add(RealNum.times(realNum3, realNum3), RealNum.times(realNum4, realNum4), 1);
        RealNum realNum6 = RealNum.add(RealNum.times(realNum, realNum3), RealNum.times(realNum2, realNum4), 1);
        RealNum realNum7 = RealNum.add(RealNum.times(realNum2, realNum3), RealNum.times(realNum, realNum4), -1);
        return Complex.make(RealNum.divide(realNum6, realNum5), RealNum.divide(realNum7, realNum5));
    }

    public Numeric div(Object object2) {
        if (object2 instanceof Complex) {
            return Complex.divide(this, (Complex)object2);
        }
        return ((Numeric)object2).divReversed(this);
    }

    public Numeric divReversed(Numeric numeric) {
        if (numeric instanceof Complex) {
            return Complex.divide((Complex)numeric, this);
        }
        throw new IllegalArgumentException();
    }

    public Complex exp() {
        return Complex.polar(Math.exp(this.doubleRealValue()), this.doubleImagValue());
    }

    public Complex log() {
        return DComplex.log(this.doubleRealValue(), this.doubleImagValue());
    }

    public Complex sqrt() {
        return DComplex.sqrt(this.doubleRealValue(), this.doubleImagValue());
    }
}

