/*
 * Decompiled with CFR 0.152.
 */
package gnu.expr;

import gnu.bytecode.ClassType;
import gnu.bytecode.Field;
import gnu.expr.ApplyExp;
import gnu.expr.CanInline;
import gnu.expr.ClassExp;
import gnu.expr.Compilation;
import gnu.expr.Declaration;
import gnu.expr.ExpWalker;
import gnu.expr.Expression;
import gnu.expr.IfExp;
import gnu.expr.Interpreter;
import gnu.expr.LambdaExp;
import gnu.expr.PrimProcedure;
import gnu.expr.QuoteExp;
import gnu.expr.ReferenceExp;
import gnu.expr.SetExp;
import gnu.kawa.reflect.Invoke;
import gnu.mapping.Procedure;
import gnu.mapping.Symbol;
import gnu.mapping.WrongArguments;

public class InlineCalls
extends ExpWalker {
    Compilation comp;

    public Compilation getCompilation() {
        return this.comp;
    }

    public static void inlineCalls(Expression expression, Compilation compilation) {
        InlineCalls inlineCalls = new InlineCalls();
        inlineCalls.comp = compilation;
        inlineCalls.messages = compilation.getMessages();
        inlineCalls.walk(expression);
    }

    Expression rewriteToInvocation(Symbol symbol, ApplyExp applyExp) {
        Invoke invoke;
        String string;
        Expression[] expressionArray = applyExp.args;
        String string2 = symbol.getNamespaceURI();
        if (string2 == null || !string2.startsWith("class:")) {
            return null;
        }
        String string3 = string2.substring(6);
        String string4 = symbol.getName();
        ClassType classType = ClassType.make("gnu.kawa.reflect.Invoke");
        boolean bl = string4.equals("new");
        if (bl) {
            string = "make";
            invoke = Invoke.make;
        } else {
            string = "invokeStatic";
            invoke = Invoke.invokeStatic;
        }
        Field field = classType.getDeclaredField(string);
        Declaration declaration = new Declaration((Object)"invoke", field);
        declaration.noteValue(new QuoteExp(invoke));
        declaration.setFlag(16384);
        Expression[] expressionArray2 = new Expression[expressionArray.length + (bl ? 1 : 2)];
        System.arraycopy(expressionArray, 0, expressionArray2, bl ? 1 : 2, expressionArray.length);
        expressionArray2[0] = new QuoteExp(string3);
        if (!bl) {
            expressionArray2[1] = new QuoteExp(string4);
        }
        expressionArray = expressionArray2;
        ApplyExp applyExp2 = new ApplyExp(new ReferenceExp(declaration), expressionArray);
        applyExp2.setLine(applyExp);
        return invoke.inline(applyExp2, this);
    }

    protected Expression walkApplyExp(ApplyExp applyExp) {
        Object object2;
        Object object3;
        super.walkApplyExp(applyExp);
        LambdaExp lambdaExp = null;
        int n = applyExp.getArgCount();
        if (applyExp.func instanceof LambdaExp) {
            lambdaExp = (LambdaExp)applyExp.func;
        }
        Expression expression = applyExp.func;
        Declaration declaration = null;
        if (expression instanceof ReferenceExp) {
            object3 = (ReferenceExp)expression;
            declaration = ((ReferenceExp)object3).binding;
            if (declaration != null && !declaration.getFlag(65536)) {
                expression = declaration.getValue();
                if (expression instanceof LambdaExp) {
                    lambdaExp = (LambdaExp)expression;
                }
            } else if (((ReferenceExp)object3).getSymbol() instanceof Symbol && (object2 = this.rewriteToInvocation((Symbol)((ReferenceExp)object3).getSymbol(), applyExp)) != null) {
                return object2;
            }
        }
        if (expression instanceof QuoteExp) {
            PrimProcedure primProcedure;
            object3 = ((QuoteExp)expression).getValue();
            if (!(object3 instanceof Procedure)) {
                return this.noteError(declaration == null ? "called value is not a procedure" : "calling " + declaration.getName() + " which is not a procedure");
            }
            object2 = (Procedure)object3;
            String string = WrongArguments.checkArgCount((Procedure)object2, n);
            if (string != null) {
                return this.noteError(string);
            }
            if (object2 instanceof CanInline) {
                return ((CanInline)object2).inline(applyExp, this);
            }
            if (this.comp.inlineOk((Procedure)object2) && (primProcedure = PrimProcedure.getMethodFor((Procedure)object2, declaration, applyExp.args, this.comp.getInterpreter())) != null) {
                ApplyExp applyExp2;
                if (primProcedure.getStaticFlag()) {
                    applyExp2 = new ApplyExp(primProcedure, applyExp.args);
                } else {
                    Expression[] expressionArray = new Expression[1 + n];
                    System.arraycopy(applyExp.getArgs(), 0, expressionArray, 1, n);
                    expressionArray[0] = new ReferenceExp(declaration.base);
                    applyExp2 = new ApplyExp(primProcedure, expressionArray);
                }
                return applyExp2.setLine(applyExp);
            }
        }
        if (lambdaExp != null) {
            int n2 = applyExp.args.length;
            object2 = WrongArguments.checkArgCount(lambdaExp.getName(), lambdaExp.min_args, lambdaExp.max_args, n2);
            if (object2 != null) {
                return this.noteError((String)object2);
            }
        }
        return applyExp;
    }

    protected Expression walkIfExp(IfExp ifExp) {
        ifExp.walkChildren(this);
        Expression expression = ifExp.test;
        if (expression instanceof QuoteExp) {
            Interpreter interpreter = this.comp.getInterpreter();
            if (interpreter.isTrue(((QuoteExp)expression).getValue())) {
                return ifExp.then_clause;
            }
            return ifExp.else_clause;
        }
        return ifExp;
    }

    protected Expression walkSetExp(SetExp setExp) {
        Expression expression;
        Declaration declaration = setExp.binding;
        boolean bl = false;
        if (declaration != null && (expression = declaration.getValue()) == setExp.new_value) {
            bl = true;
        }
        setExp.walkChildren(this);
        if (bl) {
            declaration.value = setExp.new_value;
            if (setExp.new_value instanceof LambdaExp) {
                ((LambdaExp)setExp.new_value).nameDecl = declaration;
            }
        }
        return setExp;
    }

    protected Expression walkClassExp(ClassExp classExp) {
        classExp.getCompiledClassType(this.comp);
        this.comp.addClass(classExp.type);
        if (classExp.isMakingClassPair()) {
            classExp.instanceType.setName(classExp.type.getName() + "$class");
            this.comp.addClass(classExp.instanceType);
        }
        return super.walkClassExp(classExp);
    }
}

