/*
 * Decompiled with CFR 0.152.
 */
package gnu.bytecode;

import gnu.bytecode.Access;
import gnu.bytecode.AttrContainer;
import gnu.bytecode.Attribute;
import gnu.bytecode.ClassType;
import gnu.bytecode.CpoolEntry;
import gnu.bytecode.Field;
import gnu.bytecode.Method;
import gnu.bytecode.Type;
import java.io.PrintStream;
import java.io.PrintWriter;

public class ClassTypeWriter
extends PrintWriter {
    ClassType ctype;
    int flags;
    boolean printConstants = true;

    public ClassTypeWriter(ClassType classType, PrintWriter printWriter, int n) {
        super(printWriter);
        this.ctype = classType;
        this.flags = n;
    }

    public ClassTypeWriter(ClassType classType, PrintStream printStream, int n) {
        super(printStream);
        this.ctype = classType;
        this.flags = n;
    }

    public static void print(ClassType classType, PrintWriter printWriter, int n) {
        ClassTypeWriter classTypeWriter = new ClassTypeWriter(classType, printWriter, n);
        classTypeWriter.print();
        classTypeWriter.flush();
    }

    public static void print(ClassType classType, PrintStream printStream, int n) {
        ClassTypeWriter classTypeWriter = new ClassTypeWriter(classType, printStream, n);
        classTypeWriter.print();
        classTypeWriter.flush();
    }

    public void print() {
        if (this.printConstants) {
            this.printConstantPool();
        }
        this.printClassInfo();
        this.printFields();
        this.printMethods();
    }

    public void printAttributes(AttrContainer attrContainer) {
        Attribute attribute = attrContainer.getAttributes();
        while (attribute != null) {
            attribute.print(this);
            attribute = attribute.next;
        }
    }

    void printClassInfo() {
        this.println();
        this.print("Access flags:");
        int n = this.ctype.getModifiers();
        this.print(Access.toString(n, 'C'));
        this.println();
        this.print("This class: ");
        this.printOptionalIndex(this.ctype.thisClassIndex);
        this.printConstantTersely(this.ctype.thisClassIndex, 7);
        this.print(" super: ");
        if (this.ctype.superClassIndex == -1) {
            this.print("<unknown>");
        } else if (this.ctype.superClassIndex == 0) {
            this.print("0");
        } else {
            this.printOptionalIndex(this.ctype.superClassIndex);
            this.printConstantTersely(this.ctype.superClassIndex, 7);
        }
        this.println();
        this.print("Interfaces (count: ");
        int[] nArray = this.ctype.interfaceIndexes;
        int n2 = nArray == null ? 0 : nArray.length;
        this.print(n2);
        this.print("):");
        this.println();
        for (int i = 0; i < n2; ++i) {
            this.print("- Implements: ");
            int n3 = nArray[i];
            this.printOptionalIndex(n3);
            this.printConstantTersely(n3, 7);
            this.println();
        }
    }

    public final void printFields() {
        this.println();
        this.print("Fields (count: ");
        this.print(this.ctype.fields_count);
        this.print("):");
        this.println();
        int n = 0;
        Field field = this.ctype.fields;
        while (field != null) {
            this.print("Field name: ");
            if (field.name_index != 0) {
                this.printOptionalIndex(field.name_index);
            }
            this.print(field.getName());
            this.print(Access.toString(field.flags, 'F'));
            this.print(" Signature: ");
            if (field.signature_index != 0) {
                this.printOptionalIndex(field.signature_index);
            }
            this.printSignature(field.type);
            this.println();
            this.printAttributes(field);
            ++n;
            field = field.next;
        }
    }

    void printMethods() {
        this.println();
        this.print("Methods (count: ");
        this.print(this.ctype.methods_count);
        this.print("):");
        this.println();
        Method method = this.ctype.methods;
        while (method != null) {
            this.println();
            this.print("Method name:");
            if (method.name_index != 0) {
                this.printOptionalIndex(method.name_index);
            }
            this.print('\"');
            this.print(method.getName());
            this.print('\"');
            this.print(Access.toString(method.access_flags, 'M'));
            this.print(" Signature: ");
            if (method.signature_index != 0) {
                this.printOptionalIndex(method.signature_index);
            }
            this.print('(');
            for (int i = 0; i < method.arg_types.length; ++i) {
                if (i > 0) {
                    this.print(',');
                }
                this.printSignature(method.arg_types[i]);
            }
            this.print(')');
            this.printSignature(method.return_type);
            this.println();
            this.printAttributes(method);
            method = method.next;
        }
    }

    final void printConstantTersely(int n, int n2) {
        CpoolEntry cpoolEntry;
        CpoolEntry[] cpoolEntryArray = this.ctype.constants.pool;
        if (cpoolEntryArray == null || n < 0 || n >= cpoolEntryArray.length || (cpoolEntry = cpoolEntryArray[n]) == null) {
            this.print("<invalid constant index>");
        } else if (cpoolEntry.getTag() != n2) {
            this.print("<unexpected constant type ");
            cpoolEntry.print(this, 1);
            this.print('>');
        } else {
            cpoolEntry.print(this, 0);
        }
    }

    final void printConstantOperand(int n) {
        CpoolEntry cpoolEntry;
        CpoolEntry[] cpoolEntryArray;
        this.print(' ');
        if (this.printConstants) {
            this.print('#');
            this.print(n);
            this.print('=');
        }
        if ((cpoolEntryArray = this.ctype.constants.pool) == null || n < 0 || n >= cpoolEntryArray.length || (cpoolEntry = cpoolEntryArray[n]) == null) {
            this.print("<invalid constant index>");
        } else {
            this.print('<');
            cpoolEntry.print(this, 1);
            this.print('>');
        }
    }

    public final void printQuotedString(String string) {
        this.print('\"');
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c == '\"') {
                this.print("\\\"");
                continue;
            }
            if (c >= ' ' && c < '\u007f') {
                this.print(c);
                continue;
            }
            if (c == '\n') {
                this.print("\\n");
                continue;
            }
            this.print("\\u");
            int n2 = 4;
            while (--n2 >= 0) {
                this.print(Character.forDigit(c >> n2 * 4 & 0xF, 16));
            }
        }
        this.print('\"');
    }

    public final void printConstantPool() {
        CpoolEntry[] cpoolEntryArray = this.ctype.constants.pool;
        int n = this.ctype.constants.count;
        for (int i = 1; i <= n; ++i) {
            CpoolEntry cpoolEntry = cpoolEntryArray[i];
            if (cpoolEntry == null) continue;
            this.print('#');
            this.print(cpoolEntry.index);
            this.print(": ");
            cpoolEntry.print(this, 2);
            this.println();
        }
    }

    public final void printOptionalIndex(int n) {
        if (this.printConstants) {
            this.print(n);
            this.print('=');
        }
    }

    public final void printOptionalIndex(CpoolEntry cpoolEntry) {
        this.printOptionalIndex(cpoolEntry.index);
    }

    void printName(String string) {
        this.print(string);
    }

    public final int printSignature(String string, int n) {
        String string2;
        int n2 = string.length();
        if (n >= n2) {
            this.print("<empty signature>");
            return n;
        }
        int n3 = Type.signatureLength(string, n);
        if (n3 > 0 && (string2 = Type.signatureToName(string.substring(n, n + n3))) != null) {
            this.print(string2);
            return n + n3;
        }
        char c = string.charAt(n);
        if (c != '(') {
            this.print(c);
            return n + 1;
        }
        int n4 = 0;
        ++n;
        this.print(c);
        while (true) {
            if (n >= n2) {
                this.print("<truncated method signature>");
                return n;
            }
            c = string.charAt(n);
            if (c == ')') break;
            if (n4++ > 0) {
                this.print(',');
            }
            n = this.printSignature(string, n);
        }
        this.print(c);
        return this.printSignature(string, ++n);
    }

    public final void printSignature(String string) {
        int n;
        int n2 = this.printSignature(string, 0);
        if (n2 < (n = string.length())) {
            this.print("<trailing junk:");
            this.print(string.substring(n2));
            this.print('>');
        }
    }

    public final void printSignature(Type type) {
        if (type == null) {
            this.print("<unknown type>");
        } else {
            this.printSignature(type.getSignature());
        }
    }
}

