/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.generator.layout.fillCell;

import com.sun.electric.database.EditingPreferences;
import com.sun.electric.database.geometry.EPoint;
import com.sun.electric.database.geometry.ERectangle;
import com.sun.electric.database.geometry.GeometryHandler;
import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.geometry.PolyBase;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.hierarchy.HierarchyEnumerator;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.hierarchy.Nodable;
import com.sun.electric.database.network.Netlist;
import com.sun.electric.database.network.Network;
import com.sun.electric.database.prototype.NodeProto;
import com.sun.electric.database.prototype.PortCharacteristic;
import com.sun.electric.database.prototype.PortProto;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.Connection;
import com.sun.electric.database.topology.Geometric;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.database.variable.VarContext;
import com.sun.electric.technology.ArcProto;
import com.sun.electric.technology.Layer;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.PrimitivePort;
import com.sun.electric.technology.Technology;
import com.sun.electric.technology.technologies.Generic;
import com.sun.electric.tool.extract.LayerCoverageTool;
import com.sun.electric.tool.generator.layout.LayoutLib;
import com.sun.electric.tool.generator.layout.TechType;
import com.sun.electric.tool.generator.layout.fill.FillGenConfig;
import com.sun.electric.tool.generator.layout.fill.FillGenJob;
import com.sun.electric.tool.generator.layout.fill.FillGeneratorTool;
import com.sun.electric.tool.generator.layout.fill.G;
import com.sun.electric.tool.generator.layout.fill.VddGndStraps;
import com.sun.electric.tool.generator.layout.fillCell.FillCellTool;
import com.sun.electric.tool.routing.InteractiveRouter;
import com.sun.electric.tool.routing.Route;
import com.sun.electric.tool.routing.Router;
import com.sun.electric.tool.routing.Routing;
import com.sun.electric.tool.routing.SimpleWirer;
import com.sun.electric.tool.routing.seaOfGates.SeaOfGatesEngine;
import com.sun.electric.tool.routing.seaOfGates.SeaOfGatesEngineFactory;
import com.sun.electric.tool.routing.seaOfGates.SeaOfGatesHandlers;
import com.sun.electric.util.math.DBMath;
import com.sun.electric.util.math.FixpRectangle;
import com.sun.electric.util.math.FixpTransform;
import com.sun.electric.util.math.GenMath;
import java.awt.geom.Area;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class FillCellGenJob
extends FillGenJob {
    public FillCellGenJob(Cell cell, FillGenConfig gen, boolean doItNow, LayerCoverageTool.LayerCoveragePreferences lcp) {
        super(cell, gen, doItNow, lcp);
    }

    public static Layer getMetalLayerFromExport(PortProto ex) {
        PortProto po = ex;
        if (ex instanceof Export) {
            PortInst pi = ((Export)ex).getOriginalPort();
            po = pi.getPortProto();
        }
        if (po instanceof Export) {
            return FillCellGenJob.getMetalLayerFromExport(po);
        }
        if (po instanceof PrimitivePort) {
            PrimitivePort pp = (PrimitivePort)po;
            PrimitiveNode node = pp.getParent();
            Iterator<Layer> it = node.getLayerIterator();
            while (it.hasNext()) {
                Layer layer = it.next();
                Layer.Function func = layer.getFunction();
                if (!func.isMetal() || func == Layer.Function.METAL1) continue;
                return layer;
            }
        }
        return null;
    }

    private List<PortConfig> searchPortList() {
        ArrayList<PortInst> portList = new ArrayList<PortInst>();
        this.topCell.getNetlist();
        ArrayList<Export> exportList = new ArrayList<Export>();
        Iterator<NodeInst> it = this.topCell.getNodes();
        while (it.hasNext()) {
            NodeInst ni = it.next();
            if (!ni.isCellInstance()) {
                Iterator<Export> itE = ni.getExports();
                while (itE.hasNext()) {
                    Export e = itE.next();
                    if (!e.isGround() && !e.isPower()) continue;
                    portList.add(e.getOriginalPort());
                    exportList.add(e);
                }
                continue;
            }
            Cell cell = (Cell)ni.getProto();
            Netlist netlist = cell.getNetlist();
            ArrayList<PortInst> list = new ArrayList<PortInst>();
            ArrayList<Network> nets = new ArrayList<Network>();
            ArrayList<Export> eList = new ArrayList<Export>();
            boolean foundVdd = false;
            boolean foundGnd = false;
            Iterator<PortInst> itP = ni.getPortInsts();
            while (!(!itP.hasNext() || foundVdd && foundGnd)) {
                PortInst p = itP.next();
                if (!p.getPortProto().isGround() && !p.getPortProto().isPower()) continue;
                if (foundVdd && p.getPortProto().isPower() || foundGnd && p.getPortProto().isGround()) {
                    System.out.println("Skipping export " + p + " in " + ni);
                    continue;
                }
                assert (p.getPortProto() instanceof Export);
                Export ex = (Export)p.getPortProto();
                Network net = netlist.getNetwork(ex.getOriginalPort());
                Object fillCell = null;
                if (fillCell == null && !nets.contains(net)) {
                    list.add(p);
                    nets.add(net);
                    nets.add(net);
                    eList.add(ex);
                    if (p.getPortProto().isPower()) {
                        foundVdd = true;
                        continue;
                    }
                    if (!p.getPortProto().isGround()) continue;
                    foundGnd = true;
                    continue;
                }
                System.out.println("Skipping export " + p + " in " + ni);
            }
            portList.addAll(list);
            exportList.addAll(eList);
        }
        ArrayList<PortConfig> plList = new ArrayList<PortConfig>();
        assert (portList.size() == exportList.size());
        for (int i = 0; i < exportList.size(); ++i) {
            PortInst p = (PortInst)portList.get(i);
            Layer l = FillCellGenJob.getMetalLayerFromExport(p.getPortProto());
            if (l == null) continue;
            plList.add(new PortConfig(p, (Export)exportList.get(i), l));
        }
        return plList;
    }

    private List<Cell> searchPossibleMaster() {
        Cell masterCell = null;
        ArrayList<Cell> secondMasterCell = new ArrayList<Cell>();
        ArrayList<Cell> list = null;
        Iterator<Library> it = Library.getLibraries();
        while (it.hasNext()) {
            Library lib = it.next();
            Iterator<Cell> itC = lib.getCells();
            while (itC.hasNext()) {
                Cell c = itC.next();
                if (c.getVar("FILL_MASTER") != null) {
                    masterCell = c;
                    continue;
                }
                if (c.getVar("FILL_MASTER_ALTERNATIVE") == null) continue;
                secondMasterCell.add(c);
            }
        }
        if (masterCell != null) {
            list = new ArrayList<Cell>();
            list.add(masterCell);
            list.addAll(secondMasterCell);
        } else {
            System.out.println("No master found for Fill Generator");
        }
        return list;
    }

    @Override
    public boolean doIt() {
        EditingPreferences ep = this.getEditingPreferences();
        FillCellTool fillGen = (FillCellTool)this.setUpJob();
        boolean result = this.fillGenConfig.fillType == FillGeneratorTool.FillTypeEnum.TEMPLATE ? this.doTemplateFill(fillGen, ep) : this.doFillOnCell(fillGen);
        return result;
    }

    protected static Cell detectOverlappingBars(Cell cell, Cell master, Cell empty, FixpTransform fillTransUp, HashSet<NodeInst> nodesToRemove, HashSet<ArcInst> arcsToRemove, Cell topCell, NodeInst[] ignore, double drcSpacing, int level) {
        Rectangle2D rect;
        ArrayList<Layer.Function> tmp = new ArrayList<Layer.Function>();
        Iterator<NodeInst> itNode = cell.getNodes();
        while (itNode.hasNext()) {
            Technology.NodeLayer[] subTransUp;
            NodeInst ni = itNode.next();
            if (NodeInst.isSpecialNode(ni)) continue;
            tmp.clear();
            NodeProto np = ni.getProto();
            if (ni.isCellInstance()) {
                HashSet<ArcInst> arcsToRemoveSub;
                HashSet<NodeInst> nodesToRemoveSub;
                Cell c = (Cell)ni.getProto();
                Cell tmpCell = FillCellGenJob.detectOverlappingBars(c, master, empty, (FixpTransform)(subTransUp = ni.transformOut(fillTransUp)), nodesToRemoveSub = new HashSet<NodeInst>(), arcsToRemoveSub = new HashSet<ArcInst>(), topCell, ignore, drcSpacing, ++level);
                if (tmpCell != empty && tmpCell != null) continue;
                nodesToRemoveSub.clear();
                arcsToRemoveSub.clear();
                return empty;
            }
            PrimitiveNode pn = (PrimitiveNode)np;
            if (pn.getFunction().isPin()) continue;
            subTransUp = pn.getNodeLayers();
            int nodesToRemoveSub = subTransUp.length;
            for (int arcsToRemoveSub = 0; arcsToRemoveSub < nodesToRemoveSub; ++arcsToRemoveSub) {
                Technology.NodeLayer tlayer = subTransUp[arcsToRemoveSub];
                tmp.add(tlayer.getLayer().getFunction());
            }
            rect = FillCellGenJob.getSearchRectangle(ni.getBounds(), fillTransUp, drcSpacing);
            assert (ignore.length == 0);
            if (!FillCellGenJob.searchCollision(topCell, rect, new Layer.Function.Set(tmp), null, new Object[]{cell, ni}, master, null)) continue;
            if (LOCALDEBUGFLAG) {
                rect = FillCellGenJob.getSearchRectangle(ni.getBounds(), fillTransUp, drcSpacing);
                FillCellGenJob.searchCollision(topCell, rect, new Layer.Function.Set(tmp), null, new Object[]{cell, ni}, master, null);
            }
            nodesToRemove.add(ni);
            Iterator<Connection> itC = ni.getConnections();
            while (itC.hasNext()) {
                Connection c = itC.next();
                arcsToRemove.add(c.getArc());
            }
        }
        Netlist netlist = cell.getNetlist();
        Iterator<ArcInst> itArc = cell.getArcs();
        while (itArc.hasNext()) {
            ArcInst ai = itArc.next();
            Layer.Function.Set thisLayer = new Layer.Function.Set(ai.getProto().getLayer(0).getFunction());
            rect = FillCellGenJob.getSearchRectangle(ai.getBounds(), fillTransUp, drcSpacing);
            assert (ignore.length == 0);
            Network net = netlist.getNetwork(ai, 0);
            if (!FillCellGenJob.searchCollision(topCell, rect, thisLayer, null, new Object[]{cell, ai}, master, net)) continue;
            if (LOCALDEBUGFLAG) {
                rect = FillCellGenJob.getSearchRectangle(ai.getBounds(), fillTransUp, drcSpacing);
                FillCellGenJob.searchCollision(topCell, rect, thisLayer, null, new Object[]{cell, ai}, master, net);
            }
            arcsToRemove.add(ai);
        }
        if (level == 0) {
            HashSet<ArcProto> names = new HashSet<ArcProto>();
            Iterator<NodeInst> itNode2 = cell.getNodes();
            while (itNode2.hasNext()) {
                NodeInst ni = itNode2.next();
                if (Generic.isSpecialGenericNode(ni) || nodesToRemove.contains(ni)) continue;
                int minNum = ni.getProto().getFunction().isPin() || ni.isCellInstance() ? 0 : 1;
                names.clear();
                boolean found = false;
                Iterator<Connection> itC = ni.getConnections();
                while (itC.hasNext()) {
                    Connection c = itC.next();
                    ArcInst ai = c.getArc();
                    if (arcsToRemove.contains(ai)) continue;
                    names.add(ai.getProto());
                    if (names.size() <= minNum) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                nodesToRemove.add(ni);
            }
        }
        return nodesToRemove.size() > 0 || arcsToRemove.size() > 0 ? null : master;
    }

    protected static boolean searchCollision(Cell parent, Rectangle2D nodeBounds, Layer.Function.Set theseLayers, PortConfig p, Object[] ignores, Cell master, Network theNet) {
        Rectangle2D.Double subBound = new Rectangle2D.Double();
        Netlist netlist = parent.getNetlist();
        for (int i = 0; i < ignores.length; ++i) {
            if (parent != ignores[i]) continue;
            return false;
        }
        if (master != null && FillCellGenJob.searchSubCellInMasterCell(master, parent)) {
            return false;
        }
        Iterator<Geometric> it = parent.searchIterator(nodeBounds, false);
        while (it.hasNext()) {
            Poly[] subPolyList;
            Geometric geom = it.next();
            if (p != null && geom == p.p.getNodeInst()) continue;
            boolean ignoreThis = false;
            for (int i = 0; i < ignores.length; ++i) {
                if (geom != ignores[i]) continue;
                ignoreThis = true;
                break;
            }
            if (ignoreThis) continue;
            if (geom instanceof NodeInst) {
                Poly[] subPolyList2;
                NodeInst ni = (NodeInst)geom;
                if (NodeInst.isSpecialNode(ni)) continue;
                if (ni.isCellInstance()) {
                    FixpTransform extra = ni.transformIn();
                    ((Rectangle2D)subBound).setRect(nodeBounds);
                    DBMath.transformRect(subBound, extra);
                    if (!FillCellGenJob.searchCollision((Cell)ni.getProto(), subBound, theseLayers, p, ignores, master, theNet)) continue;
                    return true;
                }
                if (p != null) {
                    boolean found = false;
                    Iterator<PortInst> itP = ni.getPortInsts();
                    while (itP.hasNext()) {
                        PortInst port = itP.next();
                        Network net = netlist.getNetwork(port);
                        if (net.findExportWithSameCharacteristic(p.e) == null) continue;
                        found = true;
                        break;
                    }
                    if (found) continue;
                }
                if ((subPolyList2 = parent.getTechnology().getShapeOfNode(ni, true, true, theseLayers)).length <= 0) continue;
                return true;
            }
            ArcInst ai = (ArcInst)geom;
            Network net = netlist.getNetwork(ai, 0);
            if (p != null && net.findExportWithSameCharacteristic(p.e) != null || theNet != null && net.getName().startsWith(theNet.getName()) || (subPolyList = parent.getTechnology().getShapeOfArc(ai, theseLayers)).length <= 0) continue;
            return true;
        }
        return false;
    }

    public static Rectangle2D getSearchRectangle(Rectangle2D bnd, FixpTransform fillTransUp, double drcSpacing) {
        Rectangle2D.Double rect = new Rectangle2D.Double(bnd.getX() - drcSpacing, bnd.getY() - drcSpacing, bnd.getWidth() + 2.0 * drcSpacing, bnd.getHeight() + 2.0 * drcSpacing);
        if (fillTransUp != null) {
            DBMath.transformRect(rect, fillTransUp);
        }
        return rect;
    }

    private static boolean searchSubCellInMasterCell(Cell master, Cell cell) {
        Iterator<NodeInst> itNi = master.getNodes();
        while (itNi.hasNext()) {
            Cell thisCell;
            NodeInst ni = itNi.next();
            if (!ni.isCellInstance() || (thisCell = (Cell)ni.getProto()) != cell) continue;
            return true;
        }
        return false;
    }

    private Export searchForClosestPort(PortInst pi, List<Export> list, Map<Export, Point2D> centerMap, FixpTransform conTransOut) {
        double closest = Double.MAX_VALUE;
        EPoint piCenter = pi.getCenter();
        Export found = null;
        for (Export ex : list) {
            double dist;
            Point2D point = centerMap.get(ex);
            if (point == null) {
                point = ex.getOriginalPort().getCenter();
                Point2D.Double newPoint = new Point2D.Double(0.0, 0.0);
                conTransOut.transform(point, newPoint);
                point = newPoint;
                centerMap.put(ex, newPoint);
            }
            if (!((dist = point.distance(piCenter)) < closest)) continue;
            found = ex;
            closest = dist;
        }
        return found;
    }

    public boolean doFillOnCell(FillCellTool fillGen) {
        EditingPreferences ep = this.getEditingPreferences();
        List<Cell> masters = null;
        if (fillGen.config.useMaster && (masters = this.searchPossibleMaster()) == null) {
            System.out.println("No master found. Either mark one or select create in pulldown menu");
            return false;
        }
        List<PortConfig> portList = this.searchPortList();
        ArrayList<Rectangle2D> topBoxList = new ArrayList<Rectangle2D>();
        topBoxList.add(this.topCell.getBounds());
        Visitor areaVisitor = new Visitor(this.fillGenConfig.level);
        HierarchyEnumerator.enumerateCell(this.topCell, VarContext.globalContext, (HierarchyEnumerator.Visitor)areaVisitor);
        TechType techType = this.fillGenConfig.getTechType();
        Cell fillCell = this.fillGenConfig.hierarchy ? fillGen.treeMakeFillCell(this.fillGenConfig, ep, this.topCell, masters, topBoxList, areaVisitor.exclusionArea) : fillGen.standardMakeFillCell(this.fillGenConfig.firstLayer, this.fillGenConfig.lastLayer, techType, ep, this.fillGenConfig.perim, this.fillGenConfig.cellTiles, true);
        fillCell.setTechnology(this.topCell.getTechnology());
        if (this.topCell == null) {
            return false;
        }
        Cell connectionCell = Cell.newInst(this.topCell.getLibrary(), this.topCell.getName() + "fill{lay}");
        connectionCell.setTechnology(this.topCell.getTechnology());
        ERectangle fillBnd = fillCell.getBounds();
        double essentialX = ((RectangularShape)fillBnd).getWidth() / 2.0;
        double essentialY = ((RectangularShape)fillBnd).getHeight() / 2.0;
        LayoutLib.newNodeInst(techType.essentialBounds(), ep, -essentialX, -essentialY, G.DEF_SIZE, G.DEF_SIZE, 180.0, connectionCell);
        LayoutLib.newNodeInst(techType.essentialBounds(), ep, essentialX, essentialY, G.DEF_SIZE, G.DEF_SIZE, 0.0, connectionCell);
        assert (topBoxList.size() == 1);
        Rectangle2D bnd = (Rectangle2D)topBoxList.get(0);
        NodeInst conNi = LayoutLib.newNodeInst(connectionCell, ep, bnd.getCenterX(), bnd.getCenterY(), ((RectangularShape)fillBnd).getWidth(), ((RectangularShape)fillBnd).getHeight(), 0.0, this.topCell);
        ERectangle conBnd = connectionCell.getBounds();
        NodeInst fillNi = LayoutLib.newNodeInst(fillCell, ep, ((RectangularShape)conBnd).getCenterX() - ((RectangularShape)fillBnd).getWidth() / 2.0 - ((RectangularShape)fillBnd).getX(), ((RectangularShape)conBnd).getCenterY() - ((RectangularShape)fillBnd).getHeight() / 2.0 - ((RectangularShape)fillBnd).getY(), ((RectangularShape)fillBnd).getWidth(), ((RectangularShape)fillBnd).getHeight(), 0.0, connectionCell);
        FixpTransform conTransOut = conNi.transformOut();
        FixpTransform fillTransOutToCon = fillNi.transformOut();
        FixpTransform fillTransIn = fillNi.transformIn(conNi.transformIn());
        SimpleWirer router = new SimpleWirer(ep);
        router.setTool(FillGeneratorTool.getTool());
        boolean rotated = fillGen.masters.get(0) != null && ((Cell)fillGen.masters.get(0)).getVar("ROTATED_MASTER") != null;
        FillGenJobContainer container = new FillGenJobContainer(router, fillCell, fillNi, connectionCell, conNi, this.fillGenConfig.drcSpacingRule, rotated);
        if (!this.fillGenConfig.hierarchy) {
            FixpTransform fillTransOut = fillNi.transformOut(conTransOut);
            this.removeOverlappingBars(container, fillTransOut);
        }
        ArrayList<Export> gndList = new ArrayList<Export>();
        ArrayList<Export> vddList = new ArrayList<Export>();
        Iterator<Export> it = container.fillCell.getExports();
        block4: while (it.hasNext()) {
            Export export = it.next();
            PortInst portInst = container.fillNi.findPortInstFromProto(export);
            Export e = Export.newInst(container.connectionCell, portInst, portInst.getPortProto().getName(), ep);
            e.setCharacteristic(portInst.getPortProto().getCharacteristic());
            switch (portInst.getPortProto().getCharacteristic()) {
                case GND: {
                    gndList.add(e);
                    continue block4;
                }
                case PWR: {
                    vddList.add(e);
                    continue block4;
                }
            }
            assert (false);
        }
        if (vddList.isEmpty() && gndList.isEmpty()) {
            System.out.println("Error: No vdd/gnd exports in master cell.");
            return false;
        }
        ArrayList<Object> errorList = new ArrayList<Object>();
        if (this.fillGenConfig.fillCellType == FillGenConfig.FillGenType.ONLYSKILL) {
            return true;
        }
        if (this.fillGenConfig.fillCellType == FillGenConfig.FillGenType.SEAGATES) {
            SeaOfGatesEngine seaGrouter = SeaOfGatesEngineFactory.createSeaOfGatesEngine();
            ArrayList<ArcInst> arrayList = new ArrayList<ArcInst>();
            HashMap<Export, Point2D> centerMapGnd = new HashMap<Export, Point2D>(gndList.size());
            HashMap<Export, Point2D> centerMapVdd = new HashMap<Export, Point2D>(vddList.size());
            for (PortConfig p : portList) {
                Export ex = p.e;
                Export fillE = null;
                fillE = ex.getCharacteristic() == PortCharacteristic.GND ? this.searchForClosestPort(p.p, gndList, centerMapGnd, conTransOut) : this.searchForClosestPort(p.p, vddList, centerMapVdd, conTransOut);
                if (fillE == null) {
                    System.out.println("It couldn't find closest port for " + p.e.getName());
                    continue;
                }
                PortInst pi = conNi.findPortInst(fillE.getName());
                assert (pi != null);
                ArcProto ap = Generic.tech().unrouted_arc;
                ArcInst ai = ArcInst.newInstanceBase(ap, ep, ap.getDefaultLambdaBaseWidth(ep), pi, p.p);
                arrayList.add(ai);
            }
            seaGrouter.setPrefs(this.lcp.seaIfGatesPrefs);
            seaGrouter.routeIt(SeaOfGatesHandlers.getDefault(this.topCell, null, Routing.SoGContactsStrategy.SOGCONTACTSATTOPLEVEL, this, ep), this.topCell, false, arrayList);
            return true;
        }
        for (PortConfig portConfig : portList) {
            Rectangle2D rect = null;
            FixpTransform trans = null;
            if (portConfig.p.getPortProto() instanceof Export) {
                Export ex = (Export)portConfig.p.getPortProto();
                assert (ex == portConfig.e);
                Cell exportCell = (Cell)portConfig.p.getNodeInst().getProto();
                rect = !this.fillGenConfig.onlyAround ? LayerCoverageTool.getGeometryOnNetwork(exportCell, ex.getOriginalPort(), portConfig.l, this.lcp) : portConfig.pPoly.getBounds2D();
                trans = portConfig.p.getNodeInst().transformOut();
            } else {
                rect = (Rectangle2D)portConfig.p.getNodeInst().getBounds().clone();
            }
            Rectangle2D backupRect = (Rectangle2D)rect.clone();
            NodeInst added = null;
            errorList.clear();
            errorList.add(portConfig.pPoly);
            errorList.add(portConfig.p.getNodeInst());
            if (!this.fillGenConfig.onlyAround && (added = this.addAllPossibleContacts(container, portConfig, rect, trans, fillTransIn, fillTransOutToCon, conTransOut, areaVisitor.exclusionArea)) != null) {
                this.log.logMessage(portConfig.p.describe(false) + " connected", errorList, this.topCell, 0, false);
                continue;
            }
            rect = backupRect;
            rect = portConfig.pPoly.getBounds2D();
            added = this.addAllPossibleContactsOverPort(container, portConfig, rect = new Rectangle2D.Double(rect.getX() - this.fillGenConfig.gap, rect.getY(), rect.getWidth() + this.fillGenConfig.gap * 2.0, backupRect.getHeight()), null, fillTransIn, null, true);
            if (added == null) {
                double searchWidth = ((Cell)fillGen.masters.get(0)).getBounds().getWidth();
                rect = portConfig.pPoly.getBounds2D();
                rect = new Rectangle2D.Double(rect.getX() - searchWidth / 2.0, rect.getY(), rect.getWidth() + searchWidth / 2.0, backupRect.getHeight());
                added = this.addAllPossibleContactsOverPort(container, portConfig, rect, null, fillTransIn, null, false);
            }
            if (added != null) {
                this.log.logMessage(portConfig.p.describe(false) + " connected by extension", errorList, this.topCell, 0, false);
                continue;
            }
            this.log.logMessage(portConfig.p.describe(false) + " not connected", errorList, this.topCell, 0, true);
        }
        return true;
    }

    private boolean detectOverlappingBars(Cell cell, FixpTransform fillTransUp, HashSet<Geometric> nodesToRemove, FillGenJobContainer container) {
        ArrayList<Layer.Function> tmp = new ArrayList<Layer.Function>();
        Iterator<NodeInst> itNode = cell.getNodes();
        while (itNode.hasNext()) {
            Technology.NodeLayer[] subTransUp;
            NodeInst ni = itNode.next();
            if (NodeInst.isSpecialNode(ni)) continue;
            tmp.clear();
            NodeProto np = ni.getProto();
            if (ni.isCellInstance()) {
                Cell subCell = (Cell)ni.getProto();
                if (!this.detectOverlappingBars(subCell, (FixpTransform)(subTransUp = ni.transformOut(fillTransUp)), nodesToRemove, container)) continue;
                if (cell == container.fillCell) {
                    nodesToRemove.add(ni);
                    continue;
                }
                return true;
            }
            PrimitiveNode pn = (PrimitiveNode)np;
            if (pn.getFunction().isPin()) continue;
            subTransUp = pn.getNodeLayers();
            int n = subTransUp.length;
            for (int i = 0; i < n; ++i) {
                Technology.NodeLayer tlayer = subTransUp[i];
                tmp.add(tlayer.getLayer().getFunction());
            }
            Rectangle2D rect = FillCellGenJob.getSearchRectangle(ni.getBounds(), fillTransUp, container.drcSpacing);
            if (!FillCellGenJob.searchCollision(this.topCell, rect, new Layer.Function.Set(tmp), null, new NodeInst[]{container.fillNi, container.connectionNi}, null, null)) continue;
            if (cell == container.fillCell) {
                nodesToRemove.add(ni);
                continue;
            }
            return true;
        }
        Iterator<ArcInst> itArc = cell.getArcs();
        while (itArc.hasNext()) {
            ArcInst ai = itArc.next();
            Layer.Function.Set thisLayer = new Layer.Function.Set(ai.getProto().getLayer(0).getFunction());
            Rectangle2D rect = FillCellGenJob.getSearchRectangle(ai.getBounds(), fillTransUp, container.drcSpacing);
            if (!FillCellGenJob.searchCollision(this.topCell, rect, thisLayer, null, new NodeInst[]{container.fillNi, container.connectionNi}, null, null)) continue;
            if (cell == container.fillCell) {
                nodesToRemove.add(ai);
                nodesToRemove.add(ai.getTail().getPortInst().getNodeInst());
                nodesToRemove.add(ai.getHead().getPortInst().getNodeInst());
                continue;
            }
            return true;
        }
        return false;
    }

    private void removeOverlappingBars(FillGenJobContainer container, FixpTransform fillTransOut) {
        HashSet<Geometric> nodesToRemove = new HashSet<Geometric>();
        this.detectOverlappingBars(container.fillCell, fillTransOut, nodesToRemove, container);
        for (Geometric geo : nodesToRemove) {
            System.out.println("Removing " + geo);
            if (geo instanceof NodeInst) {
                ((NodeInst)geo).kill();
                continue;
            }
            ((ArcInst)geo).kill();
        }
    }

    private boolean searchOverlapHierarchically(Cell searchCell, boolean rotated, GeometryHandler handler, GeometryHandler closestHandler, PortConfig p, Rectangle2D contactAreaOrig, FixpTransform downTrans, FixpTransform upTrans) {
        EditingPreferences ep = this.getEditingPreferences();
        Rectangle2D.Double contactArea = new Rectangle2D.Double(contactAreaOrig.getX(), contactAreaOrig.getY(), contactAreaOrig.getWidth(), contactAreaOrig.getHeight());
        DBMath.transformRect(contactArea, downTrans);
        Netlist fillNetlist = searchCell.getNetlist();
        double contactAreaHeight = ((RectangularShape)contactArea).getHeight();
        double contactAreaWidth = ((RectangularShape)contactArea).getWidth();
        HashMap<Layer, ArrayList<ArcInst>> protoMap = new HashMap<Layer, ArrayList<ArcInst>>();
        boolean noIntermediateCells = false;
        TechType techType = this.fillGenConfig.getTechType();
        Iterator<Geometric> it = searchCell.searchIterator(contactArea);
        while (it.hasNext()) {
            Geometric geom = it.next();
            if (geom instanceof NodeInst) {
                NodeInst ni = (NodeInst)geom;
                if (!ni.isCellInstance()) continue;
                FixpTransform fillIn = ni.transformIn();
                FixpTransform fillUp = ni.transformOut(upTrans);
                if (!this.searchOverlapHierarchically((Cell)ni.getProto(), rotated, handler, closestHandler, p, contactArea, fillIn, fillUp)) continue;
                noIntermediateCells = true;
                continue;
            }
            ArcInst ai = (ArcInst)geom;
            ArcProto ap = ai.getProto();
            Network arcNet = fillNetlist.getNetwork(ai, 0);
            if (arcNet.findExportWithSameCharacteristic(p.e) == null || ap == techType.m2() || ap == techType.m1() || !ap.getFunction().isMetal()) continue;
            Layer layer = ap.getLayerIterator().next();
            ArrayList<ArcInst> list = (ArrayList<ArcInst>)protoMap.get(layer);
            if (list == null) {
                list = new ArrayList<ArcInst>();
                protoMap.put(layer, list);
            }
            list.add(ai);
        }
        if (noIntermediateCells) {
            return true;
        }
        Set results = protoMap.keySet();
        ArrayList<Layer> listOfLayers = new ArrayList<Layer>(results.size());
        listOfLayers.addAll(results);
        Layer.getLayersSortedByRule(listOfLayers, Layer.LayerSortingType.ByName);
        double closestDist = Double.POSITIVE_INFINITY;
        Rectangle2D closestRect = null;
        int index = listOfLayers.indexOf(p.l);
        if (index > -1) {
            Layer first = (Layer)listOfLayers.get(0);
            listOfLayers.set(0, p.l);
            listOfLayers.set(index, first);
        }
        for (Layer layer : listOfLayers) {
            ArcProto ap = FillCellGenJob.findArcProtoFromLayer(layer);
            boolean horizontalBar = rotated ? ap == techType.m3() || ap == techType.m5() : ap == techType.m4() || ap == techType.m6();
            PrimitiveNode defaultContact = null;
            if (horizontalBar) {
                if (!rotated && ap == techType.m4() || rotated && ap == techType.m3()) {
                    defaultContact = techType.m3m4();
                } else if (!rotated && ap == techType.m6() || rotated && ap == techType.m5()) {
                    defaultContact = techType.m4m5();
                } else assert (false);
            }
            boolean found = false;
            Layer theLayer = null;
            for (ArcInst ai : (List)protoMap.get(layer)) {
                boolean containMax;
                double geoMax;
                double geoMin;
                double areaMax;
                double areaMin;
                double newElemMax;
                double newElemMin;
                double usefulBar;
                ERectangle geomBnd = ai.getBounds();
                theLayer = layer;
                Rectangle2D newElem = null;
                if (horizontalBar) {
                    if (layer != p.l) continue;
                    usefulBar = ((RectangularShape)geomBnd).getHeight();
                    Network net = fillNetlist.getNetwork(ai, 0);
                    ArrayList<NodeInst> nodes = new ArrayList<NodeInst>();
                    Iterator<NodeInst> it2 = searchCell.getNodes();
                    block3: while (it2.hasNext()) {
                        NodeInst ni = it2.next();
                        ERectangle r = ni.getBounds();
                        if (!ni.getProto().getFunction().isContact() || !r.intersects(geomBnd)) continue;
                        Iterator<PortInst> pit = ni.getPortInsts();
                        while (pit.hasNext()) {
                            PortInst pi = pit.next();
                            if (fillNetlist.getNetwork(pi) != net) continue;
                            nodes.add(ni);
                            continue block3;
                        }
                    }
                    if (nodes.size() == 0) {
                        newElem = new Rectangle2D.Double(((RectangularShape)contactArea).getX(), ((RectangularShape)geomBnd).getY(), defaultContact.getDefWidth(ep), usefulBar);
                    } else {
                        NodeInst ni = (NodeInst)nodes.get(0);
                        Rectangle2D r = ni.getBounds();
                        double contactW = ni.getXSizeWithoutOffset();
                        geomBnd = r = new Rectangle2D.Double(((RectangularShape)r).getCenterX() - contactW / 2.0, ((RectangularShape)contactArea).getY(), contactW, contactAreaHeight);
                        newElem = geomBnd;
                    }
                    newElemMin = newElem.getMinY();
                    newElemMax = newElem.getMaxY();
                    areaMin = contactArea.getMinY();
                    areaMax = contactArea.getMaxY();
                    geoMin = ((RectangularShape)geomBnd).getMinY();
                    geoMax = ((RectangularShape)geomBnd).getMaxY();
                } else if (rotated) {
                    usefulBar = ((RectangularShape)geomBnd).getHeight();
                    newElem = new Rectangle2D.Double(((RectangularShape)contactArea).getX(), ((RectangularShape)geomBnd).getY(), contactAreaWidth, usefulBar);
                    newElemMin = newElem.getMinY();
                    newElemMax = newElem.getMaxY();
                    areaMin = contactArea.getMinY();
                    areaMax = contactArea.getMaxY();
                    geoMin = ((RectangularShape)geomBnd).getMinY();
                    geoMax = ((RectangularShape)geomBnd).getMaxY();
                } else {
                    usefulBar = ((RectangularShape)geomBnd).getWidth();
                    newElem = new Rectangle2D.Double(((RectangularShape)geomBnd).getX(), ((RectangularShape)contactArea).getY(), usefulBar, contactAreaHeight);
                    newElemMin = newElem.getMinX();
                    newElemMax = newElem.getMaxX();
                    areaMin = contactArea.getMinX();
                    areaMax = contactArea.getMaxX();
                    geoMin = ((RectangularShape)geomBnd).getMinX();
                    geoMax = ((RectangularShape)geomBnd).getMaxX();
                }
                if (newElemMax < areaMin || areaMax < newElemMin) continue;
                boolean containMin = newElemMin <= areaMin && areaMin <= newElemMax;
                boolean bl = containMax = newElemMin <= areaMax && areaMax <= newElemMax;
                if (!containMin || !containMax) {
                    assert (geoMin == newElemMin);
                    assert (geoMax == newElemMax);
                    double min = Math.max(geoMin, areaMin);
                    double max = Math.min(geoMax, areaMax);
                    double diff = max - min;
                    double overlap = diff / usefulBar;
                    if (overlap < this.fillGenConfig.minOverlap) {
                        System.out.println("Not enough overlap (" + overlap + ") in " + ai + " to cover " + p.p);
                        double val = Math.abs(diff);
                        if (!(closestDist > val)) continue;
                        closestDist = val;
                        closestRect = newElem;
                        continue;
                    }
                }
                DBMath.transformRect(newElem, upTrans);
                handler.add(theLayer, newElem);
                found = true;
            }
            if (found) {
                return true;
            }
            if (horizontalBar || closestRect == null) continue;
            DBMath.transformRect(closestRect, upTrans);
            closestHandler.add(theLayer, closestRect);
        }
        return false;
    }

    private Export searchOverlapHierarchicallyOverPort(FillGenJobContainer container, Cell searchCell, boolean rotated, PortConfig p, Rectangle2D contactAreaOrig, FixpTransform downTrans, FixpTransform upTrans, boolean noClosestPin) {
        EditingPreferences ep = this.getEditingPreferences();
        Rectangle2D contactArea = (Rectangle2D)contactAreaOrig.clone();
        DBMath.transformRect(contactArea, downTrans);
        Netlist fillNetlist = searchCell.getNetlist();
        double contactAreaHeight = contactArea.getHeight();
        double contactAreaWidth = contactArea.getWidth();
        HashMap<Layer, ArrayList<ArcInst>> protoMap = new HashMap<Layer, ArrayList<ArcInst>>();
        boolean noIntermediateCells = false;
        TechType techType = this.fillGenConfig.getTechType();
        Iterator<Geometric> it = searchCell.searchIterator(contactArea);
        while (it.hasNext()) {
            Geometric geom = it.next();
            if (geom instanceof NodeInst) {
                NodeInst ni = (NodeInst)geom;
                if (!ni.isCellInstance()) continue;
                FixpTransform fillIn = ni.transformIn();
                FixpTransform fillUp = ni.transformOut(upTrans);
                Export export = this.searchOverlapHierarchicallyOverPort(container, (Cell)ni.getProto(), rotated, p, contactArea, fillIn, fillUp, noClosestPin);
                if (export == null) continue;
                PortInst pinPort = ni.findPortInstFromProto(export);
                Export pinExport = Export.newInst(searchCell, pinPort, "proj-" + p.e.getName(), ep);
                pinExport.setCharacteristic(p.e.getCharacteristic());
                noIntermediateCells = true;
                return pinExport;
            }
            ArcInst ai = (ArcInst)geom;
            ArcProto ap = ai.getProto();
            Network arcNet = fillNetlist.getNetwork(ai, 0);
            if (arcNet.findExportWithSameCharacteristic(p.e) == null || ap == techType.m2() || ap == techType.m1() || !ap.getFunction().isMetal()) continue;
            Layer layer = ap.getLayerIterator().next();
            ArrayList<ArcInst> list = (ArrayList<ArcInst>)protoMap.get(layer);
            if (list == null) {
                list = new ArrayList<ArcInst>();
                protoMap.put(layer, list);
            }
            list.add(ai);
        }
        if (noIntermediateCells) assert (false);
        Set results = protoMap.keySet();
        ArrayList<Layer> listOfLayers = new ArrayList<Layer>(results.size());
        listOfLayers.addAll(results);
        Layer.getLayersSortedByRule(listOfLayers, Layer.LayerSortingType.ByName);
        double closestDist = Double.POSITIVE_INFINITY;
        RectangularShape closestRect = null;
        ArcInst closestArc = null;
        int index = listOfLayers.indexOf(p.l);
        if (index > -1) {
            Layer first = (Layer)listOfLayers.get(0);
            listOfLayers.set(0, p.l);
            listOfLayers.set(index, first);
        }
        for (Layer layer : listOfLayers) {
            ArcProto ap = FillCellGenJob.findArcProtoFromLayer(layer);
            boolean horizontalBar = rotated ? ap == techType.m3() || ap == techType.m5() : ap == techType.m4() || ap == techType.m6();
            PrimitiveNode defaultContact = null;
            if (horizontalBar) {
                if (!rotated && ap == techType.m4() || rotated && ap == techType.m3()) {
                    defaultContact = techType.m3m4();
                } else if (!rotated && ap == techType.m6() || rotated && ap == techType.m5()) {
                    defaultContact = techType.m4m5();
                } else assert (false);
            }
            List theSortedList = (List)protoMap.get(layer);
            Collections.sort(theSortedList, new ArcInst.ArcsByLength());
            for (ArcInst ai : theSortedList) {
                boolean containMax;
                double geoMax;
                double geoMin;
                double areaMax;
                double areaMin;
                double newElemMax;
                double newElemMin;
                double usefulBar;
                ERectangle geomBnd = ai.getBounds();
                Rectangle2D newElem = null;
                if (horizontalBar) {
                    if (layer != p.l) continue;
                    usefulBar = ((RectangularShape)geomBnd).getHeight();
                    Network net = fillNetlist.getNetwork(ai, 0);
                    ArrayList<NodeInst> nodes = new ArrayList<NodeInst>();
                    Iterator<NodeInst> it2 = searchCell.getNodes();
                    block3: while (it2.hasNext()) {
                        NodeInst ni = it2.next();
                        ERectangle r = ni.getBounds();
                        if (!ni.getProto().getFunction().isContact() || !r.intersects(geomBnd)) continue;
                        Iterator<PortInst> pit = ni.getPortInsts();
                        while (pit.hasNext()) {
                            PortInst pi = pit.next();
                            if (fillNetlist.getNetwork(pi) != net) continue;
                            nodes.add(ni);
                            continue block3;
                        }
                    }
                    if (nodes.size() == 0) {
                        newElem = new Rectangle2D.Double(contactArea.getX(), ((RectangularShape)geomBnd).getY(), defaultContact.getDefWidth(ep), usefulBar);
                    } else {
                        NodeInst ni = (NodeInst)nodes.get(0);
                        Rectangle2D r = ni.getBounds();
                        double contactW = ni.getXSizeWithoutOffset();
                        geomBnd = r = new Rectangle2D.Double(((RectangularShape)r).getCenterX() - contactW / 2.0, contactArea.getY(), contactW, contactAreaHeight);
                        newElem = geomBnd;
                    }
                    newElemMin = newElem.getMinY();
                    newElemMax = newElem.getMaxY();
                    areaMin = contactArea.getMinY();
                    areaMax = contactArea.getMaxY();
                    geoMin = ((RectangularShape)geomBnd).getMinY();
                    geoMax = ((RectangularShape)geomBnd).getMaxY();
                } else if (rotated) {
                    usefulBar = ((RectangularShape)geomBnd).getHeight();
                    newElem = new Rectangle2D.Double(contactArea.getX(), ((RectangularShape)geomBnd).getY(), contactAreaWidth, usefulBar);
                    newElemMin = newElem.getMinY();
                    newElemMax = newElem.getMaxY();
                    areaMin = contactArea.getMinY();
                    areaMax = contactArea.getMaxY();
                    geoMin = ((RectangularShape)geomBnd).getMinY();
                    geoMax = ((RectangularShape)geomBnd).getMaxY();
                } else {
                    usefulBar = ((RectangularShape)geomBnd).getWidth();
                    newElem = new Rectangle2D.Double(((RectangularShape)geomBnd).getX(), contactArea.getY(), usefulBar, contactAreaHeight);
                    newElemMin = newElem.getMinX();
                    newElemMax = newElem.getMaxX();
                    areaMin = contactArea.getMinX();
                    areaMax = contactArea.getMaxX();
                    geoMin = ((RectangularShape)geomBnd).getMinX();
                    geoMax = ((RectangularShape)geomBnd).getMaxX();
                }
                if (newElemMax < areaMin || areaMax < newElemMin) continue;
                boolean containMin = newElemMin <= areaMin && areaMin <= newElemMax;
                boolean bl = containMax = newElemMin <= areaMax && areaMax <= newElemMax;
                if (!containMin || !containMax) {
                    assert (geoMin == newElemMin);
                    assert (geoMax == newElemMax);
                    double min = Math.max(geoMin, areaMin);
                    double max = Math.min(geoMax, areaMax);
                    double diff = max - min;
                    double overlap = diff / usefulBar;
                    if (overlap < this.fillGenConfig.minOverlap || !noClosestPin) {
                        double val;
                        if (noClosestPin) {
                            System.out.println("Not enough overlap (" + overlap + ") in " + ai + " to cover " + p.p);
                        }
                        if (!(closestDist > (val = Math.abs(diff)))) continue;
                        closestDist = val;
                        closestRect = newElem;
                        closestArc = ai;
                        continue;
                    }
                }
                if (!noClosestPin) continue;
                closestDist = 0.0;
                closestRect = newElem;
                closestArc = ai;
                break;
            }
            if (noClosestPin && closestRect != null) break;
            if (!horizontalBar && closestRect != null) continue;
        }
        if (closestRect != null) {
            if (!noClosestPin) {
                System.out.println("Selecting a closest arc!");
            }
            PrimitiveNode thePin = FillCellGenJob.findPrimitiveNodeFromLayer(closestArc.getProto().getLayerIterator().next());
            NodeInst pinOnArc = LayoutLib.newNodeInst(thePin, ep, closestRect.getCenterX(), closestRect.getCenterY(), thePin.getDefWidth(ep), contactAreaHeight, 0.0, closestArc.getParent());
            EPoint center = pinOnArc.getOnlyPortInst().getCenter();
            Route exportRoute = container.router.planRoute(closestArc.getParent(), closestArc.getPortInst(0), pinOnArc.getOnlyPortInst(), center, null, ep, false, false, null, null);
            HashMap<ArcProto, Integer> arcsCreatedMap = new HashMap<ArcProto, Integer>();
            HashMap<NodeProto, Integer> nodesCreatedMap = new HashMap<NodeProto, Integer>();
            Router.createRouteNoJob(exportRoute, closestArc.getParent(), arcsCreatedMap, nodesCreatedMap, ep);
            Export pinExport = Export.newInst(closestArc.getParent(), pinOnArc.getOnlyPortInst(), "proj-" + p.e.getName(), ep);
            pinExport.setCharacteristic(p.e.getCharacteristic());
            return pinExport;
        }
        return null;
    }

    private static PrimitiveNode findPrimitiveNodeFromLayer(Layer layer) {
        for (PrimitiveNode pin : VddGndStraps.PINS) {
            if (pin == null || layer != pin.getLayerIterator().next()) continue;
            return pin;
        }
        return null;
    }

    private static ArcProto findArcProtoFromLayer(Layer layer) {
        for (ArcProto arc : VddGndStraps.METALS) {
            if (arc == null || layer != arc.getLayerIterator().next()) continue;
            return arc;
        }
        return null;
    }

    private NodeInst addAllPossibleContacts(FillGenJobContainer container, PortConfig p, Rectangle2D contactArea, FixpTransform nodeTransOut, FixpTransform fillTransIn, FixpTransform fillTransOutToCon, FixpTransform conTransOut, Area exclusionArea) {
        EditingPreferences ep = this.getEditingPreferences();
        double contactAreaHeight = contactArea.getHeight();
        NodeInst added = null;
        if (nodeTransOut != null) {
            DBMath.transformRect(contactArea, nodeTransOut);
        }
        if (exclusionArea != null && exclusionArea.intersects(contactArea)) {
            return null;
        }
        GeometryHandler overlapHandler = GeometryHandler.createGeometryHandler(GeometryHandler.GHMode.ALGO_SWEEP, 1);
        GeometryHandler closestHandler = GeometryHandler.createGeometryHandler(GeometryHandler.GHMode.ALGO_SWEEP, 1);
        this.searchOverlapHierarchically(container.fillCell, container.rotated, overlapHandler, closestHandler, p, contactArea, fillTransIn, GenMath.MATID);
        GeometryHandler handler = overlapHandler;
        handler.postProcess(false);
        closestHandler.postProcess(false);
        Set<Layer> overlapResults = handler.getKeySet();
        Set<Layer> closestResults = closestHandler.getKeySet();
        ArrayList<Layer> listOfLayers = new ArrayList<Layer>(overlapResults.size());
        listOfLayers.addAll(overlapResults);
        listOfLayers.addAll(closestResults);
        Layer.getLayersSortedByRule(listOfLayers, Layer.LayerSortingType.ByName);
        int size = listOfLayers.size();
        if (size == 0) {
            return null;
        }
        Rectangle2D.Double portInConFill = new Rectangle2D.Double();
        ((Rectangle2D)portInConFill).setRect(p.pPoly.getBounds2D());
        DBMath.transformRect(portInConFill, fillTransIn);
        TechType techType = this.fillGenConfig.getTechType();
        PrimitiveNode thePin = FillCellGenJob.findPrimitiveNodeFromLayer(p.l);
        assert (thePin != null);
        assert (thePin != techType.m1pin());
        NodeInst pinNode = null;
        PortInst pin = null;
        for (Layer layer : listOfLayers) {
            int i;
            if (!layer.getFunction().isMetal()) continue;
            Collection<PolyBase> set = handler.getObjects(layer, false, true);
            if (set == null || set.size() == 0) {
                set = closestHandler.getObjects(layer, false, true);
            }
            if (set == null || set.size() <= 0) {
                System.out.println("Assert error");
            }
            if (set == null) {
                System.out.println("Null set");
                continue;
            }
            ArrayList<Layer.Function> fillLayers = new ArrayList<Layer.Function>();
            PrimitiveNode topPin = FillCellGenJob.findPrimitiveNodeFromLayer(layer);
            PrimitiveNode topContact = null;
            int start = -1;
            int end = -1;
            for (i = 0; i < VddGndStraps.PINS.length; ++i) {
                if (start == -1 && VddGndStraps.PINS[i] == thePin) {
                    start = i;
                }
                if (end != -1 || VddGndStraps.PINS[i] != topPin) continue;
                end = i;
            }
            if (start > end) {
                int tmp = start;
                start = end;
                end = tmp;
            }
            for (i = start; i <= end; ++i) {
                fillLayers.add(VddGndStraps.PINS[i].getLayerIterator().next().getFunction());
                if (i >= end) continue;
                topContact = VddGndStraps.fillContacts[i];
            }
            boolean horizontalBar = container.rotated ? topPin == techType.m3pin() || topPin == techType.m5pin() : topPin == techType.m4pin() || topPin == techType.m6pin();
            Layer.Function.Set fillLayersSet = new Layer.Function.Set(fillLayers);
            for (PolyBase poly : set) {
                FixpRectangle newElemFill = poly.getBounds2D();
                double newElemFillWidth = ((RectangularShape)newElemFill).getWidth();
                double newElemFillHeight = ((RectangularShape)newElemFill).getHeight();
                Rectangle2D newElemConnect = (Rectangle2D)newElemFill.clone();
                DBMath.transformRect(newElemConnect, fillTransOutToCon);
                Rectangle2D newElemTop = (Rectangle2D)newElemConnect.clone();
                DBMath.transformRect(newElemTop, conTransOut);
                if (FillCellGenJob.searchCollision(this.topCell, newElemTop, fillLayersSet, p, new NodeInst[]{container.fillNi, container.connectionNi}, null, null)) continue;
                if (pinNode == null) {
                    pinNode = LayoutLib.newNodeInst(thePin, ep, portInConFill.getCenterX(), portInConFill.getCenterY(), thePin.getDefWidth(ep), contactAreaHeight, 0.0, container.connectionCell);
                    pin = pinNode.getOnlyPortInst();
                }
                added = topContact != null ? (horizontalBar ? LayoutLib.newNodeInst(topContact, ep, newElemConnect.getCenterX(), newElemConnect.getCenterY(), newElemFillWidth, newElemFillHeight, 0.0, container.connectionCell) : LayoutLib.newNodeInst(topContact, ep, newElemConnect.getCenterX(), newElemConnect.getCenterY(), newElemFillWidth, contactAreaHeight, 0.0, container.connectionCell)) : pinNode;
                container.fillContactList.add(added);
                Route pinExportRoute = container.router.planRoute(container.connectionCell, pin, added.getOnlyPortInst(), new Point2D.Double(portInConFill.getCenterX(), portInConFill.getCenterY()), null, ep, false, false, null, null);
                HashMap<ArcProto, Integer> arcsCreatedMap = new HashMap<ArcProto, Integer>();
                HashMap<NodeProto, Integer> nodesCreatedMap = new HashMap<NodeProto, Integer>();
                Router.createRouteNoJob(pinExportRoute, container.connectionCell, arcsCreatedMap, nodesCreatedMap, ep);
                if (!pin.isLinked()) {
                    pinNode = pinExportRoute.getStart().getNodeInst();
                    pin = pinExportRoute.getStart().getPortInst();
                }
                PortInst fillNiPort = null;
                double minDistance = Double.POSITIVE_INFINITY;
                Iterator<Export> e = container.fillNi.getExports();
                while (e.hasNext()) {
                    double dist;
                    Export exp = e.next();
                    PortInst port = exp.getOriginalPort();
                    if (port.getPortProto().getCharacteristic() != p.e.getCharacteristic()) continue;
                    FixpRectangle geo = port.getPoly().getBounds2D();
                    assert (this.fillGenConfig.evenLayersHorizontal);
                    double deltaX = ((RectangularShape)geo).getCenterX() - newElemConnect.getCenterX();
                    double deltaY = ((RectangularShape)geo).getCenterY() - newElemConnect.getCenterY();
                    boolean condition = horizontalBar ? DBMath.isInBetween(((RectangularShape)geo).getCenterY(), newElemConnect.getMinY(), newElemConnect.getMaxY()) : DBMath.isInBetween(((RectangularShape)geo).getCenterX(), newElemConnect.getMinX(), newElemConnect.getMaxX());
                    if (!condition || !DBMath.isGreaterThan(minDistance, dist = Math.sqrt(deltaX * deltaX + deltaY * deltaY))) continue;
                    minDistance = dist;
                    fillNiPort = port;
                }
                if (fillNiPort == null) continue;
                EPoint center = fillNiPort.getCenter();
                Route exportRoute = container.router.planRoute(container.connectionCell, added.getOnlyPortInst(), fillNiPort, center, null, ep, false, false, null, null);
                Router.createRouteNoJob(exportRoute, container.connectionCell, arcsCreatedMap, nodesCreatedMap, ep);
            }
            if (pinNode == null) continue;
            Export pinExport = Export.newInst(container.connectionCell, pin, "proj-" + p.e.getName(), ep);
            assert (pinExport != null);
            pinExport.setCharacteristic(p.e.getCharacteristic());
            PortInst pinPort = container.connectionNi.findPortInstFromProto(pinExport);
            Route conTopExportRoute = container.router.planRoute(this.topCell, p.p, pinPort, new Point2D.Double(p.pPoly.getBounds2D().getCenterX(), p.pPoly.getBounds2D().getCenterY()), null, ep, false, false, null, null);
            HashMap<ArcProto, Integer> arcsCreatedMap = new HashMap<ArcProto, Integer>();
            HashMap<NodeProto, Integer> nodesCreatedMap = new HashMap<NodeProto, Integer>();
            Router.createRouteNoJob(conTopExportRoute, this.topCell, arcsCreatedMap, nodesCreatedMap, ep);
            return added;
        }
        return null;
    }

    private NodeInst addAllPossibleContactsOverPort(FillGenJobContainer container, PortConfig p, Rectangle2D contactArea, FixpTransform nodeTransOut, FixpTransform fillTransIn, Area exclusionArea, boolean noClosestPin) {
        EditingPreferences ep = this.getEditingPreferences();
        double contactAreaHeight = contactArea.getHeight();
        if (nodeTransOut != null) {
            DBMath.transformRect(contactArea, nodeTransOut);
        }
        if (exclusionArea != null && exclusionArea.intersects(contactArea)) {
            return null;
        }
        Export fillExport = this.searchOverlapHierarchicallyOverPort(container, container.fillCell, container.rotated, p, contactArea, fillTransIn, GenMath.MATID, noClosestPin);
        if (fillExport == null) {
            return null;
        }
        PortInst pinPort = container.fillNi.findPortInstFromProto(fillExport);
        PrimitiveNode thePin = FillCellGenJob.findPrimitiveNodeFromLayer(p.l);
        TechType techType = this.fillGenConfig.getTechType();
        assert (thePin != null);
        assert (thePin != techType.m1pin());
        Rectangle2D.Double portInConFill = new Rectangle2D.Double();
        ((Rectangle2D)portInConFill).setRect(p.pPoly.getBounds2D());
        DBMath.transformRect(portInConFill, fillTransIn);
        NodeInst pinNode = LayoutLib.newNodeInst(thePin, ep, portInConFill.getCenterX(), portInConFill.getCenterY(), thePin.getDefWidth(ep), contactAreaHeight, 0.0, container.connectionCell);
        PortInst pin = pinNode.getOnlyPortInst();
        Route pinExportRoute = container.router.planRoute(container.connectionCell, pin, pinPort, new Point2D.Double(portInConFill.getCenterX(), portInConFill.getCenterY()), null, ep, false, false, null, null);
        HashMap<ArcProto, Integer> arcsCreatedMap = new HashMap<ArcProto, Integer>();
        HashMap<NodeProto, Integer> nodesCreatedMap = new HashMap<NodeProto, Integer>();
        Router.createRouteNoJob(pinExportRoute, container.connectionCell, arcsCreatedMap, nodesCreatedMap, ep);
        Export pinExport = Export.newInst(container.connectionCell, pin, "proj-" + p.e.getName(), ep);
        if (pinExport != null) {
            pinExport.setCharacteristic(p.e.getCharacteristic());
            PortInst pinTopPort = container.connectionNi.findPortInstFromProto(pinExport);
            Route conTopExportRoute = container.router.planRoute(this.topCell, p.p, pinTopPort, new Point2D.Double(p.pPoly.getBounds2D().getCenterX(), p.pPoly.getBounds2D().getCenterY()), null, ep, false, false, null, null);
            Router.createRouteNoJob(conTopExportRoute, this.topCell, arcsCreatedMap, nodesCreatedMap, ep);
        } else {
            System.out.println("Error here");
        }
        return pinNode;
    }

    protected static class PortConfig {
        PortInst p;
        Export e;
        Layer l;
        Poly pPoly;

        PortConfig(PortInst p, Export e, Layer l) {
            this.e = e;
            this.p = p;
            this.pPoly = p.getPoly();
            this.l = l;
        }
    }

    private class Visitor
    extends HierarchyEnumerator.Visitor {
        private Area exclusionArea = new Area();
        private int level = -1;
        private int maxLevel = 0;

        public Visitor(int l) {
            this.maxLevel = l;
        }

        @Override
        public boolean enterCell(HierarchyEnumerator.CellInfo info) {
            if (this.level > this.maxLevel + 1) {
                return false;
            }
            ++this.level;
            return true;
        }

        @Override
        public void exitCell(HierarchyEnumerator.CellInfo info) {
            --this.level;
        }

        @Override
        public boolean visitNodeInst(Nodable no, HierarchyEnumerator.CellInfo info) {
            NodeProto np = no.getProto();
            if (!(np == Generic.tech().afgNode || ((FillCellGenJob)FillCellGenJob.this).fillGenConfig.onlyAround && no.isCellInstance())) {
                return false;
            }
            if (this.level > this.maxLevel) {
                return false;
            }
            if (this.level == this.maxLevel) {
                FixpTransform extra = info.getTransformToRoot();
                NodeInst ni = (NodeInst)no;
                Rectangle2D rect = (Rectangle2D)ni.getBounds().clone();
                DBMath.transformRect(rect, extra);
                this.exclusionArea.add(new Area(rect));
            }
            return true;
        }
    }

    private class FillGenJobContainer {
        InteractiveRouter router;
        Cell fillCell;
        Cell connectionCell;
        NodeInst fillNi;
        NodeInst connectionNi;
        List<NodeInst> fillContactList;
        double drcSpacing;
        boolean rotated;

        FillGenJobContainer(InteractiveRouter r, Cell fC, NodeInst fNi, Cell cC, NodeInst cNi, double drcSpacing, boolean rotated) {
            this.router = r;
            this.fillCell = fC;
            this.fillNi = fNi;
            this.connectionCell = cC;
            this.connectionNi = cNi;
            this.fillContactList = new ArrayList<NodeInst>();
            this.drcSpacing = drcSpacing;
            this.rotated = rotated;
        }
    }
}

