/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.api.minarea.errorLogging;

import com.sun.electric.api.minarea.ErrorLogger;
import com.sun.electric.api.minarea.geometry.Shapes;
import java.awt.Shape;
import java.awt.geom.Point2D;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public abstract class AbstractErrorLogger
implements ErrorLogger {
    protected List<MinAreaViolation> violations = new LinkedList<MinAreaViolation>();

    @Override
    public synchronized void reportMinAreaViolation(long area, int x, int y, Shape shape) {
        this.violations.add(new MinAreaViolation(area, x, y, shape));
    }

    public abstract void printReports(long var1);

    protected synchronized void sortViolations() {
        Collections.sort(this.violations);
    }

    protected class MinAreaViolation
    implements Comparable<MinAreaViolation> {
        private final long minArea;
        private final int x;
        private final int y;
        private final Shape shape;

        public MinAreaViolation(long minArea, int x, int y, Shape shape) {
            Point2D maxVertex;
            this.minArea = minArea;
            this.x = x;
            this.y = y;
            this.shape = shape;
            if (shape != null && ((double)x != (maxVertex = Shapes.maxVertex(shape)).getX() || (double)y != maxVertex.getY())) {
                throw new IllegalArgumentException();
            }
        }

        public long getMinArea() {
            return this.minArea;
        }

        public int getX() {
            return this.x;
        }

        public int getY() {
            return this.y;
        }

        public Shape getShape() {
            return this.shape;
        }

        public String toString() {
            return "(" + this.x + "," + this.y + ")";
        }

        @Override
        public int compareTo(MinAreaViolation v2) {
            if (this.x > v2.x) {
                return 1;
            }
            if (this.x < v2.x) {
                return -1;
            }
            if (this.y > v2.y) {
                return 1;
            }
            if (this.y < v2.y) {
                return -1;
            }
            return 0;
        }
    }
}

