/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.simulation.sctiming;

public class PinEdge {
    String pin;
    Transition transition;
    double stableVoltage;

    public PinEdge(String pin, Transition transition) {
        this.pin = pin;
        this.transition = transition;
        this.stableVoltage = 0.0;
    }

    public PinEdge(String pin, double stableVoltage) {
        this.pin = pin;
        this.transition = Transition.STABLEV;
        this.stableVoltage = stableVoltage;
    }

    public PinEdge getFinalState() {
        Transition t = this.transition;
        if (this.transition == Transition.RISE) {
            t = Transition.STABLE1;
        }
        if (this.transition == Transition.FALL) {
            t = Transition.STABLE0;
        }
        return new PinEdge(this.pin, t);
    }

    public PinEdge getInitialState() {
        Transition t = this.transition;
        if (this.transition == Transition.RISE) {
            t = Transition.STABLE0;
        }
        if (this.transition == Transition.FALL) {
            t = Transition.STABLE1;
        }
        return new PinEdge(this.pin, t);
    }

    public PinEdge getOpposite() {
        Transition t = this.transition;
        if (this.transition == Transition.RISE) {
            t = Transition.FALL;
        } else if (this.transition == Transition.FALL) {
            t = Transition.RISE;
        } else if (this.transition == Transition.STABLE0) {
            t = Transition.STABLE1;
        } else if (this.transition == Transition.STABLE1) {
            t = Transition.STABLE0;
        } else if (this.transition == Transition.STABLEV) {
            return new PinEdge(this.pin, this.stableVoltage);
        }
        return new PinEdge(this.pin, t);
    }

    public static enum Transition {
        STABLE1,
        STABLE0,
        RISE,
        FALL,
        STABLEV;

    }
}

