/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.routing;

import com.sun.electric.database.geometry.Dimension2D;
import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.prototype.ArcProto;
import com.sun.electric.database.prototype.NodeProto;
import com.sun.electric.database.prototype.PortProto;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.Connection;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.database.variable.ElectricObject;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.SizeOffset;
import com.sun.electric.tool.user.Highlight;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class RouteElement {
    private RouteElementAction action;
    private Cell cell;
    private boolean done;
    private boolean showHighlight;
    private NodeProto np;
    private PortProto newNodePort;
    private Point2D location;
    private double width;
    private double height;
    private boolean isBisectArcPin;
    private NodeInst newNodeInst;
    private List newArcs;
    private ArcProto ap;
    private double arcWidth;
    private RouteElement headRE;
    private RouteElement tailRE;
    private String arcName;
    private int arcAngle;
    private NodeInst nodeInstToDelete;
    private ArcInst arcInstToDelete;
    private PortInst existingPortInst;
    private Point2D connPoint;

    private RouteElement(RouteElementAction action) {
        this.action = action;
    }

    public static RouteElement newNode(Cell cell, NodeProto np, PortProto newNodePort, Point2D location, double width, double height) {
        RouteElement e = new RouteElement(RouteElementAction.newNode);
        e.done = false;
        e.cell = cell;
        e.np = np;
        e.newNodePort = newNodePort;
        e.location = location;
        e.newNodeInst = null;
        e.isBisectArcPin = false;
        e.newArcs = new ArrayList();
        e.setNodeSize(new Dimension2D.Double(width, height));
        e.showHighlight = true;
        e.connPoint = null;
        return e;
    }

    public static RouteElement newArc(Cell cell, ArcProto ap, double arcWidth, RouteElement headRE, RouteElement tailRE, String name) {
        RouteElement e = new RouteElement(RouteElementAction.newArc);
        e.done = false;
        e.cell = cell;
        e.ap = ap;
        e.arcWidth = arcWidth;
        e.headRE = headRE;
        e.tailRE = tailRE;
        e.arcName = name;
        if (headRE.getAction() != RouteElementAction.newNode && headRE.getAction() != RouteElementAction.existingPortInst) {
            System.out.println("  ERROR: headRE of newArc RouteElement must be newNode or existingPortInst");
        }
        if (tailRE.getAction() != RouteElementAction.newNode && tailRE.getAction() != RouteElementAction.existingPortInst) {
            System.out.println("  ERROR: tailRE of newArc RouteElement must be newNode or existingPortInst");
        }
        headRE.addConnectingNewArc(e);
        tailRE.addConnectingNewArc(e);
        e.arcAngle = 0;
        e.showHighlight = true;
        return e;
    }

    public static RouteElement deleteNode(NodeInst nodeInstToDelete) {
        RouteElement e = new RouteElement(RouteElementAction.deleteNode);
        e.done = false;
        e.nodeInstToDelete = nodeInstToDelete;
        e.showHighlight = true;
        e.cell = nodeInstToDelete.getParent();
        return e;
    }

    public static RouteElement deleteArc(ArcInst arcInstToDelete) {
        RouteElement e = new RouteElement(RouteElementAction.deleteArc);
        e.done = false;
        e.arcInstToDelete = arcInstToDelete;
        e.cell = arcInstToDelete.getParent();
        e.showHighlight = true;
        return e;
    }

    public static RouteElement existingPortInst(PortInst existingPortInst, Point2D connPoint) {
        RouteElement e = new RouteElement(RouteElementAction.existingPortInst);
        e.done = true;
        e.existingPortInst = existingPortInst;
        e.newArcs = new ArrayList();
        e.cell = existingPortInst.getNodeInst().getParent();
        e.showHighlight = true;
        e.connPoint = connPoint;
        return e;
    }

    public boolean isDone() {
        return this.done;
    }

    public void setDone() {
        this.done = true;
    }

    public RouteElementAction getAction() {
        return this.action;
    }

    public PortProto getPortProto() {
        if (this.action == RouteElementAction.newNode) {
            return this.newNodePort;
        }
        if (this.action == RouteElementAction.existingPortInst) {
            return this.existingPortInst.getPortProto();
        }
        return null;
    }

    public PortInst getConnectingPort() {
        if (!this.done) {
            return null;
        }
        if (this.action == RouteElementAction.existingPortInst) {
            return this.existingPortInst;
        }
        if (this.action == RouteElementAction.newNode) {
            return this.newNodeInst.findPortInstFromProto(this.newNodePort);
        }
        return null;
    }

    public ArcProto getArcProto() {
        if (this.action == RouteElementAction.newArc) {
            return this.ap;
        }
        if (this.action == RouteElementAction.deleteArc) {
            return this.arcInstToDelete.getProto();
        }
        return null;
    }

    public Cell getCell() {
        return this.cell;
    }

    public Point2D getLocation() {
        if (this.action == RouteElementAction.newNode) {
            return this.location;
        }
        if (this.action == RouteElementAction.existingPortInst) {
            return this.getConnPoint();
        }
        if (this.action == RouteElementAction.deleteNode) {
            return this.nodeInstToDelete.getTrueCenter();
        }
        return null;
    }

    public double getArcWidth() {
        if (this.action != RouteElementAction.newArc) {
            return -1.0;
        }
        return this.arcWidth;
    }

    public double getOffsetArcWidth() {
        if (this.action != RouteElementAction.newArc) {
            return -1.0;
        }
        return this.arcWidth - this.ap.getWidthOffset();
    }

    public void setArcWidth(double width) {
        if (this.action == RouteElementAction.newArc) {
            this.arcWidth = width;
        }
    }

    public void setArcAngle(int angle) {
        if (this.action == RouteElementAction.newArc) {
            this.arcAngle = angle;
        }
    }

    public boolean isNewArcVertical() {
        if (this.action == RouteElementAction.newArc) {
            Point2D head = this.headRE.getLocation();
            Point2D tail = this.tailRE.getLocation();
            if (head == null || tail == null) {
                return false;
            }
            if (head.getX() == tail.getX()) {
                return true;
            }
        }
        return false;
    }

    public boolean isNewArcHorizontal() {
        if (this.action == RouteElementAction.newArc) {
            Point2D head = this.headRE.getLocation();
            Point2D tail = this.tailRE.getLocation();
            if (head == null || tail == null) {
                return false;
            }
            if (head.getY() == tail.getY()) {
                return true;
            }
        }
        return false;
    }

    public String toString() {
        if (this.action == RouteElementAction.newNode) {
            return "RouteElement newNode " + this.np + " size " + this.width + "," + this.height + " at " + this.location;
        }
        if (this.action == RouteElementAction.deleteNode) {
            return "RouteElement deleteNode " + this.nodeInstToDelete;
        }
        if (this.action == RouteElementAction.existingPortInst) {
            return "RouteElement existingPortInst " + this.existingPortInst;
        }
        if (this.action == RouteElementAction.newArc) {
            return "RouteElement newArc " + this.ap + ",\nhead: " + this.headRE + "\ntail: " + this.tailRE;
        }
        if (this.action == RouteElementAction.deleteArc) {
            return "RouteElement deleteArc " + this.arcInstToDelete;
        }
        return "RouteElement bad action";
    }

    public void setBisectArcPin(boolean state) {
        if (this.action == RouteElementAction.newNode) {
            this.isBisectArcPin = state;
        }
    }

    public boolean isBisectArcPin() {
        if (this.action == RouteElementAction.newNode) {
            return this.isBisectArcPin;
        }
        return false;
    }

    public void replaceArcEnd(RouteElement oldEnd, RouteElement newEnd) {
        if (this.action == RouteElementAction.newArc) {
            if (this.headRE == oldEnd) {
                this.headRE = newEnd;
                oldEnd.removeConnectingNewArc(this);
                newEnd.addConnectingNewArc(this);
            }
            if (this.tailRE == oldEnd) {
                this.tailRE = newEnd;
                oldEnd.removeConnectingNewArc(this);
                newEnd.addConnectingNewArc(this);
            }
        }
    }

    private void addConnectingNewArc(RouteElement re) {
        if (re.getAction() != RouteElementAction.newArc) {
            return;
        }
        if (this.action == RouteElementAction.newNode) {
            this.newArcs.add(re);
        }
        if (this.action == RouteElementAction.existingPortInst) {
            this.newArcs.add(re);
        }
    }

    private void removeConnectingNewArc(RouteElement re) {
        if (re.getAction() != RouteElementAction.newArc) {
            return;
        }
        this.newArcs.remove(re);
    }

    public double getWidestConnectingArc(ArcProto ap) {
        Iterator it;
        double width = -1.0;
        if (this.action == RouteElementAction.existingPortInst) {
            it = this.existingPortInst.getConnections();
            while (it.hasNext()) {
                double newWidth;
                Connection conn = (Connection)it.next();
                ArcInst arc = conn.getArc();
                if (arc.getProto() != ap || !((newWidth = arc.getWidth() - arc.getProto().getWidthOffset()) > width)) continue;
                width = newWidth;
            }
        }
        if (this.action == RouteElementAction.newNode) {
            if (this.newArcs == null) {
                return -1.0;
            }
            it = this.newArcs.iterator();
            while (it.hasNext()) {
                RouteElement re = (RouteElement)it.next();
                if (re.getArcProto() != ap || !(re.getOffsetArcWidth() > width)) continue;
                width = re.getOffsetArcWidth();
            }
        }
        if (this.action == RouteElementAction.newArc && this.getArcProto() == ap && this.getOffsetArcWidth() > width) {
            return this.getOffsetArcWidth();
        }
        return width;
    }

    public Iterator getNewArcs() {
        if (this.action == RouteElementAction.newNode) {
            return this.newArcs.iterator();
        }
        ArrayList list = new ArrayList();
        return list.iterator();
    }

    public Dimension2D.Double getNodeSize() {
        if (this.action == RouteElementAction.newNode) {
            return new Dimension2D.Double(this.width, this.height);
        }
        if (this.action == RouteElementAction.existingPortInst) {
            NodeInst ni = this.existingPortInst.getNodeInst();
            return new Dimension2D.Double(ni.getXSize(), ni.getYSize());
        }
        return new Dimension2D.Double(-1.0, -1.0);
    }

    public void setNodeSize(Dimension2D size) {
        if (this.action == RouteElementAction.newNode) {
            SizeOffset so = this.np.getProtoSizeOffset();
            double widthoffset = so.getLowXOffset() + so.getHighXOffset();
            double heightoffset = so.getLowYOffset() + so.getHighYOffset();
            double defWidth = this.np.getDefWidth() - widthoffset;
            double defHeight = this.np.getDefHeight() - heightoffset;
            this.width = size.getWidth() > defWidth ? size.getWidth() : defWidth;
            this.height = size.getHeight() > defHeight ? size.getHeight() : defHeight;
        }
    }

    public Point2D getConnPoint() {
        if (this.action == RouteElementAction.newNode) {
            if (this.connPoint != null) {
                return this.connPoint;
            }
            if (this.done) {
                Rectangle2D bounds = this.getConnectingPort().getBounds();
                return new Point2D.Double(bounds.getCenterX(), bounds.getCenterY());
            }
        }
        if (this.action == RouteElementAction.existingPortInst) {
            if (this.connPoint != null) {
                return this.connPoint;
            }
            Rectangle2D bounds = this.getConnectingPort().getBounds();
            return new Point2D.Double(bounds.getCenterX(), bounds.getCenterY());
        }
        return null;
    }

    public void setShowHighlight(boolean b) {
        this.showHighlight = b;
    }

    public ElectricObject doAction() {
        if (this.done) {
            return null;
        }
        if (this.action == RouteElementAction.newNode) {
            SizeOffset so = this.np.getProtoSizeOffset();
            double widthso = this.width + so.getLowXOffset() + so.getHighXOffset();
            double heightso = this.height + so.getLowYOffset() + so.getHighYOffset();
            this.newNodeInst = NodeInst.makeInstance(this.np, this.location, widthso, heightso, 0, this.cell, null);
            if (this.newNodeInst == null) {
                return null;
            }
            this.setDone();
            return this.newNodeInst;
        }
        if (this.action == RouteElementAction.deleteNode) {
            this.nodeInstToDelete.kill();
            this.setDone();
        }
        if (this.action == RouteElementAction.newArc) {
            PrimitiveNode pNp;
            Dimension2D autoGrowth;
            NodeInst tailNi;
            NodeProto np;
            Poly tailPoly;
            PrimitiveNode pNp2;
            Dimension2D autoGrowth2;
            NodeInst headNi;
            NodeProto np2;
            PortInst headPi = this.headRE.getConnectingPort();
            PortInst tailPi = this.tailRE.getConnectingPort();
            Point2D headPoint = this.headRE.getConnPoint();
            Point2D tailPoint = this.tailRE.getConnPoint();
            Poly headPoly = headPi.getPoly();
            if (!headPoly.isInside(headPoint) && (np2 = (headNi = headPi.getNodeInst()).getProto()) instanceof PrimitiveNode && (autoGrowth2 = (pNp2 = (PrimitiveNode)np2).getAutoGrowth()) != null) {
                headNi.modifyInstance(0.0, 0.0, autoGrowth2.getWidth(), autoGrowth2.getHeight(), 0);
            }
            if (!(tailPoly = tailPi.getPoly()).isInside(tailPoint) && (np = (tailNi = tailPi.getNodeInst()).getProto()) instanceof PrimitiveNode && (autoGrowth = (pNp = (PrimitiveNode)np).getAutoGrowth()) != null) {
                tailNi.modifyInstance(0.0, 0.0, autoGrowth.getWidth(), autoGrowth.getHeight(), 0);
            }
            ArcInst newAi = ArcInst.makeInstance(this.ap, this.arcWidth, headPi, headPoint, tailPi, tailPoint, this.arcName);
            if (this.arcAngle != 0) {
                newAi.setAngle(this.arcAngle);
            }
            this.setDone();
            return newAi;
        }
        if (this.action == RouteElementAction.deleteArc) {
            this.arcInstToDelete.kill();
            this.setDone();
        }
        return null;
    }

    public void addHighlightArea() {
        if (!this.showHighlight) {
            return;
        }
        if (this.action == RouteElementAction.newNode) {
            Rectangle2D.Double bounds = new Rectangle2D.Double(this.location.getX() - 0.5 * this.width, this.location.getY() - 0.5 * this.height, this.width, this.height);
            Highlight.addArea(bounds, this.cell);
        }
        if (this.action == RouteElementAction.newArc) {
            Point2D headPoint = this.headRE.getLocation();
            Point2D tailPoint = this.tailRE.getLocation();
            double angle = Math.atan((tailPoint.getY() - headPoint.getY()) / (tailPoint.getX() - headPoint.getX()));
            double offsetX = 0.5 * this.width * Math.cos(angle);
            double offsetY = 0.5 * this.width * Math.sin(angle);
            Point2D.Double head1 = new Point2D.Double(headPoint.getX() + offsetX, headPoint.getY() + offsetY);
            Point2D.Double head2 = new Point2D.Double(headPoint.getX() - offsetX, headPoint.getY() - offsetY);
            Point2D.Double tail1 = new Point2D.Double(tailPoint.getX() + offsetX, tailPoint.getY() + offsetY);
            Point2D.Double tail2 = new Point2D.Double(tailPoint.getX() - offsetX, tailPoint.getY() - offsetY);
            Highlight.addLine(head1, tail1, this.cell);
            Highlight.addLine(headPoint, tailPoint, this.cell);
            Highlight.addLine(head2, tail2, this.cell);
            Highlight.addLine(head1, head2, this.cell);
            Highlight.addLine(tail1, tail2, this.cell);
        }
        if (this.action == RouteElementAction.existingPortInst) {
            Highlight.addElectricObject(this.existingPortInst, this.cell);
        }
        if (this.action == RouteElementAction.deleteArc) {
            Highlight.addElectricObject(this.arcInstToDelete, this.cell);
        }
    }

    public static class RouteElementAction {
        private String name;
        public static final RouteElementAction newNode = new RouteElementAction("newNode");
        public static final RouteElementAction newArc = new RouteElementAction("newArc");
        public static final RouteElementAction deleteNode = new RouteElementAction("deleteNode");
        public static final RouteElementAction deleteArc = new RouteElementAction("deleteArc");
        public static final RouteElementAction existingPortInst = new RouteElementAction("existingPortInst");

        public RouteElementAction(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

