/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.ncc.jemNets;

import com.sun.electric.tool.generator.layout.LayoutLib;
import com.sun.electric.tool.ncc.basic.Primes;
import com.sun.electric.tool.ncc.jemNets.Part;
import com.sun.electric.tool.ncc.jemNets.PinType;
import com.sun.electric.tool.ncc.jemNets.Wire;
import com.sun.electric.tool.ncc.trees.Circuit;
import com.sun.electric.tool.ncc.trees.NetObject;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class Transistor
extends Part {
    public static final Type NTYPE = new Type("NMOS");
    public static final Type PTYPE = new Type("PMOS");
    private static final List PIN_TYPES = new ArrayList();
    private final int[] term_coeffs;
    private double width;
    private final double length;
    private final Type type;

    public Set getPinTypes() {
        int t = this.type == NTYPE ? 0 : 1;
        ArrayList l1 = (ArrayList)PIN_TYPES.get(t);
        int c = this.isCapacitor() ? 1 : 0;
        ArrayList l2 = (ArrayList)l1.get(c);
        int s = this.numSeries() - 1;
        Set pinTypes = (Set)l2.get(s);
        return pinTypes;
    }

    private Transistor(Type np, String name, double width, double length, Wire[] pins) {
        super(name, pins);
        this.type = np;
        this.width = width;
        this.length = length;
        LayoutLib.error(this.type != NTYPE && this.type != PTYPE, "bad type");
        this.term_coeffs = CoeffGen.getCoeffArray(pins.length);
    }

    private boolean matchForward(Transistor t) {
        for (int i = 0; i < this.pins.length; ++i) {
            if (this.pins[i] == t.pins[i]) continue;
            return false;
        }
        return true;
    }

    private boolean matchReverse(Transistor t) {
        for (int i = 0; i < this.pins.length; ++i) {
            int j = this.pins.length - 1 - i;
            if (this.pins[i] == t.pins[j]) continue;
            return false;
        }
        return true;
    }

    private boolean samePinsAs(Transistor t) {
        if (this.pins.length != t.pins.length) {
            return false;
        }
        return this.matchForward(t) || this.matchReverse(t);
    }

    private void flip() {
        for (int i = 0; i < this.pins.length / 2; ++i) {
            int j = this.pins.length - 1 - i;
            Wire w = this.pins[i];
            this.pins[i] = this.pins[j];
            this.pins[j] = w;
        }
    }

    private Wire hiDiff() {
        return this.pins[this.pins.length - 1];
    }

    private Wire loDiff() {
        return this.pins[0];
    }

    public Transistor(Type np, String name, double width, double length, Wire src, Wire gate, Wire drn) {
        this(np, name, width, length, new Wire[]{src, gate, drn});
    }

    public Type getType() {
        return this.type;
    }

    public double getLength() {
        return this.length;
    }

    public double getWidth() {
        return this.width;
    }

    public boolean isNtype() {
        return this.type == NTYPE;
    }

    public boolean isPtype() {
        return this.type == PTYPE;
    }

    public boolean isThisGate(int x) {
        return x != 0 && x != this.pins.length - 1;
    }

    public int numSeries() {
        return this.pins.length - 2;
    }

    public int[] getTermCoefs() {
        return this.term_coeffs;
    }

    public boolean touchesAtGate(Wire w) {
        for (int i = 1; i < this.pins.length - 1; ++i) {
            if (w != this.pins[i]) continue;
            return true;
        }
        return false;
    }

    public boolean touchesAtDiffusion(Wire w) {
        return w == this.pins[0] || w == this.pins[this.pins.length - 1];
    }

    public boolean isCapacitor() {
        return this.pins[0] == this.pins[this.pins.length - 1];
    }

    public Integer hashCodeForParallelMerge() {
        int hc = this.pins.length;
        for (int i = 0; i < this.pins.length; ++i) {
            hc += this.pins[i].hashCode() * this.term_coeffs[i];
        }
        hc += this.getClass().hashCode();
        return new Integer(hc += this.type.hashCode());
    }

    public boolean parallelMerge(Part p) {
        if (!(p instanceof Transistor)) {
            return false;
        }
        Transistor t = (Transistor)p;
        if (this == t) {
            return false;
        }
        if (!this.isLike(t)) {
            return false;
        }
        if (!this.samePinsAs(t)) {
            return false;
        }
        this.width += t.width;
        t.deleteMe();
        return true;
    }

    public int typeCode() {
        int tw = 4;
        return 1 + ((this.isCapacitor() ? 1 : 0) << 4) + ((this.isNtype() ? 1 : 0) << 5) + (this.numSeries() << 6);
    }

    public String typeString() {
        String t = this.type.name;
        String c = this.isCapacitor() ? "_CAP" : "";
        String h = this.pins.length == 3 ? "" : "_" + (this.pins.length - 2) + "stack";
        return t + c + h;
    }

    public String nameString() {
        return this.typeString() + " " + this.getName();
    }

    public String connectionString(int n) {
        String msg = "";
        for (int i = 0; i < this.pins.length; ++i) {
            msg = i == 0 ? msg + "S=" : (i == this.pins.length - 1 ? msg + " D=" : (this.pins.length == 3 ? msg + " G=" : msg + " G" + i + "="));
            msg = msg + this.pins[i].getName();
        }
        return msg;
    }

    public String connectionString(Wire w) {
        String s = "";
        for (int i = 0; i < this.pins.length; ++i) {
            if (this.pins[i] != w) continue;
            if (s.length() != 0) {
                s = s + ",";
            }
            s = i == 0 ? s + "S" : (i == this.pins.length - 1 ? s + "D" : (this.pins.length == 3 ? s + "G" : s + "G" + i));
        }
        return s;
    }

    public boolean isLike(Transistor t) {
        return this.type == t.type && this.length == t.length;
    }

    public String valueString() {
        return "W= " + this.width + " L= " + this.length;
    }

    public static boolean joinOnWire(Wire w) {
        if (w.getPort() != null) {
            return false;
        }
        if (w.isGlobal()) {
            return false;
        }
        if (w.numParts() != 2) {
            return false;
        }
        if (w.numPartPins() != 2) {
            return false;
        }
        NetObject ta = null;
        NetObject tb = null;
        Iterator it = w.getParts();
        while (it.hasNext()) {
            Part p = (Part)it.next();
            if (!(p instanceof Transistor)) {
                return false;
            }
            Transistor t = (Transistor)p;
            if (!t.touchesAtDiffusion(w)) {
                return false;
            }
            if (t.touchesAtGate(w)) {
                return false;
            }
            if (ta == null) {
                ta = t;
                continue;
            }
            tb = t;
        }
        Transistor.error(ta == null || tb == null, "can't happen");
        Transistor.error(ta == tb, "part should only occur once on wire");
        Transistor.error(ta.getParent() != tb.getParent(), "mismatched parents?");
        if (!((Transistor)ta).isLike((Transistor)tb)) {
            return false;
        }
        if (((Transistor)ta).width != ((Transistor)tb).width) {
            return false;
        }
        if (super.hiDiff() != w) {
            super.flip();
        }
        if (super.loDiff() != w) {
            super.flip();
        }
        Transistor.error(super.hiDiff() != w || super.loDiff() != w, "joinOnWire: diffusion connections corrupted");
        Wire[] mergedPins = new Wire[((Transistor)ta).pins.length + ((Transistor)tb).pins.length - 2];
        for (int aNdx = 0; aNdx < ((Transistor)ta).pins.length - 1; ++aNdx) {
            mergedPins[aNdx] = ((Transistor)ta).pins[aNdx];
        }
        for (int bNdx = 1; bNdx < ((Transistor)tb).pins.length; ++bNdx) {
            mergedPins[aNdx++] = ((Transistor)tb).pins[bNdx];
        }
        Transistor stack = new Transistor(((Transistor)ta).getType(), ta.getName(), ((Transistor)ta).getWidth(), ((Transistor)ta).getLength(), mergedPins);
        Circuit parent = tb.getParent();
        parent.adopt(stack);
        ((Part)ta).deleteMe();
        ((Part)tb).deleteMe();
        Transistor.error(w.numParts() != 0, "wire not empty?");
        w.killMe();
        return true;
    }

    public Integer computeHashCode() {
        int sumLo = 0;
        int sumHi = 0;
        for (int i = 0; i < (this.pins.length + 1) / 2; ++i) {
            sumLo += this.pins[i].getCode() * this.term_coeffs[i];
            int j = this.pins.length - 1 - i;
            sumHi += this.pins[j].getCode() * this.term_coeffs[j];
        }
        return new Integer(sumLo * sumHi);
    }

    static {
        Type[] types = new Type[]{NTYPE, PTYPE};
        for (int i = 0; i < 2; ++i) {
            ArrayList tList = new ArrayList();
            PIN_TYPES.add(tList);
            Type type = types[i];
            for (int j = 0; j < 2; ++j) {
                ArrayList cList = new ArrayList();
                tList.add(cList);
                boolean cap = j != 0;
                for (int numSeries = 1; numSeries <= 5; ++numSeries) {
                    HashSet<PinType> pinTypes = new HashSet<PinType>();
                    cList.add(pinTypes);
                    pinTypes.add(new DiffType(type, numSeries, cap));
                    int maxHeight = (numSeries + 1) / 2;
                    for (int gateHeight = 1; gateHeight <= maxHeight; ++gateHeight) {
                        pinTypes.add(new GateType(type, numSeries, gateHeight, cap));
                    }
                }
            }
        }
    }

    private static class CoeffGen {
        private static ArrayList coeffArrays = new ArrayList();

        private CoeffGen() {
        }

        private static void ensureListEntry(int numPins) {
            while (coeffArrays.size() - 1 < numPins) {
                coeffArrays.add(null);
            }
        }

        public static int[] getCoeffArray(int numPins) {
            CoeffGen.ensureListEntry(numPins);
            int[] coeffArray = (int[])coeffArrays.get(numPins);
            if (coeffArray == null) {
                coeffArray = new int[numPins];
                for (int i = 0; i < (numPins + 1) / 2; ++i) {
                    int j = numPins - 1 - i;
                    int nthPrime = 30 + i + numPins;
                    coeffArray[i] = coeffArray[j] = Primes.get(nthPrime);
                }
                coeffArrays.set(numPins, coeffArray);
            }
            return coeffArray;
        }
    }

    private static class DiffType
    implements PinType {
        private final int numSeries;
        private final Type np;
        private final boolean cap;

        public int numConnectionsToPinOfThisType(Part p, Wire w) {
            if (!(p instanceof Transistor)) {
                return 0;
            }
            Transistor t = (Transistor)p;
            if (t.getType() != this.np) {
                return 0;
            }
            if (t.numSeries() != this.numSeries) {
                return 0;
            }
            if (this.cap != t.isCapacitor()) {
                return 0;
            }
            int count = 0;
            if (t.pins[0] == w) {
                ++count;
            }
            if (t.pins[this.numSeries + 1] == w) {
                ++count;
            }
            return count;
        }

        public String description() {
            String t = this.np == NTYPE ? "NMOS" : "PMOS";
            String c = this.cap ? "_CAP" : "";
            String h = this.numSeries == 1 ? "" : "_" + this.numSeries + "stack";
            return t + c + h + " diffusion";
        }

        public DiffType(Type np, int numSeries, boolean cap) {
            LayoutLib.error(np != NTYPE && np != PTYPE, "bad type");
            LayoutLib.error(numSeries < 1, "bad numSeries");
            int highestGateInLowerHalfOfStack = (numSeries + 1) / 2;
            this.np = np;
            this.numSeries = numSeries;
            this.cap = cap;
        }
    }

    private static class GateType
    implements PinType {
        private final int numSeries;
        private final Type np;
        private final int gateHeight;
        private final boolean cap;

        public int numConnectionsToPinOfThisType(Part p, Wire w) {
            if (!(p instanceof Transistor)) {
                return 0;
            }
            Transistor t = (Transistor)p;
            if (t.getType() != this.np) {
                return 0;
            }
            if (t.numSeries() != this.numSeries) {
                return 0;
            }
            if (this.cap != t.isCapacitor()) {
                return 0;
            }
            int loGate = this.gateHeight;
            int hiGate = this.numSeries + 1 - this.gateHeight;
            int numPins = this.numSeries + 2;
            int count = 0;
            if (t.pins[loGate] == w) {
                ++count;
            }
            if (loGate != hiGate && t.pins[hiGate] == w) {
                ++count;
            }
            return count;
        }

        public String description() {
            String t = this.np == NTYPE ? "NMOS" : "PMOS";
            String c = this.cap ? "_CAP" : "";
            String h = this.numSeries == 1 ? "" : "_" + this.numSeries + "stack";
            int hiGate = this.numSeries + 1 - this.gateHeight;
            String g = "";
            if (this.numSeries > 2) {
                g = this.gateHeight + (this.gateHeight == hiGate ? "" : "/" + hiGate);
            }
            return t + c + h + " gate" + g;
        }

        public GateType(Type np, int numSeries, int gateHeight, boolean cap) {
            LayoutLib.error(np != NTYPE && np != PTYPE, "bad type");
            LayoutLib.error(numSeries < 1, "bad numSeries");
            int highestGateInLowerHalfOfStack = (numSeries + 1) / 2;
            LayoutLib.error(gateHeight > highestGateInLowerHalfOfStack, "bad gate Height");
            this.np = np;
            this.numSeries = numSeries;
            this.gateHeight = gateHeight;
            this.cap = cap;
        }
    }

    public static class Type {
        private String name;

        private Type(String s) {
            this.name = s;
        }
    }
}

