/*
 * Decompiled with CFR 0.152.
 */
package org.videolan.vlma.daemon;

import com.thoughtworks.xstream.XStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.net.InetAddress;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.htmlparser.Node;
import org.htmlparser.Parser;
import org.htmlparser.filters.HasAttributeFilter;
import org.htmlparser.filters.OrFilter;
import org.htmlparser.filters.TagNameFilter;
import org.htmlparser.nodes.TextNode;
import org.htmlparser.util.NodeList;
import org.htmlparser.util.ParserException;
import org.videolan.vlma.common.Configuration;
import org.videolan.vlma.common.IVlData;
import org.videolan.vlma.common.IVlOrderGiver;
import org.videolan.vlma.common.VlMonostate;
import org.videolan.vlma.common.VlServer;
import org.videolan.vlma.common.VlServerReal;
import org.videolan.vlma.common.adapters.IVlAdapter;
import org.videolan.vlma.common.adapters.VlDVBS;
import org.videolan.vlma.common.adapters.VlDVBT;
import org.videolan.vlma.common.exceptions.AdapterAlreadyExistsException;
import org.videolan.vlma.common.exceptions.AdapterDoesNotExistException;
import org.videolan.vlma.common.exceptions.AdapterParameterDoesNotExistException;
import org.videolan.vlma.common.exceptions.MediaAlreadyExistsException;
import org.videolan.vlma.common.exceptions.MediaDoesNotExistException;
import org.videolan.vlma.common.exceptions.SatelliteAlreadyExistsException;
import org.videolan.vlma.common.exceptions.SatelliteDoesNotExistException;
import org.videolan.vlma.common.exceptions.ServerAlreadyExistsException;
import org.videolan.vlma.common.exceptions.ServerDoesNotExistException;
import org.videolan.vlma.common.medias.IVlMedia;
import org.videolan.vlma.common.medias.VlFilesChannel;
import org.videolan.vlma.common.medias.VlMedia;
import org.videolan.vlma.common.medias.VlSatChannel;
import org.videolan.vlma.common.medias.VlSatellite;
import org.videolan.vlma.common.medias.VlTNTChannel;
import org.videolan.vlma.common.orders.VlOrder;
import org.videolan.vlma.common.programs.IVlProgram;
import org.videolan.vlma.common.programs.VlIpBank;
import org.videolan.vlma.common.programs.VlProgram;
import org.videolan.vlma.daemon.VlOrderGiver;
import org.videolan.vlma.daemon.VlOrderMonitoring;
import org.videolan.vlma.daemon.VlServerMonitoring;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VlData
implements IVlData {
    private static final Logger logger = Logger.getLogger(VlData.class);
    private List<VlServer> servers = new ArrayList<VlServer>();
    private List<IVlMedia> medias = new ArrayList<IVlMedia>(200);
    private HashMap<Integer, List<VlOrder>> orders;
    private VlIpBank ipBank = new VlIpBank(this);
    private List<VlSatellite> satellites;
    private VlOrderGiver orderGiver;
    private VlOrderMonitoring orderMonitoring;
    private VlServerMonitoring serverMonitoring;
    private static XStream xstream = new XStream();

    public VlData() {
        this.orders = new HashMap();
        this.orderGiver = new VlOrderGiver(this);
        this.satellites = new ArrayList<VlSatellite>();
    }

    @Override
    public synchronized Configuration getConfiguration() {
        return Configuration.getInstance();
    }

    @Override
    public synchronized List<VlSatellite> getSatellites() {
        return this.satellites;
    }

    @Override
    public synchronized VlSatellite getSatellite(int satellite) throws SatelliteDoesNotExistException {
        for (VlSatellite s : this.satellites) {
            if (s.hashCode() != satellite) continue;
            return s;
        }
        throw new SatelliteDoesNotExistException("Satellite " + satellite + " doesn't exist.");
    }

    @Override
    public synchronized void clearSatelliteCoverages(int satellite) throws SatelliteDoesNotExistException {
        VlSatellite s = this.getSatellite(satellite);
        s.getCoverages().clear();
    }

    @Override
    public synchronized void addSatelliteCoverage(int satellite, String coverage) throws SatelliteDoesNotExistException {
        coverage = coverage.trim();
        VlSatellite s = this.getSatellite(satellite);
        for (String c : coverage.split("\n")) {
            s.getCoverages().add(c.trim());
        }
    }

    private synchronized void addSatelliteToTheList(VlSatellite s, String name) {
        this.satellites.add(s);
        logger.log(Level.DEBUG, "Satellite " + name + " added.");
    }

    @Override
    public synchronized int addSatellite(String name) throws SatelliteAlreadyExistsException {
        VlSatellite s = new VlSatellite(name);
        if (this.satellites != null) {
            if (this.satellites.contains(s)) {
                throw new SatelliteAlreadyExistsException("Datellite " + name + " already exists.");
            }
            this.addSatelliteToTheList(s, name);
            return s.hashCode();
        }
        this.addSatelliteToTheList(s, name);
        return s.hashCode();
    }

    @Override
    public List<String> getSatelliteCoverages(int satellite) throws SatelliteDoesNotExistException {
        VlSatellite s = this.getSatellite(satellite);
        return s.getCoverages();
    }

    @Override
    public void removeSatellite(int satellite) throws SatelliteDoesNotExistException {
        VlSatellite s = this.getSatellite(satellite);
        this.satellites.remove(s);
    }

    @Override
    public synchronized List<VlServer> getServers() {
        return this.servers;
    }

    @Override
    public synchronized VlServer getServer(int server) throws ServerDoesNotExistException {
        for (VlServer s : this.servers) {
            if (s.hashCode() != server) continue;
            return s;
        }
        throw new ServerDoesNotExistException("Server " + server + " doesn't exist.");
    }

    @Override
    public synchronized VlServer getServer(String server) throws ServerDoesNotExistException {
        for (VlServer s : this.servers) {
            logger.log(Level.DEBUG, "Server-test : " + s.getName());
            logger.log(Level.DEBUG, "Server : " + server);
            if (!s.getName().equals(server)) continue;
            return s;
        }
        throw new ServerDoesNotExistException("Server " + server + " doesn't exist.");
    }

    @Override
    public synchronized void setServerIp(int server, InetAddress newIp) throws ServerDoesNotExistException {
        VlServer s = this.getServer(server);
        s.setIp(newIp);
    }

    @Override
    public synchronized int addServer(String name) throws ServerAlreadyExistsException {
        VlServer s;
        try {
            Constructor<? extends VlServer> myConstructor = VlMonostate.serverClass.getConstructor(String.class, InetAddress.class);
            s = myConstructor.newInstance(name, null);
        }
        catch (Exception e) {
            throw new ServerAlreadyExistsException("Serveur class invalid.");
        }
        if (this.servers.contains(s)) {
            throw new ServerAlreadyExistsException("Server " + name + " already exists.");
        }
        this.servers.add(s);
        logger.log(Level.DEBUG, "Serveur " + name + " added.");
        return s.hashCode();
    }

    @Override
    public synchronized void removeServer(int server) throws ServerDoesNotExistException {
        VlServer sv = this.getServer(server);
        if (!this.servers.remove(sv)) {
            throw new ServerDoesNotExistException("Server " + server + " doesn't exist.");
        }
        logger.log(Level.DEBUG, "Serveur " + server + " removed.");
    }

    @Override
    public synchronized Map<String, IVlAdapter> getAdapters(int server) throws ServerDoesNotExistException {
        VlServer s = this.getServer(server);
        return s.getAdapters();
    }

    @Override
    public synchronized IVlAdapter getAdapter(int server, String name) throws ServerDoesNotExistException, AdapterDoesNotExistException {
        VlServer s = this.getServer(server);
        HashMap m = (HashMap)s.getAdapters();
        IVlAdapter a = (IVlAdapter)m.get(name);
        if (a == null) {
            throw new AdapterDoesNotExistException("Adapter " + name + " doesn't exist on server " + server + ".");
        }
        return a;
    }

    @Override
    public synchronized void setAdapterName(int server, String name, String newName) throws AdapterDoesNotExistException, AdapterAlreadyExistsException {
        VlServer s = this.getServer(server);
        Map<String, IVlAdapter> m = s.getAdapters();
        IVlAdapter a = m.get(name);
        if (a == null) {
            throw new AdapterDoesNotExistException("Adapter " + name + " doesn't exist on server " + server + ".");
        }
        if (m.containsKey(newName)) {
            throw new AdapterAlreadyExistsException("Adapter " + newName + " already exists in server " + server + ".");
        }
        a.setName(newName);
        m.put(newName, a);
        m.remove(name);
    }

    @Override
    public synchronized void setAdapterParameter(int server, String name, String parameter, String value) throws AdapterDoesNotExistException, AdapterParameterDoesNotExistException {
        VlServer s = this.getServer(server);
        Map<String, IVlAdapter> m = s.getAdapters();
        IVlAdapter a = m.get(name);
        if (a == null) {
            throw new AdapterDoesNotExistException("Adapter " + name + " doesn't exist in server " + server + ".");
        }
        a.setParameter(parameter, value, this);
    }

    @Override
    public synchronized void addAdapter(int server, String name, String type) throws AdapterAlreadyExistsException, IllegalAccessException, InstantiationException, ClassNotFoundException {
        VlServer s = this.getServer(server);
        Map<String, IVlAdapter> m = s.getAdapters();
        if (m.containsKey(name)) {
            throw new AdapterAlreadyExistsException("Adapter " + name + " already exists in server " + server + ".");
        }
        Class<?> c = Class.forName(type);
        IVlAdapter a = (IVlAdapter)c.newInstance();
        a.setName(name);
        a.setServer(s);
        m.put(name, a);
    }

    @Override
    public synchronized void removeAdapter(int server, String name) throws AdapterDoesNotExistException {
        VlServer s = this.getServer(server);
        Map<String, IVlAdapter> m = s.getAdapters();
        if (m.remove(name) == null) {
            throw new AdapterDoesNotExistException("Adapter " + name + " doesn't exist in server " + server + ".");
        }
    }

    @Override
    public synchronized List<IVlMedia> getMedias() {
        return this.medias;
    }

    @Override
    public synchronized IVlMedia getMedia(int media) {
        for (IVlMedia m : this.medias) {
            if (!(m.getClass().equals(VlSatChannel.class) ? ((VlSatChannel)m).hashCode() == media : (m.getClass().equals(VlTNTChannel.class) ? ((VlTNTChannel)m).hashCode() == media : m.getClass().equals(VlFilesChannel.class) && ((VlFilesChannel)m).hashCode() == media))) continue;
            return m;
        }
        throw new MediaDoesNotExistException("Media " + media + " doesn't exist");
    }

    @Override
    public synchronized int addMedia(IVlMedia media) {
        if (this.medias.contains(media)) {
            throw new MediaAlreadyExistsException("Media " + media.getName() + " already exists");
        }
        this.medias.add(media);
        logger.log(Level.DEBUG, "Media " + media.getName() + " added.");
        return media.hashCode();
    }

    @Override
    public synchronized void removeMedia(int media) {
        IVlMedia m = this.getMedia(media);
        if (!this.medias.remove(m)) {
            throw new MediaDoesNotExistException("Media " + media + " doesn't exist");
        }
        logger.log(Level.DEBUG, "Media " + media + " removed");
    }

    @Override
    public synchronized void updateMediaProgram(int media, IVlProgram program) throws MediaDoesNotExistException {
        IVlMedia m = this.getMedia(media);
        m.setProgram(program);
        logger.log(Level.DEBUG, "New programmation for media " + media);
    }

    @Override
    public synchronized VlProgram addMediaProgram(int media) throws MediaDoesNotExistException {
        IVlMedia m = this.getMedia(media);
        VlProgram program = new VlProgram();
        InetAddress a = this.ipBank.getIp();
        logger.log(Level.DEBUG, "Multicast IPv4 address for " + m.getName() + ": " + a.toString());
        program.setIp(a);
        m.setProgram(program);
        return program;
    }

    @Override
    public synchronized void setFilesChannelFilesList(int filesChannel, String files) throws MediaDoesNotExistException {
        files = files.trim();
        IVlMedia m = this.getMedia(filesChannel);
        ((VlFilesChannel)m).setFiles(new ArrayList<String>());
        for (String c : files.split("\n")) {
            ((VlFilesChannel)m).getFiles().add(c.trim());
        }
    }

    @Override
    public synchronized void setFilesChannelServer(int filesChannel, String server) throws ServerDoesNotExistException {
        IVlMedia m = this.getMedia(filesChannel);
        ((VlFilesChannel)m).setServer(this.getServer(server));
    }

    private static String htmlCellExtract(NodeList nodes, int column, int row, int maxRow) throws ParserException {
        String result = "";
        if (maxRow == 0) {
            Node text = nodes.elementAt(column);
            result = text.toPlainTextString();
        } else {
            TagNameFilter brTagFilter = new TagNameFilter("br");
            NodeList breakLines = nodes.elementAt(column).getChildren().extractAllNodesThatMatch(brTagFilter);
            if (breakLines.size() == maxRow) {
                if (row == 0) {
                    Node text = breakLines.elementAt(0).getPreviousSibling();
                    while (!(text instanceof TextNode) || "".equals(((TextNode)text).getText().trim())) {
                        if ((text = text.getPreviousSibling()) != null) continue;
                        return "";
                    }
                    result = ((TextNode)text).getText();
                } else {
                    Node text = breakLines.elementAt(row - 1).getNextSibling();
                    while (!(text instanceof TextNode) || "".equals(((TextNode)text).getText().trim())) {
                        if ((text = text.getNextSibling()) != null) continue;
                        return "";
                    }
                    result = ((TextNode)text).getText();
                }
            }
        }
        result = result.replaceAll("&nbsp;", " ");
        return result.trim();
    }

    @Override
    public synchronized void updateSatChannels(URL source) throws IOException {
        ArrayList<String> tvFilter = new ArrayList<String>();
        HashSet<String> coverages = new HashSet<String>();
        tvFilter.add("TV-DIG-CRYPT");
        tvFilter.add("TV-DIG");
        tvFilter.add("R-DIG");
        tvFilter.add("R-DIG-CRYPT");
        tvFilter.add("TV-HD");
        HashSet<VlSatChannel> newMedias = new HashSet<VlSatChannel>();
        newMedias.clear();
        logger.log(Level.DEBUG, "Downloading " + source.toString() + ".");
        try {
            Parser parser = new Parser(source.openConnection());
            NodeList rows = parser.parse(new TagNameFilter("tr"));
            logger.log(Level.DEBUG, source.toString() + " downloaded and parsed.");
            int frequency = 0;
            char polarisation = 'A';
            String coverage = "";
            OrFilter thTagFilter = new OrFilter(new TagNameFilter("th"), new HasAttributeFilter("rowspan"));
            TagNameFilter tdTagFilter = new TagNameFilter("td");
            for (int i = 0; i < rows.size(); ++i) {
                Node node = rows.elementAt(i);
                NodeList thCells = node.getChildren().extractAllNodesThatMatch(thTagFilter);
                NodeList tdCells = node.getChildren().extractAllNodesThatMatch(tdTagFilter);
                if (tdCells.size() != 8) continue;
                if (thCells.size() == 2) {
                    frequency = (int)(Double.parseDouble(VlData.htmlCellExtract(thCells, 0, 1, 2).split(" ")[0]) * 1000.0);
                    polarisation = VlData.htmlCellExtract(thCells, 0, 2, 2).charAt(0);
                    coverage = VlData.htmlCellExtract(thCells, 1, 0, 0);
                }
                String name = VlData.htmlCellExtract(tdCells, 1, 0, 3);
                String category = VlData.htmlCellExtract(tdCells, 0, 0, 2);
                String encryption = VlData.htmlCellExtract(tdCells, 2, 1, 3);
                int symbolRate = 27500;
                try {
                    symbolRate = (int)Double.parseDouble(VlData.htmlCellExtract(tdCells, 3, 0, 3)) * 1000;
                }
                catch (ArrayIndexOutOfBoundsException e) {
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
                int errorCorrection = 9;
                try {
                    errorCorrection = Integer.parseInt(VlData.htmlCellExtract(tdCells, 3, 0, 3).substring(0, 1));
                }
                catch (ArrayIndexOutOfBoundsException e) {
                }
                catch (StringIndexOutOfBoundsException e) {
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
                int sid = 0;
                try {
                    sid = Integer.parseInt(VlData.htmlCellExtract(tdCells, 4, 1, 3));
                }
                catch (NumberFormatException e) {
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    // empty catch block
                }
                String country = VlData.htmlCellExtract(tdCells, 5, 0, 3);
                VlSatChannel ch = new VlSatChannel();
                ch.setFrequency(frequency);
                ch.setPolarisation(polarisation);
                ch.setCoverage(coverage);
                ch.setName(name);
                ch.setCategory(category);
                ch.setEncryption(encryption);
                ch.setSymbolRate(symbolRate);
                ch.setErrorCorrection(errorCorrection);
                ch.setSid(sid);
                ch.setCountry(country);
                if (!tvFilter.contains(ch.getCategory())) continue;
                newMedias.add(ch);
            }
        }
        catch (ParserException e) {
            throw new IOException();
        }
        for (VlSatChannel ch : newMedias) {
            logger.log(Level.DEBUG, "Adding " + ch.getName());
            coverages.add(ch.getCoverage());
            if (!this.medias.contains(ch)) continue;
            ch.setProgram(this.medias.get(this.medias.indexOf(ch)).getProgram());
        }
        logger.log(Level.DEBUG, "Got " + newMedias.size() + " channels");
        Iterator<IVlMedia> k = this.medias.iterator();
        while (k.hasNext()) {
            VlMedia ch = (VlMedia)k.next();
            if (ch.getClass().getName() != "VlSatChannel" || !coverages.contains(((VlSatChannel)ch).getCoverage())) continue;
            k.remove();
        }
        this.medias.addAll(newMedias);
        this.sortMedias();
        logger.log(Level.DEBUG, "Ending analysis of " + source.toString());
    }

    @Override
    public HashMap<Integer, List<VlOrder>> getOrders() {
        return this.orders;
    }

    @Override
    public void giveOrders() {
        this.orderGiver.computeOrders();
    }

    @Override
    public IVlOrderGiver getOrderGiver() {
        return this.orderGiver;
    }

    @Override
    public synchronized void saveToDisk() throws FileNotFoundException, IOException {
        ArrayList<List<Object>> saveList = new ArrayList<List<Object>>();
        saveList.add(this.satellites);
        saveList.add(this.servers);
        saveList.add(this.medias);
        String vlmaHomePath = new String(System.getProperty("user.home") + File.separator + ".vlma" + File.separator);
        File vlmaHome = new File(vlmaHomePath);
        if (!vlmaHome.exists()) {
            vlmaHome.mkdir();
        }
        FileOutputStream f = new FileOutputStream(vlmaHomePath + "data.xml");
        xstream.toXML(saveList, f);
        f.close();
        f = new FileOutputStream(vlmaHomePath + "config.xml");
        xstream.toXML((Object)this.getConfiguration(), f);
        f.close();
    }

    @Override
    public synchronized void loadFromDisk() throws FileNotFoundException, IOException {
        FileInputStream f;
        String vlmaHomePath = new String(System.getProperty("user.home") + File.separator + ".vlma" + File.separator);
        try {
            f = new FileInputStream(vlmaHomePath + "data.xml");
            List loadList = (List)xstream.fromXML(f);
            f.close();
            this.satellites = (List)loadList.get(0);
            this.servers = (List)loadList.get(1);
            this.medias = (List)loadList.get(2);
        }
        catch (FileNotFoundException e) {
            logger.log(Level.WARN, "Unable to read data.xml");
        }
        try {
            f = new FileInputStream(vlmaHomePath + "config.xml");
            Configuration configuration = this.getConfiguration();
            configuration = (Configuration)xstream.fromXML(f);
            f.close();
        }
        catch (FileNotFoundException e) {
            logger.log(Level.WARN, "Unable to read config.xml");
        }
    }

    public synchronized void initIPs(boolean IPsDevel) {
        try {
            this.ipBank.initIps(IPsDevel);
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
    }

    public void setServers(List<VlServer> servers) {
        this.servers = servers;
    }

    public void setMedias(List<IVlMedia> medias) {
        this.medias = medias;
    }

    @Override
    public void sortMedias() {
        Collections.sort(this.medias);
    }

    public void startServerMonitoringDaemon() {
        this.serverMonitoring.startServerMonitoringDeamon();
    }

    public void startOrderMonitoringDaemon() {
        this.orderMonitoring.startOrderMonitoringDeamon();
    }

    @Override
    public void startOrderMonitoring() {
        this.orderMonitoring.startOrderMonitoringThread();
    }

    @Override
    public void startCheckAllVLCs() {
        this.serverMonitoring.startCheckVLCThread();
    }

    public void setOrderMonitoring(VlOrderMonitoring var) {
        this.orderMonitoring = var;
    }

    public void setServerMonitoring(VlServerMonitoring var) {
        this.serverMonitoring = var;
    }

    static {
        xstream.alias("satellite", VlSatellite.class);
        xstream.alias("satChannel", VlSatChannel.class);
        xstream.alias("server", VlServer.class);
        xstream.alias("server", VlServerReal.class);
        xstream.alias("dvb-t", VlDVBT.class);
        xstream.alias("dvb-s", VlDVBS.class);
        xstream.alias("program", VlProgram.class);
        xstream.alias("tntChannel", VlTNTChannel.class);
        xstream.alias("configuration", Configuration.class);
        xstream.setMode(1004);
    }
}

