/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.scripting.support;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.io.Resource;
import org.springframework.scripting.ScriptSource;
import org.springframework.util.Assert;
import org.springframework.util.FileCopyUtils;
import org.springframework.util.StringUtils;

public class ResourceScriptSource
implements ScriptSource {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private final Resource resource;
    private long lastModified = -1L;
    private final Object lastModifiedMonitor = new Object();

    public ResourceScriptSource(Resource resource) {
        Assert.notNull(resource, "Resource must not be null");
        this.resource = resource;
    }

    public final Resource getResource() {
        return this.resource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getScriptAsString() throws IOException {
        InputStreamReader reader;
        block10: {
            File file;
            block9: {
                file = null;
                try {
                    file = this.getResource().getFile();
                }
                catch (IOException ex) {
                    if (!this.logger.isDebugEnabled()) break block9;
                    this.logger.debug(this.getResource() + " could not be resolved in the file system - " + "cannot store last-modified timestamp for obtained script", ex);
                }
            }
            Object ex = this.lastModifiedMonitor;
            synchronized (ex) {
                this.lastModified = file != null ? file.lastModified() : 0L;
            }
            reader = null;
            if (file != null) {
                try {
                    reader = new FileReader(file);
                }
                catch (FileNotFoundException ex2) {
                    if (!this.logger.isDebugEnabled()) break block10;
                    this.logger.debug("Could not open FileReader for " + this.resource + " - falling back to InputStreamReader", ex2);
                }
            }
        }
        if (reader == null) {
            reader = new InputStreamReader(this.resource.getInputStream());
        }
        return FileCopyUtils.copyToString(reader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isModified() {
        Object object = this.lastModifiedMonitor;
        synchronized (object) {
            return this.lastModified < 0L || this.retrieveLastModifiedTime() > this.lastModified;
        }
    }

    protected long retrieveLastModifiedTime() {
        try {
            return this.getResource().getFile().lastModified();
        }
        catch (IOException ex) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug(this.getResource() + " could not be resolved in the file system - " + "current timestamp not available for script modification check", ex);
            }
            return 0L;
        }
    }

    public String suggestedClassName() {
        return StringUtils.stripFilenameExtension(this.getResource().getFilename());
    }

    public String toString() {
        return this.resource.toString();
    }
}

