/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.orm.jdo.support;

import javax.jdo.PersistenceManager;
import javax.jdo.PersistenceManagerFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.orm.jdo.PersistenceManagerFactoryUtils;
import org.springframework.orm.jdo.PersistenceManagerHolder;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import org.springframework.ui.ModelMap;
import org.springframework.web.context.request.WebRequest;
import org.springframework.web.context.request.WebRequestInterceptor;

public class OpenPersistenceManagerInViewInterceptor
implements WebRequestInterceptor {
    public static final String PARTICIPATE_SUFFIX = ".PARTICIPATE";
    protected final Log logger = LogFactory.getLog(this.getClass());
    private PersistenceManagerFactory persistenceManagerFactory;

    public void setPersistenceManagerFactory(PersistenceManagerFactory pmf) {
        this.persistenceManagerFactory = pmf;
    }

    public PersistenceManagerFactory getPersistenceManagerFactory() {
        return this.persistenceManagerFactory;
    }

    public void preHandle(WebRequest request) throws DataAccessException {
        if (TransactionSynchronizationManager.hasResource(this.getPersistenceManagerFactory())) {
            String participateAttributeName = this.getParticipateAttributeName();
            Integer count = (Integer)request.getAttribute(participateAttributeName, 0);
            int newCount = count != null ? count + 1 : 1;
            request.setAttribute(this.getParticipateAttributeName(), new Integer(newCount), 0);
        } else {
            this.logger.debug("Opening JDO PersistenceManager in OpenPersistenceManagerInViewInterceptor");
            PersistenceManager pm = PersistenceManagerFactoryUtils.getPersistenceManager(this.getPersistenceManagerFactory(), true);
            TransactionSynchronizationManager.bindResource(this.getPersistenceManagerFactory(), new PersistenceManagerHolder(pm));
        }
    }

    public void postHandle(WebRequest request, ModelMap model) {
    }

    public void afterCompletion(WebRequest request, Exception ex) throws DataAccessException {
        String participateAttributeName = this.getParticipateAttributeName();
        Integer count = (Integer)request.getAttribute(participateAttributeName, 0);
        if (count != null) {
            if (count > 1) {
                request.setAttribute(participateAttributeName, new Integer(count - 1), 0);
            } else {
                request.removeAttribute(participateAttributeName, 0);
            }
        } else {
            PersistenceManagerHolder pmHolder = (PersistenceManagerHolder)TransactionSynchronizationManager.unbindResource(this.getPersistenceManagerFactory());
            this.logger.debug("Closing JDO PersistenceManager in OpenPersistenceManagerInViewInterceptor");
            PersistenceManagerFactoryUtils.releasePersistenceManager(pmHolder.getPersistenceManager(), this.getPersistenceManagerFactory());
        }
    }

    protected String getParticipateAttributeName() {
        return this.getPersistenceManagerFactory().toString() + PARTICIPATE_SUFFIX;
    }
}

