

class SignalHandlerStorage:
    """
    The signal storage is used to keep track of signal handlers and
    provides a way to disconnect all of them in an simple way.
    """

    def __init__(self):
        """
        Initialize the signal storage.
        """
        self._handlers = {}

    def connect(self, obj, signal, callback, *args):
        """
        Connect a signal handler. All handlers connected in this way
        can be disconnected by calling disconnet().

        @param obj: the object to connect the handler to
        @type obj: gobject.GObject
        @param signal: the signal to listen for
        @type signal: str
        @param callback: the callback method
        @type callback: function object
        """
        handler_id = obj.connect(signal, callback, *args)
        self._handlers.setdefault(obj, []).append(handler_id)

    def disconnect_all(self):
        """
        Disconnect all handlers.
        """
        for obj, handler_ids in self._handlers.iteritems():
            for hid in handler_ids:
                obj.disconnect(hid)

        self._handlers = {}
