# This is a shell script that calls functions and scripts from
# tml@iki.fi's personal work environment. It is not expected to be
# usable unmodified by others, and is included only for reference.

MOD=GConf
VER=2.22.0
REV=3
ARCH=win32

THIS=${MOD}_${VER}-${REV}_${ARCH}

RUNZIP=${MOD}_${VER}-${REV}_${ARCH}.zip
DEVZIP=${MOD}-dev_${VER}-${REV}_${ARCH}.zip

HEX=`echo $THIS | md5sum | cut -d' ' -f1`
TARGET=c:/devel/target/$HEX

usedev

(

set -x

DEPS=`latest --arch=${ARCH} glib atk pango cairo gtk+ libIDL ORBit2 libxml2`
PROXY_LIBINTL=`latest --arch=${ARCH} proxy-libintl`
WIN_ICONV=`latest --arch=${ARCH} win-iconv`

PKG_CONFIG_PATH=/dummy
for D in $DEPS; do
    PATH="/devel/dist/${ARCH}/$D/bin:$PATH"
    [ -d /devel/dist/${ARCH}/$D/lib/pkgconfig ] && PKG_CONFIG_PATH=/devel/dist/${ARCH}/$D/lib/pkgconfig:$PKG_CONFIG_PATH
done

# Avoid the silly "relink" stuff in libtool
sed -e 's/need_relink=yes/need_relink=no # no way --tml/' <ltmain.sh >ltmain.temp && mv ltmain.temp ltmain.sh

# Avoid using "file" in libtool. Otherwise libtool won't create a
# shared library, and give the warning "Trying to link with static lib
# archive [...] But I can only do this if you have shared version of
# the library, which you do not appear to have." I know what I am
# doing, I do want to link with a static libintl now. (The
# proxy-libintl libintl wrapper.)

sed -e 's!file /!dont-want-to-use-file!' <configure >configure.temp && mv configure.temp configure

patch -p0 --verbose <<'EOF'
--- gconf/Makefile.in
+++ gconf/Makefile.in
@@ -347,7 +347,7 @@
 	gconfd.h		\
 	gconfd.c
 
-gconfd_2_LDADD = $(EFENCE) $(INTLLIBS) $(DEPENDENT_LIBS) libgconf-$(MAJOR_VERSION).la
+gconfd_2_LDADD = -mwindows $(EFENCE) $(INTLLIBS) $(DEPENDENT_LIBS) libgconf-$(MAJOR_VERSION).la
 
 # gconf_testclient_SOURCES = \
 # 	testclient.c
Index: ChangeLog
===================================================================
--- ChangeLog	(revision 2590)
+++ ChangeLog	(revision 2749)
@@ -1,3 +1,57 @@
+2009-01-27  Tor Lillqvist  <tml@novell.com>
+
+	* gconf/gconfd.c (main): Call g_thread_init(NULL) here as
+	libORBit-2 would anyway, and it is best to call g_thread_init() as
+	early as possible if it will be called at all.
+
+2009-01-27  Tor Lillqvist  <tml@novell.com>
+
+	Merge changes from my build scripts.
+
+	* gconf/gconf-internals.c (create_new_locked_file): Drop the Win9x
+	code path. There is no Win9x support any more lower in the stack
+	anyway.
+
+	* gconf/gconf-internals.c: Rework locking on Windows.
+
+	(create_new_locked_file): Don't attempt to use shared open with
+	deny modes on Windows, that never worked correctly here.
+
+	(gconf_release_lock): Truncate the file to zero size before
+	closing. This is to avoid race conditions, as we don't want the
+	file to exist but with seemingly valid contents between closing
+	and unlinking.
+
+2009-01-27  Tor Lillqvist  <tml@novell.com>
+
+	Merge from trunk:
+
+	* gconf/dllmain.c (setup): Drop the Win9x code path. There is no
+	Win9x support any more lower in the stack anyway.
+
+2009-01-27  Tor Lillqvist  <tml@novell.com>
+
+	Committing this here in the gnome-2-22 branch because this is what
+	is still used on Windows without dbus.
+	
+	* gconf/Makefile.am (gconfd_2_LDFLAGS): Use the -mwindows flag
+	when linking on Windows, so that we build a "GUI" executable.
+
+	* gconf/gconfd.c (main): On Windows, with GCONF_DEBUG_OUTPUT set,
+	make sure stdout and stderr go somewhere. Use the parent's console
+	window if possible, otherwise open an own console window. If we
+	had to open an own console window, give the user a chance to read
+	the output when exiting. Same idea that has been successfully used
+	in GIMP for a while.
+
+2008-05-14  Ray Strode  <rstrode@redhat.com>
+
+	* configure.in: bump glib require to 2.14
+	* backends/markup-backend.c (cleanup_timeout),
+	(ms_new), (ms_destroy): remove some if 0'd code,
+	and drop g_source_remove on non-existant timeout
+	to prevent warning
+
 =========================== gconf 2.22.0 ===========================
 
 2008-02-19  Josselin Mouette  <joss@malsain.org>
Index: gconf/gconfd.c
===================================================================
--- gconf/gconfd.c	(revision 2590)
+++ gconf/gconfd.c	(revision 2749)
@@ -55,6 +55,13 @@
 #endif
 #include <locale.h>
 
+#ifdef G_OS_WIN32
+#include <io.h>
+#include <conio.h>
+#define _WIN32_WINNT 0x0500 
+#include <windows.h>
+#endif
+
 /* This makes hash table safer when debugging */
 #ifndef GCONF_ENABLE_DEBUG
 #define safe_g_hash_table_insert g_hash_table_insert
@@ -550,6 +557,19 @@
   return TRUE;
 }
 
+#ifdef G_OS_WIN32
+
+static void
+wait_console_window (void)
+{
+  SetConsoleTitle ("GConf daemon exiting. Type any character to close this window.");
+  printf ("\n"
+	  "(GConf daemon exiting. Type any character to close this window)\n");
+  _getch ();
+}
+
+#endif
+
 int 
 main(int argc, char** argv)
 {
@@ -568,6 +588,8 @@
   int dev_null_fd;
   int write_byte_fd;
 
+  g_thread_init (NULL);
+
   _gconf_init_i18n ();
   setlocale (LC_ALL, "");
   textdomain (GETTEXT_PACKAGE);
@@ -601,6 +623,45 @@
   else
     {
       gconf_log_debug_messages = TRUE;
+#ifdef G_OS_WIN32
+      if (fileno (stdout) != -1 &&
+	  _get_osfhandle (fileno (stdout)) != -1)
+	{
+	  /* stdout is fine, presumably redirected to a file or pipe */
+	}
+      else
+	{
+	  int allocated_new_console = FALSE;
+
+	  typedef BOOL (* WINAPI AttachConsole_t) (DWORD);
+
+	  AttachConsole_t p_AttachConsole =
+	    (AttachConsole_t) GetProcAddress (GetModuleHandle ("kernel32.dll"), "AttachConsole");
+
+	  if (p_AttachConsole != NULL)
+	    {
+	      if (!AttachConsole (ATTACH_PARENT_PROCESS))
+		{
+		  if (AllocConsole ())
+		    allocated_new_console = TRUE;
+		}
+
+	      freopen ("CONOUT$", "w", stdout);
+	      dup2 (fileno (stdout), 1);
+	      freopen ("CONOUT$", "w", stderr);
+	      dup2 (fileno (stderr), 2);
+
+	      if (allocated_new_console)
+		{
+		  SetConsoleTitle ("GConf daemon debugging output. You can minimize this window, but don't close it.");
+		  printf ("You asked for debugging output by setting the GCONF_DEBUG_OUTPUT\n"
+			  "environment variable, so here it is.\n"
+			  "\n");
+		  atexit (wait_console_window);
+		}
+	    }
+	}
+#endif
     }
   
   umask (022);
Index: gconf/dllmain.c
===================================================================
--- gconf/dllmain.c	(revision 2590)
+++ gconf/dllmain.c	(revision 2749)
@@ -68,11 +68,10 @@
 static void
 setup (void)
 {
-  char *full_prefix;
+  char *full_prefix = NULL;
   char *cp_prefix; 
 
   wchar_t wcbfr[1000];
-  char cpbfr[1000];
   
   G_LOCK (mutex);
   if (locale_dir != NULL)
@@ -81,27 +80,14 @@
       return;
     }
 
-  if (G_WIN32_HAVE_WIDECHAR_API ())
+  if (GetModuleFileNameW (hmodule, wcbfr, G_N_ELEMENTS (wcbfr)))
     {
-      /* NT-based Windows has wide char API */
-      if (GetModuleFileNameW (hmodule, wcbfr, G_N_ELEMENTS (wcbfr)))
-	{
-	  full_prefix = g_utf16_to_utf8 (wcbfr, -1, NULL, NULL, NULL);
-	  if (GetShortPathNameW (wcbfr, wcbfr, G_N_ELEMENTS (wcbfr)))
-	    cp_prefix = g_utf16_to_utf8 (wcbfr, -1, NULL, NULL, NULL);
-	  else if (full_prefix)
-	    cp_prefix = g_locale_from_utf8 (full_prefix, -1, NULL, NULL, NULL);
-	}
+      full_prefix = g_utf16_to_utf8 (wcbfr, -1, NULL, NULL, NULL);
+      if (GetShortPathNameW (wcbfr, wcbfr, G_N_ELEMENTS (wcbfr)))
+	cp_prefix = g_utf16_to_utf8 (wcbfr, -1, NULL, NULL, NULL);
+      else if (full_prefix)
+	cp_prefix = g_locale_from_utf8 (full_prefix, -1, NULL, NULL, NULL);
     }
-  else
-    {
-      /* Win9x */
-      if (GetModuleFileNameA (hmodule, cpbfr, G_N_ELEMENTS (cpbfr)))
-	{
-	  full_prefix = g_locale_to_utf8 (cpbfr, -1, NULL, NULL, NULL);
-	  cp_prefix = g_strdup (cpbfr);
-	}
-    }
 
   if (full_prefix != NULL)
     {
Index: gconf/gconf-internals.c
===================================================================
--- gconf/gconf-internals.c	(revision 2590)
+++ gconf/gconf-internals.c	(revision 2749)
@@ -37,8 +37,9 @@
 #include <math.h>
 
 #ifdef G_OS_WIN32
+#define WIN32_LEAN_AND_MEAN
 #include <windows.h>
-#include <share.h>
+#include <io.h>
 #define pipe(fds) _pipe(fds, 4096, _O_BINARY)
 #endif
 
@@ -2188,8 +2189,6 @@
 #endif
 }
 
-#endif
-
 #ifdef F_SETLK
 /* Your basic Stevens cut-and-paste */
 static int
@@ -2242,8 +2241,6 @@
 #endif
 }
 
-#ifndef G_OS_WIN32
-
 static char*
 unique_filename (const char *directory)
 {
@@ -2323,21 +2320,20 @@
 
 #else
 
-  if (G_WIN32_HAVE_WIDECHAR_API ())
-    {
-      wchar_t *wfilename = g_utf8_to_utf16 (filename, -1, NULL, NULL, NULL);
-      fd = _wsopen (wfilename, O_WRONLY|O_CREAT|O_EXCL, SH_DENYWR, 0700);
-      g_free (wfilename);
-    }
-  else
-    {
-      char *cpfilename = g_locale_from_utf8 (filename, -1, NULL, NULL, NULL);
-      fd = _sopen (cpfilename, O_WRONLY|O_CREAT|O_EXCL, SH_DENYWR, 0700);
-      g_free (cpfilename);
-    }
+  wchar_t *wfilename = g_utf8_to_utf16 (filename, -1, NULL, NULL, NULL);
 
+  fd = _wopen (wfilename, O_WRONLY|O_CREAT|O_NOINHERIT|O_EXCL, 0700);
+  g_free (wfilename);
+
   got_lock = (fd >= 0);
 
+  if (!got_lock)
+    g_set_error (err,
+		 GCONF_ERROR,
+		 GCONF_ERROR_LOCK_FAILED,
+		 _("Could not create file '%s', probably because it already exists"),
+		 filename);
+
 #endif
 
   if (!got_lock)
@@ -2626,6 +2622,8 @@
   retval = FALSE;
   uniquefile = NULL;
   
+#ifndef G_OS_WIN32
+
   /* A paranoia check to avoid disaster if e.g.
    * some random client code opened and closed the
    * lockfile (maybe Nautilus checking its MIME type or
@@ -2642,8 +2640,6 @@
       goto out;
     }
 
-#ifndef G_OS_WIN32
-
   /* To avoid annoying .nfs3435314513453145 files on unlink, which keep us
    * from removing the lock directory, we don't want to hold the
    * lockfile open after removing all links to it. But we can't
@@ -2678,6 +2674,16 @@
       goto out;
     }
 
+#else
+
+  /* On Windows we just truncate the file to zero size as we can't
+   * easily rename or unlink it while it is open. This is to avoid
+   * race conditions, as we don't want the file to exist but with
+   * seemingly valid contents between closing and unlinking.
+   */
+  if (lock->lock_fd >= 0)
+    chsize (lock->lock_fd, 0);
+
 #endif
 
   /* Now drop our lock */
@@ -2701,6 +2707,19 @@
       goto out;
     }
 
+#else
+
+  if (g_unlink (lock->iorfile) < 0)
+    {
+      g_set_error (err,
+                   GCONF_ERROR,
+                   GCONF_ERROR_FAILED,
+                   _("Failed to clean up file '%s': %s"),
+                   lock->iorfile, g_strerror (errno));
+
+      goto out;
+    }
+
 #endif
 
   /* And finally clean up the directory - this would have failed if
Index: backends/markup-backend.c
===================================================================
--- backends/markup-backend.c	(revision 2590)
+++ backends/markup-backend.c	(revision 2749)
@@ -59,7 +59,6 @@
 {
   GConfSource source; /* inherit from GConfSource */
   char *root_dir;
-  guint timeout_id;
   GConfLock* lock;
   MarkupTree *tree;
   guint dir_mode;
@@ -875,21 +874,6 @@
  *  MarkupSource
  */ 
 
-/* This timeout periodically unloads
- * data that hasn't been used in a while.
- */
-static gboolean
-cleanup_timeout (gpointer data)
-{
-#if 0
-  MarkupSource* ms = (MarkupSource*)data;
-
-  cache_clean(ms->cache, 60*5 /* 5 minutes */);
-#endif
-  
-  return TRUE;
-}
-
 static MarkupSource*
 ms_new (const char* root_dir,
         guint       dir_mode,
@@ -903,10 +887,6 @@
 
   ms = g_new0(MarkupSource, 1);
 
-  ms->timeout_id = g_timeout_add (1000*60*5, /* 1 sec * 60 s/min * 5 min */
-                                  cleanup_timeout,
-                                  ms);
-
   ms->root_dir = g_strdup (root_dir);
   
   ms->lock = lock;
@@ -943,12 +921,6 @@
       error = NULL;
     }
   
-  if (!g_source_remove (ms->timeout_id))
-    {
-      /* should not happen, don't translate */
-      gconf_log (GCL_ERR, "timeout not found to remove?");
-    }
-
   markup_tree_unref (ms->tree);
 
   g_free (ms->root_dir);
EOF

CC='gcc -mtune=pentium3 -mthreads' CPPFLAGS="-I/devel/dist/${ARCH}/${PROXY_LIBINTL}/include -I/devel/dist/${ARCH}/${WIN_ICONV}/include" LDFLAGS="-L/devel/dist/${ARCH}/${PROXY_LIBINTL}/lib -Wl,--exclude-libs=libintl.a -Wl,--enable-auto-image-base" CFLAGS=-O2 ./configure --enable-debug=yes --disable-gtk-doc --disable-static --prefix=$TARGET &&
libtoolcacheize &&

make install &&

./gconf-zip &&

mv /tmp/${MOD}-${VER}.zip /tmp/$RUNZIP &&
mv /tmp/${MOD}-dev-${VER}.zip /tmp/$DEVZIP

) 2>&1 | tee /devel/src/tml/packaging/$THIS.log

(cd /devel && zip /tmp/$DEVZIP src/tml/packaging/$THIS.{sh,log}) &&
manifestify /tmp/$RUNZIP /tmp/$DEVZIP
