aircraft.livery.init("Aircraft/fokker50/Models/Liveries");

# Fokker F27 Friendship
# Fokker 50
# Fokker 60


var init = 1;
var dt = 0.1;
var views = props.globals.getNode("sim").getChildren("view");
var shininess = getprop("sim/model/livery/shininess");

var newModel = func {
  setprop("/sim/model/fokker50/f27-100", 0);
  setprop("/sim/model/fokker50/f50", 0);
  setprop("/sim/model/fokker50/f60", 0);

  var index = getprop("sim/current-view/view-number");
  var val = getprop("/sim/model/fokker50/dialogs/model-type");
  if (val == "Fokker F27 Friendship") {
    setprop("/sim/model/fokker50/f27-100", 1);
    var path = "/F27";
    var name = "Golden Knights";
    setprop("sim/view[0]/config/z-offset-m", -6.25);
    setprop("sim/view[100]/config/z-offset-m", -6.25);
  } else if (val == "Fokker 60") {
    setprop("/sim/model/fokker50/f60", 1);
    var path = "/F60";
    var name = "KLM Cityhopper";
    setprop("sim/view[0]/config/z-offset-m", -8.25);
    setprop("sim/view[100]/config/z-offset-m", -8.25);
  } else {
    setprop("/sim/model/fokker50/f50", 1);
    var path = "";
    var name = "KLM Cityhopper";
    setprop("sim/view[0]/config/z-offset-m", -7.25);
    setprop("sim/view[100]/config/z-offset-m", -7.25);
  }

  aircraft.livery.dialog.close();
  aircraft.livery.init("Aircraft/fokker50/Models/Liveries" ~ path);
  if (!init) aircraft.livery.dialog.toggle();
  init = 0;

  if (index == 0 or index == 9 or index == 10) {
    var z_offset = views[index].getValue("config/z-offset-m");
    interpolate("sim/current-view/z-offset-m", z_offset, dt);
  }
}

if (getprop("sim/model/fokker50/f27-100")) {
  setprop("/sim/model/fokker50/dialogs/model-type", "Fokker F27 Friendship");
} else if (getprop("sim/model/fokker50/f60")) {
  setprop("/sim/model/fokker50/dialogs/model-type", "Fokker 60");
} else {
  setprop("/sim/model/fokker50/dialogs/model-type", "Fokker 50");
}

settimer(newModel, 2);

# View offsets
setlistener("/sim/current-view/view-number", func(n) {
  var index = getprop("sim/current-view/view-number");
  if (index == 0 or index == 9 or index == 10) {
    var z_offset = views[0].getValue("config/z-offset-m");
    interpolate("sim/current-view/z-offset-m", z_offset, dt);
  }
}, 0);


# Smoke support
var smoke_switch = props.globals.getNode("/sim/model/fokker50/smoke", 1);
var smoke_avail = props.globals.getNode("/sim/model/livery/smoke", 1);
var smoke_set = props.globals.getNode("/sim/multiplay/generic/int[0]", 1);

var smoke_timer = maketimer(0.33, func {
  if (smoke_switch.getBoolValue() and smoke_avail.getBoolValue()) {
    smoke_set.setBoolValue(1);
  } else {
    smoke_set.setBoolValue(0);
  }
});

smoke_timer.start();

# Dirt support
var applyDirt = func {
  var dirtiness = getprop("sim/model/dirtiness");
  dirtiness = 0.75*math.pow(dirtiness, 0.33);

  setprop("sim/model/livery/shininess", shininess - dirtiness*(1.0+shininess));
}

setlistener("sim/model/livery/shininess", func(n) {
  applyDirt();
});

srand();
setprop("/sim/model/dirtiness", 0.2+0.7*rand());
