# Q400 MFD/EFIS by D-ECHO based on
# A3XX Lower ECAM Canvas
# Joshua Davidson (it0uchpods)

#	References:	http://www.smartcockpit.com/docs/Q400-Fuel.pdf
#			http://www.smartcockpit.com/docs/Q400-Electrical.pdf
#			http://www.smartcockpit.com/docs/Q400-Indicating_and_Recording_Systems.pdf


#			Setup

var instrument_path = "Aircraft/DHC-8/Models/Cockpit/Instruments/EIS/";

var MFD = nil;

#		PROPERTY SETUP

#	Organise Properties per Page that uses them
var doors = {
	pax_f:	props.globals.getNode("sim/model/door-positions/passengerF/position-norm"),
	pax_r:	props.globals.getNode("sim/model/door-positions/passengerLH/position-norm"),
	baggage_f:	props.globals.getNode("sim/model/door-positions/passengerRF/position-norm"),
	baggage_r:	props.globals.getNode("sim/model/door-positions/cargo/position-norm"),
	service:	props.globals.getNode("sim/model/door-positions/passengerRH/position-norm"),
};
var elec = {
	dc_ext_flag:	props.globals.getNode("/systems/electrical/DC/external-power", 1),
	ac_ext_flag:	props.globals.getNode("/systems/electrical/AC/external-power", 1),
	powersource:	props.globals.getNode("/systems/electrical/power-source"),
	generator:{
		load:	[
			props.globals.getNode("/systems/electrical/gen-load[0]"),
			props.globals.getNode("/systems/electrical/gen-load[1]"),
			props.globals.getNode("/systems/electrical/gen-load[2]"),
			props.globals.getNode("/systems/electrical/gen-load[3]"),
			props.globals.getNode("/systems/electrical/gen-load[4]"),
		],
		volts:	[
			props.globals.initNode("/systems/electrical/gen-volts[0]", 0.0, "DOUBLE"),
			props.globals.initNode("/systems/electrical/gen-volts[1]", 0.0, "DOUBLE"),
			props.globals.initNode("/systems/electrical/gen-volts[2]", 0.0, "DOUBLE"),
			props.globals.initNode("/systems/electrical/gen-volts[3]", 0.0, "DOUBLE"),
			props.globals.initNode("/systems/electrical/gen-volts[4]", 0.0, "DOUBLE"),
		],
	},
	battery_load: {
		main:	props.globals.initNode("systems/electrical/main-battery-load", 0.0, "DOUBLE"),
		aux:	props.globals.initNode("systems/electrical/aux-battery-load", 0.0, "DOUBLE"),
		stby:	props.globals.initNode("systems/electrical/stby-battery-load", 0.0, "DOUBLE"),
	},
	bus_volts: {
		lessential:	props.globals.getNode("systems/electrical/DC/lessential-bus/volts"),
		ressential:	props.globals.getNode("systems/electrical/DC/ressential-bus/volts"),
		lmain:		props.globals.getNode("systems/electrical/DC/lmain-bus/volts"),
		rmain:		props.globals.getNode("systems/electrical/DC/rmain-bus/volts"),
		lsecondary:	props.globals.getNode("systems/electrical/DC/lsecondary-bus/volts"),
		rsecondary:	props.globals.getNode("systems/electrical/DC/rsecondary-bus/volts"),
	},
};
#	Properties for the Engine and Fuel Pages are set up in eis-setup.nas because they are also used by the ESID
var sysdata_pilot = {
	rudder:		props.globals.getNode("sim/model/blunt-nose"),
	elevator:	props.globals.getNode("fdm/jsbsim/hydraulics/elevators/final"),
};
var sysdata_copilot = {
	flaps:	props.globals.getNode("surface-positions/flap-pos-norm"),
	press: [
		props.globals.getNode("systems/hydraulic/psi1"),
		props.globals.getNode("systems/hydraulic/psi2"),
		props.globals.getNode("systems/hydraulic/psi3"),
	],
};

var canvas_MFD_base = {
	init: func(canvas_group, file) {
		
		canvas.parsesvg(canvas_group, file, {'font-mapper': font_mapper});

		var svg_keys = me.getKeys();
			
		foreach (var key; svg_keys) {
			me[key] = canvas_group.getElementById(key);
			var clip_el = canvas_group.getElementById(key ~ "_clip");
			if (clip_el != nil) {
				clip_el.setVisible(0);
				var tran_rect = clip_el.getTransformedBounds();
				var clip_rect = sprintf("rect(%d,%d, %d,%d)", 
				tran_rect[1], # 0 ys
				tran_rect[2], # 1 xe
				tran_rect[3], # 2 ye
				tran_rect[0]); #3 xs
				#   coordinates are top,right,bottom,left (ys, xe, ye, xs) ref: l621 of simgear/canvas/CanvasElement.cxx
				me[key].set("clip", clip_rect);
				me[key].set("clip-frame", canvas.Element.PARENT);
			}
			if(key=="horizon"){
				var center=me[key].getCenter();
			}
		}

		me.page = canvas_group;

		return me;
	},
	getKeys: func() {
		return [];
	},
	update: func() {
		foreach( var i; MFD ){
			i.update();
		}
	},
};

var canvas_MFD_elec = {
	new: func(canvas_group, file) {
		var m = { parents: [canvas_MFD_elec,canvas_MFD_base] };
		m.init(canvas_group, file);

		return m;
	},
	getKeys: func() {
		return  ["DCext", "ACext", "APUload", "gen1load", "gen2load", "dcbus.essL", "dcbus.essR", "dcbus.mainL", "dcbus.mainR", "dcbus.secL", "dcbus.secR", "mainbatt.load", "auxbatt.load", "stbybatt.load", "acgen1.a.volt", "acgen2.a.volt", "acgen1.a.load", "acgen2.a.load", "acgen1.b.volt", "acgen2.b.volt", "acgen1.b.load", "acgen2.b.load", "acgen1.c.volt", "acgen2.c.volt", "acgen1.c.load", "acgen2.c.load"];
	},
	update: func() {
		
		if( elec.dc_ext_flag.getBoolValue() ){
			me["DCext"].show();
		}else{
			me["DCext"].hide();
		}
		if( elec.ac_ext_flag.getBoolValue() ){
			me["ACext"].show();
		}else{
			me["ACext"].hide();
		}
		
		me["gen1load"].setText(sprintf("%.2f", elec.generator.load[0].getDoubleValue() ));
		me["gen2load"].setText(sprintf("%.2f", elec.generator.load[1].getDoubleValue() ));
		me["APUload"].setText(sprintf("%.2f",  elec.generator.load[4].getDoubleValue() ));
		
		var acgen1_load = elec.generator.load[2].getDoubleValue();
		me["acgen1.a.load"].setText(sprintf("%.2f", acgen1_load ));
		me["acgen1.b.load"].setText(sprintf("%.2f", acgen1_load ));
		me["acgen1.c.load"].setText(sprintf("%.2f", acgen1_load ));
		
		var acgen2_load = elec.generator.load[3].getDoubleValue();
		me["acgen2.a.load"].setText(sprintf("%.2f", acgen2_load ));
		me["acgen2.b.load"].setText(sprintf("%.2f", acgen2_load ));
		me["acgen2.c.load"].setText(sprintf("%.2f", acgen2_load ));
		
		var acgen1_volts = elec.generator.volts[2].getDoubleValue();
		me["acgen1.a.volt"].setText(sprintf("%3d", acgen1_volts ));
		me["acgen1.b.volt"].setText(sprintf("%3d", acgen1_volts ));
		me["acgen1.c.volt"].setText(sprintf("%3d", acgen1_volts ));
		
		var acgen2_volts = elec.generator.volts[3].getDoubleValue();
		me["acgen2.a.volt"].setText(sprintf("%3d", acgen2_volts ));
		me["acgen2.b.volt"].setText(sprintf("%3d", acgen2_volts ));
		me["acgen2.c.volt"].setText(sprintf("%3d", acgen2_volts ));
		
		me["mainbatt.load"].setText(sprintf("%+.2f", elec.battery_load.main.getDoubleValue() ));
		me["auxbatt.load"].setText( sprintf("%+.2f", elec.battery_load.aux.getDoubleValue()  ));
		me["stbybatt.load"].setText(sprintf("%+.2f", elec.battery_load.stby.getDoubleValue() ));
		
		me["dcbus.essL"].setText(sprintf("%.1f", elec.bus_volts.lessential.getDoubleValue() ));
		me["dcbus.essR"].setText(sprintf("%.1f", elec.bus_volts.ressential.getDoubleValue() ));
		
		me["dcbus.mainL"].setText(sprintf("%.1f", elec.bus_volts.lmain.getDoubleValue() ));
		me["dcbus.mainR"].setText(sprintf("%.1f", elec.bus_volts.rmain.getDoubleValue() ));
		
		me["dcbus.secL"].setText(sprintf("%.1f", elec.bus_volts.lsecondary.getDoubleValue() ));
		me["dcbus.secR"].setText(sprintf("%.1f", elec.bus_volts.rsecondary.getDoubleValue() ));
		
	},
};

var canvas_MFD_eng = {
	new: func(canvas_group, file) {
		var m = { parents: [canvas_MFD_eng, canvas_MFD_base] };
		m.init(canvas_group, file);

		return m;
	},
	getKeys: func() {
		return ["thrustdtL", "thrustdtR", "TRQL", "TRQR", "PROPRPML", "PROPRPMR", "ITTL", "ITTR", "fuelquantityL", "fuelquantityR", "fueltempL", "fueltempR", "SAT", "FFL", "FFR", "OilPressL", "OilPressR", "OilTempL", "OilTempR", "NLL", "NLR", "NHL", "NHR", "NHL.decimal", "NHR.decimal", "rudder", "Lelev", "Relev"];
	},
	update: func() {
		me["thrustdtL"].setText( eng.thrustmode[0].getValue() );
		me["thrustdtR"].setText( eng.thrustmode[1].getValue() );
		
		me["TRQL"].setText(sprintf("%3d", math.round( eng.torque[0].getDoubleValue() / (-150) )));
		me["TRQR"].setText(sprintf("%3d", math.round( eng.torque[1].getDoubleValue() / (-150) )));
		
		me["PROPRPML"].setText(sprintf("%4d", math.round( eng.rpm[0].getDoubleValue() )));
		me["PROPRPMR"].setText(sprintf("%4d", math.round( eng.rpm[1].getDoubleValue() )));
		
		me["ITTL"].setText(sprintf("%4d", math.round( eng.itt[0].getDoubleValue() )));
		me["ITTR"].setText(sprintf("%4d", math.round( eng.itt[1].getDoubleValue() )));
		
		me["fuelquantityL"].setText(sprintf("%4d", math.round( fuel.quantity[0].getDoubleValue() )));
		me["fuelquantityR"].setText(sprintf("%4d", math.round( fuel.quantity[1].getDoubleValue() )));
		
		me["fueltempL"].setText(sprintf("%+2d", math.round( fuel.temperature[0].getDoubleValue() )));
		me["fueltempR"].setText(sprintf("%+2d", math.round( fuel.temperature[1].getDoubleValue() )));
		
		me["SAT"].setText(sprintf("%+2d", math.round( sat.getDoubleValue() )));
		
		me["FFL"].setText(sprintf("%3d", math.round( eng.fuel_flow[0].getDoubleValue() )));
		me["FFR"].setText(sprintf("%3d", math.round( eng.fuel_flow[1].getDoubleValue() )));
		
		me["OilPressL"].setText(sprintf("%3d", math.round( eng.oil.pressure[0].getDoubleValue() )));
		me["OilPressR"].setText(sprintf("%3d", math.round( eng.oil.pressure[1].getDoubleValue() )));
		
		me["OilTempL"].setText(sprintf("%3d", math.round( eng.oil.temperature[0].getDoubleValue() )));
		me["OilTempR"].setText(sprintf("%3d", math.round( eng.oil.temperature[1].getDoubleValue() )));
		
		me["NLL"].setText(sprintf("%3d", math.round( eng.n1[0].getDoubleValue() )));
		me["NLR"].setText(sprintf("%3d", math.round( eng.n1[1].getDoubleValue() )));
		
		var n2L = eng.n2[0].getDoubleValue();
		var n2R = eng.n2[1].getDoubleValue();
		me["NHL"].setText(sprintf("%s", math.round(n2L)));
		me["NHR"].setText(sprintf("%s", math.round(n2R)));
		me["NHL.decimal"].setText(sprintf("%1d", int( 10 * math.mod( n2L, 1 ))));
		me["NHR.decimal"].setText(sprintf("%1d", int( 10 * math.mod( n2R, 1 ))));
	},
};

var canvas_MFD_fuel = {
	new: func(canvas_group, file) {
		var m = { parents: [canvas_MFD_fuel,canvas_MFD_base] };
		m.init(canvas_group, file);

		return m;
	},
	getKeys: func() {
		return ["transferL", "transferR", "transferOFF", "leftquantity", "rightquantity", "totalquantity", "tank1booston1", "tank1booston2", "tank2booston1", "tank2booston2", "tank1boostoff1", "tank1boostoff2", "tank2boostoff1", "tank2boostoff2", "auxpumppressL", "auxpumppressR", "tanktemp"];
	},
	update: func() {
		var transfer = fuel.transfer.getIntValue();
		if( transfer == -1 ){
			me["transferL"].show();
			me["transferR"].hide();
			me["transferOFF"].hide();
		}else if( transfer == 1 ){
			me["transferL"].hide();
			me["transferR"].show();
			me["transferOFF"].hide();		
		}else{
			me["transferL"].hide();
			me["transferR"].hide();
			me["transferOFF"].show();		
		}
		
		me["leftquantity"].setRotation( fuel.quantity[0].getDoubleValue() * D2R * 313.25 / 7000 );
		me["rightquantity"].setRotation( fuel.quantity[1].getDoubleValue() * D2R * 313.25 / 7000 );
		
		me["totalquantity"].setText(sprintf("%s", math.round( fuel.total_quantity.getDoubleValue() )));
		
		if( fuel.boost_pump[0].getBoolValue() ){
			me["tank1booston1"].show();
			me["tank1booston2"].show();
			me["tank1boostoff1"].hide();
			me["tank1boostoff2"].hide();
			me["auxpumppressL"].show();
		}else{
			me["tank1booston1"].hide();
			me["tank1booston2"].hide();
			me["tank1boostoff1"].show();
			me["tank1boostoff2"].show();
			me["auxpumppressL"].hide();
		}
		if( fuel.boost_pump[1].getBoolValue() ){
			me["tank2booston1"].show();
			me["tank2booston2"].show();
			me["tank2boostoff1"].hide();
			me["tank2boostoff2"].hide();
			me["auxpumppressR"].show();
		}else{
			me["tank2booston1"].hide();
			me["tank2booston2"].hide();
			me["tank2boostoff1"].show();
			me["tank2boostoff2"].show();
			me["auxpumppressR"].hide();
		}	
		
		me["tanktemp"].setText(sprintf("%2d", math.round( fuel.temperature[0].getDoubleValue() )));
	},
};

var canvas_MFD_doors = {
	new: func(canvas_group, file) {
		var m = { parents: [canvas_MFD_doors,canvas_MFD_base] };
		m.init(canvas_group, file);

		return m;
	},
	getKeys: func() {
		return ["PAXF", "PAXR", "BAGGAGEF", "BAGGAGER", "SERVICE", "PAXF.text", "PAXR.text", "BAGGAGEF.text", "BAGGAGER.text", "SERVICE.text", "EMERGEXIT.text"];
	},
	update: func() {
	
		if(getprop("/sim/model/door-positions/passengerF/position-norm")==1){
			me["PAXF"].setColor(0,1,0);
			me["PAXF"].setColorFill(0,0,0);
			me["PAXF.text"].hide();
		}else{
			me["PAXF"].setColor(1,0,0);
			me["PAXF"].setColorFill(1,0,0);
			me["PAXF.text"].show();
		}
		if((getprop("/sim/model/door-positions/passengerLH/position-norm") or 0)==0){
			me["PAXR"].setColor(0,1,0);
			me["PAXR"].setColorFill(0,0,0);
			me["PAXR.text"].hide();
		}else{
			me["PAXR"].setColor(1,0,0);
			me["PAXR"].setColorFill(1,0,0);
			me["PAXR.text"].show();
		}
		if((getprop("/sim/model/door-positions/passengerRF/position-norm") or 0)==0){
			me["BAGGAGEF"].setColor(0,1,0);
			me["BAGGAGEF"].setColorFill(0,0,0);
			me["BAGGAGEF.text"].hide();
		}else{
			me["BAGGAGEF"].setColor(1,0,0);
			me["BAGGAGEF"].setColorFill(1,0,0);
			me["BAGGAGEF.text"].show();
		}
		if((getprop("/sim/model/door-positions/cargo/position-norm") or 0)==0){
			me["BAGGAGER"].setColor(0,1,0);
			me["BAGGAGER"].setColorFill(0,0,0);
			me["BAGGAGER.text"].hide();
		}else{
			me["BAGGAGER"].setColor(1,0,0);
			me["BAGGAGER"].setColorFill(1,0,0);
			me["BAGGAGER.text"].show();
		}
		if((getprop("/sim/model/door-positions/passengerRH/position-norm") or 0)==0){
			me["SERVICE"].setColor(0,1,0);
			me["SERVICE"].setColorFill(0,0,0);
			me["SERVICE.text"].hide();
		}else{
			me["SERVICE"].setColor(1,0,0);
			me["SERVICE"].setColorFill(1,0,0);
			me["SERVICE.text"].show();
		}
		
		#emergency exit door not yet implemented
		me["EMERGEXIT.text"].hide();
	},
};

var canvas_MFD_sysdata_pilot = {
	new: func( canvas_group, file ){
		var m = { parents: [canvas_MFD_sysdata_pilot, canvas_MFD_base] };
		m.init( canvas_group, file );
		
		return m;
	},
	getKeys: func () {
		return ["rudder", "Lelev", "Relev"];
	},
	update: func() {
		me["rudder"].setRotation( sysdata_pilot.rudder.getDoubleValue() * -D2R * 41.4 );
		var elevator = sysdata_pilot.elevator.getDoubleValue();
		if(elevator>0){
			me["Lelev"].setRotation(elevator * -D2R * 30);
			me["Relev"].setRotation(elevator *  D2R * 30);
		}else if(elevator<0){
			me["Lelev"].setRotation(elevator * -D2R * 43);
			me["Relev"].setRotation(elevator *  D2R * 43);
		}
	},
};

var canvas_MFD_sysdata_copilot = {
	new: func( canvas_group, file ){
		var m = { parents: [canvas_MFD_sysdata_copilot, canvas_MFD_base] };
		m.init( canvas_group, file );
		
		return m;
	},
	getKeys: func () {
		return ["flaps.pointer", "one.pointer", "two.pointer", "three.pointer", "pkbrk.pointer", "stby.pointer",];
	},
	update: func() {
		me["flaps.pointer"].setRotation( sysdata_copilot.flaps.getDoubleValue() * D2R * 210 );	
		
		me["one.pointer"].setTranslation(  0, sysdata_copilot.press[0].getDoubleValue() * (-0.045) );		
		me["two.pointer"].setTranslation(  0, sysdata_copilot.press[1].getDoubleValue() * (-0.045) );		
		me["three.pointer"].setTranslation(0, sysdata_copilot.press[2].getDoubleValue() * (-0.045) );
	},
};

var mfd_update = maketimer( 0.1, func{ canvas_MFD_base.update() } );
mfd_update.simulatedTime = 1;

var MFD_display = {
	new: func( i, node ) {
		var m = {	parents: [MFD_display],
				i: i,
				canvas:	canvas.new({
					"name": "MFD"~ i,
					"size": [1024, 1536],
					"view": [1024, 1536],
					"mipmapping": 1}),
				canvas_sysdata: canvas.new({
					"name": "MFD Sys Data"~i,
					"size": [1024, 1536],
					"view": [1024, 1536],
					"mipmapping": 1}),
				elec:	nil,
				eng:	nil,
				fuel:	nil,
				doors:	nil,	
				sysdata: nil,
		};
		m.canvas.addPlacement({"node": node~".SYS"});
		m.canvas_sysdata.addPlacement({"node": node~".sys_data"});
		
		m.elec = canvas_MFD_elec.new(	m.canvas.createGroup(),	instrument_path~"canvas/mfd/MFD.SYS.ELEC.svg");
		m.eng = canvas_MFD_eng.new(	m.canvas.createGroup(),	instrument_path~"canvas/mfd/MFD.SYS.ENG.svg");
		m.fuel = canvas_MFD_fuel.new(	m.canvas.createGroup(),	instrument_path~"canvas/mfd/MFD.SYS.FUEL.svg");
		m.doors = canvas_MFD_doors.new(	m.canvas.createGroup(),	instrument_path~"canvas/mfd/MFD.SYS.DOORS.svg");
		
		if( i == 0 ){
			m.sysdata = canvas_MFD_sysdata_pilot.new( m.canvas_sysdata.createGroup(),	instrument_path~"canvas/mfd/MFD.sys_data.pilot.svg");
		} else if ( i == 1 ){
			m.sysdata = canvas_MFD_sysdata_copilot.new( m.canvas_sysdata.createGroup(),	instrument_path~"canvas/mfd/MFD.sys_data.copilot.svg");
		} else {
			print("Canvas MFD: WARNING: No Permanent System Data Area for MFD "~ i ~" defined!");
		}
		return m;
	},
	update: func() {
		if ( volts.mfd[ me.i ].getDoubleValue() > 10) {
			var mainpage = main_page[ me.i ].getValue();
			
			if( mainpage == "sys" or mainpage == "nd" ){
				me.sysdata.page.show();
				me.sysdata.update();
			} else {
				me.sysdata.page.hide();
			}
			
			if( mainpage == "sys" ){
				var syspage = sys_page[ me.i ].getValue();
				if(syspage=="elec"){
					me.elec.page.show();
					me.elec.update();
					me.eng.page.hide();
					me.fuel.page.hide();
					me.doors.page.hide();
				}else if(syspage=="eng"){
					me.eng.page.show();
					me.eng.update();
					me.elec.page.hide();
					me.fuel.page.hide();
					me.doors.page.hide();
				}else if(syspage=="fuel"){
					me.fuel.page.show();
					me.fuel.update();
					me.elec.page.hide();
					me.eng.page.hide();
					me.doors.page.hide();
				}else if(syspage=="doors"){
					me.doors.page.show();
					me.doors.update();
					me.elec.page.hide();
					me.eng.page.hide();
					me.fuel.page.hide();
				}else{
					me.elec.page.hide();
					me.eng.page.hide();
					me.fuel.page.hide();
					me.doors.page.hide();
				}
			}else{
				me.elec.page.hide();
				me.eng.page.hide();
				me.fuel.page.hide();
				me.doors.page.hide();
			}
				
		} else {
			me.elec.page.hide();
			me.eng.page.hide();
			me.fuel.page.hide();
			me.doors.page.hide();
		}
	}
};

setlistener("sim/signals/fdm-initialized", func {
	MFD = [
		MFD_display.new( 0, "du2.screen" ),
		MFD_display.new( 1, "du4.screen" ),
	];

	mfd_update.start();
});


#	Translate Pedestal Main Page Knob Position into page
#	Mapping:
#		Position	Left MFD	Right MFD
#		0		PFD		ENG
#		1		NAV		NAV
#		2		SYS		SYS
#		3		ENG		PFD
var main_page_mapping = [
	[ "pfd", "nd", "sys", "ed"  ],
	[ "ed",  "nd", "sys", "pfd" ],
];
setlistener( main_page_knob[0], func {
	main_page[0].setValue( main_page_mapping[0][ main_page_knob[0].getIntValue() ] );
});
setlistener( main_page_knob[1], func {
	main_page[1].setValue( main_page_mapping[1][ main_page_knob[1].getIntValue() ] );
});
