#
# CRJ700 familiy - ALS landing lights
#
var LL_MIN_VOLTS = 24;
var als_lights_cfg_prop = "/sim/config/crj-als-lights";
var als_proppath = "/sim/rendering/als-secondary-lights/";
var enabledN = props.getNode(als_lights_cfg_prop, 1);
enabledN.setBoolValue(enabledN.getValue());

var cvN = props.getNode("sim/current-view/view-number-raw",1);
var path = "/systems/DC/outputs/";
var tlN = props.getNode(path~"taxi-lights", 1);
var llN = props.getNode(path~"landing-lights", 1);
var lnN = props.getNode(path~"landing-lights[1]", 1);
var lrN = props.getNode(path~"landing-lights[2]", 1);

var asl_ll1_offsetN = props.getNode(als_proppath~"landing-light1-offset-deg", 1);
var asl_ll2_offsetN = props.getNode(als_proppath~"landing-light2-offset-deg", 1);

var update_als_landinglights = func ()
{
    var v = cvN.getValue();
    tl = llN.getValue();
    ll = llN.getValue();
    ln = llN.getValue();
    lr = llN.getValue();
    if (enabledN.getValue() and (v == 0 or v == 101 or v == 109)) {
        if (ll >= LL_MIN_VOLTS) asl_ll1_offsetN.setValue(-4);
        elsif (ln >= LL_MIN_VOLTS) asl_ll1_offsetN.setValue(-1);
        else asl_ll1_offsetN.setValue(0);

        if (lr >= LL_MIN_VOLTS) asl_ll2_offsetN.setValue(4);
        elsif (ln >= LL_MIN_VOLTS) asl_ll2_offsetN.setValue(1);
        else asl_ll2_offsetN.setValue(0);

        setprop(als_proppath~"use-landing-light", (ll >= LL_MIN_VOLTS or ln >= LL_MIN_VOLTS or tl >= LL_MIN_VOLTS));
        setprop(als_proppath~"use-alt-landing-light", (lr >= LL_MIN_VOLTS or ll >= LL_MIN_VOLTS and ln >= LL_MIN_VOLTS));
    }
    else {
        setprop(als_proppath~"use-landing-light", 0);
        setprop(als_proppath~"use-alt-landing-light", 0);
    }
}

#delayed init
settimer(func {
    var path = "/systems/DC/outputs/";
    props.globals.initNode(path~"taxi-lights", 0, "DOUBLE");
    props.globals.initNode(path~"landing-lights", 0, "DOUBLE");
    props.globals.initNode(path~"landing-lights[1]", 0, "DOUBLE");
    props.globals.initNode(path~"landing-lights[2]", 0, "DOUBLE");

    setlistener(path~"taxi-lights", update_als_landinglights, 1, 0);
    setlistener(path~"landing-lights", update_als_landinglights, 0, 0);
    setlistener(path~"landing-lights[1]", update_als_landinglights, 0, 0);
    setlistener(path~"landing-lights[2]", update_als_landinglights, 0, 0);
    setlistener("/sim/current-view/view-number", update_als_landinglights, 0, 0);
}, 1);
