# DO228 ND Canvas
# Benedikt Wolf
# based on work by Joshua Davidson and artix

var get_local_path = func(file){
	return instrument_path ~ "nd/"~ file;
};

var version = getprop("sim/version/flightgear");
var v = split(".", version);
version = num(v[0]~"."~v[1]);

var SymbolLayer = canvas.SymbolLayer;
var SingleSymbolLayer = canvas.SingleSymbolLayer;
var MultiSymbolLayer = canvas.MultiSymbolLayer;
var NavaidSymbolLayer = canvas.NavaidSymbolLayer;
var Symbol = canvas.Symbol;
var Group = canvas.Group;
var Path = canvas.Path;
var DotSym = canvas.DotSym;
var Map = canvas.Map;
var SVGSymbol = canvas.SVGSymbol;
var LineSymbol = canvas.LineSymbol;
var StyleableCacheable = canvas.StyleableCacheable;
var SymbolCache32x32 = canvas.SymbolCache32x32;
var SymbolCache = canvas.SymbolCache;
var Text = canvas.Text;

io.include("ND_config.nas");
io.include("framework/canvas.nas");
io.include("framework/navdisplay.nas");
io.include("framework/MapDrivers.nas");
io.include("loaders.nas");
io.include("helpers.nas");
io.include("style.nas");

var input_display_mode = props.globals.initNode( "/instrumentation/efis[0]/inputs/display-mode", 0, "INT");

setlistener( input_display_mode, func( i ){
	if( i.getIntValue() == 0 ){
		setprop("/instrumentation/efis[0]/inputs/nd-centered", 0);
		setprop("/instrumentation/efis[0]/nd/canvas-display-mode", "VOR" );
	} elsif( i.getIntValue() == 1 ){
		setprop("/instrumentation/efis[0]/inputs/nd-centered", 1);
		setprop("/instrumentation/efis[0]/nd/canvas-display-mode", "VOR" );
	} elsif( i.getIntValue() == 2 ){
		setprop("/instrumentation/efis[0]/inputs/nd-centered", 0);
		setprop("/instrumentation/efis[0]/nd/canvas-display-mode", "MAP" );
	} elsif( i.getIntValue() == 3 ){
		setprop("/instrumentation/efis[0]/inputs/nd-centered", 1);
		setprop("/instrumentation/efis[0]/nd/canvas-display-mode", "MAP" );
	} else {
		die( "Unknown EFIS display mode: "~ i.getIntValue() );
	}
});
