# EFI-890R MFD by Benedikt Wolf (D-ECHO) based on A320 canvas avionics by Joshua Davidson

var EFI_890R_MFD_main = nil;
var EFI_890R_MFD_start = nil;
var EFI_890R_MFD_display = nil;

# Instrument properties
var trq0 = props.globals.getNode("engines/engine[0]/thruster/torque", 1);
var trq1 = props.globals.getNode("engines/engine[1]/thruster/torque", 1);

var egt0 = props.globals.getNode("engines/engine[0]/egt-degc", 1);	#TODO
var egt1 = props.globals.getNode("engines/engine[1]/egt-degc", 1);	#TODO

var rpm0 = props.globals.getNode("engines/engine[0]/thruster/rpm", 1);
var rpm1 = props.globals.getNode("engines/engine[1]/thruster/rpm", 1);

var ff0	= props.globals.getNode("engines/engine[0]/fuel-flow_pph", 1);
var ff1	= props.globals.getNode("engines/engine[1]/fuel-flow_pph", 1);

var op0 = props.globals.getNode("engines/engine[0]/oil-pressure-psi-corrected", 1);
var op1 = props.globals.getNode("engines/engine[1]/oil-pressure-psi-corrected", 1);

var ot0 = props.globals.getNode("engines/engine[0]/oil-temperature-degf", 1);
var ot1 = props.globals.getNode("engines/engine[1]/oil-temperature-degf", 1);

var ign0 = props.globals.getNode("controls/engines/engine[0]/ignition", 1);
var ign1 = props.globals.getNode("controls/engines/engine[1]/ignition", 1);

var no_wow = props.globals.getNode("fdm/jsbsim/fcs/gear-no-wow");

var messages = {
	text: [
		props.globals.getNode("instrumentation/eicas-messages/line[0]/message"),
		props.globals.getNode("instrumentation/eicas-messages/line[1]/message"),
		props.globals.getNode("instrumentation/eicas-messages/line[2]/message"),
		props.globals.getNode("instrumentation/eicas-messages/line[3]/message"),
		props.globals.getNode("instrumentation/eicas-messages/line[4]/message"),
		props.globals.getNode("instrumentation/eicas-messages/line[5]/message"),
		props.globals.getNode("instrumentation/eicas-messages/line[6]/message"),
		props.globals.getNode("instrumentation/eicas-messages/line[7]/message"),
		props.globals.getNode("instrumentation/eicas-messages/line[8]/message"),
		],
	enabled: [
		props.globals.getNode("instrumentation/eicas-messages/line[0]/enabled"),
		props.globals.getNode("instrumentation/eicas-messages/line[1]/enabled"),
		props.globals.getNode("instrumentation/eicas-messages/line[2]/enabled"),
		props.globals.getNode("instrumentation/eicas-messages/line[3]/enabled"),
		props.globals.getNode("instrumentation/eicas-messages/line[4]/enabled"),
		props.globals.getNode("instrumentation/eicas-messages/line[5]/enabled"),
		props.globals.getNode("instrumentation/eicas-messages/line[6]/enabled"),
		props.globals.getNode("instrumentation/eicas-messages/line[7]/enabled"),
		props.globals.getNode("instrumentation/eicas-messages/line[8]/enabled"),
		],
	shown: [ -1, -1, -1, -1, -1, -1, -1, -1, -1 ],
	color: {
		r: [
			props.globals.getNode("instrumentation/eicas-messages/line[0]/color-red-norm"),
			props.globals.getNode("instrumentation/eicas-messages/line[1]/color-red-norm"),
			props.globals.getNode("instrumentation/eicas-messages/line[2]/color-red-norm"),
			props.globals.getNode("instrumentation/eicas-messages/line[3]/color-red-norm"),
			props.globals.getNode("instrumentation/eicas-messages/line[4]/color-red-norm"),
			props.globals.getNode("instrumentation/eicas-messages/line[5]/color-red-norm"),
			props.globals.getNode("instrumentation/eicas-messages/line[6]/color-red-norm"),
			props.globals.getNode("instrumentation/eicas-messages/line[7]/color-red-norm"),
			props.globals.getNode("instrumentation/eicas-messages/line[8]/color-red-norm"),
		],
		g: [
			props.globals.getNode("instrumentation/eicas-messages/line[0]/color-green-norm"),
			props.globals.getNode("instrumentation/eicas-messages/line[1]/color-green-norm"),
			props.globals.getNode("instrumentation/eicas-messages/line[2]/color-green-norm"),
			props.globals.getNode("instrumentation/eicas-messages/line[3]/color-green-norm"),
			props.globals.getNode("instrumentation/eicas-messages/line[4]/color-green-norm"),
			props.globals.getNode("instrumentation/eicas-messages/line[5]/color-green-norm"),
			props.globals.getNode("instrumentation/eicas-messages/line[6]/color-green-norm"),
			props.globals.getNode("instrumentation/eicas-messages/line[7]/color-green-norm"),
			props.globals.getNode("instrumentation/eicas-messages/line[8]/color-green-norm"),
		],
		b: [
			props.globals.getNode("instrumentation/eicas-messages/line[0]/color-blue-norm"),
			props.globals.getNode("instrumentation/eicas-messages/line[1]/color-blue-norm"),
			props.globals.getNode("instrumentation/eicas-messages/line[2]/color-blue-norm"),
			props.globals.getNode("instrumentation/eicas-messages/line[3]/color-blue-norm"),
			props.globals.getNode("instrumentation/eicas-messages/line[4]/color-blue-norm"),
			props.globals.getNode("instrumentation/eicas-messages/line[5]/color-blue-norm"),
			props.globals.getNode("instrumentation/eicas-messages/line[6]/color-blue-norm"),
			props.globals.getNode("instrumentation/eicas-messages/line[7]/color-blue-norm"),
			props.globals.getNode("instrumentation/eicas-messages/line[8]/color-blue-norm"),
		],
	},
};
			

var prop_ht_amps = [
	props.globals.getNode("systems/electrical/eicas/prop-heating-amps[0]", 1),
	props.globals.getNode("systems/electrical/eicas/prop-heating-amps[1]", 1),
	];
var hyd_press = props.globals.getNode("fdm/jsbsim/systems/hydraulic/pressure-psi");

var ail_trim = props.globals.getNode("controls/flight/aileron-trim");
var rud_trim = props.globals.getNode("controls/flight/rudder-trim");
var elev_trim = props.globals.getNode("controls/flight/elevator-trim");
var flaps_cmd = props.globals.getNode("controls/flight/flaps");
var flaps_pos = props.globals.getNode("surface-positions/flap-pos-norm");

var fuel_level_lbs = [
	props.globals.getNode("consumables/fuel/tank[0]/level-lbs"),
	props.globals.getNode("consumables/fuel/tank[1]/level-lbs"),
	props.globals.getNode("consumables/fuel/tank[2]/level-lbs"),
	props.globals.getNode("consumables/fuel/tank[3]/level-lbs"),
	props.globals.getNode("consumables/fuel/tank[4]/level-lbs"),
	props.globals.getNode("consumables/fuel/tank[5]/level-lbs"),
	];
	
var fuel_level_norm = [
	props.globals.getNode("consumables/fuel/tank[0]/level-norm"),
	props.globals.getNode("consumables/fuel/tank[1]/level-norm"),
	props.globals.getNode("consumables/fuel/tank[2]/level-norm"),
	props.globals.getNode("consumables/fuel/tank[3]/level-norm"),
	props.globals.getNode("consumables/fuel/tank[4]/level-norm"),
	props.globals.getNode("consumables/fuel/tank[5]/level-norm"),
	];

var canvas_EFI_890R_MFD_base = {
	init: func(canvas_group, file) {
		var font_mapper = func(family, weight) {
			return "LiberationFonts/LiberationSans-Bold.ttf";
		};

		
		canvas.parsesvg(canvas_group, file, {'font-mapper': font_mapper});

		var svg_keys = me.getKeys();
		 
		foreach(var key; svg_keys) {
			me[key] = canvas_group.getElementById(key);
			var clip_el = canvas_group.getElementById(key ~ "_clip");
			if (clip_el != nil) {
				clip_el.setVisible(0);
				var tran_rect = clip_el.getTransformedBounds();
				var clip_rect = sprintf("rect(%d,%d, %d,%d)", 
				tran_rect[1], # 0 ys
				tran_rect[2], # 1 xe
				tran_rect[3], # 2 ye
				tran_rect[0]); #3 xs
				#   coordinates are top,right,bottom,left (ys, xe, ye, xs) ref: l621 of simgear/canvas/CanvasElement.cxx
				me[key].set("clip", clip_rect);
				me[key].set("clip-frame", canvas.Element.PARENT);
			}
		}

		me.page = canvas_group;

		return me;
	},
	getKeys: func() {
		return [];
	},
	update: func() {
		if( du_status[1] == 2 ){
			EFI_890R_MFD_start.page.hide();
			EFI_890R_MFD_main.page.show();
			EFI_890R_MFD_main.update();
		} else if ( du_status[1] == 1 ){
			EFI_890R_MFD_main.page.hide();
			EFI_890R_MFD_start.page.show();
		} else {
			EFI_890R_MFD_main.page.hide();
			EFI_890R_MFD_start.page.hide();
		}
	},
};
	
var elev_trim_green_range = -1;	# 0 = green trim range for flaps = 0; 1 = green trim range for flaps = 1

var canvas_EFI_890R_MFD_main = {
	new: func(canvas_group, file) {
		var m = { parents: [canvas_EFI_890R_MFD_main , canvas_EFI_890R_MFD_base] };
		m.init(canvas_group, file);

		return m;
	},
	getKeys: func() {
		return [
			"trq0.digits", "trq0.needle", "trq1.digits", "trq1.needle",
			"egt0.digits", "egt0.needle", "egt0.arc.starting", "egt1.digits", "egt1.needle", "egt1.arc.starting",
			"rpm0.digits", "rpm0.needle", "rpm1.digits", "rpm1.needle",
			"ot0.digits", "ot0.needle", "op0.digits", "op0.needle",
			"ot1.digits", "ot1.needle", "op1.digits", "op1.needle",
			"fuelflow0.needle","fuelflow0.digits","fuelflow1.needle","fuelflow1.digits",
			"ign0.flag", "ign1.flag",
			"beta0.flag", "beta1.flag",
			"message.0","message.1","message.2","message.3","message.4","message.5","message.6","message.7","message.8",
			"propheating0.amps.digits","propheating1.amps.digits","hydraulic_press.digits",
			"aileron_trim.needle","rudder_trim.needle","elevator_trim.needle","elevator_trim.green.flap0","elevator_trim.green.flap1","flaps.needle",
			"fuel0.ind","fuel0.digits","fuel1.ind","fuel1.digits","fuel2.ind","fuel2.digits",
			"fuel3.ind","fuel3.digits","fuel4.ind","fuel4.digits","fuel5.ind","fuel5.digits",
			"fuel_total_left.digits","fuel_total.digits","fuel_total_right.digits",
       		];
	},
	update: func() {
		#			LEFT HALF - Engine Instruments
		
		# Maximal torque is 579 000 W / 0.105 * 1591 RPM = 3465.9 Nm = 2556 ft*lbs
		var trq0_pct = trq0.getDoubleValue() / 25.56;
		me["trq0.digits"].setText( sprintf("%3d", math.round( trq0_pct ) ) );
		me["trq0.needle"].setRotation( math.min( trq0_pct, 119 ) * 2.0168 * D2R );
		if( trq0_pct < 101.4 ){
			me["trq0.digits"].setColor(0, 1, 0);
			me["trq0.needle"].setColorFill(0, 1, 0);
		} else {
			me["trq0.digits"].setColor(1, 0, 0);
			me["trq0.needle"].setColorFill(1, 0, 0);
		}
		
		var trq1_pct = trq1.getDoubleValue() / 25.56;
		me["trq1.digits"].setText( sprintf("%3d", math.round( trq1_pct ) ) );
		me["trq1.needle"].setRotation( math.min( trq1_pct, 119 ) * 2.0168 * D2R );
		if( trq1_pct < 101.4 ){
			me["trq1.digits"].setColor(0, 1, 0);
			me["trq1.needle"].setColorFill(0, 1, 0);
		} else {
			me["trq1.digits"].setColor(1, 0, 0);
			me["trq1.needle"].setColorFill(1, 0, 0);
		}
		
		var egt0_val = 350;	# TODO: EGT calc
		me["egt0.digits"].setText( sprintf("%4d", math.round( egt0_val ) ) );
		me["egt0.needle"].setRotation( math.min( egt0_val, 770 ) * 0.31169 * D2R );
		
		var egt1_val = 350;	# TODO: EGT calc
		me["egt1.digits"].setText( sprintf("%4d", math.round( egt1_val ) ) );
		me["egt1.needle"].setRotation( math.min( egt1_val, 770 ) * 0.31169 * D2R );
			# RPM and FF are already accessed here for the EGT starting condition
		var rpm0_pct = rpm0.getDoubleValue() / 16.07;
		var rpm1_pct = rpm1.getDoubleValue() / 16.07;
		var ff0_val = ff0.getDoubleValue();
		var ff1_val = ff1.getDoubleValue();
		var no_wow_val = no_wow.getBoolValue();
		var starting0 = 0;
		var starting1 = 0;
		if( rpm0_pct < 65 and ( !no_wow_val or ff0_val < 150 ) ){
			starting0 = 1;
			me["egt0.arc.starting"].setColorFill(0, 1, 0);
		} else {
			me["egt0.arc.starting"].setColorFill(1, 0, 0);
		}
		if( rpm1_pct < 65 and ( !no_wow_val or ff1_val < 150 ) ){
			starting1 = 1;
			me["egt1.arc.starting"].setColorFill(0, 1, 0);
		} else {
			me["egt1.arc.starting"].setColorFill(1, 0, 0);
		}
		
		if( egt0_val < 100 ) {
			me["egt0.digits"].setColor(1, 1, 1);
			me["egt0.needle"].setColorFill(1, 1, 1);
		} else if ( egt0_val < 500 or ( egt0_val < 770 and starting0 == 1 ) ){
			me["egt0.digits"].setColor(0, 1, 0);
			me["egt0.needle"].setColorFill(0, 1, 0);
		} else {
			me["egt0.digits"].setColor(1, 0, 0);
			me["egt0.needle"].setColorFill(1, 0, 0);
		}
		
		if( egt1_val < 100 ) {
			me["egt1.digits"].setColor(1, 1, 1);
			me["egt1.needle"].setColorFill(1, 1, 1);
		} else if ( egt1_val < 500 or ( egt1_val < 770 and starting1 == 1 ) ){
			me["egt1.digits"].setColor(0, 1, 0);
			me["egt1.needle"].setColorFill(0, 1, 0);
		} else {
			me["egt1.digits"].setColor(1, 0, 0);
			me["egt1.needle"].setColorFill(1, 0, 0);
		}
			
		
		me["rpm0.digits"].setText( sprintf("%3d", math.round( rpm0_pct ) ) );
		me["rpm0.needle"].setRotation( math.min( rpm0_pct, 106 ) * 2.2641 * D2R );
		if( rpm0_pct < 70 ){
			me["rpm0.digits"].setColor(1, 1, 1);
			me["rpm0.needle"].setColorFill(1, 1, 1);
		} else if ( rpm0_pct < 96 ){
			me["rpm0.digits"].setColor(1, 1, 0);
			me["rpm0.needle"].setColorFill(1, 1, 0);
		} else if ( rpm0_pct < 101 ){
			me["rpm0.digits"].setColor(0, 1, 0);
			me["rpm0.needle"].setColorFill(0, 1, 0);
		} else {
			me["rpm0.digits"].setColor(1, 0, 0);
			me["rpm0.needle"].setColorFill(1, 0, 0);
		}
		
		me["rpm1.digits"].setText( sprintf("%3d", math.round( rpm1_pct ) ) );
		me["rpm1.needle"].setRotation( math.min( rpm1_pct, 106 ) * 2.2641 * D2R );
		if( rpm1_pct < 70 ){
			me["rpm1.digits"].setColor(1, 1, 1);
			me["rpm1.needle"].setColorFill(1, 1, 1);
		} else if ( rpm1_pct < 96 ){
			me["rpm1.digits"].setColor(1, 1, 0);
			me["rpm1.needle"].setColorFill(1, 1, 0);
		} else if ( rpm1_pct < 101 ){
			me["rpm1.digits"].setColor(0, 1, 0);
			me["rpm1.needle"].setColorFill(0, 1, 0);
		} else {
			me["rpm1.digits"].setColor(1, 0, 0);
			me["rpm1.needle"].setColorFill(1, 0, 0);
		}
		
		var ot0_val = ( ot0.getDoubleValue() - 32 ) * 0.556; # convert from Fahrenheit to Celcius
		me["ot0.digits"].setText( sprintf("%3d", math.round( ot0_val ) ) );
		me["ot0.needle"].setRotation( ( math.clamp( ot0_val , -70, 150 ) + 70 ) / 220 * 120 * D2R );
		if( ot0_val < -40 or ot0_val > 127 ){
			me["ot0.digits"].setColor(1, 0, 0);
			me["ot0.needle"].setColorFill(1, 0, 0);
		} else if ( ot0_val < 55 or ot0_val > 110 ){
			me["ot0.digits"].setColor(1, 1, 0);
			me["ot0.needle"].setColorFill(1, 1, 0);
		} else {
			me["ot0.digits"].setColor(0, 1, 0);
			me["ot0.needle"].setColorFill(0, 1, 0);
		}
		
		var ot1_val = ( ot1.getDoubleValue() - 32 ) * 0.556; # convert from Fahrenheit to Celcius
		me["ot1.digits"].setText( sprintf("%3d", math.round( ot1_val ) ) );
		me["ot1.needle"].setRotation( ( math.clamp( ot1_val , -70, 150 ) + 70 ) / 220 * 120 * D2R );
		if( ot1_val < -40 or ot1_val > 127 ){
			me["ot1.digits"].setColor(1, 0, 0);
			me["ot1.needle"].setColorFill(1, 0, 0);
		} else if ( ot1_val < 55 or ot1_val > 110 ){
			me["ot1.digits"].setColor(1, 1, 0);
			me["ot1.needle"].setColorFill(1, 1, 0);
		} else {
			me["ot1.digits"].setColor(0, 1, 0);
			me["ot1.needle"].setColorFill(0, 1, 0);
		}
		
		var op0_val = op0.getDoubleValue();
		me["op0.digits"].setText( sprintf("%3d", math.round( op0_val ) ) );
		me["op0.needle"].setRotation( math.clamp( op0_val, 0, 150) / 150 * 120 * -D2R );
		if( op0_val < 40 or op0_val > 120 ){
			me["op0.digits"].setColor(1, 0, 0);
			me["op0.needle"].setColorFill(1, 0, 0);
		} else if ( op0_val < 70 ){
			me["op0.digits"].setColor(1, 1, 0);
			me["op0.needle"].setColorFill(1, 1, 0);
		} else {
			me["op0.digits"].setColor(0, 1, 0);
			me["op0.needle"].setColorFill(0, 1, 0);
		}
		
		var op1_val = op1.getDoubleValue();
		me["op1.digits"].setText( sprintf("%3d", math.round( op1_val ) ) );
		me["op1.needle"].setRotation( math.clamp( op1_val, 0, 150) / 150 * 120 * -D2R );
		if( op1_val < 40 or op1_val > 120 ){
			me["op1.digits"].setColor(1, 0, 0);
			me["op1.needle"].setColorFill(1, 0, 0);
		} else if ( op1_val < 70 ){
			me["op1.digits"].setColor(1, 1, 0);
			me["op1.needle"].setColorFill(1, 1, 0);
		} else {
			me["op1.digits"].setColor(0, 1, 0);
			me["op1.needle"].setColorFill(0, 1, 0);
		}
			
		
		me["fuelflow0.digits"].setText( sprintf("%4d", math.round( ff0_val, 100 ) ) );
		me["fuelflow0.needle"].setRotation( math.min( ff0_val, 500 ) / 500 * 240 * D2R );
		
		me["fuelflow1.digits"].setText( sprintf("%4d", math.round( ff1_val, 100 ) ) );
		me["fuelflow1.needle"].setRotation( math.min( ff1_val, 500 ) / 500 * 240 * D2R );
		
		if( ign0.getBoolValue() ){
			me["ign0.flag"].show();
		} else {
			me["ign0.flag"].hide();
		}
		
		if( ign1.getBoolValue() ){
			me["ign1.flag"].show();
		} else {
			me["ign1.flag"].hide();
		}
		
		# TODO Beta Flags
		me["beta0.flag"].hide();
		me["beta1.flag"].hide();
		
		
		#			RIGHT HALF
		#		Message Area
		for( var i=0; i <= 8; i += 1 ){
			if( messages.enabled[i].getBoolValue() ){
				if ( messages.shown[i] != 1 ){
					me["message."~i].show();
					messages.shown[i] = 1;
				}
				me["message."~i].setText( messages.text[i].getValue() );
				me["message."~i].setColor( messages.color.r[i].getDoubleValue(), messages.color.g[i].getDoubleValue(),  messages.color.b[i].getDoubleValue(), );
			} else if ( messages.shown[i] != 0 ){
				me["message."~i].hide();
				messages.shown[i] = 0;
			}
		}
		#		Various Systems - Prop Heating
		for( var i=0; i<=1; i += 1 ){
			var prop_ht = prop_ht_amps[i].getDoubleValue();
			me["propheating"~i~".amps.digits"].setText( sprintf("%2d", math.round( prop_ht ) ) );
			if( prop_ht < 1 ){
				me["propheating"~i~".amps.digits"].setColor( 1, 1, 1);
			} else if ( prop_ht < 21 or prop_ht > 28 ){
				me["propheating"~i~".amps.digits"].setColor( 1, 0.9, 0);
			} else {
				me["propheating"~i~".amps.digits"].setColor( 0, 1, 0);
			}
		}
		me["hydraulic_press.digits"].setText( sprintf("%4d", math.round( hyd_press.getDoubleValue() ) ) );
		
		#		Flight Controls
		me["aileron_trim.needle"].setTranslation( ail_trim.getDoubleValue() * 70, 0 );
		me["rudder_trim.needle"].setRotation( rud_trim.getDoubleValue() * -50 * D2R );
		me["elevator_trim.needle"].setTranslation( 0, elev_trim.getDoubleValue() * -69 );
		if( flaps_cmd.getDoubleValue() == 0 and elev_trim_green_range != 0 ){
			me["elevator_trim.green.flap0"].show();
			me["elevator_trim.green.flap1"].hide();
			elev_trim_green_range = 0;
		} else if ( flaps_cmd.getDoubleValue() != 0 and  elev_trim_green_range != 1 ){
			me["elevator_trim.green.flap0"].hide();
			me["elevator_trim.green.flap1"].show();
			elev_trim_green_range = 1;
		}
		me["flaps.needle"].setRotation( flaps_pos.getDoubleValue() * 90 * D2R );
		
		var fuel_lbs = [ nil, nil, nil, nil, nil, nil ];
		var fuel_norm = [ nil, nil, nil, nil, nil, nil ];
		
		var ind_factor = [ 90, 78, 47, 47, 78, 90 ];
		
		for( var i = 0; i <= 5; i += 1 ){
			fuel_lbs[i] = fuel_level_lbs[i].getDoubleValue();
			fuel_norm[i] = fuel_level_norm[i].getDoubleValue();
			if( i == 2 or i == 3 ){
				if( fuel_lbs[i] < 180 ){
					me["fuel"~i~".digits"].setColor( 1, 0.9, 0 );
					me["fuel"~i~".ind"].setColorFill( 1, 0.9, 0 );
				} else {
					me["fuel"~i~".digits"].setColor( 0, 1, 1 );
					me["fuel"~i~".ind"].setColorFill( 0, 1, 1 );
				}
			}
			me["fuel"~i~".digits"].setText( sprintf("%3d", math.round( fuel_lbs[i] ) ) );
			me["fuel"~i~".ind"].setTranslation( 0, ( 1 - fuel_norm[i] ) * ind_factor[i] );
		}
		
		var total_left = fuel_lbs[0] + fuel_lbs[1] + fuel_lbs[2];
		var total_right = fuel_lbs[3] + fuel_lbs[4] + fuel_lbs[5];
		me["fuel_total_left.digits"].setText( sprintf("%4d", math.round( total_left ) ) );
		me["fuel_total.digits"].setText( sprintf("%4d", math.round( total_left + total_right ) ) );
		me["fuel_total_right.digits"].setText( sprintf("%4d", math.round( total_right ) ) );
	}
	
};


var canvas_EFI_890R_MFD_start = {
	new: func(canvas_group, file) {
		var m = { parents: [canvas_EFI_890R_MFD_start , canvas_EFI_890R_MFD_base] };
		m.init(canvas_group, file);

		return m;
	},
	getKeys: func() {
		return [];
	},
	update: func() {
	}
	
};

var efi_mfd_update = maketimer(0.1, func {
	canvas_EFI_890R_MFD_base.update();
});
efi_mfd_update.simulatedTime = 1;

var ls_mfd = setlistener("sim/signals/fdm-initialized", func {
	EFI_890R_MFD_display = canvas.new({
		"name": "EFI_890R_MFD",
		"size": [780, 780],
		"view": [780, 780],
		"mipmapping": 1
	});
	EFI_890R_MFD_display.addPlacement({"node": "efi_890r_du2"});
	var groupMain = EFI_890R_MFD_display.createGroup();
	var groupStart = EFI_890R_MFD_display.createGroup();


	EFI_890R_MFD_main = canvas_EFI_890R_MFD_main.new(groupMain, instrument_path~"efi-890r-mfd.svg");
	EFI_890R_MFD_start = canvas_EFI_890R_MFD_start.new(groupStart, instrument_path~"efi-890r-start.svg");

	efi_mfd_update.start();
	
	removelistener(ls_mfd);
});
