# Instrumentation scripts
#
# Sergey "Mercenary_Mercury" Salow, Aug 2011
#
# Adapted for Su 33 Flanker D : Helijah November 2024

var init_systems = func{
  print ("Start");
  init_instrumentation();
}

var init_instrumentation = func {
  rifunc2();
  setprop("/instrumentation/SPO-15LM/lockon", 0);
  setprop("/instrumentation/SPO-15LM/fire", 0);
}

# Radar-imitation script for SPO-15
# Jule 2011, Sergey "Mercenary_Mercury"

var tower      = 0;
var tower_d    = 0;
var tower_sh   = 0;
var rif_pos_d  = 0;
var rif_pos_sh = 0;
var rif_head   = 0;
var rif_roll   = 0;
var rif_r_d    = 0;
var rif_r_sh   = 0;
var rif_range  = 0;
var rif_azimut = 0;
var atw        = 0;

var rifunc2 = func {
  rif_azimut = getprop("/instrumentation/gps/wp/wp[1]/bearing-true-deg");
  rif_range  = getprop("/instrumentation/gps/wp/wp[1]/distance-nm");
  if (rif_range > 200) {
    rif_range = 200.0;
  } else {
    rif_range = (200-rif_range);
  }
  var rif_range = (rif_range/200);
  setprop("/instrumentation/SPO-15LM/range_M-norm", rif_range);
  setprop("/instrumentation/SPO-15LM/azimut_M-norm", rif_azimut);
  settimer(rifunc2, 0.5);
}

var rifunc = func {
  if (tower == 0) {
    tower    = getprop("/sim[0]/tower/airport-id");
    tower_d  = getprop("/sim[0]/tower/longitude-deg");
    tower_sh = getprop("/sim[0]/tower/latitude-deg");
  }
  var rif_pos_d  = getprop("/postion/longitude-deg");
  var rif_pos_sh = getprop("/postion/latitude-deg");
  var rif_head   = getprop("/orientation/heading-deg");
  var rif_roll   = getprop("/orientation/roll-deg");

  if ( tower_d < rif_pos_d) {
    rif_r_d = (rif_pos_d-tower_d);
  } else {
    rif_r_d = (tower_d-rif_pos_d);
  }
  var rif_range = (rif_r_d+rif_r_sh);
  var rif_range = (rif_range*50);
  setprop("/instrumentation/SPO-15LM/range_M-norm", rif_range);
  settimer(rifunc, 0.5);
}

setlistener("/sim/signals/fdm-initialized", init_systems);

