# Simulation of Alpha Electro Air Speed Indicator (ASI) by Bea Wolf (D-ECHO) based on

# A3XX Lower ECAM Canvas
# Joshua Davidson (it0uchpods)

#Information based on manual http://www.flypipistrel.com/manuals/ALPHA%20ELECTRO%20POH%20A02.pdf
#######################################

var ASI_main = nil;
var ASI_display = nil;

var volts = props.globals.getNode("/systems/electrical/outputs/instruments", 1);
var ias_kt = props.globals.getNode("/instrumentation/airspeed-indicator/indicated-speed-kt", 1);

var instrument_dir = "Aircraft/AlphaElectro/Models/Instruments/ASI-alphaelectro/";


var canvas_ASI_base = {
	init: func(canvas_group, file) {
		var font_mapper = func(family, weight) {
			return "LiberationFonts/LiberationSans-Bold.ttf";
		};

		
		canvas.parsesvg(canvas_group, file, {'font-mapper': font_mapper});

		var svg_keys = me.getKeys();
		foreach (var key; svg_keys) {
			me[key] = canvas_group.getElementById(key);
		}

		me.page = canvas_group;

		return me;
	},
	getKeys: func() {
		return [];
	},
	update: func() {
		if ( volts.getDoubleValue() > 10) {
			ASI_main.page.show();
			ASI_main.update();
		} else {
			ASI_main.page.hide();
		}
	},
};
	
	
var canvas_ASI_main = {
	new: func(canvas_group, file) {
		var m = { parents: [canvas_ASI_main , canvas_ASI_base] };
		m.init(canvas_group, file);

		return m;
	},
	getKeys: func() {
		return ["ias"];
	},
	update: func() {
		me["ias"].setText( sprintf("%3d", math.round( ias_kt.getDoubleValue() )));
	}
	
};

var base_updater = maketimer( 0.02, canvas_ASI_base.update );
base_updater.simulatedTime = 1;

var ls = setlistener("sim/signals/fdm-initialized", func {
	removelistener( ls );
	ASI_display = canvas.new({
		"name": "ASI",
		"size": [256, 256],
		"view": [256, 256],
		"mipmapping": 1
	});
	ASI_display.addPlacement({"node": "ASI.display"});
	var groupMain = ASI_display.createGroup();

	ASI_main = canvas_ASI_main.new(groupMain, instrument_dir~"ASI_main.svg");

	base_updater.start();
});
