package RISCOS::ValidateAddr;

use RISCOS::SWI ':DEFAULT', '&C_Flag';
require Exporter;
use strict;
use vars qw (@ISA @EXPORT $VERSION $os_val $mask);

@ISA = qw(Exporter);
@EXPORT = qw(validate_addr);
$VERSION = 0.02;	# Now does ROM too

$os_val = SWINumberFromString("XOS_ValidateAddress");
$mask = &regmask([0,1],[15]);

sub validate_addr ($$) {
    my ($pc, $from, $to) = ('xxxx', @_);
    return undef unless defined ($from) && defined ($to);
    
    return 2 if $from >= 0x3800000 && $to < 0x4000000;
    
    return undef unless defined swix ($os_val, $mask, $from, $to, $pc);

    # Carry flag clear if range [R0,R1) is valid. Return 1 in this case.
    return (unpack ('i', $pc) & &C_Flag) ? 0 : 1;
}

$os_val;
__END__

=head1 NAME

RISCOS::ValidateAddr --perl module that checks an address range is valid

=head1 SYNOPSIS

    use RISCOS::ValidateAddr;
    $is_valid = validate_addr ($lower_inc, $upper_exc);

=head1 DESCRIPTION

This module provides a perl interface to C<OS_ValidateAddress>. This checks the
address range between the lower (inclusive) and upper (exclusive) bounds to see
if the entire specified range maps into physical RAM or ROM. (The memory should
actually exist unless you've been fiddling with C<OS_SetMemMapEntries>.)

Returns C<2> if the address range is in ROM,
C<1> if the address range is valid as RAM,
C<0> if it is not, undefined on error.

=head1 AUTHOR

Nicholas Clark <F<nick@unfortu.net>>

=cut
