package RISCOS::DrawFile::Group;

use strict;
use vars qw ($VERSION @ISA);

require RISCOS::DrawFile::Container;
require RISCOS::DrawFile::Object;

$VERSION = 0.01;
@ISA =  qw (RISCOS::DrawFile::Container RISCOS::DrawFile::Object);

sub new ($) {
    my $proto = shift;
    my $class = ref($proto) || $proto;

    my ($self, $type) = $class->RISCOS::DrawFile::Object::new (@_);
    return $self if ref ($self) eq 'ARRAY';

    $self->{'__NAME'} = unpack 'x24A12', $_[0];
    local $_[0] = \(substr $_[0], 36);
    my ($stuff, $a, $font) = $class->_split_drawobjs (@_);
    $self->Stuff ($stuff);
    $self->{'__TYPE'} = $type;
    
    wantarray ? ($self, $type, $font) : $self;
}

sub Size {
    my $self = shift;
    36 + $self->SUPER::Size;
}

sub Pack {
    my $self = shift;
    $self->PackTypeSizeBBox()
     . pack ('A12', $self->{'__NAME'})
     . $self->SUPER::Pack(@_);
}

sub Write {
    my $self = shift;
    my $good = print {$_[0]} $self->PackTypeSizeBBox(),
			     pack ('A12', $self->{'__NAME'});
    $good & $self->SUPER::Write (@_);	# Pass on args
}

sub Name {
    my $self = shift;
    my $name = $self->{'__NAME'};
    $self->{'__NAME'} = $_[0] if defined $_[0];
    $name;
}

1;
__END__

=head1 NAME

RISCOS::DrawFile::Group

=head1 SYNOPSIS

Class to handle groups in DrawFiles

=head1 DESCRIPTION

C<RISCOS::DrawFile::Group> provides a class to group other DrawFile objects. It
is derived from C<RISCOS::DrawFile::Container> and C<RISCOS::DrawFile::Object>.
In addition to their methods it provides one extra method

=over 4

=item Name [<name>]

returns the name of the group. If a new name is supplied it replaces the name
returned. Group names are truncated to 12 characters.

=back

=head1 BUGS

Not tested enough.

=head1 AUTHOR

Nicholas Clark <F<nick@unfortu.net>>
