NAME
    RISCOS::DrawFile::Common

SYNOPSIS
    Methods common to DrawFiles and objects within DrawFiles.

DESCRIPTION
    `RISCOS::DrawFile::Common' provides methods common to DrawFiles
    and to objects within DrawFiles. It provides one function
    `drawplus_split_type'.

  drawplus_split_type

    	$type = drawplus_split_type 0x00010402;		# $type = 0x02
    	($type, $layer, $flags, $spare) = drawplus_split_type $type;


    `drawplus_split_type' takes an integer and interprets it as a
    DrawPlus "extended tag". In scalar context it returns the
    standard draw type, in array context the list (type, layer,
    flags, spare), as described in the DrawPlus documentation.

  Methods

    Clone
        returns a copy of this object. Derived class implementors
        should see the RISCOS::Clone manpage for the cloning
        teqnique, and the assumptions it makes.

    BBox
        returns a reference to an array giving the bounding box, or
        `undef' if there is is no bounding box for this object
        (*i.e.* font tables, empty paths, option objects). Note that
        option objects and empty paths store a bounding box of
        (0,0,0,0) when saved. `BBox' will attempt to call
        `BBox_Calc' (which the derived class must provide) if the
        bounding box is currently unknown.

        As the returned array reference is the internal copy of the
        bounding box it must not be modified.

    Translate <x> <y> [<barf_func>]
        translates the object by (*x*, *y*), or calls
        &*barf_func*(*object*,*x*, *y*) for any object for which
        translation is not possible (*i.e.* unknown objects and
        tagged objects, as the tag data might contain co-ordinate
        information. If *barf_func* is undefined a warning is
        issued, while an empty string silences any warning, and
        assumes that altering the bounding box of any unknown object
        is sufficient to perform the translation.

    Inside <bbox>
        checks whether this object is entirely within the bounding
        box (passed as an array reference). Returns a reference to
        the object if it is, an empty list if it touches, intersects
        or lies outside the box. The empty list `()' is converted to
        `undef' in scalar context, whereas returning `undef' in list
        context would generate a one element list `(undef') which
        can cause surprises.

    InsideOrTouching <bbox>
        checks whether this object is entirely within or touching
        the bounding box (passed as an array reference). Returns a
        reference to the object if it is, `()' if it intersects or
        lies outside the box.

    Intersect <bbox>
        checks whether any of this object's bounding box is within
        the bounding box (passed as an array reference). Returns a
        reference to the object if it is, `()' if it lies outside
        the box (including just touching the edge).

    IntersectOrTouching <bbox>
        checks whether any of this object's bounding box is within
        the bounding box, or is touching the box (passed as an array
        reference). Returns a reference to the object if it is, `()'
        if it lies outside and is not touching the box.

    Outside <bbox>
        checks whether this object's bounding box is entirely
        outside the bounding box (passed as an array reference).
        Returns a reference to the object if it is, `()' if any part
        of the bounding box touches or intersects the box.


  Methods derived classes must supply

    In addition to the overriding above methods where appropriate
    (in particular `Type') derived classes (DrawFile and DrawFile
    objects) must provide the following methods. All objects within
    DrawFiles provide further classes as specifed in
    `RISCOS::DrawFile::Object'.

    BBox_Calc
        (re)calculates the bounding box, returning a reference to an
        array, or undef if there is no bounding box. As it has no
        idea about the data it contains `OpaqueObject' simply
        returns the bounding box it was given when it was called.

    PrePack <hash_reference>
        a hook to perform calculations immediately before saving a
        DrawFile. The hash reference is used to store the names of
        fonts needed in the FontTable, keys are font names, values
        the number of text objects that use that font (see `PrePack'
        in `RISCOS::DrawFile::Text' if you really must know).

    Pack <undef>, fonttable, ...
        returns a scalar containing the object packed ready to save
        into a DrawFile.

    Write <filehandle>, <fonttable>, ...
        writes the object to the given filehandle. `Write' should
        return true unless there was an error.


BUGS
    Not tested enough.

AUTHOR
    Nicholas Clark <nick@unfortu.net>

