/*
 * Decompiled with CFR 0.152.
 */
package org.apache.crimson.tree;

import org.apache.crimson.tree.DomEx;
import org.apache.crimson.tree.NodeBase;
import org.w3c.dom.CharacterData;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

abstract class DataNode
extends NodeBase
implements CharacterData {
    char[] data;
    static NodeListImpl childNodes = new NodeListImpl();

    DataNode() {
    }

    DataNode(char[] buf, int offset, int len) {
        this.data = new char[len];
        System.arraycopy(buf, offset, this.data, 0, len);
    }

    DataNode(String s) {
        if (s != null) {
            this.data = new char[s.length()];
            s.getChars(0, this.data.length, this.data, 0);
        } else {
            this.data = new char[0];
        }
    }

    public char[] getText() {
        return this.data;
    }

    public void setText(char[] buf) {
        this.data = buf;
    }

    public String toString() {
        if (this.data != null) {
            return new String(this.data);
        }
        return null;
    }

    public String getData() {
        return this.toString();
    }

    public void setData(String data) {
        if (this.isReadonly()) {
            throw new DomEx(7);
        }
        if (data == null) {
            this.setText(new char[0]);
        } else {
            this.setText(data.toCharArray());
        }
    }

    public int getLength() {
        return this.data == null ? 0 : this.data.length;
    }

    public String substringData(int offset, int count) throws DOMException {
        if (offset < 0 || offset > this.data.length || count < 0) {
            throw new DomEx(1);
        }
        count = Math.min(count, this.data.length - offset);
        return new String(this.data, offset, count);
    }

    public void appendData(String newData) {
        if (this.isReadonly()) {
            throw new DomEx(7);
        }
        int length = newData.length();
        char[] tmp = new char[length + this.data.length];
        System.arraycopy(this.data, 0, tmp, 0, this.data.length);
        newData.getChars(0, length, tmp, this.data.length);
        this.data = tmp;
    }

    public void insertData(int offset, String newData) throws DOMException {
        if (this.isReadonly()) {
            throw new DomEx(7);
        }
        if (offset < 0 || offset > this.data.length) {
            throw new DomEx(1);
        }
        int length = newData.length();
        char[] tmp = new char[length + this.data.length];
        System.arraycopy(this.data, 0, tmp, 0, offset);
        newData.getChars(0, length, tmp, offset);
        System.arraycopy(this.data, offset, tmp, offset + length, this.data.length - offset);
        this.data = tmp;
    }

    public void deleteData(int offset, int count) throws DOMException {
        if (this.isReadonly()) {
            throw new DomEx(7);
        }
        if (offset < 0 || offset >= this.data.length || count < 0) {
            throw new DomEx(1);
        }
        count = Math.min(count, this.data.length - offset);
        char[] tmp = new char[this.data.length - count];
        System.arraycopy(this.data, 0, tmp, 0, offset);
        System.arraycopy(this.data, offset + count, tmp, offset, tmp.length - offset);
        this.data = tmp;
    }

    public void replaceData(int offset, int count, String arg) throws DOMException {
        if (this.isReadonly()) {
            throw new DomEx(7);
        }
        if (offset < 0 || offset >= this.data.length || count < 0) {
            throw new DomEx(1);
        }
        if (offset + count >= this.data.length) {
            this.deleteData(offset, count);
            this.appendData(arg);
        } else if (arg.length() == count) {
            arg.getChars(0, arg.length(), this.data, offset);
        } else {
            char[] tmp = new char[this.data.length + (arg.length() - count)];
            System.arraycopy(this.data, 0, tmp, 0, offset);
            arg.getChars(0, arg.length(), tmp, offset);
            System.arraycopy(this.data, offset + count, tmp, offset + arg.length(), this.data.length - (offset + count));
            this.data = tmp;
        }
    }

    public NodeList getChildNodes() {
        return childNodes;
    }

    public String getNodeValue() {
        return this.getData();
    }

    public void setNodeValue(String value) {
        this.setData(value);
    }

    static final class NodeListImpl
    implements NodeList {
        NodeListImpl() {
        }

        public Node item(int i) {
            return null;
        }

        public int getLength() {
            return 0;
        }
    }
}

