/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.om.impl.mixin;

import javax.xml.namespace.QName;
import org.apache.axiom.core.CoreNamedNode;
import org.apache.axiom.om.OMException;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.impl.common.OMNamespaceImpl;
import org.apache.axiom.om.impl.common.builder.OMNamespaceCache;
import org.apache.axiom.om.impl.intf.AxiomElement;
import org.apache.axiom.om.impl.intf.AxiomNamedInformationItem;
import org.apache.axiom.om.impl.intf.AxiomSourcedElement;
import org.apache.axiom.util.xml.QNameCache;
import org.apache.axiom.weaver.annotation.Mixin;

@Mixin
public abstract class AxiomNamedInformationItemMixin
implements AxiomNamedInformationItem {
    private OMNamespace namespace;
    private String localName;

    @Override
    public final void initName(String namespaceURI, String localName, String prefix, Object namespaceHelper) {
        this.localName = localName;
        this.namespace = ((OMNamespaceCache)namespaceHelper).getOMNamespace(namespaceURI, prefix);
    }

    @Override
    public final void internalSetNamespace(OMNamespace namespace) {
        this.namespace = namespace;
    }

    @Override
    public final String internalGetLocalName() {
        return this.localName;
    }

    @Override
    public final void internalSetLocalName(String localName) {
        this.localName = localName;
    }

    @Override
    public OMNamespace getNamespace() {
        return this.defaultGetNamespace();
    }

    @Override
    public final String getLocalName() {
        return this.coreGetLocalName();
    }

    @Override
    public final String getNamespaceURI() {
        String namespaceURI = this.coreGetNamespaceURI();
        return namespaceURI.length() == 0 ? null : namespaceURI;
    }

    @Override
    public final String getPrefix() {
        String prefix = this.coreGetPrefix();
        return prefix.length() == 0 ? null : prefix;
    }

    @Override
    public final OMNamespace defaultGetNamespace() {
        return this.namespace;
    }

    @Override
    public final void setLocalName(String localName) {
        this.beforeSetLocalName();
        this.localName = localName;
    }

    @Override
    public QName getQName() {
        return this.defaultGetQName();
    }

    @Override
    public final QName defaultGetQName() {
        return QNameCache.getQName(this.namespace == null ? "" : this.namespace.getNamespaceURI(), this.localName, this.namespace == null ? "" : this.namespace.getPrefix());
    }

    @Override
    public final boolean hasName(QName name) {
        if (name.getLocalPart().equals(this.getLocalName())) {
            OMNamespace ns = this.getNamespace();
            return ns == null && name.getNamespaceURI().length() == 0 || ns != null && name.getNamespaceURI().equals(ns.getNamespaceURI());
        }
        return false;
    }

    @Override
    public final String coreGetNamespaceURI() {
        OMNamespace namespace = this.getNamespace();
        return namespace == null ? "" : namespace.getNamespaceURI();
    }

    @Override
    public final String coreGetPrefix() {
        OMNamespace namespace = this.getNamespace();
        return namespace == null ? "" : namespace.getPrefix();
    }

    @Override
    public final void coreSetName(String namespaceURI, String localName, String prefix) {
        this.localName = localName;
        this.namespace = namespaceURI.length() == 0 && prefix.length() == 0 ? null : new OMNamespaceImpl(namespaceURI, prefix);
    }

    @Override
    public final void initName(CoreNamedNode other) {
        AxiomNamedInformationItem o = (AxiomNamedInformationItem)other;
        if (o instanceof AxiomSourcedElement && ((AxiomElement)((Object)this)).isExpanded()) {
            this.localName = o.coreGetLocalName();
            this.namespace = o.getNamespace();
        } else {
            this.localName = o.internalGetLocalName();
            this.namespace = o.defaultGetNamespace();
        }
    }

    public void updateLocalName() {
        throw new IllegalStateException();
    }

    @Override
    public final String coreGetLocalName() {
        if (this.localName == null) {
            this.updateLocalName();
        }
        return this.localName;
    }

    @Override
    public final void coreSetPrefix(String prefix) {
        OMNamespace ns = this.getNamespace();
        if (ns == null) {
            if (prefix.length() > 0) {
                throw new OMException("Cannot set prefix on an information item without namespace");
            }
        } else {
            this.internalSetNamespace(new OMNamespaceImpl(ns.getNamespaceURI(), prefix));
        }
    }
}

