
/*
This Java source file was generated by test-to-java.xsl
and is a derived work from the source document.
The source document contained the following notice:



Copyright (c) 2001-2004 World Wide Web Consortium, 
(Massachusetts Institute of Technology, Institut National de
Recherche en Informatique et en Automatique, Keio University).  All 
Rights Reserved.  This program is distributed under the W3C's Software
Intellectual Property License.  This program is distributed in the 
hope that it will be useful, but WITHOUT ANY WARRANTY; without even
the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  

See W3C License http://www.w3.org/Consortium/Legal/ for more details.


*/

package org.w3c.domts.level3.core;

import org.w3c.dom.*;


import org.w3c.domts.DOMTestCase;
import org.w3c.domts.DOMTestDocumentBuilderFactory;



/**
 *  Create two entity reference nodes. Using compareDocumentPosition to check if the child of the first Entity 
 *  Ref node precedes the child of the second Entity Ref node, and that the child of the second Entity Ref node
 *  follows the child of the first Entity Ref node.  
* @author IBM
* @author Jenny Hsu
* @see <a href="http://www.w3.org/TR/2003/CR-DOM-Level-3-Core-20031107/core#Node3-compareDocumentPosition">http://www.w3.org/TR/2003/CR-DOM-Level-3-Core-20031107/core#Node3-compareDocumentPosition</a>
*/
public final class nodecomparedocumentposition29 extends DOMTestCase {

   /**
    * Constructor.
    * @param factory document factory, may not be null
    * @throws org.w3c.domts.DOMTestIncompatibleException Thrown if test is not compatible with parser configuration
    */
   public nodecomparedocumentposition29(final DOMTestDocumentBuilderFactory factory)  throws org.w3c.domts.DOMTestIncompatibleException {
      super(factory);

    //
    //   check if loaded documents are supported for content type
    //
    String contentType = getContentType();
    preload(contentType, "hc_staff", true);
    }

   /**
    * Runs the test case.
    * @throws Throwable Any uncaught exception causes test to fail
    */
   public void runTest() throws Throwable {
      Document doc;
      Element docElem;
      EntityReference entRef1;
      EntityReference entRef2;
      Element entRefChild1;
      ProcessingInstruction entRefChild2;
      int entRefChild1Position;
      int entRefChild2Position;
      Node appendedChild;
      doc = (Document) load("hc_staff", true);
      entRef1 = doc.createEntityReference("ent4");
      entRef2 = doc.createEntityReference("ent4");
      docElem = doc.getDocumentElement();
      appendedChild = docElem.appendChild(entRef1);
      appendedChild = docElem.appendChild(entRef2);
      entRefChild1 = (Element) entRef1.getFirstChild();
      assertNotNull("entRefChild1NotNull", entRefChild1);
      entRefChild2 = (ProcessingInstruction) entRef2.getLastChild();
      assertNotNull("entRefChild2NotNull", entRefChild2);
      entRefChild1Position = (int) entRefChild1.compareDocumentPosition(entRefChild2);
      assertEquals("nodecomparedocumentpositionFollowing29", 4, entRefChild1Position);
      entRefChild2Position = (int) entRefChild2.compareDocumentPosition(entRefChild1);
      assertEquals("nodecomparedocumentpositionPRECEDING29", 2, entRefChild2Position);
      }
   /**
    *  Gets URI that identifies the test.
    *  @return uri identifier of test
    */
   public String getTargetURI() {
      return "http://www.w3.org/2001/DOM-Test-Suite/level3/core/nodecomparedocumentposition29";
   }
   /**
    * Runs this test from the command line.
    * @param args command line arguments
    */
   public static void main(final String[] args) {
        DOMTestCase.doMain(nodecomparedocumentposition29.class, args);
   }
}

