/*
 * Decompiled with CFR 0.152.
 */
package org.apache.abdera.parser.stax;

import java.net.URL;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.MimeType;
import javax.activation.MimeTypeParseException;
import javax.activation.URLDataSource;
import org.apache.abdera.i18n.iri.IRI;
import org.apache.abdera.i18n.text.Localizer;
import org.apache.abdera.model.Content;
import org.apache.abdera.model.Div;
import org.apache.abdera.model.Element;
import org.apache.abdera.model.ElementWrapper;
import org.apache.abdera.parser.stax.FOMDiv;
import org.apache.abdera.parser.stax.FOMExtensibleElement;
import org.apache.abdera.parser.stax.FOMFactory;
import org.apache.abdera.util.Constants;
import org.apache.axiom.attachments.ByteArrayDataSource;
import org.apache.axiom.fom.AbderaContent;
import org.apache.axiom.fom.AbderaElement;
import org.apache.axiom.fom.AbderaElementMixin;
import org.apache.axiom.fom.IRIUtil;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.impl.common.AxiomContainerSupport;
import org.apache.axiom.om.impl.common.AxiomElementSupport;
import org.apache.axiom.util.base64.Base64Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FOMContent
extends FOMExtensibleElement
implements AbderaContent {
    protected Content.Type type = Content.Type.TEXT;

    public final Content.Type getContentType() {
        return this.type;
    }

    public Content setContentType(Content.Type type) {
        this.type = type;
        if (Content.Type.TEXT.equals((Object)type)) {
            this.setAttributeValue(Constants.TYPE, "text");
        } else if (Content.Type.HTML.equals((Object)type)) {
            this.setAttributeValue(Constants.TYPE, "html");
        } else if (Content.Type.XHTML.equals((Object)type)) {
            this.setAttributeValue(Constants.TYPE, "xhtml");
        } else if (Content.Type.XML.equals((Object)type)) {
            this.setAttributeValue(Constants.TYPE, "application/xml");
        } else {
            this.removeAttribute(Constants.TYPE);
        }
        return this;
    }

    public <T extends Element> T getValueElement() {
        FOMFactory factory = (FOMFactory)this.getFactory();
        return factory.getElementWrapper((Element)AxiomElementSupport.ajc$interMethodDispatch1$org_apache_axiom_om_impl_common_AxiomElementSupport$org_apache_axiom_om_impl_intf_AxiomElement$getFirstElement(this));
    }

    public <T extends Element> Content setValueElement(T value) {
        if (value != null) {
            String mt;
            MimeType mtype;
            if (AxiomElementSupport.ajc$interMethodDispatch1$org_apache_axiom_om_impl_common_AxiomElementSupport$org_apache_axiom_om_impl_intf_AxiomElement$getFirstElement(this) != null) {
                AxiomElementSupport.ajc$interMethodDispatch1$org_apache_axiom_om_impl_common_AxiomElementSupport$org_apache_axiom_om_impl_intf_AxiomElement$getFirstElement(this).discard();
            }
            if ((mtype = this.getMimeType()) == null && (mt = this.getFactory().getMimeType(value)) != null) {
                this.setMimeType(mt);
                mtype = this.getMimeType();
            }
            if (value instanceof Div && !this.type.equals((Object)Content.Type.XML)) {
                this.setContentType(Content.Type.XHTML);
            } else if (mtype == null) {
                this.setContentType(Content.Type.XML);
            }
            AbderaElement el = (AbderaElement)(value instanceof ElementWrapper ? ((ElementWrapper)value).getInternal() : value);
            AxiomContainerSupport.ajc$interMethodDispatch1$org_apache_axiom_om_impl_common_AxiomContainerSupport$org_apache_axiom_om_impl_intf_AxiomContainer$removeChildren(this);
            this._addChild(el);
        } else {
            AbderaElementMixin.ajc$interMethodDispatch1$org_apache_axiom_fom_AbderaElementMixin$org_apache_axiom_fom_AbderaElement$_removeAllChildren(this);
        }
        return this;
    }

    public MimeType getMimeType() {
        MimeType type = null;
        String mimeType = this.getAttributeValue(Constants.TYPE);
        if (mimeType != null) {
            try {
                type = new MimeType(mimeType);
            }
            catch (Exception exception) {}
        }
        return type;
    }

    public Content setMimeType(String type) {
        try {
            this.setAttributeValue(Constants.TYPE, type == null ? null : new MimeType(type).toString());
        }
        catch (MimeTypeParseException e) {
            throw new org.apache.abdera.util.MimeTypeParseException(e);
        }
        return this;
    }

    public IRI getSrc() {
        return IRIUtil.getUriValue(this.getAttributeValue(Constants.SRC));
    }

    public IRI getResolvedSrc() {
        return IRIUtil.resolve(this.getResolvedBaseUri(), this.getSrc());
    }

    public Content setSrc(String src) {
        this.setAttributeValue(Constants.SRC, IRIUtil.normalize(src));
        return this;
    }

    public DataHandler getDataHandler() {
        if (!Content.Type.MEDIA.equals((Object)this.type)) {
            throw new UnsupportedOperationException(Localizer.get((String)"DATA.HANDLER.NOT.SUPPORTED"));
        }
        MimeType type = this.getMimeType();
        URL src = null;
        try {
            src = this.getSrc().toURL();
        }
        catch (Exception exception) {}
        DataHandler dh = null;
        dh = src == null ? new DataHandler((DataSource)new ByteArrayDataSource(Base64Utils.decode((String)this.getText()), type != null ? type.toString() : null)) : new DataHandler((DataSource)new URLDataSource(src));
        return dh;
    }

    public Content setDataHandler(DataHandler dataHandler) {
        if (!Content.Type.MEDIA.equals((Object)this.type)) {
            throw new IllegalArgumentException();
        }
        if (dataHandler.getContentType() != null) {
            try {
                this.setMimeType(dataHandler.getContentType());
            }
            catch (Exception exception) {}
        }
        AbderaElementMixin.ajc$interMethodDispatch1$org_apache_axiom_fom_AbderaElementMixin$org_apache_axiom_fom_AbderaElement$_removeAllChildren(this);
        AxiomContainerSupport.ajc$interMethodDispatch1$org_apache_axiom_om_impl_common_AxiomContainerSupport$org_apache_axiom_om_impl_intf_AxiomContainer$addChild(this, (OMNode)this.getOMFactory().createOMText((Object)dataHandler, true));
        return this;
    }

    public String getValue() {
        String val = null;
        if (Content.Type.TEXT.equals((Object)this.type)) {
            val = this.getText();
        } else if (Content.Type.HTML.equals((Object)this.type)) {
            val = this.getText();
        } else if (Content.Type.XHTML.equals((Object)this.type)) {
            FOMDiv div = (FOMDiv)this._getFirstChildWithName(Constants.DIV);
            if (div != null) {
                val = div.getInternalValue();
            }
        } else if (Content.Type.XML.equals((Object)this.type)) {
            OMElement el = AxiomElementSupport.ajc$interMethodDispatch1$org_apache_axiom_om_impl_common_AxiomElementSupport$org_apache_axiom_om_impl_intf_AxiomElement$getFirstElement(this);
            if (el != null) {
                val = el.toString();
            }
        } else if (Content.Type.MEDIA.equals((Object)this.type)) {
            val = this.getText();
        }
        return val;
    }

    public <T extends Element> T setText(Content.Type type, String value) {
        this.setContentType(type);
        if (value != null) {
            OMNode child = AxiomContainerSupport.ajc$interMethodDispatch1$org_apache_axiom_om_impl_common_AxiomContainerSupport$org_apache_axiom_om_impl_intf_AxiomContainer$getFirstOMChild(this);
            while (child != null) {
                if (child.getType() == 4) {
                    child.detach();
                }
                child = child.getNextOMSibling();
            }
            this.getOMFactory().createOMText((OMContainer)this, value);
        } else {
            AbderaElementMixin.ajc$interMethodDispatch1$org_apache_axiom_fom_AbderaElementMixin$org_apache_axiom_fom_AbderaElement$_removeAllChildren(this);
        }
        return (T)this;
    }

    public Content setValue(String value) {
        if (value != null) {
            this.removeAttribute(Constants.SRC);
        }
        if (value != null) {
            if (Content.Type.TEXT.equals((Object)this.type)) {
                AbderaElementMixin.ajc$interMethodDispatch1$org_apache_axiom_fom_AbderaElementMixin$org_apache_axiom_fom_AbderaElement$_removeAllChildren(this);
                this.setText(this.type, value);
            } else if (Content.Type.HTML.equals((Object)this.type)) {
                AbderaElementMixin.ajc$interMethodDispatch1$org_apache_axiom_fom_AbderaElementMixin$org_apache_axiom_fom_AbderaElement$_removeAllChildren(this);
                this.setText(this.type, value);
            } else if (Content.Type.XHTML.equals((Object)this.type)) {
                IRI baseUri = null;
                Element element = null;
                value = "<div xmlns=\"http://www.w3.org/1999/xhtml\">" + value + "</div>";
                try {
                    baseUri = this.getResolvedBaseUri();
                    element = this._parse(value, baseUri);
                }
                catch (Exception exception) {}
                if (element != null && element instanceof Div) {
                    this.setValueElement((Div)element);
                }
            } else if (Content.Type.XML.equals((Object)this.type)) {
                IRI baseUri = null;
                Element element = null;
                try {
                    baseUri = this.getResolvedBaseUri();
                    element = this._parse(value, baseUri);
                }
                catch (Exception exception) {}
                if (element != null) {
                    this.setValueElement(element);
                }
                try {
                    if (this.getMimeType() == null) {
                        this.setMimeType("application/xml");
                    }
                }
                catch (Exception exception) {}
            } else if (Content.Type.MEDIA.equals((Object)this.type)) {
                AbderaElementMixin.ajc$interMethodDispatch1$org_apache_axiom_fom_AbderaElementMixin$org_apache_axiom_fom_AbderaElement$_removeAllChildren(this);
                this.setText(this.type, value);
                try {
                    if (this.getMimeType() == null) {
                        this.setMimeType("text/plain");
                    }
                }
                catch (Exception exception) {}
            }
        } else {
            AbderaElementMixin.ajc$interMethodDispatch1$org_apache_axiom_fom_AbderaElementMixin$org_apache_axiom_fom_AbderaElement$_removeAllChildren(this);
        }
        return this;
    }

    public String getWrappedValue() {
        if (Content.Type.XHTML.equals((Object)this.type)) {
            return this._getFirstChildWithName(Constants.DIV).toString();
        }
        return this.getText();
    }

    public Content setWrappedValue(String wrappedValue) {
        if (Content.Type.XHTML.equals((Object)this.type)) {
            IRI baseUri = null;
            Element element = null;
            try {
                baseUri = this.getResolvedBaseUri();
                element = this._parse(wrappedValue, baseUri);
            }
            catch (Exception exception) {}
            if (element != null && element instanceof Div) {
                this.setValueElement((Div)element);
            }
        } else {
            this.setText(wrappedValue);
        }
        return this;
    }

    @Override
    public IRI getBaseUri() {
        Object el;
        if (Content.Type.XHTML.equals((Object)this.type) && (el = this.getValueElement()) != null && el.getAttributeValue(Constants.BASE) != null) {
            if (this.getAttributeValue(Constants.BASE) != null) {
                return super.getBaseUri().resolve(el.getAttributeValue(Constants.BASE));
            }
            return IRIUtil.getUriValue(el.getAttributeValue(Constants.BASE));
        }
        return super.getBaseUri();
    }

    @Override
    public IRI getResolvedBaseUri() {
        Object el;
        if (Content.Type.XHTML.equals((Object)this.type) && (el = this.getValueElement()) != null && el.getAttributeValue(Constants.BASE) != null) {
            return super.getResolvedBaseUri().resolve(el.getAttributeValue(Constants.BASE));
        }
        return super.getResolvedBaseUri();
    }

    @Override
    public String getLanguage() {
        Object el;
        if (Content.Type.XHTML.equals((Object)this.type) && (el = this.getValueElement()).getAttributeValue(Constants.LANG) != null) {
            return el.getAttributeValue(Constants.LANG);
        }
        return super.getLanguage();
    }

    @Override
    public Object clone() {
        FOMContent content = (FOMContent)super.clone();
        content.type = this.type;
        return content;
    }
}

