/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.blob;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.axiom.blob.MemoryBlobChunk;
import org.apache.axiom.blob.MemoryBlobImpl;
import org.apache.axiom.ext.io.ReadFromSupport;
import org.apache.axiom.ext.io.StreamCopyException;

final class MemoryBlobOutputStream
extends OutputStream
implements ReadFromSupport {
    private final MemoryBlobImpl blob;
    private MemoryBlobChunk chunk;

    MemoryBlobOutputStream(MemoryBlobImpl blob, MemoryBlobChunk firstChunk) {
        this.blob = blob;
        this.chunk = firstChunk;
    }

    private void updateChunk() {
        if (this.chunk.size == this.chunk.buffer.length) {
            this.chunk = this.chunk.allocateNextChunk();
        }
    }

    public void write(byte[] b, int off, int len) {
        if (this.chunk == null) {
            throw new IllegalStateException();
        }
        int total = 0;
        while (total < len) {
            this.updateChunk();
            int c = Math.min(len - total, this.chunk.buffer.length - this.chunk.size);
            System.arraycopy(b, off, this.chunk.buffer, this.chunk.size, c);
            this.chunk.size += c;
            total += c;
            off += c;
        }
    }

    public void write(int b) {
        if (this.chunk == null) {
            throw new IllegalStateException();
        }
        this.updateChunk();
        this.chunk.buffer[this.chunk.size++] = (byte)b;
    }

    public long readFrom(InputStream in, long length) throws StreamCopyException {
        long toRead;
        if (this.chunk == null) {
            throw new IllegalStateException();
        }
        long read = 0L;
        long l = toRead = length == -1L ? Long.MAX_VALUE : length;
        while (toRead > 0L) {
            int c;
            this.updateChunk();
            try {
                c = in.read(this.chunk.buffer, this.chunk.size, (int)Math.min(toRead, (long)(this.chunk.buffer.length - this.chunk.size)));
            }
            catch (IOException ex) {
                throw new StreamCopyException(1, ex);
            }
            if (c == -1) break;
            this.chunk.size += c;
            read += (long)c;
            toRead -= (long)c;
        }
        return read;
    }

    public void close() {
        this.blob.commit();
        this.chunk = null;
    }
}

