/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.request.http.handler;

import org.apache.wicket.request.IRequestCycle;
import org.apache.wicket.request.IRequestHandler;
import org.apache.wicket.request.http.WebResponse;

public class RedirectRequestHandler
implements IRequestHandler {
    private final String redirectUrl;
    private final int status;

    public RedirectRequestHandler(String redirectUrl) {
        this(redirectUrl, 302);
    }

    public RedirectRequestHandler(String redirectUrl, int status) {
        if (status != 301 && status != 302 && status != 303) {
            throw new IllegalStateException("Status must be either 301, 302 or 303, but was: " + status);
        }
        this.redirectUrl = redirectUrl;
        this.status = status;
    }

    public String getRedirectUrl() {
        return this.redirectUrl;
    }

    public int getStatus() {
        return this.status;
    }

    @Override
    public void detach(IRequestCycle requestCycle) {
    }

    @Override
    public void respond(IRequestCycle requestCycle) {
        String url = this.getRedirectUrl();
        String location = url.charAt(0) == '/' ? requestCycle.getUrlRenderer().renderContextRelativeUrl(url) : url;
        WebResponse response = (WebResponse)requestCycle.getResponse();
        if (this.status == 302) {
            response.sendRedirect(location);
        } else {
            response.setStatus(this.status);
            response.setHeader("Location", location);
        }
    }
}

