/*
 * Decompiled with CFR 0.152.
 */
package javax.money.format;

import java.util.Locale;
import java.util.Objects;
import javax.money.AbstractQueryBuilder;
import javax.money.MonetaryAmountFactory;
import javax.money.MonetaryAmountFactoryQuery;
import javax.money.format.AmountFormatQuery;

public final class AmountFormatQueryBuilder
extends AbstractQueryBuilder<AmountFormatQueryBuilder, AmountFormatQuery> {
    private static final String DEFAULT_FORMAT_NAME = "default";

    private AmountFormatQueryBuilder(AmountFormatQuery formatQuery) {
        this.importContext(formatQuery);
    }

    private AmountFormatQueryBuilder(String formatName) {
        Objects.requireNonNull(formatName, "formatName required.");
        this.set("Query.formatName", formatName);
    }

    private AmountFormatQueryBuilder(Locale locale) {
        Objects.requireNonNull(locale, "locale required.");
        this.setLocale(locale);
        this.set("Query.formatName", DEFAULT_FORMAT_NAME);
    }

    public AmountFormatQueryBuilder setFormatName(String formatName) {
        return (AmountFormatQueryBuilder)this.set("Query.formatName", formatName);
    }

    public AmountFormatQueryBuilder setLocale(Locale locale) {
        return (AmountFormatQueryBuilder)this.set(locale);
    }

    public AmountFormatQueryBuilder setMonetaryQuery(MonetaryAmountFactoryQuery monetaryQuery) {
        Objects.requireNonNull(monetaryQuery);
        return (AmountFormatQueryBuilder)this.set(monetaryQuery);
    }

    public AmountFormatQueryBuilder setMonetaryAmountFactory(MonetaryAmountFactory<?> monetaryFactory) {
        Objects.requireNonNull(monetaryFactory);
        return (AmountFormatQueryBuilder)this.set(MonetaryAmountFactory.class, monetaryFactory);
    }

    @Override
    public AmountFormatQuery build() {
        return new AmountFormatQuery(this);
    }

    public static AmountFormatQueryBuilder of(AmountFormatQuery formatQuery) {
        return new AmountFormatQueryBuilder(formatQuery);
    }

    public static AmountFormatQueryBuilder of(String formatName) {
        return new AmountFormatQueryBuilder(formatName);
    }

    public static AmountFormatQueryBuilder of(Locale locale) {
        return new AmountFormatQueryBuilder(locale);
    }
}

