/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.schema.rest;

import java.util.Set;
import javax.jws.WebMethod;
import javax.jws.WebService;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.cxf.rs.security.cors.CrossOriginResourceSharing;
import org.apache.unomi.rest.exception.InvalidRequestException;
import org.apache.unomi.schema.api.JsonSchemaWrapper;
import org.apache.unomi.schema.api.SchemaService;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebService
@Produces(value={"application/json;charset=UTF-8"})
@CrossOriginResourceSharing(allowAllOrigins=true, allowCredentials=true)
@Path(value="/jsonSchema")
@Component(service={JsonSchemaEndPoint.class}, property={"osgi.jaxrs.resource=true"})
public class JsonSchemaEndPoint {
    private static final Logger logger = LoggerFactory.getLogger((String)JsonSchemaEndPoint.class.getName());
    @Reference
    private SchemaService schemaService;

    public JsonSchemaEndPoint() {
        logger.info("Initializing JSON schema endpoint...");
    }

    @WebMethod(exclude=true)
    public void setSchemaService(SchemaService schemaService) {
        this.schemaService = schemaService;
    }

    @GET
    @Path(value="/")
    public Set<String> getInstalledJsonSchemaIds() {
        return this.schemaService.getInstalledJsonSchemaIds();
    }

    @POST
    @Path(value="/query")
    public String getSchema(String id) {
        JsonSchemaWrapper schema = this.schemaService.getSchema(id);
        if (schema != null) {
            return schema.getSchema().replace("\n", "");
        }
        return null;
    }

    @POST
    @Path(value="/")
    @Consumes(value={"text/plain", "application/json"})
    @Produces(value={"application/json"})
    public Response save(String jsonSchema) {
        try {
            this.schemaService.saveSchema(jsonSchema);
            return Response.ok().build();
        }
        catch (Exception e) {
            throw new InvalidRequestException(e.getMessage(), "Unable to save schema");
        }
    }

    @POST
    @Path(value="/delete")
    public boolean remove(String id) {
        return this.schemaService.deleteSchema(id);
    }
}

