/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.api.utils;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.unomi.api.Event;
import org.apache.unomi.api.PropertyType;
import org.apache.unomi.api.ValueType;
import org.apache.unomi.api.actions.Action;
import org.apache.unomi.api.actions.ActionType;
import org.apache.unomi.api.conditions.Condition;
import org.apache.unomi.api.conditions.ConditionType;
import org.apache.unomi.api.rules.Rule;
import org.apache.unomi.api.services.DefinitionsService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParserHelper {
    private static final Logger logger = LoggerFactory.getLogger(ParserHelper.class);
    private static final Set<String> unresolvedActionTypes = new HashSet<String>();
    private static final Set<String> unresolvedConditionTypes = new HashSet<String>();
    private static final String VALUE_NAME_SEPARATOR = "::";
    private static final String PLACEHOLDER_PREFIX = "${";
    private static final String PLACEHOLDER_SUFFIX = "}";
    public static final Map<String, ValueExtractor> DEFAULT_VALUE_EXTRACTORS = new HashMap<String, ValueExtractor>();

    public static boolean resolveConditionType(final DefinitionsService definitionsService, Condition rootCondition, final String contextObjectName) {
        if (rootCondition == null) {
            logger.warn("Couldn't resolve null condition for {}", (Object)contextObjectName);
            return false;
        }
        final ArrayList result = new ArrayList();
        ParserHelper.visitConditions(rootCondition, new ConditionVisitor(){

            @Override
            public void visit(Condition condition) {
                if (condition.getConditionType() == null) {
                    ConditionType conditionType = definitionsService.getConditionType(condition.getConditionTypeId());
                    if (conditionType != null) {
                        unresolvedConditionTypes.remove(condition.getConditionTypeId());
                        condition.setConditionType(conditionType);
                    } else {
                        result.add(condition.getConditionTypeId());
                        if (!unresolvedConditionTypes.contains(condition.getConditionTypeId())) {
                            unresolvedConditionTypes.add(condition.getConditionTypeId());
                            logger.warn("Couldn't resolve condition type: {} for {}", (Object)condition.getConditionTypeId(), (Object)contextObjectName);
                        }
                    }
                }
            }

            @Override
            public void postVisit(Condition condition) {
            }
        });
        return result.isEmpty();
    }

    public static List<String> getConditionTypeIds(Condition rootCondition) {
        final ArrayList<String> result = new ArrayList<String>();
        ParserHelper.visitConditions(rootCondition, new ConditionVisitor(){

            @Override
            public void visit(Condition condition) {
                result.add(condition.getConditionTypeId());
            }

            @Override
            public void postVisit(Condition condition) {
            }
        });
        return result;
    }

    public static void visitConditions(Condition rootCondition, ConditionVisitor visitor) {
        visitor.visit(rootCondition);
        for (Object parameterValue : rootCondition.getParameterValues().values()) {
            if (parameterValue instanceof Condition) {
                Condition parameterValueCondition = (Condition)parameterValue;
                ParserHelper.visitConditions(parameterValueCondition, visitor);
                continue;
            }
            if (!(parameterValue instanceof Collection)) continue;
            Collection valueList = (Collection)parameterValue;
            for (Object value : valueList) {
                if (!(value instanceof Condition)) continue;
                Condition valueCondition = (Condition)value;
                ParserHelper.visitConditions(valueCondition, visitor);
            }
        }
        visitor.postVisit(rootCondition);
    }

    public static boolean resolveActionTypes(DefinitionsService definitionsService, Rule rule, boolean ignoreErrors) {
        boolean result = true;
        if (rule.getActions() == null) {
            if (!ignoreErrors) {
                logger.warn("Rule {}:{} has null actions", (Object)rule.getItemId(), (Object)rule.getMetadata().getName());
            }
            return false;
        }
        if (rule.getActions().isEmpty()) {
            if (!ignoreErrors) {
                logger.warn("Rule {}:{} has empty actions", (Object)rule.getItemId(), (Object)rule.getMetadata().getName());
            }
            return false;
        }
        for (Action action : rule.getActions()) {
            result &= ParserHelper.resolveActionType(definitionsService, action);
        }
        return result;
    }

    public static boolean resolveActionType(DefinitionsService definitionsService, Action action) {
        if (definitionsService == null) {
            return false;
        }
        if (action.getActionType() == null) {
            ActionType actionType = definitionsService.getActionType(action.getActionTypeId());
            if (actionType != null) {
                unresolvedActionTypes.remove(action.getActionTypeId());
                action.setActionType(actionType);
            } else {
                if (!unresolvedActionTypes.contains(action.getActionTypeId())) {
                    logger.warn("Couldn't resolve action type : " + action.getActionTypeId());
                    unresolvedActionTypes.add(action.getActionTypeId());
                }
                return false;
            }
        }
        return true;
    }

    public static void resolveValueType(DefinitionsService definitionsService, PropertyType propertyType) {
        ValueType valueType;
        if (propertyType.getValueType() == null && (valueType = definitionsService.getValueType(propertyType.getValueTypeId())) != null) {
            propertyType.setValueType(valueType);
        }
    }

    public static Set<String> resolveConditionEventTypes(Condition rootCondition) {
        if (rootCondition == null) {
            return new HashSet<String>();
        }
        EventTypeConditionVisitor eventTypeConditionVisitor = new EventTypeConditionVisitor();
        ParserHelper.visitConditions(rootCondition, eventTypeConditionVisitor);
        return eventTypeConditionVisitor.getEventTypeIds();
    }

    /*
     * Unable to fully structure code
     */
    public static Map<String, Object> parseMap(Event event, Map<String, Object> map, Map<String, ValueExtractor> valueExtractors) {
        values = new HashMap<String, Object>();
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            value = entry.getValue();
            if (value instanceof String) {
                s = (String)value;
                try {
                    if (s.contains("${")) {
                        while (s.contains("${") && (v = ParserHelper.extractValue(substring = s.substring(s.indexOf("${") + 2, s.indexOf("}")), event, valueExtractors)) != null) {
                            s = s.replace("${" + substring + "}", v.toString());
                        }
                        value = s;
                    }
                    if (!s.contains("::")) ** GOTO lbl22
                    value = ParserHelper.extractValue(s, event, valueExtractors);
                }
                catch (UnsupportedOperationException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new UnsupportedOperationException(e);
                }
            } else if (value instanceof Map) {
                value = ParserHelper.parseMap(event, value, valueExtractors);
            }
lbl22:
            // 6 sources

            values.put(entry.getKey(), value);
        }
        return values;
    }

    public static Object extractValue(String s, Event event, Map<String, ValueExtractor> valueExtractors) throws IllegalAccessException, NoSuchMethodException, InvocationTargetException {
        Object value = null;
        String valueType = StringUtils.substringBefore((String)s, (String)VALUE_NAME_SEPARATOR);
        String valueAsString = StringUtils.substringAfter((String)s, (String)VALUE_NAME_SEPARATOR);
        ValueExtractor extractor = valueExtractors.get(valueType);
        if (extractor != null) {
            value = extractor.extract(valueAsString, event);
        }
        return value;
    }

    public static boolean hasContextualParameter(Map<String, Object> values, Map<String, ValueExtractor> valueExtractors) {
        for (Map.Entry<String, Object> entry : values.entrySet()) {
            String s;
            String str;
            Object value = entry.getValue();
            if (!(value instanceof String ? (str = (s = (String)value).contains(PLACEHOLDER_PREFIX) ? s.substring(s.indexOf(PLACEHOLDER_PREFIX) + 2, s.indexOf(PLACEHOLDER_SUFFIX)) : s).contains(VALUE_NAME_SEPARATOR) && valueExtractors.containsKey(StringUtils.substringBefore((String)str, (String)VALUE_NAME_SEPARATOR)) : value instanceof Map && ParserHelper.hasContextualParameter((Map)value, valueExtractors))) continue;
            return true;
        }
        return false;
    }

    static {
        DEFAULT_VALUE_EXTRACTORS.put("profileProperty", (valueAsString, event) -> PropertyUtils.getProperty((Object)event.getProfile(), (String)("properties." + valueAsString)));
        DEFAULT_VALUE_EXTRACTORS.put("simpleProfileProperty", (valueAsString, event) -> event.getProfile().getProperty(valueAsString));
        DEFAULT_VALUE_EXTRACTORS.put("sessionProperty", (valueAsString, event) -> PropertyUtils.getProperty((Object)event.getSession(), (String)("properties." + valueAsString)));
        DEFAULT_VALUE_EXTRACTORS.put("simpleSessionProperty", (valueAsString, event) -> event.getSession().getProperty(valueAsString));
        DEFAULT_VALUE_EXTRACTORS.put("eventProperty", (valueAsString, event) -> PropertyUtils.getProperty((Object)event, (String)valueAsString));
        DEFAULT_VALUE_EXTRACTORS.put("simpleEventProperty", (valueAsString, event) -> event.getProperty(valueAsString));
    }

    public static class EventTypeConditionVisitor
    implements ConditionVisitor {
        private Set<String> eventTypeIds = new HashSet<String>();
        private Stack<String> conditionTypeStack = new Stack();

        @Override
        public void visit(Condition condition) {
            this.conditionTypeStack.push(condition.getConditionTypeId());
            if ("eventTypeCondition".equals(condition.getConditionTypeId())) {
                String eventTypeId = (String)condition.getParameter("eventTypeId");
                if (eventTypeId == null) {
                    logger.warn("Null eventTypeId found!");
                } else if (this.conditionTypeStack.contains("notCondition")) {
                    logger.warn("Found complex negative event type condition, will always evaluate rule");
                    this.eventTypeIds.add("*");
                } else {
                    this.eventTypeIds.add(eventTypeId);
                }
            } else if (condition.getConditionType() != null && condition.getConditionType().getParentCondition() != null) {
                ParserHelper.visitConditions(condition.getConditionType().getParentCondition(), this);
            }
        }

        @Override
        public void postVisit(Condition condition) {
            this.conditionTypeStack.pop();
        }

        public Set<String> getEventTypeIds() {
            return this.eventTypeIds;
        }
    }

    public static interface ValueExtractor {
        public Object extract(String var1, Event var2) throws IllegalAccessException, NoSuchMethodException, InvocationTargetException;
    }

    public static interface ConditionVisitor {
        public void visit(Condition var1);

        public void postVisit(Condition var1);
    }
}

