/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.extender.whiteboard.internal;

import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.ops4j.pax.web.extender.whiteboard.internal.util.WebContainerUtils;
import org.ops4j.pax.web.extender.whiteboard.internal.util.tracker.ReplaceableService;
import org.ops4j.pax.web.extender.whiteboard.internal.util.tracker.ReplaceableServiceListener;
import org.ops4j.pax.web.service.WebContainer;
import org.ops4j.pax.web.service.whiteboard.WhiteboardElement;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.http.HttpService;
import org.osgi.service.http.runtime.HttpServiceRuntime;
import org.osgi.service.http.runtime.dto.RequestInfoDTO;
import org.osgi.service.http.runtime.dto.RuntimeDTO;

public class ExtendedHttpServiceRuntime
implements HttpServiceRuntime,
ReplaceableServiceListener<HttpService> {
    private final BundleContext bundleContext;
    private Set<WhiteboardElement> whiteboardElements = ConcurrentHashMap.newKeySet();
    private ReplaceableService<HttpService> httpServiceTracker;
    private final ReadWriteLock httpServiceLock;
    private volatile WebContainer webContainer;
    private ServiceRegistration<HttpServiceRuntime> serviceRuntimeService;

    ExtendedHttpServiceRuntime(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
        this.httpServiceLock = new ReentrantReadWriteLock();
        this.httpServiceTracker = new ReplaceableService<HttpService>(bundleContext, HttpService.class, this, true);
    }

    public RuntimeDTO getRuntimeDTO() {
        return this.webContainer.createWhiteboardRuntimeDTO(this.whiteboardElements.iterator());
    }

    public RequestInfoDTO calculateRequestInfoDTO(String path) {
        return this.webContainer.calculateRequestInfoDTO(path, this.whiteboardElements.iterator());
    }

    public void addWhiteboardElement(WhiteboardElement element) {
        this.whiteboardElements.add(element);
    }

    public void removeWhiteboardElement(WhiteboardElement element) {
        this.whiteboardElements.remove(element);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void serviceChanged(HttpService oldService, HttpService newService, Map<String, Object> serviceProperties) {
        if (newService != null && !WebContainerUtils.isWebContainer(newService)) {
            throw new IllegalStateException("HttpService must be implementing Pax-Web WebContainer!");
        }
        this.httpServiceLock.writeLock().lock();
        try {
            this.unregisterService();
            this.webContainer = (WebContainer)newService;
            this.registerService((WebContainer)newService, serviceProperties);
        }
        finally {
            this.httpServiceLock.writeLock().unlock();
        }
    }

    private void registerService(WebContainer newService, Map<String, Object> serviceProperties) {
        if (newService == null) {
            return;
        }
        Hashtable<String, Object> props = new Hashtable<String, Object>();
        Long id = (Long)serviceProperties.get("service.id");
        String endpointString = "";
        if (newService.getWebcontainerDTO().listeningAddresses != null && newService.getWebcontainerDTO().listeningAddresses.length > 0) {
            endpointString = newService.getWebcontainerDTO().listeningAddresses[0] + ":";
        }
        endpointString = endpointString + newService.getWebcontainerDTO().port;
        ArrayList<Long> idList = new ArrayList<Long>();
        idList.add(id);
        ((Dictionary)props).put("osgi.http.endpoint", endpointString);
        ((Dictionary)props).put("osgi.http.service.id", idList);
        this.serviceRuntimeService = this.bundleContext.registerService(HttpServiceRuntime.class, (Object)this, props);
    }

    private void unregisterService() {
        if (this.serviceRuntimeService != null) {
            this.serviceRuntimeService.unregister();
            this.serviceRuntimeService = null;
        }
    }

    public void start() {
        this.httpServiceTracker.start();
    }

    public void stop() {
        this.unregisterService();
        this.httpServiceTracker.stop();
    }
}

