/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.plugins.baseplugin.actions;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.unomi.api.Event;
import org.apache.unomi.api.Item;
import org.apache.unomi.api.actions.Action;
import org.apache.unomi.api.actions.ActionExecutor;
import org.apache.unomi.api.services.EventService;
import org.apache.unomi.persistence.spi.PropertyHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SetPropertyAction
implements ActionExecutor {
    private static final Logger logger = LoggerFactory.getLogger((String)SetPropertyAction.class.getName());
    private EventService eventService;
    private static final AtomicLong nowDeprecatedLogTimestamp = new AtomicLong();
    private boolean useEventToUpdateProfile = false;

    public void setUseEventToUpdateProfile(boolean useEventToUpdateProfile) {
        this.useEventToUpdateProfile = useEventToUpdateProfile;
    }

    public int execute(Action action, Event event) {
        boolean storeInSession = Boolean.TRUE.equals(action.getParameterValues().get("storeInSession"));
        if (storeInSession && event.getSession() == null) {
            return 0;
        }
        String propertyName = (String)action.getParameterValues().get("setPropertyName");
        Object propertyValue = this.getPropertyValue(action, event);
        if (storeInSession) {
            if (PropertyHelper.setProperty((Object)event.getSession(), (String)propertyName, (Object)propertyValue, (String)((String)action.getParameterValues().get("setPropertyStrategy")))) {
                return 2;
            }
        } else if (this.useEventToUpdateProfile) {
            HashMap<String, Object> propertyToUpdate = new HashMap<String, Object>();
            propertyToUpdate.put(propertyName, propertyValue);
            Event updateProperties = new Event("updateProperties", event.getSession(), event.getProfile(), event.getScope(), null, (Item)event.getProfile(), new Date());
            updateProperties.setPersistent(false);
            updateProperties.setProperty("update", propertyToUpdate);
            int changes = this.eventService.send(updateProperties);
            if ((changes & 4) == 4) {
                return 4;
            }
        } else if (PropertyHelper.setProperty((Object)event.getProfile(), (String)propertyName, (Object)propertyValue, (String)((String)action.getParameterValues().get("setPropertyStrategy")))) {
            return 4;
        }
        return 0;
    }

    public void setEventService(EventService eventService) {
        this.eventService = eventService;
    }

    private Object getPropertyValue(Action action, Event event) {
        Object propertyValue = action.getParameterValues().get("setPropertyValue");
        if (propertyValue == null) {
            propertyValue = action.getParameterValues().get("setPropertyValueMultiple");
        }
        Object propertyValueInteger = action.getParameterValues().get("setPropertyValueInteger");
        Object setPropertyValueMultiple = action.getParameterValues().get("setPropertyValueMultiple");
        Object setPropertyValueBoolean = action.getParameterValues().get("setPropertyValueBoolean");
        Object setPropertyValueCurrentEventTimestamp = action.getParameterValues().get("setPropertyValueCurrentEventTimestamp");
        Object setPropertyValueCurrentDate = action.getParameterValues().get("setPropertyValueCurrentDate");
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        format.setTimeZone(TimeZone.getTimeZone("UTC"));
        if (propertyValue == null) {
            if (propertyValueInteger != null) {
                propertyValue = PropertyHelper.getInteger(propertyValueInteger);
            }
            if (setPropertyValueMultiple != null) {
                propertyValue = setPropertyValueMultiple;
            }
            if (setPropertyValueBoolean != null) {
                propertyValue = PropertyHelper.getBooleanValue(setPropertyValueBoolean);
            }
            if (setPropertyValueCurrentEventTimestamp != null && PropertyHelper.getBooleanValue(setPropertyValueCurrentEventTimestamp).booleanValue()) {
                propertyValue = format.format(event.getTimeStamp());
            }
            if (setPropertyValueCurrentDate != null && PropertyHelper.getBooleanValue(setPropertyValueCurrentDate).booleanValue()) {
                propertyValue = format.format(new Date());
            }
        }
        if (propertyValue != null && propertyValue.equals("now")) {
            long timeStamp = nowDeprecatedLogTimestamp.get();
            long currentTimeStamp = new Date().getTime();
            if (timeStamp == 0L || timeStamp + TimeUnit.HOURS.toMillis(6L) < currentTimeStamp) {
                logger.warn("SetPropertyAction with setPropertyValue: 'now' is deprecated, please use 'setPropertyValueCurrentEventTimestamp' or 'setPropertyValueCurrentDate' instead of 'setPropertyValue'");
                nowDeprecatedLogTimestamp.set(currentTimeStamp);
            }
            propertyValue = format.format(event.getTimeStamp());
        }
        return propertyValue;
    }
}

