/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.service.internal;

import java.util.concurrent.atomic.AtomicReference;
import org.ops4j.pax.web.service.spi.ServletEvent;
import org.ops4j.pax.web.service.spi.ServletListener;
import org.ops4j.pax.web.service.spi.WebEvent;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.log.LogService;
import org.osgi.util.tracker.ServiceTrackerCustomizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogServiceHandler
implements ServiceTrackerCustomizer<LogService, LogService>,
ServletListener {
    private static final Logger LOG = LoggerFactory.getLogger(LogServiceHandler.class);
    private AtomicReference<LogService> logServiceReference = new AtomicReference();
    private final BundleContext bundleContext;

    public LogServiceHandler(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    public void servletEvent(ServletEvent servletEvent) {
        String topic;
        switch (servletEvent.getType()) {
            case 1: {
                topic = WebEvent.WebTopic.DEPLOYING.toString();
                break;
            }
            case 2: {
                topic = WebEvent.WebTopic.DEPLOYED.toString();
                break;
            }
            case 3: {
                topic = WebEvent.WebTopic.UNDEPLOYING.toString();
                break;
            }
            case 4: {
                topic = WebEvent.WebTopic.UNDEPLOYED.toString();
                break;
            }
            default: {
                topic = WebEvent.WebTopic.FAILED.toString();
            }
        }
        LogService logService = this.logServiceReference.get();
        if (logService != null) {
            logService.log(4, topic);
        } else {
            LOG.debug(topic);
        }
    }

    public LogService addingService(ServiceReference<LogService> reference) {
        if (reference.isAssignableTo(this.bundleContext.getBundle(), "org.osgi.service.log.LogService")) {
            LogService logService = (LogService)this.bundleContext.getService(reference);
            try {
                if (logService instanceof LogService) {
                    LogService old = this.logServiceReference.getAndSet(logService);
                    if (old != null) {
                        LOG.debug("replace old LogService instance {} by an instance of {}", (Object)old.getClass().getName(), (Object)logService.getClass().getName());
                    }
                    return logService;
                }
            }
            catch (NoClassDefFoundError e) {
                LOG.warn("A LogService service was found, but the coresponding class can't be loaded, make sure to have a compatible org.osgi.service.log package package exported with version range [1.3,2.0)");
            }
            this.bundleContext.ungetService(reference);
        } else {
            LOG.warn("A LogService service was found, but it is not assignable to this bundle, make sure to have a compatible org.osgi.service.log package package exported with version range [1.3,2.0)");
        }
        return null;
    }

    public void modifiedService(ServiceReference<LogService> reference, LogService service) {
    }

    public void removedService(ServiceReference<LogService> reference, LogService service) {
        this.bundleContext.ungetService(reference);
        try {
            if (service instanceof LogService) {
                this.logServiceReference.compareAndSet(service, null);
            }
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
    }
}

