/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.services.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import org.apache.unomi.api.PropertyType;
import org.apache.unomi.api.ValueType;
import org.apache.unomi.api.actions.Action;
import org.apache.unomi.api.actions.ActionType;
import org.apache.unomi.api.conditions.Condition;
import org.apache.unomi.api.conditions.ConditionType;
import org.apache.unomi.api.rules.Rule;
import org.apache.unomi.api.services.DefinitionsService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParserHelper {
    private static final Logger logger = LoggerFactory.getLogger(ParserHelper.class);
    private static final Set<String> unresolvedActionTypes = new HashSet<String>();
    private static final Set<String> unresolvedConditionTypes = new HashSet<String>();

    public static boolean resolveConditionType(final DefinitionsService definitionsService, Condition rootCondition, final String contextObjectName) {
        if (rootCondition == null) {
            logger.warn("Couldn't resolve null condition for {}", (Object)contextObjectName);
            return false;
        }
        final ArrayList result = new ArrayList();
        ParserHelper.visitConditions(rootCondition, new ConditionVisitor(){

            @Override
            public void visit(Condition condition) {
                if (condition.getConditionType() == null) {
                    ConditionType conditionType = definitionsService.getConditionType(condition.getConditionTypeId());
                    if (conditionType != null) {
                        unresolvedConditionTypes.remove(condition.getConditionTypeId());
                        condition.setConditionType(conditionType);
                    } else {
                        result.add(condition.getConditionTypeId());
                        if (!unresolvedConditionTypes.contains(condition.getConditionTypeId())) {
                            unresolvedConditionTypes.add(condition.getConditionTypeId());
                            logger.warn("Couldn't resolve condition type: {} for {}", (Object)condition.getConditionTypeId(), (Object)contextObjectName);
                        }
                    }
                }
            }

            @Override
            public void postVisit(Condition condition) {
            }
        });
        return result.isEmpty();
    }

    public static List<String> getConditionTypeIds(Condition rootCondition) {
        final ArrayList<String> result = new ArrayList<String>();
        ParserHelper.visitConditions(rootCondition, new ConditionVisitor(){

            @Override
            public void visit(Condition condition) {
                result.add(condition.getConditionTypeId());
            }

            @Override
            public void postVisit(Condition condition) {
            }
        });
        return result;
    }

    private static void visitConditions(Condition rootCondition, ConditionVisitor visitor) {
        visitor.visit(rootCondition);
        for (Object parameterValue : rootCondition.getParameterValues().values()) {
            if (parameterValue instanceof Condition) {
                Condition parameterValueCondition = (Condition)parameterValue;
                ParserHelper.visitConditions(parameterValueCondition, visitor);
                continue;
            }
            if (!(parameterValue instanceof Collection)) continue;
            Collection valueList = (Collection)parameterValue;
            for (Object value : valueList) {
                if (!(value instanceof Condition)) continue;
                Condition valueCondition = (Condition)value;
                ParserHelper.visitConditions(valueCondition, visitor);
            }
        }
        visitor.postVisit(rootCondition);
    }

    public static boolean resolveActionTypes(DefinitionsService definitionsService, Rule rule, boolean ignoreErrors) {
        boolean result = true;
        if (rule.getActions() == null) {
            if (!ignoreErrors) {
                logger.warn("Rule {}:{} has null actions", (Object)rule.getItemId(), (Object)rule.getMetadata().getName());
            }
            return false;
        }
        if (rule.getActions().isEmpty()) {
            if (!ignoreErrors) {
                logger.warn("Rule {}:{} has empty actions", (Object)rule.getItemId(), (Object)rule.getMetadata().getName());
            }
            return false;
        }
        for (Action action : rule.getActions()) {
            result &= ParserHelper.resolveActionType(definitionsService, action);
        }
        return result;
    }

    public static boolean resolveActionType(DefinitionsService definitionsService, Action action) {
        if (definitionsService == null) {
            return false;
        }
        if (action.getActionType() == null) {
            ActionType actionType = definitionsService.getActionType(action.getActionTypeId());
            if (actionType != null) {
                unresolvedActionTypes.remove(action.getActionTypeId());
                action.setActionType(actionType);
            } else {
                if (!unresolvedActionTypes.contains(action.getActionTypeId())) {
                    logger.warn("Couldn't resolve action type : " + action.getActionTypeId());
                    unresolvedActionTypes.add(action.getActionTypeId());
                }
                return false;
            }
        }
        return true;
    }

    public static void resolveValueType(DefinitionsService definitionsService, PropertyType propertyType) {
        ValueType valueType;
        if (propertyType.getValueType() == null && (valueType = definitionsService.getValueType(propertyType.getValueTypeId())) != null) {
            propertyType.setValueType(valueType);
        }
    }

    public static Set<String> resolveConditionEventTypes(Condition rootCondition) {
        if (rootCondition == null) {
            return new HashSet<String>();
        }
        EventTypeConditionVisitor eventTypeConditionVisitor = new EventTypeConditionVisitor();
        ParserHelper.visitConditions(rootCondition, eventTypeConditionVisitor);
        return eventTypeConditionVisitor.getEventTypeIds();
    }

    static class EventTypeConditionVisitor
    implements ConditionVisitor {
        private Set<String> eventTypeIds = new HashSet<String>();
        private Stack<String> conditionTypeStack = new Stack();

        EventTypeConditionVisitor() {
        }

        @Override
        public void visit(Condition condition) {
            this.conditionTypeStack.push(condition.getConditionTypeId());
            if ("eventTypeCondition".equals(condition.getConditionTypeId())) {
                String eventTypeId = (String)condition.getParameter("eventTypeId");
                if (eventTypeId == null) {
                    logger.warn("Null eventTypeId found!");
                } else if (this.conditionTypeStack.contains("notCondition")) {
                    logger.warn("Found complex negative event type condition, will always evaluate rule");
                    this.eventTypeIds.add("*");
                } else {
                    this.eventTypeIds.add(eventTypeId);
                }
            } else if (condition.getConditionType().getParentCondition() != null) {
                ParserHelper.visitConditions(condition.getConditionType().getParentCondition(), this);
            }
        }

        @Override
        public void postVisit(Condition condition) {
            this.conditionTypeStack.pop();
        }

        public Set<String> getEventTypeIds() {
            return this.eventTypeIds;
        }
    }

    static interface ConditionVisitor {
        public void visit(Condition var1);

        public void postVisit(Condition var1);
    }
}

