/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.persistence.elasticsearch.conditions;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.unomi.api.Item;
import org.apache.unomi.api.conditions.Condition;
import org.apache.unomi.metrics.MetricAdapter;
import org.apache.unomi.metrics.MetricsService;
import org.apache.unomi.persistence.elasticsearch.conditions.ConditionContextHelper;
import org.apache.unomi.persistence.elasticsearch.conditions.ConditionEvaluator;
import org.apache.unomi.scripting.ScriptExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConditionEvaluatorDispatcher {
    private static final Logger logger = LoggerFactory.getLogger((String)ConditionEvaluatorDispatcher.class.getName());
    private Map<String, ConditionEvaluator> evaluators = new ConcurrentHashMap<String, ConditionEvaluator>();
    private MetricsService metricsService;
    private ScriptExecutor scriptExecutor;

    public void setMetricsService(MetricsService metricsService) {
        this.metricsService = metricsService;
    }

    public void setScriptExecutor(ScriptExecutor scriptExecutor) {
        this.scriptExecutor = scriptExecutor;
    }

    public void addEvaluator(String name, ConditionEvaluator evaluator) {
        this.evaluators.put(name, evaluator);
    }

    public void removeEvaluator(String name) {
        this.evaluators.remove(name);
    }

    public boolean eval(Condition condition, Item item) {
        return this.eval(condition, item, new HashMap<String, Object>());
    }

    public boolean eval(final Condition condition, final Item item, final Map<String, Object> context) {
        String conditionEvaluatorKey = condition.getConditionType().getConditionEvaluator();
        if (condition.getConditionType().getParentCondition() != null) {
            context.putAll(condition.getParameterValues());
            return this.eval(condition.getConditionType().getParentCondition(), item, context);
        }
        if (conditionEvaluatorKey == null) {
            throw new UnsupportedOperationException("No evaluator defined for : " + condition.getConditionTypeId());
        }
        if (this.evaluators.containsKey(conditionEvaluatorKey)) {
            final ConditionEvaluator evaluator = this.evaluators.get(conditionEvaluatorKey);
            final ConditionEvaluatorDispatcher dispatcher = this;
            try {
                return (Boolean)new MetricAdapter<Boolean>(this.metricsService, this.getClass().getName() + ".conditions." + conditionEvaluatorKey){

                    public Boolean execute(Object ... args) throws Exception {
                        Condition contextualCondition = ConditionContextHelper.getContextualCondition(condition, context, ConditionEvaluatorDispatcher.this.scriptExecutor);
                        if (contextualCondition != null) {
                            return evaluator.eval(contextualCondition, item, context, dispatcher);
                        }
                        return true;
                    }
                }.runWithTimer(new Object[0]);
            }
            catch (Exception e) {
                logger.error("Error executing condition evaluator with key=" + conditionEvaluatorKey, (Throwable)e);
            }
        }
        return false;
    }
}

