/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.blueprint.proxy;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.List;
import org.apache.aries.blueprint.Interceptor;
import org.apache.aries.proxy.InvocationListener;
import org.osgi.service.blueprint.reflect.ComponentMetadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Collaborator
implements InvocationListener,
Serializable {
    private static final long serialVersionUID = -58189302118314469L;
    private static final Logger LOGGER = LoggerFactory.getLogger(Collaborator.class);
    private transient List<Interceptor> interceptors = null;
    private transient ComponentMetadata cm = null;

    public Collaborator(ComponentMetadata cm, List<Interceptor> interceptors) {
        this.cm = cm;
        this.interceptors = interceptors;
    }

    public Object preInvoke(Object o, Method m, Object[] parameters) throws Throwable {
        ArrayDeque<StackElement> stack = new ArrayDeque<StackElement>(this.interceptors.size());
        if (this.interceptors != null) {
            try {
                for (Interceptor im : this.interceptors) {
                    StackElement se = new StackElement(im);
                    stack.push(se);
                    se.setPreCallToken(im.preCall(this.cm, m, parameters));
                }
            }
            catch (Throwable t) {
                this.postInvokeExceptionalReturn(stack, o, m, t);
                throw t;
            }
        }
        return stack;
    }

    public void postInvoke(Object token, Object o, Method method, Object returnType) throws Throwable {
        Deque calledInterceptors = (Deque)token;
        if (calledInterceptors != null) {
            while (!calledInterceptors.isEmpty()) {
                StackElement se = (StackElement)calledInterceptors.pop();
                try {
                    se.interceptor.postCallWithReturn(this.cm, method, returnType, se.getPreCallToken());
                }
                catch (Throwable t) {
                    LOGGER.debug("postCallInterceptorWithReturn", t);
                    throw t;
                }
            }
        }
    }

    public void postInvokeExceptionalReturn(Object token, Object o, Method method, Throwable exception) throws Throwable {
        Throwable tobeRethrown = null;
        Deque calledInterceptors = (Deque)token;
        while (!calledInterceptors.isEmpty()) {
            StackElement se = (StackElement)calledInterceptors.pop();
            try {
                se.interceptor.postCallWithException(this.cm, method, exception, se.getPreCallToken());
            }
            catch (Throwable t) {
                LOGGER.debug("postCallInterceptorWithException", t);
                if (tobeRethrown == null) {
                    tobeRethrown = t;
                    continue;
                }
                LOGGER.warn("Discarding post-call with interceptor exception", t);
            }
        }
        if (tobeRethrown != null) {
            throw tobeRethrown;
        }
    }

    private static class StackElement {
        private final Interceptor interceptor;
        private Object preCallToken;

        private StackElement(Interceptor i) {
            this.interceptor = i;
        }

        private void setPreCallToken(Object preCallToken) {
            this.preCallToken = preCallToken;
        }

        private Object getPreCallToken() {
            return this.preCallToken;
        }
    }
}

