/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.plugins.baseplugin.actions;

import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.unomi.api.CustomItem;
import org.apache.unomi.api.Event;
import org.apache.unomi.api.Profile;
import org.apache.unomi.api.Session;
import org.apache.unomi.api.actions.Action;
import org.apache.unomi.api.actions.ActionExecutor;
import org.apache.unomi.persistence.spi.PropertyHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IncrementPropertyAction
implements ActionExecutor {
    private static final Logger logger = LoggerFactory.getLogger((String)IncrementPropertyAction.class.getName());

    public int execute(Action action, Event event) {
        block6: {
            boolean storeInSession = Boolean.TRUE.equals(action.getParameterValues().get("storeInSession"));
            if (storeInSession && event.getSession() == null) {
                return 0;
            }
            String propertyName = (String)action.getParameterValues().get("propertyName");
            Profile profile = event.getProfile();
            Session session = event.getSession();
            try {
                Map properties = storeInSession ? session.getProperties() : profile.getProperties();
                Object propertyValue = this.getPropertyValue(action, event, propertyName, properties);
                if (PropertyHelper.setProperty((Object)properties, (String)propertyName, (Object)propertyValue, (String)"alwaysSet")) {
                    return storeInSession ? 2 : 4;
                }
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                logger.warn("Error resolving nested property of object. See debug log level for more information");
                if (logger.isDebugEnabled()) {
                    logger.debug("Error resolving nested property of item: {}", storeInSession ? session : profile, (Object)e);
                }
            }
            catch (IllegalStateException ee) {
                logger.warn("Error increment existing property, because existing property doesn't have expected type. See debug log level for more information");
                if (!logger.isDebugEnabled()) break block6;
                logger.debug(ee.getMessage(), (Throwable)ee);
            }
        }
        return 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Object getPropertyValue(Action action, Event event, String propertyName, Map<String, Object> properties) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        String propertyTarget = (String)action.getParameterValues().get("propertyTarget");
        String rootPropertyName = propertyName.split("\\.")[0];
        Integer propertyValue = 1;
        Object propertyTargetValue = null;
        if (StringUtils.isNotEmpty((CharSequence)propertyTarget)) {
            propertyTargetValue = PropertyUtils.getNestedProperty((Object)((CustomItem)event.getTarget()).getProperties(), (String)propertyTarget);
        }
        if (propertyTargetValue != null) {
            if (propertyTargetValue instanceof Integer) {
                if (!properties.containsKey(rootPropertyName)) return propertyTargetValue;
                Object nestedProperty = PropertyUtils.getNestedProperty(properties, (String)propertyName);
                if (nestedProperty == null) {
                    return propertyTargetValue;
                }
                if (!(nestedProperty instanceof Integer)) throw new IllegalStateException("Property: " + propertyName + " already exist, can not increment the property because the exiting property is not integer");
                return (Integer)propertyTargetValue + (Integer)nestedProperty;
            }
            if (!(propertyTargetValue instanceof Map)) return propertyValue;
            if (!properties.containsKey(rootPropertyName)) return propertyTargetValue;
            Object nestedPropertyValue = PropertyUtils.getNestedProperty(properties, (String)propertyName);
            if (nestedPropertyValue == null) {
                return propertyTargetValue;
            }
            if (!(nestedPropertyValue instanceof Map)) throw new IllegalStateException("Property: " + propertyName + " already exist, can not increment the properties from the map because the exiting property is not map");
            Map nestedProperty = (Map)nestedPropertyValue;
            ((Map)propertyTargetValue).forEach((key, targetValue) -> {
                if (targetValue instanceof Integer && nestedProperty.containsKey(key) && nestedProperty.get(key) instanceof Integer || targetValue instanceof Integer && !nestedProperty.containsKey(key)) {
                    nestedProperty.put(key, nestedProperty.containsKey(key) ? Integer.valueOf((Integer)nestedProperty.get(key) + (Integer)targetValue) : targetValue);
                }
            });
            return nestedProperty;
        }
        if (!properties.containsKey(rootPropertyName)) return propertyValue;
        Object nestedProperty = PropertyUtils.getNestedProperty(properties, (String)propertyName);
        if (nestedProperty == null) {
            return 1;
        }
        if (nestedProperty instanceof Integer) {
            return (Integer)nestedProperty + 1;
        }
        if (!(nestedProperty instanceof Map)) throw new IllegalStateException("Property: " + propertyName + " already exist, can not increment the property because the exiting property is not integer or map");
        ((Map)nestedProperty).forEach((key, propValue) -> {
            if (propValue instanceof Integer) {
                ((Map)nestedProperty).merge(key, 1, Integer::sum);
            }
        });
        return nestedProperty;
    }
}

