/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.spi.impl.discovery;

import com.hazelcast.client.connection.AddressTranslator;
import com.hazelcast.client.spi.impl.discovery.HazelcastCloudDiscovery;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.LoggingService;
import com.hazelcast.nio.Address;
import java.util.HashMap;
import java.util.Map;

public class HazelcastCloudAddressTranslator
implements AddressTranslator {
    private final ILogger logger;
    private final HazelcastCloudDiscovery hazelcastCloudDiscovery;
    private volatile Map<Address, Address> privateToPublic = new HashMap<Address, Address>();

    public HazelcastCloudAddressTranslator(String endpointUrl, int connectionTimeoutMillis, LoggingService loggingService) {
        this(new HazelcastCloudDiscovery(endpointUrl, connectionTimeoutMillis), loggingService);
    }

    HazelcastCloudAddressTranslator(HazelcastCloudDiscovery hazelcastCloudDiscovery, LoggingService loggingService) {
        this.hazelcastCloudDiscovery = hazelcastCloudDiscovery;
        this.logger = loggingService.getLogger(HazelcastCloudAddressTranslator.class);
    }

    @Override
    public Address translate(Address address) {
        if (address == null) {
            return null;
        }
        Address publicAddress = this.privateToPublic.get(address);
        if (publicAddress != null) {
            return publicAddress;
        }
        this.refresh();
        publicAddress = this.privateToPublic.get(address);
        if (publicAddress != null) {
            return publicAddress;
        }
        return null;
    }

    @Override
    public void refresh() {
        try {
            this.privateToPublic = this.hazelcastCloudDiscovery.discoverNodes();
        }
        catch (Exception e) {
            this.logger.warning("Failed to load addresses from hazelcast.cloud : " + e.getMessage());
        }
    }

    Map<Address, Address> getLookupTable() {
        return this.privateToPublic;
    }
}

