/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.collection.impl.cpm;

import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputFilter;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.List;
import java.util.Set;
import org.apache.uima.UIMAFramework;
import org.apache.uima.collection.base_cpm.SynchPoint;
import org.apache.uima.collection.impl.cpm.BaseCPMImpl;
import org.apache.uima.collection.impl.cpm.CheckpointData;
import org.apache.uima.util.Level;
import org.apache.uima.util.ProcessTrace;
import org.apache.uima.util.ProcessTraceEvent;
import org.apache.uima.util.impl.ProcessTrace_impl;

public class Checkpoint
implements Runnable {
    static final String PROP_CPE_CHECKPOINT_SERIAL_FILTER = "uima.cpe.checkpoint.serial_filter";
    private final String fileName;
    private volatile boolean stop = false;
    private final long checkpointFrequency;
    private boolean pause = false;
    private final Object lockForPause = new Object();
    private final BaseCPMImpl cpm;
    private final String synchPointFileName;

    public Checkpoint(BaseCPMImpl aCpm, String aFilename, long aCheckpointFrequency) {
        this.fileName = aFilename;
        int fExtPos = this.fileName.indexOf(46);
        this.synchPointFileName = fExtPos > -1 ? this.fileName.substring(0, fExtPos) + "_synchPoint.xml" : null;
        this.cpm = aCpm;
        this.checkpointFrequency = aCheckpointFrequency;
    }

    public void stop() {
        this.stop = true;
        if (UIMAFramework.getLogger().isInfoEnabled()) {
            UIMAFramework.getLogger(this.getClass()).logrb(Level.INFO, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_stop_checkpoint_thread__INFO", new Object[]{Thread.currentThread().getName()});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Thread.currentThread().setName("CPM Checkpoint");
        while (!this.stop) {
            Object object = this.lockForPause;
            synchronized (object) {
                if (this.pause) {
                    try {
                        this.lockForPause.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
            if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
                UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_checkpoint__FINEST", new Object[]{Thread.currentThread().getName()});
            }
            this.doCheckpoint();
            try {
                if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
                    UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_sleep__FINEST", new Object[]{Thread.currentThread().getName()});
                }
                Thread.sleep(this.checkpointFrequency);
                if (!UIMAFramework.getLogger().isLoggable(Level.FINEST)) continue;
                UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_wakeup__FINEST", new Object[]{Thread.currentThread().getName()});
            }
            catch (Exception exception) {}
        }
    }

    public void delete() {
        try {
            File checkpointFile = new File(this.fileName);
            checkpointFile.delete();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pause() {
        Object object = this.lockForPause;
        synchronized (object) {
            this.pause = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resume() {
        Object object = this.lockForPause;
        synchronized (object) {
            if (this.pause) {
                this.lockForPause.notifyAll();
                this.pause = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doCheckpoint() {
        block23: {
            try {
                if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
                    UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_checkpoint__FINEST", new Object[]{Thread.currentThread().getName()});
                }
                this.rename(this.fileName);
                this.rename(this.synchPointFileName);
                ObjectOutputStream s = null;
                try (FileOutputStream out = new FileOutputStream(this.fileName);
                     FileOutputStream synchPointOut = new FileOutputStream(this.synchPointFileName);){
                    s = new ObjectOutputStream(out);
                    SynchPoint synchPoint = this.cpm.getSynchPoint();
                    ProcessTrace pTrace = this.cpm.getPerformanceReport();
                    CheckpointData targetToSave = null;
                    if (pTrace == null) break block23;
                    if (synchPoint != null) {
                        if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
                            UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_checkpoint_with_synchpoint__FINEST", new Object[]{Thread.currentThread().getName()});
                        }
                        targetToSave = new CheckpointData(pTrace, synchPoint);
                    } else {
                        if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
                            UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_checkpoint_with_pt__FINEST", new Object[]{Thread.currentThread().getName()});
                        }
                        targetToSave = new CheckpointData(pTrace);
                    }
                    CheckpointData checkpointData = targetToSave;
                    synchronized (checkpointData) {
                        s.writeObject(targetToSave);
                        s.flush();
                        if (synchPoint != null) {
                            String xmlSynchPoint = synchPoint.serializeToXML();
                            synchPointOut.write(xmlSynchPoint.getBytes());
                            synchPointOut.flush();
                        }
                    }
                }
                catch (Exception e) {
                    UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_exception_when_checkpointing__FINEST", new Object[]{Thread.currentThread().getName(), e.getMessage()});
                }
            }
            catch (Exception e) {
                UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_exception_when_checkpointing__FINEST", new Object[]{Thread.currentThread().getName(), e.getMessage()});
            }
        }
    }

    public void rename(String aFilename) {
        File currentFile = new File(aFilename);
        File backupFile = new File(aFilename + ".prev");
        currentFile.renameTo(backupFile);
    }

    public static void printStats(ProcessTrace prT) {
        if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
            UIMAFramework.getLogger(Checkpoint.class).log(Level.FINEST, "\n\t\t\t----------------------------------------");
            UIMAFramework.getLogger(Checkpoint.class).log(Level.FINEST, "\t\t\t\t PERFORMANCE REPORT ");
            UIMAFramework.getLogger(Checkpoint.class).log(Level.FINEST, "\t\t\t----------------------------------------\n");
        }
        List eveList = prT.getEvents();
        Checkpoint.printEveList(eveList, 0);
        if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
            UIMAFramework.getLogger(Checkpoint.class).log(Level.FINEST, "_________________________________________________________________\n");
        }
    }

    public static void printEveList(List<ProcessTraceEvent> lst, int tCnt) {
        Object tabS = "";
        int tabCnt = tCnt;
        for (int j = 0; j < tabCnt; ++j) {
            tabS = (String)tabS + "\t";
        }
        for (int i = 0; i < lst.size(); ++i) {
            ProcessTraceEvent prEvent = lst.get(i);
            String compNameS = prEvent.getComponentName();
            String typeS = prEvent.getType();
            int dur = prEvent.getDurationExcludingSubEvents();
            int totDur = prEvent.getDuration();
            List subEveList = prEvent.getSubEvents();
            if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
                UIMAFramework.getLogger(Checkpoint.class).log(Level.FINEST, (String)tabS + "COMPONENT : " + compNameS + "\tTYPE : " + typeS + "\tDescription : " + prEvent.getDescription());
                UIMAFramework.getLogger(Checkpoint.class).log(Level.FINEST, (String)tabS + "TOTAL_TIME : " + totDur + "\tTIME_EXCLUDING_SUBEVENTS : " + dur);
            }
            if (subEveList != null) {
                Checkpoint.printEveList(subEveList, tabCnt + 1);
            }
            if (!UIMAFramework.getLogger().isLoggable(Level.FINEST)) continue;
            UIMAFramework.getLogger(Checkpoint.class).log(Level.FINEST, " ");
        }
    }

    public boolean exists() {
        try {
            return new File(this.fileName).exists();
        }
        catch (Exception exception) {
            return false;
        }
    }

    public synchronized Object restoreFromCheckpoint() throws IOException {
        try {
            File file = new File(this.fileName);
            CheckpointData anObject = null;
            if (file.exists()) {
                if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
                    UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_restoring_from_checkpoint__FINEST", new Object[]{Thread.currentThread().getName()});
                }
                try (FileInputStream stream = new FileInputStream(file);){
                    anObject = Checkpoint.deserializeCheckpoint(stream);
                    if (anObject instanceof CheckpointData) {
                        ProcessTrace processTrace = anObject.getProcessTrace();
                        Checkpoint.printStats(processTrace);
                    }
                }
            }
            file = new File(this.synchPointFileName);
            SynchPoint synchPoint = null;
            if (file.exists()) {
                if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
                    UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_synchpoint_from_file__FINEST", new Object[]{Thread.currentThread().getName(), this.synchPointFileName});
                }
                try (FileInputStream synchPointStream = new FileInputStream(file);){
                    if (anObject instanceof CheckpointData && (synchPoint = anObject.getSynchPoint()) != null) {
                        synchPoint.deserialize((InputStream)synchPointStream);
                    }
                }
            }
            return anObject;
        }
        catch (EOFException file) {
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    static CheckpointData deserializeCheckpoint(InputStream stream) throws IOException, ClassNotFoundException {
        Set<Class<SynchPoint>> safeList = Set.of(CheckpointData.class, ProcessTrace.class, ProcessTrace_impl.class, SynchPoint.class);
        ObjectInputFilter filter = ObjectInputFilter.allowFilter(safeList::contains, ObjectInputFilter.Status.UNDECIDED);
        ObjectInputStream ois = new ObjectInputStream(stream);
        String serialFilterPropertyValue = System.getProperty(PROP_CPE_CHECKPOINT_SERIAL_FILTER);
        if (serialFilterPropertyValue != null) {
            ObjectInputFilter serialFilter = ObjectInputFilter.Config.createFilter(serialFilterPropertyValue);
            filter = ObjectInputFilter.merge(filter, serialFilter);
        }
        filter = ObjectInputFilter.rejectUndecidedClass(filter);
        ois.setObjectInputFilter(filter);
        return (CheckpointData)ois.readObject();
    }
}

