/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 * 
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package org.apache.uima.resource.impl;

import java.io.File;

import org.apache.uima.UIMAFramework;
import org.apache.uima.resource.ResourceCreationSpecifier;
import org.apache.uima.test.junit_extension.JUnitExtension;
import org.apache.uima.util.XMLInputSource;

import junit.framework.TestCase;


public class ResourceCreationSpecifier_implTest extends TestCase {
  public void testDoFullValidation() throws Exception {
    try {
      File descFile = JUnitExtension.getFile("UimaContextTest/CasConsumerForUimaContextTest.xml");
      ResourceCreationSpecifier resCreaSpec = (ResourceCreationSpecifier) UIMAFramework
              .getXMLParser().parseResourceSpecifier(new XMLInputSource(descFile));
      resCreaSpec.doFullValidation();
    } catch (Exception e) {
      JUnitExtension.handleException(e);
    }
  }
}
